/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;
import org.gnu.glib.Boxed;
public class AccelMap extends Boxed 
{
	
	private AccelMap(int handle) {
		this.handle = handle;
	}
	
	public static AccelMap getAccelMap() {
		return new AccelMap(gtk_accel_map_get());
	}
	
	/**
	 * Loads a file previously saved with the same method, parses the
	 * file for accelerator specifications, and propogates them accordingly.
	 * @param filename The name of the file to read.
	 */
	public static void load(String filename) {
		gtk_accel_map_load(filename);
	}
	
	/**
	 * Saves the current accelerator specification (accelerator path, key,
	 * and modifiers) to the filename specified.  
	 * @param filename The name of the file to write.
	 */
	public static void save(String filename) {
		gtk_accel_map_save(filename);
	}
	
	public static void lockPath(String path) {
		gtk_accel_map_lock_path(path);
	}
	
	public static void unlockPath(String path) {
		gtk_accel_map_unlock_path(path);
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
	native static final int gtk_accel_map_get();
    native static final protected void gtk_accel_map_add_entry (String accelPath, int accelKey, int 
        accelMods);
    native static final protected boolean gtk_accel_map_lookup_entry (String accelPath, int key);
    native static final protected boolean gtk_accel_map_change_entry (String accelPath, int 
        accekKey, int accelMods, boolean replace);
    native static final protected void gtk_accel_map_load (String fileName);
    native static final protected void gtk_accel_map_save (String fileName);
    native static final protected void gtk_accel_map_load_fd (int fd);
    native static final protected void gtk_accel_map_save_fd (int fd);
    native static final protected void gtk_accel_map_lock_path(String path);
    native static final protected void gtk_accel_map_unlock_path(String path);
    native static final protected void gtk_accel_map_add_filter (String filterPattern);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

