/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

import org.gnu.glib.GObject;

/**
 */
public class Screen extends GObject {
	
	public Screen() {
		if (-1 == handle) {
			handle = gdk_screen_get_default();
		}
	}
	
	public Screen(int handle) {
		this.handle = handle;
	}
	
	public Colormap getDefaultColormap() {
		return new Colormap(gdk_screen_get_default_colormap(handle));
	}
	
	public void setDefaultColormap(Colormap colormap) {
		gdk_screen_set_default_colormap(handle, colormap.getHandle());
	}
	
	public Colormap getSystemColormap() {
		return new Colormap(gdk_screen_get_system_colormap(handle));
	}
	
	public Visual gdtSystemVisual() {
		return new Visual(gdk_screen_get_system_visual(handle));
	}
	
	public Colormap getRGBColormap() {
		return new Colormap(gdk_screen_get_rgb_colormap(handle));
	}
	
	public Visual getRGBVisual() {
		return new Visual(gdk_screen_get_rgb_visual(handle));
	}
	
	public Window getRootWindow() {
		return new Window(gdk_screen_get_root_window(handle));
	}
	
	public Display getDisplay() {
		return new Display(gdk_screen_get_display(handle));
	}

	
	public int getNumber() {
		return gdk_screen_get_number(handle);
	}
	
	public int getHeight() {
		return gdk_screen_get_height(handle);
	}
	
	public int getWidth() {
		return gdk_screen_get_width(handle);
	}
	
	public int getHeightMM() {
		return gdk_screen_get_height_mm(handle);
	}
	
	public int getWidthMM() {
		return gdk_screen_get_width_mm(handle);
	}
	
	public Visual[] ListVisuals() {
		int[] hndls = gdk_screen_list_visuals(handle);
		Visual[] vis = new Visual[hndls.length];
		for (int i = 0; i < hndls.length; i++) {
			vis[i] = new Visual(hndls[i]);
		}
		return vis;
	}
	
	public Window[] getToplevelWindows() {
		int[] hndls = gdk_screen_get_toplevel_windows(handle);
		Window[] win = new Window[hndls.length];
		for (int i = 0; i < hndls.length; i++) {
			win[i] = new Window(hndls[i]);
		}
		return win;
	}

	public String makeDisplayName() {
		return gdk_screen_make_display_name(handle);
	}

	public int getNumMonitors() {
		return gdk_screen_get_n_monitors(handle);
	}
	
	public Rectangle getMonitorGeometry(int monitorNum) {
		int[] hndl = new int[1];
		gdk_screen_get_monitor_geometry(handle, monitorNum, hndl);
		return new Rectangle(hndl[0]);
	}
	
	public int getMonitorAtPoint(int x, int y) {
		return gdk_screen_get_monitor_at_point(handle, x, y);
	}
	
	public int getMonitorAtWindow(Window win) {
		return gdk_screen_get_monitor_at_window(handle, win.getHandle());
	}
	
	public void broadcastClientMessage(Event evt) {
		gdk_screen_broadcast_client_message(handle, evt.getHandle());
	}


	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gdk_screen_get_type();
	native static final protected int gdk_screen_get_default_colormap(int screen);
	native static final protected void gdk_screen_set_default_colormap(int screen, int colormap);
	native static final protected int gdk_screen_get_system_colormap(int screen);
	native static final protected int gdk_screen_get_system_visual(int screen);
	native static final protected int gdk_screen_get_rgb_colormap(int screen);
	native static final protected int gdk_screen_get_rgb_visual(int screen);
	native static final protected int gdk_screen_get_root_window(int screen);
	native static final protected int gdk_screen_get_display(int screen);
	native static final protected int gdk_screen_get_number(int screen);
	native static final protected int gdk_screen_get_height(int screen);
	native static final protected int gdk_screen_get_width(int screen);
	native static final protected int gdk_screen_get_height_mm(int screen);
	native static final protected int gdk_screen_get_width_mm(int screen);
	native static final protected int[] gdk_screen_list_visuals(int screen);
	native static final protected int[] gdk_screen_get_toplevel_windows(int screen);
	native static final protected String gdk_screen_make_display_name(int screen);
	native static final protected int gdk_screen_get_n_monitors(int screen);
	native static final protected void gdk_screen_get_monitor_geometry(int screen, int monitorNum, int[] rect);
	native static final protected int gdk_screen_get_monitor_at_point(int screen, int x, int y);
	native static final protected int gdk_screen_get_monitor_at_window(int screen, int window);
	native static final protected void gdk_screen_broadcast_client_message(int screen, int event);
	native static final protected int gdk_screen_get_default();
	native static final protected boolean gdk_screen_get_setting(int screen, String name, int value);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
