/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_UIManager
#define _Included_org_gnu_gtk_UIManager
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_ui_manager_get_type();
}

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1new
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_ui_manager_new();
}

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_set_add_tearoffs
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1set_1add_1tearoffs
  (JNIEnv *env, jclass cls, jint uim, jboolean value)
{
	gtk_ui_manager_set_add_tearoffs((GtkUIManager*)uim, (gboolean)value);
}

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_get_add_tearoffs
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1get_1add_1tearoffs
  (JNIEnv *env, jclass cls, jint uim)
{
	return (jboolean)gtk_ui_manager_get_add_tearoffs((GtkUIManager*)uim);
}

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_insert_action_group
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1insert_1action_1group
  (JNIEnv *env, jclass cls, jint uim, jint group, jint pos)
{
	gtk_ui_manager_insert_action_group((GtkUIManager*)uim, (GtkActionGroup*)group, (gint)pos);
}

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_remove_action_group
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1remove_1action_1group
  (JNIEnv *env, jclass cls, jint uim, jint group)
{
	gtk_ui_manager_remove_action_group((GtkUIManager*)uim, (GtkActionGroup*)group);
}

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_get_action_groups
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1get_1action_1groups
  (JNIEnv *env, jclass cls, jint uim)
{
	GList *list = gtk_ui_manager_get_action_groups((GtkUIManager*)uim);
	guint len;
	jintArray ar;
	int i = 0;
 	if (NULL == list)
		return NULL;
	 len = g_list_length(list);
	 ar = (*env)->NewIntArray(env, len);
	for (i = 0; i < len; i++) {
		GList *item = g_list_nth(list, i);
		(*env)->SetIntArrayRegion(env, ar, i, 1, (jint*)item->data);
	}
	return ar;
}

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_get_accel_group
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1get_1accel_1group
  (JNIEnv *env, jclass cls, jint uim)
{
	return (jint)gtk_ui_manager_get_accel_group((GtkUIManager*)uim);
}

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_get_widget
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1get_1widget
  (JNIEnv *env, jclass cls, jint uim, jstring path)
{
	const gchar* p = (*env)->GetStringUTFChars(env, path, NULL);
	jint ret = (jint)gtk_ui_manager_get_widget((GtkUIManager*)uim, p);
	(*env)->ReleaseStringUTFChars(env, path, p);
	return ret;
}

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_get_action
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1get_1action
  (JNIEnv *env, jclass cls, jint uim, jstring path)
{
	const gchar* p = (*env)->GetStringUTFChars(env, path, NULL);
	jint ret = (jint)gtk_ui_manager_get_action((GtkUIManager*)uim, p);
	(*env)->ReleaseStringUTFChars(env, path, p);
	return ret;
}
/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_add_ui_from_string
 * Signature: (ILjava/lang/String;I[I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1add_1ui_1from_1string
  (JNIEnv *env, jclass cls, jint uim, jstring buffer, jint len, jintArray error)
{
	const gchar* b = (*env)->GetStringUTFChars(env, buffer, NULL);
	GError* err = (GError*)(*env)->GetIntArrayElements(env, error, NULL);
	jint ret = (jint)gtk_ui_manager_add_ui_from_string((GtkUIManager*)uim, b, (gint)len, &err);
	(*env)->ReleaseStringUTFChars(env, buffer, b);
	(*env)->ReleaseIntArrayElements(env, error, (jint*)err, 0);
	return ret;
}

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_add_ui_from_file
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1add_1ui_1from_1file
  (JNIEnv *env, jclass cls, jint uim, jstring filename, jintArray error)
{
	const gchar* f = (*env)->GetStringUTFChars(env, filename, NULL);
	GError* err = (GError*)(*env)->GetIntArrayElements(env, error, NULL);
	jint ret = (jint)gtk_ui_manager_add_ui_from_file((GtkUIManager*)uim, f, &err);
	(*env)->ReleaseStringUTFChars(env, filename, f);
	(*env)->ReleaseIntArrayElements(env, error, (jint*)err, 0);
	return ret;
}

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_add_ui
 * Signature: (IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1add_1ui
  (JNIEnv *env, jclass cls, jint uim, jint id, jstring path, jstring name, jstring action, jint type, jboolean top)
{
	const gchar* p = (*env)->GetStringUTFChars(env, path, NULL);
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	const gchar* a = (*env)->GetStringUTFChars(env, action, NULL);
	gtk_ui_manager_add_ui((GtkUIManager*)uim, (guint)id, p, n, a, (GtkUIManagerItemType)type, (gboolean)top);
	(*env)->ReleaseStringUTFChars(env, path, p);
	(*env)->ReleaseStringUTFChars(env, name, n);
	(*env)->ReleaseStringUTFChars(env, action, a);
}

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_remove_ui
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1remove_1ui
  (JNIEnv *env, jclass cls, jint uim, jint id)
{
	gtk_ui_manager_remove_ui((GtkUIManager*)uim, (guint)id);
}

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_get_ui
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1get_1ui
  (JNIEnv *env, jclass cls, jint uim)
{
	gchar* ui = gtk_ui_manager_get_ui((GtkUIManager*)uim);
	return (*env)->NewStringUTF(env, ui);
}

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_ensure_update
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1ensure_1update
  (JNIEnv *env, jclass cls, jint uim)
{
	gtk_ui_manager_ensure_update((GtkUIManager*)uim);
}

/*
 * Class:     org_gnu_gtk_UIManager
 * Method:    gtk_ui_manager_new_merge_id
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_UIManager_gtk_1ui_1manager_1new_1merge_1id
  (JNIEnv *env, jclass cls, jint uim)
{
	return (jint)gtk_ui_manager_new_merge_id((GtkUIManager*)uim);
}

#ifdef __cplusplus
}
#endif
#endif
