// Generated by gtkmmproc -- DO NOT MODIFY!

#include <gtkmm/clipboard.h>
#include <gtkmm/private/clipboard_p.h>

// -*- c++ -*-
/* $Id: clipboard.ccg,v 1.3 2004/01/05 17:32:16 murrayc Exp $ */

/* 
 *
 * Copyright 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/selectiondata_private.h>
#include <glibmm/utility.h> //For ScopedPtr<>.
#include <gtk/gtkclipboard.h>

namespace
{

// SignalProxy_GetClear:
// This Signal Proxy allows the C++ coder to specify a SigC::Slot instead of a static function.
class SignalProxy_GetClear
{
public:
  SignalProxy_GetClear(const Gtk::Clipboard::SlotGet& slot_get,
                       const Gtk::Clipboard::SlotClear& slot_clear);
  ~SignalProxy_GetClear();

  static void gtk_callback_get(GtkClipboard* clipboard, GtkSelectionData* selection_data,
                               unsigned int info, void* data);
  static void gtk_callback_clear(GtkClipboard* clipboard, void* data);

protected:
  Gtk::Clipboard::SlotGet   slot_get_;
  Gtk::Clipboard::SlotClear slot_clear_;
};

SignalProxy_GetClear::SignalProxy_GetClear(const Gtk::Clipboard::SlotGet& slot_get,
                                           const Gtk::Clipboard::SlotClear& slot_clear)
:
  slot_get_   (slot_get),
  slot_clear_ (slot_clear)
{}

SignalProxy_GetClear::~SignalProxy_GetClear()
{}

void SignalProxy_GetClear::gtk_callback_get(GtkClipboard*, GtkSelectionData* selection_data,
                                            unsigned int info, void* data)
{
  SignalProxy_GetClear *const self = static_cast<SignalProxy_GetClear*>(data);

  try
  {
    Gtk::SelectionData_WithoutOwnership cppSelectionData(selection_data);
    (self->slot_get_)(cppSelectionData, info);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

void SignalProxy_GetClear::gtk_callback_clear(GtkClipboard*, void* data)
{
  SignalProxy_GetClear *const self = static_cast<SignalProxy_GetClear*>(data);

  try
  {
    (self->slot_clear_)();
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  delete self; // After this callback has been called, none of the 2 callbacks will be called again.

  //This might leak the last SignalProxy_GetClear(), but only the last one,
  //because clear() is called when set() is called again.
}


// SignalProxy_Received:
// This Signal Proxy allows the C++ coder to specify a SigC::Slot instead of a static function.
class SignalProxy_Received
{
public:
  typedef Gtk::Clipboard::SlotReceived SlotType;

  SignalProxy_Received(const SlotType& slot);
  ~SignalProxy_Received();

  static void gtk_callback(GtkClipboard* clipboard, GtkSelectionData* selection_data, gpointer data);

protected:
  SlotType slot_;
};

SignalProxy_Received::SignalProxy_Received(const SlotType& slot)
:
  slot_ (slot)
{}

SignalProxy_Received::~SignalProxy_Received()
{}

void SignalProxy_Received::gtk_callback(GtkClipboard*, GtkSelectionData* selection_data, void* data)
{
  SignalProxy_Received *const self = static_cast<SignalProxy_Received*>(data);

  try
  {
    Gtk::SelectionData cppSelectionData(selection_data, true /*take_copy=true*/); 
    (self->slot_)(cppSelectionData);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  delete self;
}


// SignalProxy_TargetsReceived:
// This Signal Proxy allows the C++ coder to specify a SigC::Slot instead of a static function.
class SignalProxy_TargetsReceived
{
public:
  typedef Gtk::Clipboard::SlotTargetsReceived SlotType;

  SignalProxy_TargetsReceived(const SlotType& slot);
  ~SignalProxy_TargetsReceived();

  static void gtk_callback(GtkClipboard* clipboard, GdkAtom* atoms, gint n_atoms, gpointer data);

protected:
  SlotType slot_;
};

SignalProxy_TargetsReceived::SignalProxy_TargetsReceived(const SlotType& slot)
:
  slot_ (slot)
{}

SignalProxy_TargetsReceived::~SignalProxy_TargetsReceived()
{}

//This is not public API:
typedef std::list<Glib::ustring> listStrings;
static listStrings util_convert_atoms_to_strings(GdkAtom* targets, int n_targets)
{
  listStrings listTargets;

  //Add the targets to the C++ container:
  for(int i = 0; i < n_targets; i++)
  {
    //Convert the atom to a string:
    Glib::ustring target = gdk_atom_name(targets[i]);
    listTargets.push_back(target);
  }

  return listTargets;
}

void SignalProxy_TargetsReceived::gtk_callback(GtkClipboard*, GdkAtom* atoms, gint n_atoms, gpointer data)
{
  SignalProxy_TargetsReceived *const self = static_cast<SignalProxy_TargetsReceived*>(data);

  try
  {
    listStrings listTargets = util_convert_atoms_to_strings(atoms, n_atoms);
    (self->slot_)(listTargets);
    //I guess that GTK+ does a g_free of the GdkAtoms* array itself, so we do not need to. murrayc.
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  delete self; // the callback is only used once
}


// SignalProxy_TextReceived:
// This Signal Proxy allows the C++ coder to specify a SigC::Slot instead of a static function.
class SignalProxy_TextReceived
{
public:
  typedef Gtk::Clipboard::SlotTextReceived SlotType;

  SignalProxy_TextReceived(const SlotType& slot);
  ~SignalProxy_TextReceived();

  static void gtk_callback(GtkClipboard* clipboard, const char* text, void* data);

protected:
  SlotType slot_;
};

SignalProxy_TextReceived::SignalProxy_TextReceived(const SlotType& slot)
:
  slot_ (slot)
{}

SignalProxy_TextReceived::~SignalProxy_TextReceived()
{}

void SignalProxy_TextReceived::gtk_callback(GtkClipboard*, const char* text, void* data)
{
  SignalProxy_TextReceived *const self = static_cast<SignalProxy_TextReceived*>(data);

  try
  {
    (self->slot_)((text) ? Glib::ustring(text) : Glib::ustring());
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  delete self; // the callback is only used once
}

} // anonymous namespace


namespace Gtk
{

bool Clipboard::set(const ArrayHandle_TargetEntry& targets,
                    const SlotGet& slot_get, const SlotClear& slot_clear)
{
  // Create a signal proxy. A pointer to this will be passed through the callback's data parameter.
  SignalProxy_GetClear *const pSignalProxy = new SignalProxy_GetClear(slot_get, slot_clear);

  return gtk_clipboard_set_with_data(
      gobj(), targets.data(), targets.size(),
      &SignalProxy_GetClear::gtk_callback_get,
      &SignalProxy_GetClear::gtk_callback_clear,
      pSignalProxy);
}

void Clipboard::set_text(const Glib::ustring& text)
{
  gtk_clipboard_set_text(gobj(), text.c_str(), text.bytes());
}


void Clipboard::request_contents(const Glib::ustring& target, const SlotReceived& slot)
{
  // Create a signal proxy. A pointer to this will be passed through the callback's data parameter.
  SignalProxy_Received *const pSignalProxy = new SignalProxy_Received(slot);

  gtk_clipboard_request_contents(gobj(), gdk_atom_intern(target.c_str(), FALSE),
      &SignalProxy_Received::gtk_callback, pSignalProxy);
}

void Clipboard::request_targets(const SlotReceived& slot)
{
  // Create a signal proxy. A pointer to this will be passed through the callback's data parameter.
  SignalProxy_Received *const pSignalProxy = new SignalProxy_Received(slot);

  gtk_clipboard_request_contents(gobj(), gdk_atom_intern("TARGETS" /* see the comment in the .hg file */, FALSE),
      &SignalProxy_Received::gtk_callback, pSignalProxy);
}

void Clipboard::request_text(const SlotTextReceived& slot)
{
  // Create a signal proxy. A pointer to this will be passed through the callback's data parameter.
  SignalProxy_TextReceived *const pSignalProxy = new SignalProxy_TextReceived(slot);

  gtk_clipboard_request_text(gobj(),
      &SignalProxy_TextReceived::gtk_callback, pSignalProxy);
}

void Clipboard::request_targets(const SlotTargetsReceived& slot)
{
  // Create a signal proxy. A pointer to this will be passed through the callback's data parameter.
  SignalProxy_TargetsReceived *const pSignalProxy = new SignalProxy_TargetsReceived(slot);

  gtk_clipboard_request_targets(gobj(), &SignalProxy_TargetsReceived::gtk_callback, pSignalProxy);
}

SelectionData Clipboard::wait_for_contents(const Glib::ustring& target) const
{
  //gtk_clipboard_wait_for_contents returns a newly-allocated GtkSelectionData, or NULL.
  GtkSelectionData* cData = gtk_clipboard_wait_for_contents( const_cast<GtkClipboard*>(gobj()), gdk_atom_intern(target.c_str(), FALSE) );
  return SelectionData(cData, false /* take_copy */);
}

Glib::StringArrayHandle Clipboard::wait_for_targets() const
{
  std::list<Glib::ustring> listTargets;

  //Get a newly-allocated array of atoms:
  GdkAtom* targets = 0;
  gint n_targets = 0;
  gboolean test = gtk_clipboard_wait_for_targets( const_cast<GtkClipboard*>(gobj()), &targets, &n_targets );
  if(!test)
    n_targets = 0; //otherwise it will be -1.

  //Add the targets to the C++ container:
  for(int i = 0; i < n_targets; i++)
  {
    //Convert the atom to a string:
    gchar* const atom_name = gdk_atom_name(targets[i]);

    Glib::ustring target;
    if(atom_name)
      target = Glib::ScopedPtr<char>(atom_name).get(); //This frees the gchar*.

    listTargets.push_back(target);
  }

  return listTargets;
}

  
} //namespace Gtk


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::Clipboard> wrap(GtkClipboard* object, bool take_copy)
{
  return Glib::RefPtr<Gtk::Clipboard>( dynamic_cast<Gtk::Clipboard*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Clipboard_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Clipboard_Class::class_init_function;

    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually necessary?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_clipboard_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void Clipboard_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

}


Glib::ObjectBase* Clipboard_Class::wrap_new(GObject* object)
{
  return new Clipboard((GtkClipboard*)object);
}


/* The implementation: */

GtkClipboard* Clipboard::gobj_copy()
{
  reference();
  return gobj();
}

Clipboard::Clipboard(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{}

Clipboard::Clipboard(GtkClipboard* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

Clipboard::~Clipboard()
{}

Clipboard::CppClassType Clipboard::clipboard_class_; // initialize static member

GType Clipboard::get_type()
{
  return clipboard_class_.init().get_type();
}

GType Clipboard::get_base_type()
{
  return gtk_clipboard_get_type();
}


Glib::RefPtr<Clipboard> Clipboard::get(GdkAtom selection)
{

  Glib::RefPtr<Clipboard> retvalue = Glib::wrap(gtk_clipboard_get(selection));

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Clipboard> Clipboard::get_for_display(const Glib::RefPtr<Gdk::Display>& display, GdkAtom selection)
{

  Glib::RefPtr<Clipboard> retvalue = Glib::wrap(gtk_clipboard_get_for_display(Glib::unwrap(display), selection));

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Gdk::Display> Clipboard::get_display()
{

  Glib::RefPtr<Gdk::Display> retvalue = Glib::wrap(gtk_clipboard_get_display(gobj()));

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Display> Clipboard::get_display() const
{

  Glib::RefPtr<const Gdk::Display> retvalue = Glib::wrap(gtk_clipboard_get_display(const_cast<GtkClipboard*>(gobj())));

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Glib::Object> Clipboard::get_owner()
{
  return Glib::wrap(gtk_clipboard_get_owner(gobj()));
}

Glib::RefPtr<const Glib::Object> Clipboard::get_owner() const
{
  return Glib::wrap(gtk_clipboard_get_owner(const_cast<GtkClipboard*>(gobj())));
}

void Clipboard::clear()
{
  gtk_clipboard_clear(gobj());
}

Glib::ustring Clipboard::wait_for_text() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_clipboard_wait_for_text(const_cast<GtkClipboard*>(gobj())));
}

bool Clipboard::wait_is_text_available() const
{
  return gtk_clipboard_wait_is_text_available(const_cast<GtkClipboard*>(gobj()));
}


} // namespace Gtk


