// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_INFOBAR_H
#define _GTKMM_INFOBAR_H


#include <glibmm.h>

/* $Id: infobar.hg,v 1.10 2006/08/21 19:07:14 jjongsma Exp $ */

/* Copyright (C) 2009 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkInfoBar GtkInfoBar;
typedef struct _GtkInfoBarClass GtkInfoBarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class InfoBar_Class; } // namespace Gtk
namespace Gtk
{

/** TODO
 *
 * The InfoBar widget looks like this: TODO
 *
 * @newin{2,18}
 *
 * @ingroup Widgets
 */

class InfoBar : public HBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef InfoBar CppObjectType;
  typedef InfoBar_Class CppClassType;
  typedef GtkInfoBar BaseObjectType;
  typedef GtkInfoBarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~InfoBar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class InfoBar_Class;
  static CppClassType infobar_class_;

  // noncopyable
  InfoBar(const InfoBar&);
  InfoBar& operator=(const InfoBar&);

protected:
  explicit InfoBar(const Glib::ConstructParams& construct_params);
  explicit InfoBar(GtkInfoBar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkInfoBar*       gobj()       { return reinterpret_cast<GtkInfoBar*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkInfoBar* gobj() const { return reinterpret_cast<GtkInfoBar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_response(int response_id);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:

  InfoBar();
  

//TODO: What types are these widgets really?
  
  /** Returns: the action area.
   * @return The action area.
   * 
   * @newin{2,18}.
   */
  Widget* get_action_area();
  
  /** Returns: the action area.
   * @return The action area.
   * 
   * @newin{2,18}.
   */
  const Widget* get_action_area() const;
  
  
  /** Returns: the content area.
   * @return The content area.
   * 
   * @newin{2,18}.
   */
  Widget* get_content_area();
  
  /** Returns: the content area.
   * @return The content area.
   * 
   * @newin{2,18}.
   */
  const Widget* get_content_area() const;

  
  /** Add an activatable widget to the action area of a Gtk::InfoBar,
   * connecting a signal handler that will emit the Gtk::InfoBar::response
   * signal on the message area when the widget is activated. The widget
   * is appended to the end of the message areas action area.
   * 
   * @newin{2,18}
   * @param child An activatable widget.
   * @param response_id Response ID for @a child.
   */
  void add_action_widget(Widget& child, int response_id);
  
  
  /** Adds a button with the given text (or a stock button, if button_text
   * is a stock ID) and sets things up so that clicking the button will emit
   * the "response" signal with the given response_id. The button is appended
   * to the end of the info bars's action area. The button widget is
   * returned, but usually you don't need it.
   * @param button_text Text of button, or stock ID.
   * @param response_id Response ID for the button.
   * @return The button widget that was added
   * 
   * @newin{2,18}.
   */
  Button* add_button(const Glib::ustring& button_text, int response_id);
  
  /** Adds a button with the given text (or a stock button, if button_text
   * is a stock ID) and sets things up so that clicking the button will emit
   * the "response" signal with the given response_id. The button is appended
   * to the end of the info bars's action area. The button widget is
   * returned, but usually you don't need it.
   * @param button_text Text of button, or stock ID.
   * @param response_id Response ID for the button.
   * @return The button widget that was added
   * 
   * @newin{2,18}.
   */
  Button* add_button(const Gtk::StockID& stock_id, int response_id);
    
  
  /** Calls gtk_widget_set_sensitive (widget, setting) for each
   * widget in the info bars's action area with the given response_id.
   * A convenient way to sensitize/desensitize dialog buttons.
   * 
   * @newin{2,18}
   * @param response_id A response ID.
   * @param setting <tt>true</tt> for sensitive.
   */
  void set_response_sensitive(int response_id, bool setting = true);
  
  /** Sets the last widget in the info bar's action area with
   * the given response_id as the default widget for the dialog.
   * Pressing "Enter" normally activates the default widget.
   * 
   * @newin{2,18}
   * @param response_id A response ID.
   */
  void set_default_response(int response_id);

  
  /** Emits the 'response' signal with the given @a response_id.
   * 
   * @newin{2,18}
   * @param response_id A response ID.
   */
  void response(int response_id);

  
  /** Sets the message type of the message area.
   * GTK+ uses this type to determine what color to use
   * when drawing the message area.
   * 
   * @newin{2,18}
   * @param message_type A Gtk::MessageType.
   */
  void set_message_type(MessageType message_type);
  
  /** Returns: the message type of the message area.
   * @return The message type of the message area.
   * 
   * @newin{2,18}.
   */
  MessageType get_message_type() const;
  

  //ignored: key-binding signal: _WRAP_SIGNAL(void close(), "close")
  
  /**
   * @par Prototype:
   * <tt>void on_my_%response(int response_id)</tt>
   */

  Glib::SignalProxy1< void,int > signal_response();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The type of message.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<MessageType> property_message_type() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The type of message.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<MessageType> property_message_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::InfoBar
   */
  Gtk::InfoBar* wrap(GtkInfoBar* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_INFOBAR_H */

