// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_REGION_H
#define _GDKMM_REGION_H


#include <glibmm.h>

/* $Id: region.hg,v 1.3 2004/02/03 11:06:48 murrayc Exp $ */

/* region.h
 *
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

extern "C" { typedef struct _GdkRegion GdkRegion; }

#include <glibmm/arrayhandle.h>
#include <gdkmm/types.h>
#include <gdkmm/rectangle.h>


namespace Gdk
{


/** @addtogroup gdkmmEnums Enums and Flags */

/**
 * @ingroup gdkmmEnums
 */
enum FillRule
{
  EVEN_ODD_RULE,
  WINDING_RULE
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::FillRule> : public Glib::Value_Enum<Gdk::FillRule>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum OverlapType
{
  OVERLAP_RECTANGLE_IN,
  OVERLAP_RECTANGLE_OUT,
  OVERLAP_RECTANGLE_PART
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::OverlapType> : public Glib::Value_Enum<Gdk::OverlapType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


/** This is an opaque data type holding a set of arbitrary pixels, and is usually used for clipping graphical operations
 * (see Gdk::GC::set_clip_region()).
 */
class Region
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Region CppObjectType;
  typedef GdkRegion BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Region();

  // Use make_a_copy=true when getting it directly from a struct.
  explicit Region(GdkRegion* castitem, bool make_a_copy = false);

  Region(const Region& src);
  Region& operator=(const Region& src);

  ~Region();

  GdkRegion*       gobj()       { return gobject_; }
  const GdkRegion* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GdkRegion* gobj_copy() const;

protected:
  GdkRegion* gobject_;

private:

  
public:

  Region(const Glib::ArrayHandle<Gdk::Point>& points, FillRule fill_rule);
  explicit Region(const Rectangle& rectangle);

  
  /** Obtains the smallest rectangle which includes the entire Gdk::Region.
   * @param rectangle Return location for the clipbox.
   */
  void get_clipbox(const Rectangle& rectangle);
  Glib::ArrayHandle<Rectangle> get_rectangles() const;

  
  /** Finds out if the Gdk::Region is empty.
   * @return <tt>true</tt> if @a region is empty.
   */
  bool empty();
  
  /** Finds out if a point is in a region.
   * @param x The x coordinate of a point.
   * @param y The y coordinate of a point.
   * @return <tt>true</tt> if the point is in @a region.
   */
  bool point_in(int x, int y);
  
  /** Tests whether a rectangle is within a region.
   * @param rectangle A Gdk::Rectangle.
   * @return Gdk::OVERLAP_RECTANGLE_IN, Gdk::OVERLAP_RECTANGLE_OUT, or
   * Gdk::OVERLAP_RECTANGLE_PART, depending on whether the rectangle is inside,
   * outside, or partly inside the Gdk::Region, respectively.
   */
  OverlapType rect_in(const Rectangle& rect);

  
  /** Moves a region the specified distance.
   * @param dx The distance to move the region horizontally.
   * @param dy The distance to move the region vertically.
   */
  void offset(int dx, int dy);
  
  /** Resizes a region by the specified amount.
   * Positive values shrink the region. Negative values expand it.
   * @param dx The number of pixels to shrink the region horizontally.
   * @param dy The number of pixels to shrink the region vertically.
   */
  void shrink(int dx, int dy);
  
  /** Sets the area of @a region to the union of the areas of @a region and
   *  @a rect. The resulting area is the set of pixels contained in
   * either @a region or @a rect.
   * @param rect A Gdk::Rectangle.
   */
  void union_with_rect(const Rectangle& rect);
  
  /** Sets the area of @a source1 to the intersection of the areas of @a source1
   * and @a source2. The resulting area is the set of pixels contained in
   * both @a source1 and @a source2.
   * @param source2 Another Gdk::Region.
   */
  void intersect(const Region& source2);
  
  /** Sets the area of @a source1 to the union of the areas of @a source1 and
   *  @a source2. The resulting area is the set of pixels contained in
   * either @a source1 or @a source2.
   * @param source2 A Gdk::Region.
   */
  void union_(const Region& source2); //union is a keyword.
  
  /** Subtracts the area of @a source2 from the area @a source1. The resulting
   * area is the set of pixels contained in @a source1 but not in @a source2.
   * @param source2 Another Gdk::Region.
   */
  void subtract(const Region& source2);
  
  /** Sets the area of @a source1 to the exclusive-OR of the areas of @a source1
   * and @a source2. The resulting area is the set of pixels contained in one
   * or the other of the two sources but not in both.
   * @param source2 Another Gdk::Region.
   */
  void xor_(const Region& source2); //xor is a keyword
  
  /** Calls a function on each span in the intersection of @a region and @a spans.
   * @param spans An array of Gdk::Spans.
   * @param n_spans The length of @a spans.
   * @param sorted <tt>true</tt> if @a spans is sorted wrt. the y coordinate.
   * @param function Function to call on each span in the intersection.
   * @param data Data to pass to @a function.
   */
  void spans_intersect_foreach(GdkSpan* spans, int n_spans, bool sorted, GdkSpanFunc function, gpointer data);
  

};

} //namespace Gdk


namespace Gdk
{

/** @relates Gdk::Region
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator==(const Region& lhs, const Region& rhs);

/** @relates Gdk::Region
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator!=(const Region& lhs, const Region& rhs);


} // namespace Gdk


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Region
   */
Gdk::Region wrap(GdkRegion* object, bool take_copy = false);

} // namespace Glib


#endif /* _GDKMM_REGION_H */

