package radiotoolbar;

import org.gnu.gnome.App;
import org.gnu.gnome.GnomeStockItem;
import org.gnu.gnome.Program;
import org.gnu.gnome.UIInfo;
import org.gnu.gtk.Gtk;
import org.gnu.gtk.event.ButtonEvent;
import org.gnu.gtk.event.ButtonListener;
import org.gnu.gtk.event.LifeCycleEvent;
import org.gnu.gtk.event.LifeCycleListener;

public class RadioToolbar implements ButtonListener {

    protected App app;

    protected boolean radioOneEnabled = true;

    protected boolean radioTwoEnabled = false;

    protected boolean radioThreeEnabled = false;

    protected boolean toggleOneEnabled = false;

    protected boolean toggleTwoEnabled = false;

    protected boolean toggleThreeEnabled = false;

    public RadioToolbar() {

        app = new App("radiotoolbar", "Radio Toolbar");
        app.addListener(new LifeCycleListener() {
            public void lifeCycleEvent(LifeCycleEvent event) {
            }

            public boolean lifeCycleQuery(LifeCycleEvent event) {
                if (event.isOfType(LifeCycleEvent.Type.DELETE)
                        || event.isOfType(LifeCycleEvent.Type.DESTROY))
                    Gtk.mainQuit();
                return false;
            }
        });

        UIInfo toolbar[] = buildMyToolbar();
        app.createToolBar(toolbar);

        app.showAll();
    }

    public void buttonEvent(ButtonEvent event) {
        if (event.isOfType(ButtonEvent.Type.CLICK))
            app.message("Not implemented...");
    }

    public void radioOne() {
        radioOneEnabled = !radioOneEnabled;
        if (radioOneEnabled)
            app.message("Radio One Enabled");
    }

    public void radioTwo() {
        radioTwoEnabled = !radioTwoEnabled;
        if (radioTwoEnabled)
            app.message("Radio Two Enabled");
    }

    public void radioThree() {
        radioThreeEnabled = !radioThreeEnabled;
        if (radioThreeEnabled)
            app.message("Radio Three Enabled");
    }

    public void toggleOne() {
        toggleOneEnabled = !toggleOneEnabled;
        if (toggleOneEnabled)
            app.message("Toggle One Enabled");
        else
            app.message("Toggle One Disabled");
    }

    public void toggleTwo() {
        toggleTwoEnabled = !toggleTwoEnabled;
        if (toggleTwoEnabled)
            app.message("Toggle Two Enabled");
        else
            app.message("Toggle Two Disabled");
    }

    public void toggleThree() {
        toggleThreeEnabled = !toggleThreeEnabled;
        if (toggleThreeEnabled)
            app.message("Toggle Three Enabled");
        else
            app.message("Toggle Three Disabled");
    }

    protected UIInfo[] buildMyToolbar() {
        UIInfo radioList[] = {
                UIInfo.radioItemStock("Radio One", "The first radio button",
                        new ButtonListener() {
                            public void buttonEvent(ButtonEvent event) {
                                if (event.isOfType(ButtonEvent.Type.CLICK)) {
                                    radioOne();
                                }
                            }
                        }, GnomeStockItem.GO_UP),
                UIInfo.radioItemStock("Radio Two", "The second radio button",
                        new ButtonListener() {
                            public void buttonEvent(ButtonEvent event) {
                                if (event.isOfType(ButtonEvent.Type.CLICK))
                                    radioTwo();
                            }
                        }, GnomeStockItem.GO_DOWN),
                UIInfo.radioItemStock("Radio Three", "The third radio button",
                        new ButtonListener() {
                            public void buttonEvent(ButtonEvent event) {
                                if (event.isOfType(ButtonEvent.Type.CLICK))
                                    radioThree();
                            }
                        }, GnomeStockItem.ATTACH), UIInfo.end() };

        UIInfo toolbar[] = {
                UIInfo.radioList(radioList),
                UIInfo.separator(),
                UIInfo.toggleItemStock("Toggle One", "The first toggle button",
                        new ButtonListener() {
                            public void buttonEvent(ButtonEvent event) {
                                if (event.isOfType(ButtonEvent.Type.CLICK))
                                    toggleOne();
                            }
                        }, GnomeStockItem.GO_UP),
                UIInfo.toggleItemStock("Toggle Two",
                        "The second toggle button", new ButtonListener() {
                            public void buttonEvent(ButtonEvent event) {
                                if (event.isOfType(ButtonEvent.Type.CLICK))
                                    toggleTwo();
                            }
                        }, GnomeStockItem.GO_DOWN),
                UIInfo.toggleItemStock("Toggle Three",
                        "The third toggle button", new ButtonListener() {
                            public void buttonEvent(ButtonEvent event) {
                                if (event.isOfType(ButtonEvent.Type.CLICK))
                                    toggleThree();
                            }
                        }, GnomeStockItem.ATTACH), UIInfo.end() };

        return toolbar;
    }

    public static void main(String[] args) {

        Program.initGnomeUI("RadioToolbar", "1.0", args);

        RadioToolbar rt = new RadioToolbar();

        Gtk.main();
    }
}
