/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.glib.EventType;
import org.gnu.gtk.Orientation;
import org.gnu.gtk.ToolBarStyle;

/**
  * This event is used to identify when a ToolBar receives an event
 * 
 * @see ToolBarListener
 */
public class ToolBarEvent extends GtkEvent {
	
	private Orientation orientation;
	private ToolBarStyle style;
	private int x;
	private int y;
	private int buttonNumber;
	

	public static class Type extends EventType {
		private Type(int id, String name) {
			super(id, name);
		}

		
		public static final Type ORIENTATION_CHANGED = new Type(1, "ORIENTATION_CHANGED");
		public static final Type STYLE_CHANGED = new Type(2, "STYLE_CHANGED");
		public static final Type POPUP_CONTEXT_MENU = new Type(3, "POPUP_CONTEXT_MENU");
	}

	/**
	 * Constructor for ToolBarEvent.
	 * @param source
	 * @param type
	 */
	public ToolBarEvent(Object source, EventType type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(ToolBarEvent.Type aType) {
		return (type.getID() == aType.getID());
	}
	/**
	 * @return Returns the buttonNumber.
	 */
	public int getButtonNumber() {
		return buttonNumber;
	}

	/**
	 * @param buttonNumber The buttonNumber to set.
	 */
	public void setButtonNumber(int buttonNumber) {
		this.buttonNumber = buttonNumber;
	}

	/**
	 * @return Returns the orientation.
	 */
	public Orientation getOrientation() {
		return orientation;
	}

	/**
	 * @param orientation The orientation to set.
	 */
	public void setOrientation(Orientation orientation) {
		this.orientation = orientation;
	}

	/**
	 * @return Returns the style.
	 */
	public ToolBarStyle getStyle() {
		return style;
	}

	/**
	 * @param style The style to set.
	 */
	public void setStyle(ToolBarStyle style) {
		this.style = style;
	}

	/**
	 * @return Returns the x.
	 */
	public int getX() {
		return x;
	}

	/**
	 * @param x The x to set.
	 */
	public void setX(int x) {
		this.x = x;
	}

	/**
	 * @return Returns the y.
	 */
	public int getY() {
		return y;
	}

	/**
	 * @param y The y to set.
	 */
	public void setY(int y) {
		this.y = y;
	}

}
