/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

GdkEventType GdkEventProximity_get_type (GdkEventProximity * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventProximity
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventProximity_getType (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventProximity *obj_g = (GdkEventProximity *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventProximity_get_type (obj_g));
}

GdkWindow * GdkEventProximity_get_window (GdkEventProximity * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventProximity
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventProximity_getWindow (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventProximity *obj_g = (GdkEventProximity *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventProximity_get_window (obj_g));
}

gboolean GdkEventProximity_get_send_event (GdkEventProximity * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventProximity
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventProximity_getSendEvent (JNIEnv *env, jclass 
    cls, jobject obj) 
{
    GdkEventProximity *obj_g = (GdkEventProximity *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventProximity_get_send_event (obj_g));
}

time_t GdkEventProximity_get_time (GdkEventProximity * cptr) 
{
    return cptr->time;
}

/*
 * Class:     org.gnu.gdk.EventProximity
 * Method:    getTime
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventProximity_getTime (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventProximity *obj_g = (GdkEventProximity *)getPointerFromHandle(env, obj);
    return GdkEventProximity_get_time (obj_g);
}

GdkDevice * GdkEventProximity_get_device (GdkEventProximity * cptr) 
{
    return cptr->device;
}

/*
 * Class:     org.gnu.gdk.EventProximity
 * Method:    getDevice
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventProximity_getDevice (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventProximity *obj_g = (GdkEventProximity *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventProximity_get_device (obj_g));
}


#ifdef __cplusplus
}

#endif
