// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_WINDOW_H
#define _GTKMM_WINDOW_H

#include <glibmm.h>

/* $Id: window.hg,v 1.16 2005/07/10 19:24:22 murrayc Exp $ */

/* window.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <glibmm/object.h>
#include <glibmm/listhandle.h>
#include <gtkmm/bin.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkWindow GtkWindow;
typedef struct _GtkWindowClass GtkWindowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Window_Class; } // namespace Gtk
#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkWindowGroup GtkWindowGroup;
typedef struct _GtkWindowGroupClass GtkWindowGroupClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class WindowGroup_Class; } // namespace Gtk
namespace Gtk
{

class AccelGroup;
class WindowGroup;


/** Toplevel Window
 * This represents all widgets which are physical windows controlled
 * by the window manager.
 *
 * The window will be hidden when the window manager's close button is clicked. Override on_delete_event() to stop this.
 *
 * Gtk::manage() has no effect on Windows because they have no parent Containers.
 * @ingroup Widgets
 */

class Window : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Window CppObjectType;
  typedef Window_Class CppClassType;
  typedef GtkWindow BaseObjectType;
  typedef GtkWindowClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Window();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Window_Class;
  static CppClassType window_class_;

  // noncopyable
  Window(const Window&);
  Window& operator=(const Window&);

protected:
  explicit Window(const Glib::ConstructParams& construct_params);
  explicit Window(GtkWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkWindow*       gobj()       { return reinterpret_cast<GtkWindow*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkWindow* gobj() const { return reinterpret_cast<GtkWindow*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_set_focus(Widget* focus);
  virtual bool on_frame_event(GdkEvent* event);


private:

  
public:
   explicit Window(WindowType type = WINDOW_TOPLEVEL);

  /** The title of the window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_title() ;

/** The title of the window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_title() const;

  /** If TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_allow_shrink() ;

/** If TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_allow_shrink() const;

  /** If TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_allow_grow() ;

/** If TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_allow_grow() const;

  /** If TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_resizable() ;

/** If TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_resizable() const;

  /** If TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_modal() ;

/** If TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_modal() const;

  /** The initial position of the window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<WindowPosition> property_window_position() ;

/** The initial position of the window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<WindowPosition> property_window_position() const;

  /** The default width of the window
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_default_width() ;

/** The default width of the window
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_default_width() const;

  /** The default height of the window
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_default_height() ;

/** The default height of the window
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_default_height() const;

  /** If this window should be destroyed when the parent is destroyed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_destroy_with_parent() ;

/** If this window should be destroyed when the parent is destroyed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_destroy_with_parent() const;

  /** Icon for this window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > property_icon() ;

/** Icon for this window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Pixbuf> > property_icon() const;

  
  /** The screen where this window will be displayed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Screen> > property_screen() ;

/** The screen where this window will be displayed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Screen> > property_screen() const;

  /** Whether the toplevel is the current active window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_active() const;


  /** Whether the input focus is within this GtkWindow.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_has_toplevel_focus() const;


  /** Hint to help the desktop environment understand what kind of window this is and how to treat it.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<GdkWindowTypeHint> property_type_hint() ;

/** Hint to help the desktop environment understand what kind of window this is and how to treat it.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<GdkWindowTypeHint> property_type_hint() const;

  /** TRUE if the window should not be in the task bar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_skip_taskbar_hint() ;

/** TRUE if the window should not be in the task bar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_skip_taskbar_hint() const;

  /** TRUE if the window should not be in the pager.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_skip_pager_hint() ;

/** TRUE if the window should not be in the pager.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_skip_pager_hint() const;
      
  /** Unique identifier for the window to be used when restoring a session.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_role() ;

/** Unique identifier for the window to be used when restoring a session.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_role() const;

  /** Whether the window should be decorated by the window manager.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_decorated() ;

/** Whether the window should be decorated by the window manager.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_decorated() const;

  /** The window gravity of the window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gdk::Gravity> property_gravity() ;

/** The window gravity of the window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gdk::Gravity> property_gravity() const;

  //gtkmmproc error: urgency-hint : property defs lookup failed. 

  bool is_toplevel() const;
  bool is_dialog() const;
  bool is_popup() const;

  WindowType get_window_type() const;

  //: This is special to the GTK+ linux-fb port.
  Glib::RefPtr<Gdk::Window> get_frame();
  Glib::RefPtr<const Gdk::Window> get_frame() const;


  Glib::SignalProxy1< void,Widget* > signal_set_focus();

  
  Glib::SignalProxy1< bool,GdkEvent* > signal_frame_event();


  //Keybinding signals:
  
  
  /** Sets the title of the Gtk::Window. The title of a window will be
   * displayed in its title bar; on the X&nbsp;%Window System, the title bar
   * is rendered by the window
   * manager, so exactly how the title appears to users may vary
   * according to a user's exact configuration. The title should help a
   * user distinguish this window from other windows they may have
   * open. A good title might include the application name and current
   * document filename, for example.
   * @param title Title of the window.
   */
  void set_title(const Glib::ustring& title);

  
  /** Retrieves the title of the window. See set_title().
   * @return The title of the window, or <tt>0</tt> if none has
   * been set explicitely. The returned string is owned by the widget
   * and must not be modified or freed.
   */
  Glib::ustring get_title() const;

  
  /** Don't use this function. It sets the X&nbsp;%Window System "class" and
   * "name" hints for a window.  According to the ICCCM, you should
   * always set these to the same value for all windows in an
   * application, and GTK+ sets them to that value by default, so calling
   * this function is sort of pointless. However, you may want to call
   * set_role() on each window in your application, for the
   * benefit of the session manager. Setting the role allows the window
   * manager to restore window positions when loading a saved session.
   * @param wmclass_name Window name hint.
   * @param wmclass_class Window class hint.
   */
  void set_wmclass(const Glib::ustring& wmclass_name,
                                const Glib::ustring& wmclass_class);

  
  /** This function is only useful on X11, not with other GTK+ targets.
   * 
   * In combination with the window title, the window role allows a
   * window manager to identify "the
   * same" window when an application is restarted. So for example you
   * might set the "toolbox" role on your app's toolbox window, so that
   * when the user restarts their session, the window manager can put
   * the toolbox back in the same place.
   * 
   * If a window already has a unique title, you don't need to set the
   * role, since the WM can use the title to identify the window when
   * restoring the session.
   * @param role Unique identifier for the window to be used when restoring a session.
   */
  void set_role(const Glib::ustring& role);

  //: Returns the role of the window.
  //- See {set_role()} for further explanation.
  
  /** Returns the role of the window. See set_role() for
   * further explanation.
   * @return The role of the window if set, or <tt>0</tt>. The
   * returned is owned by the widget and must not be modified
   * or freed.
   */
  Glib::ustring get_role() const;


  /** Associate @a accel_group  with @a window , such that calling
   * gtk_accel_groups_activate() on @a window  will activate accelerators
   * in @a accel_group .
   * @param accel_group A Gtk::AccelGroup.
   */
  void add_accel_group(const Glib::RefPtr<AccelGroup>& accel_group);

  
  /** Reverses the effects of add_accel_group().
   * @param accel_group A Gtk::AccelGroup.
   */
  void remove_accel_group(const Glib::RefPtr<AccelGroup>& accel_group);

  
  /** Sets a position constraint for this window. If the old or new
   * constraint is Gtk::WIN_POS_CENTER_ALWAYS, this will also cause
   * the window to be repositioned to satisfy the new constraint.
   * @param position A position constraint.
   */
  void set_position(WindowPosition position);

  
  /** Activates the current focused widget within the window.
   * @return <tt>true</tt> if a widget got activated.
   */
  bool activate_focus();

  
  /** If @a focus  is not the current focus widget, and is focusable, sets
   * it as the focus widget for the window. To set the focus to a particular
   * widget in the toplevel, it is usually more convenient to use
   * Gtk::Widget::grab_focus() instead of this function.
   * @param focus Widget to be the new focus widget.
   */
  void set_focus(Gtk::Widget& focus);
  void unset_focus();
  
  
  /** Retrieves the current focused widget within the window.
   * Note that this is the widget that would have the focus
   * if the toplevel window focused; if the toplevel window
   * is not focused then  <tt>GTK_WIDGET_HAS_FOCUS (widget)</tt> will
   * not be <tt>true</tt> for the widget.
   * @return The currently focused widget, or <tt>0</tt> if there is none.
   */
  Widget* get_focus();
  
  /** Retrieves the current focused widget within the window.
   * Note that this is the widget that would have the focus
   * if the toplevel window focused; if the toplevel window
   * is not focused then  <tt>GTK_WIDGET_HAS_FOCUS (widget)</tt> will
   * not be <tt>true</tt> for the widget.
   * @return The currently focused widget, or <tt>0</tt> if there is none.
   */
  const Widget* get_focus() const;
  
  /** The default widget is the widget that's activated when the user
   * presses Enter in a dialog (for example). This function sets the default widget for a Gtk::Window. When setting
   * (rather than unsetting) the default widget it's generally easier to
   * call Gtk::Widget::grab_focus() on the widget. Before making a widget
   * the default widget, you must set the Gtk::CAN_DEFAULT flag on the
   * widget you'd like to make the default using GTK_WIDGET_SET_FLAGS().
   * @param default_widget Widget to be the default.
   */
  void set_default(Gtk::Widget& default_widget);
  void unset_default();
 
  
  /** Activates the default widget for the window, unless the current 
   * focused widget has been configured to receive the default action 
   * (see Gtk::RECEIVES_DEFAULT in Gtk::WidgetFlags), in which case the
   * focused widget is activated.
   * @return <tt>true</tt> if a widget got activated.
   */
  bool activate_default();

  
  /** Dialog windows should be set transient for the main application
   * window they were spawned from. This allows window managers to e.g. keep the
   * dialog on top of the main window, or center the dialog over the
   * main window. Gtk::Dialog::new_with_buttons() and other convenience
   * functions in GTK+ will sometimes call
   * set_transient_for() on your behalf.
   * 
   * On Windows, this function will and put the child window
   * on top of the parent, much as the window manager would have
   * done on X.
   * @param parent Parent window.
   */
  void set_transient_for(Window& parent);

  
  /** Fetches the transient parent for this window. See
   * set_transient_for().
   * @return The transient parent for this window, or <tt>0</tt>
   * if no transient parent has been set.
   */
  Window* get_transient_for();
  
  /** Fetches the transient parent for this window. See
   * set_transient_for().
   * @return The transient parent for this window, or <tt>0</tt>
   * if no transient parent has been set.
   */
  const Window* get_transient_for() const;

  
  /** By setting the type hint for the window, you allow the window
   * manager to decorate and handle the window in a way which is
   * suitable to the function of the window in your application.
   * 
   * This function should be called before the window becomes visible.
   * 
   * Gtk::Dialog::new_with_buttons() and other convenience functions in GTK+
   * will sometimes call set_type_hint() on your behalf.
   * @param hint The window type.
   */
  void set_type_hint(Gdk::WindowTypeHint hint);

  
  /** Gets the type hint for this window. See set_type_hint().
   * @return The type hint for @a window .
   */
  Gdk::WindowTypeHint get_type_hint() const;

  
  /** Windows may set a hint asking the desktop environment not to display
   * the window in the task bar. This function sets this hint.
   * 
   * Since: 2.2
   * @param setting <tt>true</tt> to keep this window from appearing in the task bar.
   */
  void set_skip_taskbar_hint(bool setting = true);
  
  /** Gets the value set by set_skip_taskbar_hint()
   * @return <tt>true</tt> if window shouldn't be in taskbar
   * 
   * Since: 2.2.
   */
  bool get_skip_taskbar_hint() const;

  
  /** Windows may set a hint asking the desktop environment not to display
   * the window in the pager. This function sets this hint.
   * (A "pager" is any desktop navigation tool such as a workspace
   * switcher that displays a thumbnail representation of the windows
   * on the screen.)
   * 
   * Since: 2.2
   * @param setting <tt>true</tt> to keep this window from appearing in the pager.
   */
  void set_skip_pager_hint(bool setting = true);
  
  /** Gets the value set by set_skip_pager_hint().
   * @return <tt>true</tt> if window shouldn't be in pager
   * 
   * Since: 2.2.
   */
  bool get_skip_pager_hint() const;

  
  void set_urgency_hint(bool setting = true);
  
  bool get_urgency_hint() const;

  //_WRAP_METHOD(void set_destroy_with_parent(bool setting = true), gtk_window_set_destroy_with_parent)
  // I don't that that this is ever a good thing for C++.murrayc.

  
  /** Returns whether the window will be destroyed with its transient parent. See
   * set_destroy_with_parent().
   * @return <tt>true</tt> if the window will be destroyed with its transient parent.
   */
  bool get_destroy_with_parent() const;
  // I don't that that this is ever a good thing for C++.murrayc.

  
  /** Sets whether the user can resize a window. Windows are user resizable
   * by default.
   * @param resizable <tt>true</tt> if the user can resize this window.
   */
  void set_resizable(bool resizable = true);

  
  /** Gets the value set by set_resizable().
   * @return <tt>true</tt> if the user can resize the window.
   */
  bool get_resizable() const;

  
  /** Window gravity defines the meaning of coordinates passed to
   * move(). See move() and Gdk::Gravity for
   * more details.
   * 
   * The default window gravity is Gdk::GRAVITY_NORTH_WEST which will
   * typically "do what you mean."
   * @param gravity Window gravity.
   */
  void set_gravity(Gdk::Gravity gravity);

  
  /** Gets the value set by set_gravity().
   * @return Window gravity.
   */
  Gdk::Gravity get_gravity() const;

  
  /** This function sets up hints about how a window can be resized by
   * the user.  You can set a minimum and maximum size; allowed resize
   * increments (e.g. for xterm, you can only resize by the size of a
   * character); aspect ratios; and more. See the Gdk::Geometry struct.
   * @param geometry_widget Widget the geometry hints will be applied to.
   * @param geometry Struct containing geometry information.
   * @param geom_mask Mask indicating which struct fields should be paid attention to.
   */
  void set_geometry_hints(Widget& geometry_widget,
                                       const Gdk::Geometry& geometry,
                                       Gdk::WindowHints geom_mask);

  
  /** Sets the Gdk::Screen where the @a window  is displayed; if
   * the window is already mapped, it will be unmapped, and
   * then remapped on the new screen.
   * 
   * Since: 2.2
   * @param screen A Gdk::Screen.
   */
  void set_screen(const Glib::RefPtr<Gdk::Screen>& screen);

  
  /** Returns the Gdk::Screen associated with @a window .
   * @return A Gdk::Screen.
   * 
   * Since: 2.2.
   */
  Glib::RefPtr<Gdk::Screen> get_screen();
  
  /** Returns the Gdk::Screen associated with @a window .
   * @return A Gdk::Screen.
   * 
   * Since: 2.2.
   */
  Glib::RefPtr<const Gdk::Screen> get_screen() const;


  /** (Note: this is a special-purpose function for the framebuffer port,
   * that causes GTK+ to draw its own window border. For most applications,
   * you want set_decorated() instead, which tells the window
   * manager whether to draw the window border.)
   * 
   * If this function is called on a window with setting of <tt>true</tt>, before
   * it is realized or showed, it will have a "frame" window around
   *  @a window -&gt;window, accessible in @a window -&gt;frame. Using the signal 
   * frame_event you can receive all events targeted at the frame.
   * 
   * This function is used by the linux-fb port to implement managed
   * windows, but it could concievably be used by X-programs that
   * want to do their own window decorations.
   * @param setting A boolean.
   */
  void set_has_frame(bool setting = true);

  
  /** Accessor for whether the window has a frame window exterior to
   *  @a window -&gt;window. Gets the value set by set_has_frame().
   * @return <tt>true</tt> if a frame has been added to the window
   * via set_has_frame().
   */
  bool get_has_frame() const;

  
  /** (Note: this is a special-purpose function intended for the framebuffer
   * port; see set_has_frame(). It will have no effect on the
   * window border drawn by the window manager, which is the normal
   * case when using the X&nbsp;%Window system.)
   * 
   * For windows with frames (see set_has_frame()) this function
   * can be used to change the size of the frame border.
   * @param left The width of the left border.
   * @param top The height of the top border.
   * @param right The width of the right border.
   * @param bottom The height of the bottom border.
   */
  void set_frame_dimensions(int left,  int top,
                                         int right, int bottom);

  
  /** (Note: this is a special-purpose function intended for the
   * framebuffer port; see set_has_frame(). It will not
   * return the size of the window border drawn by the window manager, which is the normal
   * case when using a windowing system.  See
   * gdk_window_get_frame_extents() to get the standard window border
   * extents.)
   * 
   * Retrieves the dimensions of the frame window for this toplevel.
   * See set_has_frame(), set_frame_dimensions().
   * @param left Location to store the width of the frame at the left.
   * @param top Location to store the height of the frame at the top.
   * @param right Location to store the width of the frame at the returns.
   * @param bottom Location to store the height of the frame at the bottom.
   */
  void get_frame_dimensions(int& left,  int& top,
                                         int& right, int& bottom) const;

  
  /** By default, windows are decorated with a title bar, resize
   * controls, etc.  Some window
   * managers allow GTK+ to disable these decorations, creating a
   * borderless window. If you set the decorated property to <tt>false</tt>
   * using this function, GTK+ will do its best to convince the window
   * manager not to decorate the window. Depending on the system, this
   * function may not have any effect when called on a window that is
   * already visible, so you should call it before calling gtk_window_show().
   * 
   * On Windows, this function always works, since there's no window manager
   * policy involved.
   * @param setting <tt>true</tt> to decorate the window.
   */
  void set_decorated(bool setting = true);
  
  /** Returns whether the window has been set to have decorations
   * such as a title bar via set_decorated().
   * @return <tt>true</tt> if the window has been set to have decorations.
   */
  bool get_decorated() const;


  /** Retrieves the list of icons set by set_icon_list().
   * The list is copied, but the reference count on each
   * member won't be incremented.
   * @return Copy of window's icon list.
   */
  Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> > get_icon_list();
  
  /** Retrieves the list of icons set by set_icon_list().
   * The list is copied, but the reference count on each
   * member won't be incremented.
   * @return Copy of window's icon list.
   */
  Glib::ListHandle< Glib::RefPtr<const Gdk::Pixbuf> > get_icon_list() const;

  
  /** Sets up the icon representing a Gtk::Window. The icon is used when
   * the window is minimized (also known as iconified).  Some window
   * managers or desktop environments may also place it in the window
   * frame, or display it in other contexts.
   * 
   * set_icon_list() allows you to pass in the same icon in
   * several hand-drawn sizes. The list should contain the natural sizes
   * your icon is available in; that is, don't scale the image before
   * passing it to GTK+. Scaling is postponed until the last minute,
   * when the desired final size is known, to allow best quality.
   * 
   * By passing several sizes, you may improve the final image quality
   * of the icon, by reducing or eliminating automatic image scaling.
   * 
   * Recommended sizes to provide: 16x16, 32x32, 48x48 at minimum, and
   * larger images (64x64, 128x128) if you have them.
   * 
   * See also set_default_icon_list() to set the icon
   * for all windows in your application in one go.
   * 
   * Note that transient windows (those who have been set transient for another
   * window using set_transient_for()) will inherit their
   * icon from their transient parent. So there's no need to explicitly
   * set the icon on transient windows.
   * @param list List of Gdk::Pixbuf.
   */
  void set_icon_list(const Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> >& list);

  
  /** Sets up the icon representing a Gtk::Window. This icon is used when
   * the window is minimized (also known as iconified).  Some window
   * managers or desktop environments may also place it in the window
   * frame, or display it in other contexts.
   * 
   * The icon should be provided in whatever size it was naturally
   * drawn; that is, don't scale the image before passing it to
   * GTK+. Scaling is postponed until the last minute, when the desired
   * final size is known, to allow best quality.
   * 
   * If you have your icon hand-drawn in multiple sizes, use
   * set_icon_list(). Then the best size will be used.
   * 
   * This function is equivalent to calling set_icon_list()
   * with a 1-element list.
   * 
   * See also set_default_icon_list() to set the icon
   * for all windows in your application in one go.
   * @param icon Icon image, or <tt>0</tt>.
   */
  void set_icon(const Glib::RefPtr<Gdk::Pixbuf>& icon);


  /** Sets the icon for the window.
   * 
   * This function is equivalent to calling set_icon()
   * with a pixbuf created by loading the image from @a filename .
   * @param filename Location of icon file.
   * @return <tt>true</tt> if setting the icon succeeded.
   * 
   * Since: 2.2.
   */
  bool set_icon_from_file(const std::string& filename);

  
  /** Gets the value set by set_icon() (or if you've
   * called set_icon_list(), gets the first icon in
   * the icon list).
   * @return Icon for window.
   */
  Glib::RefPtr<Gdk::Pixbuf> get_icon();
  
  /** Gets the value set by set_icon() (or if you've
   * called set_icon_list(), gets the first icon in
   * the icon list).
   * @return Icon for window.
   */
  Glib::RefPtr<const Gdk::Pixbuf> get_icon() const;

  
  /** Sets an icon list to be used as fallback for windows that haven't
   * had set_icon_list() called on them to set up a
   * window-specific icon list. This function allows you to set up the
   * icon for all windows in your app at once.
   * 
   * See set_icon_list() for more details.
   * @param list A list of Gdk::Pixbuf.
   */
  static void set_default_icon_list(
                   const Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> >& list);

  
  /** Gets the value set by Gtk::Window::set_default_icon_list().
   * @return Copy of default icon list.
   */
  static Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> > get_default_icon_list();
  
  
  /** Sets an icon to be used as fallback for windows that haven't
   * had set_icon_list() called on them from a file
   * on disk. Warns on failure if @a err  is <tt>0</tt>.
   * @param filename Location of icon file.
   * @return <tt>true</tt> if setting the icon succeeded.
   * 
   * Since: 2.2.
   */
  static bool set_default_icon_from_file(const std::string& filename);
  
  /** By default, after showing the first Gtk::Window for each Gdk::Screen,
   * GTK+ calls gdk_screen_notify_startup_complete().  Call this
   * function to disable the automatic startup notification. You might
   * do this if your first window is a splash screen, and you want to
   * delay notification until after your real main window has been
   * shown, for example.
   * 
   * In that example, you would disable startup notification
   * temporarily, show your splash screen, then re-enable it so that
   * showing the main window would automatically result in notification.
   * 
   * Since: 2.2
   * @param setting <tt>true</tt> to automatically do startup notification.
   */
  static void set_auto_startup_notification(bool setting = true);

  
  /** Sets a window modal or non-modal. Modal windows prevent interaction
   * with other windows in the same application. To keep modal dialogs
   * on top of main application windows, use
   * set_transient_for() to make the dialog transient for the
   * parent; most window managers
   * will then disallow lowering the dialog below the parent.
   * @param modal Whether the window is modal.
   */
  void set_modal(bool modal = true);

  
  /** Returns whether the window is modal. See set_modal().
   * @return <tt>true</tt> if the window is set to be modal and
   * establishes a grab when shown.
   */
  bool get_modal() const;


  /** Returns a list of all existing toplevel windows. The widgets
   * in the list are not individually referenced. If you want
   * to iterate through the list and perform actions involving
   * callbacks that might destroy the widgets, you <em>must</em> call
   * <tt>g_list_foreach (result, (GFunc)g_object_ref, <tt>0</tt>)</tt> first, and
   * then unref all the widgets afterwards.
   * @return List of toplevel widgets.
   */
  static Glib::ListHandle<Window*> list_toplevels();


  /** Adds a mnemonic to this window.
   * @param keyval The mnemonic.
   * @param target The widget that gets activated by the mnemonic.
   */
  void add_mnemonic(guint keyval, Widget& target);

  
  /** Removes a mnemonic from this window.
   * @param keyval The mnemonic.
   * @param target The widget that gets activated by the mnemonic.
   */
  void remove_mnemonic(guint keyval, Widget& target);

  
  /** Activates the targets associated with the mnemonic.
   * @param keyval The mnemonic.
   * @param modifier The modifiers.
   * @return <tt>true</tt> if the activation is done.
   */
  bool mnemonic_activate(guint keyval, Gdk::ModifierType modifier);

  
  /** Sets the mnemonic modifier for this window.
   * @param modifier The modifier mask used to activate
   * mnemonics on this window.
   */
  void set_mnemonic_modifier(Gdk::ModifierType modifier);

  
  /** Returns the mnemonic modifier for this window. See
   * set_mnemonic_modifier().
   * @return The modifier mask used to activate
   * mnemonics on this window.
   */
  Gdk::ModifierType get_mnemonic_modifier();


  /** Presents a window to the user. This may mean raising the window
   * in the stacking order, deiconifying it, moving it to the current
   * desktop, and/or giving it the keyboard focus, possibly dependent
   * on the user's platform, window manager, and preferences.
   * 
   * If @a window  is hidden, this function calls Gtk::Widget::show()
   * as well.
   * 
   * This function should be used when the user tries to open a window
   * that's already open. Say for example the preferences dialog is
   * currently open, and the user chooses Preferences from the menu
   * a second time; use present() to move the already-open dialog
   * where the user can see it.
   */
  void present();
  
  void present(guint32 timestamp);

  
  /** Asks to iconify (i.e.\ minimize) the specified @a window . Note that
   * you shouldn't assume the window is definitely iconified afterward,
   * because other entities (e.g. the user or window manager) could deiconify it
   * again, or there may not be a window manager in which case
   * iconification isn't possible, etc. But normally the window will end
   * up iconified. Just don't write code that crashes if not.
   * 
   * It's permitted to call this function before showing a window,
   * in which case the window will be iconified before it ever appears
   * onscreen.
   * 
   * You can track iconification via the "window_state_event" signal
   * on Gtk::Widget.
   */
  void iconify();
  
  /** Asks to deiconify (i.e.\ unminimize) the specified @a window . Note
   * that you shouldn't assume the window is definitely deiconified
   * afterward, because other entities (e.g. the user or window manager) could iconify it
   * again before your code which assumes deiconification gets to run.
   * 
   * You can track iconification via the "window_state_event" signal
   * on Gtk::Widget.
   */
  void deiconify();

  
  /** Asks to stick @a window , which means that it will appear on all user
   * desktops. Note that you shouldn't assume the window is definitely
   * stuck afterward, because other entities (e.g. the user or window manager) could unstick it
   * again, and some window managers do not support sticking
   * windows. But normally the window will end up stuck. Just don't
   * write code that crashes if not.
   * 
   * It's permitted to call this function before showing a window.
   * 
   * You can track stickiness via the "window_state_event" signal
   * on Gtk::Widget.
   */
  void stick();
  
  /** Asks to unstick @a window , which means that it will appear on only
   * one of the user's desktops. Note that you shouldn't assume the
   * window is definitely unstuck afterward, because other entities
   * (e.g. the user or window
   * manager) could stick it again. But normally the window will
   * end up stuck. Just don't write code that crashes if not.
   * 
   * You can track stickiness via the "window_state_event" signal
   * on Gtk::Widget.
   */
  void unstick();

  
  /** Asks to maximize @a window , so that it becomes full-screen. Note that
   * you shouldn't assume the window is definitely maximized afterward,
   * because other entities (e.g. the user or window manager) could unmaximize it
   * again, and not all window managers support maximization. But
   * normally the window will end up maximized. Just don't write code
   * that crashes if not.
   * 
   * It's permitted to call this function before showing a window,
   * in which case the window will be maximized when it appears onscreen
   * initially.
   * 
   * You can track maximization via the "window_state_event" signal
   * on Gtk::Widget.
   */
  void maximize();
  
  /** Asks to unmaximize @a window . Note that you shouldn't assume the
   * window is definitely unmaximized afterward, because other entities
   * (e.g. the user or window
   * manager) could maximize it again, and not all window
   * managers honor requests to unmaximize. But normally the window will
   * end up unmaximized. Just don't write code that crashes if not.
   * 
   * You can track maximization via the "window_state_event" signal
   * on Gtk::Widget.
   */
  void unmaximize();

  
  /** Asks to place @a window  in the fullscreen state. Note that you
   * shouldn't assume the window is definitely full screen afterward,
   * because other entities (e.g. the user or window manager) could unfullscreen it
   * again, and not all window managers honor requests to fullscreen
   * windows. But normally the window will end up fullscreen. Just
   * don't write code that crashes if not.
   * 
   * You can track the fullscreen state via the "window_state_event" signal
   * on Gtk::Widget.
   * 
   * Since: 2.2
   */
  void fullscreen();
  
  /** Asks to toggle off the fullscreen state for @a window . Note that you
   * shouldn't assume the window is definitely not full screen
   * afterward, because other entities (e.g. the user or window manager) could fullscreen it
   * again, and not all window managers honor requests to unfullscreen
   * windows. But normally the window will end up restored to its normal
   * state. Just don't write code that crashes if not.
   * 
   * You can track the fullscreen state via the "window_state_event" signal
   * on Gtk::Widget.
   * 
   * Since: 2.2
   */
  void unfullscreen();
        
  
  /** Starts resizing a window. This function is used if an application
   * has window resizing controls. When GDK can support it, the resize
   * will be done using the standard mechanism for the window manager or windowing
   * system. Otherwise, GDK will try to emulate window resizing,
   * potentially not all that well, depending on the windowing system.
   * @param button Mouse button that initiated the drag.
   * @param edge Position of the resize control.
   * @param root_x X position where the user clicked to initiate the drag, in root window coordinates.
   * @param root_y Y position where the user clicked to initiate the drag.
   * @param timestamp Timestamp from the click event that initiated the drag.
   */
  void begin_resize_drag(Gdk::WindowEdge edge,
                   int button, int root_x, int root_y, guint32 timestamp);

  
  /** Starts moving a window. This function is used if an application has
   * window movement grips. When GDK can support it, the window movement
   * will be done using the standard mechanism for the window manager or windowing
   * system. Otherwise, GDK will try to emulate window movement,
   * potentially not all that well, depending on the windowing system.
   * @param button Mouse button that initiated the drag.
   * @param root_x X position where the user clicked to initiate the drag, in root window coordinates.
   * @param root_y Y position where the user clicked to initiate the drag.
   * @param timestamp Timestamp from the click event that initiated the drag.
   */
  void begin_move_drag(
                   int button, int root_x, int root_y, guint32 timestamp);

  
  /** Sets the default size of a window. If the window's "natural" size
   * (its size request) is larger than the default, the default will be
   * ignored. More generally, if the default size does not obey the
   * geometry hints for the window (set_geometry_hints() can
   * be used to set these explicitly), the default size will be clamped
   * to the nearest permitted size.
   * 
   * Unlike Gtk::Widget::set_size_request(), which sets a size request for
   * a widget and thus would keep users from shrinking the window, this
   * function only sets the initial size, just as if the user had
   * resized the window themselves. Users can still shrink the window
   * again as they normally would. Setting a default size of -1 means to
   * use the "natural" default size (the size request of the window).
   * 
   * For more control over a window's initial size and how resizing works,
   * investigate set_geometry_hints().
   * 
   * For some uses, resize() is a more appropriate function.
   * resize() changes the current size of the window, rather
   * than the size to be used on initial display. resize() always
   * affects the window itself, not the geometry widget.
   * 
   * The default size of a window only affects the first time a window is
   * shown; if a window is hidden and re-shown, it will remember the size
   * it had prior to hiding, rather than using the default size.
   * 
   * Windows can't actually be 0x0 in size, they must be at least 1x1, but
   * passing 0 for @a width  and @a height  is OK, resulting in a 1x1 default size.
   * @param width Width in pixels, or -1 to unset the default width.
   * @param height Height in pixels, or -1 to unset the default height.
   */
  void set_default_size(int width, int height);

  
  /** Gets the default size of the window. A value of -1 for the width or
   * height indicates that a default size has not been explicitly set
   * for that dimension, so the "natural" size of the window will be
   * used.
   * @param width Location to store the default width.
   * @param height Location to store the default height.
   */
  void get_default_size(int& width, int& height) const;

  
  /** Resizes the window as if the user had done so, obeying geometry
   * constraints. The default geometry constraint is that windows may
   * not be smaller than their size request; to override this
   * constraint, call Gtk::Widget::set_size_request() to set the window's
   * request to a smaller value.
   * 
   * If resize() is called before showing a window for the
   * first time, it overrides any default size set with
   * set_default_size().
   * 
   * Windows may not be resized smaller than 1 by 1 pixels.
   * @param width Width in pixels to resize the window to.
   * @param height Height in pixels to resize the window to.
   */
  void resize(int width, int height);

  
  /** Obtains the current size of @a window . If @a window  is not onscreen,
   * it returns the size GTK+ will suggest to the window manager for the initial window
   * size (but this is not reliably the same as the size the window
   * manager will actually select). The size obtained by
   * get_size() is the last size received in a
   * Gdk::EventConfigure, that is, GTK+ uses its locally-stored size,
   * rather than querying the X server for the size. As a result, if you
   * call resize() then immediately call
   * get_size(), the size won't have taken effect yet. After
   * the window manager processes the resize request, GTK+ receives
   * notification that the size has changed via a configure event, and
   * the size of the window gets updated.
   * 
   * @note Nearly any use of this function creates a race condition,
   * because the size of the window may change between the time that you
   * get the size and the time that you perform some action assuming
   * that size is the current size. To avoid race conditions, connect to
   * "configure_event" on the window and adjust your size-dependent
   * state to match the size delivered in the Gdk::EventConfigure.
   * 
   * @note The returned size does <em>not</em> include the
   * size of the window manager decorations (aka the window frame or
   * border). Those are not drawn by GTK+ and GTK+ has no reliable
   * method of determining their size.
   * 
   * @note If you are getting a window size in order to position
   * the window onscreen, there may be a better way. The preferred
   * way is to simply set the window's semantic type with
   * set_type_hint(), which allows the window manager to
   * e.g. center dialogs. Also, if you set the transient parent of
   * dialogs with set_transient_for() window managers
   * will often center the dialog over its parent window. It's
   * much preferred to let the window manager handle these
   * things rather than doing it yourself, because all apps will
   * behave consistently and according to user prefs if the window
   * manager handles it. Also, the window manager can take the size
   * of the window decorations/border into account, while your
   * application cannot.
   * 
   * In any case, if you insist on application-specified window
   * positioning, there's <em>still</em> a better way than
   * doing it yourself - set_position() will frequently
   * handle the details for you.
   * @param width Return location for width.
   * @param height Return location for height.
   */
  void get_size(int& width, int& height) const;


  /** Asks the window manager to move
   *  @a window  to the given position.  %Window managers are free to ignore
   * this; most window managers ignore requests for initial window
   * positions (instead using a user-defined placement algorithm) and
   * honor requests after the window has already been shown.
   * 
   * @note the position is the position of the gravity-determined
   * reference point for the window. The gravity determines two things:
   * first, the location of the reference point in root window
   * coordinates; and second, which point on the window is positioned at
   * the reference point.
   * 
   * By default the gravity is Gdk::GRAVITY_NORTH_WEST, so the reference
   * point is simply the @a x , @a y  supplied to move(). The
   * top-left corner of the window decorations (aka window frame or
   * border) will be placed at @a x , @a y .  Therefore, to position a window
   * at the top left of the screen, you want to use the default gravity
   * (which is Gdk::GRAVITY_NORTH_WEST) and move the window to 0,0.
   * 
   * To position a window at the bottom right corner of the screen, you
   * would set Gdk::GRAVITY_SOUTH_EAST, which means that the reference
   * point is at @a x  + the window width and @a y  + the window height, and
   * the bottom-right corner of the window border will be placed at that
   * reference point. So, to place a window in the bottom right corner
   * you would first set gravity to south east, then write:
   * <tt>gtk_window_move (window, gdk_screen_width() - window_width,
   * gdk_screen_height() - window_height)</tt>.
   * 
   * The Extended Window Manager Hints specification at 
   * http://www.freedesktop.org/standards/wm-spec has a 
   * nice table of gravities in the "implementation notes" section.
   * 
   * The get_position() documentation may also be relevant.
   * @param x X coordinate to move window to.
   * @param y Y coordinate to move window to.
   */
  void move(int x, int y);

  
  /** This function returns the position you need to pass to
   * move() to keep @a window  in its current position.  This
   * means that the meaning of the returned value varies with window
   * gravity. See move() for more details.
   * 
   * If you haven't changed the window gravity, its gravity will be
   * Gdk::GRAVITY_NORTH_WEST. This means that get_position()
   * gets the position of the top-left corner of the window manager
   * frame for the window. move() sets the position of this
   * same top-left corner.
   * 
   * get_position() is not 100% reliable because the X&nbsp;%Window System
   * does not specify a way to obtain the geometry of the
   * decorations placed on a window by the window manager.
   * Thus GTK+ is using a "best guess" that works with most
   * window managers.
   * 
   * Moreover, nearly all window managers are historically broken with
   * respect to their handling of window gravity. So moving a window to
   * its current position as returned by get_position() tends
   * to result in moving the window slightly. %Window managers are
   * slowly getting better over time.
   * 
   * If a window has gravity Gdk::GRAVITY_STATIC the window manager
   * frame is not relevant, and thus get_position() will
   * always produce accurate results. However you can't use static
   * gravity to do things like place a window in a corner of the screen,
   * because static gravity ignores the window manager decorations.
   * 
   * If you are saving and restoring your application's window
   * positions, you should know that it's impossible for applications to
   * do this without getting it somewhat wrong because applications do
   * not have sufficient knowledge of window manager state. The Correct
   * Mechanism is to support the session management protocol (see the
   * "GnomeClient" object in the GNOME libraries for example) and allow
   * the window manager to save your window sizes and positions.
   * @param root_x Return location for X coordinate of gravity-determined reference point.
   * @param root_y Return location for Y coordinate of gravity-determined reference point.
   */
  void get_position(int& root_x, int& root_y) const;

  
  /** Parses a standard X&nbsp;%Window System geometry string - see the
   * manual page for X (type 'man X') for details on this.
   * parse_geometry() does work on all GTK+ ports
   * including Win32 but is primarily intended for an X environment.
   * 
   * If either a size or a position can be extracted from the
   * geometry string, parse_geometry() returns <tt>true</tt>
   * and calls set_default_size() and/or move()
   * to resize/move the window.
   * 
   * If parse_geometry() returns <tt>true</tt>, it will also
   * set the Gdk::HINT_USER_POS and/or Gdk::HINT_USER_SIZE hints
   * indicating to the window manager that the size/position of
   * the window was user-specified. This causes most window
   * managers to honor the geometry.
   * 
   * Note that for parse_geometry() to work as expected, it has
   * to be called when the window has its "final" size, i.e. after calling
   * Gtk::Widget::show_all() on the contents and set_geometry_hints()
   * on the window.
   * 
   * @code
   * int
   * main (int argc, char *argv[])
   * {
   * GtkWidget *window, vbox;
   * GdkGeometry size_hints;
   * 
   * gtk_init (&amp;argc, &amp;argv);
   * 
   * window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   * vbox = gtk_vbox_new (<tt>false</tt>, 0);
   * 
   * gtk_container_add (GTK_CONTAINER (window), vbox);
   * fill_with_content (vbox);
   * gtk_widget_show_all (vbox);
   * 
   * size_hints = {
   * 100, 50, 0, 0, 100, 50, 10, 10, 0.0, 0.0, GDK_GRAVITY_NORTH_WEST  
   * };
   * 
   * gtk_window_set_geometry_hints (GTK_WINDOW (window),
   * window,
   * &amp;size_hints,
   * GDK_HINT_MIN_SIZE | 
   * GDK_HINT_BASE_SIZE | 
   * GDK_HINT_RESIZE_INC);
   * 
   * if (argc &gt; 1)
   * {
   * if (!gtk_window_parse_geometry (GTK_WINDOW (window), argv[1]))
   * fprintf (stderr, "Failed to parse '&percnt;s'<tt>\\n</tt>", argv[1]);
   * }
   * 
   * gtk_widget_show_all (window);
   * gtk_main();
   * 
   * return 0;
   * }
   * @endcode
   * @param geometry Geometry string.
   * @return <tt>true</tt> if string was parsed successfully.
   */
  bool parse_geometry(const Glib::ustring& geometry);

  
  /** Hides @a window , then reshows it, resetting the
   * default size and position of the window. Used
   * by GUI builders only.
   */
  void reshow_with_initial_size();


  /** Sets an icon to be used as fallback for windows that haven't
   * had set_icon() called on them from a pixbuf.
   * 
   * Since: 2.4
   * @param icon The icon.
   */
  static void set_default_icon(const Glib::RefPtr<Gdk::Pixbuf>& icon);
  
  /** Asks to keep @a window  above, so that it stays on top. Note that
   * you shouldn't assume the window is definitely above afterward,
   * because other entities (e.g. the user or window manager) could not keep it above,
   * and not all window managers support keeping windows above. But
   * normally the window will end kept above. Just don't write code
   * that crashes if not.
   * 
   * It's permitted to call this function before showing a window,
   * in which case the window will be kept above when it appears onscreen
   * initially.
   * 
   * You can track the above state via the "window_state_event" signal
   * on Gtk::Widget.
   * 
   * Note that, according to the Extended Window Manager Hints
   * specification, the above state is mainly meant for user preferences and should not be used 
   * by applications e.g. for drawing attention to their dialogs.
   * 
   * Since: 2.4
   * @param setting Whether to keep @a window  above other windows.
   */
  void set_keep_above(bool setting = true);
  
  /** Asks to keep @a window  below, so that it stays in bottom. Note that
   * you shouldn't assume the window is definitely below afterward,
   * because other entities (e.g. the user or window manager) could not keep it below,
   * and not all window managers support putting windows below. But
   * normally the window will be kept below. Just don't write code
   * that crashes if not.
   * 
   * It's permitted to call this function before showing a window,
   * in which case the window will be kept below when it appears onscreen
   * initially.
   * 
   * You can track the below state via the "window_state_event" signal
   * on Gtk::Widget.
   * 
   * Note that, according to the Extended Window Manager Hints
   * specification, the above state is mainly meant for user preferences and should not be used 
   * by applications e.g. for drawing attention to their dialogs.
   * 
   * Since: 2.4
   * @param setting Whether to keep @a window  below other windows.
   */
  void set_keep_below(bool setting = true);

  
  /** Returns a default accel group for this window
   * This is a gtkmm-specific function.  This accel group can not
   * be removed.
   */
  Glib::RefPtr<AccelGroup> get_accel_group();

  /** Brings the window to the front.
   * This is just a more obvious convenience wrapper for get_window()->raise().
   */
  virtual void raise();

  ///Overriden to warn that it doesn't make sense to use Gtk::manage() on this class because it has no parent container.
  virtual void set_manage();

protected:

  //See comments in the implementations:
  void destroy_();
  void _destroy_c_instance();

private:

  //We'll create an accel_group if it's requested, and remember it.
  //Otherwise, you'd have to create it, add it to the window, then remember it somewhere else while you add it to other widgets.
  Glib::RefPtr<AccelGroup> accel_group_;


};


class WindowGroup : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef WindowGroup CppObjectType;
  typedef WindowGroup_Class CppClassType;
  typedef GtkWindowGroup BaseObjectType;
  typedef GtkWindowGroupClass BaseClassType;

private:  friend class WindowGroup_Class;
  static CppClassType windowgroup_class_;

private:
  // noncopyable
  WindowGroup(const WindowGroup&);
  WindowGroup& operator=(const WindowGroup&);

protected:
  explicit WindowGroup(const Glib::ConstructParams& construct_params);
  explicit WindowGroup(GtkWindowGroup* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~WindowGroup();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkWindowGroup*       gobj()       { return reinterpret_cast<GtkWindowGroup*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkWindowGroup* gobj() const { return reinterpret_cast<GtkWindowGroup*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkWindowGroup* gobj_copy();

private:


protected:
  WindowGroup();

public:
  
  static Glib::RefPtr<WindowGroup> create();


  /** Adds a window to a Gtk::WindowGroup.
   * @param window The Gtk::Window to add.
   */
  void add_window(Window& window);
  
  /** Removes a window from a Gtk::WindowGroup.
   * @param window The Gtk::Window to remove.
   */
  void remove_window(Window& window);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::Window
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gtk::Window* wrap(GtkWindow* object, bool take_copy = false);
}

namespace Glib
{
  /** @relates Gtk::WindowGroup
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gtk::WindowGroup> wrap(GtkWindowGroup* object, bool take_copy = false);
}


#endif /* _GTKMM_WINDOW_H */

