# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work envronment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=gtk+
VER=2.16.0
REV=2
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usehead
usemingw64
usemsvs9x64

(

set -x

DEPS=`latest --arch=${ARCH} glib atk cairo pango libpng zlib libtiff jpeg`
PROXY_LIBINTL=`latest --arch=${ARCH} proxy-libintl`


PKG_CONFIG_PATH=
for D in $DEPS; do
    [ -d /devel/dist/${ARCH}/$D/lib/pkgconfig ] && PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/lib/pkgconfig:$PKG_CONFIG_PATH
done

LIBPNG=`latest --arch=${ARCH} libpng`
ZLIB=`latest --arch=${ARCH} zlib`
LIBTIFF=`latest --arch=${ARCH} libtiff`
JPEG=`latest --arch=${ARCH} jpeg`

# Don't do any relinking crap in libtool.

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Brute force solution for problems with libtool

patch -p0 <<'EOF'
--- configure
+++ configure
@@ -5595,16 +5595,8 @@
   ;;
 
 mingw* | pw32*)
-  # Base MSYS/MinGW do not provide the 'file' command needed by
-  # func_win32_libid shell function, so use a weaker test based on 'objdump',
-  # unless we find 'file', for example because we are cross-compiling.
-  if ( file / ) >/dev/null 2>&1; then
-    lt_cv_deplibs_check_method='file_magic ^x86 archive import|^x86 DLL'
-    lt_cv_file_magic_cmd='func_win32_libid'
-  else
-    lt_cv_deplibs_check_method='file_magic file format pei*-i386(.*architecture: i386)?'
-    lt_cv_file_magic_cmd='$OBJDUMP -f'
-  fi
+  # Screw this. Just use pass_all. --tml
+  lt_cv_deplibs_check_method=pass_all
   ;;
 
 cegcc)
EOF

patch -p0 <<'EOF'
--- gdk/win32/gdkevents-win32.c	(revision 22567)
+++ gdk/win32/gdkevents-win32.c	(revision 22568)
@@ -3253,16 +3253,16 @@
       break;
 
     case WM_WINDOWPOSCHANGED:
-      GDK_NOTE (EVENTS, (windowpos = (WINDOWPOS *) msg->lParam,
-			 g_print (" %s %s %dx%d@%+d%+d",
-				  _gdk_win32_window_pos_bits_to_string (windowpos->flags),
-				  (windowpos->hwndInsertAfter == HWND_BOTTOM ? "BOTTOM" :
-				   (windowpos->hwndInsertAfter == HWND_NOTOPMOST ? "NOTOPMOST" :
-				    (windowpos->hwndInsertAfter == HWND_TOP ? "TOP" :
-				     (windowpos->hwndInsertAfter == HWND_TOPMOST ? "TOPMOST" :
-				      (sprintf (buf, "%p", windowpos->hwndInsertAfter),
-				       buf))))),
-				  windowpos->cx, windowpos->cy, windowpos->x, windowpos->y)));
+      windowpos = (WINDOWPOS *) msg->lParam;
+      GDK_NOTE (EVENTS, g_print (" %s %s %dx%d@%+d%+d",
+				 _gdk_win32_window_pos_bits_to_string (windowpos->flags),
+				 (windowpos->hwndInsertAfter == HWND_BOTTOM ? "BOTTOM" :
+				  (windowpos->hwndInsertAfter == HWND_NOTOPMOST ? "NOTOPMOST" :
+				   (windowpos->hwndInsertAfter == HWND_TOP ? "TOP" :
+				    (windowpos->hwndInsertAfter == HWND_TOPMOST ? "TOPMOST" :
+				     (sprintf (buf, "%p", windowpos->hwndInsertAfter),
+				      buf))))),
+				 windowpos->cx, windowpos->cy, windowpos->x, windowpos->y));
 
       /* If position and size haven't changed, don't do anything */
       if (_sizemove_in_progress &&
--- gtk/gtkprintoperation-win32.c
+++ gtk/gtkprintoperation-win32.c
@@ -72,7 +72,7 @@
 
 static const GUID myIID_IPrintDialogCallback  = {0x5852a2c3,0x6530,0x11d1,{0xb6,0xa3,0x0,0x0,0xf8,0x75,0x7b,0xf9}};
 
-#if !defined (_MSC_VER) && !defined (MINGW64)
+#if !defined (_MSC_VER) && !defined (MINGW64) && !defined (__MINGW64)
 #undef INTERFACE
 #define INTERFACE IPrintDialogCallback
 DECLARE_INTERFACE_ (IPrintDialogCallback, IUnknown)
EOF

CC='x86_64-pc-mingw32-gcc' CPPFLAGS="-I/devel/dist/${ARCH}/${LIBPNG}/include -I/devel/dist/${ARCH}/${ZLIB}/include -I/devel/dist/${ARCH}/${LIBTIFF}/include -I/devel/dist/${ARCH}/${JPEG}/include -I/devel/dist/${ARCH}/${PROXY_LIBINTL}/include" LDFLAGS="-L/devel/dist/${ARCH}/${LIBPNG}/lib -L/devel/dist/${ARCH}/${ZLIB}/lib -L/devel/dist/${ARCH}/${LIBTIFF}/lib -L/devel/dist/${ARCH}/${JPEG}/lib -L/devel/dist/${ARCH}/${PROXY_LIBINTL}/lib -Wl,--exclude-libs=libintl.a -Wl,--enable-auto-image-base" LIBS=-lintl CFLAGS=-O2 ./configure --host=x86_64-pc-mingw32 --with-gdktarget=win32 --disable-gdiplus --with-included-loaders --with-included-immodules --without-libjasper --enable-debug=yes --enable-explicit-deps=no --disable-gtk-doc --disable-static --prefix=$TARGET &&
libtoolcacheize &&
rm gtk/gtk.def &&
(make -j3 install || (rm .libtool-cache* && make -j3 install)) &&

./gtk-zip.sh &&

mv /tmp/${MOD}-${VER}.zip /tmp/$RUNZIP &&
mv /tmp/${MOD}-dev-${VER}.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
