# This is a shell script that is sourced, not executed. It uses
# functions and scripts from tml@iki.fi's work envronment and is included
# only for reference

MOD=pixman
VER=0.12.0
REV=1
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usemingw64

(

set -x

patch --verbose -p0 <<'EOF'
--- configure
+++ configure
@@ -19777,7 +19777,7 @@
 echo $ECHO_N "checking for -fvisibility... $ECHO_C" >&6; }
 cat >conftest.$ac_ext <<_ACEOF
 
-#if defined(__GNUC__) && (__GNUC__ >= 4)
+#if !defined(_WIN32) && defined(__GNUC__) && (__GNUC__ >= 4)
 #else
 error Need GCC 4.0 for visibility
 #endif
--- pixman/pixman-private.h
+++ pixman/pixman-private.h
@@ -6,6 +6,7 @@
 #define PIXMAN_PRIVATE_H
 
 #include "pixman.h"
+#include <stdint.h>
 #include <time.h>
 
 #ifndef FALSE
@@ -421,19 +421,19 @@
     }

 #if IMAGE_BYTE_ORDER == MSBFirst
-#define Fetch24(img, a)  ((unsigned long) (a) & 1 ?	      \
+#define Fetch24(img, a)  ((uintptr_t) (a) & 1 ?	      \
     ((READ(img, a) << 16) | READ(img, (uint16_t *) ((a)+1))) : \
     ((READ(img, (uint16_t *) (a)) << 8) | READ(img, (a)+2)))
-#define Store24(img,a,v) ((unsigned long) (a) & 1 ? \
+#define Store24(img,a,v) ((uintptr_t) (a) & 1 ? \
     (WRITE(img, a, (uint8_t) ((v) >> 16)),		  \
      WRITE(img, (uint16_t *) ((a)+1), (uint16_t) (v))) :  \
     (WRITE(img, (uint16_t *) (a), (uint16_t) ((v) >> 8)), \
      WRITE(img, (a)+2, (uint8_t) (v))))
 #else
-#define Fetch24(img,a)  ((unsigned long) (a) & 1 ?			     \
+#define Fetch24(img,a)  ((uintptr_t) (a) & 1 ?			     \
     (READ(img, a) | (READ(img, (uint16_t *) ((a)+1)) << 8)) : \
     (READ(img, (uint16_t *) (a)) | (READ(img, (a)+2) << 16)))
-#define Store24(img,a,v) ((unsigned long) (a) & 1 ? \
+#define Store24(img,a,v) ((uintptr_t) (a) & 1 ? \
     (WRITE(img, a, (uint8_t) (v)),				\
      WRITE(img, (uint16_t *) ((a)+1), (uint16_t) ((v) >> 8))) : \
     (WRITE(img, (uint16_t *) (a), (uint16_t) (v)),		\
@@ -727,7 +727,7 @@
 				   uint16_t		height);
 
 /* GCC visibility */
-#if defined(__GNUC__) && __GNUC__ >= 4
+#if !defined(_WIN32) && defined(__GNUC__) && __GNUC__ >= 4
 #define PIXMAN_EXPORT __attribute__ ((visibility("default")))
 /* Sun Studio 8 visibility */
 #elif defined(__SUNPRO_C) && (__SUNPRO_C >= 0x550)
EOF

for F in pixman/pixman-{mmx,sse2}.c; do
    sed -e 's!(unsigned long)!(uintptr_t)!' <$F >$F.tmp && mv $F.tmp $F
done

CC='x86_64-pc-mingw32-gcc' CFLAGS=-O2 ./configure --host=x86_64-pc-mingw32 --disable-shared --prefix=c:/devel/target/$HEX &&
PATH=/devel/target/$HEX/bin:$PATH make install &&

rm -f /tmp/$RUNZIP /tmp/$DEVZIP &&

(cd /devel/target/$HEX &&

# I build pixman as a static library only, so the "run-time" package
# is actually empty. I create it here anyway to be able to use some
# scripts that assume each library has both a run-time and developer
# version.

zip /tmp/$RUNZIP nul &&
zip -d /tmp/$RUNZIP nul &&
zip -r -D /tmp/$DEVZIP include/pixman-1 &&
zip /tmp/$DEVZIP lib/libpixman-1.a &&
zip -r -D /tmp/$DEVZIP lib/pkgconfig

)

) 2>&1 | tee /devel/src/tml/make/$THIS.log &&

(cd /devel && zip /tmp/$DEVZIP src/tml/make/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
