# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=libtiff
VER=3.9.2
REV=1
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev
usemsvs6

(

set -x

ZLIB=`latest --arch=${ARCH} zlib`
JPEG=`latest --arch=${ARCH} jpeg`

patch -p0 --verbose <<'EOF' &&
--- libtiff/Makefile.in
+++ libtiff/Makefile.in
@@ -515,7 +515,7 @@
 	  rm -f "$${dir}/so_locations"; \
 	done
 libtiff.la: $(libtiff_la_OBJECTS) $(libtiff_la_DEPENDENCIES) 
-	$(AM_V_CCLD)$(libtiff_la_LINK) -rpath $(libdir) $(libtiff_la_OBJECTS) $(libtiff_la_LIBADD) $(LIBS)
+	$(AM_V_CCLD)$(libtiff_la_LINK) -rpath $(libdir) -export-symbols libtiff.def $(libtiff_la_OBJECTS) $(libtiff_la_LIBADD) $(LIBS)
 libtiffxx.la: $(libtiffxx_la_OBJECTS) $(libtiffxx_la_DEPENDENCIES) 
 	$(AM_V_CXXLD)$(libtiffxx_la_LINK) $(am_libtiffxx_la_rpath) $(libtiffxx_la_OBJECTS) $(libtiffxx_la_LIBADD) $(LIBS)
 
--- libtiff/libtiff.def
+++ libtiff/libtiff.def
@@ -104,6 +104,7 @@
 	_TIFFmemset
 	_TIFFmemcpy
 	_TIFFmemcmp
+	_TIFFCheckMalloc
 	TIFFCreateDirectory
 	TIFFSetTagExtender
 	TIFFMergeFieldInfo
--- libtiff/tif_jpeg.c
+++ libtiff/tif_jpeg.c
@@ -289,20 +289,20 @@
 }
 
 static int
-TIFFjpeg_set_quality(JPEGState* sp, int quality, boolean force_baseline)
+TIFFjpeg_set_quality(JPEGState* sp, int quality, jpeg_boolean force_baseline)
 {
 	return CALLVJPEG(sp,
 	    jpeg_set_quality(&sp->cinfo.c, quality, force_baseline));
 }
 
 static int
-TIFFjpeg_suppress_tables(JPEGState* sp, boolean suppress)
+TIFFjpeg_suppress_tables(JPEGState* sp, jpeg_boolean suppress)
 {
 	return CALLVJPEG(sp, jpeg_suppress_tables(&sp->cinfo.c, suppress));
 }
 
 static int
-TIFFjpeg_start_compress(JPEGState* sp, boolean write_all_tables)
+TIFFjpeg_start_compress(JPEGState* sp, jpeg_boolean write_all_tables)
 {
 	return CALLVJPEG(sp,
 	    jpeg_start_compress(&sp->cinfo.c, write_all_tables));
@@ -335,7 +335,7 @@
 }
 
 static int
-TIFFjpeg_read_header(JPEGState* sp, boolean require_image)
+TIFFjpeg_read_header(JPEGState* sp, jpeg_boolean require_image)
 {
 	return CALLJPEG(sp, -1, jpeg_read_header(&sp->cinfo.d, require_image));
 }
@@ -403,7 +403,7 @@
 	sp->dest.free_in_buffer = (size_t) tif->tif_rawdatasize;
 }
 
-static boolean
+static jpeg_boolean
 std_empty_output_buffer(j_compress_ptr cinfo)
 {
 	JPEGState* sp = (JPEGState*) cinfo;
@@ -454,7 +454,7 @@
 	sp->dest.free_in_buffer = (size_t) sp->jpegtables_length;
 }
 
-static boolean
+static jpeg_boolean
 tables_empty_output_buffer(j_compress_ptr cinfo)
 {
 	JPEGState* sp = (JPEGState*) cinfo;
@@ -520,7 +520,7 @@
 	sp->src.bytes_in_buffer = (size_t) tif->tif_rawcc;
 }
 
-static boolean
+static jpeg_boolean
 std_fill_input_buffer(j_decompress_ptr cinfo)
 {
 	JPEGState* sp = (JPEGState* ) cinfo;
--- libtiff/tif_ojpeg.c
+++ libtiff/tif_ojpeg.c
@@ -383,9 +383,9 @@
 static void OJPEGLibjpegJpegErrorMgrOutputMessage(jpeg_common_struct* cinfo);
 static void OJPEGLibjpegJpegErrorMgrErrorExit(jpeg_common_struct* cinfo);
 static void OJPEGLibjpegJpegSourceMgrInitSource(jpeg_decompress_struct* cinfo);
-static boolean OJPEGLibjpegJpegSourceMgrFillInputBuffer(jpeg_decompress_struct* cinfo);
+static jpeg_boolean OJPEGLibjpegJpegSourceMgrFillInputBuffer(jpeg_decompress_struct* cinfo);
 static void OJPEGLibjpegJpegSourceMgrSkipInputData(jpeg_decompress_struct* cinfo, long num_bytes);
-static boolean OJPEGLibjpegJpegSourceMgrResyncToRestart(jpeg_decompress_struct* cinfo, int desired);
+static jpeg_boolean OJPEGLibjpegJpegSourceMgrResyncToRestart(jpeg_decompress_struct* cinfo, int desired);
 static void OJPEGLibjpegJpegSourceMgrTermSource(jpeg_decompress_struct* cinfo);
 
 int
@@ -2380,7 +2380,7 @@
 	(void)cinfo;
 }
 
-static boolean
+static jpeg_boolean
 OJPEGLibjpegJpegSourceMgrFillInputBuffer(jpeg_decompress_struct* cinfo)
 {
 	TIFF* tif=(TIFF*)cinfo->client_data;
@@ -2406,7 +2406,7 @@
 	jpeg_encap_unwind(tif);
 }
 
-static boolean
+static jpeg_boolean
 OJPEGLibjpegJpegSourceMgrResyncToRestart(jpeg_decompress_struct* cinfo, int desired)
 {
 	TIFF* tif=(TIFF*)cinfo->client_data;
EOF

lt_cv_deplibs_check_method='pass_all' \
CC='gcc -mtune=pentium3 -mthreads' \
CFLAGS=-O2 \
./configure \
--with-zlib-include-dir=/devel/dist/${ARCH}/${ZLIB}/include \
--with-zlib-lib-dir=/devel/dist/${ARCH}/${ZLIB}/lib \
--with-jpeg-include-dir=/devel/dist/${ARCH}/${JPEG}/include \
--with-jpeg-lib-dir=/devel/dist/${ARCH}/${JPEG}/lib \
--disable-static \
--prefix=$TARGET &&

make -j3 install &&

rm -f /tmp/$RUNZIP /tmp/$DEVZIP &&

cd /devel/target/$HEX &&
zip /tmp/$RUNZIP bin/*.dll &&
zip /tmp/$DEVZIP bin/*.exe &&
zip /tmp/$DEVZIP lib/*.dll.a &&
zip -r -D /tmp/$DEVZIP include share

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
