/* rygel-media-export-media-cache-upgrader.c generated by valac 0.18.0.2-2c22, the Vala compiler
 * generated from rygel-media-export-media-cache-upgrader.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <sqlite3.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER (rygel_media_export_media_cache_upgrader_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))

typedef struct _RygelMediaExportMediaCacheUpgrader RygelMediaExportMediaCacheUpgrader;
typedef struct _RygelMediaExportMediaCacheUpgraderClass RygelMediaExportMediaCacheUpgraderClass;
typedef struct _RygelMediaExportMediaCacheUpgraderPrivate RygelMediaExportMediaCacheUpgraderPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER (rygel_media_export_sqlite_wrapper_get_type ())
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapper))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))

typedef struct _RygelMediaExportSqliteWrapper RygelMediaExportSqliteWrapper;
typedef struct _RygelMediaExportSqliteWrapperClass RygelMediaExportSqliteWrapperClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY (rygel_media_export_sql_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactory))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))

typedef struct _RygelMediaExportSQLFactory RygelMediaExportSQLFactory;
typedef struct _RygelMediaExportSQLFactoryClass RygelMediaExportSQLFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_STRING (rygel_media_export_sql_string_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR (rygel_media_export_database_cursor_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursor))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))

typedef struct _RygelMediaExportDatabaseCursor RygelMediaExportDatabaseCursor;
typedef struct _RygelMediaExportDatabaseCursorClass RygelMediaExportDatabaseCursorClass;

#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR (rygel_media_export_database_cursor_iterator_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIterator))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIteratorClass))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIteratorClass))

typedef struct _RygelMediaExportDatabaseCursorIterator RygelMediaExportDatabaseCursorIterator;
typedef struct _RygelMediaExportDatabaseCursorIteratorClass RygelMediaExportDatabaseCursorIteratorClass;
#define _rygel_media_export_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_database_cursor_iterator_unref (var), NULL)))
typedef struct _RygelMediaExportParamSpecMediaCacheUpgrader RygelMediaExportParamSpecMediaCacheUpgrader;

struct _RygelMediaExportMediaCacheUpgrader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaExportMediaCacheUpgraderPrivate * priv;
};

struct _RygelMediaExportMediaCacheUpgraderClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaExportMediaCacheUpgrader *self);
};

struct _RygelMediaExportMediaCacheUpgraderPrivate {
	RygelMediaExportDatabase* database;
	RygelMediaExportSQLFactory* sql;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS
} RygelMediaExportSQLString;

struct _RygelMediaExportParamSpecMediaCacheUpgrader {
	GParamSpec parent_instance;
};


static gpointer rygel_media_export_media_cache_upgrader_parent_class = NULL;

gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance);
void rygel_media_export_media_cache_upgrader_unref (gpointer instance);
GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_value_set_media_cache_upgrader (GValue* value, gpointer v_object);
void rygel_media_export_value_take_media_cache_upgrader (GValue* value, gpointer v_object);
gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value);
GType rygel_media_export_media_cache_upgrader_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sqlite_wrapper_get_type (void) G_GNUC_CONST;
GType rygel_media_export_database_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sql_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_2 "UPDATE meta_data SET object_fk = " "(SELECT upnp_id FROM Object WHERE metadata_fk = meta_data.id)"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_3 "ALTER TABLE Object ADD timestamp INTEGER"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_4 "UPDATE Object SET timestamp = 0"
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type, RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint* current_version, GError** error);
GQuark rygel_media_export_database_error_quark (void);
gint rygel_media_export_database_query_value (RygelMediaExportDatabase* self, const gchar* sql, GValue* args, int args_length1, GError** error);
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION "11"
void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self, GError** error);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_exec (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
GType rygel_media_export_sql_string_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_export_sql_factory_make (RygelMediaExportSQLFactory* self, RygelMediaExportSQLString query);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);
void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self);
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint old_version);
static void rygel_media_export_media_cache_upgrader_update_v3_v4 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v4_v5 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v5_v6 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v6_v7 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v7_v8 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v8_v9 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v9_v10 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v10_v11 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_force_reindex (RygelMediaExportMediaCacheUpgrader* self, GError** error);
GType rygel_media_export_database_cursor_get_type (void) G_GNUC_CONST;
RygelMediaExportDatabaseCursor* rygel_media_export_database_exec_cursor (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
static void _vala_GValue_array_free (GValue* array, gint array_length);
gpointer rygel_media_export_database_cursor_iterator_ref (gpointer instance);
void rygel_media_export_database_cursor_iterator_unref (gpointer instance);
GParamSpec* rygel_media_export_database_cursor_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_database_cursor_value_set_iterator (GValue* value, gpointer v_object);
void rygel_media_export_database_cursor_value_take_iterator (GValue* value, gpointer v_object);
gpointer rygel_media_export_database_cursor_value_get_iterator (const GValue* value);
GType rygel_media_export_database_cursor_iterator_get_type (void) G_GNUC_CONST;
RygelMediaExportDatabaseCursorIterator* rygel_media_export_database_cursor_iterator (RygelMediaExportDatabaseCursor* self);
gboolean rygel_media_export_database_cursor_iterator_next (RygelMediaExportDatabaseCursorIterator* self);
sqlite3_stmt* rygel_media_export_database_cursor_iterator_get (RygelMediaExportDatabaseCursorIterator* self, GError** error);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME "Files & Folders"
static void rygel_media_export_media_cache_upgrader_finalize (RygelMediaExportMediaCacheUpgrader* obj);


RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type, RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql) {
	RygelMediaExportMediaCacheUpgrader* self = NULL;
	RygelMediaExportDatabase* _tmp0_;
	RygelMediaExportSQLFactory* _tmp1_;
	g_return_val_if_fail (database != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	self = (RygelMediaExportMediaCacheUpgrader*) g_type_create_instance (object_type);
	_tmp0_ = database;
	self->priv->database = _tmp0_;
	_tmp1_ = sql;
	self->priv->sql = _tmp1_;
	return self;
}


RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql) {
	return rygel_media_export_media_cache_upgrader_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, database, sql);
}


gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint* current_version, GError** error) {
	gint _vala_current_version = 0;
	gboolean result = FALSE;
	RygelMediaExportDatabase* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->database;
	_tmp1_ = rygel_media_export_database_query_value (_tmp0_, "SELECT version FROM schema_info", NULL, 0, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	_vala_current_version = _tmp2_;
	_tmp3_ = _vala_current_version;
	_tmp4_ = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
	result = _tmp3_ < _tmp4_;
	if (current_version) {
		*current_version = _vala_current_version;
	}
	return result;
}


void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self, GError** error) {
	RygelMediaExportDatabase* _tmp0_;
	gint _tmp1_ = 0;
	gint matching_schema_count;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = rygel_media_export_database_query_value (_tmp0_, "SELECT count(*) FROM " "sqlite_master WHERE sql " "LIKE 'CREATE TABLE Meta_Data" "%object_fk TEXT UNIQUE%'", NULL, 0, &_inner_error_);
	matching_schema_count = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = matching_schema_count;
	if (_tmp2_ == 0) {
		{
			RygelMediaExportDatabase* _tmp3_;
			RygelMediaExportDatabase* _tmp4_;
			RygelMediaExportDatabase* _tmp5_;
			RygelMediaExportDatabase* _tmp6_;
			RygelMediaExportSQLFactory* _tmp7_;
			const gchar* _tmp8_ = NULL;
			RygelMediaExportDatabase* _tmp9_;
			g_message ("rygel-media-export-media-cache-upgrader.vala:58: Found faulty schema, " \
"forcing full reindex");
			_tmp3_ = self->priv->database;
			rygel_media_export_database_begin (_tmp3_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch12_g_error;
			}
			_tmp4_ = self->priv->database;
			rygel_media_export_database_exec (_tmp4_, "DELETE FROM Object WHERE upnp_id IN (" "SELECT DISTINCT object_fk FROM meta_data)", NULL, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch12_g_error;
			}
			_tmp5_ = self->priv->database;
			rygel_media_export_database_exec (_tmp5_, "DROP TABLE Meta_Data", NULL, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch12_g_error;
			}
			_tmp6_ = self->priv->database;
			_tmp7_ = self->priv->sql;
			_tmp8_ = rygel_media_export_sql_factory_make (_tmp7_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA);
			rygel_media_export_database_exec (_tmp6_, _tmp8_, NULL, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch12_g_error;
			}
			_tmp9_ = self->priv->database;
			rygel_media_export_database_commit (_tmp9_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch12_g_error;
			}
		}
		goto __finally12;
		__catch12_g_error:
		{
			GError* _error_ = NULL;
			RygelMediaExportDatabase* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp10_ = self->priv->database;
			rygel_media_export_database_rollback (_tmp10_);
			_tmp11_ = _error_;
			_tmp12_ = _tmp11_->message;
			_tmp13_ = g_strconcat ("Failed to force reindex to fix database: ", _tmp12_, NULL);
			_tmp14_ = _tmp13_;
			g_warning ("rygel-media-export-media-cache-upgrader.vala:67: %s", _tmp14_);
			_g_free0 (_tmp14_);
			_g_error_free0 (_error_);
		}
		__finally12:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaExportSQLFactory* _tmp1_;
		const gchar* _tmp2_ = NULL;
		RygelMediaExportDatabase* _tmp3_;
		_tmp0_ = self->priv->database;
		_tmp1_ = self->priv->sql;
		_tmp2_ = rygel_media_export_sql_factory_make (_tmp1_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
		rygel_media_export_database_exec (_tmp0_, _tmp2_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		_tmp3_ = self->priv->database;
		rygel_media_export_database_analyze (_tmp3_);
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_strconcat ("Failed to create indices: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:78: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_g_error_free0 (_error_);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint old_version) {
	gint _tmp0_ = 0;
	gint current_version;
	g_return_if_fail (self != NULL);
	g_debug ("rygel-media-export-media-cache-upgrader.vala:84: Older schema detected" \
". Upgrading...");
	_tmp0_ = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
	current_version = _tmp0_;
	while (TRUE) {
		gint _tmp1_;
		gint _tmp2_;
		RygelMediaExportDatabase* _tmp3_;
		_tmp1_ = old_version;
		_tmp2_ = current_version;
		if (!(_tmp1_ < _tmp2_)) {
			break;
		}
		_tmp3_ = self->priv->database;
		if (_tmp3_ != NULL) {
			gint _tmp4_;
			gint _tmp5_;
			_tmp4_ = old_version;
			switch (_tmp4_) {
				case 3:
				{
					rygel_media_export_media_cache_upgrader_update_v3_v4 (self);
					break;
				}
				case 4:
				{
					rygel_media_export_media_cache_upgrader_update_v4_v5 (self);
					break;
				}
				case 5:
				{
					rygel_media_export_media_cache_upgrader_update_v5_v6 (self);
					break;
				}
				case 6:
				{
					rygel_media_export_media_cache_upgrader_update_v6_v7 (self);
					break;
				}
				case 7:
				{
					rygel_media_export_media_cache_upgrader_update_v7_v8 (self);
					break;
				}
				case 8:
				{
					rygel_media_export_media_cache_upgrader_update_v8_v9 (self);
					break;
				}
				case 9:
				{
					rygel_media_export_media_cache_upgrader_update_v9_v10 (self);
					break;
				}
				case 10:
				{
					rygel_media_export_media_cache_upgrader_update_v10_v11 (self);
					break;
				}
				default:
				{
					g_warning ("rygel-media-export-media-cache-upgrader.vala:114: Cannot upgrade");
					self->priv->database = NULL;
					break;
				}
			}
			_tmp5_ = old_version;
			old_version = _tmp5_ + 1;
		}
	}
}


static void rygel_media_export_media_cache_upgrader_force_reindex (RygelMediaExportMediaCacheUpgrader* self, GError** error) {
	RygelMediaExportDatabase* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	rygel_media_export_database_exec (_tmp0_, "UPDATE Object SET timestamp = 0", NULL, 0, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void rygel_media_export_media_cache_upgrader_update_v3_v4 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaExportDatabase* _tmp1_;
		RygelMediaExportDatabase* _tmp2_;
		RygelMediaExportSQLFactory* _tmp3_;
		const gchar* _tmp4_ = NULL;
		RygelMediaExportDatabase* _tmp5_;
		RygelMediaExportDatabase* _tmp6_;
		RygelMediaExportDatabase* _tmp7_;
		RygelMediaExportDatabase* _tmp8_;
		RygelMediaExportDatabase* _tmp9_;
		RygelMediaExportSQLFactory* _tmp10_;
		const gchar* _tmp11_ = NULL;
		RygelMediaExportDatabase* _tmp12_;
		RygelMediaExportDatabase* _tmp13_;
		_tmp0_ = self->priv->database;
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch14_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_media_export_database_exec (_tmp1_, "ALTER TABLE Meta_Data RENAME TO _Meta_Data", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch14_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		_tmp3_ = self->priv->sql;
		_tmp4_ = rygel_media_export_sql_factory_make (_tmp3_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA);
		rygel_media_export_database_exec (_tmp2_, _tmp4_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch14_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_media_export_database_exec (_tmp5_, "INSERT INTO meta_data (size, mime_type, " "duration, width, height, class, author, album, " "date, bitrate, sample_freq, bits_per_sample, " "channels, track, color_depth, object_fk) SELECT " "size, mime_type, duration, width, height, class, " "author, album, date, bitrate, sample_freq, " "bits_per_sample, channels, track, color_depth, " "o.upnp_id FROM _Meta_Data JOIN object o " "ON id = o.metadata_fk", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch14_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = self->priv->database;
		rygel_media_export_database_exec (_tmp6_, "DROP TABLE _Meta_Data", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch14_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp7_ = self->priv->database;
		rygel_media_export_database_exec (_tmp7_, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_3, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch14_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = self->priv->database;
		rygel_media_export_database_exec (_tmp8_, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_4, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch14_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = self->priv->database;
		_tmp10_ = self->priv->sql;
		_tmp11_ = rygel_media_export_sql_factory_make (_tmp10_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
		rygel_media_export_database_exec (_tmp9_, _tmp11_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch14_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = self->priv->database;
		rygel_media_export_database_exec (_tmp12_, "UPDATE schema_info SET version = '4'", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch14_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp13_ = self->priv->database;
		rygel_media_export_database_commit (_tmp13_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch14_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally14;
	__catch14_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaExportDatabase* _tmp14_;
		GError* _tmp15_;
		const gchar* _tmp16_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = self->priv->database;
		rygel_media_export_database_rollback (_tmp14_);
		_tmp15_ = _error_;
		_tmp16_ = _tmp15_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:149: Database upgrade fai" \
"led: %s", _tmp16_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _vala_GValue_array_free (GValue* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}


static void rygel_media_export_media_cache_upgrader_update_v4_v5 (RygelMediaExportMediaCacheUpgrader* self) {
	GeeLinkedList* _tmp0_;
	GeeQueue* queue;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	queue = (GeeQueue*) _tmp0_;
	{
		RygelMediaExportDatabase* _tmp1_;
		RygelMediaExportDatabase* _tmp2_;
		RygelMediaExportDatabase* _tmp3_;
		RygelMediaExportSQLFactory* _tmp4_;
		const gchar* _tmp5_ = NULL;
		RygelMediaExportDatabase* _tmp6_;
		RygelMediaExportDatabase* _tmp7_;
		RygelMediaExportDatabase* _tmp8_;
		RygelMediaExportDatabase* _tmp9_;
		RygelMediaExportSQLFactory* _tmp10_;
		const gchar* _tmp11_ = NULL;
		RygelMediaExportDatabase* _tmp12_;
		RygelMediaExportDatabase* _tmp13_;
		GeeQueue* _tmp14_;
		RygelMediaExportDatabase* _tmp36_;
		RygelMediaExportDatabase* _tmp37_;
		RygelMediaExportDatabase* _tmp38_;
		RygelMediaExportSQLFactory* _tmp39_;
		const gchar* _tmp40_ = NULL;
		RygelMediaExportDatabase* _tmp41_;
		RygelMediaExportSQLFactory* _tmp42_;
		const gchar* _tmp43_ = NULL;
		RygelMediaExportDatabase* _tmp44_;
		RygelMediaExportDatabase* _tmp45_;
		RygelMediaExportDatabase* _tmp46_;
		RygelMediaExportDatabase* _tmp47_;
		_tmp1_ = self->priv->database;
		rygel_media_export_database_begin (_tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_media_export_database_exec (_tmp2_, "DROP TRIGGER IF EXISTS trgr_delete_children", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		_tmp4_ = self->priv->sql;
		_tmp5_ = rygel_media_export_sql_factory_make (_tmp4_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
		rygel_media_export_database_exec (_tmp3_, _tmp5_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = self->priv->database;
		rygel_media_export_database_exec (_tmp6_, "ALTER TABLE Object RENAME TO _Object", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp7_ = self->priv->database;
		rygel_media_export_database_exec (_tmp7_, "CREATE TABLE Object AS SELECT * FROM _Object", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = self->priv->database;
		rygel_media_export_database_exec (_tmp8_, "DELETE FROM Object", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = self->priv->database;
		_tmp10_ = self->priv->sql;
		_tmp11_ = rygel_media_export_sql_factory_make (_tmp10_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
		rygel_media_export_database_exec (_tmp9_, _tmp11_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = self->priv->database;
		rygel_media_export_database_exec (_tmp12_, "INSERT INTO _Object (upnp_id, type_fk, title, " "timestamp) VALUES ('0', 0, 'Root', 0)", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp13_ = self->priv->database;
		rygel_media_export_database_exec (_tmp13_, "INSERT INTO Object (upnp_id, type_fk, title, " "timestamp) VALUES ('0', 0, 'Root', 0)", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp14_ = queue;
		gee_queue_offer (_tmp14_, "0");
		while (TRUE) {
			GeeQueue* _tmp15_;
			gboolean _tmp16_;
			gboolean _tmp17_;
			GeeQueue* _tmp18_;
			gpointer _tmp19_ = NULL;
			GValue _tmp20_ = {0};
			GValue* _tmp21_ = NULL;
			GValue* args;
			gint args_length1;
			gint _args_size_;
			RygelMediaExportDatabase* _tmp22_;
			GValue* _tmp23_;
			gint _tmp23__length1;
			RygelMediaExportDatabaseCursor* _tmp24_ = NULL;
			RygelMediaExportDatabaseCursor* cursor;
			RygelMediaExportDatabase* _tmp34_;
			GValue* _tmp35_;
			gint _tmp35__length1;
			_tmp15_ = queue;
			_tmp16_ = gee_collection_get_is_empty ((GeeCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			if (!(!_tmp17_)) {
				break;
			}
			_tmp18_ = queue;
			_tmp19_ = gee_queue_poll (_tmp18_);
			g_value_init (&_tmp20_, G_TYPE_STRING);
			g_value_take_string (&_tmp20_, (gchar*) _tmp19_);
			_tmp21_ = g_new0 (GValue, 1);
			_tmp21_[0] = _tmp20_;
			args = _tmp21_;
			args_length1 = 1;
			_args_size_ = args_length1;
			_tmp22_ = self->priv->database;
			_tmp23_ = args;
			_tmp23__length1 = args_length1;
			_tmp24_ = rygel_media_export_database_exec_cursor (_tmp22_, "SELECT upnp_id FROM _Object WHERE " "parent = ?", _tmp23_, _tmp23__length1, &_inner_error_);
			cursor = _tmp24_;
			if (_inner_error_ != NULL) {
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					goto __catch15_rygel_media_export_database_error;
				}
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				_g_object_unref0 (queue);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			{
				RygelMediaExportDatabaseCursor* _tmp25_;
				RygelMediaExportDatabaseCursorIterator* _tmp26_ = NULL;
				RygelMediaExportDatabaseCursorIterator* _statement_it;
				_tmp25_ = cursor;
				_tmp26_ = rygel_media_export_database_cursor_iterator (_tmp25_);
				_statement_it = _tmp26_;
				while (TRUE) {
					RygelMediaExportDatabaseCursorIterator* _tmp27_;
					gboolean _tmp28_ = FALSE;
					RygelMediaExportDatabaseCursorIterator* _tmp29_;
					sqlite3_stmt* _tmp30_ = NULL;
					sqlite3_stmt* statement;
					GeeQueue* _tmp31_;
					sqlite3_stmt* _tmp32_;
					const gchar* _tmp33_ = NULL;
					_tmp27_ = _statement_it;
					_tmp28_ = rygel_media_export_database_cursor_iterator_next (_tmp27_);
					if (!_tmp28_) {
						break;
					}
					_tmp29_ = _statement_it;
					_tmp30_ = rygel_media_export_database_cursor_iterator_get (_tmp29_, &_inner_error_);
					statement = _tmp30_;
					if (_inner_error_ != NULL) {
						_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
						_g_object_unref0 (cursor);
						args = (_vala_GValue_array_free (args, args_length1), NULL);
						if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
							goto __catch15_rygel_media_export_database_error;
						}
						_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
						_g_object_unref0 (cursor);
						args = (_vala_GValue_array_free (args, args_length1), NULL);
						_g_object_unref0 (queue);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp31_ = queue;
					_tmp32_ = statement;
					_tmp33_ = sqlite3_column_text (_tmp32_, 0);
					gee_queue_offer (_tmp31_, _tmp33_);
				}
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
			}
			_tmp34_ = self->priv->database;
			_tmp35_ = args;
			_tmp35__length1 = args_length1;
			rygel_media_export_database_exec (_tmp34_, "INSERT INTO Object SELECT * FROM _OBJECT " "WHERE parent = ?", _tmp35_, _tmp35__length1, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (cursor);
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					goto __catch15_rygel_media_export_database_error;
				}
				_g_object_unref0 (cursor);
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				_g_object_unref0 (queue);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (cursor);
			args = (_vala_GValue_array_free (args, args_length1), NULL);
		}
		_tmp36_ = self->priv->database;
		rygel_media_export_database_exec (_tmp36_, "DROP TABLE Object", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp37_ = self->priv->database;
		rygel_media_export_database_exec (_tmp37_, "ALTER TABLE _Object RENAME TO Object", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp38_ = self->priv->database;
		_tmp39_ = self->priv->sql;
		_tmp40_ = rygel_media_export_sql_factory_make (_tmp39_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
		rygel_media_export_database_exec (_tmp38_, _tmp40_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp41_ = self->priv->database;
		_tmp42_ = self->priv->sql;
		_tmp43_ = rygel_media_export_sql_factory_make (_tmp42_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
		rygel_media_export_database_exec (_tmp41_, _tmp43_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp44_ = self->priv->database;
		rygel_media_export_database_exec (_tmp44_, "UPDATE schema_info SET version = '5'", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp45_ = self->priv->database;
		rygel_media_export_database_commit (_tmp45_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp46_ = self->priv->database;
		rygel_media_export_database_exec (_tmp46_, "VACUUM", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp47_ = self->priv->database;
		rygel_media_export_database_analyze (_tmp47_);
	}
	goto __finally15;
	__catch15_rygel_media_export_database_error:
	{
		GError* err = NULL;
		RygelMediaExportDatabase* _tmp48_;
		GError* _tmp49_;
		const gchar* _tmp50_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp48_ = self->priv->database;
		rygel_media_export_database_rollback (_tmp48_);
		_tmp49_ = err;
		_tmp50_ = _tmp49_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:197: Database upgrade fai" \
"led: %s", _tmp50_);
		self->priv->database = NULL;
		_g_error_free0 (err);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (queue);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (queue);
}


static void rygel_media_export_media_cache_upgrader_update_v5_v6 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaExportDatabase* _tmp1_;
		RygelMediaExportDatabase* _tmp2_;
		RygelMediaExportDatabase* _tmp3_;
		RygelMediaExportDatabase* _tmp4_;
		RygelMediaExportDatabase* _tmp5_;
		RygelMediaExportDatabase* _tmp6_;
		RygelMediaExportDatabase* _tmp7_;
		RygelMediaExportDatabase* _tmp8_;
		RygelMediaExportDatabase* _tmp9_;
		RygelMediaExportDatabase* _tmp10_;
		_tmp0_ = self->priv->database;
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch16_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_media_export_database_exec (_tmp1_, "DROP TABLE object_type", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch16_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_media_export_database_exec (_tmp2_, "DROP TRIGGER IF EXISTS trgr_delete_uris", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch16_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		rygel_media_export_database_exec (_tmp3_, "ALTER TABLE Object ADD COLUMN uri TEXT", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch16_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = self->priv->database;
		rygel_media_export_database_exec (_tmp4_, "UPDATE Object SET uri = (SELECT uri " "FROM uri WHERE Uri.object_fk == Object.upnp_id LIMIT 1)", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch16_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_media_export_database_exec (_tmp5_, "DROP INDEX IF EXISTS idx_uri_fk", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch16_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = self->priv->database;
		rygel_media_export_database_exec (_tmp6_, "DROP TABLE Uri", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch16_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp7_ = self->priv->database;
		rygel_media_export_database_exec (_tmp7_, "UPDATE schema_info SET version = '6'", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch16_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = self->priv->database;
		rygel_media_export_database_commit (_tmp8_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch16_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = self->priv->database;
		rygel_media_export_database_exec (_tmp9_, "VACUUM", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch16_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp10_ = self->priv->database;
		rygel_media_export_database_analyze (_tmp10_);
	}
	goto __finally16;
	__catch16_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaExportDatabase* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = self->priv->database;
		rygel_media_export_database_rollback (_tmp11_);
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:218: Database upgrade fai" \
"led: %s", _tmp13_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally16:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v6_v7 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaExportDatabase* _tmp1_;
		RygelMediaExportDatabase* _tmp2_;
		RygelMediaExportDatabase* _tmp3_;
		RygelMediaExportDatabase* _tmp4_;
		RygelMediaExportDatabase* _tmp5_;
		_tmp0_ = self->priv->database;
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch17_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_media_export_database_exec (_tmp1_, "ALTER TABLE meta_data ADD COLUMN dlna_profile TEXT", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch17_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_media_export_database_exec (_tmp2_, "UPDATE schema_info SET version = '7'", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch17_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		rygel_media_export_media_cache_upgrader_force_reindex (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch17_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		rygel_media_export_database_commit (_tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch17_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = self->priv->database;
		rygel_media_export_database_exec (_tmp4_, "VACUUM", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch17_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_media_export_database_analyze (_tmp5_);
	}
	goto __finally17;
	__catch17_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaExportDatabase* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = self->priv->database;
		rygel_media_export_database_rollback (_tmp6_);
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:234: Database upgrade fai" \
"led: %s", _tmp8_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally17:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v7_v8 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaExportDatabase* _tmp1_;
		RygelMediaExportDatabase* _tmp2_;
		RygelMediaExportDatabase* _tmp3_;
		RygelMediaExportDatabase* _tmp4_;
		RygelMediaExportDatabase* _tmp5_;
		RygelMediaExportDatabase* _tmp6_;
		_tmp0_ = self->priv->database;
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch18_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_media_export_database_exec (_tmp1_, "ALTER TABLE object ADD COLUMN flags TEXT", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch18_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_media_export_database_exec (_tmp2_, "ALTER TABLE meta_data ADD COLUMN genre TEXT", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch18_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		rygel_media_export_database_exec (_tmp3_, "UPDATE schema_info SET version = '8'", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch18_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		rygel_media_export_media_cache_upgrader_force_reindex (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch18_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = self->priv->database;
		rygel_media_export_database_commit (_tmp4_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch18_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_media_export_database_exec (_tmp5_, "VACUUM", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch18_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = self->priv->database;
		rygel_media_export_database_analyze (_tmp6_);
	}
	goto __finally18;
	__catch18_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaExportDatabase* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = self->priv->database;
		rygel_media_export_database_rollback (_tmp7_);
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:251: Database upgrade fai" \
"led: %s", _tmp9_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally18:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v8_v9 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaExportDatabase* _tmp1_;
		RygelMediaExportDatabase* _tmp2_;
		RygelMediaExportDatabase* _tmp3_;
		RygelMediaExportDatabase* _tmp4_;
		RygelMediaExportSQLFactory* _tmp5_;
		const gchar* _tmp6_ = NULL;
		RygelMediaExportDatabase* _tmp7_;
		RygelMediaExportDatabase* _tmp8_;
		RygelMediaExportSQLFactory* _tmp9_;
		const gchar* _tmp10_ = NULL;
		RygelMediaExportDatabase* _tmp11_;
		RygelMediaExportDatabase* _tmp12_;
		RygelMediaExportDatabase* _tmp13_;
		RygelMediaExportDatabase* _tmp14_;
		_tmp0_ = self->priv->database;
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch19_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_media_export_database_exec (_tmp1_, "DROP TRIGGER trgr_update_closure", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch19_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_media_export_database_exec (_tmp2_, "DROP TRIGGER trgr_delete_closure", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch19_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		rygel_media_export_database_exec (_tmp3_, "ALTER TABLE Closure RENAME TO _Closure", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch19_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = self->priv->database;
		_tmp5_ = self->priv->sql;
		_tmp6_ = rygel_media_export_sql_factory_make (_tmp5_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
		rygel_media_export_database_exec (_tmp4_, _tmp6_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch19_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp7_ = self->priv->database;
		rygel_media_export_database_exec (_tmp7_, "INSERT INTO Closure (ancestor, " "descendant, depth) SELECT DISTINCT " "ancestor, descendant, depth FROM " "_Closure", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch19_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = self->priv->database;
		_tmp9_ = self->priv->sql;
		_tmp10_ = rygel_media_export_sql_factory_make (_tmp9_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
		rygel_media_export_database_exec (_tmp8_, _tmp10_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch19_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp11_ = self->priv->database;
		rygel_media_export_database_exec (_tmp11_, "DROP TABLE _Closure", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch19_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = self->priv->database;
		rygel_media_export_database_exec (_tmp12_, "UPDATE schema_info SET version = '9'", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch19_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp13_ = self->priv->database;
		rygel_media_export_database_commit (_tmp13_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch19_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp14_ = self->priv->database;
		rygel_media_export_database_exec (_tmp14_, "VACUUM", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch19_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally19;
	__catch19_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaExportDatabase* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = self->priv->database;
		rygel_media_export_database_rollback (_tmp15_);
		_tmp16_ = _error_;
		_tmp17_ = _tmp16_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:274: Database upgrade fai" \
"led: %s", _tmp17_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v9_v10 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _tmp0_;
		GeeLinkedList* queue;
		RygelMediaExportDatabase* _tmp1_;
		RygelMediaExportDatabase* _tmp2_;
		RygelMediaExportDatabase* _tmp3_;
		RygelMediaExportDatabase* _tmp4_;
		RygelMediaExportDatabase* _tmp5_;
		RygelMediaExportDatabase* _tmp6_;
		RygelMediaExportDatabase* _tmp7_;
		RygelMediaExportDatabase* _tmp8_;
		RygelMediaExportDatabase* _tmp9_;
		RygelMediaExportDatabase* _tmp10_;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		RygelMediaExportDatabase* _tmp16_;
		RygelMediaExportDatabase* _tmp17_;
		RygelMediaExportDatabase* _tmp18_;
		RygelMediaExportDatabase* _tmp19_;
		RygelMediaExportDatabase* _tmp20_;
		RygelMediaExportSQLFactory* _tmp21_;
		const gchar* _tmp22_ = NULL;
		RygelMediaExportDatabase* _tmp23_;
		RygelMediaExportSQLFactory* _tmp24_;
		const gchar* _tmp25_ = NULL;
		RygelMediaExportDatabase* _tmp26_;
		GeeLinkedList* _tmp27_;
		RygelMediaExportDatabase* _tmp49_;
		RygelMediaExportDatabase* _tmp50_;
		RygelMediaExportDatabase* _tmp51_;
		RygelMediaExportSQLFactory* _tmp52_;
		const gchar* _tmp53_ = NULL;
		RygelMediaExportDatabase* _tmp54_;
		RygelMediaExportSQLFactory* _tmp55_;
		const gchar* _tmp56_ = NULL;
		RygelMediaExportDatabase* _tmp57_;
		RygelMediaExportSQLFactory* _tmp58_;
		const gchar* _tmp59_ = NULL;
		RygelMediaExportDatabase* _tmp60_;
		RygelMediaExportDatabase* _tmp61_;
		RygelMediaExportDatabase* _tmp62_;
		RygelMediaExportDatabase* _tmp63_;
		_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		queue = _tmp0_;
		_tmp1_ = self->priv->database;
		rygel_media_export_database_begin (_tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_media_export_database_exec (_tmp2_, "DELETE FROM Object WHERE upnp_id LIKE '" RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "%'", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		rygel_media_export_database_exec (_tmp3_, "DROP TRIGGER trgr_update_closure", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = self->priv->database;
		rygel_media_export_database_exec (_tmp4_, "DROP TRIGGER trgr_delete_closure", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_media_export_database_exec (_tmp5_, "DROP INDEX idx_parent", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = self->priv->database;
		rygel_media_export_database_exec (_tmp6_, "DROP INDEX idx_meta_data_fk", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp7_ = self->priv->database;
		rygel_media_export_database_exec (_tmp7_, "DROP INDEX IF EXISTS idx_closure", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = self->priv->database;
		rygel_media_export_database_exec (_tmp8_, "DROP TABLE Closure", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = self->priv->database;
		rygel_media_export_database_exec (_tmp9_, "DROP TRIGGER trgr_delete_metadata", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp10_ = self->priv->database;
		_tmp11_ = _ (RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME);
		_tmp12_ = g_strconcat ("INSERT OR REPLACE INTO Object (parent, upnp_id, " "type_fk, title, timestamp) VALUES " "('0', '" RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "', 0, '", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, "', 0)", NULL);
		_tmp15_ = _tmp14_;
		rygel_media_export_database_exec (_tmp10_, _tmp15_, NULL, 0, &_inner_error_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp16_ = self->priv->database;
		rygel_media_export_database_exec (_tmp16_, "UPDATE Object SET parent = '" RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "' WHERE parent = '0' AND upnp_id " "NOT LIKE 'virtual-%' AND upnp_id " "<> '" RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "'", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp17_ = self->priv->database;
		rygel_media_export_database_exec (_tmp17_, "ALTER TABLE Object RENAME TO _Object", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp18_ = self->priv->database;
		rygel_media_export_database_exec (_tmp18_, "CREATE TABLE Object AS SELECT * FROM _Object", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp19_ = self->priv->database;
		rygel_media_export_database_exec (_tmp19_, "DELETE FROM Object", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp20_ = self->priv->database;
		_tmp21_ = self->priv->sql;
		_tmp22_ = rygel_media_export_sql_factory_make (_tmp21_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
		rygel_media_export_database_exec (_tmp20_, _tmp22_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp23_ = self->priv->database;
		_tmp24_ = self->priv->sql;
		_tmp25_ = rygel_media_export_sql_factory_make (_tmp24_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
		rygel_media_export_database_exec (_tmp23_, _tmp25_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp26_ = self->priv->database;
		rygel_media_export_database_exec (_tmp26_, "INSERT INTO Closure (ancestor, descendant, " "depth) VALUES ('0','0',0)", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp27_ = queue;
		gee_queue_offer ((GeeQueue*) _tmp27_, "0");
		while (TRUE) {
			GeeLinkedList* _tmp28_;
			gboolean _tmp29_;
			gboolean _tmp30_;
			GeeLinkedList* _tmp31_;
			gpointer _tmp32_ = NULL;
			GValue _tmp33_ = {0};
			GValue* _tmp34_ = NULL;
			GValue* args;
			gint args_length1;
			gint _args_size_;
			RygelMediaExportDatabase* _tmp35_;
			GValue* _tmp36_;
			gint _tmp36__length1;
			RygelMediaExportDatabaseCursor* _tmp37_ = NULL;
			RygelMediaExportDatabaseCursor* cursor;
			RygelMediaExportDatabase* _tmp47_;
			GValue* _tmp48_;
			gint _tmp48__length1;
			_tmp28_ = queue;
			_tmp29_ = gee_collection_get_is_empty ((GeeCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			if (!(!_tmp30_)) {
				break;
			}
			_tmp31_ = queue;
			_tmp32_ = gee_queue_poll ((GeeQueue*) _tmp31_);
			g_value_init (&_tmp33_, G_TYPE_STRING);
			g_value_take_string (&_tmp33_, (gchar*) _tmp32_);
			_tmp34_ = g_new0 (GValue, 1);
			_tmp34_[0] = _tmp33_;
			args = _tmp34_;
			args_length1 = 1;
			_args_size_ = args_length1;
			_tmp35_ = self->priv->database;
			_tmp36_ = args;
			_tmp36__length1 = args_length1;
			_tmp37_ = rygel_media_export_database_exec_cursor (_tmp35_, "SELECT upnp_id FROM _Object WHERE " "parent = ?", _tmp36_, _tmp36__length1, &_inner_error_);
			cursor = _tmp37_;
			if (_inner_error_ != NULL) {
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				_g_object_unref0 (queue);
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					goto __catch20_rygel_media_export_database_error;
				}
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				_g_object_unref0 (queue);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			{
				RygelMediaExportDatabaseCursor* _tmp38_;
				RygelMediaExportDatabaseCursorIterator* _tmp39_ = NULL;
				RygelMediaExportDatabaseCursorIterator* _statement_it;
				_tmp38_ = cursor;
				_tmp39_ = rygel_media_export_database_cursor_iterator (_tmp38_);
				_statement_it = _tmp39_;
				while (TRUE) {
					RygelMediaExportDatabaseCursorIterator* _tmp40_;
					gboolean _tmp41_ = FALSE;
					RygelMediaExportDatabaseCursorIterator* _tmp42_;
					sqlite3_stmt* _tmp43_ = NULL;
					sqlite3_stmt* statement;
					GeeLinkedList* _tmp44_;
					sqlite3_stmt* _tmp45_;
					const gchar* _tmp46_ = NULL;
					_tmp40_ = _statement_it;
					_tmp41_ = rygel_media_export_database_cursor_iterator_next (_tmp40_);
					if (!_tmp41_) {
						break;
					}
					_tmp42_ = _statement_it;
					_tmp43_ = rygel_media_export_database_cursor_iterator_get (_tmp42_, &_inner_error_);
					statement = _tmp43_;
					if (_inner_error_ != NULL) {
						_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
						_g_object_unref0 (cursor);
						args = (_vala_GValue_array_free (args, args_length1), NULL);
						_g_object_unref0 (queue);
						if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
							goto __catch20_rygel_media_export_database_error;
						}
						_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
						_g_object_unref0 (cursor);
						args = (_vala_GValue_array_free (args, args_length1), NULL);
						_g_object_unref0 (queue);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp44_ = queue;
					_tmp45_ = statement;
					_tmp46_ = sqlite3_column_text (_tmp45_, 0);
					gee_queue_offer ((GeeQueue*) _tmp44_, _tmp46_);
				}
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
			}
			_tmp47_ = self->priv->database;
			_tmp48_ = args;
			_tmp48__length1 = args_length1;
			rygel_media_export_database_exec (_tmp47_, "INSERT INTO Object SELECT * FROM _Object " "WHERE parent = ?", _tmp48_, _tmp48__length1, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (cursor);
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				_g_object_unref0 (queue);
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					goto __catch20_rygel_media_export_database_error;
				}
				_g_object_unref0 (cursor);
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				_g_object_unref0 (queue);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (cursor);
			args = (_vala_GValue_array_free (args, args_length1), NULL);
		}
		_tmp49_ = self->priv->database;
		rygel_media_export_database_exec (_tmp49_, "DROP TABLE Object", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp50_ = self->priv->database;
		rygel_media_export_database_exec (_tmp50_, "ALTER TABLE _Object RENAME TO Object", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp51_ = self->priv->database;
		_tmp52_ = self->priv->sql;
		_tmp53_ = rygel_media_export_sql_factory_make (_tmp52_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
		rygel_media_export_database_exec (_tmp51_, _tmp53_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp54_ = self->priv->database;
		_tmp55_ = self->priv->sql;
		_tmp56_ = rygel_media_export_sql_factory_make (_tmp55_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
		rygel_media_export_database_exec (_tmp54_, _tmp56_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp57_ = self->priv->database;
		_tmp58_ = self->priv->sql;
		_tmp59_ = rygel_media_export_sql_factory_make (_tmp58_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
		rygel_media_export_database_exec (_tmp57_, _tmp59_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp60_ = self->priv->database;
		rygel_media_export_database_exec (_tmp60_, "UPDATE schema_info SET version = '10'", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp61_ = self->priv->database;
		rygel_media_export_database_commit (_tmp61_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp62_ = self->priv->database;
		rygel_media_export_database_exec (_tmp62_, "VACUUM", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch20_rygel_media_export_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp63_ = self->priv->database;
		rygel_media_export_database_analyze (_tmp63_);
		_g_object_unref0 (queue);
	}
	goto __finally20;
	__catch20_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaExportDatabase* _tmp64_;
		GError* _tmp65_;
		const gchar* _tmp66_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp64_ = self->priv->database;
		rygel_media_export_database_rollback (_tmp64_);
		_tmp65_ = _error_;
		_tmp66_ = _tmp65_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:343: Database upgrade fai" \
"led: %s", _tmp66_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally20:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v10_v11 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaExportDatabase* _tmp1_;
		RygelMediaExportDatabase* _tmp2_;
		RygelMediaExportDatabase* _tmp3_;
		RygelMediaExportDatabase* _tmp4_;
		RygelMediaExportDatabase* _tmp5_;
		RygelMediaExportDatabase* _tmp6_;
		_tmp0_ = self->priv->database;
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch21_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_media_export_database_exec (_tmp1_, "ALTER TABLE Meta_Data " "   ADD COLUMN disc INTEGER", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch21_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_media_export_database_exec (_tmp2_, "UPDATE Object SET timestamp = 0 WHERE " "  upnp_id IN (" "SELECT object_fk FROM Meta_Data WHERE " "  class LIKE 'object.item.audioItem.%')", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch21_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		rygel_media_export_database_exec (_tmp3_, "UPDATE schema_info SET version = '11'", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch21_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = self->priv->database;
		rygel_media_export_database_commit (_tmp4_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch21_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_media_export_database_exec (_tmp5_, "VACUUM", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch21_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = self->priv->database;
		rygel_media_export_database_analyze (_tmp6_);
	}
	goto __finally21;
	__catch21_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaExportDatabase* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = self->priv->database;
		rygel_media_export_database_rollback (_tmp7_);
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:364: Database upgrade fai" \
"led: %s", _tmp9_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally21:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_value_media_cache_upgrader_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_media_export_value_media_cache_upgrader_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_media_export_media_cache_upgrader_unref (value->data[0].v_pointer);
	}
}


static void rygel_media_export_value_media_cache_upgrader_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_media_export_media_cache_upgrader_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_media_export_value_media_cache_upgrader_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_media_export_value_media_cache_upgrader_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelMediaExportMediaCacheUpgrader* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_media_export_media_cache_upgrader_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_media_export_value_media_cache_upgrader_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMediaExportMediaCacheUpgrader** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_media_export_media_cache_upgrader_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelMediaExportParamSpecMediaCacheUpgrader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER), NULL);
	return value->data[0].v_pointer;
}


void rygel_media_export_value_set_media_cache_upgrader (GValue* value, gpointer v_object) {
	RygelMediaExportMediaCacheUpgrader* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_media_export_media_cache_upgrader_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_export_media_cache_upgrader_unref (old);
	}
}


void rygel_media_export_value_take_media_cache_upgrader (GValue* value, gpointer v_object) {
	RygelMediaExportMediaCacheUpgrader* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_export_media_cache_upgrader_unref (old);
	}
}


static void rygel_media_export_media_cache_upgrader_class_init (RygelMediaExportMediaCacheUpgraderClass * klass) {
	rygel_media_export_media_cache_upgrader_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS (klass)->finalize = rygel_media_export_media_cache_upgrader_finalize;
	g_type_class_add_private (klass, sizeof (RygelMediaExportMediaCacheUpgraderPrivate));
}


static void rygel_media_export_media_cache_upgrader_instance_init (RygelMediaExportMediaCacheUpgrader * self) {
	self->priv = RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void rygel_media_export_media_cache_upgrader_finalize (RygelMediaExportMediaCacheUpgrader* obj) {
	RygelMediaExportMediaCacheUpgrader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader);
}


GType rygel_media_export_media_cache_upgrader_get_type (void) {
	static volatile gsize rygel_media_export_media_cache_upgrader_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_upgrader_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_media_export_value_media_cache_upgrader_init, rygel_media_export_value_media_cache_upgrader_free_value, rygel_media_export_value_media_cache_upgrader_copy_value, rygel_media_export_value_media_cache_upgrader_peek_pointer, "p", rygel_media_export_value_media_cache_upgrader_collect_value, "p", rygel_media_export_value_media_cache_upgrader_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheUpgraderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_upgrader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCacheUpgrader), 0, (GInstanceInitFunc) rygel_media_export_media_cache_upgrader_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_media_export_media_cache_upgrader_type_id;
		rygel_media_export_media_cache_upgrader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaExportMediaCacheUpgrader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_media_export_media_cache_upgrader_type_id__volatile, rygel_media_export_media_cache_upgrader_type_id);
	}
	return rygel_media_export_media_cache_upgrader_type_id__volatile;
}


gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance) {
	RygelMediaExportMediaCacheUpgrader* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_media_export_media_cache_upgrader_unref (gpointer instance) {
	RygelMediaExportMediaCacheUpgrader* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



