/* rygel-media-container.c generated by valac 0.18.0.2-2c22, the Vala compiler
 * generated from rygel-media-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 MediaNet Inh.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <rygel-core.h>


#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_TRACKABLE_CONTAINER (rygel_trackable_container_get_type ())
#define RYGEL_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainer))
#define RYGEL_IS_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER))
#define RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainerIface))

typedef struct _RygelTrackableContainer RygelTrackableContainer;
typedef struct _RygelTrackableContainerIface RygelTrackableContainerIface;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_UPDATABLE_OBJECT (rygel_updatable_object_get_type ())
#define RYGEL_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObject))
#define RYGEL_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT))
#define RYGEL_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObjectIface))

typedef struct _RygelUpdatableObject RygelUpdatableObject;
typedef struct _RygelUpdatableObjectIface RygelUpdatableObjectIface;

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaContainerPrivate {
	gchar* _sort_criteria;
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelTrackableContainerIface {
	GTypeInterface parent_iface;
	void (*add_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	void (*remove_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
};

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit) (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_finish) (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_media_container_parent_class = NULL;

GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerPrivate))
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY,
	RYGEL_MEDIA_CONTAINER_SORT_CRITERIA,
	RYGEL_MEDIA_CONTAINER_OCM_FLAGS
};
#define RYGEL_MEDIA_CONTAINER_DEFAULT_SORT_CRITERIA "+upnp:class,+dc:title"
#define RYGEL_MEDIA_CONTAINER_UPNP_CLASS "object.container"
#define RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".storageFolder"
#define RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".album.musicAlbum"
#define RYGEL_MEDIA_CONTAINER_MUSIC_ARTIST RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".person.musicArtist"
#define RYGEL_MEDIA_CONTAINER_MUSIC_GENRE RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".genre.musicGenre"
#define RYGEL_MEDIA_CONTAINER_ALBUM_SORT_CRITERIA "+upnp:class," "+rygel:originalVolumeNumber," "+upnp:originalTrackNumber," "+dc:title"
RygelMediaContainer* rygel_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count);
RygelMediaObject* rygel_media_object_construct (GType object_type);
void rygel_media_object_set_id (RygelMediaObject* self, const gchar* value);
void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value);
void rygel_media_object_set_upnp_class (RygelMediaObject* self, const gchar* value);
static void rygel_media_container_on_container_updated (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void _rygel_media_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
static void rygel_media_container_on_sub_tree_updates_finished (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaObject* sub_tree_root);
static void _rygel_media_container_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender, RygelMediaObject* sub_tree_root, gpointer self);
RygelMediaContainer* rygel_media_container_construct_root (GType object_type, const gchar* title, gint child_count);
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
void rygel_media_container_updated (RygelMediaContainer* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static GUPnPDIDLLiteObject* rygel_media_container_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_trackable_container_get_type (void) G_GNUC_CONST;
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self);
const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self);
void rygel_media_container_set_sort_criteria (RygelMediaContainer* self, const gchar* value);
GType rygel_updatable_object_get_type (void) G_GNUC_CONST;
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void rygel_media_container_finalize (GObject* obj);
static void _vala_rygel_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType rygel_object_event_type_get_type (void) {
	static volatile gsize rygel_object_event_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_object_event_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_OBJECT_EVENT_TYPE_ADDED, "RYGEL_OBJECT_EVENT_TYPE_ADDED", "added"}, {RYGEL_OBJECT_EVENT_TYPE_MODIFIED, "RYGEL_OBJECT_EVENT_TYPE_MODIFIED", "modified"}, {RYGEL_OBJECT_EVENT_TYPE_DELETED, "RYGEL_OBJECT_EVENT_TYPE_DELETED", "deleted"}, {0, NULL, NULL}};
		GType rygel_object_event_type_type_id;
		rygel_object_event_type_type_id = g_enum_register_static ("RygelObjectEventType", values);
		g_once_init_leave (&rygel_object_event_type_type_id__volatile, rygel_object_event_type_type_id);
	}
	return rygel_object_event_type_type_id__volatile;
}


static void _rygel_media_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
	rygel_media_container_on_container_updated (self, _sender, container, object, event_type, sub_tree_update);
}


static void _rygel_media_container_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender, RygelMediaObject* sub_tree_root, gpointer self) {
	rygel_media_container_on_sub_tree_updates_finished (self, _sender, sub_tree_root);
}


RygelMediaContainer* rygel_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count) {
	RygelMediaContainer * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
	_tmp0_ = id;
	rygel_media_object_set_id ((RygelMediaObject*) self, _tmp0_);
	_tmp1_ = parent;
	((RygelMediaObject*) self)->parent = _tmp1_;
	_tmp2_ = title;
	rygel_media_object_set_title ((RygelMediaObject*) self, _tmp2_);
	_tmp3_ = child_count;
	self->child_count = _tmp3_;
	self->update_id = (guint32) 0;
	self->storage_used = (gint64) (-1);
	self->total_deleted_child_count = (gint64) 0;
	rygel_media_object_set_upnp_class ((RygelMediaObject*) self, RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER);
	g_signal_connect_object (self, "container-updated", (GCallback) _rygel_media_container_on_container_updated_rygel_media_container_container_updated, self, 0);
	g_signal_connect_object (self, "sub-tree-updates-finished", (GCallback) _rygel_media_container_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished, self, 0);
	return self;
}


RygelMediaContainer* rygel_media_container_construct_root (GType object_type, const gchar* title, gint child_count) {
	RygelMediaContainer * self = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = title;
	_tmp1_ = child_count;
	self = (RygelMediaContainer*) rygel_media_container_construct (object_type, "0", NULL, _tmp0_, _tmp1_);
	return self;
}


void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->get_children (self, offset, max_count, sort_criteria, cancellable, _callback_, _user_data_);
}


RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->get_children_finish (self, _res_, error);
}


void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->find_object (self, id, cancellable, _callback_, _user_data_);
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->find_object_finish (self, _res_, error);
}


/**
     * This method should be called each time this container is updated.
     *
     * For instance, this should be called if there are metadata changes
     * for this container, if items under it are removed or added, if
     * there are metadata changes to items under it, etc.
     */
void rygel_media_container_updated (RygelMediaContainer* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	RygelMediaObject* _tmp0_;
	RygelObjectEventType _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = object;
	_tmp1_ = event_type;
	_tmp2_ = sub_tree_update;
	g_signal_emit_by_name (self, "container-updated", self, _tmp0_, _tmp1_, _tmp2_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GUPnPDIDLLiteObject* rygel_media_container_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
	RygelMediaContainer * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteWriter* _tmp0_;
	GUPnPDIDLLiteContainer* _tmp1_ = NULL;
	GUPnPDIDLLiteContainer* didl_container;
	RygelMediaContainer* _tmp2_;
	GUPnPDIDLLiteContainer* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GUPnPDIDLLiteContainer* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GUPnPDIDLLiteContainer* _tmp14_;
	gint _tmp15_;
	GUPnPDIDLLiteContainer* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GUPnPDIDLLiteContainer* _tmp19_;
	GUPnPDIDLLiteContainer* _tmp20_;
	gint64 _tmp21_;
	gboolean _tmp29_ = FALSE;
	RygelMediaContainer* _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	self = (RygelMediaContainer*) base;
	g_return_val_if_fail (writer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = writer;
	_tmp1_ = gupnp_didl_lite_writer_add_container (_tmp0_);
	didl_container = _tmp1_;
	_tmp2_ = ((RygelMediaObject*) self)->parent;
	if (_tmp2_ != NULL) {
		GUPnPDIDLLiteContainer* _tmp3_;
		RygelMediaContainer* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = didl_container;
		_tmp4_ = ((RygelMediaObject*) self)->parent;
		_tmp5_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp4_);
		_tmp6_ = _tmp5_;
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp3_, _tmp6_);
	} else {
		GUPnPDIDLLiteContainer* _tmp7_;
		_tmp7_ = didl_container;
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp7_, "-1");
	}
	_tmp8_ = didl_container;
	_tmp9_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp10_ = _tmp9_;
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) _tmp8_, _tmp10_);
	_tmp11_ = didl_container;
	_tmp12_ = rygel_media_object_get_title ((RygelMediaObject*) self);
	_tmp13_ = _tmp12_;
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) _tmp11_, _tmp13_);
	_tmp14_ = didl_container;
	_tmp15_ = self->child_count;
	gupnp_didl_lite_container_set_child_count (_tmp14_, _tmp15_);
	_tmp16_ = didl_container;
	_tmp17_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) self);
	_tmp18_ = _tmp17_;
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _tmp16_, _tmp18_);
	_tmp19_ = didl_container;
	gupnp_didl_lite_container_set_searchable (_tmp19_, G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_SEARCHABLE_CONTAINER));
	_tmp20_ = didl_container;
	_tmp21_ = self->storage_used;
	gupnp_didl_lite_container_set_storage_used (_tmp20_, _tmp21_);
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
		GUPnPDIDLLiteContainer* _tmp22_;
		guint32 _tmp23_;
		GUPnPDIDLLiteContainer* _tmp24_;
		guint _tmp25_;
		guint _tmp26_;
		GUPnPDIDLLiteContainer* _tmp27_;
		gint64 _tmp28_;
		_tmp22_ = didl_container;
		_tmp23_ = self->update_id;
		gupnp_didl_lite_container_set_container_update_id (_tmp22_, (guint) _tmp23_);
		_tmp24_ = didl_container;
		_tmp25_ = rygel_media_object_get_object_update_id ((RygelMediaObject*) self);
		_tmp26_ = _tmp25_;
		gupnp_didl_lite_object_set_update_id ((GUPnPDIDLLiteObject*) _tmp24_, _tmp26_);
		_tmp27_ = didl_container;
		_tmp28_ = self->total_deleted_child_count;
		gupnp_didl_lite_container_set_total_deleted_child_count (_tmp27_, (guint) _tmp28_);
	}
	_tmp30_ = ((RygelMediaObject*) self)->parent;
	if (_tmp30_ == NULL) {
		_tmp29_ = G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_SEARCHABLE_CONTAINER);
	} else {
		_tmp29_ = FALSE;
	}
	_tmp31_ = _tmp29_;
	if (_tmp31_) {
		GUPnPDIDLLiteContainer* _tmp32_;
		_tmp32_ = didl_container;
		rygel_searchable_container_serialize_search_parameters (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) self) : NULL, _tmp32_);
	}
	_tmp33_ = rygel_media_object_get_restricted ((RygelMediaObject*) self);
	_tmp34_ = _tmp33_;
	if (!_tmp34_) {
		GUPnPDIDLLiteContainer* _tmp35_;
		GUPnPDIDLLiteContainer* _tmp36_;
		GUPnPOCMFlags _tmp37_;
		GUPnPOCMFlags _tmp38_;
		RygelWritableContainer* _tmp39_;
		RygelWritableContainer* writable;
		_tmp35_ = didl_container;
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp35_, FALSE);
		_tmp36_ = didl_container;
		_tmp37_ = rygel_media_object_get_ocm_flags ((RygelMediaObject*) self);
		_tmp38_ = _tmp37_;
		gupnp_didl_lite_object_set_dlna_managed ((GUPnPDIDLLiteObject*) _tmp36_, _tmp38_);
		_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_WRITABLE_CONTAINER) ? ((RygelWritableContainer*) self) : NULL);
		writable = _tmp39_;
		{
			RygelWritableContainer* _tmp40_;
			GeeArrayList* _tmp41_;
			GeeArrayList* _tmp42_;
			GeeArrayList* _tmp43_;
			GeeArrayList* _create_class_list;
			GeeArrayList* _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			gint _create_class_size;
			gint _create_class_index;
			_tmp40_ = writable;
			_tmp41_ = rygel_writable_container_get_create_classes (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = _g_object_ref0 (_tmp42_);
			_create_class_list = _tmp43_;
			_tmp44_ = _create_class_list;
			_tmp45_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp44_);
			_tmp46_ = _tmp45_;
			_create_class_size = _tmp46_;
			_create_class_index = -1;
			while (TRUE) {
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				GeeArrayList* _tmp50_;
				gint _tmp51_;
				gpointer _tmp52_ = NULL;
				gchar* create_class;
				GUPnPDIDLLiteContainer* _tmp53_;
				const gchar* _tmp54_;
				_tmp47_ = _create_class_index;
				_create_class_index = _tmp47_ + 1;
				_tmp48_ = _create_class_index;
				_tmp49_ = _create_class_size;
				if (!(_tmp48_ < _tmp49_)) {
					break;
				}
				_tmp50_ = _create_class_list;
				_tmp51_ = _create_class_index;
				_tmp52_ = gee_abstract_list_get ((GeeAbstractList*) _tmp50_, _tmp51_);
				create_class = (gchar*) _tmp52_;
				_tmp53_ = didl_container;
				_tmp54_ = create_class;
				gupnp_didl_lite_container_add_create_class (_tmp53_, _tmp54_);
				_g_free0 (create_class);
			}
			_g_object_unref0 (_create_class_list);
		}
		_g_object_unref0 (writable);
	} else {
		GUPnPDIDLLiteContainer* _tmp55_;
		_tmp55_ = didl_container;
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp55_, TRUE);
	}
	result = (GUPnPDIDLLiteObject*) didl_container;
	return result;
}


/**
     * handler for container_updated signal on this container. We only forward
     * it to the parent, hoping someone will get it from the root container
     * and act upon it.
     *
     * @param container the container that emitted the signal
     * @param updated_container the container that just got updated
     */
static void rygel_media_container_on_container_updated (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	RygelMediaContainer* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (updated_container != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = ((RygelMediaObject*) self)->parent;
	if (_tmp0_ != NULL) {
		RygelMediaContainer* _tmp1_;
		RygelMediaContainer* _tmp2_;
		RygelMediaObject* _tmp3_;
		RygelObjectEventType _tmp4_;
		gboolean _tmp5_;
		_tmp1_ = ((RygelMediaObject*) self)->parent;
		_tmp2_ = updated_container;
		_tmp3_ = object;
		_tmp4_ = event_type;
		_tmp5_ = sub_tree_update;
		g_signal_emit_by_name (_tmp1_, "container-updated", _tmp2_, _tmp3_, _tmp4_, _tmp5_);
	}
}


static void rygel_media_container_on_sub_tree_updates_finished (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaObject* sub_tree_root) {
	RygelMediaContainer* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (sub_tree_root != NULL);
	_tmp0_ = ((RygelMediaObject*) self)->parent;
	if (_tmp0_ != NULL) {
		RygelMediaContainer* _tmp1_;
		RygelMediaObject* _tmp2_;
		_tmp1_ = ((RygelMediaObject*) self)->parent;
		_tmp2_ = sub_tree_root;
		g_signal_emit_by_name (_tmp1_, "sub-tree-updates-finished", _tmp2_);
	}
}


const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sort_criteria;
	result = _tmp0_;
	return result;
}


void rygel_media_container_set_sort_criteria (RygelMediaContainer* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_sort_criteria);
	self->priv->_sort_criteria = _tmp1_;
	g_object_notify ((GObject *) self, "sort-criteria");
}


static GUPnPOCMFlags rygel_media_container_real_get_ocm_flags (RygelMediaObject* base) {
	GUPnPOCMFlags result;
	RygelMediaContainer* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp4_;
	GUPnPOCMFlags flags;
	gboolean allow_upload;
	RygelMetaConfig* _tmp5_ = NULL;
	RygelMetaConfig* config;
	gboolean _tmp9_;
	gboolean allow_deletion;
	gboolean _tmp14_;
	GUPnPOCMFlags _tmp17_;
	GError * _inner_error_ = NULL;
	self = (RygelMediaContainer*) base;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_WRITABLE_CONTAINER)) {
		_tmp0_ = TRUE;
	} else {
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = ((RygelMediaObject*) self)->uris;
		_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ == 0;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		result = GUPNP_OCM_FLAGS_NONE;
		return result;
	}
	flags = GUPNP_OCM_FLAGS_NONE;
	allow_upload = TRUE;
	_tmp5_ = rygel_meta_config_get_default ();
	config = _tmp5_;
	{
		RygelMetaConfig* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
		_tmp6_ = config;
		_tmp7_ = rygel_configuration_get_allow_upload ((RygelConfiguration*) _tmp6_, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		allow_upload = _tmp8_;
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp9_ = allow_upload;
	if (_tmp9_) {
		GUPnPOCMFlags _tmp10_;
		_tmp10_ = flags;
		flags = _tmp10_ | (GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE);
	}
	allow_deletion = TRUE;
	{
		RygelMetaConfig* _tmp11_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		_tmp11_ = config;
		_tmp12_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp11_, &_inner_error_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		allow_deletion = _tmp13_;
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp14_ = allow_deletion;
	if (_tmp14_) {
		GUPnPOCMFlags _tmp15_;
		_tmp15_ = flags;
		flags = _tmp15_ | GUPNP_OCM_FLAGS_DESTROYABLE;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_UPDATABLE_OBJECT)) {
		GUPnPOCMFlags _tmp16_;
		_tmp16_ = flags;
		flags = _tmp16_ | GUPNP_OCM_FLAGS_CHANGE_METADATA;
	}
	_tmp17_ = flags;
	result = _tmp17_;
	_g_object_unref0 (config);
	return result;
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_ENUM_BOOLEAN) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gboolean arg_4, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_ENUM_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_ENUM_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_enum (param_values + 3), g_value_get_boolean (param_values + 4), data2);
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaContainerPrivate));
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_container_real_serialize;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_container_real_get_ocm_flags;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_SORT_CRITERIA, g_param_spec_string ("sort-criteria", "sort-criteria", "sort-criteria", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_OCM_FLAGS, g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", gupnp_ocm_flags_get_type (), 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The container_updated signal is emitted if a child container under the
	     * tree of this container has been updated. object is set to
	     * the MediaObject being the source of container update. Note that
	     * it may be even set to container itself.
	     *
	     * @param container The child container that has been updated.
	     * @param object the object that got changed.
	     * @param event_type describes what actually happened to object.
	     * @param sub_tree_update whether the modification is part of
	     * sub-tree update.
	     */
	g_signal_new ("container_updated", RYGEL_TYPE_MEDIA_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM_BOOLEAN, G_TYPE_NONE, 4, RYGEL_TYPE_MEDIA_CONTAINER, RYGEL_TYPE_MEDIA_OBJECT, RYGEL_TYPE_OBJECT_EVENT_TYPE, G_TYPE_BOOLEAN);
	/**
	     * sub_tree_updates_finished signal is emitted when all of
	     * sub-tree operations are finished.
	     *
	     * @param sub_tree_root - root of a sub-tree where all operations
	     * were performed.
	     */
	g_signal_new ("sub_tree_updates_finished", RYGEL_TYPE_MEDIA_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_OBJECT);
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
	gchar* _tmp0_;
	self->priv = RYGEL_MEDIA_CONTAINER_GET_PRIVATE (self);
	_tmp0_ = g_strdup (RYGEL_MEDIA_CONTAINER_DEFAULT_SORT_CRITERIA);
	self->priv->_sort_criteria = _tmp0_;
}


static void rygel_media_container_finalize (GObject* obj) {
	RygelMediaContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer);
	_g_free0 (self->priv->_sort_criteria);
	G_OBJECT_CLASS (rygel_media_container_parent_class)->finalize (obj);
}


/**
 * This is a container (folder) for media items and child containers.
 *
 * It provides a basic serialization implementation (to DIDLLiteWriter).
 *
 * A derived class should provide a working implementation of get_children
 * and should emit the container_updated signal.
 */
GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


static void _vala_rygel_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer);
	switch (property_id) {
		case RYGEL_MEDIA_CONTAINER_SORT_CRITERIA:
		g_value_set_string (value, rygel_media_container_get_sort_criteria (self));
		break;
		case RYGEL_MEDIA_CONTAINER_OCM_FLAGS:
		g_value_set_flags (value, rygel_media_object_get_ocm_flags ((RygelMediaObject*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer);
	switch (property_id) {
		case RYGEL_MEDIA_CONTAINER_SORT_CRITERIA:
		rygel_media_container_set_sort_criteria (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



