/* rygel-media-export-harvester.c generated by valac 0.18.0.2-2c22, the Vala compiler
 * generated from rygel-media-export-harvester.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <rygel-server.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <rygel-core.h>


#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
typedef struct _RygelMediaExportHarvesterPrivate RygelMediaExportHarvesterPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;

#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _Block3Data Block3Data;

struct _RygelMediaExportHarvester {
	GObject parent_instance;
	RygelMediaExportHarvesterPrivate * priv;
};

struct _RygelMediaExportHarvesterClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvesterPrivate {
	GeeHashMap* tasks;
	GeeHashMap* extraction_grace_timers;
	RygelMediaExportMetadataExtractor* extractor;
	RygelMediaExportRecursiveFileMonitor* monitor;
	GCancellable* cancellable;
	GeeArrayList* _locations;
};

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
struct _Block3Data {
	int _ref_count_;
	RygelMediaExportHarvester * self;
	GFile* file;
};


static gpointer rygel_media_export_harvester_parent_class = NULL;

GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTER_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS
};
#define RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD ((guint) 5)
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable, GeeArrayList* locations);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable, GeeArrayList* locations);
static void rygel_media_export_harvester_set_locations (RygelMediaExportHarvester* self, GeeArrayList* value);
GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_new (GCancellable* cancellable);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_construct (GType object_type, GCancellable* cancellable);
static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event);
static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent, const gchar* flag);
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent, const gchar* flag);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent, const gchar* flag);
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine);
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error);
static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file, GError** error);
static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
GQuark rygel_media_export_database_error_quark (void);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
GQuark rygel_media_export_media_cache_error_quark (void);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda3_ (Block3Data* _data3_);
static gboolean ___lambda3__gsource_func (gpointer self);
static void rygel_media_export_harvester_finalize (GObject* obj);
static void _vala_rygel_media_export_harvester_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_export_harvester_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Create a new instance of the meta-data extraction manager.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	rygel_media_export_harvester_on_file_changed (self, file, other_file, event_type);
}


RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable, GeeArrayList* locations) {
	RygelMediaExportHarvester * self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	RygelMediaExportMetadataExtractor* _tmp19_;
	GCancellable* _tmp20_;
	RygelMediaExportRecursiveFileMonitor* _tmp21_;
	RygelMediaExportRecursiveFileMonitor* _tmp22_;
	GeeHashMap* _tmp23_;
	GeeHashMap* _tmp24_;
	g_return_val_if_fail (cancellable != NULL, NULL);
	g_return_val_if_fail (locations != NULL, NULL);
	self = (RygelMediaExportHarvester*) g_object_new (object_type, NULL);
	_tmp0_ = cancellable;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeEqualDataFunc) g_file_equal, NULL, NULL);
	_tmp3_ = _tmp2_;
	rygel_media_export_harvester_set_locations (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	{
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		GeeArrayList* _file_list;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _file_size;
		gint _file_index;
		_tmp4_ = locations;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_file_list = _tmp5_;
		_tmp6_ = _file_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_file_size = _tmp8_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			GFile* file;
			GFile* _tmp15_;
			gboolean _tmp16_ = FALSE;
			_tmp9_ = _file_index;
			_file_index = _tmp9_ + 1;
			_tmp10_ = _file_index;
			_tmp11_ = _file_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _file_list;
			_tmp13_ = _file_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			file = (GFile*) _tmp14_;
			_tmp15_ = file;
			_tmp16_ = g_file_query_exists (_tmp15_, NULL);
			if (_tmp16_) {
				GeeArrayList* _tmp17_;
				GFile* _tmp18_;
				_tmp17_ = self->priv->_locations;
				_tmp18_ = file;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
			}
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	_tmp19_ = rygel_media_export_metadata_extractor_new ();
	_g_object_unref0 (self->priv->extractor);
	self->priv->extractor = _tmp19_;
	_tmp20_ = cancellable;
	_tmp21_ = rygel_media_export_recursive_file_monitor_new (_tmp20_);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp21_;
	_tmp22_ = self->priv->monitor;
	g_signal_connect_object (_tmp22_, "changed", (GCallback) _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed, self, 0);
	_tmp23_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeHashDataFunc) g_file_hash, NULL, NULL, (GeeEqualDataFunc) g_file_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->tasks);
	self->priv->tasks = _tmp23_;
	_tmp24_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_UINT, NULL, NULL, (GeeHashDataFunc) g_file_hash, NULL, NULL, (GeeEqualDataFunc) g_file_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->extraction_grace_timers);
	self->priv->extraction_grace_timers = _tmp24_;
	return self;
}


RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable, GeeArrayList* locations) {
	return rygel_media_export_harvester_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, cancellable, locations);
}


/**
     * Put a file on queue for meta-data extraction
     *
     * @param file the file to investigate
     * @param parent container of the filer to be harvested
     * @param flag optional flag for the container to set in the database
     */
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
	rygel_media_export_harvester_on_file_harvested (self, _sender);
}


void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent, const gchar* flag) {
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	RygelMediaExportMetadataExtractor* _tmp2_;
	GFile* _tmp4_;
	RygelMediaExportMetadataExtractor* _tmp5_;
	RygelMediaExportMetadataExtractor* _tmp6_;
	RygelMediaExportRecursiveFileMonitor* _tmp7_;
	GFile* _tmp8_;
	RygelMediaContainer* _tmp9_;
	const gchar* _tmp10_;
	RygelMediaExportHarvestingTask* _tmp11_;
	RygelMediaExportHarvestingTask* _tmp12_;
	RygelMediaExportHarvestingTask* task;
	RygelMediaExportHarvestingTask* _tmp13_;
	GCancellable* _tmp14_;
	RygelMediaExportHarvestingTask* _tmp15_;
	GeeHashMap* _tmp16_;
	GFile* _tmp17_;
	RygelMediaExportHarvestingTask* _tmp18_;
	RygelMediaExportHarvestingTask* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (parent != NULL);
	_tmp0_ = self->priv->extraction_grace_timers;
	_tmp1_ = file;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, _tmp1_, NULL);
	_tmp2_ = self->priv->extractor;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = _ ("No metadata extractor available. Will not crawl.");
		g_warning ("rygel-media-export-harvester.vala:78: %s", _tmp3_);
		return;
	}
	_tmp4_ = file;
	rygel_media_export_harvester_cancel (self, _tmp4_);
	_tmp5_ = rygel_media_export_metadata_extractor_new ();
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->monitor;
	_tmp8_ = file;
	_tmp9_ = parent;
	_tmp10_ = flag;
	_tmp11_ = rygel_media_export_harvesting_task_new (_tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp6_);
	task = _tmp12_;
	_tmp13_ = task;
	_tmp14_ = self->priv->cancellable;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) _tmp13_, _tmp14_);
	_tmp15_ = task;
	g_signal_connect_object ((RygelStateMachine*) _tmp15_, "completed", (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self, 0);
	_tmp16_ = self->priv->tasks;
	_tmp17_ = file;
	_tmp18_ = task;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, _tmp17_, _tmp18_);
	_tmp19_ = task;
	rygel_state_machine_run ((RygelStateMachine*) _tmp19_, NULL, NULL);
	_g_object_unref0 (task);
}


/**
     * Cancel a running meta-data extraction run
     *
     * @param file file cancel the current run for
     */
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file) {
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->tasks;
	_tmp1_ = file;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (_tmp2_) {
		GeeHashMap* _tmp3_;
		GFile* _tmp4_;
		gpointer _tmp5_ = NULL;
		RygelMediaExportHarvestingTask* task;
		RygelMediaExportHarvestingTask* _tmp6_;
		guint _tmp7_ = 0U;
		GeeHashMap* _tmp8_;
		GFile* _tmp9_;
		RygelMediaExportHarvestingTask* _tmp10_;
		_tmp3_ = self->priv->tasks;
		_tmp4_ = file;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
		task = (RygelMediaExportHarvestingTask*) _tmp5_;
		_tmp6_ = task;
		g_signal_parse_name ("completed", RYGEL_TYPE_STATE_MACHINE, &_tmp7_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((RygelStateMachine*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self);
		_tmp8_ = self->priv->tasks;
		_tmp9_ = file;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp8_, _tmp9_, NULL);
		_tmp10_ = task;
		rygel_media_export_harvesting_task_cancel (_tmp10_);
		_g_object_unref0 (task);
	}
}


/**
     * Callback for finished harvester.
     *
     * Updates book-keeping hash.
     * @param state_machine HarvestingTask sending the event
     */
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine) {
	RygelStateMachine* _tmp0_;
	RygelMediaExportHarvestingTask* _tmp1_;
	RygelMediaExportHarvestingTask* task;
	RygelMediaExportHarvestingTask* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* file;
	const gchar* _tmp5_ = NULL;
	GFile* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	GeeHashMap* _tmp9_;
	GFile* _tmp10_;
	GeeHashMap* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state_machine != NULL);
	_tmp0_ = state_machine;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK) ? ((RygelMediaExportHarvestingTask*) _tmp0_) : NULL);
	task = _tmp1_;
	_tmp2_ = task;
	_tmp3_ = _tmp2_->origin;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	file = _tmp4_;
	_tmp5_ = _ ("'%s' harvested");
	_tmp6_ = file;
	_tmp7_ = g_file_get_uri (_tmp6_);
	_tmp8_ = _tmp7_;
	g_message (_tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->priv->tasks;
	_tmp10_ = file;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, _tmp10_, NULL);
	_tmp11_ = self->priv->tasks;
	_tmp12_ = gee_map_get_is_empty ((GeeMap*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		g_signal_emit_by_name (self, "done");
	}
	_g_object_unref0 (file);
	_g_object_unref0 (task);
}


static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		GFileMonitorEvent _tmp0_;
		_tmp0_ = event;
		switch (_tmp0_) {
			case G_FILE_MONITOR_EVENT_CREATED:
			case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
			{
				GFile* _tmp1_;
				_tmp1_ = file;
				rygel_media_export_harvester_on_changes_done (self, _tmp1_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch46_g_error;
				}
				break;
			}
			case G_FILE_MONITOR_EVENT_DELETED:
			{
				GFile* _tmp2_;
				_tmp2_ = file;
				rygel_media_export_harvester_on_file_removed (self, _tmp2_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch46_g_error;
				}
				break;
			}
			default:
			{
				break;
			}
		}
	}
	goto __finally46;
	__catch46_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally46:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file) {
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("rygel-media-export-harvester.vala:147: Filesystem events settled for %" \
"s, scheduling extraction…", _tmp2_);
	_g_free0 (_tmp2_);
	{
		RygelMediaExportMediaCache* _tmp3_ = NULL;
		RygelMediaExportMediaCache* cache;
		GFile* _tmp4_;
		GCancellable* _tmp5_;
		GFileInfo* _tmp6_ = NULL;
		GFileInfo* info;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		GFileInfo* _tmp11_;
		GFileType _tmp12_ = 0;
		gboolean _tmp16_;
		gboolean _tmp20_;
		gboolean _tmp24_;
		gboolean _tmp27_;
		_tmp3_ = rygel_media_export_media_cache_get_default (&_inner_error_);
		cache = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch47_g_error;
		}
		_tmp4_ = file;
		_tmp5_ = self->priv->cancellable;
		_tmp6_ = g_file_query_info (_tmp4_, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, _tmp5_, &_inner_error_);
		info = _tmp6_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (cache);
			goto __catch47_g_error;
		}
		_tmp11_ = info;
		_tmp12_ = g_file_info_get_file_type (_tmp11_);
		if (_tmp12_ == G_FILE_TYPE_DIRECTORY) {
			_tmp10_ = TRUE;
		} else {
			GFileInfo* _tmp13_;
			const gchar* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
			_tmp13_ = info;
			_tmp14_ = g_file_info_get_content_type (_tmp13_);
			_tmp15_ = g_str_has_prefix (_tmp14_, "image/");
			_tmp10_ = _tmp15_;
		}
		_tmp16_ = _tmp10_;
		if (_tmp16_) {
			_tmp9_ = TRUE;
		} else {
			GFileInfo* _tmp17_;
			const gchar* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			_tmp17_ = info;
			_tmp18_ = g_file_info_get_content_type (_tmp17_);
			_tmp19_ = g_str_has_prefix (_tmp18_, "video/");
			_tmp9_ = _tmp19_;
		}
		_tmp20_ = _tmp9_;
		if (_tmp20_) {
			_tmp8_ = TRUE;
		} else {
			GFileInfo* _tmp21_;
			const gchar* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
			_tmp21_ = info;
			_tmp22_ = g_file_info_get_content_type (_tmp21_);
			_tmp23_ = g_str_has_prefix (_tmp22_, "audio/");
			_tmp8_ = _tmp23_;
		}
		_tmp24_ = _tmp8_;
		if (_tmp24_) {
			_tmp7_ = TRUE;
		} else {
			GFileInfo* _tmp25_;
			const gchar* _tmp26_ = NULL;
			_tmp25_ = info;
			_tmp26_ = g_file_info_get_content_type (_tmp25_);
			_tmp7_ = g_strcmp0 (_tmp26_, "application/ogg") == 0;
		}
		_tmp27_ = _tmp7_;
		if (_tmp27_) {
			gchar* id = NULL;
			{
				RygelMediaContainer* parent_container;
				GFile* _tmp28_;
				GFile* _tmp29_;
				GFile* current;
				GFile* _tmp50_;
				RygelMediaContainer* _tmp51_;
				parent_container = NULL;
				_tmp28_ = file;
				_tmp29_ = _g_object_ref0 (_tmp28_);
				current = _tmp29_;
				{
					gboolean _tmp30_;
					_tmp30_ = TRUE;
					while (TRUE) {
						gboolean _tmp31_;
						GFile* _tmp33_;
						GFile* _tmp34_ = NULL;
						GFile* parent;
						GFile* _tmp35_;
						gchar* _tmp36_ = NULL;
						RygelMediaExportMediaCache* _tmp37_;
						const gchar* _tmp38_;
						RygelMediaObject* _tmp39_ = NULL;
						RygelMediaObject* _tmp40_;
						RygelMediaContainer* _tmp41_;
						GeeArrayList* _tmp44_;
						GFile* _tmp45_;
						gboolean _tmp46_ = FALSE;
						_tmp31_ = _tmp30_;
						if (!_tmp31_) {
							RygelMediaContainer* _tmp32_;
							_tmp32_ = parent_container;
							if (!(_tmp32_ == NULL)) {
								break;
							}
						}
						_tmp30_ = FALSE;
						_tmp33_ = current;
						_tmp34_ = g_file_get_parent (_tmp33_);
						parent = _tmp34_;
						_tmp35_ = parent;
						_tmp36_ = rygel_media_export_media_cache_get_id (_tmp35_);
						_g_free0 (id);
						id = _tmp36_;
						_tmp37_ = cache;
						_tmp38_ = id;
						_tmp39_ = rygel_media_export_media_cache_get_object (_tmp37_, _tmp38_, &_inner_error_);
						_tmp40_ = _tmp39_;
						if (_inner_error_ != NULL) {
							_g_object_unref0 (parent);
							_g_object_unref0 (current);
							_g_object_unref0 (parent_container);
							if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
								goto __catch48_rygel_media_export_database_error;
							}
							_g_object_unref0 (parent);
							_g_object_unref0 (current);
							_g_object_unref0 (parent_container);
							_g_free0 (id);
							_g_object_unref0 (info);
							_g_object_unref0 (cache);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_g_object_unref0 (parent_container);
						parent_container = G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp40_) : NULL;
						_tmp41_ = parent_container;
						if (_tmp41_ == NULL) {
							GFile* _tmp42_;
							GFile* _tmp43_;
							_tmp42_ = parent;
							_tmp43_ = _g_object_ref0 (_tmp42_);
							_g_object_unref0 (current);
							current = _tmp43_;
						}
						_tmp44_ = self->priv->_locations;
						_tmp45_ = current;
						_tmp46_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp44_, _tmp45_);
						if (_tmp46_) {
							RygelMediaExportMediaCache* _tmp47_;
							RygelMediaObject* _tmp48_ = NULL;
							RygelMediaObject* _tmp49_;
							_tmp47_ = cache;
							_tmp48_ = rygel_media_export_media_cache_get_object (_tmp47_, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, &_inner_error_);
							_tmp49_ = _tmp48_;
							if (_inner_error_ != NULL) {
								_g_object_unref0 (parent);
								_g_object_unref0 (current);
								_g_object_unref0 (parent_container);
								if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
									goto __catch48_rygel_media_export_database_error;
								}
								_g_object_unref0 (parent);
								_g_object_unref0 (current);
								_g_object_unref0 (parent_container);
								_g_free0 (id);
								_g_object_unref0 (info);
								_g_object_unref0 (cache);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_g_object_unref0 (parent_container);
							parent_container = G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp49_) : NULL;
							_g_object_unref0 (parent);
							break;
						}
						_g_object_unref0 (parent);
					}
				}
				_tmp50_ = current;
				_tmp51_ = parent_container;
				rygel_media_export_harvester_schedule (self, _tmp50_, _tmp51_, NULL);
				_g_object_unref0 (current);
				_g_object_unref0 (parent_container);
			}
			goto __finally48;
			__catch48_rygel_media_export_database_error:
			{
				GError* _error_ = NULL;
				const gchar* _tmp52_ = NULL;
				const gchar* _tmp53_;
				GError* _tmp54_;
				const gchar* _tmp55_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				_tmp52_ = _ ("Error fetching object '%s' from database: %s");
				_tmp53_ = id;
				_tmp54_ = _error_;
				_tmp55_ = _tmp54_->message;
				g_warning (_tmp52_, _tmp53_, _tmp55_);
				_g_error_free0 (_error_);
			}
			__finally48:
			if (_inner_error_ != NULL) {
				_g_free0 (id);
				_g_object_unref0 (info);
				_g_object_unref0 (cache);
				goto __catch47_g_error;
			}
			_g_free0 (id);
		} else {
			GFile* _tmp56_;
			gchar* _tmp57_ = NULL;
			gchar* _tmp58_;
			_tmp56_ = file;
			_tmp57_ = g_file_get_uri (_tmp56_);
			_tmp58_ = _tmp57_;
			g_debug ("rygel-media-export-harvester.vala:191: %s is not eligible for extracti" \
"on", _tmp58_);
			_g_free0 (_tmp58_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (cache);
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp59_ = NULL;
		GError* _tmp60_;
		const gchar* _tmp61_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp59_ = _ ("Failed to access media cache: %s");
		_tmp60_ = _error_;
		_tmp61_ = _tmp60_->message;
		g_warning (_tmp59_, _tmp61_);
		_g_error_free0 (_error_);
	}
	__finally47:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file, GError** error) {
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	RygelMediaExportMediaCache* cache;
	GeeHashMap* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = rygel_media_export_media_cache_get_default (&_inner_error_);
	cache = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = self->priv->extraction_grace_timers;
	_tmp2_ = file;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_);
	if (_tmp3_) {
		GeeHashMap* _tmp4_;
		GFile* _tmp5_;
		gpointer _tmp6_ = NULL;
		GeeHashMap* _tmp7_;
		GFile* _tmp8_;
		_tmp4_ = self->priv->extraction_grace_timers;
		_tmp5_ = file;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
		g_source_remove ((guint) ((guintptr) _tmp6_));
		_tmp7_ = self->priv->extraction_grace_timers;
		_tmp8_ = file;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, _tmp8_, NULL);
	}
	_tmp9_ = file;
	rygel_media_export_harvester_cancel (self, _tmp9_);
	{
		GFile* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* id;
		const gchar* _tmp12_;
		RygelMediaObject* _tmp13_ = NULL;
		RygelMediaObject* object;
		RygelMediaContainer* _tmp14_;
		RygelMediaContainer* parent;
		RygelMediaContainer* _tmp27_;
		_tmp10_ = file;
		_tmp11_ = rygel_media_export_media_cache_get_id (_tmp10_);
		id = _tmp11_;
		_tmp12_ = id;
		_tmp13_ = rygel_media_export_media_cache_get_object (cache, _tmp12_, &_inner_error_);
		object = _tmp13_;
		if (_inner_error_ != NULL) {
			_g_free0 (id);
			goto __catch49_g_error;
		}
		_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (NULL, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) NULL) : NULL);
		parent = _tmp14_;
		while (TRUE) {
			RygelMediaObject* _tmp15_;
			RygelMediaObject* _tmp16_;
			RygelMediaContainer* _tmp17_;
			RygelMediaContainer* _tmp18_;
			RygelMediaObject* _tmp19_;
			RygelMediaContainer* _tmp20_;
			RygelMediaContainer* _tmp21_;
			gint _tmp22_;
			RygelMediaContainer* _tmp23_;
			gint _tmp24_;
			RygelMediaContainer* _tmp25_;
			RygelMediaObject* _tmp26_;
			_tmp15_ = object;
			if (!(_tmp15_ != NULL)) {
				break;
			}
			_tmp16_ = object;
			_tmp17_ = _tmp16_->parent;
			_tmp18_ = _g_object_ref0 (_tmp17_);
			_g_object_unref0 (parent);
			parent = _tmp18_;
			_tmp19_ = object;
			rygel_media_export_media_cache_remove_object (cache, _tmp19_, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				_g_object_unref0 (object);
				_g_free0 (id);
				goto __catch49_g_error;
			}
			_tmp20_ = parent;
			if (_tmp20_ == NULL) {
				break;
			}
			_tmp21_ = parent;
			_tmp22_ = _tmp21_->child_count;
			_tmp21_->child_count = _tmp22_ - 1;
			_tmp23_ = parent;
			_tmp24_ = _tmp23_->child_count;
			if (_tmp24_ != 0) {
				break;
			}
			_tmp25_ = parent;
			_tmp26_ = _g_object_ref0 ((RygelMediaObject*) _tmp25_);
			_g_object_unref0 (object);
			object = _tmp26_;
		}
		_tmp27_ = parent;
		if (_tmp27_ != NULL) {
			RygelMediaContainer* _tmp28_;
			_tmp28_ = parent;
			rygel_media_container_updated (_tmp28_, (RygelMediaObject*) self, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
		}
		_g_object_unref0 (parent);
		_g_object_unref0 (object);
		_g_free0 (id);
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp29_ = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp29_ = _ ("Error removing object from database: %s");
		_tmp30_ = _error_;
		_tmp31_ = _tmp30_->message;
		g_warning (_tmp29_, _tmp31_);
		_g_error_free0 (_error_);
	}
	__finally49:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (cache);
		return;
	}
	_g_object_unref0 (cache);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		RygelMediaExportHarvester * self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->file);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean __lambda3_ (Block3Data* _data3_) {
	RygelMediaExportHarvester * self;
	gboolean result = FALSE;
	GFile* _tmp0_;
	self = _data3_->self;
	_tmp0_ = _data3_->file;
	rygel_media_export_harvester_on_file_added (self, _tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
	return result;
}


static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error) {
	Block3Data* _data3_;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GeeHashMap* _tmp2_;
	GFile* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GSourceFunc callback;
	void* callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GSourceFunc _tmp11_;
	void* _tmp11__target;
	GDestroyNotify _tmp11__target_destroy_notify;
	guint _tmp12_ = 0U;
	guint timeout;
	GeeHashMap* _tmp13_;
	GFile* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data3_->file);
	_data3_->file = _tmp1_;
	_tmp2_ = self->priv->extraction_grace_timers;
	_tmp3_ = _data3_->file;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_);
	if (_tmp4_) {
		GeeHashMap* _tmp5_;
		GFile* _tmp6_;
		gpointer _tmp7_ = NULL;
		_tmp5_ = self->priv->extraction_grace_timers;
		_tmp6_ = _data3_->file;
		_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp6_);
		g_source_remove ((guint) ((guintptr) _tmp7_));
	} else {
		GFile* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp8_ = _data3_->file;
		_tmp9_ = g_file_get_uri (_tmp8_);
		_tmp10_ = _tmp9_;
		g_debug ("rygel-media-export-harvester.vala:242: Starting grace timer for harves" \
"ting %s…", _tmp10_);
		_g_free0 (_tmp10_);
	}
	callback = ___lambda3__gsource_func;
	callback_target = block3_data_ref (_data3_);
	callback_target_destroy_notify = block3_data_unref;
	_tmp11_ = callback;
	_tmp11__target = callback_target;
	_tmp11__target_destroy_notify = callback_target_destroy_notify;
	callback_target_destroy_notify = NULL;
	_tmp12_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD, _tmp11_, _tmp11__target, _tmp11__target_destroy_notify);
	timeout = _tmp12_;
	_tmp13_ = self->priv->extraction_grace_timers;
	_tmp14_ = _data3_->file;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp14_, (gpointer) ((guintptr) timeout));
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_locations;
	result = _tmp0_;
	return result;
}


static void rygel_media_export_harvester_set_locations (RygelMediaExportHarvester* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_locations);
	self->priv->_locations = _tmp1_;
	g_object_notify ((GObject *) self, "locations");
}


static void rygel_media_export_harvester_class_init (RygelMediaExportHarvesterClass * klass) {
	rygel_media_export_harvester_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvesterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_harvester_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_harvester_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvester_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS, g_param_spec_object ("locations", "locations", "locations", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("done", RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void rygel_media_export_harvester_instance_init (RygelMediaExportHarvester * self) {
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE (self);
}


static void rygel_media_export_harvester_finalize (GObject* obj) {
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
	_g_object_unref0 (self->priv->tasks);
	_g_object_unref0 (self->priv->extraction_grace_timers);
	_g_object_unref0 (self->priv->extractor);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->_locations);
	G_OBJECT_CLASS (rygel_media_export_harvester_parent_class)->finalize (obj);
}


/**
 * This class takes care of the book-keeping of running and finished
 * extraction tasks running within the media-export plugin
 */
GType rygel_media_export_harvester_get_type (void) {
	static volatile gsize rygel_media_export_harvester_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvester), 0, (GInstanceInitFunc) rygel_media_export_harvester_instance_init, NULL };
		GType rygel_media_export_harvester_type_id;
		rygel_media_export_harvester_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvester", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_harvester_type_id__volatile, rygel_media_export_harvester_type_id);
	}
	return rygel_media_export_harvester_type_id__volatile;
}


static void _vala_rygel_media_export_harvester_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS:
		g_value_set_object (value, rygel_media_export_harvester_get_locations (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_export_harvester_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS:
		rygel_media_export_harvester_set_locations (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



