/* rygel-http-time-seek.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-http-time-seek.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
typedef struct _RygelHTTPSeekPrivate RygelHTTPSeekPrivate;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;
typedef struct _RygelHTTPTimeSeekPrivate RygelHTTPTimeSeekPrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_SEEK_TYPE (rygel_http_seek_type_get_type ())

struct _RygelHTTPSeek {
	GObject parent_instance;
	RygelHTTPSeekPrivate * priv;
};

struct _RygelHTTPSeekClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPSeek* self);
};

struct _RygelHTTPTimeSeek {
	RygelHTTPSeek parent_instance;
	RygelHTTPTimeSeekPrivate * priv;
};

struct _RygelHTTPTimeSeekClass {
	RygelHTTPSeekClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupMessage* msg;
	RygelMediaItem* item;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPTranscodeHandler* handler;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	GObject parent_instance;
	RygelMediaItemPrivate * priv;
	gint64 size;
};

struct _RygelMediaItemClass {
	GObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_TYPE_BYTE,
	RYGEL_HTTP_SEEK_TYPE_TIME
} RygelHTTPSeekType;


static gpointer rygel_http_time_seek_parent_class = NULL;

GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TIME_SEEK_DUMMY_PROPERTY
};
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_error_quark (void);
RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
static gboolean rygel_http_time_seek_parse_seconds (const gchar* range_token, gint64* value);
static gboolean rygel_http_time_seek_parse_time (const gchar* range_token, gint64* value);
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, SoupMessage* msg, gint64 start, gint64 stop, gint64 step, gint64 total_length, GError** error);
GType rygel_http_seek_type_get_type (void) G_GNUC_CONST;
void rygel_http_seek_set_seek_type (RygelHTTPSeek* self, RygelHTTPSeekType value);
gboolean rygel_http_time_seek_needed (RygelHTTPGet* request);
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gboolean rygel_http_time_seek_requested (RygelHTTPGet* request);
static void rygel_http_time_seek_real_add_response_headers (RygelHTTPSeek* base);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
SoupMessage* rygel_http_seek_get_msg (RygelHTTPSeek* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1144 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1144 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 246 "rygel-http-time-seek.c"
		glong _tmp4_;
#line 1145 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1145 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1145 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 254 "rygel-http-time-seek.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 266 "rygel-http-time-seek.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1154 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 291 "rygel-http-time-seek.c"
		glong _tmp2_;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 297 "rygel-http-time-seek.c"
	} else {
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 301 "rygel-http-time-seek.c"
	}
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 307 "rygel-http-time-seek.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 319 "rygel-http-time-seek.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1160 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1160 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1160 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 329 "rygel-http-time-seek.c"
	}
#line 1163 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1163 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 335 "rygel-http-time-seek.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1164 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1164 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1164 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1165 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1165 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 349 "rygel-http-time-seek.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1167 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1167 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1167 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 359 "rygel-http-time-seek.c"
	}
#line 1169 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1169 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 365 "rygel-http-time-seek.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1170 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1170 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1170 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 374 "rygel-http-time-seek.c"
	}
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	return result;
#line 394 "rygel-http-time-seek.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
#line 884 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 884 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 885 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 885 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 885 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 885 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 887 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 887 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 421 "rygel-http-time-seek.c"
		gchar* _tmp4_;
#line 888 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 888 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 888 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 429 "rygel-http-time-seek.c"
	} else {
#line 890 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = -1;
#line 890 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 435 "rygel-http-time-seek.c"
	}
}


RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error) {
	RygelHTTPTimeSeek * self = NULL;
	gchar* range = NULL;
	gchar** range_tokens = NULL;
	gint range_tokens_length1 = 0;
	gint _range_tokens_size_ = 0;
	gint64 start;
	RygelHTTPGet* _tmp0_;
	RygelMediaItem* _tmp1_;
	gint64 _tmp2_;
	gint64 duration;
	gint64 _tmp3_;
	gint64 stop;
	gint64 parsed_value;
	gboolean parsing_start;
	RygelHTTPGet* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessageHeaders* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	RygelHTTPGet* _tmp55_;
	SoupMessage* _tmp56_;
	gint64 _tmp57_;
	gint64 _tmp58_;
	gint64 _tmp59_;
	GError * _inner_error_ = NULL;
#line 27 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	start = (gint64) 0;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp0_ = request;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp1_ = _tmp0_->item;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp2_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp1_) : NULL)->duration;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	duration = _tmp2_ * G_TIME_SPAN_SECOND;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp3_ = duration;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	stop = _tmp3_ - G_TIME_SPAN_MILLISECOND;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	parsed_value = (gint64) 0;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	parsing_start = TRUE;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp4_ = request;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp5_ = _tmp4_->msg;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp6_ = _tmp5_->request_headers;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp7_ = soup_message_headers_get_one (_tmp6_, "TimeSeekRange.dlna.org");
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_g_free0 (range);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	range = _tmp8_;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp9_ = range;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	if (_tmp9_ != NULL) {
#line 505 "rygel-http-time-seek.c"
		const gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar** _tmp17_;
		gchar** _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		gboolean _tmp25_;
		gboolean _tmp28_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		gint64 _tmp50_;
		gint64 _tmp51_;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp10_ = range;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp11_ = g_str_has_prefix (_tmp10_, "npt=");
#line 39 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		if (!_tmp11_) {
#line 530 "rygel-http-time-seek.c"
			const gchar* _tmp12_;
			GError* _tmp13_;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp12_ = range;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp13_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, "Invalid Range '%s'", _tmp12_);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_inner_error_ = _tmp13_;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				g_propagate_error (error, _inner_error_);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_g_free0 (range);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_g_object_unref0 (self);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				return NULL;
#line 551 "rygel-http-time-seek.c"
			} else {
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_g_free0 (range);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				g_clear_error (&_inner_error_);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				return NULL;
#line 563 "rygel-http-time-seek.c"
			}
		}
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp14_ = range;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp15_ = string_substring (_tmp14_, (glong) 4, (glong) (-1));
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp16_ = _tmp15_;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "-", 2);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		range_tokens = _tmp18_;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		range_tokens_length1 = _vala_array_length (_tmp17_);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_range_tokens_size_ = range_tokens_length1;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_g_free0 (_tmp16_);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp21_ = range_tokens;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp21__length1 = range_tokens_length1;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp22_ = _tmp21_[0];
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		if (_tmp22_ == NULL) {
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp20_ = TRUE;
#line 594 "rygel-http-time-seek.c"
		} else {
			gchar** _tmp23_;
			gint _tmp23__length1;
			const gchar* _tmp24_;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp23_ = range_tokens;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp23__length1 = range_tokens_length1;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp24_ = _tmp23_[0];
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp20_ = g_strcmp0 (_tmp24_, "") == 0;
#line 607 "rygel-http-time-seek.c"
		}
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp25_ = _tmp20_;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		if (_tmp25_) {
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp19_ = TRUE;
#line 615 "rygel-http-time-seek.c"
		} else {
			gchar** _tmp26_;
			gint _tmp26__length1;
			const gchar* _tmp27_;
#line 48 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp26_ = range_tokens;
#line 48 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp26__length1 = range_tokens_length1;
#line 48 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp27_ = _tmp26_[1];
#line 48 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp19_ = _tmp27_ == NULL;
#line 628 "rygel-http-time-seek.c"
		}
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp28_ = _tmp19_;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		if (_tmp28_) {
#line 634 "rygel-http-time-seek.c"
			const gchar* _tmp29_ = NULL;
			const gchar* _tmp30_;
			GError* _tmp31_;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp29_ = _ ("Invalid Range '%s'");
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp30_ = range;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp31_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp29_, _tmp30_);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_inner_error_ = _tmp31_;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				g_propagate_error (error, _inner_error_);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_g_free0 (range);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_g_object_unref0 (self);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				return NULL;
#line 658 "rygel-http-time-seek.c"
			} else {
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_g_free0 (range);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				g_clear_error (&_inner_error_);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				return NULL;
#line 670 "rygel-http-time-seek.c"
			}
		}
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp32_ = range_tokens;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp32__length1 = range_tokens_length1;
#line 677 "rygel-http-time-seek.c"
		{
			gchar** range_token_collection = NULL;
			gint range_token_collection_length1 = 0;
			gint _range_token_collection_size_ = 0;
			gint range_token_it = 0;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			range_token_collection = _tmp32_;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			range_token_collection_length1 = _tmp32__length1;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			for (range_token_it = 0; range_token_it < _tmp32__length1; range_token_it = range_token_it + 1) {
#line 689 "rygel-http-time-seek.c"
				gchar* _tmp33_;
				gchar* range_token = NULL;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_tmp33_ = g_strdup (range_token_collection[range_token_it]);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				range_token = _tmp33_;
#line 696 "rygel-http-time-seek.c"
				{
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					gint _tmp36_ = 0;
					gboolean _tmp47_;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					_tmp34_ = range_token;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					if (g_strcmp0 (_tmp34_, "") == 0) {
#line 55 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
						_g_free0 (range_token);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
						continue;
#line 710 "rygel-http-time-seek.c"
					}
#line 58 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					_tmp35_ = range_token;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					_tmp36_ = string_index_of (_tmp35_, ":", 0);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					if (_tmp36_ == (-1)) {
#line 718 "rygel-http-time-seek.c"
						const gchar* _tmp37_;
						gboolean _tmp38_ = FALSE;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
						_tmp37_ = range_token;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
						_tmp38_ = rygel_http_time_seek_parse_seconds (_tmp37_, &parsed_value);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
						if (!_tmp38_) {
#line 727 "rygel-http-time-seek.c"
							const gchar* _tmp39_ = NULL;
							const gchar* _tmp40_;
							GError* _tmp41_;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
							_tmp39_ = _ ("Invalid Range '%s'");
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
							_tmp40_ = range;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
							_tmp41_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp39_, _tmp40_);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
							_inner_error_ = _tmp41_;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
							if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								g_propagate_error (error, _inner_error_);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								_g_free0 (range_token);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								_g_free0 (range);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								_g_object_unref0 (self);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								return NULL;
#line 753 "rygel-http-time-seek.c"
							} else {
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								_g_free0 (range_token);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								_g_free0 (range);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								g_clear_error (&_inner_error_);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								return NULL;
#line 767 "rygel-http-time-seek.c"
							}
						}
					} else {
						const gchar* _tmp42_;
						gboolean _tmp43_ = FALSE;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
						_tmp42_ = range_token;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
						_tmp43_ = rygel_http_time_seek_parse_time (_tmp42_, &parsed_value);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
						if (!_tmp43_) {
#line 779 "rygel-http-time-seek.c"
							const gchar* _tmp44_ = NULL;
							const gchar* _tmp45_;
							GError* _tmp46_;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
							_tmp44_ = _ ("Invalid Range '%s'");
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
							_tmp45_ = range;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
							_tmp46_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp44_, _tmp45_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
							_inner_error_ = _tmp46_;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
							if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								g_propagate_error (error, _inner_error_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								_g_free0 (range_token);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								_g_free0 (range);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								_g_object_unref0 (self);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								return NULL;
#line 805 "rygel-http-time-seek.c"
							} else {
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								_g_free0 (range_token);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								_g_free0 (range);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								g_clear_error (&_inner_error_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
								return NULL;
#line 819 "rygel-http-time-seek.c"
							}
						}
					}
#line 73 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					_tmp47_ = parsing_start;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					if (_tmp47_) {
#line 827 "rygel-http-time-seek.c"
						gint64 _tmp48_;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
						parsing_start = FALSE;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
						_tmp48_ = parsed_value;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
						start = _tmp48_;
#line 835 "rygel-http-time-seek.c"
					} else {
						gint64 _tmp49_;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
						_tmp49_ = parsed_value;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
						stop = _tmp49_;
#line 842 "rygel-http-time-seek.c"
					}
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					_g_free0 (range_token);
#line 846 "rygel-http-time-seek.c"
				}
			}
		}
#line 81 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp50_ = start;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp51_ = stop;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		if (_tmp50_ > _tmp51_) {
#line 856 "rygel-http-time-seek.c"
			const gchar* _tmp52_ = NULL;
			const gchar* _tmp53_;
			GError* _tmp54_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp52_ = _ ("Invalid Range '%s'");
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp53_ = range;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp54_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp52_, _tmp53_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_inner_error_ = _tmp54_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				g_propagate_error (error, _inner_error_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_g_free0 (range);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_g_object_unref0 (self);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				return NULL;
#line 880 "rygel-http-time-seek.c"
			} else {
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_g_free0 (range);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				g_clear_error (&_inner_error_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				return NULL;
#line 892 "rygel-http-time-seek.c"
			}
		}
	}
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp55_ = request;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp56_ = _tmp55_->msg;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp57_ = start;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp58_ = stop;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp59_ = duration;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	self = (RygelHTTPTimeSeek*) rygel_http_seek_construct (object_type, _tmp56_, _tmp57_, _tmp58_, (gint64) G_TIME_SPAN_MILLISECOND, _tmp59_, &_inner_error_);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	if (_inner_error_ != NULL) {
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			g_propagate_error (error, _inner_error_);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_g_free0 (range);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_g_object_unref0 (self);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			return NULL;
#line 922 "rygel-http-time-seek.c"
		} else {
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_g_free0 (range);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			g_clear_error (&_inner_error_);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			return NULL;
#line 934 "rygel-http-time-seek.c"
		}
	}
#line 89 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	rygel_http_seek_set_seek_type ((RygelHTTPSeek*) self, RYGEL_HTTP_SEEK_TYPE_TIME);
#line 27 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 27 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_g_free0 (range);
#line 27 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	return self;
#line 945 "rygel-http-time-seek.c"
}


RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error) {
#line 27 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	return rygel_http_time_seek_construct (RYGEL_TYPE_HTTP_TIME_SEEK, request, error);
#line 952 "rygel-http-time-seek.c"
}


gboolean rygel_http_time_seek_needed (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	RygelHTTPGet* _tmp2_;
	RygelMediaItem* _tmp3_;
	gboolean _tmp7_;
	gboolean _tmp23_;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp2_ = request;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp3_ = _tmp2_->item;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, RYGEL_TYPE_AUDIO_ITEM)) {
#line 972 "rygel-http-time-seek.c"
		RygelHTTPGet* _tmp4_;
		RygelMediaItem* _tmp5_;
		gint64 _tmp6_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp4_ = request;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp5_ = _tmp4_->item;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp6_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp5_) : NULL)->duration;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp1_ = _tmp6_ > ((gint64) 0);
#line 984 "rygel-http-time-seek.c"
	} else {
#line 93 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp1_ = FALSE;
#line 988 "rygel-http-time-seek.c"
	}
#line 93 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp7_ = _tmp1_;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	if (_tmp7_) {
#line 994 "rygel-http-time-seek.c"
		gboolean _tmp8_ = FALSE;
		RygelHTTPGet* _tmp9_;
		RygelHTTPTranscodeHandler* _tmp10_;
		gboolean _tmp22_;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp9_ = request;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp10_ = _tmp9_->handler;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, RYGEL_TYPE_HTTP_TRANSCODE_HANDLER)) {
#line 95 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp8_ = TRUE;
#line 1007 "rygel-http-time-seek.c"
		} else {
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			RygelHTTPGet* _tmp13_;
			RygelThumbnail* _tmp14_;
			gboolean _tmp17_;
			gboolean _tmp21_;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp13_ = request;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp14_ = _tmp13_->thumbnail;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			if (_tmp14_ == NULL) {
#line 1021 "rygel-http-time-seek.c"
				RygelHTTPGet* _tmp15_;
				RygelSubtitle* _tmp16_;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_tmp15_ = request;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_tmp16_ = _tmp15_->subtitle;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_tmp12_ = _tmp16_ == NULL;
#line 1030 "rygel-http-time-seek.c"
			} else {
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_tmp12_ = FALSE;
#line 1034 "rygel-http-time-seek.c"
			}
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp17_ = _tmp12_;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			if (_tmp17_) {
#line 1040 "rygel-http-time-seek.c"
				RygelHTTPGet* _tmp18_;
				RygelMediaItem* _tmp19_;
				gboolean _tmp20_ = FALSE;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_tmp18_ = request;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_tmp19_ = _tmp18_->item;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_tmp20_ = rygel_media_item_is_live_stream (_tmp19_);
#line 98 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_tmp11_ = _tmp20_;
#line 1052 "rygel-http-time-seek.c"
			} else {
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_tmp11_ = FALSE;
#line 1056 "rygel-http-time-seek.c"
			}
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp21_ = _tmp11_;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp8_ = _tmp21_;
#line 1062 "rygel-http-time-seek.c"
		}
#line 95 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp22_ = _tmp8_;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp0_ = _tmp22_;
#line 1068 "rygel-http-time-seek.c"
	} else {
#line 93 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp0_ = FALSE;
#line 1072 "rygel-http-time-seek.c"
	}
#line 93 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp23_ = _tmp0_;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	result = _tmp23_;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	return result;
#line 1080 "rygel-http-time-seek.c"
}


gboolean rygel_http_time_seek_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessageHeaders* _tmp2_;
	const gchar* _tmp3_ = NULL;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 102 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp0_ = request;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp1_ = _tmp0_->msg;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp2_ = _tmp1_->request_headers;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp3_ = soup_message_headers_get_one (_tmp2_, "TimeSeekRange.dlna.org");
#line 102 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	result = _tmp3_ != NULL;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	return result;
#line 1104 "rygel-http-time-seek.c"
}


static void rygel_http_time_seek_real_add_response_headers (RygelHTTPSeek* base) {
	RygelHTTPTimeSeek * self;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gdouble start;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gdouble stop;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gdouble total;
	gchar* _tmp6_ = NULL;
	gchar* start_str;
	gint start_str_length1;
	gint _start_str_size_;
	gchar* _tmp7_ = NULL;
	gchar* stop_str;
	gint stop_str_length1;
	gint _stop_str_size_;
	gchar* _tmp8_ = NULL;
	gchar* total_str;
	gint total_str_length1;
	gint _total_str_size_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* range;
	SoupMessage* _tmp22_;
	SoupMessage* _tmp23_;
	SoupMessageHeaders* _tmp24_;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	self = (RygelHTTPTimeSeek*) base;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp0_ = rygel_http_seek_get_start ((RygelHTTPSeek*) self);
#line 108 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp1_ = _tmp0_;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	start = ((gdouble) _tmp1_) / G_TIME_SPAN_SECOND;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp2_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) self);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp3_ = _tmp2_;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	stop = ((gdouble) _tmp3_) / G_TIME_SPAN_SECOND;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp4_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) self);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp5_ = _tmp4_;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	total = ((gdouble) _tmp5_) / G_TIME_SPAN_SECOND;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp6_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	start_str = _tmp6_;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	start_str_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_start_str_size_ = start_str_length1;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp7_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	stop_str = _tmp7_;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	stop_str_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_stop_str_size_ = stop_str_length1;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp8_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	total_str = _tmp8_;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	total_str_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_total_str_size_ = total_str_length1;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp9_ = g_ascii_formatd (start_str, start_str_length1, "%.3f", start);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp10_ = g_strconcat ("npt=", _tmp9_, NULL);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp11_ = _tmp10_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp12_ = g_strconcat (_tmp11_, "-", NULL);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp13_ = _tmp12_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp14_ = g_ascii_formatd (stop_str, stop_str_length1, "%.3f", stop);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp15_ = g_strconcat (_tmp13_, _tmp14_, NULL);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp16_ = _tmp15_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp17_ = g_strconcat (_tmp16_, "/", NULL);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp18_ = _tmp17_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp19_ = g_ascii_formatd (total_str, total_str_length1, "%.3f", total);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp21_ = _tmp20_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_g_free0 (_tmp18_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_g_free0 (_tmp16_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_g_free0 (_tmp13_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_g_free0 (_tmp11_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	range = _tmp21_;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp22_ = rygel_http_seek_get_msg ((RygelHTTPSeek*) self);
#line 120 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp23_ = _tmp22_;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp24_ = _tmp23_->response_headers;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	soup_message_headers_append (_tmp24_, "TimeSeekRange.dlna.org", range);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_g_free0 (range);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	total_str = (g_free (total_str), NULL);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	stop_str = (g_free (stop_str), NULL);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	start_str = (g_free (start_str), NULL);
#line 1244 "rygel-http-time-seek.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
#line 951 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 952 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 952 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 952 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 952 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	return result;
#line 1262 "rygel-http-time-seek.c"
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_;
	gdouble _tmp1_ = 0.0;
#line 773 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0.0);
#line 774 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 774 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
#line 774 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 774 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	return result;
#line 1280 "rygel-http-time-seek.c"
}


static gboolean rygel_http_time_seek_parse_seconds (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar _tmp1_ = '\0';
	gboolean _tmp2_ = FALSE;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	g_return_val_if_fail (range_token != NULL, FALSE);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp0_ = range_token;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp1_ = string_get (_tmp0_, (glong) 0);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp2_ = g_ascii_isdigit (_tmp1_);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	if (_tmp2_) {
#line 1299 "rygel-http-time-seek.c"
		const gchar* _tmp3_;
		gdouble _tmp4_ = 0.0;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp3_ = range_token;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp4_ = double_parse (_tmp3_);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		*value = (gint64) (_tmp4_ * G_TIME_SPAN_SECOND);
#line 1308 "rygel-http-time-seek.c"
	} else {
#line 129 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		result = FALSE;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		return result;
#line 1314 "rygel-http-time-seek.c"
	}
#line 131 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	result = TRUE;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	return result;
#line 1320 "rygel-http-time-seek.c"
}


static gboolean rygel_http_time_seek_parse_time (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	gint64 seconds_sum;
	gint time_factor;
	gchar** time_tokens = NULL;
	gint time_tokens_length1 = 0;
	gint _time_tokens_size_ = 0;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gboolean _tmp9_;
	gboolean _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gint64 _tmp23_;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	g_return_val_if_fail (range_token != NULL, FALSE);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	seconds_sum = (gint64) 0;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	time_factor = 0;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	seconds_sum = (gint64) 0;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	time_factor = 3600;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp0_ = range_token;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ":", 3);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	time_tokens = _tmp2_;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	time_tokens_length1 = _vala_array_length (_tmp1_);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_time_tokens_size_ = time_tokens_length1;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp5_ = time_tokens;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp5__length1 = time_tokens_length1;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp6_ = _tmp5_[0];
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	if (_tmp6_ == NULL) {
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp4_ = TRUE;
#line 1376 "rygel-http-time-seek.c"
	} else {
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp7_ = time_tokens;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp7__length1 = time_tokens_length1;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp8_ = _tmp7_[1];
#line 146 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp4_ = _tmp8_ == NULL;
#line 1389 "rygel-http-time-seek.c"
	}
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp9_ = _tmp4_;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	if (_tmp9_) {
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp3_ = TRUE;
#line 1397 "rygel-http-time-seek.c"
	} else {
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp10_ = time_tokens;
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp10__length1 = time_tokens_length1;
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp11_ = _tmp10_[2];
#line 147 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		_tmp3_ = _tmp11_ == NULL;
#line 1410 "rygel-http-time-seek.c"
	}
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp12_ = _tmp3_;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	if (_tmp12_) {
#line 148 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		result = FALSE;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		return result;
#line 1422 "rygel-http-time-seek.c"
	}
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp13_ = time_tokens;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp13__length1 = time_tokens_length1;
#line 1428 "rygel-http-time-seek.c"
	{
		gchar** time_collection = NULL;
		gint time_collection_length1 = 0;
		gint _time_collection_size_ = 0;
		gint time_it = 0;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		time_collection = _tmp13_;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		time_collection_length1 = _tmp13__length1;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
		for (time_it = 0; time_it < _tmp13__length1; time_it = time_it + 1) {
#line 1440 "rygel-http-time-seek.c"
			gchar* _tmp14_;
			gchar* time = NULL;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			_tmp14_ = g_strdup (time_collection[time_it]);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
			time = _tmp14_;
#line 1447 "rygel-http-time-seek.c"
			{
				const gchar* _tmp15_;
				gchar _tmp16_ = '\0';
				gboolean _tmp17_ = FALSE;
				gint _tmp22_;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_tmp15_ = time;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_tmp16_ = string_get (_tmp15_, (glong) 0);
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_tmp17_ = g_ascii_isdigit (_tmp16_);
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				if (_tmp17_) {
#line 1461 "rygel-http-time-seek.c"
					gint64 _tmp18_;
					const gchar* _tmp19_;
					gdouble _tmp20_ = 0.0;
					gint _tmp21_;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					_tmp18_ = seconds_sum;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					_tmp19_ = time;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					_tmp20_ = double_parse (_tmp19_);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					_tmp21_ = time_factor;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					seconds_sum = _tmp18_ + ((gint64) ((_tmp20_ * G_TIME_SPAN_SECOND) * _tmp21_));
#line 1476 "rygel-http-time-seek.c"
				} else {
#line 156 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					result = FALSE;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					_g_free0 (time);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
					return result;
#line 1486 "rygel-http-time-seek.c"
				}
#line 158 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_tmp22_ = time_factor;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				time_factor = _tmp22_ / 60;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
				_g_free0 (time);
#line 1494 "rygel-http-time-seek.c"
			}
		}
	}
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	_tmp23_ = seconds_sum;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	*value = _tmp23_;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	result = TRUE;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	return result;
#line 1508 "rygel-http-time-seek.c"
}


static void rygel_http_time_seek_class_init (RygelHTTPTimeSeekClass * klass) {
#line 26 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	rygel_http_time_seek_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/jens/Source/rygel/tests/rygel-http-time-seek.vala"
	RYGEL_HTTP_SEEK_CLASS (klass)->add_response_headers = rygel_http_time_seek_real_add_response_headers;
#line 1517 "rygel-http-time-seek.c"
}


static void rygel_http_time_seek_instance_init (RygelHTTPTimeSeek * self) {
}


GType rygel_http_time_seek_get_type (void) {
	static volatile gsize rygel_http_time_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeek), 0, (GInstanceInitFunc) rygel_http_time_seek_instance_init, NULL };
		GType rygel_http_time_seek_type_id;
		rygel_http_time_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelHTTPTimeSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_type_id__volatile, rygel_http_time_seek_type_id);
	}
	return rygel_http_time_seek_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



