/* vm-configurator.c generated by valac 0.17.7, the Vala compiler
 * generated from vm-configurator.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <libcommon.h>
#include <osinfo/osinfo.h>
#include <config.h>
#include <unistd.h>
#include <libxml/parser.h>
#include <libxml/xmlreader.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define BOXES_TYPE_VM_CONFIGURATOR (boxes_vm_configurator_get_type ())
#define BOXES_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfigurator))
#define BOXES_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))
#define BOXES_IS_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_IS_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_VM_CONFIGURATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))

typedef struct _BoxesVMConfigurator BoxesVMConfigurator;
typedef struct _BoxesVMConfiguratorClass BoxesVMConfiguratorClass;
typedef struct _BoxesVMConfiguratorPrivate BoxesVMConfiguratorPrivate;

#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _xmlFreeTextReader0(var) ((var == NULL) ? NULL : (var = (xmlFreeTextReader (var), NULL)))
typedef struct _BoxesParamSpecVMConfigurator BoxesParamSpecVMConfigurator;

typedef enum  {
	BOXES_VM_CONFIGURATOR_ERROR_NO_GUEST_CAPS
} BoxesVMConfiguratorError;
#define BOXES_VM_CONFIGURATOR_ERROR boxes_vm_configurator_error_quark ()
struct _BoxesVMConfigurator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BoxesVMConfiguratorPrivate * priv;
};

struct _BoxesVMConfiguratorClass {
	GTypeClass parent_class;
	void (*finalize) (BoxesVMConfigurator *self);
};

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
	void (*set_direct_boot_params) (BoxesInstallerMedia* self, GVirConfigDomainOs* os);
	void (*prepare_for_installation) (BoxesInstallerMedia* self, const gchar* vm_name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_for_installation_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_, GError** error);
	void (*setup_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	void (*populate_setup_vbox) (BoxesInstallerMedia* self, GtkVBox* setup_vbox);
	GList* (*get_vm_properties) (BoxesInstallerMedia* self);
	guint64 (*get_installed_size) (BoxesInstallerMedia* self);
	gboolean (*get_need_user_input_for_vm_creation) (BoxesInstallerMedia* self);
	gboolean (*get_user_data_for_vm_creation_available) (BoxesInstallerMedia* self);
	gboolean (*get_supports_virtio_disk) (BoxesInstallerMedia* self);
};

struct _BoxesParamSpecVMConfigurator {
	GParamSpec parent_instance;
};


static gpointer boxes_vm_configurator_parent_class = NULL;

GQuark boxes_vm_configurator_error_quark (void);
gpointer boxes_vm_configurator_ref (gpointer instance);
void boxes_vm_configurator_unref (gpointer instance);
GParamSpec* boxes_param_spec_vm_configurator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void boxes_value_set_vm_configurator (GValue* value, gpointer v_object);
void boxes_value_take_vm_configurator (GValue* value, gpointer v_object);
gpointer boxes_value_get_vm_configurator (const GValue* value);
GType boxes_vm_configurator_get_type (void) G_GNUC_CONST;
enum  {
	BOXES_VM_CONFIGURATOR_DUMMY_PROPERTY
};
#define BOXES_VM_CONFIGURATOR_BOXES_NS "boxes"
#define BOXES_VM_CONFIGURATOR_BOXES_NS_URI "http://live.gnome.org/Boxes/"
#define BOXES_VM_CONFIGURATOR_LIVE_STATE "live"
#define BOXES_VM_CONFIGURATOR_INSTALLATION_STATE "installation"
#define BOXES_VM_CONFIGURATOR_INSTALLED_STATE "installed"
#define BOXES_VM_CONFIGURATOR_LIVE_XML "<os-state>" BOXES_VM_CONFIGURATOR_LIVE_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_INSTALLATION_XML "<os-state>" BOXES_VM_CONFIGURATOR_INSTALLATION_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_INSTALLED_XML "<os-state>" BOXES_VM_CONFIGURATOR_INSTALLED_STATE "</os-state>"
GType boxes_installer_media_get_type (void) G_GNUC_CONST;
GVirConfigDomain* boxes_vm_configurator_create_domain_config (BoxesInstallerMedia* install_media, const gchar* target_path, GVirConfigCapabilities* caps, GError** error);
gboolean boxes_installer_media_get_live (BoxesInstallerMedia* self);
static GVirConfigCapabilitiesGuest* boxes_vm_configurator_get_best_guest_caps (GVirConfigCapabilities* caps, BoxesInstallerMedia* install_media, GError** error);
static void boxes_vm_configurator_set_cpu_config (GVirConfigDomain* domain, GVirConfigCapabilities* caps);
static gboolean boxes_vm_configurator_guest_kvm_enabled (GVirConfigCapabilitiesGuest* guest_caps);
static void boxes_vm_configurator_set_os_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, GVirConfigCapabilitiesGuest* guest_caps);
static gboolean boxes_vm_configurator_guest_supports_feature (GVirConfigCapabilitiesGuest* guest_caps, const gchar* feature_name);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value);
static void boxes_vm_configurator_set_target_media_config (GVirConfigDomain* domain, const gchar* target_path, BoxesInstallerMedia* install_media);
void boxes_installer_media_setup_domain_config (BoxesInstallerMedia* self, GVirConfigDomain* domain);
static void boxes_vm_configurator_set_video_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_sound_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_tablet_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
void boxes_vm_configurator_post_install_setup (GVirConfigDomain* domain);
static void boxes_vm_configurator_set_post_install_os_config (GVirConfigDomain* domain);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void boxes_vm_configurator_mark_as_installed (GVirConfigDomain* domain);
gboolean boxes_vm_configurator_is_install_config (GVirConfigDomain* domain);
static gchar* boxes_vm_configurator_get_os_state (GVirConfigDomain* domain);
gboolean boxes_vm_configurator_is_live_config (GVirConfigDomain* domain);
GVirConfigStorageVol* boxes_vm_configurator_create_volume_config (const gchar* name, gint64 storage, GError** error);
static GVirConfigStoragePermissions* boxes_vm_configurator_get_default_permissions (void);
GVirConfigStoragePool* boxes_vm_configurator_get_pool_config (GError** error);
gboolean boxes_installer_media_get_supports_virtio_disk (BoxesInstallerMedia* self);
void boxes_installer_media_set_direct_boot_params (BoxesInstallerMedia* self, GVirConfigDomainOs* os);
OsinfoDevice* boxes_get_os_device_by_prop (OsinfoOs* os, const gchar* prop_name, const gchar* prop_value);
gboolean boxes_installer_media_is_architecture_compatible (BoxesInstallerMedia* self, const gchar* architecture);
static gboolean boxes_vm_configurator_guest_is_qemu (GVirConfigCapabilitiesGuest* guest_caps);
BoxesVMConfigurator* boxes_vm_configurator_new (void);
BoxesVMConfigurator* boxes_vm_configurator_construct (GType object_type);
static void boxes_vm_configurator_finalize (BoxesVMConfigurator* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark boxes_vm_configurator_error_quark (void) {
	return g_quark_from_static_string ("boxes_vm_configurator_error-quark");
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


GVirConfigDomain* boxes_vm_configurator_create_domain_config (BoxesInstallerMedia* install_media, const gchar* target_path, GVirConfigCapabilities* caps, GError** error) {
	GVirConfigDomain* result = NULL;
	GVirConfigDomain* _tmp0_;
	GVirConfigDomain* domain;
	const gchar* _tmp1_ = NULL;
	BoxesInstallerMedia* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* xml;
	GVirConfigCapabilities* _tmp8_;
	BoxesInstallerMedia* _tmp9_;
	GVirConfigCapabilitiesGuest* _tmp10_ = NULL;
	GVirConfigCapabilitiesGuest* best_caps;
	GVirConfigDomain* _tmp11_;
	BoxesInstallerMedia* _tmp12_;
	OsinfoResources* _tmp13_;
	gint64 _tmp14_;
	gint64 _tmp15_;
	GVirConfigDomain* _tmp16_;
	GVirConfigCapabilities* _tmp17_;
	GVirConfigDomainVirtType _tmp18_ = 0;
	gboolean _tmp19_ = FALSE;
	GVirConfigDomainVirtType _tmp20_;
	GVirConfigDomainVirtType virt_type;
	GVirConfigDomain* _tmp21_;
	GVirConfigDomainVirtType _tmp22_;
	GVirConfigDomain* _tmp23_;
	BoxesInstallerMedia* _tmp24_;
	gchar** _tmp25_ = NULL;
	gchar** features;
	gint features_length1;
	gint _features_size_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp32_ = FALSE;
	GVirConfigDomain* _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	GVirConfigDomainClock* _tmp37_;
	GVirConfigDomainClock* clock;
	gboolean _tmp38_ = FALSE;
	BoxesInstallerMedia* _tmp39_;
	OsinfoOs* _tmp40_;
	gboolean _tmp46_;
	GVirConfigDomainTimerRtc* _tmp49_;
	GVirConfigDomainTimer* timer;
	GVirConfigDomainTimer* _tmp50_;
	GVirConfigDomainClock* _tmp51_;
	GVirConfigDomainTimer* _tmp52_;
	GVirConfigDomainTimerPit* _tmp53_;
	GVirConfigDomainTimer* _tmp54_;
	GVirConfigDomainClock* _tmp55_;
	GVirConfigDomainTimer* _tmp56_;
	GVirConfigDomain* _tmp57_;
	GVirConfigDomainClock* _tmp58_;
	GVirConfigDomain* _tmp59_;
	const gchar* _tmp60_;
	BoxesInstallerMedia* _tmp61_;
	BoxesInstallerMedia* _tmp62_;
	GVirConfigDomain* _tmp63_;
	GVirConfigDomainGraphicsSpice* _tmp64_;
	GVirConfigDomainGraphicsSpice* graphics;
	GVirConfigDomainGraphicsSpice* _tmp65_;
	GVirConfigDomain* _tmp66_;
	GVirConfigDomainGraphicsSpice* _tmp67_;
	GVirConfigDomainChannel* _tmp68_;
	GVirConfigDomainChannel* channel;
	GVirConfigDomainChannel* _tmp69_;
	GVirConfigDomainChannel* _tmp70_;
	GVirConfigDomainChardevSourceSpiceVmc* _tmp71_;
	GVirConfigDomainChardevSourceSpiceVmc* vmc;
	GVirConfigDomainChannel* _tmp72_;
	GVirConfigDomainChardevSourceSpiceVmc* _tmp73_;
	GVirConfigDomain* _tmp74_;
	GVirConfigDomainChannel* _tmp75_;
	GVirConfigDomain* _tmp76_;
	BoxesInstallerMedia* _tmp77_;
	GVirConfigDomain* _tmp78_;
	BoxesInstallerMedia* _tmp79_;
	GVirConfigDomain* _tmp80_;
	BoxesInstallerMedia* _tmp81_;
	GVirConfigDomain* _tmp82_;
	GVirConfigDomain* _tmp83_;
	GVirConfigDomain* _tmp84_;
	GVirConfigDomainConsole* _tmp85_;
	GVirConfigDomainConsole* console;
	GVirConfigDomainConsole* _tmp86_;
	GVirConfigDomainChardevSourcePty* _tmp87_;
	GVirConfigDomainChardevSourcePty* _tmp88_;
	GVirConfigDomain* _tmp89_;
	GVirConfigDomainConsole* _tmp90_;
	GVirConfigDomainInterfaceUser* _tmp91_;
	GVirConfigDomainInterfaceUser* iface;
	GVirConfigDomain* _tmp92_;
	GVirConfigDomainInterfaceUser* _tmp93_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (install_media != NULL, NULL);
	g_return_val_if_fail (target_path != NULL, NULL);
	g_return_val_if_fail (caps != NULL, NULL);
	_tmp0_ = gvir_config_domain_new ();
	domain = _tmp0_;
	_tmp2_ = install_media;
	_tmp3_ = boxes_installer_media_get_live (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = BOXES_VM_CONFIGURATOR_LIVE_XML;
	} else {
		_tmp1_ = BOXES_VM_CONFIGURATOR_INSTALLATION_XML;
	}
	_tmp5_ = _tmp1_;
	_tmp6_ = g_strdup (_tmp5_);
	xml = _tmp6_;
	{
		GVirConfigDomain* _tmp7_;
		_tmp7_ = domain;
		gvir_config_domain_set_custom_xml (_tmp7_, xml, BOXES_VM_CONFIGURATOR_BOXES_NS, BOXES_VM_CONFIGURATOR_BOXES_NS_URI, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch63_g_error;
		}
	}
	goto __finally63;
	__catch63_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally63:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == BOXES_VM_CONFIGURATOR_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (xml);
			_g_object_unref0 (domain);
			return NULL;
		} else {
			_g_free0 (xml);
			_g_object_unref0 (domain);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = caps;
	_tmp9_ = install_media;
	_tmp10_ = boxes_vm_configurator_get_best_guest_caps (_tmp8_, _tmp9_, &_inner_error_);
	best_caps = _tmp10_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == BOXES_VM_CONFIGURATOR_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (xml);
			_g_object_unref0 (domain);
			return NULL;
		} else {
			_g_free0 (xml);
			_g_object_unref0 (domain);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = domain;
	_tmp12_ = install_media;
	_tmp13_ = _tmp12_->resources;
	_tmp14_ = osinfo_resources_get_ram (_tmp13_);
	_tmp15_ = _tmp14_;
	gvir_config_domain_set_memory (_tmp11_, (guint64) (_tmp15_ / OSINFO_KIBIBYTES));
	_tmp16_ = domain;
	_tmp17_ = caps;
	boxes_vm_configurator_set_cpu_config (_tmp16_, _tmp17_);
	_tmp19_ = boxes_vm_configurator_guest_kvm_enabled (best_caps);
	if (_tmp19_) {
		_tmp18_ = GVIR_CONFIG_DOMAIN_VIRT_KVM;
	} else {
		_tmp18_ = GVIR_CONFIG_DOMAIN_VIRT_QEMU;
	}
	_tmp20_ = _tmp18_;
	virt_type = _tmp20_;
	_tmp21_ = domain;
	_tmp22_ = virt_type;
	gvir_config_domain_set_virt_type (_tmp21_, _tmp22_);
	_tmp23_ = domain;
	_tmp24_ = install_media;
	boxes_vm_configurator_set_os_config (_tmp23_, _tmp24_, best_caps);
	_tmp25_ = g_new0 (gchar*, 0 + 1);
	features = _tmp25_;
	features_length1 = 0;
	_features_size_ = features_length1;
	_tmp26_ = boxes_vm_configurator_guest_supports_feature (best_caps, "acpi");
	if (_tmp26_) {
		gchar** _tmp27_;
		gint _tmp27__length1;
		gchar* _tmp28_;
		_tmp27_ = features;
		_tmp27__length1 = features_length1;
		_tmp28_ = g_strdup ("acpi");
		_vala_array_add8 (&features, &features_length1, &_features_size_, _tmp28_);
	}
	_tmp29_ = boxes_vm_configurator_guest_supports_feature (best_caps, "apic");
	if (_tmp29_) {
		gchar** _tmp30_;
		gint _tmp30__length1;
		gchar* _tmp31_;
		_tmp30_ = features;
		_tmp30__length1 = features_length1;
		_tmp31_ = g_strdup ("apic");
		_vala_array_add9 (&features, &features_length1, &_features_size_, _tmp31_);
	}
	_tmp32_ = boxes_vm_configurator_guest_supports_feature (best_caps, "pae");
	if (_tmp32_) {
		gchar** _tmp33_;
		gint _tmp33__length1;
		gchar* _tmp34_;
		_tmp33_ = features;
		_tmp33__length1 = features_length1;
		_tmp34_ = g_strdup ("pae");
		_vala_array_add10 (&features, &features_length1, &_features_size_, _tmp34_);
	}
	_tmp35_ = domain;
	_tmp36_ = features;
	_tmp36__length1 = features_length1;
	gvir_config_domain_set_features (_tmp35_, _tmp36_);
	_tmp37_ = gvir_config_domain_clock_new ();
	clock = _tmp37_;
	_tmp39_ = install_media;
	_tmp40_ = _tmp39_->os;
	if (_tmp40_ != NULL) {
		BoxesInstallerMedia* _tmp41_;
		OsinfoOs* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gboolean _tmp45_ = FALSE;
		_tmp41_ = install_media;
		_tmp42_ = _tmp41_->os;
		_tmp43_ = osinfo_product_get_short_id ((OsinfoProduct*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = string_contains (_tmp44_, "win");
		_tmp38_ = _tmp45_;
	} else {
		_tmp38_ = FALSE;
	}
	_tmp46_ = _tmp38_;
	if (_tmp46_) {
		GVirConfigDomainClock* _tmp47_;
		_tmp47_ = clock;
		gvir_config_domain_clock_set_offset (_tmp47_, GVIR_CONFIG_DOMAIN_CLOCK_LOCALTIME);
	} else {
		GVirConfigDomainClock* _tmp48_;
		_tmp48_ = clock;
		gvir_config_domain_clock_set_offset (_tmp48_, GVIR_CONFIG_DOMAIN_CLOCK_UTC);
	}
	_tmp49_ = gvir_config_domain_timer_rtc_new ();
	timer = (GVirConfigDomainTimer*) _tmp49_;
	_tmp50_ = timer;
	gvir_config_domain_timer_set_tick_policy (_tmp50_, GVIR_CONFIG_DOMAIN_TIMER_TICK_POLICY_CATCHUP);
	_tmp51_ = clock;
	_tmp52_ = timer;
	gvir_config_domain_clock_add_timer (_tmp51_, _tmp52_);
	_tmp53_ = gvir_config_domain_timer_pit_new ();
	_g_object_unref0 (timer);
	timer = (GVirConfigDomainTimer*) _tmp53_;
	_tmp54_ = timer;
	gvir_config_domain_timer_set_tick_policy (_tmp54_, GVIR_CONFIG_DOMAIN_TIMER_TICK_POLICY_DELAY);
	_tmp55_ = clock;
	_tmp56_ = timer;
	gvir_config_domain_clock_add_timer (_tmp55_, _tmp56_);
	_tmp57_ = domain;
	_tmp58_ = clock;
	gvir_config_domain_set_clock (_tmp57_, _tmp58_);
	_tmp59_ = domain;
	_tmp60_ = target_path;
	_tmp61_ = install_media;
	boxes_vm_configurator_set_target_media_config (_tmp59_, _tmp60_, _tmp61_);
	_tmp62_ = install_media;
	_tmp63_ = domain;
	boxes_installer_media_setup_domain_config (_tmp62_, _tmp63_);
	_tmp64_ = gvir_config_domain_graphics_spice_new ();
	graphics = _tmp64_;
	_tmp65_ = graphics;
	gvir_config_domain_graphics_spice_set_autoport (_tmp65_, TRUE);
	_tmp66_ = domain;
	_tmp67_ = graphics;
	gvir_config_domain_add_device (_tmp66_, (GVirConfigDomainDevice*) _tmp67_);
	_tmp68_ = gvir_config_domain_channel_new ();
	channel = _tmp68_;
	_tmp69_ = channel;
	gvir_config_domain_channel_set_target_type (_tmp69_, GVIR_CONFIG_DOMAIN_CHANNEL_TARGET_VIRTIO);
	_tmp70_ = channel;
	gvir_config_domain_channel_set_target_name (_tmp70_, "com.redhat.spice.0");
	_tmp71_ = gvir_config_domain_chardev_source_spicevmc_new ();
	vmc = _tmp71_;
	_tmp72_ = channel;
	_tmp73_ = vmc;
	gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) _tmp72_, (GVirConfigDomainChardevSource*) _tmp73_);
	_tmp74_ = domain;
	_tmp75_ = channel;
	gvir_config_domain_add_device (_tmp74_, (GVirConfigDomainDevice*) _tmp75_);
	_tmp76_ = domain;
	_tmp77_ = install_media;
	boxes_vm_configurator_set_video_config (_tmp76_, _tmp77_);
	_tmp78_ = domain;
	_tmp79_ = install_media;
	boxes_vm_configurator_set_sound_config (_tmp78_, _tmp79_);
	_tmp80_ = domain;
	_tmp81_ = install_media;
	boxes_vm_configurator_set_tablet_config (_tmp80_, _tmp81_);
	_tmp82_ = domain;
	gvir_config_domain_set_lifecycle (_tmp82_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_POWEROFF, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
	_tmp83_ = domain;
	gvir_config_domain_set_lifecycle (_tmp83_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
	_tmp84_ = domain;
	gvir_config_domain_set_lifecycle (_tmp84_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_CRASH, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
	_tmp85_ = gvir_config_domain_console_new ();
	console = _tmp85_;
	_tmp86_ = console;
	_tmp87_ = gvir_config_domain_chardev_source_pty_new ();
	_tmp88_ = _tmp87_;
	gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) _tmp86_, (GVirConfigDomainChardevSource*) _tmp88_);
	_g_object_unref0 (_tmp88_);
	_tmp89_ = domain;
	_tmp90_ = console;
	gvir_config_domain_add_device (_tmp89_, (GVirConfigDomainDevice*) _tmp90_);
	_tmp91_ = gvir_config_domain_interface_user_new ();
	iface = _tmp91_;
	_tmp92_ = domain;
	_tmp93_ = iface;
	gvir_config_domain_add_device (_tmp92_, (GVirConfigDomainDevice*) _tmp93_);
	result = domain;
	_g_object_unref0 (iface);
	_g_object_unref0 (console);
	_g_object_unref0 (vmc);
	_g_object_unref0 (channel);
	_g_object_unref0 (graphics);
	_g_object_unref0 (timer);
	_g_object_unref0 (clock);
	features = (_vala_array_free (features, features_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (best_caps);
	_g_free0 (xml);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void boxes_vm_configurator_post_install_setup (GVirConfigDomain* domain) {
	GVirConfigDomain* _tmp0_;
	GVirConfigDomain* _tmp1_;
	GVirConfigDomain* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* devices;
	GList* _tmp4_;
	GVirConfigDomain* _tmp16_;
	GList* _tmp17_;
	g_return_if_fail (domain != NULL);
	_tmp0_ = domain;
	boxes_vm_configurator_set_post_install_os_config (_tmp0_);
	_tmp1_ = domain;
	gvir_config_domain_set_lifecycle (_tmp1_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_RESTART);
	_tmp2_ = domain;
	_tmp3_ = gvir_config_domain_get_devices (_tmp2_);
	devices = _tmp3_;
	_tmp4_ = devices;
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp4_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			GVirConfigDomainDevice* _tmp5_;
			GVirConfigDomainDevice* device = NULL;
			_tmp5_ = _g_object_ref0 ((GVirConfigDomainDevice*) device_it->data);
			device = _tmp5_;
			{
				GVirConfigDomainDevice* _tmp6_;
				GVirConfigDomainDevice* _tmp7_;
				GVirConfigDomainDisk* _tmp8_;
				GVirConfigDomainDisk* disk;
				GVirConfigDomainDisk* _tmp9_;
				GVirConfigDomainDiskGuestDeviceType _tmp10_ = 0;
				GVirConfigDomainDiskGuestDeviceType disk_type;
				gboolean _tmp11_ = FALSE;
				GVirConfigDomainDiskGuestDeviceType _tmp12_;
				gboolean _tmp14_;
				_tmp6_ = device;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gvir_config_domain_disk_get_type ())) {
					_g_object_unref0 (device);
					continue;
				}
				_tmp7_ = device;
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gvir_config_domain_disk_get_type ()) ? ((GVirConfigDomainDisk*) _tmp7_) : NULL);
				disk = _tmp8_;
				_tmp9_ = disk;
				_tmp10_ = gvir_config_domain_disk_get_guest_device_type (_tmp9_);
				disk_type = _tmp10_;
				_tmp12_ = disk_type;
				if (_tmp12_ == GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_CDROM) {
					_tmp11_ = TRUE;
				} else {
					GVirConfigDomainDiskGuestDeviceType _tmp13_;
					_tmp13_ = disk_type;
					_tmp11_ = _tmp13_ == GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_FLOPPY;
				}
				_tmp14_ = _tmp11_;
				if (_tmp14_) {
					GVirConfigDomainDisk* _tmp15_;
					_tmp15_ = disk;
					gvir_config_domain_disk_set_startup_policy (_tmp15_, GVIR_CONFIG_DOMAIN_DISK_STARTUP_POLICY_OPTIONAL);
				}
				_g_object_unref0 (disk);
				_g_object_unref0 (device);
			}
		}
	}
	_tmp16_ = domain;
	_tmp17_ = devices;
	gvir_config_domain_set_devices (_tmp16_, _tmp17_);
	__g_list_free__g_object_unref0_0 (devices);
}


void boxes_vm_configurator_mark_as_installed (GVirConfigDomain* domain) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (domain != NULL);
	{
		GVirConfigDomain* _tmp0_;
		_tmp0_ = domain;
		gvir_config_domain_set_custom_xml (_tmp0_, BOXES_VM_CONFIGURATOR_INSTALLED_XML, BOXES_VM_CONFIGURATOR_BOXES_NS, BOXES_VM_CONFIGURATOR_BOXES_NS_URI, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch64_g_error;
		}
	}
	goto __finally64;
	__catch64_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally64:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gboolean boxes_vm_configurator_is_install_config (GVirConfigDomain* domain) {
	gboolean result = FALSE;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (domain != NULL, FALSE);
	_tmp0_ = domain;
	_tmp1_ = boxes_vm_configurator_get_os_state (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, BOXES_VM_CONFIGURATOR_INSTALLATION_STATE) == 0;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}


gboolean boxes_vm_configurator_is_live_config (GVirConfigDomain* domain) {
	gboolean result = FALSE;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (domain != NULL, FALSE);
	_tmp0_ = domain;
	_tmp1_ = boxes_vm_configurator_get_os_state (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, BOXES_VM_CONFIGURATOR_LIVE_STATE) == 0;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}


GVirConfigStorageVol* boxes_vm_configurator_create_volume_config (const gchar* name, gint64 storage, GError** error) {
	GVirConfigStorageVol* result = NULL;
	GVirConfigStorageVol* _tmp0_;
	GVirConfigStorageVol* volume;
	const gchar* _tmp1_;
	gint64 _tmp2_;
	GVirConfigStorageVolTarget* _tmp3_;
	GVirConfigStorageVolTarget* target;
	GVirConfigStoragePermissions* _tmp4_ = NULL;
	GVirConfigStoragePermissions* permissions;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gvir_config_storage_vol_new ();
	volume = _tmp0_;
	_tmp1_ = name;
	gvir_config_storage_vol_set_name (volume, _tmp1_);
	_tmp2_ = storage;
	gvir_config_storage_vol_set_capacity (volume, (guint64) _tmp2_);
	_tmp3_ = gvir_config_storage_vol_target_new ();
	target = _tmp3_;
	gvir_config_storage_vol_target_set_format (target, "qcow2");
	_tmp4_ = boxes_vm_configurator_get_default_permissions ();
	permissions = _tmp4_;
	gvir_config_storage_vol_target_set_permissions (target, permissions);
	gvir_config_storage_vol_set_target (volume, target);
	result = volume;
	_g_object_unref0 (permissions);
	_g_object_unref0 (target);
	return result;
}


GVirConfigStoragePool* boxes_vm_configurator_get_pool_config (GError** error) {
	GVirConfigStoragePool* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* pool_path;
	GVirConfigStoragePool* _tmp1_;
	GVirConfigStoragePool* pool;
	GVirConfigStoragePoolSource* _tmp2_;
	GVirConfigStoragePoolSource* source;
	GVirConfigStoragePoolTarget* _tmp3_;
	GVirConfigStoragePoolTarget* target;
	GVirConfigStoragePermissions* _tmp4_ = NULL;
	GVirConfigStoragePermissions* permissions;
	_tmp0_ = boxes_get_user_pkgdata ("images");
	pool_path = _tmp0_;
	boxes_ensure_directory (pool_path);
	_tmp1_ = gvir_config_storage_pool_new ();
	pool = _tmp1_;
	gvir_config_storage_pool_set_pool_type (pool, GVIR_CONFIG_STORAGE_POOL_TYPE_DIR);
	gvir_config_storage_pool_set_name (pool, PACKAGE_TARNAME);
	_tmp2_ = gvir_config_storage_pool_source_new ();
	source = _tmp2_;
	gvir_config_storage_pool_source_set_directory (source, pool_path);
	gvir_config_storage_pool_set_source (pool, source);
	_tmp3_ = gvir_config_storage_pool_target_new ();
	target = _tmp3_;
	gvir_config_storage_pool_target_set_path (target, pool_path);
	_tmp4_ = boxes_vm_configurator_get_default_permissions ();
	permissions = _tmp4_;
	gvir_config_storage_pool_target_set_permissions (target, permissions);
	gvir_config_storage_pool_set_target (pool, target);
	result = pool;
	_g_object_unref0 (permissions);
	_g_object_unref0 (target);
	_g_object_unref0 (source);
	_g_free0 (pool_path);
	return result;
}


static void boxes_vm_configurator_set_cpu_config (GVirConfigDomain* domain, GVirConfigCapabilities* caps) {
	GVirConfigCapabilities* _tmp0_;
	GVirConfigCapabilitiesHost* _tmp1_ = NULL;
	GVirConfigCapabilitiesHost* _tmp2_;
	GVirConfigCapabilitiesCpu* _tmp3_ = NULL;
	GVirConfigCapabilitiesCpu* _tmp4_;
	GVirConfigCapabilitiesCpuTopology* _tmp5_ = NULL;
	GVirConfigCapabilitiesCpuTopology* _tmp6_;
	GVirConfigCapabilitiesCpuTopology* topology;
	GVirConfigDomain* _tmp7_;
	guint64 _tmp8_ = 0ULL;
	guint64 _tmp9_ = 0ULL;
	guint64 _tmp10_ = 0ULL;
	GVirConfigDomainCpu* _tmp11_;
	GVirConfigDomainCpu* cpu;
	GVirConfigDomain* _tmp12_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (caps != NULL);
	_tmp0_ = caps;
	_tmp1_ = gvir_config_capabilities_get_host (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gvir_config_capabilities_host_get_cpu (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gvir_config_capabilities_cpu_get_topology (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	topology = _tmp6_;
	_tmp7_ = domain;
	_tmp8_ = gvir_config_capabilities_cpu_topology_get_sockets (topology);
	_tmp9_ = gvir_config_capabilities_cpu_topology_get_cores (topology);
	_tmp10_ = gvir_config_capabilities_cpu_topology_get_threads (topology);
	g_object_set (_tmp7_, "vcpu", (_tmp8_ * _tmp9_) * _tmp10_, NULL);
	_tmp11_ = gvir_config_domain_cpu_new ();
	cpu = _tmp11_;
	gvir_config_domain_cpu_set_mode (cpu, GVIR_CONFIG_DOMAIN_CPU_MODE_HOST_MODEL);
	gvir_config_capabilities_cpu_set_topology ((GVirConfigCapabilitiesCpu*) cpu, topology);
	_tmp12_ = domain;
	gvir_config_domain_set_cpu (_tmp12_, cpu);
	_g_object_unref0 (cpu);
	_g_object_unref0 (topology);
}


static void boxes_vm_configurator_set_target_media_config (GVirConfigDomain* domain, const gchar* target_path, BoxesInstallerMedia* install_media) {
	GVirConfigDomainDisk* _tmp0_;
	GVirConfigDomainDisk* disk;
	GVirConfigDomainDisk* _tmp1_;
	GVirConfigDomainDisk* _tmp2_;
	GVirConfigDomainDisk* _tmp3_;
	GVirConfigDomainDisk* _tmp4_;
	GVirConfigDomainDisk* _tmp5_;
	const gchar* _tmp6_;
	GVirConfigDomainDisk* _tmp7_;
	BoxesInstallerMedia* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GVirConfigDomain* _tmp15_;
	GVirConfigDomainDisk* _tmp16_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (target_path != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = gvir_config_domain_disk_new ();
	disk = _tmp0_;
	_tmp1_ = disk;
	gvir_config_domain_disk_set_type (_tmp1_, GVIR_CONFIG_DOMAIN_DISK_FILE);
	_tmp2_ = disk;
	gvir_config_domain_disk_set_guest_device_type (_tmp2_, GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_DISK);
	_tmp3_ = disk;
	gvir_config_domain_disk_set_driver_name (_tmp3_, "qemu");
	_tmp4_ = disk;
	gvir_config_domain_disk_set_driver_type (_tmp4_, "qcow2");
	_tmp5_ = disk;
	_tmp6_ = target_path;
	gvir_config_domain_disk_set_source (_tmp5_, _tmp6_);
	_tmp7_ = disk;
	gvir_config_domain_disk_set_driver_cache (_tmp7_, GVIR_CONFIG_DOMAIN_DISK_CACHE_NONE);
	_tmp8_ = install_media;
	_tmp9_ = boxes_installer_media_get_supports_virtio_disk (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		GVirConfigDomainDisk* _tmp11_;
		GVirConfigDomainDisk* _tmp12_;
		g_debug ("vm-configurator.vala:185: Using virtio controller for the main disk");
		_tmp11_ = disk;
		gvir_config_domain_disk_set_target_bus (_tmp11_, GVIR_CONFIG_DOMAIN_DISK_BUS_VIRTIO);
		_tmp12_ = disk;
		gvir_config_domain_disk_set_target_dev (_tmp12_, "vda");
	} else {
		GVirConfigDomainDisk* _tmp13_;
		GVirConfigDomainDisk* _tmp14_;
		g_debug ("vm-configurator.vala:189: Using IDE controller for the main disk");
		_tmp13_ = disk;
		gvir_config_domain_disk_set_target_bus (_tmp13_, GVIR_CONFIG_DOMAIN_DISK_BUS_IDE);
		_tmp14_ = disk;
		gvir_config_domain_disk_set_target_dev (_tmp14_, "hda");
	}
	_tmp15_ = domain;
	_tmp16_ = disk;
	gvir_config_domain_add_device (_tmp15_, (GVirConfigDomainDevice*) _tmp16_);
	_g_object_unref0 (disk);
}


static void boxes_vm_configurator_set_post_install_os_config (GVirConfigDomain* domain) {
	GVirConfigDomainOs* _tmp0_;
	GVirConfigDomainOs* os;
	GVirConfigDomain* _tmp1_;
	GVirConfigDomainOs* _tmp2_ = NULL;
	GVirConfigDomainOs* old_os;
	GList* _tmp3_ = NULL;
	GList* boot_devices;
	const gchar* _tmp4_ = NULL;
	GVirConfigDomain* _tmp5_;
	g_return_if_fail (domain != NULL);
	_tmp0_ = gvir_config_domain_os_new ();
	os = _tmp0_;
	gvir_config_domain_os_set_os_type (os, GVIR_CONFIG_DOMAIN_OS_TYPE_HVM);
	_tmp1_ = domain;
	_tmp2_ = gvir_config_domain_get_os (_tmp1_);
	old_os = _tmp2_;
	_tmp3_ = gvir_config_domain_os_get_boot_devices (old_os);
	boot_devices = _tmp3_;
	boot_devices = g_list_remove (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_CDROM));
	gvir_config_domain_os_set_boot_devices (os, boot_devices);
	_tmp4_ = gvir_config_domain_os_get_arch (old_os);
	gvir_config_domain_os_set_arch (os, _tmp4_);
	_tmp5_ = domain;
	gvir_config_domain_set_os (_tmp5_, os);
	_g_list_free0 (boot_devices);
	_g_object_unref0 (old_os);
	_g_object_unref0 (os);
}


static void boxes_vm_configurator_set_os_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, GVirConfigCapabilitiesGuest* guest_caps) {
	GVirConfigDomainOs* _tmp0_;
	GVirConfigDomainOs* os;
	GVirConfigCapabilitiesGuest* _tmp1_;
	GVirConfigCapabilitiesGuestArch* _tmp2_ = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GList* boot_devices;
	BoxesInstallerMedia* _tmp5_;
	GVirConfigDomain* _tmp6_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	g_return_if_fail (guest_caps != NULL);
	_tmp0_ = gvir_config_domain_os_new ();
	os = _tmp0_;
	gvir_config_domain_os_set_os_type (os, GVIR_CONFIG_DOMAIN_OS_TYPE_HVM);
	_tmp1_ = guest_caps;
	_tmp2_ = gvir_config_capabilities_guest_get_arch (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gvir_config_capabilities_guest_arch_get_name (_tmp3_);
	gvir_config_domain_os_set_arch (os, _tmp4_);
	_g_object_unref0 (_tmp3_);
	boot_devices = NULL;
	_tmp5_ = install_media;
	boxes_installer_media_set_direct_boot_params (_tmp5_, os);
	boot_devices = g_list_append (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_CDROM));
	boot_devices = g_list_append (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_HD));
	gvir_config_domain_os_set_boot_devices (os, boot_devices);
	_tmp6_ = domain;
	gvir_config_domain_set_os (_tmp6_, os);
	_g_list_free0 (boot_devices);
	_g_object_unref0 (os);
}


static void boxes_vm_configurator_set_video_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainVideo* _tmp0_;
	GVirConfigDomainVideo* video;
	BoxesInstallerMedia* _tmp1_;
	OsinfoOs* _tmp2_;
	OsinfoDevice* _tmp3_ = NULL;
	OsinfoDevice* device;
	gint _tmp4_ = 0;
	OsinfoDevice* _tmp5_;
	gint _tmp9_;
	gint model;
	GVirConfigDomainVideo* _tmp10_;
	GVirConfigDomain* _tmp11_;
	GVirConfigDomainVideo* _tmp12_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = gvir_config_domain_video_new ();
	video = _tmp0_;
	_tmp1_ = install_media;
	_tmp2_ = _tmp1_->os;
	_tmp3_ = boxes_get_os_device_by_prop (_tmp2_, OSINFO_DEVICE_PROP_CLASS, "video");
	device = _tmp3_;
	_tmp5_ = device;
	if (_tmp5_ != NULL) {
		OsinfoDevice* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp6_ = device;
		_tmp7_ = osinfo_device_get_name (_tmp6_);
		_tmp8_ = boxes_get_enum_value (_tmp7_, gvir_config_domain_video_model_get_type ());
		_tmp4_ = _tmp8_;
	} else {
		_tmp4_ = (gint) GVIR_CONFIG_DOMAIN_VIDEO_MODEL_QXL;
	}
	_tmp9_ = _tmp4_;
	model = _tmp9_;
	g_return_if_fail (model != (-1));
	_tmp10_ = video;
	gvir_config_domain_video_set_model (_tmp10_, (GVirConfigDomainVideoModel) model);
	_tmp11_ = domain;
	_tmp12_ = video;
	gvir_config_domain_add_device (_tmp11_, (GVirConfigDomainDevice*) _tmp12_);
	_g_object_unref0 (device);
	_g_object_unref0 (video);
}


static void boxes_vm_configurator_set_sound_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainSound* _tmp0_;
	GVirConfigDomainSound* sound;
	BoxesInstallerMedia* _tmp1_;
	OsinfoOs* _tmp2_;
	OsinfoDevice* _tmp3_ = NULL;
	OsinfoDevice* device;
	gint _tmp4_ = 0;
	OsinfoDevice* _tmp5_;
	gint _tmp9_;
	gint model;
	GVirConfigDomainSound* _tmp10_;
	GVirConfigDomain* _tmp11_;
	GVirConfigDomainSound* _tmp12_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = gvir_config_domain_sound_new ();
	sound = _tmp0_;
	_tmp1_ = install_media;
	_tmp2_ = _tmp1_->os;
	_tmp3_ = boxes_get_os_device_by_prop (_tmp2_, OSINFO_DEVICE_PROP_CLASS, "audio");
	device = _tmp3_;
	_tmp5_ = device;
	if (_tmp5_ != NULL) {
		OsinfoDevice* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp6_ = device;
		_tmp7_ = osinfo_device_get_name (_tmp6_);
		_tmp8_ = boxes_get_enum_value (_tmp7_, gvir_config_domain_sound_model_get_type ());
		_tmp4_ = _tmp8_;
	} else {
		_tmp4_ = (gint) GVIR_CONFIG_DOMAIN_SOUND_MODEL_AC97;
	}
	_tmp9_ = _tmp4_;
	model = _tmp9_;
	g_return_if_fail (model != (-1));
	_tmp10_ = sound;
	gvir_config_domain_sound_set_model (_tmp10_, (GVirConfigDomainSoundModel) model);
	_tmp11_ = domain;
	_tmp12_ = sound;
	gvir_config_domain_add_device (_tmp11_, (GVirConfigDomainDevice*) _tmp12_);
	_g_object_unref0 (device);
	_g_object_unref0 (sound);
}


static void boxes_vm_configurator_set_tablet_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainInput* _tmp0_;
	GVirConfigDomainInput* input;
	GVirConfigDomain* _tmp1_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = gvir_config_domain_input_new ();
	input = _tmp0_;
	gvir_config_domain_input_set_device_type (input, GVIR_CONFIG_DOMAIN_INPUT_DEVICE_TABLET);
	_tmp1_ = domain;
	gvir_config_domain_add_device (_tmp1_, (GVirConfigDomainDevice*) input);
	_g_object_unref0 (input);
}


static GVirConfigStoragePermissions* boxes_vm_configurator_get_default_permissions (void) {
	GVirConfigStoragePermissions* result = NULL;
	GVirConfigStoragePermissions* _tmp0_;
	GVirConfigStoragePermissions* permissions;
	uid_t _tmp1_ = {0};
	gid_t _tmp2_ = {0};
	_tmp0_ = gvir_config_storage_permissions_new ();
	permissions = _tmp0_;
	_tmp1_ = getuid ();
	gvir_config_storage_permissions_set_owner (permissions, (guint) _tmp1_);
	_tmp2_ = getgid ();
	gvir_config_storage_permissions_set_group (permissions, (guint) _tmp2_);
	gvir_config_storage_permissions_set_mode (permissions, (guint) 744);
	result = permissions;
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static gchar* boxes_vm_configurator_get_os_state (GVirConfigDomain* domain) {
	gchar* result = NULL;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* xml;
	const gchar* _tmp2_;
	GVirConfigDomain* _tmp20_;
	const gchar* _tmp21_ = NULL;
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = domain;
	_tmp1_ = gvir_config_domain_get_custom_xml (_tmp0_, BOXES_VM_CONFIGURATOR_BOXES_NS_URI);
	xml = _tmp1_;
	_tmp2_ = xml;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		guint8* _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		xmlTextReader* _tmp9_;
		xmlTextReader* reader;
		_tmp3_ = xml;
		_tmp4_ = string_get_data (_tmp3_, &_tmp4__length1);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _tmp4__length1;
		_tmp6_ = xml;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = xmlReaderForMemory ((gchar*) _tmp5_, _tmp8_, BOXES_VM_CONFIGURATOR_BOXES_NS_URI, NULL, (gint) XML_PARSE_COMPACT);
		reader = _tmp9_;
		{
			gboolean _tmp10_;
			_tmp10_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_;
				xmlTextReader* _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				gboolean _tmp17_;
				_tmp11_ = _tmp10_;
				if (!_tmp11_) {
					xmlTextReader* _tmp12_;
					gint _tmp13_ = 0;
					_tmp12_ = reader;
					_tmp13_ = xmlTextReaderNext (_tmp12_);
					if (!(_tmp13_ == 1)) {
						break;
					}
				}
				_tmp10_ = FALSE;
				_tmp14_ = reader;
				_tmp15_ = xmlTextReaderName (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strcmp0 (_tmp16_, "boxes:os-state") == 0;
				_g_free0 (_tmp16_);
				if (_tmp17_) {
					xmlTextReader* _tmp18_;
					gchar* _tmp19_ = NULL;
					_tmp18_ = reader;
					_tmp19_ = xmlTextReaderReadString (_tmp18_);
					result = _tmp19_;
					_xmlFreeTextReader0 (reader);
					_g_free0 (xml);
					return result;
				}
			}
		}
		_xmlFreeTextReader0 (reader);
	}
	_tmp20_ = domain;
	_tmp21_ = gvir_config_domain_get_name (_tmp20_);
	g_debug ("vm-configurator.vala:278: no Boxes OS state for domain '%s'.", _tmp21_);
	result = NULL;
	_g_free0 (xml);
	return result;
}


static GVirConfigCapabilitiesGuest* boxes_vm_configurator_get_best_guest_caps (GVirConfigCapabilities* caps, BoxesInstallerMedia* install_media, GError** error) {
	GVirConfigCapabilitiesGuest* result = NULL;
	GVirConfigCapabilities* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* guests_caps;
	GList* compat_guests_caps;
	GList* _tmp2_;
	GList* _tmp15_;
	GList* _tmp19_;
	const gchar* _tmp23_ = NULL;
	GError* _tmp24_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (caps != NULL, NULL);
	g_return_val_if_fail (install_media != NULL, NULL);
	_tmp0_ = caps;
	_tmp1_ = gvir_config_capabilities_get_guests (_tmp0_);
	guests_caps = _tmp1_;
	compat_guests_caps = NULL;
	_tmp2_ = guests_caps;
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
		guest_caps_collection = _tmp2_;
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
			GVirConfigCapabilitiesGuest* _tmp3_;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
			_tmp3_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
			guest_caps = _tmp3_;
			{
				GVirConfigCapabilitiesGuest* _tmp4_;
				GVirConfigCapabilitiesGuestArch* _tmp5_ = NULL;
				GVirConfigCapabilitiesGuestArch* _tmp6_;
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* guest_arch;
				BoxesInstallerMedia* _tmp10_;
				const gchar* _tmp11_;
				gboolean _tmp12_ = FALSE;
				_tmp4_ = guest_caps;
				_tmp5_ = gvir_config_capabilities_guest_get_arch (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = gvir_config_capabilities_guest_arch_get_name (_tmp6_);
				_tmp8_ = g_strdup (_tmp7_);
				_tmp9_ = _tmp8_;
				_g_object_unref0 (_tmp6_);
				guest_arch = _tmp9_;
				_tmp10_ = install_media;
				_tmp11_ = guest_arch;
				_tmp12_ = boxes_installer_media_is_architecture_compatible (_tmp10_, _tmp11_);
				if (_tmp12_) {
					GVirConfigCapabilitiesGuest* _tmp13_;
					GVirConfigCapabilitiesGuest* _tmp14_;
					_tmp13_ = guest_caps;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					compat_guests_caps = g_list_append (compat_guests_caps, _tmp14_);
				}
				_g_free0 (guest_arch);
				_g_object_unref0 (guest_caps);
			}
		}
	}
	_tmp15_ = compat_guests_caps;
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
		guest_caps_collection = _tmp15_;
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
			GVirConfigCapabilitiesGuest* _tmp16_;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
			_tmp16_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
			guest_caps = _tmp16_;
			{
				GVirConfigCapabilitiesGuest* _tmp17_;
				gboolean _tmp18_ = FALSE;
				_tmp17_ = guest_caps;
				_tmp18_ = boxes_vm_configurator_guest_kvm_enabled (_tmp17_);
				if (_tmp18_) {
					result = guest_caps;
					__g_list_free__g_object_unref0_0 (compat_guests_caps);
					__g_list_free__g_object_unref0_0 (guests_caps);
					return result;
				}
				_g_object_unref0 (guest_caps);
			}
		}
	}
	_tmp19_ = compat_guests_caps;
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
		guest_caps_collection = _tmp19_;
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
			GVirConfigCapabilitiesGuest* _tmp20_;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
			_tmp20_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
			guest_caps = _tmp20_;
			{
				GVirConfigCapabilitiesGuest* _tmp21_;
				gboolean _tmp22_ = FALSE;
				_tmp21_ = guest_caps;
				_tmp22_ = boxes_vm_configurator_guest_is_qemu (_tmp21_);
				if (_tmp22_) {
					result = guest_caps;
					__g_list_free__g_object_unref0_0 (compat_guests_caps);
					__g_list_free__g_object_unref0_0 (guests_caps);
					return result;
				}
				_g_object_unref0 (guest_caps);
			}
		}
	}
	_tmp23_ = _ ("Incapable host system");
	_tmp24_ = g_error_new_literal (BOXES_VM_CONFIGURATOR_ERROR, BOXES_VM_CONFIGURATOR_ERROR_NO_GUEST_CAPS, _tmp23_);
	_inner_error_ = _tmp24_;
	if (_inner_error_->domain == BOXES_VM_CONFIGURATOR_ERROR) {
		g_propagate_error (error, _inner_error_);
		__g_list_free__g_object_unref0_0 (compat_guests_caps);
		__g_list_free__g_object_unref0_0 (guests_caps);
		return NULL;
	} else {
		__g_list_free__g_object_unref0_0 (compat_guests_caps);
		__g_list_free__g_object_unref0_0 (guests_caps);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	__g_list_free__g_object_unref0_0 (compat_guests_caps);
	__g_list_free__g_object_unref0_0 (guests_caps);
}


static gboolean boxes_vm_configurator_guest_kvm_enabled (GVirConfigCapabilitiesGuest* guest_caps) {
	gboolean result = FALSE;
	GVirConfigCapabilitiesGuest* _tmp0_;
	GVirConfigCapabilitiesGuestArch* _tmp1_ = NULL;
	GVirConfigCapabilitiesGuestArch* arch;
	GVirConfigCapabilitiesGuestArch* _tmp2_;
	GList* _tmp3_ = NULL;
	g_return_val_if_fail (guest_caps != NULL, FALSE);
	_tmp0_ = guest_caps;
	_tmp1_ = gvir_config_capabilities_guest_get_arch (_tmp0_);
	arch = _tmp1_;
	_tmp2_ = arch;
	_tmp3_ = gvir_config_capabilities_guest_arch_get_domains (_tmp2_);
	{
		GList* domain_collection = NULL;
		GList* domain_it = NULL;
		domain_collection = _tmp3_;
		for (domain_it = domain_collection; domain_it != NULL; domain_it = domain_it->next) {
			GVirConfigCapabilitiesGuestDomain* _tmp4_;
			GVirConfigCapabilitiesGuestDomain* domain = NULL;
			_tmp4_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestDomain*) domain_it->data);
			domain = _tmp4_;
			{
				GVirConfigCapabilitiesGuestDomain* _tmp5_;
				GVirConfigDomainVirtType _tmp6_ = 0;
				_tmp5_ = domain;
				_tmp6_ = gvir_config_capabilities_guest_domain_get_virt_type (_tmp5_);
				if (_tmp6_ == GVIR_CONFIG_DOMAIN_VIRT_KVM) {
					result = TRUE;
					_g_object_unref0 (domain);
					__g_list_free__g_object_unref0_0 (domain_collection);
					_g_object_unref0 (arch);
					return result;
				}
				_g_object_unref0 (domain);
			}
		}
		__g_list_free__g_object_unref0_0 (domain_collection);
	}
	result = FALSE;
	_g_object_unref0 (arch);
	return result;
}


static gboolean boxes_vm_configurator_guest_is_qemu (GVirConfigCapabilitiesGuest* guest_caps) {
	gboolean result = FALSE;
	GVirConfigCapabilitiesGuest* _tmp0_;
	GVirConfigCapabilitiesGuestArch* _tmp1_ = NULL;
	GVirConfigCapabilitiesGuestArch* arch;
	GVirConfigCapabilitiesGuestArch* _tmp2_;
	GList* _tmp3_ = NULL;
	g_return_val_if_fail (guest_caps != NULL, FALSE);
	_tmp0_ = guest_caps;
	_tmp1_ = gvir_config_capabilities_guest_get_arch (_tmp0_);
	arch = _tmp1_;
	_tmp2_ = arch;
	_tmp3_ = gvir_config_capabilities_guest_arch_get_domains (_tmp2_);
	{
		GList* domain_collection = NULL;
		GList* domain_it = NULL;
		domain_collection = _tmp3_;
		for (domain_it = domain_collection; domain_it != NULL; domain_it = domain_it->next) {
			GVirConfigCapabilitiesGuestDomain* _tmp4_;
			GVirConfigCapabilitiesGuestDomain* domain = NULL;
			_tmp4_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestDomain*) domain_it->data);
			domain = _tmp4_;
			{
				GVirConfigCapabilitiesGuestDomain* _tmp5_;
				GVirConfigDomainVirtType _tmp6_ = 0;
				_tmp5_ = domain;
				_tmp6_ = gvir_config_capabilities_guest_domain_get_virt_type (_tmp5_);
				if (_tmp6_ == GVIR_CONFIG_DOMAIN_VIRT_QEMU) {
					result = TRUE;
					_g_object_unref0 (domain);
					__g_list_free__g_object_unref0_0 (domain_collection);
					_g_object_unref0 (arch);
					return result;
				}
				_g_object_unref0 (domain);
			}
		}
		__g_list_free__g_object_unref0_0 (domain_collection);
	}
	result = FALSE;
	_g_object_unref0 (arch);
	return result;
}


static gboolean boxes_vm_configurator_guest_supports_feature (GVirConfigCapabilitiesGuest* guest_caps, const gchar* feature_name) {
	gboolean result = FALSE;
	gboolean supports;
	GVirConfigCapabilitiesGuest* _tmp0_;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (guest_caps != NULL, FALSE);
	g_return_val_if_fail (feature_name != NULL, FALSE);
	supports = FALSE;
	_tmp0_ = guest_caps;
	_tmp1_ = gvir_config_capabilities_guest_get_features (_tmp0_);
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
		feature_collection = _tmp1_;
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
			GVirConfigCapabilitiesGuestFeature* _tmp2_;
			GVirConfigCapabilitiesGuestFeature* feature = NULL;
			_tmp2_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestFeature*) feature_it->data);
			feature = _tmp2_;
			{
				const gchar* _tmp3_;
				GVirConfigCapabilitiesGuestFeature* _tmp4_;
				const gchar* _tmp5_ = NULL;
				_tmp3_ = feature_name;
				_tmp4_ = feature;
				_tmp5_ = gvir_config_capabilities_guest_feature_get_name (_tmp4_);
				if (g_strcmp0 (_tmp3_, _tmp5_) == 0) {
					supports = TRUE;
					_g_object_unref0 (feature);
					break;
				}
				_g_object_unref0 (feature);
			}
		}
		__g_list_free__g_object_unref0_0 (feature_collection);
	}
	result = supports;
	return result;
}


BoxesVMConfigurator* boxes_vm_configurator_construct (GType object_type) {
	BoxesVMConfigurator* self = NULL;
	self = (BoxesVMConfigurator*) g_type_create_instance (object_type);
	return self;
}


BoxesVMConfigurator* boxes_vm_configurator_new (void) {
	return boxes_vm_configurator_construct (BOXES_TYPE_VM_CONFIGURATOR);
}


static void boxes_value_vm_configurator_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void boxes_value_vm_configurator_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		boxes_vm_configurator_unref (value->data[0].v_pointer);
	}
}


static void boxes_value_vm_configurator_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = boxes_vm_configurator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer boxes_value_vm_configurator_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* boxes_value_vm_configurator_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		BoxesVMConfigurator* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = boxes_vm_configurator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* boxes_value_vm_configurator_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BoxesVMConfigurator** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = boxes_vm_configurator_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* boxes_param_spec_vm_configurator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BoxesParamSpecVMConfigurator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BOXES_TYPE_VM_CONFIGURATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer boxes_value_get_vm_configurator (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR), NULL);
	return value->data[0].v_pointer;
}


void boxes_value_set_vm_configurator (GValue* value, gpointer v_object) {
	BoxesVMConfigurator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		boxes_vm_configurator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_vm_configurator_unref (old);
	}
}


void boxes_value_take_vm_configurator (GValue* value, gpointer v_object) {
	BoxesVMConfigurator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_vm_configurator_unref (old);
	}
}


static void boxes_vm_configurator_class_init (BoxesVMConfiguratorClass * klass) {
	boxes_vm_configurator_parent_class = g_type_class_peek_parent (klass);
	BOXES_VM_CONFIGURATOR_CLASS (klass)->finalize = boxes_vm_configurator_finalize;
}


static void boxes_vm_configurator_instance_init (BoxesVMConfigurator * self) {
	self->ref_count = 1;
}


static void boxes_vm_configurator_finalize (BoxesVMConfigurator* obj) {
	BoxesVMConfigurator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfigurator);
}


GType boxes_vm_configurator_get_type (void) {
	static volatile gsize boxes_vm_configurator_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_vm_configurator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { boxes_value_vm_configurator_init, boxes_value_vm_configurator_free_value, boxes_value_vm_configurator_copy_value, boxes_value_vm_configurator_peek_pointer, "p", boxes_value_vm_configurator_collect_value, "p", boxes_value_vm_configurator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BoxesVMConfiguratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_vm_configurator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesVMConfigurator), 0, (GInstanceInitFunc) boxes_vm_configurator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType boxes_vm_configurator_type_id;
		boxes_vm_configurator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BoxesVMConfigurator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&boxes_vm_configurator_type_id__volatile, boxes_vm_configurator_type_id);
	}
	return boxes_vm_configurator_type_id__volatile;
}


gpointer boxes_vm_configurator_ref (gpointer instance) {
	BoxesVMConfigurator* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void boxes_vm_configurator_unref (gpointer instance) {
	BoxesVMConfigurator* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BOXES_VM_CONFIGURATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



