/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-indenter.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-indenter
 * @title: IAnjutaIndenter
 * @short_description: Interface for automatic indentation
 * @see_also:
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-indenter.h
 *
 */

#include "ianjuta-indenter.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_indenter_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-indenter-quark");
	}
	
	return quark;
}

/**
 * ianjuta_indenter_indent
 * @obj: Self
 * @start: Start of the area to indent
 * @end: End of the area to indent
 * @error: Error propagation
 *
 * Indent the area between @start and @end according to the indentation rules
 * of the programming language. Usually implemented by language support plugins.
 * Only one indenter can be loaded at a time.
 * Note: Indenters always affect full lines, so start and end will be moved
 * according to the next line start/end.
 */
void
ianjuta_indenter_indent (IAnjutaIndenter *obj, IAnjutaIterable* start,   IAnjutaIterable* end, GError **err)
{
	g_return_if_fail (IANJUTA_IS_INDENTER(obj));
	g_return_if_fail ((start == NULL) ||IANJUTA_IS_ITERABLE(start));
	g_return_if_fail ((end == NULL) ||IANJUTA_IS_ITERABLE(end));
	IANJUTA_INDENTER_GET_IFACE (obj)->indent (obj, start, end, err);
}

/* Default implementation */
static void
ianjuta_indenter_indent_default (IAnjutaIndenter *obj, IAnjutaIterable* start,   IAnjutaIterable* end, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_indenter_base_init (IAnjutaIndenterIface* klass)
{
	static gboolean initialized = FALSE;

	klass->indent = ianjuta_indenter_indent_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_indenter_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaIndenterIface),
			(GBaseInitFunc) ianjuta_indenter_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaIndenter", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
