/* rygel-music-item.c generated by valac 0.15.2.4-51044, the Vala compiler
 * generated from rygel-music-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gst/gst.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ART_STORE (rygel_media_art_store_get_type ())
#define RYGEL_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore))
#define RYGEL_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))
#define RYGEL_IS_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_IS_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_MEDIA_ART_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))

typedef struct _RygelMediaArtStore RygelMediaArtStore;
typedef struct _RygelMediaArtStoreClass RygelMediaArtStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	gchar* artist;
	gchar* album;
	gchar* genre;
	gint track_number;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};


static gpointer rygel_music_item_parent_class = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY
};
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
void rygel_music_item_lookup_album_art (RygelMusicItem* self);
GType rygel_media_art_store_get_type (void) G_GNUC_CONST;
RygelMediaArtStore* rygel_media_art_store_get_default (void);
RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMusicItem* item, GError** error);
static void rygel_music_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error);
static gint rygel_music_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2);
gint rygel_media_object_compare_int_props (RygelMediaObject* self, gint prop1, gint prop2);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static GUPnPDIDLLiteObject* rygel_music_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
static void rygel_music_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const gchar* uri);
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
static void rygel_music_item_finalize (GObject* obj);


RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelMusicItem * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = title;
	_tmp3_ = upnp_class;
	self = (RygelMusicItem*) rygel_audio_item_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	return self;
}


RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM, id, parent, title, upnp_class);
}


void rygel_music_item_lookup_album_art (RygelMusicItem* self) {
	RygelThumbnail* _tmp0_;
	RygelMediaArtStore* _tmp1_ = NULL;
	RygelMediaArtStore* media_art_store;
	RygelMediaArtStore* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->album_art;
	g_assert (_tmp0_ == NULL);
	_tmp1_ = rygel_media_art_store_get_default ();
	media_art_store = _tmp1_;
	_tmp2_ = media_art_store;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (media_art_store);
		return;
	}
	{
		RygelMediaArtStore* _tmp3_;
		RygelThumbnail* _tmp4_ = NULL;
		RygelThumbnail* _tmp5_;
		_tmp3_ = media_art_store;
		_tmp4_ = rygel_media_art_store_find_media_art_any (_tmp3_, self, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch58_g_error;
		}
		_rygel_icon_info_unref0 (self->album_art);
		self->album_art = _tmp5_;
	}
	goto __finally58;
	__catch58_g_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally58:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (media_art_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (media_art_store);
}


static void rygel_music_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	RygelMusicItem * self;
	GUPnPDIDLLiteItem* _tmp0_;
	gboolean _tmp1_;
	RygelThumbnail* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (RygelMusicItem*) base;
	g_return_if_fail (didl_item != NULL);
	_tmp0_ = didl_item;
	_tmp1_ = allow_internal;
	RYGEL_MEDIA_ITEM_CLASS (rygel_music_item_parent_class)->add_resources ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), _tmp0_, _tmp1_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = self->album_art;
	if (_tmp2_ != NULL) {
		RygelThumbnail* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* protocol;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		gboolean _tmp9_;
		_tmp3_ = self->album_art;
		_tmp4_ = ((RygelIconInfo*) _tmp3_)->uri;
		_tmp5_ = rygel_media_item_get_protocol_for_uri ((RygelMediaItem*) self, _tmp4_, &_inner_error_);
		protocol = _tmp5_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp7_ = allow_internal;
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			const gchar* _tmp8_;
			_tmp8_ = protocol;
			_tmp6_ = g_strcmp0 (_tmp8_, "internal") != 0;
		}
		_tmp9_ = _tmp6_;
		if (_tmp9_) {
			GUPnPDIDLLiteItem* _tmp10_;
			RygelThumbnail* _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = didl_item;
			_tmp11_ = self->album_art;
			_tmp12_ = ((RygelIconInfo*) _tmp11_)->uri;
			gupnp_didl_lite_object_set_album_art ((GUPnPDIDLLiteObject*) _tmp10_, _tmp12_);
		}
		_g_free0 (protocol);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint rygel_music_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property) {
	RygelMusicItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMusicItem* _tmp2_;
	RygelMusicItem* item;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	self = (RygelMusicItem*) base;
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	_tmp0_ = media_object;
	if (!RYGEL_IS_MUSIC_ITEM (_tmp0_)) {
		result = 1;
		return result;
	}
	_tmp1_ = media_object;
	_tmp2_ = _g_object_ref0 (RYGEL_IS_MUSIC_ITEM (_tmp1_) ? ((RygelMusicItem*) _tmp1_) : NULL);
	item = _tmp2_;
	_tmp3_ = property;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("dc:artist")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp7_;
				RygelMusicItem* _tmp8_;
				const gchar* _tmp9_;
				gint _tmp10_ = 0;
				_tmp7_ = self->artist;
				_tmp8_ = item;
				_tmp9_ = _tmp8_->artist;
				_tmp10_ = rygel_media_object_compare_string_props ((RygelMediaObject*) self, _tmp7_, _tmp9_);
				result = _tmp10_;
				_g_object_unref0 (item);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("upnp:album")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp11_;
				RygelMusicItem* _tmp12_;
				const gchar* _tmp13_;
				gint _tmp14_ = 0;
				_tmp11_ = self->album;
				_tmp12_ = item;
				_tmp13_ = _tmp12_->album;
				_tmp14_ = rygel_media_object_compare_string_props ((RygelMediaObject*) self, _tmp11_, _tmp13_);
				result = _tmp14_;
				_g_object_unref0 (item);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("upnp:originalTrackNumber")))) {
		switch (0) {
			default:
			{
				gint _tmp15_;
				RygelMusicItem* _tmp16_;
				gint _tmp17_;
				gint _tmp18_ = 0;
				_tmp15_ = self->track_number;
				_tmp16_ = item;
				_tmp17_ = _tmp16_->track_number;
				_tmp18_ = rygel_media_object_compare_int_props ((RygelMediaObject*) self, _tmp15_, _tmp17_);
				result = _tmp18_;
				_g_object_unref0 (item);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				RygelMusicItem* _tmp19_;
				const gchar* _tmp20_;
				gint _tmp21_ = 0;
				_tmp19_ = item;
				_tmp20_ = property;
				_tmp21_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->compare_by_property ((RygelMediaObject*) RYGEL_AUDIO_ITEM (self), (RygelMediaObject*) _tmp19_, _tmp20_);
				result = _tmp21_;
				_g_object_unref0 (item);
				return result;
			}
		}
	}
	_g_object_unref0 (item);
}


static GUPnPDIDLLiteObject* rygel_music_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
	RygelMusicItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteWriter* _tmp0_;
	RygelHTTPServer* _tmp1_;
	GUPnPDIDLLiteObject* _tmp2_ = NULL;
	GUPnPDIDLLiteObject* didl_item;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	gint _tmp11_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gboolean _tmp17_;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	gboolean _tmp23_;
	GUPnPDIDLLiteObject* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GError * _inner_error_ = NULL;
	self = (RygelMusicItem*) base;
	g_return_val_if_fail (writer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = writer;
	_tmp1_ = http_server;
	_tmp2_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->serialize ((RygelMediaObject*) RYGEL_AUDIO_ITEM (self), _tmp0_, _tmp1_, &_inner_error_);
	didl_item = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp4_ = self->artist;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = self->artist;
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		GUPnPDIDLLiteObject* _tmp7_;
		GUPnPDIDLLiteContributor* _tmp8_ = NULL;
		GUPnPDIDLLiteContributor* contributor;
		GUPnPDIDLLiteContributor* _tmp9_;
		const gchar* _tmp10_;
		_tmp7_ = didl_item;
		_tmp8_ = gupnp_didl_lite_object_add_artist (_tmp7_);
		contributor = _tmp8_;
		_tmp9_ = contributor;
		_tmp10_ = self->artist;
		gupnp_didl_lite_contributor_set_name (_tmp9_, _tmp10_);
		_g_object_unref0 (contributor);
	}
	_tmp11_ = self->track_number;
	if (_tmp11_ >= 0) {
		GUPnPDIDLLiteObject* _tmp12_;
		gint _tmp13_;
		_tmp12_ = didl_item;
		_tmp13_ = self->track_number;
		gupnp_didl_lite_object_set_track_number (_tmp12_, _tmp13_);
	}
	_tmp15_ = self->album;
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_;
		_tmp16_ = self->album;
		_tmp14_ = g_strcmp0 (_tmp16_, "") != 0;
	} else {
		_tmp14_ = FALSE;
	}
	_tmp17_ = _tmp14_;
	if (_tmp17_) {
		GUPnPDIDLLiteObject* _tmp18_;
		const gchar* _tmp19_;
		_tmp18_ = didl_item;
		_tmp19_ = self->album;
		gupnp_didl_lite_object_set_album (_tmp18_, _tmp19_);
	}
	_tmp21_ = self->genre;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_;
		_tmp22_ = self->genre;
		_tmp20_ = g_strcmp0 (_tmp22_, "") != 0;
	} else {
		_tmp20_ = FALSE;
	}
	_tmp23_ = _tmp20_;
	if (_tmp23_) {
		GUPnPDIDLLiteObject* _tmp24_;
		const gchar* _tmp25_;
		_tmp24_ = didl_item;
		_tmp25_ = self->genre;
		gupnp_didl_lite_object_set_genre (_tmp24_, _tmp25_);
	}
	_tmp26_ = didl_item;
	_tmp27_ = gupnp_didl_lite_object_get_album_art (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != NULL) {
		GRegex* _tmp29_;
		GUPnPDIDLLiteObject* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		RygelHTTPServer* _tmp33_;
		GUPnPContext* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_;
		GUPnPDIDLLiteObject* _tmp39_;
		gchar* _tmp40_;
		_tmp29_ = ((RygelMediaItem*) self)->address_regex;
		_tmp30_ = didl_item;
		_tmp31_ = gupnp_didl_lite_object_get_album_art (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = http_server;
		_tmp34_ = _tmp33_->context;
		_tmp35_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_regex_replace_literal (_tmp29_, _tmp32_, (gssize) (-1), 0, _tmp36_, 0, &_inner_error_);
		_tmp38_ = _tmp37_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (didl_item);
			return NULL;
		}
		_tmp39_ = didl_item;
		_tmp40_ = _tmp38_;
		gupnp_didl_lite_object_set_album_art (_tmp39_, _tmp40_);
		_g_free0 (_tmp40_);
	}
	result = didl_item;
	return result;
}


static void rygel_music_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	RygelMusicItem * self;
	RygelHTTPServer* _tmp0_;
	GUPnPDIDLLiteItem* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp12_;
	GError * _inner_error_ = NULL;
	self = (RygelMusicItem*) base;
	g_return_if_fail (server != NULL);
	g_return_if_fail (didl_item != NULL);
	_tmp0_ = server;
	_tmp1_ = didl_item;
	RYGEL_MEDIA_ITEM_CLASS (rygel_music_item_parent_class)->add_proxy_resources ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), _tmp0_, _tmp1_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp4_ = rygel_media_item_get_place_holder ((RygelMediaItem*) self);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		RygelThumbnail* _tmp6_;
		_tmp6_ = self->album_art;
		_tmp3_ = _tmp6_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp7_ = _tmp3_;
	if (_tmp7_) {
		RygelHTTPServer* _tmp8_;
		RygelThumbnail* _tmp9_;
		const gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp8_ = server;
		_tmp9_ = self->album_art;
		_tmp10_ = ((RygelIconInfo*) _tmp9_)->uri;
		_tmp11_ = rygel_http_server_need_proxy (_tmp8_, _tmp10_);
		_tmp2_ = _tmp11_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp12_ = _tmp2_;
	if (_tmp12_) {
		GUPnPDIDLLiteItem* _tmp13_;
		RygelHTTPServer* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		_tmp13_ = didl_item;
		_tmp14_ = server;
		_tmp15_ = rygel_transcode_manager_create_uri_for_item ((RygelTranscodeManager*) _tmp14_, (RygelMediaItem*) self, 0, -1, NULL);
		_tmp16_ = _tmp15_;
		gupnp_didl_lite_object_set_album_art ((GUPnPDIDLLiteObject*) _tmp13_, _tmp16_);
		_g_free0 (_tmp16_);
	}
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resources = rygel_music_item_real_add_resources;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_music_item_real_compare_by_property;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_music_item_real_serialize;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_proxy_resources = rygel_music_item_real_add_proxy_resources;
	G_OBJECT_CLASS (klass)->finalize = rygel_music_item_finalize;
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
	self->track_number = -1;
}


static void rygel_music_item_finalize (GObject* obj) {
	RygelMusicItem * self;
	self = RYGEL_MUSIC_ITEM (obj);
	_g_free0 (self->artist);
	_g_free0 (self->album);
	_g_free0 (self->genre);
	_rygel_icon_info_unref0 (self->album_art);
	G_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
}


/**
 * Represents a music item.
 */
GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}



