/* rygel-volume.c generated by valac 0.15.1.36-84b2b, the Vala compiler
 * generated from rygel-volume.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
/* Helper class for converting between double and percentage representations*/
/* of volume.*/

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_VOLUME (rygel_volume_get_type ())
#define RYGEL_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VOLUME, RygelVolume))
#define RYGEL_VOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VOLUME, RygelVolumeClass))
#define RYGEL_IS_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VOLUME))
#define RYGEL_IS_VOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VOLUME))
#define RYGEL_VOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VOLUME, RygelVolumeClass))

typedef struct _RygelVolume RygelVolume;
typedef struct _RygelVolumeClass RygelVolumeClass;
typedef struct _RygelVolumePrivate RygelVolumePrivate;
typedef struct _RygelParamSpecVolume RygelParamSpecVolume;

struct _RygelVolume {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelVolumePrivate * priv;
};

struct _RygelVolumeClass {
	GTypeClass parent_class;
	void (*finalize) (RygelVolume *self);
};

struct _RygelParamSpecVolume {
	GParamSpec parent_instance;
};


static gpointer rygel_volume_parent_class = NULL;

gpointer rygel_volume_ref (gpointer instance);
void rygel_volume_unref (gpointer instance);
GParamSpec* rygel_param_spec_volume (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_volume (GValue* value, gpointer v_object);
void rygel_value_take_volume (GValue* value, gpointer v_object);
gpointer rygel_value_get_volume (const GValue* value);
GType rygel_volume_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_VOLUME_DUMMY_PROPERTY
};
gdouble rygel_volume_from_percentage (guint percentage);
guint rygel_volume_to_percentage (gdouble volume);
RygelVolume* rygel_volume_new (void);
RygelVolume* rygel_volume_construct (GType object_type);
static void rygel_volume_finalize (RygelVolume* obj);


gdouble rygel_volume_from_percentage (guint percentage) {
	gdouble result = 0.0;
	guint _tmp0_;
	_tmp0_ = percentage;
	result = ((gdouble) _tmp0_) / 100.0;
	return result;
}


guint rygel_volume_to_percentage (gdouble volume) {
	guint result = 0U;
	gdouble _tmp0_;
	_tmp0_ = volume;
	result = (guint) (_tmp0_ * 100.0);
	return result;
}


RygelVolume* rygel_volume_construct (GType object_type) {
	RygelVolume* self = NULL;
	self = (RygelVolume*) g_type_create_instance (object_type);
	return self;
}


RygelVolume* rygel_volume_new (void) {
	return rygel_volume_construct (RYGEL_TYPE_VOLUME);
}


static void rygel_value_volume_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_volume_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_volume_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_volume_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_volume_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_volume_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_volume_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelVolume* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_volume_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_volume_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelVolume** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_volume_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_volume (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecVolume* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_VOLUME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_volume (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_VOLUME), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_volume (GValue* value, gpointer v_object) {
	RygelVolume* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_VOLUME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_VOLUME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_volume_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_volume_unref (old);
	}
}


void rygel_value_take_volume (GValue* value, gpointer v_object) {
	RygelVolume* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_VOLUME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_VOLUME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_volume_unref (old);
	}
}


static void rygel_volume_class_init (RygelVolumeClass * klass) {
	rygel_volume_parent_class = g_type_class_peek_parent (klass);
	RYGEL_VOLUME_CLASS (klass)->finalize = rygel_volume_finalize;
}


static void rygel_volume_instance_init (RygelVolume * self) {
	self->ref_count = 1;
}


static void rygel_volume_finalize (RygelVolume* obj) {
	RygelVolume * self;
	self = RYGEL_VOLUME (obj);
}


GType rygel_volume_get_type (void) {
	static volatile gsize rygel_volume_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_volume_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_volume_init, rygel_value_volume_free_value, rygel_value_volume_copy_value, rygel_value_volume_peek_pointer, "p", rygel_value_volume_collect_value, "p", rygel_value_volume_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelVolumeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_volume_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVolume), 0, (GInstanceInitFunc) rygel_volume_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_volume_type_id;
		rygel_volume_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelVolume", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_volume_type_id__volatile, rygel_volume_type_id);
	}
	return rygel_volume_type_id__volatile;
}


gpointer rygel_volume_ref (gpointer instance) {
	RygelVolume* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_volume_unref (gpointer instance) {
	RygelVolume* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_VOLUME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



