/* rygel-tracker-item-factory.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-tracker-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2010 MediaNet Inh.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel.h>
#include <gee.h>
#include <libgupnp-dlna/gupnp-dlna-discoverer.h>
#include <gst/gst.h>
#include <libgupnp-dlna/gupnp-dlna-profile.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;

#define RYGEL_TRACKER_ITEM_FACTORY_TYPE_METADATA (rygel_tracker_item_factory_metadata_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelTrackerParamSpecItemFactory RygelTrackerParamSpecItemFactory;

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	gchar* category;
	gchar* category_iri;
	gchar* upnp_class;
	gchar* upload_dir;
	GeeArrayList* properties;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaItem* (*create) (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, gchar** metadata, int metadata_length1, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error);
};

struct _RygelTrackerItemFactoryPrivate {
	GUPnPDLNADiscoverer* discoverer;
};

typedef enum  {
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_URL,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_PLACE_HOLDER,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_FILE_NAME,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_TITLE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_DLNA_PROFILE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_MIME,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_SIZE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_DATE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY
} RygelTrackerItemFactoryMetadata;

struct _RygelTrackerParamSpecItemFactory {
	GParamSpec parent_instance;
};


static gpointer rygel_tracker_item_factory_parent_class = NULL;

gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_ITEM_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryPrivate))
enum  {
	RYGEL_TRACKER_ITEM_FACTORY_DUMMY_PROPERTY
};
GType rygel_tracker_item_factory_metadata_get_type (void) G_GNUC_CONST;
RygelTrackerItemFactory* rygel_tracker_item_factory_construct (GType object_type, const gchar* category, const gchar* category_iri, const gchar* upnp_class, const gchar* upload_dir);
RygelMediaItem* rygel_tracker_item_factory_create (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, gchar** metadata, int metadata_length1, GError** error);
static RygelMediaItem* rygel_tracker_item_factory_real_create (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, gchar** metadata, int metadata_length1, GError** error);
void rygel_tracker_item_factory_set_ref_id (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* prefix);
void rygel_tracker_item_factory_set_metadata (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error);
static void rygel_tracker_item_factory_real_set_metadata (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error);
static void rygel_tracker_item_factory_finalize (RygelTrackerItemFactory* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType rygel_tracker_item_factory_metadata_get_type (void) {
	static volatile gsize rygel_tracker_item_factory_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_item_factory_metadata_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_TRACKER_ITEM_FACTORY_METADATA_URL, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_URL", "url"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_PLACE_HOLDER, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_PLACE_HOLDER", "place-holder"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_FILE_NAME, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_FILE_NAME", "file-name"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_TITLE, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_TITLE", "title"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_DLNA_PROFILE, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_DLNA_PROFILE", "dlna-profile"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_MIME, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_MIME", "mime"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_SIZE, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_SIZE", "size"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_DATE, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_DATE", "date"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY", "last-key"}, {0, NULL, NULL}};
		GType rygel_tracker_item_factory_metadata_type_id;
		rygel_tracker_item_factory_metadata_type_id = g_enum_register_static ("RygelTrackerItemFactoryMetadata", values);
		g_once_init_leave (&rygel_tracker_item_factory_metadata_type_id__volatile, rygel_tracker_item_factory_metadata_type_id);
	}
	return rygel_tracker_item_factory_metadata_type_id__volatile;
}


RygelTrackerItemFactory* rygel_tracker_item_factory_construct (GType object_type, const gchar* category, const gchar* category_iri, const gchar* upnp_class, const gchar* upload_dir) {
	RygelTrackerItemFactory* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GUPnPDLNADiscoverer* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp21_;
	GeeArrayList* _tmp22_;
	g_return_val_if_fail (category != NULL, NULL);
	g_return_val_if_fail (category_iri != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	self = (RygelTrackerItemFactory*) g_type_create_instance (object_type);
	_tmp0_ = category;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->category);
	self->category = _tmp1_;
	_tmp2_ = category_iri;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->category_iri);
	self->category_iri = _tmp3_;
	_tmp4_ = upnp_class;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->upnp_class);
	self->upnp_class = _tmp5_;
	_tmp6_ = upload_dir;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->upload_dir);
	self->upload_dir = _tmp7_;
	_tmp9_ = upload_dir;
	if (_tmp9_ == NULL) {
		_tmp8_ = "none";
	} else {
		const gchar* _tmp10_;
		_tmp10_ = upload_dir;
		_tmp8_ = _tmp10_;
	}
	_tmp11_ = _tmp8_;
	_tmp12_ = upnp_class;
	g_message ("rygel-tracker-item-factory.vala:65: Using %s as upload directory for %" \
"s", _tmp11_, _tmp12_);
	_tmp13_ = gupnp_dlna_discoverer_new ((GstClockTime) GST_SECOND, TRUE, TRUE);
	_g_object_unref0 (self->priv->discoverer);
	self->priv->discoverer = _tmp13_;
	_tmp14_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_g_object_unref0 (self->properties);
	self->properties = _tmp14_;
	_tmp15_ = self->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, "res");
	_tmp16_ = self->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, "place_holder");
	_tmp17_ = self->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, "fileName");
	_tmp18_ = self->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, "dc:title");
	_tmp19_ = self->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, "dlnaProfile");
	_tmp20_ = self->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, "mimeType");
	_tmp21_ = self->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, "res@size");
	_tmp22_ = self->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, "date");
	return self;
}


static RygelMediaItem* rygel_tracker_item_factory_real_create (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, gchar** metadata, int metadata_length1, GError** error) {
	g_critical ("Type `%s' does not implement abstract method `rygel_tracker_item_factory_create'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


RygelMediaItem* rygel_tracker_item_factory_create (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, gchar** metadata, int metadata_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS (self)->create (self, id, uri, parent, metadata, metadata_length1, error);
}


void rygel_tracker_item_factory_set_ref_id (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* prefix) {
	RygelMediaItem* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	RygelMediaItem* _tmp4_;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** split_id;
	gint split_id_length1;
	gint _split_id_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	RygelMediaItem* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (prefix != NULL);
	_tmp0_ = item;
	_tmp1_ = ((RygelMediaObject*) _tmp0_)->id;
	_tmp2_ = prefix;
	_tmp3_ = g_str_has_prefix (_tmp1_, _tmp2_);
	if (_tmp3_) {
		return;
	}
	_tmp4_ = item;
	_tmp5_ = ((RygelMediaObject*) _tmp4_)->id;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ",", 0);
	split_id = _tmp7_;
	split_id_length1 = _vala_array_length (_tmp6_);
	_split_id_size_ = split_id_length1;
	_tmp8_ = split_id;
	_tmp8__length1 = split_id_length1;
	if (_tmp8__length1 != 2) {
		split_id = (_vala_array_free (split_id, split_id_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp9_ = item;
	_tmp10_ = prefix;
	_tmp11_ = g_strconcat (_tmp10_, ",", NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = split_id;
	_tmp13__length1 = split_id_length1;
	_tmp14_ = _tmp13_[1];
	_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
	_g_free0 (((RygelMediaObject*) _tmp9_)->ref_id);
	((RygelMediaObject*) _tmp9_)->ref_id = _tmp15_;
	_g_free0 (_tmp12_);
	split_id = (_vala_array_free (split_id, split_id_length1, (GDestroyNotify) g_free), NULL);
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gboolean bool_parse (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_tracker_item_factory_real_set_metadata (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	RygelMediaItem* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gchar** _tmp19_;
	gint _tmp19__length1;
	const gchar* _tmp20_;
	GUPnPDLNAProfile* _tmp25_;
	GUPnPDLNAProfile* profile;
	gchar** _tmp26_;
	gint _tmp26__length1;
	const gchar* _tmp27_;
	GUPnPDLNAProfile* _tmp37_;
	RygelMediaItem* _tmp47_;
	const gchar* _tmp48_;
	g_return_if_fail (item != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = metadata;
	_tmp0__length1 = metadata_length1;
	_tmp1_ = _tmp0_[RYGEL_TRACKER_ITEM_FACTORY_METADATA_TITLE];
	if (g_strcmp0 (_tmp1_, "") != 0) {
		RygelMediaItem* _tmp2_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		const gchar* _tmp4_;
		_tmp2_ = item;
		_tmp3_ = metadata;
		_tmp3__length1 = metadata_length1;
		_tmp4_ = _tmp3_[RYGEL_TRACKER_ITEM_FACTORY_METADATA_TITLE];
		rygel_media_object_set_title ((RygelMediaObject*) _tmp2_, _tmp4_);
	} else {
		RygelMediaItem* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		_tmp5_ = item;
		_tmp6_ = metadata;
		_tmp6__length1 = metadata_length1;
		_tmp7_ = _tmp6_[RYGEL_TRACKER_ITEM_FACTORY_METADATA_FILE_NAME];
		rygel_media_object_set_title ((RygelMediaObject*) _tmp5_, _tmp7_);
	}
	_tmp8_ = metadata;
	_tmp8__length1 = metadata_length1;
	_tmp9_ = _tmp8_[RYGEL_TRACKER_ITEM_FACTORY_METADATA_SIZE];
	if (g_strcmp0 (_tmp9_, "") != 0) {
		RygelMediaItem* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gint64 _tmp13_ = 0LL;
		_tmp10_ = item;
		_tmp11_ = metadata;
		_tmp11__length1 = metadata_length1;
		_tmp12_ = _tmp11_[RYGEL_TRACKER_ITEM_FACTORY_METADATA_SIZE];
		_tmp13_ = int64_parse (_tmp12_);
		rygel_media_item_set_size (_tmp10_, _tmp13_);
	} else {
		RygelMediaItem* _tmp14_;
		_tmp14_ = item;
		rygel_media_item_set_size (_tmp14_, (gint64) 0);
	}
	_tmp15_ = item;
	_tmp16_ = metadata;
	_tmp16__length1 = metadata_length1;
	_tmp17_ = _tmp16_[RYGEL_TRACKER_ITEM_FACTORY_METADATA_PLACE_HOLDER];
	_tmp18_ = bool_parse (_tmp17_);
	rygel_media_item_set_place_holder (_tmp15_, _tmp18_);
	_tmp19_ = metadata;
	_tmp19__length1 = metadata_length1;
	_tmp20_ = _tmp19_[RYGEL_TRACKER_ITEM_FACTORY_METADATA_DATE];
	if (g_strcmp0 (_tmp20_, "") != 0) {
		RygelMediaItem* _tmp21_;
		gchar** _tmp22_;
		gint _tmp22__length1;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp21_ = item;
		_tmp22_ = metadata;
		_tmp22__length1 = metadata_length1;
		_tmp23_ = _tmp22_[RYGEL_TRACKER_ITEM_FACTORY_METADATA_DATE];
		_tmp24_ = g_strdup (_tmp23_);
		_g_free0 (_tmp21_->date);
		_tmp21_->date = _tmp24_;
	}
	_tmp25_ = _g_object_ref0 (GUPNP_IS_DLNA_PROFILE (NULL) ? ((GUPnPDLNAProfile*) NULL) : NULL);
	profile = _tmp25_;
	_tmp26_ = metadata;
	_tmp26__length1 = metadata_length1;
	_tmp27_ = _tmp26_[RYGEL_TRACKER_ITEM_FACTORY_METADATA_DLNA_PROFILE];
	if (g_strcmp0 (_tmp27_, "") != 0) {
		RygelMediaItem* _tmp28_;
		gchar** _tmp29_;
		gint _tmp29__length1;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		GUPnPDLNADiscoverer* _tmp32_;
		RygelMediaItem* _tmp33_;
		const gchar* _tmp34_;
		GUPnPDLNAProfile* _tmp35_ = NULL;
		GUPnPDLNAProfile* _tmp36_;
		_tmp28_ = item;
		_tmp29_ = metadata;
		_tmp29__length1 = metadata_length1;
		_tmp30_ = _tmp29_[RYGEL_TRACKER_ITEM_FACTORY_METADATA_DLNA_PROFILE];
		_tmp31_ = g_strdup (_tmp30_);
		_g_free0 (_tmp28_->dlna_profile);
		_tmp28_->dlna_profile = _tmp31_;
		_tmp32_ = self->priv->discoverer;
		_tmp33_ = item;
		_tmp34_ = _tmp33_->dlna_profile;
		_tmp35_ = gupnp_dlna_discoverer_get_profile (_tmp32_, _tmp34_);
		_tmp36_ = _g_object_ref0 (_tmp35_);
		_g_object_unref0 (profile);
		profile = _tmp36_;
	}
	_tmp37_ = profile;
	if (_tmp37_ != NULL) {
		RygelMediaItem* _tmp38_;
		GUPnPDLNAProfile* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp38_ = item;
		_tmp39_ = profile;
		_tmp40_ = gupnp_dlna_profile_get_mime (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_strdup (_tmp41_);
		_g_free0 (_tmp38_->mime_type);
		_tmp38_->mime_type = _tmp42_;
	} else {
		RygelMediaItem* _tmp43_;
		gchar** _tmp44_;
		gint _tmp44__length1;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		_tmp43_ = item;
		_tmp44_ = metadata;
		_tmp44__length1 = metadata_length1;
		_tmp45_ = _tmp44_[RYGEL_TRACKER_ITEM_FACTORY_METADATA_MIME];
		_tmp46_ = g_strdup (_tmp45_);
		_g_free0 (_tmp43_->mime_type);
		_tmp43_->mime_type = _tmp46_;
	}
	_tmp47_ = item;
	_tmp48_ = uri;
	rygel_media_item_add_uri (_tmp47_, _tmp48_);
	_g_object_unref0 (profile);
}


void rygel_tracker_item_factory_set_metadata (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error) {
	g_return_if_fail (self != NULL);
	RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS (self)->set_metadata (self, item, uri, metadata, metadata_length1, error);
}


static void rygel_tracker_value_item_factory_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_tracker_value_item_factory_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_tracker_item_factory_unref (value->data[0].v_pointer);
	}
}


static void rygel_tracker_value_item_factory_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_tracker_item_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_tracker_value_item_factory_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_tracker_value_item_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelTrackerItemFactory* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_tracker_item_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_tracker_value_item_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelTrackerItemFactory** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_tracker_item_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelTrackerParamSpecItemFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TRACKER_TYPE_ITEM_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_tracker_value_get_item_factory (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TRACKER_TYPE_ITEM_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object) {
	RygelTrackerItemFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TRACKER_TYPE_ITEM_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TRACKER_TYPE_ITEM_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_tracker_item_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_tracker_item_factory_unref (old);
	}
}


void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object) {
	RygelTrackerItemFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TRACKER_TYPE_ITEM_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TRACKER_TYPE_ITEM_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_tracker_item_factory_unref (old);
	}
}


static void rygel_tracker_item_factory_class_init (RygelTrackerItemFactoryClass * klass) {
	rygel_tracker_item_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (klass)->finalize = rygel_tracker_item_factory_finalize;
	g_type_class_add_private (klass, sizeof (RygelTrackerItemFactoryPrivate));
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (klass)->create = rygel_tracker_item_factory_real_create;
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (klass)->set_metadata = rygel_tracker_item_factory_real_set_metadata;
}


static void rygel_tracker_item_factory_instance_init (RygelTrackerItemFactory * self) {
	self->priv = RYGEL_TRACKER_ITEM_FACTORY_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void rygel_tracker_item_factory_finalize (RygelTrackerItemFactory* obj) {
	RygelTrackerItemFactory * self;
	self = RYGEL_TRACKER_ITEM_FACTORY (obj);
	_g_free0 (self->category);
	_g_free0 (self->category_iri);
	_g_free0 (self->upnp_class);
	_g_free0 (self->upload_dir);
	_g_object_unref0 (self->properties);
	_g_object_unref0 (self->priv->discoverer);
}


/**
 * Abstract Tracker item factory.
 */
GType rygel_tracker_item_factory_get_type (void) {
	static volatile gsize rygel_tracker_item_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_item_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_tracker_value_item_factory_init, rygel_tracker_value_item_factory_free_value, rygel_tracker_value_item_factory_copy_value, rygel_tracker_value_item_factory_peek_pointer, "p", rygel_tracker_value_item_factory_collect_value, "p", rygel_tracker_value_item_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerItemFactory), 0, (GInstanceInitFunc) rygel_tracker_item_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_tracker_item_factory_type_id;
		rygel_tracker_item_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelTrackerItemFactory", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_tracker_item_factory_type_id__volatile, rygel_tracker_item_factory_type_id);
	}
	return rygel_tracker_item_factory_type_id__volatile;
}


gpointer rygel_tracker_item_factory_ref (gpointer instance) {
	RygelTrackerItemFactory* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_tracker_item_factory_unref (gpointer instance) {
	RygelTrackerItemFactory* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



