/* gnome-chess.c generated by valac 0.37.1.6-1eaec, the Vala compiler
 * generated from gnome-chess.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2014 Michael Catanzaro
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libchess.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <librsvg/rsvg.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <locale.h>


#define TYPE_CHESS_APPLICATION (chess_application_get_type ())
#define CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_APPLICATION, ChessApplication))
#define CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_APPLICATION, ChessApplicationClass))
#define IS_CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_APPLICATION))
#define IS_CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_APPLICATION))
#define CHESS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_APPLICATION, ChessApplicationClass))

typedef struct _ChessApplication ChessApplication;
typedef struct _ChessApplicationClass ChessApplicationClass;
typedef struct _ChessApplicationPrivate ChessApplicationPrivate;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;

#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;

#define TYPE_AI_PROFILE (ai_profile_get_type ())
#define AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AI_PROFILE, AIProfile))
#define AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AI_PROFILE, AIProfileClass))
#define IS_AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AI_PROFILE))
#define IS_AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AI_PROFILE))
#define AI_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AI_PROFILE, AIProfileClass))

typedef struct _AIProfile AIProfile;
typedef struct _AIProfileClass AIProfileClass;

#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
enum  {
	CHESS_APPLICATION_DUMMY_PROPERTY,
	CHESS_APPLICATION_LAST_PROPERTY
};
static GParamSpec* chess_application_properties[CHESS_APPLICATION_LAST_PROPERTY];

#define CHESS_APPLICATION_TYPE_PROMOTION_TYPE_SELECTED (chess_application_promotion_type_selected_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_CHESS_ENGINE_CECP (chess_engine_cecp_get_type ())
#define CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECP))
#define CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))
#define IS_CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_CECP))
#define IS_CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_CECP))
#define CHESS_ENGINE_CECP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))

typedef struct _ChessEngineCECP ChessEngineCECP;
typedef struct _ChessEngineCECPClass ChessEngineCECPClass;

#define TYPE_CHESS_ENGINE_UCI (chess_engine_uci_get_type ())
#define CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCI))
#define CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))
#define IS_CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_UCI))
#define IS_CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_UCI))
#define CHESS_ENGINE_UCI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))

typedef struct _ChessEngineUCI ChessEngineUCI;
typedef struct _ChessEngineUCIClass ChessEngineUCIClass;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ChessApplication {
	GtkApplication parent_instance;
	ChessApplicationPrivate * priv;
};

struct _ChessApplicationClass {
	GtkApplicationClass parent_class;
};

struct _ChessApplicationPrivate {
	gboolean is_tiled;
	gboolean is_maximized;
	gint window_width;
	gint window_height;
	GSettings* settings;
	GtkApplicationWindow* window;
	GtkContainer* view_container;
	ChessScene* scene;
	ChessView* view;
	GtkButton* pause_resume_button;
	GtkWidget* first_move_button;
	GtkWidget* prev_move_button;
	GtkWidget* next_move_button;
	GtkWidget* last_move_button;
	GtkComboBox* history_combo;
	GtkWidget* white_time_label;
	GtkWidget* black_time_label;
	GtkWidget* timer_increment_label;
	GtkHeaderBar* headerbar;
	GtkDialog* preferences_dialog;
	GtkComboBox* side_combo;
	GtkComboBox* difficulty_combo;
	GtkComboBox* duration_combo;
	GtkComboBox* clock_type_combo;
	GtkAdjustment* duration_adjustment;
	GtkAdjustment* timer_increment_adjustment;
	GtkBox* custom_duration_box;
	GtkBox* timer_increment_box;
	GtkComboBox* timer_increment_units_combo;
	GtkComboBox* custom_duration_units_combo;
	guint save_duration_timeout;
	GtkFileChooserDialog* open_dialog;
	GtkInfoBar* open_dialog_info_bar;
	GtkLabel* open_dialog_error_label;
	GtkFileChooserDialog* save_dialog;
	GtkInfoBar* save_dialog_info_bar;
	GtkLabel* save_dialog_error_label;
	GtkAboutDialog* about_dialog;
	PGNGame* pgn_game;
	ChessGame* game;
	gchar* autosave_filename;
	GFile* game_file;
	gboolean game_needs_saving;
	gboolean starting;
	GList* ai_profiles;
	ChessPlayer* opponent;
	ChessPlayer* human_player;
	ChessEngine* opponent_engine;
	gint engine_timeout_counter;
	gchar* copyrights;
};

typedef enum  {
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN,
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT,
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK,
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP
} ChessApplicationPromotionTypeSelected;

struct _Block1Data {
	int _ref_count_;
	ChessApplication* self;
	GtkInfoBar* no_engine_info_bar;
};

struct _Block2Data {
	int _ref_count_;
	ChessApplication* self;
	gchar* move;
};

struct _Block3Data {
	int _ref_count_;
	ChessApplication* self;
	ChessGame* original_game;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};


static gpointer chess_application_parent_class = NULL;

GType chess_application_get_type (void) G_GNUC_CONST;
GType chess_scene_get_type (void) G_GNUC_CONST;
GType chess_view_get_type (void) G_GNUC_CONST;
GType ai_profile_get_type (void) G_GNUC_CONST;
GType chess_engine_get_type (void) G_GNUC_CONST;
#define CHESS_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_APPLICATION, ChessApplicationPrivate))
static GType chess_application_promotion_type_selected_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
void chess_application_preferences_cb (ChessApplication* self);
static void _chess_application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_help_cb (ChessApplication* self);
static void _chess_application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_about_cb (ChessApplication* self);
static void _chess_application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_quit_cb (ChessApplication* self);
static void _chess_application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
#define CHESS_APPLICATION_NEW_GAME_ACTION_NAME "new"
#define CHESS_APPLICATION_OPEN_GAME_ACTION_NAME "open"
#define CHESS_APPLICATION_SAVE_GAME_ACTION_NAME "save"
#define CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME "save-as"
#define CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME "undo"
#define CHESS_APPLICATION_RESIGN_ACTION_NAME "resign"
#define CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME "pause-resume"
void chess_application_new_game_cb (ChessApplication* self);
static void _chess_application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_open_game_cb (ChessApplication* self);
static void _chess_application_open_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_save_game_cb (ChessApplication* self);
static void _chess_application_save_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_save_game_as_cb (ChessApplication* self);
static void _chess_application_save_game_as_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_undo_move_cb (ChessApplication* self);
static void _chess_application_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_resign_cb (ChessApplication* self);
static void _chess_application_resign_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_pause_resume_cb (ChessApplication* self);
static void _chess_application_pause_resume_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static ChessApplication* chess_application_new (void);
static ChessApplication* chess_application_construct (GType object_type);
static gint chess_application_real_handle_local_options (GApplication* base, GVariantDict* options);
static void chess_application_display_no_engine_info_bar (ChessApplication* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void chess_application_add_info_bar_to_bin (ChessApplication* self, GtkBin* bin, GtkInfoBar* * info_bar, GtkLabel* * label);
static void __lambda10_ (Block1Data* _data1_);
static void ___lambda10__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
static void chess_application_real_startup (GApplication* base);
static void chess_application_size_allocate_cb (ChessApplication* self, GtkAllocation* allocation);
static void _chess_application_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean chess_application_window_state_event_cb (ChessApplication* self, GdkEventWindowState* event);
static gboolean _chess_application_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void chess_application_update_pause_resume_button (ChessApplication* self);
ChessScene* chess_scene_new (void);
ChessScene* chess_scene_construct (GType object_type);
static gboolean __lambda11_ (ChessApplication* self, ChessPlayer* p);
static gboolean ___lambda11__chess_scene_is_human (ChessScene* _sender, ChessPlayer* player, gpointer self);
static void chess_application_scene_changed_cb (ChessApplication* self, ChessScene* scene);
static void _chess_application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self);
PieceType* chess_application_show_promotion_type_selector (ChessApplication* self);
static PieceType* _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender, gpointer self);
ChessView* chess_view_new (void);
ChessView* chess_view_construct (GType object_type);
void chess_view_set_scene (ChessView* self, ChessScene* value);
GList* ai_profile_load_ai_profiles (const gchar* filename);
const gchar* ai_profile_get_name (AIProfile* self);
const gchar* ai_profile_get_path (AIProfile* self);
static void chess_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint);
static void chess_application_real_activate (GApplication* base);
static void chess_application_start_new_game (ChessApplication* self);
static void chess_application_load_game (ChessApplication* self, GFile* file, GError** error);
static void chess_application_real_shutdown (GApplication* base);
void chess_engine_stop (ChessEngine* self, gboolean kill_engine);
const gchar* chess_scene_get_theme_name (ChessScene* self);
static void chess_application_set_piece_image (ChessApplication* self, GtkImage* image, const gchar* filename);
static PieceType* _piece_type_dup (PieceType* self);
void chess_application_quit_game (ChessApplication* self);
static gboolean chess_application_save_duration_cb (ChessApplication* self);
static void chess_application_autosave (ChessApplication* self);
static void chess_application_update_pgn_time_remaining (ChessApplication* self);
static void chess_application_update_history_panel (ChessApplication* self);
gint chess_scene_get_move_number (ChessScene* self);
static void chess_application_set_move_text (ChessApplication* self, GtkTreeIter* iter, ChessMove* move);
static void chess_application_start_game (ChessApplication* self);
static void chess_application_run_invalid_move_dialog (ChessApplication* self, const gchar* error_message);
static void chess_application_game_turn_cb (ChessApplication* self, ChessGame* game, ChessPlayer* player);
static void _chess_application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self);
static void chess_application_game_move_cb (ChessApplication* self, ChessGame* game, ChessMove* move);
static void _chess_application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self);
static void chess_application_game_undo_cb (ChessApplication* self, ChessGame* game);
static void _chess_application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self);
static void chess_application_game_end_cb (ChessApplication* self);
static void _chess_application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self);
static void chess_application_game_clock_tick_cb (ChessApplication* self, ChessClock* clock);
static void _chess_application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self);
void chess_scene_set_game (ChessScene* self, ChessGame* value);
static void chess_application_engine_ready_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self);
static void chess_application_engine_move_cb (ChessApplication* self, ChessEngine* engine, const gchar* move);
static void _chess_application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self);
static void chess_application_engine_resigned_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender, gpointer self);
static void chess_application_engine_stopped_unexpectedly_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly (ChessEngine* _sender, gpointer self);
static void chess_application_engine_error_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_error_cb_chess_engine_error (ChessEngine* _sender, gpointer self);
static void chess_application_engine_claim_draw_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender, gpointer self);
static void chess_application_engine_offer_draw_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender, gpointer self);
static ChessEngine* chess_application_get_engine (ChessApplication* self, const gchar* name, const gchar* difficulty);
gboolean chess_engine_start (ChessEngine* self);
static void chess_application_disable_window_action (ChessApplication* self, const gchar* name);
static void chess_application_enable_window_action (ChessApplication* self, const gchar* name);
void chess_engine_start_game (ChessEngine* self);
static void chess_application_update_action_status (ChessApplication* self);
static void chess_application_update_headerbar_title (ChessApplication* self);
void chess_engine_move (ChessEngine* self);
gchar** ai_profile_get_easy_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
gchar** ai_profile_get_easy_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
gchar** ai_profile_get_easy_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
gchar** ai_profile_get_hard_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup4 (gchar** self, int length);
gchar** ai_profile_get_hard_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup5 (gchar** self, int length);
gchar** ai_profile_get_hard_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup6 (gchar** self, int length);
gchar** ai_profile_get_normal_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup7 (gchar** self, int length);
gchar** ai_profile_get_normal_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup8 (gchar** self, int length);
gchar** ai_profile_get_normal_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup9 (gchar** self, int length);
const gchar* ai_profile_get_protocol (AIProfile* self);
const gchar* ai_profile_get_binary (AIProfile* self);
guint ai_profile_get_delay_seconds (AIProfile* self);
ChessEngineCECP* chess_engine_cecp_new (const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1);
ChessEngineCECP* chess_engine_cecp_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1);
GType chess_engine_cecp_get_type (void) G_GNUC_CONST;
ChessEngineUCI* chess_engine_uci_new (const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
ChessEngineUCI* chess_engine_uci_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
GType chess_engine_uci_get_type (void) G_GNUC_CONST;
gboolean chess_engine_get_ready (ChessEngine* self);
static void chess_application_do_engine_move (ChessApplication* self, const gchar* move);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean ___lambda7_ (Block2Data* _data2_);
static gboolean ____lambda7__gsource_func (gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda8_ (Block3Data* _data3_);
static gboolean ___lambda8__gsource_func (gpointer self);
static void chess_application_check_engine_timeout (ChessApplication* self);
static void chess_application_present_claim_draw_dialog (ChessApplication* self);
const gchar* chess_scene_get_move_format (ChessScene* self);
void chess_scene_set_move_number (ChessScene* self, gint value);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_undo (ChessEngine* self);
gboolean gnome_chess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self);
static gboolean chess_application_prompt_save_game (ChessApplication* self, const gchar* prompt_text);
static void chess_application_present_save_dialog (ChessApplication* self, const gchar* cancel_button_label, const gchar* save_button_label);
GType chess_model_get_type (void) G_GNUC_CONST;
gboolean white_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self);
static void chess_application_draw_time (ChessApplication* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1);
static gchar* chess_application_make_clock_text (ChessApplication* self, ChessClock* clock, Color color);
gboolean black_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self);
static gint chess_application_compute_time_label_width_request (ChessApplication* self, cairo_t* c);
void history_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void history_latest_clicked_cb (GtkWidget* widget, ChessApplication* self);
void history_next_clicked_cb (GtkWidget* widget, ChessApplication* self);
void history_previous_clicked_cb (GtkWidget* widget, ChessApplication* self);
void history_start_clicked_cb (GtkWidget* widget, ChessApplication* self);
static void chess_application_set_combo (ChessApplication* self, GtkComboBox* combo, gint value_index, const gchar* value);
static void chess_application_set_duration (ChessApplication* self, gint duration, gboolean simplify);
static void chess_application_set_clock_type (ChessApplication* self, gint clock_type);
static void chess_application_set_timer_increment (ChessApplication* self, gint timer_increment);
static gchar* chess_application_get_combo (ChessApplication* self, GtkComboBox* combo, gint value_index);
void side_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void opponent_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void difficulty_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void clock_type_changed_cb (GtkComboBox* combo, ChessApplication* self);
void timer_increment_units_changed_cb (GtkWidget* widget, ChessApplication* self);
static gint chess_application_get_duration (ChessApplication* self);
void duration_changed_cb (GtkAdjustment* adjustment, ChessApplication* self);
static void chess_application_save_duration (ChessApplication* self);
void duration_units_changed_cb (GtkWidget* widget, ChessApplication* self);
static gboolean _chess_application_save_duration_cb_gsource_func (gpointer self);
void duration_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void preferences_response_cb (GtkWidget* widget, gint response_id, ChessApplication* self);
gboolean preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self);
void piece_style_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void move_format_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void orientation_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
static void chess_application_about_response_cb (ChessApplication* self, gint response_id);
static void _chess_application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void chess_application_run_invalid_pgn_dialog (ChessApplication* self);
static void chess_application_save_dialog_cb (ChessApplication* self, gint response_id);
static void __lambda6_ (ChessApplication* self);
static void ___lambda6__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void _chess_application_save_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void __lambda9_ (ChessApplication* self);
static void chess_application_open_dialog_cb (ChessApplication* self, gint response_id);
static void ___lambda9__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void _chess_application_open_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
gint chess_application_main (gchar** args, int args_length1);
static void chess_application_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry CHESS_APPLICATION_app_entries[4] = {{"preferences", _chess_application_preferences_cb_gsimple_action_activate_callback}, {"help", _chess_application_help_cb_gsimple_action_activate_callback}, {"about", _chess_application_about_cb_gsimple_action_activate_callback}, {"quit", _chess_application_quit_cb_gsimple_action_activate_callback}};
static const GActionEntry CHESS_APPLICATION_window_entries[7] = {{CHESS_APPLICATION_NEW_GAME_ACTION_NAME, _chess_application_new_game_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_OPEN_GAME_ACTION_NAME, _chess_application_open_game_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_SAVE_GAME_ACTION_NAME, _chess_application_save_game_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME, _chess_application_save_game_as_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME, _chess_application_undo_move_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_RESIGN_ACTION_NAME, _chess_application_resign_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME, _chess_application_pause_resume_cb_gsimple_action_activate_callback}};
static const GOptionEntry CHESS_APPLICATION_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {NULL}};
static const gchar* CHESS_APPLICATION_authors[2] = {"Robert Ancell <robert.ancell@gmail.com>", NULL};
static const gchar* CHESS_APPLICATION_artists[3] = {"Max Froumentin (pieces)", "Jakub Steiner (icon)", NULL};

static GType chess_application_promotion_type_selected_get_type (void) {
	static volatile gsize chess_application_promotion_type_selected_type_id__volatile = 0;
	if (g_once_init_enter (&chess_application_promotion_type_selected_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN", "queen"}, {CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT", "knight"}, {CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK", "rook"}, {CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP", "bishop"}, {0, NULL, NULL}};
		GType chess_application_promotion_type_selected_type_id;
		chess_application_promotion_type_selected_type_id = g_enum_register_static ("ChessApplicationPromotionTypeSelected", values);
		g_once_init_leave (&chess_application_promotion_type_selected_type_id__volatile, chess_application_promotion_type_selected_type_id);
	}
	return chess_application_promotion_type_selected_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static void _chess_application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_preferences_cb ((ChessApplication*) self);
}


static void _chess_application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_help_cb ((ChessApplication*) self);
}


static void _chess_application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_about_cb ((ChessApplication*) self);
}


static void _chess_application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_quit_cb ((ChessApplication*) self);
}


static void _chess_application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_new_game_cb ((ChessApplication*) self);
}


static void _chess_application_open_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_open_game_cb ((ChessApplication*) self);
}


static void _chess_application_save_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_save_game_cb ((ChessApplication*) self);
}


static void _chess_application_save_game_as_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_save_game_as_cb ((ChessApplication*) self);
}


static void _chess_application_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_undo_move_cb ((ChessApplication*) self);
}


static void _chess_application_resign_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_resign_cb ((ChessApplication*) self);
}


static void _chess_application_pause_resume_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	chess_application_pause_resume_cb ((ChessApplication*) self);
}


static ChessApplication* chess_application_construct (GType object_type) {
	ChessApplication * self = NULL;
	self = (ChessApplication*) g_object_new (object_type, "application-id", "org.gnome.chess", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
	g_application_add_main_option_entries ((GApplication*) self, CHESS_APPLICATION_option_entries);
	return self;
}


static ChessApplication* chess_application_new (void) {
	return chess_application_construct (TYPE_CHESS_APPLICATION);
}


static gint chess_application_real_handle_local_options (GApplication* base, GVariantDict* options) {
	ChessApplication * self;
	gint result = 0;
	GVariantDict* _tmp0_;
	gboolean _tmp1_;
	self = (ChessApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		FILE* _tmp2_;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "gnome-chess %s\n", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	result = -1;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ChessApplication* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->no_engine_info_bar);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda10_ (Block1Data* _data1_) {
	ChessApplication* self;
	GtkInfoBar* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->no_engine_info_bar;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


static void ___lambda10__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	__lambda10_ (self);
}


static void chess_application_display_no_engine_info_bar (ChessApplication* self) {
	Block1Data* _data1_;
	GtkLabel* no_engine_error_label = NULL;
	GtkApplicationWindow* _tmp0_;
	GtkInfoBar* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_;
	GtkInfoBar* _tmp4_;
	GtkInfoBar* _tmp5_;
	GtkInfoBar* _tmp6_;
	GtkInfoBar* _tmp7_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->no_engine_info_bar = NULL;
	no_engine_error_label = NULL;
	_tmp0_ = self->priv->window;
	chess_application_add_info_bar_to_bin (self, (GtkBin*) _tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (_data1_->no_engine_info_bar);
	_data1_->no_engine_info_bar = _tmp1_;
	_g_object_unref0 (no_engine_error_label);
	no_engine_error_label = _tmp2_;
	_tmp3_ = no_engine_error_label;
	gtk_label_set_text (_tmp3_, _ ("No chess engine is installed. " "You will not be able to play against the computer."));
	_tmp4_ = _data1_->no_engine_info_bar;
	gtk_info_bar_set_message_type (_tmp4_, GTK_MESSAGE_ERROR);
	_tmp5_ = _data1_->no_engine_info_bar;
	gtk_widget_show ((GtkWidget*) _tmp5_);
	_tmp6_ = _data1_->no_engine_info_bar;
	gtk_info_bar_set_show_close_button (_tmp6_, TRUE);
	_tmp7_ = _data1_->no_engine_info_bar;
	g_signal_connect_data (_tmp7_, "response", (GCallback) ___lambda10__gtk_info_bar_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_g_object_unref0 (no_engine_error_label);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _chess_application_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	chess_application_size_allocate_cb ((ChessApplication*) self, allocation);
}


static gboolean _chess_application_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = chess_application_window_state_event_cb ((ChessApplication*) self, event);
	return result;
}


static gboolean __lambda11_ (ChessApplication* self, ChessPlayer* p) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_;
	ChessPlayer* _tmp1_;
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = p;
	_tmp1_ = self->priv->human_player;
	result = _tmp0_ == _tmp1_;
	return result;
}


static gboolean ___lambda11__chess_scene_is_human (ChessScene* _sender, ChessPlayer* player, gpointer self) {
	gboolean result;
	result = __lambda11_ ((ChessApplication*) self, player);
	return result;
}


static void _chess_application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self) {
	chess_application_scene_changed_cb ((ChessApplication*) self, _sender);
}


static PieceType* _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender, gpointer self) {
	PieceType* result;
	result = chess_application_show_promotion_type_selector ((ChessApplication*) self);
	return result;
}


static void chess_application_real_startup (GApplication* base) {
	ChessApplication * self;
	GSettings* _tmp0_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp1_;
	GtkBuilder* _tmp2_;
	GObject* _tmp3_;
	GtkApplicationWindow* _tmp4_;
	GtkApplicationWindow* _tmp5_;
	GSettings* _tmp6_;
	gint _tmp7_;
	GSettings* _tmp8_;
	gint _tmp9_;
	GSettings* _tmp10_;
	gboolean _tmp11_;
	GtkApplicationWindow* _tmp13_;
	GtkApplicationWindow* _tmp14_;
	GtkBuilder* _tmp15_;
	GObject* _tmp16_;
	GtkButton* _tmp17_;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_;
	GtkWidget* _tmp20_;
	GtkBuilder* _tmp21_;
	GObject* _tmp22_;
	GtkWidget* _tmp23_;
	GtkBuilder* _tmp24_;
	GObject* _tmp25_;
	GtkWidget* _tmp26_;
	GtkBuilder* _tmp27_;
	GObject* _tmp28_;
	GtkWidget* _tmp29_;
	GtkBuilder* _tmp30_;
	GObject* _tmp31_;
	GtkComboBox* _tmp32_;
	GtkBuilder* _tmp33_;
	GObject* _tmp34_;
	GtkWidget* _tmp35_;
	GtkBuilder* _tmp36_;
	GObject* _tmp37_;
	GtkWidget* _tmp38_;
	GtkBuilder* _tmp39_;
	GObject* _tmp40_;
	GtkContainer* _tmp41_;
	GtkBuilder* _tmp42_;
	GObject* _tmp43_;
	GtkHeaderBar* _tmp44_;
	GtkBuilder* _tmp45_;
	GtkApplicationWindow* _tmp46_;
	gchar* _tmp47_;
	gchar** _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gchar* _tmp50_;
	gchar** _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length1;
	gchar* _tmp53_;
	gchar** _tmp54_;
	gchar** _tmp55_;
	gint _tmp55__length1;
	gchar* _tmp56_;
	gchar** _tmp57_;
	gchar** _tmp58_;
	gint _tmp58__length1;
	gchar* _tmp59_;
	gchar** _tmp60_;
	gchar** _tmp61_;
	gint _tmp61__length1;
	gchar* _tmp62_;
	gchar** _tmp63_;
	gchar** _tmp64_;
	gint _tmp64__length1;
	GtkApplicationWindow* _tmp65_;
	ChessScene* _tmp66_;
	ChessScene* _tmp67_;
	ChessScene* _tmp68_;
	ChessScene* _tmp69_;
	GSettings* _tmp70_;
	ChessScene* _tmp71_;
	GSettings* _tmp72_;
	ChessScene* _tmp73_;
	GSettings* _tmp74_;
	ChessScene* _tmp75_;
	GSettings* _tmp76_;
	ChessScene* _tmp77_;
	GSettings* _tmp78_;
	ChessScene* _tmp79_;
	ChessView* _tmp80_;
	ChessView* _tmp81_;
	ChessView* _tmp82_;
	ChessScene* _tmp83_;
	GtkContainer* _tmp84_;
	ChessView* _tmp85_;
	ChessView* _tmp86_;
	gchar* system_engine_cfg = NULL;
	gchar* _tmp87_;
	gchar* user_engine_cfg = NULL;
	const gchar* _tmp88_;
	gchar* _tmp89_;
	const gchar* _tmp90_;
	gboolean _tmp91_;
	GList* _tmp98_;
	GList* _tmp99_;
	self = (ChessApplication*) base;
	G_APPLICATION_CLASS (chess_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = g_settings_new ("org.gnome.chess");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) self, CHESS_APPLICATION_app_entries, G_N_ELEMENTS (CHESS_APPLICATION_app_entries), self);
	_tmp1_ = gtk_builder_new_from_resource ("/org/gnome/chess/ui/gnome-chess.ui");
	builder = _tmp1_;
	_tmp2_ = builder;
	_tmp3_ = gtk_builder_get_object (_tmp2_, "gnome_chess_app");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_application_window_get_type (), GtkApplicationWindow));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp4_;
	_tmp5_ = self->priv->window;
	_tmp6_ = self->priv->settings;
	_tmp7_ = g_settings_get_int (_tmp6_, "width");
	_tmp8_ = self->priv->settings;
	_tmp9_ = g_settings_get_int (_tmp8_, "height");
	gtk_window_set_default_size ((GtkWindow*) _tmp5_, _tmp7_, _tmp9_);
	_tmp10_ = self->priv->settings;
	_tmp11_ = g_settings_get_boolean (_tmp10_, "maximized");
	if (_tmp11_) {
		GtkApplicationWindow* _tmp12_;
		_tmp12_ = self->priv->window;
		gtk_window_maximize ((GtkWindow*) _tmp12_);
	}
	_tmp13_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp13_, "size-allocate", (GCallback) _chess_application_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	_tmp14_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp14_, "window-state-event", (GCallback) _chess_application_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp15_ = builder;
	_tmp16_ = gtk_builder_get_object (_tmp15_, "pause_button");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->pause_resume_button);
	self->priv->pause_resume_button = _tmp17_;
	_tmp18_ = builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "first_move_button");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->first_move_button);
	self->priv->first_move_button = _tmp20_;
	_tmp21_ = builder;
	_tmp22_ = gtk_builder_get_object (_tmp21_, "prev_move_button");
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->prev_move_button);
	self->priv->prev_move_button = _tmp23_;
	_tmp24_ = builder;
	_tmp25_ = gtk_builder_get_object (_tmp24_, "next_move_button");
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->next_move_button);
	self->priv->next_move_button = _tmp26_;
	_tmp27_ = builder;
	_tmp28_ = gtk_builder_get_object (_tmp27_, "last_move_button");
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->last_move_button);
	self->priv->last_move_button = _tmp29_;
	_tmp30_ = builder;
	_tmp31_ = gtk_builder_get_object (_tmp30_, "history_combo");
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->history_combo);
	self->priv->history_combo = _tmp32_;
	_tmp33_ = builder;
	_tmp34_ = gtk_builder_get_object (_tmp33_, "white_time_label");
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->white_time_label);
	self->priv->white_time_label = _tmp35_;
	_tmp36_ = builder;
	_tmp37_ = gtk_builder_get_object (_tmp36_, "black_time_label");
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->black_time_label);
	self->priv->black_time_label = _tmp38_;
	_tmp39_ = builder;
	_tmp40_ = gtk_builder_get_object (_tmp39_, "view_container");
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gtk_container_get_type (), GtkContainer));
	_g_object_unref0 (self->priv->view_container);
	self->priv->view_container = _tmp41_;
	_tmp42_ = builder;
	_tmp43_ = gtk_builder_get_object (_tmp42_, "headerbar");
	_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_header_bar_get_type (), GtkHeaderBar));
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp44_;
	_tmp45_ = builder;
	gtk_builder_connect_signals (_tmp45_, self);
	chess_application_update_pause_resume_button (self);
	_tmp46_ = self->priv->window;
	g_action_map_add_action_entries ((GActionMap*) _tmp46_, CHESS_APPLICATION_window_entries, G_N_ELEMENTS (CHESS_APPLICATION_window_entries), self);
	_tmp47_ = g_strdup ("<Primary>N");
	_tmp48_ = g_new0 (gchar*, 1 + 1);
	_tmp48_[0] = _tmp47_;
	_tmp49_ = _tmp48_;
	_tmp49__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_NEW_GAME_ACTION_NAME, _tmp49_);
	_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_free), NULL);
	_tmp50_ = g_strdup ("<Primary>O");
	_tmp51_ = g_new0 (gchar*, 1 + 1);
	_tmp51_[0] = _tmp50_;
	_tmp52_ = _tmp51_;
	_tmp52__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_OPEN_GAME_ACTION_NAME, _tmp52_);
	_tmp52_ = (_vala_array_free (_tmp52_, _tmp52__length1, (GDestroyNotify) g_free), NULL);
	_tmp53_ = g_strdup ("<Primary>S");
	_tmp54_ = g_new0 (gchar*, 1 + 1);
	_tmp54_[0] = _tmp53_;
	_tmp55_ = _tmp54_;
	_tmp55__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_SAVE_GAME_ACTION_NAME, _tmp55_);
	_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
	_tmp56_ = g_strdup ("<Shift><Primary>S");
	_tmp57_ = g_new0 (gchar*, 1 + 1);
	_tmp57_[0] = _tmp56_;
	_tmp58_ = _tmp57_;
	_tmp58__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME, _tmp58_);
	_tmp58_ = (_vala_array_free (_tmp58_, _tmp58__length1, (GDestroyNotify) g_free), NULL);
	_tmp59_ = g_strdup ("<Primary>Z");
	_tmp60_ = g_new0 (gchar*, 1 + 1);
	_tmp60_[0] = _tmp59_;
	_tmp61_ = _tmp60_;
	_tmp61__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME, _tmp61_);
	_tmp61_ = (_vala_array_free (_tmp61_, _tmp61__length1, (GDestroyNotify) g_free), NULL);
	_tmp62_ = g_strdup ("Pause");
	_tmp63_ = g_new0 (gchar*, 1 + 1);
	_tmp63_[0] = _tmp62_;
	_tmp64_ = _tmp63_;
	_tmp64__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME, _tmp64_);
	_tmp64_ = (_vala_array_free (_tmp64_, _tmp64__length1, (GDestroyNotify) g_free), NULL);
	_tmp65_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp65_);
	_tmp66_ = chess_scene_new ();
	_g_object_unref0 (self->priv->scene);
	self->priv->scene = _tmp66_;
	_tmp67_ = self->priv->scene;
	g_signal_connect_object (_tmp67_, "is-human", (GCallback) ___lambda11__chess_scene_is_human, self, 0);
	_tmp68_ = self->priv->scene;
	g_signal_connect_object (_tmp68_, "changed", (GCallback) _chess_application_scene_changed_cb_chess_scene_changed, self, 0);
	_tmp69_ = self->priv->scene;
	g_signal_connect_object (_tmp69_, "choose-promotion-type", (GCallback) _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type, self, 0);
	_tmp70_ = self->priv->settings;
	_tmp71_ = self->priv->scene;
	g_settings_bind (_tmp70_, "show-move-hints", (GObject*) _tmp71_, "show-move-hints", G_SETTINGS_BIND_GET);
	_tmp72_ = self->priv->settings;
	_tmp73_ = self->priv->scene;
	g_settings_bind (_tmp72_, "show-numbering", (GObject*) _tmp73_, "show-numbering", G_SETTINGS_BIND_GET);
	_tmp74_ = self->priv->settings;
	_tmp75_ = self->priv->scene;
	g_settings_bind (_tmp74_, "piece-theme", (GObject*) _tmp75_, "theme-name", G_SETTINGS_BIND_GET);
	_tmp76_ = self->priv->settings;
	_tmp77_ = self->priv->scene;
	g_settings_bind (_tmp76_, "move-format", (GObject*) _tmp77_, "move-format", G_SETTINGS_BIND_GET);
	_tmp78_ = self->priv->settings;
	_tmp79_ = self->priv->scene;
	g_settings_bind (_tmp78_, "board-side", (GObject*) _tmp79_, "board-side", G_SETTINGS_BIND_GET);
	_tmp80_ = chess_view_new ();
	g_object_ref_sink (_tmp80_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp80_;
	_tmp81_ = self->priv->view;
	gtk_widget_set_size_request ((GtkWidget*) _tmp81_, 400, 400);
	_tmp82_ = self->priv->view;
	_tmp83_ = self->priv->scene;
	chess_view_set_scene (_tmp82_, _tmp83_);
	_tmp84_ = self->priv->view_container;
	_tmp85_ = self->priv->view;
	gtk_container_add (_tmp84_, (GtkWidget*) _tmp85_);
	_tmp86_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp86_);
	_tmp87_ = g_build_filename (SYSCONFDIR, "gnome-chess", "engines.conf", NULL, NULL);
	system_engine_cfg = _tmp87_;
	_tmp88_ = g_get_user_config_dir ();
	_tmp89_ = g_build_filename (_tmp88_, "gnome-chess", "engines.conf", NULL, NULL);
	user_engine_cfg = _tmp89_;
	_tmp90_ = user_engine_cfg;
	_tmp91_ = g_file_test (_tmp90_, G_FILE_TEST_EXISTS);
	if (_tmp91_) {
		const gchar* _tmp92_;
		GList* _tmp93_;
		_tmp92_ = user_engine_cfg;
		_tmp93_ = ai_profile_load_ai_profiles (_tmp92_);
		__g_list_free__g_object_unref0_0 (self->priv->ai_profiles);
		self->priv->ai_profiles = _tmp93_;
	} else {
		const gchar* _tmp94_;
		gboolean _tmp95_;
		_tmp94_ = system_engine_cfg;
		_tmp95_ = g_file_test (_tmp94_, G_FILE_TEST_EXISTS);
		if (_tmp95_) {
			const gchar* _tmp96_;
			GList* _tmp97_;
			_tmp96_ = system_engine_cfg;
			_tmp97_ = ai_profile_load_ai_profiles (_tmp96_);
			__g_list_free__g_object_unref0_0 (self->priv->ai_profiles);
			self->priv->ai_profiles = _tmp97_;
		} else {
			g_warning ("gnome-chess.vala:206: engines.conf not found");
		}
	}
	_tmp98_ = self->priv->ai_profiles;
	if (_tmp98_ == NULL) {
		chess_application_display_no_engine_info_bar (self);
	}
	_tmp99_ = self->priv->ai_profiles;
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
		profile_collection = _tmp99_;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			AIProfile* _tmp100_;
			AIProfile* profile = NULL;
			_tmp100_ = _g_object_ref0 ((AIProfile*) profile_it->data);
			profile = _tmp100_;
			{
				AIProfile* _tmp101_;
				const gchar* _tmp102_;
				const gchar* _tmp103_;
				AIProfile* _tmp104_;
				const gchar* _tmp105_;
				const gchar* _tmp106_;
				_tmp101_ = profile;
				_tmp102_ = ai_profile_get_name (_tmp101_);
				_tmp103_ = _tmp102_;
				_tmp104_ = profile;
				_tmp105_ = ai_profile_get_path (_tmp104_);
				_tmp106_ = _tmp105_;
				g_debug ("gnome-chess.vala:212: Detected AI profile %s in %s", _tmp103_, _tmp106_);
				_g_object_unref0 (profile);
			}
		}
	}
	_g_free0 (user_engine_cfg);
	_g_free0 (system_engine_cfg);
	_g_object_unref0 (builder);
}


static void chess_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint) {
	ChessApplication * self;
	GFile** _tmp0_;
	gint _tmp0__length1;
	GFile** _tmp1_;
	gint _tmp1__length1;
	GFile* _tmp2_;
	GFile* _tmp3_;
	self = (ChessApplication*) base;
	g_return_if_fail (hint != NULL);
	_tmp0_ = files;
	_tmp0__length1 = files_length1;
	if (_tmp0__length1 != 1) {
		g_warning ("gnome-chess.vala:220: %s", _ ("GNOME Chess can only open one PGN at a time."));
	}
	_tmp1_ = files;
	_tmp1__length1 = files_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = _tmp3_;
	g_application_activate ((GApplication*) self);
}


static void chess_application_real_activate (GApplication* base) {
	ChessApplication * self;
	GtkApplicationWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkApplicationWindow* _tmp28_;
	GError * _inner_error_ = NULL;
	self = (ChessApplication*) base;
	_tmp0_ = self->priv->window;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GFile* data_dir = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GFile* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		GFile* _tmp16_;
		GFile* _tmp21_;
		_tmp3_ = g_get_user_data_dir ();
		_tmp4_ = g_build_filename (_tmp3_, "gnome-chess", NULL, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_new_for_path (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		data_dir = _tmp7_;
		_tmp8_ = data_dir;
		_tmp9_ = g_file_get_path (_tmp8_);
		_tmp10_ = _tmp9_;
		g_mkdir_with_parents (_tmp10_, 0755);
		_g_free0 (_tmp10_);
		_tmp11_ = data_dir;
		_tmp12_ = g_file_get_path (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, "/autosave.pgn", NULL);
		_g_free0 (self->priv->autosave_filename);
		self->priv->autosave_filename = _tmp14_;
		_g_free0 (_tmp13_);
		_tmp16_ = self->priv->game_file;
		if (_tmp16_ == NULL) {
			const gchar* _tmp17_;
			gboolean _tmp18_;
			_tmp17_ = self->priv->autosave_filename;
			_tmp18_ = g_file_test (_tmp17_, G_FILE_TEST_EXISTS);
			_tmp15_ = _tmp18_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			const gchar* _tmp19_;
			GFile* _tmp20_;
			_tmp19_ = self->priv->autosave_filename;
			_tmp20_ = g_file_new_for_path (_tmp19_);
			_g_object_unref0 (self->priv->game_file);
			self->priv->game_file = _tmp20_;
		}
		_tmp21_ = self->priv->game_file;
		if (_tmp21_ == NULL) {
			chess_application_start_new_game (self);
		} else {
			{
				GFile* _tmp22_;
				_tmp22_ = self->priv->game_file;
				chess_application_load_game (self, _tmp22_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GFile* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				GError* _tmp26_;
				const gchar* _tmp27_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp23_ = self->priv->game_file;
				_tmp24_ = g_file_get_path (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = e;
				_tmp27_ = _tmp26_->message;
				g_warning ("gnome-chess.vala:252: Failed to load %s: %s\n", _tmp25_, _tmp27_);
				_g_free0 (_tmp25_);
				g_application_quit ((GApplication*) self);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (data_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (data_dir);
	}
	_tmp28_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp28_);
}


static void chess_application_real_shutdown (GApplication* base) {
	ChessApplication * self;
	ChessEngine* _tmp0_;
	GSettings* _tmp2_;
	gint _tmp3_;
	GSettings* _tmp4_;
	gint _tmp5_;
	GSettings* _tmp6_;
	gboolean _tmp7_;
	self = (ChessApplication*) base;
	_tmp0_ = self->priv->opponent_engine;
	if (_tmp0_ != NULL) {
		ChessEngine* _tmp1_;
		_tmp1_ = self->priv->opponent_engine;
		chess_engine_stop (_tmp1_, TRUE);
	}
	G_APPLICATION_CLASS (chess_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_width;
	g_settings_set_int (_tmp2_, "width", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->window_height;
	g_settings_set_int (_tmp4_, "height", _tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp6_, "maximized", _tmp7_);
}


static void chess_application_size_allocate_cb (ChessApplication* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GtkApplicationWindow* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp1_ = self->priv->is_maximized;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->is_tiled;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->window;
	gtk_window_get_size ((GtkWindow*) _tmp3_, &_tmp4_, &_tmp5_);
	self->priv->window_width = _tmp4_;
	self->priv->window_height = _tmp5_;
}


static gboolean chess_application_window_state_event_cb (ChessApplication* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_;
	GdkWindowState _tmp1_;
	GdkEventWindowState* _tmp4_;
	GdkWindowState _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState* _tmp2_;
		GdkWindowState _tmp3_;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp4_ = event;
	_tmp5_ = _tmp4_->changed_mask;
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
		GdkEventWindowState* _tmp6_;
		GdkWindowState _tmp7_;
		_tmp6_ = event;
		_tmp7_ = _tmp6_->new_window_state;
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
	}
	result = FALSE;
	return result;
}


static PieceType* _piece_type_dup (PieceType* self) {
	PieceType* dup;
	dup = g_new0 (PieceType, 1);
	memcpy (dup, self, sizeof (PieceType));
	return dup;
}


static gpointer __piece_type_dup0 (gpointer self) {
	return self ? _piece_type_dup (self) : NULL;
}


PieceType* chess_application_show_promotion_type_selector (ChessApplication* self) {
	PieceType* result = NULL;
	GtkBuilder* promotion_type_selector_builder = NULL;
	GtkBuilder* _tmp0_;
	GtkDialog* promotion_type_selector_dialog = NULL;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	GtkApplicationWindow* _tmp5_;
	gchar* color = NULL;
	ChessGame* _tmp6_;
	ChessPlayer* _tmp7_;
	ChessPlayer* _tmp8_;
	Color _tmp9_;
	gchar* filename = NULL;
	ChessScene* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GtkBuilder* _tmp20_;
	GObject* _tmp21_;
	const gchar* _tmp22_;
	ChessScene* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GtkBuilder* _tmp30_;
	GObject* _tmp31_;
	const gchar* _tmp32_;
	ChessScene* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GtkBuilder* _tmp40_;
	GObject* _tmp41_;
	const gchar* _tmp42_;
	ChessScene* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GtkBuilder* _tmp50_;
	GObject* _tmp51_;
	const gchar* _tmp52_;
	GtkBuilder* _tmp53_;
	PieceType* selection = NULL;
	gint choice = 0;
	GtkDialog* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	GtkDialog* _tmp65_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/chess/ui/promotion-type-selector.ui");
	promotion_type_selector_builder = _tmp0_;
	_tmp1_ = promotion_type_selector_builder;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "dialog_promotion_type_selector");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp2_) : NULL);
	promotion_type_selector_dialog = _tmp3_;
	_tmp4_ = promotion_type_selector_dialog;
	_tmp5_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp4_, (GtkWindow*) _tmp5_);
	_tmp6_ = self->priv->game;
	_tmp7_ = chess_game_get_current_player (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_->color;
	if (_tmp9_ == COLOR_WHITE) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("white");
		_g_free0 (color);
		color = _tmp10_;
	} else {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("black");
		_g_free0 (color);
		color = _tmp11_;
	}
	_tmp12_ = self->priv->scene;
	_tmp13_ = chess_scene_get_theme_name (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = color;
	_tmp16_ = g_strdup_printf ("%sQueen.svg", _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_build_filename (PKGDATADIR, "pieces", _tmp14_, _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	filename = _tmp19_;
	_tmp20_ = promotion_type_selector_builder;
	_tmp21_ = gtk_builder_get_object (_tmp20_, "image_queen");
	_tmp22_ = filename;
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, gtk_image_get_type ()) ? ((GtkImage*) _tmp21_) : NULL, _tmp22_);
	_tmp23_ = self->priv->scene;
	_tmp24_ = chess_scene_get_theme_name (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = color;
	_tmp27_ = g_strdup_printf ("%sKnight.svg", _tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_build_filename (PKGDATADIR, "pieces", _tmp25_, _tmp28_, NULL);
	_g_free0 (filename);
	filename = _tmp29_;
	_g_free0 (_tmp28_);
	_tmp30_ = promotion_type_selector_builder;
	_tmp31_ = gtk_builder_get_object (_tmp30_, "image_knight");
	_tmp32_ = filename;
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, gtk_image_get_type ()) ? ((GtkImage*) _tmp31_) : NULL, _tmp32_);
	_tmp33_ = self->priv->scene;
	_tmp34_ = chess_scene_get_theme_name (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = color;
	_tmp37_ = g_strdup_printf ("%sRook.svg", _tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_build_filename (PKGDATADIR, "pieces", _tmp35_, _tmp38_, NULL);
	_g_free0 (filename);
	filename = _tmp39_;
	_g_free0 (_tmp38_);
	_tmp40_ = promotion_type_selector_builder;
	_tmp41_ = gtk_builder_get_object (_tmp40_, "image_rook");
	_tmp42_ = filename;
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, gtk_image_get_type ()) ? ((GtkImage*) _tmp41_) : NULL, _tmp42_);
	_tmp43_ = self->priv->scene;
	_tmp44_ = chess_scene_get_theme_name (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = color;
	_tmp47_ = g_strdup_printf ("%sBishop.svg", _tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = g_build_filename (PKGDATADIR, "pieces", _tmp45_, _tmp48_, NULL);
	_g_free0 (filename);
	filename = _tmp49_;
	_g_free0 (_tmp48_);
	_tmp50_ = promotion_type_selector_builder;
	_tmp51_ = gtk_builder_get_object (_tmp50_, "image_bishop");
	_tmp52_ = filename;
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, gtk_image_get_type ()) ? ((GtkImage*) _tmp51_) : NULL, _tmp52_);
	_tmp53_ = promotion_type_selector_builder;
	gtk_builder_connect_signals (_tmp53_, self);
	selection = NULL;
	_tmp54_ = promotion_type_selector_dialog;
	_tmp55_ = gtk_dialog_run (_tmp54_);
	choice = _tmp55_;
	_tmp56_ = choice;
	switch (_tmp56_) {
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN:
		{
			PieceType _tmp57_;
			PieceType* _tmp58_;
			_tmp57_ = PIECE_TYPE_QUEEN;
			_tmp58_ = __piece_type_dup0 (&_tmp57_);
			_g_free0 (selection);
			selection = _tmp58_;
			break;
		}
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT:
		{
			PieceType _tmp59_;
			PieceType* _tmp60_;
			_tmp59_ = PIECE_TYPE_KNIGHT;
			_tmp60_ = __piece_type_dup0 (&_tmp59_);
			_g_free0 (selection);
			selection = _tmp60_;
			break;
		}
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK:
		{
			PieceType _tmp61_;
			PieceType* _tmp62_;
			_tmp61_ = PIECE_TYPE_ROOK;
			_tmp62_ = __piece_type_dup0 (&_tmp61_);
			_g_free0 (selection);
			selection = _tmp62_;
			break;
		}
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP:
		{
			PieceType _tmp63_;
			PieceType* _tmp64_;
			_tmp63_ = PIECE_TYPE_BISHOP;
			_tmp64_ = __piece_type_dup0 (&_tmp63_);
			_g_free0 (selection);
			selection = _tmp64_;
			break;
		}
		default:
		break;
	}
	_tmp65_ = promotion_type_selector_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp65_);
	result = selection;
	_g_free0 (filename);
	_g_free0 (color);
	_g_object_unref0 (promotion_type_selector_dialog);
	_g_object_unref0 (promotion_type_selector_builder);
	return result;
}


static void chess_application_set_piece_image (ChessApplication* self, GtkImage* image, const gchar* filename) {
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	g_return_if_fail (filename != NULL);
	_tmp2_ = gtk_icon_size_lookup (GTK_ICON_SIZE_DIALOG, &_tmp0_, &_tmp1_);
	width = _tmp0_;
	height = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	{
		RsvgHandle* h = NULL;
		const gchar* _tmp3_;
		RsvgHandle* _tmp4_;
		cairo_surface_t* s = NULL;
		gint _tmp5_;
		gint _tmp6_;
		cairo_surface_t* _tmp7_;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp8_;
		cairo_t* _tmp9_;
		cairo_matrix_t m = {0};
		gint _tmp10_;
		RsvgHandle* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		RsvgHandle* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		cairo_t* _tmp18_;
		cairo_matrix_t _tmp19_;
		RsvgHandle* _tmp20_;
		cairo_t* _tmp21_;
		GdkPixbuf* p = NULL;
		cairo_surface_t* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		GdkPixbuf* _tmp25_;
		GtkImage* _tmp26_;
		GdkPixbuf* _tmp27_;
		_tmp3_ = filename;
		_tmp4_ = rsvg_handle_new_from_file (_tmp3_, &_inner_error_);
		h = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp5_ = width;
		_tmp6_ = height;
		_tmp7_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp5_, _tmp6_);
		s = _tmp7_;
		_tmp8_ = s;
		_tmp9_ = cairo_create (_tmp8_);
		c = _tmp9_;
		cairo_matrix_init_identity (&m);
		_tmp10_ = width;
		_tmp11_ = h;
		g_object_get (_tmp11_, "width", &_tmp12_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = height;
		_tmp15_ = h;
		g_object_get (_tmp15_, "height", &_tmp16_, NULL);
		_tmp17_ = _tmp16_;
		cairo_matrix_scale (&m, ((gdouble) _tmp10_) / _tmp13_, ((gdouble) _tmp14_) / _tmp17_);
		_tmp18_ = c;
		_tmp19_ = m;
		cairo_set_matrix (_tmp18_, &_tmp19_);
		_tmp20_ = h;
		_tmp21_ = c;
		rsvg_handle_render_cairo (_tmp20_, _tmp21_);
		_tmp22_ = s;
		_tmp23_ = width;
		_tmp24_ = height;
		_tmp25_ = gdk_pixbuf_get_from_surface (_tmp22_, 0, 0, _tmp23_, _tmp24_);
		p = _tmp25_;
		_tmp26_ = image;
		_tmp27_ = p;
		gtk_image_set_from_pixbuf (_tmp26_, _tmp27_);
		_g_object_unref0 (p);
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (s);
		_g_object_unref0 (h);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp28_;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = filename;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_warning ("gnome-chess.vala:362: Failed to load image %s: %s", _tmp28_, _tmp30_);
		_g_error_free0 (e);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void chess_application_quit_game (ChessApplication* self) {
	guint _tmp0_;
	GtkApplicationWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->save_duration_timeout;
	if (_tmp0_ != ((guint) 0)) {
		chess_application_save_duration_cb (self);
	}
	chess_application_autosave (self);
	_tmp1_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
}


static void chess_application_autosave (ChessApplication* self) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_needs_saving;
	if (!_tmp0_) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->autosave_filename;
		g_remove (_tmp1_);
		return;
	}
	{
		GFile* autosave_file = NULL;
		const gchar* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		PGNGame* _tmp7_;
		GFile* _tmp8_;
		_tmp2_ = self->priv->autosave_filename;
		_tmp3_ = g_file_new_for_path (_tmp2_);
		autosave_file = _tmp3_;
		_tmp4_ = autosave_file;
		_tmp5_ = g_file_get_path (_tmp4_);
		_tmp6_ = _tmp5_;
		g_debug ("gnome-chess.vala:396: Writing current game to %s", _tmp6_);
		_g_free0 (_tmp6_);
		chess_application_update_pgn_time_remaining (self);
		_tmp7_ = self->priv->pgn_game;
		_tmp8_ = autosave_file;
		pgn_game_write (_tmp7_, _tmp8_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (autosave_file);
			goto __catch2_g_error;
		}
		_g_object_unref0 (autosave_file);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("gnome-chess.vala:402: Failed to autosave: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void chess_application_update_history_panel (ChessApplication* self) {
	ChessGame* _tmp0_;
	gint move_number = 0;
	ChessScene* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint n_moves = 0;
	ChessGame* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	gint _tmp7_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_;
	GtkWidget* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_;
	GtkWidget* _tmp23_;
	gboolean _tmp24_ = FALSE;
	gint _tmp25_;
	gint _tmp26_;
	GtkWidget* _tmp30_;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gint _tmp33_;
	GtkWidget* _tmp39_;
	GtkComboBox* _tmp40_;
	ChessGame* _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	gint i = 0;
	gint _tmp44_;
	ChessGame* _tmp45_;
	GList* _tmp46_;
	GtkComboBox* _tmp60_;
	gint _tmp61_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->scene;
	_tmp2_ = chess_scene_get_move_number (_tmp1_);
	_tmp3_ = _tmp2_;
	move_number = _tmp3_;
	_tmp4_ = self->priv->game;
	_tmp5_ = chess_game_get_n_moves (_tmp4_);
	_tmp6_ = _tmp5_;
	n_moves = (gint) _tmp6_;
	_tmp7_ = move_number;
	if (_tmp7_ < 0) {
		gint _tmp8_;
		gint _tmp9_;
		_tmp8_ = move_number;
		_tmp9_ = n_moves;
		move_number = _tmp8_ + (1 + _tmp9_);
	}
	_tmp12_ = n_moves;
	if (_tmp12_ > 0) {
		gint _tmp13_;
		_tmp13_ = move_number;
		_tmp11_ = _tmp13_ != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ChessGame* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		_tmp14_ = self->priv->game;
		_tmp15_ = chess_game_get_is_paused (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp10_ = !_tmp16_;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp17_ = self->priv->first_move_button;
	gtk_widget_set_sensitive (_tmp17_, _tmp10_);
	_tmp19_ = move_number;
	if (_tmp19_ > 0) {
		ChessGame* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = self->priv->game;
		_tmp21_ = chess_game_get_is_paused (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp18_ = !_tmp22_;
	} else {
		_tmp18_ = FALSE;
	}
	_tmp23_ = self->priv->prev_move_button;
	gtk_widget_set_sensitive (_tmp23_, _tmp18_);
	_tmp25_ = move_number;
	_tmp26_ = n_moves;
	if (_tmp25_ < _tmp26_) {
		ChessGame* _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
		_tmp27_ = self->priv->game;
		_tmp28_ = chess_game_get_is_paused (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp24_ = !_tmp29_;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp30_ = self->priv->next_move_button;
	gtk_widget_set_sensitive (_tmp30_, _tmp24_);
	_tmp33_ = n_moves;
	if (_tmp33_ > 0) {
		gint _tmp34_;
		gint _tmp35_;
		_tmp34_ = move_number;
		_tmp35_ = n_moves;
		_tmp32_ = _tmp34_ != _tmp35_;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		ChessGame* _tmp36_;
		gboolean _tmp37_;
		gboolean _tmp38_;
		_tmp36_ = self->priv->game;
		_tmp37_ = chess_game_get_is_paused (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp31_ = !_tmp38_;
	} else {
		_tmp31_ = FALSE;
	}
	_tmp39_ = self->priv->last_move_button;
	gtk_widget_set_sensitive (_tmp39_, _tmp31_);
	_tmp40_ = self->priv->history_combo;
	_tmp41_ = self->priv->game;
	_tmp42_ = chess_game_get_is_paused (_tmp41_);
	_tmp43_ = _tmp42_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp40_, !_tmp43_);
	_tmp44_ = n_moves;
	i = _tmp44_;
	_tmp45_ = self->priv->game;
	_tmp46_ = _tmp45_->move_stack;
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
		state_collection = _tmp46_;
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
			ChessState* _tmp47_;
			ChessState* state = NULL;
			_tmp47_ = _g_object_ref0 ((ChessState*) state_it->data);
			state = _tmp47_;
			{
				ChessState* _tmp48_;
				ChessMove* _tmp49_;
				gint _tmp59_;
				_tmp48_ = state;
				_tmp49_ = _tmp48_->last_move;
				if (_tmp49_ != NULL) {
					GtkTreeIter iter = {0};
					GtkComboBox* _tmp50_;
					GtkTreeModel* _tmp51_;
					GtkTreeModel* _tmp52_;
					gint _tmp53_;
					GtkTreeIter _tmp54_ = {0};
					gboolean _tmp55_;
					_tmp50_ = self->priv->history_combo;
					_tmp51_ = gtk_combo_box_get_model (_tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = i;
					_tmp55_ = gtk_tree_model_iter_nth_child (_tmp52_, &_tmp54_, NULL, _tmp53_);
					iter = _tmp54_;
					if (_tmp55_) {
						GtkTreeIter _tmp56_;
						ChessState* _tmp57_;
						ChessMove* _tmp58_;
						_tmp56_ = iter;
						_tmp57_ = state;
						_tmp58_ = _tmp57_->last_move;
						chess_application_set_move_text (self, &_tmp56_, _tmp58_);
					}
				}
				_tmp59_ = i;
				i = _tmp59_ - 1;
				_g_object_unref0 (state);
			}
		}
	}
	_tmp60_ = self->priv->history_combo;
	_tmp61_ = move_number;
	gtk_combo_box_set_active (_tmp60_, _tmp61_);
}


static void chess_application_scene_changed_cb (ChessApplication* self, ChessScene* scene) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (scene != NULL);
	chess_application_update_history_panel (self);
}


static void _chess_application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self) {
	chess_application_game_turn_cb ((ChessApplication*) self, _sender, player);
}


static void _chess_application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self) {
	chess_application_game_move_cb ((ChessApplication*) self, _sender, move);
}


static void _chess_application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self) {
	chess_application_game_undo_cb ((ChessApplication*) self, _sender);
}


static void _chess_application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self) {
	chess_application_game_end_cb ((ChessApplication*) self);
}


static void _chess_application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self) {
	chess_application_game_clock_tick_cb ((ChessApplication*) self, _sender);
}


static void _chess_application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self) {
	chess_application_engine_ready_cb ((ChessApplication*) self, _sender);
}


static void _chess_application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self) {
	chess_application_engine_move_cb ((ChessApplication*) self, _sender, move);
}


static void _chess_application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender, gpointer self) {
	chess_application_engine_resigned_cb ((ChessApplication*) self, _sender);
}


static void _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly (ChessEngine* _sender, gpointer self) {
	chess_application_engine_stopped_unexpectedly_cb ((ChessApplication*) self, _sender);
}


static void _chess_application_engine_error_cb_chess_engine_error (ChessEngine* _sender, gpointer self) {
	chess_application_engine_error_cb ((ChessApplication*) self, _sender);
}


static void _chess_application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender, gpointer self) {
	chess_application_engine_claim_draw_cb ((ChessApplication*) self, _sender);
}


static void _chess_application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender, gpointer self) {
	chess_application_engine_offer_draw_cb ((ChessApplication*) self, _sender);
}


static void chess_application_start_game (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp11_;
	GtkTreeModel* _tmp12_;
	GtkTreeModel* _tmp13_;
	GtkListStore* _tmp14_;
	GtkListStore* _tmp15_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp16_;
	GtkTreeIter _tmp17_ = {0};
	GtkListStore* _tmp18_;
	GtkTreeIter _tmp19_;
	GtkComboBox* _tmp20_;
	GtkTreeIter _tmp21_;
	gchar* fen = NULL;
	gchar* _tmp22_;
	gchar** moves = NULL;
	PGNGame* _tmp23_;
	GList* _tmp24_;
	guint _tmp25_;
	gchar** _tmp26_;
	gint moves_length1;
	gint _moves_size_;
	gint i = 0;
	PGNGame* _tmp27_;
	GList* _tmp28_;
	PGNGame* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp52_ = FALSE;
	PGNGame* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	ChessGame* _tmp83_;
	ChessGame* _tmp84_;
	ChessGame* _tmp85_;
	ChessGame* _tmp86_;
	ChessGame* _tmp87_;
	ChessClock* _tmp88_;
	ChessClock* _tmp89_;
	ChessScene* _tmp93_;
	ChessGame* _tmp94_;
	gchar* white_engine = NULL;
	PGNGame* _tmp95_;
	const gchar* _tmp96_;
	const gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* white_level = NULL;
	PGNGame* _tmp99_;
	const gchar* _tmp100_;
	const gchar* _tmp101_;
	gchar* _tmp102_;
	const gchar* _tmp103_;
	gchar* black_engine = NULL;
	PGNGame* _tmp105_;
	const gchar* _tmp106_;
	const gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* black_level = NULL;
	PGNGame* _tmp109_;
	const gchar* _tmp110_;
	const gchar* _tmp111_;
	gchar* _tmp112_;
	const gchar* _tmp113_;
	ChessEngine* _tmp115_;
	const gchar* _tmp131_;
	ChessEngine* _tmp159_;
	gboolean _tmp191_ = FALSE;
	GFile* _tmp192_;
	ChessGame* _tmp197_;
	gint timer_increment_adj_value = 0;
	PGNGame* _tmp198_;
	const gchar* _tmp199_;
	const gchar* _tmp200_;
	ClockType clock_type = 0;
	PGNGame* _tmp211_;
	const gchar* _tmp212_;
	const gchar* _tmp213_;
	ChessGame* _tmp226_;
	ChessClock* _tmp227_;
	ChessClock* _tmp228_;
	PGNGame* _tmp237_;
	const gchar* _tmp238_;
	const gchar* _tmp239_;
	const gchar* _tmp240_;
	ChessEngine* _tmp252_;
	gboolean _tmp254_ = FALSE;
	gchar** _tmp255_;
	gint _tmp255__length1;
	GtkWidget* _tmp262_;
	GtkWidget* _tmp263_;
	gboolean _tmp264_ = FALSE;
	gboolean _tmp265_ = FALSE;
	const gchar* _tmp266_;
	ChessGame* _tmp279_;
	ChessResult _tmp280_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->starting = TRUE;
	_tmp1_ = self->priv->game_file;
	if (_tmp1_ != NULL) {
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp2_ = self->priv->game_file;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->autosave_filename;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) != 0;
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkHeaderBar* _tmp6_;
		GFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = self->priv->headerbar;
		_tmp7_ = self->priv->game_file;
		_tmp8_ = g_file_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_header_bar_set_subtitle (_tmp6_, _tmp9_);
		_g_free0 (_tmp9_);
	} else {
		GtkHeaderBar* _tmp10_;
		_tmp10_ = self->priv->headerbar;
		gtk_header_bar_set_subtitle (_tmp10_, NULL);
	}
	_tmp11_ = self->priv->history_combo;
	_tmp12_ = gtk_combo_box_get_model (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp14_;
	_tmp15_ = model;
	gtk_list_store_clear (_tmp15_);
	_tmp16_ = model;
	gtk_list_store_append (_tmp16_, &_tmp17_);
	iter = _tmp17_;
	_tmp18_ = model;
	_tmp19_ = iter;
	gtk_list_store_set (_tmp18_, &_tmp19_, 0, _ ("Game Start"), 1, 0, -1, -1);
	_tmp20_ = self->priv->history_combo;
	_tmp21_ = iter;
	gtk_combo_box_set_active_iter (_tmp20_, &_tmp21_);
	_tmp22_ = g_strdup (CHESS_GAME_STANDARD_SETUP);
	fen = _tmp22_;
	_tmp23_ = self->priv->pgn_game;
	_tmp24_ = _tmp23_->moves;
	_tmp25_ = g_list_length (_tmp24_);
	_tmp26_ = g_new0 (gchar*, _tmp25_ + 1);
	moves = _tmp26_;
	moves_length1 = _tmp25_;
	_moves_size_ = moves_length1;
	i = 0;
	_tmp27_ = self->priv->pgn_game;
	_tmp28_ = _tmp27_->moves;
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
		move_collection = _tmp28_;
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
			gchar* _tmp29_;
			gchar* move = NULL;
			_tmp29_ = g_strdup ((const gchar*) move_it->data);
			move = _tmp29_;
			{
				gchar** _tmp30_;
				gint _tmp30__length1;
				gint _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				_tmp30_ = moves;
				_tmp30__length1 = moves_length1;
				_tmp31_ = i;
				i = _tmp31_ + 1;
				_tmp32_ = move;
				_tmp33_ = g_strdup (_tmp32_);
				_g_free0 (_tmp30_[_tmp31_]);
				_tmp30_[_tmp31_] = _tmp33_;
				_tmp34_ = _tmp30_[_tmp31_];
				_g_free0 (move);
			}
		}
	}
	_tmp35_ = self->priv->pgn_game;
	_tmp36_ = pgn_game_get_set_up (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		PGNGame* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		_tmp38_ = self->priv->pgn_game;
		_tmp39_ = pgn_game_get_fen (_tmp38_);
		_tmp40_ = _tmp39_;
		if (_tmp40_ != NULL) {
			PGNGame* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp41_ = self->priv->pgn_game;
			_tmp42_ = pgn_game_get_fen (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strdup (_tmp43_);
			_g_free0 (fen);
			fen = _tmp44_;
		} else {
			g_warning ("gnome-chess.vala:472: Chess game has SetUp tag but no FEN tag");
		}
	}
	{
		ChessGame* _tmp45_ = NULL;
		const gchar* _tmp46_;
		gchar** _tmp47_;
		gint _tmp47__length1;
		ChessGame* _tmp48_;
		ChessGame* _tmp49_;
		_tmp46_ = fen;
		_tmp47_ = moves;
		_tmp47__length1 = moves_length1;
		_tmp48_ = chess_game_new (_tmp46_, _tmp47_, _tmp47__length1, &_inner_error_);
		_tmp45_ = _tmp48_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp49_ = _tmp45_;
		_tmp45_ = NULL;
		_g_object_unref0 (self->priv->game);
		self->priv->game = _tmp49_;
		_g_object_unref0 (_tmp45_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp50_;
		const gchar* _tmp51_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp50_ = e;
		_tmp51_ = _tmp50_->message;
		chess_application_run_invalid_move_dialog (self, _tmp51_);
		chess_application_start_new_game (self);
		_g_error_free0 (e);
		moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (fen);
		_g_object_unref0 (model);
		return;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (fen);
		_g_object_unref0 (model);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp53_ = self->priv->pgn_game;
	_tmp54_ = pgn_game_get_time_control (_tmp53_);
	_tmp55_ = _tmp54_;
	if (_tmp55_ != NULL) {
		PGNGame* _tmp56_;
		const gchar* _tmp57_;
		const gchar* _tmp58_;
		gint _tmp59_;
		_tmp56_ = self->priv->pgn_game;
		_tmp57_ = pgn_game_get_time_control (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = atoi (_tmp58_);
		_tmp52_ = _tmp59_ != 0;
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		gboolean _tmp60_ = FALSE;
		PGNGame* _tmp61_;
		const gchar* _tmp62_;
		const gchar* _tmp63_;
		_tmp61_ = self->priv->pgn_game;
		_tmp62_ = pgn_game_get_white_time_left (_tmp61_);
		_tmp63_ = _tmp62_;
		if (_tmp63_ != NULL) {
			PGNGame* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			_tmp64_ = self->priv->pgn_game;
			_tmp65_ = pgn_game_get_black_time_left (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp60_ = _tmp66_ != NULL;
		} else {
			_tmp60_ = FALSE;
		}
		if (_tmp60_) {
			gint white_seconds = 0;
			PGNGame* _tmp67_;
			const gchar* _tmp68_;
			const gchar* _tmp69_;
			gint _tmp70_;
			gint black_seconds = 0;
			PGNGame* _tmp71_;
			const gchar* _tmp72_;
			const gchar* _tmp73_;
			gint _tmp74_;
			gboolean _tmp75_ = FALSE;
			gint _tmp76_;
			_tmp67_ = self->priv->pgn_game;
			_tmp68_ = pgn_game_get_white_time_left (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = atoi (_tmp69_);
			white_seconds = _tmp70_;
			_tmp71_ = self->priv->pgn_game;
			_tmp72_ = pgn_game_get_black_time_left (_tmp71_);
			_tmp73_ = _tmp72_;
			_tmp74_ = atoi (_tmp73_);
			black_seconds = _tmp74_;
			_tmp76_ = white_seconds;
			if (_tmp76_ >= 0) {
				gint _tmp77_;
				_tmp77_ = black_seconds;
				_tmp75_ = _tmp77_ >= 0;
			} else {
				_tmp75_ = FALSE;
			}
			if (_tmp75_) {
				ChessGame* _tmp78_;
				gint _tmp79_;
				gint _tmp80_;
				ChessClock* _tmp81_;
				ChessClock* _tmp82_;
				_tmp78_ = self->priv->game;
				_tmp79_ = white_seconds;
				_tmp80_ = black_seconds;
				_tmp81_ = chess_clock_new (_tmp79_, _tmp80_);
				_tmp82_ = _tmp81_;
				chess_game_set_clock (_tmp78_, _tmp82_);
				_g_object_unref0 (_tmp82_);
			}
		}
	}
	_tmp83_ = self->priv->game;
	g_signal_connect_object (_tmp83_, "turn-started", (GCallback) _chess_application_game_turn_cb_chess_game_turn_started, self, 0);
	_tmp84_ = self->priv->game;
	g_signal_connect_object (_tmp84_, "moved", (GCallback) _chess_application_game_move_cb_chess_game_moved, self, 0);
	_tmp85_ = self->priv->game;
	g_signal_connect_object (_tmp85_, "undo", (GCallback) _chess_application_game_undo_cb_chess_game_undo, self, 0);
	_tmp86_ = self->priv->game;
	g_signal_connect_object (_tmp86_, "ended", (GCallback) _chess_application_game_end_cb_chess_game_ended, self, 0);
	_tmp87_ = self->priv->game;
	_tmp88_ = chess_game_get_clock (_tmp87_);
	_tmp89_ = _tmp88_;
	if (_tmp89_ != NULL) {
		ChessGame* _tmp90_;
		ChessClock* _tmp91_;
		ChessClock* _tmp92_;
		_tmp90_ = self->priv->game;
		_tmp91_ = chess_game_get_clock (_tmp90_);
		_tmp92_ = _tmp91_;
		g_signal_connect_object (_tmp92_, "tick", (GCallback) _chess_application_game_clock_tick_cb_chess_clock_tick, self, 0);
	}
	_tmp93_ = self->priv->scene;
	_tmp94_ = self->priv->game;
	chess_scene_set_game (_tmp93_, _tmp94_);
	_tmp95_ = self->priv->pgn_game;
	_tmp96_ = pgn_game_get_white_ai (_tmp95_);
	_tmp97_ = _tmp96_;
	_tmp98_ = g_strdup (_tmp97_);
	white_engine = _tmp98_;
	_tmp99_ = self->priv->pgn_game;
	_tmp100_ = pgn_game_get_white_level (_tmp99_);
	_tmp101_ = _tmp100_;
	_tmp102_ = g_strdup (_tmp101_);
	white_level = _tmp102_;
	_tmp103_ = white_level;
	if (_tmp103_ == NULL) {
		gchar* _tmp104_;
		_tmp104_ = g_strdup ("normal");
		_g_free0 (white_level);
		white_level = _tmp104_;
	}
	_tmp105_ = self->priv->pgn_game;
	_tmp106_ = pgn_game_get_black_ai (_tmp105_);
	_tmp107_ = _tmp106_;
	_tmp108_ = g_strdup (_tmp107_);
	black_engine = _tmp108_;
	_tmp109_ = self->priv->pgn_game;
	_tmp110_ = pgn_game_get_black_level (_tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = g_strdup (_tmp111_);
	black_level = _tmp112_;
	_tmp113_ = black_level;
	if (_tmp113_ == NULL) {
		gchar* _tmp114_;
		_tmp114_ = g_strdup ("normal");
		_g_free0 (black_level);
		black_level = _tmp114_;
	}
	_g_object_unref0 (self->priv->human_player);
	self->priv->human_player = NULL;
	_g_object_unref0 (self->priv->opponent);
	self->priv->opponent = NULL;
	_tmp115_ = self->priv->opponent_engine;
	if (_tmp115_ != NULL) {
		ChessEngine* _tmp116_;
		ChessEngine* _tmp117_;
		guint _tmp118_;
		ChessEngine* _tmp119_;
		guint _tmp120_;
		ChessEngine* _tmp121_;
		guint _tmp122_;
		ChessEngine* _tmp123_;
		guint _tmp124_;
		ChessEngine* _tmp125_;
		guint _tmp126_;
		ChessEngine* _tmp127_;
		guint _tmp128_;
		ChessEngine* _tmp129_;
		guint _tmp130_;
		_tmp116_ = self->priv->opponent_engine;
		chess_engine_stop (_tmp116_, TRUE);
		_tmp117_ = self->priv->opponent_engine;
		g_signal_parse_name ("ready-changed", TYPE_CHESS_ENGINE, &_tmp118_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp117_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp118_, 0, NULL, (GCallback) _chess_application_engine_ready_cb_chess_engine_ready_changed, self);
		_tmp119_ = self->priv->opponent_engine;
		g_signal_parse_name ("moved", TYPE_CHESS_ENGINE, &_tmp120_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp119_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp120_, 0, NULL, (GCallback) _chess_application_engine_move_cb_chess_engine_moved, self);
		_tmp121_ = self->priv->opponent_engine;
		g_signal_parse_name ("resigned", TYPE_CHESS_ENGINE, &_tmp122_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp121_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp122_, 0, NULL, (GCallback) _chess_application_engine_resigned_cb_chess_engine_resigned, self);
		_tmp123_ = self->priv->opponent_engine;
		g_signal_parse_name ("stopped-unexpectedly", TYPE_CHESS_ENGINE, &_tmp124_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp123_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp124_, 0, NULL, (GCallback) _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly, self);
		_tmp125_ = self->priv->opponent_engine;
		g_signal_parse_name ("error", TYPE_CHESS_ENGINE, &_tmp126_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp125_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp126_, 0, NULL, (GCallback) _chess_application_engine_error_cb_chess_engine_error, self);
		_tmp127_ = self->priv->opponent_engine;
		g_signal_parse_name ("claim-draw", TYPE_CHESS_ENGINE, &_tmp128_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp127_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp128_, 0, NULL, (GCallback) _chess_application_engine_claim_draw_cb_chess_engine_claim_draw, self);
		_tmp129_ = self->priv->opponent_engine;
		g_signal_parse_name ("offer-draw", TYPE_CHESS_ENGINE, &_tmp130_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp129_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp130_, 0, NULL, (GCallback) _chess_application_engine_offer_draw_cb_chess_engine_offer_draw, self);
		_g_object_unref0 (self->priv->opponent_engine);
		self->priv->opponent_engine = NULL;
	}
	_tmp131_ = white_engine;
	if (_tmp131_ != NULL) {
		ChessGame* _tmp132_;
		ChessPlayer* _tmp133_;
		ChessPlayer* _tmp134_;
		ChessPlayer* _tmp135_;
		ChessGame* _tmp136_;
		ChessPlayer* _tmp137_;
		ChessPlayer* _tmp138_;
		ChessPlayer* _tmp139_;
		const gchar* _tmp140_;
		const gchar* _tmp141_;
		ChessEngine* _tmp142_;
		ChessPlayer* _tmp143_;
		ChessPlayer* _tmp144_;
		_tmp132_ = self->priv->game;
		_tmp133_ = chess_game_get_white (_tmp132_);
		_tmp134_ = _tmp133_;
		_tmp135_ = _g_object_ref0 (_tmp134_);
		_g_object_unref0 (self->priv->opponent);
		self->priv->opponent = _tmp135_;
		_tmp136_ = self->priv->game;
		_tmp137_ = chess_game_get_black (_tmp136_);
		_tmp138_ = _tmp137_;
		_tmp139_ = _g_object_ref0 (_tmp138_);
		_g_object_unref0 (self->priv->human_player);
		self->priv->human_player = _tmp139_;
		_tmp140_ = white_engine;
		_tmp141_ = white_level;
		_tmp142_ = chess_application_get_engine (self, _tmp140_, _tmp141_);
		_g_object_unref0 (self->priv->opponent_engine);
		self->priv->opponent_engine = _tmp142_;
		_tmp143_ = self->priv->opponent;
		chess_player_set_local_human (_tmp143_, FALSE);
		_tmp144_ = self->priv->human_player;
		chess_player_set_local_human (_tmp144_, TRUE);
	} else {
		const gchar* _tmp145_;
		_tmp145_ = black_engine;
		if (_tmp145_ != NULL) {
			ChessGame* _tmp146_;
			ChessPlayer* _tmp147_;
			ChessPlayer* _tmp148_;
			ChessPlayer* _tmp149_;
			ChessGame* _tmp150_;
			ChessPlayer* _tmp151_;
			ChessPlayer* _tmp152_;
			ChessPlayer* _tmp153_;
			const gchar* _tmp154_;
			const gchar* _tmp155_;
			ChessEngine* _tmp156_;
			ChessPlayer* _tmp157_;
			ChessPlayer* _tmp158_;
			_tmp146_ = self->priv->game;
			_tmp147_ = chess_game_get_black (_tmp146_);
			_tmp148_ = _tmp147_;
			_tmp149_ = _g_object_ref0 (_tmp148_);
			_g_object_unref0 (self->priv->opponent);
			self->priv->opponent = _tmp149_;
			_tmp150_ = self->priv->game;
			_tmp151_ = chess_game_get_white (_tmp150_);
			_tmp152_ = _tmp151_;
			_tmp153_ = _g_object_ref0 (_tmp152_);
			_g_object_unref0 (self->priv->human_player);
			self->priv->human_player = _tmp153_;
			_tmp154_ = black_engine;
			_tmp155_ = black_level;
			_tmp156_ = chess_application_get_engine (self, _tmp154_, _tmp155_);
			_g_object_unref0 (self->priv->opponent_engine);
			self->priv->opponent_engine = _tmp156_;
			_tmp157_ = self->priv->opponent;
			chess_player_set_local_human (_tmp157_, FALSE);
			_tmp158_ = self->priv->human_player;
			chess_player_set_local_human (_tmp158_, TRUE);
		}
	}
	_tmp159_ = self->priv->opponent_engine;
	if (_tmp159_ == NULL) {
		ChessGame* _tmp160_;
		ChessPlayer* _tmp161_;
		ChessPlayer* _tmp162_;
		ChessGame* _tmp163_;
		ChessPlayer* _tmp164_;
		ChessPlayer* _tmp165_;
		_tmp160_ = self->priv->game;
		_tmp161_ = chess_game_get_black (_tmp160_);
		_tmp162_ = _tmp161_;
		chess_player_set_local_human (_tmp162_, TRUE);
		_tmp163_ = self->priv->game;
		_tmp164_ = chess_game_get_white (_tmp163_);
		_tmp165_ = _tmp164_;
		chess_player_set_local_human (_tmp165_, TRUE);
		_g_object_unref0 (self->priv->human_player);
		self->priv->human_player = NULL;
	} else {
		ChessEngine* _tmp166_;
		ChessEngine* _tmp167_;
		ChessEngine* _tmp168_;
		ChessEngine* _tmp169_;
		ChessEngine* _tmp170_;
		ChessEngine* _tmp171_;
		ChessEngine* _tmp172_;
		ChessEngine* _tmp173_;
		gboolean _tmp174_;
		_tmp166_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp166_, "ready-changed", (GCallback) _chess_application_engine_ready_cb_chess_engine_ready_changed, self, 0);
		_tmp167_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp167_, "moved", (GCallback) _chess_application_engine_move_cb_chess_engine_moved, self, 0);
		_tmp168_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp168_, "resigned", (GCallback) _chess_application_engine_resigned_cb_chess_engine_resigned, self, 0);
		_tmp169_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp169_, "stopped-unexpectedly", (GCallback) _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly, self, 0);
		_tmp170_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp170_, "error", (GCallback) _chess_application_engine_error_cb_chess_engine_error, self, 0);
		_tmp171_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp171_, "claim-draw", (GCallback) _chess_application_engine_claim_draw_cb_chess_engine_claim_draw, self, 0);
		_tmp172_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp172_, "offer-draw", (GCallback) _chess_application_engine_offer_draw_cb_chess_engine_offer_draw, self, 0);
		_tmp173_ = self->priv->opponent_engine;
		_tmp174_ = chess_engine_start (_tmp173_);
		if (!_tmp174_) {
			ChessGame* _tmp175_;
			ChessGame* _tmp176_;
			chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
			_tmp175_ = self->priv->game;
			_tmp175_->result = CHESS_RESULT_BUG;
			_tmp176_ = self->priv->game;
			_tmp176_->rule = CHESS_RULE_BUG;
			chess_application_game_end_cb (self);
			_g_free0 (black_level);
			_g_free0 (black_engine);
			_g_free0 (white_level);
			_g_free0 (white_engine);
			moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (fen);
			_g_object_unref0 (model);
			return;
		}
	}
	{
		gint j = 0;
		ChessGame* _tmp177_;
		GList* _tmp178_;
		guint _tmp179_;
		_tmp177_ = self->priv->game;
		_tmp178_ = _tmp177_->move_stack;
		_tmp179_ = g_list_length (_tmp178_);
		j = ((gint) _tmp179_) - 2;
		{
			gboolean _tmp180_ = FALSE;
			_tmp180_ = TRUE;
			while (TRUE) {
				gint _tmp182_;
				ChessState* state = NULL;
				ChessGame* _tmp183_;
				GList* _tmp184_;
				gint _tmp185_;
				gconstpointer _tmp186_;
				ChessState* _tmp187_;
				ChessGame* _tmp188_;
				ChessState* _tmp189_;
				ChessMove* _tmp190_;
				if (!_tmp180_) {
					gint _tmp181_;
					_tmp181_ = j;
					j = _tmp181_ - 1;
				}
				_tmp180_ = FALSE;
				_tmp182_ = j;
				if (!(_tmp182_ >= 0)) {
					break;
				}
				_tmp183_ = self->priv->game;
				_tmp184_ = _tmp183_->move_stack;
				_tmp185_ = j;
				_tmp186_ = g_list_nth_data (_tmp184_, (guint) _tmp185_);
				_tmp187_ = _g_object_ref0 ((ChessState*) _tmp186_);
				state = _tmp187_;
				_tmp188_ = self->priv->game;
				_tmp189_ = state;
				_tmp190_ = _tmp189_->last_move;
				chess_application_game_move_cb (self, _tmp188_, _tmp190_);
				_g_object_unref0 (state);
			}
		}
	}
	_tmp192_ = self->priv->game_file;
	if (_tmp192_ != NULL) {
		GFile* _tmp193_;
		gchar* _tmp194_;
		gchar* _tmp195_;
		const gchar* _tmp196_;
		_tmp193_ = self->priv->game_file;
		_tmp194_ = g_file_get_path (_tmp193_);
		_tmp195_ = _tmp194_;
		_tmp196_ = self->priv->autosave_filename;
		_tmp191_ = g_strcmp0 (_tmp195_, _tmp196_) == 0;
		_g_free0 (_tmp195_);
	} else {
		_tmp191_ = FALSE;
	}
	if (_tmp191_) {
		self->priv->game_needs_saving = TRUE;
		chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
	} else {
		self->priv->game_needs_saving = FALSE;
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
	}
	_tmp197_ = self->priv->game;
	chess_game_start (_tmp197_);
	timer_increment_adj_value = 0;
	_tmp198_ = self->priv->pgn_game;
	_tmp199_ = pgn_game_get_timer_increment (_tmp198_);
	_tmp200_ = _tmp199_;
	if (_tmp200_ != NULL) {
		PGNGame* _tmp201_;
		const gchar* _tmp202_;
		const gchar* _tmp203_;
		gint _tmp204_;
		_tmp201_ = self->priv->pgn_game;
		_tmp202_ = pgn_game_get_timer_increment (_tmp201_);
		_tmp203_ = _tmp202_;
		_tmp204_ = atoi (_tmp203_);
		timer_increment_adj_value = _tmp204_;
	} else {
		GSettings* _tmp205_;
		gint _tmp206_;
		PGNGame* _tmp207_;
		gint _tmp208_;
		gchar* _tmp209_;
		gchar* _tmp210_;
		_tmp205_ = self->priv->settings;
		_tmp206_ = g_settings_get_int (_tmp205_, "timer-increment");
		timer_increment_adj_value = _tmp206_;
		_tmp207_ = self->priv->pgn_game;
		_tmp208_ = timer_increment_adj_value;
		_tmp209_ = g_strdup_printf ("%i", _tmp208_);
		_tmp210_ = _tmp209_;
		pgn_game_set_timer_increment (_tmp207_, _tmp210_);
		_g_free0 (_tmp210_);
	}
	clock_type = CLOCK_TYPE_SIMPLE;
	_tmp211_ = self->priv->pgn_game;
	_tmp212_ = pgn_game_get_clock_type (_tmp211_);
	_tmp213_ = _tmp212_;
	if (_tmp213_ != NULL) {
		PGNGame* _tmp214_;
		const gchar* _tmp215_;
		const gchar* _tmp216_;
		ClockType _tmp217_;
		_tmp214_ = self->priv->pgn_game;
		_tmp215_ = pgn_game_get_clock_type (_tmp214_);
		_tmp216_ = _tmp215_;
		_tmp217_ = clock_type_string_to_enum (_tmp216_);
		clock_type = _tmp217_;
	} else {
		GSettings* _tmp218_;
		gchar* _tmp219_;
		gchar* _tmp220_;
		ClockType _tmp221_;
		PGNGame* _tmp222_;
		ClockType _tmp223_;
		gchar* _tmp224_;
		gchar* _tmp225_;
		_tmp218_ = self->priv->settings;
		_tmp219_ = g_settings_get_string (_tmp218_, "clock-type");
		_tmp220_ = _tmp219_;
		_tmp221_ = clock_type_string_to_enum (_tmp220_);
		clock_type = _tmp221_;
		_g_free0 (_tmp220_);
		_tmp222_ = self->priv->pgn_game;
		_tmp223_ = clock_type;
		_tmp224_ = clock_type_to_string (_tmp223_);
		_tmp225_ = _tmp224_;
		pgn_game_set_clock_type (_tmp222_, _tmp225_);
		_g_free0 (_tmp225_);
	}
	_tmp226_ = self->priv->game;
	_tmp227_ = chess_game_get_clock (_tmp226_);
	_tmp228_ = _tmp227_;
	if (_tmp228_ != NULL) {
		ChessGame* _tmp229_;
		ChessClock* _tmp230_;
		ChessClock* _tmp231_;
		gint _tmp232_;
		ChessGame* _tmp233_;
		ChessClock* _tmp234_;
		ChessClock* _tmp235_;
		ClockType _tmp236_;
		_tmp229_ = self->priv->game;
		_tmp230_ = chess_game_get_clock (_tmp229_);
		_tmp231_ = _tmp230_;
		_tmp232_ = timer_increment_adj_value;
		chess_clock_set_extra_seconds (_tmp231_, (gint) _tmp232_);
		_tmp233_ = self->priv->game;
		_tmp234_ = chess_game_get_clock (_tmp233_);
		_tmp235_ = _tmp234_;
		_tmp236_ = clock_type;
		chess_clock_set_clock_type (_tmp235_, _tmp236_);
	}
	_tmp237_ = self->priv->pgn_game;
	_tmp238_ = pgn_game_get_result (_tmp237_);
	_tmp239_ = _tmp238_;
	_tmp240_ = pgn_game_RESULT_WHITE;
	if (g_strcmp0 (_tmp239_, _tmp240_) == 0) {
		ChessGame* _tmp241_;
		_tmp241_ = self->priv->game;
		_tmp241_->result = CHESS_RESULT_WHITE_WON;
	} else {
		PGNGame* _tmp242_;
		const gchar* _tmp243_;
		const gchar* _tmp244_;
		const gchar* _tmp245_;
		_tmp242_ = self->priv->pgn_game;
		_tmp243_ = pgn_game_get_result (_tmp242_);
		_tmp244_ = _tmp243_;
		_tmp245_ = pgn_game_RESULT_BLACK;
		if (g_strcmp0 (_tmp244_, _tmp245_) == 0) {
			ChessGame* _tmp246_;
			_tmp246_ = self->priv->game;
			_tmp246_->result = CHESS_RESULT_BLACK_WON;
		} else {
			PGNGame* _tmp247_;
			const gchar* _tmp248_;
			const gchar* _tmp249_;
			const gchar* _tmp250_;
			_tmp247_ = self->priv->pgn_game;
			_tmp248_ = pgn_game_get_result (_tmp247_);
			_tmp249_ = _tmp248_;
			_tmp250_ = pgn_game_RESULT_DRAW;
			if (g_strcmp0 (_tmp249_, _tmp250_) == 0) {
				ChessGame* _tmp251_;
				_tmp251_ = self->priv->game;
				_tmp251_->result = CHESS_RESULT_DRAW;
			}
		}
	}
	_tmp252_ = self->priv->opponent_engine;
	if (_tmp252_ != NULL) {
		ChessEngine* _tmp253_;
		_tmp253_ = self->priv->opponent_engine;
		chess_engine_start_game (_tmp253_);
	}
	_tmp255_ = moves;
	_tmp255__length1 = moves_length1;
	if (_tmp255__length1 > 0) {
		ChessGame* _tmp256_;
		ChessClock* _tmp257_;
		ChessClock* _tmp258_;
		_tmp256_ = self->priv->game;
		_tmp257_ = chess_game_get_clock (_tmp256_);
		_tmp258_ = _tmp257_;
		_tmp254_ = _tmp258_ != NULL;
	} else {
		_tmp254_ = FALSE;
	}
	if (_tmp254_) {
		ChessGame* _tmp259_;
		ChessClock* _tmp260_;
		ChessClock* _tmp261_;
		_tmp259_ = self->priv->game;
		_tmp260_ = chess_game_get_clock (_tmp259_);
		_tmp261_ = _tmp260_;
		chess_clock_start (_tmp261_);
		chess_application_enable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
	} else {
		chess_application_disable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
	}
	chess_application_update_history_panel (self);
	chess_application_update_action_status (self);
	chess_application_update_pause_resume_button (self);
	chess_application_update_headerbar_title (self);
	_tmp262_ = self->priv->white_time_label;
	gtk_widget_queue_draw (_tmp262_);
	_tmp263_ = self->priv->black_time_label;
	gtk_widget_queue_draw (_tmp263_);
	self->priv->starting = FALSE;
	_tmp266_ = white_engine;
	if (_tmp266_ != NULL) {
		ChessGame* _tmp267_;
		ChessPlayer* _tmp268_;
		ChessPlayer* _tmp269_;
		Color _tmp270_;
		_tmp267_ = self->priv->game;
		_tmp268_ = chess_game_get_current_player (_tmp267_);
		_tmp269_ = _tmp268_;
		_tmp270_ = _tmp269_->color;
		_tmp265_ = _tmp270_ == COLOR_WHITE;
	} else {
		_tmp265_ = FALSE;
	}
	if (_tmp265_) {
		_tmp264_ = TRUE;
	} else {
		gboolean _tmp271_ = FALSE;
		const gchar* _tmp272_;
		_tmp272_ = black_engine;
		if (_tmp272_ != NULL) {
			ChessGame* _tmp273_;
			ChessPlayer* _tmp274_;
			ChessPlayer* _tmp275_;
			Color _tmp276_;
			_tmp273_ = self->priv->game;
			_tmp274_ = chess_game_get_current_player (_tmp273_);
			_tmp275_ = _tmp274_;
			_tmp276_ = _tmp275_->color;
			_tmp271_ = _tmp276_ == COLOR_BLACK;
		} else {
			_tmp271_ = FALSE;
		}
		_tmp264_ = _tmp271_;
	}
	if (_tmp264_) {
		ChessEngine* _tmp277_;
		ChessEngine* _tmp278_;
		_tmp277_ = self->priv->opponent_engine;
		_vala_assert (_tmp277_ != NULL, "opponent_engine != null");
		_tmp278_ = self->priv->opponent_engine;
		chess_engine_move (_tmp278_);
	}
	_tmp279_ = self->priv->game;
	_tmp280_ = _tmp279_->result;
	if (_tmp280_ != CHESS_RESULT_IN_PROGRESS) {
		ChessGame* _tmp281_;
		ChessGame* _tmp282_;
		ChessResult _tmp283_;
		_tmp281_ = self->priv->game;
		_tmp282_ = self->priv->game;
		_tmp283_ = _tmp282_->result;
		chess_game_stop (_tmp281_, _tmp283_, CHESS_RULE_UNKNOWN);
	}
	_g_free0 (black_level);
	_g_free0 (black_engine);
	_g_free0 (white_level);
	_g_free0 (white_engine);
	moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (fen);
	_g_object_unref0 (model);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static ChessEngine* chess_application_get_engine (ChessApplication* self, const gchar* name, const gchar* difficulty) {
	ChessEngine* result = NULL;
	ChessEngine* engine = NULL;
	AIProfile* profile = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GList* _tmp2_;
	AIProfile* _tmp12_;
	gchar** options = NULL;
	gint options_length1 = 0;
	gint _options_size_ = 0;
	gchar** uci_go_options = NULL;
	gint uci_go_options_length1 = 0;
	gint _uci_go_options_size_ = 0;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GQuark _tmp21_ = 0U;
	static GQuark _tmp20_label0 = 0;
	static GQuark _tmp20_label1 = 0;
	AIProfile* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (difficulty != NULL, NULL);
	profile = NULL;
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "human") == 0) {
		result = NULL;
		_g_object_unref0 (profile);
		_g_object_unref0 (engine);
		return result;
	}
	_tmp1_ = name;
	if (g_strcmp0 (_tmp1_, "GNUchess") == 0) {
		name = "GNU Chess";
	}
	_tmp2_ = self->priv->ai_profiles;
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = _tmp2_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			AIProfile* _tmp3_;
			AIProfile* p = NULL;
			_tmp3_ = _g_object_ref0 ((AIProfile*) p_it->data);
			p = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				const gchar* _tmp5_;
				_tmp5_ = name;
				if (g_strcmp0 (_tmp5_, "") == 0) {
					_tmp4_ = TRUE;
				} else {
					AIProfile* _tmp6_;
					const gchar* _tmp7_;
					const gchar* _tmp8_;
					const gchar* _tmp9_;
					_tmp6_ = p;
					_tmp7_ = ai_profile_get_name (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = name;
					_tmp4_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
				}
				if (_tmp4_) {
					AIProfile* _tmp10_;
					AIProfile* _tmp11_;
					_tmp10_ = p;
					_tmp11_ = _g_object_ref0 (_tmp10_);
					_g_object_unref0 (profile);
					profile = _tmp11_;
					_g_object_unref0 (p);
					break;
				}
				_g_object_unref0 (p);
			}
		}
	}
	_tmp12_ = profile;
	if (_tmp12_ == NULL) {
		const gchar* _tmp13_;
		GList* _tmp14_;
		GList* _tmp15_;
		gconstpointer _tmp16_;
		AIProfile* _tmp17_;
		_tmp13_ = name;
		g_warning ("gnome-chess.vala:689: Unknown AI profile %s", _tmp13_);
		_tmp14_ = self->priv->ai_profiles;
		if (_tmp14_ == NULL) {
			result = NULL;
			_g_object_unref0 (profile);
			_g_object_unref0 (engine);
			return result;
		}
		_tmp15_ = self->priv->ai_profiles;
		_tmp16_ = _tmp15_->data;
		_tmp17_ = _g_object_ref0 ((AIProfile*) _tmp16_);
		_g_object_unref0 (profile);
		profile = _tmp17_;
	}
	_tmp18_ = difficulty;
	_tmp19_ = _tmp18_;
	_tmp21_ = (NULL == _tmp19_) ? 0 : g_quark_from_string (_tmp19_);
	if (_tmp21_ == ((0 != _tmp20_label0) ? _tmp20_label0 : (_tmp20_label0 = g_quark_from_static_string ("easy")))) {
		switch (0) {
			default:
			{
				AIProfile* _tmp22_;
				gchar** _tmp23_;
				gint _tmp23__length1;
				gchar** _tmp24_;
				gint _tmp24__length1;
				gchar** _tmp25_;
				gint _tmp25__length1;
				AIProfile* _tmp26_;
				gchar** _tmp27_;
				gint _tmp27__length1;
				gchar** _tmp28_;
				gint _tmp28__length1;
				gchar** _tmp29_;
				gint _tmp29__length1;
				AIProfile* _tmp30_;
				gchar** _tmp31_;
				gint _tmp31__length1;
				gchar** _tmp32_;
				gint _tmp32__length1;
				gchar** _tmp33_;
				gint _tmp33__length1;
				_tmp22_ = profile;
				_tmp23_ = ai_profile_get_easy_options (_tmp22_, &_tmp23__length1);
				_tmp24_ = _tmp23_;
				_tmp24__length1 = _tmp23__length1;
				_tmp25_ = (_tmp24_ != NULL) ? _vala_array_dup1 (_tmp24_, _tmp24__length1) : ((gpointer) _tmp24_);
				_tmp25__length1 = _tmp24__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp25_;
				options_length1 = _tmp25__length1;
				_options_size_ = options_length1;
				_tmp26_ = profile;
				_tmp27_ = ai_profile_get_easy_uci_go_options (_tmp26_, &_tmp27__length1);
				_tmp28_ = _tmp27_;
				_tmp28__length1 = _tmp27__length1;
				_tmp29_ = (_tmp28_ != NULL) ? _vala_array_dup2 (_tmp28_, _tmp28__length1) : ((gpointer) _tmp28_);
				_tmp29__length1 = _tmp28__length1;
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
				uci_go_options = _tmp29_;
				uci_go_options_length1 = _tmp29__length1;
				_uci_go_options_size_ = uci_go_options_length1;
				_tmp30_ = profile;
				_tmp31_ = ai_profile_get_easy_args (_tmp30_, &_tmp31__length1);
				_tmp32_ = _tmp31_;
				_tmp32__length1 = _tmp31__length1;
				_tmp33_ = (_tmp32_ != NULL) ? _vala_array_dup3 (_tmp32_, _tmp32__length1) : ((gpointer) _tmp32_);
				_tmp33__length1 = _tmp32__length1;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp33_;
				args_length1 = _tmp33__length1;
				_args_size_ = args_length1;
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label1) ? _tmp20_label1 : (_tmp20_label1 = g_quark_from_static_string ("hard")))) {
		switch (0) {
			default:
			{
				AIProfile* _tmp34_;
				gchar** _tmp35_;
				gint _tmp35__length1;
				gchar** _tmp36_;
				gint _tmp36__length1;
				gchar** _tmp37_;
				gint _tmp37__length1;
				AIProfile* _tmp38_;
				gchar** _tmp39_;
				gint _tmp39__length1;
				gchar** _tmp40_;
				gint _tmp40__length1;
				gchar** _tmp41_;
				gint _tmp41__length1;
				AIProfile* _tmp42_;
				gchar** _tmp43_;
				gint _tmp43__length1;
				gchar** _tmp44_;
				gint _tmp44__length1;
				gchar** _tmp45_;
				gint _tmp45__length1;
				_tmp34_ = profile;
				_tmp35_ = ai_profile_get_hard_options (_tmp34_, &_tmp35__length1);
				_tmp36_ = _tmp35_;
				_tmp36__length1 = _tmp35__length1;
				_tmp37_ = (_tmp36_ != NULL) ? _vala_array_dup4 (_tmp36_, _tmp36__length1) : ((gpointer) _tmp36_);
				_tmp37__length1 = _tmp36__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp37_;
				options_length1 = _tmp37__length1;
				_options_size_ = options_length1;
				_tmp38_ = profile;
				_tmp39_ = ai_profile_get_hard_uci_go_options (_tmp38_, &_tmp39__length1);
				_tmp40_ = _tmp39_;
				_tmp40__length1 = _tmp39__length1;
				_tmp41_ = (_tmp40_ != NULL) ? _vala_array_dup5 (_tmp40_, _tmp40__length1) : ((gpointer) _tmp40_);
				_tmp41__length1 = _tmp40__length1;
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
				uci_go_options = _tmp41_;
				uci_go_options_length1 = _tmp41__length1;
				_uci_go_options_size_ = uci_go_options_length1;
				_tmp42_ = profile;
				_tmp43_ = ai_profile_get_hard_args (_tmp42_, &_tmp43__length1);
				_tmp44_ = _tmp43_;
				_tmp44__length1 = _tmp43__length1;
				_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup6 (_tmp44_, _tmp44__length1) : ((gpointer) _tmp44_);
				_tmp45__length1 = _tmp44__length1;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp45_;
				args_length1 = _tmp45__length1;
				_args_size_ = args_length1;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				AIProfile* _tmp46_;
				gchar** _tmp47_;
				gint _tmp47__length1;
				gchar** _tmp48_;
				gint _tmp48__length1;
				gchar** _tmp49_;
				gint _tmp49__length1;
				AIProfile* _tmp50_;
				gchar** _tmp51_;
				gint _tmp51__length1;
				gchar** _tmp52_;
				gint _tmp52__length1;
				gchar** _tmp53_;
				gint _tmp53__length1;
				AIProfile* _tmp54_;
				gchar** _tmp55_;
				gint _tmp55__length1;
				gchar** _tmp56_;
				gint _tmp56__length1;
				gchar** _tmp57_;
				gint _tmp57__length1;
				_tmp46_ = profile;
				_tmp47_ = ai_profile_get_normal_options (_tmp46_, &_tmp47__length1);
				_tmp48_ = _tmp47_;
				_tmp48__length1 = _tmp47__length1;
				_tmp49_ = (_tmp48_ != NULL) ? _vala_array_dup7 (_tmp48_, _tmp48__length1) : ((gpointer) _tmp48_);
				_tmp49__length1 = _tmp48__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp49_;
				options_length1 = _tmp49__length1;
				_options_size_ = options_length1;
				_tmp50_ = profile;
				_tmp51_ = ai_profile_get_normal_uci_go_options (_tmp50_, &_tmp51__length1);
				_tmp52_ = _tmp51_;
				_tmp52__length1 = _tmp51__length1;
				_tmp53_ = (_tmp52_ != NULL) ? _vala_array_dup8 (_tmp52_, _tmp52__length1) : ((gpointer) _tmp52_);
				_tmp53__length1 = _tmp52__length1;
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
				uci_go_options = _tmp53_;
				uci_go_options_length1 = _tmp53__length1;
				_uci_go_options_size_ = uci_go_options_length1;
				_tmp54_ = profile;
				_tmp55_ = ai_profile_get_normal_args (_tmp54_, &_tmp55__length1);
				_tmp56_ = _tmp55_;
				_tmp56__length1 = _tmp55__length1;
				_tmp57_ = (_tmp56_ != NULL) ? _vala_array_dup9 (_tmp56_, _tmp56__length1) : ((gpointer) _tmp56_);
				_tmp57__length1 = _tmp56__length1;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp57_;
				args_length1 = _tmp57__length1;
				_args_size_ = args_length1;
				break;
			}
		}
	}
	_tmp58_ = profile;
	_tmp59_ = ai_profile_get_protocol (_tmp58_);
	_tmp60_ = _tmp59_;
	if (g_strcmp0 (_tmp60_, "cecp") == 0) {
		gchar** _tmp61_;
		gint _tmp61__length1;
		AIProfile* _tmp62_;
		const gchar* _tmp63_;
		const gchar* _tmp64_;
		gchar** _tmp65_;
		gint _tmp65__length1;
		AIProfile* _tmp66_;
		guint _tmp67_;
		guint _tmp68_;
		gchar** _tmp69_;
		gint _tmp69__length1;
		ChessEngineCECP* _tmp70_;
		_tmp61_ = uci_go_options;
		_tmp61__length1 = uci_go_options_length1;
		g_warn_if_fail (_tmp61__length1 == 0);
		_tmp62_ = profile;
		_tmp63_ = ai_profile_get_binary (_tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = args;
		_tmp65__length1 = args_length1;
		_tmp66_ = profile;
		_tmp67_ = ai_profile_get_delay_seconds (_tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = options;
		_tmp69__length1 = options_length1;
		_tmp70_ = chess_engine_cecp_new (_tmp64_, _tmp65_, _tmp65__length1, _tmp68_, _tmp69_, _tmp69__length1);
		_g_object_unref0 (engine);
		engine = (ChessEngine*) _tmp70_;
	} else {
		AIProfile* _tmp71_;
		const gchar* _tmp72_;
		const gchar* _tmp73_;
		_tmp71_ = profile;
		_tmp72_ = ai_profile_get_protocol (_tmp71_);
		_tmp73_ = _tmp72_;
		if (g_strcmp0 (_tmp73_, "uci") == 0) {
			AIProfile* _tmp74_;
			const gchar* _tmp75_;
			const gchar* _tmp76_;
			gchar** _tmp77_;
			gint _tmp77__length1;
			AIProfile* _tmp78_;
			guint _tmp79_;
			guint _tmp80_;
			gchar** _tmp81_;
			gint _tmp81__length1;
			gchar** _tmp82_;
			gint _tmp82__length1;
			ChessEngineUCI* _tmp83_;
			_tmp74_ = profile;
			_tmp75_ = ai_profile_get_binary (_tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = args;
			_tmp77__length1 = args_length1;
			_tmp78_ = profile;
			_tmp79_ = ai_profile_get_delay_seconds (_tmp78_);
			_tmp80_ = _tmp79_;
			_tmp81_ = options;
			_tmp81__length1 = options_length1;
			_tmp82_ = uci_go_options;
			_tmp82__length1 = uci_go_options_length1;
			_tmp83_ = chess_engine_uci_new (_tmp76_, _tmp77_, _tmp77__length1, _tmp80_, _tmp81_, _tmp81__length1, _tmp82_, _tmp82__length1);
			_g_object_unref0 (engine);
			engine = (ChessEngine*) _tmp83_;
		} else {
			AIProfile* _tmp84_;
			const gchar* _tmp85_;
			const gchar* _tmp86_;
			_tmp84_ = profile;
			_tmp85_ = ai_profile_get_protocol (_tmp84_);
			_tmp86_ = _tmp85_;
			g_warning ("gnome-chess.vala:727: Unknown AI protocol %s", _tmp86_);
			result = NULL;
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
			options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (profile);
			_g_object_unref0 (engine);
			return result;
		}
	}
	result = engine;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (profile);
	return result;
}


static void chess_application_engine_ready_cb (ChessApplication* self, ChessEngine* engine) {
	ChessEngine* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->opponent_engine;
	_tmp1_ = chess_engine_get_ready (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ChessView* _tmp3_;
		_tmp3_ = self->priv->view;
		gtk_widget_queue_draw ((GtkWidget*) _tmp3_);
	}
}


static void chess_application_do_engine_move (ChessApplication* self, const gchar* move) {
	ChessPlayer* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (move != NULL);
	_tmp0_ = self->priv->opponent;
	_tmp1_ = move;
	_tmp2_ = chess_player_move (_tmp0_, _tmp1_, TRUE);
	if (!_tmp2_) {
		const gchar* _tmp3_;
		ChessGame* _tmp4_;
		_tmp3_ = move;
		g_warning ("gnome-chess.vala:746: Engine's move %s is illegal! Engine desync?", _tmp3_);
		_tmp4_ = self->priv->game;
		chess_game_stop (_tmp4_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
	}
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ChessApplication* self;
		self = _data2_->self;
		_g_free0 (_data2_->move);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean ___lambda7_ (Block2Data* _data2_) {
	ChessApplication* self;
	gboolean result = FALSE;
	ChessGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data2_->self;
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = G_SOURCE_CONTINUE;
		return result;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = _data2_->move;
		chess_application_do_engine_move (self, _tmp3_);
		result = G_SOURCE_REMOVE;
		return result;
	}
}


static gboolean ____lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda7_ (self);
	return result;
}


static void chess_application_engine_move_cb (ChessApplication* self, ChessEngine* engine, const gchar* move) {
	Block2Data* _data2_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	ChessGame* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	g_return_if_fail (move != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = move;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data2_->move);
	_data2_->move = _tmp1_;
	_tmp2_ = self->priv->game;
	_tmp3_ = chess_game_get_is_paused (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		const gchar* _tmp5_;
		_tmp5_ = _data2_->move;
		chess_application_do_engine_move (self, _tmp5_);
	} else {
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda7__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	}
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void chess_application_engine_resigned_cb (ChessApplication* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->opponent;
	chess_player_resign (_tmp0_);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ChessApplication* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->original_game);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean __lambda8_ (Block3Data* _data3_) {
	ChessApplication* self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_;
	self = _data3_->self;
	_tmp1_ = self->priv->game;
	if (_tmp1_ == _data3_->original_game) {
		ChessGame* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = self->priv->game;
		_tmp3_ = _tmp2_->is_started;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessGame* _tmp4_;
		_tmp4_ = self->priv->game;
		chess_game_stop (_tmp4_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
	}
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ___lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda8_ (self);
	return result;
}


static void chess_application_engine_stopped_unexpectedly_cb (ChessApplication* self, ChessEngine* engine) {
	Block3Data* _data3_;
	ChessGame* _tmp0_;
	ChessGame* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data3_->original_game = _tmp1_;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ___lambda8__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void chess_application_engine_error_cb (ChessApplication* self, ChessEngine* engine) {
	ChessGame* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->game;
	chess_game_stop (_tmp0_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
}


static void chess_application_engine_claim_draw_cb (ChessApplication* self, ChessEngine* engine) {
	ChessGame* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_can_claim_draw (_tmp0_);
	if (!_tmp1_) {
		ChessGame* _tmp2_;
		_tmp2_ = self->priv->game;
		chess_game_stop (_tmp2_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
	}
}


static void chess_application_engine_offer_draw_cb (ChessApplication* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->opponent;
	chess_player_claim_draw (_tmp0_);
}


static void chess_application_check_engine_timeout (ChessApplication* self) {
	gint _tmp0_;
	ChessEngine* _tmp1_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	PGNGame* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->engine_timeout_counter;
	_vala_return_if_fail (_tmp0_ >= 0, "engine_timeout_counter >= 0");
	_tmp1_ = self->priv->opponent_engine;
	if (_tmp1_ == NULL) {
		gint _tmp2_;
		_tmp2_ = self->priv->engine_timeout_counter;
		_vala_warn_if_fail (_tmp2_ >= 0, "engine_timeout_counter >= 0");
		return;
	}
	_tmp5_ = self->priv->pgn_game;
	_tmp6_ = pgn_game_get_white_ai (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ChessGame* _tmp8_;
		ChessPlayer* _tmp9_;
		ChessPlayer* _tmp10_;
		Color _tmp11_;
		_tmp8_ = self->priv->game;
		_tmp9_ = chess_game_get_current_player (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_->color;
		_tmp4_ = _tmp11_ == COLOR_WHITE;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp12_ = FALSE;
		PGNGame* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = self->priv->pgn_game;
		_tmp14_ = pgn_game_get_black_ai (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ != NULL) {
			ChessGame* _tmp16_;
			ChessPlayer* _tmp17_;
			ChessPlayer* _tmp18_;
			Color _tmp19_;
			_tmp16_ = self->priv->game;
			_tmp17_ = chess_game_get_current_player (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = _tmp18_->color;
			_tmp12_ = _tmp19_ == COLOR_BLACK;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp3_ = _tmp12_;
	}
	if (_tmp3_) {
		gint _tmp20_;
		gint _tmp21_;
		_tmp20_ = self->priv->engine_timeout_counter;
		self->priv->engine_timeout_counter = _tmp20_ - 1;
		_tmp21_ = self->priv->engine_timeout_counter;
		if (_tmp21_ == 0) {
			ChessEngine* _tmp22_;
			_tmp22_ = self->priv->opponent_engine;
			chess_application_engine_error_cb (self, _tmp22_);
		}
	} else {
		self->priv->engine_timeout_counter = 10;
	}
	_tmp23_ = self->priv->engine_timeout_counter;
	_vala_warn_if_fail (_tmp23_ >= 0, "engine_timeout_counter >= 0");
}


static void chess_application_game_clock_tick_cb (ChessApplication* self, ChessClock* clock) {
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clock != NULL);
	chess_application_check_engine_timeout (self);
	_tmp0_ = self->priv->white_time_label;
	gtk_widget_queue_draw (_tmp0_);
	_tmp1_ = self->priv->black_time_label;
	gtk_widget_queue_draw (_tmp1_);
}


static void chess_application_game_turn_cb (ChessApplication* self, ChessGame* game, ChessPlayer* player) {
	ChessGame* _tmp0_;
	gboolean _tmp1_;
	ChessGame* _tmp2_;
	ChessClock* _tmp3_;
	ChessClock* _tmp4_;
	ChessGame* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (player != NULL);
	_tmp0_ = game;
	_tmp1_ = _tmp0_->is_started;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = game;
	_tmp3_ = chess_game_get_clock (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		chess_application_enable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
	}
	_tmp5_ = game;
	_tmp6_ = chess_game_can_claim_draw (_tmp5_);
	if (_tmp6_) {
		chess_application_present_claim_draw_dialog (self);
	}
}


static void chess_application_set_move_text (ChessApplication* self, GtkTreeIter* iter, ChessMove* move) {
	static const gchar* human_descriptions[] = {N_ ("White pawn moves from %1$s to %2$s"), N_ ("White pawn at %1$s takes the black pawn at %2$s"), N_ ("White pawn at %1$s takes the black rook at %2$s"), N_ ("White pawn at %1$s takes the black knight at %2$s"), N_ ("White pawn at %1$s takes the black bishop at %2$s"), N_ ("White pawn at %1$s takes the black queen at %2$s"), N_ ("White rook moves from %1$s to %2$s"), N_ ("White rook at %1$s takes the black pawn at %2$s"), N_ ("White rook at %1$s takes the black rook at %2$s"), N_ ("White rook at %1$s takes the black knight at %2$s"), N_ ("White rook at %1$s takes the black bishop at %2$s"), N_ ("White rook at %1$s takes the black queen at %2$s"), N_ ("White knight moves from %1$s to %2$s"), N_ ("White knight at %1$s takes the black pawn at %2$s"), N_ ("White knight at %1$s takes the black rook at %2$s"), N_ ("White knight at %1$s takes the black knight at %2$s"), N_ ("White knight at %1$s takes the black bishop at %2$s"), N_ ("White knight at %1$s takes the black queen at %2$s"), N_ ("White bishop moves from %1$s to %2$s"), N_ ("White bishop at %1$s takes the black pawn at %2$s"), N_ ("White bishop at %1$s takes the black rook at %2$s"), N_ ("White bishop at %1$s takes the black knight at %2$s"), N_ ("White bishop at %1$s takes the black bishop at %2$s"), N_ ("White bishop at %1$s takes the black queen at %2$s"), N_ ("White queen moves from %1$s to %2$s"), N_ ("White queen at %1$s takes the black pawn at %2$s"), N_ ("White queen at %1$s takes the black rook at %2$s"), N_ ("White queen at %1$s takes the black knight at %2$s"), N_ ("White queen at %1$s takes the black bishop at %2$s"), N_ ("White queen at %1$s takes the black queen at %2$s"), N_ ("White king moves from %1$s to %2$s"), N_ ("White king at %1$s takes the black pawn at %2$s"), N_ ("White king at %1$s takes the black rook at %2$s"), N_ ("White king at %1$s takes the black knight at %2$s"), N_ ("White king at %1$s takes the black bishop at %2$s"), N_ ("White king at %1$s takes the black queen at %2$s"), N_ ("Black pawn moves from %1$s to %2$s"), N_ ("Black pawn at %1$s takes the white pawn at %2$s"), N_ ("Black pawn at %1$s takes the white rook at %2$s"), N_ ("Black pawn at %1$s takes the white knight at %2$s"), N_ ("Black pawn at %1$s takes the white bishop at %2$s"), N_ ("Black pawn at %1$s takes the white queen at %2$s"), N_ ("Black rook moves from %1$s to %2$s"), N_ ("Black rook at %1$s takes the white pawn at %2$s"), N_ ("Black rook at %1$s takes the white rook at %2$s"), N_ ("Black rook at %1$s takes the white knight at %2$s"), N_ ("Black rook at %1$s takes the white bishop at %2$s"), N_ ("Black rook at %1$s takes the white queen at %2$s"), N_ ("Black knight moves from %1$s to %2$s"), N_ ("Black knight at %1$s takes the white pawn at %2$s"), N_ ("Black knight at %1$s takes the white rook at %2$s"), N_ ("Black knight at %1$s takes the white knight at %2$s"), N_ ("Black knight at %1$s takes the white bishop at %2$s"), N_ ("Black knight at %1$s takes the white queen at %2$s"), N_ ("Black bishop moves from %1$s to %2$s"), N_ ("Black bishop at %1$s takes the white pawn at %2$s"), N_ ("Black bishop at %1$s takes the white rook at %2$s"), N_ ("Black bishop at %1$s takes the white knight at %2$s"), N_ ("Black bishop at %1$s takes the white bishop at %2$s"), N_ ("Black bishop at %1$s takes the white queen at %2$s"), N_ ("Black queen moves from %1$s to %2$s"), N_ ("Black queen at %1$s takes the white pawn at %2$s"), N_ ("Black queen at %1$s takes the white rook at %2$s"), N_ ("Black queen at %1$s takes the white knight at %2$s"), N_ ("Black queen at %1$s takes the white bishop at %2$s"), N_ ("Black queen at %1$s takes the white queen at %2$s"), N_ ("Black king moves from %1$s to %2$s"), N_ ("Black king at %1$s takes the white pawn at %2$s"), N_ ("Black king at %1$s takes the white rook at %2$s"), N_ ("Black king at %1$s takes the white knight at %2$s"), N_ ("Black king at %1$s takes the white bishop at %2$s"), N_ ("Black king at %1$s takes the white queen at %2$s")};
	gchar* move_text = NULL;
	gchar* _tmp0_;
	ChessScene* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp76_;
	GtkTreeModel* _tmp77_;
	GtkTreeModel* _tmp78_;
	GtkListStore* _tmp79_;
	gchar _tmp80_ = '\0';
	ChessMove* _tmp81_;
	gint _tmp82_;
	gchar* label = NULL;
	ChessMove* _tmp83_;
	gint _tmp84_;
	const gchar* _tmp85_;
	gchar* _tmp86_;
	GtkListStore* _tmp87_;
	GtkTreeIter _tmp88_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (move != NULL);
	_tmp0_ = g_strdup ("");
	move_text = _tmp0_;
	_tmp1_ = self->priv->scene;
	_tmp2_ = chess_scene_get_move_format (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("human")))) {
		switch (0) {
			default:
			{
				ChessMove* _tmp7_;
				ChessPiece* _tmp8_;
				_tmp7_ = move;
				_tmp8_ = _tmp7_->moved_rook;
				if (_tmp8_ == NULL) {
					gint index = 0;
					ChessMove* _tmp9_;
					ChessPiece* _tmp10_;
					gint _tmp14_;
					ChessMove* _tmp15_;
					ChessPiece* _tmp16_;
					PieceType _tmp17_;
					ChessMove* _tmp18_;
					ChessPiece* _tmp19_;
					ChessPlayer* _tmp20_;
					Color _tmp21_;
					gchar* start = NULL;
					ChessMove* _tmp23_;
					gint _tmp24_;
					ChessMove* _tmp25_;
					gint _tmp26_;
					gchar* _tmp27_;
					gchar* end = NULL;
					ChessMove* _tmp28_;
					gint _tmp29_;
					ChessMove* _tmp30_;
					gint _tmp31_;
					gchar* _tmp32_;
					gint _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
					_tmp9_ = move;
					_tmp10_ = _tmp9_->victim;
					if (_tmp10_ == NULL) {
						index = 0;
					} else {
						ChessMove* _tmp11_;
						ChessPiece* _tmp12_;
						PieceType _tmp13_;
						_tmp11_ = move;
						_tmp12_ = _tmp11_->victim;
						_tmp13_ = _tmp12_->type;
						index = (gint) (_tmp13_ + 1);
					}
					_tmp14_ = index;
					_tmp15_ = move;
					_tmp16_ = _tmp15_->piece;
					_tmp17_ = _tmp16_->type;
					index = _tmp14_ + (_tmp17_ * 6);
					_tmp18_ = move;
					_tmp19_ = _tmp18_->piece;
					_tmp20_ = _tmp19_->player;
					_tmp21_ = _tmp20_->color;
					if (_tmp21_ == COLOR_BLACK) {
						gint _tmp22_;
						_tmp22_ = index;
						index = _tmp22_ + 36;
					}
					_tmp23_ = move;
					_tmp24_ = _tmp23_->f0;
					_tmp25_ = move;
					_tmp26_ = _tmp25_->r0;
					_tmp27_ = g_strdup_printf ("%c%d", 'a' + _tmp24_, _tmp26_ + 1);
					start = _tmp27_;
					_tmp28_ = move;
					_tmp29_ = _tmp28_->f1;
					_tmp30_ = move;
					_tmp31_ = _tmp30_->r1;
					_tmp32_ = g_strdup_printf ("%c%d", 'a' + _tmp29_, _tmp31_ + 1);
					end = _tmp32_;
					_tmp33_ = index;
					_tmp34_ = human_descriptions[_tmp33_];
					_tmp35_ = start;
					_tmp36_ = end;
					_tmp37_ = g_strdup_printf (_ (_tmp34_), _tmp35_, _tmp36_);
					_g_free0 (move_text);
					move_text = _tmp37_;
					_g_free0 (end);
					_g_free0 (start);
				} else {
					gboolean _tmp38_ = FALSE;
					ChessMove* _tmp39_;
					gint _tmp40_;
					ChessMove* _tmp41_;
					gint _tmp42_;
					_tmp39_ = move;
					_tmp40_ = _tmp39_->f0;
					_tmp41_ = move;
					_tmp42_ = _tmp41_->f1;
					if (_tmp40_ < _tmp42_) {
						ChessMove* _tmp43_;
						gint _tmp44_;
						_tmp43_ = move;
						_tmp44_ = _tmp43_->r0;
						_tmp38_ = _tmp44_ == 0;
					} else {
						_tmp38_ = FALSE;
					}
					if (_tmp38_) {
						gchar* _tmp45_;
						_tmp45_ = g_strdup (_ ("White castles kingside"));
						_g_free0 (move_text);
						move_text = _tmp45_;
					} else {
						gboolean _tmp46_ = FALSE;
						ChessMove* _tmp47_;
						gint _tmp48_;
						ChessMove* _tmp49_;
						gint _tmp50_;
						_tmp47_ = move;
						_tmp48_ = _tmp47_->f1;
						_tmp49_ = move;
						_tmp50_ = _tmp49_->f0;
						if (_tmp48_ < _tmp50_) {
							ChessMove* _tmp51_;
							gint _tmp52_;
							_tmp51_ = move;
							_tmp52_ = _tmp51_->r0;
							_tmp46_ = _tmp52_ == 0;
						} else {
							_tmp46_ = FALSE;
						}
						if (_tmp46_) {
							gchar* _tmp53_;
							_tmp53_ = g_strdup (_ ("White castles queenside"));
							_g_free0 (move_text);
							move_text = _tmp53_;
						} else {
							gboolean _tmp54_ = FALSE;
							ChessMove* _tmp55_;
							gint _tmp56_;
							ChessMove* _tmp57_;
							gint _tmp58_;
							_tmp55_ = move;
							_tmp56_ = _tmp55_->f0;
							_tmp57_ = move;
							_tmp58_ = _tmp57_->f1;
							if (_tmp56_ < _tmp58_) {
								ChessMove* _tmp59_;
								gint _tmp60_;
								_tmp59_ = move;
								_tmp60_ = _tmp59_->r0;
								_tmp54_ = _tmp60_ == 7;
							} else {
								_tmp54_ = FALSE;
							}
							if (_tmp54_) {
								gchar* _tmp61_;
								_tmp61_ = g_strdup (_ ("Black castles kingside"));
								_g_free0 (move_text);
								move_text = _tmp61_;
							} else {
								gboolean _tmp62_ = FALSE;
								ChessMove* _tmp63_;
								gint _tmp64_;
								ChessMove* _tmp65_;
								gint _tmp66_;
								_tmp63_ = move;
								_tmp64_ = _tmp63_->f1;
								_tmp65_ = move;
								_tmp66_ = _tmp65_->f0;
								if (_tmp64_ < _tmp66_) {
									ChessMove* _tmp67_;
									gint _tmp68_;
									_tmp67_ = move;
									_tmp68_ = _tmp67_->r0;
									_tmp62_ = _tmp68_ == 7;
								} else {
									_tmp62_ = FALSE;
								}
								if (_tmp62_) {
									gchar* _tmp69_;
									_tmp69_ = g_strdup (_ ("Black castles queenside"));
									_g_free0 (move_text);
									move_text = _tmp69_;
								} else {
									g_assert_not_reached ();
								}
							}
						}
					}
				}
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("san")))) {
		switch (0) {
			default:
			{
				ChessMove* _tmp70_;
				gchar* _tmp71_;
				_tmp70_ = move;
				_tmp71_ = chess_move_get_san (_tmp70_);
				_g_free0 (move_text);
				move_text = _tmp71_;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("fan")))) {
		switch (0) {
			default:
			{
				ChessMove* _tmp72_;
				gchar* _tmp73_;
				_tmp72_ = move;
				_tmp73_ = chess_move_get_fan (_tmp72_);
				_g_free0 (move_text);
				move_text = _tmp73_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				ChessMove* _tmp74_;
				gchar* _tmp75_;
				_tmp74_ = move;
				_tmp75_ = chess_move_get_lan (_tmp74_);
				_g_free0 (move_text);
				move_text = _tmp75_;
				break;
			}
		}
	}
	_tmp76_ = self->priv->history_combo;
	_tmp77_ = gtk_combo_box_get_model (_tmp76_);
	_tmp78_ = _tmp77_;
	_tmp79_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp79_;
	_tmp81_ = move;
	_tmp82_ = _tmp81_->number;
	if ((_tmp82_ % 2) == 0) {
		_tmp80_ = 'b';
	} else {
		_tmp80_ = 'a';
	}
	_tmp83_ = move;
	_tmp84_ = _tmp83_->number;
	_tmp85_ = move_text;
	_tmp86_ = g_strdup_printf ("%u%c. %s", (guint) ((_tmp84_ + 1) / 2), (gint) _tmp80_, _tmp85_);
	label = _tmp86_;
	_tmp87_ = model;
	_tmp88_ = *iter;
	gtk_list_store_set (_tmp87_, &_tmp88_, 0, label, -1, -1);
	_g_free0 (label);
	_g_object_unref0 (model);
	_g_free0 (move_text);
}


static void chess_application_game_move_cb (ChessApplication* self, ChessGame* game, ChessMove* move) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessMove* _tmp2_;
	gint _tmp3_;
	ChessMove* _tmp7_;
	gint _tmp8_;
	PGNGame* _tmp9_;
	GList* _tmp10_;
	guint _tmp11_;
	ChessScene* _tmp15_;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp16_;
	GtkTreeModel* _tmp17_;
	GtkTreeModel* _tmp18_;
	GtkListStore* _tmp19_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp20_;
	GtkTreeIter _tmp21_ = {0};
	GtkListStore* _tmp22_;
	GtkTreeIter _tmp23_;
	ChessMove* _tmp24_;
	gint _tmp25_;
	GtkTreeIter _tmp26_;
	ChessMove* _tmp27_;
	ChessMove* _tmp28_;
	gint _tmp29_;
	ChessGame* _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	ChessView* _tmp35_;
	ChessEngine* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (move != NULL);
	chess_application_enable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
	self->priv->game_needs_saving = TRUE;
	_tmp2_ = move;
	_tmp3_ = _tmp2_->number;
	if (_tmp3_ == 1) {
		ChessPlayer* _tmp4_;
		_tmp4_ = self->priv->opponent;
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ChessPlayer* _tmp5_;
		Color _tmp6_;
		_tmp5_ = self->priv->opponent;
		_tmp6_ = _tmp5_->color;
		_tmp0_ = _tmp6_ == COLOR_WHITE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->game_needs_saving = FALSE;
	}
	_tmp7_ = move;
	_tmp8_ = _tmp7_->number;
	_tmp9_ = self->priv->pgn_game;
	_tmp10_ = _tmp9_->moves;
	_tmp11_ = g_list_length (_tmp10_);
	if (((guint) _tmp8_) > _tmp11_) {
		PGNGame* _tmp12_;
		ChessMove* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = self->priv->pgn_game;
		_tmp13_ = move;
		_tmp14_ = chess_move_get_san (_tmp13_);
		_tmp12_->moves = g_list_append (_tmp12_->moves, _tmp14_);
	}
	_tmp15_ = self->priv->scene;
	chess_scene_set_move_number (_tmp15_, -1);
	_tmp16_ = self->priv->history_combo;
	_tmp17_ = gtk_combo_box_get_model (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp19_;
	_tmp20_ = model;
	gtk_list_store_append (_tmp20_, &_tmp21_);
	iter = _tmp21_;
	_tmp22_ = model;
	_tmp23_ = iter;
	_tmp24_ = move;
	_tmp25_ = _tmp24_->number;
	gtk_list_store_set (_tmp22_, &_tmp23_, 1, _tmp25_, -1, -1);
	_tmp26_ = iter;
	_tmp27_ = move;
	chess_application_set_move_text (self, &_tmp26_, _tmp27_);
	_tmp28_ = move;
	_tmp29_ = _tmp28_->number;
	_tmp30_ = game;
	_tmp31_ = chess_game_get_n_moves (_tmp30_);
	_tmp32_ = _tmp31_;
	if (((guint) _tmp29_) == _tmp32_) {
		GtkComboBox* _tmp33_;
		GtkTreeIter _tmp34_;
		_tmp33_ = self->priv->history_combo;
		_tmp34_ = iter;
		gtk_combo_box_set_active_iter (_tmp33_, &_tmp34_);
	}
	chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
	chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
	chess_application_update_history_panel (self);
	chess_application_update_action_status (self);
	chess_application_update_headerbar_title (self);
	_tmp35_ = self->priv->view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp35_);
	_tmp36_ = self->priv->opponent_engine;
	if (_tmp36_ != NULL) {
		ChessEngine* _tmp37_;
		ChessMove* _tmp38_;
		gboolean _tmp39_ = FALSE;
		ChessMove* _tmp40_;
		ChessPiece* _tmp41_;
		Color _tmp42_;
		Color _tmp43_;
		ChessPlayer* _tmp44_;
		Color _tmp45_;
		_tmp37_ = self->priv->opponent_engine;
		_tmp38_ = move;
		chess_engine_report_move (_tmp37_, _tmp38_);
		_tmp40_ = move;
		_tmp41_ = _tmp40_->piece;
		_tmp42_ = chess_piece_get_color (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = self->priv->opponent;
		_tmp45_ = _tmp44_->color;
		if (_tmp43_ != _tmp45_) {
			gboolean _tmp46_;
			_tmp46_ = self->priv->starting;
			_tmp39_ = !_tmp46_;
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			ChessEngine* _tmp47_;
			_tmp47_ = self->priv->opponent_engine;
			chess_engine_move (_tmp47_);
		}
	}
	_g_object_unref0 (model);
}


static void chess_application_game_undo_cb (ChessApplication* self, ChessGame* game) {
	ChessEngine* _tmp0_;
	PGNGame* _tmp2_;
	PGNGame* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeModel* _tmp8_;
	GtkListStore* _tmp9_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp10_;
	GtkListStore* _tmp11_;
	gint _tmp12_;
	GtkTreeIter _tmp13_ = {0};
	GtkListStore* _tmp14_;
	ChessScene* _tmp15_;
	GtkListStore* _tmp16_;
	GtkListStore* _tmp17_;
	gint _tmp18_;
	GtkTreeIter _tmp19_ = {0};
	GtkComboBox* _tmp20_;
	GtkTreeIter _tmp21_;
	ChessView* _tmp22_;
	ChessGame* _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->opponent_engine;
	if (_tmp0_ != NULL) {
		ChessEngine* _tmp1_;
		_tmp1_ = self->priv->opponent_engine;
		chess_engine_undo (_tmp1_);
	}
	_tmp2_ = self->priv->pgn_game;
	_tmp3_ = self->priv->pgn_game;
	_tmp4_ = _tmp3_->moves;
	_tmp5_ = g_list_last (_tmp4_);
	_tmp2_->moves = g_list_remove_link (_tmp2_->moves, _tmp5_);
	_tmp6_ = self->priv->history_combo;
	_tmp7_ = gtk_combo_box_get_model (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp9_;
	_tmp10_ = model;
	_tmp11_ = model;
	_tmp12_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp11_, NULL);
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp10_, &_tmp13_, NULL, _tmp12_ - 1);
	iter = _tmp13_;
	_tmp14_ = model;
	gtk_list_store_remove (_tmp14_, &iter);
	_tmp15_ = self->priv->scene;
	chess_scene_set_move_number (_tmp15_, -1);
	_tmp16_ = model;
	_tmp17_ = model;
	_tmp18_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp17_, NULL);
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp16_, &_tmp19_, NULL, _tmp18_ - 1);
	iter = _tmp19_;
	_tmp20_ = self->priv->history_combo;
	_tmp21_ = iter;
	gtk_combo_box_set_active_iter (_tmp20_, &_tmp21_);
	_tmp22_ = self->priv->view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp22_);
	_tmp23_ = game;
	_tmp24_ = chess_game_get_n_moves (_tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ > ((guint) 0)) {
		self->priv->game_needs_saving = TRUE;
		chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
		chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
	} else {
		self->priv->game_needs_saving = FALSE;
		chess_application_disable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
	}
	chess_application_update_history_panel (self);
	chess_application_update_action_status (self);
	chess_application_update_headerbar_title (self);
	_g_object_unref0 (model);
}


static void chess_application_update_action_status (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gboolean can_resign = FALSE;
	gboolean _tmp7_;
	gboolean _tmp8_ = FALSE;
	ChessGame* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	gboolean can_undo = FALSE;
	gboolean _tmp15_ = FALSE;
	ChessPlayer* _tmp16_;
	gboolean _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	_tmp2_ = chess_game_get_n_moves (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > ((guint) 0)) {
		ChessGame* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->game;
		_tmp5_ = chess_game_get_is_paused (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	can_resign = _tmp0_;
	_tmp7_ = can_resign;
	if (_tmp7_) {
		chess_application_enable_window_action (self, CHESS_APPLICATION_RESIGN_ACTION_NAME);
	} else {
		chess_application_disable_window_action (self, CHESS_APPLICATION_RESIGN_ACTION_NAME);
	}
	_tmp9_ = self->priv->game;
	_tmp10_ = chess_game_get_n_moves (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ > ((guint) 0)) {
		ChessGame* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp12_ = self->priv->game;
		_tmp13_ = chess_game_get_is_paused (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp8_ = !_tmp14_;
	} else {
		_tmp8_ = FALSE;
	}
	can_undo = _tmp8_;
	_tmp16_ = self->priv->opponent;
	if (_tmp16_ != NULL) {
		ChessPlayer* _tmp17_;
		Color _tmp18_;
		_tmp17_ = self->priv->opponent;
		_tmp18_ = _tmp17_->color;
		_tmp15_ = _tmp18_ == COLOR_WHITE;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gboolean _tmp19_ = FALSE;
		ChessGame* _tmp20_;
		guint _tmp21_;
		guint _tmp22_;
		_tmp20_ = self->priv->game;
		_tmp21_ = chess_game_get_n_moves (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_ > ((guint) 1)) {
			ChessGame* _tmp23_;
			gboolean _tmp24_;
			gboolean _tmp25_;
			_tmp23_ = self->priv->game;
			_tmp24_ = chess_game_get_is_paused (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp19_ = !_tmp25_;
		} else {
			_tmp19_ = FALSE;
		}
		can_undo = _tmp19_;
	}
	_tmp26_ = can_undo;
	if (_tmp26_) {
		chess_application_enable_window_action (self, CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME);
	} else {
		chess_application_disable_window_action (self, CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME);
	}
}


static void chess_application_update_headerbar_title (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessPlayer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->human_player;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ChessPlayer* _tmp3_;
		Color _tmp4_;
		ChessGame* _tmp5_;
		ChessPlayer* _tmp6_;
		ChessPlayer* _tmp7_;
		Color _tmp8_;
		_tmp3_ = self->priv->human_player;
		_tmp4_ = _tmp3_->color;
		_tmp5_ = self->priv->game;
		_tmp6_ = chess_game_get_current_player (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->color;
		_tmp1_ = _tmp4_ == _tmp8_;
	}
	if (_tmp1_) {
		ChessGame* _tmp9_;
		ChessState* _tmp10_;
		ChessState* _tmp11_;
		ChessGame* _tmp12_;
		ChessPlayer* _tmp13_;
		ChessPlayer* _tmp14_;
		gboolean _tmp15_;
		_tmp9_ = self->priv->game;
		_tmp10_ = chess_game_get_current_state (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->priv->game;
		_tmp13_ = chess_game_get_current_player (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = chess_state_is_in_check (_tmp11_, _tmp14_);
		_tmp0_ = _tmp15_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessGame* _tmp16_;
		ChessPlayer* _tmp17_;
		ChessPlayer* _tmp18_;
		Color _tmp19_;
		_tmp16_ = self->priv->game;
		_tmp17_ = chess_game_get_current_player (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_->color;
		if (_tmp19_ == COLOR_WHITE) {
			GtkHeaderBar* _tmp20_;
			_tmp20_ = self->priv->headerbar;
			gtk_header_bar_set_title (_tmp20_, _ ("White is in Check"));
		} else {
			GtkHeaderBar* _tmp21_;
			_tmp21_ = self->priv->headerbar;
			gtk_header_bar_set_title (_tmp21_, _ ("Black is in Check"));
		}
	} else {
		ChessGame* _tmp22_;
		ChessPlayer* _tmp23_;
		ChessPlayer* _tmp24_;
		Color _tmp25_;
		_tmp22_ = self->priv->game;
		_tmp23_ = chess_game_get_current_player (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_->color;
		if (_tmp25_ == COLOR_WHITE) {
			gboolean _tmp26_ = FALSE;
			ChessPlayer* _tmp27_;
			_tmp27_ = self->priv->human_player;
			if (_tmp27_ == NULL) {
				_tmp26_ = TRUE;
			} else {
				ChessPlayer* _tmp28_;
				Color _tmp29_;
				_tmp28_ = self->priv->human_player;
				_tmp29_ = _tmp28_->color;
				_tmp26_ = _tmp29_ == COLOR_WHITE;
			}
			if (_tmp26_) {
				GtkHeaderBar* _tmp30_;
				_tmp30_ = self->priv->headerbar;
				gtk_header_bar_set_title (_tmp30_, _ ("White to Move"));
			} else {
				GtkHeaderBar* _tmp31_;
				_tmp31_ = self->priv->headerbar;
				gtk_header_bar_set_title (_tmp31_, _ ("White is Thinking…"));
			}
		} else {
			gboolean _tmp32_ = FALSE;
			ChessPlayer* _tmp33_;
			_tmp33_ = self->priv->human_player;
			if (_tmp33_ == NULL) {
				_tmp32_ = TRUE;
			} else {
				ChessPlayer* _tmp34_;
				Color _tmp35_;
				_tmp34_ = self->priv->human_player;
				_tmp35_ = _tmp34_->color;
				_tmp32_ = _tmp35_ == COLOR_BLACK;
			}
			if (_tmp32_) {
				GtkHeaderBar* _tmp36_;
				_tmp36_ = self->priv->headerbar;
				gtk_header_bar_set_title (_tmp36_, _ ("Black to Move"));
			} else {
				GtkHeaderBar* _tmp37_;
				_tmp37_ = self->priv->headerbar;
				gtk_header_bar_set_title (_tmp37_, _ ("Black is Thinking…"));
			}
		}
	}
}


static void chess_application_update_pause_resume_button (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_;
	gboolean _tmp7_ = FALSE;
	ChessGame* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	if (_tmp1_ != NULL) {
		ChessGame* _tmp2_;
		ChessClock* _tmp3_;
		ChessClock* _tmp4_;
		_tmp2_ = self->priv->game;
		_tmp3_ = chess_game_get_clock (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkButton* _tmp5_;
		_tmp5_ = self->priv->pause_resume_button;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
	} else {
		GtkButton* _tmp6_;
		_tmp6_ = self->priv->pause_resume_button;
		gtk_widget_show ((GtkWidget*) _tmp6_);
	}
	_tmp8_ = self->priv->game;
	if (_tmp8_ != NULL) {
		ChessGame* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->game;
		_tmp10_ = chess_game_get_is_paused (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GtkButton* _tmp12_;
		GtkImage* _tmp13_;
		GtkImage* _tmp14_;
		GtkButton* _tmp15_;
		_tmp12_ = self->priv->pause_resume_button;
		_tmp13_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-start-symbolic", GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp13_);
		_tmp14_ = _tmp13_;
		gtk_button_set_image (_tmp12_, (GtkWidget*) _tmp14_);
		_g_object_unref0 (_tmp14_);
		_tmp15_ = self->priv->pause_resume_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, _ ("Unpause the game"));
	} else {
		GtkButton* _tmp16_;
		GtkImage* _tmp17_;
		GtkImage* _tmp18_;
		GtkButton* _tmp19_;
		_tmp16_ = self->priv->pause_resume_button;
		_tmp17_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-pause-symbolic", GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp17_);
		_tmp18_ = _tmp17_;
		gtk_button_set_image (_tmp16_, (GtkWidget*) _tmp18_);
		_g_object_unref0 (_tmp18_);
		_tmp19_ = self->priv->pause_resume_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp19_, _ ("Pause the game"));
	}
}


static void chess_application_game_end_cb (ChessApplication* self) {
	ChessEngine* _tmp0_;
	gchar* title = NULL;
	gchar* _tmp2_;
	ChessGame* _tmp3_;
	ChessResult _tmp4_;
	gchar* reason = NULL;
	gchar* _tmp15_;
	ChessGame* _tmp16_;
	ChessRule _tmp17_;
	GtkHeaderBar* _tmp51_;
	const gchar* _tmp52_;
	GtkHeaderBar* _tmp53_;
	const gchar* _tmp54_;
	GtkWidget* _tmp55_;
	GtkWidget* _tmp56_;
	g_return_if_fail (self != NULL);
	chess_application_disable_window_action (self, CHESS_APPLICATION_RESIGN_ACTION_NAME);
	chess_application_disable_window_action (self, CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME);
	chess_application_disable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
	chess_application_enable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
	self->priv->game_needs_saving = FALSE;
	_tmp0_ = self->priv->opponent_engine;
	if (_tmp0_ != NULL) {
		ChessEngine* _tmp1_;
		_tmp1_ = self->priv->opponent_engine;
		chess_engine_stop (_tmp1_, TRUE);
	}
	_tmp2_ = g_strdup ("");
	title = _tmp2_;
	_tmp3_ = self->priv->game;
	_tmp4_ = _tmp3_->result;
	switch (_tmp4_) {
		case CHESS_RESULT_WHITE_WON:
		{
			gchar* _tmp5_;
			PGNGame* _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = g_strdup (_ ("White Wins"));
			_g_free0 (title);
			title = _tmp5_;
			_tmp6_ = self->priv->pgn_game;
			_tmp7_ = pgn_game_RESULT_WHITE;
			pgn_game_set_result (_tmp6_, _tmp7_);
			break;
		}
		case CHESS_RESULT_BLACK_WON:
		{
			gchar* _tmp8_;
			PGNGame* _tmp9_;
			const gchar* _tmp10_;
			_tmp8_ = g_strdup (_ ("Black Wins"));
			_g_free0 (title);
			title = _tmp8_;
			_tmp9_ = self->priv->pgn_game;
			_tmp10_ = pgn_game_RESULT_BLACK;
			pgn_game_set_result (_tmp9_, _tmp10_);
			break;
		}
		case CHESS_RESULT_DRAW:
		{
			gchar* _tmp11_;
			PGNGame* _tmp12_;
			const gchar* _tmp13_;
			_tmp11_ = g_strdup (_ ("Game is Drawn"));
			_g_free0 (title);
			title = _tmp11_;
			_tmp12_ = self->priv->pgn_game;
			_tmp13_ = pgn_game_RESULT_DRAW;
			pgn_game_set_result (_tmp12_, _tmp13_);
			break;
		}
		case CHESS_RESULT_BUG:
		{
			gchar* _tmp14_;
			_tmp14_ = g_strdup (_ ("Oops! Something has gone wrong."));
			_g_free0 (title);
			title = _tmp14_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp15_ = g_strdup ("");
	reason = _tmp15_;
	_tmp16_ = self->priv->game;
	_tmp17_ = _tmp16_->rule;
	switch (_tmp17_) {
		case CHESS_RULE_CHECKMATE:
		{
			ChessGame* _tmp18_;
			ChessResult _tmp19_;
			_tmp18_ = self->priv->game;
			_tmp19_ = _tmp18_->result;
			if (_tmp19_ == CHESS_RESULT_WHITE_WON) {
				gchar* _tmp20_;
				_tmp20_ = g_strdup (_ ("Black is in check and cannot move."));
				_g_free0 (reason);
				reason = _tmp20_;
			} else {
				ChessGame* _tmp21_;
				ChessResult _tmp22_;
				_tmp21_ = self->priv->game;
				_tmp22_ = _tmp21_->result;
				if (_tmp22_ == CHESS_RESULT_BLACK_WON) {
					gchar* _tmp23_;
					_tmp23_ = g_strdup (_ ("White is in check and cannot move."));
					_g_free0 (reason);
					reason = _tmp23_;
				} else {
					g_assert_not_reached ();
				}
			}
			break;
		}
		case CHESS_RULE_STALEMATE:
		{
			gchar* _tmp24_;
			_tmp24_ = g_strdup (_ ("Opponent cannot move."));
			_g_free0 (reason);
			reason = _tmp24_;
			break;
		}
		case CHESS_RULE_FIFTY_MOVES:
		{
			gchar* _tmp25_;
			_tmp25_ = g_strdup (_ ("No piece was taken or pawn moved in fifty moves."));
			_g_free0 (reason);
			reason = _tmp25_;
			break;
		}
		case CHESS_RULE_SEVENTY_FIVE_MOVES:
		{
			gchar* _tmp26_;
			_tmp26_ = g_strdup (_ ("No piece was taken or pawn moved in 75 moves."));
			_g_free0 (reason);
			reason = _tmp26_;
			break;
		}
		case CHESS_RULE_TIMEOUT:
		{
			ChessGame* _tmp27_;
			ChessResult _tmp28_;
			_tmp27_ = self->priv->game;
			_tmp28_ = _tmp27_->result;
			if (_tmp28_ == CHESS_RESULT_WHITE_WON) {
				gchar* _tmp29_;
				_tmp29_ = g_strdup (_ ("Black has run out of time."));
				_g_free0 (reason);
				reason = _tmp29_;
			} else {
				ChessGame* _tmp30_;
				ChessResult _tmp31_;
				_tmp30_ = self->priv->game;
				_tmp31_ = _tmp30_->result;
				if (_tmp31_ == CHESS_RESULT_BLACK_WON) {
					gchar* _tmp32_;
					_tmp32_ = g_strdup (_ ("White has run out of time."));
					_g_free0 (reason);
					reason = _tmp32_;
				} else {
					g_assert_not_reached ();
				}
			}
			break;
		}
		case CHESS_RULE_THREE_FOLD_REPETITION:
		{
			gchar* _tmp33_;
			_tmp33_ = g_strdup (_ ("The same board state has occurred three times."));
			_g_free0 (reason);
			reason = _tmp33_;
			break;
		}
		case CHESS_RULE_FIVE_FOLD_REPETITION:
		{
			gchar* _tmp34_;
			_tmp34_ = g_strdup (_ ("The same board state has occurred five times."));
			_g_free0 (reason);
			reason = _tmp34_;
			break;
		}
		case CHESS_RULE_INSUFFICIENT_MATERIAL:
		{
			gchar* _tmp35_;
			_tmp35_ = g_strdup (_ ("Neither player can checkmate."));
			_g_free0 (reason);
			reason = _tmp35_;
			break;
		}
		case CHESS_RULE_RESIGN:
		{
			ChessGame* _tmp36_;
			ChessResult _tmp37_;
			_tmp36_ = self->priv->game;
			_tmp37_ = _tmp36_->result;
			if (_tmp37_ == CHESS_RESULT_WHITE_WON) {
				gchar* _tmp38_;
				_tmp38_ = g_strdup (_ ("Black has resigned."));
				_g_free0 (reason);
				reason = _tmp38_;
			} else {
				ChessGame* _tmp39_;
				ChessResult _tmp40_;
				_tmp39_ = self->priv->game;
				_tmp40_ = _tmp39_->result;
				if (_tmp40_ == CHESS_RESULT_BLACK_WON) {
					gchar* _tmp41_;
					_tmp41_ = g_strdup (_ ("White has resigned."));
					_g_free0 (reason);
					reason = _tmp41_;
				} else {
					g_assert_not_reached ();
				}
			}
			break;
		}
		case CHESS_RULE_ABANDONMENT:
		{
			gchar* _tmp42_;
			PGNGame* _tmp43_;
			const gchar* _tmp44_;
			_tmp42_ = g_strdup (_ ("The game has been abandoned."));
			_g_free0 (reason);
			reason = _tmp42_;
			_tmp43_ = self->priv->pgn_game;
			_tmp44_ = pgn_game_TERMINATE_ABANDONED;
			pgn_game_set_termination (_tmp43_, _tmp44_);
			break;
		}
		case CHESS_RULE_DEATH:
		{
			gchar* _tmp45_;
			PGNGame* _tmp46_;
			const gchar* _tmp47_;
			_tmp45_ = g_strdup (_ ("The game log says a player died!"));
			_g_free0 (reason);
			reason = _tmp45_;
			_tmp46_ = self->priv->pgn_game;
			_tmp47_ = pgn_game_TERMINATE_DEATH;
			pgn_game_set_termination (_tmp46_, _tmp47_);
			break;
		}
		case CHESS_RULE_BUG:
		{
			gchar* _tmp48_;
			_tmp48_ = g_strdup (_ ("The computer player is confused. The game cannot continue."));
			_g_free0 (reason);
			reason = _tmp48_;
			break;
		}
		case CHESS_RULE_UNKNOWN:
		{
			GFile* _tmp49_;
			gchar* _tmp50_;
			_tmp49_ = self->priv->game_file;
			_tmp50_ = g_file_get_basename (_tmp49_);
			_g_free0 (reason);
			reason = _tmp50_;
			break;
		}
		default:
		break;
	}
	_tmp51_ = self->priv->headerbar;
	_tmp52_ = title;
	gtk_header_bar_set_title (_tmp51_, _tmp52_);
	_tmp53_ = self->priv->headerbar;
	_tmp54_ = reason;
	gtk_header_bar_set_subtitle (_tmp53_, _tmp54_);
	_tmp55_ = self->priv->white_time_label;
	gtk_widget_queue_draw (_tmp55_);
	_tmp56_ = self->priv->black_time_label;
	gtk_widget_queue_draw (_tmp56_);
	_g_free0 (reason);
	_g_free0 (title);
}


gboolean gnome_chess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	chess_application_quit_game (self);
	result = FALSE;
	return result;
}


static gboolean chess_application_prompt_save_game (ChessApplication* self, const gchar* prompt_text) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp1_;
	const gchar* _tmp2_;
	GtkMessageDialog* _tmp3_;
	GtkMessageDialog* _tmp4_;
	ChessGame* _tmp5_;
	ChessResult _tmp6_;
	gint _result_ = 0;
	GtkMessageDialog* _tmp11_;
	gint _tmp12_;
	GtkMessageDialog* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (prompt_text != NULL, FALSE);
	_tmp0_ = self->priv->game_needs_saving;
	if (!_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->window;
	_tmp2_ = prompt_text;
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp1_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp2_);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp4_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp5_ = self->priv->game;
	_tmp6_ = _tmp5_->result;
	if (_tmp6_ == CHESS_RESULT_IN_PROGRESS) {
		GtkMessageDialog* _tmp7_;
		GtkMessageDialog* _tmp8_;
		_tmp7_ = dialog;
		gtk_dialog_add_button ((GtkDialog*) _tmp7_, _ ("_Abandon game"), (gint) GTK_RESPONSE_NO);
		_tmp8_ = dialog;
		gtk_dialog_add_button ((GtkDialog*) _tmp8_, _ ("_Save game for later"), (gint) GTK_RESPONSE_YES);
	} else {
		GtkMessageDialog* _tmp9_;
		GtkMessageDialog* _tmp10_;
		_tmp9_ = dialog;
		gtk_dialog_add_button ((GtkDialog*) _tmp9_, _ ("_Discard game"), (gint) GTK_RESPONSE_NO);
		_tmp10_ = dialog;
		gtk_dialog_add_button ((GtkDialog*) _tmp10_, _ ("_Save game log"), (gint) GTK_RESPONSE_YES);
	}
	_tmp11_ = dialog;
	_tmp12_ = gtk_dialog_run ((GtkDialog*) _tmp11_);
	_result_ = _tmp12_;
	_tmp13_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
	_tmp15_ = _result_;
	if (_tmp15_ == ((gint) GTK_RESPONSE_CANCEL)) {
		_tmp14_ = TRUE;
	} else {
		gint _tmp16_;
		_tmp16_ = _result_;
		_tmp14_ = _tmp16_ == ((gint) GTK_RESPONSE_DELETE_EVENT);
	}
	if (_tmp14_) {
		result = FALSE;
		_g_object_unref0 (dialog);
		return result;
	} else {
		gint _tmp17_;
		_tmp17_ = _result_;
		if (_tmp17_ == ((gint) GTK_RESPONSE_YES)) {
			chess_application_present_save_dialog (self, _ ("_Discard"), _ ("_Save"));
		} else {
			gint _tmp18_;
			_tmp18_ = _result_;
			g_warn_if_fail (_tmp18_ == ((gint) GTK_RESPONSE_NO));
			self->priv->game_needs_saving = FALSE;
			chess_application_autosave (self);
		}
	}
	result = TRUE;
	_g_object_unref0 (dialog);
	return result;
}


static void chess_application_present_claim_draw_dialog (ChessApplication* self) {
	ChessGame* _tmp0_;
	gboolean _tmp1_;
	ChessGame* _tmp2_;
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp3_;
	GtkMessageDialog* _tmp4_;
	gchar* reason = NULL;
	ChessGame* _tmp5_;
	gboolean _tmp6_;
	GtkMessageDialog* _tmp11_;
	const gchar* _tmp12_;
	GtkMessageDialog* _tmp13_;
	gint response = 0;
	GtkMessageDialog* _tmp14_;
	gint _tmp15_;
	GtkMessageDialog* _tmp16_;
	gint _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_can_claim_draw (_tmp0_);
	_vala_return_if_fail (_tmp1_, "game.can_claim_draw ()");
	_tmp2_ = self->priv->game;
	chess_game_pause (_tmp2_, FALSE);
	_tmp3_ = self->priv->window;
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp3_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Would you like to claim a draw?"));
	g_object_ref_sink (_tmp4_);
	dialog = _tmp4_;
	_tmp5_ = self->priv->game;
	_tmp6_ = chess_game_is_fifty_move_rule_fulfilled (_tmp5_);
	if (_tmp6_) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (_ ("Fifty moves have passed without a capture or pawn advancement."));
		_g_free0 (reason);
		reason = _tmp7_;
	} else {
		ChessGame* _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = self->priv->game;
		_tmp9_ = chess_game_is_three_fold_repeat (_tmp8_);
		if (_tmp9_) {
			gchar* _tmp10_;
			_tmp10_ = g_strdup (_ ("The current board position has occurred three times."));
			_g_free0 (reason);
			reason = _tmp10_;
		} else {
			g_assert_not_reached ();
		}
	}
	_tmp11_ = dialog;
	_tmp12_ = reason;
	g_object_set (_tmp11_, "secondary-text", _tmp12_, NULL);
	_tmp13_ = dialog;
	gtk_dialog_add_buttons ((GtkDialog*) _tmp13_, _ ("_Keep Playing"), GTK_RESPONSE_REJECT, _ ("_Claim Draw"), GTK_RESPONSE_ACCEPT, NULL, NULL);
	_tmp14_ = dialog;
	_tmp15_ = gtk_dialog_run ((GtkDialog*) _tmp14_);
	response = _tmp15_;
	_tmp16_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp16_);
	_tmp17_ = response;
	if (_tmp17_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		ChessGame* _tmp18_;
		ChessPlayer* _tmp19_;
		ChessPlayer* _tmp20_;
		_tmp18_ = self->priv->game;
		_tmp19_ = chess_game_get_current_player (_tmp18_);
		_tmp20_ = _tmp19_;
		chess_player_claim_draw (_tmp20_);
	} else {
		ChessGame* _tmp21_;
		_tmp21_ = self->priv->game;
		chess_game_unpause (_tmp21_);
	}
	_g_free0 (reason);
	_g_object_unref0 (dialog);
}


void chess_application_new_game_cb (ChessApplication* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_application_prompt_save_game (self, _ ("Save this game before starting a new one?"));
	if (_tmp0_) {
		chess_application_start_new_game (self);
	}
}


void chess_application_resign_cb (ChessApplication* self) {
	ChessGame* _tmp0_;
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkMessageDialog* _tmp3_;
	GtkMessageDialog* _tmp4_;
	gint response = 0;
	GtkMessageDialog* _tmp5_;
	gint _tmp6_;
	GtkMessageDialog* _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	chess_game_pause (_tmp0_, FALSE);
	_tmp1_ = self->priv->window;
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp1_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Are you sure you want to resign?"));
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	_tmp3_ = dialog;
	gtk_message_dialog_format_secondary_text (_tmp3_, "%s", _ ("This makes sense if you plan to save the game as a record of your loss" \
"."));
	_tmp4_ = dialog;
	gtk_dialog_add_buttons ((GtkDialog*) _tmp4_, _ ("_Keep Playing"), GTK_RESPONSE_REJECT, _ ("_Resign"), GTK_RESPONSE_ACCEPT, NULL, NULL);
	_tmp5_ = dialog;
	_tmp6_ = gtk_dialog_run ((GtkDialog*) _tmp5_);
	response = _tmp6_;
	_tmp7_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp7_);
	_tmp8_ = response;
	if (_tmp8_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		ChessPlayer* _tmp9_;
		_tmp9_ = self->priv->human_player;
		if (_tmp9_ != NULL) {
			ChessPlayer* _tmp10_;
			_tmp10_ = self->priv->human_player;
			chess_player_resign (_tmp10_);
		} else {
			ChessGame* _tmp11_;
			ChessPlayer* _tmp12_;
			ChessPlayer* _tmp13_;
			_tmp11_ = self->priv->game;
			_tmp12_ = chess_game_get_current_player (_tmp11_);
			_tmp13_ = _tmp12_;
			chess_player_resign (_tmp13_);
		}
	} else {
		ChessGame* _tmp14_;
		_tmp14_ = self->priv->game;
		chess_game_unpause (_tmp14_);
	}
	_g_object_unref0 (dialog);
}


void chess_application_undo_move_cb (ChessApplication* self) {
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	ChessPlayer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scene;
	_tmp0_->selected_rank = -1;
	_tmp1_ = self->priv->scene;
	_tmp1_->selected_file = -1;
	_tmp2_ = self->priv->opponent;
	if (_tmp2_ != NULL) {
		ChessPlayer* _tmp3_;
		_tmp3_ = self->priv->human_player;
		chess_player_undo (_tmp3_);
	} else {
		ChessGame* _tmp4_;
		ChessPlayer* _tmp5_;
		ChessPlayer* _tmp6_;
		_tmp4_ = self->priv->game;
		_tmp5_ = chess_game_get_opponent (_tmp4_);
		_tmp6_ = _tmp5_;
		chess_player_undo (_tmp6_);
	}
}


void chess_application_pause_resume_cb (ChessApplication* self) {
	ChessGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ChessGame* _tmp3_;
		_tmp3_ = self->priv->game;
		chess_game_unpause (_tmp3_);
	} else {
		ChessGame* _tmp4_;
		_tmp4_ = self->priv->game;
		chess_game_pause (_tmp4_, TRUE);
	}
	chess_application_update_pause_resume_button (self);
	chess_application_update_history_panel (self);
	chess_application_update_action_status (self);
}


void chess_application_quit_cb (ChessApplication* self) {
	g_return_if_fail (self != NULL);
	chess_application_quit_game (self);
}


gboolean white_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self) {
	gboolean result = FALSE;
	gdouble fg[3] = {0};
	gdouble _tmp0_[3];
	gdouble bg[3] = {0};
	gdouble _tmp1_[3];
	GtkWidget* _tmp2_;
	cairo_t* _tmp3_;
	ChessGame* _tmp4_;
	ChessClock* _tmp5_;
	ChessClock* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_[0] = 0.0;
	_tmp0_[1] = 0.0;
	_tmp0_[2] = 0.0;
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
	_tmp1_[0] = 1.0;
	_tmp1_[1] = 1.0;
	_tmp1_[2] = 1.0;
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
	_tmp2_ = widget;
	_tmp3_ = c;
	_tmp4_ = self->priv->game;
	_tmp5_ = chess_game_get_clock (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = chess_application_make_clock_text (self, _tmp6_, COLOR_WHITE);
	_tmp8_ = _tmp7_;
	chess_application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
	_g_free0 (_tmp8_);
	result = FALSE;
	return result;
}


gboolean black_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self) {
	gboolean result = FALSE;
	gdouble fg[3] = {0};
	gdouble _tmp0_[3];
	gdouble bg[3] = {0};
	gdouble _tmp1_[3];
	GtkWidget* _tmp2_;
	cairo_t* _tmp3_;
	ChessGame* _tmp4_;
	ChessClock* _tmp5_;
	ChessClock* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_[0] = 1.0;
	_tmp0_[1] = 1.0;
	_tmp0_[2] = 1.0;
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
	_tmp1_[0] = 0.0;
	_tmp1_[1] = 0.0;
	_tmp1_[2] = 0.0;
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
	_tmp2_ = widget;
	_tmp3_ = c;
	_tmp4_ = self->priv->game;
	_tmp5_ = chess_game_get_clock (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = chess_application_make_clock_text (self, _tmp6_, COLOR_BLACK);
	_tmp8_ = _tmp7_;
	chess_application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
	_g_free0 (_tmp8_);
	result = FALSE;
	return result;
}


static gchar* chess_application_make_clock_text (ChessApplication* self, ChessClock* clock, Color color) {
	gchar* result = NULL;
	ChessClock* _tmp0_;
	gint time = 0;
	Color _tmp2_;
	gint _tmp33_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clock;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("∞");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = color;
	if (_tmp2_ == COLOR_WHITE) {
		ChessGame* _tmp3_;
		ChessClock* _tmp4_;
		ChessClock* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		ChessGame* _tmp8_;
		ChessClock* _tmp9_;
		ChessClock* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		ChessGame* _tmp13_;
		ChessClock* _tmp14_;
		ChessClock* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp3_ = self->priv->game;
		_tmp4_ = chess_game_get_clock (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = chess_clock_get_white_initial_seconds (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->game;
		_tmp9_ = chess_game_get_clock (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = chess_clock_get_white_seconds_used (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->game;
		_tmp14_ = chess_game_get_clock (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = chess_clock_get_white_extra_seconds (_tmp15_);
		_tmp17_ = _tmp16_;
		time = (_tmp7_ - _tmp12_) + _tmp17_;
	} else {
		ChessGame* _tmp18_;
		ChessClock* _tmp19_;
		ChessClock* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		ChessGame* _tmp23_;
		ChessClock* _tmp24_;
		ChessClock* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		ChessGame* _tmp28_;
		ChessClock* _tmp29_;
		ChessClock* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		_tmp18_ = self->priv->game;
		_tmp19_ = chess_game_get_clock (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = chess_clock_get_black_initial_seconds (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->game;
		_tmp24_ = chess_game_get_clock (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = chess_clock_get_black_seconds_used (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = self->priv->game;
		_tmp29_ = chess_game_get_clock (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = chess_clock_get_black_extra_seconds (_tmp30_);
		_tmp32_ = _tmp31_;
		time = (_tmp22_ - _tmp27_) + _tmp32_;
	}
	_tmp33_ = time;
	if (_tmp33_ >= 60) {
		gint _tmp34_;
		gint _tmp35_;
		gchar* _tmp36_;
		_tmp34_ = time;
		_tmp35_ = time;
		_tmp36_ = g_strdup_printf ("%d∶\xE2\x80\x8E%02d", _tmp34_ / 60, _tmp35_ % 60);
		result = _tmp36_;
		return result;
	} else {
		gint _tmp37_;
		gchar* _tmp38_;
		_tmp37_ = time;
		_tmp38_ = g_strdup_printf ("∶\xE2\x80\x8E%02d", _tmp37_);
		result = _tmp38_;
		return result;
	}
}


static gint chess_application_compute_time_label_width_request (ChessApplication* self, cairo_t* c) {
	gint result = 0;
	cairo_text_extents_t extents = {0};
	gdouble max = 0.0;
	cairo_t* _tmp0_;
	cairo_text_extents_t _tmp1_ = {0};
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_;
	cairo_text_extents_t _tmp4_;
	gdouble _tmp5_;
	cairo_t* _tmp9_;
	cairo_text_extents_t _tmp10_ = {0};
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_;
	cairo_text_extents_t _tmp13_;
	gdouble _tmp14_;
	cairo_t* _tmp18_;
	cairo_text_extents_t _tmp19_ = {0};
	gdouble _tmp20_ = 0.0;
	gdouble _tmp21_;
	cairo_text_extents_t _tmp22_;
	gdouble _tmp23_;
	cairo_t* _tmp27_;
	cairo_text_extents_t _tmp28_ = {0};
	gdouble _tmp29_ = 0.0;
	gdouble _tmp30_;
	cairo_text_extents_t _tmp31_;
	gdouble _tmp32_;
	cairo_t* _tmp36_;
	cairo_text_extents_t _tmp37_ = {0};
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_;
	cairo_text_extents_t _tmp40_;
	gdouble _tmp41_;
	cairo_t* _tmp45_;
	cairo_text_extents_t _tmp46_ = {0};
	gdouble _tmp47_ = 0.0;
	gdouble _tmp48_;
	cairo_text_extents_t _tmp49_;
	gdouble _tmp50_;
	cairo_t* _tmp54_;
	cairo_text_extents_t _tmp55_ = {0};
	gdouble _tmp56_ = 0.0;
	gdouble _tmp57_;
	cairo_text_extents_t _tmp58_;
	gdouble _tmp59_;
	cairo_t* _tmp63_;
	cairo_text_extents_t _tmp64_ = {0};
	gdouble _tmp65_ = 0.0;
	gdouble _tmp66_;
	cairo_text_extents_t _tmp67_;
	gdouble _tmp68_;
	cairo_t* _tmp72_;
	cairo_text_extents_t _tmp73_ = {0};
	gdouble _tmp74_ = 0.0;
	gdouble _tmp75_;
	cairo_text_extents_t _tmp76_;
	gdouble _tmp77_;
	cairo_t* _tmp81_;
	cairo_text_extents_t _tmp82_ = {0};
	gdouble _tmp83_ = 0.0;
	gdouble _tmp84_;
	cairo_text_extents_t _tmp85_;
	gdouble _tmp86_;
	gdouble _tmp90_;
	gdouble _tmp91_;
	gint _tmp92_;
	gint _tmp93_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (c != NULL, 0);
	max = (gdouble) 0;
	_tmp0_ = c;
	cairo_text_extents (_tmp0_, "000∶00", &_tmp1_);
	extents = _tmp1_;
	_tmp3_ = max;
	_tmp4_ = extents;
	_tmp5_ = _tmp4_.width;
	if (_tmp3_ > _tmp5_) {
		gdouble _tmp6_;
		_tmp6_ = max;
		_tmp2_ = _tmp6_;
	} else {
		cairo_text_extents_t _tmp7_;
		gdouble _tmp8_;
		_tmp7_ = extents;
		_tmp8_ = _tmp7_.width;
		_tmp2_ = _tmp8_;
	}
	max = _tmp2_;
	_tmp9_ = c;
	cairo_text_extents (_tmp9_, "111∶11", &_tmp10_);
	extents = _tmp10_;
	_tmp12_ = max;
	_tmp13_ = extents;
	_tmp14_ = _tmp13_.width;
	if (_tmp12_ > _tmp14_) {
		gdouble _tmp15_;
		_tmp15_ = max;
		_tmp11_ = _tmp15_;
	} else {
		cairo_text_extents_t _tmp16_;
		gdouble _tmp17_;
		_tmp16_ = extents;
		_tmp17_ = _tmp16_.width;
		_tmp11_ = _tmp17_;
	}
	max = _tmp11_;
	_tmp18_ = c;
	cairo_text_extents (_tmp18_, "222∶22", &_tmp19_);
	extents = _tmp19_;
	_tmp21_ = max;
	_tmp22_ = extents;
	_tmp23_ = _tmp22_.width;
	if (_tmp21_ > _tmp23_) {
		gdouble _tmp24_;
		_tmp24_ = max;
		_tmp20_ = _tmp24_;
	} else {
		cairo_text_extents_t _tmp25_;
		gdouble _tmp26_;
		_tmp25_ = extents;
		_tmp26_ = _tmp25_.width;
		_tmp20_ = _tmp26_;
	}
	max = _tmp20_;
	_tmp27_ = c;
	cairo_text_extents (_tmp27_, "333∶33", &_tmp28_);
	extents = _tmp28_;
	_tmp30_ = max;
	_tmp31_ = extents;
	_tmp32_ = _tmp31_.width;
	if (_tmp30_ > _tmp32_) {
		gdouble _tmp33_;
		_tmp33_ = max;
		_tmp29_ = _tmp33_;
	} else {
		cairo_text_extents_t _tmp34_;
		gdouble _tmp35_;
		_tmp34_ = extents;
		_tmp35_ = _tmp34_.width;
		_tmp29_ = _tmp35_;
	}
	max = _tmp29_;
	_tmp36_ = c;
	cairo_text_extents (_tmp36_, "444∶44", &_tmp37_);
	extents = _tmp37_;
	_tmp39_ = max;
	_tmp40_ = extents;
	_tmp41_ = _tmp40_.width;
	if (_tmp39_ > _tmp41_) {
		gdouble _tmp42_;
		_tmp42_ = max;
		_tmp38_ = _tmp42_;
	} else {
		cairo_text_extents_t _tmp43_;
		gdouble _tmp44_;
		_tmp43_ = extents;
		_tmp44_ = _tmp43_.width;
		_tmp38_ = _tmp44_;
	}
	max = _tmp38_;
	_tmp45_ = c;
	cairo_text_extents (_tmp45_, "555∶55", &_tmp46_);
	extents = _tmp46_;
	_tmp48_ = max;
	_tmp49_ = extents;
	_tmp50_ = _tmp49_.width;
	if (_tmp48_ > _tmp50_) {
		gdouble _tmp51_;
		_tmp51_ = max;
		_tmp47_ = _tmp51_;
	} else {
		cairo_text_extents_t _tmp52_;
		gdouble _tmp53_;
		_tmp52_ = extents;
		_tmp53_ = _tmp52_.width;
		_tmp47_ = _tmp53_;
	}
	max = _tmp47_;
	_tmp54_ = c;
	cairo_text_extents (_tmp54_, "666∶66", &_tmp55_);
	extents = _tmp55_;
	_tmp57_ = max;
	_tmp58_ = extents;
	_tmp59_ = _tmp58_.width;
	if (_tmp57_ > _tmp59_) {
		gdouble _tmp60_;
		_tmp60_ = max;
		_tmp56_ = _tmp60_;
	} else {
		cairo_text_extents_t _tmp61_;
		gdouble _tmp62_;
		_tmp61_ = extents;
		_tmp62_ = _tmp61_.width;
		_tmp56_ = _tmp62_;
	}
	max = _tmp56_;
	_tmp63_ = c;
	cairo_text_extents (_tmp63_, "777∶77", &_tmp64_);
	extents = _tmp64_;
	_tmp66_ = max;
	_tmp67_ = extents;
	_tmp68_ = _tmp67_.width;
	if (_tmp66_ > _tmp68_) {
		gdouble _tmp69_;
		_tmp69_ = max;
		_tmp65_ = _tmp69_;
	} else {
		cairo_text_extents_t _tmp70_;
		gdouble _tmp71_;
		_tmp70_ = extents;
		_tmp71_ = _tmp70_.width;
		_tmp65_ = _tmp71_;
	}
	max = _tmp65_;
	_tmp72_ = c;
	cairo_text_extents (_tmp72_, "888∶88", &_tmp73_);
	extents = _tmp73_;
	_tmp75_ = max;
	_tmp76_ = extents;
	_tmp77_ = _tmp76_.width;
	if (_tmp75_ > _tmp77_) {
		gdouble _tmp78_;
		_tmp78_ = max;
		_tmp74_ = _tmp78_;
	} else {
		cairo_text_extents_t _tmp79_;
		gdouble _tmp80_;
		_tmp79_ = extents;
		_tmp80_ = _tmp79_.width;
		_tmp74_ = _tmp80_;
	}
	max = _tmp74_;
	_tmp81_ = c;
	cairo_text_extents (_tmp81_, "999∶99", &_tmp82_);
	extents = _tmp82_;
	_tmp84_ = max;
	_tmp85_ = extents;
	_tmp86_ = _tmp85_.width;
	if (_tmp84_ > _tmp86_) {
		gdouble _tmp87_;
		_tmp87_ = max;
		_tmp83_ = _tmp87_;
	} else {
		cairo_text_extents_t _tmp88_;
		gdouble _tmp89_;
		_tmp88_ = extents;
		_tmp89_ = _tmp88_.width;
		_tmp83_ = _tmp89_;
	}
	max = _tmp83_;
	_tmp90_ = max;
	_tmp91_ = ceil (_tmp90_);
	result = ((gint) _tmp91_) + 6;
	_tmp92_ = result;
	_vala_warn_if_fail (_tmp92_ > 0, "result > 0");
	return result;
}


static void chess_application_draw_time (ChessApplication* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1) {
	gdouble alpha = 0.0;
	GtkWidget* _tmp0_;
	GtkStateFlags _tmp1_;
	cairo_t* _tmp2_;
	gdouble* _tmp3_;
	gint _tmp3__length1;
	gdouble _tmp4_;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gdouble _tmp6_;
	gdouble* _tmp7_;
	gint _tmp7__length1;
	gdouble _tmp8_;
	gdouble _tmp9_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	gdouble* _tmp12_;
	gint _tmp12__length1;
	gdouble _tmp13_;
	gdouble* _tmp14_;
	gint _tmp14__length1;
	gdouble _tmp15_;
	gdouble* _tmp16_;
	gint _tmp16__length1;
	gdouble _tmp17_;
	gdouble _tmp18_;
	cairo_t* _tmp19_;
	cairo_t* _tmp20_;
	GtkWidget* _tmp21_;
	gint _tmp22_;
	cairo_text_extents_t extents = {0};
	cairo_t* _tmp23_;
	const gchar* _tmp24_;
	cairo_text_extents_t _tmp25_ = {0};
	cairo_t* _tmp26_;
	GtkWidget* _tmp27_;
	gint _tmp28_;
	cairo_text_extents_t _tmp29_;
	gdouble _tmp30_;
	cairo_text_extents_t _tmp31_;
	gdouble _tmp32_;
	GtkWidget* _tmp33_;
	gint _tmp34_;
	cairo_text_extents_t _tmp35_;
	gdouble _tmp36_;
	cairo_text_extents_t _tmp37_;
	gdouble _tmp38_;
	cairo_t* _tmp39_;
	const gchar* _tmp40_;
	gint width = 0;
	GtkWidget* _tmp41_;
	gint _tmp42_ = 0;
	gint _tmp43_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (text != NULL);
	alpha = 1.0;
	_tmp0_ = widget;
	_tmp1_ = gtk_widget_get_state_flags (_tmp0_);
	if ((_tmp1_ & GTK_STATE_FLAG_INSENSITIVE) != 0) {
		alpha = 0.5;
	}
	_tmp2_ = c;
	_tmp3_ = bg;
	_tmp3__length1 = bg_length1;
	_tmp4_ = _tmp3_[0];
	_tmp5_ = bg;
	_tmp5__length1 = bg_length1;
	_tmp6_ = _tmp5_[1];
	_tmp7_ = bg;
	_tmp7__length1 = bg_length1;
	_tmp8_ = _tmp7_[2];
	_tmp9_ = alpha;
	cairo_set_source_rgba (_tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp9_);
	_tmp10_ = c;
	cairo_paint (_tmp10_);
	_tmp11_ = c;
	_tmp12_ = fg;
	_tmp12__length1 = fg_length1;
	_tmp13_ = _tmp12_[0];
	_tmp14_ = fg;
	_tmp14__length1 = fg_length1;
	_tmp15_ = _tmp14_[1];
	_tmp16_ = fg;
	_tmp16__length1 = fg_length1;
	_tmp17_ = _tmp16_[2];
	_tmp18_ = alpha;
	cairo_set_source_rgba (_tmp11_, _tmp13_, _tmp15_, _tmp17_, _tmp18_);
	_tmp19_ = c;
	cairo_select_font_face (_tmp19_, "fixed", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	_tmp20_ = c;
	_tmp21_ = widget;
	_tmp22_ = gtk_widget_get_allocated_height (_tmp21_);
	cairo_set_font_size (_tmp20_, 0.6 * _tmp22_);
	_tmp23_ = c;
	_tmp24_ = text;
	cairo_text_extents (_tmp23_, _tmp24_, &_tmp25_);
	extents = _tmp25_;
	_tmp26_ = c;
	_tmp27_ = widget;
	_tmp28_ = gtk_widget_get_allocated_width (_tmp27_);
	_tmp29_ = extents;
	_tmp30_ = _tmp29_.width;
	_tmp31_ = extents;
	_tmp32_ = _tmp31_.x_bearing;
	_tmp33_ = widget;
	_tmp34_ = gtk_widget_get_allocated_height (_tmp33_);
	_tmp35_ = extents;
	_tmp36_ = _tmp35_.height;
	_tmp37_ = extents;
	_tmp38_ = _tmp37_.y_bearing;
	cairo_move_to (_tmp26_, ((_tmp28_ - _tmp30_) / 2) - _tmp32_, ((_tmp34_ - _tmp36_) / 2) - _tmp38_);
	_tmp39_ = c;
	_tmp40_ = text;
	cairo_show_text (_tmp39_, _tmp40_);
	_tmp41_ = widget;
	gtk_widget_get_size_request (_tmp41_, &_tmp42_, NULL);
	width = _tmp42_;
	_tmp43_ = width;
	if (_tmp43_ == -1) {
		GtkWidget* _tmp44_;
		cairo_t* _tmp45_;
		gint _tmp46_;
		_tmp44_ = widget;
		_tmp45_ = c;
		_tmp46_ = chess_application_compute_time_label_width_request (self, _tmp45_);
		gtk_widget_set_size_request (_tmp44_, _tmp46_, -1);
	}
}


void history_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gint move_number = 0;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	gboolean _tmp7_ = FALSE;
	ChessGame* _tmp8_;
	ChessScene* _tmp13_;
	gint _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &move_number, -1, -1);
	_tmp8_ = self->priv->game;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		gint _tmp9_;
		ChessGame* _tmp10_;
		guint _tmp11_;
		guint _tmp12_;
		_tmp9_ = move_number;
		_tmp10_ = self->priv->game;
		_tmp11_ = chess_game_get_n_moves (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp7_ = ((guint) _tmp9_) == _tmp12_;
	}
	if (_tmp7_) {
		move_number = -1;
	}
	_tmp13_ = self->priv->scene;
	_tmp14_ = move_number;
	chess_scene_set_move_number (_tmp13_, _tmp14_);
}


void history_latest_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	chess_scene_set_move_number (_tmp0_, -1);
}


void history_next_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint move_number = 0;
	ChessScene* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ChessGame* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == -1) {
		return;
	}
	_tmp3_ = self->priv->scene;
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
	_tmp5_ = _tmp4_;
	move_number = _tmp5_ + 1;
	_tmp6_ = move_number;
	_tmp7_ = self->priv->game;
	_tmp8_ = chess_game_get_n_moves (_tmp7_);
	_tmp9_ = _tmp8_;
	if (((guint) _tmp6_) >= _tmp9_) {
		ChessScene* _tmp10_;
		_tmp10_ = self->priv->scene;
		chess_scene_set_move_number (_tmp10_, -1);
	} else {
		ChessScene* _tmp11_;
		gint _tmp12_;
		_tmp11_ = self->priv->scene;
		_tmp12_ = move_number;
		chess_scene_set_move_number (_tmp11_, _tmp12_);
	}
}


void history_previous_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ChessScene* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = self->priv->scene;
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == -1) {
		ChessScene* _tmp6_;
		ChessGame* _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
		_tmp6_ = self->priv->scene;
		_tmp7_ = self->priv->game;
		_tmp8_ = chess_game_get_n_moves (_tmp7_);
		_tmp9_ = _tmp8_;
		chess_scene_set_move_number (_tmp6_, ((gint) _tmp9_) - 1);
	} else {
		ChessScene* _tmp10_;
		ChessScene* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp10_ = self->priv->scene;
		_tmp11_ = self->priv->scene;
		_tmp12_ = chess_scene_get_move_number (_tmp11_);
		_tmp13_ = _tmp12_;
		chess_scene_set_move_number (_tmp10_, _tmp13_ - 1);
	}
}


void history_start_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	chess_scene_set_move_number (_tmp0_, 0);
}


void chess_application_preferences_cb (ChessApplication* self) {
	GtkDialog* _tmp0_;
	GtkBuilder* preferences_builder = NULL;
	GtkBuilder* _tmp2_;
	GtkBuilder* _tmp3_;
	GObject* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkApplicationWindow* _tmp7_;
	GSettings* _tmp8_;
	GtkBuilder* _tmp9_;
	GObject* _tmp10_;
	GSettings* _tmp11_;
	GtkBuilder* _tmp12_;
	GObject* _tmp13_;
	GtkBuilder* _tmp14_;
	GObject* _tmp15_;
	GtkComboBox* _tmp16_;
	GtkComboBox* _tmp17_;
	GSettings* _tmp18_;
	gint _tmp19_;
	GtkComboBox* ai_combo = NULL;
	GtkBuilder* _tmp20_;
	GObject* _tmp21_;
	GtkComboBox* _tmp22_;
	GtkListStore* ai_model = NULL;
	GtkComboBox* _tmp23_;
	GtkTreeModel* _tmp24_;
	GtkTreeModel* _tmp25_;
	GtkListStore* _tmp26_;
	gchar* opponent_name = NULL;
	GSettings* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	GList* _tmp31_;
	GtkComboBox* _tmp54_;
	gint _tmp55_;
	GtkBuilder* _tmp58_;
	GObject* _tmp59_;
	GtkComboBox* _tmp60_;
	GtkComboBox* _tmp61_;
	GSettings* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	GtkBuilder* _tmp65_;
	GObject* _tmp66_;
	GtkComboBox* _tmp67_;
	GtkBuilder* _tmp68_;
	GObject* _tmp69_;
	GtkComboBox* _tmp70_;
	GtkBuilder* _tmp71_;
	GObject* _tmp72_;
	GtkAdjustment* _tmp73_;
	GtkBuilder* _tmp74_;
	GObject* _tmp75_;
	GtkAdjustment* _tmp76_;
	GtkBuilder* _tmp77_;
	GObject* _tmp78_;
	GtkBox* _tmp79_;
	GtkBuilder* _tmp80_;
	GObject* _tmp81_;
	GtkBox* _tmp82_;
	GtkBuilder* _tmp83_;
	GObject* _tmp84_;
	GtkComboBox* _tmp85_;
	GSettings* _tmp86_;
	gint _tmp87_;
	GtkBuilder* _tmp88_;
	GObject* _tmp89_;
	GtkWidget* _tmp90_;
	GtkBuilder* _tmp91_;
	GObject* _tmp92_;
	GtkComboBox* _tmp93_;
	PGNGame* _tmp94_;
	const gchar* _tmp95_;
	const gchar* _tmp96_;
	PGNGame* _tmp105_;
	const gchar* _tmp106_;
	const gchar* _tmp107_;
	GtkComboBox* orientation_combo = NULL;
	GtkBuilder* _tmp114_;
	GObject* _tmp115_;
	GtkComboBox* _tmp116_;
	GtkComboBox* _tmp117_;
	GSettings* _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	GtkComboBox* move_combo = NULL;
	GtkBuilder* _tmp121_;
	GObject* _tmp122_;
	GtkComboBox* _tmp123_;
	GtkComboBox* _tmp124_;
	GSettings* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	GtkComboBox* theme_combo = NULL;
	GtkBuilder* _tmp128_;
	GObject* _tmp129_;
	GtkComboBox* _tmp130_;
	GtkComboBox* _tmp131_;
	GSettings* _tmp132_;
	gchar* _tmp133_;
	gchar* _tmp134_;
	GtkBuilder* _tmp135_;
	GtkComboBox* _tmp136_;
	gint _tmp137_;
	GtkDialog* _tmp140_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ != NULL) {
		GtkDialog* _tmp1_;
		_tmp1_ = self->priv->preferences_dialog;
		gtk_dialog_run (_tmp1_);
		return;
	}
	_tmp2_ = gtk_builder_new_from_resource ("/org/gnome/chess/ui/preferences.ui");
	preferences_builder = _tmp2_;
	_tmp3_ = preferences_builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "preferences");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_dialog_get_type (), GtkDialog));
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp5_;
	_tmp6_ = self->priv->preferences_dialog;
	_tmp7_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp6_, (GtkWindow*) _tmp7_);
	_tmp8_ = self->priv->settings;
	_tmp9_ = preferences_builder;
	_tmp10_ = gtk_builder_get_object (_tmp9_, "show_numbering_check");
	g_settings_bind (_tmp8_, "show-numbering", _tmp10_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp11_ = self->priv->settings;
	_tmp12_ = preferences_builder;
	_tmp13_ = gtk_builder_get_object (_tmp12_, "show_move_hints_check");
	g_settings_bind (_tmp11_, "show-move-hints", _tmp13_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp14_ = preferences_builder;
	_tmp15_ = gtk_builder_get_object (_tmp14_, "side_combo");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->side_combo);
	self->priv->side_combo = _tmp16_;
	_tmp17_ = self->priv->side_combo;
	_tmp18_ = self->priv->settings;
	_tmp19_ = g_settings_get_enum (_tmp18_, "play-as");
	gtk_combo_box_set_active (_tmp17_, _tmp19_);
	_tmp20_ = preferences_builder;
	_tmp21_ = gtk_builder_get_object (_tmp20_, "opponent_combo");
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_combo_box_get_type (), GtkComboBox));
	ai_combo = _tmp22_;
	_tmp23_ = ai_combo;
	_tmp24_ = gtk_combo_box_get_model (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_list_store_get_type (), GtkListStore));
	ai_model = _tmp26_;
	_tmp27_ = self->priv->settings;
	_tmp28_ = g_settings_get_string (_tmp27_, "opponent");
	opponent_name = _tmp28_;
	_tmp29_ = opponent_name;
	if (g_strcmp0 (_tmp29_, "human") == 0) {
		GtkComboBox* _tmp30_;
		_tmp30_ = ai_combo;
		gtk_combo_box_set_active (_tmp30_, 0);
	}
	_tmp31_ = self->priv->ai_profiles;
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = _tmp31_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			AIProfile* _tmp32_;
			AIProfile* p = NULL;
			_tmp32_ = _g_object_ref0 ((AIProfile*) p_it->data);
			p = _tmp32_;
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp33_;
				GtkTreeIter _tmp34_ = {0};
				GtkListStore* _tmp35_;
				GtkTreeIter _tmp36_;
				AIProfile* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				AIProfile* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				gboolean _tmp43_ = FALSE;
				AIProfile* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				_tmp33_ = ai_model;
				gtk_list_store_append (_tmp33_, &_tmp34_);
				iter = _tmp34_;
				_tmp35_ = ai_model;
				_tmp36_ = iter;
				_tmp37_ = p;
				_tmp38_ = ai_profile_get_name (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = p;
				_tmp41_ = ai_profile_get_name (_tmp40_);
				_tmp42_ = _tmp41_;
				gtk_list_store_set (_tmp35_, &_tmp36_, 0, _tmp39_, 1, _tmp42_, -1, -1);
				_tmp44_ = p;
				_tmp45_ = ai_profile_get_name (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = opponent_name;
				if (g_strcmp0 (_tmp46_, _tmp47_) == 0) {
					_tmp43_ = TRUE;
				} else {
					gboolean _tmp48_ = FALSE;
					const gchar* _tmp49_;
					_tmp49_ = opponent_name;
					if (g_strcmp0 (_tmp49_, "") == 0) {
						GtkComboBox* _tmp50_;
						gint _tmp51_;
						_tmp50_ = ai_combo;
						_tmp51_ = gtk_combo_box_get_active (_tmp50_);
						_tmp48_ = _tmp51_ == -1;
					} else {
						_tmp48_ = FALSE;
					}
					_tmp43_ = _tmp48_;
				}
				if (_tmp43_) {
					GtkComboBox* _tmp52_;
					GtkTreeIter _tmp53_;
					_tmp52_ = ai_combo;
					_tmp53_ = iter;
					gtk_combo_box_set_active_iter (_tmp52_, &_tmp53_);
				}
				_g_object_unref0 (p);
			}
		}
	}
	_tmp54_ = ai_combo;
	_tmp55_ = gtk_combo_box_get_active (_tmp54_);
	if (_tmp55_ == -1) {
		GtkComboBox* _tmp56_;
		GSettings* _tmp57_;
		_tmp56_ = ai_combo;
		gtk_combo_box_set_active (_tmp56_, 0);
		_tmp57_ = self->priv->settings;
		g_settings_set_string (_tmp57_, "opponent", "human");
	}
	_tmp58_ = preferences_builder;
	_tmp59_ = gtk_builder_get_object (_tmp58_, "difficulty_combo");
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->difficulty_combo);
	self->priv->difficulty_combo = _tmp60_;
	_tmp61_ = self->priv->difficulty_combo;
	_tmp62_ = self->priv->settings;
	_tmp63_ = g_settings_get_string (_tmp62_, "difficulty");
	_tmp64_ = _tmp63_;
	chess_application_set_combo (self, _tmp61_, 1, _tmp64_);
	_g_free0 (_tmp64_);
	_tmp65_ = preferences_builder;
	_tmp66_ = gtk_builder_get_object (_tmp65_, "duration_combo");
	_tmp67_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->duration_combo);
	self->priv->duration_combo = _tmp67_;
	_tmp68_ = preferences_builder;
	_tmp69_ = gtk_builder_get_object (_tmp68_, "clock_type_combo");
	_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->clock_type_combo);
	self->priv->clock_type_combo = _tmp70_;
	_tmp71_ = preferences_builder;
	_tmp72_ = gtk_builder_get_object (_tmp71_, "duration_adjustment");
	_tmp73_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, gtk_adjustment_get_type (), GtkAdjustment));
	_g_object_unref0 (self->priv->duration_adjustment);
	self->priv->duration_adjustment = _tmp73_;
	_tmp74_ = preferences_builder;
	_tmp75_ = gtk_builder_get_object (_tmp74_, "timer_increment_adjustment");
	_tmp76_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, gtk_adjustment_get_type (), GtkAdjustment));
	_g_object_unref0 (self->priv->timer_increment_adjustment);
	self->priv->timer_increment_adjustment = _tmp76_;
	_tmp77_ = preferences_builder;
	_tmp78_ = gtk_builder_get_object (_tmp77_, "custom_duration_box");
	_tmp79_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->custom_duration_box);
	self->priv->custom_duration_box = _tmp79_;
	_tmp80_ = preferences_builder;
	_tmp81_ = gtk_builder_get_object (_tmp80_, "timer_increment_box");
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->timer_increment_box);
	self->priv->timer_increment_box = _tmp82_;
	_tmp83_ = preferences_builder;
	_tmp84_ = gtk_builder_get_object (_tmp83_, "custom_duration_units_combo");
	_tmp85_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->custom_duration_units_combo);
	self->priv->custom_duration_units_combo = _tmp85_;
	_tmp86_ = self->priv->settings;
	_tmp87_ = g_settings_get_int (_tmp86_, "duration");
	chess_application_set_duration (self, _tmp87_, TRUE);
	_tmp88_ = preferences_builder;
	_tmp89_ = gtk_builder_get_object (_tmp88_, "timer_increment_label");
	_tmp90_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->timer_increment_label);
	self->priv->timer_increment_label = _tmp90_;
	_tmp91_ = preferences_builder;
	_tmp92_ = gtk_builder_get_object (_tmp91_, "timer_increment_units_combo");
	_tmp93_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->timer_increment_units_combo);
	self->priv->timer_increment_units_combo = _tmp93_;
	_tmp94_ = self->priv->pgn_game;
	_tmp95_ = pgn_game_get_clock_type (_tmp94_);
	_tmp96_ = _tmp95_;
	if (_tmp96_ != NULL) {
		PGNGame* _tmp97_;
		const gchar* _tmp98_;
		const gchar* _tmp99_;
		ClockType _tmp100_;
		_tmp97_ = self->priv->pgn_game;
		_tmp98_ = pgn_game_get_clock_type (_tmp97_);
		_tmp99_ = _tmp98_;
		_tmp100_ = clock_type_string_to_enum (_tmp99_);
		chess_application_set_clock_type (self, (gint) _tmp100_);
	} else {
		GSettings* _tmp101_;
		gchar* _tmp102_;
		gchar* _tmp103_;
		ClockType _tmp104_;
		_tmp101_ = self->priv->settings;
		_tmp102_ = g_settings_get_string (_tmp101_, "clock-type");
		_tmp103_ = _tmp102_;
		_tmp104_ = clock_type_string_to_enum (_tmp103_);
		chess_application_set_clock_type (self, (gint) _tmp104_);
		_g_free0 (_tmp103_);
	}
	_tmp105_ = self->priv->pgn_game;
	_tmp106_ = pgn_game_get_timer_increment (_tmp105_);
	_tmp107_ = _tmp106_;
	if (_tmp107_ != NULL) {
		PGNGame* _tmp108_;
		const gchar* _tmp109_;
		const gchar* _tmp110_;
		gint _tmp111_;
		_tmp108_ = self->priv->pgn_game;
		_tmp109_ = pgn_game_get_timer_increment (_tmp108_);
		_tmp110_ = _tmp109_;
		_tmp111_ = atoi (_tmp110_);
		chess_application_set_timer_increment (self, _tmp111_);
	} else {
		GSettings* _tmp112_;
		gint _tmp113_;
		_tmp112_ = self->priv->settings;
		_tmp113_ = g_settings_get_int (_tmp112_, "timer-increment");
		chess_application_set_timer_increment (self, _tmp113_);
	}
	_tmp114_ = preferences_builder;
	_tmp115_ = gtk_builder_get_object (_tmp114_, "orientation_combo");
	_tmp116_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, gtk_combo_box_get_type (), GtkComboBox));
	orientation_combo = _tmp116_;
	_tmp117_ = orientation_combo;
	_tmp118_ = self->priv->settings;
	_tmp119_ = g_settings_get_string (_tmp118_, "board-side");
	_tmp120_ = _tmp119_;
	chess_application_set_combo (self, _tmp117_, 1, _tmp120_);
	_g_free0 (_tmp120_);
	_tmp121_ = preferences_builder;
	_tmp122_ = gtk_builder_get_object (_tmp121_, "move_format_combo");
	_tmp123_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, gtk_combo_box_get_type (), GtkComboBox));
	move_combo = _tmp123_;
	_tmp124_ = move_combo;
	_tmp125_ = self->priv->settings;
	_tmp126_ = g_settings_get_string (_tmp125_, "move-format");
	_tmp127_ = _tmp126_;
	chess_application_set_combo (self, _tmp124_, 1, _tmp127_);
	_g_free0 (_tmp127_);
	_tmp128_ = preferences_builder;
	_tmp129_ = gtk_builder_get_object (_tmp128_, "piece_style_combo");
	_tmp130_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, gtk_combo_box_get_type (), GtkComboBox));
	theme_combo = _tmp130_;
	_tmp131_ = theme_combo;
	_tmp132_ = self->priv->settings;
	_tmp133_ = g_settings_get_string (_tmp132_, "piece-theme");
	_tmp134_ = _tmp133_;
	chess_application_set_combo (self, _tmp131_, 1, _tmp134_);
	_g_free0 (_tmp134_);
	_tmp135_ = preferences_builder;
	gtk_builder_connect_signals (_tmp135_, self);
	_tmp136_ = ai_combo;
	_tmp137_ = gtk_combo_box_get_active (_tmp136_);
	if (_tmp137_ == 0) {
		GtkComboBox* _tmp138_;
		GtkComboBox* _tmp139_;
		_tmp138_ = self->priv->side_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp138_, FALSE);
		_tmp139_ = self->priv->difficulty_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp139_, FALSE);
	}
	_tmp140_ = self->priv->preferences_dialog;
	gtk_dialog_run (_tmp140_);
	_g_object_unref0 (theme_combo);
	_g_object_unref0 (move_combo);
	_g_object_unref0 (orientation_combo);
	_g_free0 (opponent_name);
	_g_object_unref0 (ai_model);
	_g_object_unref0 (ai_combo);
	_g_object_unref0 (preferences_builder);
}


static void chess_application_set_combo (ChessApplication* self, GtkComboBox* combo, gint value_index, const gchar* value) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	model = _tmp3_;
	_tmp4_ = model;
	_tmp6_ = gtk_tree_model_get_iter_first (_tmp4_, &_tmp5_);
	iter = _tmp5_;
	if (!_tmp6_) {
		_g_object_unref0 (model);
		return;
	}
	{
		gboolean _tmp7_ = FALSE;
		_tmp7_ = TRUE;
		while (TRUE) {
			gchar* v = NULL;
			GtkTreeModel* _tmp10_;
			GtkTreeIter _tmp11_;
			gint _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			if (!_tmp7_) {
				GtkTreeModel* _tmp8_;
				gboolean _tmp9_;
				_tmp8_ = model;
				_tmp9_ = gtk_tree_model_iter_next (_tmp8_, &iter);
				if (!_tmp9_) {
					break;
				}
			}
			_tmp7_ = FALSE;
			_tmp10_ = model;
			_tmp11_ = iter;
			_tmp12_ = value_index;
			gtk_tree_model_get (_tmp10_, &_tmp11_, _tmp12_, &v, -1, -1);
			_tmp13_ = v;
			_tmp14_ = value;
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
				GtkComboBox* _tmp15_;
				GtkTreeIter _tmp16_;
				_tmp15_ = combo;
				_tmp16_ = iter;
				gtk_combo_box_set_active_iter (_tmp15_, &_tmp16_);
				_g_free0 (v);
				_g_object_unref0 (model);
				return;
			}
			_g_free0 (v);
		}
	}
	_g_object_unref0 (model);
}


static gchar* chess_application_get_combo (ChessApplication* self, GtkComboBox* combo, gint value_index) {
	gchar* result = NULL;
	gchar* value = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (combo != NULL, NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		result = NULL;
		_g_free0 (value);
		return result;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	_tmp7_ = value_index;
	gtk_tree_model_get (_tmp5_, &_tmp6_, _tmp7_, &value, -1, -1);
	result = value;
	return result;
}


void side_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gint player = 0;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GSettings* _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &player, -1, -1);
	_tmp7_ = self->priv->settings;
	_tmp8_ = player;
	g_settings_set_enum (_tmp7_, "play-as", _tmp8_);
}


void opponent_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gchar* opponent = NULL;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GSettings* _tmp7_;
	const gchar* _tmp8_;
	gboolean vs_human = FALSE;
	GtkComboBox* _tmp9_;
	gint _tmp10_;
	GtkComboBox* _tmp11_;
	gboolean _tmp12_;
	GtkComboBox* _tmp13_;
	gboolean _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &opponent, -1, -1);
	_tmp7_ = self->priv->settings;
	_tmp8_ = opponent;
	g_settings_set_string (_tmp7_, "opponent", _tmp8_);
	_tmp9_ = combo;
	_tmp10_ = gtk_combo_box_get_active (_tmp9_);
	vs_human = _tmp10_ == 0;
	_tmp11_ = self->priv->side_combo;
	_tmp12_ = vs_human;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, !_tmp12_);
	_tmp13_ = self->priv->difficulty_combo;
	_tmp14_ = vs_human;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, !_tmp14_);
	_g_free0 (opponent);
}


void difficulty_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gchar* difficulty = NULL;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GSettings* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &difficulty, -1, -1);
	_tmp7_ = self->priv->settings;
	_tmp8_ = difficulty;
	g_settings_set_string (_tmp7_, "difficulty", _tmp8_);
	_g_free0 (difficulty);
}


static void chess_application_set_clock_type (ChessApplication* self, gint clock_type) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter iter = {0};
	GtkTreeIter active_iter_clock_type = {0};
	GtkTreeIter _tmp4_ = {0};
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_;
	GtkComboBox* _tmp16_;
	GtkTreeIter _tmp17_;
	GtkComboBox* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock_type_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	model = _tmp3_;
	active_iter_clock_type = _tmp4_;
	_tmp5_ = model;
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
	iter = _tmp6_;
	if (_tmp7_) {
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint type = 0;
				GtkTreeModel* _tmp11_;
				GtkTreeIter _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				if (!_tmp8_) {
					GtkTreeModel* _tmp9_;
					gboolean _tmp10_;
					_tmp9_ = model;
					_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
					if (!_tmp10_) {
						break;
					}
				}
				_tmp8_ = FALSE;
				_tmp11_ = model;
				_tmp12_ = iter;
				gtk_tree_model_get (_tmp11_, &_tmp12_, 1, &type, -1, -1);
				_tmp13_ = type;
				_tmp14_ = clock_type;
				if (_tmp13_ == _tmp14_) {
					GtkTreeIter _tmp15_;
					_tmp15_ = iter;
					active_iter_clock_type = _tmp15_;
				}
			}
		}
	}
	_tmp16_ = self->priv->clock_type_combo;
	_tmp17_ = active_iter_clock_type;
	gtk_combo_box_set_active_iter (_tmp16_, &_tmp17_);
	_tmp18_ = self->priv->clock_type_combo;
	clock_type_changed_cb (_tmp18_, self);
	_g_object_unref0 (model);
}


static void chess_application_set_timer_increment (ChessApplication* self, gint timer_increment) {
	gint timer_increment_multiplier = 0;
	gint _tmp0_;
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp5_;
	GtkTreeModel* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeModel* _tmp8_;
	GtkTreeIter iter = {0};
	GtkTreeIter reqd_iter = {0};
	GtkTreeIter _tmp9_ = {0};
	GtkTreeModel* _tmp10_;
	GtkTreeIter _tmp11_ = {0};
	gboolean _tmp12_;
	GtkComboBox* _tmp21_;
	GtkTreeIter _tmp22_;
	GtkComboBox* _tmp23_;
	g_return_if_fail (self != NULL);
	timer_increment_multiplier = 1;
	_tmp0_ = timer_increment;
	if (_tmp0_ >= 60) {
		GtkAdjustment* _tmp1_;
		gint _tmp2_;
		_tmp1_ = self->priv->timer_increment_adjustment;
		_tmp2_ = timer_increment;
		gtk_adjustment_set_value (_tmp1_, (gdouble) (_tmp2_ / 60));
		timer_increment_multiplier = 60;
	} else {
		GtkAdjustment* _tmp3_;
		gint _tmp4_;
		_tmp3_ = self->priv->timer_increment_adjustment;
		_tmp4_ = timer_increment;
		gtk_adjustment_set_value (_tmp3_, (gdouble) _tmp4_);
	}
	_tmp5_ = self->priv->timer_increment_units_combo;
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	model = _tmp8_;
	reqd_iter = _tmp9_;
	_tmp10_ = model;
	_tmp12_ = gtk_tree_model_get_iter_first (_tmp10_, &_tmp11_);
	iter = _tmp11_;
	if (_tmp12_) {
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gint multiplier = 0;
				GtkTreeModel* _tmp16_;
				GtkTreeIter _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				if (!_tmp13_) {
					GtkTreeModel* _tmp14_;
					gboolean _tmp15_;
					_tmp14_ = model;
					_tmp15_ = gtk_tree_model_iter_next (_tmp14_, &iter);
					if (!_tmp15_) {
						break;
					}
				}
				_tmp13_ = FALSE;
				_tmp16_ = model;
				_tmp17_ = iter;
				gtk_tree_model_get (_tmp16_, &_tmp17_, 1, &multiplier, -1, -1);
				_tmp18_ = multiplier;
				_tmp19_ = timer_increment_multiplier;
				if (_tmp18_ == _tmp19_) {
					GtkTreeIter _tmp20_;
					_tmp20_ = iter;
					reqd_iter = _tmp20_;
				}
			}
		}
	}
	_tmp21_ = self->priv->timer_increment_units_combo;
	_tmp22_ = reqd_iter;
	gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
	_tmp23_ = self->priv->timer_increment_units_combo;
	timer_increment_units_changed_cb ((GtkWidget*) _tmp23_, self);
	_g_object_unref0 (model);
}


static void chess_application_set_duration (ChessApplication* self, gint duration, gboolean simplify) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter iter = {0};
	GtkTreeIter max_iter = {0};
	GtkTreeIter _tmp4_ = {0};
	gint max_multiplier = 0;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_;
	gint value = 0;
	gint _tmp20_;
	gboolean _tmp27_;
	GtkComboBox* _tmp28_;
	GtkTreeModel* _tmp29_;
	GtkTreeModel* _tmp30_;
	GtkTreeModel* _tmp31_;
	GtkTreeModel* _tmp32_;
	GtkTreeIter _tmp33_ = {0};
	gboolean _tmp34_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->custom_duration_units_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	model = _tmp3_;
	max_iter = _tmp4_;
	max_multiplier = 0;
	_tmp5_ = model;
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
	iter = _tmp6_;
	if (_tmp7_) {
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint multiplier = 0;
				GtkTreeModel* _tmp11_;
				GtkTreeIter _tmp12_;
				gboolean _tmp13_ = FALSE;
				gint _tmp14_;
				gint _tmp15_;
				if (!_tmp8_) {
					GtkTreeModel* _tmp9_;
					gboolean _tmp10_;
					_tmp9_ = model;
					_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
					if (!_tmp10_) {
						break;
					}
				}
				_tmp8_ = FALSE;
				_tmp11_ = model;
				_tmp12_ = iter;
				gtk_tree_model_get (_tmp11_, &_tmp12_, 1, &multiplier, -1, -1);
				_tmp14_ = multiplier;
				_tmp15_ = max_multiplier;
				if (_tmp14_ > _tmp15_) {
					gint _tmp16_;
					gint _tmp17_;
					_tmp16_ = duration;
					_tmp17_ = multiplier;
					_tmp13_ = (_tmp16_ % _tmp17_) == 0;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					gint _tmp18_;
					GtkTreeIter _tmp19_;
					_tmp18_ = multiplier;
					max_multiplier = _tmp18_;
					_tmp19_ = iter;
					max_iter = _tmp19_;
				}
			}
		}
	}
	value = 0;
	_tmp20_ = max_multiplier;
	if (_tmp20_ > 0) {
		gint _tmp21_;
		gint _tmp22_;
		GtkAdjustment* _tmp23_;
		gint _tmp24_;
		GtkComboBox* _tmp25_;
		GtkTreeIter _tmp26_;
		_tmp21_ = duration;
		_tmp22_ = max_multiplier;
		value = _tmp21_ / _tmp22_;
		_tmp23_ = self->priv->duration_adjustment;
		_tmp24_ = value;
		gtk_adjustment_set_value (_tmp23_, (gdouble) _tmp24_);
		_tmp25_ = self->priv->custom_duration_units_combo;
		_tmp26_ = max_iter;
		gtk_combo_box_set_active_iter (_tmp25_, &_tmp26_);
	}
	_tmp27_ = simplify;
	if (!_tmp27_) {
		_g_object_unref0 (model);
		return;
	}
	_tmp28_ = self->priv->duration_combo;
	_tmp29_ = gtk_combo_box_get_model (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = _g_object_ref0 (_tmp30_);
	_g_object_unref0 (model);
	model = _tmp31_;
	_tmp32_ = model;
	_tmp34_ = gtk_tree_model_get_iter_first (_tmp32_, &_tmp33_);
	iter = _tmp33_;
	if (!_tmp34_) {
		_g_object_unref0 (model);
		return;
	}
	{
		gboolean _tmp35_ = FALSE;
		_tmp35_ = TRUE;
		while (TRUE) {
			gint v = 0;
			GtkTreeModel* _tmp38_;
			GtkTreeIter _tmp39_;
			gboolean _tmp40_ = FALSE;
			gint _tmp41_;
			gint _tmp42_;
			if (!_tmp35_) {
				GtkTreeModel* _tmp36_;
				gboolean _tmp37_;
				_tmp36_ = model;
				_tmp37_ = gtk_tree_model_iter_next (_tmp36_, &iter);
				if (!_tmp37_) {
					break;
				}
			}
			_tmp35_ = FALSE;
			_tmp38_ = model;
			_tmp39_ = iter;
			gtk_tree_model_get (_tmp38_, &_tmp39_, 1, &v, -1, -1);
			_tmp41_ = v;
			_tmp42_ = duration;
			if (_tmp41_ == _tmp42_) {
				_tmp40_ = TRUE;
			} else {
				gint _tmp43_;
				_tmp43_ = v;
				_tmp40_ = _tmp43_ == -1;
			}
			if (_tmp40_) {
				GtkComboBox* _tmp44_;
				GtkTreeIter _tmp45_;
				GtkBox* _tmp46_;
				gint _tmp47_;
				_tmp44_ = self->priv->duration_combo;
				_tmp45_ = iter;
				gtk_combo_box_set_active_iter (_tmp44_, &_tmp45_);
				_tmp46_ = self->priv->custom_duration_box;
				_tmp47_ = v;
				gtk_widget_set_visible ((GtkWidget*) _tmp46_, _tmp47_ == -1);
				_g_object_unref0 (model);
				return;
			}
		}
	}
	_g_object_unref0 (model);
}


static gint chess_application_get_duration (ChessApplication* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gint magnitude = 0;
	GtkAdjustment* _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gint multiplier = 0;
	GtkComboBox* _tmp11_;
	GtkTreeIter _tmp12_ = {0};
	gboolean _tmp13_;
	gint _tmp18_;
	gint _tmp29_;
	gint _tmp30_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->duration_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		gint duration = 0;
		GtkComboBox* _tmp3_;
		GtkTreeModel* _tmp4_;
		GtkTreeModel* _tmp5_;
		GtkTreeIter _tmp6_;
		gint _tmp7_;
		_tmp3_ = self->priv->duration_combo;
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = iter;
		gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
		_tmp7_ = duration;
		if (_tmp7_ >= 0) {
			result = duration;
			return result;
		}
	}
	_tmp8_ = self->priv->duration_adjustment;
	_tmp9_ = gtk_adjustment_get_value (_tmp8_);
	_tmp10_ = _tmp9_;
	magnitude = (gint) _tmp10_;
	multiplier = 1;
	_tmp11_ = self->priv->custom_duration_units_combo;
	_tmp13_ = gtk_combo_box_get_active_iter (_tmp11_, &_tmp12_);
	iter = _tmp12_;
	if (_tmp13_) {
		GtkComboBox* _tmp14_;
		GtkTreeModel* _tmp15_;
		GtkTreeModel* _tmp16_;
		GtkTreeIter _tmp17_;
		_tmp14_ = self->priv->custom_duration_units_combo;
		_tmp15_ = gtk_combo_box_get_model (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = iter;
		gtk_tree_model_get (_tmp16_, &_tmp17_, 1, &multiplier, -1, -1);
	}
	_tmp18_ = multiplier;
	switch (_tmp18_) {
		case 60:
		{
			GtkAdjustment* _tmp19_;
			gdouble _tmp20_;
			_tmp19_ = self->priv->duration_adjustment;
			_tmp20_ = gtk_adjustment_get_upper (_tmp19_);
			if (_tmp20_ != ((gdouble) 600)) {
				GtkAdjustment* _tmp21_;
				_tmp21_ = self->priv->duration_adjustment;
				gtk_adjustment_set_upper (_tmp21_, (gdouble) 600);
			}
			break;
		}
		case 3600:
		{
			GtkAdjustment* _tmp22_;
			gdouble _tmp23_;
			_tmp22_ = self->priv->duration_adjustment;
			_tmp23_ = gtk_adjustment_get_upper (_tmp22_);
			if (_tmp23_ != ((gdouble) 10)) {
				GtkAdjustment* _tmp24_;
				GtkAdjustment* _tmp25_;
				gdouble _tmp26_;
				gdouble _tmp27_;
				_tmp24_ = self->priv->duration_adjustment;
				gtk_adjustment_set_upper (_tmp24_, (gdouble) 10);
				_tmp25_ = self->priv->duration_adjustment;
				_tmp26_ = gtk_adjustment_get_value (_tmp25_);
				_tmp27_ = _tmp26_;
				if (_tmp27_ > ((gdouble) 10)) {
					GtkAdjustment* _tmp28_;
					_tmp28_ = self->priv->duration_adjustment;
					gtk_adjustment_set_value (_tmp28_, (gdouble) 10);
					magnitude = 10;
				}
			}
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp29_ = magnitude;
	_tmp30_ = multiplier;
	result = _tmp29_ * _tmp30_;
	return result;
}


static gboolean chess_application_save_duration_cb (ChessApplication* self) {
	gboolean result = FALSE;
	GSettings* _tmp0_;
	gint _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	_tmp1_ = chess_application_get_duration (self);
	g_settings_set_int (_tmp0_, "duration", _tmp1_);
	_tmp2_ = self->priv->save_duration_timeout;
	g_source_remove (_tmp2_);
	self->priv->save_duration_timeout = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}


void duration_changed_cb (GtkAdjustment* adjustment, ChessApplication* self) {
	GtkListStore* model = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->custom_duration_units_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp3_;
	_tmp4_ = model;
	_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp4_, &_tmp5_);
	iter = _tmp5_;
	if (_tmp6_) {
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint multiplier = 0;
				GtkListStore* _tmp10_;
				GtkTreeIter _tmp11_;
				gint _tmp12_;
				if (!_tmp7_) {
					GtkListStore* _tmp8_;
					gboolean _tmp9_;
					_tmp8_ = model;
					_tmp9_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp8_, &iter);
					if (!_tmp9_) {
						break;
					}
				}
				_tmp7_ = FALSE;
				_tmp10_ = model;
				_tmp11_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 1, &multiplier, -1, -1);
				_tmp12_ = multiplier;
				switch (_tmp12_) {
					case 60:
					{
						GtkListStore* _tmp13_;
						GtkTreeIter _tmp14_;
						GtkAdjustment* _tmp15_;
						gdouble _tmp16_;
						gdouble _tmp17_;
						_tmp13_ = model;
						_tmp14_ = iter;
						_tmp15_ = adjustment;
						_tmp16_ = gtk_adjustment_get_value (_tmp15_);
						_tmp17_ = _tmp16_;
						gtk_list_store_set (_tmp13_, &_tmp14_, 0, ngettext ("minute", "minutes", (gulong) _tmp17_), -1, -1);
						break;
					}
					case 3600:
					{
						GtkListStore* _tmp18_;
						GtkTreeIter _tmp19_;
						GtkAdjustment* _tmp20_;
						gdouble _tmp21_;
						gdouble _tmp22_;
						_tmp18_ = model;
						_tmp19_ = iter;
						_tmp20_ = adjustment;
						_tmp21_ = gtk_adjustment_get_value (_tmp20_);
						_tmp22_ = _tmp21_;
						gtk_list_store_set (_tmp18_, &_tmp19_, 0, ngettext ("hour", "hours", (gulong) _tmp22_), -1, -1);
						break;
					}
					default:
					{
						g_assert_not_reached ();
					}
				}
			}
		}
	}
	chess_application_save_duration (self);
	_g_object_unref0 (model);
}


void duration_units_changed_cb (GtkWidget* widget, ChessApplication* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	chess_application_save_duration (self);
}


void timer_increment_units_changed_cb (GtkWidget* widget, ChessApplication* self) {
	GtkListStore* model = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeIter iter = {0};
	gint multiplier = 0;
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_;
	GtkComboBox* _tmp23_;
	GtkTreeIter _tmp24_ = {0};
	gboolean _tmp25_;
	gint _tmp30_;
	GSettings* _tmp41_;
	GtkAdjustment* _tmp42_;
	gdouble _tmp43_;
	gdouble _tmp44_;
	gint _tmp45_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->timer_increment_units_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp3_;
	multiplier = 0;
	_tmp4_ = model;
	_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp4_, &_tmp5_);
	iter = _tmp5_;
	if (_tmp6_) {
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GtkListStore* _tmp10_;
				GtkTreeIter _tmp11_;
				gint _tmp12_;
				if (!_tmp7_) {
					GtkListStore* _tmp8_;
					gboolean _tmp9_;
					_tmp8_ = model;
					_tmp9_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp8_, &iter);
					if (!_tmp9_) {
						break;
					}
				}
				_tmp7_ = FALSE;
				_tmp10_ = model;
				_tmp11_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 1, &multiplier, -1, -1);
				_tmp12_ = multiplier;
				switch (_tmp12_) {
					case 1:
					{
						GtkListStore* _tmp13_;
						GtkTreeIter _tmp14_;
						GtkAdjustment* _tmp15_;
						gdouble _tmp16_;
						gdouble _tmp17_;
						_tmp13_ = model;
						_tmp14_ = iter;
						_tmp15_ = self->priv->timer_increment_adjustment;
						_tmp16_ = gtk_adjustment_get_value (_tmp15_);
						_tmp17_ = _tmp16_;
						gtk_list_store_set (_tmp13_, &_tmp14_, 0, ngettext ("second", "seconds", (gulong) _tmp17_), -1, -1);
						break;
					}
					case 60:
					{
						GtkListStore* _tmp18_;
						GtkTreeIter _tmp19_;
						GtkAdjustment* _tmp20_;
						gdouble _tmp21_;
						gdouble _tmp22_;
						_tmp18_ = model;
						_tmp19_ = iter;
						_tmp20_ = self->priv->timer_increment_adjustment;
						_tmp21_ = gtk_adjustment_get_value (_tmp20_);
						_tmp22_ = _tmp21_;
						gtk_list_store_set (_tmp18_, &_tmp19_, 0, ngettext ("minute", "minutes", (gulong) _tmp22_), -1, -1);
						break;
					}
					default:
					{
						g_assert_not_reached ();
					}
				}
			}
		}
	}
	_tmp23_ = self->priv->timer_increment_units_combo;
	_tmp25_ = gtk_combo_box_get_active_iter (_tmp23_, &_tmp24_);
	iter = _tmp24_;
	if (_tmp25_) {
		GtkComboBox* _tmp26_;
		GtkTreeModel* _tmp27_;
		GtkTreeModel* _tmp28_;
		GtkTreeIter _tmp29_;
		_tmp26_ = self->priv->timer_increment_units_combo;
		_tmp27_ = gtk_combo_box_get_model (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = iter;
		gtk_tree_model_get (_tmp28_, &_tmp29_, 1, &multiplier, -1, -1);
	}
	_tmp30_ = multiplier;
	switch (_tmp30_) {
		case 1:
		{
			GtkAdjustment* _tmp31_;
			gdouble _tmp32_;
			_tmp31_ = self->priv->timer_increment_adjustment;
			_tmp32_ = gtk_adjustment_get_upper (_tmp31_);
			if (_tmp32_ != ((gdouble) 59)) {
				GtkAdjustment* _tmp33_;
				_tmp33_ = self->priv->timer_increment_adjustment;
				gtk_adjustment_set_upper (_tmp33_, (gdouble) 59);
			}
			break;
		}
		case 60:
		{
			GtkAdjustment* _tmp34_;
			gdouble _tmp35_;
			_tmp34_ = self->priv->timer_increment_adjustment;
			_tmp35_ = gtk_adjustment_get_upper (_tmp34_);
			if (_tmp35_ != ((gdouble) 10)) {
				GtkAdjustment* _tmp36_;
				GtkAdjustment* _tmp37_;
				gdouble _tmp38_;
				gdouble _tmp39_;
				_tmp36_ = self->priv->timer_increment_adjustment;
				gtk_adjustment_set_upper (_tmp36_, (gdouble) 10);
				_tmp37_ = self->priv->timer_increment_adjustment;
				_tmp38_ = gtk_adjustment_get_value (_tmp37_);
				_tmp39_ = _tmp38_;
				if (_tmp39_ > ((gdouble) 10)) {
					GtkAdjustment* _tmp40_;
					_tmp40_ = self->priv->timer_increment_adjustment;
					gtk_adjustment_set_value (_tmp40_, (gdouble) 10);
				}
			}
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp41_ = self->priv->settings;
	_tmp42_ = self->priv->timer_increment_adjustment;
	_tmp43_ = gtk_adjustment_get_value (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = multiplier;
	g_settings_set_int (_tmp41_, "timer-increment", ((gint) _tmp44_) * _tmp45_);
	_g_object_unref0 (model);
}


static gboolean _chess_application_save_duration_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_application_save_duration_cb ((ChessApplication*) self);
	return result;
}


static void chess_application_save_duration (ChessApplication* self) {
	guint _tmp0_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->save_duration_timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->save_duration_timeout;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _chess_application_save_duration_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->save_duration_timeout = _tmp2_;
}


void duration_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gint duration = 0;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GtkBox* _tmp7_;
	gint _tmp8_;
	GtkComboBox* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
	_tmp7_ = self->priv->custom_duration_box;
	_tmp8_ = duration;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_ < 0);
	_tmp9_ = self->priv->clock_type_combo;
	_tmp10_ = duration;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, _tmp10_ != 0);
	_tmp11_ = duration;
	if (_tmp11_ == 0) {
		chess_application_set_clock_type (self, (gint) CLOCK_TYPE_SIMPLE);
	}
	_tmp12_ = duration;
	if (_tmp12_ >= 0) {
		gint _tmp13_;
		_tmp13_ = duration;
		chess_application_set_duration (self, _tmp13_, FALSE);
	} else {
		gint _tmp14_;
		_tmp14_ = chess_application_get_duration (self);
		if (_tmp14_ <= 0) {
			chess_application_set_duration (self, 60 * 60, FALSE);
		}
	}
	chess_application_save_duration (self);
}


void clock_type_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	ClockType clock_type = 0;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GtkBox* _tmp7_;
	ClockType _tmp8_;
	GtkWidget* _tmp9_;
	ClockType _tmp10_;
	GSettings* _tmp11_;
	ClockType _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &clock_type, -1, -1);
	_tmp7_ = self->priv->timer_increment_box;
	_tmp8_ = clock_type;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_ > 0);
	_tmp9_ = self->priv->timer_increment_label;
	_tmp10_ = clock_type;
	gtk_widget_set_visible (_tmp9_, _tmp10_ > 0);
	_tmp11_ = self->priv->settings;
	_tmp12_ = clock_type;
	_tmp13_ = clock_type_to_string (_tmp12_);
	_tmp14_ = _tmp13_;
	g_settings_set_string (_tmp11_, "clock-type", _tmp14_);
	_g_free0 (_tmp14_);
}


void preferences_response_cb (GtkWidget* widget, gint response_id, ChessApplication* self) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


gboolean preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = widget;
	preferences_response_cb (_tmp0_, (gint) GTK_RESPONSE_CANCEL, self);
	result = TRUE;
	return result;
}


void piece_style_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GSettings* _tmp0_;
	GtkComboBox* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = combo;
	_tmp2_ = chess_application_get_combo (self, _tmp1_, 1);
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp0_, "piece-theme", _tmp3_);
	_g_free0 (_tmp3_);
}


void move_format_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GSettings* _tmp0_;
	GtkComboBox* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = combo;
	_tmp2_ = chess_application_get_combo (self, _tmp1_, 1);
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp0_, "move-format", _tmp3_);
	_g_free0 (_tmp3_);
}


void orientation_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GSettings* _tmp0_;
	GtkComboBox* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = combo;
	_tmp2_ = chess_application_get_combo (self, _tmp1_, 1);
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp0_, "board-side", _tmp3_);
	_g_free0 (_tmp3_);
}


void chess_application_help_cb (ChessApplication* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkApplicationWindow* _tmp0_;
		GdkScreen* _tmp1_;
		guint32 _tmp2_;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-chess", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-chess.vala:2175: Unable to open help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _chess_application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	chess_application_about_response_cb ((ChessApplication*) self, response_id);
}


void chess_application_about_cb (ChessApplication* self) {
	GtkAboutDialog* _tmp0_;
	GtkAboutDialog* _tmp2_;
	GtkAboutDialog* _tmp3_;
	GtkApplicationWindow* _tmp4_;
	GtkAboutDialog* _tmp5_;
	GtkAboutDialog* _tmp6_;
	GtkAboutDialog* _tmp7_;
	GtkAboutDialog* _tmp8_;
	const gchar* _tmp9_;
	GtkAboutDialog* _tmp10_;
	GtkAboutDialog* _tmp11_;
	GtkAboutDialog* _tmp12_;
	GtkAboutDialog* _tmp13_;
	GtkAboutDialog* _tmp14_;
	GtkAboutDialog* _tmp15_;
	GtkAboutDialog* _tmp16_;
	GtkAboutDialog* _tmp17_;
	GtkAboutDialog* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->about_dialog;
	if (_tmp0_ != NULL) {
		GtkAboutDialog* _tmp1_;
		_tmp1_ = self->priv->about_dialog;
		gtk_window_present ((GtkWindow*) _tmp1_);
		return;
	}
	_tmp2_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->about_dialog);
	self->priv->about_dialog = _tmp2_;
	_tmp3_ = self->priv->about_dialog;
	_tmp4_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, (GtkWindow*) _tmp4_);
	_tmp5_ = self->priv->about_dialog;
	gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
	_tmp6_ = self->priv->about_dialog;
	gtk_about_dialog_set_program_name (_tmp6_, _ ("Chess"));
	_tmp7_ = self->priv->about_dialog;
	gtk_about_dialog_set_version (_tmp7_, VERSION);
	_tmp8_ = self->priv->about_dialog;
	_tmp9_ = self->priv->copyrights;
	gtk_about_dialog_set_copyright (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->about_dialog;
	gtk_about_dialog_set_license_type (_tmp10_, GTK_LICENSE_GPL_3_0);
	_tmp11_ = self->priv->about_dialog;
	gtk_about_dialog_set_comments (_tmp11_, _ ("A classic game of positional strategy"));
	_tmp12_ = self->priv->about_dialog;
	gtk_about_dialog_set_authors (_tmp12_, CHESS_APPLICATION_authors);
	_tmp13_ = self->priv->about_dialog;
	gtk_about_dialog_set_artists (_tmp13_, CHESS_APPLICATION_artists);
	_tmp14_ = self->priv->about_dialog;
	gtk_about_dialog_set_translator_credits (_tmp14_, _ ("translator-credits"));
	_tmp15_ = self->priv->about_dialog;
	gtk_about_dialog_set_website (_tmp15_, "https://wiki.gnome.org/Apps/Chess");
	_tmp16_ = self->priv->about_dialog;
	gtk_about_dialog_set_logo_icon_name (_tmp16_, "gnome-chess");
	_tmp17_ = self->priv->about_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp17_, "response", (GCallback) _chess_application_about_response_cb_gtk_dialog_response, self, 0);
	_tmp18_ = self->priv->about_dialog;
	gtk_widget_show ((GtkWidget*) _tmp18_);
}


static void chess_application_run_invalid_pgn_dialog (ChessApplication* self) {
	GtkMessageDialog* invalid_pgn_dialog = NULL;
	GtkApplicationWindow* _tmp0_;
	GtkMessageDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", _ ("This does not look like a valid PGN game."));
	g_object_ref_sink (_tmp1_);
	invalid_pgn_dialog = _tmp1_;
	gtk_dialog_add_button ((GtkDialog*) invalid_pgn_dialog, _ ("_OK"), (gint) GTK_RESPONSE_OK);
	gtk_dialog_run ((GtkDialog*) invalid_pgn_dialog);
	gtk_widget_destroy ((GtkWidget*) invalid_pgn_dialog);
	_g_object_unref0 (invalid_pgn_dialog);
}


static void chess_application_run_invalid_move_dialog (ChessApplication* self, const gchar* error_message) {
	GtkMessageDialog* invalid_move_dialog = NULL;
	GtkApplicationWindow* _tmp0_;
	const gchar* _tmp1_;
	GtkMessageDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_message != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = error_message;
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", _tmp1_);
	g_object_ref_sink (_tmp2_);
	invalid_move_dialog = _tmp2_;
	gtk_dialog_add_button ((GtkDialog*) invalid_move_dialog, _ ("_OK"), (gint) GTK_RESPONSE_OK);
	gtk_dialog_run ((GtkDialog*) invalid_move_dialog);
	gtk_widget_destroy ((GtkWidget*) invalid_move_dialog);
	_g_object_unref0 (invalid_move_dialog);
}


static void chess_application_about_response_cb (ChessApplication* self, gint response_id) {
	GtkAboutDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->about_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_g_object_unref0 (self->priv->about_dialog);
	self->priv->about_dialog = NULL;
}


static void chess_application_add_info_bar_to_bin (ChessApplication* self, GtkBin* bin, GtkInfoBar* * info_bar, GtkLabel* * label) {
	GtkInfoBar* _vala_info_bar = NULL;
	GtkLabel* _vala_label = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp0_;
	GtkInfoBar* _tmp1_;
	GtkContainer* content_area = NULL;
	GtkContainer* _tmp2_;
	GtkContainer* _tmp3_;
	GtkLabel* _tmp4_;
	GtkContainer* child = NULL;
	GtkBin* _tmp5_;
	GtkWidget* _tmp6_;
	GtkContainer* _tmp7_;
	GtkBin* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	GtkBin* _tmp11_;
	GtkBin* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bin != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	vbox = _tmp0_;
	gtk_widget_show ((GtkWidget*) vbox);
	_tmp1_ = (GtkInfoBar*) gtk_info_bar_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (_vala_info_bar);
	_vala_info_bar = _tmp1_;
	_tmp2_ = gtk_info_bar_get_content_area (_vala_info_bar);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer));
	content_area = _tmp3_;
	gtk_box_pack_start (vbox, (GtkWidget*) _vala_info_bar, FALSE, TRUE, (guint) 0);
	_tmp4_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (_vala_label);
	_vala_label = _tmp4_;
	gtk_container_add (content_area, (GtkWidget*) _vala_label);
	gtk_widget_show ((GtkWidget*) _vala_label);
	_tmp5_ = bin;
	_tmp6_ = gtk_bin_get_child (_tmp5_);
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_container_get_type (), GtkContainer));
	child = _tmp7_;
	gtk_widget_reparent ((GtkWidget*) child, (GtkWidget*) vbox);
	_tmp8_ = bin;
	_tmp9_ = gtk_container_get_border_width ((GtkContainer*) _tmp8_);
	_tmp10_ = _tmp9_;
	gtk_container_set_border_width (child, _tmp10_);
	_tmp11_ = bin;
	gtk_container_set_border_width ((GtkContainer*) _tmp11_, (guint) 0);
	gtk_box_set_child_packing (vbox, (GtkWidget*) child, TRUE, TRUE, (guint) 0, GTK_PACK_START);
	_tmp12_ = bin;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) vbox);
	_g_object_unref0 (child);
	_g_object_unref0 (content_area);
	_g_object_unref0 (vbox);
	if (info_bar) {
		*info_bar = _vala_info_bar;
	} else {
		_g_object_unref0 (_vala_info_bar);
	}
	if (label) {
		*label = _vala_label;
	} else {
		_g_object_unref0 (_vala_label);
	}
}


static void chess_application_update_pgn_time_remaining (ChessApplication* self) {
	ChessGame* _tmp0_;
	ChessClock* _tmp1_;
	ChessClock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_clock (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		guint white_initial_time = 0U;
		PGNGame* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		guint black_initial_time = 0U;
		PGNGame* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		guint white_used = 0U;
		ChessGame* _tmp11_;
		ChessClock* _tmp12_;
		ChessClock* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		guint black_used = 0U;
		ChessGame* _tmp16_;
		ChessClock* _tmp17_;
		ChessClock* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		guint white_extra = 0U;
		ChessGame* _tmp21_;
		ChessClock* _tmp22_;
		ChessClock* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		guint black_extra = 0U;
		ChessGame* _tmp26_;
		ChessClock* _tmp27_;
		ChessClock* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		PGNGame* _tmp31_;
		guint _tmp32_;
		guint _tmp33_;
		guint _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		PGNGame* _tmp37_;
		guint _tmp38_;
		guint _tmp39_;
		guint _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp3_ = self->priv->pgn_game;
		_tmp4_ = pgn_game_get_white_time_left (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = atoi (_tmp5_);
		white_initial_time = (guint) _tmp6_;
		_tmp7_ = self->priv->pgn_game;
		_tmp8_ = pgn_game_get_black_time_left (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = atoi (_tmp9_);
		black_initial_time = (guint) _tmp10_;
		_tmp11_ = self->priv->game;
		_tmp12_ = chess_game_get_clock (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = chess_clock_get_white_seconds_used (_tmp13_);
		_tmp15_ = _tmp14_;
		white_used = (guint) _tmp15_;
		_tmp16_ = self->priv->game;
		_tmp17_ = chess_game_get_clock (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = chess_clock_get_black_seconds_used (_tmp18_);
		_tmp20_ = _tmp19_;
		black_used = (guint) _tmp20_;
		_tmp21_ = self->priv->game;
		_tmp22_ = chess_game_get_clock (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = chess_clock_get_white_extra_seconds (_tmp23_);
		_tmp25_ = _tmp24_;
		white_extra = (guint) _tmp25_;
		_tmp26_ = self->priv->game;
		_tmp27_ = chess_game_get_clock (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = chess_clock_get_black_extra_seconds (_tmp28_);
		_tmp30_ = _tmp29_;
		black_extra = (guint) _tmp30_;
		_tmp31_ = self->priv->pgn_game;
		_tmp32_ = white_initial_time;
		_tmp33_ = white_used;
		_tmp34_ = white_extra;
		_tmp35_ = g_strdup_printf ("%u", (_tmp32_ - _tmp33_) + _tmp34_);
		_tmp36_ = _tmp35_;
		pgn_game_set_white_time_left (_tmp31_, _tmp36_);
		_g_free0 (_tmp36_);
		_tmp37_ = self->priv->pgn_game;
		_tmp38_ = black_initial_time;
		_tmp39_ = black_used;
		_tmp40_ = black_extra;
		_tmp41_ = g_strdup_printf ("%u", (_tmp38_ - _tmp39_) + _tmp40_);
		_tmp42_ = _tmp41_;
		pgn_game_set_black_time_left (_tmp37_, _tmp42_);
		_g_free0 (_tmp42_);
	}
}


static void chess_application_save_dialog_cb (ChessApplication* self, gint response_id) {
	gint _tmp0_;
	GtkFileChooserDialog* _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		chess_application_update_pgn_time_remaining (self);
		{
			GtkFileChooserDialog* _tmp1_;
			GFile* _tmp2_;
			PGNGame* _tmp3_;
			GFile* _tmp4_;
			GtkHeaderBar* _tmp5_;
			GFile* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp1_ = self->priv->save_dialog;
			_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp1_);
			_g_object_unref0 (self->priv->game_file);
			self->priv->game_file = _tmp2_;
			_tmp3_ = self->priv->pgn_game;
			_tmp4_ = self->priv->game_file;
			pgn_game_write (_tmp3_, _tmp4_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch5_g_error;
			}
			_tmp5_ = self->priv->headerbar;
			_tmp6_ = self->priv->game_file;
			_tmp7_ = g_file_get_basename (_tmp6_);
			_tmp8_ = _tmp7_;
			gtk_header_bar_set_subtitle (_tmp5_, _tmp8_);
			_g_free0 (_tmp8_);
			chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
			self->priv->game_needs_saving = FALSE;
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			GtkLabel* _tmp11_;
			GtkInfoBar* _tmp12_;
			GtkInfoBar* _tmp13_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("gnome-chess.vala:2296: Failed to save game: %s", _tmp10_);
			_tmp11_ = self->priv->save_dialog_error_label;
			gtk_label_set_text (_tmp11_, _ ("Failed to save game"));
			_tmp12_ = self->priv->save_dialog_info_bar;
			gtk_info_bar_set_message_type (_tmp12_, GTK_MESSAGE_ERROR);
			_tmp13_ = self->priv->save_dialog_info_bar;
			gtk_widget_show ((GtkWidget*) _tmp13_);
			_g_error_free0 (e);
			return;
		}
		__finally5:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = self->priv->save_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp14_);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = NULL;
	_g_object_unref0 (self->priv->save_dialog_info_bar);
	self->priv->save_dialog_info_bar = NULL;
	_g_object_unref0 (self->priv->save_dialog_error_label);
	self->priv->save_dialog_error_label = NULL;
}


static void __lambda6_ (ChessApplication* self) {
	chess_application_save_dialog_cb (self, (gint) GTK_RESPONSE_OK);
}


static void ___lambda6__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
	__lambda6_ ((ChessApplication*) self);
}


static void _chess_application_save_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	chess_application_save_dialog_cb ((ChessApplication*) self, response_id);
}


static void chess_application_present_save_dialog (ChessApplication* self, const gchar* cancel_button_label, const gchar* save_button_label) {
	GtkFileChooserDialog* _tmp0_;
	GtkApplicationWindow* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkFileChooserDialog* _tmp5_;
	GtkFileChooserDialog* _tmp6_;
	GtkInfoBar* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_;
	GtkFileChooserDialog* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GFile* _tmp12_;
	GtkFileFilter* pgn_filter = NULL;
	GtkFileFilter* _tmp24_;
	GtkFileFilter* _tmp25_;
	GtkFileFilter* _tmp26_;
	GtkFileChooserDialog* _tmp27_;
	GtkFileFilter* _tmp28_;
	GtkFileFilter* _tmp29_;
	GtkFileFilter* all_filter = NULL;
	GtkFileFilter* _tmp30_;
	GtkFileFilter* _tmp31_;
	GtkFileFilter* _tmp32_;
	GtkFileChooserDialog* _tmp33_;
	GtkFileFilter* _tmp34_;
	GtkFileFilter* _tmp35_;
	GtkFileChooserDialog* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cancel_button_label != NULL);
	g_return_if_fail (save_button_label != NULL);
	_tmp0_ = self->priv->save_dialog;
	if (_tmp0_ != NULL) {
		GtkFileChooserDialog* _tmp1_;
		_tmp1_ = self->priv->save_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp1_);
		return;
	}
	_tmp2_ = self->priv->window;
	_tmp3_ = cancel_button_label;
	_tmp4_ = save_button_label;
	_tmp5_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Save Chess Game"), (GtkWindow*) _tmp2_, GTK_FILE_CHOOSER_ACTION_SAVE, _ (_tmp3_), GTK_RESPONSE_CANCEL, _ (_tmp4_), GTK_RESPONSE_OK, NULL, NULL);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = _tmp5_;
	_tmp6_ = self->priv->save_dialog;
	chess_application_add_info_bar_to_bin (self, (GtkBin*) _tmp6_, &_tmp7_, &_tmp8_);
	_g_object_unref0 (self->priv->save_dialog_info_bar);
	self->priv->save_dialog_info_bar = _tmp7_;
	_g_object_unref0 (self->priv->save_dialog_error_label);
	self->priv->save_dialog_error_label = _tmp8_;
	_tmp9_ = self->priv->save_dialog;
	g_signal_connect_object ((GtkFileChooser*) _tmp9_, "file-activated", (GCallback) ___lambda6__gtk_file_chooser_file_activated, self, 0);
	_tmp10_ = self->priv->save_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp10_, "response", (GCallback) _chess_application_save_dialog_cb_gtk_dialog_response, self, 0);
	_tmp12_ = self->priv->game_file;
	if (_tmp12_ != NULL) {
		GFile* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp13_ = self->priv->game_file;
		_tmp14_ = g_file_get_path (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = self->priv->autosave_filename;
		_tmp11_ = g_strcmp0 (_tmp15_, _tmp16_) != 0;
		_g_free0 (_tmp15_);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GtkFileChooserDialog* _tmp17_;
		GFile* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp17_ = self->priv->save_dialog;
		_tmp18_ = self->priv->game_file;
		_tmp19_ = g_file_get_path (_tmp18_);
		_tmp20_ = _tmp19_;
		gtk_file_chooser_set_filename ((GtkFileChooser*) _tmp17_, _tmp20_);
		_g_free0 (_tmp20_);
	} else {
		GtkFileChooserDialog* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp21_ = self->priv->save_dialog;
		_tmp22_ = g_strconcat (_ ("Untitled Chess Game"), ".pgn", NULL);
		_tmp23_ = _tmp22_;
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp21_, _tmp23_);
		_g_free0 (_tmp23_);
	}
	_tmp24_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp24_);
	pgn_filter = _tmp24_;
	_tmp25_ = pgn_filter;
	gtk_file_filter_set_name (_tmp25_, _ ("PGN files"));
	_tmp26_ = pgn_filter;
	gtk_file_filter_add_pattern (_tmp26_, "*.pgn");
	_tmp27_ = self->priv->save_dialog;
	_tmp28_ = pgn_filter;
	_tmp29_ = _g_object_ref0 (_tmp28_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp27_, _tmp29_);
	_tmp30_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp30_);
	all_filter = _tmp30_;
	_tmp31_ = all_filter;
	gtk_file_filter_set_name (_tmp31_, _ ("All files"));
	_tmp32_ = all_filter;
	gtk_file_filter_add_pattern (_tmp32_, "*");
	_tmp33_ = self->priv->save_dialog;
	_tmp34_ = all_filter;
	_tmp35_ = _g_object_ref0 (_tmp34_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp33_, _tmp35_);
	_tmp36_ = self->priv->save_dialog;
	gtk_dialog_run ((GtkDialog*) _tmp36_);
	_g_object_unref0 (all_filter);
	_g_object_unref0 (pgn_filter);
}


void chess_application_save_game_cb (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game_file;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp2_ = self->priv->game_file;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->autosave_filename;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
		_g_free0 (_tmp4_);
	}
	if (_tmp0_) {
		chess_application_present_save_dialog (self, N_ ("_Cancel"), N_ ("_Save"));
		return;
	}
	chess_application_update_pgn_time_remaining (self);
	{
		PGNGame* _tmp6_;
		GFile* _tmp7_;
		_tmp6_ = self->priv->pgn_game;
		_tmp7_ = self->priv->game_file;
		pgn_game_write (_tmp6_, _tmp7_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		chess_application_present_save_dialog (self, N_ ("_Cancel"), N_ ("_Save"));
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void chess_application_save_game_as_cb (ChessApplication* self) {
	g_return_if_fail (self != NULL);
	chess_application_present_save_dialog (self, N_ ("_Cancel"), N_ ("_Save"));
}


static void __lambda9_ (ChessApplication* self) {
	chess_application_open_dialog_cb (self, (gint) GTK_RESPONSE_OK);
}


static void ___lambda9__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
	__lambda9_ ((ChessApplication*) self);
}


static void _chess_application_open_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	chess_application_open_dialog_cb ((ChessApplication*) self, response_id);
}


void chess_application_open_game_cb (ChessApplication* self) {
	gboolean _tmp0_;
	GtkFileChooserDialog* _tmp1_;
	GtkApplicationWindow* _tmp3_;
	GtkFileChooserDialog* _tmp4_;
	GtkFileChooserDialog* _tmp5_;
	GtkInfoBar* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkFileChooserDialog* _tmp8_;
	GtkFileChooserDialog* _tmp9_;
	GtkFileFilter* pgn_filter = NULL;
	GtkFileFilter* _tmp10_;
	GtkFileFilter* _tmp11_;
	GtkFileFilter* _tmp12_;
	GtkFileChooserDialog* _tmp13_;
	GtkFileFilter* _tmp14_;
	GtkFileFilter* _tmp15_;
	GtkFileFilter* all_filter = NULL;
	GtkFileFilter* _tmp16_;
	GtkFileFilter* _tmp17_;
	GtkFileFilter* _tmp18_;
	GtkFileChooserDialog* _tmp19_;
	GtkFileFilter* _tmp20_;
	GtkFileFilter* _tmp21_;
	GtkFileChooserDialog* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_application_prompt_save_game (self, _ ("Save this game before loading another one?"));
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->open_dialog;
	if (_tmp1_ != NULL) {
		GtkFileChooserDialog* _tmp2_;
		_tmp2_ = self->priv->open_dialog;
		gtk_window_present ((GtkWindow*) _tmp2_);
		return;
	}
	_tmp3_ = self->priv->window;
	_tmp4_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Load Chess Game"), (GtkWindow*) _tmp3_, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Open"), GTK_RESPONSE_OK, NULL, NULL);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->open_dialog);
	self->priv->open_dialog = _tmp4_;
	_tmp5_ = self->priv->open_dialog;
	chess_application_add_info_bar_to_bin (self, (GtkBin*) _tmp5_, &_tmp6_, &_tmp7_);
	_g_object_unref0 (self->priv->open_dialog_info_bar);
	self->priv->open_dialog_info_bar = _tmp6_;
	_g_object_unref0 (self->priv->open_dialog_error_label);
	self->priv->open_dialog_error_label = _tmp7_;
	_tmp8_ = self->priv->open_dialog;
	g_signal_connect_object ((GtkFileChooser*) _tmp8_, "file-activated", (GCallback) ___lambda9__gtk_file_chooser_file_activated, self, 0);
	_tmp9_ = self->priv->open_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp9_, "response", (GCallback) _chess_application_open_dialog_cb_gtk_dialog_response, self, 0);
	_tmp10_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp10_);
	pgn_filter = _tmp10_;
	_tmp11_ = pgn_filter;
	gtk_file_filter_set_name (_tmp11_, _ ("PGN files"));
	_tmp12_ = pgn_filter;
	gtk_file_filter_add_pattern (_tmp12_, "*.pgn");
	_tmp13_ = self->priv->open_dialog;
	_tmp14_ = pgn_filter;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp13_, _tmp15_);
	_tmp16_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp16_);
	all_filter = _tmp16_;
	_tmp17_ = all_filter;
	gtk_file_filter_set_name (_tmp17_, _ ("All files"));
	_tmp18_ = all_filter;
	gtk_file_filter_add_pattern (_tmp18_, "*");
	_tmp19_ = self->priv->open_dialog;
	_tmp20_ = all_filter;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp19_, _tmp21_);
	_tmp22_ = self->priv->open_dialog;
	gtk_window_present ((GtkWindow*) _tmp22_);
	_g_object_unref0 (all_filter);
	_g_object_unref0 (pgn_filter);
}


static void chess_application_open_dialog_cb (ChessApplication* self, gint response_id) {
	gint _tmp0_;
	GtkFileChooserDialog* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		{
			GtkFileChooserDialog* _tmp1_;
			GFile* _tmp2_;
			GFile* _tmp3_;
			_tmp1_ = self->priv->open_dialog;
			_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp1_);
			_g_object_unref0 (self->priv->game_file);
			self->priv->game_file = _tmp2_;
			_tmp3_ = self->priv->game_file;
			chess_application_load_game (self, _tmp3_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch7_g_error;
			}
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			GtkLabel* _tmp6_;
			GtkInfoBar* _tmp7_;
			GtkInfoBar* _tmp8_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("gnome-chess.vala:2427: Failed to open game: %s", _tmp5_);
			_tmp6_ = self->priv->open_dialog_error_label;
			gtk_label_set_text (_tmp6_, _ ("Failed to open game"));
			_tmp7_ = self->priv->open_dialog_info_bar;
			gtk_info_bar_set_message_type (_tmp7_, GTK_MESSAGE_ERROR);
			_tmp8_ = self->priv->open_dialog_info_bar;
			gtk_widget_show ((GtkWidget*) _tmp8_);
			_g_error_free0 (e);
			return;
		}
		__finally7:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp9_ = self->priv->open_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp9_);
	_g_object_unref0 (self->priv->open_dialog);
	self->priv->open_dialog = NULL;
	_g_object_unref0 (self->priv->open_dialog_info_bar);
	self->priv->open_dialog_info_bar = NULL;
	_g_object_unref0 (self->priv->open_dialog_error_label);
	self->priv->open_dialog_error_label = NULL;
}


static void chess_application_start_new_game (ChessApplication* self) {
	PGNGame* _tmp0_;
	GDateTime* now = NULL;
	GDateTime* _tmp1_;
	PGNGame* _tmp2_;
	GDateTime* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	PGNGame* _tmp6_;
	GDateTime* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint duration = 0;
	GSettings* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gchar* engine_name = NULL;
	GSettings* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* engine_level = NULL;
	GSettings* _tmp35_;
	gchar* _tmp36_;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp38_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = NULL;
	chess_application_disable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
	chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
	_tmp0_ = pgn_game_new ();
	_g_object_unref0 (self->priv->pgn_game);
	self->priv->pgn_game = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = self->priv->pgn_game;
	_tmp3_ = now;
	_tmp4_ = g_date_time_format (_tmp3_, "%Y.%m.%d");
	_tmp5_ = _tmp4_;
	pgn_game_set_date (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->pgn_game;
	_tmp7_ = now;
	_tmp8_ = g_date_time_format (_tmp7_, "%H:%M:%S");
	_tmp9_ = _tmp8_;
	pgn_game_set_time (_tmp6_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->settings;
	_tmp11_ = g_settings_get_int (_tmp10_, "duration");
	duration = _tmp11_;
	_tmp12_ = duration;
	if (_tmp12_ > 0) {
		PGNGame* _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		PGNGame* _tmp17_;
		gint _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		PGNGame* _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp13_ = self->priv->pgn_game;
		_tmp14_ = duration;
		_tmp15_ = g_strdup_printf ("%i", _tmp14_);
		_tmp16_ = _tmp15_;
		pgn_game_set_time_control (_tmp13_, _tmp16_);
		_g_free0 (_tmp16_);
		_tmp17_ = self->priv->pgn_game;
		_tmp18_ = duration;
		_tmp19_ = g_strdup_printf ("%i", _tmp18_);
		_tmp20_ = _tmp19_;
		pgn_game_set_white_time_left (_tmp17_, _tmp20_);
		_g_free0 (_tmp20_);
		_tmp21_ = self->priv->pgn_game;
		_tmp22_ = duration;
		_tmp23_ = g_strdup_printf ("%i", _tmp22_);
		_tmp24_ = _tmp23_;
		pgn_game_set_black_time_left (_tmp21_, _tmp24_);
		_g_free0 (_tmp24_);
	}
	_tmp25_ = self->priv->settings;
	_tmp26_ = g_settings_get_string (_tmp25_, "opponent");
	engine_name = _tmp26_;
	_tmp27_ = engine_name;
	if (g_strcmp0 (_tmp27_, "") == 0) {
		GList* _tmp28_;
		_tmp28_ = self->priv->ai_profiles;
		if (_tmp28_ != NULL) {
			GList* _tmp29_;
			gconstpointer _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp29_ = self->priv->ai_profiles;
			_tmp30_ = _tmp29_->data;
			_tmp31_ = ai_profile_get_name ((AIProfile*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strdup (_tmp32_);
			_g_free0 (engine_name);
			engine_name = _tmp33_;
		} else {
			gchar* _tmp34_;
			_tmp34_ = g_strdup ("human");
			_g_free0 (engine_name);
			engine_name = _tmp34_;
		}
	}
	_tmp35_ = self->priv->settings;
	_tmp36_ = g_settings_get_string (_tmp35_, "difficulty");
	engine_level = _tmp36_;
	_tmp38_ = engine_name;
	if (_tmp38_ != NULL) {
		const gchar* _tmp39_;
		_tmp39_ = engine_name;
		_tmp37_ = g_strcmp0 (_tmp39_, "human") != 0;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		gchar* play_as = NULL;
		GSettings* _tmp40_;
		gchar* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp48_;
		GSettings* _tmp58_;
		const gchar* _tmp59_;
		_tmp40_ = self->priv->settings;
		_tmp41_ = g_settings_get_string (_tmp40_, "play-as");
		play_as = _tmp41_;
		_tmp42_ = play_as;
		if (g_strcmp0 (_tmp42_, "alternate") == 0) {
			gchar* last_side = NULL;
			GSettings* _tmp43_;
			gchar* _tmp44_;
			const gchar* _tmp45_ = NULL;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			_tmp43_ = self->priv->settings;
			_tmp44_ = g_settings_get_string (_tmp43_, "last-played-as");
			last_side = _tmp44_;
			_tmp46_ = last_side;
			if (g_strcmp0 (_tmp46_, "white") == 0) {
				_tmp45_ = "black";
			} else {
				_tmp45_ = "white";
			}
			_tmp47_ = g_strdup (_tmp45_);
			_g_free0 (play_as);
			play_as = _tmp47_;
			_g_free0 (last_side);
		}
		_tmp48_ = play_as;
		if (g_strcmp0 (_tmp48_, "white") == 0) {
			PGNGame* _tmp49_;
			const gchar* _tmp50_;
			PGNGame* _tmp51_;
			const gchar* _tmp52_;
			_tmp49_ = self->priv->pgn_game;
			_tmp50_ = engine_name;
			pgn_game_set_black_ai (_tmp49_, _tmp50_);
			_tmp51_ = self->priv->pgn_game;
			_tmp52_ = engine_level;
			pgn_game_set_black_level (_tmp51_, _tmp52_);
		} else {
			const gchar* _tmp53_;
			_tmp53_ = play_as;
			if (g_strcmp0 (_tmp53_, "black") == 0) {
				PGNGame* _tmp54_;
				const gchar* _tmp55_;
				PGNGame* _tmp56_;
				const gchar* _tmp57_;
				_tmp54_ = self->priv->pgn_game;
				_tmp55_ = engine_name;
				pgn_game_set_white_ai (_tmp54_, _tmp55_);
				_tmp56_ = self->priv->pgn_game;
				_tmp57_ = engine_level;
				pgn_game_set_white_level (_tmp56_, _tmp57_);
			} else {
				g_assert_not_reached ();
			}
		}
		_tmp58_ = self->priv->settings;
		_tmp59_ = play_as;
		g_settings_set_string (_tmp58_, "last-played-as", _tmp59_);
		_g_free0 (play_as);
	}
	chess_application_start_game (self);
	_g_free0 (engine_level);
	_g_free0 (engine_name);
	_g_date_time_unref0 (now);
}


static void chess_application_load_game (ChessApplication* self, GFile* file, GError** error) {
	PGN* pgn = NULL;
	GFile* _tmp0_;
	PGN* _tmp1_;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	PGNGame* _tmp4_;
	PGNGame* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	chess_application_enable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
	_tmp0_ = file;
	_tmp1_ = pgn_new_from_file (_tmp0_, &_inner_error_);
	pgn = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = pgn->games;
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
	_tmp4_ = _g_object_ref0 ((PGNGame*) _tmp3_);
	_g_object_unref0 (self->priv->pgn_game);
	self->priv->pgn_game = _tmp4_;
	_tmp5_ = self->priv->pgn_game;
	if (_tmp5_ == NULL) {
		PGNGame* _tmp6_;
		chess_application_run_invalid_pgn_dialog (self);
		_tmp6_ = pgn_game_new ();
		_g_object_unref0 (self->priv->pgn_game);
		self->priv->pgn_game = _tmp6_;
		_g_object_unref0 (self->priv->game_file);
		self->priv->game_file = NULL;
	} else {
		GFile* _tmp7_;
		GFile* _tmp8_;
		_tmp7_ = file;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (self->priv->game_file);
		self->priv->game_file = _tmp8_;
		chess_application_start_game (self);
	}
	_g_object_unref0 (pgn);
}


static void chess_application_enable_window_action (ChessApplication* self, const gchar* name) {
	GtkApplicationWindow* _tmp0_;
	const gchar* _tmp1_;
	GAction* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = name;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, _tmp1_);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction), TRUE);
}


static void chess_application_disable_window_action (ChessApplication* self, const gchar* name) {
	GtkApplicationWindow* _tmp0_;
	const gchar* _tmp1_;
	GAction* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = name;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, _tmp1_);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction), FALSE);
}


gint chess_application_main (gchar** args, int args_length1) {
	gint result = 0;
	ChessApplication* _tmp0_;
	ChessApplication* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gint _tmp4_;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_application_name (_ ("Chess"));
	gtk_window_set_default_icon_name ("gnome-chess");
	_tmp0_ = chess_application_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = g_application_run ((GApplication*) _tmp1_, _tmp2__length1, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


int main (int argc, char ** argv) {
	return chess_application_main (argv, argc);
}


static void chess_application_class_init (ChessApplicationClass * klass) {
	chess_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessApplicationPrivate));
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication *, GVariantDict*)) chess_application_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication *)) chess_application_real_startup;
	((GApplicationClass *) klass)->open = (void (*) (GApplication *, GFile**, int, const gchar*)) chess_application_real_open;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication *)) chess_application_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication *)) chess_application_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = chess_application_finalize;
}


static void chess_application_instance_init (ChessApplication * self) {
	gchar* _tmp0_;
	self->priv = CHESS_APPLICATION_GET_PRIVATE (self);
	self->priv->preferences_dialog = NULL;
	self->priv->save_duration_timeout = (guint) 0;
	self->priv->open_dialog = NULL;
	self->priv->open_dialog_info_bar = NULL;
	self->priv->open_dialog_error_label = NULL;
	self->priv->save_dialog = NULL;
	self->priv->save_dialog_info_bar = NULL;
	self->priv->save_dialog_error_label = NULL;
	self->priv->about_dialog = NULL;
	self->priv->game_needs_saving = FALSE;
	self->priv->starting = TRUE;
	self->priv->opponent = NULL;
	self->priv->human_player = NULL;
	self->priv->opponent_engine = NULL;
	self->priv->engine_timeout_counter = 10;
	_tmp0_ = g_strdup ("Copyright \302\251 2010\342\200\2232013 Robert Ancell\n" \
"Copyright \302\251 2013\342\200\2232014 Michael Catanzaro\n" \
"Copyright \302\251 2015\342\200\2232016 Sahil Sareen");
	self->priv->copyrights = _tmp0_;
}


static void chess_application_finalize (GObject * obj) {
	ChessApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_APPLICATION, ChessApplication);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->view_container);
	_g_object_unref0 (self->priv->scene);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->pause_resume_button);
	_g_object_unref0 (self->priv->first_move_button);
	_g_object_unref0 (self->priv->prev_move_button);
	_g_object_unref0 (self->priv->next_move_button);
	_g_object_unref0 (self->priv->last_move_button);
	_g_object_unref0 (self->priv->history_combo);
	_g_object_unref0 (self->priv->white_time_label);
	_g_object_unref0 (self->priv->black_time_label);
	_g_object_unref0 (self->priv->timer_increment_label);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->side_combo);
	_g_object_unref0 (self->priv->difficulty_combo);
	_g_object_unref0 (self->priv->duration_combo);
	_g_object_unref0 (self->priv->clock_type_combo);
	_g_object_unref0 (self->priv->duration_adjustment);
	_g_object_unref0 (self->priv->timer_increment_adjustment);
	_g_object_unref0 (self->priv->custom_duration_box);
	_g_object_unref0 (self->priv->timer_increment_box);
	_g_object_unref0 (self->priv->timer_increment_units_combo);
	_g_object_unref0 (self->priv->custom_duration_units_combo);
	_g_object_unref0 (self->priv->open_dialog);
	_g_object_unref0 (self->priv->open_dialog_info_bar);
	_g_object_unref0 (self->priv->open_dialog_error_label);
	_g_object_unref0 (self->priv->save_dialog);
	_g_object_unref0 (self->priv->save_dialog_info_bar);
	_g_object_unref0 (self->priv->save_dialog_error_label);
	_g_object_unref0 (self->priv->about_dialog);
	_g_object_unref0 (self->priv->pgn_game);
	_g_object_unref0 (self->priv->game);
	_g_free0 (self->priv->autosave_filename);
	_g_object_unref0 (self->priv->game_file);
	__g_list_free__g_object_unref0_0 (self->priv->ai_profiles);
	_g_object_unref0 (self->priv->opponent);
	_g_object_unref0 (self->priv->human_player);
	_g_object_unref0 (self->priv->opponent_engine);
	_g_free0 (self->priv->copyrights);
	G_OBJECT_CLASS (chess_application_parent_class)->finalize (obj);
}


GType chess_application_get_type (void) {
	static volatile gsize chess_application_type_id__volatile = 0;
	if (g_once_init_enter (&chess_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessApplication), 0, (GInstanceInitFunc) chess_application_instance_init, NULL };
		GType chess_application_type_id;
		chess_application_type_id = g_type_register_static (gtk_application_get_type (), "ChessApplication", &g_define_type_info, 0);
		g_once_init_leave (&chess_application_type_id__volatile, chess_application_type_id);
	}
	return chess_application_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



