/* chess-engine.c generated by valac 0.37.1.6-1eaec, the Vala compiler
 * generated from chess-engine.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2014 Michael Catanzaro
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include "libchess.h"
#include "portability.h"
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <string.h>
#include <stdlib.h>


#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;
enum  {
	CHESS_ENGINE_DUMMY_PROPERTY,
	CHESS_ENGINE_READY,
	CHESS_ENGINE_LAST_PROPERTY
};
static GParamSpec* chess_engine_properties[CHESS_ENGINE_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	CHESS_ENGINE_STARTING_SIGNAL,
	CHESS_ENGINE_READY_CHANGED_SIGNAL,
	CHESS_ENGINE_MOVED_SIGNAL,
	CHESS_ENGINE_RESIGNED_SIGNAL,
	CHESS_ENGINE_STOPPED_UNEXPECTEDLY_SIGNAL,
	CHESS_ENGINE_ERROR_SIGNAL,
	CHESS_ENGINE_CLAIM_DRAW_SIGNAL,
	CHESS_ENGINE_OFFER_DRAW_SIGNAL,
	CHESS_ENGINE_LAST_SIGNAL
};
static guint chess_engine_signals[CHESS_ENGINE_LAST_SIGNAL] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*do_undo) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
};

struct _ChessEnginePrivate {
	gchar* binary;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	guint delay_seconds;
	guint pending_move_source_id;
	GPid pid;
	gint stdin_fd;
	gint stderr_fd;
	GIOChannel* stdout_channel;
	guint child_watch_id;
	guint stdout_watch_id;
	gboolean started;
	gboolean _ready;
};


static gpointer chess_engine_parent_class = NULL;

GType chess_engine_get_type (void) G_GNUC_CONST;
#define CHESS_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_ENGINE, ChessEnginePrivate))
void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1);
static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1);
ChessEngine* chess_engine_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds);
static gchar** _vala_array_dup19 (gchar** self, int length);
gboolean chess_engine_start (ChessEngine* self);
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar** * array, int* length, int* size, gchar* value);
static void ___lambda4_ (ChessEngine* self);
static void ____lambda4__gspawn_child_setup_func (gpointer self);
static void chess_engine_engine_stopped_cb (ChessEngine* self, GPid pid);
static void _chess_engine_engine_stopped_cb_gchild_watch_func (GPid pid, gint status, gpointer self);
static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition);
static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
void chess_engine_stop (ChessEngine* self, gboolean kill_engine);
void chess_engine_start_game (ChessEngine* self);
static void chess_engine_real_start_game (ChessEngine* self);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_do_undo (ChessEngine* self);
static void chess_engine_real_do_undo (ChessEngine* self);
void chess_engine_request_move (ChessEngine* self);
static void chess_engine_real_request_move (ChessEngine* self);
void chess_engine_move (ChessEngine* self);
static gboolean __lambda5_ (ChessEngine* self);
static gboolean ___lambda5__gsource_func (gpointer self);
void chess_engine_undo (ChessEngine* self);
void chess_engine_write (ChessEngine* self, gchar* data, int data_length1);
void chess_engine_write_line (ChessEngine* self, const gchar* line);
gboolean chess_engine_get_ready (ChessEngine* self);
void chess_engine_set_ready (ChessEngine* self, gboolean value);
static void chess_engine_finalize (GObject * obj);
static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1) {
}


void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->process_input (self, data, data_length1);
}


static gchar** _vala_array_dup19 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


ChessEngine* chess_engine_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds) {
	ChessEngine * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	guint _tmp4_;
	g_return_val_if_fail (binary != NULL, NULL);
	self = (ChessEngine*) g_object_new (object_type, NULL);
	_tmp0_ = binary;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->binary);
	self->priv->binary = _tmp1_;
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup19 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
	self->priv->args = _tmp3_;
	self->priv->args_length1 = _tmp3__length1;
	self->priv->_args_size_ = self->priv->args_length1;
	_tmp4_ = delay_seconds;
	self->priv->delay_seconds = _tmp4_;
	return self;
}


static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void ___lambda4_ (ChessEngine* self) {
	maybe_kill_orphan_engine ();
}


static void ____lambda4__gspawn_child_setup_func (gpointer self) {
	___lambda4_ ((ChessEngine*) self);
}


static void _chess_engine_engine_stopped_cb_gchild_watch_func (GPid pid, gint status, gpointer self) {
	chess_engine_engine_stopped_cb ((ChessEngine*) self, pid);
}


static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = chess_engine_read_cb ((ChessEngine*) self, source, condition);
	return result;
}


gboolean chess_engine_start (ChessEngine* self) {
	gboolean result = FALSE;
	GPid _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	gchar** argv = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gint stdout_fd = 0;
	GPid _tmp24_;
	guint _tmp25_;
	gint _tmp26_;
	GIOChannel* _tmp27_;
	GIOChannel* _tmp33_;
	GIOChannel* _tmp34_;
	guint _tmp35_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pid;
	_vala_return_val_if_fail (_tmp0_ == ((GPid) 0), "pid == 0", FALSE);
	_tmp1_ = self->priv->child_watch_id;
	_vala_return_val_if_fail (_tmp1_ == ((guint) 0), "child_watch_id == 0", FALSE);
	_tmp2_ = self->priv->stdout_watch_id;
	_vala_return_val_if_fail (_tmp2_ == ((guint) 0), "stdout_watch_id == 0", FALSE);
	_tmp3_ = self->priv->stdin_fd;
	_vala_return_val_if_fail (_tmp3_ == -1, "stdin_fd == -1", FALSE);
	_tmp4_ = self->priv->stderr_fd;
	_vala_return_val_if_fail (_tmp4_ == -1, "stderr_fd == -1", FALSE);
	_tmp5_ = self->priv->started;
	_vala_return_val_if_fail (!_tmp5_, "!started", FALSE);
	_tmp6_ = self->priv->binary;
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = g_new0 (gchar*, 1 + 1);
	_tmp8_[0] = _tmp7_;
	argv = _tmp8_;
	argv_length1 = 1;
	_argv_size_ = argv_length1;
	_tmp9_ = self->priv->args;
	_tmp9__length1 = self->priv->args_length1;
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp9_;
		arg_collection_length1 = _tmp9__length1;
		for (arg_it = 0; arg_it < _tmp9__length1; arg_it = arg_it + 1) {
			gchar* _tmp10_;
			gchar* arg = NULL;
			_tmp10_ = g_strdup (arg_collection[arg_it]);
			arg = _tmp10_;
			{
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = argv;
				_tmp11__length1 = argv_length1;
				_tmp12_ = arg;
				_tmp13_ = g_strdup (_tmp12_);
				_vala_array_add1 (&argv, &argv_length1, &_argv_size_, _tmp13_);
				_g_free0 (arg);
			}
		}
	}
	_tmp14_ = argv;
	_tmp14__length1 = argv_length1;
	_vala_array_add2 (&argv, &argv_length1, &_argv_size_, NULL);
	{
		gchar** _tmp15_;
		gint _tmp15__length1;
		GPid _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		_tmp15_ = argv;
		_tmp15__length1 = argv_length1;
		g_spawn_async_with_pipes (NULL, _tmp15_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, ____lambda4__gspawn_child_setup_func, self, &_tmp16_, &_tmp17_, &_tmp18_, &_tmp19_, &_inner_error_);
		self->priv->pid = _tmp16_;
		self->priv->stdin_fd = _tmp17_;
		stdout_fd = _tmp18_;
		self->priv->stderr_fd = _tmp19_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp20_ = FALSE;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch10_g_spawn_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp20_;
		}
	}
	goto __finally10;
	__catch10_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("chess-engine.vala:90: Failed to execute chess engine: %s\n", _tmp22_);
		result = FALSE;
		_g_error_free0 (e);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp23_ = FALSE;
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp23_;
	}
	_tmp24_ = self->priv->pid;
	_tmp25_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp24_, _chess_engine_engine_stopped_cb_gchild_watch_func, g_object_ref (self), g_object_unref);
	self->priv->child_watch_id = _tmp25_;
	_tmp26_ = stdout_fd;
	_tmp27_ = g_io_channel_unix_new (_tmp26_);
	_g_io_channel_unref0 (self->priv->stdout_channel);
	self->priv->stdout_channel = _tmp27_;
	{
		GIOChannel* _tmp28_;
		_tmp28_ = self->priv->stdout_channel;
		g_io_channel_set_flags (_tmp28_, G_IO_FLAG_NONBLOCK, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp29_ = FALSE;
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch11_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp29_;
		}
	}
	goto __finally11;
	__catch11_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		g_warning ("chess-engine.vala:103: Failed to set input from chess engine to non-bl" \
"ocking: %s", _tmp31_);
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp32_ = FALSE;
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp32_;
	}
	_tmp33_ = self->priv->stdout_channel;
	g_io_channel_set_close_on_unref (_tmp33_, TRUE);
	_tmp34_ = self->priv->stdout_channel;
	_tmp35_ = g_io_add_watch (_tmp34_, G_IO_IN, _chess_engine_read_cb_gio_func, self);
	self->priv->stdout_watch_id = _tmp35_;
	self->priv->started = TRUE;
	g_signal_emit (self, chess_engine_signals[CHESS_ENGINE_STARTING_SIGNAL], 0);
	result = TRUE;
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void chess_engine_engine_stopped_cb (ChessEngine* self, GPid pid) {
	gboolean _tmp0_;
	GPid _tmp1_;
	GPid _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->started;
	_vala_return_if_fail (_tmp0_, "started");
	_tmp1_ = pid;
	_tmp2_ = self->priv->pid;
	_vala_return_if_fail (_tmp1_ == _tmp2_, "pid == this.pid");
	chess_engine_stop (self, FALSE);
	g_signal_emit (self, chess_engine_signals[CHESS_ENGINE_STOPPED_UNEXPECTEDLY_SIGNAL], 0);
}


static void chess_engine_real_start_game (ChessEngine* self) {
	g_critical ("Type `%s' does not implement abstract method `chess_engine_start_game'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void chess_engine_start_game (ChessEngine* self) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->start_game (self);
}


static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move) {
	g_critical ("Type `%s' does not implement abstract method `chess_engine_report_move'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void chess_engine_report_move (ChessEngine* self, ChessMove* move) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->report_move (self, move);
}


static void chess_engine_real_do_undo (ChessEngine* self) {
	g_critical ("Type `%s' does not implement abstract method `chess_engine_do_undo'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void chess_engine_do_undo (ChessEngine* self) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->do_undo (self);
}


static void chess_engine_real_request_move (ChessEngine* self) {
	g_critical ("Type `%s' does not implement abstract method `chess_engine_request_move'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void chess_engine_request_move (ChessEngine* self) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->request_move (self);
}


static gboolean __lambda5_ (ChessEngine* self) {
	gboolean result = FALSE;
	self->priv->pending_move_source_id = (guint) 0;
	chess_engine_request_move (self);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ ((ChessEngine*) self);
	return result;
}


void chess_engine_move (ChessEngine* self) {
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->delay_seconds;
	_tmp1_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _tmp0_, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->pending_move_source_id = _tmp1_;
}


void chess_engine_undo (ChessEngine* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending_move_source_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->pending_move_source_id;
		g_source_remove (_tmp1_);
		self->priv->pending_move_source_id = (guint) 0;
	}
	chess_engine_do_undo (self);
}


void chess_engine_stop (ChessEngine* self, gboolean kill_engine) {
	gboolean _tmp0_;
	GIOChannel* _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_;
	GPid _tmp7_;
	gboolean _tmp8_;
	guint _tmp9_;
	gboolean _tmp10_;
	guint _tmp11_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp20_;
	gint _tmp21_;
	guint _tmp24_;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_;
	GPid _tmp31_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->started;
	_tmp1_ = self->priv->stdout_channel;
	_vala_return_if_fail ((!_tmp0_) || (_tmp1_ != NULL), "!started || stdout_channel != null");
	_tmp2_ = self->priv->started;
	_tmp3_ = self->priv->stdin_fd;
	_vala_return_if_fail ((!_tmp2_) || (_tmp3_ != -1), "!started || stdin_fd != -1");
	_tmp4_ = self->priv->started;
	_tmp5_ = self->priv->stderr_fd;
	_vala_return_if_fail ((!_tmp4_) || (_tmp5_ != -1), "!started || stderr_fd != -1");
	_tmp6_ = self->priv->started;
	_tmp7_ = self->priv->pid;
	_vala_return_if_fail ((!_tmp6_) || (_tmp7_ != ((GPid) 0)), "!started || pid != 0");
	_tmp8_ = self->priv->started;
	_tmp9_ = self->priv->child_watch_id;
	_vala_return_if_fail ((!_tmp8_) || (_tmp9_ != ((guint) 0)), "!started || child_watch_id != 0");
	_tmp10_ = self->priv->started;
	if (!_tmp10_) {
		return;
	}
	self->priv->started = FALSE;
	_tmp11_ = self->priv->stdout_watch_id;
	if (_tmp11_ != ((guint) 0)) {
		guint _tmp12_;
		_tmp12_ = self->priv->stdout_watch_id;
		g_source_remove (_tmp12_);
		self->priv->stdout_watch_id = (guint) 0;
	}
	{
		GIOChannel* _tmp13_;
		_tmp13_ = self->priv->stdout_channel;
		g_io_channel_shutdown (_tmp13_, FALSE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch12_g_io_channel_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally12;
	__catch12_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("chess-engine.vala:173: Failed to close channel to engine's stdout: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_io_channel_unref0 (self->priv->stdout_channel);
	self->priv->stdout_channel = NULL;
	_tmp16_ = self->priv->stdin_fd;
	_tmp17_ = close (_tmp16_);
	if (_tmp17_ == -1) {
		gint _tmp18_;
		const gchar* _tmp19_;
		_tmp18_ = errno;
		_tmp19_ = g_strerror (_tmp18_);
		g_warning ("chess-engine.vala:178: Failed to close pipe to engine's stdin: %s", _tmp19_);
	}
	self->priv->stdin_fd = -1;
	_tmp20_ = self->priv->stderr_fd;
	_tmp21_ = close (_tmp20_);
	if (_tmp21_ == -1) {
		gint _tmp22_;
		const gchar* _tmp23_;
		_tmp22_ = errno;
		_tmp23_ = g_strerror (_tmp22_);
		g_warning ("chess-engine.vala:182: Failed to close pipe to engine's stderr: %s", _tmp23_);
	}
	self->priv->stderr_fd = -1;
	_tmp24_ = self->priv->child_watch_id;
	g_source_remove (_tmp24_);
	self->priv->child_watch_id = (guint) 0;
	_tmp26_ = kill_engine;
	if (_tmp26_) {
		GPid _tmp27_;
		gint _tmp28_;
		_tmp27_ = self->priv->pid;
		_tmp28_ = kill ((pid_t) _tmp27_, SIGTERM);
		_tmp25_ = _tmp28_ == -1;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		gint _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = errno;
		_tmp30_ = g_strerror (_tmp29_);
		g_warning ("chess-engine.vala:189: Failed to kill engine: %s", _tmp30_);
	}
	_tmp31_ = self->priv->pid;
	g_spawn_close_pid (_tmp31_);
	self->priv->pid = (GPid) 0;
}


static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	guint _tmp0_;
	gchar* buf = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	gsize n_read = 0UL;
	GIOStatus status = 0;
	gchar* _tmp1_;
	GIOStatus _tmp13_;
	GIOStatus _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = self->priv->stdout_watch_id;
	_vala_return_val_if_fail (_tmp0_ != ((guint) 0), "stdout_watch_id != 0", FALSE);
	_tmp1_ = g_new0 (gchar, 1024);
	buf = (g_free (buf), NULL);
	buf = _tmp1_;
	buf_length1 = 1024;
	_buf_size_ = buf_length1;
	{
		GIOStatus _tmp2_ = 0;
		GIOChannel* _tmp3_;
		gchar* _tmp4_;
		gint _tmp4__length1;
		gsize _tmp5_ = 0UL;
		GIOStatus _tmp6_;
		_tmp3_ = source;
		_tmp4_ = buf;
		_tmp4__length1 = buf_length1;
		_tmp6_ = g_io_channel_read_chars (_tmp3_, _tmp4_, _tmp4__length1, &_tmp5_, &_inner_error_);
		n_read = _tmp5_;
		_tmp2_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch13_g_convert_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch13_g_io_channel_error;
			}
			buf = (g_free (buf), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp7_;
		}
		status = _tmp2_;
	}
	goto __finally13;
	__catch13_g_convert_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("chess-engine.vala:208: Failed to read from engine: %s", _tmp9_);
		self->priv->stdout_watch_id = (guint) 0;
		result = FALSE;
		_g_error_free0 (e);
		buf = (g_free (buf), NULL);
		return result;
	}
	goto __finally13;
	__catch13_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("chess-engine.vala:214: Failed to read from engine: %s", _tmp11_);
		self->priv->stdout_watch_id = (guint) 0;
		result = FALSE;
		_g_error_free0 (e);
		buf = (g_free (buf), NULL);
		return result;
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp12_ = FALSE;
		buf = (g_free (buf), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp12_;
	}
	_tmp13_ = status;
	if (_tmp13_ == G_IO_STATUS_EOF) {
		g_debug ("chess-engine.vala:221: EOF");
		self->priv->stdout_watch_id = (guint) 0;
		result = FALSE;
		buf = (g_free (buf), NULL);
		return result;
	}
	_tmp14_ = status;
	if (_tmp14_ == G_IO_STATUS_NORMAL) {
		gsize _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_;
		gint _tmp17__length1;
		_tmp15_ = n_read;
		_tmp16_ = (gint) _tmp15_;
		buf = g_renew (gchar, buf, (gint) _tmp15_);
		(_tmp16_ > buf_length1) ? memset (buf + buf_length1, 0, sizeof (gchar) * (_tmp16_ - buf_length1)) : NULL;
		buf_length1 = _tmp16_;
		_buf_size_ = _tmp16_;
		_tmp17_ = buf;
		_tmp17__length1 = buf_length1;
		chess_engine_process_input (self, _tmp17_, _tmp17__length1);
	}
	result = TRUE;
	buf = (g_free (buf), NULL);
	return result;
}


void chess_engine_write (ChessEngine* self, gchar* data, int data_length1) {
	gsize offset = 0UL;
	gsize n_written = 0UL;
	g_return_if_fail (self != NULL);
	offset = (gsize) 0;
	n_written = (gsize) 0;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp5_;
			gchar* _tmp6_;
			gint _tmp6__length1;
			gsize _tmp7_;
			gchar* _tmp8_;
			gint _tmp8__length1;
			gsize _tmp9_;
			gssize _tmp10_;
			gsize _tmp11_;
			gsize _tmp12_;
			if (!_tmp0_) {
				gboolean _tmp1_ = FALSE;
				gsize _tmp2_;
				_tmp2_ = n_written;
				if (_tmp2_ > ((gsize) 0)) {
					gsize _tmp3_;
					gchar* _tmp4_;
					gint _tmp4__length1;
					_tmp3_ = offset;
					_tmp4_ = data;
					_tmp4__length1 = data_length1;
					_tmp1_ = _tmp3_ < ((gsize) _tmp4__length1);
				} else {
					_tmp1_ = FALSE;
				}
				if (!_tmp1_) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp5_ = self->priv->stdin_fd;
			_tmp6_ = data;
			_tmp6__length1 = data_length1;
			_tmp7_ = offset;
			_tmp8_ = data;
			_tmp8__length1 = data_length1;
			_tmp9_ = offset;
			_tmp10_ = write (_tmp5_, &_tmp6_[_tmp7_], _tmp8__length1 - _tmp9_);
			n_written = (gsize) _tmp10_;
			_tmp11_ = offset;
			_tmp12_ = n_written;
			offset = _tmp11_ + _tmp12_;
		}
	}
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_ + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	_tmp5_ = strlen (self);
	_tmp6_ = _tmp5_;
	memcpy (_tmp4_, self, (gsize) _tmp6_);
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


void chess_engine_write_line (ChessEngine* self, const gchar* line) {
	gchar* l = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* d = NULL;
	const gchar* _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gint d_length1;
	gint _d_size_;
	gchar* _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = line;
	_tmp1_ = g_strconcat (_tmp0_, "\n", NULL);
	l = _tmp1_;
	_tmp2_ = line;
	g_debug ("chess-engine.vala:249: Writing line to engine: '%s'", _tmp2_);
	_tmp3_ = l;
	_tmp5_ = string_to_utf8 (_tmp3_, &_tmp4_);
	d = _tmp5_;
	d_length1 = _tmp4_;
	_d_size_ = d_length1;
	_tmp6_ = d;
	_tmp6__length1 = d_length1;
	if (_tmp6_ != NULL) {
		gchar* _tmp7_;
		gint _tmp7__length1;
		_tmp7_ = d;
		_tmp7__length1 = d_length1;
		chess_engine_write (self, _tmp7_, _tmp7__length1);
	}
	d = (g_free (d), NULL);
	_g_free0 (l);
}


gboolean chess_engine_get_ready (ChessEngine* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_ready;
	result = _tmp0_;
	return result;
}


void chess_engine_set_ready (ChessEngine* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_ready = _tmp0_;
	g_signal_emit (self, chess_engine_signals[CHESS_ENGINE_READY_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, chess_engine_properties[CHESS_ENGINE_READY]);
}


static void chess_engine_class_init (ChessEngineClass * klass) {
	chess_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessEnginePrivate));
	((ChessEngineClass *) klass)->process_input = (void (*) (ChessEngine *, gchar*, int)) chess_engine_real_process_input;
	((ChessEngineClass *) klass)->start_game = (void (*) (ChessEngine *)) chess_engine_real_start_game;
	((ChessEngineClass *) klass)->report_move = (void (*) (ChessEngine *, ChessMove*)) chess_engine_real_report_move;
	((ChessEngineClass *) klass)->do_undo = (void (*) (ChessEngine *)) chess_engine_real_do_undo;
	((ChessEngineClass *) klass)->request_move = (void (*) (ChessEngine *)) chess_engine_real_request_move;
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_engine_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_engine_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_engine_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_ENGINE_READY, chess_engine_properties[CHESS_ENGINE_READY] = g_param_spec_boolean ("ready", "ready", "ready", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	chess_engine_signals[CHESS_ENGINE_STARTING_SIGNAL] = g_signal_new ("starting", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_engine_signals[CHESS_ENGINE_READY_CHANGED_SIGNAL] = g_signal_new ("ready-changed", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_engine_signals[CHESS_ENGINE_MOVED_SIGNAL] = g_signal_new ("moved", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	chess_engine_signals[CHESS_ENGINE_RESIGNED_SIGNAL] = g_signal_new ("resigned", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_engine_signals[CHESS_ENGINE_STOPPED_UNEXPECTEDLY_SIGNAL] = g_signal_new ("stopped-unexpectedly", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_engine_signals[CHESS_ENGINE_ERROR_SIGNAL] = g_signal_new ("error", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_engine_signals[CHESS_ENGINE_CLAIM_DRAW_SIGNAL] = g_signal_new ("claim-draw", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_engine_signals[CHESS_ENGINE_OFFER_DRAW_SIGNAL] = g_signal_new ("offer-draw", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_engine_instance_init (ChessEngine * self) {
	self->priv = CHESS_ENGINE_GET_PRIVATE (self);
	self->priv->pid = (GPid) 0;
	self->priv->stdin_fd = -1;
	self->priv->stderr_fd = -1;
	self->priv->child_watch_id = (guint) 0;
	self->priv->stdout_watch_id = (guint) 0;
	self->priv->started = FALSE;
	self->priv->_ready = FALSE;
}


static void chess_engine_finalize (GObject * obj) {
	ChessEngine * self;
	gboolean _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_ENGINE, ChessEngine);
	_tmp0_ = self->priv->started;
	_vala_assert (!_tmp0_, "!started");
	_g_free0 (self->priv->binary);
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
	_g_io_channel_unref0 (self->priv->stdout_channel);
	G_OBJECT_CLASS (chess_engine_parent_class)->finalize (obj);
}


GType chess_engine_get_type (void) {
	static volatile gsize chess_engine_type_id__volatile = 0;
	if (g_once_init_enter (&chess_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngine), 0, (GInstanceInitFunc) chess_engine_instance_init, NULL };
		GType chess_engine_type_id;
		chess_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessEngine", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&chess_engine_type_id__volatile, chess_engine_type_id);
	}
	return chess_engine_type_id__volatile;
}


static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_ENGINE, ChessEngine);
	switch (property_id) {
		case CHESS_ENGINE_READY:
		g_value_set_boolean (value, chess_engine_get_ready (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_ENGINE, ChessEngine);
	switch (property_id) {
		case CHESS_ENGINE_READY:
		chess_engine_set_ready (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



