/* chess-state.c generated by valac 0.37.1.6-1eaec, the Vala compiler
 * generated from chess-state.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2014 Robert Ancell
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;
typedef struct _ChessStatePrivate ChessStatePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
enum  {
	CHESS_STATE_DUMMY_PROPERTY,
	CHESS_STATE_OPPONENT,
	CHESS_STATE_LAST_PROPERTY
};
static GParamSpec* chess_state_properties[CHESS_STATE_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_COLOR (color_get_type ())

#define TYPE_PIECE_TYPE (piece_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;
typedef struct _ChessPiecePrivate ChessPiecePrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ChessMovePrivate ChessMovePrivate;

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_RESULT (chess_result_get_type ())

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessState {
	GObject parent_instance;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GObjectClass parent_class;
};

struct _ChessStatePrivate {
	gint64 piece_masks[2];
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};

struct _ChessPiece {
	GObject parent_instance;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GObjectClass parent_class;
};

struct _ChessMove {
	GObject parent_instance;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GObjectClass parent_class;
};

typedef enum  {
	CHESS_RULE_UNKNOWN,
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_SEVENTY_FIVE_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_FIVE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH,
	CHESS_RULE_BUG
} ChessRule;

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW,
	CHESS_RESULT_BUG
} ChessResult;


static gpointer chess_state_parent_class = NULL;

GType check_state_get_type (void) G_GNUC_CONST;
GType chess_state_get_type (void) G_GNUC_CONST;
GType chess_player_get_type (void) G_GNUC_CONST;
GType chess_piece_get_type (void) G_GNUC_CONST;
GType chess_move_get_type (void) G_GNUC_CONST;
#define CHESS_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_STATE, ChessStatePrivate))
static ChessState* chess_state_new_empty (void);
static ChessState* chess_state_construct_empty (GType object_type);
ChessState* chess_state_new (const gchar* fen);
ChessState* chess_state_construct (GType object_type, const gchar* fen);
GType color_get_type (void) G_GNUC_CONST;
ChessPlayer* chess_player_new (Color color);
ChessPlayer* chess_player_construct (GType object_type, Color color);
GType piece_type_get_type (void) G_GNUC_CONST;
static gboolean chess_state_decode_piece_type (ChessState* self, gunichar c, PieceType* type);
gint chess_state_get_index (ChessState* self, gint rank, gint file);
ChessPiece* chess_piece_new (ChessPlayer* player, PieceType type);
ChessPiece* chess_piece_construct (GType object_type, ChessPlayer* player, PieceType type);
static CheckState chess_state_get_check_state (ChessState* self, ChessPlayer* player);
ChessState* chess_state_copy (ChessState* self);
ChessMove* chess_move_copy (ChessMove* self);
gboolean chess_state_equals (ChessState* self, ChessState* state);
gchar* chess_state_get_fen (ChessState* self);
gunichar chess_piece_get_symbol (ChessPiece* self);
gint chess_state_get_file (ChessState* self, gint index);
gint chess_state_get_rank (ChessState* self, gint index);
gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply);
static gboolean chess_state_decode_move (ChessState* self, ChessPlayer* player, const gchar* move, gint* r0, gint* f0, gint* r1, gint* f1, PieceType* promotion_type);
gboolean chess_state_move_with_coords (ChessState* self, ChessPlayer* player, gint r0, gint f0, gint r1, gint f1, PieceType promotion_type, gboolean apply, gboolean test_check);
Color chess_piece_get_color (ChessPiece* self);
gboolean chess_state_is_in_check (ChessState* self, ChessPlayer* player);
ChessMove* chess_move_new (void);
ChessMove* chess_move_construct (GType object_type);
GType chess_rule_get_type (void) G_GNUC_CONST;
GType chess_result_get_type (void) G_GNUC_CONST;
ChessResult chess_state_get_result (ChessState* self, ChessRule* rule);
static gboolean chess_state_can_move (ChessState* self, ChessPlayer* player);
gboolean chess_state_have_sufficient_material (ChessState* self);
static gboolean chess_state_is_in_checkmate (ChessState* self, ChessPlayer* player);
ChessPlayer* chess_state_get_opponent (ChessState* self);
static void chess_state_finalize (GObject * obj);
static void _vala_chess_state_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

extern const gint64 BIT_BOARD_set_location_masks[64];
extern const gint64 BIT_BOARD_move_masks[768];
extern const gint64 BIT_BOARD_over_masks[4096];
extern const gint64 BIT_BOARD_clear_location_masks[64];

GType check_state_get_type (void) {
	static volatile gsize check_state_type_id__volatile = 0;
	if (g_once_init_enter (&check_state_type_id__volatile)) {
		static const GEnumValue values[] = {{CHECK_STATE_NONE, "CHECK_STATE_NONE", "none"}, {CHECK_STATE_CHECK, "CHECK_STATE_CHECK", "check"}, {CHECK_STATE_CHECKMATE, "CHECK_STATE_CHECKMATE", "checkmate"}, {0, NULL, NULL}};
		GType check_state_type_id;
		check_state_type_id = g_enum_register_static ("CheckState", values);
		g_once_init_leave (&check_state_type_id__volatile, check_state_type_id);
	}
	return check_state_type_id__volatile;
}


static ChessState* chess_state_construct_empty (GType object_type) {
	ChessState * self = NULL;
	self = (ChessState*) g_object_new (object_type, NULL);
	return self;
}


static ChessState* chess_state_new_empty (void) {
	return chess_state_construct_empty (TYPE_CHESS_STATE);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ChessState* chess_state_construct (GType object_type, const gchar* fen) {
	ChessState * self = NULL;
	ChessPlayer* _tmp0_;
	ChessPlayer* _tmp1_;
	ChessPlayer* _tmp2_;
	ChessPlayer* _tmp3_;
	gchar** fields = NULL;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint fields_length1;
	gint _fields_size_;
	gchar** ranks = NULL;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint ranks_length1;
	gint _ranks_size_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	const gchar* _tmp63_;
	gchar** _tmp70_;
	gint _tmp70__length1;
	const gchar* _tmp71_;
	gchar** _tmp91_;
	gint _tmp91__length1;
	const gchar* _tmp92_;
	gchar** _tmp100_;
	gint _tmp100__length1;
	const gchar* _tmp101_;
	gint _tmp102_;
	gchar** _tmp103_;
	gint _tmp103__length1;
	const gchar* _tmp104_;
	gint _tmp105_;
	ChessPlayer* _tmp106_;
	Color _tmp107_;
	ChessPlayer* _tmp109_;
	CheckState _tmp110_;
	g_return_val_if_fail (fen != NULL, NULL);
	self = (ChessState*) g_object_new (object_type, NULL);
	_tmp0_ = chess_player_new (COLOR_WHITE);
	_g_object_unref0 (self->players[COLOR_WHITE]);
	self->players[COLOR_WHITE] = _tmp0_;
	_tmp1_ = self->players[COLOR_WHITE];
	_tmp2_ = chess_player_new (COLOR_BLACK);
	_g_object_unref0 (self->players[COLOR_BLACK]);
	self->players[COLOR_BLACK] = _tmp2_;
	_tmp3_ = self->players[COLOR_BLACK];
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				ChessPiece* _tmp8_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ < 64)) {
					break;
				}
				_tmp7_ = i;
				_g_object_unref0 (self->board[_tmp7_]);
				self->board[_tmp7_] = NULL;
				_tmp8_ = self->board[_tmp7_];
			}
		}
	}
	_tmp9_ = fen;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, " ", 0);
	fields = _tmp11_;
	fields_length1 = _vala_array_length (_tmp10_);
	_fields_size_ = fields_length1;
	_tmp12_ = fields;
	_tmp12__length1 = fields_length1;
	_tmp13_ = _tmp12_[0];
	_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "/", 0);
	ranks = _tmp15_;
	ranks_length1 = _vala_array_length (_tmp14_);
	_ranks_size_ = ranks_length1;
	{
		gint rank = 0;
		rank = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint _tmp18_;
				gchar* rank_string = NULL;
				gchar** _tmp19_;
				gint _tmp19__length1;
				gint _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = rank;
					rank = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = rank;
				if (!(_tmp18_ < 8)) {
					break;
				}
				_tmp19_ = ranks;
				_tmp19__length1 = ranks_length1;
				_tmp20_ = rank;
				_tmp21_ = _tmp19_[7 - _tmp20_];
				_tmp22_ = g_strdup (_tmp21_);
				rank_string = _tmp22_;
				{
					gint file = 0;
					gint offset = 0;
					file = 0;
					offset = 0;
					{
						gboolean _tmp23_ = FALSE;
						_tmp23_ = TRUE;
						while (TRUE) {
							gboolean _tmp25_ = FALSE;
							gint _tmp26_;
							gchar c = '\0';
							const gchar* _tmp31_;
							gint _tmp32_;
							gchar _tmp33_;
							gboolean _tmp34_ = FALSE;
							gchar _tmp35_;
							PieceType type = 0;
							Color _tmp39_ = 0;
							gchar _tmp40_;
							gboolean _tmp41_;
							Color color = 0;
							gchar _tmp42_;
							gchar _tmp43_;
							PieceType _tmp44_ = 0;
							gint index = 0;
							gint _tmp45_;
							gint _tmp46_;
							gint _tmp47_;
							ChessPiece* piece = NULL;
							Color _tmp48_;
							ChessPlayer* _tmp49_;
							PieceType _tmp50_;
							ChessPiece* _tmp51_;
							gint _tmp52_;
							ChessPiece* _tmp53_;
							ChessPiece* _tmp54_;
							ChessPiece* _tmp55_;
							gint64 mask = 0LL;
							gint _tmp56_;
							gint64 _tmp57_;
							Color _tmp58_;
							gint64 _tmp59_;
							gint64 _tmp60_;
							gint _tmp61_;
							if (!_tmp23_) {
								gint _tmp24_;
								_tmp24_ = offset;
								offset = _tmp24_ + 1;
							}
							_tmp23_ = FALSE;
							_tmp26_ = file;
							if (_tmp26_ < 8) {
								gint _tmp27_;
								const gchar* _tmp28_;
								gint _tmp29_;
								gint _tmp30_;
								_tmp27_ = offset;
								_tmp28_ = rank_string;
								_tmp29_ = strlen (_tmp28_);
								_tmp30_ = _tmp29_;
								_tmp25_ = _tmp27_ < _tmp30_;
							} else {
								_tmp25_ = FALSE;
							}
							if (!_tmp25_) {
								break;
							}
							_tmp31_ = rank_string;
							_tmp32_ = offset;
							_tmp33_ = string_get (_tmp31_, (glong) _tmp32_);
							c = _tmp33_;
							_tmp35_ = c;
							if (_tmp35_ >= '1') {
								gchar _tmp36_;
								_tmp36_ = c;
								_tmp34_ = _tmp36_ <= '8';
							} else {
								_tmp34_ = FALSE;
							}
							if (_tmp34_) {
								gint _tmp37_;
								gchar _tmp38_;
								_tmp37_ = file;
								_tmp38_ = c;
								file = _tmp37_ + (_tmp38_ - '0');
								continue;
							}
							_tmp40_ = c;
							_tmp41_ = g_ascii_isupper (_tmp40_);
							if (_tmp41_) {
								_tmp39_ = COLOR_WHITE;
							} else {
								_tmp39_ = COLOR_BLACK;
							}
							color = _tmp39_;
							_tmp42_ = c;
							_tmp43_ = g_ascii_toupper (_tmp42_);
							chess_state_decode_piece_type (self, (gunichar) _tmp43_, &_tmp44_);
							type = _tmp44_;
							_tmp45_ = rank;
							_tmp46_ = file;
							_tmp47_ = chess_state_get_index (self, _tmp45_, _tmp46_);
							index = _tmp47_;
							_tmp48_ = color;
							_tmp49_ = self->players[_tmp48_];
							_tmp50_ = type;
							_tmp51_ = chess_piece_new (_tmp49_, _tmp50_);
							piece = _tmp51_;
							_tmp52_ = index;
							_tmp53_ = piece;
							_tmp54_ = _g_object_ref0 (_tmp53_);
							_g_object_unref0 (self->board[_tmp52_]);
							self->board[_tmp52_] = _tmp54_;
							_tmp55_ = self->board[_tmp52_];
							_tmp56_ = index;
							_tmp57_ = BIT_BOARD_set_location_masks[_tmp56_];
							mask = _tmp57_;
							_tmp58_ = color;
							_tmp59_ = mask;
							self->priv->piece_masks[_tmp58_] |= _tmp59_;
							_tmp60_ = self->priv->piece_masks[_tmp58_];
							_tmp61_ = file;
							file = _tmp61_ + 1;
							_g_object_unref0 (piece);
						}
					}
				}
				_g_free0 (rank_string);
			}
		}
	}
	_tmp62_ = fields;
	_tmp62__length1 = fields_length1;
	_tmp63_ = _tmp62_[1];
	if (g_strcmp0 (_tmp63_, "w") == 0) {
		ChessPlayer* _tmp64_;
		ChessPlayer* _tmp65_;
		_tmp64_ = self->players[COLOR_WHITE];
		_tmp65_ = _g_object_ref0 (_tmp64_);
		_g_object_unref0 (self->current_player);
		self->current_player = _tmp65_;
	} else {
		gchar** _tmp66_;
		gint _tmp66__length1;
		const gchar* _tmp67_;
		_tmp66_ = fields;
		_tmp66__length1 = fields_length1;
		_tmp67_ = _tmp66_[1];
		if (g_strcmp0 (_tmp67_, "b") == 0) {
			ChessPlayer* _tmp68_;
			ChessPlayer* _tmp69_;
			_tmp68_ = self->players[COLOR_BLACK];
			_tmp69_ = _g_object_ref0 (_tmp68_);
			_g_object_unref0 (self->current_player);
			self->current_player = _tmp69_;
		}
	}
	_tmp70_ = fields;
	_tmp70__length1 = fields_length1;
	_tmp71_ = _tmp70_[2];
	if (g_strcmp0 (_tmp71_, "-") != 0) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp72_ = FALSE;
				_tmp72_ = TRUE;
				while (TRUE) {
					gint _tmp74_;
					gchar** _tmp75_;
					gint _tmp75__length1;
					const gchar* _tmp76_;
					gint _tmp77_;
					gint _tmp78_;
					gchar c = '\0';
					gchar** _tmp79_;
					gint _tmp79__length1;
					const gchar* _tmp80_;
					gint _tmp81_;
					gchar _tmp82_;
					gchar _tmp83_;
					if (!_tmp72_) {
						gint _tmp73_;
						_tmp73_ = i;
						i = _tmp73_ + 1;
					}
					_tmp72_ = FALSE;
					_tmp74_ = i;
					_tmp75_ = fields;
					_tmp75__length1 = fields_length1;
					_tmp76_ = _tmp75_[2];
					_tmp77_ = strlen (_tmp76_);
					_tmp78_ = _tmp77_;
					if (!(_tmp74_ < _tmp78_)) {
						break;
					}
					_tmp79_ = fields;
					_tmp79__length1 = fields_length1;
					_tmp80_ = _tmp79_[2];
					_tmp81_ = i;
					_tmp82_ = string_get (_tmp80_, (glong) _tmp81_);
					c = _tmp82_;
					_tmp83_ = c;
					if (_tmp83_ == 'K') {
						gboolean _tmp84_;
						self->can_castle_kingside[COLOR_WHITE] = TRUE;
						_tmp84_ = self->can_castle_kingside[COLOR_WHITE];
					} else {
						gchar _tmp85_;
						_tmp85_ = c;
						if (_tmp85_ == 'Q') {
							gboolean _tmp86_;
							self->can_castle_queenside[COLOR_WHITE] = TRUE;
							_tmp86_ = self->can_castle_queenside[COLOR_WHITE];
						} else {
							gchar _tmp87_;
							_tmp87_ = c;
							if (_tmp87_ == 'k') {
								gboolean _tmp88_;
								self->can_castle_kingside[COLOR_BLACK] = TRUE;
								_tmp88_ = self->can_castle_kingside[COLOR_BLACK];
							} else {
								gchar _tmp89_;
								_tmp89_ = c;
								if (_tmp89_ == 'q') {
									gboolean _tmp90_;
									self->can_castle_queenside[COLOR_BLACK] = TRUE;
									_tmp90_ = self->can_castle_queenside[COLOR_BLACK];
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp91_ = fields;
	_tmp91__length1 = fields_length1;
	_tmp92_ = _tmp91_[3];
	if (g_strcmp0 (_tmp92_, "-") != 0) {
		gchar** _tmp93_;
		gint _tmp93__length1;
		const gchar* _tmp94_;
		gchar _tmp95_;
		gchar** _tmp96_;
		gint _tmp96__length1;
		const gchar* _tmp97_;
		gchar _tmp98_;
		gint _tmp99_;
		_tmp93_ = fields;
		_tmp93__length1 = fields_length1;
		_tmp94_ = _tmp93_[3];
		_tmp95_ = string_get (_tmp94_, (glong) 1);
		_tmp96_ = fields;
		_tmp96__length1 = fields_length1;
		_tmp97_ = _tmp96_[3];
		_tmp98_ = string_get (_tmp97_, (glong) 0);
		_tmp99_ = chess_state_get_index (self, (gint) (_tmp95_ - '1'), (gint) (_tmp98_ - 'a'));
		self->en_passant_index = _tmp99_;
	}
	_tmp100_ = fields;
	_tmp100__length1 = fields_length1;
	_tmp101_ = _tmp100_[4];
	_tmp102_ = atoi (_tmp101_);
	self->halfmove_clock = _tmp102_;
	_tmp103_ = fields;
	_tmp103__length1 = fields_length1;
	_tmp104_ = _tmp103_[5];
	_tmp105_ = atoi (_tmp104_);
	self->number = (_tmp105_ - 1) * 2;
	_tmp106_ = self->current_player;
	_tmp107_ = _tmp106_->color;
	if (_tmp107_ == COLOR_BLACK) {
		gint _tmp108_;
		_tmp108_ = self->number;
		self->number = _tmp108_ + 1;
	}
	_tmp109_ = self->current_player;
	_tmp110_ = chess_state_get_check_state (self, _tmp109_);
	self->check_state = _tmp110_;
	ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


ChessState* chess_state_new (const gchar* fen) {
	return chess_state_construct (TYPE_CHESS_STATE, fen);
}


ChessState* chess_state_copy (ChessState* self) {
	ChessState* result = NULL;
	ChessState* state = NULL;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	gint _tmp2_;
	ChessState* _tmp3_;
	ChessPlayer* _tmp4_;
	ChessPlayer* _tmp5_;
	ChessPlayer* _tmp6_;
	ChessState* _tmp7_;
	ChessPlayer* _tmp8_;
	ChessPlayer* _tmp9_;
	ChessPlayer* _tmp10_;
	ChessState* _tmp11_;
	ChessPlayer* _tmp12_;
	ChessPlayer* _tmp13_;
	ChessState* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	ChessState* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	ChessState* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	ChessState* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	ChessState* _tmp26_;
	gint _tmp27_;
	ChessState* _tmp28_;
	CheckState _tmp29_;
	ChessMove* _tmp30_;
	ChessState* _tmp43_;
	gint64 _tmp44_;
	gint64 _tmp45_;
	ChessState* _tmp46_;
	gint64 _tmp47_;
	gint64 _tmp48_;
	ChessState* _tmp49_;
	gint _tmp50_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_state_new_empty ();
	state = _tmp0_;
	_tmp1_ = state;
	_tmp2_ = self->number;
	_tmp1_->number = _tmp2_;
	_tmp3_ = state;
	_tmp4_ = self->players[COLOR_WHITE];
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_tmp3_->players[COLOR_WHITE]);
	_tmp3_->players[COLOR_WHITE] = _tmp5_;
	_tmp6_ = _tmp3_->players[COLOR_WHITE];
	_tmp7_ = state;
	_tmp8_ = self->players[COLOR_BLACK];
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (_tmp7_->players[COLOR_BLACK]);
	_tmp7_->players[COLOR_BLACK] = _tmp9_;
	_tmp10_ = _tmp7_->players[COLOR_BLACK];
	_tmp11_ = state;
	_tmp12_ = self->current_player;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (_tmp11_->current_player);
	_tmp11_->current_player = _tmp13_;
	_tmp14_ = state;
	_tmp15_ = self->can_castle_kingside[COLOR_WHITE];
	_tmp14_->can_castle_kingside[COLOR_WHITE] = _tmp15_;
	_tmp16_ = _tmp14_->can_castle_kingside[COLOR_WHITE];
	_tmp17_ = state;
	_tmp18_ = self->can_castle_queenside[COLOR_WHITE];
	_tmp17_->can_castle_queenside[COLOR_WHITE] = _tmp18_;
	_tmp19_ = _tmp17_->can_castle_queenside[COLOR_WHITE];
	_tmp20_ = state;
	_tmp21_ = self->can_castle_kingside[COLOR_BLACK];
	_tmp20_->can_castle_kingside[COLOR_BLACK] = _tmp21_;
	_tmp22_ = _tmp20_->can_castle_kingside[COLOR_BLACK];
	_tmp23_ = state;
	_tmp24_ = self->can_castle_queenside[COLOR_BLACK];
	_tmp23_->can_castle_queenside[COLOR_BLACK] = _tmp24_;
	_tmp25_ = _tmp23_->can_castle_queenside[COLOR_BLACK];
	_tmp26_ = state;
	_tmp27_ = self->en_passant_index;
	_tmp26_->en_passant_index = _tmp27_;
	_tmp28_ = state;
	_tmp29_ = self->check_state;
	_tmp28_->check_state = _tmp29_;
	_tmp30_ = self->last_move;
	if (_tmp30_ != NULL) {
		ChessState* _tmp31_;
		ChessMove* _tmp32_;
		ChessMove* _tmp33_;
		_tmp31_ = state;
		_tmp32_ = self->last_move;
		_tmp33_ = chess_move_copy (_tmp32_);
		_g_object_unref0 (_tmp31_->last_move);
		_tmp31_->last_move = _tmp33_;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp34_ = FALSE;
			_tmp34_ = TRUE;
			while (TRUE) {
				gint _tmp36_;
				ChessState* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				ChessPiece* _tmp40_;
				ChessPiece* _tmp41_;
				ChessPiece* _tmp42_;
				if (!_tmp34_) {
					gint _tmp35_;
					_tmp35_ = i;
					i = _tmp35_ + 1;
				}
				_tmp34_ = FALSE;
				_tmp36_ = i;
				if (!(_tmp36_ < 64)) {
					break;
				}
				_tmp37_ = state;
				_tmp38_ = i;
				_tmp39_ = i;
				_tmp40_ = self->board[_tmp39_];
				_tmp41_ = _g_object_ref0 (_tmp40_);
				_g_object_unref0 (_tmp37_->board[_tmp38_]);
				_tmp37_->board[_tmp38_] = _tmp41_;
				_tmp42_ = _tmp37_->board[_tmp38_];
			}
		}
	}
	_tmp43_ = state;
	_tmp44_ = self->priv->piece_masks[COLOR_WHITE];
	_tmp43_->priv->piece_masks[COLOR_WHITE] = _tmp44_;
	_tmp45_ = _tmp43_->priv->piece_masks[COLOR_WHITE];
	_tmp46_ = state;
	_tmp47_ = self->priv->piece_masks[COLOR_BLACK];
	_tmp46_->priv->piece_masks[COLOR_BLACK] = _tmp47_;
	_tmp48_ = _tmp46_->priv->piece_masks[COLOR_BLACK];
	_tmp49_ = state;
	_tmp50_ = self->halfmove_clock;
	_tmp49_->halfmove_clock = _tmp50_;
	result = state;
	return result;
}


gboolean chess_state_equals (ChessState* self, ChessState* state) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gint64 _tmp7_;
	ChessState* _tmp8_;
	gint64 _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	_tmp7_ = self->priv->piece_masks[COLOR_WHITE];
	_tmp8_ = state;
	_tmp9_ = _tmp8_->priv->piece_masks[COLOR_WHITE];
	if (_tmp7_ != _tmp9_) {
		_tmp6_ = TRUE;
	} else {
		gint64 _tmp10_;
		ChessState* _tmp11_;
		gint64 _tmp12_;
		_tmp10_ = self->priv->piece_masks[COLOR_BLACK];
		_tmp11_ = state;
		_tmp12_ = _tmp11_->priv->piece_masks[COLOR_BLACK];
		_tmp6_ = _tmp10_ != _tmp12_;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		ChessPlayer* _tmp13_;
		Color _tmp14_;
		ChessState* _tmp15_;
		ChessPlayer* _tmp16_;
		Color _tmp17_;
		_tmp13_ = self->current_player;
		_tmp14_ = _tmp13_->color;
		_tmp15_ = state;
		_tmp16_ = _tmp15_->current_player;
		_tmp17_ = _tmp16_->color;
		_tmp5_ = _tmp14_ != _tmp17_;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp18_;
		ChessState* _tmp19_;
		gboolean _tmp20_;
		_tmp18_ = self->can_castle_kingside[COLOR_WHITE];
		_tmp19_ = state;
		_tmp20_ = _tmp19_->can_castle_kingside[COLOR_WHITE];
		_tmp4_ = _tmp18_ != _tmp20_;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp21_;
		ChessState* _tmp22_;
		gboolean _tmp23_;
		_tmp21_ = self->can_castle_queenside[COLOR_WHITE];
		_tmp22_ = state;
		_tmp23_ = _tmp22_->can_castle_queenside[COLOR_WHITE];
		_tmp3_ = _tmp21_ != _tmp23_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp24_;
		ChessState* _tmp25_;
		gboolean _tmp26_;
		_tmp24_ = self->can_castle_kingside[COLOR_BLACK];
		_tmp25_ = state;
		_tmp26_ = _tmp25_->can_castle_kingside[COLOR_BLACK];
		_tmp2_ = _tmp24_ != _tmp26_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp27_;
		ChessState* _tmp28_;
		gboolean _tmp29_;
		_tmp27_ = self->can_castle_queenside[COLOR_BLACK];
		_tmp28_ = state;
		_tmp29_ = _tmp28_->can_castle_queenside[COLOR_BLACK];
		_tmp1_ = _tmp27_ != _tmp29_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp30_;
		ChessState* _tmp31_;
		gint _tmp32_;
		_tmp30_ = self->en_passant_index;
		_tmp31_ = state;
		_tmp32_ = _tmp31_->en_passant_index;
		_tmp0_ = _tmp30_ != _tmp32_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp33_ = FALSE;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				gboolean _tmp36_ = FALSE;
				gint _tmp37_;
				ChessPiece* _tmp38_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < 64)) {
					break;
				}
				_tmp37_ = i;
				_tmp38_ = self->board[_tmp37_];
				if (_tmp38_ != NULL) {
					gint _tmp39_;
					ChessPiece* _tmp40_;
					PieceType _tmp41_;
					ChessState* _tmp42_;
					gint _tmp43_;
					ChessPiece* _tmp44_;
					PieceType _tmp45_;
					_tmp39_ = i;
					_tmp40_ = self->board[_tmp39_];
					_tmp41_ = _tmp40_->type;
					_tmp42_ = state;
					_tmp43_ = i;
					_tmp44_ = _tmp42_->board[_tmp43_];
					_tmp45_ = _tmp44_->type;
					_tmp36_ = _tmp41_ != _tmp45_;
				} else {
					_tmp36_ = FALSE;
				}
				if (_tmp36_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


gchar* chess_state_get_fen (ChessState* self) {
	gchar* result = NULL;
	GString* value = NULL;
	GString* _tmp0_;
	GString* _tmp26_;
	ChessPlayer* _tmp27_;
	Color _tmp28_;
	GString* _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp34_;
	gboolean _tmp36_;
	gboolean _tmp38_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	GString* _tmp45_;
	gint _tmp46_;
	GString* _tmp53_;
	GString* _tmp54_;
	gint _tmp55_;
	GString* _tmp56_;
	ChessPlayer* _tmp57_;
	Color _tmp58_;
	GString* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	value = _tmp0_;
	{
		gint rank = 0;
		rank = 7;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint skip_count = 0;
				gint _tmp21_;
				gint _tmp24_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = rank;
					rank = _tmp2_ - 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = rank;
				if (!(_tmp3_ >= 0)) {
					break;
				}
				skip_count = 0;
				{
					gint file = 0;
					file = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							ChessPiece* p = NULL;
							gint _tmp7_;
							gint _tmp8_;
							gint _tmp9_;
							ChessPiece* _tmp10_;
							ChessPiece* _tmp11_;
							ChessPiece* _tmp12_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = file;
								file = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = file;
							if (!(_tmp6_ < 8)) {
								break;
							}
							_tmp7_ = rank;
							_tmp8_ = file;
							_tmp9_ = chess_state_get_index (self, _tmp7_, _tmp8_);
							_tmp10_ = self->board[_tmp9_];
							_tmp11_ = _g_object_ref0 (_tmp10_);
							p = _tmp11_;
							_tmp12_ = p;
							if (_tmp12_ == NULL) {
								gint _tmp13_;
								_tmp13_ = skip_count;
								skip_count = _tmp13_ + 1;
							} else {
								gint _tmp14_;
								GString* _tmp17_;
								ChessPiece* _tmp18_;
								gunichar _tmp19_;
								gunichar _tmp20_;
								_tmp14_ = skip_count;
								if (_tmp14_ > 0) {
									GString* _tmp15_;
									gint _tmp16_;
									_tmp15_ = value;
									_tmp16_ = skip_count;
									g_string_append_printf (_tmp15_, "%d", _tmp16_);
									skip_count = 0;
								}
								_tmp17_ = value;
								_tmp18_ = p;
								_tmp19_ = chess_piece_get_symbol (_tmp18_);
								_tmp20_ = _tmp19_;
								g_string_append_printf (_tmp17_, "%c", (gint) _tmp20_);
							}
							_g_object_unref0 (p);
						}
					}
				}
				_tmp21_ = skip_count;
				if (_tmp21_ > 0) {
					GString* _tmp22_;
					gint _tmp23_;
					_tmp22_ = value;
					_tmp23_ = skip_count;
					g_string_append_printf (_tmp22_, "%d", _tmp23_);
				}
				_tmp24_ = rank;
				if (_tmp24_ != 0) {
					GString* _tmp25_;
					_tmp25_ = value;
					g_string_append_c (_tmp25_, '/');
				}
			}
		}
	}
	_tmp26_ = value;
	g_string_append_c (_tmp26_, ' ');
	_tmp27_ = self->current_player;
	_tmp28_ = _tmp27_->color;
	if (_tmp28_ == COLOR_WHITE) {
		GString* _tmp29_;
		_tmp29_ = value;
		g_string_append_c (_tmp29_, 'w');
	} else {
		GString* _tmp30_;
		_tmp30_ = value;
		g_string_append_c (_tmp30_, 'b');
	}
	_tmp31_ = value;
	g_string_append_c (_tmp31_, ' ');
	_tmp32_ = self->can_castle_kingside[COLOR_WHITE];
	if (_tmp32_) {
		GString* _tmp33_;
		_tmp33_ = value;
		g_string_append_c (_tmp33_, 'K');
	}
	_tmp34_ = self->can_castle_queenside[COLOR_WHITE];
	if (_tmp34_) {
		GString* _tmp35_;
		_tmp35_ = value;
		g_string_append_c (_tmp35_, 'Q');
	}
	_tmp36_ = self->can_castle_kingside[COLOR_BLACK];
	if (_tmp36_) {
		GString* _tmp37_;
		_tmp37_ = value;
		g_string_append_c (_tmp37_, 'k');
	}
	_tmp38_ = self->can_castle_queenside[COLOR_BLACK];
	if (_tmp38_) {
		GString* _tmp39_;
		_tmp39_ = value;
		g_string_append_c (_tmp39_, 'q');
	}
	_tmp40_ = self->can_castle_kingside[COLOR_WHITE];
	_tmp41_ = self->can_castle_queenside[COLOR_WHITE];
	_tmp42_ = self->can_castle_kingside[COLOR_BLACK];
	_tmp43_ = self->can_castle_queenside[COLOR_BLACK];
	if (!(((_tmp40_ | _tmp41_) | _tmp42_) | _tmp43_)) {
		GString* _tmp44_;
		_tmp44_ = value;
		g_string_append_c (_tmp44_, '-');
	}
	_tmp45_ = value;
	g_string_append_c (_tmp45_, ' ');
	_tmp46_ = self->en_passant_index;
	if (_tmp46_ >= 0) {
		GString* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		_tmp47_ = value;
		_tmp48_ = self->en_passant_index;
		_tmp49_ = chess_state_get_file (self, _tmp48_);
		_tmp50_ = self->en_passant_index;
		_tmp51_ = chess_state_get_rank (self, _tmp50_);
		g_string_append_printf (_tmp47_, "%c%d", 'a' + _tmp49_, _tmp51_ + 1);
	} else {
		GString* _tmp52_;
		_tmp52_ = value;
		g_string_append_c (_tmp52_, '-');
	}
	_tmp53_ = value;
	g_string_append_c (_tmp53_, ' ');
	_tmp54_ = value;
	_tmp55_ = self->halfmove_clock;
	g_string_append_printf (_tmp54_, "%d", _tmp55_);
	_tmp56_ = value;
	g_string_append_c (_tmp56_, ' ');
	_tmp57_ = self->current_player;
	_tmp58_ = _tmp57_->color;
	if (_tmp58_ == COLOR_WHITE) {
		GString* _tmp59_;
		gint _tmp60_;
		_tmp59_ = value;
		_tmp60_ = self->number;
		g_string_append_printf (_tmp59_, "%d", _tmp60_ / 2);
	} else {
		GString* _tmp61_;
		gint _tmp62_;
		_tmp61_ = value;
		_tmp62_ = self->number;
		g_string_append_printf (_tmp61_, "%d", (_tmp62_ / 2) + 1);
	}
	_tmp63_ = value;
	_tmp64_ = _tmp63_->str;
	_tmp65_ = g_strdup (_tmp64_);
	result = _tmp65_;
	_g_string_free0 (value);
	return result;
}


gint chess_state_get_index (ChessState* self, gint rank, gint file) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = rank;
	_tmp1_ = file;
	result = (_tmp0_ * 8) + _tmp1_;
	return result;
}


gint chess_state_get_rank (ChessState* self, gint index) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = index;
	result = _tmp0_ / 8;
	return result;
}


gint chess_state_get_file (ChessState* self, gint index) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = index;
	result = _tmp0_ % 8;
	return result;
}


gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	gint r0 = 0;
	gint f0 = 0;
	gint r1 = 0;
	gint f1 = 0;
	PieceType promotion_type = 0;
	ChessPlayer* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	PieceType _tmp6_ = 0;
	gboolean _tmp7_;
	ChessPlayer* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	PieceType _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (move != NULL, FALSE);
	_tmp0_ = self->current_player;
	_tmp1_ = move;
	_tmp7_ = chess_state_decode_move (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	r0 = _tmp2_;
	f0 = _tmp3_;
	r1 = _tmp4_;
	f1 = _tmp5_;
	promotion_type = _tmp6_;
	if (!_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = self->current_player;
	_tmp9_ = r0;
	_tmp10_ = f0;
	_tmp11_ = r1;
	_tmp12_ = f1;
	_tmp13_ = promotion_type;
	_tmp14_ = apply;
	_tmp15_ = chess_state_move_with_coords (self, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_, TRUE);
	if (!_tmp15_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


gboolean chess_state_move_with_coords (ChessState* self, ChessPlayer* player, gint r0, gint f0, gint r1, gint f1, PieceType promotion_type, gboolean apply, gboolean test_check) {
	gboolean result = FALSE;
	gint start = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint end = 0;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Color color = 0;
	ChessPlayer* _tmp6_;
	Color _tmp7_;
	Color _tmp8_ = 0;
	Color _tmp9_;
	Color opponent_color = 0;
	ChessPiece* piece = NULL;
	gint _tmp10_;
	ChessPiece* _tmp11_;
	ChessPiece* _tmp12_;
	gboolean _tmp13_ = FALSE;
	ChessPiece* _tmp14_;
	gint64 end_mask = 0LL;
	gint _tmp18_;
	gint64 _tmp19_;
	gint64 move_mask = 0LL;
	Color _tmp20_;
	ChessPiece* _tmp21_;
	PieceType _tmp22_;
	gint _tmp23_;
	gint64 _tmp24_;
	gint64 _tmp25_;
	gint64 _tmp26_;
	gint64 over_mask = 0LL;
	gint _tmp27_;
	gint _tmp28_;
	gint64 _tmp29_;
	gint64 _tmp30_;
	gint64 _tmp31_;
	gint64 _tmp32_;
	ChessPiece* victim = NULL;
	gint _tmp33_;
	ChessPiece* _tmp34_;
	ChessPiece* _tmp35_;
	gint victim_index = 0;
	gint _tmp36_;
	gboolean _tmp37_ = FALSE;
	ChessPiece* _tmp38_;
	gint rook_start = 0;
	gint rook_end = 0;
	gboolean is_promotion = FALSE;
	gboolean ambiguous_rank = FALSE;
	gboolean ambiguous_file = FALSE;
	ChessPiece* _tmp42_;
	PieceType _tmp43_;
	gboolean _tmp111_ = FALSE;
	gboolean _tmp112_;
	gboolean _tmp114_;
	gint64 old_white_mask = 0LL;
	gint64 _tmp147_;
	gint64 old_black_mask = 0LL;
	gint64 _tmp148_;
	gboolean old_white_can_castle_kingside = FALSE;
	gboolean _tmp149_;
	gboolean old_white_can_castle_queenside = FALSE;
	gboolean _tmp150_;
	gboolean old_black_can_castle_kingside = FALSE;
	gboolean _tmp151_;
	gboolean old_black_can_castle_queenside = FALSE;
	gboolean _tmp152_;
	gint old_en_passant_index = 0;
	gint _tmp153_;
	gint old_halfmove_clock = 0;
	gint _tmp154_;
	gint _tmp155_;
	ChessPiece* _tmp156_;
	gint _tmp157_;
	gint64 _tmp158_;
	gint64 _tmp159_;
	gint _tmp160_;
	gint64 _tmp161_;
	gint64 _tmp162_;
	ChessPiece* _tmp163_;
	gboolean _tmp172_;
	Color _tmp182_;
	gint64 _tmp183_;
	gint64 _tmp184_;
	Color _tmp185_;
	gint _tmp186_;
	gint64 _tmp187_;
	gint64 _tmp188_;
	gint _tmp189_;
	ChessPiece* _tmp207_;
	PieceType _tmp208_;
	gboolean _tmp239_ = FALSE;
	ChessPiece* _tmp240_;
	PieceType _tmp241_;
	gboolean _tmp247_ = FALSE;
	ChessPiece* _tmp248_;
	PieceType _tmp249_;
	gboolean _result_ = FALSE;
	gboolean _tmp252_ = FALSE;
	gboolean _tmp253_;
	gboolean _tmp256_ = FALSE;
	gboolean _tmp257_;
	ChessPlayer* _tmp294_ = NULL;
	Color _tmp295_;
	ChessPlayer* _tmp298_;
	ChessPlayer* _tmp299_;
	CheckState _tmp300_;
	ChessMove* _tmp301_;
	ChessMove* _tmp302_;
	gint _tmp303_;
	ChessMove* _tmp304_;
	ChessPiece* _tmp305_;
	ChessPiece* _tmp306_;
	gboolean _tmp307_;
	ChessMove* _tmp312_;
	ChessPiece* _tmp313_;
	ChessPiece* _tmp314_;
	gint _tmp315_;
	ChessMove* _tmp320_;
	gint _tmp321_;
	ChessMove* _tmp322_;
	gint _tmp323_;
	ChessMove* _tmp324_;
	gint _tmp325_;
	ChessMove* _tmp326_;
	gint _tmp327_;
	ChessMove* _tmp328_;
	gboolean _tmp329_;
	ChessMove* _tmp330_;
	gboolean _tmp331_;
	ChessMove* _tmp332_;
	CheckState _tmp333_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp0_ = r0;
	_tmp1_ = f0;
	_tmp2_ = chess_state_get_index (self, _tmp0_, _tmp1_);
	start = _tmp2_;
	_tmp3_ = r1;
	_tmp4_ = f1;
	_tmp5_ = chess_state_get_index (self, _tmp3_, _tmp4_);
	end = _tmp5_;
	_tmp6_ = player;
	_tmp7_ = _tmp6_->color;
	color = _tmp7_;
	_tmp9_ = color;
	if (_tmp9_ == COLOR_WHITE) {
		_tmp8_ = COLOR_BLACK;
	} else {
		_tmp8_ = COLOR_WHITE;
	}
	opponent_color = _tmp8_;
	_tmp10_ = start;
	_tmp11_ = self->board[_tmp10_];
	_tmp12_ = _g_object_ref0 (_tmp11_);
	piece = _tmp12_;
	_tmp14_ = piece;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		ChessPiece* _tmp15_;
		ChessPlayer* _tmp16_;
		ChessPlayer* _tmp17_;
		_tmp15_ = piece;
		_tmp16_ = _tmp15_->player;
		_tmp17_ = player;
		_tmp13_ = _tmp16_ != _tmp17_;
	}
	if (_tmp13_) {
		result = FALSE;
		_g_object_unref0 (piece);
		return result;
	}
	_tmp18_ = end;
	_tmp19_ = BIT_BOARD_set_location_masks[_tmp18_];
	end_mask = _tmp19_;
	_tmp20_ = color;
	_tmp21_ = piece;
	_tmp22_ = _tmp21_->type;
	_tmp23_ = start;
	_tmp24_ = BIT_BOARD_move_masks[(((_tmp20_ * 64) * 6) + (_tmp22_ * 64)) + _tmp23_];
	move_mask = _tmp24_;
	_tmp25_ = end_mask;
	_tmp26_ = move_mask;
	if ((_tmp25_ & _tmp26_) == ((gint64) 0)) {
		result = FALSE;
		_g_object_unref0 (piece);
		return result;
	}
	_tmp27_ = start;
	_tmp28_ = end;
	_tmp29_ = BIT_BOARD_over_masks[(_tmp27_ * 64) + _tmp28_];
	over_mask = _tmp29_;
	_tmp30_ = over_mask;
	_tmp31_ = self->priv->piece_masks[COLOR_WHITE];
	_tmp32_ = self->priv->piece_masks[COLOR_BLACK];
	if ((_tmp30_ & (_tmp31_ | _tmp32_)) != ((gint64) 0)) {
		result = FALSE;
		_g_object_unref0 (piece);
		return result;
	}
	_tmp33_ = end;
	_tmp34_ = self->board[_tmp33_];
	_tmp35_ = _g_object_ref0 (_tmp34_);
	victim = _tmp35_;
	_tmp36_ = end;
	victim_index = _tmp36_;
	_tmp38_ = victim;
	if (_tmp38_ != NULL) {
		ChessPiece* _tmp39_;
		ChessPlayer* _tmp40_;
		ChessPlayer* _tmp41_;
		_tmp39_ = victim;
		_tmp40_ = _tmp39_->player;
		_tmp41_ = player;
		_tmp37_ = _tmp40_ == _tmp41_;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		result = FALSE;
		_g_object_unref0 (victim);
		_g_object_unref0 (piece);
		return result;
	}
	rook_start = -1;
	rook_end = -1;
	is_promotion = FALSE;
	ambiguous_rank = FALSE;
	ambiguous_file = FALSE;
	_tmp42_ = piece;
	_tmp43_ = _tmp42_->type;
	switch (_tmp43_) {
		case PIECE_TYPE_PAWN:
		{
			gboolean _tmp44_ = FALSE;
			ChessPiece* _tmp45_;
			gint _tmp55_;
			gint _tmp56_;
			gboolean _tmp59_ = FALSE;
			gint _tmp60_;
			ChessPiece* _tmp62_;
			_tmp45_ = victim;
			if (_tmp45_ == NULL) {
				gint _tmp46_;
				gint _tmp47_;
				_tmp46_ = end;
				_tmp47_ = self->en_passant_index;
				_tmp44_ = _tmp46_ == _tmp47_;
			} else {
				_tmp44_ = FALSE;
			}
			if (_tmp44_) {
				gint _tmp48_ = 0;
				gint _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				ChessPiece* _tmp53_;
				ChessPiece* _tmp54_;
				_tmp49_ = r1;
				if (_tmp49_ == 2) {
					_tmp48_ = 3;
				} else {
					_tmp48_ = 4;
				}
				_tmp50_ = f1;
				_tmp51_ = chess_state_get_index (self, _tmp48_, _tmp50_);
				victim_index = _tmp51_;
				_tmp52_ = victim_index;
				_tmp53_ = self->board[_tmp52_];
				_tmp54_ = _g_object_ref0 (_tmp53_);
				_g_object_unref0 (victim);
				victim = _tmp54_;
			}
			_tmp55_ = f0;
			_tmp56_ = f1;
			if (_tmp55_ != _tmp56_) {
				ChessPiece* _tmp57_;
				_tmp57_ = victim;
				if (_tmp57_ == NULL) {
					result = FALSE;
					_g_object_unref0 (victim);
					_g_object_unref0 (piece);
					return result;
				}
			} else {
				ChessPiece* _tmp58_;
				_tmp58_ = victim;
				if (_tmp58_ != NULL) {
					result = FALSE;
					_g_object_unref0 (victim);
					_g_object_unref0 (piece);
					return result;
				}
			}
			_tmp60_ = r1;
			if (_tmp60_ == 0) {
				_tmp59_ = TRUE;
			} else {
				gint _tmp61_;
				_tmp61_ = r1;
				_tmp59_ = _tmp61_ == 7;
			}
			is_promotion = _tmp59_;
			_tmp62_ = victim;
			if (_tmp62_ != NULL) {
				ambiguous_file = TRUE;
			}
			break;
		}
		case PIECE_TYPE_KING:
		{
			gint _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			_tmp63_ = f0;
			_tmp64_ = f1;
			_tmp65_ = abs (_tmp63_ - _tmp64_);
			if (_tmp65_ > 1) {
				gint _tmp66_ = 0;
				gint _tmp67_;
				gint _tmp68_;
				gint _tmp69_;
				gint _tmp70_;
				gint _tmp71_ = 0;
				gint _tmp72_;
				gint _tmp73_;
				gint _tmp76_;
				gint _tmp77_;
				gint _tmp78_;
				gint _tmp79_;
				ChessPiece* rook = NULL;
				gint _tmp84_;
				ChessPiece* _tmp85_;
				ChessPiece* _tmp86_;
				gboolean _tmp87_ = FALSE;
				gboolean _tmp88_ = FALSE;
				ChessPiece* _tmp89_;
				gint64 rook_over_mask = 0LL;
				gint _tmp96_;
				gint _tmp97_;
				gint64 _tmp98_;
				gint64 _tmp99_;
				gint64 _tmp100_;
				gint64 _tmp101_;
				CheckState _tmp102_;
				ChessPlayer* _tmp103_;
				gint _tmp104_;
				gint _tmp105_;
				gint _tmp106_;
				gint _tmp107_;
				gint _tmp108_;
				gint _tmp109_;
				gboolean _tmp110_;
				_tmp67_ = f1;
				_tmp68_ = f0;
				if (_tmp67_ > _tmp68_) {
					_tmp66_ = 7;
				} else {
					_tmp66_ = 0;
				}
				_tmp69_ = r0;
				_tmp70_ = chess_state_get_index (self, _tmp69_, _tmp66_);
				rook_start = _tmp70_;
				_tmp72_ = f1;
				_tmp73_ = f0;
				if (_tmp72_ > _tmp73_) {
					gint _tmp74_;
					_tmp74_ = f1;
					_tmp71_ = _tmp74_ - 1;
				} else {
					gint _tmp75_;
					_tmp75_ = f1;
					_tmp71_ = _tmp75_ + 1;
				}
				_tmp76_ = r0;
				_tmp77_ = chess_state_get_index (self, _tmp76_, _tmp71_);
				rook_end = _tmp77_;
				_tmp78_ = f1;
				_tmp79_ = f0;
				if (_tmp78_ > _tmp79_) {
					Color _tmp80_;
					gboolean _tmp81_;
					_tmp80_ = color;
					_tmp81_ = self->can_castle_kingside[_tmp80_];
					if (!_tmp81_) {
						result = FALSE;
						_g_object_unref0 (victim);
						_g_object_unref0 (piece);
						return result;
					}
				} else {
					Color _tmp82_;
					gboolean _tmp83_;
					_tmp82_ = color;
					_tmp83_ = self->can_castle_queenside[_tmp82_];
					if (!_tmp83_) {
						result = FALSE;
						_g_object_unref0 (victim);
						_g_object_unref0 (piece);
						return result;
					}
				}
				_tmp84_ = rook_start;
				_tmp85_ = self->board[_tmp84_];
				_tmp86_ = _g_object_ref0 (_tmp85_);
				rook = _tmp86_;
				_tmp89_ = rook;
				if (_tmp89_ == NULL) {
					_tmp88_ = TRUE;
				} else {
					ChessPiece* _tmp90_;
					PieceType _tmp91_;
					_tmp90_ = rook;
					_tmp91_ = _tmp90_->type;
					_tmp88_ = _tmp91_ != PIECE_TYPE_ROOK;
				}
				if (_tmp88_) {
					_tmp87_ = TRUE;
				} else {
					ChessPiece* _tmp92_;
					Color _tmp93_;
					Color _tmp94_;
					Color _tmp95_;
					_tmp92_ = rook;
					_tmp93_ = chess_piece_get_color (_tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = color;
					_tmp87_ = _tmp94_ != _tmp95_;
				}
				if (_tmp87_) {
					result = FALSE;
					_g_object_unref0 (rook);
					_g_object_unref0 (victim);
					_g_object_unref0 (piece);
					return result;
				}
				_tmp96_ = rook_start;
				_tmp97_ = rook_end;
				_tmp98_ = BIT_BOARD_over_masks[(_tmp96_ * 64) + _tmp97_];
				rook_over_mask = _tmp98_;
				_tmp99_ = rook_over_mask;
				_tmp100_ = self->priv->piece_masks[COLOR_WHITE];
				_tmp101_ = self->priv->piece_masks[COLOR_BLACK];
				if ((_tmp99_ & (_tmp100_ | _tmp101_)) != ((gint64) 0)) {
					result = FALSE;
					_g_object_unref0 (rook);
					_g_object_unref0 (victim);
					_g_object_unref0 (piece);
					return result;
				}
				_tmp102_ = self->check_state;
				if (_tmp102_ == CHECK_STATE_CHECK) {
					result = FALSE;
					_g_object_unref0 (rook);
					_g_object_unref0 (victim);
					_g_object_unref0 (piece);
					return result;
				}
				_tmp103_ = player;
				_tmp104_ = r0;
				_tmp105_ = f0;
				_tmp106_ = rook_end;
				_tmp107_ = chess_state_get_rank (self, _tmp106_);
				_tmp108_ = rook_end;
				_tmp109_ = chess_state_get_file (self, _tmp108_);
				_tmp110_ = chess_state_move_with_coords (self, _tmp103_, _tmp104_, _tmp105_, _tmp107_, _tmp109_, PIECE_TYPE_QUEEN, FALSE, TRUE);
				if (!_tmp110_) {
					result = FALSE;
					_g_object_unref0 (rook);
					_g_object_unref0 (victim);
					_g_object_unref0 (piece);
					return result;
				}
				_g_object_unref0 (rook);
			}
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp112_ = apply;
	if (!_tmp112_) {
		gboolean _tmp113_;
		_tmp113_ = test_check;
		_tmp111_ = !_tmp113_;
	} else {
		_tmp111_ = FALSE;
	}
	if (_tmp111_) {
		result = TRUE;
		_g_object_unref0 (victim);
		_g_object_unref0 (piece);
		return result;
	}
	_tmp114_ = apply;
	if (_tmp114_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp115_ = FALSE;
				_tmp115_ = TRUE;
				while (TRUE) {
					gint _tmp117_;
					gint _tmp118_;
					gint _tmp119_;
					ChessPiece* p = NULL;
					gint _tmp120_;
					ChessPiece* _tmp121_;
					ChessPiece* _tmp122_;
					gboolean _tmp123_ = FALSE;
					gboolean _tmp124_ = FALSE;
					ChessPiece* _tmp125_;
					gint r = 0;
					gint _tmp133_;
					gint _tmp134_;
					gint f = 0;
					gint _tmp135_;
					gint _tmp136_;
					ChessPlayer* _tmp137_;
					gint _tmp138_;
					gint _tmp139_;
					gint _tmp140_;
					gint _tmp141_;
					gboolean _tmp142_;
					if (!_tmp115_) {
						gint _tmp116_;
						_tmp116_ = i;
						i = _tmp116_ + 1;
					}
					_tmp115_ = FALSE;
					_tmp117_ = i;
					if (!(_tmp117_ < 64)) {
						break;
					}
					_tmp118_ = i;
					_tmp119_ = start;
					if (_tmp118_ == _tmp119_) {
						continue;
					}
					_tmp120_ = i;
					_tmp121_ = self->board[_tmp120_];
					_tmp122_ = _g_object_ref0 (_tmp121_);
					p = _tmp122_;
					_tmp125_ = p;
					if (_tmp125_ == NULL) {
						_tmp124_ = TRUE;
					} else {
						ChessPiece* _tmp126_;
						ChessPlayer* _tmp127_;
						ChessPlayer* _tmp128_;
						_tmp126_ = p;
						_tmp127_ = _tmp126_->player;
						_tmp128_ = player;
						_tmp124_ = _tmp127_ != _tmp128_;
					}
					if (_tmp124_) {
						_tmp123_ = TRUE;
					} else {
						ChessPiece* _tmp129_;
						PieceType _tmp130_;
						ChessPiece* _tmp131_;
						PieceType _tmp132_;
						_tmp129_ = p;
						_tmp130_ = _tmp129_->type;
						_tmp131_ = piece;
						_tmp132_ = _tmp131_->type;
						_tmp123_ = _tmp130_ != _tmp132_;
					}
					if (_tmp123_) {
						_g_object_unref0 (p);
						continue;
					}
					_tmp133_ = i;
					_tmp134_ = chess_state_get_rank (self, _tmp133_);
					r = _tmp134_;
					_tmp135_ = i;
					_tmp136_ = chess_state_get_file (self, _tmp135_);
					f = _tmp136_;
					_tmp137_ = player;
					_tmp138_ = r;
					_tmp139_ = f;
					_tmp140_ = r1;
					_tmp141_ = f1;
					_tmp142_ = chess_state_move_with_coords (self, _tmp137_, _tmp138_, _tmp139_, _tmp140_, _tmp141_, PIECE_TYPE_QUEEN, FALSE, TRUE);
					if (_tmp142_) {
						gint _tmp143_;
						gint _tmp144_;
						gint _tmp145_;
						gint _tmp146_;
						_tmp143_ = r;
						_tmp144_ = r0;
						if (_tmp143_ != _tmp144_) {
							ambiguous_rank = TRUE;
						}
						_tmp145_ = f;
						_tmp146_ = f0;
						if (_tmp145_ != _tmp146_) {
							ambiguous_file = TRUE;
						}
					}
					_g_object_unref0 (p);
				}
			}
		}
	}
	_tmp147_ = self->priv->piece_masks[COLOR_WHITE];
	old_white_mask = _tmp147_;
	_tmp148_ = self->priv->piece_masks[COLOR_BLACK];
	old_black_mask = _tmp148_;
	_tmp149_ = self->can_castle_kingside[COLOR_WHITE];
	old_white_can_castle_kingside = _tmp149_;
	_tmp150_ = self->can_castle_queenside[COLOR_WHITE];
	old_white_can_castle_queenside = _tmp150_;
	_tmp151_ = self->can_castle_kingside[COLOR_BLACK];
	old_black_can_castle_kingside = _tmp151_;
	_tmp152_ = self->can_castle_queenside[COLOR_BLACK];
	old_black_can_castle_queenside = _tmp152_;
	_tmp153_ = self->en_passant_index;
	old_en_passant_index = _tmp153_;
	_tmp154_ = self->halfmove_clock;
	old_halfmove_clock = _tmp154_;
	_tmp155_ = start;
	_g_object_unref0 (self->board[_tmp155_]);
	self->board[_tmp155_] = NULL;
	_tmp156_ = self->board[_tmp155_];
	_tmp157_ = start;
	_tmp158_ = BIT_BOARD_clear_location_masks[_tmp157_];
	self->priv->piece_masks[COLOR_WHITE] &= _tmp158_;
	_tmp159_ = self->priv->piece_masks[COLOR_WHITE];
	_tmp160_ = start;
	_tmp161_ = BIT_BOARD_clear_location_masks[_tmp160_];
	self->priv->piece_masks[COLOR_BLACK] &= _tmp161_;
	_tmp162_ = self->priv->piece_masks[COLOR_BLACK];
	_tmp163_ = victim;
	if (_tmp163_ != NULL) {
		gint _tmp164_;
		ChessPiece* _tmp165_;
		gint _tmp166_;
		gint64 _tmp167_;
		gint64 _tmp168_;
		gint _tmp169_;
		gint64 _tmp170_;
		gint64 _tmp171_;
		_tmp164_ = victim_index;
		_g_object_unref0 (self->board[_tmp164_]);
		self->board[_tmp164_] = NULL;
		_tmp165_ = self->board[_tmp164_];
		_tmp166_ = victim_index;
		_tmp167_ = BIT_BOARD_clear_location_masks[_tmp166_];
		self->priv->piece_masks[COLOR_WHITE] &= _tmp167_;
		_tmp168_ = self->priv->piece_masks[COLOR_WHITE];
		_tmp169_ = victim_index;
		_tmp170_ = BIT_BOARD_clear_location_masks[_tmp169_];
		self->priv->piece_masks[COLOR_BLACK] &= _tmp170_;
		_tmp171_ = self->priv->piece_masks[COLOR_BLACK];
	}
	_tmp172_ = is_promotion;
	if (_tmp172_) {
		gint _tmp173_;
		ChessPlayer* _tmp174_;
		PieceType _tmp175_;
		ChessPiece* _tmp176_;
		ChessPiece* _tmp177_;
		_tmp173_ = end;
		_tmp174_ = player;
		_tmp175_ = promotion_type;
		_tmp176_ = chess_piece_new (_tmp174_, _tmp175_);
		_g_object_unref0 (self->board[_tmp173_]);
		self->board[_tmp173_] = _tmp176_;
		_tmp177_ = self->board[_tmp173_];
	} else {
		gint _tmp178_;
		ChessPiece* _tmp179_;
		ChessPiece* _tmp180_;
		ChessPiece* _tmp181_;
		_tmp178_ = end;
		_tmp179_ = piece;
		_tmp180_ = _g_object_ref0 (_tmp179_);
		_g_object_unref0 (self->board[_tmp178_]);
		self->board[_tmp178_] = _tmp180_;
		_tmp181_ = self->board[_tmp178_];
	}
	_tmp182_ = color;
	_tmp183_ = end_mask;
	self->priv->piece_masks[_tmp182_] |= _tmp183_;
	_tmp184_ = self->priv->piece_masks[_tmp182_];
	_tmp185_ = opponent_color;
	_tmp186_ = end;
	_tmp187_ = BIT_BOARD_clear_location_masks[_tmp186_];
	self->priv->piece_masks[_tmp185_] &= _tmp187_;
	_tmp188_ = self->priv->piece_masks[_tmp185_];
	_tmp189_ = rook_start;
	if (_tmp189_ >= 0) {
		ChessPiece* rook = NULL;
		gint _tmp190_;
		ChessPiece* _tmp191_;
		ChessPiece* _tmp192_;
		gint _tmp193_;
		ChessPiece* _tmp194_;
		Color _tmp195_;
		gint _tmp196_;
		gint64 _tmp197_;
		gint64 _tmp198_;
		gint _tmp199_;
		ChessPiece* _tmp200_;
		ChessPiece* _tmp201_;
		ChessPiece* _tmp202_;
		Color _tmp203_;
		gint _tmp204_;
		gint64 _tmp205_;
		gint64 _tmp206_;
		_tmp190_ = rook_start;
		_tmp191_ = self->board[_tmp190_];
		_tmp192_ = _g_object_ref0 (_tmp191_);
		rook = _tmp192_;
		_tmp193_ = rook_start;
		_g_object_unref0 (self->board[_tmp193_]);
		self->board[_tmp193_] = NULL;
		_tmp194_ = self->board[_tmp193_];
		_tmp195_ = color;
		_tmp196_ = rook_start;
		_tmp197_ = BIT_BOARD_clear_location_masks[_tmp196_];
		self->priv->piece_masks[_tmp195_] &= _tmp197_;
		_tmp198_ = self->priv->piece_masks[_tmp195_];
		_tmp199_ = rook_end;
		_tmp200_ = rook;
		_tmp201_ = _g_object_ref0 (_tmp200_);
		_g_object_unref0 (self->board[_tmp199_]);
		self->board[_tmp199_] = _tmp201_;
		_tmp202_ = self->board[_tmp199_];
		_tmp203_ = color;
		_tmp204_ = rook_end;
		_tmp205_ = BIT_BOARD_set_location_masks[_tmp204_];
		self->priv->piece_masks[_tmp203_] |= _tmp205_;
		_tmp206_ = self->priv->piece_masks[_tmp203_];
		_g_object_unref0 (rook);
	}
	_tmp207_ = piece;
	_tmp208_ = _tmp207_->type;
	if (_tmp208_ == PIECE_TYPE_KING) {
		Color _tmp209_;
		gboolean _tmp210_;
		Color _tmp211_;
		gboolean _tmp212_;
		_tmp209_ = color;
		self->can_castle_kingside[_tmp209_] = FALSE;
		_tmp210_ = self->can_castle_kingside[_tmp209_];
		_tmp211_ = color;
		self->can_castle_queenside[_tmp211_] = FALSE;
		_tmp212_ = self->can_castle_queenside[_tmp211_];
	} else {
		ChessPiece* _tmp213_;
		PieceType _tmp214_;
		_tmp213_ = piece;
		_tmp214_ = _tmp213_->type;
		if (_tmp214_ == PIECE_TYPE_ROOK) {
			gint _tmp215_ = 0;
			Color _tmp216_;
			gint base_rank = 0;
			gint _tmp217_;
			gint _tmp218_;
			_tmp216_ = color;
			if (_tmp216_ == COLOR_WHITE) {
				_tmp215_ = 0;
			} else {
				_tmp215_ = 7;
			}
			base_rank = _tmp215_;
			_tmp217_ = r0;
			_tmp218_ = base_rank;
			if (_tmp217_ == _tmp218_) {
				gint _tmp219_;
				_tmp219_ = f0;
				if (_tmp219_ == 0) {
					Color _tmp220_;
					gboolean _tmp221_;
					_tmp220_ = color;
					self->can_castle_queenside[_tmp220_] = FALSE;
					_tmp221_ = self->can_castle_queenside[_tmp220_];
				} else {
					gint _tmp222_;
					_tmp222_ = f0;
					if (_tmp222_ == 7) {
						Color _tmp223_;
						gboolean _tmp224_;
						_tmp223_ = color;
						self->can_castle_kingside[_tmp223_] = FALSE;
						_tmp224_ = self->can_castle_kingside[_tmp223_];
					}
				}
			}
		} else {
			gboolean _tmp225_ = FALSE;
			ChessPiece* _tmp226_;
			_tmp226_ = victim;
			if (_tmp226_ != NULL) {
				ChessPiece* _tmp227_;
				PieceType _tmp228_;
				_tmp227_ = victim;
				_tmp228_ = _tmp227_->type;
				_tmp225_ = _tmp228_ == PIECE_TYPE_ROOK;
			} else {
				_tmp225_ = FALSE;
			}
			if (_tmp225_) {
				gint _tmp229_ = 0;
				Color _tmp230_;
				gint base_rank = 0;
				gint _tmp231_;
				gint _tmp232_;
				_tmp230_ = opponent_color;
				if (_tmp230_ == COLOR_WHITE) {
					_tmp229_ = 0;
				} else {
					_tmp229_ = 7;
				}
				base_rank = _tmp229_;
				_tmp231_ = r1;
				_tmp232_ = base_rank;
				if (_tmp231_ == _tmp232_) {
					gint _tmp233_;
					_tmp233_ = f1;
					if (_tmp233_ == 0) {
						Color _tmp234_;
						gboolean _tmp235_;
						_tmp234_ = opponent_color;
						self->can_castle_queenside[_tmp234_] = FALSE;
						_tmp235_ = self->can_castle_queenside[_tmp234_];
					} else {
						gint _tmp236_;
						_tmp236_ = f1;
						if (_tmp236_ == 7) {
							Color _tmp237_;
							gboolean _tmp238_;
							_tmp237_ = opponent_color;
							self->can_castle_kingside[_tmp237_] = FALSE;
							_tmp238_ = self->can_castle_kingside[_tmp237_];
						}
					}
				}
			}
		}
	}
	_tmp240_ = piece;
	_tmp241_ = _tmp240_->type;
	if (_tmp241_ == PIECE_TYPE_PAWN) {
		gint64 _tmp242_;
		_tmp242_ = over_mask;
		_tmp239_ = _tmp242_ != ((gint64) 0);
	} else {
		_tmp239_ = FALSE;
	}
	if (_tmp239_) {
		gint _tmp243_;
		gint _tmp244_;
		gint _tmp245_;
		gint _tmp246_;
		_tmp243_ = r0;
		_tmp244_ = r1;
		_tmp245_ = f0;
		_tmp246_ = chess_state_get_index (self, (_tmp243_ + _tmp244_) / 2, _tmp245_);
		self->en_passant_index = _tmp246_;
	} else {
		self->en_passant_index = -1;
	}
	_tmp248_ = piece;
	_tmp249_ = _tmp248_->type;
	if (_tmp249_ == PIECE_TYPE_PAWN) {
		_tmp247_ = TRUE;
	} else {
		ChessPiece* _tmp250_;
		_tmp250_ = victim;
		_tmp247_ = _tmp250_ != NULL;
	}
	if (_tmp247_) {
		self->halfmove_clock = 0;
	} else {
		gint _tmp251_;
		_tmp251_ = self->halfmove_clock;
		self->halfmove_clock = _tmp251_ + 1;
	}
	_result_ = TRUE;
	_tmp253_ = test_check;
	if (_tmp253_) {
		ChessPlayer* _tmp254_;
		gboolean _tmp255_;
		_tmp254_ = player;
		_tmp255_ = chess_state_is_in_check (self, _tmp254_);
		_tmp252_ = _tmp255_;
	} else {
		_tmp252_ = FALSE;
	}
	if (_tmp252_) {
		_result_ = FALSE;
	}
	_tmp257_ = apply;
	if (!_tmp257_) {
		_tmp256_ = TRUE;
	} else {
		gboolean _tmp258_;
		_tmp258_ = _result_;
		_tmp256_ = !_tmp258_;
	}
	if (_tmp256_) {
		gint _tmp259_;
		ChessPiece* _tmp260_;
		ChessPiece* _tmp261_;
		ChessPiece* _tmp262_;
		gint _tmp263_;
		ChessPiece* _tmp264_;
		ChessPiece* _tmp265_;
		gint _tmp270_;
		gint64 _tmp280_;
		gint64 _tmp281_;
		gint64 _tmp282_;
		gint64 _tmp283_;
		gboolean _tmp284_;
		gboolean _tmp285_;
		gboolean _tmp286_;
		gboolean _tmp287_;
		gboolean _tmp288_;
		gboolean _tmp289_;
		gboolean _tmp290_;
		gboolean _tmp291_;
		gint _tmp292_;
		gint _tmp293_;
		_tmp259_ = start;
		_tmp260_ = piece;
		_tmp261_ = _g_object_ref0 (_tmp260_);
		_g_object_unref0 (self->board[_tmp259_]);
		self->board[_tmp259_] = _tmp261_;
		_tmp262_ = self->board[_tmp259_];
		_tmp263_ = end;
		_g_object_unref0 (self->board[_tmp263_]);
		self->board[_tmp263_] = NULL;
		_tmp264_ = self->board[_tmp263_];
		_tmp265_ = victim;
		if (_tmp265_ != NULL) {
			gint _tmp266_;
			ChessPiece* _tmp267_;
			ChessPiece* _tmp268_;
			ChessPiece* _tmp269_;
			_tmp266_ = victim_index;
			_tmp267_ = victim;
			_tmp268_ = _g_object_ref0 (_tmp267_);
			_g_object_unref0 (self->board[_tmp266_]);
			self->board[_tmp266_] = _tmp268_;
			_tmp269_ = self->board[_tmp266_];
		}
		_tmp270_ = rook_start;
		if (_tmp270_ >= 0) {
			ChessPiece* rook = NULL;
			gint _tmp271_;
			ChessPiece* _tmp272_;
			ChessPiece* _tmp273_;
			gint _tmp274_;
			ChessPiece* _tmp275_;
			ChessPiece* _tmp276_;
			ChessPiece* _tmp277_;
			gint _tmp278_;
			ChessPiece* _tmp279_;
			_tmp271_ = rook_end;
			_tmp272_ = self->board[_tmp271_];
			_tmp273_ = _g_object_ref0 (_tmp272_);
			rook = _tmp273_;
			_tmp274_ = rook_start;
			_tmp275_ = rook;
			_tmp276_ = _g_object_ref0 (_tmp275_);
			_g_object_unref0 (self->board[_tmp274_]);
			self->board[_tmp274_] = _tmp276_;
			_tmp277_ = self->board[_tmp274_];
			_tmp278_ = rook_end;
			_g_object_unref0 (self->board[_tmp278_]);
			self->board[_tmp278_] = NULL;
			_tmp279_ = self->board[_tmp278_];
			_g_object_unref0 (rook);
		}
		_tmp280_ = old_white_mask;
		self->priv->piece_masks[COLOR_WHITE] = _tmp280_;
		_tmp281_ = self->priv->piece_masks[COLOR_WHITE];
		_tmp282_ = old_black_mask;
		self->priv->piece_masks[COLOR_BLACK] = _tmp282_;
		_tmp283_ = self->priv->piece_masks[COLOR_BLACK];
		_tmp284_ = old_white_can_castle_kingside;
		self->can_castle_kingside[COLOR_WHITE] = _tmp284_;
		_tmp285_ = self->can_castle_kingside[COLOR_WHITE];
		_tmp286_ = old_white_can_castle_queenside;
		self->can_castle_queenside[COLOR_WHITE] = _tmp286_;
		_tmp287_ = self->can_castle_queenside[COLOR_WHITE];
		_tmp288_ = old_black_can_castle_kingside;
		self->can_castle_kingside[COLOR_BLACK] = _tmp288_;
		_tmp289_ = self->can_castle_kingside[COLOR_BLACK];
		_tmp290_ = old_black_can_castle_queenside;
		self->can_castle_queenside[COLOR_BLACK] = _tmp290_;
		_tmp291_ = self->can_castle_queenside[COLOR_BLACK];
		_tmp292_ = old_en_passant_index;
		self->en_passant_index = _tmp292_;
		_tmp293_ = old_halfmove_clock;
		self->halfmove_clock = _tmp293_;
		result = _result_;
		_g_object_unref0 (victim);
		_g_object_unref0 (piece);
		return result;
	}
	_tmp295_ = color;
	if (_tmp295_ == COLOR_WHITE) {
		ChessPlayer* _tmp296_;
		_tmp296_ = self->players[COLOR_BLACK];
		_tmp294_ = _tmp296_;
	} else {
		ChessPlayer* _tmp297_;
		_tmp297_ = self->players[COLOR_WHITE];
		_tmp294_ = _tmp297_;
	}
	_tmp298_ = _g_object_ref0 (_tmp294_);
	_g_object_unref0 (self->current_player);
	self->current_player = _tmp298_;
	_tmp299_ = self->current_player;
	_tmp300_ = chess_state_get_check_state (self, _tmp299_);
	self->check_state = _tmp300_;
	_tmp301_ = chess_move_new ();
	_g_object_unref0 (self->last_move);
	self->last_move = _tmp301_;
	_tmp302_ = self->last_move;
	_tmp303_ = self->number;
	_tmp302_->number = _tmp303_;
	_tmp304_ = self->last_move;
	_tmp305_ = piece;
	_tmp306_ = _g_object_ref0 (_tmp305_);
	_g_object_unref0 (_tmp304_->piece);
	_tmp304_->piece = _tmp306_;
	_tmp307_ = is_promotion;
	if (_tmp307_) {
		ChessMove* _tmp308_;
		gint _tmp309_;
		ChessPiece* _tmp310_;
		ChessPiece* _tmp311_;
		_tmp308_ = self->last_move;
		_tmp309_ = end;
		_tmp310_ = self->board[_tmp309_];
		_tmp311_ = _g_object_ref0 (_tmp310_);
		_g_object_unref0 (_tmp308_->promotion_piece);
		_tmp308_->promotion_piece = _tmp311_;
	}
	_tmp312_ = self->last_move;
	_tmp313_ = victim;
	_tmp314_ = _g_object_ref0 (_tmp313_);
	_g_object_unref0 (_tmp312_->victim);
	_tmp312_->victim = _tmp314_;
	_tmp315_ = rook_end;
	if (_tmp315_ >= 0) {
		ChessMove* _tmp316_;
		gint _tmp317_;
		ChessPiece* _tmp318_;
		ChessPiece* _tmp319_;
		_tmp316_ = self->last_move;
		_tmp317_ = rook_end;
		_tmp318_ = self->board[_tmp317_];
		_tmp319_ = _g_object_ref0 (_tmp318_);
		_g_object_unref0 (_tmp316_->moved_rook);
		_tmp316_->moved_rook = _tmp319_;
	}
	_tmp320_ = self->last_move;
	_tmp321_ = r0;
	_tmp320_->r0 = _tmp321_;
	_tmp322_ = self->last_move;
	_tmp323_ = f0;
	_tmp322_->f0 = _tmp323_;
	_tmp324_ = self->last_move;
	_tmp325_ = r1;
	_tmp324_->r1 = _tmp325_;
	_tmp326_ = self->last_move;
	_tmp327_ = f1;
	_tmp326_->f1 = _tmp327_;
	_tmp328_ = self->last_move;
	_tmp329_ = ambiguous_rank;
	_tmp328_->ambiguous_rank = _tmp329_;
	_tmp330_ = self->last_move;
	_tmp331_ = ambiguous_file;
	_tmp330_->ambiguous_file = _tmp331_;
	_tmp332_ = self->last_move;
	_tmp333_ = self->check_state;
	_tmp332_->check_state = _tmp333_;
	result = TRUE;
	_g_object_unref0 (victim);
	_g_object_unref0 (piece);
	return result;
}


ChessResult chess_state_get_result (ChessState* self, ChessRule* rule) {
	ChessRule _vala_rule = 0;
	ChessResult result = 0;
	CheckState _tmp0_;
	ChessPlayer* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	ChessMove* _tmp7_;
	g_return_val_if_fail (self != NULL, 0);
	_vala_rule = CHESS_RULE_CHECKMATE;
	_tmp0_ = self->check_state;
	if (_tmp0_ == CHECK_STATE_CHECKMATE) {
		ChessPlayer* _tmp1_;
		Color _tmp2_;
		_tmp1_ = self->current_player;
		_tmp2_ = _tmp1_->color;
		if (_tmp2_ == COLOR_WHITE) {
			_vala_rule = CHESS_RULE_CHECKMATE;
			result = CHESS_RESULT_BLACK_WON;
			if (rule) {
				*rule = _vala_rule;
			}
			return result;
		} else {
			_vala_rule = CHESS_RULE_CHECKMATE;
			result = CHESS_RESULT_WHITE_WON;
			if (rule) {
				*rule = _vala_rule;
			}
			return result;
		}
	}
	_tmp3_ = self->current_player;
	_tmp4_ = chess_state_can_move (self, _tmp3_);
	if (!_tmp4_) {
		_vala_rule = CHESS_RULE_STALEMATE;
		result = CHESS_RESULT_DRAW;
		if (rule) {
			*rule = _vala_rule;
		}
		return result;
	}
	_tmp7_ = self->last_move;
	if (_tmp7_ != NULL) {
		ChessMove* _tmp8_;
		ChessPiece* _tmp9_;
		_tmp8_ = self->last_move;
		_tmp9_ = _tmp8_->victim;
		_tmp6_ = _tmp9_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gboolean _tmp10_;
		_tmp10_ = chess_state_have_sufficient_material (self);
		_tmp5_ = !_tmp10_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_vala_rule = CHESS_RULE_INSUFFICIENT_MATERIAL;
		result = CHESS_RESULT_DRAW;
		if (rule) {
			*rule = _vala_rule;
		}
		return result;
	}
	result = CHESS_RESULT_IN_PROGRESS;
	if (rule) {
		*rule = _vala_rule;
	}
	return result;
}


static CheckState chess_state_get_check_state (ChessState* self, ChessPlayer* player) {
	CheckState result = 0;
	ChessPlayer* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (player != NULL, 0);
	_tmp0_ = player;
	_tmp1_ = chess_state_is_in_check (self, _tmp0_);
	if (_tmp1_) {
		ChessPlayer* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = player;
		_tmp3_ = chess_state_is_in_checkmate (self, _tmp2_);
		if (_tmp3_) {
			result = CHECK_STATE_CHECKMATE;
			return result;
		} else {
			result = CHECK_STATE_CHECK;
			return result;
		}
	}
	result = CHECK_STATE_NONE;
	return result;
}


gboolean chess_state_is_in_check (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_;
	Color _tmp2_;
	ChessPlayer* opponent = NULL;
	ChessPlayer* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp1_ = player;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		ChessPlayer* _tmp3_;
		_tmp3_ = self->players[COLOR_BLACK];
		_tmp0_ = _tmp3_;
	} else {
		ChessPlayer* _tmp4_;
		_tmp4_ = self->players[COLOR_WHITE];
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _g_object_ref0 (_tmp0_);
	opponent = _tmp5_;
	{
		gint king_index = 0;
		king_index = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_;
				ChessPiece* p = NULL;
				gint _tmp9_;
				ChessPiece* _tmp10_;
				ChessPiece* _tmp11_;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				ChessPiece* _tmp14_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = king_index;
					king_index = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = king_index;
				if (!(_tmp8_ < 64)) {
					break;
				}
				_tmp9_ = king_index;
				_tmp10_ = self->board[_tmp9_];
				_tmp11_ = _g_object_ref0 (_tmp10_);
				p = _tmp11_;
				_tmp14_ = p;
				if (_tmp14_ != NULL) {
					ChessPiece* _tmp15_;
					ChessPlayer* _tmp16_;
					ChessPlayer* _tmp17_;
					_tmp15_ = p;
					_tmp16_ = _tmp15_->player;
					_tmp17_ = player;
					_tmp13_ = _tmp16_ == _tmp17_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					ChessPiece* _tmp18_;
					PieceType _tmp19_;
					_tmp18_ = p;
					_tmp19_ = _tmp18_->type;
					_tmp12_ = _tmp19_ == PIECE_TYPE_KING;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					{
						gint start = 0;
						start = 0;
						{
							gboolean _tmp20_ = FALSE;
							_tmp20_ = TRUE;
							while (TRUE) {
								gint _tmp22_;
								ChessPlayer* _tmp23_;
								gint _tmp24_;
								gint _tmp25_;
								gint _tmp26_;
								gint _tmp27_;
								gint _tmp28_;
								gint _tmp29_;
								gint _tmp30_;
								gint _tmp31_;
								gboolean _tmp32_;
								if (!_tmp20_) {
									gint _tmp21_;
									_tmp21_ = start;
									start = _tmp21_ + 1;
								}
								_tmp20_ = FALSE;
								_tmp22_ = start;
								if (!(_tmp22_ < 64)) {
									break;
								}
								_tmp23_ = opponent;
								_tmp24_ = start;
								_tmp25_ = chess_state_get_rank (self, _tmp24_);
								_tmp26_ = start;
								_tmp27_ = chess_state_get_file (self, _tmp26_);
								_tmp28_ = king_index;
								_tmp29_ = chess_state_get_rank (self, _tmp28_);
								_tmp30_ = king_index;
								_tmp31_ = chess_state_get_file (self, _tmp30_);
								_tmp32_ = chess_state_move_with_coords (self, _tmp23_, _tmp25_, _tmp27_, _tmp29_, _tmp31_, PIECE_TYPE_QUEEN, FALSE, FALSE);
								if (_tmp32_) {
									result = TRUE;
									_g_object_unref0 (p);
									_g_object_unref0 (opponent);
									return result;
								}
							}
						}
					}
				}
				_g_object_unref0 (p);
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (opponent);
	return result;
}


static gboolean chess_state_is_in_checkmate (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	{
		gint piece_index = 0;
		piece_index = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ChessPiece* p = NULL;
				gint _tmp3_;
				ChessPiece* _tmp4_;
				ChessPiece* _tmp5_;
				gboolean _tmp6_ = FALSE;
				ChessPiece* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = piece_index;
					piece_index = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = piece_index;
				if (!(_tmp2_ < 64)) {
					break;
				}
				_tmp3_ = piece_index;
				_tmp4_ = self->board[_tmp3_];
				_tmp5_ = _g_object_ref0 (_tmp4_);
				p = _tmp5_;
				_tmp7_ = p;
				if (_tmp7_ != NULL) {
					ChessPiece* _tmp8_;
					ChessPlayer* _tmp9_;
					ChessPlayer* _tmp10_;
					_tmp8_ = p;
					_tmp9_ = _tmp8_->player;
					_tmp10_ = player;
					_tmp6_ = _tmp9_ == _tmp10_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					{
						gint end = 0;
						end = 0;
						{
							gboolean _tmp11_ = FALSE;
							_tmp11_ = TRUE;
							while (TRUE) {
								gint _tmp13_;
								ChessPlayer* _tmp14_;
								gint _tmp15_;
								gint _tmp16_;
								gint _tmp17_;
								gint _tmp18_;
								gint _tmp19_;
								gint _tmp20_;
								gint _tmp21_;
								gint _tmp22_;
								gboolean _tmp23_;
								if (!_tmp11_) {
									gint _tmp12_;
									_tmp12_ = end;
									end = _tmp12_ + 1;
								}
								_tmp11_ = FALSE;
								_tmp13_ = end;
								if (!(_tmp13_ < 64)) {
									break;
								}
								_tmp14_ = player;
								_tmp15_ = piece_index;
								_tmp16_ = chess_state_get_rank (self, _tmp15_);
								_tmp17_ = piece_index;
								_tmp18_ = chess_state_get_file (self, _tmp17_);
								_tmp19_ = end;
								_tmp20_ = chess_state_get_rank (self, _tmp19_);
								_tmp21_ = end;
								_tmp22_ = chess_state_get_file (self, _tmp21_);
								_tmp23_ = chess_state_move_with_coords (self, _tmp14_, _tmp16_, _tmp18_, _tmp20_, _tmp22_, PIECE_TYPE_QUEEN, FALSE, TRUE);
								if (_tmp23_) {
									result = FALSE;
									_g_object_unref0 (p);
									return result;
								}
							}
						}
					}
				}
				_g_object_unref0 (p);
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean chess_state_can_move (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean have_pieces = FALSE;
	gboolean _tmp24_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	have_pieces = FALSE;
	{
		gint start = 0;
		start = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ChessPiece* p = NULL;
				gint _tmp3_;
				ChessPiece* _tmp4_;
				ChessPiece* _tmp5_;
				gboolean _tmp6_ = FALSE;
				ChessPiece* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = start;
					start = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = start;
				if (!(_tmp2_ < 64)) {
					break;
				}
				_tmp3_ = start;
				_tmp4_ = self->board[_tmp3_];
				_tmp5_ = _g_object_ref0 (_tmp4_);
				p = _tmp5_;
				_tmp7_ = p;
				if (_tmp7_ != NULL) {
					ChessPiece* _tmp8_;
					ChessPlayer* _tmp9_;
					ChessPlayer* _tmp10_;
					_tmp8_ = p;
					_tmp9_ = _tmp8_->player;
					_tmp10_ = player;
					_tmp6_ = _tmp9_ == _tmp10_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					have_pieces = TRUE;
					{
						gint end = 0;
						end = 0;
						{
							gboolean _tmp11_ = FALSE;
							_tmp11_ = TRUE;
							while (TRUE) {
								gint _tmp13_;
								ChessPlayer* _tmp14_;
								gint _tmp15_;
								gint _tmp16_;
								gint _tmp17_;
								gint _tmp18_;
								gint _tmp19_;
								gint _tmp20_;
								gint _tmp21_;
								gint _tmp22_;
								gboolean _tmp23_;
								if (!_tmp11_) {
									gint _tmp12_;
									_tmp12_ = end;
									end = _tmp12_ + 1;
								}
								_tmp11_ = FALSE;
								_tmp13_ = end;
								if (!(_tmp13_ < 64)) {
									break;
								}
								_tmp14_ = player;
								_tmp15_ = start;
								_tmp16_ = chess_state_get_rank (self, _tmp15_);
								_tmp17_ = start;
								_tmp18_ = chess_state_get_file (self, _tmp17_);
								_tmp19_ = end;
								_tmp20_ = chess_state_get_rank (self, _tmp19_);
								_tmp21_ = end;
								_tmp22_ = chess_state_get_file (self, _tmp21_);
								_tmp23_ = chess_state_move_with_coords (self, _tmp14_, _tmp16_, _tmp18_, _tmp20_, _tmp22_, PIECE_TYPE_QUEEN, FALSE, TRUE);
								if (_tmp23_) {
									result = TRUE;
									_g_object_unref0 (p);
									return result;
								}
							}
						}
					}
				}
				_g_object_unref0 (p);
			}
		}
	}
	_tmp24_ = have_pieces;
	if (_tmp24_) {
		result = FALSE;
		return result;
	} else {
		result = TRUE;
		return result;
	}
}


gboolean chess_state_have_sufficient_material (ChessState* self) {
	gboolean result = FALSE;
	gint white_knight_count = 0;
	gint white_bishop_count = 0;
	gboolean white_bishop_on_white_square = FALSE;
	gboolean white_bishop_on_black_square = FALSE;
	gint black_knight_count = 0;
	gint black_bishop_count = 0;
	gboolean black_bishop_on_white_square = FALSE;
	gboolean black_bishop_on_black_square = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	white_knight_count = 0;
	white_bishop_count = 0;
	white_bishop_on_white_square = FALSE;
	white_bishop_on_black_square = FALSE;
	black_knight_count = 0;
	black_bishop_count = 0;
	black_bishop_on_white_square = FALSE;
	black_bishop_on_black_square = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ChessPiece* p = NULL;
				gint _tmp3_;
				ChessPiece* _tmp4_;
				ChessPiece* _tmp5_;
				ChessPiece* _tmp6_;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				ChessPiece* _tmp9_;
				PieceType _tmp10_;
				ChessPiece* _tmp15_;
				PieceType _tmp16_;
				ChessPiece* _tmp22_;
				PieceType _tmp23_;
				gboolean _tmp33_ = FALSE;
				gint _tmp34_;
				gboolean _tmp36_ = FALSE;
				gint _tmp37_;
				gboolean _tmp39_ = FALSE;
				gint _tmp40_;
				gboolean _tmp42_ = FALSE;
				gboolean _tmp43_;
				gboolean _tmp45_ = FALSE;
				gboolean _tmp46_;
				gboolean _tmp48_ = FALSE;
				gboolean _tmp49_ = FALSE;
				gint _tmp50_;
				gboolean _tmp53_ = FALSE;
				gboolean _tmp54_ = FALSE;
				gint _tmp55_;
				gboolean _tmp58_ = FALSE;
				gint _tmp59_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < 64)) {
					break;
				}
				_tmp3_ = i;
				_tmp4_ = self->board[_tmp3_];
				_tmp5_ = _g_object_ref0 (_tmp4_);
				p = _tmp5_;
				_tmp6_ = p;
				if (_tmp6_ == NULL) {
					_g_object_unref0 (p);
					continue;
				}
				_tmp9_ = p;
				_tmp10_ = _tmp9_->type;
				if (_tmp10_ == PIECE_TYPE_PAWN) {
					_tmp8_ = TRUE;
				} else {
					ChessPiece* _tmp11_;
					PieceType _tmp12_;
					_tmp11_ = p;
					_tmp12_ = _tmp11_->type;
					_tmp8_ = _tmp12_ == PIECE_TYPE_ROOK;
				}
				if (_tmp8_) {
					_tmp7_ = TRUE;
				} else {
					ChessPiece* _tmp13_;
					PieceType _tmp14_;
					_tmp13_ = p;
					_tmp14_ = _tmp13_->type;
					_tmp7_ = _tmp14_ == PIECE_TYPE_QUEEN;
				}
				if (_tmp7_) {
					result = TRUE;
					_g_object_unref0 (p);
					return result;
				}
				_tmp15_ = p;
				_tmp16_ = _tmp15_->type;
				if (_tmp16_ == PIECE_TYPE_KNIGHT) {
					ChessPiece* _tmp17_;
					Color _tmp18_;
					Color _tmp19_;
					_tmp17_ = p;
					_tmp18_ = chess_piece_get_color (_tmp17_);
					_tmp19_ = _tmp18_;
					if (_tmp19_ == COLOR_WHITE) {
						gint _tmp20_;
						_tmp20_ = white_knight_count;
						white_knight_count = _tmp20_ + 1;
					} else {
						gint _tmp21_;
						_tmp21_ = black_knight_count;
						black_knight_count = _tmp21_ + 1;
					}
				}
				_tmp22_ = p;
				_tmp23_ = _tmp22_->type;
				if (_tmp23_ == PIECE_TYPE_BISHOP) {
					Color color = 0;
					gint _tmp24_;
					gint _tmp25_;
					ChessPiece* _tmp26_;
					Color _tmp27_;
					Color _tmp28_;
					color = COLOR_BLACK;
					_tmp24_ = i;
					_tmp25_ = i;
					if (((_tmp24_ + (_tmp25_ / 8)) % 2) != 0) {
						color = COLOR_WHITE;
					}
					_tmp26_ = p;
					_tmp27_ = chess_piece_get_color (_tmp26_);
					_tmp28_ = _tmp27_;
					if (_tmp28_ == COLOR_WHITE) {
						Color _tmp29_;
						gint _tmp30_;
						_tmp29_ = color;
						if (_tmp29_ == COLOR_WHITE) {
							white_bishop_on_white_square = TRUE;
						} else {
							white_bishop_on_black_square = TRUE;
						}
						_tmp30_ = white_bishop_count;
						white_bishop_count = _tmp30_ + 1;
					} else {
						Color _tmp31_;
						gint _tmp32_;
						_tmp31_ = color;
						if (_tmp31_ == COLOR_WHITE) {
							black_bishop_on_white_square = TRUE;
						} else {
							black_bishop_on_black_square = TRUE;
						}
						_tmp32_ = black_bishop_count;
						black_bishop_count = _tmp32_ + 1;
					}
				}
				_tmp34_ = white_knight_count;
				if (_tmp34_ > 1) {
					_tmp33_ = TRUE;
				} else {
					gint _tmp35_;
					_tmp35_ = black_knight_count;
					_tmp33_ = _tmp35_ > 1;
				}
				if (_tmp33_) {
					result = TRUE;
					_g_object_unref0 (p);
					return result;
				}
				_tmp37_ = white_bishop_count;
				if (_tmp37_ > 0) {
					gint _tmp38_;
					_tmp38_ = white_knight_count;
					_tmp36_ = _tmp38_ > 0;
				} else {
					_tmp36_ = FALSE;
				}
				if (_tmp36_) {
					result = TRUE;
					_g_object_unref0 (p);
					return result;
				}
				_tmp40_ = black_bishop_count;
				if (_tmp40_ > 0) {
					gint _tmp41_;
					_tmp41_ = black_knight_count;
					_tmp39_ = _tmp41_ > 0;
				} else {
					_tmp39_ = FALSE;
				}
				if (_tmp39_) {
					result = TRUE;
					_g_object_unref0 (p);
					return result;
				}
				_tmp43_ = white_bishop_on_white_square;
				if (_tmp43_) {
					gboolean _tmp44_;
					_tmp44_ = white_bishop_on_black_square;
					_tmp42_ = _tmp44_;
				} else {
					_tmp42_ = FALSE;
				}
				if (_tmp42_) {
					result = TRUE;
					_g_object_unref0 (p);
					return result;
				}
				_tmp46_ = black_bishop_on_white_square;
				if (_tmp46_) {
					gboolean _tmp47_;
					_tmp47_ = black_bishop_on_black_square;
					_tmp45_ = _tmp47_;
				} else {
					_tmp45_ = FALSE;
				}
				if (_tmp45_) {
					result = TRUE;
					_g_object_unref0 (p);
					return result;
				}
				_tmp50_ = white_bishop_count;
				if (_tmp50_ > 0) {
					_tmp49_ = TRUE;
				} else {
					gint _tmp51_;
					_tmp51_ = white_knight_count;
					_tmp49_ = _tmp51_ > 0;
				}
				if (_tmp49_) {
					gint _tmp52_;
					_tmp52_ = black_knight_count;
					_tmp48_ = _tmp52_ > 0;
				} else {
					_tmp48_ = FALSE;
				}
				if (_tmp48_) {
					result = TRUE;
					_g_object_unref0 (p);
					return result;
				}
				_tmp55_ = black_bishop_count;
				if (_tmp55_ > 0) {
					_tmp54_ = TRUE;
				} else {
					gint _tmp56_;
					_tmp56_ = black_knight_count;
					_tmp54_ = _tmp56_ > 0;
				}
				if (_tmp54_) {
					gint _tmp57_;
					_tmp57_ = white_knight_count;
					_tmp53_ = _tmp57_ > 0;
				} else {
					_tmp53_ = FALSE;
				}
				if (_tmp53_) {
					result = TRUE;
					_g_object_unref0 (p);
					return result;
				}
				_tmp59_ = white_bishop_count;
				if (_tmp59_ > 0) {
					gint _tmp60_;
					_tmp60_ = black_bishop_count;
					_tmp58_ = _tmp60_ > 0;
				} else {
					_tmp58_ = FALSE;
				}
				if (_tmp58_) {
					gboolean _tmp61_ = FALSE;
					gboolean _tmp62_;
					_tmp62_ = white_bishop_on_white_square;
					if (_tmp62_) {
						gboolean _tmp63_;
						_tmp63_ = black_bishop_on_black_square;
						_tmp61_ = _tmp63_;
					} else {
						_tmp61_ = FALSE;
					}
					if (_tmp61_) {
						result = TRUE;
						_g_object_unref0 (p);
						return result;
					} else {
						gboolean _tmp64_ = FALSE;
						gboolean _tmp65_;
						_tmp65_ = white_bishop_on_black_square;
						if (_tmp65_) {
							gboolean _tmp66_;
							_tmp66_ = black_bishop_on_white_square;
							_tmp64_ = _tmp66_;
						} else {
							_tmp64_ = FALSE;
						}
						if (_tmp64_) {
							result = TRUE;
							_g_object_unref0 (p);
							return result;
						}
					}
				}
				_g_object_unref0 (p);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean chess_state_decode_piece_type (ChessState* self, gunichar c, PieceType* type) {
	PieceType _vala_type = 0;
	gboolean result = FALSE;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_type = PIECE_TYPE_PAWN;
	_tmp0_ = c;
	switch (_tmp0_) {
		case 'P':
		{
			_vala_type = PIECE_TYPE_PAWN;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		case 'R':
		{
			_vala_type = PIECE_TYPE_ROOK;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		case 'N':
		{
			_vala_type = PIECE_TYPE_KNIGHT;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		case 'B':
		{
			_vala_type = PIECE_TYPE_BISHOP;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		case 'Q':
		{
			_vala_type = PIECE_TYPE_QUEEN;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		case 'K':
		{
			_vala_type = PIECE_TYPE_KING;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		default:
		{
			result = FALSE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
	}
	if (type) {
		*type = _vala_type;
	}
}


static gboolean chess_state_decode_move (ChessState* self, ChessPlayer* player, const gchar* move, gint* r0, gint* f0, gint* r1, gint* f1, PieceType* promotion_type) {
	gint _vala_r0 = 0;
	gint _vala_f0 = 0;
	gint _vala_r1 = 0;
	gint _vala_f1 = 0;
	PieceType _vala_promotion_type = 0;
	gboolean result = FALSE;
	gint i = 0;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp150_;
	gint _tmp151_;
	gchar _tmp152_;
	const gchar* _tmp158_;
	gint _tmp159_;
	gchar _tmp160_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	g_return_val_if_fail (move != NULL, FALSE);
	i = 0;
	_vala_promotion_type = PIECE_TYPE_QUEEN;
	_tmp0_ = move;
	_tmp1_ = g_str_has_prefix (_tmp0_, "O-O-O");
	if (_tmp1_) {
		ChessPlayer* _tmp2_;
		Color _tmp3_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp2_ = player;
		_tmp3_ = _tmp2_->color;
		if (_tmp3_ == COLOR_WHITE) {
			gint _tmp4_;
			_vala_r1 = 0;
			_tmp4_ = _vala_r1;
			_vala_r0 = _tmp4_;
		} else {
			gint _tmp5_;
			_vala_r1 = 7;
			_tmp5_ = _vala_r1;
			_vala_r0 = _tmp5_;
		}
		_vala_f0 = 4;
		_vala_f1 = 2;
		_tmp6_ = i;
		_tmp7_ = strlen ("O-O-O");
		_tmp8_ = _tmp7_;
		i = _tmp6_ + ((gint) _tmp8_);
	} else {
		const gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = move;
		_tmp10_ = g_str_has_prefix (_tmp9_, "O-O");
		if (_tmp10_) {
			ChessPlayer* _tmp11_;
			Color _tmp12_;
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			_tmp11_ = player;
			_tmp12_ = _tmp11_->color;
			if (_tmp12_ == COLOR_WHITE) {
				gint _tmp13_;
				_vala_r1 = 0;
				_tmp13_ = _vala_r1;
				_vala_r0 = _tmp13_;
			} else {
				gint _tmp14_;
				_vala_r1 = 7;
				_tmp14_ = _vala_r1;
				_vala_r0 = _tmp14_;
			}
			_vala_f0 = 4;
			_vala_f1 = 6;
			_tmp15_ = i;
			_tmp16_ = strlen ("O-O");
			_tmp17_ = _tmp16_;
			i = _tmp15_ + ((gint) _tmp17_);
		} else {
			PieceType type = 0;
			const gchar* _tmp18_;
			gint _tmp19_;
			gchar _tmp20_;
			PieceType _tmp21_ = 0;
			gboolean _tmp22_;
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gboolean _tmp27_ = FALSE;
			const gchar* _tmp28_;
			gint _tmp29_;
			gchar _tmp30_;
			gboolean _tmp38_ = FALSE;
			const gchar* _tmp39_;
			gint _tmp40_;
			gchar _tmp41_;
			gboolean _tmp49_ = FALSE;
			const gchar* _tmp50_;
			gint _tmp51_;
			gchar _tmp52_;
			gboolean _tmp57_ = FALSE;
			const gchar* _tmp58_;
			gint _tmp59_;
			gchar _tmp60_;
			gboolean _tmp69_ = FALSE;
			const gchar* _tmp70_;
			gint _tmp71_;
			gchar _tmp72_;
			const gchar* _tmp81_;
			gint _tmp82_;
			gchar _tmp83_;
			gboolean _tmp101_ = FALSE;
			gint _tmp102_;
			gboolean _tmp105_ = FALSE;
			gint _tmp106_;
			type = PIECE_TYPE_PAWN;
			_tmp18_ = move;
			_tmp19_ = i;
			_tmp20_ = string_get (_tmp18_, (glong) _tmp19_);
			_tmp22_ = chess_state_decode_piece_type (self, (gunichar) _tmp20_, &_tmp21_);
			type = _tmp21_;
			if (_tmp22_) {
				gint _tmp23_;
				_tmp23_ = i;
				i = _tmp23_ + 1;
			}
			_vala_f1 = -1;
			_tmp24_ = _vala_f1;
			_vala_r1 = _tmp24_;
			_tmp25_ = _vala_r1;
			_vala_f0 = _tmp25_;
			_tmp26_ = _vala_f0;
			_vala_r0 = _tmp26_;
			_tmp28_ = move;
			_tmp29_ = i;
			_tmp30_ = string_get (_tmp28_, (glong) _tmp29_);
			if (_tmp30_ >= 'a') {
				const gchar* _tmp31_;
				gint _tmp32_;
				gchar _tmp33_;
				_tmp31_ = move;
				_tmp32_ = i;
				_tmp33_ = string_get (_tmp31_, (glong) _tmp32_);
				_tmp27_ = _tmp33_ <= 'h';
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				const gchar* _tmp34_;
				gint _tmp35_;
				gchar _tmp36_;
				gint _tmp37_;
				_tmp34_ = move;
				_tmp35_ = i;
				_tmp36_ = string_get (_tmp34_, (glong) _tmp35_);
				_vala_f1 = (gint) (_tmp36_ - 'a');
				_tmp37_ = i;
				i = _tmp37_ + 1;
			}
			_tmp39_ = move;
			_tmp40_ = i;
			_tmp41_ = string_get (_tmp39_, (glong) _tmp40_);
			if (_tmp41_ >= '1') {
				const gchar* _tmp42_;
				gint _tmp43_;
				gchar _tmp44_;
				_tmp42_ = move;
				_tmp43_ = i;
				_tmp44_ = string_get (_tmp42_, (glong) _tmp43_);
				_tmp38_ = _tmp44_ <= '8';
			} else {
				_tmp38_ = FALSE;
			}
			if (_tmp38_) {
				const gchar* _tmp45_;
				gint _tmp46_;
				gchar _tmp47_;
				gint _tmp48_;
				_tmp45_ = move;
				_tmp46_ = i;
				_tmp47_ = string_get (_tmp45_, (glong) _tmp46_);
				_vala_r1 = (gint) (_tmp47_ - '1');
				_tmp48_ = i;
				i = _tmp48_ + 1;
			}
			_tmp50_ = move;
			_tmp51_ = i;
			_tmp52_ = string_get (_tmp50_, (glong) _tmp51_);
			if (_tmp52_ == 'x') {
				_tmp49_ = TRUE;
			} else {
				const gchar* _tmp53_;
				gint _tmp54_;
				gchar _tmp55_;
				_tmp53_ = move;
				_tmp54_ = i;
				_tmp55_ = string_get (_tmp53_, (glong) _tmp54_);
				_tmp49_ = _tmp55_ == '-';
			}
			if (_tmp49_) {
				gint _tmp56_;
				_tmp56_ = i;
				i = _tmp56_ + 1;
			}
			_tmp58_ = move;
			_tmp59_ = i;
			_tmp60_ = string_get (_tmp58_, (glong) _tmp59_);
			if (_tmp60_ >= 'a') {
				const gchar* _tmp61_;
				gint _tmp62_;
				gchar _tmp63_;
				_tmp61_ = move;
				_tmp62_ = i;
				_tmp63_ = string_get (_tmp61_, (glong) _tmp62_);
				_tmp57_ = _tmp63_ <= 'h';
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				gint _tmp64_;
				const gchar* _tmp65_;
				gint _tmp66_;
				gchar _tmp67_;
				gint _tmp68_;
				_tmp64_ = _vala_f1;
				_vala_f0 = _tmp64_;
				_tmp65_ = move;
				_tmp66_ = i;
				_tmp67_ = string_get (_tmp65_, (glong) _tmp66_);
				_vala_f1 = (gint) (_tmp67_ - 'a');
				_tmp68_ = i;
				i = _tmp68_ + 1;
			}
			_tmp70_ = move;
			_tmp71_ = i;
			_tmp72_ = string_get (_tmp70_, (glong) _tmp71_);
			if (_tmp72_ >= '1') {
				const gchar* _tmp73_;
				gint _tmp74_;
				gchar _tmp75_;
				_tmp73_ = move;
				_tmp74_ = i;
				_tmp75_ = string_get (_tmp73_, (glong) _tmp74_);
				_tmp69_ = _tmp75_ <= '8';
			} else {
				_tmp69_ = FALSE;
			}
			if (_tmp69_) {
				gint _tmp76_;
				const gchar* _tmp77_;
				gint _tmp78_;
				gchar _tmp79_;
				gint _tmp80_;
				_tmp76_ = _vala_r1;
				_vala_r0 = _tmp76_;
				_tmp77_ = move;
				_tmp78_ = i;
				_tmp79_ = string_get (_tmp77_, (glong) _tmp78_);
				_vala_r1 = (gint) (_tmp79_ - '1');
				_tmp80_ = i;
				i = _tmp80_ + 1;
			}
			_tmp81_ = move;
			_tmp82_ = i;
			_tmp83_ = string_get (_tmp81_, (glong) _tmp82_);
			if (_tmp83_ == '=') {
				gint _tmp84_;
				const gchar* _tmp85_;
				gint _tmp86_;
				gchar _tmp87_;
				PieceType _tmp88_ = 0;
				gboolean _tmp89_;
				_tmp84_ = i;
				i = _tmp84_ + 1;
				_tmp85_ = move;
				_tmp86_ = i;
				_tmp87_ = string_get (_tmp85_, (glong) _tmp86_);
				_tmp89_ = chess_state_decode_piece_type (self, (gunichar) _tmp87_, &_tmp88_);
				_vala_promotion_type = _tmp88_;
				if (_tmp89_) {
					gint _tmp90_;
					_tmp90_ = i;
					i = _tmp90_ + 1;
				}
			} else {
				const gchar* _tmp91_;
				gint _tmp92_;
				gchar _tmp93_;
				_tmp91_ = move;
				_tmp92_ = i;
				_tmp93_ = string_get (_tmp91_, (glong) _tmp92_);
				if (_tmp93_ != '\0') {
					const gchar* _tmp94_;
					gint _tmp95_;
					gchar _tmp96_;
					_tmp94_ = move;
					_tmp95_ = i;
					_tmp96_ = string_get (_tmp94_, (glong) _tmp95_);
					switch (_tmp96_) {
						case 'q':
						case 'Q':
						{
							gint _tmp97_;
							_vala_promotion_type = PIECE_TYPE_QUEEN;
							_tmp97_ = i;
							i = _tmp97_ + 1;
							break;
						}
						case 'n':
						case 'N':
						{
							gint _tmp98_;
							_vala_promotion_type = PIECE_TYPE_KNIGHT;
							_tmp98_ = i;
							i = _tmp98_ + 1;
							break;
						}
						case 'r':
						case 'R':
						{
							gint _tmp99_;
							_vala_promotion_type = PIECE_TYPE_ROOK;
							_tmp99_ = i;
							i = _tmp99_ + 1;
							break;
						}
						case 'b':
						case 'B':
						{
							gint _tmp100_;
							_vala_promotion_type = PIECE_TYPE_BISHOP;
							_tmp100_ = i;
							i = _tmp100_ + 1;
							break;
						}
						default:
						break;
					}
				}
			}
			_tmp102_ = _vala_r1;
			if (_tmp102_ < 0) {
				_tmp101_ = TRUE;
			} else {
				gint _tmp103_;
				_tmp103_ = _vala_f1;
				_tmp101_ = _tmp103_ < 0;
			}
			if (_tmp101_) {
				const gchar* _tmp104_;
				_tmp104_ = move;
				g_debug ("chess-state.vala:910: Move %s missing destination", _tmp104_);
				result = FALSE;
				if (r0) {
					*r0 = _vala_r0;
				}
				if (f0) {
					*f0 = _vala_f0;
				}
				if (r1) {
					*r1 = _vala_r1;
				}
				if (f1) {
					*f1 = _vala_f1;
				}
				if (promotion_type) {
					*promotion_type = _vala_promotion_type;
				}
				return result;
			}
			_tmp106_ = _vala_r0;
			if (_tmp106_ < 0) {
				_tmp105_ = TRUE;
			} else {
				gint _tmp107_;
				_tmp107_ = _vala_f0;
				_tmp105_ = _tmp107_ < 0;
			}
			if (_tmp105_) {
				gint match_rank = 0;
				gint match_file = 0;
				gint _tmp146_;
				gint _tmp148_;
				gint _tmp149_;
				match_rank = -1;
				match_file = -1;
				{
					gint file = 0;
					file = 0;
					{
						gboolean _tmp108_ = FALSE;
						_tmp108_ = TRUE;
						while (TRUE) {
							gint _tmp110_;
							gboolean _tmp111_ = FALSE;
							gint _tmp112_;
							if (!_tmp108_) {
								gint _tmp109_;
								_tmp109_ = file;
								file = _tmp109_ + 1;
							}
							_tmp108_ = FALSE;
							_tmp110_ = file;
							if (!(_tmp110_ < 8)) {
								break;
							}
							_tmp112_ = _vala_f0;
							if (_tmp112_ >= 0) {
								gint _tmp113_;
								gint _tmp114_;
								_tmp113_ = file;
								_tmp114_ = _vala_f0;
								_tmp111_ = _tmp113_ != _tmp114_;
							} else {
								_tmp111_ = FALSE;
							}
							if (_tmp111_) {
								continue;
							}
							{
								gint rank = 0;
								rank = 0;
								{
									gboolean _tmp115_ = FALSE;
									_tmp115_ = TRUE;
									while (TRUE) {
										gint _tmp117_;
										gboolean _tmp118_ = FALSE;
										gint _tmp119_;
										ChessPiece* piece = NULL;
										gint _tmp122_;
										gint _tmp123_;
										gint _tmp124_;
										ChessPiece* _tmp125_;
										ChessPiece* _tmp126_;
										gboolean _tmp127_ = FALSE;
										gboolean _tmp128_ = FALSE;
										ChessPiece* _tmp129_;
										ChessPlayer* _tmp136_;
										gint _tmp137_;
										gint _tmp138_;
										gint _tmp139_;
										gint _tmp140_;
										gboolean _tmp141_;
										gint _tmp142_;
										gint _tmp144_;
										gint _tmp145_;
										if (!_tmp115_) {
											gint _tmp116_;
											_tmp116_ = rank;
											rank = _tmp116_ + 1;
										}
										_tmp115_ = FALSE;
										_tmp117_ = rank;
										if (!(_tmp117_ < 8)) {
											break;
										}
										_tmp119_ = _vala_r0;
										if (_tmp119_ >= 0) {
											gint _tmp120_;
											gint _tmp121_;
											_tmp120_ = rank;
											_tmp121_ = _vala_r0;
											_tmp118_ = _tmp120_ != _tmp121_;
										} else {
											_tmp118_ = FALSE;
										}
										if (_tmp118_) {
											continue;
										}
										_tmp122_ = rank;
										_tmp123_ = file;
										_tmp124_ = chess_state_get_index (self, _tmp122_, _tmp123_);
										_tmp125_ = self->board[_tmp124_];
										_tmp126_ = _g_object_ref0 (_tmp125_);
										piece = _tmp126_;
										_tmp129_ = piece;
										if (_tmp129_ == NULL) {
											_tmp128_ = TRUE;
										} else {
											ChessPiece* _tmp130_;
											PieceType _tmp131_;
											PieceType _tmp132_;
											_tmp130_ = piece;
											_tmp131_ = _tmp130_->type;
											_tmp132_ = type;
											_tmp128_ = _tmp131_ != _tmp132_;
										}
										if (_tmp128_) {
											_tmp127_ = TRUE;
										} else {
											ChessPiece* _tmp133_;
											ChessPlayer* _tmp134_;
											ChessPlayer* _tmp135_;
											_tmp133_ = piece;
											_tmp134_ = _tmp133_->player;
											_tmp135_ = player;
											_tmp127_ = _tmp134_ != _tmp135_;
										}
										if (_tmp127_) {
											_g_object_unref0 (piece);
											continue;
										}
										_tmp136_ = player;
										_tmp137_ = rank;
										_tmp138_ = file;
										_tmp139_ = _vala_r1;
										_tmp140_ = _vala_f1;
										_tmp141_ = chess_state_move_with_coords (self, _tmp136_, _tmp137_, _tmp138_, _tmp139_, _tmp140_, PIECE_TYPE_QUEEN, FALSE, TRUE);
										if (!_tmp141_) {
											_g_object_unref0 (piece);
											continue;
										}
										_tmp142_ = match_rank;
										if (_tmp142_ >= 0) {
											const gchar* _tmp143_;
											_tmp143_ = move;
											g_debug ("chess-state.vala:941: Move %s is ambiguous", _tmp143_);
											result = FALSE;
											_g_object_unref0 (piece);
											if (r0) {
												*r0 = _vala_r0;
											}
											if (f0) {
												*f0 = _vala_f0;
											}
											if (r1) {
												*r1 = _vala_r1;
											}
											if (f1) {
												*f1 = _vala_f1;
											}
											if (promotion_type) {
												*promotion_type = _vala_promotion_type;
											}
											return result;
										}
										_tmp144_ = rank;
										match_rank = _tmp144_;
										_tmp145_ = file;
										match_file = _tmp145_;
										_g_object_unref0 (piece);
									}
								}
							}
						}
					}
				}
				_tmp146_ = match_rank;
				if (_tmp146_ < 0) {
					const gchar* _tmp147_;
					_tmp147_ = move;
					g_debug ("chess-state.vala:952: Move %s has no matches", _tmp147_);
					result = FALSE;
					if (r0) {
						*r0 = _vala_r0;
					}
					if (f0) {
						*f0 = _vala_f0;
					}
					if (r1) {
						*r1 = _vala_r1;
					}
					if (f1) {
						*f1 = _vala_f1;
					}
					if (promotion_type) {
						*promotion_type = _vala_promotion_type;
					}
					return result;
				}
				_tmp148_ = match_rank;
				_vala_r0 = _tmp148_;
				_tmp149_ = match_file;
				_vala_f0 = _tmp149_;
			}
		}
	}
	_tmp150_ = move;
	_tmp151_ = i;
	_tmp152_ = string_get (_tmp150_, (glong) _tmp151_);
	if (_tmp152_ == '+') {
		gint _tmp153_;
		_tmp153_ = i;
		i = _tmp153_ + 1;
	} else {
		const gchar* _tmp154_;
		gint _tmp155_;
		gchar _tmp156_;
		_tmp154_ = move;
		_tmp155_ = i;
		_tmp156_ = string_get (_tmp154_, (glong) _tmp155_);
		if (_tmp156_ == '#') {
			gint _tmp157_;
			_tmp157_ = i;
			i = _tmp157_ + 1;
		}
	}
	_tmp158_ = move;
	_tmp159_ = i;
	_tmp160_ = string_get (_tmp158_, (glong) _tmp159_);
	if (_tmp160_ != '\0') {
		const gchar* _tmp161_;
		_tmp161_ = move;
		g_debug ("chess-state.vala:968: Move %s has unexpected characters", _tmp161_);
		result = FALSE;
		if (r0) {
			*r0 = _vala_r0;
		}
		if (f0) {
			*f0 = _vala_f0;
		}
		if (r1) {
			*r1 = _vala_r1;
		}
		if (f1) {
			*f1 = _vala_f1;
		}
		if (promotion_type) {
			*promotion_type = _vala_promotion_type;
		}
		return result;
	}
	result = TRUE;
	if (r0) {
		*r0 = _vala_r0;
	}
	if (f0) {
		*f0 = _vala_f0;
	}
	if (r1) {
		*r1 = _vala_r1;
	}
	if (f1) {
		*f1 = _vala_f1;
	}
	if (promotion_type) {
		*promotion_type = _vala_promotion_type;
	}
	return result;
}


ChessPlayer* chess_state_get_opponent (ChessState* self) {
	ChessPlayer* result;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_;
	Color _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->current_player;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		ChessPlayer* _tmp3_;
		_tmp3_ = self->players[COLOR_BLACK];
		_tmp0_ = _tmp3_;
	} else {
		ChessPlayer* _tmp4_;
		_tmp4_ = self->players[COLOR_WHITE];
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}


static void chess_state_class_init (ChessStateClass * klass) {
	chess_state_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessStatePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_state_get_property;
	G_OBJECT_CLASS (klass)->finalize = chess_state_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_STATE_OPPONENT, chess_state_properties[CHESS_STATE_OPPONENT] = g_param_spec_object ("opponent", "opponent", "opponent", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void chess_state_instance_init (ChessState * self) {
	self->priv = CHESS_STATE_GET_PRIVATE (self);
	self->number = 0;
	self->en_passant_index = -1;
	self->last_move = NULL;
}


static void chess_state_finalize (GObject * obj) {
	ChessState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_STATE, ChessState);
	_vala_array_destroy (self->players, 2, (GDestroyNotify) g_object_unref);
	_g_object_unref0 (self->current_player);
	_vala_array_destroy (self->board, 64, (GDestroyNotify) g_object_unref);
	_g_object_unref0 (self->last_move);
	G_OBJECT_CLASS (chess_state_parent_class)->finalize (obj);
}


GType chess_state_get_type (void) {
	static volatile gsize chess_state_type_id__volatile = 0;
	if (g_once_init_enter (&chess_state_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessState), 0, (GInstanceInitFunc) chess_state_instance_init, NULL };
		GType chess_state_type_id;
		chess_state_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessState", &g_define_type_info, 0);
		g_once_init_leave (&chess_state_type_id__volatile, chess_state_type_id);
	}
	return chess_state_type_id__volatile;
}


static void _vala_chess_state_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_STATE, ChessState);
	switch (property_id) {
		case CHESS_STATE_OPPONENT:
		g_value_set_object (value, chess_state_get_opponent (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



