/* rygel-searchable-container.c generated by valac 0.34.4, the Vala compiler
 * generated from rygel-searchable-container.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 MediaNet Inh.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define TYPE_MEDIA_OBJECT (media_object_get_type ())
#define MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECT, MediaObject))
#define MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECT, MediaObjectClass))
#define IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECT))
#define IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECT))
#define MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECT, MediaObjectClass))

typedef struct _MediaObject MediaObject;
typedef struct _MediaObjectClass MediaObjectClass;

#define TYPE_MEDIA_CONTAINER (media_container_get_type ())
#define MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_CONTAINER, MediaContainer))
#define MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_CONTAINER, MediaContainerClass))
#define IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_CONTAINER))
#define IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_CONTAINER))
#define MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_CONTAINER, MediaContainerClass))

typedef struct _MediaContainer MediaContainer;
typedef struct _MediaContainerClass MediaContainerClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define TYPE_SEARCH_EXPRESSION (search_expression_get_type ())
#define SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_EXPRESSION, SearchExpression))
#define SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))
#define IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_EXPRESSION))
#define IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_EXPRESSION))
#define SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))

typedef struct _SearchExpression SearchExpression;
typedef struct _SearchExpressionClass SearchExpressionClass;

#define TYPE_MEDIA_OBJECTS (media_objects_get_type ())
#define MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECTS, MediaObjects))
#define MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECTS, MediaObjectsClass))
#define IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECTS))
#define IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECTS))
#define MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECTS, MediaObjectsClass))

typedef struct _MediaObjects MediaObjects;
typedef struct _MediaObjectsClass MediaObjectsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MediaObjectPrivate MediaObjectPrivate;
typedef struct _MediaContainerPrivate MediaContainerPrivate;
typedef struct _RygelSearchableContainerSimpleSearchData RygelSearchableContainerSimpleSearchData;

#define TYPE_RELATIONAL_EXPRESSION (relational_expression_get_type ())
#define RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpression))
#define RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))
#define IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RELATIONAL_EXPRESSION))
#define IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RELATIONAL_EXPRESSION))
#define RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))

typedef struct _RelationalExpression RelationalExpression;
typedef struct _RelationalExpressionClass RelationalExpressionClass;
typedef struct _SearchExpressionPrivate SearchExpressionPrivate;
typedef struct _RygelSearchableContainerFindObjectData RygelSearchableContainerFindObjectData;
typedef struct _RygelSearchableContainerSearchInChildrenData RygelSearchableContainerSearchInChildrenData;

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	MediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _MediaObject {
	GObject parent_instance;
	MediaObjectPrivate * priv;
};

struct _MediaObjectClass {
	GObjectClass parent_class;
};

struct _MediaContainer {
	MediaObject parent_instance;
	MediaContainerPrivate * priv;
	gchar* sort_criteria;
	gint child_count;
	gboolean create_mode_enabled;
};

struct _MediaContainerClass {
	MediaObjectClass parent_class;
};

struct _RygelSearchableContainerSimpleSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	SearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	MediaObjects* result;
	MediaObjects* _result_;
	MediaObjects* _tmp0_;
	gint count;
	gint _tmp1_;
	SearchExpression* _tmp2_;
	gboolean _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	MediaObjects* children;
	gint _tmp6_;
	const gchar* _tmp7_;
	GCancellable* _tmp8_;
	MediaObjects* _tmp9_;
	guint limit;
	guint _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	MediaObjects* _child_list;
	MediaObjects* _tmp13_;
	MediaObjects* _tmp14_;
	gint _child_size;
	MediaObjects* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _child_index;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	MediaObject* child;
	MediaObjects* _tmp21_;
	gint _tmp22_;
	gpointer _tmp23_;
	gboolean _tmp24_;
	SearchExpression* _tmp25_;
	SearchExpression* _tmp26_;
	MediaObject* _tmp27_;
	gboolean _tmp28_;
	MediaObjects* _tmp29_;
	MediaObject* _tmp30_;
	gboolean _tmp31_;
	guint _tmp32_;
	MediaObjects* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	guint _tmp36_;
	gboolean _tmp37_;
	guint _tmp38_;
	MediaObjects* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	guint _tmp42_;
	guint _tmp43_;
	guint _tmp44_;
	guint _tmp45_;
	MediaObjects* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	guint child_limit;
	MediaObjects* child_results;
	SearchExpression* _tmp49_;
	MediaObjects* _tmp50_;
	guint _tmp51_;
	const gchar* _tmp52_;
	GCancellable* _tmp53_;
	MediaObjects* _tmp54_;
	MediaObjects* _tmp55_;
	MediaObjects* _tmp56_;
	guint _tmp57_;
	MediaObjects* _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	guint _tmp61_;
	MediaObjects* _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	MediaObjects* _tmp65_;
	gboolean _tmp66_;
	MediaObjects* _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	gboolean _tmp70_;
	guint _tmp71_;
	guint _tmp72_;
	guint stop;
	gboolean _tmp73_;
	guint _tmp74_;
	guint _tmp75_;
	guint _tmp76_;
	MediaObjects* _tmp77_;
	gint _tmp78_;
	gint _tmp79_;
	guint _tmp80_;
	guint _tmp81_;
	MediaObjects* _tmp82_;
	gint _tmp83_;
	gint _tmp84_;
	MediaObjects* _tmp85_;
	guint _tmp86_;
	guint _tmp87_;
	GeeList* _tmp88_;
	MediaObjects* _tmp89_;
	GError * _inner_error_;
};

struct _SearchExpression {
	GObject parent_instance;
	SearchExpressionPrivate * priv;
	gchar* operand1;
	gchar* operand2;
	gchar* op;
};

struct _SearchExpressionClass {
	GObjectClass parent_class;
};

struct _RygelSearchableContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	gchar* id;
	GCancellable* cancellable;
	MediaObject* result;
	RelationalExpression* expression;
	RelationalExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	guint total_matches;
	MediaObjects* results;
	GCancellable* _tmp5_;
	guint _tmp6_;
	MediaObjects* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	GError * _inner_error_;
};

struct _RygelSearchableContainerSearchInChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	SearchExpression* expression;
	MediaObjects* children;
	guint limit;
	gchar* sort_criteria;
	GCancellable* cancellable;
	MediaObjects* result;
	MediaObjects* _result_;
	MediaObjects* _tmp0_;
	MediaObjects* _child_list;
	MediaObjects* _tmp1_;
	MediaObjects* _tmp2_;
	gint _child_size;
	MediaObjects* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _child_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	MediaObject* child;
	MediaObjects* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	MediaObject* _tmp12_;
	RygelSearchableContainer* container;
	MediaObject* _tmp13_;
	RygelSearchableContainer* _tmp14_;
	guint tmp;
	MediaObjects* child_result;
	RygelSearchableContainer* _tmp15_;
	SearchExpression* _tmp16_;
	guint _tmp17_;
	const gchar* _tmp18_;
	GCancellable* _tmp19_;
	guint _tmp20_;
	MediaObjects* _tmp21_;
	MediaObjects* _tmp22_;
	MediaObjects* _tmp23_;
	gboolean _tmp24_;
	guint _tmp25_;
	MediaObjects* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	guint _tmp29_;
	GError * _inner_error_;
};



GType media_object_get_type (void) G_GNUC_CONST;
GType media_container_get_type (void) G_GNUC_CONST;
GType search_expression_get_type (void) G_GNUC_CONST;
GType media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_searchable_container_simple_search_data_free (gpointer _data);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_);
MediaObjects* media_objects_new (void);
MediaObjects* media_objects_construct (GType object_type);
void media_container_check_search_expression (MediaContainer* self, SearchExpression* expression);
gint media_container_get_all_child_count (MediaContainer* self);
void media_container_get_children (MediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* media_container_get_children_finish (MediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean search_expression_satisfied_by (SearchExpression* self, MediaObject* object);
static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, SearchExpression* expression, MediaObjects* children, guint limit, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static MediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_searchable_container_find_object_data_free (gpointer _data);
void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_);
GType relational_expression_get_type (void) G_GNUC_CONST;
RelationalExpression* relational_expression_new (void);
RelationalExpression* relational_expression_construct (GType object_type);
#define SEARCH_CRITERIA_OP_EQ "="
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_searchable_container_search_in_children_data_free (gpointer _data);
static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_);
static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value);


void rygel_searchable_container_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search (self, expression, offset, max_count, sort_criteria, cancellable, _callback_, _user_data_);
}


MediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search_finish (self, _res_, total_matches, error);
}


static void rygel_searchable_container_simple_search_data_free (gpointer _data) {
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSearchableContainerSimpleSearchData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_searchable_container_simple_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
	RygelSearchableContainer* _tmp0_ = NULL;
	SearchExpression* _tmp1_ = NULL;
	SearchExpression* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	_data_ = g_slice_new0 (RygelSearchableContainerSimpleSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_searchable_container_simple_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_simple_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->expression);
	_data_->expression = _tmp2_;
	_tmp3_ = offset;
	_data_->offset = _tmp3_;
	_tmp4_ = max_count;
	_data_->max_count = _tmp4_;
	_tmp5_ = sort_criteria;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp6_;
	_tmp7_ = cancellable;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp8_;
	rygel_searchable_container_simple_search_co (_data_);
}


MediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	MediaObjects* result;
	RygelSearchableContainerSimpleSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Utility method that retrieves all children and recursively searches for
     * all media objects that satisfy the given search expression in this
     * container.
     *
     * @param expression the search expression or `null` for wildcard
     * @param offset zero-based index of the first object to return
     * @param max_count maximum number of objects to return
     * @param total_matches sets it to the actual number of objects that satisfy
     *                      the given search expression. If it is not possible
     *                      to compute this value (in a timely mannger), it is
     *                      set to '0'.
     * @param cancellable optional cancellable for this operation
     *
     * @return A list of media objects.
     */
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_searchable_container_simple_search_co (_data_);
}


static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = media_objects_new ();
	_data_->_result_ = _data_->_tmp0_;
	_data_->_tmp1_ = 0;
	_data_->_tmp1_ = ((MediaContainer*) _data_->self)->child_count;
	_data_->count = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->expression;
	media_container_check_search_expression ((MediaContainer*) _data_->self, _data_->_tmp2_);
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = ((MediaContainer*) _data_->self)->create_mode_enabled;
	if (_data_->_tmp3_) {
		_data_->_tmp4_ = 0;
		_data_->_tmp4_ = media_container_get_all_child_count ((MediaContainer*) _data_->self);
		_data_->_tmp5_ = 0;
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->count = _data_->_tmp5_;
	}
	_data_->_tmp6_ = 0;
	_data_->_tmp6_ = _data_->count;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->sort_criteria;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->cancellable;
	_data_->_state_ = 1;
	media_container_get_children ((MediaContainer*) _data_->self, (guint) 0, (guint) _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp8_, rygel_searchable_container_simple_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = media_container_get_children_finish ((MediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->children = _data_->_tmp9_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->_result_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = 0U;
	_data_->_tmp10_ = _data_->max_count;
	if (_data_->_tmp10_ > ((guint) 0)) {
		_data_->_tmp11_ = 0U;
		_data_->_tmp11_ = _data_->offset;
		_data_->_tmp12_ = 0U;
		_data_->_tmp12_ = _data_->max_count;
		_data_->limit = _data_->_tmp11_ + _data_->_tmp12_;
	} else {
		_data_->limit = (guint) 0;
	}
	{
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->children;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _g_object_ref0 (_data_->_tmp13_);
		_data_->_child_list = _data_->_tmp14_;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->_child_list;
		_data_->_tmp16_ = 0;
		_data_->_tmp16_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp15_);
		_data_->_tmp17_ = 0;
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_child_size = _data_->_tmp17_;
		_data_->_child_index = -1;
		while (TRUE) {
			_data_->_tmp18_ = 0;
			_data_->_tmp18_ = _data_->_child_index;
			_data_->_child_index = _data_->_tmp18_ + 1;
			_data_->_tmp19_ = 0;
			_data_->_tmp19_ = _data_->_child_index;
			_data_->_tmp20_ = 0;
			_data_->_tmp20_ = _data_->_child_size;
			if (!(_data_->_tmp19_ < _data_->_tmp20_)) {
				break;
			}
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->_child_list;
			_data_->_tmp22_ = 0;
			_data_->_tmp22_ = _data_->_child_index;
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp21_, _data_->_tmp22_);
			_data_->child = (MediaObject*) _data_->_tmp23_;
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->expression;
			if (_data_->_tmp25_ == NULL) {
				_data_->_tmp24_ = TRUE;
			} else {
				_data_->_tmp26_ = NULL;
				_data_->_tmp26_ = _data_->expression;
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = _data_->child;
				_data_->_tmp28_ = FALSE;
				_data_->_tmp28_ = search_expression_satisfied_by (_data_->_tmp26_, _data_->_tmp27_);
				_data_->_tmp24_ = _data_->_tmp28_;
			}
			if (_data_->_tmp24_) {
				_data_->_tmp29_ = NULL;
				_data_->_tmp29_ = _data_->_result_;
				_data_->_tmp30_ = NULL;
				_data_->_tmp30_ = _data_->child;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp29_, _data_->_tmp30_);
			}
			_data_->_tmp32_ = 0U;
			_data_->_tmp32_ = _data_->limit;
			if (_data_->_tmp32_ > ((guint) 0)) {
				_data_->_tmp33_ = NULL;
				_data_->_tmp33_ = _data_->_result_;
				_data_->_tmp34_ = 0;
				_data_->_tmp34_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp33_);
				_data_->_tmp35_ = 0;
				_data_->_tmp35_ = _data_->_tmp34_;
				_data_->_tmp36_ = 0U;
				_data_->_tmp36_ = _data_->limit;
				_data_->_tmp31_ = ((guint) _data_->_tmp35_) >= _data_->_tmp36_;
			} else {
				_data_->_tmp31_ = FALSE;
			}
			if (_data_->_tmp31_) {
				_g_object_unref0 (_data_->child);
				break;
			}
			_g_object_unref0 (_data_->child);
		}
		_g_object_unref0 (_data_->_child_list);
	}
	_data_->_tmp38_ = 0U;
	_data_->_tmp38_ = _data_->limit;
	if (_data_->_tmp38_ == ((guint) 0)) {
		_data_->_tmp37_ = TRUE;
	} else {
		_data_->_tmp39_ = NULL;
		_data_->_tmp39_ = _data_->_result_;
		_data_->_tmp40_ = 0;
		_data_->_tmp40_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp39_);
		_data_->_tmp41_ = 0;
		_data_->_tmp41_ = _data_->_tmp40_;
		_data_->_tmp42_ = 0U;
		_data_->_tmp42_ = _data_->limit;
		_data_->_tmp37_ = ((guint) _data_->_tmp41_) < _data_->_tmp42_;
	}
	if (_data_->_tmp37_) {
		_data_->_tmp44_ = 0U;
		_data_->_tmp44_ = _data_->limit;
		if (_data_->_tmp44_ == ((guint) 0)) {
			_data_->_tmp43_ = (guint) 0;
		} else {
			_data_->_tmp45_ = 0U;
			_data_->_tmp45_ = _data_->limit;
			_data_->_tmp46_ = NULL;
			_data_->_tmp46_ = _data_->_result_;
			_data_->_tmp47_ = 0;
			_data_->_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp46_);
			_data_->_tmp48_ = 0;
			_data_->_tmp48_ = _data_->_tmp47_;
			_data_->_tmp43_ = _data_->_tmp45_ - _data_->_tmp48_;
		}
		_data_->child_limit = _data_->_tmp43_;
		_data_->_tmp49_ = NULL;
		_data_->_tmp49_ = _data_->expression;
		_data_->_tmp50_ = NULL;
		_data_->_tmp50_ = _data_->children;
		_data_->_tmp51_ = 0U;
		_data_->_tmp51_ = _data_->child_limit;
		_data_->_tmp52_ = NULL;
		_data_->_tmp52_ = _data_->sort_criteria;
		_data_->_tmp53_ = NULL;
		_data_->_tmp53_ = _data_->cancellable;
		_data_->_state_ = 2;
		rygel_searchable_container_search_in_children (_data_->self, _data_->_tmp49_, _data_->_tmp50_, _data_->_tmp51_, _data_->_tmp52_, _data_->_tmp53_, rygel_searchable_container_simple_search_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp54_ = NULL;
		_data_->_tmp54_ = rygel_searchable_container_search_in_children_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->child_results = _data_->_tmp54_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->children);
			_g_object_unref0 (_data_->_result_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp55_ = NULL;
		_data_->_tmp55_ = _data_->_result_;
		_data_->_tmp56_ = NULL;
		_data_->_tmp56_ = _data_->child_results;
		gee_array_list_add_all ((GeeArrayList*) _data_->_tmp55_, (GeeCollection*) _data_->_tmp56_);
		_g_object_unref0 (_data_->child_results);
	}
	_data_->_tmp57_ = 0U;
	_data_->_tmp57_ = _data_->max_count;
	if (_data_->_tmp57_ > ((guint) 0)) {
		_data_->total_matches = (guint) 0;
	} else {
		_data_->_tmp58_ = NULL;
		_data_->_tmp58_ = _data_->_result_;
		_data_->_tmp59_ = 0;
		_data_->_tmp59_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp58_);
		_data_->_tmp60_ = 0;
		_data_->_tmp60_ = _data_->_tmp59_;
		_data_->total_matches = (guint) _data_->_tmp60_;
	}
	_data_->_tmp61_ = 0U;
	_data_->_tmp61_ = _data_->offset;
	_data_->_tmp62_ = NULL;
	_data_->_tmp62_ = _data_->_result_;
	_data_->_tmp63_ = 0;
	_data_->_tmp63_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp62_);
	_data_->_tmp64_ = 0;
	_data_->_tmp64_ = _data_->_tmp63_;
	if (_data_->_tmp61_ >= ((guint) _data_->_tmp64_)) {
		_data_->_tmp65_ = NULL;
		_data_->_tmp65_ = media_objects_new ();
		_data_->result = _data_->_tmp65_;
		_g_object_unref0 (_data_->children);
		_g_object_unref0 (_data_->_result_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp67_ = NULL;
	_data_->_tmp67_ = _data_->_result_;
	_data_->_tmp68_ = 0;
	_data_->_tmp68_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp67_);
	_data_->_tmp69_ = 0;
	_data_->_tmp69_ = _data_->_tmp68_;
	if (_data_->_tmp69_ > 0) {
		_data_->_tmp71_ = 0U;
		_data_->_tmp71_ = _data_->max_count;
		if (_data_->_tmp71_ > ((guint) 0)) {
			_data_->_tmp70_ = TRUE;
		} else {
			_data_->_tmp72_ = 0U;
			_data_->_tmp72_ = _data_->offset;
			_data_->_tmp70_ = _data_->_tmp72_ > ((guint) 0);
		}
		_data_->_tmp66_ = _data_->_tmp70_;
	} else {
		_data_->_tmp66_ = FALSE;
	}
	if (_data_->_tmp66_) {
		_data_->_tmp74_ = 0U;
		_data_->_tmp74_ = _data_->max_count;
		if (_data_->_tmp74_ != ((guint) 0)) {
			_data_->_tmp75_ = 0U;
			_data_->_tmp75_ = _data_->offset;
			_data_->_tmp76_ = 0U;
			_data_->_tmp76_ = _data_->max_count;
			_data_->_tmp77_ = NULL;
			_data_->_tmp77_ = _data_->_result_;
			_data_->_tmp78_ = 0;
			_data_->_tmp78_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp77_);
			_data_->_tmp79_ = 0;
			_data_->_tmp79_ = _data_->_tmp78_;
			_data_->_tmp73_ = (_data_->_tmp75_ + _data_->_tmp76_) <= ((guint) _data_->_tmp79_);
		} else {
			_data_->_tmp73_ = FALSE;
		}
		if (_data_->_tmp73_) {
			_data_->_tmp80_ = 0U;
			_data_->_tmp80_ = _data_->offset;
			_data_->_tmp81_ = 0U;
			_data_->_tmp81_ = _data_->max_count;
			_data_->stop = _data_->_tmp80_ + _data_->_tmp81_;
		} else {
			_data_->_tmp82_ = NULL;
			_data_->_tmp82_ = _data_->_result_;
			_data_->_tmp83_ = 0;
			_data_->_tmp83_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp82_);
			_data_->_tmp84_ = 0;
			_data_->_tmp84_ = _data_->_tmp83_;
			_data_->stop = (guint) _data_->_tmp84_;
		}
		_data_->_tmp85_ = NULL;
		_data_->_tmp85_ = _data_->_result_;
		_data_->_tmp86_ = 0U;
		_data_->_tmp86_ = _data_->offset;
		_data_->_tmp87_ = 0U;
		_data_->_tmp87_ = _data_->stop;
		_data_->_tmp88_ = NULL;
		_data_->_tmp88_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp85_, (gint) _data_->_tmp86_, (gint) _data_->_tmp87_);
		_data_->_tmp89_ = NULL;
		_data_->_tmp89_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp88_, TYPE_MEDIA_OBJECTS) ? ((MediaObjects*) _data_->_tmp88_) : NULL;
		if (_data_->_tmp89_ == NULL) {
			_g_object_unref0 (_data_->_tmp88_);
		}
		_data_->result = _data_->_tmp89_;
		_g_object_unref0 (_data_->children);
		_g_object_unref0 (_data_->_result_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_result_;
	_g_object_unref0 (_data_->children);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->children);
	_g_object_unref0 (_data_->_result_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_searchable_container_find_object_data_free (gpointer _data) {
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSearchableContainerFindObjectData, _data_);
}


void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
	RygelSearchableContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	_data_ = g_slice_new0 (RygelSearchableContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_searchable_container_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_searchable_container_find_object_co (_data_);
}


MediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	MediaObject* result;
	RygelSearchableContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Recursively searches for media object with the given id in this
     * container.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     * @param callback function to call when result is ready
     *
     * @return the found media object.
     */
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_searchable_container_find_object_co (_data_);
}


static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = relational_expression_new ();
	_data_->expression = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_strdup (SEARCH_CRITERIA_OP_EQ);
	_g_free0 (((SearchExpression*) _data_->expression)->op);
	((SearchExpression*) _data_->expression)->op = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_strdup ("@id");
	_g_free0 (((SearchExpression*) _data_->expression)->operand1);
	((SearchExpression*) _data_->expression)->operand1 = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->id;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
	_g_free0 (((SearchExpression*) _data_->expression)->operand2);
	((SearchExpression*) _data_->expression)->operand2 = _data_->_tmp4_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->cancellable;
	_data_->_tmp6_ = 0U;
	_data_->_state_ = 1;
	rygel_searchable_container_search (_data_->self, (SearchExpression*) _data_->expression, (guint) 0, (guint) 1, "", _data_->_tmp5_, rygel_searchable_container_find_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = rygel_searchable_container_search_finish (_data_->self, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
	_data_->total_matches = _data_->_tmp6_;
	_data_->results = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->expression);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = 0;
	_data_->_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->results);
	_data_->_tmp9_ = 0;
	_data_->_tmp9_ = _data_->_tmp8_;
	if (_data_->_tmp9_ > 0) {
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _data_->results, 0);
		_data_->result = (MediaObject*) _data_->_tmp10_;
		_g_object_unref0 (_data_->results);
		_g_object_unref0 (_data_->expression);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->result = NULL;
		_g_object_unref0 (_data_->results);
		_g_object_unref0 (_data_->expression);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->results);
	_g_object_unref0 (_data_->expression);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_searchable_container_search_in_children_data_free (gpointer _data) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->expression);
	_g_object_unref0 (_data_->children);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSearchableContainerSearchInChildrenData, _data_);
}


static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, SearchExpression* expression, MediaObjects* children, guint limit, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	RygelSearchableContainer* _tmp0_ = NULL;
	SearchExpression* _tmp1_ = NULL;
	SearchExpression* _tmp2_ = NULL;
	MediaObjects* _tmp3_ = NULL;
	MediaObjects* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	GCancellable* _tmp9_ = NULL;
	_data_ = g_slice_new0 (RygelSearchableContainerSearchInChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_searchable_container_search_in_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_search_in_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->expression);
	_data_->expression = _tmp2_;
	_tmp3_ = children;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->children);
	_data_->children = _tmp4_;
	_tmp5_ = limit;
	_data_->limit = _tmp5_;
	_tmp6_ = sort_criteria;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp7_;
	_tmp8_ = cancellable;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp9_;
	rygel_searchable_container_search_in_children_co (_data_);
}


static MediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	MediaObjects* result;
	RygelSearchableContainerSearchInChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_searchable_container_search_in_children_co (_data_);
}


static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = media_objects_new ();
	_data_->_result_ = _data_->_tmp0_;
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->children;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
		_data_->_child_list = _data_->_tmp2_;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_child_list;
		_data_->_tmp4_ = 0;
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
		_data_->_tmp5_ = 0;
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_child_size = _data_->_tmp5_;
		_data_->_child_index = -1;
		while (TRUE) {
			_data_->_tmp6_ = 0;
			_data_->_tmp6_ = _data_->_child_index;
			_data_->_child_index = _data_->_tmp6_ + 1;
			_data_->_tmp7_ = 0;
			_data_->_tmp7_ = _data_->_child_index;
			_data_->_tmp8_ = 0;
			_data_->_tmp8_ = _data_->_child_size;
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
				break;
			}
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->_child_list;
			_data_->_tmp10_ = 0;
			_data_->_tmp10_ = _data_->_child_index;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
			_data_->child = (MediaObject*) _data_->_tmp11_;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->child;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp12_, RYGEL_TYPE_SEARCHABLE_CONTAINER)) {
				_data_->_tmp13_ = NULL;
				_data_->_tmp13_ = _data_->child;
				_data_->_tmp14_ = NULL;
				_data_->_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp13_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->_tmp13_) : NULL);
				_data_->container = _data_->_tmp14_;
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = _data_->container;
				_data_->_tmp16_ = NULL;
				_data_->_tmp16_ = _data_->expression;
				_data_->_tmp17_ = 0U;
				_data_->_tmp17_ = _data_->limit;
				_data_->_tmp18_ = NULL;
				_data_->_tmp18_ = _data_->sort_criteria;
				_data_->_tmp19_ = NULL;
				_data_->_tmp19_ = _data_->cancellable;
				_data_->_tmp20_ = 0U;
				_data_->_state_ = 1;
				rygel_searchable_container_search (_data_->_tmp15_, _data_->_tmp16_, (guint) 0, _data_->_tmp17_, _data_->_tmp18_, _data_->_tmp19_, rygel_searchable_container_search_in_children_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp21_ = NULL;
				_data_->_tmp21_ = rygel_searchable_container_search_finish (_data_->_tmp15_, _data_->_res_, &_data_->_tmp20_, &_data_->_inner_error_);
				_data_->tmp = _data_->_tmp20_;
				_data_->child_result = _data_->_tmp21_;
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					_g_object_unref0 (_data_->container);
					_g_object_unref0 (_data_->child);
					_g_object_unref0 (_data_->_child_list);
					_g_object_unref0 (_data_->_result_);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp22_ = NULL;
				_data_->_tmp22_ = _data_->_result_;
				_data_->_tmp23_ = NULL;
				_data_->_tmp23_ = _data_->child_result;
				gee_array_list_add_all ((GeeArrayList*) _data_->_tmp22_, (GeeCollection*) _data_->_tmp23_);
				_g_object_unref0 (_data_->child_result);
				_g_object_unref0 (_data_->container);
			}
			_data_->_tmp25_ = 0U;
			_data_->_tmp25_ = _data_->limit;
			if (_data_->_tmp25_ > ((guint) 0)) {
				_data_->_tmp26_ = NULL;
				_data_->_tmp26_ = _data_->_result_;
				_data_->_tmp27_ = 0;
				_data_->_tmp27_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp26_);
				_data_->_tmp28_ = 0;
				_data_->_tmp28_ = _data_->_tmp27_;
				_data_->_tmp29_ = 0U;
				_data_->_tmp29_ = _data_->limit;
				_data_->_tmp24_ = ((guint) _data_->_tmp28_) >= _data_->_tmp29_;
			} else {
				_data_->_tmp24_ = FALSE;
			}
			if (_data_->_tmp24_) {
				_g_object_unref0 (_data_->child);
				break;
			}
			_g_object_unref0 (_data_->child);
		}
		_g_object_unref0 (_data_->_child_list);
	}
	_data_->result = _data_->_result_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->_result_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container) {
	g_return_if_fail (didl_container != NULL);
	{
		GeeArrayList* _search_class_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		gint _search_class_size = 0;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _search_class_index = 0;
		_tmp0_ = rygel_searchable_container_get_search_classes (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_search_class_list = _tmp2_;
		_tmp3_ = _search_class_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_search_class_size = _tmp5_;
		_search_class_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gchar* search_class = NULL;
			GeeArrayList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			GUPnPDIDLLiteContainer* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			_tmp6_ = _search_class_index;
			_search_class_index = _tmp6_ + 1;
			_tmp7_ = _search_class_index;
			_tmp8_ = _search_class_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _search_class_list;
			_tmp10_ = _search_class_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			search_class = (gchar*) _tmp11_;
			_tmp12_ = didl_container;
			_tmp13_ = search_class;
			gupnp_didl_lite_container_add_search_class (_tmp12_, _tmp13_);
			_g_free0 (search_class);
		}
		_g_object_unref0 (_search_class_list);
	}
}


GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->get_search_classes (self);
}


void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value) {
	g_return_if_fail (self != NULL);
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->set_search_classes (self, value);
}


static void rygel_searchable_container_base_init (RygelSearchableContainerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * The base class for searchable containers.
 *
 * Classes that implement this interface can, for instance:
 *
 *  # Allow backends to implement a UPnP Search call using native searching (such as SQL or SPARQL queries).
 *  # Implement searching via the naïve default implementation provided by rygel_searchable_container_simple_search(), which does a recursive tree walk.
 *
 * The search_classes property lists what information this container may be searched
 * for. It is mapped to upnp:searchClass (with includeDerived assumed to be false),
 */
GType rygel_searchable_container_get_type (void) {
	static volatile gsize rygel_searchable_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_searchable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchableContainerIface), (GBaseInitFunc) rygel_searchable_container_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_searchable_container_type_id;
		rygel_searchable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelSearchableContainer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_searchable_container_type_id, TYPE_MEDIA_CONTAINER);
		g_once_init_leave (&rygel_searchable_container_type_id__volatile, rygel_searchable_container_type_id);
	}
	return rygel_searchable_container_type_id__volatile;
}



