/* test-chess-pgn.c generated by valac 0.37.1.6-1eaec, the Vala compiler
 * generated from test-chess-pgn.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libchess.h"
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_GNOME_CHESS (gnome_chess_get_type ())
#define GNOME_CHESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GNOME_CHESS, GNOMEChess))
#define GNOME_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GNOME_CHESS, GNOMEChessClass))
#define IS_GNOME_CHESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GNOME_CHESS))
#define IS_GNOME_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GNOME_CHESS))
#define GNOME_CHESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GNOME_CHESS, GNOMEChessClass))

typedef struct _GNOMEChess GNOMEChess;
typedef struct _GNOMEChessClass GNOMEChessClass;
typedef struct _GNOMEChessPrivate GNOMEChessPrivate;
enum  {
	GNOME_CHESS_DUMMY_PROPERTY,
	GNOME_CHESS_LAST_PROPERTY
};
static GParamSpec* gnome_chess_properties[GNOME_CHESS_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecGNOMEChess ParamSpecGNOMEChess;

struct _GNOMEChess {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GNOMEChessPrivate * priv;
};

struct _GNOMEChessClass {
	GTypeClass parent_class;
	void (*finalize) (GNOMEChess *self);
};

struct _ParamSpecGNOMEChess {
	GParamSpec parent_instance;
};


static gpointer gnome_chess_parent_class = NULL;
static gint gnome_chess_test_count;
static gint gnome_chess_test_count = 0;
static gint gnome_chess_failure_count;
static gint gnome_chess_failure_count = 0;

gpointer gnome_chess_ref (gpointer instance);
void gnome_chess_unref (gpointer instance);
GParamSpec* param_spec_gnome_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_gnome_chess (GValue* value, gpointer v_object);
void value_take_gnome_chess (GValue* value, gpointer v_object);
gpointer value_get_gnome_chess (const GValue* value);
GType gnome_chess_get_type (void) G_GNUC_CONST;
static void gnome_chess_test_pgn_file (const gchar* data, const gchar* moves);
gint gnome_chess_main (gchar** args, int args_length1);
GNOMEChess* gnome_chess_new (void);
GNOMEChess* gnome_chess_construct (GType object_type);
static void gnome_chess_finalize (GNOMEChess * obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void gnome_chess_test_pgn_file (const gchar* data, const gchar* moves) {
	gint _tmp0_;
	PGN* file = NULL;
	PGNGame* game = NULL;
	PGN* _tmp10_;
	GList* _tmp11_;
	gconstpointer _tmp12_;
	PGNGame* _tmp13_;
	gchar* move_string = NULL;
	gchar* _tmp14_;
	PGNGame* _tmp15_;
	GList* _tmp16_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (data != NULL);
	g_return_if_fail (moves != NULL);
	_tmp0_ = gnome_chess_test_count;
	gnome_chess_test_count = _tmp0_ + 1;
	{
		PGN* _tmp1_ = NULL;
		const gchar* _tmp2_;
		PGN* _tmp3_;
		PGN* _tmp4_;
		_tmp2_ = data;
		_tmp3_ = pgn_new_from_string (_tmp2_, &_inner_error_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == PGN_ERROR) {
				goto __catch0_pgn_error;
			}
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (file);
		file = _tmp4_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_pgn_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		gint _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = gnome_chess_test_count;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp5_, "%d. FAIL %s\n", _tmp6_, _tmp8_);
		_tmp9_ = gnome_chess_failure_count;
		gnome_chess_failure_count = _tmp9_ + 1;
		_g_error_free0 (e);
		_g_object_unref0 (file);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp10_ = file;
	_tmp11_ = _tmp10_->games;
	_tmp12_ = g_list_nth_data (_tmp11_, (guint) 0);
	_tmp13_ = _g_object_ref0 ((PGNGame*) _tmp12_);
	game = _tmp13_;
	_tmp14_ = g_strdup ("");
	move_string = _tmp14_;
	_tmp15_ = game;
	_tmp16_ = _tmp15_->moves;
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
		move_collection = _tmp16_;
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
			gchar* _tmp17_;
			gchar* move = NULL;
			_tmp17_ = g_strdup ((const gchar*) move_it->data);
			move = _tmp17_;
			{
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp18_ = move_string;
				_tmp19_ = move;
				_tmp20_ = g_strdup_printf ("%s ", _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strconcat (_tmp18_, _tmp21_, NULL);
				_g_free0 (move_string);
				move_string = _tmp22_;
				_g_free0 (_tmp21_);
				_g_free0 (move);
			}
		}
	}
	_tmp23_ = move_string;
	_tmp24_ = string_strip (_tmp23_);
	_g_free0 (move_string);
	move_string = _tmp24_;
	_tmp25_ = move_string;
	_tmp26_ = moves;
	if (g_strcmp0 (_tmp25_, _tmp26_) == 0) {
		FILE* _tmp27_;
		gint _tmp28_;
		_tmp27_ = stderr;
		_tmp28_ = gnome_chess_test_count;
		fprintf (_tmp27_, "%d. PASS\n", _tmp28_);
	} else {
		gint _tmp29_;
		FILE* _tmp30_;
		gint _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp29_ = gnome_chess_failure_count;
		gnome_chess_failure_count = _tmp29_ + 1;
		_tmp30_ = stderr;
		_tmp31_ = gnome_chess_test_count;
		_tmp32_ = move_string;
		_tmp33_ = moves;
		fprintf (_tmp30_, "%d. FAIL got moves '%s', expected '%s'\n", _tmp31_, _tmp32_, _tmp33_);
	}
	_g_free0 (move_string);
	_g_object_unref0 (game);
	_g_object_unref0 (file);
}


gint gnome_chess_main (gchar** args, int args_length1) {
	gint result = 0;
	FILE* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gnome_chess_test_pgn_file ("[Event \"?\"]\n" "[Site \"?\"]\n" "[Date \"????.??.??\"]\n" "[Round \"?\"]\n" "[White \"\"]\n" "[Black \"\"]\n" "[Result \"*\"]\n" "\n" "1. *\n", "");
	gnome_chess_test_pgn_file ("1. e1 *\n", "e1");
	gnome_chess_test_pgn_file ("e1 *\n", "e1");
	gnome_chess_test_pgn_file ("e1\n", "e1");
	gnome_chess_test_pgn_file ("e1", "e1");
	gnome_chess_test_pgn_file ("[Event \"?\"]\r" "\r" "1. d4 *\r", "d4");
	gnome_chess_test_pgn_file ("; Line comment 1\n" "[Event \"?\"]\n" "; Line comment 2\n" "\n" "1. e4 {First Move} e5 {Multi\n" "line\n" "comment} 2. Nc3 {More comments} * {Comment about game end}\n", "e4 e5 Nc3");
	gnome_chess_test_pgn_file (";Title: Yahoo! Chess Game\n" ";White: roovis\n" ";Black: ladyjones96\n" ";Date: Fri Oct 19 12:51:54 GMT 2007\n" "\n" "1. e2-e4 e7-e5\n", "e2-e4 e7-e5");
	gnome_chess_test_pgn_file ("1.Ra8+ (1.Bxd6+ Kb7 2.Rc7+ Kb8 (2...Kb6 3.Ra6#) 3.Rd7+ Kc8 4.Rc1# (4.R" \
"a8#))", "Ra8+");
	gnome_chess_test_pgn_file ("e4 e5 $1 Nc3 $2", "e4 e5 Nc3");
	_tmp0_ = stdout;
	_tmp1_ = gnome_chess_test_count;
	_tmp2_ = gnome_chess_failure_count;
	_tmp3_ = gnome_chess_test_count;
	fprintf (_tmp0_, "%d/%d tests successful\n", _tmp1_ - _tmp2_, _tmp3_);
	_tmp4_ = gnome_chess_failure_count;
	result = _tmp4_;
	return result;
}


int main (int argc, char ** argv) {
	return gnome_chess_main (argv, argc);
}


GNOMEChess* gnome_chess_construct (GType object_type) {
	GNOMEChess* self = NULL;
	self = (GNOMEChess*) g_type_create_instance (object_type);
	return self;
}


GNOMEChess* gnome_chess_new (void) {
	return gnome_chess_construct (TYPE_GNOME_CHESS);
}


static void value_gnome_chess_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_gnome_chess_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gnome_chess_unref (value->data[0].v_pointer);
	}
}


static void value_gnome_chess_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gnome_chess_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_gnome_chess_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_gnome_chess_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GNOMEChess * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gnome_chess_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_gnome_chess_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GNOMEChess ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gnome_chess_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_gnome_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecGNOMEChess* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_GNOME_CHESS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_gnome_chess (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GNOME_CHESS), NULL);
	return value->data[0].v_pointer;
}


void value_set_gnome_chess (GValue* value, gpointer v_object) {
	GNOMEChess * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GNOME_CHESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GNOME_CHESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gnome_chess_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gnome_chess_unref (old);
	}
}


void value_take_gnome_chess (GValue* value, gpointer v_object) {
	GNOMEChess * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GNOME_CHESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GNOME_CHESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gnome_chess_unref (old);
	}
}


static void gnome_chess_class_init (GNOMEChessClass * klass) {
	gnome_chess_parent_class = g_type_class_peek_parent (klass);
	((GNOMEChessClass *) klass)->finalize = gnome_chess_finalize;
}


static void gnome_chess_instance_init (GNOMEChess * self) {
	self->ref_count = 1;
}


static void gnome_chess_finalize (GNOMEChess * obj) {
	GNOMEChess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GNOME_CHESS, GNOMEChess);
	g_signal_handlers_destroy (self);
}


GType gnome_chess_get_type (void) {
	static volatile gsize gnome_chess_type_id__volatile = 0;
	if (g_once_init_enter (&gnome_chess_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_gnome_chess_init, value_gnome_chess_free_value, value_gnome_chess_copy_value, value_gnome_chess_peek_pointer, "p", value_gnome_chess_collect_value, "p", value_gnome_chess_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GNOMEChessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_chess_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GNOMEChess), 0, (GInstanceInitFunc) gnome_chess_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gnome_chess_type_id;
		gnome_chess_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GNOMEChess", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gnome_chess_type_id__volatile, gnome_chess_type_id);
	}
	return gnome_chess_type_id__volatile;
}


gpointer gnome_chess_ref (gpointer instance) {
	GNOMEChess * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gnome_chess_unref (gpointer instance) {
	GNOMEChess * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GNOME_CHESS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



