/* rygel-media-export-extractor.c generated by valac 0.34.4, the Vala compiler
 * generated from rygel-media-export-extractor.vala, do not modify */

/*
 * Copyright (C) 2016 Jens Georg <mail@jensge.org>
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>


#define RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR (rygel_media_export_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))

typedef struct _RygelMediaExportExtractor RygelMediaExportExtractor;
typedef struct _RygelMediaExportExtractorClass RygelMediaExportExtractorClass;
typedef struct _RygelMediaExportExtractorPrivate RygelMediaExportExtractorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER (rygel_media_export_dvd_parser_get_type ())
#define RYGEL_MEDIA_EXPORT_DVD_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, RygelMediaExportDVDParser))
#define RYGEL_MEDIA_EXPORT_DVD_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, RygelMediaExportDVDParserClass))
#define RYGEL_MEDIA_EXPORT_IS_DVD_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER))
#define RYGEL_MEDIA_EXPORT_IS_DVD_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER))
#define RYGEL_MEDIA_EXPORT_DVD_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, RygelMediaExportDVDParserClass))

typedef struct _RygelMediaExportDVDParser RygelMediaExportDVDParser;
typedef struct _RygelMediaExportDVDParserClass RygelMediaExportDVDParserClass;

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_EXTRACTOR (rygel_media_export_playlist_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_EXTRACTOR, RygelMediaExportPlaylistExtractor))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_EXTRACTOR, RygelMediaExportPlaylistExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_EXTRACTOR, RygelMediaExportPlaylistExtractorClass))

typedef struct _RygelMediaExportPlaylistExtractor RygelMediaExportPlaylistExtractor;
typedef struct _RygelMediaExportPlaylistExtractorClass RygelMediaExportPlaylistExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_IMAGE_EXTRACTOR (rygel_media_export_image_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_IMAGE_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_IMAGE_EXTRACTOR, RygelMediaExportImageExtractor))
#define RYGEL_MEDIA_EXPORT_IMAGE_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_IMAGE_EXTRACTOR, RygelMediaExportImageExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_IMAGE_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_IMAGE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_IMAGE_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_IMAGE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IMAGE_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_IMAGE_EXTRACTOR, RygelMediaExportImageExtractorClass))

typedef struct _RygelMediaExportImageExtractor RygelMediaExportImageExtractor;
typedef struct _RygelMediaExportImageExtractorClass RygelMediaExportImageExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR (rygel_media_export_generic_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractor))
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_GENERIC_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_GENERIC_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractorClass))

typedef struct _RygelMediaExportGenericExtractor RygelMediaExportGenericExtractor;
typedef struct _RygelMediaExportGenericExtractorClass RygelMediaExportGenericExtractorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelMediaExportExtractorRunData RygelMediaExportExtractorRunData;
#define __vala_SoupDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupDate_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	EXTRACTOR_ERROR_GENERAL,
	EXTRACTOR_ERROR_INVALID
} ExtractorError;
#define EXTRACTOR_ERROR extractor_error_quark ()
struct _RygelMediaExportExtractor {
	GObject parent_instance;
	RygelMediaExportExtractorPrivate * priv;
	GVariantDict* serialized_info;
};

struct _RygelMediaExportExtractorClass {
	GObjectClass parent_class;
	void (*run) (RygelMediaExportExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelMediaExportExtractor* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportExtractorPrivate {
	GFile* _file;
};

struct _RygelMediaExportExtractorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportExtractor* self;
	GFileInfo* file_info;
	GFile* _tmp0_;
	GFileInfo* _tmp1_;
	gchar* display_name;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* title;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GVariantDict* _tmp6_;
	const gchar* _tmp7_;
	guint64 mtime;
	guint64 _tmp8_;
	GVariantDict* _tmp9_;
	guint64 _tmp10_;
	GTimeVal tv;
	guint64 _tmp11_;
	GTimeVal _tmp12_;
	GVariantDict* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* content_type;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	GVariantDict* _tmp18_;
	const gchar* _tmp19_;
	GVariantDict* _tmp20_;
	gint64 _tmp21_;
	gchar* id;
	GFile* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GVariantDict* _tmp27_;
	const gchar* _tmp28_;
	GVariantDict* _tmp29_;
	GFile* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GError * _inner_error_;
};


static gpointer rygel_media_export_extractor_parent_class = NULL;
static GRegex* rygel_media_export_extractor_char_remove_regex;
static GRegex* rygel_media_export_extractor_char_remove_regex = NULL;
static GRegex* rygel_media_export_extractor_char_convert_regex;
static GRegex* rygel_media_export_extractor_char_convert_regex = NULL;
static GRegex* rygel_media_export_extractor_space_compress_regex;
static GRegex* rygel_media_export_extractor_space_compress_regex = NULL;
static GRegex** rygel_media_export_extractor_block_regexes;
static gint rygel_media_export_extractor_block_regexes_length1;
static GRegex** rygel_media_export_extractor_block_regexes = NULL;
static gint rygel_media_export_extractor_block_regexes_length1 = 0;
static gint _rygel_media_export_extractor_block_regexes_size_ = 0;
static GRegex** rygel_media_export_extractor_blacklist_regexes;
static gint rygel_media_export_extractor_blacklist_regexes_length1;
static GRegex** rygel_media_export_extractor_blacklist_regexes = NULL;
static gint rygel_media_export_extractor_blacklist_regexes_length1 = 0;
static gint _rygel_media_export_extractor_blacklist_regexes_size_ = 0;
static GRegex** rygel_media_export_extractor_video_suffix_regexes;
static gint rygel_media_export_extractor_video_suffix_regexes_length1;
static GRegex** rygel_media_export_extractor_video_suffix_regexes = NULL;
static gint rygel_media_export_extractor_video_suffix_regexes_length1 = 0;
static gint _rygel_media_export_extractor_video_suffix_regexes_size_ = 0;

GQuark extractor_error_quark (void);
GType rygel_media_export_extractor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_EXTRACTOR_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_EXTRACTOR_FILE
};
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_INVALID_CHARS "()[]<>{}!@#$^&*+=|\\/\"'?~"
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_CONVERT_CHARS "\t_\\."
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_BLOCK_PATTERN "%s[^%s]*%s"
RygelMediaExportExtractor* rygel_media_export_extractor_create_for_file (GFile* file, const gchar* content_type, gboolean extract_metadata);
static RygelMediaExportExtractor* rygel_media_export_extractor_new (GFile* file);
static RygelMediaExportExtractor* rygel_media_export_extractor_construct (GType object_type, GFile* file);
RygelMediaExportDVDParser* rygel_media_export_dvd_parser_new (GFile* file);
RygelMediaExportDVDParser* rygel_media_export_dvd_parser_construct (GType object_type, GFile* file);
GType rygel_media_export_dvd_parser_get_type (void) G_GNUC_CONST;
RygelMediaExportPlaylistExtractor* rygel_media_export_playlist_extractor_new (GFile* file);
RygelMediaExportPlaylistExtractor* rygel_media_export_playlist_extractor_construct (GType object_type, GFile* file);
GType rygel_media_export_playlist_extractor_get_type (void) G_GNUC_CONST;
RygelMediaExportImageExtractor* rygel_media_export_image_extractor_new (GFile* file);
RygelMediaExportImageExtractor* rygel_media_export_image_extractor_construct (GType object_type, GFile* file);
GType rygel_media_export_image_extractor_get_type (void) G_GNUC_CONST;
RygelMediaExportGenericExtractor* rygel_media_export_generic_extractor_new (GFile* file);
RygelMediaExportGenericExtractor* rygel_media_export_generic_extractor_construct (GType object_type, GFile* file);
GType rygel_media_export_generic_extractor_get_type (void) G_GNUC_CONST;
static void rygel_media_export_extractor_real_constructed (GObject* base);
static void rygel_media_export_extractor_real_run_data_free (gpointer _data);
static void rygel_media_export_extractor_real_run (RygelMediaExportExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_extractor_run (RygelMediaExportExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_extractor_run_finish (RygelMediaExportExtractor* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_export_extractor_real_run_co (RygelMediaExportExtractorRunData* _data_);
GFile* rygel_media_export_extractor_get_file (RygelMediaExportExtractor* self);
static void rygel_media_export_extractor_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* rygel_media_export_extractor_strip_invalid_entities (RygelMediaExportExtractor* self, const gchar* original);
#define RYGEL_MEDIA_EXPORT_SERIALIZER_TITLE "Title"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_MODIFIED "MTime"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DATE "Date"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE "MimeType"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_SIZE "Size"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_ID "Id"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_URI "Uri"
GVariant* rygel_media_export_extractor_get (RygelMediaExportExtractor* self);
static void _vala_SoupDate_free (SoupDate* self);
static void _vala_array_add1 (GRegex*** array, int* length, int* size, GRegex* value);
static void _vala_array_add2 (GRegex*** array, int* length, int* size, GRegex* value);
static void _vala_array_add3 (GRegex*** array, int* length, int* size, GRegex* value);
void rygel_media_export_extractor_set_file (RygelMediaExportExtractor* self, GFile* value);
static void rygel_media_export_extractor_finalize (GObject* obj);
static void _vala_rygel_media_export_extractor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_export_extractor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* RYGEL_MEDIA_EXPORT_EXTRACTOR_BLOCKS[4] = {"()", "{}", "[]", "<>"};
static const gchar* RYGEL_MEDIA_EXPORT_EXTRACTOR_BLACKLIST[14] = {"720p", "1080p", "x264", "ws", "proper", "real.repack", "repack", "hdtv", "pdtv", "notv", "dsr", "DVDRip", "divx", "xvid"};
static const gchar* RYGEL_MEDIA_EXPORT_EXTRACTOR_VIDEO_SUFFIXES[21] = {"webm", "mkv", "flv", "ogv", "ogg", "avi", "mov", "wmv", "mp4", "m4v", "mpeg", "mpg", "iso", "mp3", "m4a", "png", "jpg", "jpeg", "ogv", "oga", "3gp"};

GQuark extractor_error_quark (void) {
	return g_quark_from_static_string ("extractor_error-quark");
}


/**
     * Factory method for creating specific extractors depending on the
     * content type of the file
     */
RygelMediaExportExtractor* rygel_media_export_extractor_create_for_file (GFile* file, const gchar* content_type, gboolean extract_metadata) {
	RygelMediaExportExtractor* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean is_text = FALSE;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_ = NULL;
	GFile* _tmp19_ = NULL;
	RygelMediaExportGenericExtractor* _tmp20_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (content_type != NULL, NULL);
	_tmp0_ = extract_metadata;
	if (!_tmp0_) {
		GFile* _tmp1_ = NULL;
		RygelMediaExportExtractor* _tmp2_ = NULL;
		_tmp1_ = file;
		_tmp2_ = rygel_media_export_extractor_new (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp4_ = content_type;
	_tmp5_ = g_str_has_prefix (_tmp4_, "text/");
	if (_tmp5_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = content_type;
		_tmp7_ = g_str_has_suffix (_tmp6_, "xml");
		_tmp3_ = _tmp7_;
	}
	is_text = _tmp3_;
	_tmp8_ = content_type;
	if (g_strcmp0 (_tmp8_, "application/x-cd-image") == 0) {
		GFile* _tmp9_ = NULL;
		RygelMediaExportDVDParser* _tmp10_ = NULL;
		_tmp9_ = file;
		_tmp10_ = rygel_media_export_dvd_parser_new (_tmp9_);
		result = (RygelMediaExportExtractor*) _tmp10_;
		return result;
	}
	_tmp11_ = is_text;
	if (_tmp11_) {
		GFile* _tmp12_ = NULL;
		RygelMediaExportPlaylistExtractor* _tmp13_ = NULL;
		_tmp12_ = file;
		_tmp13_ = rygel_media_export_playlist_extractor_new (_tmp12_);
		result = (RygelMediaExportExtractor*) _tmp13_;
		return result;
	}
	_tmp15_ = content_type;
	if (g_strcmp0 (_tmp15_, "image/jpeg") == 0) {
		_tmp14_ = TRUE;
	} else {
		const gchar* _tmp16_ = NULL;
		_tmp16_ = content_type;
		_tmp14_ = g_strcmp0 (_tmp16_, "image/png") == 0;
	}
	if (_tmp14_) {
		GFile* _tmp17_ = NULL;
		RygelMediaExportImageExtractor* _tmp18_ = NULL;
		_tmp17_ = file;
		_tmp18_ = rygel_media_export_image_extractor_new (_tmp17_);
		result = (RygelMediaExportExtractor*) _tmp18_;
		return result;
	}
	_tmp19_ = file;
	_tmp20_ = rygel_media_export_generic_extractor_new (_tmp19_);
	result = (RygelMediaExportExtractor*) _tmp20_;
	return result;
}


static RygelMediaExportExtractor* rygel_media_export_extractor_construct (GType object_type, GFile* file) {
	RygelMediaExportExtractor * self = NULL;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = file;
	self = (RygelMediaExportExtractor*) g_object_new (object_type, "file", _tmp0_, NULL);
	return self;
}


static RygelMediaExportExtractor* rygel_media_export_extractor_new (GFile* file) {
	return rygel_media_export_extractor_construct (RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, file);
}


static void rygel_media_export_extractor_real_constructed (GObject* base) {
	RygelMediaExportExtractor * self;
	GVariantDict* _tmp0_ = NULL;
	self = (RygelMediaExportExtractor*) base;
	_tmp0_ = g_variant_dict_new (NULL);
	_g_variant_dict_unref0 (self->serialized_info);
	self->serialized_info = _tmp0_;
}


static void rygel_media_export_extractor_real_run_data_free (gpointer _data) {
	RygelMediaExportExtractorRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportExtractorRunData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_media_export_extractor_real_run (RygelMediaExportExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportExtractorRunData* _data_;
	RygelMediaExportExtractor* _tmp0_ = NULL;
	_data_ = g_slice_new0 (RygelMediaExportExtractorRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_extractor_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_extractor_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_extractor_real_run_co (_data_);
}


static void rygel_media_export_extractor_real_run_finish (RygelMediaExportExtractor* self, GAsyncResult* _res_, GError** error) {
	RygelMediaExportExtractorRunData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_media_export_extractor_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportExtractorRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_extractor_real_run_co (_data_);
}


static gboolean rygel_media_export_extractor_real_run_co (RygelMediaExportExtractorRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_file;
	_data_->_state_ = 1;
	g_file_query_info_async (_data_->_tmp0_, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, rygel_media_export_extractor_run_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_file_query_info_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
	_data_->file_info = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_file_info_get_display_name (_data_->file_info);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
	_data_->display_name = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->display_name;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rygel_media_export_extractor_strip_invalid_entities (_data_->self, _data_->_tmp4_);
	_data_->title = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->self->serialized_info;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->title;
	g_variant_dict_insert (_data_->_tmp6_, RYGEL_MEDIA_EXPORT_SERIALIZER_TITLE, "s", _data_->_tmp7_, NULL);
	_data_->_tmp8_ = 0ULL;
	_data_->_tmp8_ = g_file_info_get_attribute_uint64 (_data_->file_info, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	_data_->mtime = _data_->_tmp8_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->self->serialized_info;
	_data_->_tmp10_ = 0ULL;
	_data_->_tmp10_ = _data_->mtime;
	g_variant_dict_insert (_data_->_tmp9_, RYGEL_MEDIA_EXPORT_SERIALIZER_MODIFIED, "t", _data_->_tmp10_, NULL);
	_data_->_tmp11_ = 0ULL;
	_data_->_tmp11_ = _data_->mtime;
	memset (&_data_->_tmp12_, 0, sizeof (GTimeVal));
	_data_->_tmp12_.tv_sec = (glong) _data_->_tmp11_;
	_data_->_tmp12_.tv_usec = (glong) 0;
	_data_->tv = _data_->_tmp12_;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->self->serialized_info;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_time_val_to_iso8601 (&_data_->tv);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->_tmp14_;
	g_variant_dict_insert (_data_->_tmp13_, RYGEL_MEDIA_EXPORT_SERIALIZER_DATE, "s", _data_->_tmp15_, NULL);
	_g_free0 (_data_->_tmp15_);
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = g_file_info_get_content_type (_data_->file_info);
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = g_content_type_get_mime_type (_data_->_tmp16_);
	_data_->content_type = _data_->_tmp17_;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->self->serialized_info;
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->content_type;
	g_variant_dict_insert (_data_->_tmp18_, RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE, "s", _data_->_tmp19_, NULL);
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->self->serialized_info;
	_data_->_tmp21_ = 0LL;
	_data_->_tmp21_ = g_file_info_get_size (_data_->file_info);
	g_variant_dict_insert (_data_->_tmp20_, RYGEL_MEDIA_EXPORT_SERIALIZER_SIZE, "t", _data_->_tmp21_, NULL);
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->self->priv->_file;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = g_file_get_uri (_data_->_tmp22_);
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _data_->_tmp24_, (gsize) -1);
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _data_->_tmp25_;
	_g_free0 (_data_->_tmp24_);
	_data_->id = _data_->_tmp26_;
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = _data_->self->serialized_info;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->id;
	g_variant_dict_insert (_data_->_tmp27_, RYGEL_MEDIA_EXPORT_SERIALIZER_ID, "s", _data_->_tmp28_, NULL);
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->self->serialized_info;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->self->priv->_file;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = g_file_get_uri (_data_->_tmp30_);
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->_tmp31_;
	g_variant_dict_insert (_data_->_tmp29_, RYGEL_MEDIA_EXPORT_SERIALIZER_URI, "s", _data_->_tmp32_, NULL);
	_g_free0 (_data_->_tmp32_);
	_g_free0 (_data_->id);
	_g_free0 (_data_->content_type);
	_g_free0 (_data_->title);
	_g_free0 (_data_->display_name);
	_g_object_unref0 (_data_->file_info);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void rygel_media_export_extractor_run (RygelMediaExportExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_CLASS (self)->run (self, _callback_, _user_data_);
}


void rygel_media_export_extractor_run_finish (RygelMediaExportExtractor* self, GAsyncResult* _res_, GError** error) {
	RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_CLASS (self)->run_finish (self, _res_, error);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void _vala_SoupDate_free (SoupDate* self) {
	g_boxed_free (soup_date_get_type (), self);
}


GVariant* rygel_media_export_extractor_get (RygelMediaExportExtractor* self) {
	GVariant* result = NULL;
	GVariant* date = NULL;
	GVariantDict* _tmp0_ = NULL;
	const GVariantType* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GVariantDict* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->serialized_info;
	_tmp1_ = G_VARIANT_TYPE_STRING;
	_tmp2_ = g_variant_dict_lookup_value (_tmp0_, RYGEL_MEDIA_EXPORT_SERIALIZER_DATE, _tmp1_);
	date = _tmp2_;
	_tmp3_ = date;
	_tmp4_ = g_variant_get_string (_tmp3_, NULL);
	_tmp5_ = string_contains (_tmp4_, "T");
	if (_tmp5_) {
		SoupDate* fixed_date = NULL;
		GVariant* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		SoupDate* _tmp8_ = NULL;
		gchar* new_date = NULL;
		SoupDate* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GVariantDict* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp6_ = date;
		_tmp7_ = g_variant_get_string (_tmp6_, NULL);
		_tmp8_ = soup_date_new_from_string (_tmp7_);
		fixed_date = _tmp8_;
		_tmp9_ = fixed_date;
		_tmp10_ = soup_date_to_string (_tmp9_, SOUP_DATE_ISO8601_FULL);
		new_date = _tmp10_;
		_tmp11_ = self->serialized_info;
		_tmp12_ = new_date;
		g_variant_dict_insert (_tmp11_, RYGEL_MEDIA_EXPORT_SERIALIZER_DATE, "s", _tmp12_, NULL);
		_g_free0 (new_date);
		__vala_SoupDate_free0 (fixed_date);
	}
	_tmp13_ = self->serialized_info;
	_tmp14_ = g_variant_dict_end (_tmp13_);
	g_variant_ref_sink (_tmp14_);
	result = _tmp14_;
	_g_variant_unref0 (date);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void _vala_array_add1 (GRegex*** array, int* length, int* size, GRegex* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GRegex*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (GRegex*** array, int* length, int* size, GRegex* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GRegex*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


static void _vala_array_add3 (GRegex*** array, int* length, int* size, GRegex* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GRegex*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* rygel_media_export_extractor_strip_invalid_entities (RygelMediaExportExtractor* self, const gchar* original) {
	gchar* result = NULL;
	GRegex* _tmp0_ = NULL;
	gchar* p = NULL;
	const gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (original != NULL, NULL);
	_tmp0_ = rygel_media_export_extractor_char_remove_regex;
	if (_tmp0_ == NULL) {
		{
			gchar* regex_string = NULL;
			gchar* _tmp1_ = NULL;
			GRegex* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			GRegex* _tmp6_ = NULL;
			GRegex* _tmp7_ = NULL;
			GRegex* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			GRegex* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			GRegex* _tmp14_ = NULL;
			GRegex* _tmp15_ = NULL;
			GRegex* _tmp16_ = NULL;
			GRegex* _tmp17_ = NULL;
			GRegex* _tmp18_ = NULL;
			GRegex* _tmp19_ = NULL;
			GRegex** _tmp20_ = NULL;
			_tmp1_ = g_regex_escape_string (RYGEL_MEDIA_EXPORT_EXTRACTOR_INVALID_CHARS, -1);
			regex_string = _tmp1_;
			_tmp3_ = regex_string;
			_tmp4_ = g_strdup_printf ("[%s]", _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_regex_new (_tmp5_, 0, 0, &_inner_error_);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp5_);
			_tmp2_ = _tmp7_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (regex_string);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				_g_free0 (regex_string);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp8_ = _tmp2_;
			_tmp2_ = NULL;
			_g_regex_unref0 (rygel_media_export_extractor_char_remove_regex);
			rygel_media_export_extractor_char_remove_regex = _tmp8_;
			_tmp9_ = g_regex_escape_string (RYGEL_MEDIA_EXPORT_EXTRACTOR_CONVERT_CHARS, -1);
			_g_free0 (regex_string);
			regex_string = _tmp9_;
			_tmp11_ = regex_string;
			_tmp12_ = g_strdup_printf ("[%s]", _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_regex_new (_tmp13_, 0, 0, &_inner_error_);
			_tmp15_ = _tmp14_;
			_g_free0 (_tmp13_);
			_tmp10_ = _tmp15_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_regex_unref0 (_tmp2_);
				_g_free0 (regex_string);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				_g_regex_unref0 (_tmp2_);
				_g_free0 (regex_string);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp16_ = _tmp10_;
			_tmp10_ = NULL;
			_g_regex_unref0 (rygel_media_export_extractor_char_convert_regex);
			rygel_media_export_extractor_char_convert_regex = _tmp16_;
			_tmp18_ = g_regex_new ("\\s+", 0, 0, &_inner_error_);
			_tmp17_ = _tmp18_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_regex_unref0 (_tmp10_);
				_g_regex_unref0 (_tmp2_);
				_g_free0 (regex_string);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				_g_regex_unref0 (_tmp10_);
				_g_regex_unref0 (_tmp2_);
				_g_free0 (regex_string);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp19_ = _tmp17_;
			_tmp17_ = NULL;
			_g_regex_unref0 (rygel_media_export_extractor_space_compress_regex);
			rygel_media_export_extractor_space_compress_regex = _tmp19_;
			_tmp20_ = g_new0 (GRegex*, 0 + 1);
			rygel_media_export_extractor_block_regexes = (_vala_array_free (rygel_media_export_extractor_block_regexes, rygel_media_export_extractor_block_regexes_length1, (GDestroyNotify) g_regex_unref), NULL);
			rygel_media_export_extractor_block_regexes = _tmp20_;
			rygel_media_export_extractor_block_regexes_length1 = 0;
			_rygel_media_export_extractor_block_regexes_size_ = rygel_media_export_extractor_block_regexes_length1;
			{
				const gchar** block_collection = NULL;
				gint block_collection_length1 = 0;
				gint _block_collection_size_ = 0;
				gint block_it = 0;
				block_collection = RYGEL_MEDIA_EXPORT_EXTRACTOR_BLOCKS;
				block_collection_length1 = G_N_ELEMENTS (RYGEL_MEDIA_EXPORT_EXTRACTOR_BLOCKS);
				for (block_it = 0; block_it < G_N_ELEMENTS (RYGEL_MEDIA_EXPORT_EXTRACTOR_BLOCKS); block_it = block_it + 1) {
					const gchar* block = NULL;
					block = block_collection[block_it];
					{
						gchar* block_re = NULL;
						const gchar* _tmp21_ = NULL;
						gchar _tmp22_ = '\0';
						gchar* _tmp23_ = NULL;
						gchar* _tmp24_ = NULL;
						gchar* _tmp25_ = NULL;
						gchar* _tmp26_ = NULL;
						const gchar* _tmp27_ = NULL;
						gchar _tmp28_ = '\0';
						gchar* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
						gchar* _tmp32_ = NULL;
						const gchar* _tmp33_ = NULL;
						gchar _tmp34_ = '\0';
						gchar* _tmp35_ = NULL;
						gchar* _tmp36_ = NULL;
						gchar* _tmp37_ = NULL;
						gchar* _tmp38_ = NULL;
						gchar* _tmp39_ = NULL;
						gchar* _tmp40_ = NULL;
						GRegex* _tmp41_ = NULL;
						const gchar* _tmp42_ = NULL;
						GRegex* _tmp43_ = NULL;
						GRegex** _tmp44_ = NULL;
						gint _tmp44__length1 = 0;
						GRegex* _tmp45_ = NULL;
						_tmp21_ = block;
						_tmp22_ = string_get (_tmp21_, (glong) 0);
						_tmp23_ = g_strdup_printf ("%C", _tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = g_regex_escape_string (_tmp24_, -1);
						_tmp26_ = _tmp25_;
						_tmp27_ = block;
						_tmp28_ = string_get (_tmp27_, (glong) 1);
						_tmp29_ = g_strdup_printf ("%C", _tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = g_regex_escape_string (_tmp30_, -1);
						_tmp32_ = _tmp31_;
						_tmp33_ = block;
						_tmp34_ = string_get (_tmp33_, (glong) 1);
						_tmp35_ = g_strdup_printf ("%C", _tmp34_);
						_tmp36_ = _tmp35_;
						_tmp37_ = g_regex_escape_string (_tmp36_, -1);
						_tmp38_ = _tmp37_;
						_tmp39_ = g_strdup_printf (RYGEL_MEDIA_EXPORT_EXTRACTOR_BLOCK_PATTERN, _tmp26_, _tmp32_, _tmp38_);
						_tmp40_ = _tmp39_;
						_g_free0 (_tmp38_);
						_g_free0 (_tmp36_);
						_g_free0 (_tmp32_);
						_g_free0 (_tmp30_);
						_g_free0 (_tmp26_);
						_g_free0 (_tmp24_);
						block_re = _tmp40_;
						_tmp42_ = block_re;
						_tmp43_ = g_regex_new (_tmp42_, 0, 0, &_inner_error_);
						_tmp41_ = _tmp43_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_free0 (block_re);
							_g_regex_unref0 (_tmp17_);
							_g_regex_unref0 (_tmp10_);
							_g_regex_unref0 (_tmp2_);
							_g_free0 (regex_string);
							if (_inner_error_->domain == G_REGEX_ERROR) {
								goto __catch7_g_regex_error;
							}
							_g_free0 (block_re);
							_g_regex_unref0 (_tmp17_);
							_g_regex_unref0 (_tmp10_);
							_g_regex_unref0 (_tmp2_);
							_g_free0 (regex_string);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_tmp44_ = rygel_media_export_extractor_block_regexes;
						_tmp44__length1 = rygel_media_export_extractor_block_regexes_length1;
						_tmp45_ = _tmp41_;
						_tmp41_ = NULL;
						_vala_array_add1 (&rygel_media_export_extractor_block_regexes, &rygel_media_export_extractor_block_regexes_length1, &_rygel_media_export_extractor_block_regexes_size_, _tmp45_);
						_g_regex_unref0 (_tmp41_);
						_g_free0 (block_re);
					}
				}
			}
			{
				const gchar** blacklist_collection = NULL;
				gint blacklist_collection_length1 = 0;
				gint _blacklist_collection_size_ = 0;
				gint blacklist_it = 0;
				blacklist_collection = RYGEL_MEDIA_EXPORT_EXTRACTOR_BLACKLIST;
				blacklist_collection_length1 = G_N_ELEMENTS (RYGEL_MEDIA_EXPORT_EXTRACTOR_BLACKLIST);
				for (blacklist_it = 0; blacklist_it < G_N_ELEMENTS (RYGEL_MEDIA_EXPORT_EXTRACTOR_BLACKLIST); blacklist_it = blacklist_it + 1) {
					const gchar* blacklist = NULL;
					blacklist = blacklist_collection[blacklist_it];
					{
						GRegex* _tmp46_ = NULL;
						const gchar* _tmp47_ = NULL;
						gchar* _tmp48_ = NULL;
						gchar* _tmp49_ = NULL;
						GRegex* _tmp50_ = NULL;
						GRegex* _tmp51_ = NULL;
						GRegex** _tmp52_ = NULL;
						gint _tmp52__length1 = 0;
						GRegex* _tmp53_ = NULL;
						_tmp47_ = blacklist;
						_tmp48_ = g_regex_escape_string (_tmp47_, -1);
						_tmp49_ = _tmp48_;
						_tmp50_ = g_regex_new (_tmp49_, 0, 0, &_inner_error_);
						_tmp51_ = _tmp50_;
						_g_free0 (_tmp49_);
						_tmp46_ = _tmp51_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_regex_unref0 (_tmp17_);
							_g_regex_unref0 (_tmp10_);
							_g_regex_unref0 (_tmp2_);
							_g_free0 (regex_string);
							if (_inner_error_->domain == G_REGEX_ERROR) {
								goto __catch7_g_regex_error;
							}
							_g_regex_unref0 (_tmp17_);
							_g_regex_unref0 (_tmp10_);
							_g_regex_unref0 (_tmp2_);
							_g_free0 (regex_string);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_tmp52_ = rygel_media_export_extractor_blacklist_regexes;
						_tmp52__length1 = rygel_media_export_extractor_blacklist_regexes_length1;
						_tmp53_ = _tmp46_;
						_tmp46_ = NULL;
						_vala_array_add2 (&rygel_media_export_extractor_blacklist_regexes, &rygel_media_export_extractor_blacklist_regexes_length1, &_rygel_media_export_extractor_blacklist_regexes_size_, _tmp53_);
						_g_regex_unref0 (_tmp46_);
					}
				}
			}
			{
				const gchar** suffix_collection = NULL;
				gint suffix_collection_length1 = 0;
				gint _suffix_collection_size_ = 0;
				gint suffix_it = 0;
				suffix_collection = RYGEL_MEDIA_EXPORT_EXTRACTOR_VIDEO_SUFFIXES;
				suffix_collection_length1 = G_N_ELEMENTS (RYGEL_MEDIA_EXPORT_EXTRACTOR_VIDEO_SUFFIXES);
				for (suffix_it = 0; suffix_it < G_N_ELEMENTS (RYGEL_MEDIA_EXPORT_EXTRACTOR_VIDEO_SUFFIXES); suffix_it = suffix_it + 1) {
					const gchar* suffix = NULL;
					suffix = suffix_collection[suffix_it];
					{
						GRegex* regex = NULL;
						const gchar* _tmp54_ = NULL;
						gchar* _tmp55_ = NULL;
						gchar* _tmp56_ = NULL;
						GRegex* _tmp57_ = NULL;
						GRegex* _tmp58_ = NULL;
						GRegex** _tmp59_ = NULL;
						gint _tmp59__length1 = 0;
						GRegex* _tmp60_ = NULL;
						GRegex* _tmp61_ = NULL;
						_tmp54_ = suffix;
						_tmp55_ = g_regex_escape_string (_tmp54_, -1);
						_tmp56_ = _tmp55_;
						_tmp57_ = g_regex_new (_tmp56_, G_REGEX_CASELESS, 0, &_inner_error_);
						_tmp58_ = _tmp57_;
						_g_free0 (_tmp56_);
						regex = _tmp58_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_regex_unref0 (_tmp17_);
							_g_regex_unref0 (_tmp10_);
							_g_regex_unref0 (_tmp2_);
							_g_free0 (regex_string);
							if (_inner_error_->domain == G_REGEX_ERROR) {
								goto __catch7_g_regex_error;
							}
							_g_regex_unref0 (_tmp17_);
							_g_regex_unref0 (_tmp10_);
							_g_regex_unref0 (_tmp2_);
							_g_free0 (regex_string);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_tmp59_ = rygel_media_export_extractor_video_suffix_regexes;
						_tmp59__length1 = rygel_media_export_extractor_video_suffix_regexes_length1;
						_tmp60_ = regex;
						_tmp61_ = _g_regex_ref0 (_tmp60_);
						_vala_array_add3 (&rygel_media_export_extractor_video_suffix_regexes, &rygel_media_export_extractor_video_suffix_regexes_length1, &_rygel_media_export_extractor_video_suffix_regexes_size_, _tmp61_);
						_g_regex_unref0 (regex);
					}
				}
			}
			_g_regex_unref0 (_tmp17_);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp2_);
			_g_free0 (regex_string);
		}
		goto __finally7;
		__catch7_g_regex_error:
		{
			GError* _error_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			g_assert_not_reached ();
			_g_error_free0 (_error_);
		}
		__finally7:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp62_ = original;
	_tmp63_ = g_strdup (_tmp62_);
	_g_free0 (p);
	p = _tmp63_;
	{
		GRegex** _tmp64_ = NULL;
		gint _tmp64__length1 = 0;
		GRegex** _tmp71_ = NULL;
		gint _tmp71__length1 = 0;
		GRegex** _tmp78_ = NULL;
		gint _tmp78__length1 = 0;
		gchar* _tmp85_ = NULL;
		GRegex* _tmp86_ = NULL;
		const gchar* _tmp87_ = NULL;
		gchar* _tmp88_ = NULL;
		gchar* _tmp89_ = NULL;
		gchar* _tmp90_ = NULL;
		GRegex* _tmp91_ = NULL;
		const gchar* _tmp92_ = NULL;
		gchar* _tmp93_ = NULL;
		gchar* _tmp94_ = NULL;
		gchar* _tmp95_ = NULL;
		GRegex* _tmp96_ = NULL;
		const gchar* _tmp97_ = NULL;
		gchar* _tmp98_ = NULL;
		gchar* _tmp99_ = NULL;
		const gchar* _tmp100_ = NULL;
		_tmp64_ = rygel_media_export_extractor_blacklist_regexes;
		_tmp64__length1 = rygel_media_export_extractor_blacklist_regexes_length1;
		{
			GRegex** re_collection = NULL;
			gint re_collection_length1 = 0;
			gint _re_collection_size_ = 0;
			gint re_it = 0;
			re_collection = _tmp64_;
			re_collection_length1 = _tmp64__length1;
			for (re_it = 0; re_it < _tmp64__length1; re_it = re_it + 1) {
				GRegex* _tmp65_ = NULL;
				GRegex* re = NULL;
				_tmp65_ = _g_regex_ref0 (re_collection[re_it]);
				re = _tmp65_;
				{
					gchar* _tmp66_ = NULL;
					GRegex* _tmp67_ = NULL;
					const gchar* _tmp68_ = NULL;
					gchar* _tmp69_ = NULL;
					gchar* _tmp70_ = NULL;
					_tmp67_ = re;
					_tmp68_ = p;
					_tmp69_ = g_regex_replace_literal (_tmp67_, _tmp68_, (gssize) -1, 0, "", 0, &_inner_error_);
					_tmp66_ = _tmp69_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_regex_unref0 (re);
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch8_g_regex_error;
						}
						_g_regex_unref0 (re);
						_g_free0 (p);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp70_ = _tmp66_;
					_tmp66_ = NULL;
					_g_free0 (p);
					p = _tmp70_;
					_g_free0 (_tmp66_);
					_g_regex_unref0 (re);
				}
			}
		}
		_tmp71_ = rygel_media_export_extractor_video_suffix_regexes;
		_tmp71__length1 = rygel_media_export_extractor_video_suffix_regexes_length1;
		{
			GRegex** re_collection = NULL;
			gint re_collection_length1 = 0;
			gint _re_collection_size_ = 0;
			gint re_it = 0;
			re_collection = _tmp71_;
			re_collection_length1 = _tmp71__length1;
			for (re_it = 0; re_it < _tmp71__length1; re_it = re_it + 1) {
				GRegex* _tmp72_ = NULL;
				GRegex* re = NULL;
				_tmp72_ = _g_regex_ref0 (re_collection[re_it]);
				re = _tmp72_;
				{
					gchar* _tmp73_ = NULL;
					GRegex* _tmp74_ = NULL;
					const gchar* _tmp75_ = NULL;
					gchar* _tmp76_ = NULL;
					gchar* _tmp77_ = NULL;
					_tmp74_ = re;
					_tmp75_ = p;
					_tmp76_ = g_regex_replace_literal (_tmp74_, _tmp75_, (gssize) -1, 0, "", 0, &_inner_error_);
					_tmp73_ = _tmp76_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_regex_unref0 (re);
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch8_g_regex_error;
						}
						_g_regex_unref0 (re);
						_g_free0 (p);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp77_ = _tmp73_;
					_tmp73_ = NULL;
					_g_free0 (p);
					p = _tmp77_;
					_g_free0 (_tmp73_);
					_g_regex_unref0 (re);
				}
			}
		}
		_tmp78_ = rygel_media_export_extractor_block_regexes;
		_tmp78__length1 = rygel_media_export_extractor_block_regexes_length1;
		{
			GRegex** re_collection = NULL;
			gint re_collection_length1 = 0;
			gint _re_collection_size_ = 0;
			gint re_it = 0;
			re_collection = _tmp78_;
			re_collection_length1 = _tmp78__length1;
			for (re_it = 0; re_it < _tmp78__length1; re_it = re_it + 1) {
				GRegex* _tmp79_ = NULL;
				GRegex* re = NULL;
				_tmp79_ = _g_regex_ref0 (re_collection[re_it]);
				re = _tmp79_;
				{
					gchar* _tmp80_ = NULL;
					GRegex* _tmp81_ = NULL;
					const gchar* _tmp82_ = NULL;
					gchar* _tmp83_ = NULL;
					gchar* _tmp84_ = NULL;
					_tmp81_ = re;
					_tmp82_ = p;
					_tmp83_ = g_regex_replace_literal (_tmp81_, _tmp82_, (gssize) -1, 0, "", 0, &_inner_error_);
					_tmp80_ = _tmp83_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_regex_unref0 (re);
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch8_g_regex_error;
						}
						_g_regex_unref0 (re);
						_g_free0 (p);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp84_ = _tmp80_;
					_tmp80_ = NULL;
					_g_free0 (p);
					p = _tmp84_;
					_g_free0 (_tmp80_);
					_g_regex_unref0 (re);
				}
			}
		}
		_tmp86_ = rygel_media_export_extractor_char_remove_regex;
		_tmp87_ = p;
		_tmp88_ = g_regex_replace_literal (_tmp86_, _tmp87_, (gssize) -1, 0, "", 0, &_inner_error_);
		_tmp85_ = _tmp88_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			_g_free0 (p);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp89_ = _tmp85_;
		_tmp85_ = NULL;
		_g_free0 (p);
		p = _tmp89_;
		_tmp91_ = rygel_media_export_extractor_char_convert_regex;
		_tmp92_ = p;
		_tmp93_ = g_regex_replace_literal (_tmp91_, _tmp92_, (gssize) -1, 0, " ", 0, &_inner_error_);
		_tmp90_ = _tmp93_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp85_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			_g_free0 (_tmp85_);
			_g_free0 (p);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp94_ = _tmp90_;
		_tmp90_ = NULL;
		_g_free0 (p);
		p = _tmp94_;
		_tmp96_ = rygel_media_export_extractor_space_compress_regex;
		_tmp97_ = p;
		_tmp98_ = g_regex_replace_literal (_tmp96_, _tmp97_, (gssize) -1, 0, " ", 0, &_inner_error_);
		_tmp95_ = _tmp98_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp90_);
			_g_free0 (_tmp85_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			_g_free0 (_tmp90_);
			_g_free0 (_tmp85_);
			_g_free0 (p);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp99_ = _tmp95_;
		_tmp95_ = NULL;
		_g_free0 (p);
		p = _tmp99_;
		_tmp100_ = p;
		g_strstrip (_tmp100_);
		result = p;
		_g_free0 (_tmp95_);
		_g_free0 (_tmp90_);
		_g_free0 (_tmp85_);
		return result;
	}
	goto __finally8;
	__catch8_g_regex_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally8:
	_g_free0 (p);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


GFile* rygel_media_export_extractor_get_file (RygelMediaExportExtractor* self) {
	GFile* result;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}


void rygel_media_export_extractor_set_file (RygelMediaExportExtractor* self, GFile* value) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp1_;
	g_object_notify ((GObject *) self, "file");
}


static void rygel_media_export_extractor_class_init (RygelMediaExportExtractorClass * klass) {
	rygel_media_export_extractor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportExtractorPrivate));
	((GObjectClass *) klass)->constructed = rygel_media_export_extractor_real_constructed;
	((RygelMediaExportExtractorClass *) klass)->run = rygel_media_export_extractor_real_run;
	((RygelMediaExportExtractorClass *) klass)->run_finish = rygel_media_export_extractor_real_run_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_extractor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_extractor_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_extractor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_EXTRACTOR_FILE, g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void rygel_media_export_extractor_instance_init (RygelMediaExportExtractor * self) {
	self->priv = RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_PRIVATE (self);
}


static void rygel_media_export_extractor_finalize (GObject* obj) {
	RygelMediaExportExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor);
	_g_object_unref0 (self->priv->_file);
	_g_variant_dict_unref0 (self->serialized_info);
	G_OBJECT_CLASS (rygel_media_export_extractor_parent_class)->finalize (obj);
}


GType rygel_media_export_extractor_get_type (void) {
	static volatile gsize rygel_media_export_extractor_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_extractor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportExtractor), 0, (GInstanceInitFunc) rygel_media_export_extractor_instance_init, NULL };
		GType rygel_media_export_extractor_type_id;
		rygel_media_export_extractor_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportExtractor", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_extractor_type_id__volatile, rygel_media_export_extractor_type_id);
	}
	return rygel_media_export_extractor_type_id__volatile;
}


static void _vala_rygel_media_export_extractor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_EXTRACTOR_FILE:
		g_value_set_object (value, rygel_media_export_extractor_get_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_export_extractor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaExportExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_EXTRACTOR_FILE:
		rygel_media_export_extractor_set_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



