/* ide-build-result-addin.c
 *
 * Copyright (C) 2015 Christian Hergert <christian@hergert.me>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "ide-build-result-addin.h"

G_DEFINE_INTERFACE (IdeBuildResultAddin, ide_build_result_addin, G_TYPE_OBJECT)

static void
ide_build_result_addin_real_load (IdeBuildResultAddin *self,
                                  IdeBuildResult      *result)
{
}

static void
ide_build_result_addin_real_unload (IdeBuildResultAddin *self,
                                    IdeBuildResult      *result)
{
}

static void
ide_build_result_addin_default_init (IdeBuildResultAddinInterface *iface)
{
  iface->load = ide_build_result_addin_real_load;
  iface->unload = ide_build_result_addin_real_unload;
}

void
ide_build_result_addin_load (IdeBuildResultAddin *self,
                             IdeBuildResult      *result)
{
  g_return_if_fail (IDE_IS_BUILD_RESULT_ADDIN (self));
  g_return_if_fail (IDE_IS_BUILD_RESULT (result));

  IDE_BUILD_RESULT_ADDIN_GET_IFACE (self)->load (self, result);
}

void
ide_build_result_addin_unload (IdeBuildResultAddin *self,
                               IdeBuildResult      *result)
{
  g_return_if_fail (IDE_IS_BUILD_RESULT_ADDIN (self));
  g_return_if_fail (IDE_IS_BUILD_RESULT (result));

  IDE_BUILD_RESULT_ADDIN_GET_IFACE (self)->unload (self, result);
}
