// Generated by gmmproc 2.49.2 -- DO NOT MODIFY!


#include <glibmm.h>

#include <idemm/uri.h>
#include <idemm/private/uri_p.h>


/* uri.hg
 *
 * Copyright (C) 2016 Marcin Kolny <marcin.kolny@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

namespace Ide {

Uri::Uri(const Glib::ustring& uri_string, Ide::UriParseFlags flags)
{
  GError* gerror = nullptr;
  gobject_ = ide_uri_new(uri_string.c_str(), static_cast<IdeUriParseFlags>(flags), &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

Uri::Uri(const Uri& base_uri, const Glib::ustring& uri_string, Ide::UriParseFlags flags)
{
  GError* gerror = nullptr;
  gobject_ = ide_uri_new_relative(const_cast<IdeUri*>(base_uri.gobj()), uri_string.c_str(), static_cast<IdeUriParseFlags>(flags), &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

Uri::Uri(const Glib::RefPtr<Gio::File>& file)
{
  gobject_ = ide_uri_new_from_file(file->gobj());
}

}
namespace
{
} // anonymous namespace


namespace Glib
{

Ide::Uri wrap(IdeUri* object, bool take_copy)
{
  return Ide::Uri(object, take_copy);
}

} // namespace Glib


namespace Ide
{


// static
GType Uri::get_type()
{
  return ide_uri_get_type();
}

Uri::Uri()
:
  gobject_ (nullptr) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

Uri::Uri(const Uri& other)
:
  gobject_ ((other.gobject_) ? ide_uri_copy(other.gobject_) : nullptr)
{}

Uri::Uri(Uri&& other) noexcept
:
  gobject_(other.gobject_)
{
  other.gobject_ = nullptr;
}

Uri& Uri::operator=(Uri&& other) noexcept
{
  Uri temp (other);
  swap(temp);
  return *this;
}

Uri::Uri(IdeUri* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? ide_uri_copy(gobject) : gobject)
{}

Uri& Uri::operator=(const Uri& other)
{
  Uri temp (other);
  swap(temp);
  return *this;
}

Uri::~Uri() noexcept
{
  if(gobject_)
    ide_uri_unref(gobject_);
}

void Uri::swap(Uri& other) noexcept
{
  IdeUri *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;
}

IdeUri* Uri::gobj_copy() const
{
  return ide_uri_copy(gobject_);
}


Glib::ustring Uri::to_string(Ide::UriToStringFlags flags) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(ide_uri_to_string(const_cast<IdeUri*>(gobj()), ((IdeUriToStringFlags)(flags))));
}

Glib::ustring Uri::get_scheme() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(ide_uri_get_scheme(const_cast<IdeUri*>(gobj())));
}

void Uri::set_scheme(const Glib::ustring& scheme)
{
  ide_uri_set_scheme(gobj(), scheme.c_str());
}

Glib::ustring Uri::get_user() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(ide_uri_get_user(const_cast<IdeUri*>(gobj())));
}

void Uri::set_user(const Glib::ustring& user)
{
  ide_uri_set_user(gobj(), user.c_str());
}

Glib::ustring Uri::get_password() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(ide_uri_get_password(const_cast<IdeUri*>(gobj())));
}

void Uri::set_password(const Glib::ustring& password)
{
  ide_uri_set_password(gobj(), password.c_str());
}

Glib::ustring Uri::get_auth_params() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(ide_uri_get_auth_params(const_cast<IdeUri*>(gobj())));
}

void Uri::set_auth_params(const Glib::ustring& auth_params)
{
  ide_uri_set_auth_params(gobj(), auth_params.c_str());
}

Glib::ustring Uri::get_host() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(ide_uri_get_host(const_cast<IdeUri*>(gobj())));
}

void Uri::set_host(const Glib::ustring& host)
{
  ide_uri_set_host(gobj(), host.c_str());
}

gushort Uri::get_port() const
{
  return ide_uri_get_port(const_cast<IdeUri*>(gobj()));
}

void Uri::set_port(gushort port)
{
  ide_uri_set_port(gobj(), port);
}

Glib::ustring Uri::get_path() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(ide_uri_get_path(const_cast<IdeUri*>(gobj())));
}

void Uri::set_path(const Glib::ustring& path)
{
  ide_uri_set_path(gobj(), path.c_str());
}

Glib::ustring Uri::get_query() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(ide_uri_get_query(const_cast<IdeUri*>(gobj())));
}

void Uri::set_query(const Glib::ustring& query)
{
  ide_uri_set_query(gobj(), query.c_str());
}

Glib::ustring Uri::get_fragment() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(ide_uri_get_fragment(const_cast<IdeUri*>(gobj())));
}

void Uri::set_fragment(const Glib::ustring& fragment)
{
  ide_uri_set_fragment(gobj(), fragment.c_str());
}

bool Uri::is_file(const Glib::RefPtr<Gio::File>& file) const
{
  return ide_uri_is_file(const_cast<IdeUri*>(gobj()), const_cast<GFile*>(Glib::unwrap<Gio::File>(file)));
}

Glib::RefPtr<Gio::File> Uri::to_file() const
{
  return Glib::wrap(ide_uri_to_file(const_cast<IdeUri*>(gobj())));
}


} // namespace Ide


