/* taquin-main.c generated by valac 0.32.0.61-f103e, the Vala compiler
 * generated from taquin-main.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2014-2016 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of Taquin.
 *
 * Taquin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Taquin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Taquin. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <canberra-gtk.h>
#include <canberra.h>


#define TYPE_TAQUIN (taquin_get_type ())
#define TAQUIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAQUIN, Taquin))
#define TAQUIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAQUIN, TaquinClass))
#define IS_TAQUIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAQUIN))
#define IS_TAQUIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAQUIN))
#define TAQUIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAQUIN, TaquinClass))

typedef struct _Taquin Taquin;
typedef struct _TaquinClass TaquinClass;
typedef struct _TaquinPrivate TaquinPrivate;

#define TYPE_GAME_TYPE (game_type_get_type ())

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;

#define TYPE_TAQUIN_VIEW (taquin_view_get_type ())
#define TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAQUIN_VIEW, TaquinView))
#define TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAQUIN_VIEW, TaquinViewClass))
#define IS_TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAQUIN_VIEW))
#define IS_TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAQUIN_VIEW))
#define TAQUIN_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAQUIN_VIEW, TaquinViewClass))

typedef struct _TaquinView TaquinView;
typedef struct _TaquinViewClass TaquinViewClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GameWindowPrivate GameWindowPrivate;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

struct _Taquin {
	GtkApplication parent_instance;
	TaquinPrivate * priv;
};

struct _TaquinClass {
	GtkApplicationClass parent_class;
};

typedef enum  {
	GAME_TYPE_FIFTEEN,
	GAME_TYPE_SIXTEEN
} GameType;

struct _TaquinPrivate {
	GSettings* settings;
	GameType* tmp_type;
	gboolean size_changed;
	gboolean theme_changed;
	GameWindow* window;
	GtkMenuButton* size_button;
	GtkMenuButton* theme_button;
	TaquinView* view;
	Game* game;
	GList* theme_dirlist;
};

typedef enum  {
	GAME_WINDOW_FLAGS_SHOW_UNDO = 1 << 0,
	GAME_WINDOW_FLAGS_SHOW_REDO = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HINT = 1 << 2,
	GAME_WINDOW_FLAGS_SHOW_START_BUTTON = 1 << 3
} GameWindowFlags;

struct _GameWindow {
	GtkApplicationWindow parent_instance;
	GameWindowPrivate * priv;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
};

struct _GameWindowClass {
	GtkApplicationWindowClass parent_class;
};


static gpointer taquin_parent_class = NULL;
static gint taquin_tmp_size;
static gint taquin_tmp_size = 0;
static gboolean* taquin_sound;
static gboolean* taquin_sound = NULL;

GType taquin_get_type (void) G_GNUC_CONST;
GType game_type_get_type (void) G_GNUC_CONST;
GType game_window_get_type (void) G_GNUC_CONST;
GType taquin_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define TAQUIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TAQUIN, TaquinPrivate))
enum  {
	TAQUIN_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void taquin_change_size_cb (Taquin* self, GSimpleAction* action, GVariant* variant);
static void _taquin_change_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void taquin_change_theme_cb (Taquin* self, GSimpleAction* action, GVariant* variant);
static void _taquin_change_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void taquin_help_cb (Taquin* self);
static void _taquin_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void taquin_about_cb (Taquin* self);
static void _taquin_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
gint taquin_main (gchar** args, int args_length1);
static Taquin* taquin_new (void);
static Taquin* taquin_construct (GType object_type);
static gint taquin_real_handle_local_options (GApplication* base, GVariantDict* options);
static gboolean* _bool_dup (gboolean* self);
static GameType* _game_type_dup (GameType* self);
static void taquin_real_startup (GApplication* base);
gchar* game_type_to_string (GameType self);
TaquinView* taquin_view_new (void);
TaquinView* taquin_view_construct (GType object_type);
GType game_window_flags_get_type (void) G_GNUC_CONST;
GameWindow* game_window_new (const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
GameWindow* game_window_construct (GType object_type, const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
static void taquin_start_game (Taquin* self);
static void _taquin_start_game_game_window_play (GameWindow* _sender, gpointer self);
static void taquin_undo_cb (Taquin* self);
static void _taquin_undo_cb_game_window_undo (GameWindow* _sender, gpointer self);
static void __lambda5_ (Taquin* self);
static void taquin_update_size_button_label (Taquin* self, gint size);
static void ___lambda5__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda6_ (Taquin* self);
static void taquin_update_theme (Taquin* self, const gchar* theme);
static void ___lambda6__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void taquin_real_activate (GApplication* base);
static void taquin_real_shutdown (GApplication* base);
void game_window_shutdown (GameWindow* self, GSettings* settings);
Game* game_new (GameType game_type, gint size);
Game* game_construct (GType object_type, GameType game_type, gint size);
void taquin_view_set_game (TaquinView* self, Game* value);
void taquin_view_set_theme (TaquinView* self, const gchar* value);
static void taquin_game_complete_cb (Taquin* self);
static void _taquin_game_complete_cb_game_complete (Game* _sender, gpointer self);
static void taquin_cannot_move_cb (Taquin* self);
static void _taquin_cannot_move_cb_game_cannot_move (Game* _sender, gint x, gint y, gpointer self);
void game_window_cannot_undo_more (GameWindow* self);
static void _game_window_cannot_undo_more_game_cannot_undo_more (Game* _sender, gpointer self);
static void taquin_move_cb (Taquin* self);
static void _taquin_move_cb_game_move (Game* _sender, gboolean x_axis, gint number, gint x_gap, gint y_gap, gpointer self);
void game_undo (Game* self);
static void taquin_play_sound (Taquin* self, const gchar* name);
void game_window_set_subtitle (GameWindow* self, const gchar* subtitle);
void game_window_finish_game (GameWindow* self);
static void taquin_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry TAQUIN_option_entries[7] = {{"fifteen", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play the classical 1880s’ 15-puzzle", NULL}, {"sixteen", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Try this fun alternative 16-puzzle", NULL}, {"size", 's', 0, G_OPTION_ARG_INT, &taquin_tmp_size, "Sets the puzzle edges’ size (3-5, 2-9 for debug)", NULL}, {"mute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn off the sound", NULL}, {"unmute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn on the sound", NULL}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print release version and exit", NULL}, {NULL}};
static const GActionEntry TAQUIN_app_actions[5] = {{"change-size", _taquin_change_size_cb_gsimple_action_activate_callback, "s"}, {"change-theme", _taquin_change_theme_cb_gsimple_action_activate_callback, "s"}, {"help", _taquin_help_cb_gsimple_action_activate_callback}, {"about", _taquin_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};

static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void _taquin_change_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	taquin_change_size_cb ((Taquin*) self, action, parameter);
}


static void _taquin_change_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	taquin_change_theme_cb ((Taquin*) self, action, parameter);
}


static void _taquin_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	taquin_help_cb ((Taquin*) self);
}


static void _taquin_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	taquin_about_cb ((Taquin*) self);
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	g_application_quit ((GApplication*) self);
}


gint taquin_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	Taquin* _tmp1_ = NULL;
	Taquin* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = _ ("Taquin");
	g_set_application_name (_tmp0_);
	gtk_window_set_default_icon_name ("gnome-taquin");
	_tmp1_ = taquin_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = args;
	_tmp3__length1 = args_length1;
	_tmp4_ = g_application_run ((GApplication*) _tmp2_, _tmp3__length1, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return taquin_main (argv, argc);
}


static Taquin* taquin_construct (GType object_type) {
	Taquin * self = NULL;
	self = (Taquin*) g_object_new (object_type, "application-id", "org.gnome.taquin", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, TAQUIN_option_entries);
	return self;
}


static Taquin* taquin_new (void) {
	return taquin_construct (TYPE_TAQUIN);
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


static GameType* _game_type_dup (GameType* self) {
	GameType* dup;
	dup = g_new0 (GameType, 1);
	memcpy (dup, self, sizeof (GameType));
	return dup;
}


static gpointer __game_type_dup0 (gpointer self) {
	return self ? _game_type_dup (self) : NULL;
}


static gint taquin_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Taquin * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	GVariantDict* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GVariantDict* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	self = (Taquin*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stdout;
		fprintf (_tmp2_, "%1$s %2$s\n", "gnome-taquin", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	_tmp4_ = taquin_tmp_size;
	if (_tmp4_ != 0) {
		gint _tmp5_ = 0;
		_tmp5_ = taquin_tmp_size;
		_tmp3_ = _tmp5_ < 2;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		taquin_tmp_size = 2;
	}
	_tmp6_ = options;
	_tmp7_ = g_variant_dict_contains (_tmp6_, "mute");
	if (_tmp7_) {
		gboolean _tmp8_ = FALSE;
		gboolean* _tmp9_ = NULL;
		_tmp8_ = FALSE;
		_tmp9_ = __bool_dup0 (&_tmp8_);
		_g_free0 (taquin_sound);
		taquin_sound = _tmp9_;
	} else {
		GVariantDict* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = options;
		_tmp11_ = g_variant_dict_contains (_tmp10_, "unmute");
		if (_tmp11_) {
			gboolean _tmp12_ = FALSE;
			gboolean* _tmp13_ = NULL;
			_tmp12_ = TRUE;
			_tmp13_ = __bool_dup0 (&_tmp12_);
			_g_free0 (taquin_sound);
			taquin_sound = _tmp13_;
		}
	}
	_tmp14_ = options;
	_tmp15_ = g_variant_dict_contains (_tmp14_, "fifteen");
	if (_tmp15_) {
		GameType _tmp16_ = 0;
		GameType* _tmp17_ = NULL;
		_tmp16_ = GAME_TYPE_FIFTEEN;
		_tmp17_ = __game_type_dup0 (&_tmp16_);
		_g_free0 (self->priv->tmp_type);
		self->priv->tmp_type = _tmp17_;
	} else {
		GVariantDict* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		_tmp18_ = options;
		_tmp19_ = g_variant_dict_contains (_tmp18_, "sixteen");
		if (_tmp19_) {
			GameType _tmp20_ = 0;
			GameType* _tmp21_ = NULL;
			_tmp20_ = GAME_TYPE_SIXTEEN;
			_tmp21_ = __game_type_dup0 (&_tmp20_);
			_g_free0 (self->priv->tmp_type);
			self->priv->tmp_type = _tmp21_;
		}
	}
	result = -1;
	return result;
}


static void _taquin_start_game_game_window_play (GameWindow* _sender, gpointer self) {
	taquin_start_game ((Taquin*) self);
}


static void _taquin_undo_cb_game_window_undo (GameWindow* _sender, gpointer self) {
	taquin_undo_cb ((Taquin*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda5_ (Taquin* self) {
	gboolean _tmp0_ = FALSE;
	_tmp0_ = self->priv->size_changed;
	if (!_tmp0_) {
		GSettings* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = self->priv->settings;
		_tmp2_ = g_settings_get_int (_tmp1_, "size");
		taquin_update_size_button_label (self, _tmp2_);
	}
	self->priv->size_changed = FALSE;
}


static void ___lambda5__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda5_ ((Taquin*) self);
}


static void __lambda6_ (Taquin* self) {
	gboolean _tmp0_ = FALSE;
	_tmp0_ = self->priv->theme_changed;
	if (!_tmp0_) {
		GSettings* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = self->priv->settings;
		_tmp2_ = g_settings_get_string (_tmp1_, "theme");
		_tmp3_ = _tmp2_;
		taquin_update_theme (self, _tmp3_);
		_g_free0 (_tmp3_);
	}
	self->priv->theme_changed = FALSE;
}


static void ___lambda6__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda6_ ((Taquin*) self);
}


static void taquin_real_startup (GApplication* base) {
	Taquin * self;
	GSettings* _tmp0_ = NULL;
	gboolean* _tmp1_ = NULL;
	gint _tmp4_ = 0;
	GameType* _tmp7_ = NULL;
	TaquinView* _tmp12_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GSettings* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	GSettings* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	GSettings* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GObject* _tmp21_ = NULL;
	TaquinView* _tmp22_ = NULL;
	GameWindow* _tmp23_ = NULL;
	GameWindow* _tmp24_ = NULL;
	GameWindow* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar** _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	gchar* _tmp29_ = NULL;
	gchar** _tmp30_ = NULL;
	gchar** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	gchar* _tmp32_ = NULL;
	gchar** _tmp33_ = NULL;
	gchar** _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	gchar* _tmp35_ = NULL;
	gchar** _tmp36_ = NULL;
	gchar** _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	gchar* _tmp38_ = NULL;
	gchar** _tmp39_ = NULL;
	gchar** _tmp40_ = NULL;
	gint _tmp40__length1 = 0;
	GObject* _tmp41_ = NULL;
	GtkMenuButton* _tmp42_ = NULL;
	GSettings* _tmp43_ = NULL;
	GSettings* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	GObject* _tmp46_ = NULL;
	GtkMenuButton* _tmp47_ = NULL;
	GSettings* _tmp48_ = NULL;
	GSettings* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	GSettings* _tmp52_ = NULL;
	GAction* _tmp53_ = NULL;
	GAction* _tmp54_ = NULL;
	GSettings* _tmp55_ = NULL;
	GAction* _tmp56_ = NULL;
	GAction* _tmp57_ = NULL;
	GameWindow* _tmp58_ = NULL;
	self = (Taquin*) base;
	G_APPLICATION_CLASS (taquin_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = g_settings_new ("org.gnome.taquin");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = taquin_sound;
	if (_tmp1_ != NULL) {
		GSettings* _tmp2_ = NULL;
		gboolean* _tmp3_ = NULL;
		_tmp2_ = self->priv->settings;
		_tmp3_ = taquin_sound;
		g_settings_set_boolean (_tmp2_, "sound", *_tmp3_);
	}
	_tmp4_ = taquin_tmp_size;
	if (_tmp4_ > 1) {
		GSettings* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp5_ = self->priv->settings;
		_tmp6_ = taquin_tmp_size;
		g_settings_set_int (_tmp5_, "size", _tmp6_);
	}
	_tmp7_ = self->priv->tmp_type;
	if (_tmp7_ != NULL) {
		GSettings* _tmp8_ = NULL;
		GameType* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp8_ = self->priv->settings;
		_tmp9_ = self->priv->tmp_type;
		_tmp10_ = game_type_to_string (*_tmp9_);
		_tmp11_ = _tmp10_;
		g_settings_set_string (_tmp8_, "type", _tmp11_);
		_g_free0 (_tmp11_);
	}
	_tmp12_ = taquin_view_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp12_;
	_tmp13_ = gtk_builder_new_from_resource ("/org/gnome/taquin/ui/taquin-screens.ui");
	builder = _tmp13_;
	_tmp14_ = _ ("Taquin");
	_tmp15_ = self->priv->settings;
	_tmp16_ = g_settings_get_int (_tmp15_, "window-width");
	_tmp17_ = self->priv->settings;
	_tmp18_ = g_settings_get_int (_tmp17_, "window-height");
	_tmp19_ = self->priv->settings;
	_tmp20_ = g_settings_get_boolean (_tmp19_, "window-is-maximized");
	_tmp21_ = gtk_builder_get_object (builder, "new-game-screen");
	_tmp22_ = self->priv->view;
	_tmp23_ = game_window_new ("/org/gnome/taquin/ui/taquin.css", _tmp14_, _tmp16_, _tmp18_, _tmp20_, TRUE, GAME_WINDOW_FLAGS_SHOW_UNDO | GAME_WINDOW_FLAGS_SHOW_START_BUTTON, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp22_);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp23_;
	_tmp24_ = self->priv->window;
	g_signal_connect_object (_tmp24_, "play", (GCallback) _taquin_start_game_game_window_play, self, 0);
	_tmp25_ = self->priv->window;
	g_signal_connect_object (_tmp25_, "undo", (GCallback) _taquin_undo_cb_game_window_undo, self, 0);
	_tmp26_ = g_strdup ("<Primary>n");
	_tmp27_ = g_new0 (gchar*, 1 + 1);
	_tmp27_[0] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.new-game", _tmp28_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_tmp29_ = g_strdup ("<Primary><Shift>n");
	_tmp30_ = g_new0 (gchar*, 1 + 1);
	_tmp30_[0] = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.start-game", _tmp31_);
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
	_tmp32_ = g_strdup ("<Primary>z");
	_tmp33_ = g_new0 (gchar*, 1 + 1);
	_tmp33_[0] = _tmp32_;
	_tmp34_ = _tmp33_;
	_tmp34__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.undo", _tmp34_);
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
	_tmp35_ = g_strdup ("<Primary><Shift>z");
	_tmp36_ = g_new0 (gchar*, 1 + 1);
	_tmp36_[0] = _tmp35_;
	_tmp37_ = _tmp36_;
	_tmp37__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.redo", _tmp37_);
	_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
	_tmp38_ = g_strdup ("Escape");
	_tmp39_ = g_new0 (gchar*, 1 + 1);
	_tmp39_[0] = _tmp38_;
	_tmp40_ = _tmp39_;
	_tmp40__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.back", _tmp40_);
	_tmp40_ = (_vala_array_free (_tmp40_, _tmp40__length1, (GDestroyNotify) g_free), NULL);
	_tmp41_ = gtk_builder_get_object (builder, "size-button");
	_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_menu_button_get_type (), GtkMenuButton));
	_g_object_unref0 (self->priv->size_button);
	self->priv->size_button = _tmp42_;
	_tmp43_ = self->priv->settings;
	g_signal_connect_object (_tmp43_, "changed::size", (GCallback) ___lambda5__g_settings_changed, self, 0);
	_tmp44_ = self->priv->settings;
	_tmp45_ = g_settings_get_int (_tmp44_, "size");
	taquin_update_size_button_label (self, _tmp45_);
	_tmp46_ = gtk_builder_get_object (builder, "theme-button");
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_menu_button_get_type (), GtkMenuButton));
	_g_object_unref0 (self->priv->theme_button);
	self->priv->theme_button = _tmp47_;
	_tmp48_ = self->priv->settings;
	g_signal_connect_object (_tmp48_, "changed::theme", (GCallback) ___lambda6__g_settings_changed, self, 0);
	_tmp49_ = self->priv->settings;
	_tmp50_ = g_settings_get_string (_tmp49_, "theme");
	_tmp51_ = _tmp50_;
	taquin_update_theme (self, _tmp51_);
	_g_free0 (_tmp51_);
	g_action_map_add_action_entries ((GActionMap*) self, TAQUIN_app_actions, G_N_ELEMENTS (TAQUIN_app_actions), self);
	_tmp52_ = self->priv->settings;
	_tmp53_ = g_settings_create_action (_tmp52_, "sound");
	_tmp54_ = _tmp53_;
	g_action_map_add_action ((GActionMap*) self, _tmp54_);
	_g_object_unref0 (_tmp54_);
	_tmp55_ = self->priv->settings;
	_tmp56_ = g_settings_create_action (_tmp55_, "type");
	_tmp57_ = _tmp56_;
	g_action_map_add_action ((GActionMap*) self, _tmp57_);
	_g_object_unref0 (_tmp57_);
	_tmp58_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp58_);
	taquin_start_game (self);
	_g_object_unref0 (builder);
}


static void taquin_real_activate (GApplication* base) {
	Taquin * self;
	GameWindow* _tmp0_ = NULL;
	self = (Taquin*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void taquin_real_shutdown (GApplication* base) {
	Taquin * self;
	GameWindow* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	self = (Taquin*) base;
	_tmp0_ = self->priv->window;
	_tmp1_ = self->priv->settings;
	game_window_shutdown (_tmp0_, _tmp1_);
	G_APPLICATION_CLASS (taquin_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void _taquin_game_complete_cb_game_complete (Game* _sender, gpointer self) {
	taquin_game_complete_cb ((Taquin*) self);
}


static void _taquin_cannot_move_cb_game_cannot_move (Game* _sender, gint x, gint y, gpointer self) {
	taquin_cannot_move_cb ((Taquin*) self);
}


static void _game_window_cannot_undo_more_game_cannot_undo_more (Game* _sender, gpointer self) {
	game_window_cannot_undo_more ((GameWindow*) self);
}


static void _taquin_move_cb_game_move (Game* _sender, gboolean x_axis, gint number, gint x_gap, gint y_gap, gpointer self) {
	taquin_move_cb ((Taquin*) self);
}


static void taquin_start_game (Taquin* self) {
	Game* _tmp0_ = NULL;
	GameType type = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint size = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GameType _tmp6_ = 0;
	gint _tmp7_ = 0;
	Game* _tmp8_ = NULL;
	TaquinView* _tmp9_ = NULL;
	Game* _tmp10_ = NULL;
	gchar* filename = NULL;
	gchar* _tmp11_ = NULL;
	GList* dirlist = NULL;
	GList* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	TaquinView* _tmp42_ = NULL;
	GSettings* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	TaquinView* _tmp49_ = NULL;
	Game* _tmp50_ = NULL;
	Game* _tmp51_ = NULL;
	Game* _tmp52_ = NULL;
	GameWindow* _tmp53_ = NULL;
	Game* _tmp54_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_ = NULL;
		_tmp1_ = self->priv->game;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_enum (_tmp2_, "type");
	type = (GameType) _tmp3_;
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_get_int (_tmp4_, "size");
	size = _tmp5_;
	_tmp6_ = type;
	_tmp7_ = size;
	_tmp8_ = game_new (_tmp6_, _tmp7_);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp8_;
	_tmp9_ = self->priv->view;
	_tmp10_ = self->priv->game;
	taquin_view_set_game (_tmp9_, _tmp10_);
	_tmp11_ = g_strdup ("");
	filename = _tmp11_;
	_tmp12_ = self->priv->theme_dirlist;
	_tmp13_ = g_list_copy (_tmp12_);
	dirlist = _tmp13_;
	{
		gboolean _tmp14_ = FALSE;
		_tmp14_ = TRUE;
		while (TRUE) {
			gint random = 0;
			GList* _tmp30_ = NULL;
			guint _tmp31_ = 0U;
			gint32 _tmp32_ = 0;
			GList* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gconstpointer _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			GList* entry = NULL;
			GList* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			GCompareFunc _tmp39_ = NULL;
			GList* _tmp40_ = NULL;
			GList* _tmp41_ = NULL;
			if (!_tmp14_) {
				gboolean _tmp15_ = FALSE;
				const gchar* _tmp16_ = NULL;
				gchar _tmp17_ = '\0';
				_tmp16_ = filename;
				_tmp17_ = string_get (_tmp16_, (glong) 0);
				if (_tmp17_ == '0') {
					_tmp15_ = TRUE;
				} else {
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					const gchar* _tmp20_ = NULL;
					gchar _tmp21_ = '\0';
					_tmp20_ = filename;
					_tmp21_ = string_get (_tmp20_, (glong) 0);
					if (_tmp21_ != '1') {
						const gchar* _tmp22_ = NULL;
						gchar _tmp23_ = '\0';
						gint _tmp24_ = 0;
						gchar* _tmp25_ = NULL;
						gchar* _tmp26_ = NULL;
						gchar _tmp27_ = '\0';
						_tmp22_ = filename;
						_tmp23_ = string_get (_tmp22_, (glong) 0);
						_tmp24_ = size;
						_tmp25_ = g_strdup_printf ("%i", _tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = string_get (_tmp26_, (glong) 0);
						_tmp19_ = _tmp23_ != _tmp27_;
						_g_free0 (_tmp26_);
					} else {
						_tmp19_ = FALSE;
					}
					if (_tmp19_) {
						GList* _tmp28_ = NULL;
						guint _tmp29_ = 0U;
						_tmp28_ = dirlist;
						_tmp29_ = g_list_length (_tmp28_);
						_tmp18_ = _tmp29_ != ((guint) 0);
					} else {
						_tmp18_ = FALSE;
					}
					_tmp15_ = _tmp18_;
				}
				if (!_tmp15_) {
					break;
				}
			}
			_tmp14_ = FALSE;
			_tmp30_ = dirlist;
			_tmp31_ = g_list_length (_tmp30_);
			_tmp32_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp31_));
			random = (gint) _tmp32_;
			_tmp33_ = dirlist;
			_tmp34_ = random;
			_tmp35_ = g_list_nth_data (_tmp33_, (guint) _tmp34_);
			_tmp36_ = g_strdup ((const gchar*) _tmp35_);
			_g_free0 (filename);
			filename = _tmp36_;
			_tmp37_ = dirlist;
			_tmp38_ = filename;
			_tmp39_ = g_strcmp0;
			_tmp40_ = g_list_find_custom (_tmp37_, _tmp38_, _tmp39_);
			entry = _tmp40_;
			_tmp41_ = entry;
			dirlist = g_list_remove_link (dirlist, _tmp41_);
		}
	}
	_tmp42_ = self->priv->view;
	_tmp43_ = self->priv->settings;
	_tmp44_ = g_settings_get_string (_tmp43_, "theme");
	_tmp45_ = _tmp44_;
	_tmp46_ = filename;
	_tmp47_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp45_, _tmp46_, NULL);
	_tmp48_ = _tmp47_;
	taquin_view_set_theme (_tmp42_, _tmp48_);
	_g_free0 (_tmp48_);
	_g_free0 (_tmp45_);
	_tmp49_ = self->priv->view;
	gtk_widget_realize ((GtkWidget*) _tmp49_);
	_tmp50_ = self->priv->game;
	g_signal_connect_object (_tmp50_, "complete", (GCallback) _taquin_game_complete_cb_game_complete, self, 0);
	_tmp51_ = self->priv->game;
	g_signal_connect_object (_tmp51_, "cannot-move", (GCallback) _taquin_cannot_move_cb_game_cannot_move, self, 0);
	_tmp52_ = self->priv->game;
	_tmp53_ = self->priv->window;
	g_signal_connect_object (_tmp52_, "cannot-undo-more", (GCallback) _game_window_cannot_undo_more_game_cannot_undo_more, _tmp53_, 0);
	_tmp54_ = self->priv->game;
	g_signal_connect_object (_tmp54_, "move", (GCallback) _taquin_move_cb_game_move, self, 0);
	_g_list_free0 (dirlist);
	_g_free0 (filename);
}


static void taquin_about_cb (Taquin* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** artists = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GameWindow* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Arnaud Bonatti");
	_tmp1_ = g_new0 (gchar*, 2 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp1_[1] = NULL;
	authors = _tmp1_;
	authors_length1 = 2;
	_authors_size_ = authors_length1;
	_tmp2_ = g_strdup ("Abelard (Wikimedia)");
	_tmp3_ = g_strdup ("Alvesgaspar (Wikimedia)");
	_tmp4_ = g_strdup ("Mueller-rech.muenchen (Wikimedia)");
	_tmp5_ = g_strdup ("Ruskis (Wikimedia)");
	_tmp6_ = g_strdup ("Toyah (Wikimedia)");
	_tmp7_ = _ ("(see COPYING.themes for informations)");
	_tmp8_ = g_strdup (_tmp7_);
	_tmp9_ = g_new0 (gchar*, 7 + 1);
	_tmp9_[0] = _tmp2_;
	_tmp9_[1] = _tmp3_;
	_tmp9_[2] = _tmp4_;
	_tmp9_[3] = _tmp5_;
	_tmp9_[4] = _tmp6_;
	_tmp9_[5] = _tmp8_;
	_tmp9_[6] = NULL;
	artists = _tmp9_;
	artists_length1 = 7;
	_artists_size_ = artists_length1;
	_tmp10_ = g_strdup ("Arnaud Bonatti");
	_tmp11_ = g_new0 (gchar*, 2 + 1);
	_tmp11_[0] = _tmp10_;
	_tmp11_[1] = NULL;
	documenters = _tmp11_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp12_ = self->priv->window;
	_tmp13_ = _ ("Taquin");
	_tmp14_ = _ ("A classic 15-puzzle game");
	_tmp15_ = _ ("translator-credits");
	gtk_show_about_dialog ((GtkWindow*) _tmp12_, "name", _tmp13_, "version", VERSION, "copyright", "Copyright © 2014-2016 Arnaud Bonatti", "license-type", GTK_LICENSE_GPL_3_0, "comments", _tmp14_, "authors", authors, "artists", artists, "documenters", documenters, "translator-credits", _tmp15_, "logo-icon-name", "gnome-taquin", "website", "https://wiki.gnome.org/Apps/Taquin", NULL, NULL);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void taquin_help_cb (Taquin* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GameWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-taquin", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("taquin-main.vala:259: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void taquin_undo_cb (Taquin* self) {
	Game* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	game_undo (_tmp0_);
	taquin_play_sound (self, "sliding-1");
}


static void taquin_move_cb (Taquin* self) {
	GameWindow* _tmp0_ = NULL;
	GameWindow* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	game_window_set_subtitle (_tmp0_, NULL);
	_tmp1_ = self->priv->window;
	_tmp2_ = _tmp1_->undo_action;
	g_simple_action_set_enabled (_tmp2_, TRUE);
	taquin_play_sound (self, "sliding-1");
}


static void taquin_cannot_move_cb (Taquin* self) {
	GameWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = _ ("You can’t move this tile!");
	game_window_set_subtitle (_tmp0_, _tmp1_);
}


static void taquin_game_complete_cb (Taquin* self) {
	GameWindow* _tmp0_ = NULL;
	GameWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GameWindow* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	game_window_finish_game (_tmp0_);
	_tmp1_ = self->priv->window;
	_tmp2_ = _ ("Bravo! You finished the game!");
	game_window_set_subtitle (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->window;
	_tmp4_ = _tmp3_->undo_action;
	g_simple_action_set_enabled (_tmp4_, FALSE);
	taquin_play_sound (self, "gameover");
}


static void taquin_change_size_cb (Taquin* self, GSimpleAction* action, GVariant* variant) {
	gint size = 0;
	GVariant* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	self->priv->size_changed = TRUE;
	_tmp0_ = variant;
	_tmp1_ = g_variant_get_string (_tmp0_, NULL);
	_tmp2_ = atoi (_tmp1_);
	size = _tmp2_;
	taquin_update_size_button_label (self, size);
	_tmp3_ = self->priv->settings;
	g_settings_set_int (_tmp3_, "size", size);
}


static void taquin_update_size_button_label (Taquin* self, gint size) {
	GtkMenuButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->size_button;
	_tmp1_ = _ ("Size: %d × %d ▾");
	_tmp2_ = size;
	_tmp3_ = size;
	_tmp4_ = g_strdup_printf (_tmp1_, _tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_button_set_label ((GtkButton*) _tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
}


static void taquin_change_theme_cb (Taquin* self, GSimpleAction* action, GVariant* variant) {
	gchar* name = NULL;
	GVariant* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	self->priv->theme_changed = TRUE;
	_tmp0_ = variant;
	_tmp1_ = g_variant_get_string (_tmp0_, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	taquin_update_theme (self, name);
	_tmp3_ = self->priv->settings;
	g_settings_set_string (_tmp3_, "theme", name);
	_g_free0 (name);
}


static void taquin_update_theme (Taquin* self, const gchar* theme) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	GDir* dir = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = theme;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("cats")))) {
		switch (0) {
			default:
			{
				GtkMenuButton* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				_tmp4_ = self->priv->theme_button;
				_tmp5_ = _ ("Theme: Cats ▾");
				gtk_button_set_label ((GtkButton*) _tmp4_, _tmp5_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("numbers")))) {
		switch (0) {
			default:
			{
				GtkMenuButton* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				_tmp6_ = self->priv->theme_button;
				_tmp7_ = _ ("Theme: Numbers ▾");
				gtk_button_set_label ((GtkButton*) _tmp6_, _tmp7_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_warn_if_reached ();
				break;
			}
		}
	}
	__g_list_free__g_free0_0 (self->priv->theme_dirlist);
	self->priv->theme_dirlist = NULL;
	{
		GDir* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		GDir* _tmp12_ = NULL;
		GDir* _tmp13_ = NULL;
		GDir* _tmp14_ = NULL;
		_tmp9_ = theme;
		_tmp10_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_dir_open (_tmp11_, (guint) 0, &_inner_error_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_tmp8_ = _tmp13_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_dir_close0 (dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp14_ = _tmp8_;
		_tmp8_ = NULL;
		_g_dir_close0 (dir);
		dir = _tmp14_;
		while (TRUE) {
			gchar* filename = NULL;
			GDir* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			_tmp15_ = dir;
			_tmp16_ = g_dir_read_name (_tmp15_);
			_tmp17_ = g_strdup (_tmp16_);
			filename = _tmp17_;
			_tmp18_ = filename;
			if (_tmp18_ == NULL) {
				_g_free0 (filename);
				break;
			}
			_tmp19_ = filename;
			_tmp20_ = g_strdup (_tmp19_);
			self->priv->theme_dirlist = g_list_append (self->priv->theme_dirlist, _tmp20_);
			_g_free0 (filename);
		}
		_g_dir_close0 (_tmp8_);
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("taquin-main.vala:344: Failed to load images: %s", _tmp22_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_dir_close0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_dir_close0 (dir);
}


static void taquin_play_sound (Taquin* self, const gchar* name) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	TaquinView* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->view;
	_tmp3_ = name;
	_tmp4_ = name;
	_tmp5_ = g_strdup_printf ("%s.ogg", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_build_filename (SOUND_DIRECTORY, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	ca_gtk_play_for_widget ((GtkWidget*) _tmp2_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp3_, CA_PROP_MEDIA_FILENAME, _tmp8_, NULL);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
}


static void taquin_class_init (TaquinClass * klass) {
	taquin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TaquinPrivate));
	((GApplicationClass *) klass)->handle_local_options = taquin_real_handle_local_options;
	((GApplicationClass *) klass)->startup = taquin_real_startup;
	((GApplicationClass *) klass)->activate = taquin_real_activate;
	((GApplicationClass *) klass)->shutdown = taquin_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = taquin_finalize;
}


static void taquin_instance_init (Taquin * self) {
	self->priv = TAQUIN_GET_PRIVATE (self);
	self->priv->tmp_type = NULL;
	self->priv->size_changed = FALSE;
	self->priv->theme_changed = FALSE;
	self->priv->game = NULL;
}


static void taquin_finalize (GObject* obj) {
	Taquin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAQUIN, Taquin);
	_g_object_unref0 (self->priv->settings);
	_g_free0 (self->priv->tmp_type);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->size_button);
	_g_object_unref0 (self->priv->theme_button);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->game);
	__g_list_free__g_free0_0 (self->priv->theme_dirlist);
	G_OBJECT_CLASS (taquin_parent_class)->finalize (obj);
}


GType taquin_get_type (void) {
	static volatile gsize taquin_type_id__volatile = 0;
	if (g_once_init_enter (&taquin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaquinClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) taquin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Taquin), 0, (GInstanceInitFunc) taquin_instance_init, NULL };
		GType taquin_type_id;
		taquin_type_id = g_type_register_static (gtk_application_get_type (), "Taquin", &g_define_type_info, 0);
		g_once_init_leave (&taquin_type_id__volatile, taquin_type_id);
	}
	return taquin_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



