/* rygel-media-export-item-factory.c generated by valac 0.31.1.6-4f062, the Vala compiler
 * generated from rygel-media-export-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2012,2013 Intel Corporation.
 * Copyright (C) 2015 Jens Georg
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *         Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rygel-server.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <libsoup/soup.h>

#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM (rygel_media_export_playlist_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItem))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))

typedef struct _RygelMediaExportPlaylistItem RygelMediaExportPlaylistItem;
typedef struct _RygelMediaExportPlaylistItemClass RygelMediaExportPlaylistItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM (rygel_media_export_photo_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItem))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))

typedef struct _RygelMediaExportPhotoItem RygelMediaExportPhotoItem;
typedef struct _RygelMediaExportPhotoItemClass RygelMediaExportPhotoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER (rygel_media_export_dvd_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainer))
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DVD_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DVD_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainerClass))

typedef struct _RygelMediaExportDVDContainer RygelMediaExportDVDContainer;
typedef struct _RygelMediaExportDVDContainerClass RygelMediaExportDVDContainerClass;
#define __vala_SoupDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupDate_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

typedef enum  {
	RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_DESERIALIZATION,
	RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_MISMATCH
} RygelMediaExportItemFactoryItemFactoryError;
#define RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR rygel_media_export_item_factory_item_factory_error_quark ()
struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};


extern GRegex* rygel_media_export_item_factory_char_remove_regex;
GRegex* rygel_media_export_item_factory_char_remove_regex = NULL;
extern GRegex* rygel_media_export_item_factory_char_convert_regex;
GRegex* rygel_media_export_item_factory_char_convert_regex = NULL;
extern GRegex* rygel_media_export_item_factory_space_compress_regex;
GRegex* rygel_media_export_item_factory_space_compress_regex = NULL;
extern GRegex** rygel_media_export_item_factory_block_regexes;
extern gint rygel_media_export_item_factory_block_regexes_length1;
GRegex** rygel_media_export_item_factory_block_regexes = NULL;
gint rygel_media_export_item_factory_block_regexes_length1 = 0;
static gint _rygel_media_export_item_factory_block_regexes_size_ = 0;
extern GRegex** rygel_media_export_item_factory_blacklist_regexes;
extern gint rygel_media_export_item_factory_blacklist_regexes_length1;
GRegex** rygel_media_export_item_factory_blacklist_regexes = NULL;
gint rygel_media_export_item_factory_blacklist_regexes_length1 = 0;
static gint _rygel_media_export_item_factory_blacklist_regexes_size_ = 0;
extern GRegex** rygel_media_export_item_factory_video_suffix_regexes;
extern gint rygel_media_export_item_factory_video_suffix_regexes_length1;
GRegex** rygel_media_export_item_factory_video_suffix_regexes = NULL;
gint rygel_media_export_item_factory_video_suffix_regexes_length1 = 0;
static gint _rygel_media_export_item_factory_video_suffix_regexes_size_ = 0;

GQuark rygel_media_export_item_factory_item_factory_error_quark (void);
#define RYGEL_MEDIA_EXPORT_ITEM_FACTORY_INVALID_CHARS "()[]<>{}!@#$^&*+=|\\/\"'?~"
#define RYGEL_MEDIA_EXPORT_ITEM_FACTORY_CONVERT_CHARS "\t_\\."
#define RYGEL_MEDIA_EXPORT_ITEM_FACTORY_BLOCK_PATTERN "%s[^%s]*%s"
gboolean rygel_media_export_item_factory_check_variant_type (GVariant* v, const gchar* typestring, GError** error);
RygelMediaFileItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GType rygel_media_export_playlist_item_get_type (void) G_GNUC_CONST;
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaObject* rygel_media_export_item_factory_create_from_variant (RygelMediaContainer* parent, GFile* file, GVariant* v, GError** error);
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_UPNP_CLASS RYGEL_MEDIA_CONTAINER_PLAYLIST ".DVD"
RygelMediaExportPhotoItem* rygel_media_export_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPhotoItem* rygel_media_export_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_photo_item_get_type (void) G_GNUC_CONST;
RygelMediaExportVideoItem* rygel_media_export_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportVideoItem* rygel_media_export_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
RygelMediaExportMusicItem* rygel_media_export_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportMusicItem* rygel_media_export_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dvd_container_get_type (void) G_GNUC_CONST;
RygelMediaExportDVDContainer* rygel_media_export_dvd_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* path);
RygelMediaExportDVDContainer* rygel_media_export_dvd_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* path);
void rygel_media_export_item_factory_apply_file_info (RygelMediaObject* object, GVariant* v, GError** error);
gchar* rygel_media_export_item_factory_strip_invalid_entities (const gchar* original);
void rygel_media_export_item_factory_apply_dlna_profile (RygelMediaFileItem* item, GVariant* v, GError** error);
void rygel_media_export_item_factory_apply_info (RygelMediaFileItem* item, GVariant* v, GError** error);
void rygel_media_export_item_factory_apply_audio_info (RygelMediaFileItem* item, GVariant* v, GError** error);
void rygel_media_export_item_factory_apply_video_info (RygelMediaFileItem* item, GVariant* v, GError** error);
void rygel_media_export_item_factory_apply_meta_data (RygelMediaFileItem* item, GVariant* v, GError** error);
static void _vala_SoupDate_free (SoupDate* self);
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
static void _vala_array_add1 (GRegex*** array, int* length, int* size, GRegex* value);
static void _vala_array_add2 (GRegex*** array, int* length, int* size, GRegex* value);
static void _vala_array_add3 (GRegex*** array, int* length, int* size, GRegex* value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gchar* RYGEL_MEDIA_EXPORT_ITEM_FACTORY_BLOCKS[4] = {"()", "{}", "[]", "<>"};
const gchar* RYGEL_MEDIA_EXPORT_ITEM_FACTORY_BLACKLIST[14] = {"720p", "1080p", "x264", "ws", "proper", "real.repack", "repack", "hdtv", "pdtv", "notv", "dsr", "DVDRip", "divx", "xvid"};
const gchar* RYGEL_MEDIA_EXPORT_ITEM_FACTORY_VIDEO_SUFFIXES[13] = {"webm", "mkv", "flv", "ogv", "ogg", "avi", "mov", "wmv", "mp4", "m4v", "mpeg", "mpg", "iso"};

GQuark rygel_media_export_item_factory_item_factory_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_export_item_factory_item_factory_error-quark");
}


gboolean rygel_media_export_item_factory_check_variant_type (GVariant* v, const gchar* typestring, GError** error) {
	gboolean result = FALSE;
	GVariant* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GVariantType* _tmp2_ = NULL;
	GVariantType* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (v != NULL, FALSE);
	g_return_val_if_fail (typestring != NULL, FALSE);
	_tmp0_ = v;
	_tmp1_ = typestring;
	_tmp2_ = g_variant_type_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_is_of_type (_tmp0_, _tmp3_);
	_tmp5_ = !_tmp4_;
	_g_variant_type_free0 (_tmp3_);
	if (_tmp5_) {
		gchar* msg = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GVariant* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		_tmp6_ = g_strdup ("Variant type mismatch, expected %s, got %s");
		msg = _tmp6_;
		_tmp7_ = msg;
		_tmp8_ = v;
		_tmp9_ = g_variant_get_type_string (_tmp8_);
		_tmp10_ = typestring;
		_tmp11_ = g_error_new (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR, RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_DESERIALIZATION, _tmp7_, _tmp9_, _tmp10_);
		_inner_error_ = _tmp11_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


RygelMediaFileItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title) {
	RygelMediaFileItem* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (fallback_title != NULL, NULL);
	{
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		gboolean _tmp0_ = FALSE;
		GFile* _tmp1_ = NULL;
		guint8* _tmp2_ = NULL;
		gsize _tmp3_;
		gboolean _tmp4_ = FALSE;
		gint i = 0;
		guint8* _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		gint _tmp14_ = 0;
		guint8 _tmp15_ = 0U;
		GUPnPMediaCollection* didl_s = NULL;
		guint8* _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		GUPnPMediaCollection* _tmp17_ = NULL;
		gchar* author = NULL;
		GUPnPMediaCollection* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* title = NULL;
		GUPnPMediaCollection* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp33_ = NULL;
		RygelMediaExportPlaylistItem* item = NULL;
		GFile* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		RygelMediaContainer* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		RygelMediaExportPlaylistItem* _tmp41_ = NULL;
		RygelMediaExportPlaylistItem* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		RygelMediaExportPlaylistItem* _tmp46_ = NULL;
		_tmp1_ = file;
		_tmp4_ = g_file_load_contents (_tmp1_, NULL, &_tmp2_, &_tmp3_, NULL, &_inner_error_);
		contents = (g_free (contents), NULL);
		contents = _tmp2_;
		contents_length1 = _tmp3_;
		_contents_size_ = contents_length1;
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			contents = (g_free (contents), NULL);
			goto __catch62_g_error;
		}
		if (!_tmp0_) {
			result = NULL;
			contents = (g_free (contents), NULL);
			return result;
		}
		i = 0;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			guint8* _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			gint _tmp7_ = 0;
			guint8 _tmp8_ = 0U;
			gboolean _tmp9_ = FALSE;
			gint _tmp12_ = 0;
			_tmp6_ = contents;
			_tmp6__length1 = contents_length1;
			_tmp7_ = i;
			_tmp8_ = _tmp6_[_tmp7_];
			_tmp9_ = g_ascii_isspace ((gchar) _tmp8_);
			if (_tmp9_) {
				gint _tmp10_ = 0;
				guint8* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				_tmp10_ = i;
				_tmp11_ = contents;
				_tmp11__length1 = contents_length1;
				_tmp5_ = _tmp10_ < _tmp11__length1;
			} else {
				_tmp5_ = FALSE;
			}
			if (!_tmp5_) {
				break;
			}
			_tmp12_ = i;
			i = _tmp12_ + 1;
		}
		_tmp13_ = contents;
		_tmp13__length1 = contents_length1;
		_tmp14_ = i;
		_tmp15_ = _tmp13_[_tmp14_];
		if (_tmp15_ != ((guint8) '<')) {
			result = NULL;
			contents = (g_free (contents), NULL);
			return result;
		}
		_tmp16_ = contents;
		_tmp16__length1 = contents_length1;
		_tmp17_ = gupnp_media_collection_new_from_string ((const gchar*) _tmp16_);
		didl_s = _tmp17_;
		_tmp18_ = didl_s;
		_tmp19_ = gupnp_media_collection_get_author (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup (_tmp20_);
		author = _tmp21_;
		_tmp22_ = didl_s;
		_tmp23_ = gupnp_media_collection_get_title (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup (_tmp24_);
		title = _tmp25_;
		_tmp28_ = author;
		if (_tmp28_ == NULL) {
			const gchar* _tmp29_ = NULL;
			_tmp29_ = title;
			_tmp27_ = _tmp29_ == NULL;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			GUPnPMediaCollection* _tmp30_ = NULL;
			GList* _tmp31_ = NULL;
			GList* _tmp32_ = NULL;
			_tmp30_ = didl_s;
			_tmp31_ = gupnp_media_collection_get_items (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp26_ = _tmp32_ == NULL;
			__g_list_free__g_object_unref0_0 (_tmp32_);
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			result = NULL;
			_g_free0 (title);
			_g_free0 (author);
			_g_object_unref0 (didl_s);
			contents = (g_free (contents), NULL);
			return result;
		}
		_tmp33_ = title;
		if (_tmp33_ == NULL) {
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			_tmp34_ = fallback_title;
			_tmp35_ = g_strdup (_tmp34_);
			_g_free0 (title);
			title = _tmp35_;
		}
		_tmp36_ = file;
		_tmp37_ = rygel_media_export_media_cache_get_id (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = parent;
		_tmp40_ = title;
		_tmp41_ = rygel_media_export_playlist_item_new (_tmp38_, _tmp39_, _tmp40_, RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp38_);
		item = _tmp42_;
		_tmp43_ = author;
		if (_tmp43_ != NULL) {
			RygelMediaExportPlaylistItem* _tmp44_ = NULL;
			const gchar* _tmp45_ = NULL;
			_tmp44_ = item;
			_tmp45_ = author;
			rygel_media_object_set_creator ((RygelMediaObject*) _tmp44_, _tmp45_);
		}
		_tmp46_ = item;
		rygel_media_file_item_set_dlna_profile ((RygelMediaFileItem*) _tmp46_, "DIDL_S");
		result = (RygelMediaFileItem*) item;
		_g_free0 (title);
		_g_free0 (author);
		_g_object_unref0 (didl_s);
		contents = (g_free (contents), NULL);
		return result;
	}
	goto __finally62;
	__catch62_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally62:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void _vala_SoupDate_free (SoupDate* self) {
	g_boxed_free (soup_date_get_type (), self);
}


RygelMediaObject* rygel_media_export_item_factory_create_from_variant (RygelMediaContainer* parent, GFile* file, GVariant* v, GError** error) {
	RygelMediaObject* result = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* upnp_class = NULL;
	GVariant* file_info = NULL;
	GVariant* dlna_profile = NULL;
	GVariant* info = NULL;
	GVariant* video_info = NULL;
	GVariant* audio_info = NULL;
	GVariant* meta_data = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp2_ = NULL;
	GVariantIter* _tmp3_ = NULL;
	gchar* id = NULL;
	GFile* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GVariantIter* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariantIter* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	GVariantIter* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	GVariant* _tmp19_ = NULL;
	GVariantIter* _tmp22_ = NULL;
	GVariant* _tmp23_ = NULL;
	GVariant* _tmp24_ = NULL;
	GVariant* _tmp25_ = NULL;
	GVariant* _tmp26_ = NULL;
	GVariantIter* _tmp29_ = NULL;
	GVariant* _tmp30_ = NULL;
	GVariant* _tmp31_ = NULL;
	GVariant* _tmp32_ = NULL;
	GVariant* _tmp33_ = NULL;
	GVariantIter* _tmp36_ = NULL;
	GVariant* _tmp37_ = NULL;
	GVariant* _tmp38_ = NULL;
	GVariant* _tmp39_ = NULL;
	GVariant* _tmp40_ = NULL;
	GVariantIter* _tmp43_ = NULL;
	GVariant* _tmp44_ = NULL;
	GVariant* _tmp45_ = NULL;
	GVariant* _tmp46_ = NULL;
	GVariant* _tmp47_ = NULL;
	RygelMediaFileItem* item = NULL;
	RygelMediaObject* object = NULL;
	GVariant* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	GQuark _tmp54_ = 0U;
	RygelMediaFileItem* _tmp102_ = NULL;
	GFile* _tmp103_ = NULL;
	gchar* _tmp104_ = NULL;
	gchar* _tmp105_ = NULL;
	GVariant* _tmp106_ = NULL;
	GVariant* _tmp109_ = NULL;
	gboolean _tmp112_ = FALSE;
	RygelMediaFileItem* _tmp113_ = NULL;
	const gchar* _tmp114_ = NULL;
	const gchar* _tmp115_ = NULL;
	gboolean strip_title = FALSE;
	GVariant* _tmp119_ = NULL;
	GVariant* _tmp135_ = NULL;
	GVariant* _tmp138_ = NULL;
	GVariant* _tmp141_ = NULL;
	RygelMediaFileItem* _tmp144_ = NULL;
	const gchar* _tmp145_ = NULL;
	const gchar* _tmp146_ = NULL;
	gboolean _tmp147_ = FALSE;
	RygelMediaFileItem* _tmp156_ = NULL;
	RygelMediaObject* _tmp157_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = v;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp1_, "(smvmvmvmvmvmv)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp2_ = v;
	_tmp3_ = g_variant_iter_new (_tmp2_);
	it = _tmp3_;
	_tmp4_ = file;
	_tmp5_ = rygel_media_export_media_cache_get_id (_tmp4_);
	id = _tmp5_;
	_tmp6_ = it;
	_tmp7_ = g_variant_iter_next_value (_tmp6_);
	_g_variant_unref0 (upnp_class);
	upnp_class = _tmp7_;
	_tmp8_ = it;
	_tmp9_ = g_variant_iter_next_value (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_variant_get_maybe (_tmp10_);
	_g_variant_unref0 (file_info);
	file_info = _tmp11_;
	_g_variant_unref0 (_tmp10_);
	_tmp12_ = file_info;
	if (_tmp12_ != NULL) {
		GVariant* _tmp13_ = NULL;
		GVariant* _tmp14_ = NULL;
		_tmp13_ = file_info;
		_tmp14_ = g_variant_get_variant (_tmp13_);
		_g_variant_unref0 (file_info);
		file_info = _tmp14_;
	}
	_tmp15_ = it;
	_tmp16_ = g_variant_iter_next_value (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_variant_get_maybe (_tmp17_);
	_g_variant_unref0 (dlna_profile);
	dlna_profile = _tmp18_;
	_g_variant_unref0 (_tmp17_);
	_tmp19_ = dlna_profile;
	if (_tmp19_ != NULL) {
		GVariant* _tmp20_ = NULL;
		GVariant* _tmp21_ = NULL;
		_tmp20_ = dlna_profile;
		_tmp21_ = g_variant_get_variant (_tmp20_);
		_g_variant_unref0 (dlna_profile);
		dlna_profile = _tmp21_;
	}
	_tmp22_ = it;
	_tmp23_ = g_variant_iter_next_value (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_variant_get_maybe (_tmp24_);
	_g_variant_unref0 (info);
	info = _tmp25_;
	_g_variant_unref0 (_tmp24_);
	_tmp26_ = info;
	if (_tmp26_ != NULL) {
		GVariant* _tmp27_ = NULL;
		GVariant* _tmp28_ = NULL;
		_tmp27_ = info;
		_tmp28_ = g_variant_get_variant (_tmp27_);
		_g_variant_unref0 (info);
		info = _tmp28_;
	}
	_tmp29_ = it;
	_tmp30_ = g_variant_iter_next_value (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_variant_get_maybe (_tmp31_);
	_g_variant_unref0 (audio_info);
	audio_info = _tmp32_;
	_g_variant_unref0 (_tmp31_);
	_tmp33_ = audio_info;
	if (_tmp33_ != NULL) {
		GVariant* _tmp34_ = NULL;
		GVariant* _tmp35_ = NULL;
		_tmp34_ = audio_info;
		_tmp35_ = g_variant_get_variant (_tmp34_);
		_g_variant_unref0 (audio_info);
		audio_info = _tmp35_;
	}
	_tmp36_ = it;
	_tmp37_ = g_variant_iter_next_value (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_variant_get_maybe (_tmp38_);
	_g_variant_unref0 (video_info);
	video_info = _tmp39_;
	_g_variant_unref0 (_tmp38_);
	_tmp40_ = video_info;
	if (_tmp40_ != NULL) {
		GVariant* _tmp41_ = NULL;
		GVariant* _tmp42_ = NULL;
		_tmp41_ = video_info;
		_tmp42_ = g_variant_get_variant (_tmp41_);
		_g_variant_unref0 (video_info);
		video_info = _tmp42_;
	}
	_tmp43_ = it;
	_tmp44_ = g_variant_iter_next_value (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_variant_get_maybe (_tmp45_);
	_g_variant_unref0 (meta_data);
	meta_data = _tmp46_;
	_g_variant_unref0 (_tmp45_);
	_tmp47_ = meta_data;
	if (_tmp47_ != NULL) {
		GVariant* _tmp48_ = NULL;
		GVariant* _tmp49_ = NULL;
		_tmp48_ = meta_data;
		_tmp49_ = g_variant_get_variant (_tmp48_);
		_g_variant_unref0 (meta_data);
		meta_data = _tmp49_;
	}
	item = NULL;
	object = NULL;
	_tmp50_ = upnp_class;
	_tmp51_ = g_variant_get_string (_tmp50_, NULL);
	_tmp52_ = _tmp51_;
	_tmp54_ = (NULL == _tmp52_) ? 0 : g_quark_from_string (_tmp52_);
	if (_tmp54_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp55_ = NULL;
				RygelMediaContainer* _tmp56_ = NULL;
				RygelMediaExportPhotoItem* _tmp57_ = NULL;
				_tmp55_ = id;
				_tmp56_ = parent;
				_tmp57_ = rygel_media_export_photo_item_new (_tmp55_, _tmp56_, "", RYGEL_PHOTO_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaFileItem*) _tmp57_;
				break;
			}
		}
	} else if (_tmp54_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp58_ = NULL;
				RygelMediaContainer* _tmp59_ = NULL;
				RygelMediaExportVideoItem* _tmp60_ = NULL;
				_tmp58_ = id;
				_tmp59_ = parent;
				_tmp60_ = rygel_media_export_video_item_new (_tmp58_, _tmp59_, "", RYGEL_VIDEO_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaFileItem*) _tmp60_;
				break;
			}
		}
	} else if (_tmp54_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp61_ = NULL;
				RygelMediaContainer* _tmp62_ = NULL;
				RygelMediaExportMusicItem* _tmp63_ = NULL;
				_tmp61_ = id;
				_tmp62_ = parent;
				_tmp63_ = rygel_media_export_music_item_new (_tmp61_, _tmp62_, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaFileItem*) _tmp63_;
				break;
			}
		}
	} else if (_tmp54_ == g_quark_from_string (RYGEL_PLAYLIST_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				GFile* _tmp64_ = NULL;
				RygelMediaContainer* _tmp65_ = NULL;
				RygelMediaFileItem* _tmp66_ = NULL;
				RygelMediaFileItem* _tmp67_ = NULL;
				_tmp64_ = file;
				_tmp65_ = parent;
				_tmp66_ = rygel_media_export_item_factory_create_playlist_item (_tmp64_, _tmp65_, "");
				_g_object_unref0 (item);
				item = _tmp66_;
				_tmp67_ = item;
				if (_tmp67_ == NULL) {
					result = NULL;
					_g_object_unref0 (object);
					_g_object_unref0 (item);
					_g_free0 (id);
					_g_variant_iter_free0 (it);
					_g_variant_unref0 (meta_data);
					_g_variant_unref0 (audio_info);
					_g_variant_unref0 (video_info);
					_g_variant_unref0 (info);
					_g_variant_unref0 (dlna_profile);
					_g_variant_unref0 (file_info);
					_g_variant_unref0 (upnp_class);
					return result;
				}
				break;
			}
		}
	} else if (_tmp54_ == g_quark_from_string (RYGEL_MEDIA_EXPORT_DVD_CONTAINER_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				RygelMediaExportDVDContainer* container = NULL;
				const gchar* _tmp68_ = NULL;
				gchar* _tmp69_ = NULL;
				gchar* _tmp70_ = NULL;
				RygelMediaContainer* _tmp71_ = NULL;
				GFile* _tmp72_ = NULL;
				gchar* _tmp73_ = NULL;
				gchar* _tmp74_ = NULL;
				RygelMediaExportDVDContainer* _tmp75_ = NULL;
				RygelMediaExportDVDContainer* _tmp76_ = NULL;
				RygelMediaExportDVDContainer* _tmp77_ = NULL;
				RygelMediaObject* _tmp78_ = NULL;
				GVariant* _tmp79_ = NULL;
				RygelMediaExportDVDContainer* _tmp88_ = NULL;
				gint _tmp89_ = 0;
				gint _tmp90_ = 0;
				_tmp68_ = id;
				_tmp69_ = g_strconcat ("dvd:", _tmp68_, NULL);
				_tmp70_ = _tmp69_;
				_tmp71_ = parent;
				_tmp72_ = file;
				_tmp73_ = g_file_get_path (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = rygel_media_export_dvd_container_new (_tmp70_, _tmp71_, "", _tmp74_);
				_tmp76_ = _tmp75_;
				_g_free0 (_tmp74_);
				_g_free0 (_tmp70_);
				container = _tmp76_;
				_tmp77_ = container;
				_tmp78_ = _g_object_ref0 ((RygelMediaObject*) _tmp77_);
				_g_object_unref0 (object);
				object = _tmp78_;
				_tmp79_ = file_info;
				if (_tmp79_ != NULL) {
					RygelMediaObject* _tmp80_ = NULL;
					GVariant* _tmp81_ = NULL;
					RygelMediaObject* _tmp82_ = NULL;
					RygelMediaObject* _tmp83_ = NULL;
					const gchar* _tmp84_ = NULL;
					const gchar* _tmp85_ = NULL;
					gchar* _tmp86_ = NULL;
					gchar* _tmp87_ = NULL;
					_tmp80_ = object;
					_tmp81_ = file_info;
					rygel_media_export_item_factory_apply_file_info (_tmp80_, _tmp81_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (container);
						_g_object_unref0 (object);
						_g_object_unref0 (item);
						_g_free0 (id);
						_g_variant_iter_free0 (it);
						_g_variant_unref0 (meta_data);
						_g_variant_unref0 (audio_info);
						_g_variant_unref0 (video_info);
						_g_variant_unref0 (info);
						_g_variant_unref0 (dlna_profile);
						_g_variant_unref0 (file_info);
						_g_variant_unref0 (upnp_class);
						return NULL;
					}
					_tmp82_ = object;
					_tmp83_ = object;
					_tmp84_ = rygel_media_object_get_title (_tmp83_);
					_tmp85_ = _tmp84_;
					_tmp86_ = rygel_media_export_item_factory_strip_invalid_entities (_tmp85_);
					_tmp87_ = _tmp86_;
					rygel_media_object_set_title (_tmp82_, _tmp87_);
					_g_free0 (_tmp87_);
				}
				_tmp88_ = container;
				_tmp89_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _tmp88_);
				_tmp90_ = _tmp89_;
				if (_tmp90_ == 1) {
					RygelMediaExportDVDContainer* _tmp91_ = NULL;
					RygelMediaObjects* _tmp92_ = NULL;
					gpointer _tmp93_ = NULL;
					RygelMediaObject* _tmp94_ = NULL;
					RygelMediaExportDVDContainer* _tmp95_ = NULL;
					const gchar* _tmp96_ = NULL;
					const gchar* _tmp97_ = NULL;
					RygelMediaObject* _tmp98_ = NULL;
					RygelMediaExportDVDContainer* _tmp99_ = NULL;
					guint64 _tmp100_ = 0ULL;
					guint64 _tmp101_ = 0ULL;
					_tmp91_ = container;
					_tmp92_ = ((RygelSimpleContainer*) _tmp91_)->children;
					_tmp93_ = gee_abstract_list_get ((GeeAbstractList*) _tmp92_, 0);
					_g_object_unref0 (object);
					object = (RygelMediaObject*) _tmp93_;
					_tmp94_ = object;
					_tmp95_ = container;
					_tmp96_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp95_);
					_tmp97_ = _tmp96_;
					rygel_media_object_set_title (_tmp94_, _tmp97_);
					_tmp98_ = object;
					_tmp99_ = container;
					_tmp100_ = rygel_media_object_get_modified ((RygelMediaObject*) _tmp99_);
					_tmp101_ = _tmp100_;
					rygel_media_object_set_modified (_tmp98_, _tmp101_);
				}
				result = object;
				_g_object_unref0 (container);
				_g_object_unref0 (item);
				_g_free0 (id);
				_g_variant_iter_free0 (it);
				_g_variant_unref0 (meta_data);
				_g_variant_unref0 (audio_info);
				_g_variant_unref0 (video_info);
				_g_variant_unref0 (info);
				_g_variant_unref0 (dlna_profile);
				_g_variant_unref0 (file_info);
				_g_variant_unref0 (upnp_class);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				_g_object_unref0 (object);
				_g_object_unref0 (item);
				_g_free0 (id);
				_g_variant_iter_free0 (it);
				_g_variant_unref0 (meta_data);
				_g_variant_unref0 (audio_info);
				_g_variant_unref0 (video_info);
				_g_variant_unref0 (info);
				_g_variant_unref0 (dlna_profile);
				_g_variant_unref0 (file_info);
				_g_variant_unref0 (upnp_class);
				return result;
			}
		}
	}
	_tmp102_ = item;
	_tmp103_ = file;
	_tmp104_ = g_file_get_uri (_tmp103_);
	_tmp105_ = _tmp104_;
	rygel_media_object_add_uri ((RygelMediaObject*) _tmp102_, _tmp105_);
	_g_free0 (_tmp105_);
	_tmp106_ = dlna_profile;
	if (_tmp106_ != NULL) {
		RygelMediaFileItem* _tmp107_ = NULL;
		GVariant* _tmp108_ = NULL;
		_tmp107_ = item;
		_tmp108_ = dlna_profile;
		rygel_media_export_item_factory_apply_dlna_profile (_tmp107_, _tmp108_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			_g_object_unref0 (item);
			_g_free0 (id);
			_g_variant_iter_free0 (it);
			_g_variant_unref0 (meta_data);
			_g_variant_unref0 (audio_info);
			_g_variant_unref0 (video_info);
			_g_variant_unref0 (info);
			_g_variant_unref0 (dlna_profile);
			_g_variant_unref0 (file_info);
			_g_variant_unref0 (upnp_class);
			return NULL;
		}
	}
	_tmp109_ = info;
	if (_tmp109_ != NULL) {
		RygelMediaFileItem* _tmp110_ = NULL;
		GVariant* _tmp111_ = NULL;
		_tmp110_ = item;
		_tmp111_ = info;
		rygel_media_export_item_factory_apply_info (_tmp110_, _tmp111_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			_g_object_unref0 (item);
			_g_free0 (id);
			_g_variant_iter_free0 (it);
			_g_variant_unref0 (meta_data);
			_g_variant_unref0 (audio_info);
			_g_variant_unref0 (video_info);
			_g_variant_unref0 (info);
			_g_variant_unref0 (dlna_profile);
			_g_variant_unref0 (file_info);
			_g_variant_unref0 (upnp_class);
			return NULL;
		}
	}
	_tmp113_ = item;
	_tmp114_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp113_);
	_tmp115_ = _tmp114_;
	if (_tmp115_ == NULL) {
		_tmp112_ = TRUE;
	} else {
		RygelMediaFileItem* _tmp116_ = NULL;
		const gchar* _tmp117_ = NULL;
		const gchar* _tmp118_ = NULL;
		_tmp116_ = item;
		_tmp117_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp116_);
		_tmp118_ = _tmp117_;
		_tmp112_ = g_strcmp0 (_tmp118_, "") == 0;
	}
	strip_title = _tmp112_;
	_tmp119_ = file_info;
	if (_tmp119_ != NULL) {
		RygelMediaFileItem* _tmp120_ = NULL;
		GVariant* _tmp121_ = NULL;
		RygelMediaFileItem* _tmp122_ = NULL;
		const gchar* _tmp123_ = NULL;
		const gchar* _tmp124_ = NULL;
		gboolean _tmp128_ = FALSE;
		_tmp120_ = item;
		_tmp121_ = file_info;
		rygel_media_export_item_factory_apply_file_info ((RygelMediaObject*) _tmp120_, _tmp121_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			_g_object_unref0 (item);
			_g_free0 (id);
			_g_variant_iter_free0 (it);
			_g_variant_unref0 (meta_data);
			_g_variant_unref0 (audio_info);
			_g_variant_unref0 (video_info);
			_g_variant_unref0 (info);
			_g_variant_unref0 (dlna_profile);
			_g_variant_unref0 (file_info);
			_g_variant_unref0 (upnp_class);
			return NULL;
		}
		_tmp122_ = item;
		_tmp123_ = rygel_media_file_item_get_mime_type (_tmp122_);
		_tmp124_ = _tmp123_;
		if (g_strcmp0 (_tmp124_, "video/x-msvideo") == 0) {
			RygelMediaFileItem* _tmp125_ = NULL;
			RygelMediaFileItem* _tmp126_ = NULL;
			GVariant* _tmp127_ = NULL;
			_tmp125_ = item;
			rygel_media_object_set_title ((RygelMediaObject*) _tmp125_, "");
			strip_title = TRUE;
			_tmp126_ = item;
			_tmp127_ = file_info;
			rygel_media_export_item_factory_apply_file_info ((RygelMediaObject*) _tmp126_, _tmp127_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (object);
				_g_object_unref0 (item);
				_g_free0 (id);
				_g_variant_iter_free0 (it);
				_g_variant_unref0 (meta_data);
				_g_variant_unref0 (audio_info);
				_g_variant_unref0 (video_info);
				_g_variant_unref0 (info);
				_g_variant_unref0 (dlna_profile);
				_g_variant_unref0 (file_info);
				_g_variant_unref0 (upnp_class);
				return NULL;
			}
		}
		_tmp128_ = strip_title;
		if (_tmp128_) {
			RygelMediaFileItem* _tmp129_ = NULL;
			RygelMediaFileItem* _tmp130_ = NULL;
			const gchar* _tmp131_ = NULL;
			const gchar* _tmp132_ = NULL;
			gchar* _tmp133_ = NULL;
			gchar* _tmp134_ = NULL;
			_tmp129_ = item;
			_tmp130_ = item;
			_tmp131_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp133_ = rygel_media_export_item_factory_strip_invalid_entities (_tmp132_);
			_tmp134_ = _tmp133_;
			rygel_media_object_set_title ((RygelMediaObject*) _tmp129_, _tmp134_);
			_g_free0 (_tmp134_);
		}
	}
	_tmp135_ = audio_info;
	if (_tmp135_ != NULL) {
		RygelMediaFileItem* _tmp136_ = NULL;
		GVariant* _tmp137_ = NULL;
		_tmp136_ = item;
		_tmp137_ = audio_info;
		rygel_media_export_item_factory_apply_audio_info (_tmp136_, _tmp137_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			_g_object_unref0 (item);
			_g_free0 (id);
			_g_variant_iter_free0 (it);
			_g_variant_unref0 (meta_data);
			_g_variant_unref0 (audio_info);
			_g_variant_unref0 (video_info);
			_g_variant_unref0 (info);
			_g_variant_unref0 (dlna_profile);
			_g_variant_unref0 (file_info);
			_g_variant_unref0 (upnp_class);
			return NULL;
		}
	}
	_tmp138_ = video_info;
	if (_tmp138_ != NULL) {
		RygelMediaFileItem* _tmp139_ = NULL;
		GVariant* _tmp140_ = NULL;
		_tmp139_ = item;
		_tmp140_ = video_info;
		rygel_media_export_item_factory_apply_video_info (_tmp139_, _tmp140_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			_g_object_unref0 (item);
			_g_free0 (id);
			_g_variant_iter_free0 (it);
			_g_variant_unref0 (meta_data);
			_g_variant_unref0 (audio_info);
			_g_variant_unref0 (video_info);
			_g_variant_unref0 (info);
			_g_variant_unref0 (dlna_profile);
			_g_variant_unref0 (file_info);
			_g_variant_unref0 (upnp_class);
			return NULL;
		}
	}
	_tmp141_ = meta_data;
	if (_tmp141_ != NULL) {
		RygelMediaFileItem* _tmp142_ = NULL;
		GVariant* _tmp143_ = NULL;
		_tmp142_ = item;
		_tmp143_ = meta_data;
		rygel_media_export_item_factory_apply_meta_data (_tmp142_, _tmp143_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			_g_object_unref0 (item);
			_g_free0 (id);
			_g_variant_iter_free0 (it);
			_g_variant_unref0 (meta_data);
			_g_variant_unref0 (audio_info);
			_g_variant_unref0 (video_info);
			_g_variant_unref0 (info);
			_g_variant_unref0 (dlna_profile);
			_g_variant_unref0 (file_info);
			_g_variant_unref0 (upnp_class);
			return NULL;
		}
	}
	_tmp144_ = item;
	_tmp145_ = rygel_media_object_get_date ((RygelMediaObject*) _tmp144_);
	_tmp146_ = _tmp145_;
	_tmp147_ = string_contains (_tmp146_, "T");
	if (_tmp147_) {
		SoupDate* date = NULL;
		RygelMediaFileItem* _tmp148_ = NULL;
		const gchar* _tmp149_ = NULL;
		const gchar* _tmp150_ = NULL;
		SoupDate* _tmp151_ = NULL;
		RygelMediaFileItem* _tmp152_ = NULL;
		SoupDate* _tmp153_ = NULL;
		gchar* _tmp154_ = NULL;
		gchar* _tmp155_ = NULL;
		_tmp148_ = item;
		_tmp149_ = rygel_media_object_get_date ((RygelMediaObject*) _tmp148_);
		_tmp150_ = _tmp149_;
		_tmp151_ = soup_date_new_from_string (_tmp150_);
		date = _tmp151_;
		_tmp152_ = item;
		_tmp153_ = date;
		_tmp154_ = soup_date_to_string (_tmp153_, SOUP_DATE_ISO8601_FULL);
		_tmp155_ = _tmp154_;
		rygel_media_object_set_date ((RygelMediaObject*) _tmp152_, _tmp155_);
		_g_free0 (_tmp155_);
		__vala_SoupDate_free0 (date);
	}
	_tmp156_ = item;
	_tmp157_ = _g_object_ref0 ((RygelMediaObject*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp156_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp156_) : NULL));
	result = _tmp157_;
	_g_object_unref0 (object);
	_g_object_unref0 (item);
	_g_free0 (id);
	_g_variant_iter_free0 (it);
	_g_variant_unref0 (meta_data);
	_g_variant_unref0 (audio_info);
	_g_variant_unref0 (video_info);
	_g_variant_unref0 (info);
	_g_variant_unref0 (dlna_profile);
	_g_variant_unref0 (file_info);
	_g_variant_unref0 (upnp_class);
	return result;
}


void rygel_media_export_item_factory_apply_meta_data (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantIter* _tmp2_ = NULL;
	GVariant* val = NULL;
	GVariantIter* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	RygelMediaFileItem* _tmp12_ = NULL;
	GVariantIter* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	GVariant* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	gchar* album = NULL;
	gchar* _tmp21_ = NULL;
	GVariantIter* _tmp22_ = NULL;
	GVariant* _tmp23_ = NULL;
	GVariant* _tmp24_ = NULL;
	GVariant* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	GVariant* _tmp27_ = NULL;
	RygelMediaFileItem* _tmp30_ = NULL;
	gint32 disc = 0;
	GVariantIter* _tmp31_ = NULL;
	GVariant* _tmp32_ = NULL;
	GVariant* _tmp33_ = NULL;
	gint32 _tmp34_ = 0;
	gint32 _tmp35_ = 0;
	RygelMediaFileItem* _tmp36_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(msmsmsiii)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	it = _tmp2_;
	_tmp3_ = it;
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_get_maybe (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_variant_unref0 (_tmp5_);
	val = _tmp7_;
	_tmp9_ = val;
	if (_tmp9_ == NULL) {
		_g_free0 (_tmp8_);
		_tmp8_ = NULL;
	} else {
		GVariant* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp10_ = val;
		_tmp11_ = g_variant_dup_string (_tmp10_, NULL);
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp11_;
	}
	_tmp12_ = item;
	rygel_media_object_set_artist ((RygelMediaObject*) _tmp12_, _tmp8_);
	_tmp13_ = it;
	_tmp14_ = g_variant_iter_next_value (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_variant_get_maybe (_tmp15_);
	_g_variant_unref0 (val);
	val = _tmp16_;
	_g_variant_unref0 (_tmp15_);
	_tmp18_ = val;
	if (_tmp18_ == NULL) {
		_g_free0 (_tmp17_);
		_tmp17_ = NULL;
	} else {
		GVariant* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp19_ = val;
		_tmp20_ = g_variant_dup_string (_tmp19_, NULL);
		_g_free0 (_tmp17_);
		_tmp17_ = _tmp20_;
	}
	_tmp21_ = g_strdup (_tmp17_);
	album = _tmp21_;
	_tmp22_ = it;
	_tmp23_ = g_variant_iter_next_value (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_variant_get_maybe (_tmp24_);
	_g_variant_unref0 (val);
	val = _tmp25_;
	_g_variant_unref0 (_tmp24_);
	_tmp27_ = val;
	if (_tmp27_ == NULL) {
		_g_free0 (_tmp26_);
		_tmp26_ = NULL;
	} else {
		GVariant* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		_tmp28_ = val;
		_tmp29_ = g_variant_dup_string (_tmp28_, NULL);
		_g_free0 (_tmp26_);
		_tmp26_ = _tmp29_;
	}
	_tmp30_ = item;
	rygel_media_object_set_genre ((RygelMediaObject*) _tmp30_, _tmp26_);
	_tmp31_ = it;
	_tmp32_ = g_variant_iter_next_value (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_variant_get_int32 (_tmp33_);
	_tmp35_ = _tmp34_;
	_g_variant_unref0 (_tmp33_);
	disc = _tmp35_;
	_tmp36_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelAudioItem* audio_item = NULL;
		RygelMediaFileItem* _tmp37_ = NULL;
		RygelAudioItem* _tmp38_ = NULL;
		gint32 track_number = 0;
		GVariantIter* _tmp39_ = NULL;
		GVariant* _tmp40_ = NULL;
		GVariant* _tmp41_ = NULL;
		gint32 _tmp42_ = 0;
		gint32 _tmp43_ = 0;
		RygelAudioItem* _tmp44_ = NULL;
		GVariantIter* _tmp45_ = NULL;
		GVariant* _tmp46_ = NULL;
		GVariant* _tmp47_ = NULL;
		gint32 _tmp48_ = 0;
		RygelAudioItem* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		RygelMediaFileItem* _tmp51_ = NULL;
		_tmp37_ = item;
		_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp37_) : NULL);
		audio_item = _tmp38_;
		_tmp39_ = it;
		_tmp40_ = g_variant_iter_next_value (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_variant_get_int32 (_tmp41_);
		_tmp43_ = _tmp42_;
		_g_variant_unref0 (_tmp41_);
		track_number = _tmp43_;
		_tmp44_ = audio_item;
		_tmp45_ = it;
		_tmp46_ = g_variant_iter_next_value (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_variant_get_int32 (_tmp47_);
		rygel_audio_item_set_bitrate (_tmp44_, (gint) _tmp48_);
		_g_variant_unref0 (_tmp47_);
		_tmp49_ = audio_item;
		_tmp50_ = album;
		rygel_audio_item_set_album (_tmp49_, _tmp50_);
		_tmp51_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaFileItem* _tmp52_ = NULL;
			RygelMediaExportMusicItem* _tmp53_ = NULL;
			RygelMediaExportMusicItem* _tmp54_ = NULL;
			gint32 _tmp55_ = 0;
			RygelMediaExportMusicItem* _tmp56_ = NULL;
			gint32 _tmp57_ = 0;
			_tmp52_ = item;
			_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp52_) : NULL);
			music_item = _tmp53_;
			_tmp54_ = music_item;
			_tmp55_ = disc;
			_tmp54_->disc = (gint) _tmp55_;
			_tmp56_ = music_item;
			_tmp57_ = track_number;
			rygel_music_item_set_track_number ((RygelMusicItem*) _tmp56_, (gint) _tmp57_);
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	_g_free0 (_tmp26_);
	_g_free0 (album);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp8_);
	_g_variant_unref0 (val);
	_g_variant_iter_free0 (it);
}


void rygel_media_export_item_factory_apply_video_info (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	RygelMediaFileItem* _tmp1_ = NULL;
	RygelVisualItem* visual_item = NULL;
	RygelMediaFileItem* _tmp5_ = NULL;
	RygelVisualItem* _tmp6_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp7_ = NULL;
	GVariantIter* _tmp8_ = NULL;
	RygelVisualItem* _tmp9_ = NULL;
	GVariantIter* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	gint32 _tmp13_ = 0;
	RygelVisualItem* _tmp14_ = NULL;
	GVariantIter* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	gint32 _tmp18_ = 0;
	RygelVisualItem* _tmp19_ = NULL;
	GVariantIter* _tmp20_ = NULL;
	GVariant* _tmp21_ = NULL;
	GVariant* _tmp22_ = NULL;
	gint32 _tmp23_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(iii)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = item;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_VISUAL_ITEM)) {
		gchar* msg = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp2_ = g_strdup ("UPnP class does not match supplied meta data");
		msg = _tmp2_;
		_tmp3_ = msg;
		_tmp4_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR, RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_MISMATCH, _tmp3_);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return;
	}
	_tmp5_ = item;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp5_) : NULL);
	visual_item = _tmp6_;
	_tmp7_ = v;
	_tmp8_ = g_variant_iter_new (_tmp7_);
	it = _tmp8_;
	_tmp9_ = visual_item;
	_tmp10_ = it;
	_tmp11_ = g_variant_iter_next_value (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_get_int32 (_tmp12_);
	rygel_visual_item_set_width (_tmp9_, (gint) _tmp13_);
	_g_variant_unref0 (_tmp12_);
	_tmp14_ = visual_item;
	_tmp15_ = it;
	_tmp16_ = g_variant_iter_next_value (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_variant_get_int32 (_tmp17_);
	rygel_visual_item_set_height (_tmp14_, (gint) _tmp18_);
	_g_variant_unref0 (_tmp17_);
	_tmp19_ = visual_item;
	_tmp20_ = it;
	_tmp21_ = g_variant_iter_next_value (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_variant_get_int32 (_tmp22_);
	rygel_visual_item_set_color_depth (_tmp19_, (gint) _tmp23_);
	_g_variant_unref0 (_tmp22_);
	_g_variant_iter_free0 (it);
	_g_object_unref0 (visual_item);
}


void rygel_media_export_item_factory_apply_audio_info (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	RygelMediaFileItem* _tmp1_ = NULL;
	RygelAudioItem* audio_item = NULL;
	RygelMediaFileItem* _tmp5_ = NULL;
	RygelAudioItem* _tmp6_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp7_ = NULL;
	GVariantIter* _tmp8_ = NULL;
	RygelAudioItem* _tmp9_ = NULL;
	GVariantIter* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	gint32 _tmp13_ = 0;
	RygelAudioItem* _tmp14_ = NULL;
	GVariantIter* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	gint32 _tmp18_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(ii)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = item;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_AUDIO_ITEM)) {
		gchar* msg = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp2_ = g_strdup ("UPnP class does not match supplied meta data");
		msg = _tmp2_;
		_tmp3_ = msg;
		_tmp4_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR, RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_MISMATCH, _tmp3_);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return;
	}
	_tmp5_ = item;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp5_) : NULL);
	audio_item = _tmp6_;
	_tmp7_ = v;
	_tmp8_ = g_variant_iter_new (_tmp7_);
	it = _tmp8_;
	_tmp9_ = audio_item;
	_tmp10_ = it;
	_tmp11_ = g_variant_iter_next_value (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_get_int32 (_tmp12_);
	rygel_audio_item_set_channels (_tmp9_, (gint) _tmp13_);
	_g_variant_unref0 (_tmp12_);
	_tmp14_ = audio_item;
	_tmp15_ = it;
	_tmp16_ = g_variant_iter_next_value (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_variant_get_int32 (_tmp17_);
	rygel_audio_item_set_sample_freq (_tmp14_, (gint) _tmp18_);
	_g_variant_unref0 (_tmp17_);
	_g_variant_iter_free0 (it);
	_g_object_unref0 (audio_item);
}


void rygel_media_export_item_factory_apply_info (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantIter* _tmp2_ = NULL;
	GVariant* val = NULL;
	GVariantIter* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	GVariantIter* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	GVariant* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	RygelMediaFileItem* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(msmsi)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	it = _tmp2_;
	_tmp3_ = it;
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_get_maybe (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_variant_unref0 (_tmp5_);
	val = _tmp7_;
	_tmp8_ = val;
	if (_tmp8_ != NULL) {
		RygelMediaFileItem* _tmp9_ = NULL;
		GVariant* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp9_ = item;
		_tmp10_ = val;
		_tmp11_ = g_variant_dup_string (_tmp10_, NULL);
		_tmp12_ = _tmp11_;
		rygel_media_object_set_title ((RygelMediaObject*) _tmp9_, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = it;
	_tmp14_ = g_variant_iter_next_value (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_variant_get_maybe (_tmp15_);
	_g_variant_unref0 (val);
	val = _tmp16_;
	_g_variant_unref0 (_tmp15_);
	_tmp17_ = val;
	if (_tmp17_ != NULL) {
		RygelMediaFileItem* _tmp18_ = NULL;
		GVariant* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp18_ = item;
		_tmp19_ = val;
		_tmp20_ = g_variant_dup_string (_tmp19_, NULL);
		_tmp21_ = _tmp20_;
		rygel_media_object_set_date ((RygelMediaObject*) _tmp18_, _tmp21_);
		_g_free0 (_tmp21_);
	}
	_tmp22_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelMediaFileItem* _tmp23_ = NULL;
		GVariantIter* _tmp24_ = NULL;
		GVariant* _tmp25_ = NULL;
		GVariant* _tmp26_ = NULL;
		gint32 _tmp27_ = 0;
		_tmp23_ = item;
		_tmp24_ = it;
		_tmp25_ = g_variant_iter_next_value (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_variant_get_int32 (_tmp26_);
		rygel_audio_item_set_duration (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp23_) : NULL, (glong) _tmp27_);
		_g_variant_unref0 (_tmp26_);
	}
	_g_variant_unref0 (val);
	_g_variant_iter_free0 (it);
}


void rygel_media_export_item_factory_apply_dlna_profile (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantIter* _tmp2_ = NULL;
	RygelMediaFileItem* _tmp3_ = NULL;
	GVariantIter* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	RygelMediaFileItem* _tmp9_ = NULL;
	GVariantIter* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(ss)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	it = _tmp2_;
	_tmp3_ = item;
	_tmp4_ = it;
	_tmp5_ = g_variant_iter_next_value (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_variant_dup_string (_tmp6_, NULL);
	_tmp8_ = _tmp7_;
	rygel_media_file_item_set_dlna_profile (_tmp3_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_variant_unref0 (_tmp6_);
	_tmp9_ = item;
	_tmp10_ = it;
	_tmp11_ = g_variant_iter_next_value (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_dup_string (_tmp12_, NULL);
	_tmp14_ = _tmp13_;
	rygel_media_file_item_set_mime_type (_tmp9_, _tmp14_);
	_g_free0 (_tmp14_);
	_g_variant_unref0 (_tmp12_);
	_g_variant_iter_free0 (it);
}


void rygel_media_export_item_factory_apply_file_info (RygelMediaObject* object, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantIter* _tmp2_ = NULL;
	GVariant* display_name = NULL;
	GVariantIter* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	RygelMediaObject* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	RygelMediaObject* _tmp16_ = NULL;
	GVariantIter* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	GVariant* _tmp19_ = NULL;
	guint64 _tmp20_ = 0ULL;
	RygelMediaObject* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (object != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(stst)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	it = _tmp2_;
	_tmp3_ = it;
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
	display_name = _tmp4_;
	_tmp6_ = object;
	_tmp7_ = rygel_media_object_get_title (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		RygelMediaObject* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp9_ = object;
		_tmp10_ = rygel_media_object_get_title (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = g_strcmp0 (_tmp11_, "") == 0;
	}
	if (_tmp5_) {
		RygelMediaObject* _tmp12_ = NULL;
		GVariant* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp12_ = object;
		_tmp13_ = display_name;
		_tmp14_ = g_variant_dup_string (_tmp13_, NULL);
		_tmp15_ = _tmp14_;
		rygel_media_object_set_title (_tmp12_, _tmp15_);
		_g_free0 (_tmp15_);
	}
	_tmp16_ = object;
	_tmp17_ = it;
	_tmp18_ = g_variant_iter_next_value (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_variant_get_uint64 (_tmp19_);
	rygel_media_object_set_modified (_tmp16_, (guint64) ((gint64) _tmp20_));
	_g_variant_unref0 (_tmp19_);
	_tmp21_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		RygelMediaFileItem* item = NULL;
		RygelMediaObject* _tmp22_ = NULL;
		RygelMediaFileItem* _tmp23_ = NULL;
		GVariant* mime = NULL;
		GVariantIter* _tmp24_ = NULL;
		GVariant* _tmp25_ = NULL;
		RygelMediaFileItem* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		RygelMediaFileItem* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		RygelMediaFileItem* _tmp43_ = NULL;
		GVariantIter* _tmp44_ = NULL;
		GVariant* _tmp45_ = NULL;
		GVariant* _tmp46_ = NULL;
		guint64 _tmp47_ = 0ULL;
		_tmp22_ = object;
		_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp22_) : NULL);
		item = _tmp23_;
		_tmp24_ = it;
		_tmp25_ = g_variant_iter_next_value (_tmp24_);
		mime = _tmp25_;
		_tmp26_ = item;
		_tmp27_ = rygel_media_file_item_get_mime_type (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ == NULL) {
			RygelMediaFileItem* _tmp29_ = NULL;
			GVariant* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			_tmp29_ = item;
			_tmp30_ = mime;
			_tmp31_ = g_variant_dup_string (_tmp30_, NULL);
			_tmp32_ = _tmp31_;
			rygel_media_file_item_set_mime_type (_tmp29_, _tmp32_);
			_g_free0 (_tmp32_);
		}
		_tmp33_ = item;
		_tmp34_ = rygel_media_object_get_date ((RygelMediaObject*) _tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp35_ == NULL) {
			GTimeVal tv = {0};
			RygelMediaFileItem* _tmp36_ = NULL;
			guint64 _tmp37_ = 0ULL;
			guint64 _tmp38_ = 0ULL;
			GTimeVal _tmp39_ = {0};
			RygelMediaFileItem* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			_tmp36_ = item;
			_tmp37_ = rygel_media_object_get_modified ((RygelMediaObject*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_.tv_sec = (glong) _tmp38_;
			_tmp39_.tv_usec = (glong) 0;
			tv = _tmp39_;
			_tmp40_ = item;
			_tmp41_ = g_time_val_to_iso8601 (&tv);
			_tmp42_ = _tmp41_;
			rygel_media_object_set_date ((RygelMediaObject*) _tmp40_, _tmp42_);
			_g_free0 (_tmp42_);
		}
		_tmp43_ = item;
		_tmp44_ = it;
		_tmp45_ = g_variant_iter_next_value (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = g_variant_get_uint64 (_tmp46_);
		rygel_media_file_item_set_size (_tmp43_, (gint64) _tmp47_);
		_g_variant_unref0 (_tmp46_);
		_g_variant_unref0 (mime);
		_g_object_unref0 (item);
	}
	_g_variant_unref0 (display_name);
	_g_variant_iter_free0 (it);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void _vala_array_add1 (GRegex*** array, int* length, int* size, GRegex* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GRegex*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (GRegex*** array, int* length, int* size, GRegex* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GRegex*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (GRegex*** array, int* length, int* size, GRegex* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GRegex*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


gchar* rygel_media_export_item_factory_strip_invalid_entities (const gchar* original) {
	gchar* result = NULL;
	GRegex* _tmp0_ = NULL;
	gchar* p = NULL;
	const gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (original != NULL, NULL);
	_tmp0_ = rygel_media_export_item_factory_char_remove_regex;
	if (_tmp0_ == NULL) {
		{
			gchar* regex_string = NULL;
			gchar* _tmp1_ = NULL;
			GRegex* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			GRegex* _tmp6_ = NULL;
			GRegex* _tmp7_ = NULL;
			GRegex* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			GRegex* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			GRegex* _tmp14_ = NULL;
			GRegex* _tmp15_ = NULL;
			GRegex* _tmp16_ = NULL;
			GRegex* _tmp17_ = NULL;
			GRegex* _tmp18_ = NULL;
			GRegex* _tmp19_ = NULL;
			GRegex** _tmp20_ = NULL;
			_tmp1_ = g_regex_escape_string (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_INVALID_CHARS, -1);
			regex_string = _tmp1_;
			_tmp3_ = regex_string;
			_tmp4_ = g_strdup_printf ("[%s]", _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_regex_new (_tmp5_, 0, 0, &_inner_error_);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp5_);
			_tmp2_ = _tmp7_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (regex_string);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch63_g_regex_error;
				}
				_g_free0 (regex_string);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp8_ = _tmp2_;
			_tmp2_ = NULL;
			_g_regex_unref0 (rygel_media_export_item_factory_char_remove_regex);
			rygel_media_export_item_factory_char_remove_regex = _tmp8_;
			_tmp9_ = g_regex_escape_string (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_CONVERT_CHARS, -1);
			_g_free0 (regex_string);
			regex_string = _tmp9_;
			_tmp11_ = regex_string;
			_tmp12_ = g_strdup_printf ("[%s]", _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_regex_new (_tmp13_, 0, 0, &_inner_error_);
			_tmp15_ = _tmp14_;
			_g_free0 (_tmp13_);
			_tmp10_ = _tmp15_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_regex_unref0 (_tmp2_);
				_g_free0 (regex_string);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch63_g_regex_error;
				}
				_g_regex_unref0 (_tmp2_);
				_g_free0 (regex_string);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp16_ = _tmp10_;
			_tmp10_ = NULL;
			_g_regex_unref0 (rygel_media_export_item_factory_char_convert_regex);
			rygel_media_export_item_factory_char_convert_regex = _tmp16_;
			_tmp18_ = g_regex_new ("\\s+", 0, 0, &_inner_error_);
			_tmp17_ = _tmp18_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_regex_unref0 (_tmp10_);
				_g_regex_unref0 (_tmp2_);
				_g_free0 (regex_string);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch63_g_regex_error;
				}
				_g_regex_unref0 (_tmp10_);
				_g_regex_unref0 (_tmp2_);
				_g_free0 (regex_string);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp19_ = _tmp17_;
			_tmp17_ = NULL;
			_g_regex_unref0 (rygel_media_export_item_factory_space_compress_regex);
			rygel_media_export_item_factory_space_compress_regex = _tmp19_;
			_tmp20_ = g_new0 (GRegex*, 0 + 1);
			rygel_media_export_item_factory_block_regexes = (_vala_array_free (rygel_media_export_item_factory_block_regexes, rygel_media_export_item_factory_block_regexes_length1, (GDestroyNotify) g_regex_unref), NULL);
			rygel_media_export_item_factory_block_regexes = _tmp20_;
			rygel_media_export_item_factory_block_regexes_length1 = 0;
			_rygel_media_export_item_factory_block_regexes_size_ = rygel_media_export_item_factory_block_regexes_length1;
			{
				const gchar** block_collection = NULL;
				gint block_collection_length1 = 0;
				gint _block_collection_size_ = 0;
				gint block_it = 0;
				block_collection = RYGEL_MEDIA_EXPORT_ITEM_FACTORY_BLOCKS;
				block_collection_length1 = G_N_ELEMENTS (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_BLOCKS);
				for (block_it = 0; block_it < G_N_ELEMENTS (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_BLOCKS); block_it = block_it + 1) {
					const gchar* block = NULL;
					block = block_collection[block_it];
					{
						gchar* block_re = NULL;
						const gchar* _tmp21_ = NULL;
						gchar _tmp22_ = '\0';
						gchar* _tmp23_ = NULL;
						gchar* _tmp24_ = NULL;
						gchar* _tmp25_ = NULL;
						gchar* _tmp26_ = NULL;
						const gchar* _tmp27_ = NULL;
						gchar _tmp28_ = '\0';
						gchar* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
						gchar* _tmp32_ = NULL;
						const gchar* _tmp33_ = NULL;
						gchar _tmp34_ = '\0';
						gchar* _tmp35_ = NULL;
						gchar* _tmp36_ = NULL;
						gchar* _tmp37_ = NULL;
						gchar* _tmp38_ = NULL;
						gchar* _tmp39_ = NULL;
						gchar* _tmp40_ = NULL;
						GRegex* _tmp41_ = NULL;
						const gchar* _tmp42_ = NULL;
						GRegex* _tmp43_ = NULL;
						GRegex** _tmp44_ = NULL;
						gint _tmp44__length1 = 0;
						GRegex* _tmp45_ = NULL;
						_tmp21_ = block;
						_tmp22_ = string_get (_tmp21_, (glong) 0);
						_tmp23_ = g_strdup_printf ("%C", _tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = g_regex_escape_string (_tmp24_, -1);
						_tmp26_ = _tmp25_;
						_tmp27_ = block;
						_tmp28_ = string_get (_tmp27_, (glong) 1);
						_tmp29_ = g_strdup_printf ("%C", _tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = g_regex_escape_string (_tmp30_, -1);
						_tmp32_ = _tmp31_;
						_tmp33_ = block;
						_tmp34_ = string_get (_tmp33_, (glong) 1);
						_tmp35_ = g_strdup_printf ("%C", _tmp34_);
						_tmp36_ = _tmp35_;
						_tmp37_ = g_regex_escape_string (_tmp36_, -1);
						_tmp38_ = _tmp37_;
						_tmp39_ = g_strdup_printf (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_BLOCK_PATTERN, _tmp26_, _tmp32_, _tmp38_);
						_tmp40_ = _tmp39_;
						_g_free0 (_tmp38_);
						_g_free0 (_tmp36_);
						_g_free0 (_tmp32_);
						_g_free0 (_tmp30_);
						_g_free0 (_tmp26_);
						_g_free0 (_tmp24_);
						block_re = _tmp40_;
						_tmp42_ = block_re;
						_tmp43_ = g_regex_new (_tmp42_, 0, 0, &_inner_error_);
						_tmp41_ = _tmp43_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_free0 (block_re);
							_g_regex_unref0 (_tmp17_);
							_g_regex_unref0 (_tmp10_);
							_g_regex_unref0 (_tmp2_);
							_g_free0 (regex_string);
							if (_inner_error_->domain == G_REGEX_ERROR) {
								goto __catch63_g_regex_error;
							}
							_g_free0 (block_re);
							_g_regex_unref0 (_tmp17_);
							_g_regex_unref0 (_tmp10_);
							_g_regex_unref0 (_tmp2_);
							_g_free0 (regex_string);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_tmp44_ = rygel_media_export_item_factory_block_regexes;
						_tmp44__length1 = rygel_media_export_item_factory_block_regexes_length1;
						_tmp45_ = _tmp41_;
						_tmp41_ = NULL;
						_vala_array_add1 (&rygel_media_export_item_factory_block_regexes, &rygel_media_export_item_factory_block_regexes_length1, &_rygel_media_export_item_factory_block_regexes_size_, _tmp45_);
						_g_regex_unref0 (_tmp41_);
						_g_free0 (block_re);
					}
				}
			}
			{
				const gchar** blacklist_collection = NULL;
				gint blacklist_collection_length1 = 0;
				gint _blacklist_collection_size_ = 0;
				gint blacklist_it = 0;
				blacklist_collection = RYGEL_MEDIA_EXPORT_ITEM_FACTORY_BLACKLIST;
				blacklist_collection_length1 = G_N_ELEMENTS (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_BLACKLIST);
				for (blacklist_it = 0; blacklist_it < G_N_ELEMENTS (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_BLACKLIST); blacklist_it = blacklist_it + 1) {
					const gchar* blacklist = NULL;
					blacklist = blacklist_collection[blacklist_it];
					{
						GRegex* _tmp46_ = NULL;
						const gchar* _tmp47_ = NULL;
						gchar* _tmp48_ = NULL;
						gchar* _tmp49_ = NULL;
						GRegex* _tmp50_ = NULL;
						GRegex* _tmp51_ = NULL;
						GRegex** _tmp52_ = NULL;
						gint _tmp52__length1 = 0;
						GRegex* _tmp53_ = NULL;
						_tmp47_ = blacklist;
						_tmp48_ = g_regex_escape_string (_tmp47_, -1);
						_tmp49_ = _tmp48_;
						_tmp50_ = g_regex_new (_tmp49_, 0, 0, &_inner_error_);
						_tmp51_ = _tmp50_;
						_g_free0 (_tmp49_);
						_tmp46_ = _tmp51_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_regex_unref0 (_tmp17_);
							_g_regex_unref0 (_tmp10_);
							_g_regex_unref0 (_tmp2_);
							_g_free0 (regex_string);
							if (_inner_error_->domain == G_REGEX_ERROR) {
								goto __catch63_g_regex_error;
							}
							_g_regex_unref0 (_tmp17_);
							_g_regex_unref0 (_tmp10_);
							_g_regex_unref0 (_tmp2_);
							_g_free0 (regex_string);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_tmp52_ = rygel_media_export_item_factory_blacklist_regexes;
						_tmp52__length1 = rygel_media_export_item_factory_blacklist_regexes_length1;
						_tmp53_ = _tmp46_;
						_tmp46_ = NULL;
						_vala_array_add2 (&rygel_media_export_item_factory_blacklist_regexes, &rygel_media_export_item_factory_blacklist_regexes_length1, &_rygel_media_export_item_factory_blacklist_regexes_size_, _tmp53_);
						_g_regex_unref0 (_tmp46_);
					}
				}
			}
			{
				const gchar** suffix_collection = NULL;
				gint suffix_collection_length1 = 0;
				gint _suffix_collection_size_ = 0;
				gint suffix_it = 0;
				suffix_collection = RYGEL_MEDIA_EXPORT_ITEM_FACTORY_VIDEO_SUFFIXES;
				suffix_collection_length1 = G_N_ELEMENTS (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_VIDEO_SUFFIXES);
				for (suffix_it = 0; suffix_it < G_N_ELEMENTS (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_VIDEO_SUFFIXES); suffix_it = suffix_it + 1) {
					const gchar* suffix = NULL;
					suffix = suffix_collection[suffix_it];
					{
						GRegex* _tmp54_ = NULL;
						const gchar* _tmp55_ = NULL;
						gchar* _tmp56_ = NULL;
						gchar* _tmp57_ = NULL;
						GRegex* _tmp58_ = NULL;
						GRegex* _tmp59_ = NULL;
						GRegex** _tmp60_ = NULL;
						gint _tmp60__length1 = 0;
						GRegex* _tmp61_ = NULL;
						_tmp55_ = suffix;
						_tmp56_ = g_regex_escape_string (_tmp55_, -1);
						_tmp57_ = _tmp56_;
						_tmp58_ = g_regex_new (_tmp57_, 0, 0, &_inner_error_);
						_tmp59_ = _tmp58_;
						_g_free0 (_tmp57_);
						_tmp54_ = _tmp59_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_regex_unref0 (_tmp17_);
							_g_regex_unref0 (_tmp10_);
							_g_regex_unref0 (_tmp2_);
							_g_free0 (regex_string);
							if (_inner_error_->domain == G_REGEX_ERROR) {
								goto __catch63_g_regex_error;
							}
							_g_regex_unref0 (_tmp17_);
							_g_regex_unref0 (_tmp10_);
							_g_regex_unref0 (_tmp2_);
							_g_free0 (regex_string);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_tmp60_ = rygel_media_export_item_factory_video_suffix_regexes;
						_tmp60__length1 = rygel_media_export_item_factory_video_suffix_regexes_length1;
						_tmp61_ = _tmp54_;
						_tmp54_ = NULL;
						_vala_array_add3 (&rygel_media_export_item_factory_video_suffix_regexes, &rygel_media_export_item_factory_video_suffix_regexes_length1, &_rygel_media_export_item_factory_video_suffix_regexes_size_, _tmp61_);
						_g_regex_unref0 (_tmp54_);
					}
				}
			}
			_g_regex_unref0 (_tmp17_);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp2_);
			_g_free0 (regex_string);
		}
		goto __finally63;
		__catch63_g_regex_error:
		{
			GError* _error_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			g_assert_not_reached ();
			_g_error_free0 (_error_);
		}
		__finally63:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp62_ = original;
	_tmp63_ = g_strdup (_tmp62_);
	_g_free0 (p);
	p = _tmp63_;
	{
		GRegex** _tmp64_ = NULL;
		gint _tmp64__length1 = 0;
		GRegex** _tmp71_ = NULL;
		gint _tmp71__length1 = 0;
		GRegex** _tmp78_ = NULL;
		gint _tmp78__length1 = 0;
		gchar* _tmp85_ = NULL;
		GRegex* _tmp86_ = NULL;
		const gchar* _tmp87_ = NULL;
		gchar* _tmp88_ = NULL;
		gchar* _tmp89_ = NULL;
		gchar* _tmp90_ = NULL;
		GRegex* _tmp91_ = NULL;
		const gchar* _tmp92_ = NULL;
		gchar* _tmp93_ = NULL;
		gchar* _tmp94_ = NULL;
		gchar* _tmp95_ = NULL;
		GRegex* _tmp96_ = NULL;
		const gchar* _tmp97_ = NULL;
		gchar* _tmp98_ = NULL;
		gchar* _tmp99_ = NULL;
		const gchar* _tmp100_ = NULL;
		_tmp64_ = rygel_media_export_item_factory_blacklist_regexes;
		_tmp64__length1 = rygel_media_export_item_factory_blacklist_regexes_length1;
		{
			GRegex** re_collection = NULL;
			gint re_collection_length1 = 0;
			gint _re_collection_size_ = 0;
			gint re_it = 0;
			re_collection = _tmp64_;
			re_collection_length1 = _tmp64__length1;
			for (re_it = 0; re_it < _tmp64__length1; re_it = re_it + 1) {
				GRegex* _tmp65_ = NULL;
				GRegex* re = NULL;
				_tmp65_ = _g_regex_ref0 (re_collection[re_it]);
				re = _tmp65_;
				{
					gchar* _tmp66_ = NULL;
					GRegex* _tmp67_ = NULL;
					const gchar* _tmp68_ = NULL;
					gchar* _tmp69_ = NULL;
					gchar* _tmp70_ = NULL;
					_tmp67_ = re;
					_tmp68_ = p;
					_tmp69_ = g_regex_replace_literal (_tmp67_, _tmp68_, (gssize) -1, 0, "", 0, &_inner_error_);
					_tmp66_ = _tmp69_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_regex_unref0 (re);
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch64_g_regex_error;
						}
						_g_regex_unref0 (re);
						_g_free0 (p);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp70_ = _tmp66_;
					_tmp66_ = NULL;
					_g_free0 (p);
					p = _tmp70_;
					_g_free0 (_tmp66_);
					_g_regex_unref0 (re);
				}
			}
		}
		_tmp71_ = rygel_media_export_item_factory_video_suffix_regexes;
		_tmp71__length1 = rygel_media_export_item_factory_video_suffix_regexes_length1;
		{
			GRegex** re_collection = NULL;
			gint re_collection_length1 = 0;
			gint _re_collection_size_ = 0;
			gint re_it = 0;
			re_collection = _tmp71_;
			re_collection_length1 = _tmp71__length1;
			for (re_it = 0; re_it < _tmp71__length1; re_it = re_it + 1) {
				GRegex* _tmp72_ = NULL;
				GRegex* re = NULL;
				_tmp72_ = _g_regex_ref0 (re_collection[re_it]);
				re = _tmp72_;
				{
					gchar* _tmp73_ = NULL;
					GRegex* _tmp74_ = NULL;
					const gchar* _tmp75_ = NULL;
					gchar* _tmp76_ = NULL;
					gchar* _tmp77_ = NULL;
					_tmp74_ = re;
					_tmp75_ = p;
					_tmp76_ = g_regex_replace_literal (_tmp74_, _tmp75_, (gssize) -1, 0, "", 0, &_inner_error_);
					_tmp73_ = _tmp76_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_regex_unref0 (re);
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch64_g_regex_error;
						}
						_g_regex_unref0 (re);
						_g_free0 (p);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp77_ = _tmp73_;
					_tmp73_ = NULL;
					_g_free0 (p);
					p = _tmp77_;
					_g_free0 (_tmp73_);
					_g_regex_unref0 (re);
				}
			}
		}
		_tmp78_ = rygel_media_export_item_factory_block_regexes;
		_tmp78__length1 = rygel_media_export_item_factory_block_regexes_length1;
		{
			GRegex** re_collection = NULL;
			gint re_collection_length1 = 0;
			gint _re_collection_size_ = 0;
			gint re_it = 0;
			re_collection = _tmp78_;
			re_collection_length1 = _tmp78__length1;
			for (re_it = 0; re_it < _tmp78__length1; re_it = re_it + 1) {
				GRegex* _tmp79_ = NULL;
				GRegex* re = NULL;
				_tmp79_ = _g_regex_ref0 (re_collection[re_it]);
				re = _tmp79_;
				{
					gchar* _tmp80_ = NULL;
					GRegex* _tmp81_ = NULL;
					const gchar* _tmp82_ = NULL;
					gchar* _tmp83_ = NULL;
					gchar* _tmp84_ = NULL;
					_tmp81_ = re;
					_tmp82_ = p;
					_tmp83_ = g_regex_replace_literal (_tmp81_, _tmp82_, (gssize) -1, 0, "", 0, &_inner_error_);
					_tmp80_ = _tmp83_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_regex_unref0 (re);
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch64_g_regex_error;
						}
						_g_regex_unref0 (re);
						_g_free0 (p);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp84_ = _tmp80_;
					_tmp80_ = NULL;
					_g_free0 (p);
					p = _tmp84_;
					_g_free0 (_tmp80_);
					_g_regex_unref0 (re);
				}
			}
		}
		_tmp86_ = rygel_media_export_item_factory_char_remove_regex;
		_tmp87_ = p;
		_tmp88_ = g_regex_replace_literal (_tmp86_, _tmp87_, (gssize) -1, 0, "", 0, &_inner_error_);
		_tmp85_ = _tmp88_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch64_g_regex_error;
			}
			_g_free0 (p);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp89_ = _tmp85_;
		_tmp85_ = NULL;
		_g_free0 (p);
		p = _tmp89_;
		_tmp91_ = rygel_media_export_item_factory_char_convert_regex;
		_tmp92_ = p;
		_tmp93_ = g_regex_replace_literal (_tmp91_, _tmp92_, (gssize) -1, 0, " ", 0, &_inner_error_);
		_tmp90_ = _tmp93_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp85_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch64_g_regex_error;
			}
			_g_free0 (_tmp85_);
			_g_free0 (p);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp94_ = _tmp90_;
		_tmp90_ = NULL;
		_g_free0 (p);
		p = _tmp94_;
		_tmp96_ = rygel_media_export_item_factory_space_compress_regex;
		_tmp97_ = p;
		_tmp98_ = g_regex_replace_literal (_tmp96_, _tmp97_, (gssize) -1, 0, " ", 0, &_inner_error_);
		_tmp95_ = _tmp98_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp90_);
			_g_free0 (_tmp85_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch64_g_regex_error;
			}
			_g_free0 (_tmp90_);
			_g_free0 (_tmp85_);
			_g_free0 (p);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp99_ = _tmp95_;
		_tmp95_ = NULL;
		_g_free0 (p);
		p = _tmp99_;
		_tmp100_ = p;
		g_strstrip (_tmp100_);
		result = p;
		_g_free0 (_tmp95_);
		_g_free0 (_tmp90_);
		_g_free0 (_tmp85_);
		return result;
	}
	goto __finally64;
	__catch64_g_regex_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally64:
	_g_free0 (p);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



