/* chess-engine.c generated by valac 0.30.0, the Vala compiler
 * generated from chess-engine.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2014 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include "libchess.h"
#include "portability.h"
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <string.h>
#include <stdlib.h>


#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*do_undo) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
};

struct _ChessEnginePrivate {
	gchar* binary;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	guint delay_seconds;
	guint pending_move_source_id;
	GPid pid;
	gint stdin_fd;
	gint stderr_fd;
	GIOChannel* stdout_channel;
	guint child_watch_id;
	guint stdout_watch_id;
	gboolean started;
	gboolean _ready;
};


static gpointer chess_engine_parent_class = NULL;

GType chess_engine_get_type (void) G_GNUC_CONST;
#define CHESS_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_ENGINE, ChessEnginePrivate))
enum  {
	CHESS_ENGINE_DUMMY_PROPERTY,
	CHESS_ENGINE_READY
};
void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1);
static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1);
ChessEngine* chess_engine_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds);
static gchar** _vala_array_dup19 (gchar** self, int length);
gboolean chess_engine_start (ChessEngine* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void ___lambda4_ (ChessEngine* self);
static void ____lambda4__gspawn_child_setup_func (gpointer self);
static void chess_engine_engine_stopped_cb (ChessEngine* self, GPid pid);
static void _chess_engine_engine_stopped_cb_gchild_watch_func (GPid pid, gint status, gpointer self);
static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition);
static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
void chess_engine_stop (ChessEngine* self, gboolean kill_engine);
void chess_engine_start_game (ChessEngine* self);
static void chess_engine_real_start_game (ChessEngine* self);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_do_undo (ChessEngine* self);
static void chess_engine_real_do_undo (ChessEngine* self);
void chess_engine_request_move (ChessEngine* self);
static void chess_engine_real_request_move (ChessEngine* self);
void chess_engine_move (ChessEngine* self);
static gboolean __lambda5_ (ChessEngine* self);
static gboolean ___lambda5__gsource_func (gpointer self);
void chess_engine_undo (ChessEngine* self);
void chess_engine_write (ChessEngine* self, gchar* data, int data_length1);
void chess_engine_write_line (ChessEngine* self, const gchar* line);
gboolean chess_engine_get_ready (ChessEngine* self);
void chess_engine_set_ready (ChessEngine* self, gboolean value);
static void chess_engine_finalize (GObject* obj);
static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1) {
}


void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1) {
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_GET_CLASS (self)->process_input (self, data, data_length1);
#line 133 "chess-engine.c"
}


static gchar** _vala_array_dup19 (gchar** self, int length) {
	gchar** result;
	int i;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	result = g_new0 (gchar*, length + 1);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	for (i = 0; i < length; i++) {
#line 144 "chess-engine.c"
		gchar* _tmp0_ = NULL;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp0_ = g_strdup (self[i]);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		result[i] = _tmp0_;
#line 150 "chess-engine.c"
	}
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return result;
#line 154 "chess-engine.c"
}


ChessEngine* chess_engine_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds) {
	ChessEngine * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint _tmp4_ = 0U;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_val_if_fail (binary != NULL, NULL);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self = (ChessEngine*) g_object_new (object_type, NULL);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = binary;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_g_free0 (self->priv->binary);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->binary = _tmp1_;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp2_ = args;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp2__length1 = args_length1;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup19 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp3__length1 = _tmp2__length1;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->args = _tmp3_;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->args_length1 = _tmp3__length1;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->_args_size_ = self->priv->args_length1;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp4_ = delay_seconds;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->delay_seconds = _tmp4_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return self;
#line 201 "chess-engine.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if ((*length) == (*size)) {
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 212 "chess-engine.c"
	}
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	(*array)[(*length)++] = value;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	(*array)[*length] = NULL;
#line 218 "chess-engine.c"
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if ((*length) == (*size)) {
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 229 "chess-engine.c"
	}
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	(*array)[(*length)++] = value;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	(*array)[*length] = NULL;
#line 235 "chess-engine.c"
}


static void ___lambda4_ (ChessEngine* self) {
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	maybe_kill_orphan_engine ();
#line 242 "chess-engine.c"
}


static void ____lambda4__gspawn_child_setup_func (gpointer self) {
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	___lambda4_ ((ChessEngine*) self);
#line 249 "chess-engine.c"
}


static void _chess_engine_engine_stopped_cb_gchild_watch_func (GPid pid, gint status, gpointer self) {
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	chess_engine_engine_stopped_cb ((ChessEngine*) self, pid);
#line 256 "chess-engine.c"
}


static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = chess_engine_read_cb ((ChessEngine*) self, source, condition);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return result;
#line 265 "chess-engine.c"
}


gboolean chess_engine_start (ChessEngine* self) {
	gboolean result = FALSE;
	GPid _tmp0_ = 0;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gchar** argv = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gint stdout_fd = 0;
	GPid _tmp22_ = 0;
	guint _tmp23_ = 0U;
	gint _tmp24_ = 0;
	GIOChannel* _tmp25_ = NULL;
	GIOChannel* _tmp29_ = NULL;
	GIOChannel* _tmp30_ = NULL;
	guint _tmp31_ = 0U;
	GError * _inner_error_ = NULL;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->pid;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_return_val_if_fail (_tmp0_ == ((GPid) 0), "pid == 0", FALSE);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp1_ = self->priv->child_watch_id;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_return_val_if_fail (_tmp1_ == ((guint) 0), "child_watch_id == 0", FALSE);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp2_ = self->priv->stdout_watch_id;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_return_val_if_fail (_tmp2_ == ((guint) 0), "stdout_watch_id == 0", FALSE);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp3_ = self->priv->stdin_fd;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_return_val_if_fail (_tmp3_ == -1, "stdin_fd == -1", FALSE);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp4_ = self->priv->stderr_fd;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_return_val_if_fail (_tmp4_ == -1, "stderr_fd == -1", FALSE);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp5_ = self->priv->started;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_return_val_if_fail (!_tmp5_, "!started", FALSE);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp6_ = self->priv->binary;
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp8_ = g_new0 (gchar*, 1 + 1);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp8_[0] = _tmp7_;
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	argv = _tmp8_;
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	argv_length1 = 1;
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_argv_size_ = argv_length1;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp9_ = self->priv->args;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp9__length1 = self->priv->args_length1;
#line 340 "chess-engine.c"
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		arg_collection = _tmp9_;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		arg_collection_length1 = _tmp9__length1;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		for (arg_it = 0; arg_it < _tmp9__length1; arg_it = arg_it + 1) {
#line 352 "chess-engine.c"
			gchar* _tmp10_ = NULL;
			gchar* arg = NULL;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp10_ = g_strdup (arg_collection[arg_it]);
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			arg = _tmp10_;
#line 359 "chess-engine.c"
			{
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				_tmp11_ = argv;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				_tmp11__length1 = argv_length1;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				_tmp12_ = arg;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				_tmp13_ = g_strdup (_tmp12_);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				_vala_array_add1 (&argv, &argv_length1, &_argv_size_, _tmp13_);
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				_g_free0 (arg);
#line 377 "chess-engine.c"
			}
		}
	}
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp14_ = argv;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp14__length1 = argv_length1;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_array_add2 (&argv, &argv_length1, &_argv_size_, NULL);
#line 387 "chess-engine.c"
	{
		gchar** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		GPid _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp15_ = argv;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp15__length1 = argv_length1;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_spawn_async_with_pipes (NULL, _tmp15_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, ____lambda4__gspawn_child_setup_func, self, &_tmp16_, &_tmp17_, &_tmp18_, &_tmp19_, &_inner_error_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		self->priv->pid = _tmp16_;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		self->priv->stdin_fd = _tmp17_;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		stdout_fd = _tmp18_;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		self->priv->stderr_fd = _tmp19_;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 413 "chess-engine.c"
				goto __catch10_g_spawn_error;
			}
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_clear_error (&_inner_error_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			return FALSE;
#line 424 "chess-engine.c"
		}
	}
	goto __finally10;
	__catch10_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		e = _inner_error_;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_inner_error_ = NULL;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp20_ = e;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp21_ = _tmp20_->message;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:89: Failed to execute chess engine: %s\n", _tmp21_);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		result = FALSE;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_g_error_free0 (e);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return result;
#line 451 "chess-engine.c"
	}
	__finally10:
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_clear_error (&_inner_error_);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return FALSE;
#line 464 "chess-engine.c"
	}
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp22_ = self->priv->pid;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp23_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp22_, _chess_engine_engine_stopped_cb_gchild_watch_func, g_object_ref (self), g_object_unref);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->child_watch_id = _tmp23_;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp24_ = stdout_fd;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp25_ = g_io_channel_unix_new (_tmp24_);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_g_io_channel_unref0 (self->priv->stdout_channel);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->stdout_channel = _tmp25_;
#line 480 "chess-engine.c"
	{
		GIOChannel* _tmp26_ = NULL;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp26_ = self->priv->stdout_channel;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_io_channel_set_flags (_tmp26_, G_IO_FLAG_NONBLOCK, &_inner_error_);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
#line 491 "chess-engine.c"
				goto __catch11_g_io_channel_error;
			}
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_clear_error (&_inner_error_);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			return FALSE;
#line 502 "chess-engine.c"
		}
	}
	goto __finally11;
	__catch11_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		e = _inner_error_;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_inner_error_ = NULL;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp27_ = e;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp28_ = _tmp27_->message;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:102: Failed to set input from chess engine to non-bl" \
"ocking: %s", _tmp28_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_g_error_free0 (e);
#line 523 "chess-engine.c"
	}
	__finally11:
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_clear_error (&_inner_error_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return FALSE;
#line 536 "chess-engine.c"
	}
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp29_ = self->priv->stdout_channel;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_io_channel_set_close_on_unref (_tmp29_, TRUE);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp30_ = self->priv->stdout_channel;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp31_ = g_io_add_watch (_tmp30_, G_IO_IN, _chess_engine_read_cb_gio_func, self);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->stdout_watch_id = _tmp31_;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->started = TRUE;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_emit_by_name (self, "starting");
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	result = TRUE;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return result;
#line 558 "chess-engine.c"
}


static void chess_engine_engine_stopped_cb (ChessEngine* self, GPid pid) {
	gboolean _tmp0_ = FALSE;
	GPid _tmp1_ = 0;
	GPid _tmp2_ = 0;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->started;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_return_if_fail (_tmp0_, "started");
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp1_ = pid;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp2_ = self->priv->pid;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_return_if_fail (_tmp1_ == _tmp2_, "pid == this.pid");
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	chess_engine_stop (self, FALSE);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_emit_by_name (self, "stopped-unexpectedly");
#line 582 "chess-engine.c"
}


static void chess_engine_real_start_game (ChessEngine* self) {
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_critical ("Type `%s' does not implement abstract method `chess_engine_start_game'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return;
#line 591 "chess-engine.c"
}


void chess_engine_start_game (ChessEngine* self) {
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_GET_CLASS (self)->start_game (self);
#line 600 "chess-engine.c"
}


static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move) {
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_critical ("Type `%s' does not implement abstract method `chess_engine_report_move'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return;
#line 609 "chess-engine.c"
}


void chess_engine_report_move (ChessEngine* self, ChessMove* move) {
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_GET_CLASS (self)->report_move (self, move);
#line 618 "chess-engine.c"
}


static void chess_engine_real_do_undo (ChessEngine* self) {
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_critical ("Type `%s' does not implement abstract method `chess_engine_do_undo'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return;
#line 627 "chess-engine.c"
}


void chess_engine_do_undo (ChessEngine* self) {
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_GET_CLASS (self)->do_undo (self);
#line 636 "chess-engine.c"
}


static void chess_engine_real_request_move (ChessEngine* self) {
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_critical ("Type `%s' does not implement abstract method `chess_engine_request_move'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return;
#line 645 "chess-engine.c"
}


void chess_engine_request_move (ChessEngine* self) {
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_GET_CLASS (self)->request_move (self);
#line 654 "chess-engine.c"
}


static gboolean __lambda5_ (ChessEngine* self) {
	gboolean result = FALSE;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->pending_move_source_id = (guint) 0;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	chess_engine_request_move (self);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	result = G_SOURCE_REMOVE;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return result;
#line 668 "chess-engine.c"
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ ((ChessEngine*) self);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return result;
#line 677 "chess-engine.c"
}


void chess_engine_move (ChessEngine* self) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->delay_seconds;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp1_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _tmp0_, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->pending_move_source_id = _tmp1_;
#line 692 "chess-engine.c"
}


void chess_engine_undo (ChessEngine* self) {
	guint _tmp0_ = 0U;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->pending_move_source_id;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 704 "chess-engine.c"
		guint _tmp1_ = 0U;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp1_ = self->priv->pending_move_source_id;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_source_remove (_tmp1_);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		self->priv->pending_move_source_id = (guint) 0;
#line 712 "chess-engine.c"
	}
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	chess_engine_do_undo (self);
#line 716 "chess-engine.c"
}


void chess_engine_stop (ChessEngine* self, gboolean kill_engine) {
	gboolean _tmp0_ = FALSE;
	GIOChannel* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	GPid _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	guint _tmp9_ = 0U;
	gboolean _tmp10_ = FALSE;
	guint _tmp11_ = 0U;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	guint _tmp24_ = 0U;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	GPid _tmp31_ = 0;
	GError * _inner_error_ = NULL;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->started;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp1_ = self->priv->stdout_channel;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_return_if_fail ((!_tmp0_) || (_tmp1_ != NULL), "!started || stdout_channel != null");
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp2_ = self->priv->started;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp3_ = self->priv->stdin_fd;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_return_if_fail ((!_tmp2_) || (_tmp3_ != -1), "!started || stdin_fd != -1");
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp4_ = self->priv->started;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp5_ = self->priv->stderr_fd;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_return_if_fail ((!_tmp4_) || (_tmp5_ != -1), "!started || stderr_fd != -1");
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp6_ = self->priv->started;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp7_ = self->priv->pid;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_return_if_fail ((!_tmp6_) || (_tmp7_ != ((GPid) 0)), "!started || pid != 0");
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp8_ = self->priv->started;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp9_ = self->priv->child_watch_id;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_return_if_fail ((!_tmp8_) || (_tmp9_ != ((guint) 0)), "!started || child_watch_id != 0");
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp10_ = self->priv->started;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (!_tmp10_) {
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return;
#line 780 "chess-engine.c"
	}
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->started = FALSE;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp11_ = self->priv->stdout_watch_id;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp11_ != ((guint) 0)) {
#line 788 "chess-engine.c"
		guint _tmp12_ = 0U;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp12_ = self->priv->stdout_watch_id;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_source_remove (_tmp12_);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		self->priv->stdout_watch_id = (guint) 0;
#line 796 "chess-engine.c"
	}
	{
		GIOChannel* _tmp13_ = NULL;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp13_ = self->priv->stdout_channel;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_io_channel_shutdown (_tmp13_, FALSE, &_inner_error_);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
#line 808 "chess-engine.c"
				goto __catch12_g_io_channel_error;
			}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_clear_error (&_inner_error_);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			return;
#line 817 "chess-engine.c"
		}
	}
	goto __finally12;
	__catch12_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		e = _inner_error_;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_inner_error_ = NULL;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp14_ = e;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp15_ = _tmp14_->message;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:172: Failed to close channel to engine's stdout: %s", _tmp15_);
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_g_error_free0 (e);
#line 838 "chess-engine.c"
	}
	__finally12:
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_clear_error (&_inner_error_);
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return;
#line 849 "chess-engine.c"
	}
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_g_io_channel_unref0 (self->priv->stdout_channel);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->stdout_channel = NULL;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp16_ = self->priv->stdin_fd;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp17_ = close (_tmp16_);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp17_ == -1) {
#line 861 "chess-engine.c"
		gint _tmp18_ = 0;
		const gchar* _tmp19_ = NULL;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp18_ = errno;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp19_ = g_strerror (_tmp18_);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:177: Failed to close pipe to engine's stdin: %s", _tmp19_);
#line 870 "chess-engine.c"
	}
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->stdin_fd = -1;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp20_ = self->priv->stderr_fd;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp21_ = close (_tmp20_);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp21_ == -1) {
#line 880 "chess-engine.c"
		gint _tmp22_ = 0;
		const gchar* _tmp23_ = NULL;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp22_ = errno;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp23_ = g_strerror (_tmp22_);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:181: Failed to close pipe to engine's stderr: %s", _tmp23_);
#line 889 "chess-engine.c"
	}
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->stderr_fd = -1;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp24_ = self->priv->child_watch_id;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_source_remove (_tmp24_);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->child_watch_id = (guint) 0;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp26_ = kill_engine;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp26_) {
#line 903 "chess-engine.c"
		GPid _tmp27_ = 0;
		gint _tmp28_ = 0;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp27_ = self->priv->pid;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp28_ = kill ((pid_t) _tmp27_, SIGTERM);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp25_ = _tmp28_ == -1;
#line 912 "chess-engine.c"
	} else {
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp25_ = FALSE;
#line 916 "chess-engine.c"
	}
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp25_) {
#line 920 "chess-engine.c"
		gint _tmp29_ = 0;
		const gchar* _tmp30_ = NULL;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp29_ = errno;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp30_ = g_strerror (_tmp29_);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:188: Failed to kill engine: %s", _tmp30_);
#line 929 "chess-engine.c"
	}
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp31_ = self->priv->pid;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_spawn_close_pid (_tmp31_);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->pid = (GPid) 0;
#line 937 "chess-engine.c"
}


static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	gchar* buf = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	gsize n_read = 0UL;
	GIOStatus status = 0;
	gchar* _tmp1_ = NULL;
	GIOStatus _tmp11_ = 0;
	GIOStatus _tmp12_ = 0;
	GError * _inner_error_ = NULL;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_val_if_fail (source != NULL, FALSE);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->stdout_watch_id;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_return_val_if_fail (_tmp0_ != ((guint) 0), "stdout_watch_id != 0", FALSE);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp1_ = g_new0 (gchar, 1024);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	buf = (g_free (buf), NULL);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	buf = _tmp1_;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	buf_length1 = 1024;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_buf_size_ = buf_length1;
#line 971 "chess-engine.c"
	{
		GIOStatus _tmp2_ = 0;
		GIOChannel* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gsize _tmp5_ = 0UL;
		GIOStatus _tmp6_ = 0;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp3_ = source;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp4_ = buf;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp4__length1 = buf_length1;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp6_ = g_io_channel_read_chars (_tmp3_, _tmp4_, _tmp4__length1, &_tmp5_, &_inner_error_);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		n_read = _tmp5_;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp2_ = _tmp6_;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			if (_inner_error_->domain == G_CONVERT_ERROR) {
#line 995 "chess-engine.c"
				goto __catch13_g_convert_error;
			}
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
#line 1000 "chess-engine.c"
				goto __catch13_g_io_channel_error;
			}
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			buf = (g_free (buf), NULL);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_clear_error (&_inner_error_);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			return FALSE;
#line 1011 "chess-engine.c"
		}
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		status = _tmp2_;
#line 1015 "chess-engine.c"
	}
	goto __finally13;
	__catch13_g_convert_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		e = _inner_error_;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_inner_error_ = NULL;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp7_ = e;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp8_ = _tmp7_->message;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:207: Failed to read from engine: %s", _tmp8_);
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		self->priv->stdout_watch_id = (guint) 0;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		result = FALSE;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_g_error_free0 (e);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		buf = (g_free (buf), NULL);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return result;
#line 1043 "chess-engine.c"
	}
	goto __finally13;
	__catch13_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		e = _inner_error_;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_inner_error_ = NULL;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp9_ = e;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp10_ = _tmp9_->message;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:213: Failed to read from engine: %s", _tmp10_);
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		self->priv->stdout_watch_id = (guint) 0;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		result = FALSE;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_g_error_free0 (e);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		buf = (g_free (buf), NULL);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return result;
#line 1071 "chess-engine.c"
	}
	__finally13:
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		buf = (g_free (buf), NULL);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_clear_error (&_inner_error_);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return FALSE;
#line 1084 "chess-engine.c"
	}
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp11_ = status;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp11_ == G_IO_STATUS_EOF) {
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_debug ("chess-engine.vala:220: EOF");
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		self->priv->stdout_watch_id = (guint) 0;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		result = FALSE;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		buf = (g_free (buf), NULL);
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return result;
#line 1100 "chess-engine.c"
	}
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp12_ = status;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp12_ == G_IO_STATUS_NORMAL) {
#line 1106 "chess-engine.c"
		gsize _tmp13_ = 0UL;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp13_ = n_read;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp14_ = (gint) _tmp13_;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		buf = g_renew (gchar, buf, (gint) _tmp13_);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		(_tmp14_ > buf_length1) ? memset (buf + buf_length1, 0, sizeof (gchar) * (_tmp14_ - buf_length1)) : NULL;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		buf_length1 = _tmp14_;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_buf_size_ = _tmp14_;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp15_ = buf;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp15__length1 = buf_length1;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		chess_engine_process_input (self, _tmp15_, _tmp15__length1);
#line 1129 "chess-engine.c"
	}
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	result = TRUE;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	buf = (g_free (buf), NULL);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return result;
#line 1137 "chess-engine.c"
}


void chess_engine_write (ChessEngine* self, gchar* data, int data_length1) {
	gsize offset = 0UL;
	gsize n_written = 0UL;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	offset = (gsize) 0;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	n_written = (gsize) 0;
#line 1150 "chess-engine.c"
	{
		gboolean _tmp0_ = FALSE;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp0_ = TRUE;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		while (TRUE) {
#line 1157 "chess-engine.c"
			gint _tmp5_ = 0;
			gchar* _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			gsize _tmp7_ = 0UL;
			gchar* _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			gsize _tmp9_ = 0UL;
			gssize _tmp10_ = 0L;
			gsize _tmp11_ = 0UL;
			gsize _tmp12_ = 0UL;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			if (!_tmp0_) {
#line 1170 "chess-engine.c"
				gboolean _tmp1_ = FALSE;
				gsize _tmp2_ = 0UL;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				_tmp2_ = n_written;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				if (_tmp2_ > ((gsize) 0)) {
#line 1177 "chess-engine.c"
					gsize _tmp3_ = 0UL;
					gchar* _tmp4_ = NULL;
					gint _tmp4__length1 = 0;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
					_tmp3_ = offset;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
					_tmp4_ = data;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
					_tmp4__length1 = data_length1;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
					_tmp1_ = _tmp3_ < ((gsize) _tmp4__length1);
#line 1189 "chess-engine.c"
				} else {
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
					_tmp1_ = FALSE;
#line 1193 "chess-engine.c"
				}
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				if (!_tmp1_) {
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
					break;
#line 1199 "chess-engine.c"
				}
			}
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp0_ = FALSE;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp5_ = self->priv->stdin_fd;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp6_ = data;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp6__length1 = data_length1;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp7_ = offset;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp8_ = data;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp8__length1 = data_length1;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp9_ = offset;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp10_ = write (_tmp5_, &_tmp6_[_tmp7_], _tmp8__length1 - _tmp9_);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			n_written = (gsize) _tmp10_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp11_ = offset;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp12_ = n_written;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			offset = _tmp11_ + _tmp12_;
#line 1228 "chess-engine.c"
		}
	}
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 1307 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1308 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1308 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1308 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1308 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1308 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1308 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1309 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1309 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1310 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1310 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1310 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1310 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1310 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1311 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1311 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1311 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1311 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 1285 "chess-engine.c"
	}
#line 1311 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1311 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 1291 "chess-engine.c"
}


void chess_engine_write_line (ChessEngine* self, const gchar* line) {
	gchar* l = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* d = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gint d_length1 = 0;
	gint _d_size_ = 0;
	gchar* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (line != NULL);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = line;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp1_ = g_strconcat (_tmp0_, "\n", NULL);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	l = _tmp1_;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp2_ = line;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_debug ("chess-engine.vala:248: Writing line to engine: '%s'", _tmp2_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp3_ = l;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp5_ = string_to_utf8 (_tmp3_, &_tmp4_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	d = _tmp5_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	d_length1 = _tmp4_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_d_size_ = d_length1;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp6_ = d;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp6__length1 = d_length1;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp6_ != NULL) {
#line 1338 "chess-engine.c"
		gchar* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp7_ = d;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp7__length1 = d_length1;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		chess_engine_write (self, _tmp7_, _tmp7__length1);
#line 1347 "chess-engine.c"
	}
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	d = (g_free (d), NULL);
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_g_free0 (l);
#line 1353 "chess-engine.c"
}


gboolean chess_engine_get_ready (ChessEngine* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->_ready;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	result = _tmp0_;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return result;
#line 1368 "chess-engine.c"
}


void chess_engine_set_ready (ChessEngine* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = value;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->_ready = _tmp0_;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_emit_by_name (self, "ready-changed");
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_object_notify ((GObject *) self, "ready");
#line 1384 "chess-engine.c"
}


static void chess_engine_class_init (ChessEngineClass * klass) {
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	chess_engine_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_type_class_add_private (klass, sizeof (ChessEnginePrivate));
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	((ChessEngineClass *) klass)->process_input = chess_engine_real_process_input;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	((ChessEngineClass *) klass)->start_game = chess_engine_real_start_game;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	((ChessEngineClass *) klass)->report_move = chess_engine_real_report_move;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	((ChessEngineClass *) klass)->do_undo = chess_engine_real_do_undo;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	((ChessEngineClass *) klass)->request_move = chess_engine_real_request_move;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_engine_get_property;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_engine_set_property;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_engine_finalize;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_ENGINE_READY, g_param_spec_boolean ("ready", "ready", "ready", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("starting", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("ready_changed", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("moved", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("resigned", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("stopped_unexpectedly", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("error", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("claim_draw", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("offer_draw", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1427 "chess-engine.c"
}


static void chess_engine_instance_init (ChessEngine * self) {
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv = CHESS_ENGINE_GET_PRIVATE (self);
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->pid = (GPid) 0;
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->stdin_fd = -1;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->stderr_fd = -1;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->child_watch_id = (guint) 0;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->stdout_watch_id = (guint) 0;
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->started = FALSE;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->_ready = FALSE;
#line 1448 "chess-engine.c"
}


static void chess_engine_finalize (GObject* obj) {
	ChessEngine * self;
	gboolean _tmp0_ = FALSE;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_ENGINE, ChessEngine);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->started;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_assert (!_tmp0_, "!started");
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_g_free0 (self->priv->binary);
#line 16 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_g_io_channel_unref0 (self->priv->stdout_channel);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	G_OBJECT_CLASS (chess_engine_parent_class)->finalize (obj);
#line 1469 "chess-engine.c"
}


GType chess_engine_get_type (void) {
	static volatile gsize chess_engine_type_id__volatile = 0;
	if (g_once_init_enter (&chess_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngine), 0, (GInstanceInitFunc) chess_engine_instance_init, NULL };
		GType chess_engine_type_id;
		chess_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessEngine", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&chess_engine_type_id__volatile, chess_engine_type_id);
	}
	return chess_engine_type_id__volatile;
}


static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_ENGINE, ChessEngine);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	switch (property_id) {
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		case CHESS_ENGINE_READY:
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_value_set_boolean (value, chess_engine_get_ready (self));
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		break;
#line 1496 "chess-engine.c"
		default:
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		break;
#line 1502 "chess-engine.c"
	}
}


static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_ENGINE, ChessEngine);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	switch (property_id) {
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		case CHESS_ENGINE_READY:
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		chess_engine_set_ready (self, g_value_get_boolean (value));
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		break;
#line 1518 "chess-engine.c"
		default:
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		break;
#line 1524 "chess-engine.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



