/* rygel-acl.c generated by valac 0.28.0, the Vala compiler
 * generated from rygel-acl.vala, do not modify */

/*
 * Copyright (C) 2014 Jens Georg <mail@jensge.org>
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_ACL (rygel_acl_get_type ())
#define RYGEL_ACL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ACL, RygelAcl))
#define RYGEL_ACL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ACL, RygelAclClass))
#define RYGEL_IS_ACL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ACL))
#define RYGEL_IS_ACL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ACL))
#define RYGEL_ACL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ACL, RygelAclClass))

typedef struct _RygelAcl RygelAcl;
typedef struct _RygelAclClass RygelAclClass;
typedef struct _RygelAclPrivate RygelAclPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelAclIsAllowedAsyncData RygelAclIsAllowedAsyncData;

struct _RygelAcl {
	GObject parent_instance;
	RygelAclPrivate * priv;
};

struct _RygelAclClass {
	GObjectClass parent_class;
};

struct _RygelAclPrivate {
	RygelDBusAclProvider* provider;
	RygelConfiguration* configuration;
	gboolean fallback_policy;
};

struct _Block1Data {
	int _ref_count_;
	RygelAcl* self;
	gpointer _async_data_;
};

struct _RygelAclIsAllowedAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelAcl* self;
	GUPnPDevice* device;
	GUPnPService* service;
	gchar* path;
	gchar* address;
	gchar* agent;
	GCancellable* cancellable;
	gboolean result;
	Block1Data* _data1_;
	RygelDBusAclProvider* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	GUPnPDevice* _tmp3_;
	GUPnPDevice* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GHashTable* device_hash;
	GHashFunc _tmp11_;
	GEqualFunc _tmp12_;
	GHashTable* _tmp13_;
	GUPnPDevice* _tmp14_;
	GHashTable* _tmp15_;
	gchar* _tmp16_;
	GUPnPDevice* _tmp17_;
	gchar* _tmp18_;
	GHashTable* _tmp19_;
	gchar* _tmp20_;
	GUPnPDevice* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	GHashTable* _tmp25_;
	gchar* _tmp26_;
	GUPnPDevice* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	GHashTable* service_hash;
	GHashFunc _tmp31_;
	GEqualFunc _tmp32_;
	GHashTable* _tmp33_;
	GUPnPService* _tmp34_;
	GHashTable* _tmp35_;
	gchar* _tmp36_;
	GUPnPService* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gboolean allowed;
	RygelDBusAclProvider* _tmp41_;
	GHashTable* _tmp42_;
	GHashTable* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gboolean _tmp47_;
	GError* _error_;
	const gchar* _tmp48_;
	GError* _tmp49_;
	const gchar* _tmp50_;
	GError * _inner_error_;
};


static gpointer rygel_acl_parent_class = NULL;
static GUPnPAclInterface* rygel_acl_gupnp_acl_parent_iface = NULL;

GType rygel_acl_get_type (void) G_GNUC_CONST;
#define RYGEL_ACL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ACL, RygelAclPrivate))
enum  {
	RYGEL_ACL_DUMMY_PROPERTY
};
static void rygel_acl_real_constructed (GObject* base);
static void rygel_acl_on_name_appeared (RygelAcl* self, GDBusConnection* connection, const gchar* name, const gchar* name_owner);
static void _rygel_acl_on_name_appeared_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self);
static void rygel_acl_on_name_vanished (RygelAcl* self, GDBusConnection* connection, const gchar* name);
static void _rygel_acl_on_name_vanished_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void rygel_acl_update_fallback_policy (RygelAcl* self);
static void __lambda4_ (RygelAcl* self, const gchar* s, const gchar* k);
static void ___lambda4__rygel_configuration_setting_changed (RygelConfiguration* _sender, const gchar* section, const gchar* key, gpointer self);
static gboolean rygel_acl_real_can_sync (GUPnPAcl* base);
static gboolean rygel_acl_real_is_allowed (GUPnPAcl* base, GUPnPDevice* device, GUPnPService* service, const gchar* path, const gchar* address, const gchar* agent);
static void rygel_acl_real_is_allowed_async_data_free (gpointer _data);
static void rygel_acl_real_is_allowed_async (GUPnPAcl* base, GUPnPDevice* device, GUPnPService* service, const gchar* path, const gchar* address, const gchar* agent, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_acl_real_is_allowed_async_co (RygelAclIsAllowedAsyncData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ___lambda5_ (Block1Data* _data1_);
static gboolean ____lambda5__gsource_func (gpointer self);
static void _g_free0_ (gpointer var);
static void rygel_acl_is_allowed_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RygelAcl* rygel_acl_new (void);
RygelAcl* rygel_acl_construct (GType object_type);
static void rygel_acl_finalize (GObject* obj);


static void _rygel_acl_on_name_appeared_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self) {
	rygel_acl_on_name_appeared ((RygelAcl*) self, connection, name, name_owner);
}


static void _rygel_acl_on_name_vanished_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	rygel_acl_on_name_vanished ((RygelAcl*) self, connection, name);
}


static void __lambda4_ (RygelAcl* self, const gchar* s, const gchar* k) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (s != NULL);
	g_return_if_fail (k != NULL);
	_tmp1_ = s;
	if (g_strcmp0 (_tmp1_, "general") == 0) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = k;
		_tmp0_ = g_strcmp0 (_tmp2_, "acl-fallback-policy") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		rygel_acl_update_fallback_policy (self);
	}
}


static void ___lambda4__rygel_configuration_setting_changed (RygelConfiguration* _sender, const gchar* section, const gchar* key, gpointer self) {
	__lambda4_ ((RygelAcl*) self, section, key);
}


static void rygel_acl_real_constructed (GObject* base) {
	RygelAcl * self;
	RygelMetaConfig* _tmp0_ = NULL;
	RygelConfiguration* _tmp1_ = NULL;
	self = (RygelAcl*) base;
	G_OBJECT_CLASS (rygel_acl_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, RYGEL_DBUS_ACL_PROVIDER_SERVICE_NAME, G_BUS_NAME_WATCHER_FLAGS_AUTO_START, (GClosure*) ((_rygel_acl_on_name_appeared_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _rygel_acl_on_name_appeared_gbus_name_appeared_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((_rygel_acl_on_name_vanished_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _rygel_acl_on_name_vanished_gbus_name_vanished_callback, g_object_ref (self), g_object_unref)));
	_tmp0_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->configuration);
	self->priv->configuration = (RygelConfiguration*) _tmp0_;
	self->priv->fallback_policy = TRUE;
	rygel_acl_update_fallback_policy (self);
	_tmp1_ = self->priv->configuration;
	g_signal_connect_object (_tmp1_, "setting-changed", (GCallback) ___lambda4__rygel_configuration_setting_changed, self, 0);
}


/**
     * Whether this provider supports sync access.
     *
     * If we do not have a DBus provider (yet) there is no need to
     * artificially delay the fall-back policy answer.
     */
static gboolean rygel_acl_real_can_sync (GUPnPAcl* base) {
	RygelAcl * self;
	gboolean result = FALSE;
	RygelDBusAclProvider* _tmp0_ = NULL;
	self = (RygelAcl*) base;
	_tmp0_ = self->priv->provider;
	result = _tmp0_ == NULL;
	return result;
}


static gboolean rygel_acl_real_is_allowed (GUPnPAcl* base, GUPnPDevice* device, GUPnPService* service, const gchar* path, const gchar* address, const gchar* agent) {
	RygelAcl * self;
	gboolean result = FALSE;
	RygelDBusAclProvider* _tmp0_ = NULL;
	self = (RygelAcl*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (address != NULL, FALSE);
	_tmp0_ = self->priv->provider;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = self->priv->fallback_policy;
		result = _tmp1_;
		return result;
	} else {
		g_assert_not_reached ();
	}
}


static void rygel_acl_real_is_allowed_async_data_free (gpointer _data) {
	RygelAclIsAllowedAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->device);
	_g_object_unref0 (_data_->service);
	_g_free0 (_data_->path);
	_g_free0 (_data_->address);
	_g_free0 (_data_->agent);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelAclIsAllowedAsyncData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_acl_real_is_allowed_async (GUPnPAcl* base, GUPnPDevice* device, GUPnPService* service, const gchar* path, const gchar* address, const gchar* agent, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelAcl * self;
	RygelAclIsAllowedAsyncData* _data_;
	RygelAcl* _tmp0_ = NULL;
	GUPnPDevice* _tmp1_ = NULL;
	GUPnPDevice* _tmp2_ = NULL;
	GUPnPService* _tmp3_ = NULL;
	GUPnPService* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GCancellable* _tmp11_ = NULL;
	GCancellable* _tmp12_ = NULL;
	self = (RygelAcl*) base;
	_data_ = g_slice_new0 (RygelAclIsAllowedAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_acl_real_is_allowed_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_acl_real_is_allowed_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = device;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->device);
	_data_->device = _tmp2_;
	_tmp3_ = service;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->service);
	_data_->service = _tmp4_;
	_tmp5_ = path;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->path);
	_data_->path = _tmp6_;
	_tmp7_ = address;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (_data_->address);
	_data_->address = _tmp8_;
	_tmp9_ = agent;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (_data_->agent);
	_data_->agent = _tmp10_;
	_tmp11_ = cancellable;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp12_;
	rygel_acl_real_is_allowed_async_co (_data_);
}


static gboolean rygel_acl_real_is_allowed_finish (GUPnPAcl* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	RygelAclIsAllowedAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelAcl* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean ___lambda5_ (Block1Data* _data1_) {
	RygelAcl* self;
	gboolean result = FALSE;
	self = _data1_->self;
	rygel_acl_real_is_allowed_async_co (_data1_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean ____lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda5_ (self);
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void rygel_acl_is_allowed_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelAclIsAllowedAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_acl_real_is_allowed_async_co (_data_);
}


static gboolean rygel_acl_real_is_allowed_async_co (RygelAclIsAllowedAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->provider;
	if (_data_->_tmp0_ == NULL) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda5__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp1_ = FALSE;
		_data_->_tmp1_ = _data_->self->priv->fallback_policy;
		_data_->result = _data_->_tmp1_;
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->device;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->device;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = gupnp_device_info_get_udn ((GUPnPDeviceInfo*) _data_->_tmp4_);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp2_ = _data_->_tmp6_;
	} else {
		_data_->_tmp2_ = "none";
	}
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->agent;
	_data_->_tmp7_ = _data_->_tmp8_;
	if (_data_->_tmp7_ == NULL) {
		_data_->_tmp7_ = "Unknown";
	}
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->path;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->address;
	g_debug ("rygel-acl.vala:83: Querying ACL for %s on %s by %s@%s", _data_->_tmp9_, _data_->_tmp2_, _data_->_tmp7_, _data_->_tmp10_);
	{
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = g_str_hash;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_str_equal;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = g_hash_table_new_full (_data_->_tmp11_, _data_->_tmp12_, _g_free0_, _g_free0_);
		_data_->device_hash = _data_->_tmp13_;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->device;
		if (_data_->_tmp14_ != NULL) {
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->device_hash;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = g_strdup ("FriendlyName");
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = _data_->device;
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = gupnp_device_info_get_friendly_name ((GUPnPDeviceInfo*) _data_->_tmp17_);
			g_hash_table_insert (_data_->_tmp15_, _data_->_tmp16_, _data_->_tmp18_);
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->device_hash;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = g_strdup ("UDN");
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->device;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = gupnp_device_info_get_udn ((GUPnPDeviceInfo*) _data_->_tmp21_);
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->_tmp22_;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = g_strdup (_data_->_tmp23_);
			g_hash_table_insert (_data_->_tmp19_, _data_->_tmp20_, _data_->_tmp24_);
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->device_hash;
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = g_strdup ("Type");
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = _data_->device;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = gupnp_device_info_get_device_type ((GUPnPDeviceInfo*) _data_->_tmp27_);
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = _data_->_tmp28_;
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = g_strdup (_data_->_tmp29_);
			g_hash_table_insert (_data_->_tmp25_, _data_->_tmp26_, _data_->_tmp30_);
		}
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = g_str_hash;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = g_str_equal;
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = g_hash_table_new_full (_data_->_tmp31_, _data_->_tmp32_, _g_free0_, _g_free0_);
		_data_->service_hash = _data_->_tmp33_;
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = _data_->service;
		if (_data_->_tmp34_ != NULL) {
			_data_->_tmp35_ = NULL;
			_data_->_tmp35_ = _data_->service_hash;
			_data_->_tmp36_ = NULL;
			_data_->_tmp36_ = g_strdup ("Type");
			_data_->_tmp37_ = NULL;
			_data_->_tmp37_ = _data_->service;
			_data_->_tmp38_ = NULL;
			_data_->_tmp38_ = gupnp_service_info_get_service_type ((GUPnPServiceInfo*) _data_->_tmp37_);
			_data_->_tmp39_ = NULL;
			_data_->_tmp39_ = _data_->_tmp38_;
			_data_->_tmp40_ = NULL;
			_data_->_tmp40_ = g_strdup (_data_->_tmp39_);
			g_hash_table_insert (_data_->_tmp35_, _data_->_tmp36_, _data_->_tmp40_);
		}
		_data_->_tmp41_ = NULL;
		_data_->_tmp41_ = _data_->self->priv->provider;
		_data_->_tmp42_ = NULL;
		_data_->_tmp42_ = _data_->device_hash;
		_data_->_tmp43_ = NULL;
		_data_->_tmp43_ = _data_->service_hash;
		_data_->_tmp44_ = NULL;
		_data_->_tmp44_ = _data_->path;
		_data_->_tmp45_ = NULL;
		_data_->_tmp45_ = _data_->address;
		_data_->_tmp46_ = NULL;
		_data_->_tmp46_ = _data_->agent;
		_data_->_state_ = 2;
		rygel_dbus_acl_provider_is_allowed (_data_->_tmp41_, _data_->_tmp42_, _data_->_tmp43_, _data_->_tmp44_, _data_->_tmp45_, _data_->_tmp46_, rygel_acl_is_allowed_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp47_ = FALSE;
		_data_->_tmp47_ = rygel_dbus_acl_provider_is_allowed_finish (_data_->_tmp41_, _data_->_res_, &_data_->_inner_error_);
		_data_->allowed = _data_->_tmp47_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_hash_table_unref0 (_data_->service_hash);
			_g_hash_table_unref0 (_data_->device_hash);
			goto __catch0_g_error;
		}
		_data_->result = _data_->allowed;
		_g_hash_table_unref0 (_data_->service_hash);
		_g_hash_table_unref0 (_data_->device_hash);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp48_ = NULL;
		_data_->_tmp48_ = _ ("Failed to query ACL: %s");
		_data_->_tmp49_ = NULL;
		_data_->_tmp49_ = _data_->_error_;
		_data_->_tmp50_ = NULL;
		_data_->_tmp50_ = _data_->_tmp49_->message;
		g_warning (_data_->_tmp48_, _data_->_tmp50_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = FALSE;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_acl_on_name_appeared (RygelAcl* self, GDBusConnection* connection, const gchar* name, const gchar* name_owner) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (name_owner != NULL);
	_tmp0_ = name;
	_tmp1_ = name_owner;
	g_debug ("rygel-acl.vala:119: Found ACL provider %s (%s), creating object", _tmp0_, _tmp1_);
	{
		RygelDBusAclProvider* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		RygelDBusAclProvider* _tmp4_ = NULL;
		RygelDBusAclProvider* _tmp5_ = NULL;
		_tmp3_ = name;
		_tmp4_ = g_initable_new (RYGEL_TYPE_DBUS_ACL_PROVIDER_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", _tmp3_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_DBUS_ACL_PROVIDER_OBJECT_PATH, "g-interface-name", "org.gnome.Rygel1.AclProvider1", "g-interface-info", g_type_get_qdata (RYGEL_TYPE_DBUS_ACL_PROVIDER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		_tmp2_ = (RygelDBusAclProvider*) _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (self->priv->provider);
		self->priv->provider = _tmp5_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = _ ("Error creating DBus proxy for ACL: %s");
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_warning (_tmp6_, _tmp8_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_acl_on_name_vanished (RygelAcl* self, GDBusConnection* connection, const gchar* name) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
	_g_object_unref0 (self->priv->provider);
	self->priv->provider = NULL;
}


static void rygel_acl_update_fallback_policy (RygelAcl* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		RygelConfiguration* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = self->priv->configuration;
		_tmp2_ = rygel_configuration_get_bool (_tmp1_, "general", "acl-fallback-policy", &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		self->priv->fallback_policy = _tmp0_;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp3_ = FALSE;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = self->priv->fallback_policy;
		if (_tmp3_) {
			const gchar* _tmp4_ = NULL;
			_tmp4_ = _ ("No ACL fallback policy found. Using \"allow\"");
			g_message ("rygel-acl.vala:143: %s", _tmp4_);
		} else {
			const gchar* _tmp5_ = NULL;
			_tmp5_ = _ ("No ACL fallback policy found. Using \"deny\"");
			g_message ("rygel-acl.vala:145: %s", _tmp5_);
		}
		_g_error_free0 (_error_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


RygelAcl* rygel_acl_construct (GType object_type) {
	RygelAcl * self = NULL;
	self = (RygelAcl*) g_object_new (object_type, NULL);
	return self;
}


RygelAcl* rygel_acl_new (void) {
	return rygel_acl_construct (RYGEL_TYPE_ACL);
}


static void rygel_acl_class_init (RygelAclClass * klass) {
	rygel_acl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelAclPrivate));
	((GObjectClass *) klass)->constructed = rygel_acl_real_constructed;
	G_OBJECT_CLASS (klass)->finalize = rygel_acl_finalize;
}


static void rygel_acl_gupnp_acl_interface_init (GUPnPAclInterface * iface) {
	rygel_acl_gupnp_acl_parent_iface = g_type_interface_peek_parent (iface);
	iface->can_sync = (gboolean (*)(GUPnPAcl*)) rygel_acl_real_can_sync;
	iface->is_allowed = (gboolean (*)(GUPnPAcl*, GUPnPDevice*, GUPnPService*, const gchar*, const gchar*, const gchar*)) rygel_acl_real_is_allowed;
	iface->is_allowed_async = (gboolean (*)(GUPnPAcl*, GUPnPDevice*, GUPnPService*, const gchar*, const gchar*, const gchar*, GCancellable*, GError**)) rygel_acl_real_is_allowed_async;
	iface->is_allowed_finish = rygel_acl_real_is_allowed_finish;
}


static void rygel_acl_instance_init (RygelAcl * self) {
	self->priv = RYGEL_ACL_GET_PRIVATE (self);
}


static void rygel_acl_finalize (GObject* obj) {
	RygelAcl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ACL, RygelAcl);
	_g_object_unref0 (self->priv->provider);
	_g_object_unref0 (self->priv->configuration);
	G_OBJECT_CLASS (rygel_acl_parent_class)->finalize (obj);
}


GType rygel_acl_get_type (void) {
	static volatile gsize rygel_acl_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_acl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAclClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_acl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAcl), 0, (GInstanceInitFunc) rygel_acl_instance_init, NULL };
		static const GInterfaceInfo gupnp_acl_info = { (GInterfaceInitFunc) rygel_acl_gupnp_acl_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_acl_type_id;
		rygel_acl_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelAcl", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_acl_type_id, GUPNP_TYPE_ACL, &gupnp_acl_info);
		g_once_init_leave (&rygel_acl_type_id__volatile, rygel_acl_type_id);
	}
	return rygel_acl_type_id__volatile;
}



