/* gnome-mahjongg.c generated by valac 0.28.0.14-080be, the Vala compiler
 * generated from gnome-mahjongg.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <locale.h>


#define TYPE_MAHJONGG (mahjongg_get_type ())
#define MAHJONGG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAHJONGG, Mahjongg))
#define MAHJONGG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAHJONGG, MahjonggClass))
#define IS_MAHJONGG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAHJONGG))
#define IS_MAHJONGG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAHJONGG))
#define MAHJONGG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAHJONGG, MahjonggClass))

typedef struct _Mahjongg Mahjongg;
typedef struct _MahjonggClass MahjonggClass;
typedef struct _MahjonggPrivate MahjonggPrivate;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define MAHJONGG_TYPE_NO_MOVES_DIALOG_RESPONSE (mahjongg_no_moves_dialog_response_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _MapPrivate MapPrivate;

#define TYPE_SLOT (slot_get_type ())
#define SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLOT, Slot))
#define SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLOT, SlotClass))
#define IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLOT))
#define IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLOT))
#define SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLOT, SlotClass))

typedef struct _Slot Slot;
typedef struct _SlotClass SlotClass;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
typedef struct _GameViewPrivate GameViewPrivate;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

#define TYPE_MATCH (match_get_type ())
#define MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATCH, Match))
#define MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATCH, MatchClass))
#define IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATCH))
#define IS_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATCH))
#define MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATCH, MatchClass))

typedef struct _Match Match;
typedef struct _MatchClass MatchClass;
typedef struct _MatchPrivate MatchPrivate;

#define TYPE_MAP_LOADER (map_loader_get_type ())
#define MAP_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP_LOADER, MapLoader))
#define MAP_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP_LOADER, MapLoaderClass))
#define IS_MAP_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP_LOADER))
#define IS_MAP_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP_LOADER))
#define MAP_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP_LOADER, MapLoaderClass))

typedef struct _MapLoader MapLoader;
typedef struct _MapLoaderClass MapLoaderClass;
typedef struct _MapLoaderPrivate MapLoaderPrivate;

struct _Mahjongg {
	GtkApplication parent_instance;
	MahjonggPrivate * priv;
};

struct _MahjonggClass {
	GtkApplicationClass parent_class;
};

struct _MahjonggPrivate {
	GSettings* settings;
	History* history;
	GList* maps;
	GtkApplicationWindow* window;
	GtkLabel* title;
	gint window_width;
	gint window_height;
	gboolean is_maximized;
	gboolean is_tiled;
	GameView* game_view;
	GtkButton* pause_button;
	GtkLabel* moves_label;
	GtkLabel* clock_label;
	GtkDialog* preferences_dialog;
};

typedef enum  {
	MAHJONGG_NO_MOVES_DIALOG_RESPONSE_UNDO,
	MAHJONGG_NO_MOVES_DIALOG_RESPONSE_SHUFFLE,
	MAHJONGG_NO_MOVES_DIALOG_RESPONSE_RESTART,
	MAHJONGG_NO_MOVES_DIALOG_RESPONSE_NEW_GAME
} MahjonggNoMovesDialogResponse;

struct _Map {
	GObject parent_instance;
	MapPrivate * priv;
	gchar* name;
	gchar* score_name;
	GList* slots;
};

struct _MapClass {
	GObjectClass parent_class;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Map* map;
	GList* tiles;
	Tile* hint_tiles[2];
	gint move_number;
	guint hint_blink_counter;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
	GdkRGBA background_color;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _Match {
	GObject parent_instance;
	MatchPrivate * priv;
	Tile* tile0;
	Tile* tile1;
};

struct _MatchClass {
	GObjectClass parent_class;
};

struct _MapLoader {
	GObject parent_instance;
	MapLoaderPrivate * priv;
	GList* maps;
};

struct _MapLoaderClass {
	GObjectClass parent_class;
};


static gpointer mahjongg_parent_class = NULL;

GType mahjongg_get_type (void) G_GNUC_CONST;
GType history_get_type (void) G_GNUC_CONST;
GType map_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
#define MAHJONGG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAHJONGG, MahjonggPrivate))
enum  {
	MAHJONGG_DUMMY_PROPERTY
};
static GType mahjongg_no_moves_dialog_response_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void mahjongg_new_game_cb (Mahjongg* self);
static void _mahjongg_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_undo_cb (Mahjongg* self);
static void _mahjongg_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_redo_cb (Mahjongg* self);
static void _mahjongg_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_hint_cb (Mahjongg* self);
static void _mahjongg_hint_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_pause_cb (Mahjongg* self);
static void _mahjongg_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_restart_game_cb (Mahjongg* self);
static void _mahjongg_restart_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_scores_cb (Mahjongg* self);
static void _mahjongg_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_preferences_cb (Mahjongg* self);
static void _mahjongg_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_help_cb (Mahjongg* self);
static void _mahjongg_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_about_cb (Mahjongg* self);
static void _mahjongg_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_quit_cb (Mahjongg* self);
static void _mahjongg_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Mahjongg* mahjongg_new (void);
Mahjongg* mahjongg_construct (GType object_type);
static void mahjongg_real_startup (GApplication* base);
static void mahjongg_load_maps (Mahjongg* self);
History* history_new (const gchar* filename);
History* history_construct (GType object_type, const gchar* filename);
void history_load (History* self);
static void mahjongg_size_allocate_cb (Mahjongg* self, GtkAllocation* allocation);
static void _mahjongg_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean mahjongg_window_state_event_cb (Mahjongg* self, GdkEventWindowState* event);
static gboolean _mahjongg_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static gboolean mahjongg_view_button_press_event (Mahjongg* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _mahjongg_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean mahjongg_is_desktop (Mahjongg* self, const gchar* name);
static void mahjongg_conf_value_changed_cb (Mahjongg* self, GSettings* settings, const gchar* key);
static void _mahjongg_conf_value_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void mahjongg_new_game (Mahjongg* self);
static void mahjongg_tick_cb (Mahjongg* self);
static void mahjongg_real_shutdown (GApplication* base);
static gint mahjongg_real_handle_local_options (GApplication* base, GVariantDict* options);
static void mahjongg_real_activate (GApplication* base);
static void mahjongg_update_ui (Mahjongg* self);
GType game_get_type (void) G_GNUC_CONST;
Game* game_view_get_game (GameView* self);
gboolean game_get_started (Game* self);
gboolean game_get_paused (Game* self);
guint game_get_moves_left (Game* self);
gboolean game_get_can_undo (Game* self);
gboolean game_get_can_redo (Game* self);
static void mahjongg_theme_changed_cb (Mahjongg* self, GtkComboBox* widget);
void game_view_set_theme (GameView* self, const gchar* value);
void game_view_set_background (GameView* self, const gchar* colour);
void game_set_paused (Game* self, gboolean value);
static void mahjongg_background_changed_cb (Mahjongg* self, GtkColorButton* widget);
static void mahjongg_map_changed_cb (Mahjongg* self, GtkComboBox* widget);
GType slot_get_type (void) G_GNUC_CONST;
static void mahjongg_moved_cb (Mahjongg* self);
gboolean game_get_complete (Game* self);
gdouble game_get_elapsed (Game* self);
GType history_entry_get_type (void) G_GNUC_CONST;
GType tile_get_type (void) G_GNUC_CONST;
HistoryEntry* history_entry_new (GDateTime* date, const gchar* name, guint duration);
HistoryEntry* history_entry_construct (GType object_type, GDateTime* date, const gchar* name, guint duration);
void history_add (History* self, HistoryEntry* entry);
void history_save (History* self);
static gint mahjongg_show_scores (Mahjongg* self, HistoryEntry* selected_entry, gboolean show_quit);
gboolean game_get_can_move (Game* self);
gint game_number_of_movable_tiles (Game* self);
static void mahjongg_shuffle_cb (Mahjongg* self);
static void mahjongg_restart_game (Mahjongg* self);
GType score_dialog_get_type (void) G_GNUC_CONST;
ScoreDialog* score_dialog_new (History* history, HistoryEntry* selected_entry, gboolean show_quit);
ScoreDialog* score_dialog_construct (GType object_type, History* history, HistoryEntry* selected_entry, gboolean show_quit);
static void mahjongg_preferences_dialog_response_cb (Mahjongg* self, GtkDialog* dialog, gint response);
static void _mahjongg_preferences_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static GList* mahjongg_load_themes (Mahjongg* self);
static void _mahjongg_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _mahjongg_map_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _mahjongg_background_changed_cb_gtk_color_button_color_set (GtkColorButton* _sender, gpointer self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
GType match_get_type (void) G_GNUC_CONST;
GList* game_find_matches (Game* self, Tile* tile);
Tile* game_get_selected_tile (Game* self);
void game_set_hint (Game* self, Tile* tile0, Tile* tile1);
void game_shuffle_remaining (Game* self, gboolean redraw);
void game_set_selected_tile (Game* self, Tile* value);
void game_redo (Game* self);
void game_undo (Game* self);
void game_reset (Game* self);
Game* game_new (Map* map);
Game* game_construct (GType object_type, Map* map);
void game_view_set_game (GameView* self, Game* value);
static void _mahjongg_moved_cb_game_moved (Game* _sender, gpointer self);
static void _mahjongg_tick_cb_game_tick (Game* _sender, gpointer self);
Map* map_new_builtin (void);
Map* map_construct_builtin (GType object_type);
GType map_loader_get_type (void) G_GNUC_CONST;
MapLoader* map_loader_new (void);
MapLoader* map_loader_construct (GType object_type);
void map_loader_load (MapLoader* self, const gchar* filename, GError** error);
gint mahjongg_main (gchar** args, int args_length1);
static void mahjongg_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry MAHJONGG_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print release version and exit", NULL}, {NULL}};
static const GActionEntry MAHJONGG_action_entries[11] = {{"new-game", _mahjongg_new_game_cb_gsimple_action_activate_callback}, {"undo", _mahjongg_undo_cb_gsimple_action_activate_callback}, {"redo", _mahjongg_redo_cb_gsimple_action_activate_callback}, {"hint", _mahjongg_hint_cb_gsimple_action_activate_callback}, {"pause", _mahjongg_pause_cb_gsimple_action_activate_callback}, {"restart-game", _mahjongg_restart_game_cb_gsimple_action_activate_callback}, {"scores", _mahjongg_scores_cb_gsimple_action_activate_callback}, {"preferences", _mahjongg_preferences_cb_gsimple_action_activate_callback}, {"help", _mahjongg_help_cb_gsimple_action_activate_callback}, {"about", _mahjongg_about_cb_gsimple_action_activate_callback}, {"quit", _mahjongg_quit_cb_gsimple_action_activate_callback}};

static GType mahjongg_no_moves_dialog_response_get_type (void) {
	static volatile gsize mahjongg_no_moves_dialog_response_type_id__volatile = 0;
	if (g_once_init_enter (&mahjongg_no_moves_dialog_response_type_id__volatile)) {
		static const GEnumValue values[] = {{MAHJONGG_NO_MOVES_DIALOG_RESPONSE_UNDO, "MAHJONGG_NO_MOVES_DIALOG_RESPONSE_UNDO", "undo"}, {MAHJONGG_NO_MOVES_DIALOG_RESPONSE_SHUFFLE, "MAHJONGG_NO_MOVES_DIALOG_RESPONSE_SHUFFLE", "shuffle"}, {MAHJONGG_NO_MOVES_DIALOG_RESPONSE_RESTART, "MAHJONGG_NO_MOVES_DIALOG_RESPONSE_RESTART", "restart"}, {MAHJONGG_NO_MOVES_DIALOG_RESPONSE_NEW_GAME, "MAHJONGG_NO_MOVES_DIALOG_RESPONSE_NEW_GAME", "new-game"}, {0, NULL, NULL}};
		GType mahjongg_no_moves_dialog_response_type_id;
		mahjongg_no_moves_dialog_response_type_id = g_enum_register_static ("MahjonggNoMovesDialogResponse", values);
		g_once_init_leave (&mahjongg_no_moves_dialog_response_type_id__volatile, mahjongg_no_moves_dialog_response_type_id);
	}
	return mahjongg_no_moves_dialog_response_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
#line 17 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 388 "gnome-mahjongg.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 17 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 17 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_list_free (self);
#line 397 "gnome-mahjongg.c"
}


static void _mahjongg_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_new_game_cb ((Mahjongg*) self);
#line 404 "gnome-mahjongg.c"
}


static void _mahjongg_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_undo_cb ((Mahjongg*) self);
#line 411 "gnome-mahjongg.c"
}


static void _mahjongg_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_redo_cb ((Mahjongg*) self);
#line 418 "gnome-mahjongg.c"
}


static void _mahjongg_hint_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_hint_cb ((Mahjongg*) self);
#line 425 "gnome-mahjongg.c"
}


static void _mahjongg_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_pause_cb ((Mahjongg*) self);
#line 432 "gnome-mahjongg.c"
}


static void _mahjongg_restart_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_restart_game_cb ((Mahjongg*) self);
#line 439 "gnome-mahjongg.c"
}


static void _mahjongg_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_scores_cb ((Mahjongg*) self);
#line 446 "gnome-mahjongg.c"
}


static void _mahjongg_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_preferences_cb ((Mahjongg*) self);
#line 453 "gnome-mahjongg.c"
}


static void _mahjongg_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_help_cb ((Mahjongg*) self);
#line 460 "gnome-mahjongg.c"
}


static void _mahjongg_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_about_cb ((Mahjongg*) self);
#line 467 "gnome-mahjongg.c"
}


static void _mahjongg_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_quit_cb ((Mahjongg*) self);
#line 474 "gnome-mahjongg.c"
}


Mahjongg* mahjongg_construct (GType object_type) {
	Mahjongg * self = NULL;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self = (Mahjongg*) g_object_new (object_type, "application-id", "org.gnome.gnome-mahjongg", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_application_add_main_option_entries ((GApplication*) self, MAHJONGG_option_entries);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	return self;
#line 486 "gnome-mahjongg.c"
}


Mahjongg* mahjongg_new (void) {
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	return mahjongg_construct (TYPE_MAHJONGG);
#line 493 "gnome-mahjongg.c"
}


static void _mahjongg_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_size_allocate_cb ((Mahjongg*) self, allocation);
#line 500 "gnome-mahjongg.c"
}


static gboolean _mahjongg_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = mahjongg_window_state_event_cb ((Mahjongg*) self, event);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	return result;
#line 509 "gnome-mahjongg.c"
}


static gboolean _mahjongg_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = mahjongg_view_button_press_event ((Mahjongg*) self, _sender, event);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	return result;
#line 518 "gnome-mahjongg.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	return self ? g_object_ref (self) : NULL;
#line 525 "gnome-mahjongg.c"
}


static void _mahjongg_conf_value_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_conf_value_changed_cb ((Mahjongg*) self, _sender, key);
#line 532 "gnome-mahjongg.c"
}


static void mahjongg_real_startup (GApplication* base) {
	Mahjongg * self;
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GSettings* _tmp12_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp13_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	History* _tmp18_ = NULL;
	History* _tmp19_ = NULL;
	GtkApplicationWindow* _tmp20_ = NULL;
	GtkApplicationWindow* _tmp21_ = NULL;
	GtkApplicationWindow* _tmp22_ = NULL;
	GtkApplicationWindow* _tmp23_ = NULL;
	GSettings* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GSettings* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	GSettings* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	GtkBox* status_box = NULL;
	GtkBox* _tmp31_ = NULL;
	GtkBox* group_box = NULL;
	GtkBox* _tmp32_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp33_ = NULL;
	GtkLabel* _tmp34_ = NULL;
	GtkBox* _tmp35_ = NULL;
	GtkLabel* _tmp36_ = NULL;
	GtkLabel* spacer = NULL;
	GtkLabel* _tmp37_ = NULL;
	GtkBox* _tmp38_ = NULL;
	GtkLabel* _tmp39_ = NULL;
	GtkLabel* _tmp40_ = NULL;
	GtkBox* _tmp41_ = NULL;
	GtkLabel* _tmp42_ = NULL;
	GtkBox* _tmp43_ = NULL;
	GtkBox* _tmp44_ = NULL;
	GtkLabel* _tmp45_ = NULL;
	GtkBox* _tmp46_ = NULL;
	GtkLabel* _tmp47_ = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp48_ = NULL;
	GameView* _tmp49_ = NULL;
	GameView* _tmp50_ = NULL;
	GameView* _tmp51_ = NULL;
	GtkLabel* _tmp52_ = NULL;
	GtkLabel* _tmp53_ = NULL;
	GtkStyleContext* _tmp54_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp55_ = NULL;
	GtkBox* _tmp56_ = NULL;
	GtkStyleContext* _tmp57_ = NULL;
	GtkButton* undo_button = NULL;
	GtkButton* _tmp58_ = NULL;
	GtkButton* _tmp59_ = NULL;
	GtkButton* _tmp60_ = NULL;
	GtkButton* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	GtkBox* _tmp63_ = NULL;
	GtkButton* _tmp64_ = NULL;
	GtkButton* redo_button = NULL;
	GtkButton* _tmp65_ = NULL;
	GtkButton* _tmp66_ = NULL;
	GtkButton* _tmp67_ = NULL;
	GtkButton* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	GtkBox* _tmp70_ = NULL;
	GtkButton* _tmp71_ = NULL;
	GtkButton* hint_button = NULL;
	GtkButton* _tmp72_ = NULL;
	GtkButton* _tmp73_ = NULL;
	GtkButton* _tmp74_ = NULL;
	GtkButton* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	GtkButton* _tmp77_ = NULL;
	GtkButton* _tmp78_ = NULL;
	GtkButton* _tmp79_ = NULL;
	GtkButton* _tmp80_ = NULL;
	const gchar* _tmp81_ = NULL;
	GtkBox* title_box = NULL;
	GtkBox* _tmp82_ = NULL;
	GtkBox* _tmp83_ = NULL;
	GtkLabel* _tmp84_ = NULL;
	GtkBox* _tmp85_ = NULL;
	GtkBox* _tmp86_ = NULL;
	GtkBox* _tmp87_ = NULL;
	gboolean shell_shows_menubar = FALSE;
	GtkSettings* _tmp88_ = NULL;
	gboolean _tmp89_ = FALSE;
	GtkHeaderBar* header_bar = NULL;
	GtkHeaderBar* _tmp117_ = NULL;
	GtkHeaderBar* _tmp118_ = NULL;
	GtkBox* _tmp119_ = NULL;
	GtkHeaderBar* _tmp120_ = NULL;
	GtkBox* _tmp121_ = NULL;
	GtkHeaderBar* _tmp122_ = NULL;
	GtkButton* _tmp123_ = NULL;
	GtkHeaderBar* _tmp124_ = NULL;
	GtkButton* _tmp125_ = NULL;
	gchar* desktop = NULL;
	const gchar* _tmp126_ = NULL;
	gchar* _tmp127_ = NULL;
	gboolean _tmp128_ = FALSE;
	GtkBox* _tmp134_ = NULL;
	GameView* _tmp135_ = NULL;
	GtkApplicationWindow* _tmp136_ = NULL;
	GtkBox* _tmp137_ = NULL;
	GtkApplicationWindow* _tmp138_ = NULL;
	GSettings* _tmp139_ = NULL;
	GameView* _tmp140_ = NULL;
	GSettings* _tmp141_ = NULL;
	GSettings* _tmp142_ = NULL;
	GError * _inner_error_ = NULL;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self = (Mahjongg*) base;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	G_APPLICATION_CLASS (mahjongg_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_action_map_add_action_entries ((GActionMap*) self, MAHJONGG_action_entries, G_N_ELEMENTS (MAHJONGG_action_entries), self);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = g_strdup ("Pause");
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_[0] = _tmp0_;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = _tmp1_;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2__length1 = 1;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.pause", _tmp2_);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = g_strdup ("<Primary>h");
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = g_new0 (gchar*, 1 + 1);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_[0] = _tmp3_;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = _tmp4_;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5__length1 = 1;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.hint", _tmp5_);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp6_ = g_strdup ("<Primary>z");
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp7_ = g_new0 (gchar*, 1 + 1);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp7_[0] = _tmp6_;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp8_ = _tmp7_;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp8__length1 = 1;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp8_);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp9_ = g_strdup ("<Primary><Shift>z");
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp10_ = g_new0 (gchar*, 1 + 1);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp10_[0] = _tmp9_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp11_ = _tmp10_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp11__length1 = 1;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp11_);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp12_ = g_settings_new ("org.gnome.mahjongg");
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->settings);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->settings = _tmp12_;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp13_ = gtk_builder_new ();
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	builder = _tmp13_;
#line 738 "gnome-mahjongg.c"
	{
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		gtk_builder_add_from_resource (builder, "/org/gnome/mahjongg/ui/menu.ui", &_inner_error_);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 744 "gnome-mahjongg.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp14_ = NULL;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		e = _inner_error_;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_inner_error_ = NULL;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp14_ = e->message;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_error ("gnome-mahjongg.vala:76: loading menu builder file: %s", _tmp14_);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_error_free0 (e);
#line 763 "gnome-mahjongg.c"
	}
	__finally3:
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_object_unref0 (builder);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_clear_error (&_inner_error_);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		return;
#line 776 "gnome-mahjongg.c"
	}
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_load_maps (self);
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp15_ = g_get_user_data_dir ();
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp16_ = g_build_filename (_tmp15_, "gnome-mahjongg", "history", NULL);
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp17_ = _tmp16_;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp18_ = history_new (_tmp17_);
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->history);
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->history = _tmp18_;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_free0 (_tmp17_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp19_ = self->priv->history;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	history_load (_tmp19_);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp20_ = (GtkApplicationWindow*) gtk_application_window_new ((GtkApplication*) self);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp20_);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->window);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->window = _tmp20_;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp21_ = self->priv->window;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_signal_connect_object ((GtkWidget*) _tmp21_, "size-allocate", (GCallback) _mahjongg_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp22_ = self->priv->window;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_signal_connect_object ((GtkWidget*) _tmp22_, "window-state-event", (GCallback) _mahjongg_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp23_ = self->priv->window;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp24_ = self->priv->settings;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp25_ = g_settings_get_int (_tmp24_, "window-width");
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp26_ = self->priv->settings;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp27_ = g_settings_get_int (_tmp26_, "window-height");
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp23_, _tmp25_, _tmp27_);
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp28_ = self->priv->settings;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp29_ = g_settings_get_boolean (_tmp28_, "window-is-maximized");
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp29_) {
#line 832 "gnome-mahjongg.c"
		GtkApplicationWindow* _tmp30_ = NULL;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp30_ = self->priv->window;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		gtk_window_maximize ((GtkWindow*) _tmp30_);
#line 838 "gnome-mahjongg.c"
	}
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp31_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 10);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp31_);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	status_box = _tmp31_;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp32_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp32_);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	group_box = _tmp32_;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp33_ = _ ("Moves Left:");
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp34_ = (GtkLabel*) gtk_label_new (_tmp33_);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp34_);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	label = _tmp34_;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp35_ = group_box;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp36_ = label;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_box_pack_start (_tmp35_, (GtkWidget*) _tmp36_, FALSE, FALSE, (guint) 0);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp37_ = (GtkLabel*) gtk_label_new (" ");
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp37_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	spacer = _tmp37_;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp38_ = group_box;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp39_ = spacer;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_box_pack_start (_tmp38_, (GtkWidget*) _tmp39_, FALSE, FALSE, (guint) 0);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp40_ = (GtkLabel*) gtk_label_new ("");
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp40_);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->moves_label);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->moves_label = _tmp40_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp41_ = group_box;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp42_ = self->priv->moves_label;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_box_pack_start (_tmp41_, (GtkWidget*) _tmp42_, FALSE, FALSE, (guint) 0);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp43_ = status_box;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp44_ = group_box;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_box_pack_start (_tmp43_, (GtkWidget*) _tmp44_, FALSE, FALSE, (guint) 0);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp45_ = (GtkLabel*) gtk_label_new ("");
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp45_);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->clock_label);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->clock_label = _tmp45_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp46_ = status_box;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp47_ = self->priv->clock_label;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_box_pack_start (_tmp46_, (GtkWidget*) _tmp47_, FALSE, FALSE, (guint) 0);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp48_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp48_);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	vbox = _tmp48_;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp49_ = game_view_new ();
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp49_);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->game_view);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->game_view = _tmp49_;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp50_ = self->priv->game_view;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_signal_connect_object ((GtkWidget*) _tmp50_, "button-press-event", (GCallback) _mahjongg_view_button_press_event_gtk_widget_button_press_event, self, 0);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp51_ = self->priv->game_view;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp51_, 600, 400);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp52_ = (GtkLabel*) gtk_label_new ("");
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp52_);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->title);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->title = _tmp52_;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp53_ = self->priv->title;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp54_ = gtk_widget_get_style_context ((GtkWidget*) _tmp53_);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_style_context_add_class (_tmp54_, "title");
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp55_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp55_);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	hbox = _tmp55_;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp56_ = hbox;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp57_ = gtk_widget_get_style_context ((GtkWidget*) _tmp56_);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_style_context_add_class (_tmp57_, "linked");
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp58_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", GTK_ICON_SIZE_BUTTON);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp58_);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	undo_button = _tmp58_;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp59_ = undo_button;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp59_, GTK_ALIGN_CENTER);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp60_ = undo_button;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_actionable_set_action_name ((GtkActionable*) _tmp60_, "app.undo");
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp61_ = undo_button;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp62_ = _ ("Undo your last move");
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp61_, _tmp62_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp63_ = hbox;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp64_ = undo_button;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_box_pack_start (_tmp63_, (GtkWidget*) _tmp64_, TRUE, TRUE, (guint) 0);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp65_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-redo-symbolic", GTK_ICON_SIZE_BUTTON);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp65_);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	redo_button = _tmp65_;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp66_ = redo_button;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp66_, GTK_ALIGN_CENTER);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp67_ = redo_button;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_actionable_set_action_name ((GtkActionable*) _tmp67_, "app.redo");
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp68_ = redo_button;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp69_ = _ ("Redo your last move");
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp68_, _tmp69_);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp70_ = hbox;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp71_ = redo_button;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_box_pack_start (_tmp70_, (GtkWidget*) _tmp71_, TRUE, TRUE, (guint) 0);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp72_ = (GtkButton*) gtk_button_new_from_icon_name ("dialog-question-symbolic", GTK_ICON_SIZE_BUTTON);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp72_);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	hint_button = _tmp72_;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp73_ = hint_button;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp73_, GTK_ALIGN_CENTER);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp74_ = hint_button;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_actionable_set_action_name ((GtkActionable*) _tmp74_, "app.hint");
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp75_ = hint_button;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp76_ = _ ("Receive a hint for your next move");
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp75_, _tmp76_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp77_ = (GtkButton*) gtk_button_new_from_icon_name ("media-playback-pause-symbolic", GTK_ICON_SIZE_BUTTON);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp77_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->pause_button);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->pause_button = _tmp77_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp78_ = self->priv->pause_button;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp78_, GTK_ALIGN_CENTER);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp79_ = self->priv->pause_button;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_actionable_set_action_name ((GtkActionable*) _tmp79_, "app.pause");
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp80_ = self->priv->pause_button;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp81_ = _ ("Pause the game");
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp80_, _tmp81_);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp82_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp82_);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	title_box = _tmp82_;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp83_ = title_box;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp84_ = self->priv->title;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_box_pack_start (_tmp83_, (GtkWidget*) _tmp84_, FALSE, FALSE, (guint) 0);
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp85_ = status_box;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp85_, GTK_ALIGN_CENTER);
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp86_ = title_box;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp87_ = status_box;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_box_pack_start (_tmp86_, (GtkWidget*) _tmp87_, FALSE, FALSE, (guint) 0);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp88_ = gtk_settings_get_default ();
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_get ((GObject*) _tmp88_, "gtk-shell-shows-menubar", &shell_shows_menubar, NULL);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp89_ = shell_shows_menubar;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (!_tmp89_) {
#line 1084 "gnome-mahjongg.c"
		GMenuModel* app_menu = NULL;
		GObject* _tmp90_ = NULL;
		GMenuModel* _tmp91_ = NULL;
		GMenuModel* _tmp92_ = NULL;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp90_ = gtk_builder_get_object (builder, "appmenu");
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp91_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp90_) : NULL);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		app_menu = _tmp91_;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp92_ = app_menu;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		gtk_application_set_app_menu ((GtkApplication*) self, _tmp92_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_object_unref0 (app_menu);
#line 1101 "gnome-mahjongg.c"
	} else {
		GMenu* menu = NULL;
		GMenu* _tmp93_ = NULL;
		GMenu* mahjongg_menu = NULL;
		GMenu* _tmp94_ = NULL;
		GMenu* _tmp95_ = NULL;
		const gchar* _tmp96_ = NULL;
		GMenu* _tmp97_ = NULL;
		GMenu* _tmp98_ = NULL;
		const gchar* _tmp99_ = NULL;
		GMenu* _tmp100_ = NULL;
		const gchar* _tmp101_ = NULL;
		GMenu* _tmp102_ = NULL;
		const gchar* _tmp103_ = NULL;
		GMenu* _tmp104_ = NULL;
		const gchar* _tmp105_ = NULL;
		GMenu* _tmp106_ = NULL;
		const gchar* _tmp107_ = NULL;
		GMenu* help_menu = NULL;
		GMenu* _tmp108_ = NULL;
		GMenu* _tmp109_ = NULL;
		const gchar* _tmp110_ = NULL;
		GMenu* _tmp111_ = NULL;
		GMenu* _tmp112_ = NULL;
		const gchar* _tmp113_ = NULL;
		GMenu* _tmp114_ = NULL;
		const gchar* _tmp115_ = NULL;
		GMenu* _tmp116_ = NULL;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp93_ = g_menu_new ();
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		menu = _tmp93_;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp94_ = g_menu_new ();
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		mahjongg_menu = _tmp94_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp95_ = menu;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp96_ = _ ("_Mahjongg");
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp97_ = mahjongg_menu;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_menu_append_submenu (_tmp95_, _tmp96_, (GMenuModel*) _tmp97_);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp98_ = mahjongg_menu;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp99_ = _ ("_New Game");
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_menu_append (_tmp98_, _tmp99_, "app.new-game");
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp100_ = mahjongg_menu;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp101_ = _ ("_Restart Game");
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_menu_append (_tmp100_, _tmp101_, "app.restart-game");
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp102_ = mahjongg_menu;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp103_ = _ ("_Scores");
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_menu_append (_tmp102_, _tmp103_, "app.scores");
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp104_ = mahjongg_menu;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp105_ = _ ("_Preferences");
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_menu_append (_tmp104_, _tmp105_, "app.preferences");
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp106_ = mahjongg_menu;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp107_ = _ ("_Quit");
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_menu_append (_tmp106_, _tmp107_, "app.quit");
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp108_ = g_menu_new ();
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		help_menu = _tmp108_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp109_ = menu;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp110_ = _ ("_Help");
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp111_ = help_menu;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_menu_append_submenu (_tmp109_, _tmp110_, (GMenuModel*) _tmp111_);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp112_ = help_menu;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp113_ = _ ("_Contents");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_menu_append (_tmp112_, _tmp113_, "app.help");
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp114_ = help_menu;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp115_ = _ ("_About");
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_menu_append (_tmp114_, _tmp115_, "app.about");
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp116_ = menu;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		gtk_application_set_menubar ((GtkApplication*) self, (GMenuModel*) _tmp116_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_object_unref0 (help_menu);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_object_unref0 (mahjongg_menu);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_object_unref0 (menu);
#line 1210 "gnome-mahjongg.c"
	}
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp117_ = (GtkHeaderBar*) gtk_header_bar_new ();
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp117_);
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	header_bar = _tmp117_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp118_ = header_bar;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp119_ = title_box;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_header_bar_set_custom_title (_tmp118_, (GtkWidget*) _tmp119_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp120_ = header_bar;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp121_ = hbox;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_header_bar_pack_start (_tmp120_, (GtkWidget*) _tmp121_);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp122_ = header_bar;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp123_ = hint_button;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_header_bar_pack_end (_tmp122_, (GtkWidget*) _tmp123_);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp124_ = header_bar;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp125_ = self->priv->pause_button;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_header_bar_pack_end (_tmp124_, (GtkWidget*) _tmp125_);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp126_ = g_getenv ("XDG_CURRENT_DESKTOP");
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp127_ = g_strdup (_tmp126_);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	desktop = _tmp127_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp128_ = mahjongg_is_desktop (self, "Unity");
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (!_tmp128_) {
#line 1252 "gnome-mahjongg.c"
		GtkHeaderBar* _tmp129_ = NULL;
		GtkApplicationWindow* _tmp130_ = NULL;
		GtkHeaderBar* _tmp131_ = NULL;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp129_ = header_bar;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		gtk_header_bar_set_show_close_button (_tmp129_, TRUE);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp130_ = self->priv->window;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp131_ = header_bar;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		gtk_window_set_titlebar ((GtkWindow*) _tmp130_, (GtkWidget*) _tmp131_);
#line 1266 "gnome-mahjongg.c"
	} else {
		GtkBox* _tmp132_ = NULL;
		GtkHeaderBar* _tmp133_ = NULL;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp132_ = vbox;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp133_ = header_bar;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		gtk_box_pack_start (_tmp132_, (GtkWidget*) _tmp133_, FALSE, FALSE, (guint) 0);
#line 1276 "gnome-mahjongg.c"
	}
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp134_ = vbox;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp135_ = self->priv->game_view;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_box_pack_start (_tmp134_, (GtkWidget*) _tmp135_, TRUE, TRUE, (guint) 0);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp136_ = self->priv->window;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp137_ = vbox;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_container_add ((GtkContainer*) _tmp136_, (GtkWidget*) _tmp137_);
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp138_ = self->priv->window;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp138_);
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp139_ = self->priv->settings;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_signal_connect_object (_tmp139_, "changed", (GCallback) _mahjongg_conf_value_changed_cb_g_settings_changed, self, 0);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_new_game (self);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp140_ = self->priv->game_view;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp140_);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp141_ = self->priv->settings;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_conf_value_changed_cb (self, _tmp141_, "tileset");
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp142_ = self->priv->settings;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_conf_value_changed_cb (self, _tmp142_, "bgcolour");
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_tick_cb (self);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_free0 (desktop);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (header_bar);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (title_box);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (hint_button);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (redo_button);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (undo_button);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (hbox);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (vbox);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (spacer);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (label);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (group_box);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (status_box);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (builder);
#line 1340 "gnome-mahjongg.c"
}


static gboolean mahjongg_is_desktop (Mahjongg* self, const gchar* name) {
	gboolean result = FALSE;
	gchar* desktop_name_list = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	desktop_name_list = _tmp1_;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = desktop_name_list;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp2_ == NULL) {
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		result = FALSE;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_free0 (desktop_name_list);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		return result;
#line 1373 "gnome-mahjongg.c"
	}
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = desktop_name_list;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ":", 0);
#line 1379 "gnome-mahjongg.c"
	{
		gchar** n_collection = NULL;
		gint n_collection_length1 = 0;
		gint _n_collection_size_ = 0;
		gint n_it = 0;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		n_collection = _tmp5_;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		n_collection_length1 = _vala_array_length (_tmp4_);
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		for (n_it = 0; n_it < _vala_array_length (_tmp4_); n_it = n_it + 1) {
#line 1391 "gnome-mahjongg.c"
			gchar* _tmp6_ = NULL;
			gchar* n = NULL;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp6_ = g_strdup (n_collection[n_it]);
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			n = _tmp6_;
#line 1398 "gnome-mahjongg.c"
			{
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp7_ = n;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp8_ = name;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					result = TRUE;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_g_free0 (n);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					n_collection = (_vala_array_free (n_collection, n_collection_length1, (GDestroyNotify) g_free), NULL);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_g_free0 (desktop_name_list);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					return result;
#line 1418 "gnome-mahjongg.c"
				}
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_g_free0 (n);
#line 1422 "gnome-mahjongg.c"
			}
		}
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		n_collection = (_vala_array_free (n_collection, n_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1427 "gnome-mahjongg.c"
	}
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	result = FALSE;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_free0 (desktop_name_list);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	return result;
#line 1435 "gnome-mahjongg.c"
}


static void mahjongg_size_allocate_cb (Mahjongg* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (allocation != NULL);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = self->priv->is_maximized;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp1_) {
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp0_ = TRUE;
#line 1456 "gnome-mahjongg.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp2_ = self->priv->is_tiled;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp0_ = _tmp2_;
#line 1463 "gnome-mahjongg.c"
	}
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp0_) {
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		return;
#line 1469 "gnome-mahjongg.c"
	}
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = *allocation;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = _tmp3_.width;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->window_width = _tmp4_;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = *allocation;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp6_ = _tmp5_.height;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->window_height = _tmp6_;
#line 1483 "gnome-mahjongg.c"
}


static gboolean mahjongg_window_state_event_cb (Mahjongg* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = event;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1503 "gnome-mahjongg.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp2_ = event;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1512 "gnome-mahjongg.c"
	}
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = event;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 1520 "gnome-mahjongg.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp6_ = event;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 1529 "gnome-mahjongg.c"
	}
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	result = FALSE;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	return result;
#line 1535 "gnome-mahjongg.c"
}


static void mahjongg_real_shutdown (GApplication* base) {
	Mahjongg * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self = (Mahjongg*) base;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	G_APPLICATION_CLASS (mahjongg_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->settings;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = self->priv->window_width;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = self->priv->settings;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = self->priv->window_height;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = self->priv->settings;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = self->priv->is_maximized;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
#line 1569 "gnome-mahjongg.c"
}


static gint mahjongg_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Mahjongg * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self = (Mahjongg*) base;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = options;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp1_) {
#line 1588 "gnome-mahjongg.c"
		FILE* _tmp2_ = NULL;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp2_ = stderr;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		fprintf (_tmp2_, "%1$s %2$s\n", "gnome-mahjongg", VERSION);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		result = EXIT_SUCCESS;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		return result;
#line 1598 "gnome-mahjongg.c"
	}
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	result = -1;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	return result;
#line 1604 "gnome-mahjongg.c"
}


static void mahjongg_real_activate (GApplication* base) {
	Mahjongg * self;
	GtkApplicationWindow* _tmp0_ = NULL;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self = (Mahjongg*) base;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->window;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 1617 "gnome-mahjongg.c"
}


static void mahjongg_update_ui (Mahjongg* self) {
	GSimpleAction* pause_action = NULL;
	GAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GSimpleAction* hint_action = NULL;
	GAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* undo_action = NULL;
	GAction* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	GSimpleAction* redo_action = NULL;
	GAction* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	GSimpleAction* _tmp8_ = NULL;
	GameView* _tmp9_ = NULL;
	Game* _tmp10_ = NULL;
	Game* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GameView* _tmp14_ = NULL;
	Game* _tmp15_ = NULL;
	Game* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	GtkLabel* _tmp40_ = NULL;
	GameView* _tmp41_ = NULL;
	Game* _tmp42_ = NULL;
	Game* _tmp43_ = NULL;
	guint _tmp44_ = 0U;
	guint _tmp45_ = 0U;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	pause_action = _tmp1_;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "hint");
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	hint_action = _tmp3_;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp4_) : NULL);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	undo_action = _tmp5_;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp6_) : NULL);
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	redo_action = _tmp7_;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp8_ = pause_action;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp9_ = self->priv->game_view;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp10_ = game_view_get_game (_tmp9_);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp11_ = _tmp10_;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp12_ = game_get_started (_tmp11_);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp13_ = _tmp12_;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_simple_action_set_enabled (_tmp8_, _tmp13_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_ = self->priv->game_view;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp15_ = game_view_get_game (_tmp14_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp16_ = _tmp15_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp17_ = game_get_paused (_tmp16_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp18_ = _tmp17_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp18_) {
#line 1705 "gnome-mahjongg.c"
		GSimpleAction* _tmp19_ = NULL;
		GSimpleAction* _tmp20_ = NULL;
		GSimpleAction* _tmp21_ = NULL;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp19_ = hint_action;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_simple_action_set_enabled (_tmp19_, FALSE);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp20_ = undo_action;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_simple_action_set_enabled (_tmp20_, FALSE);
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp21_ = redo_action;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_simple_action_set_enabled (_tmp21_, FALSE);
#line 1721 "gnome-mahjongg.c"
	} else {
		GSimpleAction* _tmp22_ = NULL;
		GameView* _tmp23_ = NULL;
		Game* _tmp24_ = NULL;
		Game* _tmp25_ = NULL;
		guint _tmp26_ = 0U;
		guint _tmp27_ = 0U;
		GSimpleAction* _tmp28_ = NULL;
		GameView* _tmp29_ = NULL;
		Game* _tmp30_ = NULL;
		Game* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		GSimpleAction* _tmp34_ = NULL;
		GameView* _tmp35_ = NULL;
		Game* _tmp36_ = NULL;
		Game* _tmp37_ = NULL;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp22_ = hint_action;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp23_ = self->priv->game_view;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp24_ = game_view_get_game (_tmp23_);
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp25_ = _tmp24_;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp26_ = game_get_moves_left (_tmp25_);
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp27_ = _tmp26_;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_simple_action_set_enabled (_tmp22_, _tmp27_ > ((guint) 0));
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp28_ = undo_action;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp29_ = self->priv->game_view;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp30_ = game_view_get_game (_tmp29_);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp31_ = _tmp30_;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp32_ = game_get_can_undo (_tmp31_);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp33_ = _tmp32_;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_simple_action_set_enabled (_tmp28_, _tmp33_);
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp34_ = redo_action;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp35_ = self->priv->game_view;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp36_ = game_view_get_game (_tmp35_);
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp37_ = _tmp36_;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp38_ = game_get_can_redo (_tmp37_);
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp39_ = _tmp38_;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_simple_action_set_enabled (_tmp34_, _tmp39_);
#line 1783 "gnome-mahjongg.c"
	}
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp40_ = self->priv->moves_label;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp41_ = self->priv->game_view;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp42_ = game_view_get_game (_tmp41_);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp43_ = _tmp42_;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp44_ = game_get_moves_left (_tmp43_);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp45_ = _tmp44_;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp46_ = g_strdup_printf ("%2u", _tmp45_);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp47_ = _tmp46_;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_label_set_text (_tmp40_, _tmp47_);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_free0 (_tmp47_);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (redo_action);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (undo_action);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (hint_action);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (pause_action);
#line 1813 "gnome-mahjongg.c"
}


static void mahjongg_theme_changed_cb (Mahjongg* self, GtkComboBox* widget) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gchar* theme = NULL;
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GSettings* _tmp6_ = NULL;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (widget != NULL);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = widget;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	iter = _tmp1_;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = widget;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = _tmp3_;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = iter;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &theme, -1);
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp6_ = self->priv->settings;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_settings_set_string (_tmp6_, "tileset", theme);
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_free0 (theme);
#line 1853 "gnome-mahjongg.c"
}


static void mahjongg_conf_value_changed_cb (Mahjongg* self, GSettings* settings, const gchar* key) {
	const gchar* _tmp0_ = NULL;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (settings != NULL);
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (key != NULL);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = key;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (g_strcmp0 (_tmp0_, "tileset") == 0) {
#line 1869 "gnome-mahjongg.c"
		gchar* theme = NULL;
		GSettings* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GameView* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp1_ = settings;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp2_ = g_settings_get_string (_tmp1_, "tileset");
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		theme = _tmp2_;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp3_ = self->priv->game_view;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp4_ = theme;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp5_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp4_, NULL);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp6_ = _tmp5_;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		game_view_set_theme (_tmp3_, _tmp6_);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_free0 (_tmp6_);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_free0 (theme);
#line 1897 "gnome-mahjongg.c"
	} else {
		const gchar* _tmp7_ = NULL;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp7_ = key;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (g_strcmp0 (_tmp7_, "bgcolour") == 0) {
#line 1904 "gnome-mahjongg.c"
			GameView* _tmp8_ = NULL;
			GSettings* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp8_ = self->priv->game_view;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp9_ = settings;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp10_ = g_settings_get_string (_tmp9_, "bgcolour");
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp11_ = _tmp10_;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			game_view_set_background (_tmp8_, _tmp11_);
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_free0 (_tmp11_);
#line 1921 "gnome-mahjongg.c"
		} else {
			const gchar* _tmp12_ = NULL;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp12_ = key;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			if (g_strcmp0 (_tmp12_, "mapset") == 0) {
#line 1928 "gnome-mahjongg.c"
				GameView* _tmp13_ = NULL;
				Game* _tmp14_ = NULL;
				Game* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp13_ = self->priv->game_view;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp14_ = game_view_get_game (_tmp13_);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp15_ = _tmp14_;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp16_ = game_get_started (_tmp15_);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp17_ = _tmp16_;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				if (_tmp17_) {
#line 1946 "gnome-mahjongg.c"
					GtkMessageDialog* dialog = NULL;
					GtkApplicationWindow* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					GtkMessageDialog* _tmp20_ = NULL;
					GtkMessageDialog* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					GtkMessageDialog* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					GtkMessageDialog* _tmp26_ = NULL;
					gint response = 0;
					GtkMessageDialog* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					GtkMessageDialog* _tmp30_ = NULL;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp18_ = self->priv->window;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp19_ = _ ("Do you want to start a new game with this map?");
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp20_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp18_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp19_);
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					g_object_ref_sink (_tmp20_);
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					dialog = _tmp20_;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp21_ = dialog;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp22_ = _ ("If you continue playing the next game will use the new map.");
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					gtk_message_dialog_format_secondary_text (_tmp21_, "%s", _tmp22_);
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp23_ = dialog;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp24_ = _ ("_Continue playing");
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp25_ = _ ("Use _new map");
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					gtk_dialog_add_buttons ((GtkDialog*) _tmp23_, _tmp24_, GTK_RESPONSE_REJECT, _tmp25_, GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp26_ = dialog;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					gtk_dialog_set_default_response ((GtkDialog*) _tmp26_, (gint) GTK_RESPONSE_ACCEPT);
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp27_ = dialog;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp28_ = gtk_dialog_run ((GtkDialog*) _tmp27_);
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					response = _tmp28_;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp29_ = response;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					if (_tmp29_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
						mahjongg_new_game (self);
#line 2002 "gnome-mahjongg.c"
					}
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp30_ = dialog;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					gtk_widget_destroy ((GtkWidget*) _tmp30_);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_g_object_unref0 (dialog);
#line 2010 "gnome-mahjongg.c"
				} else {
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					mahjongg_new_game (self);
#line 2014 "gnome-mahjongg.c"
				}
			}
		}
	}
}


static gboolean mahjongg_view_button_press_event (Mahjongg* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->game_view;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = game_view_get_game (_tmp0_);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = _tmp1_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = game_get_paused (_tmp2_);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = _tmp3_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp4_) {
#line 2047 "gnome-mahjongg.c"
		GameView* _tmp5_ = NULL;
		Game* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp5_ = self->priv->game_view;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp6_ = game_view_get_game (_tmp5_);
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp7_ = _tmp6_;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		game_set_paused (_tmp7_, FALSE);
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		result = TRUE;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		return result;
#line 2063 "gnome-mahjongg.c"
	}
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	result = FALSE;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	return result;
#line 2069 "gnome-mahjongg.c"
}


static void mahjongg_background_changed_cb (Mahjongg* self, GtkColorButton* widget) {
	GdkRGBA colour = {0};
	GtkColorButton* _tmp0_ = NULL;
	GdkRGBA _tmp1_ = {0};
	GSettings* _tmp2_ = NULL;
	GdkRGBA _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	GdkRGBA _tmp5_ = {0};
	gdouble _tmp6_ = 0.0;
	GdkRGBA _tmp7_ = {0};
	gdouble _tmp8_ = 0.0;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (widget != NULL);
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = widget;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp0_, &_tmp1_);
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	colour = _tmp1_;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = self->priv->settings;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = colour;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = _tmp3_.red;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = colour;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp6_ = _tmp5_.green;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp7_ = colour;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp8_ = _tmp7_.blue;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp9_ = g_strdup_printf ("#%04x%04x%04x", (guint) ((gint) ((_tmp4_ * 65536) + 0.5)), (guint) ((gint) ((_tmp6_ * 65536) + 0.5)), (guint) ((gint) ((_tmp8_ * 65536) + 0.5)));
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp10_ = _tmp9_;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_settings_set_string (_tmp2_, "bgcolour", _tmp10_);
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_free0 (_tmp10_);
#line 2118 "gnome-mahjongg.c"
}


static void mahjongg_map_changed_cb (Mahjongg* self, GtkComboBox* widget) {
	GSettings* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GtkComboBox* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gconstpointer _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (widget != NULL);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->settings;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = self->priv->maps;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = widget;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = gtk_combo_box_get_active (_tmp2_);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = _tmp3_;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = g_list_nth_data (_tmp1_, (guint) _tmp4_);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp6_ = ((Map*) _tmp5_)->name;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_settings_set_string (_tmp0_, "mapset", _tmp6_);
#line 2150 "gnome-mahjongg.c"
}


static void mahjongg_moved_cb (Mahjongg* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_update_ui (self);
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->game_view;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = game_view_get_game (_tmp0_);
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = _tmp1_;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = game_get_complete (_tmp2_);
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = _tmp3_;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp4_) {
#line 2176 "gnome-mahjongg.c"
		GDateTime* date = NULL;
		GDateTime* _tmp5_ = NULL;
		guint duration = 0U;
		GameView* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		Game* _tmp8_ = NULL;
		gdouble _tmp9_ = 0.0;
		gdouble _tmp10_ = 0.0;
		HistoryEntry* entry = NULL;
		GDateTime* _tmp11_ = NULL;
		GameView* _tmp12_ = NULL;
		Game* _tmp13_ = NULL;
		Game* _tmp14_ = NULL;
		Map* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		guint _tmp17_ = 0U;
		HistoryEntry* _tmp18_ = NULL;
		History* _tmp19_ = NULL;
		HistoryEntry* _tmp20_ = NULL;
		History* _tmp21_ = NULL;
		HistoryEntry* _tmp22_ = NULL;
		gint _tmp23_ = 0;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp5_ = g_date_time_new_now_local ();
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		date = _tmp5_;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp6_ = self->priv->game_view;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp7_ = game_view_get_game (_tmp6_);
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp8_ = _tmp7_;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp9_ = game_get_elapsed (_tmp8_);
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp10_ = _tmp9_;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		duration = (guint) (_tmp10_ + 0.5);
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp11_ = date;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp12_ = self->priv->game_view;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp13_ = game_view_get_game (_tmp12_);
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp14_ = _tmp13_;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp15_ = _tmp14_->map;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp16_ = _tmp15_->score_name;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp17_ = duration;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp18_ = history_entry_new (_tmp11_, _tmp16_, _tmp17_);
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		entry = _tmp18_;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp19_ = self->priv->history;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp20_ = entry;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		history_add (_tmp19_, _tmp20_);
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp21_ = self->priv->history;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		history_save (_tmp21_);
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp22_ = entry;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp23_ = mahjongg_show_scores (self, _tmp22_, TRUE);
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (_tmp23_ == ((gint) GTK_RESPONSE_CLOSE)) {
#line 2249 "gnome-mahjongg.c"
			GtkApplicationWindow* _tmp24_ = NULL;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp24_ = self->priv->window;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp24_);
#line 2255 "gnome-mahjongg.c"
		} else {
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			mahjongg_new_game (self);
#line 2259 "gnome-mahjongg.c"
		}
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_object_unref0 (entry);
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_date_time_unref0 (date);
#line 2265 "gnome-mahjongg.c"
	} else {
		GameView* _tmp25_ = NULL;
		Game* _tmp26_ = NULL;
		Game* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp25_ = self->priv->game_view;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp26_ = game_view_get_game (_tmp25_);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp27_ = _tmp26_;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp28_ = game_get_can_move (_tmp27_);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp29_ = _tmp28_;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (!_tmp29_) {
#line 2284 "gnome-mahjongg.c"
			gboolean allow_shuffle = FALSE;
			GameView* _tmp30_ = NULL;
			Game* _tmp31_ = NULL;
			Game* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			GtkMessageDialog* dialog = NULL;
			GtkApplicationWindow* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			GtkMessageDialog* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
			gboolean _tmp38_ = FALSE;
			const gchar* _tmp39_ = NULL;
			gboolean _tmp40_ = FALSE;
			GtkMessageDialog* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			const gchar* _tmp46_ = NULL;
			gboolean _tmp47_ = FALSE;
			GtkMessageDialog* _tmp49_ = NULL;
			const gchar* _tmp50_ = NULL;
			const gchar* _tmp51_ = NULL;
			const gchar* _tmp52_ = NULL;
			gint _result_ = 0;
			GtkMessageDialog* _tmp53_ = NULL;
			gint _tmp54_ = 0;
			GtkMessageDialog* _tmp55_ = NULL;
			gint _tmp56_ = 0;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp30_ = self->priv->game_view;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp31_ = game_view_get_game (_tmp30_);
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp32_ = _tmp31_;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp33_ = game_number_of_movable_tiles (_tmp32_);
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			allow_shuffle = _tmp33_ > 1;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp34_ = self->priv->window;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp35_ = _ ("There are no more moves.");
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp36_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp34_, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, "%s", _tmp35_);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			g_object_ref_sink (_tmp36_);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			dialog = _tmp36_;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp38_ = allow_shuffle;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			if (_tmp38_) {
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp37_ = " ";
#line 2339 "gnome-mahjongg.c"
			} else {
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp37_ = "";
#line 2343 "gnome-mahjongg.c"
			}
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp40_ = allow_shuffle;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			if (_tmp40_) {
#line 2349 "gnome-mahjongg.c"
				const gchar* _tmp41_ = NULL;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp41_ = _ ("You can also try to reshuffle the game, but this does not guarantee a " \
"solution.");
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp39_ = _tmp41_;
#line 2355 "gnome-mahjongg.c"
			} else {
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp39_ = "";
#line 2359 "gnome-mahjongg.c"
			}
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp42_ = dialog;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp43_ = _ ("Each puzzle has at least one solution.  You can undo your moves and tr" \
"y and find the solution, restart this game, or start a new one.");
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp44_ = g_strdup_printf ("%s%s%s", _tmp43_, _tmp37_, _tmp39_);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp45_ = _tmp44_;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			gtk_message_dialog_format_secondary_text (_tmp42_, "%s", _tmp45_);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_free0 (_tmp45_);
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp47_ = allow_shuffle;
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			if (_tmp47_) {
#line 2377 "gnome-mahjongg.c"
				const gchar* _tmp48_ = NULL;
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp48_ = _ ("_Shuffle");
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp46_ = _tmp48_;
#line 2383 "gnome-mahjongg.c"
			} else {
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp46_ = NULL;
#line 2387 "gnome-mahjongg.c"
			}
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp49_ = dialog;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp50_ = _ ("_Undo");
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp51_ = _ ("_Restart");
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp52_ = _ ("_New game");
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			gtk_dialog_add_buttons ((GtkDialog*) _tmp49_, _tmp50_, MAHJONGG_NO_MOVES_DIALOG_RESPONSE_UNDO, _tmp51_, MAHJONGG_NO_MOVES_DIALOG_RESPONSE_RESTART, _tmp52_, MAHJONGG_NO_MOVES_DIALOG_RESPONSE_NEW_GAME, _tmp46_, MAHJONGG_NO_MOVES_DIALOG_RESPONSE_SHUFFLE, NULL);
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp53_ = dialog;
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp54_ = gtk_dialog_run ((GtkDialog*) _tmp53_);
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_result_ = _tmp54_;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp55_ = dialog;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp55_);
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp56_ = _result_;
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			switch (_tmp56_) {
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				case MAHJONGG_NO_MOVES_DIALOG_RESPONSE_UNDO:
#line 2415 "gnome-mahjongg.c"
				{
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					mahjongg_undo_cb (self);
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					break;
#line 2421 "gnome-mahjongg.c"
				}
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				case MAHJONGG_NO_MOVES_DIALOG_RESPONSE_SHUFFLE:
#line 2425 "gnome-mahjongg.c"
				{
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					mahjongg_shuffle_cb (self);
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					break;
#line 2431 "gnome-mahjongg.c"
				}
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				case MAHJONGG_NO_MOVES_DIALOG_RESPONSE_RESTART:
#line 2435 "gnome-mahjongg.c"
				{
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					mahjongg_restart_game (self);
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					break;
#line 2441 "gnome-mahjongg.c"
				}
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				case MAHJONGG_NO_MOVES_DIALOG_RESPONSE_NEW_GAME:
#line 2445 "gnome-mahjongg.c"
				{
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					mahjongg_new_game (self);
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					break;
#line 2451 "gnome-mahjongg.c"
				}
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				case GTK_RESPONSE_DELETE_EVENT:
#line 2455 "gnome-mahjongg.c"
				{
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					break;
#line 2459 "gnome-mahjongg.c"
				}
				default:
				{
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					g_assert_not_reached ();
#line 2465 "gnome-mahjongg.c"
				}
			}
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_object_unref0 (dialog);
#line 2470 "gnome-mahjongg.c"
		}
	}
}


static gint mahjongg_show_scores (Mahjongg* self, HistoryEntry* selected_entry, gboolean show_quit) {
	gint result = 0;
	ScoreDialog* dialog = NULL;
	History* _tmp0_ = NULL;
	HistoryEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	ScoreDialog* _tmp3_ = NULL;
	GtkApplicationWindow* _tmp4_ = NULL;
	gint _result_ = 0;
	gint _tmp5_ = 0;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->history;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = selected_entry;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = show_quit;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = score_dialog_new (_tmp0_, _tmp1_, _tmp2_);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp3_);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	dialog = _tmp3_;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_window_set_modal ((GtkWindow*) dialog, TRUE);
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = self->priv->window;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_window_set_transient_for ((GtkWindow*) dialog, (GtkWindow*) _tmp4_);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = gtk_dialog_run ((GtkDialog*) dialog);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_result_ = _tmp5_;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_destroy ((GtkWidget*) dialog);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	result = _result_;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (dialog);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	return result;
#line 2518 "gnome-mahjongg.c"
}


static void _mahjongg_preferences_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_preferences_dialog_response_cb ((Mahjongg*) self, _sender, response_id);
#line 2525 "gnome-mahjongg.c"
}


static void _mahjongg_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_theme_changed_cb ((Mahjongg*) self, _sender);
#line 2532 "gnome-mahjongg.c"
}


static void _mahjongg_map_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_map_changed_cb ((Mahjongg*) self, _sender);
#line 2539 "gnome-mahjongg.c"
}


static void _mahjongg_background_changed_cb_gtk_color_button_color_set (GtkColorButton* _sender, gpointer self) {
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_background_changed_cb ((Mahjongg*) self, _sender);
#line 2546 "gnome-mahjongg.c"
}


static void _g_free0_ (gpointer var) {
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	var = (g_free (var), NULL);
#line 2553 "gnome-mahjongg.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_list_free (self);
#line 2562 "gnome-mahjongg.c"
}


static void mahjongg_preferences_cb (Mahjongg* self) {
	GtkDialog* _tmp0_ = NULL;
	gboolean dialogs_use_header = FALSE;
	GtkSettings* _tmp2_ = NULL;
	GtkDialogFlags _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	GtkApplicationWindow* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	GtkBox* dialog_content_area = NULL;
	GtkDialog* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkBox* _tmp11_ = NULL;
	GtkBox* _tmp12_ = NULL;
	GtkDialog* _tmp13_ = NULL;
	GtkDialog* _tmp14_ = NULL;
	GtkDialog* _tmp15_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp16_ = NULL;
	GtkGrid* _tmp17_ = NULL;
	GtkGrid* _tmp18_ = NULL;
	GtkGrid* _tmp19_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkGrid* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GList* themes = NULL;
	GList* _tmp25_ = NULL;
	GtkComboBox* theme_combo = NULL;
	GtkComboBox* _tmp26_ = NULL;
	GtkListStore* theme_store = NULL;
	GtkListStore* _tmp27_ = NULL;
	GtkComboBox* _tmp28_ = NULL;
	GtkListStore* _tmp29_ = NULL;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp30_ = NULL;
	GtkComboBox* _tmp31_ = NULL;
	GtkCellRendererText* _tmp32_ = NULL;
	GtkComboBox* _tmp33_ = NULL;
	GtkCellRendererText* _tmp34_ = NULL;
	GList* _tmp35_ = NULL;
	GtkComboBox* _tmp56_ = NULL;
	GtkComboBox* _tmp57_ = NULL;
	GtkGrid* _tmp58_ = NULL;
	GtkComboBox* _tmp59_ = NULL;
	GtkLabel* _tmp60_ = NULL;
	GtkComboBox* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	GtkLabel* _tmp63_ = NULL;
	GtkLabel* _tmp64_ = NULL;
	GtkGrid* _tmp65_ = NULL;
	GtkLabel* _tmp66_ = NULL;
	GtkComboBox* map_combo = NULL;
	GtkComboBox* _tmp67_ = NULL;
	GtkListStore* map_store = NULL;
	GtkListStore* _tmp68_ = NULL;
	GtkComboBox* _tmp69_ = NULL;
	GtkListStore* _tmp70_ = NULL;
	GtkCellRendererText* _tmp71_ = NULL;
	GtkComboBox* _tmp72_ = NULL;
	GtkCellRendererText* _tmp73_ = NULL;
	GtkComboBox* _tmp74_ = NULL;
	GtkCellRendererText* _tmp75_ = NULL;
	GList* _tmp76_ = NULL;
	GtkComboBox* _tmp96_ = NULL;
	GtkComboBox* _tmp97_ = NULL;
	GtkGrid* _tmp98_ = NULL;
	GtkComboBox* _tmp99_ = NULL;
	GtkLabel* _tmp100_ = NULL;
	GtkComboBox* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	GtkLabel* _tmp103_ = NULL;
	GtkLabel* _tmp104_ = NULL;
	GtkGrid* _tmp105_ = NULL;
	GtkLabel* _tmp106_ = NULL;
	GtkColorButton* widget = NULL;
	GtkColorButton* _tmp107_ = NULL;
	GtkColorButton* _tmp108_ = NULL;
	GameView* _tmp109_ = NULL;
	GdkRGBA _tmp110_ = {0};
	GtkColorButton* _tmp111_ = NULL;
	GtkColorButton* _tmp112_ = NULL;
	GtkGrid* _tmp113_ = NULL;
	GtkColorButton* _tmp114_ = NULL;
	GtkLabel* _tmp115_ = NULL;
	GtkColorButton* _tmp116_ = NULL;
	GtkBox* _tmp117_ = NULL;
	GtkGrid* _tmp118_ = NULL;
	gboolean _tmp119_ = FALSE;
	GtkDialog* _tmp122_ = NULL;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp0_ != NULL) {
#line 2665 "gnome-mahjongg.c"
		GtkDialog* _tmp1_ = NULL;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp1_ = self->priv->preferences_dialog;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		gtk_window_present ((GtkWindow*) _tmp1_);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		return;
#line 2673 "gnome-mahjongg.c"
	}
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = gtk_settings_get_default ();
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_get ((GObject*) _tmp2_, "gtk-dialogs-use-header", &dialogs_use_header, NULL);
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = dialogs_use_header;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp4_) {
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp3_ = GTK_DIALOG_USE_HEADER_BAR;
#line 2685 "gnome-mahjongg.c"
	} else {
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp3_ = 0;
#line 2689 "gnome-mahjongg.c"
	}
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = _ ("Preferences");
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp6_ = self->priv->window;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp7_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp5_, (GtkWindow*) _tmp6_, _tmp3_, NULL, NULL);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp7_);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->preferences_dialog = _tmp7_;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp8_ = self->priv->preferences_dialog;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp8_, (guint) 5);
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp9_ = self->priv->preferences_dialog;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp10_ = (GtkBox*) gtk_dialog_get_content_area (_tmp9_);
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_box_get_type (), GtkBox));
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	dialog_content_area = _tmp11_;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp12_ = dialog_content_area;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_box_set_spacing (_tmp12_, 2);
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp13_ = self->priv->preferences_dialog;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_window_set_resizable ((GtkWindow*) _tmp13_, FALSE);
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_ = self->priv->preferences_dialog;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_dialog_set_default_response (_tmp14_, (gint) GTK_RESPONSE_CLOSE);
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp15_ = self->priv->preferences_dialog;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_signal_connect_object (_tmp15_, "response", (GCallback) _mahjongg_preferences_dialog_response_cb_gtk_dialog_response, self, 0);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp16_ = (GtkGrid*) gtk_grid_new ();
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp16_);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	grid = _tmp16_;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp17_ = grid;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp17_, (guint) 5);
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp18_ = grid;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_grid_set_row_spacing (_tmp18_, (guint) 6);
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp19_ = grid;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_grid_set_column_spacing (_tmp19_, (guint) 18);
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp20_ = _ ("_Theme:");
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp21_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp20_);
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp21_);
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	label = _tmp21_;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp22_ = label;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp22_, (gfloat) 0, 0.5f);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp23_ = grid;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp24_ = label;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_grid_attach (_tmp23_, (GtkWidget*) _tmp24_, 0, 0, 1, 1);
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp25_ = mahjongg_load_themes (self);
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	themes = _tmp25_;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp26_ = (GtkComboBox*) gtk_combo_box_new ();
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp26_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	theme_combo = _tmp26_;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp27_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	theme_store = _tmp27_;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp28_ = theme_combo;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp29_ = theme_store;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_combo_box_set_model (_tmp28_, (GtkTreeModel*) _tmp29_);
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp30_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp30_);
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	renderer = _tmp30_;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp31_ = theme_combo;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp32_ = renderer;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp31_, (GtkCellRenderer*) _tmp32_, TRUE);
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp33_ = theme_combo;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp34_ = renderer;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp33_, (GtkCellRenderer*) _tmp34_, "text", 0);
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp35_ = themes;
#line 2807 "gnome-mahjongg.c"
	{
		GList* theme_collection = NULL;
		GList* theme_it = NULL;
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		theme_collection = _tmp35_;
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		for (theme_it = theme_collection; theme_it != NULL; theme_it = theme_it->next) {
#line 2815 "gnome-mahjongg.c"
			gchar* _tmp36_ = NULL;
			gchar* theme = NULL;
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp36_ = g_strdup ((const gchar*) theme_it->data);
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			theme = _tmp36_;
#line 2822 "gnome-mahjongg.c"
			{
				gchar** tokens = NULL;
				const gchar* _tmp37_ = NULL;
				gchar** _tmp38_ = NULL;
				gchar** _tmp39_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gchar* name = NULL;
				gchar** _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				const gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp43_ = NULL;
				GtkTreeIter _tmp44_ = {0};
				GtkListStore* _tmp45_ = NULL;
				GtkTreeIter _tmp46_ = {0};
				const gchar* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				const gchar* _tmp49_ = NULL;
				GSettings* _tmp50_ = NULL;
				gchar* _tmp51_ = NULL;
				gchar* _tmp52_ = NULL;
				gboolean _tmp53_ = FALSE;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp37_ = theme;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp39_ = _tmp38_ = g_strsplit (_tmp37_, ".", -1);
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				tokens = _tmp39_;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				tokens_length1 = _vala_array_length (_tmp38_);
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tokens_size_ = tokens_length1;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp40_ = tokens;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp40__length1 = tokens_length1;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp41_ = _tmp40_[0];
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp42_ = g_strdup (_tmp41_);
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				name = _tmp42_;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp43_ = theme_store;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				gtk_list_store_append (_tmp43_, &_tmp44_);
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				iter = _tmp44_;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp45_ = theme_store;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp46_ = iter;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp47_ = name;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp48_ = theme;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				gtk_list_store_set (_tmp45_, &_tmp46_, 0, _tmp47_, 1, _tmp48_, -1, -1);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp49_ = theme;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp50_ = self->priv->settings;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp51_ = g_settings_get_string (_tmp50_, "tileset");
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp52_ = _tmp51_;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp53_ = g_strcmp0 (_tmp49_, _tmp52_) == 0;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_g_free0 (_tmp52_);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				if (_tmp53_) {
#line 2897 "gnome-mahjongg.c"
					GtkComboBox* _tmp54_ = NULL;
					GtkTreeIter _tmp55_ = {0};
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp54_ = theme_combo;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp55_ = iter;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					gtk_combo_box_set_active_iter (_tmp54_, &_tmp55_);
#line 2906 "gnome-mahjongg.c"
				}
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_g_free0 (name);
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_g_free0 (theme);
#line 2914 "gnome-mahjongg.c"
			}
		}
	}
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp56_ = theme_combo;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_signal_connect_object (_tmp56_, "changed", (GCallback) _mahjongg_theme_changed_cb_gtk_combo_box_changed, self, 0);
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp57_ = theme_combo;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp57_, TRUE);
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp58_ = grid;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp59_ = theme_combo;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_grid_attach (_tmp58_, (GtkWidget*) _tmp59_, 1, 0, 1, 1);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp60_ = label;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp61_ = theme_combo;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_label_set_mnemonic_widget (_tmp60_, (GtkWidget*) _tmp61_);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp62_ = _ ("_Layout:");
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp63_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp62_);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp63_);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (label);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	label = _tmp63_;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp64_ = label;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp64_, (gfloat) 0, 0.5f);
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp65_ = grid;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp66_ = label;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_grid_attach (_tmp65_, (GtkWidget*) _tmp66_, 0, 1, 1, 1);
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp67_ = (GtkComboBox*) gtk_combo_box_new ();
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp67_);
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	map_combo = _tmp67_;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp68_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	map_store = _tmp68_;
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp69_ = map_combo;
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp70_ = map_store;
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_combo_box_set_model (_tmp69_, (GtkTreeModel*) _tmp70_);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp71_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp71_);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (renderer);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	renderer = _tmp71_;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp72_ = map_combo;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp73_ = renderer;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp72_, (GtkCellRenderer*) _tmp73_, TRUE);
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp74_ = map_combo;
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp75_ = renderer;
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp74_, (GtkCellRenderer*) _tmp75_, "text", 0);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp76_ = self->priv->maps;
#line 2996 "gnome-mahjongg.c"
	{
		GList* map_collection = NULL;
		GList* map_it = NULL;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		map_collection = _tmp76_;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		for (map_it = map_collection; map_it != NULL; map_it = map_it->next) {
#line 3004 "gnome-mahjongg.c"
			Map* _tmp77_ = NULL;
			Map* map = NULL;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp77_ = _g_object_ref0 ((Map*) map_it->data);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			map = _tmp77_;
#line 3011 "gnome-mahjongg.c"
			{
				gchar* display_name = NULL;
				Map* _tmp78_ = NULL;
				const gchar* _tmp79_ = NULL;
				const gchar* _tmp80_ = NULL;
				gchar* _tmp81_ = NULL;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp82_ = NULL;
				GtkTreeIter _tmp83_ = {0};
				GtkListStore* _tmp84_ = NULL;
				GtkTreeIter _tmp85_ = {0};
				const gchar* _tmp86_ = NULL;
				Map* _tmp87_ = NULL;
				GSettings* _tmp88_ = NULL;
				gchar* _tmp89_ = NULL;
				gchar* _tmp90_ = NULL;
				Map* _tmp91_ = NULL;
				const gchar* _tmp92_ = NULL;
				gboolean _tmp93_ = FALSE;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp78_ = map;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp79_ = _tmp78_->name;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp80_ = g_dpgettext2 (NULL, "mahjongg map name", _tmp79_);
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp81_ = g_strdup (_tmp80_);
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				display_name = _tmp81_;
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp82_ = map_store;
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				gtk_list_store_append (_tmp82_, &_tmp83_);
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				iter = _tmp83_;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp84_ = map_store;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp85_ = iter;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp86_ = display_name;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp87_ = map;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				gtk_list_store_set (_tmp84_, &_tmp85_, 0, _tmp86_, 1, _tmp87_, -1, -1);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp88_ = self->priv->settings;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp89_ = g_settings_get_string (_tmp88_, "mapset");
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp90_ = _tmp89_;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp91_ = map;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp92_ = _tmp91_->name;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp93_ = g_strcmp0 (_tmp90_, _tmp92_) == 0;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_g_free0 (_tmp90_);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				if (_tmp93_) {
#line 3073 "gnome-mahjongg.c"
					GtkComboBox* _tmp94_ = NULL;
					GtkTreeIter _tmp95_ = {0};
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp94_ = map_combo;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp95_ = iter;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					gtk_combo_box_set_active_iter (_tmp94_, &_tmp95_);
#line 3082 "gnome-mahjongg.c"
				}
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_g_free0 (display_name);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_g_object_unref0 (map);
#line 3088 "gnome-mahjongg.c"
			}
		}
	}
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp96_ = map_combo;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_signal_connect_object (_tmp96_, "changed", (GCallback) _mahjongg_map_changed_cb_gtk_combo_box_changed, self, 0);
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp97_ = map_combo;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp97_, TRUE);
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp98_ = grid;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp99_ = map_combo;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_grid_attach (_tmp98_, (GtkWidget*) _tmp99_, 1, 1, 1, 1);
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp100_ = label;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp101_ = map_combo;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_label_set_mnemonic_widget (_tmp100_, (GtkWidget*) _tmp101_);
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp102_ = _ ("_Background color:");
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp103_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp102_);
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp103_);
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (label);
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	label = _tmp103_;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp104_ = label;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp104_, (gfloat) 0, 0.5f);
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp105_ = grid;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp106_ = label;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_grid_attach (_tmp105_, (GtkWidget*) _tmp106_, 0, 2, 1, 1);
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp107_ = (GtkColorButton*) gtk_color_button_new ();
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_ref_sink (_tmp107_);
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	widget = _tmp107_;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp108_ = widget;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp109_ = self->priv->game_view;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp110_ = _tmp109_->background_color;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp108_, &_tmp110_);
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp111_ = widget;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_signal_connect_object (_tmp111_, "color-set", (GCallback) _mahjongg_background_changed_cb_gtk_color_button_color_set, self, 0);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp112_ = widget;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp112_, TRUE);
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp113_ = grid;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp114_ = widget;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_grid_attach (_tmp113_, (GtkWidget*) _tmp114_, 1, 2, 1, 1);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp115_ = label;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp116_ = widget;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_label_set_mnemonic_widget (_tmp115_, (GtkWidget*) _tmp116_);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp117_ = dialog_content_area;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp118_ = grid;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_box_pack_start (_tmp117_, (GtkWidget*) _tmp118_, TRUE, TRUE, (guint) 0);
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp119_ = dialogs_use_header;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (!_tmp119_) {
#line 3176 "gnome-mahjongg.c"
		GtkDialog* _tmp120_ = NULL;
		const gchar* _tmp121_ = NULL;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp120_ = self->priv->preferences_dialog;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp121_ = _ ("_Close");
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		gtk_dialog_add_button (_tmp120_, _tmp121_, (gint) GTK_RESPONSE_CLOSE);
#line 3185 "gnome-mahjongg.c"
	}
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp122_ = self->priv->preferences_dialog;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp122_);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (widget);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (map_store);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (map_combo);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (renderer);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (theme_store);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (theme_combo);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	__g_list_free__g_free0_0 (themes);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (label);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (grid);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (dialog_content_area);
#line 3211 "gnome-mahjongg.c"
}


static void mahjongg_preferences_dialog_response_cb (Mahjongg* self, GtkDialog* dialog, gint response) {
	GtkDialog* _tmp0_ = NULL;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (dialog != NULL);
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->preferences_dialog = NULL;
#line 3229 "gnome-mahjongg.c"
}


static GList* mahjongg_load_themes (Mahjongg* self) {
	GList* result = NULL;
	GList* themes = NULL;
	GDir* dir = NULL;
	GError * _inner_error_ = NULL;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	themes = NULL;
#line 3242 "gnome-mahjongg.c"
	{
		GDir* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GDir* _tmp3_ = NULL;
		GDir* _tmp4_ = NULL;
		GDir* _tmp5_ = NULL;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp1_ = g_build_filename (DATA_DIRECTORY, "themes", NULL);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp2_ = _tmp1_;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp3_ = g_dir_open (_tmp2_, (guint) 0, &_inner_error_);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp4_ = _tmp3_;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_free0 (_tmp2_);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp0_ = _tmp4_;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 3266 "gnome-mahjongg.c"
				goto __catch4_g_file_error;
			}
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_dir_close0 (dir);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			__g_list_free__g_free0_0 (themes);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			g_clear_error (&_inner_error_);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			return NULL;
#line 3279 "gnome-mahjongg.c"
		}
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp5_ = _tmp0_;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp0_ = NULL;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_dir_close0 (dir);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		dir = _tmp5_;
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_dir_close0 (_tmp0_);
#line 3291 "gnome-mahjongg.c"
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		e = _inner_error_;
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_inner_error_ = NULL;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		result = themes;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_error_free0 (e);
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_dir_close0 (dir);
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		return result;
#line 3309 "gnome-mahjongg.c"
	}
	__finally4:
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_dir_close0 (dir);
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		__g_list_free__g_free0_0 (themes);
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_clear_error (&_inner_error_);
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		return NULL;
#line 3324 "gnome-mahjongg.c"
	}
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	while (TRUE) {
#line 3328 "gnome-mahjongg.c"
		gchar* s = NULL;
		GDir* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp6_ = dir;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp7_ = g_dir_read_name (_tmp6_);
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		s = _tmp8_;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp9_ = s;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (_tmp9_ == NULL) {
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_free0 (s);
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			break;
#line 3357 "gnome-mahjongg.c"
		}
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp15_ = s;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp16_ = g_str_has_suffix (_tmp15_, ".xpm");
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (_tmp16_) {
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp14_ = TRUE;
#line 3367 "gnome-mahjongg.c"
		} else {
			const gchar* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp17_ = s;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp18_ = g_str_has_suffix (_tmp17_, ".svg");
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp14_ = _tmp18_;
#line 3377 "gnome-mahjongg.c"
		}
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (_tmp14_) {
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp13_ = TRUE;
#line 3383 "gnome-mahjongg.c"
		} else {
			const gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp19_ = s;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp20_ = g_str_has_suffix (_tmp19_, ".gif");
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp13_ = _tmp20_;
#line 3393 "gnome-mahjongg.c"
		}
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (_tmp13_) {
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp12_ = TRUE;
#line 3399 "gnome-mahjongg.c"
		} else {
			const gchar* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp21_ = s;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp22_ = g_str_has_suffix (_tmp21_, ".png");
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp12_ = _tmp22_;
#line 3409 "gnome-mahjongg.c"
		}
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (_tmp12_) {
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp11_ = TRUE;
#line 3415 "gnome-mahjongg.c"
		} else {
			const gchar* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp23_ = s;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp24_ = g_str_has_suffix (_tmp23_, ".jpg");
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp11_ = _tmp24_;
#line 3425 "gnome-mahjongg.c"
		}
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (_tmp11_) {
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp10_ = TRUE;
#line 3431 "gnome-mahjongg.c"
		} else {
			const gchar* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp25_ = s;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp26_ = g_str_has_suffix (_tmp25_, ".xbm");
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp10_ = _tmp26_;
#line 3441 "gnome-mahjongg.c"
		}
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (_tmp10_) {
#line 3445 "gnome-mahjongg.c"
			const gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp27_ = s;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp28_ = g_strdup (_tmp27_);
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			themes = g_list_append (themes, _tmp28_);
#line 3454 "gnome-mahjongg.c"
		}
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_free0 (s);
#line 3458 "gnome-mahjongg.c"
	}
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	result = themes;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_dir_close0 (dir);
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	return result;
#line 3466 "gnome-mahjongg.c"
}


static void mahjongg_hint_cb (Mahjongg* self) {
	GList* matches = NULL;
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	GameView* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	Tile* _tmp6_ = NULL;
	Tile* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	gint32 n = 0;
	GList* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
	gint32 _tmp22_ = 0;
	Match* match = NULL;
	GList* _tmp23_ = NULL;
	gint32 _tmp24_ = 0;
	gconstpointer _tmp25_ = NULL;
	Match* _tmp26_ = NULL;
	GameView* _tmp27_ = NULL;
	Game* _tmp28_ = NULL;
	Game* _tmp29_ = NULL;
	Match* _tmp30_ = NULL;
	Tile* _tmp31_ = NULL;
	Match* _tmp32_ = NULL;
	Tile* _tmp33_ = NULL;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->game_view;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = game_view_get_game (_tmp0_);
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = _tmp1_;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = self->priv->game_view;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = game_view_get_game (_tmp3_);
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = _tmp4_;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp6_ = game_get_selected_tile (_tmp5_);
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp7_ = _tmp6_;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp8_ = game_find_matches (_tmp2_, _tmp7_);
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	matches = _tmp8_;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp9_ = matches;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp10_ = g_list_length (_tmp9_);
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp10_ == ((guint) 0)) {
#line 3527 "gnome-mahjongg.c"
		GameView* _tmp11_ = NULL;
		Game* _tmp12_ = NULL;
		Game* _tmp13_ = NULL;
		Tile* _tmp14_ = NULL;
		Tile* _tmp15_ = NULL;
		GameView* _tmp16_ = NULL;
		Game* _tmp17_ = NULL;
		Game* _tmp18_ = NULL;
		GList* _tmp19_ = NULL;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp11_ = self->priv->game_view;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp12_ = game_view_get_game (_tmp11_);
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp13_ = _tmp12_;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp14_ = game_get_selected_tile (_tmp13_);
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp15_ = _tmp14_;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (_tmp15_ == NULL) {
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			__g_list_free__g_object_unref0_0 (matches);
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			return;
#line 3553 "gnome-mahjongg.c"
		}
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp16_ = self->priv->game_view;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp17_ = game_view_get_game (_tmp16_);
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp18_ = _tmp17_;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp19_ = game_find_matches (_tmp18_, NULL);
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		__g_list_free__g_object_unref0_0 (matches);
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		matches = _tmp19_;
#line 3567 "gnome-mahjongg.c"
	}
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp20_ = matches;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp21_ = g_list_length (_tmp20_);
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp22_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp21_));
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	n = _tmp22_;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp23_ = matches;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp24_ = n;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp25_ = g_list_nth_data (_tmp23_, (guint) _tmp24_);
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp26_ = _g_object_ref0 ((Match*) _tmp25_);
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	match = _tmp26_;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp27_ = self->priv->game_view;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp28_ = game_view_get_game (_tmp27_);
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp29_ = _tmp28_;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp30_ = match;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp31_ = _tmp30_->tile0;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp32_ = match;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp33_ = _tmp32_->tile1;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	game_set_hint (_tmp29_, _tmp31_, _tmp33_);
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_update_ui (self);
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (match);
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	__g_list_free__g_object_unref0_0 (matches);
#line 3609 "gnome-mahjongg.c"
}


static void mahjongg_shuffle_cb (Mahjongg* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->game_view;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = game_view_get_game (_tmp0_);
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = _tmp1_;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	game_shuffle_remaining (_tmp2_, TRUE);
#line 3627 "gnome-mahjongg.c"
}


static void mahjongg_about_cb (Mahjongg* self) {
	gchar** authors = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** artists = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar** _tmp25_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GtkApplicationWindow* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = _ ("Main game:");
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = g_strdup ("Francisco Bustamante");
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = g_strdup ("Max Watson");
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = g_strdup ("Heinz Hempe");
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = g_strdup ("Michael Meeks");
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp6_ = g_strdup ("Philippe Chavin");
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp7_ = g_strdup ("Callum McKenzie");
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp8_ = g_strdup ("Robert Ancell");
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp9_ = g_strdup ("");
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp10_ = _ ("Maps:");
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp12_ = g_strdup ("Rexford Newbould");
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp13_ = g_strdup ("Krzysztof Foltman");
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_ = g_new0 (gchar*, 13 + 1);
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_[0] = _tmp1_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_[1] = _tmp2_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_[2] = _tmp3_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_[3] = _tmp4_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_[4] = _tmp5_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_[5] = _tmp6_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_[6] = _tmp7_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_[7] = _tmp8_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_[8] = _tmp9_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_[9] = _tmp11_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_[10] = _tmp12_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_[11] = _tmp13_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_[12] = NULL;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	authors = _tmp14_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	authors_length1 = 13;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_authors_size_ = authors_length1;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp15_ = _ ("Tiles:");
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp17_ = g_strdup ("Jonathan Buzzard");
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp18_ = g_strdup ("Jim Evans");
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp19_ = g_strdup ("Richard Hoelscher");
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp20_ = g_strdup ("Gonzalo Odiard");
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp21_ = g_strdup ("Max Watson");
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp22_ = g_new0 (gchar*, 7 + 1);
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp22_[0] = _tmp16_;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp22_[1] = _tmp17_;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp22_[2] = _tmp18_;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp22_[3] = _tmp19_;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp22_[4] = _tmp20_;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp22_[5] = _tmp21_;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp22_[6] = NULL;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	artists = _tmp22_;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	artists_length1 = 7;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_artists_size_ = artists_length1;
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp23_ = g_strdup ("Tiffany Antopolski");
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp24_ = g_strdup ("Chris Beiser");
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp25_ = g_new0 (gchar*, 3 + 1);
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp25_[0] = _tmp23_;
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp25_[1] = _tmp24_;
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp25_[2] = NULL;
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	documenters = _tmp25_;
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	documenters_length1 = 3;
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_documenters_size_ = documenters_length1;
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp26_ = self->priv->window;
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp27_ = _ ("Mahjongg");
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp28_ = _ ("A matching game played with Mahjongg tiles");
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp29_ = _ ("translator-credits");
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp26_, "program-name", _tmp27_, "version", VERSION, "comments", _tmp28_, "copyright", "Copyright © 1998–2008 Free Software Foundation, Inc.", "license-type", GTK_LICENSE_GPL_2_0, "authors", authors, "artists", artists, "documenters", documenters, "translator-credits", _tmp29_, "logo-icon-name", "gnome-mahjongg", "website", "https://wiki.gnome.org/Apps/Mahjongg", NULL, NULL);
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 3805 "gnome-mahjongg.c"
}


static void mahjongg_pause_cb (Mahjongg* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	GameView* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GameView* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	Game* _tmp10_ = NULL;
	GameView* _tmp11_ = NULL;
	Game* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
	GtkImage* pause_image = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkWidget* _tmp15_ = NULL;
	GtkWidget* _tmp16_ = NULL;
	GtkImage* _tmp17_ = NULL;
	GameView* _tmp18_ = NULL;
	Game* _tmp19_ = NULL;
	Game* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
#line 645 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->game_view;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = game_view_get_game (_tmp0_);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = _tmp1_;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = self->priv->game_view;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = game_view_get_game (_tmp3_);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = _tmp4_;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp6_ = game_get_paused (_tmp5_);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp7_ = _tmp6_;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	game_set_paused (_tmp2_, !_tmp7_);
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp8_ = self->priv->game_view;
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp9_ = game_view_get_game (_tmp8_);
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp10_ = _tmp9_;
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	game_set_hint (_tmp10_, NULL, NULL);
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp11_ = self->priv->game_view;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp12_ = game_view_get_game (_tmp11_);
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp13_ = _tmp12_;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	game_set_selected_tile (_tmp13_, NULL);
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_ = self->priv->pause_button;
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp15_ = gtk_button_get_image (_tmp14_);
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp16_ = _tmp15_;
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_image_get_type (), GtkImage));
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	pause_image = _tmp17_;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp18_ = self->priv->game_view;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp19_ = game_view_get_game (_tmp18_);
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp20_ = _tmp19_;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp21_ = game_get_paused (_tmp20_);
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp22_ = _tmp21_;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp22_) {
#line 3892 "gnome-mahjongg.c"
		GtkImage* _tmp23_ = NULL;
		GtkButton* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp23_ = pause_image;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_object_set (_tmp23_, "icon-name", "media-playback-start-symbolic", NULL);
#line 655 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp24_ = self->priv->pause_button;
#line 655 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp25_ = _ ("Unpause the game");
#line 655 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp24_, _tmp25_);
#line 3906 "gnome-mahjongg.c"
	} else {
		GtkImage* _tmp26_ = NULL;
		GtkButton* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp26_ = pause_image;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_object_set (_tmp26_, "icon-name", "media-playback-pause-symbolic", NULL);
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp27_ = self->priv->pause_button;
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp28_ = _ ("Pause the game");
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp27_, _tmp28_);
#line 3921 "gnome-mahjongg.c"
	}
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_update_ui (self);
#line 645 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (pause_image);
#line 3927 "gnome-mahjongg.c"
}


static void mahjongg_scores_cb (Mahjongg* self) {
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 668 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_show_scores (self, NULL, FALSE);
#line 3936 "gnome-mahjongg.c"
}


static void mahjongg_new_game_cb (Mahjongg* self) {
#line 671 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_new_game (self);
#line 3945 "gnome-mahjongg.c"
}


static void mahjongg_restart_game_cb (Mahjongg* self) {
#line 676 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_restart_game (self);
#line 3954 "gnome-mahjongg.c"
}


static void mahjongg_quit_cb (Mahjongg* self) {
	GtkApplicationWindow* _tmp0_ = NULL;
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 683 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->window;
#line 683 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 3966 "gnome-mahjongg.c"
}


static void mahjongg_redo_cb (Mahjongg* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GameView* _tmp5_ = NULL;
	Game* _tmp6_ = NULL;
	Game* _tmp7_ = NULL;
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->game_view;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = game_view_get_game (_tmp0_);
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = _tmp1_;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = game_get_paused (_tmp2_);
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = _tmp3_;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp4_) {
#line 689 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		return;
#line 3995 "gnome-mahjongg.c"
	}
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = self->priv->game_view;
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp6_ = game_view_get_game (_tmp5_);
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp7_ = _tmp6_;
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	game_redo (_tmp7_);
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_update_ui (self);
#line 4007 "gnome-mahjongg.c"
}


static void mahjongg_undo_cb (Mahjongg* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->game_view;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = game_view_get_game (_tmp0_);
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = _tmp1_;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	game_undo (_tmp2_);
#line 698 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_update_ui (self);
#line 4027 "gnome-mahjongg.c"
}


static void mahjongg_restart_game (Mahjongg* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	GameView* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->game_view;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = game_view_get_game (_tmp0_);
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = _tmp1_;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	game_reset (_tmp2_);
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = self->priv->game_view;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp4_ = game_view_get_game (_tmp3_);
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp5_ = _tmp4_;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp6_ = game_get_paused (_tmp5_);
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp7_ = _tmp6_;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp7_) {
#line 705 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		mahjongg_pause_cb (self);
#line 4064 "gnome-mahjongg.c"
	}
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_update_ui (self);
#line 4068 "gnome-mahjongg.c"
}


static void _mahjongg_moved_cb_game_moved (Game* _sender, gpointer self) {
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_moved_cb ((Mahjongg*) self);
#line 4075 "gnome-mahjongg.c"
}


static void _mahjongg_tick_cb_game_tick (Game* _sender, gpointer self) {
#line 725 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_tick_cb ((Mahjongg*) self);
#line 4082 "gnome-mahjongg.c"
}


static void mahjongg_new_game (Mahjongg* self) {
	Map* map = NULL;
	GList* _tmp0_ = NULL;
	Map* _tmp10_ = NULL;
	GameView* _tmp14_ = NULL;
	Map* _tmp15_ = NULL;
	Game* _tmp16_ = NULL;
	Game* _tmp17_ = NULL;
	GameView* _tmp18_ = NULL;
	Game* _tmp19_ = NULL;
	Game* _tmp20_ = NULL;
	GameView* _tmp21_ = NULL;
	Game* _tmp22_ = NULL;
	Game* _tmp23_ = NULL;
	gchar* display_name = NULL;
	GameView* _tmp24_ = NULL;
	Game* _tmp25_ = NULL;
	Game* _tmp26_ = NULL;
	Map* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	GtkLabel* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	GtkImage* pause_image = NULL;
	GtkButton* _tmp33_ = NULL;
	GtkWidget* _tmp34_ = NULL;
	GtkWidget* _tmp35_ = NULL;
	GtkImage* _tmp36_ = NULL;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 711 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	map = NULL;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->maps;
#line 4121 "gnome-mahjongg.c"
	{
		GList* m_collection = NULL;
		GList* m_it = NULL;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		m_collection = _tmp0_;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		for (m_it = m_collection; m_it != NULL; m_it = m_it->next) {
#line 4129 "gnome-mahjongg.c"
			Map* _tmp1_ = NULL;
			Map* m = NULL;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp1_ = _g_object_ref0 ((Map*) m_it->data);
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			m = _tmp1_;
#line 4136 "gnome-mahjongg.c"
			{
				Map* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				GSettings* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
#line 714 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp2_ = m;
#line 714 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp3_ = _tmp2_->name;
#line 714 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp4_ = self->priv->settings;
#line 714 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp5_ = g_settings_get_string (_tmp4_, "mapset");
#line 714 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp6_ = _tmp5_;
#line 714 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp7_ = g_strcmp0 (_tmp3_, _tmp6_) == 0;
#line 714 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_g_free0 (_tmp6_);
#line 714 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				if (_tmp7_) {
#line 4160 "gnome-mahjongg.c"
					Map* _tmp8_ = NULL;
					Map* _tmp9_ = NULL;
#line 716 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp8_ = m;
#line 716 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp9_ = _g_object_ref0 (_tmp8_);
#line 716 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_g_object_unref0 (map);
#line 716 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					map = _tmp9_;
#line 717 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_g_object_unref0 (m);
#line 717 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					break;
#line 4175 "gnome-mahjongg.c"
				}
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_g_object_unref0 (m);
#line 4179 "gnome-mahjongg.c"
			}
		}
	}
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp10_ = map;
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp10_ == NULL) {
#line 4187 "gnome-mahjongg.c"
		GList* _tmp11_ = NULL;
		gconstpointer _tmp12_ = NULL;
		Map* _tmp13_ = NULL;
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp11_ = self->priv->maps;
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp12_ = g_list_nth_data (_tmp11_, (guint) 0);
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp13_ = _g_object_ref0 ((Map*) _tmp12_);
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_object_unref0 (map);
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		map = _tmp13_;
#line 4201 "gnome-mahjongg.c"
	}
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_ = self->priv->game_view;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp15_ = map;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp16_ = game_new (_tmp15_);
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp17_ = _tmp16_;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	game_view_set_game (_tmp14_, _tmp17_);
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (_tmp17_);
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp18_ = self->priv->game_view;
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp19_ = game_view_get_game (_tmp18_);
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp20_ = _tmp19_;
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_signal_connect_object (_tmp20_, "moved", (GCallback) _mahjongg_moved_cb_game_moved, self, 0);
#line 725 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp21_ = self->priv->game_view;
#line 725 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp22_ = game_view_get_game (_tmp21_);
#line 725 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp23_ = _tmp22_;
#line 725 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_signal_connect_object (_tmp23_, "tick", (GCallback) _mahjongg_tick_cb_game_tick, self, 0);
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp24_ = self->priv->game_view;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp25_ = game_view_get_game (_tmp24_);
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp26_ = _tmp25_;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp27_ = _tmp26_->map;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp28_ = _tmp27_->name;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp29_ = g_dpgettext2 (NULL, "mahjongg map name", _tmp28_);
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp30_ = g_strdup (_tmp29_);
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	display_name = _tmp30_;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp31_ = self->priv->title;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp32_ = _ (display_name);
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_label_set_label (_tmp31_, _tmp32_);
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_update_ui (self);
#line 734 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_tick_cb (self);
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp33_ = self->priv->pause_button;
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp34_ = gtk_button_get_image (_tmp33_);
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp35_ = _tmp34_;
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_image_get_type (), GtkImage));
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	pause_image = _tmp36_;
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_object_set (pause_image, "icon-name", "media-playback-pause-symbolic", NULL);
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (pause_image);
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_free0 (display_name);
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (map);
#line 4275 "gnome-mahjongg.c"
}


static void mahjongg_tick_cb (Mahjongg* self) {
	gint elapsed = 0;
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	gint hours = 0;
	gint _tmp8_ = 0;
	gint minutes = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint seconds = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	elapsed = 0;
#line 744 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = self->priv->game_view;
#line 744 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = game_view_get_game (_tmp0_);
#line 744 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = _tmp1_;
#line 744 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp2_ != NULL) {
#line 4306 "gnome-mahjongg.c"
		GameView* _tmp3_ = NULL;
		Game* _tmp4_ = NULL;
		Game* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp3_ = self->priv->game_view;
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp4_ = game_view_get_game (_tmp3_);
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp5_ = _tmp4_;
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp6_ = game_get_elapsed (_tmp5_);
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp7_ = _tmp6_;
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		elapsed = (gint) (_tmp7_ + 0.5);
#line 4324 "gnome-mahjongg.c"
	}
#line 746 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp8_ = elapsed;
#line 746 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	hours = _tmp8_ / 3600;
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp9_ = elapsed;
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp10_ = hours;
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	minutes = (_tmp9_ - (_tmp10_ * 3600)) / 60;
#line 748 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp11_ = elapsed;
#line 748 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp12_ = hours;
#line 748 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp13_ = minutes;
#line 748 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	seconds = (_tmp11_ - (_tmp12_ * 3600)) - (_tmp13_ * 60);
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp14_ = hours;
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (_tmp14_ > 0) {
#line 4348 "gnome-mahjongg.c"
		GtkLabel* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
#line 750 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp15_ = self->priv->clock_label;
#line 750 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp16_ = hours;
#line 750 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp17_ = minutes;
#line 750 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp18_ = seconds;
#line 750 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp19_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", _tmp16_, _tmp17_, _tmp18_);
#line 750 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp20_ = _tmp19_;
#line 750 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		gtk_label_set_text (_tmp15_, _tmp20_);
#line 750 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_free0 (_tmp20_);
#line 4371 "gnome-mahjongg.c"
	} else {
		GtkLabel* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
#line 752 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp21_ = self->priv->clock_label;
#line 752 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp22_ = minutes;
#line 752 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp23_ = seconds;
#line 752 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp24_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", _tmp22_, _tmp23_);
#line 752 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp25_ = _tmp24_;
#line 752 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		gtk_label_set_text (_tmp21_, _tmp25_);
#line 752 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_free0 (_tmp25_);
#line 4392 "gnome-mahjongg.c"
	}
}


static void mahjongg_help_cb (Mahjongg* self) {
	GError * _inner_error_ = NULL;
#line 755 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 4401 "gnome-mahjongg.c"
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 759 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp0_ = self->priv->window;
#line 759 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 759 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 759 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		gtk_show_uri (_tmp1_, "help:gnome-mahjongg", _tmp2_, &_inner_error_);
#line 759 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4416 "gnome-mahjongg.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 757 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		e = _inner_error_;
#line 757 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_inner_error_ = NULL;
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp3_ = e;
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp4_ = _tmp3_->message;
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_warning ("gnome-mahjongg.vala:763: Failed to show help: %s", _tmp4_);
#line 757 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_error_free0 (e);
#line 4438 "gnome-mahjongg.c"
	}
	__finally5:
#line 757 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 757 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 757 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_clear_error (&_inner_error_);
#line 757 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		return;
#line 4449 "gnome-mahjongg.c"
	}
}


static void mahjongg_load_maps (Mahjongg* self) {
	Map* _tmp0_ = NULL;
	GDir* dir = NULL;
	GError * _inner_error_ = NULL;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_return_if_fail (self != NULL);
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	__g_list_free__g_object_unref0_0 (self->priv->maps);
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->maps = NULL;
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = map_new_builtin ();
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->maps = g_list_append (self->priv->maps, _tmp0_);
#line 4468 "gnome-mahjongg.c"
	{
		GDir* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GDir* _tmp4_ = NULL;
		GDir* _tmp5_ = NULL;
		GDir* _tmp6_ = NULL;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp2_ = g_build_filename (DATA_DIRECTORY, "maps", NULL);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp3_ = _tmp2_;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp4_ = g_dir_open (_tmp3_, (guint) 0, &_inner_error_);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp5_ = _tmp4_;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_free0 (_tmp3_);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp1_ = _tmp5_;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 4492 "gnome-mahjongg.c"
				goto __catch6_g_file_error;
			}
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_dir_close0 (dir);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			g_clear_error (&_inner_error_);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			return;
#line 4503 "gnome-mahjongg.c"
		}
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp6_ = _tmp1_;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp1_ = NULL;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_dir_close0 (dir);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		dir = _tmp6_;
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_dir_close0 (_tmp1_);
#line 4515 "gnome-mahjongg.c"
	}
	goto __finally6;
	__catch6_g_file_error:
	{
		GError* e = NULL;
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		e = _inner_error_;
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_inner_error_ = NULL;
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_error_free0 (e);
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_dir_close0 (dir);
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		return;
#line 4531 "gnome-mahjongg.c"
	}
	__finally6:
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_dir_close0 (dir);
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		g_clear_error (&_inner_error_);
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		return;
#line 4544 "gnome-mahjongg.c"
	}
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	while (TRUE) {
#line 4548 "gnome-mahjongg.c"
		gchar* filename = NULL;
		GDir* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		MapLoader* loader = NULL;
		MapLoader* _tmp13_ = NULL;
		gchar* path = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		MapLoader* _tmp21_ = NULL;
		GList* _tmp22_ = NULL;
#line 785 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp7_ = dir;
#line 785 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp8_ = g_dir_read_name (_tmp7_);
#line 785 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 785 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		filename = _tmp9_;
#line 786 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp10_ = filename;
#line 786 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (_tmp10_ == NULL) {
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_free0 (filename);
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			break;
#line 4579 "gnome-mahjongg.c"
		}
#line 789 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp11_ = filename;
#line 789 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp12_ = g_str_has_suffix (_tmp11_, ".map");
#line 789 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (!_tmp12_) {
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_free0 (filename);
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			continue;
#line 4591 "gnome-mahjongg.c"
		}
#line 792 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp13_ = map_loader_new ();
#line 792 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		loader = _tmp13_;
#line 793 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp14_ = filename;
#line 793 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp15_ = g_build_filename (DATA_DIRECTORY, "maps", _tmp14_, NULL);
#line 793 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		path = _tmp15_;
#line 4603 "gnome-mahjongg.c"
		{
			MapLoader* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp16_ = loader;
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp17_ = path;
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			map_loader_load (_tmp16_, _tmp17_, &_inner_error_);
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4615 "gnome-mahjongg.c"
				goto __catch7_g_error;
			}
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp18_ = NULL;
			GError* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			e = _inner_error_;
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_inner_error_ = NULL;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp18_ = path;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp19_ = e;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_tmp20_ = _tmp19_->message;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			g_warning ("gnome-mahjongg.vala:800: Could not load map %s: %s\n", _tmp18_, _tmp20_);
#line 801 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_error_free0 (e);
#line 801 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_free0 (path);
#line 801 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_object_unref0 (loader);
#line 801 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_free0 (filename);
#line 801 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			continue;
#line 4648 "gnome-mahjongg.c"
		}
		__finally7:
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_free0 (path);
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_object_unref0 (loader);
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_free0 (filename);
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			_g_dir_close0 (dir);
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			g_clear_error (&_inner_error_);
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			return;
#line 4667 "gnome-mahjongg.c"
		}
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp21_ = loader;
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_tmp22_ = _tmp21_->maps;
#line 4673 "gnome-mahjongg.c"
		{
			GList* map_collection = NULL;
			GList* map_it = NULL;
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			map_collection = _tmp22_;
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
			for (map_it = map_collection; map_it != NULL; map_it = map_it->next) {
#line 4681 "gnome-mahjongg.c"
				Map* _tmp23_ = NULL;
				Map* map = NULL;
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				_tmp23_ = _g_object_ref0 ((Map*) map_it->data);
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
				map = _tmp23_;
#line 4688 "gnome-mahjongg.c"
				{
					Map* _tmp24_ = NULL;
					Map* _tmp25_ = NULL;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp24_ = map;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_tmp25_ = _g_object_ref0 (_tmp24_);
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					self->priv->maps = g_list_append (self->priv->maps, _tmp25_);
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
					_g_object_unref0 (map);
#line 4700 "gnome-mahjongg.c"
				}
			}
		}
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_free0 (path);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_object_unref0 (loader);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
		_g_free0 (filename);
#line 4710 "gnome-mahjongg.c"
	}
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_dir_close0 (dir);
#line 4714 "gnome-mahjongg.c"
}


gint mahjongg_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	Mahjongg* app = NULL;
	Mahjongg* _tmp1_ = NULL;
	gint _result_ = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
#line 810 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	setlocale (LC_ALL, "");
#line 811 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 812 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	textdomain (GETTEXT_PACKAGE);
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp0_ = _ ("Mahjongg");
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_set_application_name (_tmp0_);
#line 816 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	gtk_window_set_default_icon_name ("gnome-mahjongg");
#line 818 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp1_ = mahjongg_new ();
#line 818 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	app = _tmp1_;
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2_ = args;
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp2__length1 = args_length1;
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_tmp3_ = g_application_run ((GApplication*) app, _tmp2__length1, _tmp2_);
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_result_ = _tmp3_;
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_settings_sync ();
#line 823 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	result = _result_;
#line 823 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (app);
#line 823 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	return result;
#line 4761 "gnome-mahjongg.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 808 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	return mahjongg_main (argv, argc);
#line 4771 "gnome-mahjongg.c"
}


static void mahjongg_class_init (MahjonggClass * klass) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	mahjongg_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	g_type_class_add_private (klass, sizeof (MahjonggPrivate));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	((GApplicationClass *) klass)->startup = mahjongg_real_startup;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	((GApplicationClass *) klass)->shutdown = mahjongg_real_shutdown;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	((GApplicationClass *) klass)->handle_local_options = mahjongg_real_handle_local_options;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	((GApplicationClass *) klass)->activate = mahjongg_real_activate;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	G_OBJECT_CLASS (klass)->finalize = mahjongg_finalize;
#line 4790 "gnome-mahjongg.c"
}


static void mahjongg_instance_init (Mahjongg * self) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv = MAHJONGG_GET_PRIVATE (self);
#line 17 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->maps = NULL;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self->priv->preferences_dialog = NULL;
#line 4801 "gnome-mahjongg.c"
}


static void mahjongg_finalize (GObject* obj) {
	Mahjongg * self;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAHJONGG, Mahjongg);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->settings);
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->history);
#line 17 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	__g_list_free__g_object_unref0_0 (self->priv->maps);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->window);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->title);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->game_view);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->pause_button);
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->moves_label);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->clock_label);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/gnome-mahjongg.vala"
	G_OBJECT_CLASS (mahjongg_parent_class)->finalize (obj);
#line 4831 "gnome-mahjongg.c"
}


GType mahjongg_get_type (void) {
	static volatile gsize mahjongg_type_id__volatile = 0;
	if (g_once_init_enter (&mahjongg_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MahjonggClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mahjongg_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Mahjongg), 0, (GInstanceInitFunc) mahjongg_instance_init, NULL };
		GType mahjongg_type_id;
		mahjongg_type_id = g_type_register_static (gtk_application_get_type (), "Mahjongg", &g_define_type_info, 0);
		g_once_init_leave (&mahjongg_type_id__volatile, mahjongg_type_id);
	}
	return mahjongg_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



