/* gitg-credentials-manager.c generated by valac 0.28.0.11-bbdd, the Vala compiler
 * generated from gitg-credentials-manager.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2014 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libsecret/secret.h>
#include <stdio.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <gobject/gvaluecollector.h>


#define GITG_TYPE_CREDENTIALS_MANAGER (gitg_credentials_manager_get_type ())
#define GITG_CREDENTIALS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManager))
#define GITG_CREDENTIALS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManagerClass))
#define GITG_IS_CREDENTIALS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_CREDENTIALS_MANAGER))
#define GITG_IS_CREDENTIALS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_CREDENTIALS_MANAGER))
#define GITG_CREDENTIALS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManagerClass))

typedef struct _GitgCredentialsManager GitgCredentialsManager;
typedef struct _GitgCredentialsManagerClass GitgCredentialsManagerClass;
typedef struct _GitgCredentialsManagerPrivate GitgCredentialsManagerPrivate;

#define GITG_TYPE_REMOTE (gitg_remote_get_type ())
#define GITG_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REMOTE, GitgRemote))
#define GITG_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REMOTE, GitgRemoteClass))
#define GITG_IS_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REMOTE))
#define GITG_IS_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REMOTE))
#define GITG_REMOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REMOTE, GitgRemoteClass))

typedef struct _GitgRemote GitgRemote;
typedef struct _GitgRemoteClass GitgRemoteClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GITG_TYPE_AUTHENTICATION_LIFE_TIME (gitg_authentication_life_time_get_type ())
typedef struct _Block4Data Block4Data;
#define _gitg_credentials_manager_unref0(var) ((var == NULL) ? NULL : (var = (gitg_credentials_manager_unref (var), NULL)))

#define GITG_TYPE_AUTHENTICATION_DIALOG (gitg_authentication_dialog_get_type ())
#define GITG_AUTHENTICATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_AUTHENTICATION_DIALOG, GitgAuthenticationDialog))
#define GITG_AUTHENTICATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_AUTHENTICATION_DIALOG, GitgAuthenticationDialogClass))
#define GITG_IS_AUTHENTICATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_AUTHENTICATION_DIALOG))
#define GITG_IS_AUTHENTICATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_AUTHENTICATION_DIALOG))
#define GITG_AUTHENTICATION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_AUTHENTICATION_DIALOG, GitgAuthenticationDialogClass))

typedef struct _GitgAuthenticationDialog GitgAuthenticationDialog;
typedef struct _GitgAuthenticationDialogClass GitgAuthenticationDialogClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
typedef struct _GitgParamSpecCredentialsManager GitgParamSpecCredentialsManager;

typedef enum  {
	GITG_CREDENTIALS_ERROR_CANCELLED
} GitgCredentialsError;
#define GITG_CREDENTIALS_ERROR gitg_credentials_error_quark ()
struct _GitgCredentialsManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgCredentialsManagerPrivate * priv;
};

struct _GitgCredentialsManagerClass {
	GTypeClass parent_class;
	void (*finalize) (GitgCredentialsManager *self);
};

struct _GitgCredentialsManagerPrivate {
	GitgRemote* d_remote;
	GtkWindow* d_window;
	GeeHashMap* d_usermap;
};

typedef enum  {
	GITG_AUTHENTICATION_LIFE_TIME_FORGET,
	GITG_AUTHENTICATION_LIFE_TIME_SESSION,
	GITG_AUTHENTICATION_LIFE_TIME_FOREVER
} GitgAuthenticationLifeTime;

struct _Block4Data {
	int _ref_count_;
	GitgCredentialsManager* self;
	GMutex mutex;
	GCond cond;
	GtkResponseType response;
	gchar* password;
	gchar* newusername;
	GitgAuthenticationLifeTime lifetime;
	gchar* url;
	gchar* username;
};

struct _GitgParamSpecCredentialsManager {
	GParamSpec parent_instance;
};


static gpointer gitg_credentials_manager_parent_class = NULL;
static SecretSchema* gitg_credentials_manager_s_secret_schema;
static SecretSchema* gitg_credentials_manager_s_secret_schema = NULL;

GQuark gitg_credentials_error_quark (void);
gpointer gitg_credentials_manager_ref (gpointer instance);
void gitg_credentials_manager_unref (gpointer instance);
GParamSpec* gitg_param_spec_credentials_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gitg_value_set_credentials_manager (GValue* value, gpointer v_object);
void gitg_value_take_credentials_manager (GValue* value, gpointer v_object);
gpointer gitg_value_get_credentials_manager (const GValue* value);
GType gitg_credentials_manager_get_type (void) G_GNUC_CONST;
GType gitg_remote_get_type (void) G_GNUC_CONST;
#define GITG_CREDENTIALS_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManagerPrivate))
enum  {
	GITG_CREDENTIALS_MANAGER_DUMMY_PROPERTY
};
GitgCredentialsManager* gitg_credentials_manager_new (GitgRemote* remote, GtkWindow* window);
GitgCredentialsManager* gitg_credentials_manager_construct (GType object_type, GitgRemote* remote, GtkWindow* window);
static gchar* gitg_credentials_manager_lookup_user (GitgCredentialsManager* self, const gchar* host);
static gint ____lambda41_ (GitgCredentialsManager* self, GMatchInfo* info, const gchar* value);
static gint _____lambda41__ggit_config_match_callback (GMatchInfo* match_info, const gchar* value, gpointer self);
static GgitCred* gitg_credentials_manager_user_pass_dialog (GitgCredentialsManager* self, const gchar* url, const gchar* scheme, const gchar* host, const gchar* username, GError** error);
GType gitg_authentication_life_time_get_type (void) G_GNUC_CONST;
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda42_ (Block4Data* _data4_);
GType gitg_authentication_dialog_get_type (void) G_GNUC_CONST;
GError* gitg_remote_get_authentication_error (GitgRemote* self);
GitgAuthenticationDialog* gitg_authentication_dialog_new (const gchar* url, const gchar* username, gboolean failed);
GitgAuthenticationDialog* gitg_authentication_dialog_construct (GType object_type, const gchar* url, const gchar* username, gboolean failed);
const gchar* gitg_authentication_dialog_get_username (GitgAuthenticationDialog* self);
const gchar* gitg_authentication_dialog_get_password (GitgAuthenticationDialog* self);
GitgAuthenticationLifeTime gitg_authentication_dialog_get_life_time (GitgAuthenticationDialog* self);
static gboolean ___lambda42__gsource_func (gpointer self);
static void _g_free0_ (gpointer var);
static void ___lambda43_ (GitgCredentialsManager* self, GObject* obj, GAsyncResult* res);
static void ____lambda43__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda44_ (GitgCredentialsManager* self, GObject* obj, GAsyncResult* res);
static void ____lambda44__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static GgitCred* gitg_credentials_manager_query_user_pass (GitgCredentialsManager* self, const gchar* url, const gchar* username, GError** error);
static void _vala_SoupURI_free (SoupURI* self);
GgitCred* gitg_credentials_manager_credentials (GitgCredentialsManager* self, const gchar* url, const gchar* username, GgitCredtype allowed_types, GError** error);
static void gitg_credentials_manager_finalize (GitgCredentialsManager* obj);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);


GQuark gitg_credentials_error_quark (void) {
	return g_quark_from_static_string ("gitg_credentials_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 47 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return self ? g_object_ref (self) : NULL;
#line 184 "gitg-credentials-manager.c"
}


GitgCredentialsManager* gitg_credentials_manager_construct (GType object_type, GitgRemote* remote, GtkWindow* window) {
	GitgCredentialsManager* self = NULL;
	GitgRemote* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
#line 44 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (remote != NULL, NULL);
#line 44 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 44 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self = (GitgCredentialsManager*) g_type_create_instance (object_type);
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = remote;
#line 46 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self->priv->d_remote = _tmp0_;
#line 47 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = window;
#line 47 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 47 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_window);
#line 47 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self->priv->d_window = _tmp2_;
#line 44 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return self;
#line 213 "gitg-credentials-manager.c"
}


GitgCredentialsManager* gitg_credentials_manager_new (GitgRemote* remote, GtkWindow* window) {
#line 44 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return gitg_credentials_manager_construct (GITG_TYPE_CREDENTIALS_MANAGER, remote, window);
#line 220 "gitg-credentials-manager.c"
}


static gint ____lambda41_ (GitgCredentialsManager* self, GMatchInfo* info, const gchar* value) {
	gint result = 0;
	GeeHashMap* _tmp0_ = NULL;
	GMatchInfo* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 61 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (info != NULL, 0);
#line 61 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (value != NULL, 0);
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = self->priv->d_usermap;
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = info;
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = g_match_info_fetch (_tmp1_, 1);
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = _tmp2_;
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp4_ = value;
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp3_, _tmp4_);
#line 62 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (_tmp3_);
#line 63 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	result = 0;
#line 63 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 253 "gitg-credentials-manager.c"
}


static gint _____lambda41__ggit_config_match_callback (GMatchInfo* match_info, const gchar* value, gpointer self) {
	gint result;
	result = ____lambda41_ ((GitgCredentialsManager*) self, match_info, value);
#line 61 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 262 "gitg-credentials-manager.c"
}


static gchar* gitg_credentials_manager_lookup_user (GitgCredentialsManager* self, const gchar* host) {
	gchar* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gpointer _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
#line 50 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (host != NULL, NULL);
#line 52 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = self->priv->d_usermap;
#line 52 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp0_ == NULL) {
#line 281 "gitg-credentials-manager.c"
		GeeHashMap* _tmp1_ = NULL;
#line 54 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 54 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_object_unref0 (self->priv->d_usermap);
#line 54 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		self->priv->d_usermap = _tmp1_;
#line 289 "gitg-credentials-manager.c"
		{
			GgitConfig* config = NULL;
			GitgRemote* _tmp2_ = NULL;
			GgitRepository* _tmp3_ = NULL;
			GgitRepository* _tmp4_ = NULL;
			GgitConfig* _tmp5_ = NULL;
			GgitConfig* _tmp6_ = NULL;
			GRegex* r = NULL;
			GRegex* _tmp7_ = NULL;
			GgitConfig* _tmp8_ = NULL;
			GRegex* _tmp9_ = NULL;
#line 58 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp2_ = self->priv->d_remote;
#line 58 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp3_ = ggit_remote_get_owner ((GgitRemote*) _tmp2_);
#line 58 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp4_ = _tmp3_;
#line 58 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp5_ = ggit_repository_get_config (_tmp4_, &_inner_error_);
#line 58 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp6_ = _tmp5_;
#line 58 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_object_unref0 (_tmp4_);
#line 58 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			config = _tmp6_;
#line 58 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 317 "gitg-credentials-manager.c"
				goto __catch23_g_error;
			}
#line 59 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp7_ = g_regex_new ("credential\\.(.*)\\.username", 0, 0, &_inner_error_);
#line 59 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			r = _tmp7_;
#line 59 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 59 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_object_unref0 (config);
#line 328 "gitg-credentials-manager.c"
				goto __catch23_g_error;
			}
#line 61 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp8_ = config;
#line 61 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp9_ = r;
#line 61 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			ggit_config_match_foreach (_tmp8_, _tmp9_, _____lambda41__ggit_config_match_callback, self, &_inner_error_);
#line 61 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 61 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_regex_unref0 (r);
#line 61 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_object_unref0 (config);
#line 343 "gitg-credentials-manager.c"
				goto __catch23_g_error;
			}
#line 56 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_regex_unref0 (r);
#line 56 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_object_unref0 (config);
#line 350 "gitg-credentials-manager.c"
		}
		goto __finally23;
		__catch23_g_error:
		{
			GError* e = NULL;
			FILE* _tmp10_ = NULL;
			GError* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
#line 56 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			e = _inner_error_;
#line 56 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_inner_error_ = NULL;
#line 68 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp10_ = stderr;
#line 68 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp11_ = e;
#line 68 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp12_ = _tmp11_->message;
#line 68 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			fprintf (_tmp10_, "Could not get username from git config: %s\n", _tmp12_);
#line 56 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_error_free0 (e);
#line 373 "gitg-credentials-manager.c"
		}
		__finally23:
#line 56 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 56 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 56 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			g_clear_error (&_inner_error_);
#line 56 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return NULL;
#line 384 "gitg-credentials-manager.c"
		}
	}
#line 72 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp13_ = self->priv->d_usermap;
#line 72 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp14_ = host;
#line 72 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, _tmp14_);
#line 72 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	result = (gchar*) _tmp15_;
#line 72 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 397 "gitg-credentials-manager.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return _data4_;
#line 406 "gitg-credentials-manager.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 415 "gitg-credentials-manager.c"
		GitgCredentialsManager* self;
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		self = _data4_->self;
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data4_->newusername);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data4_->password);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_vala_clear_GCond (&_data4_->cond);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_vala_clear_GMutex (&_data4_->mutex);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data4_->url);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data4_->username);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_gitg_credentials_manager_unref0 (self);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_slice_free (Block4Data, _data4_);
#line 435 "gitg-credentials-manager.c"
	}
}


static gboolean __lambda42_ (Block4Data* _data4_) {
	GitgCredentialsManager* self;
	gboolean result = FALSE;
	GitgAuthenticationDialog* d = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GitgRemote* _tmp2_ = NULL;
	GError* _tmp3_ = NULL;
	GError* _tmp4_ = NULL;
	GitgAuthenticationDialog* _tmp5_ = NULL;
	GitgAuthenticationDialog* _tmp6_ = NULL;
	GtkWindow* _tmp7_ = NULL;
	GitgAuthenticationDialog* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GtkResponseType _tmp10_ = 0;
	GitgAuthenticationDialog* _tmp22_ = NULL;
#line 88 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self = _data4_->self;
#line 89 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = _data4_->url;
#line 89 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = _data4_->username;
#line 89 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = self->priv->d_remote;
#line 89 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = gitg_remote_get_authentication_error (_tmp2_);
#line 89 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp4_ = _tmp3_;
#line 89 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp5_ = gitg_authentication_dialog_new (_tmp0_, _tmp1_, _tmp4_ != NULL);
#line 89 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_object_ref_sink (_tmp5_);
#line 89 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	d = _tmp5_;
#line 90 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp6_ = d;
#line 90 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp7_ = self->priv->d_window;
#line 90 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp6_, _tmp7_);
#line 92 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp8_ = d;
#line 92 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp9_ = gtk_dialog_run ((GtkDialog*) _tmp8_);
#line 92 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data4_->response = (GtkResponseType) _tmp9_;
#line 94 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp10_ = _data4_->response;
#line 94 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp10_ == GTK_RESPONSE_OK) {
#line 490 "gitg-credentials-manager.c"
		GitgAuthenticationDialog* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		GitgAuthenticationDialog* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		GitgAuthenticationDialog* _tmp19_ = NULL;
		GitgAuthenticationLifeTime _tmp20_ = 0;
		GitgAuthenticationLifeTime _tmp21_ = 0;
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp11_ = d;
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp12_ = gitg_authentication_dialog_get_username (_tmp11_);
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp13_ = _tmp12_;
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data4_->newusername);
#line 96 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_data4_->newusername = _tmp14_;
#line 97 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp15_ = d;
#line 97 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp16_ = gitg_authentication_dialog_get_password (_tmp15_);
#line 97 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp17_ = _tmp16_;
#line 97 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp18_ = g_strdup (_tmp17_);
#line 97 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_data4_->password);
#line 97 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_data4_->password = _tmp18_;
#line 98 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp19_ = d;
#line 98 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp20_ = gitg_authentication_dialog_get_life_time (_tmp19_);
#line 98 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp21_ = _tmp20_;
#line 98 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_data4_->lifetime = _tmp21_;
#line 534 "gitg-credentials-manager.c"
	}
#line 101 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp22_ = d;
#line 101 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp22_);
#line 103 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_mutex_lock (&_data4_->mutex);
#line 104 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_cond_signal (&_data4_->cond);
#line 105 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_mutex_unlock (&_data4_->mutex);
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	result = FALSE;
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (d);
#line 107 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 552 "gitg-credentials-manager.c"
}


static gboolean ___lambda42__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda42_ (self);
#line 88 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 561 "gitg-credentials-manager.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1314 "/opt/gnome/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1315 "/opt/gnome/share/vala-0.30/vapi/glib-2.0.vapi"
	result = self;
#line 1315 "/opt/gnome/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 573 "gitg-credentials-manager.c"
}


static void _g_free0_ (gpointer var) {
#line 142 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	var = (g_free (var), NULL);
#line 580 "gitg-credentials-manager.c"
}


static void ___lambda43_ (GitgCredentialsManager* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 163 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_if_fail (res != NULL);
#line 588 "gitg-credentials-manager.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 166 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp0_ = res;
#line 166 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		secret_password_store_finish (_tmp0_, &_inner_error_);
#line 166 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 597 "gitg-credentials-manager.c"
			goto __catch25_g_error;
		}
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 164 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		e = _inner_error_;
#line 164 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_inner_error_ = NULL;
#line 170 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp1_ = stderr;
#line 170 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp2_ = e;
#line 170 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp3_ = _tmp2_->message;
#line 170 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		fprintf (_tmp1_, "Failed to store secret in keyring: %s\n", _tmp3_);
#line 164 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_error_free0 (e);
#line 622 "gitg-credentials-manager.c"
	}
	__finally25:
#line 164 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 164 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 164 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_clear_error (&_inner_error_);
#line 164 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		return;
#line 633 "gitg-credentials-manager.c"
	}
}


static void ____lambda43__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 157 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	___lambda43_ ((GitgCredentialsManager*) self, source_object, res);
#line 157 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	gitg_credentials_manager_unref (self);
#line 643 "gitg-credentials-manager.c"
}


static void ___lambda44_ (GitgCredentialsManager* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 176 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_if_fail (res != NULL);
#line 651 "gitg-credentials-manager.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 179 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp0_ = res;
#line 179 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		secret_password_clear_finish (_tmp0_, &_inner_error_);
#line 179 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 660 "gitg-credentials-manager.c"
			goto __catch26_g_error;
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		e = _inner_error_;
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_inner_error_ = NULL;
#line 183 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp1_ = stderr;
#line 183 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp2_ = e;
#line 183 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp3_ = _tmp2_->message;
#line 183 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		fprintf (_tmp1_, "Failed to clear secret from keyring: %s\n", _tmp3_);
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_error_free0 (e);
#line 685 "gitg-credentials-manager.c"
	}
	__finally26:
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_clear_error (&_inner_error_);
#line 177 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		return;
#line 696 "gitg-credentials-manager.c"
	}
}


static void ____lambda44__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 176 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	___lambda44_ ((GitgCredentialsManager*) self, source_object, res);
#line 176 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	gitg_credentials_manager_unref (self);
#line 706 "gitg-credentials-manager.c"
}


static GgitCred* gitg_credentials_manager_user_pass_dialog (GitgCredentialsManager* self, const gchar* url, const gchar* scheme, const gchar* host, const gchar* username, GError** error) {
	GgitCred* result = NULL;
	Block4Data* _data4_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GtkResponseType _tmp6_ = 0;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	GHashTable* attributes = NULL;
	GHashFunc _tmp35_ = NULL;
	GEqualFunc _tmp36_ = NULL;
	GHashTable* _tmp37_ = NULL;
	GHashTable* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	GHashTable* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	GHashTable* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	GitgAuthenticationLifeTime _tmp50_ = 0;
	GgitCredPlaintext* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	const gchar* _tmp67_ = NULL;
	GgitCredPlaintext* _tmp68_ = NULL;
	GgitCredPlaintext* _tmp69_ = NULL;
	GError * _inner_error_ = NULL;
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (scheme != NULL, NULL);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (host != NULL, NULL);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data4_->_ref_count_ = 1;
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data4_->self = gitg_credentials_manager_ref (self);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = url;
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (_data4_->url);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data4_->url = _tmp1_;
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = username;
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (_data4_->username);
#line 75 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data4_->username = _tmp3_;
#line 77 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_mutex_init (&_data4_->mutex);
#line 78 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_mutex_lock (&_data4_->mutex);
#line 80 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_cond_init (&_data4_->cond);
#line 82 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data4_->response = GTK_RESPONSE_CANCEL;
#line 84 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp4_ = g_strdup ("");
#line 84 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data4_->password = _tmp4_;
#line 85 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp5_ = g_strdup ("");
#line 85 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data4_->newusername = _tmp5_;
#line 86 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data4_->lifetime = GITG_AUTHENTICATION_LIFE_TIME_FORGET;
#line 88 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda42__gsource_func, block4_data_ref (_data4_), block4_data_unref);
#line 110 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_cond_wait (&_data4_->cond, &_data4_->mutex);
#line 111 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_mutex_unlock (&_data4_->mutex);
#line 113 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp6_ = _data4_->response;
#line 113 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp6_ != GTK_RESPONSE_OK) {
#line 803 "gitg-credentials-manager.c"
		GError* _tmp7_ = NULL;
#line 115 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp7_ = g_error_new_literal (GITG_CREDENTIALS_ERROR, GITG_CREDENTIALS_ERROR_CANCELLED, "cancelled by user");
#line 115 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_inner_error_ = _tmp7_;
#line 115 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_propagate_error (error, _inner_error_);
#line 115 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		block4_data_unref (_data4_);
#line 115 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_data4_ = NULL;
#line 115 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		return NULL;
#line 817 "gitg-credentials-manager.c"
	}
#line 119 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp9_ = _data4_->username;
#line 119 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp9_ == NULL) {
#line 119 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp8_ = TRUE;
#line 825 "gitg-credentials-manager.c"
	} else {
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 119 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp10_ = _data4_->newusername;
#line 119 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp11_ = _data4_->username;
#line 119 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp8_ = g_strcmp0 (_tmp10_, _tmp11_) != 0;
#line 835 "gitg-credentials-manager.c"
	}
#line 119 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp8_) {
#line 839 "gitg-credentials-manager.c"
		GeeHashMap* _tmp12_ = NULL;
#line 121 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp12_ = self->priv->d_usermap;
#line 121 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (_tmp12_ == NULL) {
#line 845 "gitg-credentials-manager.c"
			GeeHashMap* _tmp13_ = NULL;
#line 123 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp13_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 123 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_object_unref0 (self->priv->d_usermap);
#line 123 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			self->priv->d_usermap = _tmp13_;
#line 853 "gitg-credentials-manager.c"
		}
		{
			GgitRepository* repo = NULL;
			GitgRemote* _tmp14_ = NULL;
			GgitRepository* _tmp15_ = NULL;
			GgitConfig* config = NULL;
			GgitRepository* _tmp16_ = NULL;
			GgitConfig* _tmp17_ = NULL;
			gchar* hid = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			GgitConfig* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			GeeHashMap* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
#line 128 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp14_ = self->priv->d_remote;
#line 128 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp15_ = ggit_remote_get_owner ((GgitRemote*) _tmp14_);
#line 128 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			repo = _tmp15_;
#line 129 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp16_ = repo;
#line 129 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp17_ = ggit_repository_get_config (_tmp16_, &_inner_error_);
#line 129 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			config = _tmp17_;
#line 129 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 129 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_object_unref0 (repo);
#line 893 "gitg-credentials-manager.c"
				goto __catch24_g_error;
			}
#line 130 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp18_ = scheme;
#line 130 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp19_ = string_to_string (_tmp18_);
#line 130 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp20_ = host;
#line 130 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp21_ = string_to_string (_tmp20_);
#line 130 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp22_ = g_strconcat (_tmp19_, "://", _tmp21_, NULL);
#line 130 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			hid = _tmp22_;
#line 132 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp23_ = config;
#line 132 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp24_ = hid;
#line 132 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp25_ = string_to_string (_tmp24_);
#line 132 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp26_ = g_strconcat ("credential.", _tmp25_, ".username", NULL);
#line 132 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp27_ = _tmp26_;
#line 132 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp28_ = _data4_->newusername;
#line 132 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			ggit_config_set_string (_tmp23_, _tmp27_, _tmp28_, &_inner_error_);
#line 132 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (_tmp27_);
#line 132 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 132 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (hid);
#line 132 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_object_unref0 (config);
#line 132 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_object_unref0 (repo);
#line 932 "gitg-credentials-manager.c"
				goto __catch24_g_error;
			}
#line 134 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp29_ = self->priv->d_usermap;
#line 134 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp30_ = hid;
#line 134 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp31_ = _data4_->newusername;
#line 134 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, _tmp30_, _tmp31_);
#line 126 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (hid);
#line 126 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_object_unref0 (config);
#line 126 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_object_unref0 (repo);
#line 949 "gitg-credentials-manager.c"
		}
		goto __finally24;
		__catch24_g_error:
		{
			GError* e = NULL;
			FILE* _tmp32_ = NULL;
			GError* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
#line 126 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			e = _inner_error_;
#line 126 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_inner_error_ = NULL;
#line 138 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp32_ = stderr;
#line 138 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp33_ = e;
#line 138 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp34_ = _tmp33_->message;
#line 138 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			fprintf (_tmp32_, "Failed to store username in config: %s\n", _tmp34_);
#line 126 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_error_free0 (e);
#line 972 "gitg-credentials-manager.c"
		}
		__finally24:
#line 126 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 126 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			g_propagate_error (error, _inner_error_);
#line 126 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			block4_data_unref (_data4_);
#line 126 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_data4_ = NULL;
#line 126 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return NULL;
#line 985 "gitg-credentials-manager.c"
		}
	}
#line 142 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp35_ = g_str_hash;
#line 142 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp36_ = g_str_equal;
#line 142 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp37_ = g_hash_table_new_full (_tmp35_, _tmp36_, _g_free0_, _g_free0_);
#line 142 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	attributes = _tmp37_;
#line 143 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp38_ = attributes;
#line 143 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp39_ = g_strdup ("scheme");
#line 143 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp40_ = scheme;
#line 143 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp41_ = g_strdup (_tmp40_);
#line 143 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_hash_table_insert (_tmp38_, _tmp39_, _tmp41_);
#line 144 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp42_ = attributes;
#line 144 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp43_ = g_strdup ("host");
#line 144 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp44_ = host;
#line 144 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp45_ = g_strdup (_tmp44_);
#line 144 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_hash_table_insert (_tmp42_, _tmp43_, _tmp45_);
#line 145 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp46_ = attributes;
#line 145 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp47_ = g_strdup ("user");
#line 145 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp48_ = _data4_->newusername;
#line 145 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp49_ = g_strdup (_tmp48_);
#line 145 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_hash_table_insert (_tmp46_, _tmp47_, _tmp49_);
#line 148 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp50_ = _data4_->lifetime;
#line 148 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp50_ != GITG_AUTHENTICATION_LIFE_TIME_FORGET) {
#line 1030 "gitg-credentials-manager.c"
		gchar* collection = NULL;
		GitgAuthenticationLifeTime _tmp51_ = 0;
		SecretSchema* _tmp53_ = NULL;
		GHashTable* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
#line 150 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		collection = NULL;
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp51_ = _data4_->lifetime;
#line 152 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (_tmp51_ == GITG_AUTHENTICATION_LIFE_TIME_SESSION) {
#line 1049 "gitg-credentials-manager.c"
			gchar* _tmp52_ = NULL;
#line 154 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp52_ = g_strdup (SECRET_COLLECTION_SESSION);
#line 154 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (collection);
#line 154 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			collection = _tmp52_;
#line 1057 "gitg-credentials-manager.c"
		}
#line 157 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp53_ = gitg_credentials_manager_s_secret_schema;
#line 157 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp54_ = attributes;
#line 157 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp55_ = collection;
#line 157 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp56_ = scheme;
#line 157 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp57_ = string_to_string (_tmp56_);
#line 157 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp58_ = host;
#line 157 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp59_ = string_to_string (_tmp58_);
#line 157 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp60_ = g_strconcat (_tmp57_, "://", _tmp59_, NULL);
#line 157 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp61_ = _tmp60_;
#line 157 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp62_ = _data4_->password;
#line 157 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		secret_password_storev (_tmp53_, _tmp54_, _tmp55_, _tmp61_, _tmp62_, NULL, ____lambda43__gasync_ready_callback, gitg_credentials_manager_ref (self));
#line 157 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_tmp61_);
#line 148 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (collection);
#line 1085 "gitg-credentials-manager.c"
	} else {
		SecretSchema* _tmp63_ = NULL;
		GHashTable* _tmp64_ = NULL;
#line 176 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp63_ = gitg_credentials_manager_s_secret_schema;
#line 176 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp64_ = attributes;
#line 176 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		secret_password_clearv (_tmp63_, _tmp64_, NULL, ____lambda44__gasync_ready_callback, gitg_credentials_manager_ref (self));
#line 1095 "gitg-credentials-manager.c"
	}
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp66_ = _data4_->newusername;
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp67_ = _data4_->password;
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp68_ = ggit_cred_plaintext_new (_tmp66_, _tmp67_, &_inner_error_);
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp65_ = _tmp68_;
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_propagate_error (error, _inner_error_);
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_hash_table_unref0 (attributes);
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		block4_data_unref (_data4_);
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_data4_ = NULL;
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		return NULL;
#line 1117 "gitg-credentials-manager.c"
	}
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp69_ = _tmp65_;
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp65_ = NULL;
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	result = (GgitCred*) _tmp69_;
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (_tmp65_);
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_hash_table_unref0 (attributes);
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	block4_data_unref (_data4_);
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_data4_ = NULL;
#line 188 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 1135 "gitg-credentials-manager.c"
}


static void _vala_SoupURI_free (SoupURI* self) {
#line 219 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_boxed_free (soup_uri_get_type (), self);
#line 1142 "gitg-credentials-manager.c"
}


static GgitCred* gitg_credentials_manager_query_user_pass (GitgCredentialsManager* self, const gchar* url, const gchar* username, GError** error) {
	GgitCred* result = NULL;
	gchar* user = NULL;
	SoupURI* uri = NULL;
	const gchar* _tmp0_ = NULL;
	SoupURI* _tmp1_ = NULL;
	gchar* host = NULL;
	SoupURI* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	SoupURI* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* scheme = NULL;
	SoupURI* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
#line 191 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 191 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 195 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = url;
#line 195 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = soup_uri_new (_tmp0_);
#line 195 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	uri = _tmp1_;
#line 196 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = uri;
#line 196 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = soup_uri_get_host (_tmp2_);
#line 196 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 196 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	host = _tmp4_;
#line 198 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp5_ = uri;
#line 198 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp6_ = soup_uri_uses_default_port (_tmp5_);
#line 198 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (!_tmp6_) {
#line 1190 "gitg-credentials-manager.c"
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		SoupURI* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 200 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp7_ = host;
#line 200 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp8_ = string_to_string (_tmp7_);
#line 200 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp9_ = uri;
#line 200 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp10_ = soup_uri_get_port (_tmp9_);
#line 200 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp11_ = g_strdup_printf ("%u", _tmp10_);
#line 200 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp12_ = _tmp11_;
#line 200 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp13_ = g_strconcat (_tmp8_, ":", _tmp12_, NULL);
#line 200 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (host);
#line 200 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		host = _tmp13_;
#line 200 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_tmp12_);
#line 1218 "gitg-credentials-manager.c"
	}
#line 203 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp14_ = uri;
#line 203 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp15_ = soup_uri_get_scheme (_tmp14_);
#line 203 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 203 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	scheme = _tmp16_;
#line 205 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp17_ = username;
#line 205 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp17_ == NULL) {
#line 1232 "gitg-credentials-manager.c"
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 208 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp18_ = scheme;
#line 208 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp19_ = string_to_string (_tmp18_);
#line 208 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp20_ = host;
#line 208 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp21_ = string_to_string (_tmp20_);
#line 208 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp22_ = g_strconcat (_tmp19_, "://", _tmp21_, NULL);
#line 208 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp23_ = _tmp22_;
#line 208 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp24_ = gitg_credentials_manager_lookup_user (self, _tmp23_);
#line 208 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (user);
#line 208 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		user = _tmp24_;
#line 208 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (_tmp23_);
#line 1260 "gitg-credentials-manager.c"
	} else {
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
#line 212 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp25_ = username;
#line 212 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp26_ = g_strdup (_tmp25_);
#line 212 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (user);
#line 212 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		user = _tmp26_;
#line 1272 "gitg-credentials-manager.c"
	}
#line 215 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp28_ = user;
#line 215 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp28_ != NULL) {
#line 1278 "gitg-credentials-manager.c"
		GitgRemote* _tmp29_ = NULL;
		GError* _tmp30_ = NULL;
		GError* _tmp31_ = NULL;
#line 215 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp29_ = self->priv->d_remote;
#line 215 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp30_ = gitg_remote_get_authentication_error (_tmp29_);
#line 215 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp31_ = _tmp30_;
#line 215 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp27_ = _tmp31_ == NULL;
#line 1290 "gitg-credentials-manager.c"
	} else {
#line 215 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp27_ = FALSE;
#line 1294 "gitg-credentials-manager.c"
	}
#line 215 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp27_) {
#line 1298 "gitg-credentials-manager.c"
		gchar* secret = NULL;
		const gchar* _tmp39_ = NULL;
#line 217 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		secret = NULL;
#line 1303 "gitg-credentials-manager.c"
		{
			gchar* _tmp32_ = NULL;
			SecretSchema* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
#line 221 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp33_ = gitg_credentials_manager_s_secret_schema;
#line 221 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp34_ = scheme;
#line 221 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp35_ = host;
#line 221 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp36_ = user;
#line 221 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp37_ = secret_password_lookup_sync (_tmp33_, NULL, &_inner_error_, "scheme", _tmp34_, "host", _tmp35_, "user", _tmp36_, NULL);
#line 221 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp32_ = _tmp37_;
#line 221 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1326 "gitg-credentials-manager.c"
				goto __catch27_g_error;
			}
#line 221 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp38_ = _tmp32_;
#line 221 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp32_ = NULL;
#line 221 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (secret);
#line 221 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			secret = _tmp38_;
#line 219 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (_tmp32_);
#line 1339 "gitg-credentials-manager.c"
		}
		goto __finally27;
		__catch27_g_error:
		{
#line 219 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			g_clear_error (&_inner_error_);
#line 219 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_inner_error_ = NULL;
#line 1348 "gitg-credentials-manager.c"
		}
		__finally27:
#line 219 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 219 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			g_propagate_error (error, _inner_error_);
#line 219 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (secret);
#line 219 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (scheme);
#line 219 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (host);
#line 219 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			__vala_SoupURI_free0 (uri);
#line 219 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (user);
#line 219 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return NULL;
#line 1367 "gitg-credentials-manager.c"
		}
#line 228 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp39_ = secret;
#line 228 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (_tmp39_ == NULL) {
#line 1373 "gitg-credentials-manager.c"
			GgitCred* _tmp40_ = NULL;
			const gchar* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			GgitCred* _tmp45_ = NULL;
			GgitCred* _tmp46_ = NULL;
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp41_ = url;
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp42_ = scheme;
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp43_ = host;
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp44_ = user;
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp45_ = gitg_credentials_manager_user_pass_dialog (self, _tmp41_, _tmp42_, _tmp43_, _tmp44_, &_inner_error_);
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp40_ = _tmp45_;
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				g_propagate_error (error, _inner_error_);
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (secret);
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (scheme);
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (host);
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				__vala_SoupURI_free0 (uri);
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_free0 (user);
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				return NULL;
#line 1409 "gitg-credentials-manager.c"
			}
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp46_ = _tmp40_;
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp40_ = NULL;
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			result = _tmp46_;
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_object_unref0 (_tmp40_);
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (secret);
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (scheme);
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (host);
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			__vala_SoupURI_free0 (uri);
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (user);
#line 230 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return result;
#line 1431 "gitg-credentials-manager.c"
		}
		{
			GgitCredPlaintext* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			const gchar* _tmp49_ = NULL;
			GgitCredPlaintext* _tmp50_ = NULL;
			GgitCredPlaintext* _tmp51_ = NULL;
#line 235 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp48_ = user;
#line 235 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp49_ = secret;
#line 235 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp50_ = ggit_cred_plaintext_new (_tmp48_, _tmp49_, &_inner_error_);
#line 235 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp47_ = _tmp50_;
#line 235 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1449 "gitg-credentials-manager.c"
				goto __catch28_g_error;
			}
#line 235 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp51_ = _tmp47_;
#line 235 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp47_ = NULL;
#line 235 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			result = (GgitCred*) _tmp51_;
#line 235 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_object_unref0 (_tmp47_);
#line 235 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (secret);
#line 235 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (scheme);
#line 235 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (host);
#line 235 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			__vala_SoupURI_free0 (uri);
#line 235 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (user);
#line 235 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return result;
#line 1472 "gitg-credentials-manager.c"
		}
		goto __finally28;
		__catch28_g_error:
		{
			GError* e = NULL;
			GgitCred* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			const gchar* _tmp54_ = NULL;
			const gchar* _tmp55_ = NULL;
			const gchar* _tmp56_ = NULL;
			GgitCred* _tmp57_ = NULL;
			GgitCred* _tmp58_ = NULL;
#line 233 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			e = _inner_error_;
#line 233 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_inner_error_ = NULL;
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp53_ = url;
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp54_ = scheme;
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp55_ = host;
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp56_ = user;
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp57_ = gitg_credentials_manager_user_pass_dialog (self, _tmp53_, _tmp54_, _tmp55_, _tmp56_, &_inner_error_);
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp52_ = _tmp57_;
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				_g_error_free0 (e);
#line 1505 "gitg-credentials-manager.c"
				goto __finally28;
			}
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp58_ = _tmp52_;
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp52_ = NULL;
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			result = _tmp58_;
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_object_unref0 (_tmp52_);
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_error_free0 (e);
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (secret);
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (scheme);
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (host);
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			__vala_SoupURI_free0 (uri);
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (user);
#line 239 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return result;
#line 1530 "gitg-credentials-manager.c"
		}
		__finally28:
#line 233 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_propagate_error (error, _inner_error_);
#line 233 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (secret);
#line 233 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (scheme);
#line 233 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (host);
#line 233 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		__vala_SoupURI_free0 (uri);
#line 233 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (user);
#line 233 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		return NULL;
#line 1547 "gitg-credentials-manager.c"
	} else {
		GgitCred* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		GgitCred* _tmp64_ = NULL;
		GgitCred* _tmp65_ = NULL;
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp60_ = url;
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp61_ = scheme;
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp62_ = host;
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp63_ = user;
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp64_ = gitg_credentials_manager_user_pass_dialog (self, _tmp60_, _tmp61_, _tmp62_, _tmp63_, &_inner_error_);
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp59_ = _tmp64_;
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			g_propagate_error (error, _inner_error_);
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (scheme);
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (host);
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			__vala_SoupURI_free0 (uri);
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_free0 (user);
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return NULL;
#line 1582 "gitg-credentials-manager.c"
		}
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp65_ = _tmp59_;
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp59_ = NULL;
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		result = _tmp65_;
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_object_unref0 (_tmp59_);
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (scheme);
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (host);
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		__vala_SoupURI_free0 (uri);
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_free0 (user);
#line 244 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		return result;
#line 1602 "gitg-credentials-manager.c"
	}
#line 191 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (scheme);
#line 191 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (host);
#line 191 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	__vala_SoupURI_free0 (uri);
#line 191 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_free0 (user);
#line 1612 "gitg-credentials-manager.c"
}


GgitCred* gitg_credentials_manager_credentials (GitgCredentialsManager* self, const gchar* url, const gchar* username, GgitCredtype allowed_types, GError** error) {
	GgitCred* result = NULL;
	gboolean _tmp0_ = FALSE;
	GitgRemote* _tmp1_ = NULL;
	GError* _tmp2_ = NULL;
	GError* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 248 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 248 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 252 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp1_ = self->priv->d_remote;
#line 252 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp2_ = gitg_remote_get_authentication_error (_tmp1_);
#line 252 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp3_ = _tmp2_;
#line 252 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp3_ == NULL) {
#line 1635 "gitg-credentials-manager.c"
		GgitCredtype _tmp4_ = 0;
#line 252 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp4_ = allowed_types;
#line 252 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp0_ = (_tmp4_ & GGIT_CREDTYPE_SSH_KEY) != 0;
#line 1641 "gitg-credentials-manager.c"
	} else {
#line 252 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp0_ = FALSE;
#line 1645 "gitg-credentials-manager.c"
	}
#line 252 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (_tmp0_) {
#line 1649 "gitg-credentials-manager.c"
		GgitCredSshKeyFromAgent* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GgitCredSshKeyFromAgent* _tmp7_ = NULL;
		GgitCredSshKeyFromAgent* _tmp8_ = NULL;
#line 254 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp6_ = username;
#line 254 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp7_ = ggit_cred_ssh_key_from_agent_new (_tmp6_, &_inner_error_);
#line 254 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp5_ = _tmp7_;
#line 254 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 254 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			g_propagate_error (error, _inner_error_);
#line 254 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return NULL;
#line 1666 "gitg-credentials-manager.c"
		}
#line 254 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp8_ = _tmp5_;
#line 254 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp5_ = NULL;
#line 254 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		result = (GgitCred*) _tmp8_;
#line 254 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_g_object_unref0 (_tmp5_);
#line 254 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		return result;
#line 1678 "gitg-credentials-manager.c"
	} else {
		GgitCredtype _tmp9_ = 0;
#line 256 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		_tmp9_ = allowed_types;
#line 256 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if ((_tmp9_ & GGIT_CREDTYPE_USERPASS_PLAINTEXT) != 0) {
#line 1685 "gitg-credentials-manager.c"
			GgitCred* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			GgitCred* _tmp13_ = NULL;
			GgitCred* _tmp14_ = NULL;
#line 258 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp11_ = url;
#line 258 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp12_ = username;
#line 258 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp13_ = gitg_credentials_manager_query_user_pass (self, _tmp11_, _tmp12_, &_inner_error_);
#line 258 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp10_ = _tmp13_;
#line 258 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 258 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				g_propagate_error (error, _inner_error_);
#line 258 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
				return NULL;
#line 1705 "gitg-credentials-manager.c"
			}
#line 258 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp14_ = _tmp10_;
#line 258 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_tmp10_ = NULL;
#line 258 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			result = _tmp14_;
#line 258 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			_g_object_unref0 (_tmp10_);
#line 258 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return result;
#line 1717 "gitg-credentials-manager.c"
		}
	}
#line 261 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	result = NULL;
#line 261 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return result;
#line 1724 "gitg-credentials-manager.c"
}


static void gitg_value_credentials_manager_init (GValue* value) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	value->data[0].v_pointer = NULL;
#line 1731 "gitg-credentials-manager.c"
}


static void gitg_value_credentials_manager_free_value (GValue* value) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (value->data[0].v_pointer) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		gitg_credentials_manager_unref (value->data[0].v_pointer);
#line 1740 "gitg-credentials-manager.c"
	}
}


static void gitg_value_credentials_manager_copy_value (const GValue* src_value, GValue* dest_value) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (src_value->data[0].v_pointer) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		dest_value->data[0].v_pointer = gitg_credentials_manager_ref (src_value->data[0].v_pointer);
#line 1750 "gitg-credentials-manager.c"
	} else {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1754 "gitg-credentials-manager.c"
	}
}


static gpointer gitg_value_credentials_manager_peek_pointer (const GValue* value) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return value->data[0].v_pointer;
#line 1762 "gitg-credentials-manager.c"
}


static gchar* gitg_value_credentials_manager_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (collect_values[0].v_pointer) {
#line 1769 "gitg-credentials-manager.c"
		GitgCredentialsManager* object;
		object = collect_values[0].v_pointer;
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		if (object->parent_instance.g_class == NULL) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1776 "gitg-credentials-manager.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1780 "gitg-credentials-manager.c"
		}
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = gitg_credentials_manager_ref (object);
#line 1784 "gitg-credentials-manager.c"
	} else {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = NULL;
#line 1788 "gitg-credentials-manager.c"
	}
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return NULL;
#line 1792 "gitg-credentials-manager.c"
}


static gchar* gitg_value_credentials_manager_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GitgCredentialsManager** object_p;
	object_p = collect_values[0].v_pointer;
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (!object_p) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1803 "gitg-credentials-manager.c"
	}
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (!value->data[0].v_pointer) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		*object_p = NULL;
#line 1809 "gitg-credentials-manager.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		*object_p = value->data[0].v_pointer;
#line 1813 "gitg-credentials-manager.c"
	} else {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		*object_p = gitg_credentials_manager_ref (value->data[0].v_pointer);
#line 1817 "gitg-credentials-manager.c"
	}
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return NULL;
#line 1821 "gitg-credentials-manager.c"
}


GParamSpec* gitg_param_spec_credentials_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GitgParamSpecCredentialsManager* spec;
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GITG_TYPE_CREDENTIALS_MANAGER), NULL);
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return G_PARAM_SPEC (spec);
#line 1835 "gitg-credentials-manager.c"
}


gpointer gitg_value_get_credentials_manager (const GValue* value) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_CREDENTIALS_MANAGER), NULL);
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return value->data[0].v_pointer;
#line 1844 "gitg-credentials-manager.c"
}


void gitg_value_set_credentials_manager (GValue* value, gpointer v_object) {
	GitgCredentialsManager* old;
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_CREDENTIALS_MANAGER));
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	old = value->data[0].v_pointer;
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (v_object) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_CREDENTIALS_MANAGER));
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = v_object;
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		gitg_credentials_manager_ref (value->data[0].v_pointer);
#line 1864 "gitg-credentials-manager.c"
	} else {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = NULL;
#line 1868 "gitg-credentials-manager.c"
	}
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (old) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		gitg_credentials_manager_unref (old);
#line 1874 "gitg-credentials-manager.c"
	}
}


void gitg_value_take_credentials_manager (GValue* value, gpointer v_object) {
	GitgCredentialsManager* old;
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_CREDENTIALS_MANAGER));
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	old = value->data[0].v_pointer;
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (v_object) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_CREDENTIALS_MANAGER));
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = v_object;
#line 1893 "gitg-credentials-manager.c"
	} else {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		value->data[0].v_pointer = NULL;
#line 1897 "gitg-credentials-manager.c"
	}
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (old) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		gitg_credentials_manager_unref (old);
#line 1903 "gitg-credentials-manager.c"
	}
}


static void gitg_credentials_manager_class_init (GitgCredentialsManagerClass * klass) {
	SecretSchema* _tmp0_ = NULL;
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	gitg_credentials_manager_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	((GitgCredentialsManagerClass *) klass)->finalize = gitg_credentials_manager_finalize;
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_type_class_add_private (klass, sizeof (GitgCredentialsManagerPrivate));
#line 37 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_tmp0_ = secret_schema_new ("org.gnome.Gitg.Credentials", SECRET_SCHEMA_NONE, "scheme", SECRET_SCHEMA_ATTRIBUTE_STRING, "host", SECRET_SCHEMA_ATTRIBUTE_STRING, "user", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
#line 37 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_secret_schema_unref0 (gitg_credentials_manager_s_secret_schema);
#line 37 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	gitg_credentials_manager_s_secret_schema = _tmp0_;
#line 1922 "gitg-credentials-manager.c"
}


static void gitg_credentials_manager_instance_init (GitgCredentialsManager * self) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self->priv = GITG_CREDENTIALS_MANAGER_GET_PRIVATE (self);
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self->ref_count = 1;
#line 1931 "gitg-credentials-manager.c"
}


static void gitg_credentials_manager_finalize (GitgCredentialsManager* obj) {
	GitgCredentialsManager * self;
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManager);
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_signal_handlers_destroy (self);
#line 31 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_window);
#line 32 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	_g_object_unref0 (self->priv->d_usermap);
#line 1945 "gitg-credentials-manager.c"
}


GType gitg_credentials_manager_get_type (void) {
	static volatile gsize gitg_credentials_manager_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_credentials_manager_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gitg_value_credentials_manager_init, gitg_value_credentials_manager_free_value, gitg_value_credentials_manager_copy_value, gitg_value_credentials_manager_peek_pointer, "p", gitg_value_credentials_manager_collect_value, "p", gitg_value_credentials_manager_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GitgCredentialsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_credentials_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgCredentialsManager), 0, (GInstanceInitFunc) gitg_credentials_manager_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gitg_credentials_manager_type_id;
		gitg_credentials_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgCredentialsManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gitg_credentials_manager_type_id__volatile, gitg_credentials_manager_type_id);
	}
	return gitg_credentials_manager_type_id__volatile;
}


gpointer gitg_credentials_manager_ref (gpointer instance) {
	GitgCredentialsManager* self;
	self = instance;
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	g_atomic_int_inc (&self->ref_count);
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	return instance;
#line 1970 "gitg-credentials-manager.c"
}


void gitg_credentials_manager_unref (gpointer instance) {
	GitgCredentialsManager* self;
	self = instance;
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		GITG_CREDENTIALS_MANAGER_GET_CLASS (self)->finalize (self);
#line 28 "/home/gregier/hacking/gnome/gitg/libgitg/gitg-credentials-manager.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1983 "gitg-credentials-manager.c"
	}
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



