/* gnome-chess.c generated by valac 0.26.0.30-a52f5a, the Vala compiler
 * generated from gnome-chess.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2014 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libchess.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <glib/gstdio.h>
#include <librsvg/rsvg.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>


#define TYPE_CHESS_APPLICATION (chess_application_get_type ())
#define CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_APPLICATION, ChessApplication))
#define CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_APPLICATION, ChessApplicationClass))
#define IS_CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_APPLICATION))
#define IS_CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_APPLICATION))
#define CHESS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_APPLICATION, ChessApplicationClass))

typedef struct _ChessApplication ChessApplication;
typedef struct _ChessApplicationClass ChessApplicationClass;
typedef struct _ChessApplicationPrivate ChessApplicationPrivate;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;

#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;

#define TYPE_AI_PROFILE (ai_profile_get_type ())
#define AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AI_PROFILE, AIProfile))
#define AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AI_PROFILE, AIProfileClass))
#define IS_AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AI_PROFILE))
#define IS_AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AI_PROFILE))
#define AI_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AI_PROFILE, AIProfileClass))

typedef struct _AIProfile AIProfile;
typedef struct _AIProfileClass AIProfileClass;

#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;

#define CHESS_APPLICATION_TYPE_PROMOTION_TYPE_SELECTED (chess_application_promotion_type_selected_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_CHESS_ENGINE_CECP (chess_engine_cecp_get_type ())
#define CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECP))
#define CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))
#define IS_CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_CECP))
#define IS_CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_CECP))
#define CHESS_ENGINE_CECP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))

typedef struct _ChessEngineCECP ChessEngineCECP;
typedef struct _ChessEngineCECPClass ChessEngineCECPClass;

#define TYPE_CHESS_ENGINE_UCI (chess_engine_uci_get_type ())
#define CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCI))
#define CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))
#define IS_CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_UCI))
#define IS_CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_UCI))
#define CHESS_ENGINE_UCI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))

typedef struct _ChessEngineUCI ChessEngineUCI;
typedef struct _ChessEngineUCIClass ChessEngineUCIClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ChessApplication {
	GtkApplication parent_instance;
	ChessApplicationPrivate * priv;
};

struct _ChessApplicationClass {
	GtkApplicationClass parent_class;
};

struct _ChessApplicationPrivate {
	GSettings* settings;
	GtkBuilder* builder;
	GtkBuilder* preferences_builder;
	GtkApplicationWindow* window;
	GtkContainer* view_container;
	ChessScene* scene;
	ChessView* view;
	GtkButton* pause_resume_button;
	GtkWidget* first_move_button;
	GtkWidget* prev_move_button;
	GtkWidget* next_move_button;
	GtkWidget* last_move_button;
	GtkComboBox* history_combo;
	GtkWidget* white_time_label;
	GtkWidget* black_time_label;
	GtkHeaderBar* headerbar;
	GtkDialog* preferences_dialog;
	GtkComboBox* side_combo;
	GtkComboBox* difficulty_combo;
	GtkComboBox* duration_combo;
	GtkAdjustment* duration_adjustment;
	GtkBox* custom_duration_box;
	GtkComboBox* custom_duration_units_combo;
	guint save_duration_timeout;
	GtkFileChooserDialog* open_dialog;
	GtkInfoBar* open_dialog_info_bar;
	GtkLabel* open_dialog_error_label;
	GtkFileChooserDialog* save_dialog;
	GtkInfoBar* save_dialog_info_bar;
	GtkLabel* save_dialog_error_label;
	GtkAboutDialog* about_dialog;
	PGNGame* pgn_game;
	ChessGame* game;
	gchar* autosave_filename;
	GFile* game_file;
	gboolean game_needs_saving;
	gboolean allow_claim_draw_dialog;
	gboolean starting;
	GList* ai_profiles;
	ChessPlayer* opponent;
	ChessPlayer* human_player;
	ChessEngine* opponent_engine;
};

typedef enum  {
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN,
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT,
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK,
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP
} ChessApplicationPromotionTypeSelected;

struct _Block1Data {
	int _ref_count_;
	ChessApplication* self;
	gchar* move;
};

struct _Block2Data {
	int _ref_count_;
	ChessApplication* self;
	ChessGame* original_game;
};


static gpointer chess_application_parent_class = NULL;

GType chess_application_get_type (void) G_GNUC_CONST;
GType chess_scene_get_type (void) G_GNUC_CONST;
GType chess_view_get_type (void) G_GNUC_CONST;
GType ai_profile_get_type (void) G_GNUC_CONST;
GType chess_engine_get_type (void) G_GNUC_CONST;
#define CHESS_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_APPLICATION, ChessApplicationPrivate))
enum  {
	CHESS_APPLICATION_DUMMY_PROPERTY
};
static GType chess_application_promotion_type_selected_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void chess_application_preferences_cb (ChessApplication* self);
static void _chess_application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_help_cb (ChessApplication* self);
static void _chess_application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_about_cb (ChessApplication* self);
static void _chess_application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_quit_cb (ChessApplication* self);
static void _chess_application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
#define CHESS_APPLICATION_NEW_GAME_ACTION_NAME "new"
#define CHESS_APPLICATION_OPEN_GAME_ACTION_NAME "open"
#define CHESS_APPLICATION_SAVE_GAME_ACTION_NAME "save"
#define CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME "save-as"
#define CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME "undo"
#define CHESS_APPLICATION_RESIGN_ACTION_NAME "resign"
#define CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME "pause-resume"
void chess_application_new_game_cb (ChessApplication* self);
static void _chess_application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_open_game_cb (ChessApplication* self);
static void _chess_application_open_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_save_game_cb (ChessApplication* self);
static void _chess_application_save_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_save_game_as_cb (ChessApplication* self);
static void _chess_application_save_game_as_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_undo_move_cb (ChessApplication* self);
static void _chess_application_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_resign_cb (ChessApplication* self);
static void _chess_application_resign_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_pause_resume_cb (ChessApplication* self);
static void _chess_application_pause_resume_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static ChessApplication* chess_application_new (void);
static ChessApplication* chess_application_construct (GType object_type);
static gint chess_application_real_handle_local_options (GApplication* base, GVariantDict* options);
static void chess_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint);
static void chess_application_real_startup (GApplication* base);
static void chess_application_real_shutdown (GApplication* base);
void chess_engine_stop (ChessEngine* self);
static void chess_application_real_activate (GApplication* base);
static void chess_application_update_pause_resume_button (ChessApplication* self);
ChessScene* chess_scene_new (void);
ChessScene* chess_scene_construct (GType object_type);
static gboolean __lambda10_ (ChessApplication* self, ChessPlayer* p);
static gboolean ___lambda10__chess_scene_is_human (ChessScene* _sender, ChessPlayer* player, gpointer self);
static void chess_application_scene_changed_cb (ChessApplication* self, ChessScene* scene);
static void _chess_application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self);
PieceType chess_application_show_promotion_type_selector (ChessApplication* self);
static PieceType _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender, gpointer self);
ChessView* chess_view_new (void);
ChessView* chess_view_construct (GType object_type);
void chess_view_set_scene (ChessView* self, ChessScene* value);
GList* ai_profile_load_ai_profiles (const gchar* filename);
const gchar* ai_profile_get_name (AIProfile* self);
const gchar* ai_profile_get_path (AIProfile* self);
static void chess_application_start_new_game (ChessApplication* self);
static void chess_application_load_game (ChessApplication* self, GFile* file, GError** error);
static void chess_application_add_accelerators (ChessApplication* self);
void chess_application_show (ChessApplication* self);
const gchar* chess_scene_get_theme_name (ChessScene* self);
static void chess_application_set_piece_image (ChessApplication* self, GtkImage* image, const gchar* filename);
void chess_application_quit_game (ChessApplication* self);
static gboolean chess_application_save_duration_cb (ChessApplication* self);
static void chess_application_autosave (ChessApplication* self);
static void chess_application_update_pgn_time_remaining (ChessApplication* self);
static void chess_application_update_history_panel (ChessApplication* self);
gint chess_scene_get_move_number (ChessScene* self);
static void chess_application_set_move_text (ChessApplication* self, GtkTreeIter* iter, ChessMove* move);
static void chess_application_start_game (ChessApplication* self);
static void chess_application_game_turn_cb (ChessApplication* self, ChessGame* game, ChessPlayer* player);
static void _chess_application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self);
static void chess_application_game_move_cb (ChessApplication* self, ChessGame* game, ChessMove* move);
static void _chess_application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self);
static void chess_application_game_undo_cb (ChessApplication* self, ChessGame* game);
static void _chess_application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self);
static void chess_application_game_end_cb (ChessApplication* self, ChessGame* game);
static void _chess_application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self);
static void chess_application_game_clock_tick_cb (ChessApplication* self, ChessClock* clock);
static void _chess_application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self);
void chess_scene_set_game (ChessScene* self, ChessGame* value);
static void chess_application_engine_ready_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self);
static void chess_application_engine_move_cb (ChessApplication* self, ChessEngine* engine, const gchar* move);
static void _chess_application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self);
static void chess_application_engine_resigned_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender, gpointer self);
static void chess_application_engine_stopped_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_stopped_cb_chess_engine_stopped (ChessEngine* _sender, gpointer self);
static void chess_application_engine_error_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_error_cb_chess_engine_error (ChessEngine* _sender, gpointer self);
static void chess_application_engine_claim_draw_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender, gpointer self);
static void chess_application_engine_offer_draw_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender, gpointer self);
static ChessEngine* chess_application_get_engine (ChessApplication* self, const gchar* name, const gchar* difficulty);
gboolean chess_engine_start (ChessEngine* self);
static void chess_application_disable_window_action (ChessApplication* self, const gchar* name);
static void chess_application_enable_window_action (ChessApplication* self, const gchar* name);
void chess_engine_start_game (ChessEngine* self);
static void chess_application_update_action_status (ChessApplication* self);
static void chess_application_update_headerbar_title (ChessApplication* self);
void chess_engine_move (ChessEngine* self);
gchar** ai_profile_get_easy_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
gchar** ai_profile_get_easy_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
gchar** ai_profile_get_easy_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
gchar** ai_profile_get_hard_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup4 (gchar** self, int length);
gchar** ai_profile_get_hard_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup5 (gchar** self, int length);
gchar** ai_profile_get_hard_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup6 (gchar** self, int length);
gchar** ai_profile_get_normal_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup7 (gchar** self, int length);
gchar** ai_profile_get_normal_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup8 (gchar** self, int length);
gchar** ai_profile_get_normal_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup9 (gchar** self, int length);
const gchar* ai_profile_get_protocol (AIProfile* self);
const gchar* ai_profile_get_binary (AIProfile* self);
guint ai_profile_get_delay_seconds (AIProfile* self);
ChessEngineCECP* chess_engine_cecp_new (const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1);
ChessEngineCECP* chess_engine_cecp_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1);
GType chess_engine_cecp_get_type (void) G_GNUC_CONST;
ChessEngineUCI* chess_engine_uci_new (const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
ChessEngineUCI* chess_engine_uci_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
GType chess_engine_uci_get_type (void) G_GNUC_CONST;
gboolean chess_engine_get_ready (ChessEngine* self);
static void chess_application_do_engine_move (ChessApplication* self, const gchar* move);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ___lambda7_ (Block1Data* _data1_);
static gboolean ____lambda7__gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda8_ (Block2Data* _data2_);
static gboolean ___lambda8__gsource_func (gpointer self);
static void chess_application_present_claim_draw_dialog (ChessApplication* self);
const gchar* chess_scene_get_move_format (ChessScene* self);
void chess_scene_set_move_number (ChessScene* self, gint value);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_undo (ChessEngine* self);
gboolean G_MODULE_EXPORT gnome_chess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self);
gboolean G_MODULE_EXPORT gnome_chess_app_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, ChessApplication* self);
gboolean G_MODULE_EXPORT gnome_chess_app_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, ChessApplication* self);
static gboolean chess_application_prompt_save_game (ChessApplication* self, const gchar* prompt_text);
static void chess_application_present_save_dialog (ChessApplication* self, const gchar* cancel_button_label, const gchar* save_button_label);
gboolean G_MODULE_EXPORT white_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self);
static void chess_application_draw_time (ChessApplication* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1);
static gchar* chess_application_make_clock_text (ChessApplication* self, ChessClock* clock, Color color);
gboolean G_MODULE_EXPORT black_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self);
static gint chess_application_compute_time_label_width_request (ChessApplication* self, cairo_t* c);
void G_MODULE_EXPORT history_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT history_latest_clicked_cb (GtkWidget* widget, ChessApplication* self);
void G_MODULE_EXPORT history_next_clicked_cb (GtkWidget* widget, ChessApplication* self);
void G_MODULE_EXPORT history_previous_clicked_cb (GtkWidget* widget, ChessApplication* self);
void G_MODULE_EXPORT history_start_clicked_cb (GtkWidget* widget, ChessApplication* self);
static void chess_application_set_combo (ChessApplication* self, GtkComboBox* combo, gint value_index, const gchar* value);
static void chess_application_set_duration (ChessApplication* self, gint duration, gboolean simplify);
static gchar* chess_application_get_combo (ChessApplication* self, GtkComboBox* combo, gint value_index);
void G_MODULE_EXPORT side_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT opponent_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT difficulty_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
static gint chess_application_get_duration (ChessApplication* self);
void G_MODULE_EXPORT duration_changed_cb (GtkAdjustment* adjustment, ChessApplication* self);
static void chess_application_save_duration (ChessApplication* self);
void G_MODULE_EXPORT duration_units_changed_cb (GtkWidget* widget, ChessApplication* self);
static gboolean _chess_application_save_duration_cb_gsource_func (gpointer self);
void G_MODULE_EXPORT duration_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT preferences_response_cb (GtkWidget* widget, gint response_id, ChessApplication* self);
gboolean G_MODULE_EXPORT preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self);
void G_MODULE_EXPORT piece_style_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT move_format_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT orientation_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
static void chess_application_about_response_cb (ChessApplication* self, gint response_id);
static void _chess_application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void chess_application_add_info_bar_to_dialog (ChessApplication* self, GtkDialog* dialog, GtkInfoBar** info_bar, GtkLabel** label);
static void chess_application_save_dialog_cb (ChessApplication* self, gint response_id);
static void __lambda6_ (ChessApplication* self);
static void ___lambda6__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void _chess_application_save_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void __lambda9_ (ChessApplication* self);
static void chess_application_open_dialog_cb (ChessApplication* self, gint response_id);
static void ___lambda9__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void _chess_application_open_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
gint chess_application_main (gchar** args, int args_length1);
static void chess_application_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry CHESS_APPLICATION_app_entries[4] = {{"preferences", _chess_application_preferences_cb_gsimple_action_activate_callback}, {"help", _chess_application_help_cb_gsimple_action_activate_callback}, {"about", _chess_application_about_cb_gsimple_action_activate_callback}, {"quit", _chess_application_quit_cb_gsimple_action_activate_callback}};
static const GActionEntry CHESS_APPLICATION_window_entries[7] = {{CHESS_APPLICATION_NEW_GAME_ACTION_NAME, _chess_application_new_game_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_OPEN_GAME_ACTION_NAME, _chess_application_open_game_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_SAVE_GAME_ACTION_NAME, _chess_application_save_game_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME, _chess_application_save_game_as_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME, _chess_application_undo_move_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_RESIGN_ACTION_NAME, _chess_application_resign_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME, _chess_application_pause_resume_cb_gsimple_action_activate_callback}};
static const GOptionEntry CHESS_APPLICATION_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Show release version", NULL}, {NULL}};
static const gchar* CHESS_APPLICATION_authors[2] = {"Robert Ancell <robert.ancell@gmail.com>", NULL};
static const gchar* CHESS_APPLICATION_artists[3] = {"Max Froumentin (pieces)", "Jakub Steiner (icon)", NULL};

static GType chess_application_promotion_type_selected_get_type (void) {
	static volatile gsize chess_application_promotion_type_selected_type_id__volatile = 0;
	if (g_once_init_enter (&chess_application_promotion_type_selected_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN", "queen"}, {CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT", "knight"}, {CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK", "rook"}, {CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP", "bishop"}, {0, NULL, NULL}};
		GType chess_application_promotion_type_selected_type_id;
		chess_application_promotion_type_selected_type_id = g_enum_register_static ("ChessApplicationPromotionTypeSelected", values);
		g_once_init_leave (&chess_application_promotion_type_selected_type_id__volatile, chess_application_promotion_type_selected_type_id);
	}
	return chess_application_promotion_type_selected_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 417 "gnome-chess.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_list_free (self);
#line 426 "gnome-chess.c"
}


static void _chess_application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_preferences_cb ((ChessApplication*) self);
#line 433 "gnome-chess.c"
}


static void _chess_application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_help_cb ((ChessApplication*) self);
#line 440 "gnome-chess.c"
}


static void _chess_application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_about_cb ((ChessApplication*) self);
#line 447 "gnome-chess.c"
}


static void _chess_application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_quit_cb ((ChessApplication*) self);
#line 454 "gnome-chess.c"
}


static void _chess_application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_new_game_cb ((ChessApplication*) self);
#line 461 "gnome-chess.c"
}


static void _chess_application_open_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_open_game_cb ((ChessApplication*) self);
#line 468 "gnome-chess.c"
}


static void _chess_application_save_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_save_game_cb ((ChessApplication*) self);
#line 475 "gnome-chess.c"
}


static void _chess_application_save_game_as_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_save_game_as_cb ((ChessApplication*) self);
#line 482 "gnome-chess.c"
}


static void _chess_application_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_undo_move_cb ((ChessApplication*) self);
#line 489 "gnome-chess.c"
}


static void _chess_application_resign_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_resign_cb ((ChessApplication*) self);
#line 496 "gnome-chess.c"
}


static void _chess_application_pause_resume_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_pause_resume_cb ((ChessApplication*) self);
#line 503 "gnome-chess.c"
}


static ChessApplication* chess_application_construct (GType object_type) {
	ChessApplication * self = NULL;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) g_object_new (object_type, "application-id", "org.gnome.gnome-chess", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_application_add_main_option_entries ((GApplication*) self, CHESS_APPLICATION_option_entries);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return self;
#line 515 "gnome-chess.c"
}


static ChessApplication* chess_application_new (void) {
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return chess_application_construct (TYPE_CHESS_APPLICATION);
#line 522 "gnome-chess.c"
}


static gint chess_application_real_handle_local_options (GApplication* base, GVariantDict* options) {
	ChessApplication * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) base;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = options;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_) {
#line 541 "gnome-chess.c"
		FILE* _tmp2_ = NULL;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = stderr;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		fprintf (_tmp2_, "gnome-chess %s\n", VERSION);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = EXIT_SUCCESS;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 551 "gnome-chess.c"
	}
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = -1;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 557 "gnome-chess.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return self ? g_object_ref (self) : NULL;
#line 564 "gnome-chess.c"
}


static void chess_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint) {
	ChessApplication * self;
	GFile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GFile** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) base;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (hint != NULL);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = files;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0__length1 = files_length1;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0__length1 != 1) {
#line 586 "gnome-chess.c"
		const gchar* _tmp1_ = NULL;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = _ ("GNOME Chess can only open one PGN at a time.");
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:120: %s", _tmp1_);
#line 592 "gnome-chess.c"
	}
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = files;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2__length1 = files_length1;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_[0];
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game_file);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->game_file = _tmp4_;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_application_activate ((GApplication*) self);
#line 608 "gnome-chess.c"
}


static void chess_application_real_startup (GApplication* base) {
	ChessApplication * self;
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) base;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	G_APPLICATION_CLASS (chess_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	setlocale (LC_ALL, "");
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	textdomain (GETTEXT_PACKAGE);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = _ ("Chess");
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_set_application_name (_tmp0_);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_default_icon_name ("gnome-chess");
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = g_settings_new ("org.gnome.chess");
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->settings);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->settings = _tmp1_;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_action_map_add_action_entries ((GActionMap*) self, CHESS_APPLICATION_app_entries, G_N_ELEMENTS (CHESS_APPLICATION_app_entries), self);
#line 642 "gnome-chess.c"
}


static void chess_application_real_shutdown (GApplication* base) {
	ChessApplication * self;
	ChessEngine* _tmp0_ = NULL;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) base;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 655 "gnome-chess.c"
		ChessEngine* _tmp1_ = NULL;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->opponent_engine;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_engine_stop (_tmp1_);
#line 661 "gnome-chess.c"
	}
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	G_APPLICATION_CLASS (chess_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 665 "gnome-chess.c"
}


static gboolean __lambda10_ (ChessApplication* self, ChessPlayer* p) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (p != NULL, FALSE);
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = p;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->human_player;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = _tmp0_ == _tmp1_;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 683 "gnome-chess.c"
}


static gboolean ___lambda10__chess_scene_is_human (ChessScene* _sender, ChessPlayer* player, gpointer self) {
	gboolean result;
	result = __lambda10_ ((ChessApplication*) self, player);
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 692 "gnome-chess.c"
}


static void _chess_application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self) {
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_scene_changed_cb ((ChessApplication*) self, _sender);
#line 699 "gnome-chess.c"
}


static PieceType _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender, gpointer self) {
	PieceType result;
	result = chess_application_show_promotion_type_selector ((ChessApplication*) self);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 708 "gnome-chess.c"
}


static void chess_application_real_activate (GApplication* base) {
	ChessApplication * self;
	GFile* data_dir = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GtkBuilder* _tmp7_ = NULL;
	GMenu* app_menu = NULL;
	GtkBuilder* _tmp12_ = NULL;
	GObject* _tmp13_ = NULL;
	GMenu* _tmp14_ = NULL;
	GtkBuilder* _tmp20_ = NULL;
	GObject* _tmp21_ = NULL;
	GtkApplicationWindow* _tmp22_ = NULL;
	GtkBuilder* _tmp23_ = NULL;
	GObject* _tmp24_ = NULL;
	GtkButton* _tmp25_ = NULL;
	GtkBuilder* _tmp26_ = NULL;
	GObject* _tmp27_ = NULL;
	GtkWidget* _tmp28_ = NULL;
	GtkBuilder* _tmp29_ = NULL;
	GObject* _tmp30_ = NULL;
	GtkWidget* _tmp31_ = NULL;
	GtkBuilder* _tmp32_ = NULL;
	GObject* _tmp33_ = NULL;
	GtkWidget* _tmp34_ = NULL;
	GtkBuilder* _tmp35_ = NULL;
	GObject* _tmp36_ = NULL;
	GtkWidget* _tmp37_ = NULL;
	GtkBuilder* _tmp38_ = NULL;
	GObject* _tmp39_ = NULL;
	GtkComboBox* _tmp40_ = NULL;
	GtkBuilder* _tmp41_ = NULL;
	GObject* _tmp42_ = NULL;
	GtkWidget* _tmp43_ = NULL;
	GtkBuilder* _tmp44_ = NULL;
	GObject* _tmp45_ = NULL;
	GtkWidget* _tmp46_ = NULL;
	GtkBuilder* _tmp47_ = NULL;
	GObject* _tmp48_ = NULL;
	GtkContainer* _tmp49_ = NULL;
	GtkBuilder* _tmp50_ = NULL;
	GObject* _tmp51_ = NULL;
	GtkHeaderBar* _tmp52_ = NULL;
	GtkBuilder* _tmp53_ = NULL;
	GtkApplicationWindow* _tmp54_ = NULL;
	GtkApplicationWindow* _tmp55_ = NULL;
	ChessScene* _tmp56_ = NULL;
	ChessScene* _tmp57_ = NULL;
	ChessScene* _tmp58_ = NULL;
	ChessScene* _tmp59_ = NULL;
	GSettings* _tmp60_ = NULL;
	ChessScene* _tmp61_ = NULL;
	GSettings* _tmp62_ = NULL;
	ChessScene* _tmp63_ = NULL;
	GSettings* _tmp64_ = NULL;
	ChessScene* _tmp65_ = NULL;
	GSettings* _tmp66_ = NULL;
	ChessScene* _tmp67_ = NULL;
	GSettings* _tmp68_ = NULL;
	ChessScene* _tmp69_ = NULL;
	ChessView* _tmp70_ = NULL;
	ChessView* _tmp71_ = NULL;
	ChessView* _tmp72_ = NULL;
	ChessScene* _tmp73_ = NULL;
	GtkContainer* _tmp74_ = NULL;
	ChessView* _tmp75_ = NULL;
	ChessView* _tmp76_ = NULL;
	gchar* system_engine_cfg = NULL;
	gchar* _tmp77_ = NULL;
	gchar* user_engine_cfg = NULL;
	const gchar* _tmp78_ = NULL;
	gchar* _tmp79_ = NULL;
	const gchar* _tmp80_ = NULL;
	gboolean _tmp81_ = FALSE;
	GList* _tmp88_ = NULL;
	gchar* _tmp96_ = NULL;
	gchar* _tmp97_ = NULL;
	gchar* _tmp98_ = NULL;
	GFile* _tmp99_ = NULL;
	GFile* _tmp105_ = NULL;
	GtkApplicationWindow* _tmp113_ = NULL;
	GSettings* _tmp114_ = NULL;
	gint _tmp115_ = 0;
	GSettings* _tmp116_ = NULL;
	gint _tmp117_ = 0;
	GSettings* _tmp118_ = NULL;
	gboolean _tmp119_ = FALSE;
	GtkApplicationWindow* _tmp121_ = NULL;
	GError * _inner_error_ = NULL;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) base;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = g_get_user_data_dir ();
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = g_build_filename (_tmp0_, "gnome-chess", NULL, NULL);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = g_file_new_for_path (_tmp2_);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp2_);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	data_dir = _tmp4_;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = g_file_get_path (data_dir);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_mkdir_with_parents (_tmp6_, 0755);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp6_);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = gtk_builder_new ();
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->builder);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->builder = _tmp7_;
#line 836 "gnome-chess.c"
	{
		GtkBuilder* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = self->priv->builder;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = g_build_filename (PKGDATADIR, "menu.ui", NULL, NULL);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp9_;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_builder_add_from_file (_tmp8_, _tmp10_, &_inner_error_);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp10_);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 853 "gnome-chess.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_ = NULL;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = e->message;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_error ("gnome-chess.vala:165: Error loading menu UI: %s", _tmp11_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 872 "gnome-chess.c"
	}
	__finally0:
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (data_dir);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 885 "gnome-chess.c"
	}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->builder;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = gtk_builder_get_object (_tmp12_, "appmenu");
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_menu_get_type (), GMenu));
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	app_menu = _tmp14_;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_application_set_app_menu ((GtkApplication*) self, (GMenuModel*) app_menu);
#line 897 "gnome-chess.c"
	{
		GtkBuilder* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = self->priv->builder;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = g_build_filename (PKGDATADIR, "gnome-chess.ui", NULL, NULL);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _tmp16_;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_builder_add_from_file (_tmp15_, _tmp17_, &_inner_error_);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp17_);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 914 "gnome-chess.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = e;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = _tmp18_->message;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:177: Could not load UI: %s", _tmp19_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 936 "gnome-chess.c"
	}
	__finally1:
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (app_menu);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (data_dir);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 951 "gnome-chess.c"
	}
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = self->priv->builder;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = gtk_builder_get_object (_tmp20_, "gnome_chess_app");
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_application_window_get_type (), GtkApplicationWindow));
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->window);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->window = _tmp22_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->builder;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = gtk_builder_get_object (_tmp23_, "pause_button");
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_button_get_type (), GtkButton));
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pause_resume_button);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->pause_resume_button = _tmp25_;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = self->priv->builder;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = gtk_builder_get_object (_tmp26_, "first_move_button");
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget));
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->first_move_button);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->first_move_button = _tmp28_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = self->priv->builder;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = gtk_builder_get_object (_tmp29_, "prev_move_button");
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget));
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->prev_move_button);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->prev_move_button = _tmp31_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = self->priv->builder;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = gtk_builder_get_object (_tmp32_, "next_move_button");
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget));
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->next_move_button);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->next_move_button = _tmp34_;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = self->priv->builder;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = gtk_builder_get_object (_tmp35_, "last_move_button");
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget));
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->last_move_button);
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->last_move_button = _tmp37_;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = self->priv->builder;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = gtk_builder_get_object (_tmp38_, "history_combo");
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_combo_box_get_type (), GtkComboBox));
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->history_combo);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->history_combo = _tmp40_;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = self->priv->builder;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = gtk_builder_get_object (_tmp41_, "white_time_label");
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_widget_get_type (), GtkWidget));
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->white_time_label);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->white_time_label = _tmp43_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp44_ = self->priv->builder;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = gtk_builder_get_object (_tmp44_, "black_time_label");
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp46_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_widget_get_type (), GtkWidget));
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->black_time_label);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->black_time_label = _tmp46_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp47_ = self->priv->builder;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp48_ = gtk_builder_get_object (_tmp47_, "view_container");
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp49_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_container_get_type (), GtkContainer));
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->view_container);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->view_container = _tmp49_;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp50_ = self->priv->builder;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp51_ = gtk_builder_get_object (_tmp50_, "headerbar");
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp52_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_header_bar_get_type (), GtkHeaderBar));
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->headerbar = _tmp52_;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp53_ = self->priv->builder;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_builder_connect_signals (_tmp53_, self);
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_pause_resume_button (self);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = self->priv->window;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_action_map_add_action_entries ((GActionMap*) _tmp54_, CHESS_APPLICATION_window_entries, G_N_ELEMENTS (CHESS_APPLICATION_window_entries), self);
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = self->priv->window;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp55_);
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp56_ = chess_scene_new ();
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->scene);
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->scene = _tmp56_;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp57_ = self->priv->scene;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp57_, "is-human", (GCallback) ___lambda10__chess_scene_is_human, self, 0);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = self->priv->scene;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp58_, "changed", (GCallback) _chess_application_scene_changed_cb_chess_scene_changed, self, 0);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = self->priv->scene;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp59_, "choose-promotion-type", (GCallback) _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type, self, 0);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = self->priv->settings;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp61_ = self->priv->scene;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp60_, "show-move-hints", (GObject*) _tmp61_, "show-move-hints", G_SETTINGS_BIND_GET);
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp62_ = self->priv->settings;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp63_ = self->priv->scene;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp62_, "show-numbering", (GObject*) _tmp63_, "show-numbering", G_SETTINGS_BIND_GET);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp64_ = self->priv->settings;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp65_ = self->priv->scene;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp64_, "piece-theme", (GObject*) _tmp65_, "theme-name", G_SETTINGS_BIND_GET);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp66_ = self->priv->settings;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp67_ = self->priv->scene;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp66_, "move-format", (GObject*) _tmp67_, "move-format", G_SETTINGS_BIND_GET);
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp68_ = self->priv->settings;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp69_ = self->priv->scene;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp68_, "board-side", (GObject*) _tmp69_, "board-side", G_SETTINGS_BIND_GET);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp70_ = chess_view_new ();
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp70_);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->view);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->view = _tmp70_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp71_ = self->priv->view;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp71_, 400, 400);
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp72_ = self->priv->view;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp73_ = self->priv->scene;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_view_set_scene (_tmp72_, _tmp73_);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp74_ = self->priv->view_container;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp75_ = self->priv->view;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_container_add (_tmp74_, (GtkWidget*) _tmp75_);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp76_ = self->priv->view;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp76_);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp77_ = g_build_filename (SYSCONFDIR, "gnome-chess", "engines.conf", NULL, NULL);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	system_engine_cfg = _tmp77_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp78_ = g_get_user_config_dir ();
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp79_ = g_build_filename (_tmp78_, "gnome-chess", "engines.conf", NULL, NULL);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	user_engine_cfg = _tmp79_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp80_ = user_engine_cfg;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp81_ = g_file_test (_tmp80_, G_FILE_TEST_EXISTS);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp81_) {
#line 1169 "gnome-chess.c"
		const gchar* _tmp82_ = NULL;
		GList* _tmp83_ = NULL;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp82_ = user_engine_cfg;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp83_ = ai_profile_load_ai_profiles (_tmp82_);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		__g_list_free__g_object_unref0_0 (self->priv->ai_profiles);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->ai_profiles = _tmp83_;
#line 1180 "gnome-chess.c"
	} else {
		const gchar* _tmp84_ = NULL;
		gboolean _tmp85_ = FALSE;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp84_ = system_engine_cfg;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp85_ = g_file_test (_tmp84_, G_FILE_TEST_EXISTS);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp85_) {
#line 1190 "gnome-chess.c"
			const gchar* _tmp86_ = NULL;
			GList* _tmp87_ = NULL;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp86_ = system_engine_cfg;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp87_ = ai_profile_load_ai_profiles (_tmp86_);
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			__g_list_free__g_object_unref0_0 (self->priv->ai_profiles);
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->ai_profiles = _tmp87_;
#line 1201 "gnome-chess.c"
		} else {
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:222: engines.conf not found");
#line 1205 "gnome-chess.c"
		}
	}
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp88_ = self->priv->ai_profiles;
#line 1210 "gnome-chess.c"
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		profile_collection = _tmp88_;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
#line 1218 "gnome-chess.c"
			AIProfile* _tmp89_ = NULL;
			AIProfile* profile = NULL;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp89_ = _g_object_ref0 ((AIProfile*) profile_it->data);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			profile = _tmp89_;
#line 1225 "gnome-chess.c"
			{
				AIProfile* _tmp90_ = NULL;
				const gchar* _tmp91_ = NULL;
				const gchar* _tmp92_ = NULL;
				AIProfile* _tmp93_ = NULL;
				const gchar* _tmp94_ = NULL;
				const gchar* _tmp95_ = NULL;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp90_ = profile;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp91_ = ai_profile_get_name (_tmp90_);
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp92_ = _tmp91_;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp93_ = profile;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp94_ = ai_profile_get_path (_tmp93_);
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp95_ = _tmp94_;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				g_debug ("gnome-chess.vala:225: Detected AI profile %s in %s", _tmp92_, _tmp95_);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (profile);
#line 1249 "gnome-chess.c"
			}
		}
	}
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp96_ = g_file_get_path (data_dir);
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp97_ = _tmp96_;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp98_ = g_strconcat (_tmp97_, "/autosave.pgn", NULL);
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (self->priv->autosave_filename);
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->autosave_filename = _tmp98_;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp97_);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp99_ = self->priv->game_file;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp99_ == NULL) {
#line 1269 "gnome-chess.c"
		const gchar* _tmp100_ = NULL;
		gboolean _tmp101_ = FALSE;
		GFile* _tmp104_ = NULL;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp100_ = self->priv->autosave_filename;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp101_ = g_file_test (_tmp100_, G_FILE_TEST_EXISTS);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp101_) {
#line 1279 "gnome-chess.c"
			const gchar* _tmp102_ = NULL;
			GFile* _tmp103_ = NULL;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp102_ = self->priv->autosave_filename;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp103_ = g_file_new_for_path (_tmp102_);
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->game_file);
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->game_file = _tmp103_;
#line 1290 "gnome-chess.c"
		}
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp104_ = self->priv->game_file;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp104_ == NULL) {
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_start_new_game (self);
#line 1298 "gnome-chess.c"
		}
	}
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp105_ = self->priv->game_file;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp105_ != NULL) {
#line 1305 "gnome-chess.c"
		{
			GFile* _tmp106_ = NULL;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp106_ = self->priv->game_file;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_load_game (self, _tmp106_, &_inner_error_);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1314 "gnome-chess.c"
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			FILE* _tmp107_ = NULL;
			GFile* _tmp108_ = NULL;
			gchar* _tmp109_ = NULL;
			gchar* _tmp110_ = NULL;
			GError* _tmp111_ = NULL;
			const gchar* _tmp112_ = NULL;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			e = _inner_error_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_inner_error_ = NULL;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp107_ = stderr;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp108_ = self->priv->game_file;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp109_ = g_file_get_path (_tmp108_);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp110_ = _tmp109_;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp111_ = e;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp112_ = _tmp111_->message;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			fprintf (_tmp107_, "Failed to load %s: %s\n", _tmp110_, _tmp112_);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (_tmp110_);
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_application_quit ((GApplication*) self);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_error_free0 (e);
#line 1352 "gnome-chess.c"
		}
		__finally2:
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (user_engine_cfg);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (system_engine_cfg);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (app_menu);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (data_dir);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_clear_error (&_inner_error_);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return;
#line 1371 "gnome-chess.c"
		}
	}
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp113_ = self->priv->window;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp114_ = self->priv->settings;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp115_ = g_settings_get_int (_tmp114_, "width");
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp116_ = self->priv->settings;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp117_ = g_settings_get_int (_tmp116_, "height");
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp113_, _tmp115_, _tmp117_);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp118_ = self->priv->settings;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp119_ = g_settings_get_boolean (_tmp118_, "maximized");
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp119_) {
#line 1392 "gnome-chess.c"
		GtkApplicationWindow* _tmp120_ = NULL;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp120_ = self->priv->window;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_window_maximize ((GtkWindow*) _tmp120_);
#line 1398 "gnome-chess.c"
	}
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_add_accelerators (self);
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_show (self);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp121_ = self->priv->window;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp121_);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (user_engine_cfg);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (system_engine_cfg);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (app_menu);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (data_dir);
#line 1416 "gnome-chess.c"
}


PieceType chess_application_show_promotion_type_selector (ChessApplication* self) {
	PieceType result = 0;
	GtkBuilder* promotion_type_selector_builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GtkDialog* promotion_type_selector_dialog = NULL;
	GtkBuilder* _tmp6_ = NULL;
	GObject* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	GtkDialog* _tmp9_ = NULL;
	GtkApplicationWindow* _tmp10_ = NULL;
	gchar* color = NULL;
	ChessGame* _tmp11_ = NULL;
	ChessPlayer* _tmp12_ = NULL;
	ChessPlayer* _tmp13_ = NULL;
	Color _tmp14_ = 0;
	gchar* filename = NULL;
	ChessScene* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	GtkBuilder* _tmp25_ = NULL;
	GObject* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	ChessScene* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	GtkBuilder* _tmp35_ = NULL;
	GObject* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	ChessScene* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	GtkBuilder* _tmp45_ = NULL;
	GObject* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	ChessScene* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	GtkBuilder* _tmp55_ = NULL;
	GObject* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	GtkBuilder* _tmp58_ = NULL;
	PieceType selection = 0;
	gint choice = 0;
	GtkDialog* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	GtkDialog* _tmp62_ = NULL;
	GError * _inner_error_ = NULL;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = gtk_builder_new ();
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (promotion_type_selector_builder);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	promotion_type_selector_builder = _tmp0_;
#line 1493 "gnome-chess.c"
	{
		GtkBuilder* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = promotion_type_selector_builder;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = g_build_filename (PKGDATADIR, "promotion-type-selector.ui", NULL, NULL);
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = _tmp2_;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_builder_add_from_file (_tmp1_, _tmp3_, &_inner_error_);
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp3_);
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1510 "gnome-chess.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = e;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_->message;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:275: Could not load promotion type selector UI: %s", _tmp5_);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 1532 "gnome-chess.c"
	}
	__finally3:
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (promotion_type_selector_builder);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return 0;
#line 1545 "gnome-chess.c"
	}
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = promotion_type_selector_builder;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = gtk_builder_get_object (_tmp6_, "dialog_promotion_type_selector");
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp7_) : NULL);
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	promotion_type_selector_dialog = _tmp8_;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = promotion_type_selector_dialog;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->window;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp9_, (GtkWindow*) _tmp10_);
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->game;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = chess_game_get_current_player (_tmp11_);
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = _tmp12_;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = _tmp13_->color;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp14_ == COLOR_WHITE) {
#line 1571 "gnome-chess.c"
		gchar* _tmp15_ = NULL;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = g_strdup ("white");
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (color);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		color = _tmp15_;
#line 1579 "gnome-chess.c"
	} else {
		gchar* _tmp16_ = NULL;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = g_strdup ("black");
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (color);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		color = _tmp16_;
#line 1588 "gnome-chess.c"
	}
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = self->priv->scene;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = chess_scene_get_theme_name (_tmp17_);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = _tmp18_;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = color;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = g_strdup_printf ("%sQueen.svg", _tmp20_);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = _tmp21_;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = g_build_filename (PKGDATADIR, "pieces", _tmp19_, _tmp22_, NULL);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = _tmp23_;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp22_);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	filename = _tmp24_;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = promotion_type_selector_builder;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = gtk_builder_get_object (_tmp25_, "image_queen");
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = filename;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, gtk_image_get_type ()) ? ((GtkImage*) _tmp26_) : NULL, _tmp27_);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = self->priv->scene;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = chess_scene_get_theme_name (_tmp28_);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = _tmp29_;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = color;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = g_strdup_printf ("%sKnight.svg", _tmp31_);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = _tmp32_;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = g_build_filename (PKGDATADIR, "pieces", _tmp30_, _tmp33_, NULL);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	filename = _tmp34_;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp33_);
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = promotion_type_selector_builder;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = gtk_builder_get_object (_tmp35_, "image_knight");
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = filename;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, gtk_image_get_type ()) ? ((GtkImage*) _tmp36_) : NULL, _tmp37_);
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = self->priv->scene;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = chess_scene_get_theme_name (_tmp38_);
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = _tmp39_;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = color;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = g_strdup_printf ("%sRook.svg", _tmp41_);
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = _tmp42_;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp44_ = g_build_filename (PKGDATADIR, "pieces", _tmp40_, _tmp43_, NULL);
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	filename = _tmp44_;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp43_);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = promotion_type_selector_builder;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp46_ = gtk_builder_get_object (_tmp45_, "image_rook");
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp47_ = filename;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, gtk_image_get_type ()) ? ((GtkImage*) _tmp46_) : NULL, _tmp47_);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp48_ = self->priv->scene;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp49_ = chess_scene_get_theme_name (_tmp48_);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp50_ = _tmp49_;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp51_ = color;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp52_ = g_strdup_printf ("%sBishop.svg", _tmp51_);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp53_ = _tmp52_;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = g_build_filename (PKGDATADIR, "pieces", _tmp50_, _tmp53_, NULL);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	filename = _tmp54_;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp53_);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = promotion_type_selector_builder;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp56_ = gtk_builder_get_object (_tmp55_, "image_bishop");
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp57_ = filename;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, gtk_image_get_type ()) ? ((GtkImage*) _tmp56_) : NULL, _tmp57_);
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = promotion_type_selector_builder;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_builder_connect_signals (_tmp58_, self);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = promotion_type_selector_dialog;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = gtk_dialog_run (_tmp59_);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	choice = _tmp60_;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp61_ = choice;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	switch (_tmp61_) {
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN:
#line 1718 "gnome-chess.c"
		{
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			selection = PIECE_TYPE_QUEEN;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 1724 "gnome-chess.c"
		}
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT:
#line 1728 "gnome-chess.c"
		{
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			selection = PIECE_TYPE_KNIGHT;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 1734 "gnome-chess.c"
		}
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK:
#line 1738 "gnome-chess.c"
		{
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			selection = PIECE_TYPE_ROOK;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 1744 "gnome-chess.c"
		}
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP:
#line 1748 "gnome-chess.c"
		{
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			selection = PIECE_TYPE_BISHOP;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 1754 "gnome-chess.c"
		}
		default:
		{
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			selection = PIECE_TYPE_QUEEN;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 1762 "gnome-chess.c"
		}
	}
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp62_ = promotion_type_selector_dialog;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp62_);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = selection;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (color);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (promotion_type_selector_dialog);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (promotion_type_selector_builder);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 1781 "gnome-chess.c"
}


static void chess_application_set_piece_image (ChessApplication* self, GtkImage* image, const gchar* filename) {
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (image != NULL);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (filename != NULL);
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_icon_size_lookup (GTK_ICON_SIZE_DIALOG, &_tmp0_, &_tmp1_);
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	width = _tmp0_;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	height = _tmp1_;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 1808 "gnome-chess.c"
	}
	{
		RsvgHandle* h = NULL;
		const gchar* _tmp3_ = NULL;
		RsvgHandle* _tmp4_ = NULL;
		cairo_surface_t* s = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		cairo_surface_t* _tmp7_ = NULL;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp8_ = NULL;
		cairo_t* _tmp9_ = NULL;
		cairo_matrix_t m = {0};
		gint _tmp10_ = 0;
		RsvgHandle* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		RsvgHandle* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		cairo_t* _tmp18_ = NULL;
		cairo_matrix_t _tmp19_ = {0};
		RsvgHandle* _tmp20_ = NULL;
		cairo_t* _tmp21_ = NULL;
		GdkPixbuf* p = NULL;
		cairo_surface_t* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		GdkPixbuf* _tmp25_ = NULL;
		GtkImage* _tmp26_ = NULL;
		GdkPixbuf* _tmp27_ = NULL;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = filename;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = rsvg_handle_new_from_file (_tmp3_, &_inner_error_);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		h = _tmp4_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1849 "gnome-chess.c"
			goto __catch4_g_error;
		}
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = width;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = height;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp5_, _tmp6_);
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		s = _tmp7_;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = s;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = cairo_create (_tmp8_);
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		c = _tmp9_;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		cairo_matrix_init_identity (&m);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = width;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = h;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_object_get (_tmp11_, "width", &_tmp12_, NULL);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = _tmp12_;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = height;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = h;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_object_get (_tmp15_, "height", &_tmp16_, NULL);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _tmp16_;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		cairo_matrix_scale (&m, ((gdouble) _tmp10_) / _tmp13_, ((gdouble) _tmp14_) / _tmp17_);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = c;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = m;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		cairo_set_matrix (_tmp18_, &_tmp19_);
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = h;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = c;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		rsvg_handle_render_cairo (_tmp20_, _tmp21_);
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = s;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = width;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = height;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = gdk_pixbuf_get_from_surface (_tmp22_, 0, 0, _tmp23_, _tmp24_);
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		p = _tmp25_;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = image;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = p;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_image_set_from_pixbuf (_tmp26_, _tmp27_);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (p);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_cairo_destroy0 (c);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_cairo_surface_destroy0 (s);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (h);
#line 1922 "gnome-chess.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp28_ = NULL;
		GError* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = filename;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = e;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp30_ = _tmp29_->message;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:348: Failed to load image %s: %s", _tmp28_, _tmp30_);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 1947 "gnome-chess.c"
	}
	__finally4:
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 1958 "gnome-chess.c"
	}
}


void chess_application_quit_game (ChessApplication* self) {
	guint _tmp0_ = 0U;
	GtkApplicationWindow* _tmp1_ = NULL;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->save_duration_timeout;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_save_duration_cb (self);
#line 1974 "gnome-chess.c"
	}
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_autosave (self);
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->window;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 1982 "gnome-chess.c"
}


static void chess_application_autosave (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game_needs_saving;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp0_) {
#line 1995 "gnome-chess.c"
		const gchar* _tmp1_ = NULL;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->autosave_filename;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_remove (_tmp1_);
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 2003 "gnome-chess.c"
	}
	{
		GFile* autosave_file = NULL;
		const gchar* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		PGNGame* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->autosave_filename;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = g_file_new_for_path (_tmp2_);
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		autosave_file = _tmp3_;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = autosave_file;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = g_file_get_path (_tmp4_);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = _tmp5_;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_debug ("gnome-chess.vala:382: Writing current game to %s", _tmp6_);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp6_);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_update_pgn_time_remaining (self);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->pgn_game;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = autosave_file;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_write (_tmp7_, _tmp8_, &_inner_error_);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (autosave_file);
#line 2042 "gnome-chess.c"
			goto __catch5_g_error;
		}
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (autosave_file);
#line 2047 "gnome-chess.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = e;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp9_->message;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:388: Failed to autosave: %s", _tmp10_);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 2067 "gnome-chess.c"
	}
	__finally5:
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 2078 "gnome-chess.c"
	}
}


static void chess_application_update_history_panel (ChessApplication* self) {
	ChessGame* _tmp0_ = NULL;
	gint move_number = 0;
	ChessScene* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint n_moves = 0;
	ChessGame* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	gint _tmp7_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_ = 0;
	GtkWidget* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_ = 0;
	GtkWidget* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	GtkWidget* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gint _tmp33_ = 0;
	GtkWidget* _tmp39_ = NULL;
	GtkComboBox* _tmp40_ = NULL;
	ChessGame* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	gint i = 0;
	gint _tmp44_ = 0;
	ChessGame* _tmp45_ = NULL;
	GList* _tmp46_ = NULL;
	GtkComboBox* _tmp60_ = NULL;
	gint _tmp61_ = 0;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == NULL) {
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 2127 "gnome-chess.c"
	}
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->scene;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_scene_get_move_number (_tmp1_);
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	move_number = _tmp3_;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->game;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = chess_game_get_n_moves (_tmp4_);
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	n_moves = (gint) _tmp6_;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = move_number;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_ < 0) {
#line 2149 "gnome-chess.c"
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = move_number;
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = n_moves;
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		move_number = _tmp8_ + (1 + _tmp9_);
#line 2158 "gnome-chess.c"
	}
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = n_moves;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ > 0) {
#line 2164 "gnome-chess.c"
		gint _tmp13_ = 0;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = move_number;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp13_ != 0;
#line 2170 "gnome-chess.c"
	} else {
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = FALSE;
#line 2174 "gnome-chess.c"
	}
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp11_) {
#line 2178 "gnome-chess.c"
		ChessGame* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->game;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = chess_game_get_is_paused (_tmp14_);
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = !_tmp16_;
#line 2190 "gnome-chess.c"
	} else {
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = FALSE;
#line 2194 "gnome-chess.c"
	}
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = self->priv->first_move_button;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp17_, _tmp10_);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = move_number;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp19_ > 0) {
#line 2204 "gnome-chess.c"
		ChessGame* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = self->priv->game;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = chess_game_get_is_paused (_tmp20_);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = _tmp21_;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = !_tmp22_;
#line 2216 "gnome-chess.c"
	} else {
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = FALSE;
#line 2220 "gnome-chess.c"
	}
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->prev_move_button;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp23_, _tmp18_);
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = move_number;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = n_moves;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp25_ < _tmp26_) {
#line 2232 "gnome-chess.c"
		ChessGame* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = self->priv->game;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = chess_game_get_is_paused (_tmp27_);
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = _tmp28_;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = !_tmp29_;
#line 2244 "gnome-chess.c"
	} else {
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = FALSE;
#line 2248 "gnome-chess.c"
	}
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = self->priv->next_move_button;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp30_, _tmp24_);
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = n_moves;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp33_ > 0) {
#line 2258 "gnome-chess.c"
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp34_ = move_number;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp35_ = n_moves;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp32_ = _tmp34_ != _tmp35_;
#line 2267 "gnome-chess.c"
	} else {
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp32_ = FALSE;
#line 2271 "gnome-chess.c"
	}
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp32_) {
#line 2275 "gnome-chess.c"
		ChessGame* _tmp36_ = NULL;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp36_ = self->priv->game;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = chess_game_get_is_paused (_tmp36_);
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = _tmp37_;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp31_ = !_tmp38_;
#line 2287 "gnome-chess.c"
	} else {
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp31_ = FALSE;
#line 2291 "gnome-chess.c"
	}
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = self->priv->last_move_button;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp39_, _tmp31_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = self->priv->history_combo;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = self->priv->game;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = chess_game_get_is_paused (_tmp41_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = _tmp42_;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp40_, !_tmp43_);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp44_ = n_moves;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	i = _tmp44_;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = self->priv->game;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp46_ = _tmp45_->move_stack;
#line 2315 "gnome-chess.c"
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		state_collection = _tmp46_;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
#line 2323 "gnome-chess.c"
			ChessState* _tmp47_ = NULL;
			ChessState* state = NULL;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = _g_object_ref0 ((ChessState*) state_it->data);
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			state = _tmp47_;
#line 2330 "gnome-chess.c"
			{
				ChessState* _tmp48_ = NULL;
				ChessMove* _tmp49_ = NULL;
				gint _tmp59_ = 0;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp48_ = state;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp49_ = _tmp48_->last_move;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp49_ != NULL) {
#line 2341 "gnome-chess.c"
					GtkTreeIter iter = {0};
					GtkComboBox* _tmp50_ = NULL;
					GtkTreeModel* _tmp51_ = NULL;
					GtkTreeModel* _tmp52_ = NULL;
					gint _tmp53_ = 0;
					GtkTreeIter _tmp54_ = {0};
					gboolean _tmp55_ = FALSE;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp50_ = self->priv->history_combo;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp51_ = gtk_combo_box_get_model (_tmp50_);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp52_ = _tmp51_;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp53_ = i;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp55_ = gtk_tree_model_iter_nth_child (_tmp52_, &_tmp54_, NULL, _tmp53_);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					iter = _tmp54_;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (_tmp55_) {
#line 2363 "gnome-chess.c"
						GtkTreeIter _tmp56_ = {0};
						ChessState* _tmp57_ = NULL;
						ChessMove* _tmp58_ = NULL;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp56_ = iter;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp57_ = state;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp58_ = _tmp57_->last_move;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						chess_application_set_move_text (self, &_tmp56_, _tmp58_);
#line 2375 "gnome-chess.c"
					}
				}
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp59_ = i;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				i = _tmp59_ - 1;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (state);
#line 2384 "gnome-chess.c"
			}
		}
	}
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = self->priv->history_combo;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp61_ = move_number;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active (_tmp60_, _tmp61_);
#line 2394 "gnome-chess.c"
}


static void chess_application_scene_changed_cb (ChessApplication* self, ChessScene* scene) {
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (scene != NULL);
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_history_panel (self);
#line 2405 "gnome-chess.c"
}


static void _chess_application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self) {
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_game_turn_cb ((ChessApplication*) self, _sender, player);
#line 2412 "gnome-chess.c"
}


static void _chess_application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self) {
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_game_move_cb ((ChessApplication*) self, _sender, move);
#line 2419 "gnome-chess.c"
}


static void _chess_application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self) {
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_game_undo_cb ((ChessApplication*) self, _sender);
#line 2426 "gnome-chess.c"
}


static void _chess_application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self) {
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_game_end_cb ((ChessApplication*) self, _sender);
#line 2433 "gnome-chess.c"
}


static void _chess_application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self) {
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_game_clock_tick_cb ((ChessApplication*) self, _sender);
#line 2440 "gnome-chess.c"
}


static void _chess_application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self) {
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_ready_cb ((ChessApplication*) self, _sender);
#line 2447 "gnome-chess.c"
}


static void _chess_application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self) {
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_move_cb ((ChessApplication*) self, _sender, move);
#line 2454 "gnome-chess.c"
}


static void _chess_application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender, gpointer self) {
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_resigned_cb ((ChessApplication*) self, _sender);
#line 2461 "gnome-chess.c"
}


static void _chess_application_engine_stopped_cb_chess_engine_stopped (ChessEngine* _sender, gpointer self) {
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_stopped_cb ((ChessApplication*) self, _sender);
#line 2468 "gnome-chess.c"
}


static void _chess_application_engine_error_cb_chess_engine_error (ChessEngine* _sender, gpointer self) {
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_error_cb ((ChessApplication*) self, _sender);
#line 2475 "gnome-chess.c"
}


static void _chess_application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender, gpointer self) {
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_claim_draw_cb ((ChessApplication*) self, _sender);
#line 2482 "gnome-chess.c"
}


static void _chess_application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender, gpointer self) {
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_offer_draw_cb ((ChessApplication*) self, _sender);
#line 2489 "gnome-chess.c"
}


static void chess_application_start_game (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_ = NULL;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp11_ = NULL;
	GtkTreeModel* _tmp12_ = NULL;
	GtkTreeModel* _tmp13_ = NULL;
	GtkListStore* _tmp14_ = NULL;
	GtkListStore* _tmp15_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp16_ = NULL;
	GtkTreeIter _tmp17_ = {0};
	GtkListStore* _tmp18_ = NULL;
	GtkTreeIter _tmp19_ = {0};
	const gchar* _tmp20_ = NULL;
	GtkComboBox* _tmp21_ = NULL;
	GtkTreeIter _tmp22_ = {0};
	gchar* fen = NULL;
	gchar* _tmp23_ = NULL;
	gchar** moves = NULL;
	PGNGame* _tmp24_ = NULL;
	GList* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	gchar** _tmp27_ = NULL;
	gint moves_length1 = 0;
	gint _moves_size_ = 0;
	gint i = 0;
	PGNGame* _tmp28_ = NULL;
	GList* _tmp29_ = NULL;
	PGNGame* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	const gchar* _tmp46_ = NULL;
	gchar** _tmp47_ = NULL;
	gint _tmp47__length1 = 0;
	ChessGame* _tmp48_ = NULL;
	gboolean _tmp49_ = FALSE;
	PGNGame* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	ChessGame* _tmp80_ = NULL;
	ChessGame* _tmp81_ = NULL;
	ChessGame* _tmp82_ = NULL;
	ChessGame* _tmp83_ = NULL;
	ChessGame* _tmp84_ = NULL;
	ChessClock* _tmp85_ = NULL;
	ChessClock* _tmp86_ = NULL;
	ChessScene* _tmp90_ = NULL;
	ChessGame* _tmp91_ = NULL;
	gchar* white_engine = NULL;
	PGNGame* _tmp92_ = NULL;
	const gchar* _tmp93_ = NULL;
	const gchar* _tmp94_ = NULL;
	gchar* _tmp95_ = NULL;
	gchar* white_level = NULL;
	PGNGame* _tmp96_ = NULL;
	const gchar* _tmp97_ = NULL;
	const gchar* _tmp98_ = NULL;
	gchar* _tmp99_ = NULL;
	const gchar* _tmp100_ = NULL;
	gchar* black_engine = NULL;
	PGNGame* _tmp102_ = NULL;
	const gchar* _tmp103_ = NULL;
	const gchar* _tmp104_ = NULL;
	gchar* _tmp105_ = NULL;
	gchar* black_level = NULL;
	PGNGame* _tmp106_ = NULL;
	const gchar* _tmp107_ = NULL;
	const gchar* _tmp108_ = NULL;
	gchar* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	ChessEngine* _tmp112_ = NULL;
	const gchar* _tmp128_ = NULL;
	ChessEngine* _tmp156_ = NULL;
	gboolean _tmp189_ = FALSE;
	GFile* _tmp190_ = NULL;
	ChessGame* _tmp195_ = NULL;
	ChessEngine* _tmp196_ = NULL;
	gboolean _tmp198_ = FALSE;
	gchar** _tmp199_ = NULL;
	gint _tmp199__length1 = 0;
	ChessGame* _tmp206_ = NULL;
	ChessResult _tmp207_ = 0;
	GtkWidget* _tmp209_ = NULL;
	GtkWidget* _tmp210_ = NULL;
	gboolean _tmp211_ = FALSE;
	gboolean _tmp212_ = FALSE;
	const gchar* _tmp213_ = NULL;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->starting = TRUE;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game_file;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ != NULL) {
#line 2589 "gnome-chess.c"
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game_file;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = g_file_get_path (_tmp2_);
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->autosave_filename;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) != 0;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp4_);
#line 2606 "gnome-chess.c"
	} else {
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 2610 "gnome-chess.c"
	}
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 2614 "gnome-chess.c"
		GtkHeaderBar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->headerbar;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->game_file;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = g_file_get_basename (_tmp7_);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _tmp8_;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_header_bar_set_subtitle (_tmp6_, _tmp9_);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp9_);
#line 2631 "gnome-chess.c"
	} else {
		GtkHeaderBar* _tmp10_ = NULL;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->headerbar;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_header_bar_set_subtitle (_tmp10_, NULL);
#line 2638 "gnome-chess.c"
	}
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->history_combo;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = gtk_combo_box_get_model (_tmp11_);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = _tmp12_;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_list_store_get_type (), GtkListStore));
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp14_;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = model;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_clear (_tmp15_);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = model;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_append (_tmp16_, &_tmp17_);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp17_;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = model;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = iter;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = _ ("Game Start");
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_set (_tmp18_, &_tmp19_, 0, _tmp20_, 1, 0, -1, -1);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = self->priv->history_combo;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = iter;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = g_strdup (CHESS_GAME_STANDARD_SETUP);
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	fen = _tmp23_;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = self->priv->pgn_game;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = _tmp24_->moves;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = g_list_length (_tmp25_);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = g_new0 (gchar*, _tmp26_ + 1);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	moves = _tmp27_;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	moves_length1 = _tmp26_;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_moves_size_ = moves_length1;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	i = 0;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = self->priv->pgn_game;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = _tmp28_->moves;
#line 2698 "gnome-chess.c"
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		move_collection = _tmp29_;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
#line 2706 "gnome-chess.c"
			gchar* _tmp30_ = NULL;
			gchar* move = NULL;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp30_ = g_strdup ((const gchar*) move_it->data);
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			move = _tmp30_;
#line 2713 "gnome-chess.c"
			{
				gchar** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp31_ = moves;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp31__length1 = moves_length1;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp32_ = i;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				i = _tmp32_ + 1;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp33_ = move;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp34_ = g_strdup (_tmp33_);
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (_tmp31_[_tmp32_]);
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp31_[_tmp32_] = _tmp34_;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp35_ = _tmp31_[_tmp32_];
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move);
#line 2741 "gnome-chess.c"
			}
		}
	}
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = self->priv->pgn_game;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = pgn_game_get_set_up (_tmp36_);
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = _tmp37_;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp38_) {
#line 2753 "gnome-chess.c"
		PGNGame* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp39_ = self->priv->pgn_game;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp40_ = pgn_game_get_fen (_tmp39_);
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp41_ = _tmp40_;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp41_ != NULL) {
#line 2765 "gnome-chess.c"
			PGNGame* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp42_ = self->priv->pgn_game;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp43_ = pgn_game_get_fen (_tmp42_);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp44_ = _tmp43_;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp45_ = g_strdup (_tmp44_);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (fen);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			fen = _tmp45_;
#line 2782 "gnome-chess.c"
		} else {
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:458: Chess game has SetUp tag but no FEN tag");
#line 2786 "gnome-chess.c"
		}
	}
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp46_ = fen;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp47_ = moves;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp47__length1 = moves_length1;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp48_ = chess_game_new (_tmp46_, _tmp47_, _tmp47__length1);
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game);
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->game = _tmp48_;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp50_ = self->priv->pgn_game;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp51_ = pgn_game_get_time_control (_tmp50_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp52_ = _tmp51_;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp52_ != NULL) {
#line 2809 "gnome-chess.c"
		PGNGame* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		gint _tmp56_ = 0;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp53_ = self->priv->pgn_game;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp54_ = pgn_game_get_time_control (_tmp53_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp55_ = _tmp54_;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp56_ = atoi (_tmp55_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp49_ = _tmp56_ != 0;
#line 2824 "gnome-chess.c"
	} else {
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp49_ = FALSE;
#line 2828 "gnome-chess.c"
	}
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp49_) {
#line 2832 "gnome-chess.c"
		gboolean _tmp57_ = FALSE;
		PGNGame* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp58_ = self->priv->pgn_game;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp59_ = pgn_game_get_white_time_left (_tmp58_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp60_ = _tmp59_;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp60_ != NULL) {
#line 2845 "gnome-chess.c"
			PGNGame* _tmp61_ = NULL;
			const gchar* _tmp62_ = NULL;
			const gchar* _tmp63_ = NULL;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp61_ = self->priv->pgn_game;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp62_ = pgn_game_get_black_time_left (_tmp61_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp63_ = _tmp62_;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp57_ = _tmp63_ != NULL;
#line 2857 "gnome-chess.c"
		} else {
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp57_ = FALSE;
#line 2861 "gnome-chess.c"
		}
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp57_) {
#line 2865 "gnome-chess.c"
			gint white_seconds = 0;
			PGNGame* _tmp64_ = NULL;
			const gchar* _tmp65_ = NULL;
			const gchar* _tmp66_ = NULL;
			gint _tmp67_ = 0;
			gint black_seconds = 0;
			PGNGame* _tmp68_ = NULL;
			const gchar* _tmp69_ = NULL;
			const gchar* _tmp70_ = NULL;
			gint _tmp71_ = 0;
			gboolean _tmp72_ = FALSE;
			gint _tmp73_ = 0;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp64_ = self->priv->pgn_game;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp65_ = pgn_game_get_white_time_left (_tmp64_);
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp66_ = _tmp65_;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp67_ = atoi (_tmp66_);
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			white_seconds = _tmp67_;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp68_ = self->priv->pgn_game;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp69_ = pgn_game_get_black_time_left (_tmp68_);
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp70_ = _tmp69_;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp71_ = atoi (_tmp70_);
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			black_seconds = _tmp71_;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp73_ = white_seconds;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp73_ > 0) {
#line 2902 "gnome-chess.c"
				gint _tmp74_ = 0;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp74_ = black_seconds;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp72_ = _tmp74_ > 0;
#line 2908 "gnome-chess.c"
			} else {
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp72_ = FALSE;
#line 2912 "gnome-chess.c"
			}
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp72_) {
#line 2916 "gnome-chess.c"
				ChessGame* _tmp75_ = NULL;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				ChessClock* _tmp78_ = NULL;
				ChessClock* _tmp79_ = NULL;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp75_ = self->priv->game;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp76_ = white_seconds;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp77_ = black_seconds;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp78_ = chess_clock_new (_tmp76_, _tmp77_);
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp79_ = _tmp78_;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				chess_game_set_clock (_tmp75_, _tmp79_);
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (_tmp79_);
#line 2936 "gnome-chess.c"
			}
		}
	}
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp80_ = self->priv->game;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp80_, "turn-started", (GCallback) _chess_application_game_turn_cb_chess_game_turn_started, self, 0);
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp81_ = self->priv->game;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp81_, "moved", (GCallback) _chess_application_game_move_cb_chess_game_moved, self, 0);
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp82_ = self->priv->game;
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp82_, "undo", (GCallback) _chess_application_game_undo_cb_chess_game_undo, self, 0);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp83_ = self->priv->game;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp83_, "ended", (GCallback) _chess_application_game_end_cb_chess_game_ended, self, 0);
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = self->priv->game;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp85_ = chess_game_get_clock (_tmp84_);
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = _tmp85_;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp86_ != NULL) {
#line 2964 "gnome-chess.c"
		ChessGame* _tmp87_ = NULL;
		ChessClock* _tmp88_ = NULL;
		ChessClock* _tmp89_ = NULL;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp87_ = self->priv->game;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp88_ = chess_game_get_clock (_tmp87_);
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp89_ = _tmp88_;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp89_, "tick", (GCallback) _chess_application_game_clock_tick_cb_chess_clock_tick, self, 0);
#line 2976 "gnome-chess.c"
	}
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = self->priv->scene;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp91_ = self->priv->game;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_game (_tmp90_, _tmp91_);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp92_ = self->priv->pgn_game;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp93_ = pgn_game_get_white_ai (_tmp92_);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp94_ = _tmp93_;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp95_ = g_strdup (_tmp94_);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	white_engine = _tmp95_;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp96_ = self->priv->pgn_game;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp97_ = pgn_game_get_white_level (_tmp96_);
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp98_ = _tmp97_;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp99_ = g_strdup (_tmp98_);
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	white_level = _tmp99_;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp100_ = white_level;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp100_ == NULL) {
#line 3008 "gnome-chess.c"
		gchar* _tmp101_ = NULL;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp101_ = g_strdup ("normal");
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (white_level);
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		white_level = _tmp101_;
#line 3016 "gnome-chess.c"
	}
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp102_ = self->priv->pgn_game;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp103_ = pgn_game_get_black_ai (_tmp102_);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp104_ = _tmp103_;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp105_ = g_strdup (_tmp104_);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	black_engine = _tmp105_;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp106_ = self->priv->pgn_game;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp107_ = pgn_game_get_black_level (_tmp106_);
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp108_ = _tmp107_;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp109_ = g_strdup (_tmp108_);
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	black_level = _tmp109_;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp110_ = black_level;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp110_ == NULL) {
#line 3042 "gnome-chess.c"
		gchar* _tmp111_ = NULL;
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp111_ = g_strdup ("normal");
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (black_level);
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		black_level = _tmp111_;
#line 3050 "gnome-chess.c"
	}
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->human_player);
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->human_player = NULL;
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->opponent);
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->opponent = NULL;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp112_ = self->priv->opponent_engine;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp112_ != NULL) {
#line 3064 "gnome-chess.c"
		ChessEngine* _tmp113_ = NULL;
		ChessEngine* _tmp114_ = NULL;
		guint _tmp115_ = 0U;
		ChessEngine* _tmp116_ = NULL;
		guint _tmp117_ = 0U;
		ChessEngine* _tmp118_ = NULL;
		guint _tmp119_ = 0U;
		ChessEngine* _tmp120_ = NULL;
		guint _tmp121_ = 0U;
		ChessEngine* _tmp122_ = NULL;
		guint _tmp123_ = 0U;
		ChessEngine* _tmp124_ = NULL;
		guint _tmp125_ = 0U;
		ChessEngine* _tmp126_ = NULL;
		guint _tmp127_ = 0U;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp113_ = self->priv->opponent_engine;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_engine_stop (_tmp113_);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp114_ = self->priv->opponent_engine;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("ready-changed", TYPE_CHESS_ENGINE, &_tmp115_, NULL, FALSE);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp114_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp115_, 0, NULL, (GCallback) _chess_application_engine_ready_cb_chess_engine_ready_changed, self);
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp116_ = self->priv->opponent_engine;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("moved", TYPE_CHESS_ENGINE, &_tmp117_, NULL, FALSE);
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp116_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp117_, 0, NULL, (GCallback) _chess_application_engine_move_cb_chess_engine_moved, self);
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp118_ = self->priv->opponent_engine;
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("resigned", TYPE_CHESS_ENGINE, &_tmp119_, NULL, FALSE);
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp118_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp119_, 0, NULL, (GCallback) _chess_application_engine_resigned_cb_chess_engine_resigned, self);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp120_ = self->priv->opponent_engine;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("stopped", TYPE_CHESS_ENGINE, &_tmp121_, NULL, FALSE);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp120_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp121_, 0, NULL, (GCallback) _chess_application_engine_stopped_cb_chess_engine_stopped, self);
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp122_ = self->priv->opponent_engine;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("error", TYPE_CHESS_ENGINE, &_tmp123_, NULL, FALSE);
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp122_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp123_, 0, NULL, (GCallback) _chess_application_engine_error_cb_chess_engine_error, self);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp124_ = self->priv->opponent_engine;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("claim-draw", TYPE_CHESS_ENGINE, &_tmp125_, NULL, FALSE);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp124_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp125_, 0, NULL, (GCallback) _chess_application_engine_claim_draw_cb_chess_engine_claim_draw, self);
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp126_ = self->priv->opponent_engine;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("offer-draw", TYPE_CHESS_ENGINE, &_tmp127_, NULL, FALSE);
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp126_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp127_, 0, NULL, (GCallback) _chess_application_engine_offer_draw_cb_chess_engine_offer_draw, self);
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->opponent_engine);
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->opponent_engine = NULL;
#line 3130 "gnome-chess.c"
	}
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp128_ = white_engine;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp128_ != NULL) {
#line 3136 "gnome-chess.c"
		ChessGame* _tmp129_ = NULL;
		ChessPlayer* _tmp130_ = NULL;
		ChessPlayer* _tmp131_ = NULL;
		ChessPlayer* _tmp132_ = NULL;
		ChessGame* _tmp133_ = NULL;
		ChessPlayer* _tmp134_ = NULL;
		ChessPlayer* _tmp135_ = NULL;
		ChessPlayer* _tmp136_ = NULL;
		const gchar* _tmp137_ = NULL;
		const gchar* _tmp138_ = NULL;
		ChessEngine* _tmp139_ = NULL;
		ChessPlayer* _tmp140_ = NULL;
		ChessPlayer* _tmp141_ = NULL;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp129_ = self->priv->game;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp130_ = chess_game_get_white (_tmp129_);
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp131_ = _tmp130_;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp132_ = _g_object_ref0 (_tmp131_);
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->opponent);
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->opponent = _tmp132_;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp133_ = self->priv->game;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp134_ = chess_game_get_black (_tmp133_);
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp135_ = _tmp134_;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp136_ = _g_object_ref0 (_tmp135_);
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->human_player);
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->human_player = _tmp136_;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp137_ = white_engine;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp138_ = white_level;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp139_ = chess_application_get_engine (self, _tmp137_, _tmp138_);
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->opponent_engine);
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->opponent_engine = _tmp139_;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp140_ = self->priv->opponent;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp140_, FALSE);
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp141_ = self->priv->human_player;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp141_, TRUE);
#line 3192 "gnome-chess.c"
	} else {
		const gchar* _tmp142_ = NULL;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp142_ = black_engine;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp142_ != NULL) {
#line 3199 "gnome-chess.c"
			ChessGame* _tmp143_ = NULL;
			ChessPlayer* _tmp144_ = NULL;
			ChessPlayer* _tmp145_ = NULL;
			ChessPlayer* _tmp146_ = NULL;
			ChessGame* _tmp147_ = NULL;
			ChessPlayer* _tmp148_ = NULL;
			ChessPlayer* _tmp149_ = NULL;
			ChessPlayer* _tmp150_ = NULL;
			const gchar* _tmp151_ = NULL;
			const gchar* _tmp152_ = NULL;
			ChessEngine* _tmp153_ = NULL;
			ChessPlayer* _tmp154_ = NULL;
			ChessPlayer* _tmp155_ = NULL;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp143_ = self->priv->game;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp144_ = chess_game_get_black (_tmp143_);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp145_ = _tmp144_;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp146_ = _g_object_ref0 (_tmp145_);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->opponent);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->opponent = _tmp146_;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp147_ = self->priv->game;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp148_ = chess_game_get_white (_tmp147_);
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp149_ = _tmp148_;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp150_ = _g_object_ref0 (_tmp149_);
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->human_player);
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->human_player = _tmp150_;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp151_ = black_engine;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp152_ = black_level;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp153_ = chess_application_get_engine (self, _tmp151_, _tmp152_);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->opponent_engine);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->opponent_engine = _tmp153_;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp154_ = self->priv->opponent;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_player_set_local_human (_tmp154_, FALSE);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp155_ = self->priv->human_player;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_player_set_local_human (_tmp155_, TRUE);
#line 3255 "gnome-chess.c"
		}
	}
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp156_ = self->priv->opponent_engine;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp156_ == NULL) {
#line 3262 "gnome-chess.c"
		ChessGame* _tmp157_ = NULL;
		ChessPlayer* _tmp158_ = NULL;
		ChessPlayer* _tmp159_ = NULL;
		ChessGame* _tmp160_ = NULL;
		ChessPlayer* _tmp161_ = NULL;
		ChessPlayer* _tmp162_ = NULL;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp157_ = self->priv->game;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp158_ = chess_game_get_black (_tmp157_);
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp159_ = _tmp158_;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp159_, TRUE);
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp160_ = self->priv->game;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp161_ = chess_game_get_white (_tmp160_);
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp162_ = _tmp161_;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp162_, TRUE);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->human_player);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->human_player = NULL;
#line 3289 "gnome-chess.c"
	} else {
		ChessEngine* _tmp163_ = NULL;
		ChessEngine* _tmp164_ = NULL;
		ChessEngine* _tmp165_ = NULL;
		ChessEngine* _tmp166_ = NULL;
		ChessEngine* _tmp167_ = NULL;
		ChessEngine* _tmp168_ = NULL;
		ChessEngine* _tmp169_ = NULL;
		ChessEngine* _tmp170_ = NULL;
		gboolean _tmp171_ = FALSE;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp163_ = self->priv->opponent_engine;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp163_, "ready-changed", (GCallback) _chess_application_engine_ready_cb_chess_engine_ready_changed, self, 0);
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp164_ = self->priv->opponent_engine;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp164_, "moved", (GCallback) _chess_application_engine_move_cb_chess_engine_moved, self, 0);
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp165_ = self->priv->opponent_engine;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp165_, "resigned", (GCallback) _chess_application_engine_resigned_cb_chess_engine_resigned, self, 0);
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp166_ = self->priv->opponent_engine;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp166_, "stopped", (GCallback) _chess_application_engine_stopped_cb_chess_engine_stopped, self, 0);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp167_ = self->priv->opponent_engine;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp167_, "error", (GCallback) _chess_application_engine_error_cb_chess_engine_error, self, 0);
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp168_ = self->priv->opponent_engine;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp168_, "claim-draw", (GCallback) _chess_application_engine_claim_draw_cb_chess_engine_claim_draw, self, 0);
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp169_ = self->priv->opponent_engine;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp169_, "offer-draw", (GCallback) _chess_application_engine_offer_draw_cb_chess_engine_offer_draw, self, 0);
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp170_ = self->priv->opponent_engine;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp171_ = chess_engine_start (_tmp170_);
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (!_tmp171_) {
#line 3334 "gnome-chess.c"
			ChessGame* _tmp172_ = NULL;
			ChessGame* _tmp173_ = NULL;
			ChessGame* _tmp174_ = NULL;
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp172_ = self->priv->game;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp172_->result = CHESS_RESULT_BUG;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp173_ = self->priv->game;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp173_->rule = CHESS_RULE_BUG;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp174_ = self->priv->game;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_game_end_cb (self, _tmp174_);
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (black_level);
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (black_engine);
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (white_level);
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (white_engine);
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (fen);
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (model);
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return;
#line 3368 "gnome-chess.c"
		}
	}
	{
		gint j = 0;
		ChessGame* _tmp175_ = NULL;
		GList* _tmp176_ = NULL;
		guint _tmp177_ = 0U;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp175_ = self->priv->game;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp176_ = _tmp175_->move_stack;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp177_ = g_list_length (_tmp176_);
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		j = ((gint) _tmp177_) - 2;
#line 3384 "gnome-chess.c"
		{
			gboolean _tmp178_ = FALSE;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp178_ = TRUE;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 3391 "gnome-chess.c"
				gint _tmp180_ = 0;
				ChessState* state = NULL;
				ChessGame* _tmp181_ = NULL;
				GList* _tmp182_ = NULL;
				gint _tmp183_ = 0;
				gconstpointer _tmp184_ = NULL;
				ChessState* _tmp185_ = NULL;
				ChessGame* _tmp186_ = NULL;
				ChessState* _tmp187_ = NULL;
				ChessMove* _tmp188_ = NULL;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (!_tmp178_) {
#line 3404 "gnome-chess.c"
					gint _tmp179_ = 0;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp179_ = j;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					j = _tmp179_ - 1;
#line 3410 "gnome-chess.c"
				}
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp178_ = FALSE;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp180_ = j;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (!(_tmp180_ >= 0)) {
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					break;
#line 3420 "gnome-chess.c"
				}
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp181_ = self->priv->game;
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp182_ = _tmp181_->move_stack;
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp183_ = j;
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp184_ = g_list_nth_data (_tmp182_, (guint) _tmp183_);
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp185_ = _g_object_ref0 ((ChessState*) _tmp184_);
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				state = _tmp185_;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp186_ = self->priv->game;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp187_ = state;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp188_ = _tmp187_->last_move;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				chess_application_game_move_cb (self, _tmp186_, _tmp188_);
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (state);
#line 3444 "gnome-chess.c"
			}
		}
	}
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp190_ = self->priv->game_file;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp190_ != NULL) {
#line 3452 "gnome-chess.c"
		GFile* _tmp191_ = NULL;
		gchar* _tmp192_ = NULL;
		gchar* _tmp193_ = NULL;
		const gchar* _tmp194_ = NULL;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp191_ = self->priv->game_file;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp192_ = g_file_get_path (_tmp191_);
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp193_ = _tmp192_;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp194_ = self->priv->autosave_filename;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp189_ = g_strcmp0 (_tmp193_, _tmp194_) == 0;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp193_);
#line 3469 "gnome-chess.c"
	} else {
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp189_ = FALSE;
#line 3473 "gnome-chess.c"
	}
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp189_) {
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = TRUE;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 3481 "gnome-chess.c"
	} else {
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = FALSE;
#line 571 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 3487 "gnome-chess.c"
	}
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp195_ = self->priv->game;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_game_start (_tmp195_);
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp196_ = self->priv->opponent_engine;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp196_ != NULL) {
#line 3497 "gnome-chess.c"
		ChessEngine* _tmp197_ = NULL;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp197_ = self->priv->opponent_engine;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_engine_start_game (_tmp197_);
#line 3503 "gnome-chess.c"
	}
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp199_ = moves;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp199__length1 = moves_length1;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp199__length1 > 0) {
#line 3511 "gnome-chess.c"
		ChessGame* _tmp200_ = NULL;
		ChessClock* _tmp201_ = NULL;
		ChessClock* _tmp202_ = NULL;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp200_ = self->priv->game;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp201_ = chess_game_get_clock (_tmp200_);
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp202_ = _tmp201_;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp198_ = _tmp202_ != NULL;
#line 3523 "gnome-chess.c"
	} else {
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp198_ = FALSE;
#line 3527 "gnome-chess.c"
	}
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp198_) {
#line 3531 "gnome-chess.c"
		ChessGame* _tmp203_ = NULL;
		ChessClock* _tmp204_ = NULL;
		ChessClock* _tmp205_ = NULL;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp203_ = self->priv->game;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp204_ = chess_game_get_clock (_tmp203_);
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp205_ = _tmp204_;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_clock_start (_tmp205_);
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
#line 3545 "gnome-chess.c"
	} else {
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
#line 3549 "gnome-chess.c"
	}
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp206_ = self->priv->game;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp207_ = _tmp206_->result;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp207_ != CHESS_RESULT_IN_PROGRESS) {
#line 3557 "gnome-chess.c"
		ChessGame* _tmp208_ = NULL;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp208_ = self->priv->game;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_game_end_cb (self, _tmp208_);
#line 3563 "gnome-chess.c"
	}
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_history_panel (self);
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_action_status (self);
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_pause_resume_button (self);
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_headerbar_title (self);
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp209_ = self->priv->white_time_label;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp209_);
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp210_ = self->priv->black_time_label;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp210_);
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->starting = FALSE;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp213_ = white_engine;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp213_ != NULL) {
#line 3587 "gnome-chess.c"
		ChessGame* _tmp214_ = NULL;
		ChessPlayer* _tmp215_ = NULL;
		ChessPlayer* _tmp216_ = NULL;
		Color _tmp217_ = 0;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp214_ = self->priv->game;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp215_ = chess_game_get_current_player (_tmp214_);
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp216_ = _tmp215_;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp217_ = _tmp216_->color;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp212_ = _tmp217_ == COLOR_WHITE;
#line 3602 "gnome-chess.c"
	} else {
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp212_ = FALSE;
#line 3606 "gnome-chess.c"
	}
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp212_) {
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp211_ = TRUE;
#line 3612 "gnome-chess.c"
	} else {
		gboolean _tmp218_ = FALSE;
		const gchar* _tmp219_ = NULL;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp219_ = black_engine;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp219_ != NULL) {
#line 3620 "gnome-chess.c"
			ChessGame* _tmp220_ = NULL;
			ChessPlayer* _tmp221_ = NULL;
			ChessPlayer* _tmp222_ = NULL;
			Color _tmp223_ = 0;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp220_ = self->priv->game;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp221_ = chess_game_get_current_player (_tmp220_);
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp222_ = _tmp221_;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp223_ = _tmp222_->color;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp218_ = _tmp223_ == COLOR_BLACK;
#line 3635 "gnome-chess.c"
		} else {
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp218_ = FALSE;
#line 3639 "gnome-chess.c"
		}
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp211_ = _tmp218_;
#line 3643 "gnome-chess.c"
	}
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp211_) {
#line 3647 "gnome-chess.c"
		ChessEngine* _tmp224_ = NULL;
		ChessEngine* _tmp225_ = NULL;
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp224_ = self->priv->opponent_engine;
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_vala_assert (_tmp224_ != NULL, "opponent_engine != null");
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp225_ = self->priv->opponent_engine;
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_engine_move (_tmp225_);
#line 3658 "gnome-chess.c"
	}
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (black_level);
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (black_engine);
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (white_level);
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (white_engine);
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (fen);
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 3674 "gnome-chess.c"
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 3685 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 3691 "gnome-chess.c"
	}
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 3695 "gnome-chess.c"
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 3706 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 3712 "gnome-chess.c"
	}
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 3716 "gnome-chess.c"
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 3727 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 3733 "gnome-chess.c"
	}
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 3737 "gnome-chess.c"
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 3748 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 3754 "gnome-chess.c"
	}
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 3758 "gnome-chess.c"
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 3769 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 3775 "gnome-chess.c"
	}
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 3779 "gnome-chess.c"
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 3790 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 3796 "gnome-chess.c"
	}
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 3800 "gnome-chess.c"
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 3811 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 3817 "gnome-chess.c"
	}
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 3821 "gnome-chess.c"
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 3832 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 3838 "gnome-chess.c"
	}
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 3842 "gnome-chess.c"
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 3853 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 3859 "gnome-chess.c"
	}
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 3863 "gnome-chess.c"
}


static ChessEngine* chess_application_get_engine (ChessApplication* self, const gchar* name, const gchar* difficulty) {
	ChessEngine* result = NULL;
	ChessEngine* engine = NULL;
	AIProfile* profile = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	AIProfile* _tmp12_ = NULL;
	gchar** options = NULL;
	gint options_length1 = 0;
	gint _options_size_ = 0;
	gchar** uci_go_options = NULL;
	gint uci_go_options_length1 = 0;
	gint _uci_go_options_size_ = 0;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GQuark _tmp21_ = 0U;
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp20_label0 = 0;
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp20_label1 = 0;
#line 3891 "gnome-chess.c"
	AIProfile* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
#line 609 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 609 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 609 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (difficulty != NULL, NULL);
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	profile = NULL;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = name;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp0_, "human") == 0) {
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = NULL;
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (profile);
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (engine);
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 3915 "gnome-chess.c"
	}
#line 618 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = name;
#line 618 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp1_, "GNUchess") == 0) {
#line 619 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		name = "GNU Chess";
#line 3923 "gnome-chess.c"
	}
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->ai_profiles;
#line 3927 "gnome-chess.c"
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		p_collection = _tmp2_;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
#line 3935 "gnome-chess.c"
			AIProfile* _tmp3_ = NULL;
			AIProfile* p = NULL;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp3_ = _g_object_ref0 ((AIProfile*) p_it->data);
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			p = _tmp3_;
#line 3942 "gnome-chess.c"
			{
				gboolean _tmp4_ = FALSE;
				const gchar* _tmp5_ = NULL;
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp5_ = name;
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (g_strcmp0 (_tmp5_, "") == 0) {
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp4_ = TRUE;
#line 3952 "gnome-chess.c"
				} else {
					AIProfile* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp6_ = p;
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp7_ = ai_profile_get_name (_tmp6_);
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp8_ = _tmp7_;
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = name;
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp4_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
#line 3968 "gnome-chess.c"
				}
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp4_) {
#line 3972 "gnome-chess.c"
					AIProfile* _tmp10_ = NULL;
					AIProfile* _tmp11_ = NULL;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp10_ = p;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp11_ = _g_object_ref0 (_tmp10_);
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_object_unref0 (profile);
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					profile = _tmp11_;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_object_unref0 (p);
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					break;
#line 3987 "gnome-chess.c"
				}
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (p);
#line 3991 "gnome-chess.c"
			}
		}
	}
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = profile;
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ == NULL) {
#line 3999 "gnome-chess.c"
		const gchar* _tmp13_ = NULL;
		GList* _tmp14_ = NULL;
		GList* _tmp15_ = NULL;
		gconstpointer _tmp16_ = NULL;
		AIProfile* _tmp17_ = NULL;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = name;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:631: Unknown AI profile %s", _tmp13_);
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->ai_profiles;
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp14_ == NULL) {
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			result = NULL;
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (profile);
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (engine);
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return result;
#line 4021 "gnome-chess.c"
		}
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = self->priv->ai_profiles;
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_->data;
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _g_object_ref0 ((AIProfile*) _tmp16_);
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (profile);
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		profile = _tmp17_;
#line 4033 "gnome-chess.c"
	}
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = difficulty;
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = _tmp18_;
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = (NULL == _tmp19_) ? 0 : g_quark_from_string (_tmp19_);
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp21_ == ((0 != _tmp20_label0) ? _tmp20_label0 : (_tmp20_label0 = g_quark_from_static_string ("easy")))) {
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 4045 "gnome-chess.c"
			default:
			{
				AIProfile* _tmp22_ = NULL;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gchar** _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				gchar** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				AIProfile* _tmp26_ = NULL;
				gchar** _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				gchar** _tmp28_ = NULL;
				gint _tmp28__length1 = 0;
				gchar** _tmp29_ = NULL;
				gint _tmp29__length1 = 0;
				AIProfile* _tmp30_ = NULL;
				gchar** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gchar** _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gchar** _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp22_ = profile;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp23_ = ai_profile_get_easy_options (_tmp22_, &_tmp23__length1);
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp24_ = _tmp23_;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp24__length1 = _tmp23__length1;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp25_ = (_tmp24_ != NULL) ? _vala_array_dup1 (_tmp24_, _tmp24__length1) : ((gpointer) _tmp24_);
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp25__length1 = _tmp24__length1;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options = _tmp25_;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options_length1 = _tmp25__length1;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_options_size_ = options_length1;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp26_ = profile;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp27_ = ai_profile_get_easy_uci_go_options (_tmp26_, &_tmp27__length1);
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp28_ = _tmp27_;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp28__length1 = _tmp27__length1;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp29_ = (_tmp28_ != NULL) ? _vala_array_dup2 (_tmp28_, _tmp28__length1) : ((gpointer) _tmp28_);
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp29__length1 = _tmp28__length1;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options = _tmp29_;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options_length1 = _tmp29__length1;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_uci_go_options_size_ = uci_go_options_length1;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp30_ = profile;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp31_ = ai_profile_get_easy_args (_tmp30_, &_tmp31__length1);
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp32_ = _tmp31_;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp32__length1 = _tmp31__length1;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp33_ = (_tmp32_ != NULL) ? _vala_array_dup3 (_tmp32_, _tmp32__length1) : ((gpointer) _tmp32_);
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp33__length1 = _tmp32__length1;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args = _tmp33_;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args_length1 = _tmp33__length1;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_args_size_ = args_length1;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				break;
#line 4131 "gnome-chess.c"
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label1) ? _tmp20_label1 : (_tmp20_label1 = g_quark_from_static_string ("hard")))) {
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 4137 "gnome-chess.c"
			default:
			{
				AIProfile* _tmp34_ = NULL;
				gchar** _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				gchar** _tmp36_ = NULL;
				gint _tmp36__length1 = 0;
				gchar** _tmp37_ = NULL;
				gint _tmp37__length1 = 0;
				AIProfile* _tmp38_ = NULL;
				gchar** _tmp39_ = NULL;
				gint _tmp39__length1 = 0;
				gchar** _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				gchar** _tmp41_ = NULL;
				gint _tmp41__length1 = 0;
				AIProfile* _tmp42_ = NULL;
				gchar** _tmp43_ = NULL;
				gint _tmp43__length1 = 0;
				gchar** _tmp44_ = NULL;
				gint _tmp44__length1 = 0;
				gchar** _tmp45_ = NULL;
				gint _tmp45__length1 = 0;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp34_ = profile;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp35_ = ai_profile_get_hard_options (_tmp34_, &_tmp35__length1);
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = _tmp35_;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp36__length1 = _tmp35__length1;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp37_ = (_tmp36_ != NULL) ? _vala_array_dup4 (_tmp36_, _tmp36__length1) : ((gpointer) _tmp36_);
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp37__length1 = _tmp36__length1;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options = _tmp37_;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options_length1 = _tmp37__length1;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_options_size_ = options_length1;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp38_ = profile;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = ai_profile_get_hard_uci_go_options (_tmp38_, &_tmp39__length1);
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = _tmp39_;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp40__length1 = _tmp39__length1;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp41_ = (_tmp40_ != NULL) ? _vala_array_dup5 (_tmp40_, _tmp40__length1) : ((gpointer) _tmp40_);
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp41__length1 = _tmp40__length1;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options = _tmp41_;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options_length1 = _tmp41__length1;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_uci_go_options_size_ = uci_go_options_length1;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp42_ = profile;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp43_ = ai_profile_get_hard_args (_tmp42_, &_tmp43__length1);
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp44_ = _tmp43_;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp44__length1 = _tmp43__length1;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup6 (_tmp44_, _tmp44__length1) : ((gpointer) _tmp44_);
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp45__length1 = _tmp44__length1;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args = _tmp45_;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args_length1 = _tmp45__length1;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_args_size_ = args_length1;
#line 655 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				break;
#line 4223 "gnome-chess.c"
			}
		}
	} else {
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 4229 "gnome-chess.c"
			default:
			{
				AIProfile* _tmp46_ = NULL;
				gchar** _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				gchar** _tmp48_ = NULL;
				gint _tmp48__length1 = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				AIProfile* _tmp50_ = NULL;
				gchar** _tmp51_ = NULL;
				gint _tmp51__length1 = 0;
				gchar** _tmp52_ = NULL;
				gint _tmp52__length1 = 0;
				gchar** _tmp53_ = NULL;
				gint _tmp53__length1 = 0;
				AIProfile* _tmp54_ = NULL;
				gchar** _tmp55_ = NULL;
				gint _tmp55__length1 = 0;
				gchar** _tmp56_ = NULL;
				gint _tmp56__length1 = 0;
				gchar** _tmp57_ = NULL;
				gint _tmp57__length1 = 0;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp46_ = profile;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp47_ = ai_profile_get_normal_options (_tmp46_, &_tmp47__length1);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp48_ = _tmp47_;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp48__length1 = _tmp47__length1;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp49_ = (_tmp48_ != NULL) ? _vala_array_dup7 (_tmp48_, _tmp48__length1) : ((gpointer) _tmp48_);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp49__length1 = _tmp48__length1;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options = _tmp49_;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options_length1 = _tmp49__length1;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_options_size_ = options_length1;
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp50_ = profile;
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp51_ = ai_profile_get_normal_uci_go_options (_tmp50_, &_tmp51__length1);
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp52_ = _tmp51_;
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp52__length1 = _tmp51__length1;
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp53_ = (_tmp52_ != NULL) ? _vala_array_dup8 (_tmp52_, _tmp52__length1) : ((gpointer) _tmp52_);
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp53__length1 = _tmp52__length1;
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options = _tmp53_;
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options_length1 = _tmp53__length1;
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_uci_go_options_size_ = uci_go_options_length1;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp54_ = profile;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp55_ = ai_profile_get_normal_args (_tmp54_, &_tmp55__length1);
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp56_ = _tmp55_;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp56__length1 = _tmp55__length1;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp57_ = (_tmp56_ != NULL) ? _vala_array_dup9 (_tmp56_, _tmp56__length1) : ((gpointer) _tmp56_);
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp57__length1 = _tmp56__length1;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args = _tmp57_;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args_length1 = _tmp57__length1;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_args_size_ = args_length1;
#line 650 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				break;
#line 4315 "gnome-chess.c"
			}
		}
	}
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = profile;
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = ai_profile_get_protocol (_tmp58_);
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = _tmp59_;
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp60_, "cecp") == 0) {
#line 4327 "gnome-chess.c"
		gchar** _tmp61_ = NULL;
		gint _tmp61__length1 = 0;
		AIProfile* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		gchar** _tmp65_ = NULL;
		gint _tmp65__length1 = 0;
		AIProfile* _tmp66_ = NULL;
		guint _tmp67_ = 0U;
		guint _tmp68_ = 0U;
		gchar** _tmp69_ = NULL;
		gint _tmp69__length1 = 0;
		ChessEngineCECP* _tmp70_ = NULL;
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp61_ = uci_go_options;
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp61__length1 = uci_go_options_length1;
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warn_if_fail (_tmp61__length1 == 0);
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp62_ = profile;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp63_ = ai_profile_get_binary (_tmp62_);
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp64_ = _tmp63_;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp65_ = args;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp65__length1 = args_length1;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp66_ = profile;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp67_ = ai_profile_get_delay_seconds (_tmp66_);
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp68_ = _tmp67_;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp69_ = options;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp69__length1 = options_length1;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp70_ = chess_engine_cecp_new (_tmp64_, _tmp65_, _tmp65__length1, _tmp68_, _tmp69_, _tmp69__length1);
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (engine);
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		engine = (ChessEngine*) _tmp70_;
#line 4373 "gnome-chess.c"
	} else {
		AIProfile* _tmp71_ = NULL;
		const gchar* _tmp72_ = NULL;
		const gchar* _tmp73_ = NULL;
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp71_ = profile;
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp72_ = ai_profile_get_protocol (_tmp71_);
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp73_ = _tmp72_;
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (g_strcmp0 (_tmp73_, "uci") == 0) {
#line 4386 "gnome-chess.c"
			AIProfile* _tmp74_ = NULL;
			const gchar* _tmp75_ = NULL;
			const gchar* _tmp76_ = NULL;
			gchar** _tmp77_ = NULL;
			gint _tmp77__length1 = 0;
			AIProfile* _tmp78_ = NULL;
			guint _tmp79_ = 0U;
			guint _tmp80_ = 0U;
			gchar** _tmp81_ = NULL;
			gint _tmp81__length1 = 0;
			gchar** _tmp82_ = NULL;
			gint _tmp82__length1 = 0;
			ChessEngineUCI* _tmp83_ = NULL;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp74_ = profile;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp75_ = ai_profile_get_binary (_tmp74_);
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp76_ = _tmp75_;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp77_ = args;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp77__length1 = args_length1;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp78_ = profile;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp79_ = ai_profile_get_delay_seconds (_tmp78_);
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp80_ = _tmp79_;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp81_ = options;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp81__length1 = options_length1;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp82_ = uci_go_options;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp82__length1 = uci_go_options_length1;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp83_ = chess_engine_uci_new (_tmp76_, _tmp77_, _tmp77__length1, _tmp80_, _tmp81_, _tmp81__length1, _tmp82_, _tmp82__length1);
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (engine);
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			engine = (ChessEngine*) _tmp83_;
#line 4430 "gnome-chess.c"
		} else {
			AIProfile* _tmp84_ = NULL;
			const gchar* _tmp85_ = NULL;
			const gchar* _tmp86_ = NULL;
#line 669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp84_ = profile;
#line 669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp85_ = ai_profile_get_protocol (_tmp84_);
#line 669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp86_ = _tmp85_;
#line 669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:669: Unknown AI protocol %s", _tmp86_);
#line 670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			result = NULL;
#line 670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (profile);
#line 670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (engine);
#line 670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return result;
#line 4457 "gnome-chess.c"
		}
	}
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = engine;
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (profile);
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4472 "gnome-chess.c"
}


static void chess_application_engine_ready_cb (ChessApplication* self, ChessEngine* engine) {
	ChessEngine* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 676 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 676 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_engine_get_ready (_tmp0_);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_) {
#line 4492 "gnome-chess.c"
		ChessView* _tmp3_ = NULL;
#line 680 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->view;
#line 680 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_queue_draw ((GtkWidget*) _tmp3_);
#line 4498 "gnome-chess.c"
	}
}


static void chess_application_do_engine_move (ChessApplication* self, const gchar* move) {
	ChessPlayer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 684 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 684 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (move != NULL);
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent;
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = move;
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_player_move (_tmp0_, _tmp1_, TRUE);
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 4519 "gnome-chess.c"
		const gchar* _tmp3_ = NULL;
		ChessGame* _tmp4_ = NULL;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = move;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:688: Engine's move %s is illegal! Engine desync?", _tmp3_);
#line 689 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->game;
#line 689 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_game_stop (_tmp4_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 4530 "gnome-chess.c"
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return _data1_;
#line 4540 "gnome-chess.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 4549 "gnome-chess.c"
		ChessApplication* self;
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self = _data1_->self;
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_data1_->move);
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self);
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_slice_free (Block1Data, _data1_);
#line 4559 "gnome-chess.c"
	}
}


static gboolean ___lambda7_ (Block1Data* _data1_) {
	ChessApplication* self;
	gboolean result = FALSE;
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = _data1_->self;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_) {
#line 705 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = TRUE;
#line 705 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 4584 "gnome-chess.c"
	} else {
		const gchar* _tmp3_ = NULL;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = _data1_->move;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_do_engine_move (self, _tmp3_);
#line 711 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = FALSE;
#line 711 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 4595 "gnome-chess.c"
	}
}


static gboolean ____lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda7_ (self);
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4605 "gnome-chess.c"
}


static void chess_application_engine_move_cb (ChessApplication* self, ChessEngine* engine, const gchar* move) {
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (move != NULL);
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data1_->_ref_count_ = 1;
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data1_->self = g_object_ref (self);
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = move;
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_data1_->move);
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data1_->move = _tmp1_;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->game;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = chess_game_get_is_paused (_tmp2_);
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp4_) {
#line 4644 "gnome-chess.c"
		const gchar* _tmp5_ = NULL;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _data1_->move;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_do_engine_move (self, _tmp5_);
#line 4650 "gnome-chess.c"
	} else {
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda7__gsource_func, block1_data_ref (_data1_), block1_data_unref);
#line 4654 "gnome-chess.c"
	}
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	block1_data_unref (_data1_);
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data1_ = NULL;
#line 4660 "gnome-chess.c"
}


static void chess_application_engine_resigned_cb (ChessApplication* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_ = NULL;
#line 717 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 717 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_player_resign (_tmp0_);
#line 4674 "gnome-chess.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return _data2_;
#line 4683 "gnome-chess.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 4692 "gnome-chess.c"
		ChessApplication* self;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self = _data2_->self;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_data2_->original_game);
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self);
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_slice_free (Block2Data, _data2_);
#line 4702 "gnome-chess.c"
	}
}


static gboolean __lambda8_ (Block2Data* _data2_) {
	ChessApplication* self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = _data2_->self;
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game;
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ == _data2_->original_game) {
#line 4718 "gnome-chess.c"
		ChessGame* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game;
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = _tmp2_->is_started;
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp3_;
#line 4727 "gnome-chess.c"
	} else {
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 4731 "gnome-chess.c"
	}
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 4735 "gnome-chess.c"
		ChessGame* _tmp4_ = NULL;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->game;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_game_stop (_tmp4_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 4741 "gnome-chess.c"
	}
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4747 "gnome-chess.c"
}


static gboolean ___lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda8_ (self);
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4756 "gnome-chess.c"
}


static void chess_application_engine_stopped_cb (ChessApplication* self, ChessEngine* engine) {
	Block2Data* _data2_;
	ChessGame* _tmp0_ = NULL;
	ChessGame* _tmp1_ = NULL;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data2_->_ref_count_ = 1;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data2_->self = g_object_ref (self);
#line 736 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 736 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 736 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data2_->original_game = _tmp1_;
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ___lambda8__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	block2_data_unref (_data2_);
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data2_ = NULL;
#line 4786 "gnome-chess.c"
}


static void chess_application_engine_error_cb (ChessApplication* self, ChessEngine* engine) {
	ChessGame* _tmp0_ = NULL;
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_game_stop (_tmp0_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 4800 "gnome-chess.c"
}


static void chess_application_engine_claim_draw_cb (ChessApplication* self, ChessEngine* engine) {
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 750 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 750 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 752 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 752 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_can_claim_draw (_tmp0_);
#line 752 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp1_) {
#line 4817 "gnome-chess.c"
		ChessGame* _tmp2_ = NULL;
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game;
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_game_stop (_tmp2_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 4823 "gnome-chess.c"
	}
}


static void chess_application_engine_offer_draw_cb (ChessApplication* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_ = NULL;
#line 756 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 756 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent;
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_player_claim_draw (_tmp0_);
#line 4838 "gnome-chess.c"
}


static void chess_application_game_clock_tick_cb (ChessApplication* self, ChessClock* clock) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (clock != NULL);
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->white_time_label;
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp0_);
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->black_time_label;
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp1_);
#line 4857 "gnome-chess.c"
}


static void chess_application_game_turn_cb (ChessApplication* self, ChessGame* game, ChessPlayer* player) {
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ChessGame* _tmp2_ = NULL;
	ChessClock* _tmp3_ = NULL;
	ChessClock* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	ChessGame* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (game != NULL);
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (player != NULL);
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = game;
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = _tmp0_->is_started;
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp1_) {
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 4884 "gnome-chess.c"
	}
#line 793 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = game;
#line 793 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = chess_game_get_clock (_tmp2_);
#line 793 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_;
#line 793 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp4_ != NULL) {
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
#line 4896 "gnome-chess.c"
	}
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = game;
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = chess_game_can_claim_draw (_tmp6_);
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 4904 "gnome-chess.c"
		gboolean _tmp8_ = FALSE;
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = self->priv->allow_claim_draw_dialog;
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp8_;
#line 4910 "gnome-chess.c"
	} else {
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = FALSE;
#line 4914 "gnome-chess.c"
	}
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp5_) {
#line 797 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_present_claim_draw_dialog (self);
#line 4920 "gnome-chess.c"
	}
}


static void chess_application_set_move_text (ChessApplication* self, GtkTreeIter* iter, ChessMove* move) {
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	static const gchar* human_descriptions[] = {"White pawn moves from %1$s to %2$s", "White pawn at %1$s takes the black pawn at %2$s", "White pawn at %1$s takes the black rook at %2$s", "White pawn at %1$s takes the black knight at %2$s", "White pawn at %1$s takes the black bishop at %2$s", "White pawn at %1$s takes the black queen at %2$s", "White rook moves from %1$s to %2$s", "White rook at %1$s takes the black pawn at %2$s", "White rook at %1$s takes the black rook at %2$s", "White rook at %1$s takes the black knight at %2$s", "White rook at %1$s takes the black bishop at %2$s", "White rook at %1$s takes the black queen at %2$s", "White knight moves from %1$s to %2$s", "White knight at %1$s takes the black pawn at %2$s", "White knight at %1$s takes the black rook at %2$s", "White knight at %1$s takes the black knight at %2$s", "White knight at %1$s takes the black bishop at %2$s", "White knight at %1$s takes the black queen at %2$s", "White bishop moves from %1$s to %2$s", "White bishop at %1$s takes the black pawn at %2$s", "White bishop at %1$s takes the black rook at %2$s", "White bishop at %1$s takes the black knight at %2$s", "White bishop at %1$s takes the black bishop at %2$s", "White bishop at %1$s takes the black queen at %2$s", "White queen moves from %1$s to %2$s", "White queen at %1$s takes the black pawn at %2$s", "White queen at %1$s takes the black rook at %2$s", "White queen at %1$s takes the black knight at %2$s", "White queen at %1$s takes the black bishop at %2$s", "White queen at %1$s takes the black queen at %2$s", "White king moves from %1$s to %2$s", "White king at %1$s takes the black pawn at %2$s", "White king at %1$s takes the black rook at %2$s", "White king at %1$s takes the black knight at %2$s", "White king at %1$s takes the black bishop at %2$s", "White king at %1$s takes the black queen at %2$s", "Black pawn moves from %1$s to %2$s", "Black pawn at %1$s takes the white pawn at %2$s", "Black pawn at %1$s takes the white rook at %2$s", "Black pawn at %1$s takes the white knight at %2$s", "Black pawn at %1$s takes the white bishop at %2$s", "Black pawn at %1$s takes the white queen at %2$s", "Black rook moves from %1$s to %2$s", "Black rook at %1$s takes the white pawn at %2$s", "Black rook at %1$s takes the white rook at %2$s", "Black rook at %1$s takes the white knight at %2$s", "Black rook at %1$s takes the white bishop at %2$s", "Black rook at %1$s takes the white queen at %2$s", "Black knight moves from %1$s to %2$s", "Black knight at %1$s takes the white pawn at %2$s", "Black knight at %1$s takes the white rook at %2$s", "Black knight at %1$s takes the white knight at %2$s", "Black knight at %1$s takes the white bishop at %2$s", "Black knight at %1$s takes the white queen at %2$s", "Black bishop moves from %1$s to %2$s", "Black bishop at %1$s takes the white pawn at %2$s", "Black bishop at %1$s takes the white rook at %2$s", "Black bishop at %1$s takes the white knight at %2$s", "Black bishop at %1$s takes the white bishop at %2$s", "Black bishop at %1$s takes the white queen at %2$s", "Black queen moves from %1$s to %2$s", "Black queen at %1$s takes the white pawn at %2$s", "Black queen at %1$s takes the white rook at %2$s", "Black queen at %1$s takes the white knight at %2$s", "Black queen at %1$s takes the white bishop at %2$s", "Black queen at %1$s takes the white queen at %2$s", "Black king moves from %1$s to %2$s", "Black king at %1$s takes the white pawn at %2$s", "Black king at %1$s takes the white rook at %2$s", "Black king at %1$s takes the white knight at %2$s", "Black king at %1$s takes the white bishop at %2$s", "Black king at %1$s takes the white queen at %2$s"};
#line 4928 "gnome-chess.c"
	gchar* move_text = NULL;
	gchar* _tmp0_ = NULL;
	ChessScene* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp5_label0 = 0;
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp5_label1 = 0;
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp5_label2 = 0;
#line 4942 "gnome-chess.c"
	GtkListStore* model = NULL;
	GtkComboBox* _tmp81_ = NULL;
	GtkTreeModel* _tmp82_ = NULL;
	GtkTreeModel* _tmp83_ = NULL;
	GtkListStore* _tmp84_ = NULL;
	gchar _tmp85_ = '\0';
	ChessMove* _tmp86_ = NULL;
	gint _tmp87_ = 0;
	gchar* label = NULL;
	ChessMove* _tmp88_ = NULL;
	gint _tmp89_ = 0;
	const gchar* _tmp90_ = NULL;
	gchar* _tmp91_ = NULL;
	GtkListStore* _tmp92_ = NULL;
	GtkTreeIter _tmp93_ = {0};
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (iter != NULL);
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (move != NULL);
#line 948 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = g_strdup ("");
#line 948 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	move_text = _tmp0_;
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->scene;
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_scene_get_move_format (_tmp1_);
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_;
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("human")))) {
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 4982 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp7_ = NULL;
				ChessPiece* _tmp8_ = NULL;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp7_ = move;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp8_ = _tmp7_->moved_rook;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp8_ == NULL) {
#line 4993 "gnome-chess.c"
					gint index = 0;
					ChessMove* _tmp9_ = NULL;
					ChessPiece* _tmp10_ = NULL;
					gint _tmp14_ = 0;
					ChessMove* _tmp15_ = NULL;
					ChessPiece* _tmp16_ = NULL;
					PieceType _tmp17_ = 0;
					ChessMove* _tmp18_ = NULL;
					ChessPiece* _tmp19_ = NULL;
					ChessPlayer* _tmp20_ = NULL;
					Color _tmp21_ = 0;
					gchar* start = NULL;
					ChessMove* _tmp23_ = NULL;
					gint _tmp24_ = 0;
					ChessMove* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gchar* _tmp27_ = NULL;
					gchar* end = NULL;
					ChessMove* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					ChessMove* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					gchar* _tmp32_ = NULL;
					gint _tmp33_ = 0;
					const gchar* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					gchar* _tmp38_ = NULL;
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = move;
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp10_ = _tmp9_->victim;
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (_tmp10_ == NULL) {
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						index = 0;
#line 5031 "gnome-chess.c"
					} else {
						ChessMove* _tmp11_ = NULL;
						ChessPiece* _tmp12_ = NULL;
						PieceType _tmp13_ = 0;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp11_ = move;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp12_ = _tmp11_->victim;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp13_ = _tmp12_->type;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						index = (gint) (_tmp13_ + 1);
#line 5044 "gnome-chess.c"
					}
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp14_ = index;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp15_ = move;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp16_ = _tmp15_->piece;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp17_ = _tmp16_->type;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					index = _tmp14_ + (_tmp17_ * 6);
#line 960 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp18_ = move;
#line 960 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp19_ = _tmp18_->piece;
#line 960 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp20_ = _tmp19_->player;
#line 960 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp21_ = _tmp20_->color;
#line 960 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (_tmp21_ == COLOR_BLACK) {
#line 5066 "gnome-chess.c"
						gint _tmp22_ = 0;
#line 961 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp22_ = index;
#line 961 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						index = _tmp22_ + 36;
#line 5072 "gnome-chess.c"
					}
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp23_ = move;
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp24_ = _tmp23_->f0;
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp25_ = move;
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp26_ = _tmp25_->r0;
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp27_ = g_strdup_printf ("%c%d", 'a' + _tmp24_, _tmp26_ + 1);
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					start = _tmp27_;
#line 964 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp28_ = move;
#line 964 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp29_ = _tmp28_->f1;
#line 964 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp30_ = move;
#line 964 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp31_ = _tmp30_->r1;
#line 964 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp32_ = g_strdup_printf ("%c%d", 'a' + _tmp29_, _tmp31_ + 1);
#line 964 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					end = _tmp32_;
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp33_ = index;
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp34_ = human_descriptions[_tmp33_];
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp35_ = _ (_tmp34_);
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp36_ = start;
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp37_ = end;
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp38_ = g_strdup_printf (_tmp35_, _tmp36_, _tmp37_);
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_free0 (move_text);
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					move_text = _tmp38_;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_free0 (end);
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_free0 (start);
#line 5118 "gnome-chess.c"
				} else {
					gboolean _tmp39_ = FALSE;
					ChessMove* _tmp40_ = NULL;
					gint _tmp41_ = 0;
					ChessMove* _tmp42_ = NULL;
					gint _tmp43_ = 0;
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp40_ = move;
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp41_ = _tmp40_->f0;
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp42_ = move;
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp43_ = _tmp42_->f1;
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (_tmp41_ < _tmp43_) {
#line 5135 "gnome-chess.c"
						ChessMove* _tmp44_ = NULL;
						gint _tmp45_ = 0;
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp44_ = move;
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp45_ = _tmp44_->r0;
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp39_ = _tmp45_ == 0;
#line 5144 "gnome-chess.c"
					} else {
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp39_ = FALSE;
#line 5148 "gnome-chess.c"
					}
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (_tmp39_) {
#line 5152 "gnome-chess.c"
						const gchar* _tmp46_ = NULL;
						gchar* _tmp47_ = NULL;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp46_ = _ ("White castles kingside");
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp47_ = g_strdup (_tmp46_);
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_g_free0 (move_text);
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						move_text = _tmp47_;
#line 5163 "gnome-chess.c"
					} else {
						gboolean _tmp48_ = FALSE;
						ChessMove* _tmp49_ = NULL;
						gint _tmp50_ = 0;
						ChessMove* _tmp51_ = NULL;
						gint _tmp52_ = 0;
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp49_ = move;
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp50_ = _tmp49_->f1;
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp51_ = move;
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp52_ = _tmp51_->f0;
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						if (_tmp50_ < _tmp52_) {
#line 5180 "gnome-chess.c"
							ChessMove* _tmp53_ = NULL;
							gint _tmp54_ = 0;
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp53_ = move;
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp54_ = _tmp53_->r0;
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp48_ = _tmp54_ == 0;
#line 5189 "gnome-chess.c"
						} else {
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp48_ = FALSE;
#line 5193 "gnome-chess.c"
						}
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						if (_tmp48_) {
#line 5197 "gnome-chess.c"
							const gchar* _tmp55_ = NULL;
							gchar* _tmp56_ = NULL;
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp55_ = _ ("White castles queenside");
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp56_ = g_strdup (_tmp55_);
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_g_free0 (move_text);
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							move_text = _tmp56_;
#line 5208 "gnome-chess.c"
						} else {
							gboolean _tmp57_ = FALSE;
							ChessMove* _tmp58_ = NULL;
							gint _tmp59_ = 0;
							ChessMove* _tmp60_ = NULL;
							gint _tmp61_ = 0;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp58_ = move;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp59_ = _tmp58_->f0;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp60_ = move;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp61_ = _tmp60_->f1;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							if (_tmp59_ < _tmp61_) {
#line 5225 "gnome-chess.c"
								ChessMove* _tmp62_ = NULL;
								gint _tmp63_ = 0;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp62_ = move;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp63_ = _tmp62_->r0;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp57_ = _tmp63_ == 7;
#line 5234 "gnome-chess.c"
							} else {
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp57_ = FALSE;
#line 5238 "gnome-chess.c"
							}
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							if (_tmp57_) {
#line 5242 "gnome-chess.c"
								const gchar* _tmp64_ = NULL;
								gchar* _tmp65_ = NULL;
#line 977 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp64_ = _ ("Black castles kingside");
#line 977 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp65_ = g_strdup (_tmp64_);
#line 977 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_g_free0 (move_text);
#line 977 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								move_text = _tmp65_;
#line 5253 "gnome-chess.c"
							} else {
								gboolean _tmp66_ = FALSE;
								ChessMove* _tmp67_ = NULL;
								gint _tmp68_ = 0;
								ChessMove* _tmp69_ = NULL;
								gint _tmp70_ = 0;
#line 979 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp67_ = move;
#line 979 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp68_ = _tmp67_->f1;
#line 979 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp69_ = move;
#line 979 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp70_ = _tmp69_->f0;
#line 979 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								if (_tmp68_ < _tmp70_) {
#line 5270 "gnome-chess.c"
									ChessMove* _tmp71_ = NULL;
									gint _tmp72_ = 0;
#line 979 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									_tmp71_ = move;
#line 979 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									_tmp72_ = _tmp71_->r0;
#line 979 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									_tmp66_ = _tmp72_ == 7;
#line 5279 "gnome-chess.c"
								} else {
#line 979 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									_tmp66_ = FALSE;
#line 5283 "gnome-chess.c"
								}
#line 979 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								if (_tmp66_) {
#line 5287 "gnome-chess.c"
									const gchar* _tmp73_ = NULL;
									gchar* _tmp74_ = NULL;
#line 981 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									_tmp73_ = _ ("Black castles queenside");
#line 981 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									_tmp74_ = g_strdup (_tmp73_);
#line 981 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									_g_free0 (move_text);
#line 981 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									move_text = _tmp74_;
#line 5298 "gnome-chess.c"
								} else {
#line 983 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									g_assert_not_reached ();
#line 5302 "gnome-chess.c"
								}
							}
						}
					}
				}
#line 984 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				break;
#line 5310 "gnome-chess.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("san")))) {
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 5316 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp75_ = NULL;
				gchar* _tmp76_ = NULL;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp75_ = move;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp76_ = chess_move_get_san (_tmp75_);
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move_text);
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				move_text = _tmp76_;
#line 988 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				break;
#line 5331 "gnome-chess.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("fan")))) {
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 5337 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp77_ = NULL;
				gchar* _tmp78_ = NULL;
#line 991 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp77_ = move;
#line 991 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp78_ = chess_move_get_fan (_tmp77_);
#line 991 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move_text);
#line 991 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				move_text = _tmp78_;
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				break;
#line 5352 "gnome-chess.c"
			}
		}
	} else {
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 5358 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp79_ = NULL;
				gchar* _tmp80_ = NULL;
#line 996 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp79_ = move;
#line 996 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp80_ = chess_move_get_lan (_tmp79_);
#line 996 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move_text);
#line 996 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				move_text = _tmp80_;
#line 997 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				break;
#line 5373 "gnome-chess.c"
			}
		}
	}
#line 1000 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp81_ = self->priv->history_combo;
#line 1000 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp82_ = gtk_combo_box_get_model (_tmp81_);
#line 1000 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp83_ = _tmp82_;
#line 1000 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, gtk_list_store_get_type (), GtkListStore));
#line 1000 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp84_;
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = move;
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp87_ = _tmp86_->number;
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if ((_tmp87_ % 2) == 0) {
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp85_ = 'b';
#line 5395 "gnome-chess.c"
	} else {
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp85_ = 'a';
#line 5399 "gnome-chess.c"
	}
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp88_ = move;
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp89_ = _tmp88_->number;
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = move_text;
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp91_ = g_strdup_printf ("%u%c. %s", (guint) ((_tmp89_ + 1) / 2), (gint) _tmp85_, _tmp90_);
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	label = _tmp91_;
#line 1002 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp92_ = model;
#line 1002 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp93_ = *iter;
#line 1002 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_set (_tmp92_, &_tmp93_, 0, label, -1, -1);
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (label);
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (move_text);
#line 5423 "gnome-chess.c"
}


static void chess_application_game_move_cb (ChessApplication* self, ChessGame* game, ChessMove* move) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessMove* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	ChessMove* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	PGNGame* _tmp9_ = NULL;
	GList* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	ChessScene* _tmp15_ = NULL;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp16_ = NULL;
	GtkTreeModel* _tmp17_ = NULL;
	GtkTreeModel* _tmp18_ = NULL;
	GtkListStore* _tmp19_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp20_ = NULL;
	GtkTreeIter _tmp21_ = {0};
	GtkListStore* _tmp22_ = NULL;
	GtkTreeIter _tmp23_ = {0};
	ChessMove* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GtkTreeIter _tmp26_ = {0};
	ChessMove* _tmp27_ = NULL;
	ChessMove* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	ChessGame* _tmp30_ = NULL;
	guint _tmp31_ = 0U;
	guint _tmp32_ = 0U;
	ChessView* _tmp35_ = NULL;
	ChessEngine* _tmp36_ = NULL;
#line 1005 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1005 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (game != NULL);
#line 1005 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (move != NULL);
#line 1009 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_enable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
#line 1012 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->game_needs_saving = TRUE;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = move;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_->number;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp3_ == 1) {
#line 5475 "gnome-chess.c"
		ChessPlayer* _tmp4_ = NULL;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->opponent;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = _tmp4_ != NULL;
#line 5481 "gnome-chess.c"
	} else {
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = FALSE;
#line 5485 "gnome-chess.c"
	}
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_) {
#line 5489 "gnome-chess.c"
		ChessPlayer* _tmp5_ = NULL;
		Color _tmp6_ = 0;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->opponent;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = _tmp5_->color;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp6_ == COLOR_WHITE;
#line 5498 "gnome-chess.c"
	} else {
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 5502 "gnome-chess.c"
	}
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 1016 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = FALSE;
#line 5508 "gnome-chess.c"
	}
#line 1018 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = move;
#line 1018 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_->number;
#line 1018 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->pgn_game;
#line 1018 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = _tmp9_->moves;
#line 1018 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = g_list_length (_tmp10_);
#line 1018 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (((guint) _tmp8_) > _tmp11_) {
#line 5522 "gnome-chess.c"
		PGNGame* _tmp12_ = NULL;
		ChessMove* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 1019 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->pgn_game;
#line 1019 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = move;
#line 1019 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = chess_move_get_san (_tmp13_);
#line 1019 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_->moves = g_list_append (_tmp12_->moves, _tmp14_);
#line 5534 "gnome-chess.c"
	}
#line 1022 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->scene;
#line 1022 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp15_, -1);
#line 1024 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->history_combo;
#line 1024 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = gtk_combo_box_get_model (_tmp16_);
#line 1024 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = _tmp17_;
#line 1024 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_list_store_get_type (), GtkListStore));
#line 1024 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp19_;
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = model;
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_append (_tmp20_, &_tmp21_);
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp21_;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = model;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = iter;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = move;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = _tmp24_->number;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_set (_tmp22_, &_tmp23_, 1, _tmp25_, -1, -1);
#line 1028 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = iter;
#line 1028 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = move;
#line 1028 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_move_text (self, &_tmp26_, _tmp27_);
#line 1031 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = move;
#line 1031 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = _tmp28_->number;
#line 1031 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = game;
#line 1031 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = chess_game_get_n_moves (_tmp30_);
#line 1031 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _tmp31_;
#line 1031 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (((guint) _tmp29_) == _tmp32_) {
#line 5584 "gnome-chess.c"
		GtkComboBox* _tmp33_ = NULL;
		GtkTreeIter _tmp34_ = {0};
#line 1032 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp33_ = self->priv->history_combo;
#line 1032 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp34_ = iter;
#line 1032 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active_iter (_tmp33_, &_tmp34_);
#line 5593 "gnome-chess.c"
	}
#line 1034 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_history_panel (self);
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_action_status (self);
#line 1038 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_headerbar_title (self);
#line 1040 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = self->priv->view;
#line 1040 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp35_);
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = self->priv->opponent_engine;
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp36_ != NULL) {
#line 5613 "gnome-chess.c"
		ChessEngine* _tmp37_ = NULL;
		ChessMove* _tmp38_ = NULL;
		gboolean _tmp39_ = FALSE;
		ChessMove* _tmp40_ = NULL;
		ChessPiece* _tmp41_ = NULL;
		Color _tmp42_ = 0;
		Color _tmp43_ = 0;
		ChessPlayer* _tmp44_ = NULL;
		Color _tmp45_ = 0;
#line 1044 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = self->priv->opponent_engine;
#line 1044 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = move;
#line 1044 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_engine_report_move (_tmp37_, _tmp38_);
#line 1046 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp40_ = move;
#line 1046 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp41_ = _tmp40_->piece;
#line 1046 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp42_ = chess_piece_get_color (_tmp41_);
#line 1046 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp43_ = _tmp42_;
#line 1046 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp44_ = self->priv->opponent;
#line 1046 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp45_ = _tmp44_->color;
#line 1046 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp43_ != _tmp45_) {
#line 5643 "gnome-chess.c"
			gboolean _tmp46_ = FALSE;
#line 1046 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp46_ = self->priv->starting;
#line 1046 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp39_ = !_tmp46_;
#line 5649 "gnome-chess.c"
		} else {
#line 1046 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp39_ = FALSE;
#line 5653 "gnome-chess.c"
		}
#line 1046 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp39_) {
#line 5657 "gnome-chess.c"
			ChessEngine* _tmp47_ = NULL;
#line 1047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = self->priv->opponent_engine;
#line 1047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_engine_move (_tmp47_);
#line 5663 "gnome-chess.c"
		}
	}
#line 1005 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 5668 "gnome-chess.c"
}


static void chess_application_game_undo_cb (ChessApplication* self, ChessGame* game) {
	ChessEngine* _tmp0_ = NULL;
	PGNGame* _tmp2_ = NULL;
	PGNGame* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_ = NULL;
	GtkListStore* _tmp9_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp10_ = NULL;
	GtkListStore* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GtkTreeIter _tmp13_ = {0};
	GtkListStore* _tmp14_ = NULL;
	GtkTreeIter _tmp15_ = {0};
	ChessScene* _tmp16_ = NULL;
	GtkListStore* _tmp17_ = NULL;
	GtkListStore* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GtkTreeIter _tmp20_ = {0};
	GtkComboBox* _tmp21_ = NULL;
	GtkTreeIter _tmp22_ = {0};
	ChessView* _tmp23_ = NULL;
	ChessGame* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	guint _tmp26_ = 0U;
#line 1051 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1051 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (game != NULL);
#line 1054 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 1054 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 5709 "gnome-chess.c"
		ChessEngine* _tmp1_ = NULL;
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->opponent_engine;
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_engine_undo (_tmp1_);
#line 5715 "gnome-chess.c"
	}
#line 1058 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->pgn_game;
#line 1058 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->pgn_game;
#line 1058 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_->moves;
#line 1058 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = g_list_last (_tmp4_);
#line 1058 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_->moves = g_list_remove_link (_tmp2_->moves, _tmp5_);
#line 1061 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->history_combo;
#line 1061 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = gtk_combo_box_get_model (_tmp6_);
#line 1061 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_;
#line 1061 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_list_store_get_type (), GtkListStore));
#line 1061 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp9_;
#line 1063 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = model;
#line 1063 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = model;
#line 1063 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp11_, NULL);
#line 1063 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp10_, &_tmp13_, NULL, _tmp12_ - 1);
#line 1063 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp13_;
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = model;
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = iter;
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_remove (_tmp14_, &_tmp15_);
#line 1067 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->scene;
#line 1067 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp16_, -1);
#line 1070 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = model;
#line 1070 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = model;
#line 1070 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp18_, NULL);
#line 1070 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp17_, &_tmp20_, NULL, _tmp19_ - 1);
#line 1070 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp20_;
#line 1071 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = self->priv->history_combo;
#line 1071 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = iter;
#line 1071 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
#line 1072 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->view;
#line 1072 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp23_);
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = game;
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = chess_game_get_n_moves (_tmp24_);
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = _tmp25_;
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp26_ > ((guint) 0)) {
#line 1076 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = TRUE;
#line 1077 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 1078 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
#line 5791 "gnome-chess.c"
	} else {
#line 1082 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = FALSE;
#line 1083 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
#line 1084 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 1085 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
#line 5801 "gnome-chess.c"
	}
#line 1088 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_history_panel (self);
#line 1089 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_action_status (self);
#line 1090 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_headerbar_title (self);
#line 1051 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 5811 "gnome-chess.c"
}


static void chess_application_update_action_status (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gboolean can_resign = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	ChessGame* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	gboolean can_undo = FALSE;
	gboolean _tmp15_ = FALSE;
	ChessPlayer* _tmp16_ = NULL;
	gboolean _tmp26_ = FALSE;
#line 1093 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game;
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_game_get_n_moves (_tmp1_);
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp3_ > ((guint) 0)) {
#line 5840 "gnome-chess.c"
		ChessGame* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->game;
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = chess_game_get_is_paused (_tmp4_);
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = _tmp5_;
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = !_tmp6_;
#line 5852 "gnome-chess.c"
	} else {
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 5856 "gnome-chess.c"
	}
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	can_resign = _tmp0_;
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = can_resign;
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_RESIGN_ACTION_NAME);
#line 5866 "gnome-chess.c"
	} else {
#line 1099 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_RESIGN_ACTION_NAME);
#line 5870 "gnome-chess.c"
	}
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->game;
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = chess_game_get_n_moves (_tmp9_);
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = _tmp10_;
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp11_ > ((guint) 0)) {
#line 5880 "gnome-chess.c"
		ChessGame* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->game;
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = chess_game_get_is_paused (_tmp12_);
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = _tmp13_;
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = !_tmp14_;
#line 5892 "gnome-chess.c"
	} else {
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = FALSE;
#line 5896 "gnome-chess.c"
	}
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	can_undo = _tmp8_;
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->opponent;
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp16_ != NULL) {
#line 5904 "gnome-chess.c"
		ChessPlayer* _tmp17_ = NULL;
		Color _tmp18_ = 0;
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = self->priv->opponent;
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = _tmp17_->color;
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _tmp18_ == COLOR_WHITE;
#line 5913 "gnome-chess.c"
	} else {
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = FALSE;
#line 5917 "gnome-chess.c"
	}
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp15_) {
#line 5921 "gnome-chess.c"
		gboolean _tmp19_ = FALSE;
		ChessGame* _tmp20_ = NULL;
		guint _tmp21_ = 0U;
		guint _tmp22_ = 0U;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = self->priv->game;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = chess_game_get_n_moves (_tmp20_);
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = _tmp21_;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp22_ > ((guint) 1)) {
#line 5934 "gnome-chess.c"
			ChessGame* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp23_ = self->priv->game;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp24_ = chess_game_get_is_paused (_tmp23_);
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp25_ = _tmp24_;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp19_ = !_tmp25_;
#line 5946 "gnome-chess.c"
		} else {
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp19_ = FALSE;
#line 5950 "gnome-chess.c"
		}
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		can_undo = _tmp19_;
#line 5954 "gnome-chess.c"
	}
#line 1106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = can_undo;
#line 1106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp26_) {
#line 1107 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME);
#line 5962 "gnome-chess.c"
	} else {
#line 1109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME);
#line 5966 "gnome-chess.c"
	}
}


static void chess_application_update_headerbar_title (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessPlayer* _tmp2_ = NULL;
#line 1112 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->human_player;
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ == NULL) {
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = TRUE;
#line 5983 "gnome-chess.c"
	} else {
		ChessPlayer* _tmp3_ = NULL;
		Color _tmp4_ = 0;
		ChessGame* _tmp5_ = NULL;
		ChessPlayer* _tmp6_ = NULL;
		ChessPlayer* _tmp7_ = NULL;
		Color _tmp8_ = 0;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->human_player;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_->color;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->game;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = chess_game_get_current_player (_tmp5_);
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp6_;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = _tmp7_->color;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = _tmp4_ == _tmp8_;
#line 6005 "gnome-chess.c"
	}
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_) {
#line 6009 "gnome-chess.c"
		ChessGame* _tmp9_ = NULL;
		ChessState* _tmp10_ = NULL;
		ChessState* _tmp11_ = NULL;
		ChessGame* _tmp12_ = NULL;
		ChessPlayer* _tmp13_ = NULL;
		ChessPlayer* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = self->priv->game;
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = chess_game_get_current_state (_tmp9_);
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp10_;
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->game;
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = chess_game_get_current_player (_tmp12_);
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = _tmp13_;
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = chess_state_is_in_check (_tmp11_, _tmp14_);
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp15_;
#line 6033 "gnome-chess.c"
	} else {
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 6037 "gnome-chess.c"
	}
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 6041 "gnome-chess.c"
		ChessGame* _tmp16_ = NULL;
		ChessPlayer* _tmp17_ = NULL;
		ChessPlayer* _tmp18_ = NULL;
		Color _tmp19_ = 0;
#line 1118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = self->priv->game;
#line 1118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = chess_game_get_current_player (_tmp16_);
#line 1118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = _tmp17_;
#line 1118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = _tmp18_->color;
#line 1118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp19_ == COLOR_WHITE) {
#line 6056 "gnome-chess.c"
			GtkHeaderBar* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
#line 1120 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp20_ = self->priv->headerbar;
#line 1120 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp21_ = _ ("White is in Check");
#line 1120 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_header_bar_set_title (_tmp20_, _tmp21_);
#line 6065 "gnome-chess.c"
		} else {
			GtkHeaderBar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
#line 1123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp22_ = self->priv->headerbar;
#line 1123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp23_ = _ ("Black is in Check");
#line 1123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_header_bar_set_title (_tmp22_, _tmp23_);
#line 6075 "gnome-chess.c"
		}
	} else {
		ChessGame* _tmp24_ = NULL;
		ChessPlayer* _tmp25_ = NULL;
		ChessPlayer* _tmp26_ = NULL;
		Color _tmp27_ = 0;
#line 1125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = self->priv->game;
#line 1125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = chess_game_get_current_player (_tmp24_);
#line 1125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = _tmp25_;
#line 1125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = _tmp26_->color;
#line 1125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp27_ == COLOR_WHITE) {
#line 6092 "gnome-chess.c"
			gboolean _tmp28_ = FALSE;
			ChessPlayer* _tmp29_ = NULL;
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp29_ = self->priv->human_player;
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp29_ == NULL) {
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp28_ = TRUE;
#line 6101 "gnome-chess.c"
			} else {
				ChessPlayer* _tmp30_ = NULL;
				Color _tmp31_ = 0;
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp30_ = self->priv->human_player;
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp31_ = _tmp30_->color;
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp28_ = _tmp31_ == COLOR_WHITE;
#line 6111 "gnome-chess.c"
			}
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp28_) {
#line 6115 "gnome-chess.c"
				GtkHeaderBar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp32_ = self->priv->headerbar;
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp33_ = _ ("White to Move");
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_header_bar_set_title (_tmp32_, _tmp33_);
#line 6124 "gnome-chess.c"
			} else {
				GtkHeaderBar* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
#line 1132 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp34_ = self->priv->headerbar;
#line 1132 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp35_ = _ ("White is Thinking…");
#line 1132 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_header_bar_set_title (_tmp34_, _tmp35_);
#line 6134 "gnome-chess.c"
			}
		} else {
			gboolean _tmp36_ = FALSE;
			ChessPlayer* _tmp37_ = NULL;
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp37_ = self->priv->human_player;
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp37_ == NULL) {
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = TRUE;
#line 6145 "gnome-chess.c"
			} else {
				ChessPlayer* _tmp38_ = NULL;
				Color _tmp39_ = 0;
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp38_ = self->priv->human_player;
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = _tmp38_->color;
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = _tmp39_ == COLOR_BLACK;
#line 6155 "gnome-chess.c"
			}
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp36_) {
#line 6159 "gnome-chess.c"
				GtkHeaderBar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
#line 1138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = self->priv->headerbar;
#line 1138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp41_ = _ ("Black to Move");
#line 1138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_header_bar_set_title (_tmp40_, _tmp41_);
#line 6168 "gnome-chess.c"
			} else {
				GtkHeaderBar* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp42_ = self->priv->headerbar;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp43_ = _ ("Black is Thinking…");
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_header_bar_set_title (_tmp42_, _tmp43_);
#line 6178 "gnome-chess.c"
			}
		}
	}
}


static void chess_application_add_accelerators (ChessApplication* self) {
#line 1145 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>N", "win." CHESS_APPLICATION_NEW_GAME_ACTION_NAME, NULL);
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>O", "win." CHESS_APPLICATION_OPEN_GAME_ACTION_NAME, NULL);
#line 1149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>S", "win." CHESS_APPLICATION_SAVE_GAME_ACTION_NAME, NULL);
#line 1150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_application_add_accelerator ((GtkApplication*) self, "<Shift><Primary>S", "win." CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME, NULL);
#line 1151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>Z", "win." CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME, NULL);
#line 1152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_application_add_accelerator ((GtkApplication*) self, "Pause", "win." CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME, NULL);
#line 6200 "gnome-chess.c"
}


static void chess_application_update_pause_resume_button (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	gboolean _tmp7_ = FALSE;
	ChessGame* _tmp8_ = NULL;
#line 1155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game;
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ != NULL) {
#line 6215 "gnome-chess.c"
		ChessGame* _tmp2_ = NULL;
		ChessClock* _tmp3_ = NULL;
		ChessClock* _tmp4_ = NULL;
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game;
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = chess_game_get_clock (_tmp2_);
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_;
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp4_ == NULL;
#line 6227 "gnome-chess.c"
	} else {
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 6231 "gnome-chess.c"
	}
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 6235 "gnome-chess.c"
		GtkButton* _tmp5_ = NULL;
#line 1158 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->pause_resume_button;
#line 1158 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_hide ((GtkWidget*) _tmp5_);
#line 6241 "gnome-chess.c"
	} else {
		GtkButton* _tmp6_ = NULL;
#line 1160 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->pause_resume_button;
#line 1160 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_show ((GtkWidget*) _tmp6_);
#line 6248 "gnome-chess.c"
	}
#line 1162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->game;
#line 1162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp8_ != NULL) {
#line 6254 "gnome-chess.c"
		ChessGame* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
#line 1162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = self->priv->game;
#line 1162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = chess_game_get_is_paused (_tmp9_);
#line 1162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp10_;
#line 1162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp11_;
#line 6266 "gnome-chess.c"
	} else {
#line 1162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = FALSE;
#line 6270 "gnome-chess.c"
	}
#line 1162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 6274 "gnome-chess.c"
		GtkButton* _tmp12_ = NULL;
		GtkImage* _tmp13_ = NULL;
		GtkImage* _tmp14_ = NULL;
		GtkButton* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 1164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->pause_resume_button;
#line 1164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-start-symbolic", GTK_ICON_SIZE_BUTTON);
#line 1164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_object_ref_sink (_tmp13_);
#line 1164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = _tmp13_;
#line 1164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_button_set_image (_tmp12_, (GtkWidget*) _tmp14_);
#line 1164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_tmp14_);
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = self->priv->pause_resume_button;
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _ ("Unpause the game");
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, _tmp16_);
#line 6298 "gnome-chess.c"
	} else {
		GtkButton* _tmp17_ = NULL;
		GtkImage* _tmp18_ = NULL;
		GtkImage* _tmp19_ = NULL;
		GtkButton* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
#line 1170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = self->priv->pause_resume_button;
#line 1170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-pause-symbolic", GTK_ICON_SIZE_BUTTON);
#line 1170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_object_ref_sink (_tmp18_);
#line 1170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = _tmp18_;
#line 1170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_button_set_image (_tmp17_, (GtkWidget*) _tmp19_);
#line 1170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_tmp19_);
#line 1172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = self->priv->pause_resume_button;
#line 1172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = _ ("Pause the game");
#line 1172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp20_, _tmp21_);
#line 6323 "gnome-chess.c"
	}
}


static void chess_application_game_end_cb (ChessApplication* self, ChessGame* game) {
	ChessEngine* _tmp0_ = NULL;
	gchar* title = NULL;
	gchar* _tmp2_ = NULL;
	ChessGame* _tmp3_ = NULL;
	ChessResult _tmp4_ = 0;
	gchar* reason = NULL;
	gchar* _tmp19_ = NULL;
	ChessGame* _tmp20_ = NULL;
	ChessRule _tmp21_ = 0;
	GtkHeaderBar* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	GtkHeaderBar* _tmp66_ = NULL;
	const gchar* _tmp67_ = NULL;
	GtkWidget* _tmp68_ = NULL;
	GtkWidget* _tmp69_ = NULL;
#line 1176 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1176 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (game != NULL);
#line 1178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_disable_window_action (self, CHESS_APPLICATION_RESIGN_ACTION_NAME);
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_disable_window_action (self, CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME);
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_disable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
#line 1183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_enable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
#line 1185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->game_needs_saving = FALSE;
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 6362 "gnome-chess.c"
		ChessEngine* _tmp1_ = NULL;
#line 1188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->opponent_engine;
#line 1188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_engine_stop (_tmp1_);
#line 6368 "gnome-chess.c"
	}
#line 1190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = g_strdup ("");
#line 1190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	title = _tmp2_;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = game;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_->result;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	switch (_tmp4_) {
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_WHITE_WON:
#line 6382 "gnome-chess.c"
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			PGNGame* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
#line 1195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp5_ = _ ("White Wins");
#line 1195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp6_ = g_strdup (_tmp5_);
#line 1195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			title = _tmp6_;
#line 1196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = self->priv->pgn_game;
#line 1196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = pgn_game_RESULT_WHITE;
#line 1196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_result (_tmp7_, _tmp8_);
#line 1197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 6404 "gnome-chess.c"
		}
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_BLACK_WON:
#line 6408 "gnome-chess.c"
		{
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			PGNGame* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
#line 1200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp9_ = _ ("Black Wins");
#line 1200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp10_ = g_strdup (_tmp9_);
#line 1200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			title = _tmp10_;
#line 1201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp11_ = self->priv->pgn_game;
#line 1201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = pgn_game_RESULT_BLACK;
#line 1201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_result (_tmp11_, _tmp12_);
#line 1202 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 6430 "gnome-chess.c"
		}
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_DRAW:
#line 6434 "gnome-chess.c"
		{
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			PGNGame* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = _ ("Game is Drawn");
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp14_ = g_strdup (_tmp13_);
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			title = _tmp14_;
#line 1206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp15_ = self->priv->pgn_game;
#line 1206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp16_ = pgn_game_RESULT_DRAW;
#line 1206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_result (_tmp15_, _tmp16_);
#line 1207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 6456 "gnome-chess.c"
		}
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_BUG:
#line 6460 "gnome-chess.c"
		{
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
#line 1217 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp17_ = _ ("Oops! Something has gone wrong.");
#line 1217 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp18_ = g_strdup (_tmp17_);
#line 1217 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1217 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			title = _tmp18_;
#line 1219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 6474 "gnome-chess.c"
		}
		default:
		{
#line 1221 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 6480 "gnome-chess.c"
		}
	}
#line 1224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = g_strdup ("");
#line 1224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	reason = _tmp19_;
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = game;
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = _tmp20_->rule;
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	switch (_tmp21_) {
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_CHECKMATE:
#line 6495 "gnome-chess.c"
		{
			ChessGame* _tmp22_ = NULL;
			ChessResult _tmp23_ = 0;
#line 1228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp22_ = game;
#line 1228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp23_ = _tmp22_->result;
#line 1228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp23_ == CHESS_RESULT_WHITE_WON) {
#line 6505 "gnome-chess.c"
				const gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp24_ = _ ("Black is in check and cannot move.");
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp25_ = g_strdup (_tmp24_);
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (reason);
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				reason = _tmp25_;
#line 6516 "gnome-chess.c"
			} else {
				ChessGame* _tmp26_ = NULL;
				ChessResult _tmp27_ = 0;
#line 1231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp26_ = game;
#line 1231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp27_ = _tmp26_->result;
#line 1231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp27_ == CHESS_RESULT_BLACK_WON) {
#line 6526 "gnome-chess.c"
					const gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
#line 1233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp28_ = _ ("White is in check and cannot move.");
#line 1233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp29_ = g_strdup (_tmp28_);
#line 1233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_free0 (reason);
#line 1233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					reason = _tmp29_;
#line 6537 "gnome-chess.c"
				} else {
#line 1235 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					g_assert_not_reached ();
#line 6541 "gnome-chess.c"
				}
			}
#line 1236 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 6546 "gnome-chess.c"
		}
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_STALEMATE:
#line 6550 "gnome-chess.c"
		{
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp30_ = _ ("Opponent cannot move.");
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp31_ = g_strdup (_tmp30_);
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp31_;
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 6564 "gnome-chess.c"
		}
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_FIFTY_MOVES:
#line 6568 "gnome-chess.c"
		{
			const gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
#line 1243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp32_ = _ ("No piece was taken or pawn moved in fifty moves.");
#line 1243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp33_ = g_strdup (_tmp32_);
#line 1243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp33_;
#line 1244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 6582 "gnome-chess.c"
		}
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_TIMEOUT:
#line 6586 "gnome-chess.c"
		{
			ChessGame* _tmp34_ = NULL;
			ChessResult _tmp35_ = 0;
#line 1246 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp34_ = game;
#line 1246 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp35_ = _tmp34_->result;
#line 1246 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp35_ == CHESS_RESULT_WHITE_WON) {
#line 6596 "gnome-chess.c"
				const gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
#line 1248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = _ ("Black has run out of time.");
#line 1248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp37_ = g_strdup (_tmp36_);
#line 1248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (reason);
#line 1248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				reason = _tmp37_;
#line 6607 "gnome-chess.c"
			} else {
				ChessGame* _tmp38_ = NULL;
				ChessResult _tmp39_ = 0;
#line 1249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp38_ = game;
#line 1249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = _tmp38_->result;
#line 1249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp39_ == CHESS_RESULT_BLACK_WON) {
#line 6617 "gnome-chess.c"
					const gchar* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
#line 1251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp40_ = _ ("White has run out of time.");
#line 1251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp41_ = g_strdup (_tmp40_);
#line 1251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_free0 (reason);
#line 1251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					reason = _tmp41_;
#line 6628 "gnome-chess.c"
				} else {
#line 1253 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					g_assert_not_reached ();
#line 6632 "gnome-chess.c"
				}
			}
#line 1254 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 6637 "gnome-chess.c"
		}
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_THREE_FOLD_REPETITION:
#line 6641 "gnome-chess.c"
		{
			const gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp42_ = _ ("The same board state has occurred three times.");
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp43_ = g_strdup (_tmp42_);
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp43_;
#line 1258 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 6655 "gnome-chess.c"
		}
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_INSUFFICIENT_MATERIAL:
#line 6659 "gnome-chess.c"
		{
			const gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
#line 1261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp44_ = _ ("Neither player can checkmate.");
#line 1261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp45_ = g_strdup (_tmp44_);
#line 1261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp45_;
#line 1262 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 6673 "gnome-chess.c"
		}
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_RESIGN:
#line 6677 "gnome-chess.c"
		{
			ChessGame* _tmp46_ = NULL;
			ChessResult _tmp47_ = 0;
#line 1264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp46_ = game;
#line 1264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = _tmp46_->result;
#line 1264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp47_ == CHESS_RESULT_WHITE_WON) {
#line 6687 "gnome-chess.c"
				const gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
#line 1266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp48_ = _ ("Black has resigned.");
#line 1266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp49_ = g_strdup (_tmp48_);
#line 1266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (reason);
#line 1266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				reason = _tmp49_;
#line 6698 "gnome-chess.c"
			} else {
				ChessGame* _tmp50_ = NULL;
				ChessResult _tmp51_ = 0;
#line 1267 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp50_ = game;
#line 1267 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp51_ = _tmp50_->result;
#line 1267 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp51_ == CHESS_RESULT_BLACK_WON) {
#line 6708 "gnome-chess.c"
					const gchar* _tmp52_ = NULL;
					gchar* _tmp53_ = NULL;
#line 1269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp52_ = _ ("White has resigned.");
#line 1269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp53_ = g_strdup (_tmp52_);
#line 1269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_free0 (reason);
#line 1269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					reason = _tmp53_;
#line 6719 "gnome-chess.c"
				} else {
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					g_assert_not_reached ();
#line 6723 "gnome-chess.c"
				}
			}
#line 1272 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 6728 "gnome-chess.c"
		}
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_ABANDONMENT:
#line 6732 "gnome-chess.c"
		{
			const gchar* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
			PGNGame* _tmp56_ = NULL;
			const gchar* _tmp57_ = NULL;
#line 1275 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp54_ = _ ("The game has been abandoned.");
#line 1275 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp55_ = g_strdup (_tmp54_);
#line 1275 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1275 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp55_;
#line 1276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp56_ = self->priv->pgn_game;
#line 1276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp57_ = pgn_game_TERMINATE_ABANDONED;
#line 1276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_termination (_tmp56_, _tmp57_);
#line 1277 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 6754 "gnome-chess.c"
		}
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_DEATH:
#line 6758 "gnome-chess.c"
		{
			const gchar* _tmp58_ = NULL;
			gchar* _tmp59_ = NULL;
			PGNGame* _tmp60_ = NULL;
			const gchar* _tmp61_ = NULL;
#line 1281 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp58_ = _ ("The game log says a player died!");
#line 1281 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp59_ = g_strdup (_tmp58_);
#line 1281 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1281 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp59_;
#line 1282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp60_ = self->priv->pgn_game;
#line 1282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp61_ = pgn_game_TERMINATE_DEATH;
#line 1282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_termination (_tmp60_, _tmp61_);
#line 1283 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 6780 "gnome-chess.c"
		}
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_BUG:
#line 6784 "gnome-chess.c"
		{
			const gchar* _tmp62_ = NULL;
			gchar* _tmp63_ = NULL;
#line 1287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp62_ = _ ("The computer player is confused. The game cannot continue.");
#line 1287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp63_ = g_strdup (_tmp62_);
#line 1287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp63_;
#line 1289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 6798 "gnome-chess.c"
		}
		default:
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		break;
#line 6803 "gnome-chess.c"
	}
#line 1292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp64_ = self->priv->headerbar;
#line 1292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp65_ = title;
#line 1292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_header_bar_set_title (_tmp64_, _tmp65_);
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp66_ = self->priv->headerbar;
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp67_ = reason;
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_header_bar_set_subtitle (_tmp66_, _tmp67_);
#line 1295 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp68_ = self->priv->white_time_label;
#line 1295 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp68_);
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp69_ = self->priv->black_time_label;
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp69_);
#line 1176 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (reason);
#line 1176 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (title);
#line 6829 "gnome-chess.c"
}


void chess_application_show (ChessApplication* self) {
	GtkApplicationWindow* _tmp0_ = NULL;
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1301 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 1301 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 6841 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT gnome_chess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self) {
	gboolean result = FALSE;
#line 1305 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1305 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1305 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1307 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_quit_game (self);
#line 1308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 6859 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT gnome_chess_app_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, ChessApplication* self) {
	gboolean result = FALSE;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1314 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 1314 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "maximized");
#line 1314 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp1_) {
#line 6879 "gnome-chess.c"
		GSettings* _tmp2_ = NULL;
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		GSettings* _tmp5_ = NULL;
		GdkEventConfigure* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 1316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->settings;
#line 1316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = event;
#line 1316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_->width;
#line 1316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_settings_set_int (_tmp2_, "width", _tmp4_);
#line 1317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->settings;
#line 1317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = event;
#line 1317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp6_->height;
#line 1317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_settings_set_int (_tmp5_, "height", _tmp7_);
#line 6902 "gnome-chess.c"
	}
#line 1320 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1320 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 6908 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT gnome_chess_app_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, ChessApplication* self) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
#line 1324 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1324 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1324 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1326 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = event;
#line 1326 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 1326 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 6928 "gnome-chess.c"
		gboolean is_maximized = FALSE;
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
		GSettings* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 1328 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = event;
#line 1328 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 1328 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->settings;
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = is_maximized;
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_settings_set_boolean (_tmp4_, "maximized", _tmp5_);
#line 6946 "gnome-chess.c"
	}
#line 1332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 6952 "gnome-chess.c"
}


static gboolean chess_application_prompt_save_game (ChessApplication* self, const gchar* prompt_text) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkMessageDialog* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	ChessGame* _tmp6_ = NULL;
	ChessResult _tmp7_ = 0;
	gint _result_ = 0;
	GtkMessageDialog* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GtkMessageDialog* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gint _tmp20_ = 0;
#line 1335 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1335 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (prompt_text != NULL, FALSE);
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game_needs_saving;
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp0_) {
#line 1338 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = TRUE;
#line 1338 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 6985 "gnome-chess.c"
	}
#line 1340 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->window;
#line 1340 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = prompt_text;
#line 1340 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp1_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp2_);
#line 1340 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp3_);
#line 1340 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	dialog = _tmp3_;
#line 1345 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = dialog;
#line 1345 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _ ("_Cancel");
#line 1345 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp4_, _tmp5_, (gint) GTK_RESPONSE_CANCEL);
#line 1347 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->game;
#line 1347 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _tmp6_->result;
#line 1347 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_ == CHESS_RESULT_IN_PROGRESS) {
#line 7009 "gnome-chess.c"
		GtkMessageDialog* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GtkMessageDialog* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 1349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = dialog;
#line 1349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _ ("_Abandon game");
#line 1349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp8_, _tmp9_, (gint) GTK_RESPONSE_NO);
#line 1350 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = dialog;
#line 1350 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _ ("_Save game for later");
#line 1350 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp10_, _tmp11_, (gint) GTK_RESPONSE_YES);
#line 7026 "gnome-chess.c"
	} else {
		GtkMessageDialog* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GtkMessageDialog* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 1354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = dialog;
#line 1354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = _ ("_Discard game");
#line 1354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp12_, _tmp13_, (gint) GTK_RESPONSE_NO);
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = dialog;
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _ ("_Save game log");
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp14_, _tmp15_, (gint) GTK_RESPONSE_YES);
#line 7044 "gnome-chess.c"
	}
#line 1358 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = dialog;
#line 1358 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = gtk_dialog_run ((GtkDialog*) _tmp16_);
#line 1358 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_result_ = _tmp17_;
#line 1359 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = dialog;
#line 1359 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp18_);
#line 1361 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = _result_;
#line 1361 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp20_ == ((gint) GTK_RESPONSE_CANCEL)) {
#line 1361 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = TRUE;
#line 7062 "gnome-chess.c"
	} else {
		gint _tmp21_ = 0;
#line 1361 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = _result_;
#line 1361 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = _tmp21_ == ((gint) GTK_RESPONSE_DELETE_EVENT);
#line 7069 "gnome-chess.c"
	}
#line 1361 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp19_) {
#line 1363 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = FALSE;
#line 1363 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (dialog);
#line 1363 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 7079 "gnome-chess.c"
	} else {
		gint _tmp22_ = 0;
#line 1365 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = _result_;
#line 1365 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp22_ == ((gint) GTK_RESPONSE_YES)) {
#line 7086 "gnome-chess.c"
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp23_ = _ ("_Discard");
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp24_ = _ ("_Save");
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_present_save_dialog (self, _tmp23_, _tmp24_);
#line 7095 "gnome-chess.c"
		} else {
			gint _tmp25_ = 0;
#line 1372 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp25_ = _result_;
#line 1372 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_warn_if_fail (_tmp25_ == ((gint) GTK_RESPONSE_NO));
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->game_needs_saving = FALSE;
#line 1375 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_autosave (self);
#line 7106 "gnome-chess.c"
		}
	}
#line 1378 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = TRUE;
#line 1378 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (dialog);
#line 1378 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 7115 "gnome-chess.c"
}


static void chess_application_present_claim_draw_dialog (ChessApplication* self) {
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ChessGame* _tmp2_ = NULL;
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkMessageDialog* _tmp5_ = NULL;
	gchar* reason = NULL;
	ChessGame* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GtkMessageDialog* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkMessageDialog* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gint response = 0;
	GtkMessageDialog* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	GtkMessageDialog* _tmp22_ = NULL;
	gint _tmp23_ = 0;
#line 1381 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1381 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 1381 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_can_claim_draw (_tmp0_);
#line 1381 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (_tmp1_);
#line 1384 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->game;
#line 1384 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_game_pause (_tmp2_, FALSE);
#line 1386 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->window;
#line 1386 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _ ("Would you like to claim a draw?");
#line 1386 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp3_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp4_);
#line 1386 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp5_);
#line 1386 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	dialog = _tmp5_;
#line 1394 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->game;
#line 1394 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = chess_game_is_fifty_move_rule_fulfilled (_tmp6_);
#line 1394 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 7169 "gnome-chess.c"
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1397 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = _ ("Fifty moves have passed without a capture or pawn advancement.");
#line 1397 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 1397 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (reason);
#line 1397 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		reason = _tmp9_;
#line 7180 "gnome-chess.c"
	} else {
		ChessGame* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 1399 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->game;
#line 1399 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = chess_game_is_three_fold_repeat (_tmp10_);
#line 1399 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp11_) {
#line 7190 "gnome-chess.c"
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
#line 1402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = _ ("The current board position has occurred three times.");
#line 1402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = g_strdup (_tmp12_);
#line 1402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp13_;
#line 7201 "gnome-chess.c"
		} else {
#line 1404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_assert_not_reached ();
#line 7205 "gnome-chess.c"
		}
	}
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = dialog;
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = reason;
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = _ ("(You will not be offered this choice again.)");
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_message_dialog_format_secondary_text (_tmp14_, "%s\n%s", _tmp15_, _tmp16_);
#line 1410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = dialog;
#line 1410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = _ ("_Keep Playing");
#line 1410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = _ ("_Claim Draw");
#line 1410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_add_buttons ((GtkDialog*) _tmp17_, _tmp18_, GTK_RESPONSE_REJECT, _tmp19_, GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 1416 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = dialog;
#line 1416 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = gtk_dialog_run ((GtkDialog*) _tmp20_);
#line 1416 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	response = _tmp21_;
#line 1417 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = dialog;
#line 1417 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp22_);
#line 1419 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = response;
#line 1419 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp23_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 7238 "gnome-chess.c"
		ChessGame* _tmp24_ = NULL;
		ChessPlayer* _tmp25_ = NULL;
		ChessPlayer* _tmp26_ = NULL;
#line 1421 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = self->priv->game;
#line 1421 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = chess_game_get_current_player (_tmp24_);
#line 1421 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = _tmp25_;
#line 1421 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_player_claim_draw (_tmp26_);
#line 7250 "gnome-chess.c"
	} else {
		ChessGame* _tmp27_ = NULL;
#line 1426 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->allow_claim_draw_dialog = FALSE;
#line 1427 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = self->priv->game;
#line 1427 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_game_unpause (_tmp27_);
#line 7259 "gnome-chess.c"
	}
#line 1381 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (reason);
#line 1381 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (dialog);
#line 7265 "gnome-chess.c"
}


void chess_application_new_game_cb (ChessApplication* self) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1431 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = _ ("Save this game before starting a new one?");
#line 1433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_application_prompt_save_game (self, _tmp0_);
#line 1433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_) {
#line 1434 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_start_new_game (self);
#line 7282 "gnome-chess.c"
	}
}


void chess_application_resign_cb (ChessApplication* self) {
	ChessGame* _tmp0_ = NULL;
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkMessageDialog* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkMessageDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gint response = 0;
	GtkMessageDialog* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GtkMessageDialog* _tmp11_ = NULL;
	gint _tmp12_ = 0;
#line 1437 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 1439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_game_pause (_tmp0_, FALSE);
#line 1441 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->window;
#line 1441 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _ ("Are you sure you want to resign?");
#line 1441 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp1_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp2_);
#line 1441 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp3_);
#line 1441 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	dialog = _tmp3_;
#line 1447 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = dialog;
#line 1447 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _ ("This makes sense if you plan to save the game as a record of your loss" \
".");
#line 1447 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_message_dialog_format_secondary_text (_tmp4_, "%s", _tmp5_);
#line 1450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = dialog;
#line 1450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _ ("_Keep Playing");
#line 1450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _ ("_Resign");
#line 1450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_add_buttons ((GtkDialog*) _tmp6_, _tmp7_, GTK_RESPONSE_REJECT, _tmp8_, GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 1456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = dialog;
#line 1456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = gtk_dialog_run ((GtkDialog*) _tmp9_);
#line 1456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	response = _tmp10_;
#line 1457 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = dialog;
#line 1457 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp11_);
#line 1459 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = response;
#line 1459 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 7347 "gnome-chess.c"
		ChessPlayer* _tmp13_ = NULL;
#line 1461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->human_player;
#line 1461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp13_ != NULL) {
#line 7353 "gnome-chess.c"
			ChessPlayer* _tmp14_ = NULL;
#line 1462 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp14_ = self->priv->human_player;
#line 1462 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_player_resign (_tmp14_);
#line 7359 "gnome-chess.c"
		} else {
			ChessGame* _tmp15_ = NULL;
			ChessPlayer* _tmp16_ = NULL;
			ChessPlayer* _tmp17_ = NULL;
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp15_ = self->priv->game;
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp16_ = chess_game_get_current_player (_tmp15_);
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp17_ = _tmp16_;
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_player_resign (_tmp17_);
#line 7372 "gnome-chess.c"
		}
	} else {
		ChessGame* _tmp18_ = NULL;
#line 1468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = self->priv->game;
#line 1468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_game_unpause (_tmp18_);
#line 7380 "gnome-chess.c"
	}
#line 1437 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (dialog);
#line 7384 "gnome-chess.c"
}


void chess_application_undo_move_cb (ChessApplication* self) {
	ChessPlayer* _tmp0_ = NULL;
#line 1472 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1474 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent;
#line 1474 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 7396 "gnome-chess.c"
		ChessPlayer* _tmp1_ = NULL;
#line 1475 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->human_player;
#line 1475 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_player_undo (_tmp1_);
#line 7402 "gnome-chess.c"
	} else {
		ChessGame* _tmp2_ = NULL;
		ChessPlayer* _tmp3_ = NULL;
		ChessPlayer* _tmp4_ = NULL;
#line 1477 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game;
#line 1477 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = chess_game_get_opponent (_tmp2_);
#line 1477 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_;
#line 1477 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_player_undo (_tmp4_);
#line 7415 "gnome-chess.c"
	}
}


void chess_application_pause_resume_cb (ChessApplication* self) {
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 1480 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1482 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 1482 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
#line 1482 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1482 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_) {
#line 7434 "gnome-chess.c"
		ChessGame* _tmp3_ = NULL;
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->game;
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_game_unpause (_tmp3_);
#line 7440 "gnome-chess.c"
	} else {
		ChessGame* _tmp4_ = NULL;
#line 1485 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->game;
#line 1485 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_game_pause (_tmp4_, TRUE);
#line 7447 "gnome-chess.c"
	}
#line 1487 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_pause_resume_button (self);
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_history_panel (self);
#line 1489 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_action_status (self);
#line 7455 "gnome-chess.c"
}


void chess_application_quit_cb (ChessApplication* self) {
#line 1492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1494 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_quit_game (self);
#line 7464 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT white_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self) {
	gboolean result = FALSE;
	gdouble fg[3] = {0};
	gdouble _tmp0_[3] = {0};
	gdouble bg[3] = {0};
	gdouble _tmp1_[3] = {0};
	GtkWidget* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessClock* _tmp5_ = NULL;
	ChessClock* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 1498 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1498 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1498 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 1500 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_[0] = 0.0;
#line 1500 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_[1] = 0.0;
#line 1500 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_[2] = 0.0;
#line 1500 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_[0] = 1.0;
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_[1] = 1.0;
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_[2] = 1.0;
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
#line 1503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = widget;
#line 1503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = c;
#line 1503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->game;
#line 1503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = chess_game_get_clock (_tmp4_);
#line 1503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_;
#line 1503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = chess_application_make_clock_text (self, _tmp6_, COLOR_WHITE);
#line 1503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_;
#line 1503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
#line 1503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp8_);
#line 1504 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1504 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 7525 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT black_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self) {
	gboolean result = FALSE;
	gdouble fg[3] = {0};
	gdouble _tmp0_[3] = {0};
	gdouble bg[3] = {0};
	gdouble _tmp1_[3] = {0};
	GtkWidget* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessClock* _tmp5_ = NULL;
	ChessClock* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 1508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 1510 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_[0] = 1.0;
#line 1510 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_[1] = 1.0;
#line 1510 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_[2] = 1.0;
#line 1510 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
#line 1511 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_[0] = 0.0;
#line 1511 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_[1] = 0.0;
#line 1511 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_[2] = 0.0;
#line 1511 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = widget;
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = c;
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->game;
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = chess_game_get_clock (_tmp4_);
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_;
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = chess_application_make_clock_text (self, _tmp6_, COLOR_BLACK);
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_;
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp8_);
#line 1514 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1514 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 7586 "gnome-chess.c"
}


static gchar* chess_application_make_clock_text (ChessApplication* self, ChessClock* clock, Color color) {
	gchar* result = NULL;
	ChessClock* _tmp0_ = NULL;
	gint time = 0;
	Color _tmp2_ = 0;
	gint _tmp23_ = 0;
#line 1517 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1519 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = clock;
#line 1519 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == NULL) {
#line 7602 "gnome-chess.c"
		gchar* _tmp1_ = NULL;
#line 1520 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = g_strdup ("∞");
#line 1520 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = _tmp1_;
#line 1520 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 7610 "gnome-chess.c"
	}
#line 1523 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = color;
#line 1523 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 7616 "gnome-chess.c"
		ChessGame* _tmp3_ = NULL;
		ChessClock* _tmp4_ = NULL;
		ChessClock* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		ChessGame* _tmp8_ = NULL;
		ChessClock* _tmp9_ = NULL;
		ChessClock* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->game;
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = chess_game_get_clock (_tmp3_);
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = chess_clock_get_white_initial_seconds (_tmp5_);
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp6_;
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = self->priv->game;
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = chess_game_get_clock (_tmp8_);
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp9_;
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = chess_clock_get_white_seconds_used (_tmp10_);
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = _tmp11_;
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		time = _tmp7_ - _tmp12_;
#line 7649 "gnome-chess.c"
	} else {
		ChessGame* _tmp13_ = NULL;
		ChessClock* _tmp14_ = NULL;
		ChessClock* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		ChessGame* _tmp18_ = NULL;
		ChessClock* _tmp19_ = NULL;
		ChessClock* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->game;
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = chess_game_get_clock (_tmp13_);
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _tmp14_;
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = chess_clock_get_black_initial_seconds (_tmp15_);
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _tmp16_;
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = self->priv->game;
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = chess_game_get_clock (_tmp18_);
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp19_;
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = chess_clock_get_black_seconds_used (_tmp20_);
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = _tmp21_;
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		time = _tmp17_ - _tmp22_;
#line 7683 "gnome-chess.c"
	}
#line 1528 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = time;
#line 1528 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp23_ >= 60) {
#line 7689 "gnome-chess.c"
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gchar* _tmp26_ = NULL;
#line 1529 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = time;
#line 1529 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = time;
#line 1529 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = g_strdup_printf ("%d∶\xE2\x80\x8E%02d", _tmp24_ / 60, _tmp25_ % 60);
#line 1529 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = _tmp26_;
#line 1529 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 7703 "gnome-chess.c"
	} else {
		gint _tmp27_ = 0;
		gchar* _tmp28_ = NULL;
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = time;
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = g_strdup_printf ("∶\xE2\x80\x8E%02d", _tmp27_);
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = _tmp28_;
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 7715 "gnome-chess.c"
	}
}


static gint chess_application_compute_time_label_width_request (ChessApplication* self, cairo_t* c) {
	gint result = 0;
	cairo_text_extents_t extents = {0};
	gdouble max = 0.0;
	cairo_t* _tmp0_ = NULL;
	cairo_text_extents_t _tmp1_ = {0};
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	cairo_text_extents_t _tmp4_ = {0};
	gdouble _tmp5_ = 0.0;
	cairo_t* _tmp9_ = NULL;
	cairo_text_extents_t _tmp10_ = {0};
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	cairo_text_extents_t _tmp13_ = {0};
	gdouble _tmp14_ = 0.0;
	cairo_t* _tmp18_ = NULL;
	cairo_text_extents_t _tmp19_ = {0};
	gdouble _tmp20_ = 0.0;
	gdouble _tmp21_ = 0.0;
	cairo_text_extents_t _tmp22_ = {0};
	gdouble _tmp23_ = 0.0;
	cairo_t* _tmp27_ = NULL;
	cairo_text_extents_t _tmp28_ = {0};
	gdouble _tmp29_ = 0.0;
	gdouble _tmp30_ = 0.0;
	cairo_text_extents_t _tmp31_ = {0};
	gdouble _tmp32_ = 0.0;
	cairo_t* _tmp36_ = NULL;
	cairo_text_extents_t _tmp37_ = {0};
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_ = 0.0;
	cairo_text_extents_t _tmp40_ = {0};
	gdouble _tmp41_ = 0.0;
	cairo_t* _tmp45_ = NULL;
	cairo_text_extents_t _tmp46_ = {0};
	gdouble _tmp47_ = 0.0;
	gdouble _tmp48_ = 0.0;
	cairo_text_extents_t _tmp49_ = {0};
	gdouble _tmp50_ = 0.0;
	cairo_t* _tmp54_ = NULL;
	cairo_text_extents_t _tmp55_ = {0};
	gdouble _tmp56_ = 0.0;
	gdouble _tmp57_ = 0.0;
	cairo_text_extents_t _tmp58_ = {0};
	gdouble _tmp59_ = 0.0;
	cairo_t* _tmp63_ = NULL;
	cairo_text_extents_t _tmp64_ = {0};
	gdouble _tmp65_ = 0.0;
	gdouble _tmp66_ = 0.0;
	cairo_text_extents_t _tmp67_ = {0};
	gdouble _tmp68_ = 0.0;
	cairo_t* _tmp72_ = NULL;
	cairo_text_extents_t _tmp73_ = {0};
	gdouble _tmp74_ = 0.0;
	gdouble _tmp75_ = 0.0;
	cairo_text_extents_t _tmp76_ = {0};
	gdouble _tmp77_ = 0.0;
	cairo_t* _tmp81_ = NULL;
	cairo_text_extents_t _tmp82_ = {0};
	gdouble _tmp83_ = 0.0;
	gdouble _tmp84_ = 0.0;
	cairo_text_extents_t _tmp85_ = {0};
	gdouble _tmp86_ = 0.0;
	gdouble _tmp90_ = 0.0;
	gdouble _tmp91_ = 0.0;
	gint _tmp92_ = 0;
	gint _tmp93_ = 0;
#line 1539 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1539 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (c != NULL, 0);
#line 1543 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = (gdouble) 0;
#line 1545 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = c;
#line 1545 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp0_, "000∶00", &_tmp1_);
#line 1545 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp1_;
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = max;
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = extents;
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_.width;
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp3_ > _tmp5_) {
#line 7808 "gnome-chess.c"
		gdouble _tmp6_ = 0.0;
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = max;
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = _tmp6_;
#line 7814 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp7_ = {0};
		gdouble _tmp8_ = 0.0;
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = extents;
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = _tmp7_.width;
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = _tmp8_;
#line 7824 "gnome-chess.c"
	}
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp2_;
#line 1547 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = c;
#line 1547 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp9_, "111∶11", &_tmp10_);
#line 1547 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp10_;
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = max;
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = extents;
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = _tmp13_.width;
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ > _tmp14_) {
#line 7842 "gnome-chess.c"
		gdouble _tmp15_ = 0.0;
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = max;
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp15_;
#line 7848 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp16_ = {0};
		gdouble _tmp17_ = 0.0;
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = extents;
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _tmp16_.width;
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp17_;
#line 7858 "gnome-chess.c"
	}
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp11_;
#line 1549 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = c;
#line 1549 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp18_, "222∶22", &_tmp19_);
#line 1549 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp19_;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = max;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = extents;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = _tmp22_.width;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp21_ > _tmp23_) {
#line 7876 "gnome-chess.c"
		gdouble _tmp24_ = 0.0;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = max;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp24_;
#line 7882 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp25_ = {0};
		gdouble _tmp26_ = 0.0;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = extents;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = _tmp25_.width;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp26_;
#line 7892 "gnome-chess.c"
	}
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp20_;
#line 1551 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = c;
#line 1551 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp27_, "333∶33", &_tmp28_);
#line 1551 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp28_;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = max;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = extents;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _tmp31_.width;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp30_ > _tmp32_) {
#line 7910 "gnome-chess.c"
		gdouble _tmp33_ = 0.0;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp33_ = max;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = _tmp33_;
#line 7916 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp34_ = {0};
		gdouble _tmp35_ = 0.0;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp34_ = extents;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp35_ = _tmp34_.width;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = _tmp35_;
#line 7926 "gnome-chess.c"
	}
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp29_;
#line 1553 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = c;
#line 1553 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp36_, "444∶44", &_tmp37_);
#line 1553 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp37_;
#line 1554 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = max;
#line 1554 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = extents;
#line 1554 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = _tmp40_.width;
#line 1554 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp39_ > _tmp41_) {
#line 7944 "gnome-chess.c"
		gdouble _tmp42_ = 0.0;
#line 1554 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp42_ = max;
#line 1554 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = _tmp42_;
#line 7950 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp43_ = {0};
		gdouble _tmp44_ = 0.0;
#line 1554 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp43_ = extents;
#line 1554 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp44_ = _tmp43_.width;
#line 1554 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = _tmp44_;
#line 7960 "gnome-chess.c"
	}
#line 1554 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp38_;
#line 1555 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = c;
#line 1555 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp45_, "555∶55", &_tmp46_);
#line 1555 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp46_;
#line 1556 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp48_ = max;
#line 1556 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp49_ = extents;
#line 1556 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp50_ = _tmp49_.width;
#line 1556 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp48_ > _tmp50_) {
#line 7978 "gnome-chess.c"
		gdouble _tmp51_ = 0.0;
#line 1556 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp51_ = max;
#line 1556 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp47_ = _tmp51_;
#line 7984 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp52_ = {0};
		gdouble _tmp53_ = 0.0;
#line 1556 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp52_ = extents;
#line 1556 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp53_ = _tmp52_.width;
#line 1556 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp47_ = _tmp53_;
#line 7994 "gnome-chess.c"
	}
#line 1556 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp47_;
#line 1557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = c;
#line 1557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp54_, "666∶66", &_tmp55_);
#line 1557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp55_;
#line 1558 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp57_ = max;
#line 1558 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = extents;
#line 1558 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = _tmp58_.width;
#line 1558 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp57_ > _tmp59_) {
#line 8012 "gnome-chess.c"
		gdouble _tmp60_ = 0.0;
#line 1558 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp60_ = max;
#line 1558 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp56_ = _tmp60_;
#line 8018 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp61_ = {0};
		gdouble _tmp62_ = 0.0;
#line 1558 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp61_ = extents;
#line 1558 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp62_ = _tmp61_.width;
#line 1558 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp56_ = _tmp62_;
#line 8028 "gnome-chess.c"
	}
#line 1558 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp56_;
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp63_ = c;
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp63_, "777∶77", &_tmp64_);
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp64_;
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp66_ = max;
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp67_ = extents;
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp68_ = _tmp67_.width;
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp66_ > _tmp68_) {
#line 8046 "gnome-chess.c"
		gdouble _tmp69_ = 0.0;
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp69_ = max;
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp65_ = _tmp69_;
#line 8052 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp70_ = {0};
		gdouble _tmp71_ = 0.0;
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp70_ = extents;
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp71_ = _tmp70_.width;
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp65_ = _tmp71_;
#line 8062 "gnome-chess.c"
	}
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp65_;
#line 1561 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp72_ = c;
#line 1561 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp72_, "888∶88", &_tmp73_);
#line 1561 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp73_;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp75_ = max;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp76_ = extents;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp77_ = _tmp76_.width;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp75_ > _tmp77_) {
#line 8080 "gnome-chess.c"
		gdouble _tmp78_ = 0.0;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp78_ = max;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp74_ = _tmp78_;
#line 8086 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp79_ = {0};
		gdouble _tmp80_ = 0.0;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp79_ = extents;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp80_ = _tmp79_.width;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp74_ = _tmp80_;
#line 8096 "gnome-chess.c"
	}
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp74_;
#line 1563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp81_ = c;
#line 1563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp81_, "999∶99", &_tmp82_);
#line 1563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp82_;
#line 1564 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = max;
#line 1564 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp85_ = extents;
#line 1564 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = _tmp85_.width;
#line 1564 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp84_ > _tmp86_) {
#line 8114 "gnome-chess.c"
		gdouble _tmp87_ = 0.0;
#line 1564 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp87_ = max;
#line 1564 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp83_ = _tmp87_;
#line 8120 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp88_ = {0};
		gdouble _tmp89_ = 0.0;
#line 1564 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp88_ = extents;
#line 1564 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp89_ = _tmp88_.width;
#line 1564 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp83_ = _tmp89_;
#line 8130 "gnome-chess.c"
	}
#line 1564 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp83_;
#line 1567 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = max;
#line 1567 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp91_ = ceil (_tmp90_);
#line 1567 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = ((gint) _tmp91_) + 6;
#line 1567 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp92_ = result;
#line 1567 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_warn_if_fail (_tmp92_ > 0);
#line 1567 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 8146 "gnome-chess.c"
}


static void chess_application_draw_time (ChessApplication* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1) {
	gdouble alpha = 0.0;
	GtkWidget* _tmp0_ = NULL;
	GtkStateFlags _tmp1_ = 0;
	cairo_t* _tmp2_ = NULL;
	gdouble* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gdouble _tmp4_ = 0.0;
	gdouble* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gdouble _tmp6_ = 0.0;
	gdouble* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	cairo_t* _tmp10_ = NULL;
	cairo_t* _tmp11_ = NULL;
	gdouble* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gdouble _tmp13_ = 0.0;
	gdouble* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gdouble _tmp15_ = 0.0;
	gdouble* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	cairo_t* _tmp19_ = NULL;
	cairo_t* _tmp20_ = NULL;
	GtkWidget* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	cairo_text_extents_t extents = {0};
	cairo_t* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	cairo_text_extents_t _tmp25_ = {0};
	cairo_t* _tmp26_ = NULL;
	GtkWidget* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	cairo_text_extents_t _tmp29_ = {0};
	gdouble _tmp30_ = 0.0;
	cairo_text_extents_t _tmp31_ = {0};
	gdouble _tmp32_ = 0.0;
	GtkWidget* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	cairo_text_extents_t _tmp35_ = {0};
	gdouble _tmp36_ = 0.0;
	cairo_text_extents_t _tmp37_ = {0};
	gdouble _tmp38_ = 0.0;
	cairo_t* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	gint width = 0;
	GtkWidget* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
#line 1570 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1570 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1570 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (c != NULL);
#line 1570 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (text != NULL);
#line 1572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	alpha = 1.0;
#line 1574 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = widget;
#line 1574 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_widget_get_state_flags (_tmp0_);
#line 1574 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if ((_tmp1_ & GTK_STATE_FLAG_INSENSITIVE) != 0) {
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		alpha = 0.5;
#line 8222 "gnome-chess.c"
	}
#line 1576 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = c;
#line 1576 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = bg;
#line 1576 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3__length1 = bg_length1;
#line 1576 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_[0];
#line 1576 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = bg;
#line 1576 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5__length1 = bg_length1;
#line 1576 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_[1];
#line 1576 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = bg;
#line 1576 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7__length1 = bg_length1;
#line 1576 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_[2];
#line 1576 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = alpha;
#line 1576 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_set_source_rgba (_tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp9_);
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = c;
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_paint (_tmp10_);
#line 1579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = c;
#line 1579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = fg;
#line 1579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12__length1 = fg_length1;
#line 1579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = _tmp12_[0];
#line 1579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = fg;
#line 1579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14__length1 = fg_length1;
#line 1579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = _tmp14_[1];
#line 1579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = fg;
#line 1579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16__length1 = fg_length1;
#line 1579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = _tmp16_[2];
#line 1579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = alpha;
#line 1579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_set_source_rgba (_tmp11_, _tmp13_, _tmp15_, _tmp17_, _tmp18_);
#line 1580 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = c;
#line 1580 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_select_font_face (_tmp19_, "fixed", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = c;
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = widget;
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = gtk_widget_get_allocated_height (_tmp21_);
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_set_font_size (_tmp20_, 0.6 * _tmp22_);
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = c;
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = text;
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp23_, _tmp24_, &_tmp25_);
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp25_;
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = c;
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = widget;
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = gtk_widget_get_allocated_width (_tmp27_);
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = extents;
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = _tmp29_.width;
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = extents;
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _tmp31_.x_bearing;
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = widget;
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = gtk_widget_get_allocated_height (_tmp33_);
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = extents;
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = _tmp35_.height;
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = extents;
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = _tmp37_.y_bearing;
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_move_to (_tmp26_, ((_tmp28_ - _tmp30_) / 2) - _tmp32_, ((_tmp34_ - _tmp36_) / 2) - _tmp38_);
#line 1586 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = c;
#line 1586 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = text;
#line 1586 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_show_text (_tmp39_, _tmp40_);
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = widget;
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_get_size_request (_tmp41_, &_tmp42_, NULL);
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	width = _tmp42_;
#line 1590 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = width;
#line 1590 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp43_ == (-1)) {
#line 8340 "gnome-chess.c"
		GtkWidget* _tmp44_ = NULL;
		cairo_t* _tmp45_ = NULL;
		gint _tmp46_ = 0;
#line 1591 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp44_ = widget;
#line 1591 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp45_ = c;
#line 1591 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp46_ = chess_application_compute_time_label_width_request (self, _tmp45_);
#line 1591 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_size_request (_tmp44_, _tmp46_, -1);
#line 8352 "gnome-chess.c"
	}
}


void G_MODULE_EXPORT history_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint move_number = 0;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	ChessGame* _tmp8_ = NULL;
	ChessScene* _tmp13_ = NULL;
	gint _tmp14_ = 0;
#line 1595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1599 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 8385 "gnome-chess.c"
	}
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &move_number, -1, -1);
#line 1602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->game;
#line 1602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp8_ == NULL) {
#line 1602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = TRUE;
#line 8403 "gnome-chess.c"
	} else {
		gint _tmp9_ = 0;
		ChessGame* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		guint _tmp12_ = 0U;
#line 1602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = move_number;
#line 1602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->game;
#line 1602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = chess_game_get_n_moves (_tmp10_);
#line 1602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = _tmp11_;
#line 1602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = ((guint) _tmp9_) == _tmp12_;
#line 8419 "gnome-chess.c"
	}
#line 1602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 1603 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		move_number = -1;
#line 8425 "gnome-chess.c"
	}
#line 1604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->scene;
#line 1604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = move_number;
#line 1604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp13_, _tmp14_);
#line 8433 "gnome-chess.c"
}


void G_MODULE_EXPORT history_latest_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_ = NULL;
#line 1608 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1608 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1610 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1610 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp0_, -1);
#line 8447 "gnome-chess.c"
}


void G_MODULE_EXPORT history_next_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint move_number = 0;
	ChessScene* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	ChessGame* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
#line 1614 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1614 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1616 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1616 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
#line 1616 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1616 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ == (-1)) {
#line 1617 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 8477 "gnome-chess.c"
	}
#line 1619 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->scene;
#line 1619 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
#line 1619 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1619 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	move_number = _tmp5_ + 1;
#line 1620 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = move_number;
#line 1620 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->game;
#line 1620 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = chess_game_get_n_moves (_tmp7_);
#line 1620 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _tmp8_;
#line 1620 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (((guint) _tmp6_) >= _tmp9_) {
#line 8497 "gnome-chess.c"
		ChessScene* _tmp10_ = NULL;
#line 1621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->scene;
#line 1621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp10_, -1);
#line 8503 "gnome-chess.c"
	} else {
		ChessScene* _tmp11_ = NULL;
		gint _tmp12_ = 0;
#line 1623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = self->priv->scene;
#line 1623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = move_number;
#line 1623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp11_, _tmp12_);
#line 8513 "gnome-chess.c"
	}
}


void G_MODULE_EXPORT history_previous_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ChessScene* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 1627 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1627 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1629 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1629 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
#line 1629 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1629 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ == 0) {
#line 1630 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 8539 "gnome-chess.c"
	}
#line 1632 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->scene;
#line 1632 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
#line 1632 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1632 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp5_ == (-1)) {
#line 8549 "gnome-chess.c"
		ChessScene* _tmp6_ = NULL;
		ChessGame* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->scene;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->game;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = chess_game_get_n_moves (_tmp7_);
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _tmp8_;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp6_, ((gint) _tmp9_) - 1);
#line 8564 "gnome-chess.c"
	} else {
		ChessScene* _tmp10_ = NULL;
		ChessScene* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->scene;
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = self->priv->scene;
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = chess_scene_get_move_number (_tmp11_);
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = _tmp12_;
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp10_, _tmp13_ - 1);
#line 8580 "gnome-chess.c"
	}
}


void G_MODULE_EXPORT history_start_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_ = NULL;
#line 1639 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1639 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp0_, 0);
#line 8595 "gnome-chess.c"
}


void chess_application_preferences_cb (ChessApplication* self) {
	GtkDialog* _tmp0_ = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkDialog* _tmp11_ = NULL;
	GtkApplicationWindow* _tmp12_ = NULL;
	GSettings* _tmp13_ = NULL;
	GtkBuilder* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	GSettings* _tmp16_ = NULL;
	GtkBuilder* _tmp17_ = NULL;
	GObject* _tmp18_ = NULL;
	GtkBuilder* _tmp19_ = NULL;
	GObject* _tmp20_ = NULL;
	GtkComboBox* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	GSettings* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	GtkComboBox* _tmp25_ = NULL;
	GtkComboBox* ai_combo = NULL;
	GtkBuilder* _tmp26_ = NULL;
	GObject* _tmp27_ = NULL;
	GtkComboBox* _tmp28_ = NULL;
	GtkListStore* ai_model = NULL;
	GtkComboBox* _tmp29_ = NULL;
	GtkTreeModel* _tmp30_ = NULL;
	GtkTreeModel* _tmp31_ = NULL;
	GtkListStore* _tmp32_ = NULL;
	gchar* opponent_name = NULL;
	GSettings* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	GList* _tmp37_ = NULL;
	GtkComboBox* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	GtkBuilder* _tmp64_ = NULL;
	GObject* _tmp65_ = NULL;
	GtkComboBox* _tmp66_ = NULL;
	GtkComboBox* _tmp67_ = NULL;
	GSettings* _tmp68_ = NULL;
	gchar* _tmp69_ = NULL;
	gchar* _tmp70_ = NULL;
	GtkBuilder* _tmp71_ = NULL;
	GObject* _tmp72_ = NULL;
	GtkComboBox* _tmp73_ = NULL;
	GtkBuilder* _tmp74_ = NULL;
	GObject* _tmp75_ = NULL;
	GtkAdjustment* _tmp76_ = NULL;
	GtkBuilder* _tmp77_ = NULL;
	GObject* _tmp78_ = NULL;
	GtkBox* _tmp79_ = NULL;
	GtkBuilder* _tmp80_ = NULL;
	GObject* _tmp81_ = NULL;
	GtkComboBox* _tmp82_ = NULL;
	GSettings* _tmp83_ = NULL;
	gint _tmp84_ = 0;
	GtkComboBox* orientation_combo = NULL;
	GtkBuilder* _tmp85_ = NULL;
	GObject* _tmp86_ = NULL;
	GtkComboBox* _tmp87_ = NULL;
	GtkComboBox* _tmp88_ = NULL;
	GSettings* _tmp89_ = NULL;
	gchar* _tmp90_ = NULL;
	gchar* _tmp91_ = NULL;
	GtkComboBox* move_combo = NULL;
	GtkBuilder* _tmp92_ = NULL;
	GObject* _tmp93_ = NULL;
	GtkComboBox* _tmp94_ = NULL;
	GtkComboBox* _tmp95_ = NULL;
	GSettings* _tmp96_ = NULL;
	gchar* _tmp97_ = NULL;
	gchar* _tmp98_ = NULL;
	GtkComboBox* theme_combo = NULL;
	GtkBuilder* _tmp99_ = NULL;
	GObject* _tmp100_ = NULL;
	GtkComboBox* _tmp101_ = NULL;
	GtkComboBox* _tmp102_ = NULL;
	GSettings* _tmp103_ = NULL;
	gchar* _tmp104_ = NULL;
	gchar* _tmp105_ = NULL;
	GtkBuilder* _tmp106_ = NULL;
	GtkComboBox* _tmp107_ = NULL;
	gint _tmp108_ = 0;
	GtkDialog* _tmp111_ = NULL;
	GError * _inner_error_ = NULL;
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1646 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 1646 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 8692 "gnome-chess.c"
		GtkDialog* _tmp1_ = NULL;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->preferences_dialog;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_window_present ((GtkWindow*) _tmp1_);
#line 1649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 8700 "gnome-chess.c"
	}
#line 1652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_builder_new ();
#line 1652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->preferences_builder);
#line 1652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->preferences_builder = _tmp2_;
#line 8708 "gnome-chess.c"
	{
		GtkBuilder* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 1655 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->preferences_builder;
#line 1655 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = g_build_filename (PKGDATADIR, "preferences.ui", NULL, NULL);
#line 1655 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 1655 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_builder_add_from_file (_tmp3_, _tmp5_, &_inner_error_);
#line 1655 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp5_);
#line 1655 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8725 "gnome-chess.c"
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 1653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 1653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 1659 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = e;
#line 1659 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp6_->message;
#line 1659 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:1659: Could not load preferences UI: %s", _tmp7_);
#line 1653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 8747 "gnome-chess.c"
	}
	__finally6:
#line 1653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 1653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 8758 "gnome-chess.c"
	}
#line 1661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->preferences_builder;
#line 1661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = gtk_builder_get_object (_tmp8_, "preferences");
#line 1661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_dialog_get_type (), GtkDialog));
#line 1661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 1661 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->preferences_dialog = _tmp10_;
#line 1662 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->preferences_dialog;
#line 1662 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->window;
#line 1662 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp11_, (GtkWindow*) _tmp12_);
#line 1664 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->settings;
#line 1664 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = self->priv->preferences_builder;
#line 1664 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = gtk_builder_get_object (_tmp14_, "show_numbering_check");
#line 1664 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp13_, "show-numbering", _tmp15_, "active", G_SETTINGS_BIND_DEFAULT);
#line 1666 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->settings;
#line 1666 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = self->priv->preferences_builder;
#line 1666 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = gtk_builder_get_object (_tmp17_, "show_move_hints_check");
#line 1666 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp16_, "show-move-hints", _tmp18_, "active", G_SETTINGS_BIND_DEFAULT);
#line 1669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = self->priv->preferences_builder;
#line 1669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = gtk_builder_get_object (_tmp19_, "side_combo");
#line 1669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_combo_box_get_type (), GtkComboBox));
#line 1669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->side_combo);
#line 1669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->side_combo = _tmp21_;
#line 1670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->settings;
#line 1670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = g_settings_get_boolean (_tmp23_, "play-as-white");
#line 1670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp24_) {
#line 1670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = 0;
#line 8810 "gnome-chess.c"
	} else {
#line 1670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = 1;
#line 8814 "gnome-chess.c"
	}
#line 1670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = self->priv->side_combo;
#line 1670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active (_tmp25_, _tmp22_);
#line 1672 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = self->priv->preferences_builder;
#line 1672 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = gtk_builder_get_object (_tmp26_, "opponent_combo");
#line 1672 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_combo_box_get_type (), GtkComboBox));
#line 1672 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	ai_combo = _tmp28_;
#line 1673 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = ai_combo;
#line 1673 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = gtk_combo_box_get_model (_tmp29_);
#line 1673 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = _tmp30_;
#line 1673 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_list_store_get_type (), GtkListStore));
#line 1673 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	ai_model = _tmp32_;
#line 1674 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = self->priv->settings;
#line 1674 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = g_settings_get_string (_tmp33_, "opponent");
#line 1674 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	opponent_name = _tmp34_;
#line 1675 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = opponent_name;
#line 1675 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp35_, "human") == 0) {
#line 8848 "gnome-chess.c"
		GtkComboBox* _tmp36_ = NULL;
#line 1676 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp36_ = ai_combo;
#line 1676 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active (_tmp36_, 0);
#line 8854 "gnome-chess.c"
	}
#line 1677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = self->priv->ai_profiles;
#line 8858 "gnome-chess.c"
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
#line 1677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		p_collection = _tmp37_;
#line 1677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
#line 8866 "gnome-chess.c"
			AIProfile* _tmp38_ = NULL;
			AIProfile* p = NULL;
#line 1677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp38_ = _g_object_ref0 ((AIProfile*) p_it->data);
#line 1677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			p = _tmp38_;
#line 8873 "gnome-chess.c"
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp39_ = NULL;
				GtkTreeIter _tmp40_ = {0};
				GtkListStore* _tmp41_ = NULL;
				GtkTreeIter _tmp42_ = {0};
				AIProfile* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				AIProfile* _tmp46_ = NULL;
				const gchar* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				gboolean _tmp49_ = FALSE;
				AIProfile* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				const gchar* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
#line 1680 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = ai_model;
#line 1680 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_list_store_append (_tmp39_, &_tmp40_);
#line 1680 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				iter = _tmp40_;
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp41_ = ai_model;
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp42_ = iter;
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp43_ = p;
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp44_ = ai_profile_get_name (_tmp43_);
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp45_ = _tmp44_;
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp46_ = p;
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp47_ = ai_profile_get_name (_tmp46_);
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp48_ = _tmp47_;
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_list_store_set (_tmp41_, &_tmp42_, 0, _tmp45_, 1, _tmp48_, -1, -1);
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp50_ = p;
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp51_ = ai_profile_get_name (_tmp50_);
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp52_ = _tmp51_;
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp53_ = opponent_name;
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (g_strcmp0 (_tmp52_, _tmp53_) == 0) {
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp49_ = TRUE;
#line 8927 "gnome-chess.c"
				} else {
					gboolean _tmp54_ = FALSE;
					const gchar* _tmp55_ = NULL;
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp55_ = opponent_name;
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (g_strcmp0 (_tmp55_, "") == 0) {
#line 8935 "gnome-chess.c"
						GtkComboBox* _tmp56_ = NULL;
						gint _tmp57_ = 0;
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp56_ = ai_combo;
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp57_ = gtk_combo_box_get_active (_tmp56_);
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp54_ = _tmp57_ == (-1);
#line 8944 "gnome-chess.c"
					} else {
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp54_ = FALSE;
#line 8948 "gnome-chess.c"
					}
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp49_ = _tmp54_;
#line 8952 "gnome-chess.c"
				}
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp49_) {
#line 8956 "gnome-chess.c"
					GtkComboBox* _tmp58_ = NULL;
					GtkTreeIter _tmp59_ = {0};
#line 1683 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp58_ = ai_combo;
#line 1683 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp59_ = iter;
#line 1683 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					gtk_combo_box_set_active_iter (_tmp58_, &_tmp59_);
#line 8965 "gnome-chess.c"
				}
#line 1677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (p);
#line 8969 "gnome-chess.c"
			}
		}
	}
#line 1685 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = ai_combo;
#line 1685 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp61_ = gtk_combo_box_get_active (_tmp60_);
#line 1685 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp61_ == (-1)) {
#line 8979 "gnome-chess.c"
		GtkComboBox* _tmp62_ = NULL;
		GSettings* _tmp63_ = NULL;
#line 1687 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp62_ = ai_combo;
#line 1687 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active (_tmp62_, 0);
#line 1688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp63_ = self->priv->settings;
#line 1688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_settings_set_string (_tmp63_, "opponent", "human");
#line 8990 "gnome-chess.c"
	}
#line 1691 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp64_ = self->priv->preferences_builder;
#line 1691 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp65_ = gtk_builder_get_object (_tmp64_, "difficulty_combo");
#line 1691 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, gtk_combo_box_get_type (), GtkComboBox));
#line 1691 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->difficulty_combo);
#line 1691 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->difficulty_combo = _tmp66_;
#line 1692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp67_ = self->priv->difficulty_combo;
#line 1692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp68_ = self->priv->settings;
#line 1692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp69_ = g_settings_get_string (_tmp68_, "difficulty");
#line 1692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp70_ = _tmp69_;
#line 1692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_combo (self, _tmp67_, 1, _tmp70_);
#line 1692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp70_);
#line 1694 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp71_ = self->priv->preferences_builder;
#line 1694 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp72_ = gtk_builder_get_object (_tmp71_, "duration_combo");
#line 1694 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp73_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, gtk_combo_box_get_type (), GtkComboBox));
#line 1694 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_combo);
#line 1694 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->duration_combo = _tmp73_;
#line 1695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp74_ = self->priv->preferences_builder;
#line 1695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp75_ = gtk_builder_get_object (_tmp74_, "duration_adjustment");
#line 1695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp76_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, gtk_adjustment_get_type (), GtkAdjustment));
#line 1695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_adjustment);
#line 1695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->duration_adjustment = _tmp76_;
#line 1696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp77_ = self->priv->preferences_builder;
#line 1696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp78_ = gtk_builder_get_object (_tmp77_, "custom_duration_box");
#line 1696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp79_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, gtk_box_get_type (), GtkBox));
#line 1696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_box);
#line 1696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->custom_duration_box = _tmp79_;
#line 1697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp80_ = self->priv->preferences_builder;
#line 1697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp81_ = gtk_builder_get_object (_tmp80_, "custom_duration_units_combo");
#line 1697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, gtk_combo_box_get_type (), GtkComboBox));
#line 1697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_units_combo);
#line 1697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->custom_duration_units_combo = _tmp82_;
#line 1698 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp83_ = self->priv->settings;
#line 1698 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = g_settings_get_int (_tmp83_, "duration");
#line 1698 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_duration (self, _tmp84_, TRUE);
#line 1700 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp85_ = self->priv->preferences_builder;
#line 1700 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = gtk_builder_get_object (_tmp85_, "orientation_combo");
#line 1700 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp87_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, gtk_combo_box_get_type (), GtkComboBox));
#line 1700 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	orientation_combo = _tmp87_;
#line 1701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp88_ = orientation_combo;
#line 1701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp89_ = self->priv->settings;
#line 1701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = g_settings_get_string (_tmp89_, "board-side");
#line 1701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp91_ = _tmp90_;
#line 1701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_combo (self, _tmp88_, 1, _tmp91_);
#line 1701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp91_);
#line 1703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp92_ = self->priv->preferences_builder;
#line 1703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp93_ = gtk_builder_get_object (_tmp92_, "move_format_combo");
#line 1703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, gtk_combo_box_get_type (), GtkComboBox));
#line 1703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	move_combo = _tmp94_;
#line 1704 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp95_ = move_combo;
#line 1704 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp96_ = self->priv->settings;
#line 1704 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp97_ = g_settings_get_string (_tmp96_, "move-format");
#line 1704 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp98_ = _tmp97_;
#line 1704 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_combo (self, _tmp95_, 1, _tmp98_);
#line 1704 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp98_);
#line 1706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp99_ = self->priv->preferences_builder;
#line 1706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp100_ = gtk_builder_get_object (_tmp99_, "piece_style_combo");
#line 1706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp101_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, gtk_combo_box_get_type (), GtkComboBox));
#line 1706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	theme_combo = _tmp101_;
#line 1707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp102_ = theme_combo;
#line 1707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp103_ = self->priv->settings;
#line 1707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp104_ = g_settings_get_string (_tmp103_, "piece-theme");
#line 1707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp105_ = _tmp104_;
#line 1707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_combo (self, _tmp102_, 1, _tmp105_);
#line 1707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp105_);
#line 1709 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp106_ = self->priv->preferences_builder;
#line 1709 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_builder_connect_signals (_tmp106_, self);
#line 1712 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp107_ = ai_combo;
#line 1712 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp108_ = gtk_combo_box_get_active (_tmp107_);
#line 1712 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp108_ == 0) {
#line 9130 "gnome-chess.c"
		GtkComboBox* _tmp109_ = NULL;
		GtkComboBox* _tmp110_ = NULL;
#line 1714 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp109_ = self->priv->side_combo;
#line 1714 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp109_, FALSE);
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp110_ = self->priv->difficulty_combo;
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp110_, FALSE);
#line 9141 "gnome-chess.c"
	}
#line 1718 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp111_ = self->priv->preferences_dialog;
#line 1718 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_present ((GtkWindow*) _tmp111_);
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (theme_combo);
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (move_combo);
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (orientation_combo);
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (opponent_name);
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (ai_model);
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (ai_combo);
#line 9159 "gnome-chess.c"
}


static void chess_application_set_combo (ChessApplication* self, GtkComboBox* combo, gint value_index, const gchar* value) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
#line 1721 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1721 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1721 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (value != NULL);
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 1725 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = model;
#line 1725 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_tree_model_get_iter_first (_tmp4_, &_tmp5_);
#line 1725 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp5_;
#line 1725 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp6_) {
#line 1726 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 1726 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 9201 "gnome-chess.c"
	}
	{
		gboolean _tmp7_ = FALSE;
#line 1727 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = TRUE;
#line 1727 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		while (TRUE) {
#line 9209 "gnome-chess.c"
			gchar* v = NULL;
			GtkTreeModel* _tmp10_ = NULL;
			GtkTreeIter _tmp11_ = {0};
			gint _tmp12_ = 0;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
#line 1727 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (!_tmp7_) {
#line 9218 "gnome-chess.c"
				GtkTreeModel* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp8_ = model;
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp9_ = gtk_tree_model_iter_next (_tmp8_, &iter);
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (!_tmp9_) {
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					break;
#line 9229 "gnome-chess.c"
				}
			}
#line 1727 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = FALSE;
#line 1730 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp10_ = model;
#line 1730 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp11_ = iter;
#line 1730 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = value_index;
#line 1730 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_tree_model_get (_tmp10_, &_tmp11_, _tmp12_, &v, -1, -1);
#line 1731 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = v;
#line 1731 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp14_ = value;
#line 1731 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
#line 9248 "gnome-chess.c"
				GtkComboBox* _tmp15_ = NULL;
				GtkTreeIter _tmp16_ = {0};
#line 1733 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp15_ = combo;
#line 1733 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp16_ = iter;
#line 1733 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_combo_box_set_active_iter (_tmp15_, &_tmp16_);
#line 1734 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (v);
#line 1734 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (model);
#line 1734 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				return;
#line 9263 "gnome-chess.c"
			}
#line 1727 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (v);
#line 9267 "gnome-chess.c"
		}
	}
#line 1721 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 9272 "gnome-chess.c"
}


static gchar* chess_application_get_combo (ChessApplication* self, GtkComboBox* combo, gint value_index) {
	gchar* result = NULL;
	gchar* value = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gint _tmp7_ = 0;
#line 1739 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1739 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (combo != NULL, NULL);
#line 1743 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1743 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1743 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1743 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1744 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = NULL;
#line 1744 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (value);
#line 1744 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 9306 "gnome-chess.c"
	}
#line 1745 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1745 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1745 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1745 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1745 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = value_index;
#line 1745 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, _tmp7_, &value, -1, -1);
#line 1746 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = value;
#line 1746 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 9324 "gnome-chess.c"
}


void G_MODULE_EXPORT side_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean play_as_white = FALSE;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GSettings* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 1750 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1750 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1753 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1753 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1753 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1753 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1754 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 9354 "gnome-chess.c"
	}
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &play_as_white, -1, -1);
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->settings;
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = play_as_white;
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_boolean (_tmp7_, "play-as-white", _tmp8_);
#line 9372 "gnome-chess.c"
}


void G_MODULE_EXPORT opponent_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gchar* opponent = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GSettings* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean vs_human = FALSE;
	GtkComboBox* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GtkComboBox* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GtkComboBox* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
#line 1761 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1761 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1765 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 9409 "gnome-chess.c"
	}
#line 1767 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1767 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1767 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1767 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1767 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &opponent, -1, -1);
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->settings;
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = opponent;
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp7_, "opponent", _tmp8_);
#line 1769 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = combo;
#line 1769 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = gtk_combo_box_get_active (_tmp9_);
#line 1769 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	vs_human = _tmp10_ == 0;
#line 1770 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->side_combo;
#line 1770 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = vs_human;
#line 1770 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, !_tmp12_);
#line 1771 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->difficulty_combo;
#line 1771 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = vs_human;
#line 1771 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, !_tmp14_);
#line 1761 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (opponent);
#line 9447 "gnome-chess.c"
}


void G_MODULE_EXPORT difficulty_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gchar* difficulty = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GSettings* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 1775 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1775 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1779 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 9477 "gnome-chess.c"
	}
#line 1781 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1781 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1781 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1781 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1781 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &difficulty, -1, -1);
#line 1782 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->settings;
#line 1782 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = difficulty;
#line 1782 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp7_, "difficulty", _tmp8_);
#line 1775 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (difficulty);
#line 9497 "gnome-chess.c"
}


static void chess_application_set_duration (ChessApplication* self, gint duration, gboolean simplify) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeIter max_iter = {0};
	GtkTreeIter _tmp4_ = {0};
	gint max_multiplier = 0;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	gint value = 0;
	gint _tmp20_ = 0;
	gboolean _tmp27_ = FALSE;
	GtkComboBox* _tmp28_ = NULL;
	GtkTreeModel* _tmp29_ = NULL;
	GtkTreeModel* _tmp30_ = NULL;
	GtkTreeModel* _tmp31_ = NULL;
	GtkTreeModel* _tmp32_ = NULL;
	GtkTreeIter _tmp33_ = {0};
	gboolean _tmp34_ = FALSE;
#line 1785 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->custom_duration_units_combo;
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 1788 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max_iter = _tmp4_;
#line 1791 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max_multiplier = 0;
#line 1792 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = model;
#line 1792 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
#line 1792 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp6_;
#line 1792 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 9548 "gnome-chess.c"
		{
			gboolean _tmp8_ = FALSE;
#line 1794 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = TRUE;
#line 1794 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 9555 "gnome-chess.c"
				gint multiplier = 0;
				GtkTreeModel* _tmp11_ = NULL;
				GtkTreeIter _tmp12_ = {0};
				gboolean _tmp13_ = FALSE;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
#line 1794 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (!_tmp8_) {
#line 9564 "gnome-chess.c"
					GtkTreeModel* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
#line 1803 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = model;
#line 1803 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
#line 1803 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (!_tmp10_) {
#line 1803 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						break;
#line 9575 "gnome-chess.c"
					}
				}
#line 1794 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp8_ = FALSE;
#line 1797 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp11_ = model;
#line 1797 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp12_ = iter;
#line 1797 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_tree_model_get (_tmp11_, &_tmp12_, 1, &multiplier, -1, -1);
#line 1798 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp14_ = multiplier;
#line 1798 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp15_ = max_multiplier;
#line 1798 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp14_ > _tmp15_) {
#line 9592 "gnome-chess.c"
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
#line 1798 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp16_ = duration;
#line 1798 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp17_ = multiplier;
#line 1798 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp13_ = (_tmp16_ % _tmp17_) == 0;
#line 9601 "gnome-chess.c"
				} else {
#line 1798 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp13_ = FALSE;
#line 9605 "gnome-chess.c"
				}
#line 1798 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp13_) {
#line 9609 "gnome-chess.c"
					gint _tmp18_ = 0;
					GtkTreeIter _tmp19_ = {0};
#line 1800 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp18_ = multiplier;
#line 1800 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					max_multiplier = _tmp18_;
#line 1801 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp19_ = iter;
#line 1801 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					max_iter = _tmp19_;
#line 9620 "gnome-chess.c"
				}
			}
		}
	}
#line 1807 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	value = 0;
#line 1808 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = max_multiplier;
#line 1808 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp20_ > 0) {
#line 9631 "gnome-chess.c"
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		GtkAdjustment* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		GtkComboBox* _tmp25_ = NULL;
		GtkTreeIter _tmp26_ = {0};
#line 1810 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = duration;
#line 1810 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = max_multiplier;
#line 1810 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		value = _tmp21_ / _tmp22_;
#line 1811 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = self->priv->duration_adjustment;
#line 1811 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = value;
#line 1811 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_adjustment_set_value (_tmp23_, (gdouble) _tmp24_);
#line 1812 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = self->priv->custom_duration_units_combo;
#line 1812 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = max_iter;
#line 1812 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active_iter (_tmp25_, &_tmp26_);
#line 9656 "gnome-chess.c"
	}
#line 1815 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = simplify;
#line 1815 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp27_) {
#line 1816 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 1816 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 9666 "gnome-chess.c"
	}
#line 1818 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = self->priv->duration_combo;
#line 1818 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = gtk_combo_box_get_model (_tmp28_);
#line 1818 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = _tmp29_;
#line 1818 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = _g_object_ref0 (_tmp30_);
#line 1818 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 1818 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp31_;
#line 1819 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = model;
#line 1819 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = gtk_tree_model_get_iter_first (_tmp32_, &_tmp33_);
#line 1819 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp33_;
#line 1819 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp34_) {
#line 1820 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 1820 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 9692 "gnome-chess.c"
	}
	{
		gboolean _tmp35_ = FALSE;
#line 1821 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp35_ = TRUE;
#line 1821 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		while (TRUE) {
#line 9700 "gnome-chess.c"
			gint v = 0;
			GtkTreeModel* _tmp38_ = NULL;
			GtkTreeIter _tmp39_ = {0};
			gboolean _tmp40_ = FALSE;
			gint _tmp41_ = 0;
			gint _tmp42_ = 0;
#line 1821 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (!_tmp35_) {
#line 9709 "gnome-chess.c"
				GtkTreeModel* _tmp36_ = NULL;
				gboolean _tmp37_ = FALSE;
#line 1831 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = model;
#line 1831 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp37_ = gtk_tree_model_iter_next (_tmp36_, &iter);
#line 1831 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (!_tmp37_) {
#line 1831 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					break;
#line 9720 "gnome-chess.c"
				}
			}
#line 1821 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp35_ = FALSE;
#line 1824 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp38_ = model;
#line 1824 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp39_ = iter;
#line 1824 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_tree_model_get (_tmp38_, &_tmp39_, 1, &v, -1, -1);
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp41_ = v;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp42_ = duration;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp41_ == _tmp42_) {
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = TRUE;
#line 9739 "gnome-chess.c"
			} else {
				gint _tmp43_ = 0;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp43_ = v;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = _tmp43_ == (-1);
#line 9746 "gnome-chess.c"
			}
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp40_) {
#line 9750 "gnome-chess.c"
				GtkComboBox* _tmp44_ = NULL;
				GtkTreeIter _tmp45_ = {0};
				GtkBox* _tmp46_ = NULL;
				gint _tmp47_ = 0;
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp44_ = self->priv->duration_combo;
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp45_ = iter;
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_combo_box_set_active_iter (_tmp44_, &_tmp45_);
#line 1828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp46_ = self->priv->custom_duration_box;
#line 1828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp47_ = v;
#line 1828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_widget_set_visible ((GtkWidget*) _tmp46_, _tmp47_ == (-1));
#line 1829 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (model);
#line 1829 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				return;
#line 9771 "gnome-chess.c"
			}
		}
	}
#line 1785 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 9777 "gnome-chess.c"
}


static gint chess_application_get_duration (ChessApplication* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint magnitude = 0;
	GtkAdjustment* _tmp8_ = NULL;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gint multiplier = 0;
	GtkComboBox* _tmp11_ = NULL;
	GtkTreeIter _tmp12_ = {0};
	gboolean _tmp13_ = FALSE;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
#line 1834 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1837 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->duration_combo;
#line 1837 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1837 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1837 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_) {
#line 9807 "gnome-chess.c"
		gint duration = 0;
		GtkComboBox* _tmp3_ = NULL;
		GtkTreeModel* _tmp4_ = NULL;
		GtkTreeModel* _tmp5_ = NULL;
		GtkTreeIter _tmp6_ = {0};
		gint _tmp7_ = 0;
#line 1840 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->duration_combo;
#line 1840 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1840 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 1840 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = iter;
#line 1840 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
#line 1841 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = duration;
#line 1841 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp7_ >= 0) {
#line 1842 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			result = duration;
#line 1842 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return result;
#line 9832 "gnome-chess.c"
		}
	}
#line 1845 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->duration_adjustment;
#line 1845 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = gtk_adjustment_get_value (_tmp8_);
#line 1845 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = _tmp9_;
#line 1845 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	magnitude = (gint) _tmp10_;
#line 1846 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	multiplier = 1;
#line 1847 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->custom_duration_units_combo;
#line 1847 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = gtk_combo_box_get_active_iter (_tmp11_, &_tmp12_);
#line 1847 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp12_;
#line 1847 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp13_) {
#line 9853 "gnome-chess.c"
		GtkComboBox* _tmp14_ = NULL;
		GtkTreeModel* _tmp15_ = NULL;
		GtkTreeModel* _tmp16_ = NULL;
		GtkTreeIter _tmp17_ = {0};
#line 1848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->custom_duration_units_combo;
#line 1848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = gtk_combo_box_get_model (_tmp14_);
#line 1848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_;
#line 1848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = iter;
#line 1848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_tree_model_get (_tmp16_, &_tmp17_, 1, &multiplier, -1, -1);
#line 9868 "gnome-chess.c"
	}
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = magnitude;
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = multiplier;
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = _tmp18_ * _tmp19_;
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 9878 "gnome-chess.c"
}


static gboolean chess_application_save_duration_cb (ChessApplication* self) {
	gboolean result = FALSE;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	guint _tmp2_ = 0U;
#line 1852 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1854 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 1854 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_application_get_duration (self);
#line 1854 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_int (_tmp0_, "duration", _tmp1_);
#line 1855 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->save_duration_timeout;
#line 1855 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_source_remove (_tmp2_);
#line 1856 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_duration_timeout = (guint) 0;
#line 1857 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1857 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 9905 "gnome-chess.c"
}


void G_MODULE_EXPORT duration_changed_cb (GtkAdjustment* adjustment, ChessApplication* self) {
	GtkListStore* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkListStore* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
#line 1861 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1861 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (adjustment != NULL);
#line 1863 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->custom_duration_units_combo;
#line 1863 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 1863 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1863 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
#line 1863 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 1866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = model;
#line 1866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp4_, &_tmp5_);
#line 1866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp5_;
#line 1866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp6_) {
#line 9941 "gnome-chess.c"
		{
			gboolean _tmp7_ = FALSE;
#line 1868 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = TRUE;
#line 1868 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 9948 "gnome-chess.c"
				gint multiplier = 0;
				GtkListStore* _tmp10_ = NULL;
				GtkTreeIter _tmp11_ = {0};
				gint _tmp12_ = 0;
#line 1868 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (!_tmp7_) {
#line 9955 "gnome-chess.c"
					GtkListStore* _tmp8_ = NULL;
					gboolean _tmp9_ = FALSE;
#line 1885 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp8_ = model;
#line 1885 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp8_, &iter);
#line 1885 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (!_tmp9_) {
#line 1885 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						break;
#line 9966 "gnome-chess.c"
					}
				}
#line 1868 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp7_ = FALSE;
#line 1871 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp10_ = model;
#line 1871 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp11_ = iter;
#line 1871 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 1, &multiplier, -1, -1);
#line 1872 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp12_ = multiplier;
#line 1872 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				switch (_tmp12_) {
#line 1872 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					case 60:
#line 9983 "gnome-chess.c"
					{
						GtkListStore* _tmp13_ = NULL;
						GtkTreeIter _tmp14_ = {0};
						GtkAdjustment* _tmp15_ = NULL;
						gdouble _tmp16_ = 0.0;
						gdouble _tmp17_ = 0.0;
						const gchar* _tmp18_ = NULL;
#line 1875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp13_ = model;
#line 1875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp14_ = iter;
#line 1875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp15_ = adjustment;
#line 1875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp16_ = gtk_adjustment_get_value (_tmp15_);
#line 1875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp17_ = _tmp16_;
#line 1875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp18_ = ngettext ("minute", "minutes", (gulong) _tmp17_);
#line 1875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						gtk_list_store_set (_tmp13_, &_tmp14_, 0, _tmp18_, -1, -1);
#line 1877 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						break;
#line 10007 "gnome-chess.c"
					}
#line 1872 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					case 3600:
#line 10011 "gnome-chess.c"
					{
						GtkListStore* _tmp19_ = NULL;
						GtkTreeIter _tmp20_ = {0};
						GtkAdjustment* _tmp21_ = NULL;
						gdouble _tmp22_ = 0.0;
						gdouble _tmp23_ = 0.0;
						const gchar* _tmp24_ = NULL;
#line 1879 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp19_ = model;
#line 1879 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp20_ = iter;
#line 1879 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp21_ = adjustment;
#line 1879 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp22_ = gtk_adjustment_get_value (_tmp21_);
#line 1879 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp23_ = _tmp22_;
#line 1879 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp24_ = ngettext ("hour", "hours", (gulong) _tmp23_);
#line 1879 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						gtk_list_store_set (_tmp19_, &_tmp20_, 0, _tmp24_, -1, -1);
#line 1881 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						break;
#line 10035 "gnome-chess.c"
					}
					default:
					{
#line 1883 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						g_assert_not_reached ();
#line 10041 "gnome-chess.c"
					}
				}
			}
		}
	}
#line 1888 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_save_duration (self);
#line 1861 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 10051 "gnome-chess.c"
}


void G_MODULE_EXPORT duration_units_changed_cb (GtkWidget* widget, ChessApplication* self) {
#line 1892 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1892 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1894 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_save_duration (self);
#line 10062 "gnome-chess.c"
}


static gboolean _chess_application_save_duration_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_application_save_duration_cb ((ChessApplication*) self);
#line 1902 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 10071 "gnome-chess.c"
}


static void chess_application_save_duration (ChessApplication* self) {
	guint _tmp0_ = 0U;
	guint _tmp2_ = 0U;
#line 1897 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1900 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->save_duration_timeout;
#line 1900 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 10084 "gnome-chess.c"
		guint _tmp1_ = 0U;
#line 1901 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->save_duration_timeout;
#line 1901 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_source_remove (_tmp1_);
#line 10090 "gnome-chess.c"
	}
#line 1902 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _chess_application_save_duration_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 1902 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_duration_timeout = _tmp2_;
#line 10096 "gnome-chess.c"
}


void G_MODULE_EXPORT duration_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint duration = 0;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GtkBox* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
#line 1906 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1906 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 10127 "gnome-chess.c"
	}
#line 1912 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1912 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1912 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1912 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1912 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
#line 1913 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->custom_duration_box;
#line 1913 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = duration;
#line 1913 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_ < 0);
#line 1915 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = duration;
#line 1915 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp9_ >= 0) {
#line 10149 "gnome-chess.c"
		gint _tmp10_ = 0;
#line 1916 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = duration;
#line 1916 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_set_duration (self, _tmp10_, FALSE);
#line 10155 "gnome-chess.c"
	} else {
		gint _tmp11_ = 0;
#line 1918 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = chess_application_get_duration (self);
#line 1918 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp11_ <= 0) {
#line 1919 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_set_duration (self, 60 * 60, FALSE);
#line 10164 "gnome-chess.c"
		}
	}
#line 1921 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_save_duration (self);
#line 10169 "gnome-chess.c"
}


void G_MODULE_EXPORT preferences_response_cb (GtkWidget* widget, gint response_id, ChessApplication* self) {
	GtkDialog* _tmp0_ = NULL;
#line 1925 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1925 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1927 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 1927 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 10183 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
#line 1931 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1931 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1931 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1933 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = widget;
#line 1933 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	G_MODULE_EXPORT preferences_response_cb (_tmp0_, (gint) GTK_RESPONSE_CANCEL, self);
#line 1934 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = TRUE;
#line 1934 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 10204 "gnome-chess.c"
}


void G_MODULE_EXPORT piece_style_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GSettings* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1938 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1938 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 1940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = combo;
#line 1940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_application_get_combo (self, _tmp1_, 1);
#line 1940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 1940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp0_, "piece-theme", _tmp3_);
#line 1940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp3_);
#line 10229 "gnome-chess.c"
}


void G_MODULE_EXPORT move_format_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GSettings* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1944 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1944 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1946 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 1946 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = combo;
#line 1946 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_application_get_combo (self, _tmp1_, 1);
#line 1946 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 1946 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp0_, "move-format", _tmp3_);
#line 1946 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp3_);
#line 10254 "gnome-chess.c"
}


void G_MODULE_EXPORT orientation_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GSettings* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1950 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1950 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1952 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 1952 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = combo;
#line 1952 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_application_get_combo (self, _tmp1_, 1);
#line 1952 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 1952 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp0_, "board-side", _tmp3_);
#line 1952 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp3_);
#line 10279 "gnome-chess.c"
}


void chess_application_help_cb (ChessApplication* self) {
	GError * _inner_error_ = NULL;
#line 1955 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 10287 "gnome-chess.c"
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = self->priv->window;
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_show_uri (_tmp1_, "help:gnome-chess", _tmp2_, &_inner_error_);
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10302 "gnome-chess.c"
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 1957 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 1957 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 1963 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = e;
#line 1963 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_->message;
#line 1963 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:1963: Unable to open help: %s", _tmp4_);
#line 1957 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 10324 "gnome-chess.c"
	}
	__finally7:
#line 1957 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1957 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1957 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 1957 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 10335 "gnome-chess.c"
	}
}


static void _chess_application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 1991 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_about_response_cb ((ChessApplication*) self, response_id);
#line 10343 "gnome-chess.c"
}


void chess_application_about_cb (ChessApplication* self) {
	GtkAboutDialog* _tmp0_ = NULL;
	GtkAboutDialog* _tmp2_ = NULL;
	GtkAboutDialog* _tmp3_ = NULL;
	GtkApplicationWindow* _tmp4_ = NULL;
	GtkAboutDialog* _tmp5_ = NULL;
	GtkAboutDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkAboutDialog* _tmp8_ = NULL;
	GtkAboutDialog* _tmp9_ = NULL;
	GtkAboutDialog* _tmp10_ = NULL;
	GtkAboutDialog* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkAboutDialog* _tmp13_ = NULL;
	GtkAboutDialog* _tmp14_ = NULL;
	GtkAboutDialog* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkAboutDialog* _tmp17_ = NULL;
	GtkAboutDialog* _tmp18_ = NULL;
	GtkAboutDialog* _tmp19_ = NULL;
	GtkAboutDialog* _tmp20_ = NULL;
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1972 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->about_dialog;
#line 1972 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 10374 "gnome-chess.c"
		GtkAboutDialog* _tmp1_ = NULL;
#line 1974 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->about_dialog;
#line 1974 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_window_present ((GtkWindow*) _tmp1_);
#line 1975 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 10382 "gnome-chess.c"
	}
#line 1978 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = (GtkAboutDialog*) gtk_about_dialog_new ();
#line 1978 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp2_);
#line 1978 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->about_dialog);
#line 1978 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->about_dialog = _tmp2_;
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->about_dialog;
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->window;
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, (GtkWindow*) _tmp4_);
#line 1980 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->about_dialog;
#line 1980 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
#line 1981 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->about_dialog;
#line 1981 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _ ("Chess");
#line 1981 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_program_name (_tmp6_, _tmp7_);
#line 1982 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->about_dialog;
#line 1982 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_version (_tmp8_, VERSION);
#line 1983 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->about_dialog;
#line 1983 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_copyright (_tmp9_, "Copyright © 2010–2013 Robert Ancell\n" \
"Copyright © 2013–2014 Michael Catanzaro");
#line 1984 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->about_dialog;
#line 1984 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_license_type (_tmp10_, GTK_LICENSE_GPL_2_0);
#line 1985 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->about_dialog;
#line 1985 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = _ ("A classic game of positional strategy");
#line 1985 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_comments (_tmp11_, _tmp12_);
#line 1986 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->about_dialog;
#line 1986 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_authors (_tmp13_, CHESS_APPLICATION_authors);
#line 1987 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = self->priv->about_dialog;
#line 1987 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_artists (_tmp14_, CHESS_APPLICATION_artists);
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->about_dialog;
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = _ ("translator-credits");
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_translator_credits (_tmp15_, _tmp16_);
#line 1989 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = self->priv->about_dialog;
#line 1989 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_website (_tmp17_, "https://wiki.gnome.org/Apps/Chess");
#line 1990 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = self->priv->about_dialog;
#line 1990 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_logo_icon_name (_tmp18_, "gnome-chess");
#line 1991 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = self->priv->about_dialog;
#line 1991 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkDialog*) _tmp19_, "response", (GCallback) _chess_application_about_response_cb_gtk_dialog_response, self, 0);
#line 1992 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = self->priv->about_dialog;
#line 1992 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp20_);
#line 10456 "gnome-chess.c"
}


static void chess_application_about_response_cb (ChessApplication* self, gint response_id) {
	GtkAboutDialog* _tmp0_ = NULL;
#line 1995 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1997 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->about_dialog;
#line 1997 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 1998 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->about_dialog);
#line 1998 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->about_dialog = NULL;
#line 10472 "gnome-chess.c"
}


static void chess_application_add_info_bar_to_dialog (ChessApplication* self, GtkDialog* dialog, GtkInfoBar** info_bar, GtkLabel** label) {
	GtkInfoBar* _vala_info_bar = NULL;
	GtkLabel* _vala_label = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp0_ = NULL;
	GtkInfoBar* _tmp1_ = NULL;
	GtkContainer* content_area = NULL;
	GtkContainer* _tmp2_ = NULL;
	GtkContainer* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkContainer* child = NULL;
	GtkDialog* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GtkContainer* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	GtkDialog* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
#line 2001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (dialog != NULL);
#line 2003 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#line 2003 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp0_);
#line 2003 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	vbox = _tmp0_;
#line 2004 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) vbox);
#line 2006 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = (GtkInfoBar*) gtk_info_bar_new ();
#line 2006 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp1_);
#line 2006 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (_vala_info_bar);
#line 2006 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_vala_info_bar = _tmp1_;
#line 2007 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_info_bar_get_content_area (_vala_info_bar);
#line 2007 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer));
#line 2007 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	content_area = _tmp3_;
#line 2008 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_box_pack_start (vbox, (GtkWidget*) _vala_info_bar, FALSE, TRUE, (guint) 0);
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = (GtkLabel*) gtk_label_new ("");
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp4_);
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (_vala_label);
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_vala_label = _tmp4_;
#line 2011 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_container_add (content_area, (GtkWidget*) _vala_label);
#line 2012 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _vala_label);
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = dialog;
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_bin_get_child ((GtkBin*) _tmp5_);
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_container_get_type (), GtkContainer));
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	child = _tmp7_;
#line 2015 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_reparent ((GtkWidget*) child, (GtkWidget*) vbox);
#line 2016 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = dialog;
#line 2016 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = gtk_container_get_border_width ((GtkContainer*) _tmp8_);
#line 2016 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = _tmp9_;
#line 2016 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_container_set_border_width (child, _tmp10_);
#line 2017 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = dialog;
#line 2017 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp11_, (guint) 0);
#line 2019 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_box_set_child_packing (vbox, (GtkWidget*) child, TRUE, TRUE, (guint) 0, GTK_PACK_START);
#line 2020 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = dialog;
#line 2020 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) vbox);
#line 2001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (child);
#line 2001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (content_area);
#line 2001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (vbox);
#line 2001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (info_bar) {
#line 2001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		*info_bar = _vala_info_bar;
#line 10573 "gnome-chess.c"
	} else {
#line 2001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_vala_info_bar);
#line 10577 "gnome-chess.c"
	}
#line 2001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (label) {
#line 2001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		*label = _vala_label;
#line 10583 "gnome-chess.c"
	} else {
#line 2001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_vala_label);
#line 10587 "gnome-chess.c"
	}
}


static void chess_application_update_pgn_time_remaining (ChessApplication* self) {
	ChessGame* _tmp0_ = NULL;
	ChessClock* _tmp1_ = NULL;
	ChessClock* _tmp2_ = NULL;
#line 2023 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2025 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 2025 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_get_clock (_tmp0_);
#line 2025 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 2025 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ != NULL) {
#line 10606 "gnome-chess.c"
		guint initial_time = 0U;
		PGNGame* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		guint white_used = 0U;
		ChessGame* _tmp7_ = NULL;
		ChessClock* _tmp8_ = NULL;
		ChessClock* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		guint black_used = 0U;
		ChessGame* _tmp12_ = NULL;
		ChessClock* _tmp13_ = NULL;
		ChessClock* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		PGNGame* _tmp17_ = NULL;
		guint _tmp18_ = 0U;
		guint _tmp19_ = 0U;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		PGNGame* _tmp22_ = NULL;
		guint _tmp23_ = 0U;
		guint _tmp24_ = 0U;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->pgn_game;
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = pgn_game_get_time_control (_tmp3_);
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = atoi (_tmp5_);
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		initial_time = (guint) _tmp6_;
#line 2029 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->game;
#line 2029 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = chess_game_get_clock (_tmp7_);
#line 2029 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _tmp8_;
#line 2029 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = chess_clock_get_white_seconds_used (_tmp9_);
#line 2029 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp10_;
#line 2029 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		white_used = (guint) _tmp11_;
#line 2030 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->game;
#line 2030 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = chess_game_get_clock (_tmp12_);
#line 2030 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = _tmp13_;
#line 2030 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = chess_clock_get_black_seconds_used (_tmp14_);
#line 2030 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_;
#line 2030 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		black_used = (guint) _tmp16_;
#line 2032 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = self->priv->pgn_game;
#line 2032 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = initial_time;
#line 2032 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = white_used;
#line 2032 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = g_strdup_printf ("%u", _tmp18_ - _tmp19_);
#line 2032 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = _tmp20_;
#line 2032 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_white_time_left (_tmp17_, _tmp21_);
#line 2032 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp21_);
#line 2033 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = self->priv->pgn_game;
#line 2033 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = initial_time;
#line 2033 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = black_used;
#line 2033 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = g_strdup_printf ("%u", _tmp23_ - _tmp24_);
#line 2033 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = _tmp25_;
#line 2033 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_black_time_left (_tmp22_, _tmp26_);
#line 2033 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp26_);
#line 10696 "gnome-chess.c"
	}
}


static void chess_application_save_dialog_cb (ChessApplication* self, gint response_id) {
	gint _tmp0_ = 0;
	GtkFileChooserDialog* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
#line 2037 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2039 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = response_id;
#line 2039 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 2041 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_update_pgn_time_remaining (self);
#line 10713 "gnome-chess.c"
		{
			GtkFileChooserDialog* _tmp1_ = NULL;
			GFile* _tmp2_ = NULL;
			PGNGame* _tmp3_ = NULL;
			GFile* _tmp4_ = NULL;
			GtkHeaderBar* _tmp5_ = NULL;
			GFile* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
#line 2045 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp1_ = self->priv->save_dialog;
#line 2045 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp1_);
#line 2045 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->game_file);
#line 2045 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->game_file = _tmp2_;
#line 2046 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp3_ = self->priv->pgn_game;
#line 2046 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp4_ = self->priv->game_file;
#line 2046 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_write (_tmp3_, _tmp4_, &_inner_error_);
#line 2046 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10739 "gnome-chess.c"
				goto __catch8_g_error;
			}
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp5_ = self->priv->headerbar;
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp6_ = self->priv->game_file;
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = g_file_get_basename (_tmp6_);
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = _tmp7_;
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_header_bar_set_subtitle (_tmp5_, _tmp8_);
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (_tmp8_);
#line 2048 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 2049 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->game_needs_saving = FALSE;
#line 10758 "gnome-chess.c"
		}
		goto __finally8;
		__catch8_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			GtkLabel* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			GtkInfoBar* _tmp13_ = NULL;
			GtkInfoBar* _tmp14_ = NULL;
#line 2043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			e = _inner_error_;
#line 2043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_inner_error_ = NULL;
#line 2053 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp9_ = e;
#line 2053 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp10_ = _tmp9_->message;
#line 2053 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:2053: Failed to save game: %s", _tmp10_);
#line 2054 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp11_ = self->priv->save_dialog_error_label;
#line 2054 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = _ ("Failed to save game");
#line 2054 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_label_set_text (_tmp11_, _tmp12_);
#line 2055 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = self->priv->save_dialog_info_bar;
#line 2055 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_info_bar_set_message_type (_tmp13_, GTK_MESSAGE_ERROR);
#line 2056 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp14_ = self->priv->save_dialog_info_bar;
#line 2056 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_widget_show ((GtkWidget*) _tmp14_);
#line 2057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_error_free0 (e);
#line 2057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return;
#line 10798 "gnome-chess.c"
		}
		__finally8:
#line 2043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_clear_error (&_inner_error_);
#line 2043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return;
#line 10809 "gnome-chess.c"
		}
	}
#line 2061 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->save_dialog;
#line 2061 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp15_);
#line 2062 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 2062 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog = NULL;
#line 2063 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_info_bar);
#line 2063 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_info_bar = NULL;
#line 2064 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_error_label);
#line 2064 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_error_label = NULL;
#line 10828 "gnome-chess.c"
}


static void __lambda6_ (ChessApplication* self) {
#line 2084 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_save_dialog_cb (self, (gint) GTK_RESPONSE_OK);
#line 10835 "gnome-chess.c"
}


static void ___lambda6__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
#line 2084 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	__lambda6_ ((ChessApplication*) self);
#line 10842 "gnome-chess.c"
}


static void _chess_application_save_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 2085 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_save_dialog_cb ((ChessApplication*) self, response_id);
#line 10849 "gnome-chess.c"
}


static void chess_application_present_save_dialog (ChessApplication* self, const gchar* cancel_button_label, const gchar* save_button_label) {
	GtkFileChooserDialog* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkFileChooserDialog* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_ = NULL;
	GtkInfoBar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GFile* _tmp15_ = NULL;
	GtkFileFilter* pgn_filter = NULL;
	GtkFileFilter* _tmp28_ = NULL;
	GtkFileFilter* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	GtkFileFilter* _tmp31_ = NULL;
	GtkFileChooserDialog* _tmp32_ = NULL;
	GtkFileFilter* _tmp33_ = NULL;
	GtkFileFilter* _tmp34_ = NULL;
	GtkFileFilter* all_filter = NULL;
	GtkFileFilter* _tmp35_ = NULL;
	GtkFileFilter* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	GtkFileFilter* _tmp38_ = NULL;
	GtkFileChooserDialog* _tmp39_ = NULL;
	GtkFileFilter* _tmp40_ = NULL;
	GtkFileFilter* _tmp41_ = NULL;
	GtkFileChooserDialog* _tmp42_ = NULL;
#line 2067 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2067 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (cancel_button_label != NULL);
#line 2067 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (save_button_label != NULL);
#line 2071 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->save_dialog;
#line 2071 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 10896 "gnome-chess.c"
		GtkFileChooserDialog* _tmp1_ = NULL;
#line 2073 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->save_dialog;
#line 2073 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_run ((GtkDialog*) _tmp1_);
#line 2074 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 10904 "gnome-chess.c"
	}
#line 2077 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _ ("Save Chess Game");
#line 2077 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->window;
#line 2077 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = cancel_button_label;
#line 2077 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _ (_tmp4_);
#line 2077 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = save_button_label;
#line 2077 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _ (_tmp6_);
#line 2077 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp2_, (GtkWindow*) _tmp3_, GTK_FILE_CHOOSER_ACTION_SAVE, _tmp5_, GTK_RESPONSE_CANCEL, _tmp7_, GTK_RESPONSE_OK, NULL, NULL);
#line 2077 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp8_);
#line 2077 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 2077 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog = _tmp8_;
#line 2082 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->save_dialog;
#line 2082 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_add_info_bar_to_dialog (self, (GtkDialog*) _tmp9_, &_tmp10_, &_tmp11_);
#line 2082 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_info_bar);
#line 2082 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_info_bar = _tmp10_;
#line 2082 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_error_label);
#line 2082 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_error_label = _tmp11_;
#line 2084 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->save_dialog;
#line 2084 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkFileChooser*) _tmp12_, "file-activated", (GCallback) ___lambda6__gtk_file_chooser_file_activated, self, 0);
#line 2085 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->save_dialog;
#line 2085 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkDialog*) _tmp13_, "response", (GCallback) _chess_application_save_dialog_cb_gtk_dialog_response, self, 0);
#line 2087 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->game_file;
#line 2087 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp15_ != NULL) {
#line 10950 "gnome-chess.c"
		GFile* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 2087 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = self->priv->game_file;
#line 2087 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = g_file_get_path (_tmp16_);
#line 2087 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = _tmp17_;
#line 2087 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = self->priv->autosave_filename;
#line 2087 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = g_strcmp0 (_tmp18_, _tmp19_) != 0;
#line 2087 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp18_);
#line 10967 "gnome-chess.c"
	} else {
#line 2087 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = FALSE;
#line 10971 "gnome-chess.c"
	}
#line 2087 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp14_) {
#line 10975 "gnome-chess.c"
		GtkFileChooserDialog* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
#line 2088 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = self->priv->save_dialog;
#line 2088 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = self->priv->game_file;
#line 2088 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = g_file_get_path (_tmp21_);
#line 2088 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = _tmp22_;
#line 2088 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_file_chooser_set_filename ((GtkFileChooser*) _tmp20_, _tmp23_);
#line 2088 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp23_);
#line 10992 "gnome-chess.c"
	} else {
		GtkFileChooserDialog* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
#line 2090 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = self->priv->save_dialog;
#line 2090 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = _ ("Untitled Chess Game");
#line 2090 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = g_strconcat (_tmp25_, ".pgn", NULL);
#line 2090 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = _tmp26_;
#line 2090 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp24_, _tmp27_);
#line 2090 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp27_);
#line 11010 "gnome-chess.c"
	}
#line 2094 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = gtk_file_filter_new ();
#line 2094 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp28_);
#line 2094 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	pgn_filter = _tmp28_;
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = pgn_filter;
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = _ ("PGN files");
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp29_, _tmp30_);
#line 2097 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = pgn_filter;
#line 2097 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp31_, "*.pgn");
#line 2098 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = self->priv->save_dialog;
#line 2098 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = pgn_filter;
#line 2098 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = _g_object_ref0 (_tmp33_);
#line 2098 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp32_, _tmp34_);
#line 2100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = gtk_file_filter_new ();
#line 2100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp35_);
#line 2100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	all_filter = _tmp35_;
#line 2102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = all_filter;
#line 2102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = _ ("All files");
#line 2102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp36_, _tmp37_);
#line 2103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = all_filter;
#line 2103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp38_, "*");
#line 2104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = self->priv->save_dialog;
#line 2104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = all_filter;
#line 2104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = _g_object_ref0 (_tmp40_);
#line 2104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp39_, _tmp41_);
#line 2106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = self->priv->save_dialog;
#line 2106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_run ((GtkDialog*) _tmp42_);
#line 2067 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (all_filter);
#line 2067 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (pgn_filter);
#line 11068 "gnome-chess.c"
}


void chess_application_save_game_cb (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 2109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game_file;
#line 2111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ == NULL) {
#line 2111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = TRUE;
#line 11084 "gnome-chess.c"
	} else {
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 2111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game_file;
#line 2111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = g_file_get_path (_tmp2_);
#line 2111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_;
#line 2111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->autosave_filename;
#line 2111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
#line 2111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp4_);
#line 11102 "gnome-chess.c"
	}
#line 2111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 2113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_present_save_dialog (self, "_Cancel", "_Save");
#line 2114 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 11110 "gnome-chess.c"
	}
#line 2117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_pgn_time_remaining (self);
#line 11114 "gnome-chess.c"
	{
		PGNGame* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
#line 2121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->pgn_game;
#line 2121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->game_file;
#line 2121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_write (_tmp6_, _tmp7_, &_inner_error_);
#line 2121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11126 "gnome-chess.c"
			goto __catch9_g_error;
		}
#line 2122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 11131 "gnome-chess.c"
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
#line 2119 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 2119 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 2126 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_present_save_dialog (self, "_Cancel", "_Save");
#line 2119 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 11145 "gnome-chess.c"
	}
	__finally9:
#line 2119 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2119 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2119 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 2119 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 11156 "gnome-chess.c"
	}
}


void chess_application_save_game_as_cb (ChessApplication* self) {
#line 2130 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2132 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_present_save_dialog (self, "_Cancel", "_Save");
#line 11166 "gnome-chess.c"
}


static void __lambda9_ (ChessApplication* self) {
#line 2154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_open_dialog_cb (self, (gint) GTK_RESPONSE_OK);
#line 11173 "gnome-chess.c"
}


static void ___lambda9__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
#line 2154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	__lambda9_ ((ChessApplication*) self);
#line 11180 "gnome-chess.c"
}


static void _chess_application_open_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 2155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_open_dialog_cb ((ChessApplication*) self, response_id);
#line 11187 "gnome-chess.c"
}


void chess_application_open_game_cb (ChessApplication* self) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkFileChooserDialog* _tmp2_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkApplicationWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkFileChooserDialog* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_ = NULL;
	GtkInfoBar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_ = NULL;
	GtkFileFilter* pgn_filter = NULL;
	GtkFileFilter* _tmp14_ = NULL;
	GtkFileFilter* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkFileFilter* _tmp17_ = NULL;
	GtkFileChooserDialog* _tmp18_ = NULL;
	GtkFileFilter* _tmp19_ = NULL;
	GtkFileFilter* _tmp20_ = NULL;
	GtkFileFilter* all_filter = NULL;
	GtkFileFilter* _tmp21_ = NULL;
	GtkFileFilter* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GtkFileFilter* _tmp24_ = NULL;
	GtkFileChooserDialog* _tmp25_ = NULL;
	GtkFileFilter* _tmp26_ = NULL;
	GtkFileFilter* _tmp27_ = NULL;
	GtkFileChooserDialog* _tmp28_ = NULL;
#line 2135 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = _ ("Save this game before loading another one?");
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_application_prompt_save_game (self, _tmp0_);
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp1_) {
#line 2138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 11232 "gnome-chess.c"
	}
#line 2141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->open_dialog;
#line 2141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ != NULL) {
#line 11238 "gnome-chess.c"
		GtkFileChooserDialog* _tmp3_ = NULL;
#line 2143 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->open_dialog;
#line 2143 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_window_present ((GtkWindow*) _tmp3_);
#line 2144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 11246 "gnome-chess.c"
	}
#line 2147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _ ("Load Chess Game");
#line 2147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->window;
#line 2147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _ ("_Cancel");
#line 2147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _ ("_Open");
#line 2147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp4_, (GtkWindow*) _tmp5_, GTK_FILE_CHOOSER_ACTION_OPEN, _tmp6_, GTK_RESPONSE_CANCEL, _tmp7_, GTK_RESPONSE_OK, NULL, NULL);
#line 2147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp8_);
#line 2147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog);
#line 2147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog = _tmp8_;
#line 2152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->open_dialog;
#line 2152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_add_info_bar_to_dialog (self, (GtkDialog*) _tmp9_, &_tmp10_, &_tmp11_);
#line 2152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_info_bar);
#line 2152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_info_bar = _tmp10_;
#line 2152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_error_label);
#line 2152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_error_label = _tmp11_;
#line 2154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->open_dialog;
#line 2154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkFileChooser*) _tmp12_, "file-activated", (GCallback) ___lambda9__gtk_file_chooser_file_activated, self, 0);
#line 2155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->open_dialog;
#line 2155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkDialog*) _tmp13_, "response", (GCallback) _chess_application_open_dialog_cb_gtk_dialog_response, self, 0);
#line 2158 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = gtk_file_filter_new ();
#line 2158 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp14_);
#line 2158 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	pgn_filter = _tmp14_;
#line 2160 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = pgn_filter;
#line 2160 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = _ ("PGN files");
#line 2160 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp15_, _tmp16_);
#line 2161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = pgn_filter;
#line 2161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp17_, "*.pgn");
#line 2162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = self->priv->open_dialog;
#line 2162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = pgn_filter;
#line 2162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = _g_object_ref0 (_tmp19_);
#line 2162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp18_, _tmp20_);
#line 2164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = gtk_file_filter_new ();
#line 2164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp21_);
#line 2164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	all_filter = _tmp21_;
#line 2166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = all_filter;
#line 2166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = _ ("All files");
#line 2166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp22_, _tmp23_);
#line 2167 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = all_filter;
#line 2167 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp24_, "*");
#line 2168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = self->priv->open_dialog;
#line 2168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = all_filter;
#line 2168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = _g_object_ref0 (_tmp26_);
#line 2168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp25_, _tmp27_);
#line 2170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = self->priv->open_dialog;
#line 2170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_present ((GtkWindow*) _tmp28_);
#line 2135 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (all_filter);
#line 2135 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (pgn_filter);
#line 11340 "gnome-chess.c"
}


static void chess_application_open_dialog_cb (ChessApplication* self, gint response_id) {
	gint _tmp0_ = 0;
	GtkFileChooserDialog* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 2173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2175 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = response_id;
#line 2175 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 11354 "gnome-chess.c"
		{
			GtkFileChooserDialog* _tmp1_ = NULL;
			GFile* _tmp2_ = NULL;
			GFile* _tmp3_ = NULL;
#line 2179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp1_ = self->priv->open_dialog;
#line 2179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp1_);
#line 2179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->game_file);
#line 2179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->game_file = _tmp2_;
#line 2180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp3_ = self->priv->game_file;
#line 2180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_load_game (self, _tmp3_, &_inner_error_);
#line 2180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11373 "gnome-chess.c"
				goto __catch10_g_error;
			}
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			GtkLabel* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			GtkInfoBar* _tmp8_ = NULL;
			GtkInfoBar* _tmp9_ = NULL;
#line 2177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			e = _inner_error_;
#line 2177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_inner_error_ = NULL;
#line 2184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp4_ = e;
#line 2184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp5_ = _tmp4_->message;
#line 2184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:2184: Failed to open game: %s", _tmp5_);
#line 2185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp6_ = self->priv->open_dialog_error_label;
#line 2185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = _ ("Failed to open game");
#line 2185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_label_set_text (_tmp6_, _tmp7_);
#line 2186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = self->priv->open_dialog_info_bar;
#line 2186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_info_bar_set_message_type (_tmp8_, GTK_MESSAGE_ERROR);
#line 2187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp9_ = self->priv->open_dialog_info_bar;
#line 2187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_widget_show ((GtkWidget*) _tmp9_);
#line 2188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_error_free0 (e);
#line 2188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return;
#line 11415 "gnome-chess.c"
		}
		__finally10:
#line 2177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_clear_error (&_inner_error_);
#line 2177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return;
#line 11426 "gnome-chess.c"
		}
	}
#line 2192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->open_dialog;
#line 2192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp10_);
#line 2193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog);
#line 2193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog = NULL;
#line 2194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_info_bar);
#line 2194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_info_bar = NULL;
#line 2195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_error_label);
#line 2195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_error_label = NULL;
#line 11445 "gnome-chess.c"
}


static void chess_application_start_new_game (ChessApplication* self) {
	PGNGame* _tmp0_ = NULL;
	GDateTime* now = NULL;
	GDateTime* _tmp1_ = NULL;
	PGNGame* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	PGNGame* _tmp6_ = NULL;
	GDateTime* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gint duration = 0;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gchar* engine_name = NULL;
	GSettings* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gchar* engine_level = NULL;
	GSettings* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp38_ = NULL;
#line 2198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game_file);
#line 2200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->game_file = NULL;
#line 2202 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->allow_claim_draw_dialog = TRUE;
#line 2203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_disable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
#line 2204 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
#line 2206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = pgn_game_new ();
#line 2206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pgn_game);
#line 2206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->pgn_game = _tmp0_;
#line 2207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = g_date_time_new_now_local ();
#line 2207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	now = _tmp1_;
#line 2208 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->pgn_game;
#line 2208 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = now;
#line 2208 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = g_date_time_format (_tmp3_, "%Y.%m.%d");
#line 2208 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 2208 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	pgn_game_set_date (_tmp2_, _tmp5_);
#line 2208 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp5_);
#line 2209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->pgn_game;
#line 2209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = now;
#line 2209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = g_date_time_format (_tmp7_, "%H:%M:%S");
#line 2209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _tmp8_;
#line 2209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	pgn_game_set_time (_tmp6_, _tmp9_);
#line 2209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp9_);
#line 2210 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->settings;
#line 2210 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = g_settings_get_int (_tmp10_, "duration");
#line 2210 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	duration = _tmp11_;
#line 2211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = duration;
#line 2211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ > 0) {
#line 11530 "gnome-chess.c"
		PGNGame* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		PGNGame* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		PGNGame* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 2213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->pgn_game;
#line 2213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = duration;
#line 2213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = g_strdup_printf ("%i", _tmp14_);
#line 2213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_;
#line 2213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_time_control (_tmp13_, _tmp16_);
#line 2213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp16_);
#line 2214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = self->priv->pgn_game;
#line 2214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = duration;
#line 2214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = g_strdup_printf ("%i", _tmp18_);
#line 2214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp19_;
#line 2214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_white_time_left (_tmp17_, _tmp20_);
#line 2214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp20_);
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = self->priv->pgn_game;
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = duration;
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = g_strdup_printf ("%i", _tmp22_);
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = _tmp23_;
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_black_time_left (_tmp21_, _tmp24_);
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp24_);
#line 11579 "gnome-chess.c"
	}
#line 2217 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = self->priv->settings;
#line 2217 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = g_settings_get_string (_tmp25_, "opponent");
#line 2217 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	engine_name = _tmp26_;
#line 2218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = engine_name;
#line 2218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp27_, "") == 0) {
#line 11591 "gnome-chess.c"
		GList* _tmp28_ = NULL;
#line 2220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = self->priv->ai_profiles;
#line 2220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp28_ != NULL) {
#line 11597 "gnome-chess.c"
			GList* _tmp29_ = NULL;
			gconstpointer _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
#line 2221 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp29_ = self->priv->ai_profiles;
#line 2221 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp30_ = _tmp29_->data;
#line 2221 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp31_ = ai_profile_get_name ((AIProfile*) _tmp30_);
#line 2221 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp32_ = _tmp31_;
#line 2221 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp33_ = g_strdup (_tmp32_);
#line 2221 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (engine_name);
#line 2221 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			engine_name = _tmp33_;
#line 11617 "gnome-chess.c"
		} else {
			gchar* _tmp34_ = NULL;
#line 2223 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp34_ = g_strdup ("human");
#line 2223 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (engine_name);
#line 2223 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			engine_name = _tmp34_;
#line 11626 "gnome-chess.c"
		}
	}
#line 2225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = self->priv->settings;
#line 2225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = g_settings_get_string (_tmp35_, "difficulty");
#line 2225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	engine_level = _tmp36_;
#line 2226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = engine_name;
#line 2226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp38_ != NULL) {
#line 11639 "gnome-chess.c"
		const gchar* _tmp39_ = NULL;
#line 2226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp39_ = engine_name;
#line 2226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = g_strcmp0 (_tmp39_, "human") != 0;
#line 11645 "gnome-chess.c"
	} else {
#line 2226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = FALSE;
#line 11649 "gnome-chess.c"
	}
#line 2226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp37_) {
#line 11653 "gnome-chess.c"
		GSettings* _tmp40_ = NULL;
		gboolean _tmp41_ = FALSE;
#line 2228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp40_ = self->priv->settings;
#line 2228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp41_ = g_settings_get_boolean (_tmp40_, "play-as-white");
#line 2228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp41_) {
#line 11662 "gnome-chess.c"
			PGNGame* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			PGNGame* _tmp44_ = NULL;
			const gchar* _tmp45_ = NULL;
#line 2230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp42_ = self->priv->pgn_game;
#line 2230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp43_ = engine_name;
#line 2230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_black_ai (_tmp42_, _tmp43_);
#line 2231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp44_ = self->priv->pgn_game;
#line 2231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp45_ = engine_level;
#line 2231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_black_level (_tmp44_, _tmp45_);
#line 11679 "gnome-chess.c"
		} else {
			PGNGame* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			PGNGame* _tmp48_ = NULL;
			const gchar* _tmp49_ = NULL;
#line 2235 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp46_ = self->priv->pgn_game;
#line 2235 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = engine_name;
#line 2235 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_white_ai (_tmp46_, _tmp47_);
#line 2236 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp48_ = self->priv->pgn_game;
#line 2236 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp49_ = engine_level;
#line 2236 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_white_level (_tmp48_, _tmp49_);
#line 11697 "gnome-chess.c"
		}
	}
#line 2240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_start_game (self);
#line 2198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (engine_level);
#line 2198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (engine_name);
#line 2198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_date_time_unref0 (now);
#line 11708 "gnome-chess.c"
}


static void chess_application_load_game (ChessApplication* self, GFile* file, GError** error) {
	PGN* pgn = NULL;
	GFile* _tmp0_ = NULL;
	PGN* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	PGNGame* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 2243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (file != NULL);
#line 2245 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_enable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
#line 2247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = file;
#line 2247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = pgn_new_from_file (_tmp0_, &_inner_error_);
#line 2247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	pgn = _tmp1_;
#line 2247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_propagate_error (error, _inner_error_);
#line 2247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 11740 "gnome-chess.c"
	}
#line 2248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = pgn->games;
#line 2248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
#line 2248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _g_object_ref0 ((PGNGame*) _tmp3_);
#line 2248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pgn_game);
#line 2248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->pgn_game = _tmp4_;
#line 2250 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = file;
#line 2250 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 2250 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game_file);
#line 2250 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->game_file = _tmp6_;
#line 2251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_start_game (self);
#line 2243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (pgn);
#line 11764 "gnome-chess.c"
}


static void chess_application_enable_window_action (ChessApplication* self, const gchar* name) {
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
#line 2254 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2254 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (name != NULL);
#line 2256 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 2256 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = name;
#line 2256 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, _tmp1_);
#line 2256 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction), TRUE);
#line 11784 "gnome-chess.c"
}


static void chess_application_disable_window_action (ChessApplication* self, const gchar* name) {
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
#line 2259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (name != NULL);
#line 2261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 2261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = name;
#line 2261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, _tmp1_);
#line 2261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction), FALSE);
#line 11804 "gnome-chess.c"
}


gint chess_application_main (gchar** args, int args_length1) {
	gint result = 0;
	ChessApplication* _tmp0_ = NULL;
	ChessApplication* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 2266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = chess_application_new ();
#line 2266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = _tmp0_;
#line 2266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = args;
#line 2266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2__length1 = args_length1;
#line 2266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = g_application_run ((GApplication*) _tmp1_, _tmp2__length1, _tmp2_);
#line 2266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_;
#line 2266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (_tmp1_);
#line 2266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = _tmp4_;
#line 2266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 11834 "gnome-chess.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 2264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return chess_application_main (argv, argc);
#line 11844 "gnome-chess.c"
}


static void chess_application_class_init (ChessApplicationClass * klass) {
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_type_class_add_private (klass, sizeof (ChessApplicationPrivate));
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	((GApplicationClass *) klass)->handle_local_options = chess_application_real_handle_local_options;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	((GApplicationClass *) klass)->open = chess_application_real_open;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	((GApplicationClass *) klass)->startup = chess_application_real_startup;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	((GApplicationClass *) klass)->shutdown = chess_application_real_shutdown;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	((GApplicationClass *) klass)->activate = chess_application_real_activate;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_application_finalize;
#line 11865 "gnome-chess.c"
}


static void chess_application_instance_init (ChessApplication * self) {
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv = CHESS_APPLICATION_GET_PRIVATE (self);
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->preferences_dialog = NULL;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_duration_timeout = (guint) 0;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog = NULL;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_info_bar = NULL;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_error_label = NULL;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog = NULL;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_info_bar = NULL;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_error_label = NULL;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->about_dialog = NULL;
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->game_needs_saving = FALSE;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->allow_claim_draw_dialog = TRUE;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->starting = TRUE;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->opponent = NULL;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->human_player = NULL;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->opponent_engine = NULL;
#line 11902 "gnome-chess.c"
}


static void chess_application_finalize (GObject* obj) {
	ChessApplication * self;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_APPLICATION, ChessApplication);
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->settings);
#line 16 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->builder);
#line 17 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->preferences_builder);
#line 18 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->window);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->view_container);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->scene);
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->view);
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pause_resume_button);
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->first_move_button);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->prev_move_button);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->next_move_button);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->last_move_button);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->history_combo);
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->white_time_label);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->black_time_label);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->side_combo);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->difficulty_combo);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_combo);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_adjustment);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_box);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_units_combo);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_info_bar);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_error_label);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_info_bar);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_error_label);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->about_dialog);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pgn_game);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (self->priv->autosave_filename);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game_file);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	__g_list_free__g_object_unref0_0 (self->priv->ai_profiles);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->opponent);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->human_player);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->opponent_engine);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	G_OBJECT_CLASS (chess_application_parent_class)->finalize (obj);
#line 11988 "gnome-chess.c"
}


GType chess_application_get_type (void) {
	static volatile gsize chess_application_type_id__volatile = 0;
	if (g_once_init_enter (&chess_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessApplication), 0, (GInstanceInitFunc) chess_application_instance_init, NULL };
		GType chess_application_type_id;
		chess_application_type_id = g_type_register_static (gtk_application_get_type (), "ChessApplication", &g_define_type_info, 0);
		g_once_init_leave (&chess_application_type_id__volatile, chess_application_type_id);
	}
	return chess_application_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



