/* rygel-mediathek-rss-container.c generated by valac 0.26.0.3-ba43c, the Vala compiler
 * generated from rygel-mediathek-rss-container.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Jens Georg
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libgupnp/gupnp.h>
#include <libxml/xpath.h>


#define RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER (rygel_mediathek_rss_container_get_type ())
#define RYGEL_MEDIATHEK_RSS_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, RygelMediathekRssContainer))
#define RYGEL_MEDIATHEK_RSS_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, RygelMediathekRssContainerClass))
#define RYGEL_MEDIATHEK_IS_RSS_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER))
#define RYGEL_MEDIATHEK_IS_RSS_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER))
#define RYGEL_MEDIATHEK_RSS_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, RygelMediathekRssContainerClass))

typedef struct _RygelMediathekRssContainer RygelMediathekRssContainer;
typedef struct _RygelMediathekRssContainerClass RygelMediathekRssContainerClass;
typedef struct _RygelMediathekRssContainerPrivate RygelMediathekRssContainerPrivate;
#define __vala_SoupDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupDate_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _RygelMediathekRssContainerUpdateData RygelMediathekRssContainerUpdateData;

#define RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY (rygel_mediathek_video_item_factory_get_type ())
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY, RygelMediathekVideoItemFactory))
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY, RygelMediathekVideoItemFactoryClass))
#define RYGEL_MEDIATHEK_IS_VIDEO_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY))
#define RYGEL_MEDIATHEK_IS_VIDEO_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY))
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY, RygelMediathekVideoItemFactoryClass))

typedef struct _RygelMediathekVideoItemFactory RygelMediathekVideoItemFactory;
typedef struct _RygelMediathekVideoItemFactoryClass RygelMediathekVideoItemFactoryClass;
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))

#define RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM (rygel_mediathek_video_item_get_type ())
#define RYGEL_MEDIATHEK_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM, RygelMediathekVideoItem))
#define RYGEL_MEDIATHEK_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM, RygelMediathekVideoItemClass))
#define RYGEL_MEDIATHEK_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIATHEK_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIATHEK_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM, RygelMediathekVideoItemClass))

typedef struct _RygelMediathekVideoItem RygelMediathekVideoItem;
typedef struct _RygelMediathekVideoItemClass RygelMediathekVideoItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediathekRssContainerParseResponseData RygelMediathekRssContainerParseResponseData;
typedef struct _RygelMediathekRssContainerAddChildData RygelMediathekRssContainerAddChildData;

struct _RygelMediathekRssContainer {
	RygelSimpleContainer parent_instance;
	RygelMediathekRssContainerPrivate * priv;
};

struct _RygelMediathekRssContainerClass {
	RygelSimpleContainerClass parent_class;
};

struct _RygelMediathekRssContainerPrivate {
	guint content_id;
	SoupDate* last_modified;
	gchar* feed_uri;
};

struct _Block2Data {
	int _ref_count_;
	RygelMediathekRssContainer* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediathekRssContainerUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediathekRssContainer* self;
	Block2Data* _data2_;
	SoupMessage* message;
	SoupMessage* _tmp0_;
	SoupSession* session;
	SoupSession* _tmp1_;
	SoupSession* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	SoupMessage* _tmp8_;
	SoupURI* _tmp9_;
	SoupURI* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gboolean success;
	SoupMessage* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gchar* date;
	SoupMessage* _tmp16_;
	SoupMessageHeaders* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	SoupDate* _tmp21_;
	SoupMessage* _tmp22_;
	guint _tmp23_;
	guint _tmp24_;
	SoupMessage* _tmp25_;
	SoupURI* _tmp26_;
	SoupURI* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	SoupMessage* _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	const gchar* _tmp33_;
};

typedef enum  {
	RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR,
	RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_NETWORK_ERROR
} RygelMediathekVideoItemError;
#define RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR rygel_mediathek_video_item_error_quark ()
struct _RygelMediathekRssContainerParseResponseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediathekRssContainer* self;
	SoupMessage* message;
	gboolean result;
	RygelMediathekVideoItemFactory* factory;
	RygelMediathekVideoItemFactory* _tmp0_;
	SoupMessageBody* response;
	SoupMessage* _tmp1_;
	SoupMessageBody* _tmp2_;
	xmlDoc* doc;
	SoupMessageBody* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	SoupMessageBody* _tmp5_;
	gint64 _tmp6_;
	xmlDoc* _tmp7_;
	xmlDoc* _tmp8_;
	GUPnPXMLDoc* guard;
	xmlDoc* _tmp9_;
	GUPnPXMLDoc* _tmp10_;
	xmlXPathContext* context;
	GUPnPXMLDoc* _tmp11_;
	xmlDoc* _tmp12_;
	xmlXPathContext* _tmp13_;
	xmlXPathObject* xpath_object;
	xmlXPathContext* _tmp14_;
	xmlXPathObject* _tmp15_;
	gboolean _tmp16_;
	xmlXPathObject* _tmp17_;
	xmlXPathObjectType _tmp18_;
	xmlXPathObject* _tmp19_;
	xmlNodeSet* _tmp20_;
	gint _tmp21_;
	xmlXPathObject* _tmp22_;
	xmlNodeSet* _tmp23_;
	xmlNode* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	xmlXPathObject* _tmp27_;
	xmlXPathContext* _tmp28_;
	xmlXPathObject* _tmp29_;
	xmlXPathObject* _tmp30_;
	xmlXPathObjectType _tmp31_;
	xmlXPathObject* _tmp32_;
	gint i;
	gboolean _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	xmlXPathObject* _tmp36_;
	xmlNodeSet* _tmp37_;
	gint _tmp38_;
	xmlNode* node;
	xmlXPathObject* _tmp39_;
	xmlNodeSet* _tmp40_;
	gint _tmp41_;
	xmlNode* _tmp42_;
	RygelMediathekVideoItem* item;
	RygelMediathekVideoItemFactory* _tmp43_;
	xmlNode* _tmp44_;
	RygelMediathekVideoItem* _tmp45_;
	RygelMediathekVideoItem* _tmp46_;
	RygelMediathekVideoItem* _tmp47_;
	GError* _error_;
	GError* _tmp48_;
	const gchar* _tmp49_;
	xmlXPathObject* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	GError * _inner_error_;
};

struct _RygelMediathekRssContainerAddChildData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediathekRssContainer* self;
	RygelMediaObject* object;
	RygelMediaObject* _tmp0_;
};


static gpointer rygel_mediathek_rss_container_parent_class = NULL;
static RygelTrackableContainerIface* rygel_mediathek_rss_container_rygel_trackable_container_parent_iface = NULL;

GType rygel_mediathek_rss_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIATHEK_RSS_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, RygelMediathekRssContainerPrivate))
enum  {
	RYGEL_MEDIATHEK_RSS_CONTAINER_DUMMY_PROPERTY
};
static void _vala_SoupDate_free (SoupDate* self);
#define RYGEL_MEDIATHEK_RSS_CONTAINER_URI_TEMPLATE "http://www.zdf.de/ZDFmediathek/" "content/%u?view=rss"
RygelMediathekRssContainer* rygel_mediathek_rss_container_new (RygelMediaContainer* parent, guint id);
RygelMediathekRssContainer* rygel_mediathek_rss_container_construct (GType object_type, RygelMediaContainer* parent, guint id);
void rygel_mediathek_rss_container_update (RygelMediathekRssContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_mediathek_rss_container_update_finish (RygelMediathekRssContainer* self, GAsyncResult* _res_);
static void rygel_mediathek_rss_container_update_data_free (gpointer _data);
static gboolean rygel_mediathek_rss_container_update_co (RygelMediathekRssContainerUpdateData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static SoupMessage* rygel_mediathek_rss_container_get_update_message (RygelMediathekRssContainer* self);
SoupSession* rygel_mediathek_root_container_get_default_session (void);
static gboolean _rygel_mediathek_rss_container_update_co_gsource_func (gpointer self);
static void __lambda5_ (Block2Data* _data2_);
static void ___lambda5__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void rygel_mediathek_rss_container_parse_response (RygelMediathekRssContainer* self, SoupMessage* message, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_mediathek_rss_container_parse_response_finish (RygelMediathekRssContainer* self, GAsyncResult* _res_);
static void rygel_mediathek_rss_container_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_mediathek_rss_container_parse_response_data_free (gpointer _data);
static gboolean rygel_mediathek_rss_container_parse_response_co (RygelMediathekRssContainerParseResponseData* _data_);
GType rygel_mediathek_video_item_factory_get_type (void) G_GNUC_CONST;
RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_get_default (void);
void xmlXPathFreeObject (xmlXPathObject* object);
static void rygel_mediathek_rss_container_parse_response_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_mediathek_video_item_get_type (void) G_GNUC_CONST;
void rygel_mediathek_video_item_factory_create (RygelMediathekVideoItemFactory* self, RygelMediaContainer* parent, xmlNode* xml_item, GAsyncReadyCallback _callback_, gpointer _user_data_);
GQuark rygel_mediathek_video_item_error_quark (void);
RygelMediathekVideoItem* rygel_mediathek_video_item_factory_create_finish (RygelMediathekVideoItemFactory* self, GAsyncResult* _res_, GError** error);
static void rygel_mediathek_rss_container_real_add_child_data_free (gpointer _data);
static void rygel_mediathek_rss_container_real_add_child (RygelTrackableContainer* base, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_mediathek_rss_container_real_add_child_co (RygelMediathekRssContainerAddChildData* _data_);
static void rygel_mediathek_rss_container_finalize (GObject* obj);


static void _vala_SoupDate_free (SoupDate* self) {
	g_boxed_free (soup_date_get_type (), self);
}


RygelMediathekRssContainer* rygel_mediathek_rss_container_construct (GType object_type, RygelMediaContainer* parent, guint id) {
	RygelMediathekRssContainer * self = NULL;
	guint _tmp0_ = 0U;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelMediaContainer* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	gchar* _tmp9_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = g_strdup_printf ("GroupId:%u", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = parent;
	_tmp4_ = id;
	_tmp5_ = g_strdup_printf ("ZDF Mediathek RSS feed %u", _tmp4_);
	_tmp6_ = _tmp5_;
	self = (RygelMediathekRssContainer*) rygel_simple_container_construct (object_type, _tmp2_, _tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp2_);
	_tmp7_ = id;
	self->priv->content_id = _tmp7_;
	_tmp8_ = id;
	_tmp9_ = g_strdup_printf (RYGEL_MEDIATHEK_RSS_CONTAINER_URI_TEMPLATE, _tmp8_);
	_g_free0 (self->priv->feed_uri);
	self->priv->feed_uri = _tmp9_;
	rygel_media_container_set_sort_criteria ((RygelMediaContainer*) self, "-dc:date,+dc:title");
	rygel_mediathek_rss_container_update (self, NULL, NULL);
	return self;
}


RygelMediathekRssContainer* rygel_mediathek_rss_container_new (RygelMediaContainer* parent, guint id) {
	return rygel_mediathek_rss_container_construct (RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, parent, id);
}


static void rygel_mediathek_rss_container_update_data_free (gpointer _data) {
	RygelMediathekRssContainerUpdateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediathekRssContainerUpdateData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_mediathek_rss_container_update (RygelMediathekRssContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediathekRssContainerUpdateData* _data_;
	RygelMediathekRssContainer* _tmp0_ = NULL;
	_data_ = g_slice_new0 (RygelMediathekRssContainerUpdateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_mediathek_rss_container_update);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_mediathek_rss_container_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_mediathek_rss_container_update_co (_data_);
}


void rygel_mediathek_rss_container_update_finish (RygelMediathekRssContainer* self, GAsyncResult* _res_) {
	RygelMediathekRssContainerUpdateData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		RygelMediathekRssContainer* self;
		self = _data2_->self;
		(_data2_->callback_target_destroy_notify == NULL) ? NULL : (_data2_->callback_target_destroy_notify (_data2_->callback_target), NULL);
		_data2_->callback = NULL;
		_data2_->callback_target = NULL;
		_data2_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _rygel_mediathek_rss_container_update_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_mediathek_rss_container_update_co (self);
	return result;
}


static void __lambda5_ (Block2Data* _data2_) {
	RygelMediathekRssContainer* self;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	self = _data2_->self;
	_tmp0_ = _data2_->callback;
	_tmp0__target = _data2_->callback_target;
	_tmp0_ (_tmp0__target);
}


static void ___lambda5__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda5_ (self);
	block2_data_unref (self);
}


static void rygel_mediathek_rss_container_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediathekRssContainerUpdateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_mediathek_rss_container_update_co (_data_);
}


static gboolean rygel_mediathek_rss_container_update_co (RygelMediathekRssContainerUpdateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = rygel_mediathek_rss_container_get_update_message (_data_->self);
	_data_->message = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = rygel_mediathek_root_container_get_default_session ();
	_data_->session = _data_->_tmp1_;
	_data_->_data2_->callback = _rygel_mediathek_rss_container_update_co_gsource_func;
	_data_->_data2_->callback_target = _data_;
	_data_->_data2_->callback_target_destroy_notify = NULL;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->session;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->message;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
	soup_session_queue_message (_data_->_tmp2_, _data_->_tmp4_, ___lambda5__soup_session_callback, block2_data_ref (_data_->_data2_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->message;
	_data_->_tmp6_ = 0U;
	g_object_get (_data_->_tmp5_, "status-code", &_data_->_tmp6_, NULL);
	_data_->_tmp7_ = 0U;
	_data_->_tmp7_ = _data_->_tmp6_;
	switch (_data_->_tmp7_) {
		case 304:
		{
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->message;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = soup_message_get_uri (_data_->_tmp8_);
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = soup_uri_to_string (_data_->_tmp10_, FALSE);
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->_tmp11_;
			g_debug ("rygel-mediathek-rss-container.vala:57: Feed at %s did not change, noth" \
"ing to do.", _data_->_tmp12_);
			_g_free0 (_data_->_tmp12_);
			break;
		}
		case 200:
		{
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->message;
			_data_->_state_ = 2;
			rygel_mediathek_rss_container_parse_response (_data_->self, _data_->_tmp13_, rygel_mediathek_rss_container_update_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp14_ = FALSE;
			_data_->_tmp14_ = rygel_mediathek_rss_container_parse_response_finish (_data_->self, _data_->_res_);
			_data_->success = _data_->_tmp14_;
			_data_->_tmp15_ = FALSE;
			_data_->_tmp15_ = _data_->success;
			if (_data_->_tmp15_) {
				_data_->_tmp16_ = NULL;
				_data_->_tmp16_ = _data_->message;
				_data_->_tmp17_ = NULL;
				_data_->_tmp17_ = _data_->_tmp16_->response_headers;
				_data_->_tmp18_ = NULL;
				_data_->_tmp18_ = soup_message_headers_get_one (_data_->_tmp17_, "Date");
				_data_->_tmp19_ = NULL;
				_data_->_tmp19_ = g_strdup (_data_->_tmp18_);
				_data_->date = _data_->_tmp19_;
				_data_->_tmp20_ = NULL;
				_data_->_tmp20_ = _data_->date;
				_data_->_tmp21_ = NULL;
				_data_->_tmp21_ = soup_date_new_from_string (_data_->_tmp20_);
				__vala_SoupDate_free0 (_data_->self->priv->last_modified);
				_data_->self->priv->last_modified = _data_->_tmp21_;
				_g_free0 (_data_->date);
			}
			break;
		}
		default:
		{
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _data_->message;
			_data_->_tmp23_ = 0U;
			g_object_get (_data_->_tmp22_, "status-code", &_data_->_tmp23_, NULL);
			_data_->_tmp24_ = 0U;
			_data_->_tmp24_ = _data_->_tmp23_;
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->message;
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = soup_message_get_uri (_data_->_tmp25_);
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = _data_->_tmp26_;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = soup_uri_to_string (_data_->_tmp27_, FALSE);
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = _data_->_tmp28_;
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = _data_->message;
			_data_->_tmp31_ = 0U;
			g_object_get (_data_->_tmp30_, "status-code", &_data_->_tmp31_, NULL);
			_data_->_tmp32_ = 0U;
			_data_->_tmp32_ = _data_->_tmp31_;
			_data_->_tmp33_ = NULL;
			_data_->_tmp33_ = soup_status_get_phrase (_data_->_tmp32_);
			g_warning ("rygel-mediathek-rss-container.vala:69: Unexpected response %u for %s: " \
"%s", _data_->_tmp24_, _data_->_tmp29_, _data_->_tmp33_);
			_g_free0 (_data_->_tmp29_);
			break;
		}
	}
	_g_object_unref0 (_data_->session);
	_g_object_unref0 (_data_->message);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_mediathek_rss_container_parse_response_data_free (gpointer _data) {
	RygelMediathekRssContainerParseResponseData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediathekRssContainerParseResponseData, _data_);
}


static void rygel_mediathek_rss_container_parse_response (RygelMediathekRssContainer* self, SoupMessage* message, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediathekRssContainerParseResponseData* _data_;
	RygelMediathekRssContainer* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessage* _tmp2_ = NULL;
	_data_ = g_slice_new0 (RygelMediathekRssContainerParseResponseData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_mediathek_rss_container_parse_response);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_mediathek_rss_container_parse_response_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = message;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->message);
	_data_->message = _tmp2_;
	rygel_mediathek_rss_container_parse_response_co (_data_);
}


static gboolean rygel_mediathek_rss_container_parse_response_finish (RygelMediathekRssContainer* self, GAsyncResult* _res_) {
	gboolean result;
	RygelMediathekRssContainerParseResponseData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void rygel_mediathek_rss_container_parse_response_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediathekRssContainerParseResponseData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_mediathek_rss_container_parse_response_co (_data_);
}


static gboolean rygel_mediathek_rss_container_parse_response_co (RygelMediathekRssContainerParseResponseData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = rygel_mediathek_video_item_factory_get_default ();
	_data_->factory = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->message;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_->response_body;
	_data_->response = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->response;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4__length1 = 0;
	_data_->_tmp4_ = _data_->_tmp3_->data;
	_data_->_tmp4__length1 = (gint) _data_->_tmp3_->length;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->response;
	_data_->_tmp6_ = 0LL;
	_data_->_tmp6_ = _data_->_tmp5_->length;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = xmlParseMemory ((const gchar*) _data_->_tmp4_, (gint) _data_->_tmp6_);
	_data_->doc = _data_->_tmp7_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->doc;
	if (_data_->_tmp8_ == NULL) {
		g_warning ("rygel-mediathek-rss-container.vala:84: Failed to parse XML document");
		_data_->result = FALSE;
		_g_object_unref0 (_data_->factory);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->doc;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = gupnp_xml_doc_new (_data_->_tmp9_);
	_data_->guard = _data_->_tmp10_;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->guard;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->_tmp11_->doc;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = xmlXPathNewContext (_data_->_tmp12_);
	_data_->context = _data_->_tmp13_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->context;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = xmlXPathEval ((xmlChar*) "/rss/channel/title", _data_->_tmp14_);
	_data_->xpath_object = _data_->_tmp15_;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->xpath_object;
	_data_->_tmp18_ = 0;
	_data_->_tmp18_ = _data_->_tmp17_->type;
	if (_data_->_tmp18_ == XPATH_NODESET) {
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->xpath_object;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->_tmp19_->nodesetval;
		_data_->_tmp21_ = 0;
		_data_->_tmp21_ = xmlXPathNodeSetGetLength (_data_->_tmp20_);
		_data_->_tmp16_ = _data_->_tmp21_ > 0;
	} else {
		_data_->_tmp16_ = FALSE;
	}
	if (_data_->_tmp16_) {
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->xpath_object;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->_tmp22_->nodesetval;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = xmlXPathNodeSetItem (_data_->_tmp23_, 0);
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = (gchar*) xmlNodeGetContent (_data_->_tmp24_);
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->_tmp25_;
		rygel_media_object_set_title ((RygelMediaObject*) _data_->self, _data_->_tmp26_);
		_g_free0 (_data_->_tmp26_);
	}
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = _data_->xpath_object;
	xmlXPathFreeObject (_data_->_tmp27_);
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->context;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = xmlXPathEval ((xmlChar*) "/rss/channel/item", _data_->_tmp28_);
	_data_->xpath_object = _data_->_tmp29_;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->xpath_object;
	_data_->_tmp31_ = 0;
	_data_->_tmp31_ = _data_->_tmp30_->type;
	if (_data_->_tmp31_ != XPATH_NODESET) {
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = _data_->xpath_object;
		xmlXPathFreeObject (_data_->_tmp32_);
		g_warning ("rygel-mediathek-rss-container.vala:102: RSS feed doesn't have items");
		_data_->result = FALSE;
		_xmlXPathFreeContext0 (_data_->context);
		_g_object_unref0 (_data_->guard);
		_g_object_unref0 (_data_->factory);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 1;
	rygel_trackable_container_clear ((RygelTrackableContainer*) _data_->self, rygel_mediathek_rss_container_parse_response_ready, _data_);
	return FALSE;
	_state_1:
	rygel_trackable_container_clear_finish ((RygelTrackableContainer*) _data_->self, _data_->_res_);
	rygel_media_container_set_child_count ((RygelMediaContainer*) _data_->self, 0);
	{
		_data_->i = 0;
		{
			_data_->_tmp33_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp33_) {
					_data_->_tmp34_ = 0;
					_data_->_tmp34_ = _data_->i;
					_data_->i = _data_->_tmp34_ + 1;
				}
				_data_->_tmp33_ = FALSE;
				_data_->_tmp35_ = 0;
				_data_->_tmp35_ = _data_->i;
				_data_->_tmp36_ = NULL;
				_data_->_tmp36_ = _data_->xpath_object;
				_data_->_tmp37_ = NULL;
				_data_->_tmp37_ = _data_->_tmp36_->nodesetval;
				_data_->_tmp38_ = 0;
				_data_->_tmp38_ = xmlXPathNodeSetGetLength (_data_->_tmp37_);
				if (!(_data_->_tmp35_ < _data_->_tmp38_)) {
					break;
				}
				_data_->_tmp39_ = NULL;
				_data_->_tmp39_ = _data_->xpath_object;
				_data_->_tmp40_ = NULL;
				_data_->_tmp40_ = _data_->_tmp39_->nodesetval;
				_data_->_tmp41_ = 0;
				_data_->_tmp41_ = _data_->i;
				_data_->_tmp42_ = NULL;
				_data_->_tmp42_ = xmlXPathNodeSetItem (_data_->_tmp40_, _data_->_tmp41_);
				_data_->node = _data_->_tmp42_;
				{
					_data_->_tmp43_ = NULL;
					_data_->_tmp43_ = _data_->factory;
					_data_->_tmp44_ = NULL;
					_data_->_tmp44_ = _data_->node;
					_data_->_state_ = 2;
					rygel_mediathek_video_item_factory_create (_data_->_tmp43_, (RygelMediaContainer*) _data_->self, _data_->_tmp44_, rygel_mediathek_rss_container_parse_response_ready, _data_);
					return FALSE;
					_state_2:
					_data_->_tmp45_ = NULL;
					_data_->_tmp45_ = rygel_mediathek_video_item_factory_create_finish (_data_->_tmp43_, _data_->_res_, &_data_->_inner_error_);
					_data_->item = _data_->_tmp45_;
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						if (_data_->_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
							goto __catch5_rygel_mediathek_video_item_error;
						}
						_xmlXPathFreeContext0 (_data_->context);
						_g_object_unref0 (_data_->guard);
						_g_object_unref0 (_data_->factory);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						return FALSE;
					}
					_data_->_tmp46_ = NULL;
					_data_->_tmp46_ = _data_->item;
					if (_data_->_tmp46_ != NULL) {
						_data_->_tmp47_ = NULL;
						_data_->_tmp47_ = _data_->item;
						_data_->_state_ = 3;
						rygel_trackable_container_add_child_tracked ((RygelTrackableContainer*) _data_->self, (RygelMediaObject*) _data_->_tmp47_, rygel_mediathek_rss_container_parse_response_ready, _data_);
						return FALSE;
						_state_3:
						rygel_trackable_container_add_child_tracked_finish ((RygelTrackableContainer*) _data_->self, _data_->_res_);
					}
					_g_object_unref0 (_data_->item);
				}
				goto __finally5;
				__catch5_rygel_mediathek_video_item_error:
				{
					_data_->_error_ = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp48_ = NULL;
					_data_->_tmp48_ = _data_->_error_;
					_data_->_tmp49_ = NULL;
					_data_->_tmp49_ = _data_->_tmp48_->message;
					g_debug ("rygel-mediathek-rss-container.vala:117: Could not create video item: %" \
"s, skipping", _data_->_tmp49_);
					_g_error_free0 (_data_->_error_);
				}
				__finally5:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_xmlXPathFreeContext0 (_data_->context);
					_g_object_unref0 (_data_->guard);
					_g_object_unref0 (_data_->factory);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
		}
	}
	_data_->_tmp50_ = NULL;
	_data_->_tmp50_ = _data_->xpath_object;
	xmlXPathFreeObject (_data_->_tmp50_);
	_data_->_tmp51_ = 0;
	_data_->_tmp51_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _data_->self);
	_data_->_tmp52_ = 0;
	_data_->_tmp52_ = _data_->_tmp51_;
	_data_->result = _data_->_tmp52_ > 0;
	_xmlXPathFreeContext0 (_data_->context);
	_g_object_unref0 (_data_->guard);
	_g_object_unref0 (_data_->factory);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_xmlXPathFreeContext0 (_data_->context);
	_g_object_unref0 (_data_->guard);
	_g_object_unref0 (_data_->factory);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static SoupMessage* rygel_mediathek_rss_container_get_update_message (RygelMediathekRssContainer* self) {
	SoupMessage* result = NULL;
	SoupMessage* message = NULL;
	const gchar* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupDate* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->feed_uri;
	_tmp1_ = soup_message_new ("GET", _tmp0_);
	message = _tmp1_;
	_tmp2_ = self->priv->last_modified;
	if (_tmp2_ != NULL) {
		gchar* datestring = NULL;
		SoupDate* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		SoupMessage* _tmp6_ = NULL;
		SoupMessageHeaders* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp3_ = self->priv->last_modified;
		_tmp4_ = soup_date_to_string (_tmp3_, SOUP_DATE_HTTP);
		datestring = _tmp4_;
		_tmp5_ = datestring;
		g_debug ("rygel-mediathek-rss-container.vala:132: Requesting change since %s", _tmp5_);
		_tmp6_ = message;
		_tmp7_ = _tmp6_->request_headers;
		_tmp8_ = datestring;
		soup_message_headers_append (_tmp7_, "If-Modified-Since", _tmp8_);
		_g_free0 (datestring);
	}
	result = message;
	return result;
}


static void rygel_mediathek_rss_container_real_add_child_data_free (gpointer _data) {
	RygelMediathekRssContainerAddChildData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->object);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediathekRssContainerAddChildData, _data_);
}


static void rygel_mediathek_rss_container_real_add_child (RygelTrackableContainer* base, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediathekRssContainer * self;
	RygelMediathekRssContainerAddChildData* _data_;
	RygelMediathekRssContainer* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaObject* _tmp2_ = NULL;
	self = (RygelMediathekRssContainer*) base;
	_data_ = g_slice_new0 (RygelMediathekRssContainerAddChildData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_mediathek_rss_container_real_add_child);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_mediathek_rss_container_real_add_child_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = object;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->object);
	_data_->object = _tmp2_;
	rygel_mediathek_rss_container_real_add_child_co (_data_);
}


static void rygel_mediathek_rss_container_real_add_child_finish (RygelTrackableContainer* base, GAsyncResult* _res_) {
	RygelMediathekRssContainerAddChildData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean rygel_mediathek_rss_container_real_add_child_co (RygelMediathekRssContainerAddChildData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->object;
	rygel_simple_container_add_child_item ((RygelSimpleContainer*) _data_->self, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp0_) : NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_mediathek_rss_container_class_init (RygelMediathekRssContainerClass * klass) {
	rygel_mediathek_rss_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediathekRssContainerPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_mediathek_rss_container_finalize;
}


static void rygel_mediathek_rss_container_rygel_trackable_container_interface_init (RygelTrackableContainerIface * iface) {
	rygel_mediathek_rss_container_rygel_trackable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_child = (void (*)(RygelTrackableContainer*, RygelMediaObject*)) rygel_mediathek_rss_container_real_add_child;
	iface->add_child_finish = rygel_mediathek_rss_container_real_add_child_finish;
	iface->remove_child = (void (*)(RygelTrackableContainer*, RygelMediaObject*)) rygel_simple_container_remove_child;
}


static void rygel_mediathek_rss_container_instance_init (RygelMediathekRssContainer * self) {
	self->priv = RYGEL_MEDIATHEK_RSS_CONTAINER_GET_PRIVATE (self);
	self->priv->last_modified = NULL;
}


static void rygel_mediathek_rss_container_finalize (GObject* obj) {
	RygelMediathekRssContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, RygelMediathekRssContainer);
	__vala_SoupDate_free0 (self->priv->last_modified);
	_g_free0 (self->priv->feed_uri);
	G_OBJECT_CLASS (rygel_mediathek_rss_container_parent_class)->finalize (obj);
}


GType rygel_mediathek_rss_container_get_type (void) {
	static volatile gsize rygel_mediathek_rss_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mediathek_rss_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediathekRssContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mediathek_rss_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediathekRssContainer), 0, (GInstanceInitFunc) rygel_mediathek_rss_container_instance_init, NULL };
		static const GInterfaceInfo rygel_trackable_container_info = { (GInterfaceInitFunc) rygel_mediathek_rss_container_rygel_trackable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_mediathek_rss_container_type_id;
		rygel_mediathek_rss_container_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelMediathekRssContainer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_mediathek_rss_container_type_id, RYGEL_TYPE_TRACKABLE_CONTAINER, &rygel_trackable_container_info);
		g_once_init_leave (&rygel_mediathek_rss_container_type_id__volatile, rygel_mediathek_rss_container_type_id);
	}
	return rygel_mediathek_rss_container_type_id__volatile;
}



