/* rygel-thumbnail.c generated by valac 0.25.3.10-37e0, the Vala compiler
 * generated from rygel-thumbnail.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelThumbnail {
	RygelIconInfo parent_instance;
	RygelThumbnailPrivate * priv;
	gchar* dlna_profile;
};

struct _RygelThumbnailClass {
	RygelIconInfoClass parent_class;
	GUPnPDIDLLiteResource* (*add_resource) (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const gchar* protocol);
};


static gpointer rygel_thumbnail_parent_class = NULL;

GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_thumbnail_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
GUPnPDIDLLiteResource* rygel_thumbnail_add_resource (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const gchar* protocol);
static GUPnPDIDLLiteResource* rygel_thumbnail_real_add_resource (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const gchar* protocol);
static GUPnPProtocolInfo* rygel_thumbnail_get_protocol_info (RygelThumbnail* self, const gchar* protocol);
static void rygel_thumbnail_finalize (RygelIconInfo* obj);


RygelThumbnail* rygel_thumbnail_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension) {
	RygelThumbnail* self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (mime_type != NULL, NULL);
	g_return_val_if_fail (dlna_profile != NULL, NULL);
	g_return_val_if_fail (file_extension != NULL, NULL);
	_tmp0_ = mime_type;
	_tmp1_ = file_extension;
	self = (RygelThumbnail*) rygel_icon_info_construct (object_type, _tmp0_, _tmp1_);
	_tmp2_ = dlna_profile;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->dlna_profile);
	self->dlna_profile = _tmp3_;
	return self;
}


RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension) {
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL, mime_type, dlna_profile, file_extension);
}


static GUPnPDIDLLiteResource* rygel_thumbnail_real_add_resource (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const gchar* protocol) {
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* res = NULL;
	GUPnPDIDLLiteItem* _tmp0_ = NULL;
	GUPnPDIDLLiteResource* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPDIDLLiteResource* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	GUPnPDIDLLiteResource* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GUPnPDIDLLiteResource* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GUPnPDIDLLiteResource* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GUPnPDIDLLiteResource* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GUPnPProtocolInfo* _tmp15_ = NULL;
	GUPnPProtocolInfo* _tmp16_ = NULL;
	g_return_val_if_fail (didl_item != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = didl_item;
	_tmp1_ = gupnp_didl_lite_object_add_resource ((GUPnPDIDLLiteObject*) _tmp0_);
	res = _tmp1_;
	_tmp2_ = ((RygelIconInfo*) self)->uri;
	if (_tmp2_ != NULL) {
		GUPnPDIDLLiteResource* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = res;
		_tmp4_ = ((RygelIconInfo*) self)->uri;
		gupnp_didl_lite_resource_set_uri (_tmp3_, _tmp4_);
	}
	_tmp5_ = res;
	_tmp6_ = ((RygelIconInfo*) self)->size;
	gupnp_didl_lite_resource_set_size64 (_tmp5_, _tmp6_);
	_tmp7_ = res;
	_tmp8_ = ((RygelIconInfo*) self)->width;
	gupnp_didl_lite_resource_set_width (_tmp7_, _tmp8_);
	_tmp9_ = res;
	_tmp10_ = ((RygelIconInfo*) self)->height;
	gupnp_didl_lite_resource_set_height (_tmp9_, _tmp10_);
	_tmp11_ = res;
	_tmp12_ = ((RygelIconInfo*) self)->depth;
	gupnp_didl_lite_resource_set_color_depth (_tmp11_, _tmp12_);
	_tmp13_ = res;
	_tmp14_ = protocol;
	_tmp15_ = rygel_thumbnail_get_protocol_info (self, _tmp14_);
	_tmp16_ = _tmp15_;
	gupnp_didl_lite_resource_set_protocol_info (_tmp13_, _tmp16_);
	_g_object_unref0 (_tmp16_);
	result = res;
	return result;
}


GUPnPDIDLLiteResource* rygel_thumbnail_add_resource (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const gchar* protocol) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_THUMBNAIL_GET_CLASS (self)->add_resource (self, didl_item, protocol);
}


static GUPnPProtocolInfo* rygel_thumbnail_get_protocol_info (RygelThumbnail* self, const gchar* protocol) {
	GUPnPProtocolInfo* result = NULL;
	GUPnPProtocolInfo* protocol_info = NULL;
	GUPnPProtocolInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GUPnPDLNAFlags _tmp4_ = 0;
	GUPnPDLNAFlags _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = gupnp_protocol_info_new ();
	protocol_info = _tmp0_;
	_tmp1_ = ((RygelIconInfo*) self)->mime_type;
	gupnp_protocol_info_set_mime_type (protocol_info, _tmp1_);
	_tmp2_ = self->dlna_profile;
	gupnp_protocol_info_set_dlna_profile (protocol_info, _tmp2_);
	_tmp3_ = protocol;
	gupnp_protocol_info_set_protocol (protocol_info, _tmp3_);
	_tmp4_ = gupnp_protocol_info_get_dlna_flags (protocol_info);
	_tmp5_ = _tmp4_;
	gupnp_protocol_info_set_dlna_flags (protocol_info, _tmp5_ | (((GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_CONNECTION_STALL) | GUPNP_DLNA_FLAGS_DLNA_V15));
	gupnp_protocol_info_set_dlna_operation (protocol_info, GUPNP_DLNA_OPERATION_RANGE);
	gupnp_protocol_info_set_dlna_conversion (protocol_info, GUPNP_DLNA_CONVERSION_TRANSCODED);
	result = protocol_info;
	return result;
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
	((RygelIconInfoClass *) klass)->finalize = rygel_thumbnail_finalize;
	((RygelThumbnailClass *) klass)->add_resource = rygel_thumbnail_real_add_resource;
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
}


static void rygel_thumbnail_finalize (RygelIconInfo* obj) {
	RygelThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_THUMBNAIL, RygelThumbnail);
	_g_free0 (self->dlna_profile);
	RYGEL_ICON_INFO_CLASS (rygel_thumbnail_parent_class)->finalize (obj);
}


/**
 * Represents a picture or video thumbnail.
 */
GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, NULL };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_static (RYGEL_TYPE_ICON_INFO, "RygelThumbnail", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}



