/* rygel-search-criteria-parser.c generated by valac 0.25.3.10-37e0, the Vala compiler
 * generated from rygel-search-criteria-parser.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define RYGEL_TYPE_SEARCH_CRITERIA_SYMBOL (rygel_search_criteria_symbol_get_type ())

#define RYGEL_TYPE_SEARCH_CRITERIA_TOKEN (rygel_search_criteria_token_get_type ())
typedef struct _RygelSearchCriteriaToken RygelSearchCriteriaToken;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_SEARCH_CRITERIA_PARSER (rygel_search_criteria_parser_get_type ())
#define RYGEL_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser))
#define RYGEL_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))

typedef struct _RygelSearchCriteriaParser RygelSearchCriteriaParser;
typedef struct _RygelSearchCriteriaParserClass RygelSearchCriteriaParserClass;
typedef struct _RygelSearchCriteriaParserPrivate RygelSearchCriteriaParserPrivate;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_scanner_destroy0(var) ((var == NULL) ? NULL : (var = (g_scanner_destroy (var), NULL)))
typedef struct _RygelSearchCriteriaParserRunData RygelSearchCriteriaParserRunData;

#define RYGEL_TYPE_LOGICAL_EXPRESSION (rygel_logical_expression_get_type ())
#define RYGEL_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpression))
#define RYGEL_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))
#define RYGEL_IS_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_IS_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_LOGICAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))

typedef struct _RygelLogicalExpression RygelLogicalExpression;
typedef struct _RygelLogicalExpressionClass RygelLogicalExpressionClass;

#define RYGEL_TYPE_LOGICAL_OPERATOR (rygel_logical_operator_get_type ())
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;

typedef enum  {
	RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR
} RygelSearchCriteriaError;
#define RYGEL_SEARCH_CRITERIA_ERROR rygel_search_criteria_error_quark ()
typedef enum  {
	RYGEL_SEARCH_CRITERIA_SYMBOL_EQ = GUPNP_SEARCH_CRITERIA_OP_EQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_LESS,
	RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER,
	RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS,
	RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN,
	RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM,
	RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS,
	RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK,
	RYGEL_SEARCH_CRITERIA_SYMBOL_AND,
	RYGEL_SEARCH_CRITERIA_SYMBOL_OR,
	RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE,
	RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE
} RygelSearchCriteriaSymbol;

struct _RygelSearchCriteriaToken {
	gchar* str_symbol;
	RygelSearchCriteriaSymbol symbol;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelSearchCriteriaParser {
	GObject parent_instance;
	RygelSearchCriteriaParserPrivate * priv;
	gchar* str;
	RygelSearchExpression* expression;
	GError* err;
};

struct _RygelSearchCriteriaParserClass {
	GObjectClass parent_class;
};

struct _RygelSearchCriteriaParserPrivate {
	GCancellable* _cancellable;
	GScanner* scanner;
};

struct _RygelSearchCriteriaParserRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchCriteriaParser* self;
	const gchar* _tmp0_;
	GScanner* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GScanner* _tmp6_;
	RygelSearchExpression* _tmp7_;
	RygelSearchExpression* _tmp8_;
	RygelSearchExpression* _tmp9_;
	GError* err;
	GError* _tmp10_;
	GError* _tmp11_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_LOGICAL_OPERATOR_AND,
	RYGEL_LOGICAL_OPERATOR_OR
} RygelLogicalOperator;

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};


static gpointer rygel_search_criteria_parser_parent_class = NULL;
static RygelStateMachineIface* rygel_search_criteria_parser_rygel_state_machine_parent_iface = NULL;

GQuark rygel_search_criteria_error_quark (void);
GType rygel_search_criteria_symbol_get_type (void) G_GNUC_CONST;
GType rygel_search_criteria_token_get_type (void) G_GNUC_CONST;
RygelSearchCriteriaToken* rygel_search_criteria_token_dup (const RygelSearchCriteriaToken* self);
void rygel_search_criteria_token_free (RygelSearchCriteriaToken* self);
void rygel_search_criteria_token_copy (const RygelSearchCriteriaToken* self, RygelSearchCriteriaToken* dest);
void rygel_search_criteria_token_destroy (RygelSearchCriteriaToken* self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_search_criteria_parser_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserPrivate))
enum  {
	RYGEL_SEARCH_CRITERIA_PARSER_DUMMY_PROPERTY,
	RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE
};
RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const gchar* str, GError** error);
RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type, const gchar* str, GError** error);
static void rygel_search_criteria_parser_real_run_data_free (gpointer _data);
static void rygel_search_criteria_parser_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_search_criteria_parser_real_run_co (RygelSearchCriteriaParserRunData* _data_);
static RygelSearchExpression* rygel_search_criteria_parser_parse_or_expression (RygelSearchCriteriaParser* self, GError** error);
static RygelSearchExpression* rygel_search_criteria_parser_parse_and_expression (RygelSearchCriteriaParser* self, GError** error);
static RygelSearchExpression* rygel_search_criteria_parser_parse_rel_expression (RygelSearchCriteriaParser* self, GError** error);
static RygelSearchCriteriaSymbol rygel_search_criteria_parser_get_token (RygelSearchCriteriaParser* self);
GType rygel_logical_expression_get_type (void) G_GNUC_CONST;
RygelLogicalExpression* rygel_logical_expression_new (void);
RygelLogicalExpression* rygel_logical_expression_construct (GType object_type);
GType rygel_logical_operator_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
static gchar* rygel_search_criteria_parser_get_context (RygelSearchCriteriaParser* self);
static void rygel_search_criteria_parser_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void _vala_rygel_search_criteria_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void _vala_rygel_search_criteria_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const RygelSearchCriteriaToken RYGEL_SEARCH_CRITERIA_PARSER_TOKENS[15] = {{"=", RYGEL_SEARCH_CRITERIA_SYMBOL_EQ}, {"!=", RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ}, {"<", RYGEL_SEARCH_CRITERIA_SYMBOL_LESS}, {"<=", RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ}, {">", RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER}, {">=", RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ}, {"contains", RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS}, {"doesNotContain", RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN}, {"derivedfrom", RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM}, {"exists", RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS}, {"*", RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK}, {"and", RYGEL_SEARCH_CRITERIA_SYMBOL_AND}, {"or", RYGEL_SEARCH_CRITERIA_SYMBOL_OR}, {"true", RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE}, {"false", RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE}};

GQuark rygel_search_criteria_error_quark (void) {
	return g_quark_from_static_string ("rygel_search_criteria_error-quark");
}


GType rygel_search_criteria_symbol_get_type (void) {
	static volatile gsize rygel_search_criteria_symbol_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_search_criteria_symbol_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_SEARCH_CRITERIA_SYMBOL_EQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_EQ", "eq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ", "neq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_LESS, "RYGEL_SEARCH_CRITERIA_SYMBOL_LESS", "less"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ", "leq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER, "RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER", "greater"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ", "geq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS, "RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS", "contains"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN, "RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN", "does-not-contain"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM, "RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM", "derived-from"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS, "RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS", "exists"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK, "RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK", "asterisk"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_AND, "RYGEL_SEARCH_CRITERIA_SYMBOL_AND", "and"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_OR, "RYGEL_SEARCH_CRITERIA_SYMBOL_OR", "or"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE, "RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE", "true"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE, "RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE", "false"}, {0, NULL, NULL}};
		GType rygel_search_criteria_symbol_type_id;
		rygel_search_criteria_symbol_type_id = g_enum_register_static ("RygelSearchCriteriaSymbol", values);
		g_once_init_leave (&rygel_search_criteria_symbol_type_id__volatile, rygel_search_criteria_symbol_type_id);
	}
	return rygel_search_criteria_symbol_type_id__volatile;
}


void rygel_search_criteria_token_copy (const RygelSearchCriteriaToken* self, RygelSearchCriteriaToken* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	RygelSearchCriteriaSymbol _tmp2_ = 0;
	_tmp0_ = (*self).str_symbol;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).str_symbol);
	(*dest).str_symbol = _tmp1_;
	_tmp2_ = (*self).symbol;
	(*dest).symbol = _tmp2_;
}


void rygel_search_criteria_token_destroy (RygelSearchCriteriaToken* self) {
	_g_free0 ((*self).str_symbol);
}


RygelSearchCriteriaToken* rygel_search_criteria_token_dup (const RygelSearchCriteriaToken* self) {
	RygelSearchCriteriaToken* dup;
	dup = g_new0 (RygelSearchCriteriaToken, 1);
	rygel_search_criteria_token_copy (self, dup);
	return dup;
}


void rygel_search_criteria_token_free (RygelSearchCriteriaToken* self) {
	rygel_search_criteria_token_destroy (self);
	g_free (self);
}


GType rygel_search_criteria_token_get_type (void) {
	static volatile gsize rygel_search_criteria_token_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_search_criteria_token_type_id__volatile)) {
		GType rygel_search_criteria_token_type_id;
		rygel_search_criteria_token_type_id = g_boxed_type_register_static ("RygelSearchCriteriaToken", (GBoxedCopyFunc) rygel_search_criteria_token_dup, (GBoxedFreeFunc) rygel_search_criteria_token_free);
		g_once_init_leave (&rygel_search_criteria_token_type_id__volatile, rygel_search_criteria_token_type_id);
	}
	return rygel_search_criteria_token_type_id__volatile;
}


RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type, const gchar* str, GError** error) {
	RygelSearchCriteriaParser * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GScanner* _tmp2_ = NULL;
	GScanner* _tmp3_ = NULL;
	GScannerConfig* _tmp4_ = NULL;
	GScanner* _tmp5_ = NULL;
	GScannerConfig* _tmp6_ = NULL;
	GScanner* _tmp7_ = NULL;
	GScannerConfig* _tmp8_ = NULL;
	GScanner* _tmp9_ = NULL;
	GScannerConfig* _tmp10_ = NULL;
	GScanner* _tmp11_ = NULL;
	GScannerConfig* _tmp12_ = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	self = (RygelSearchCriteriaParser*) g_object_new (object_type, NULL);
	_tmp0_ = str;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->str);
	self->str = _tmp1_;
	_tmp2_ = g_scanner_new (NULL);
	_g_scanner_destroy0 (self->priv->scanner);
	self->priv->scanner = _tmp2_;
	_tmp3_ = self->priv->scanner;
	_tmp4_ = _tmp3_->config;
	(*_tmp4_).cset_skip_characters = " \t\n\r\012" "\013\014\015";
	_tmp5_ = self->priv->scanner;
	_tmp6_ = _tmp5_->config;
	(*_tmp6_).scan_identifier_1char = TRUE;
	_tmp7_ = self->priv->scanner;
	_tmp8_ = _tmp7_->config;
	(*_tmp8_).cset_identifier_first = G_CSET_a_2_z "_*<>=!@" G_CSET_A_2_Z;
	_tmp9_ = self->priv->scanner;
	_tmp10_ = _tmp9_->config;
	(*_tmp10_).cset_identifier_nth = G_CSET_a_2_z "_" G_CSET_DIGITS "=:@" G_CSET_A_2_Z G_CSET_LATINS G_CSET_LATINC;
	_tmp11_ = self->priv->scanner;
	_tmp12_ = _tmp11_->config;
	(*_tmp12_).symbol_2_token = TRUE;
	{
		RygelSearchCriteriaToken* token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = RYGEL_SEARCH_CRITERIA_PARSER_TOKENS;
		token_collection_length1 = G_N_ELEMENTS (RYGEL_SEARCH_CRITERIA_PARSER_TOKENS);
		for (token_it = 0; token_it < G_N_ELEMENTS (RYGEL_SEARCH_CRITERIA_PARSER_TOKENS); token_it = token_it + 1) {
			RygelSearchCriteriaToken token = {0};
			token = token_collection[token_it];
			{
				GScanner* _tmp13_ = NULL;
				RygelSearchCriteriaToken _tmp14_ = {0};
				const gchar* _tmp15_ = NULL;
				RygelSearchCriteriaToken _tmp16_ = {0};
				RygelSearchCriteriaSymbol _tmp17_ = 0;
				void* _tmp18_ = NULL;
				_tmp13_ = self->priv->scanner;
				_tmp14_ = token;
				_tmp15_ = _tmp14_.str_symbol;
				_tmp16_ = token;
				_tmp17_ = _tmp16_.symbol;
				_tmp18_ = GINT_TO_POINTER ((gint) _tmp17_);
				g_scanner_scope_add_symbol (_tmp13_, (guint) 0, _tmp15_, _tmp18_);
			}
		}
	}
	return self;
}


RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const gchar* str, GError** error) {
	return rygel_search_criteria_parser_construct (RYGEL_TYPE_SEARCH_CRITERIA_PARSER, str, error);
}


static void rygel_search_criteria_parser_real_run_data_free (gpointer _data) {
	RygelSearchCriteriaParserRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSearchCriteriaParserRunData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_search_criteria_parser_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchCriteriaParser * self;
	RygelSearchCriteriaParserRunData* _data_;
	RygelSearchCriteriaParser* _tmp0_ = NULL;
	self = (RygelSearchCriteriaParser*) base;
	_data_ = g_slice_new0 (RygelSearchCriteriaParserRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_search_criteria_parser_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_search_criteria_parser_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_search_criteria_parser_real_run_co (_data_);
}


static void rygel_search_criteria_parser_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelSearchCriteriaParserRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean rygel_search_criteria_parser_real_run_co (RygelSearchCriteriaParserRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->str;
	if (g_strcmp0 (_data_->_tmp0_, "*") == 0) {
		g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->scanner;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->str;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->str;
	_data_->_tmp4_ = 0;
	_data_->_tmp4_ = strlen (_data_->_tmp3_);
	_data_->_tmp5_ = 0;
	_data_->_tmp5_ = _data_->_tmp4_;
	g_scanner_input_text (_data_->_tmp1_, _data_->_tmp2_, (guint) _data_->_tmp5_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->self->priv->scanner;
	g_scanner_get_next_token (_data_->_tmp6_);
	{
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = rygel_search_criteria_parser_parse_or_expression (_data_->self, &_data_->_inner_error_);
		_data_->_tmp7_ = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_tmp7_;
		_data_->_tmp7_ = NULL;
		_rygel_search_expression_unref0 (_data_->self->expression);
		_data_->self->expression = _data_->_tmp9_;
		_rygel_search_expression_unref0 (_data_->_tmp7_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->err;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _g_error_copy0 (_data_->_tmp10_);
		_g_error_free0 (_data_->self->err);
		_data_->self->err = _data_->_tmp11_;
		_g_error_free0 (_data_->err);
	}
	__finally5:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static RygelSearchExpression* rygel_search_criteria_parser_parse_and_expression (RygelSearchCriteriaParser* self, GError** error) {
	RygelSearchExpression* result = NULL;
	RygelSearchExpression* exp = NULL;
	RygelSearchExpression* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_search_criteria_parser_parse_rel_expression (self, &_inner_error_);
	exp = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	while (TRUE) {
		RygelSearchCriteriaSymbol _tmp1_ = 0;
		RygelSearchCriteriaSymbol _tmp2_ = 0;
		GScanner* _tmp3_ = NULL;
		RygelLogicalExpression* exp2 = NULL;
		RygelLogicalExpression* _tmp4_ = NULL;
		RygelLogicalExpression* _tmp5_ = NULL;
		RygelSearchExpression* _tmp6_ = NULL;
		RygelSearchExpression* _tmp7_ = NULL;
		RygelLogicalExpression* _tmp8_ = NULL;
		RygelSearchExpression* _tmp9_ = NULL;
		RygelSearchExpression* _tmp10_ = NULL;
		RygelLogicalExpression* _tmp11_ = NULL;
		RygelSearchExpression* _tmp12_ = NULL;
		RygelLogicalExpression* _tmp13_ = NULL;
		RygelSearchExpression* _tmp14_ = NULL;
		_tmp1_ = rygel_search_criteria_parser_get_token (self);
		_tmp2_ = _tmp1_;
		if (!(_tmp2_ == RYGEL_SEARCH_CRITERIA_SYMBOL_AND)) {
			break;
		}
		_tmp3_ = self->priv->scanner;
		g_scanner_get_next_token (_tmp3_);
		_tmp4_ = rygel_logical_expression_new ();
		exp2 = _tmp4_;
		_tmp5_ = exp2;
		_tmp6_ = exp;
		_tmp7_ = _rygel_search_expression_ref0 (_tmp6_);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp5_)->operand1);
		((RygelSearchExpression*) _tmp5_)->operand1 = _tmp7_;
		_tmp8_ = exp2;
		((RygelSearchExpression*) _tmp8_)->op = (gpointer) ((gintptr) RYGEL_LOGICAL_OPERATOR_AND);
		_tmp10_ = rygel_search_criteria_parser_parse_rel_expression (self, &_inner_error_);
		_tmp9_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_rygel_search_expression_unref0 (exp2);
			_rygel_search_expression_unref0 (exp);
			return NULL;
		}
		_tmp11_ = exp2;
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp11_)->operand2);
		((RygelSearchExpression*) _tmp11_)->operand2 = _tmp12_;
		_tmp13_ = exp2;
		_tmp14_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp13_);
		_rygel_search_expression_unref0 (exp);
		exp = _tmp14_;
		_rygel_search_expression_unref0 (_tmp9_);
		_rygel_search_expression_unref0 (exp2);
	}
	result = exp;
	return result;
}


static RygelSearchExpression* rygel_search_criteria_parser_parse_rel_expression (RygelSearchCriteriaParser* self, GError** error) {
	RygelSearchExpression* result = NULL;
	RygelRelationalExpression* exp = NULL;
	RygelRelationalExpression* _tmp0_ = NULL;
	GScanner* _tmp1_ = NULL;
	GTokenType _tmp2_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_relational_expression_new ();
	exp = _tmp0_;
	_tmp1_ = self->priv->scanner;
	_tmp2_ = _tmp1_->token;
	if (_tmp2_ == G_TOKEN_IDENTIFIER) {
		RygelRelationalExpression* _tmp3_ = NULL;
		GScanner* _tmp4_ = NULL;
		GTokenValue _tmp5_ = {0};
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GScanner* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		RygelSearchCriteriaSymbol _tmp17_ = 0;
		RygelSearchCriteriaSymbol _tmp18_ = 0;
		_tmp3_ = exp;
		_tmp4_ = self->priv->scanner;
		_tmp5_ = _tmp4_->value;
		_tmp6_ = _tmp5_.v_identifier;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (((RygelSearchExpression*) _tmp3_)->operand1);
		((RygelSearchExpression*) _tmp3_)->operand1 = _tmp7_;
		_tmp8_ = self->priv->scanner;
		g_scanner_get_next_token (_tmp8_);
		_tmp17_ = rygel_search_criteria_parser_get_token (self);
		_tmp18_ = _tmp17_;
		if (_tmp18_ == RYGEL_SEARCH_CRITERIA_SYMBOL_EQ) {
			_tmp16_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp19_ = 0;
			RygelSearchCriteriaSymbol _tmp20_ = 0;
			_tmp19_ = rygel_search_criteria_parser_get_token (self);
			_tmp20_ = _tmp19_;
			_tmp16_ = _tmp20_ == RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ;
		}
		if (_tmp16_) {
			_tmp15_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp21_ = 0;
			RygelSearchCriteriaSymbol _tmp22_ = 0;
			_tmp21_ = rygel_search_criteria_parser_get_token (self);
			_tmp22_ = _tmp21_;
			_tmp15_ = _tmp22_ == RYGEL_SEARCH_CRITERIA_SYMBOL_LESS;
		}
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp23_ = 0;
			RygelSearchCriteriaSymbol _tmp24_ = 0;
			_tmp23_ = rygel_search_criteria_parser_get_token (self);
			_tmp24_ = _tmp23_;
			_tmp14_ = _tmp24_ == RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp25_ = 0;
			RygelSearchCriteriaSymbol _tmp26_ = 0;
			_tmp25_ = rygel_search_criteria_parser_get_token (self);
			_tmp26_ = _tmp25_;
			_tmp13_ = _tmp26_ == RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER;
		}
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp27_ = 0;
			RygelSearchCriteriaSymbol _tmp28_ = 0;
			_tmp27_ = rygel_search_criteria_parser_get_token (self);
			_tmp28_ = _tmp27_;
			_tmp12_ = _tmp28_ == RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ;
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp29_ = 0;
			RygelSearchCriteriaSymbol _tmp30_ = 0;
			_tmp29_ = rygel_search_criteria_parser_get_token (self);
			_tmp30_ = _tmp29_;
			_tmp11_ = _tmp30_ == RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS;
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp31_ = 0;
			RygelSearchCriteriaSymbol _tmp32_ = 0;
			_tmp31_ = rygel_search_criteria_parser_get_token (self);
			_tmp32_ = _tmp31_;
			_tmp10_ = _tmp32_ == RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp33_ = 0;
			RygelSearchCriteriaSymbol _tmp34_ = 0;
			_tmp33_ = rygel_search_criteria_parser_get_token (self);
			_tmp34_ = _tmp33_;
			_tmp9_ = _tmp34_ == RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM;
		}
		if (_tmp9_) {
			RygelRelationalExpression* _tmp35_ = NULL;
			GScanner* _tmp36_ = NULL;
			GTokenType _tmp37_ = 0;
			GScanner* _tmp38_ = NULL;
			GScanner* _tmp39_ = NULL;
			GTokenType _tmp40_ = 0;
			_tmp35_ = exp;
			_tmp36_ = self->priv->scanner;
			_tmp37_ = _tmp36_->token;
			((RygelSearchExpression*) _tmp35_)->op = (gpointer) ((gintptr) ((GUPnPSearchCriteriaOp) _tmp37_));
			_tmp38_ = self->priv->scanner;
			g_scanner_get_next_token (_tmp38_);
			_tmp39_ = self->priv->scanner;
			_tmp40_ = _tmp39_->token;
			if (_tmp40_ == G_TOKEN_STRING) {
				RygelRelationalExpression* _tmp41_ = NULL;
				GScanner* _tmp42_ = NULL;
				GTokenValue _tmp43_ = {0};
				const gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				GScanner* _tmp46_ = NULL;
				_tmp41_ = exp;
				_tmp42_ = self->priv->scanner;
				_tmp43_ = _tmp42_->value;
				_tmp44_ = _tmp43_.v_string;
				_tmp45_ = g_strdup (_tmp44_);
				_g_free0 (((RygelSearchExpression*) _tmp41_)->operand2);
				((RygelSearchExpression*) _tmp41_)->operand2 = _tmp45_;
				_tmp46_ = self->priv->scanner;
				g_scanner_get_next_token (_tmp46_);
				result = (RygelSearchExpression*) exp;
				return result;
			} else {
				gchar* _tmp47_ = NULL;
				gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				gchar* _tmp50_ = NULL;
				gchar* _tmp51_ = NULL;
				gchar* _tmp52_ = NULL;
				gchar* _tmp53_ = NULL;
				GError* _tmp54_ = NULL;
				GError* _tmp55_ = NULL;
				_tmp47_ = rygel_search_criteria_parser_get_context (self);
				_tmp48_ = _tmp47_;
				_tmp49_ = _tmp48_;
				_tmp50_ = g_strconcat (_tmp49_, ": expected ", NULL);
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strconcat (_tmp51_, "\"STRING\"", NULL);
				_tmp53_ = _tmp52_;
				_tmp54_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp53_);
				_tmp55_ = _tmp54_;
				_g_free0 (_tmp53_);
				_g_free0 (_tmp51_);
				_g_free0 (_tmp49_);
				_inner_error_ = _tmp55_;
				g_propagate_error (error, _inner_error_);
				_rygel_search_expression_unref0 (exp);
				return NULL;
			}
		} else {
			RygelSearchCriteriaSymbol _tmp56_ = 0;
			RygelSearchCriteriaSymbol _tmp57_ = 0;
			_tmp56_ = rygel_search_criteria_parser_get_token (self);
			_tmp57_ = _tmp56_;
			if (_tmp57_ == RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS) {
				RygelRelationalExpression* _tmp58_ = NULL;
				GScanner* _tmp59_ = NULL;
				GTokenType _tmp60_ = 0;
				GScanner* _tmp61_ = NULL;
				RygelSearchCriteriaSymbol _tmp62_ = 0;
				RygelSearchCriteriaSymbol _tmp63_ = 0;
				_tmp58_ = exp;
				_tmp59_ = self->priv->scanner;
				_tmp60_ = _tmp59_->token;
				((RygelSearchExpression*) _tmp58_)->op = (gpointer) ((gintptr) ((GUPnPSearchCriteriaOp) _tmp60_));
				_tmp61_ = self->priv->scanner;
				g_scanner_get_next_token (_tmp61_);
				_tmp62_ = rygel_search_criteria_parser_get_token (self);
				_tmp63_ = _tmp62_;
				if (_tmp63_ == RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE) {
					RygelRelationalExpression* _tmp64_ = NULL;
					gchar* _tmp65_ = NULL;
					GScanner* _tmp66_ = NULL;
					_tmp64_ = exp;
					_tmp65_ = g_strdup ("true");
					_g_free0 (((RygelSearchExpression*) _tmp64_)->operand2);
					((RygelSearchExpression*) _tmp64_)->operand2 = _tmp65_;
					_tmp66_ = self->priv->scanner;
					g_scanner_get_next_token (_tmp66_);
					result = (RygelSearchExpression*) exp;
					return result;
				} else {
					RygelSearchCriteriaSymbol _tmp67_ = 0;
					RygelSearchCriteriaSymbol _tmp68_ = 0;
					_tmp67_ = rygel_search_criteria_parser_get_token (self);
					_tmp68_ = _tmp67_;
					if (_tmp68_ == RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE) {
						RygelRelationalExpression* _tmp69_ = NULL;
						gchar* _tmp70_ = NULL;
						GScanner* _tmp71_ = NULL;
						_tmp69_ = exp;
						_tmp70_ = g_strdup ("false");
						_g_free0 (((RygelSearchExpression*) _tmp69_)->operand2);
						((RygelSearchExpression*) _tmp69_)->operand2 = _tmp70_;
						_tmp71_ = self->priv->scanner;
						g_scanner_get_next_token (_tmp71_);
						result = (RygelSearchExpression*) exp;
						return result;
					} else {
						gchar* _tmp72_ = NULL;
						gchar* _tmp73_ = NULL;
						gchar* _tmp74_ = NULL;
						gchar* _tmp75_ = NULL;
						gchar* _tmp76_ = NULL;
						gchar* _tmp77_ = NULL;
						gchar* _tmp78_ = NULL;
						gchar* _tmp79_ = NULL;
						gchar* _tmp80_ = NULL;
						GError* _tmp81_ = NULL;
						GError* _tmp82_ = NULL;
						_tmp72_ = rygel_search_criteria_parser_get_context (self);
						_tmp73_ = _tmp72_;
						_tmp74_ = _tmp73_;
						_tmp75_ = g_strconcat (_tmp74_, ": expected ", NULL);
						_tmp76_ = _tmp75_;
						_tmp77_ = g_strconcat (_tmp76_, "\"true\"|\"", NULL);
						_tmp78_ = _tmp77_;
						_tmp79_ = g_strconcat (_tmp78_, "false\"", NULL);
						_tmp80_ = _tmp79_;
						_tmp81_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp80_);
						_tmp82_ = _tmp81_;
						_g_free0 (_tmp80_);
						_g_free0 (_tmp78_);
						_g_free0 (_tmp76_);
						_g_free0 (_tmp74_);
						_inner_error_ = _tmp82_;
						g_propagate_error (error, _inner_error_);
						_rygel_search_expression_unref0 (exp);
						return NULL;
					}
				}
			} else {
				gchar* _tmp83_ = NULL;
				gchar* _tmp84_ = NULL;
				gchar* _tmp85_ = NULL;
				gchar* _tmp86_ = NULL;
				gchar* _tmp87_ = NULL;
				gchar* _tmp88_ = NULL;
				gchar* _tmp89_ = NULL;
				GError* _tmp90_ = NULL;
				GError* _tmp91_ = NULL;
				_tmp83_ = rygel_search_criteria_parser_get_context (self);
				_tmp84_ = _tmp83_;
				_tmp85_ = _tmp84_;
				_tmp86_ = g_strconcat (_tmp85_, ": expected ", NULL);
				_tmp87_ = _tmp86_;
				_tmp88_ = g_strconcat (_tmp87_, "operator", NULL);
				_tmp89_ = _tmp88_;
				_tmp90_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp89_);
				_tmp91_ = _tmp90_;
				_g_free0 (_tmp89_);
				_g_free0 (_tmp87_);
				_g_free0 (_tmp85_);
				_inner_error_ = _tmp91_;
				g_propagate_error (error, _inner_error_);
				_rygel_search_expression_unref0 (exp);
				return NULL;
			}
		}
	} else {
		GScanner* _tmp92_ = NULL;
		GTokenType _tmp93_ = 0;
		_tmp92_ = self->priv->scanner;
		_tmp93_ = _tmp92_->token;
		if (_tmp93_ == G_TOKEN_LEFT_PAREN) {
			GScanner* _tmp94_ = NULL;
			RygelSearchExpression* exp2 = NULL;
			RygelSearchExpression* _tmp95_ = NULL;
			GScanner* _tmp96_ = NULL;
			GTokenType _tmp97_ = 0;
			_tmp94_ = self->priv->scanner;
			g_scanner_get_next_token (_tmp94_);
			_tmp95_ = rygel_search_criteria_parser_parse_or_expression (self, &_inner_error_);
			exp2 = _tmp95_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_rygel_search_expression_unref0 (exp);
				return NULL;
			}
			_tmp96_ = self->priv->scanner;
			_tmp97_ = _tmp96_->token;
			if (_tmp97_ != G_TOKEN_RIGHT_PAREN) {
				gchar* _tmp98_ = NULL;
				gchar* _tmp99_ = NULL;
				gchar* _tmp100_ = NULL;
				gchar* _tmp101_ = NULL;
				gchar* _tmp102_ = NULL;
				GError* _tmp103_ = NULL;
				GError* _tmp104_ = NULL;
				_tmp98_ = rygel_search_criteria_parser_get_context (self);
				_tmp99_ = _tmp98_;
				_tmp100_ = _tmp99_;
				_tmp101_ = g_strconcat (_tmp100_, ": expected ')'", NULL);
				_tmp102_ = _tmp101_;
				_tmp103_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp102_);
				_tmp104_ = _tmp103_;
				_g_free0 (_tmp102_);
				_g_free0 (_tmp100_);
				_inner_error_ = _tmp104_;
				g_propagate_error (error, _inner_error_);
				_rygel_search_expression_unref0 (exp2);
				_rygel_search_expression_unref0 (exp);
				return NULL;
			} else {
				GScanner* _tmp105_ = NULL;
				_tmp105_ = self->priv->scanner;
				g_scanner_get_next_token (_tmp105_);
				result = exp2;
				_rygel_search_expression_unref0 (exp);
				return result;
			}
			_rygel_search_expression_unref0 (exp2);
		} else {
			gchar* _tmp106_ = NULL;
			gchar* _tmp107_ = NULL;
			gchar* _tmp108_ = NULL;
			gchar* _tmp109_ = NULL;
			gchar* _tmp110_ = NULL;
			gchar* _tmp111_ = NULL;
			gchar* _tmp112_ = NULL;
			GError* _tmp113_ = NULL;
			GError* _tmp114_ = NULL;
			_tmp106_ = rygel_search_criteria_parser_get_context (self);
			_tmp107_ = _tmp106_;
			_tmp108_ = _tmp107_;
			_tmp109_ = g_strconcat (_tmp108_, ": expected ", NULL);
			_tmp110_ = _tmp109_;
			_tmp111_ = g_strconcat (_tmp110_, "identifier or '('", NULL);
			_tmp112_ = _tmp111_;
			_tmp113_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp112_);
			_tmp114_ = _tmp113_;
			_g_free0 (_tmp112_);
			_g_free0 (_tmp110_);
			_g_free0 (_tmp108_);
			_inner_error_ = _tmp114_;
			g_propagate_error (error, _inner_error_);
			_rygel_search_expression_unref0 (exp);
			return NULL;
		}
	}
	_rygel_search_expression_unref0 (exp);
}


static RygelSearchExpression* rygel_search_criteria_parser_parse_or_expression (RygelSearchCriteriaParser* self, GError** error) {
	RygelSearchExpression* result = NULL;
	RygelSearchExpression* exp = NULL;
	RygelSearchExpression* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_search_criteria_parser_parse_and_expression (self, &_inner_error_);
	exp = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	while (TRUE) {
		RygelSearchCriteriaSymbol _tmp1_ = 0;
		RygelSearchCriteriaSymbol _tmp2_ = 0;
		GScanner* _tmp3_ = NULL;
		RygelLogicalExpression* exp2 = NULL;
		RygelLogicalExpression* _tmp4_ = NULL;
		RygelLogicalExpression* _tmp5_ = NULL;
		RygelSearchExpression* _tmp6_ = NULL;
		RygelSearchExpression* _tmp7_ = NULL;
		RygelLogicalExpression* _tmp8_ = NULL;
		RygelSearchExpression* _tmp9_ = NULL;
		RygelSearchExpression* _tmp10_ = NULL;
		RygelLogicalExpression* _tmp11_ = NULL;
		RygelSearchExpression* _tmp12_ = NULL;
		RygelLogicalExpression* _tmp13_ = NULL;
		RygelSearchExpression* _tmp14_ = NULL;
		_tmp1_ = rygel_search_criteria_parser_get_token (self);
		_tmp2_ = _tmp1_;
		if (!(_tmp2_ == RYGEL_SEARCH_CRITERIA_SYMBOL_OR)) {
			break;
		}
		_tmp3_ = self->priv->scanner;
		g_scanner_get_next_token (_tmp3_);
		_tmp4_ = rygel_logical_expression_new ();
		exp2 = _tmp4_;
		_tmp5_ = exp2;
		_tmp6_ = exp;
		_tmp7_ = _rygel_search_expression_ref0 (_tmp6_);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp5_)->operand1);
		((RygelSearchExpression*) _tmp5_)->operand1 = _tmp7_;
		_tmp8_ = exp2;
		((RygelSearchExpression*) _tmp8_)->op = (gpointer) ((gintptr) RYGEL_LOGICAL_OPERATOR_OR);
		_tmp10_ = rygel_search_criteria_parser_parse_and_expression (self, &_inner_error_);
		_tmp9_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_rygel_search_expression_unref0 (exp2);
			_rygel_search_expression_unref0 (exp);
			return NULL;
		}
		_tmp11_ = exp2;
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp11_)->operand2);
		((RygelSearchExpression*) _tmp11_)->operand2 = _tmp12_;
		_tmp13_ = exp2;
		_tmp14_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp13_);
		_rygel_search_expression_unref0 (exp);
		exp = _tmp14_;
		_rygel_search_expression_unref0 (_tmp9_);
		_rygel_search_expression_unref0 (exp2);
	}
	result = exp;
	return result;
}


static GCancellable* rygel_search_criteria_parser_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelSearchCriteriaParser* self;
	GCancellable* _tmp0_ = NULL;
	self = (RygelSearchCriteriaParser*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


static void rygel_search_criteria_parser_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelSearchCriteriaParser* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	self = (RygelSearchCriteriaParser*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static RygelSearchCriteriaSymbol rygel_search_criteria_parser_get_token (RygelSearchCriteriaParser* self) {
	RygelSearchCriteriaSymbol result;
	GScanner* _tmp0_ = NULL;
	GTokenType _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = _tmp0_->token;
	result = (RygelSearchCriteriaSymbol) _tmp1_;
	return result;
}


static gchar* rygel_search_criteria_parser_get_context (RygelSearchCriteriaParser* self) {
	gchar* result;
	GScanner* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GScanner* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = _tmp0_->line;
	_tmp2_ = g_strdup_printf ("%u", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ".", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->scanner;
	_tmp7_ = _tmp6_->position;
	_tmp8_ = g_strdup_printf ("%u", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp5_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	result = _tmp11_;
	return result;
}


static void rygel_search_criteria_parser_class_init (RygelSearchCriteriaParserClass * klass) {
	rygel_search_criteria_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelSearchCriteriaParserPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_search_criteria_parser_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_search_criteria_parser_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_search_criteria_parser_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_search_criteria_parser_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_search_criteria_parser_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_search_criteria_parser_real_run;
	iface->run_finish = rygel_search_criteria_parser_real_run_finish;
	iface->get_cancellable = rygel_search_criteria_parser_real_get_cancellable;
	iface->set_cancellable = rygel_search_criteria_parser_real_set_cancellable;
}


static void rygel_search_criteria_parser_instance_init (RygelSearchCriteriaParser * self) {
	self->priv = RYGEL_SEARCH_CRITERIA_PARSER_GET_PRIVATE (self);
}


static void rygel_search_criteria_parser_finalize (GObject* obj) {
	RygelSearchCriteriaParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser);
	_g_free0 (self->str);
	_rygel_search_expression_unref0 (self->expression);
	_g_error_free0 (self->err);
	_g_object_unref0 (self->priv->_cancellable);
	_g_scanner_destroy0 (self->priv->scanner);
	G_OBJECT_CLASS (rygel_search_criteria_parser_parent_class)->finalize (obj);
}


/**
 * Parses a search criteria string and creates SearchExpression as a result.
 */
GType rygel_search_criteria_parser_get_type (void) {
	static volatile gsize rygel_search_criteria_parser_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_search_criteria_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchCriteriaParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_search_criteria_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSearchCriteriaParser), 0, (GInstanceInitFunc) rygel_search_criteria_parser_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_search_criteria_parser_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_search_criteria_parser_type_id;
		rygel_search_criteria_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSearchCriteriaParser", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_search_criteria_parser_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_search_criteria_parser_type_id__volatile, rygel_search_criteria_parser_type_id);
	}
	return rygel_search_criteria_parser_type_id__volatile;
}


static void _vala_rygel_search_criteria_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelSearchCriteriaParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser);
	switch (property_id) {
		case RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_search_criteria_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelSearchCriteriaParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser);
	switch (property_id) {
		case RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



