/* sudoku-generator.c generated by valac 0.23.3.24-5b8db, the Vala compiler
 * generated from sudoku-generator.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <glib.h>
#include <glib-object.h>
#include "qqwing-wrapper.h"
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_SUDOKU_GENERATOR (sudoku_generator_get_type ())
#define SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GENERATOR, SudokuGenerator))
#define SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))
#define IS_SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GENERATOR))
#define IS_SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GENERATOR))
#define SUDOKU_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))

typedef struct _SudokuGenerator SudokuGenerator;
typedef struct _SudokuGeneratorClass SudokuGeneratorClass;
typedef struct _SudokuGeneratorPrivate SudokuGeneratorPrivate;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_GENERATOR_THREAD (generator_thread_get_type ())
#define GENERATOR_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GENERATOR_THREAD, GeneratorThread))
#define GENERATOR_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GENERATOR_THREAD, GeneratorThreadClass))
#define IS_GENERATOR_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GENERATOR_THREAD))
#define IS_GENERATOR_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GENERATOR_THREAD))
#define GENERATOR_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GENERATOR_THREAD, GeneratorThreadClass))

typedef struct _GeneratorThread GeneratorThread;
typedef struct _GeneratorThreadClass GeneratorThreadClass;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _SudokuGeneratorGenerateBoardsAsyncData SudokuGeneratorGenerateBoardsAsyncData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GeneratorThreadPrivate GeneratorThreadPrivate;

struct _SudokuGenerator {
	GObject parent_instance;
	SudokuGeneratorPrivate * priv;
};

struct _SudokuGeneratorClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD
} DifficultyCategory;

struct _SudokuGeneratorGenerateBoardsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gint nboards;
	DifficultyCategory category;
	SudokuBoard** result;
	gint result_length1;
	GeeArrayList* boards_list;
	GeeArrayList* _tmp0_;
	SudokuBoard** boards;
	gint _tmp1_;
	SudokuBoard** _tmp2_;
	gint boards_length1;
	gint _boards_size_;
	GThread* threads[16];
	gint ncpu_usable;
	gint _tmp3_;
	gint _tmp4_;
	gint nthreads;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint base_nsudokus_each;
	gint _tmp8_;
	gint _tmp9_;
	gint remainder;
	gint _tmp10_;
	gint _tmp11_;
	gint nsudokus_per_thread;
	gint _tmp12_;
	gint i;
	gboolean _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	GeneratorThread* gen_thread;
	gint _tmp21_;
	DifficultyCategory _tmp22_;
	GeneratorThread* _tmp23_;
	gint _tmp24_;
	GeneratorThread* _tmp25_;
	GThread* _tmp26_;
	GThread* _tmp27_;
	gint _vala1_i;
	gboolean _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	GThread* _tmp33_;
	GThread* _tmp34_;
	gint _vala2_i;
	gboolean _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	GeeArrayList* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	SudokuBoard** _tmp41_;
	gint _tmp41__length1;
	gint _tmp42_;
	GeeArrayList* _tmp43_;
	gint _tmp44_;
	gpointer _tmp45_;
	SudokuBoard* _tmp46_;
	SudokuBoard** _tmp47_;
	gint _tmp47__length1;
};

struct _GeneratorThread {
	GObject parent_instance;
	GeneratorThreadPrivate * priv;
};

struct _GeneratorThreadClass {
	GObjectClass parent_class;
};

struct _GeneratorThreadPrivate {
	gint nsudokus;
	DifficultyCategory level;
	GeeArrayList* boards_list;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};


static gpointer sudoku_generator_parent_class = NULL;
static gpointer generator_thread_parent_class = NULL;

GType sudoku_generator_get_type (void) G_GNUC_CONST;
enum  {
	SUDOKU_GENERATOR_DUMMY_PROPERTY
};
static SudokuGenerator* sudoku_generator_new (void);
static SudokuGenerator* sudoku_generator_construct (GType object_type);
GType difficulty_category_get_type (void) G_GNUC_CONST;
GType sudoku_board_get_type (void) G_GNUC_CONST;
SudokuBoard* sudoku_generator_generate_board (DifficultyCategory category);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value);
static void sudoku_generator_generate_boards_async_data_free (gpointer _data);
void sudoku_generator_generate_boards_async (gint nboards, DifficultyCategory category, GAsyncReadyCallback _callback_, gpointer _user_data_);
SudokuBoard** sudoku_generator_generate_boards_finish (GAsyncResult* _res_, int* result_length1, GError** error);
static gboolean sudoku_generator_generate_boards_async_co (SudokuGeneratorGenerateBoardsAsyncData* _data_);
static gint sudoku_generator_get_number_of_processors (void);
GType generator_thread_get_type (void) G_GNUC_CONST;
static gboolean _sudoku_generator_generate_boards_async_co_gsource_func (gpointer self);
GeneratorThread* generator_thread_new (gint nsudokus, DifficultyCategory level, GeeArrayList** boards_list, GSourceFunc callback, void* callback_target);
GeneratorThread* generator_thread_construct (GType object_type, gint nsudokus, DifficultyCategory level, GeeArrayList** boards_list, GSourceFunc callback, void* callback_target);
void* generator_thread_run (GeneratorThread* self);
static gpointer _generator_thread_run_gthread_func (gpointer self);
void sudoku_generator_print_stats (SudokuBoard* board);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
gchar* sudoku_generator_qqwing_version (void);
#define GENERATOR_THREAD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GENERATOR_THREAD, GeneratorThreadPrivate))
enum  {
	GENERATOR_THREAD_DUMMY_PROPERTY
};
static void generator_thread_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static SudokuGenerator* sudoku_generator_construct (GType object_type) {
	SudokuGenerator * self = NULL;
#line 7 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self = (SudokuGenerator*) g_object_new (object_type, NULL);
#line 7 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return self;
#line 213 "sudoku-generator.c"
}


static SudokuGenerator* sudoku_generator_new (void) {
#line 7 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return sudoku_generator_construct (TYPE_SUDOKU_GENERATOR);
#line 220 "sudoku-generator.c"
}


SudokuBoard* sudoku_generator_generate_board (DifficultyCategory category) {
	SudokuBoard* result = NULL;
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp0_ = NULL;
	gint* puzzle = NULL;
	DifficultyCategory _tmp1_ = 0;
	gint* _tmp2_ = NULL;
	gint puzzle_length1 = 0;
	gint _puzzle_size_ = 0;
	SudokuBoard* _tmp27_ = NULL;
	DifficultyCategory _tmp28_ = 0;
#line 12 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = sudoku_board_new (3, 3);
#line 12 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	board = _tmp0_;
#line 13 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = category;
#line 13 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp2_ = qqwing_generate_puzzle ((gint) _tmp1_);
#line 13 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = _tmp2_;
#line 13 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle_length1 = -1;
#line 13 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_puzzle_size_ = puzzle_length1;
#line 249 "sudoku-generator.c"
	{
		gint row = 0;
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		row = 0;
#line 254 "sudoku-generator.c"
		{
			gboolean _tmp3_ = FALSE;
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp3_ = TRUE;
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 261 "sudoku-generator.c"
				gint _tmp5_ = 0;
				SudokuBoard* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_tmp3_) {
#line 268 "sudoku-generator.c"
					gint _tmp4_ = 0;
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp4_ = row;
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					row = _tmp4_ + 1;
#line 274 "sudoku-generator.c"
				}
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp3_ = FALSE;
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp5_ = row;
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp6_ = board;
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp7_ = sudoku_board_get_rows (_tmp6_);
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp8_ = _tmp7_;
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_tmp5_ < _tmp8_)) {
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 290 "sudoku-generator.c"
				}
				{
					gint col = 0;
#line 16 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					col = 0;
#line 296 "sudoku-generator.c"
					{
						gboolean _tmp9_ = FALSE;
#line 16 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp9_ = TRUE;
#line 16 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						while (TRUE) {
#line 303 "sudoku-generator.c"
							gint _tmp11_ = 0;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint val = 0;
							gint* _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp16_ = 0;
							SudokuBoard* _tmp17_ = NULL;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
#line 16 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							if (!_tmp9_) {
#line 320 "sudoku-generator.c"
								gint _tmp10_ = 0;
#line 16 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp10_ = col;
#line 16 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								col = _tmp10_ + 1;
#line 326 "sudoku-generator.c"
							}
#line 16 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp9_ = FALSE;
#line 16 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp11_ = col;
#line 16 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp12_ = board;
#line 16 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
#line 16 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp14_ = _tmp13_;
#line 16 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							if (!(_tmp11_ < _tmp14_)) {
#line 16 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								break;
#line 342 "sudoku-generator.c"
							}
#line 18 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp15_ = puzzle;
#line 18 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp15__length1 = puzzle_length1;
#line 18 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp16_ = row;
#line 18 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp17_ = board;
#line 18 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp18_ = sudoku_board_get_cols (_tmp17_);
#line 18 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp19_ = _tmp18_;
#line 18 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp20_ = col;
#line 18 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp21_ = _tmp15_[(_tmp16_ * _tmp19_) + _tmp20_];
#line 18 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							val = _tmp21_;
#line 19 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp22_ = val;
#line 19 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							if (_tmp22_ != 0) {
#line 366 "sudoku-generator.c"
								SudokuBoard* _tmp23_ = NULL;
								gint _tmp24_ = 0;
								gint _tmp25_ = 0;
								gint _tmp26_ = 0;
#line 20 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp23_ = board;
#line 20 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp24_ = row;
#line 20 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp25_ = col;
#line 20 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp26_ = val;
#line 20 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								sudoku_board_insert (_tmp23_, _tmp24_, _tmp25_, _tmp26_, TRUE);
#line 381 "sudoku-generator.c"
							}
						}
					}
				}
			}
		}
	}
#line 22 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp27_ = board;
#line 22 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp28_ = category;
#line 22 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_board_set_difficulty_category (_tmp27_, _tmp28_);
#line 24 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	result = board;
#line 24 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = (g_free (puzzle), NULL);
#line 24 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 401 "sudoku-generator.c"
}


static void sudoku_generator_generate_boards_async_data_free (gpointer _data) {
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	_data_ = _data;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_object_unref), NULL);
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_slice_free (SudokuGeneratorGenerateBoardsAsyncData, _data_);
#line 412 "sudoku-generator.c"
}


void sudoku_generator_generate_boards_async (gint nboards, DifficultyCategory category, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	gint _tmp0_ = 0;
	DifficultyCategory _tmp1_ = 0;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_ = g_slice_new0 (SudokuGeneratorGenerateBoardsAsyncData);
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, sudoku_generator_generate_boards_async);
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sudoku_generator_generate_boards_async_data_free);
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = nboards;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->nboards = _tmp0_;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = category;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->category = _tmp1_;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_generate_boards_async_co (_data_);
#line 436 "sudoku-generator.c"
}


SudokuBoard** sudoku_generator_generate_boards_finish (GAsyncResult* _res_, int* result_length1, GError** error) {
	SudokuBoard** result;
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		return NULL;
#line 447 "sudoku-generator.c"
	}
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	result = _data_->result;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	*result_length1 = _data_->result_length1;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->result = NULL;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 459 "sudoku-generator.c"
}


static gboolean _sudoku_generator_generate_boards_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = sudoku_generator_generate_boards_async_co (self);
#line 43 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 468 "sudoku-generator.c"
}


static gpointer _generator_thread_run_gthread_func (gpointer self) {
	gpointer result;
	result = generator_thread_run ((GeneratorThread*) self);
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 477 "sudoku-generator.c"
}


static gpointer _g_thread_ref0 (gpointer self) {
#line 51 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return self ? g_thread_ref (self) : NULL;
#line 484 "sudoku-generator.c"
}


static gboolean sudoku_generator_generate_boards_async_co (SudokuGeneratorGenerateBoardsAsyncData* _data_) {
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	switch (_data_->_state_) {
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		case 0:
#line 493 "sudoku-generator.c"
		goto _state_0;
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		case 1:
#line 497 "sudoku-generator.c"
		goto _state_1;
		default:
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		g_assert_not_reached ();
#line 502 "sudoku-generator.c"
	}
	_state_0:
#line 29 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp0_ = NULL;
#line 29 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp0_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 29 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->boards_list = _data_->_tmp0_;
#line 30 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp1_ = 0;
#line 30 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp1_ = _data_->nboards;
#line 30 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp2_ = NULL;
#line 30 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp2_ = g_new0 (SudokuBoard*, _data_->_tmp1_ + 1);
#line 30 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->boards_length1 = 0;
#line 30 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_boards_size_ = 0;
#line 30 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->boards = _data_->_tmp2_;
#line 30 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->boards_length1 = _data_->_tmp1_;
#line 30 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_boards_size_ = _data_->boards_length1;
#line 33 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp3_ = 0;
#line 33 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp3_ = sudoku_generator_get_number_of_processors ();
#line 33 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp4_ = 0;
#line 33 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp4_ = MAX (1, _data_->_tmp3_ - 1);
#line 33 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->ncpu_usable = _data_->_tmp4_;
#line 34 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp5_ = 0;
#line 34 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp5_ = _data_->ncpu_usable;
#line 34 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp6_ = 0;
#line 34 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp6_ = _data_->nboards;
#line 34 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp7_ = 0;
#line 34 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp7_ = MIN (_data_->_tmp5_, _data_->_tmp6_);
#line 34 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->nthreads = _data_->_tmp7_;
#line 35 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp8_ = 0;
#line 35 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp8_ = _data_->nboards;
#line 35 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp9_ = 0;
#line 35 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp9_ = _data_->nthreads;
#line 35 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->base_nsudokus_each = _data_->_tmp8_ / _data_->_tmp9_;
#line 36 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp10_ = 0;
#line 36 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp10_ = _data_->nboards;
#line 36 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp11_ = 0;
#line 36 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp11_ = _data_->nthreads;
#line 36 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->remainder = _data_->_tmp10_ % _data_->_tmp11_;
#line 37 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp12_ = 0;
#line 37 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp12_ = _data_->base_nsudokus_each;
#line 37 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->nsudokus_per_thread = _data_->_tmp12_;
#line 579 "sudoku-generator.c"
	{
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_data_->i = 0;
#line 583 "sudoku-generator.c"
		{
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_data_->_tmp13_ = TRUE;
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_data_->_tmp13_) {
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->_tmp14_ = 0;
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->_tmp14_ = _data_->i;
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->i = _data_->_tmp14_ + 1;
#line 597 "sudoku-generator.c"
				}
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp13_ = FALSE;
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp15_ = 0;
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp15_ = _data_->i;
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp16_ = 0;
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp16_ = _data_->nthreads;
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_data_->_tmp15_ < _data_->_tmp16_)) {
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 613 "sudoku-generator.c"
				}
#line 41 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp17_ = 0;
#line 41 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp17_ = _data_->i;
#line 41 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp18_ = 0;
#line 41 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp18_ = _data_->nthreads;
#line 41 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp19_ = 0;
#line 41 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp19_ = _data_->remainder;
#line 41 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (_data_->_tmp17_ > ((_data_->_tmp18_ - _data_->_tmp19_) - 1)) {
#line 42 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->_tmp20_ = 0;
#line 42 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->_tmp20_ = _data_->base_nsudokus_each;
#line 42 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->nsudokus_per_thread = _data_->_tmp20_ + 1;
#line 635 "sudoku-generator.c"
				}
#line 43 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp21_ = 0;
#line 43 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp21_ = _data_->nsudokus_per_thread;
#line 43 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp22_ = 0;
#line 43 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp22_ = _data_->category;
#line 43 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp23_ = NULL;
#line 43 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp23_ = generator_thread_new (_data_->_tmp21_, _data_->_tmp22_, &_data_->boards_list, _sudoku_generator_generate_boards_async_co_gsource_func, _data_);
#line 43 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->gen_thread = _data_->_tmp23_;
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp24_ = 0;
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp24_ = _data_->i;
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp25_ = NULL;
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp25_ = _data_->gen_thread;
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp26_ = NULL;
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp26_ = g_thread_new ("Generator thread", _generator_thread_run_gthread_func, g_object_ref (_data_->_tmp25_));
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_g_thread_unref0 (_data_->threads[_data_->_tmp24_]);
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->threads[_data_->_tmp24_] = _data_->_tmp26_;
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp27_ = NULL;
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp27_ = _data_->threads[_data_->_tmp24_];
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_g_object_unref0 (_data_->gen_thread);
#line 673 "sudoku-generator.c"
			}
		}
	}
	{
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_data_->_vala1_i = 0;
#line 680 "sudoku-generator.c"
		{
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_data_->_tmp28_ = TRUE;
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_data_->_tmp28_) {
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->_tmp29_ = 0;
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->_tmp29_ = _data_->_vala1_i;
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->_vala1_i = _data_->_tmp29_ + 1;
#line 694 "sudoku-generator.c"
				}
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp28_ = FALSE;
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp30_ = 0;
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp30_ = _data_->_vala1_i;
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp31_ = 0;
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp31_ = _data_->nthreads;
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_data_->_tmp30_ < _data_->_tmp31_)) {
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 710 "sudoku-generator.c"
				}
#line 50 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_state_ = 1;
#line 50 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				return FALSE;
#line 716 "sudoku-generator.c"
				_state_1:
				;
#line 51 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp32_ = 0;
#line 51 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp32_ = _data_->_vala1_i;
#line 51 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp33_ = NULL;
#line 51 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp33_ = _data_->threads[_data_->_tmp32_];
#line 51 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp34_ = NULL;
#line 51 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp34_ = _g_thread_ref0 (_data_->_tmp33_);
#line 51 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				g_thread_join (_data_->_tmp34_);
#line 733 "sudoku-generator.c"
			}
		}
	}
	{
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_data_->_vala2_i = 0;
#line 740 "sudoku-generator.c"
		{
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_data_->_tmp35_ = TRUE;
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_data_->_tmp35_) {
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->_tmp36_ = 0;
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->_tmp36_ = _data_->_vala2_i;
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->_vala2_i = _data_->_tmp36_ + 1;
#line 754 "sudoku-generator.c"
				}
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp35_ = FALSE;
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp37_ = 0;
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp37_ = _data_->_vala2_i;
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp38_ = NULL;
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp38_ = _data_->boards_list;
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp39_ = 0;
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp39_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp38_);
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp40_ = 0;
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp40_ = _data_->_tmp39_;
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_data_->_tmp37_ < _data_->_tmp40_)) {
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 778 "sudoku-generator.c"
				}
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp41_ = NULL;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp41__length1 = 0;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp41_ = _data_->boards;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp41__length1 = _data_->boards_length1;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp42_ = 0;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp42_ = _data_->_vala2_i;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp43_ = NULL;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp43_ = _data_->boards_list;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp44_ = 0;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp44_ = _data_->_vala2_i;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp45_ = NULL;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp43_, _data_->_tmp44_);
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_g_object_unref0 (_data_->_tmp41_[_data_->_tmp42_]);
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp41_[_data_->_tmp42_] = (SudokuBoard*) _data_->_tmp45_;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp46_ = NULL;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp46_ = _data_->_tmp41_[_data_->_tmp42_];
#line 812 "sudoku-generator.c"
			}
		}
	}
#line 56 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp47_ = NULL;
#line 56 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp47__length1 = 0;
#line 56 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp47_ = _data_->boards;
#line 56 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp47__length1 = _data_->boards_length1;
#line 56 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->result_length1 = _data_->_tmp47__length1;
#line 56 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->result = _data_->_tmp47_;
#line 56 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_vala_array_destroy (_data_->threads, 16, (GDestroyNotify) g_thread_unref);
#line 56 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (_data_->boards_list);
#line 56 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	if (_data_->_state_ == 0) {
#line 56 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 836 "sudoku-generator.c"
	} else {
#line 56 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 840 "sudoku-generator.c"
	}
#line 56 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_object_unref (_data_->_async_result);
#line 56 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return FALSE;
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_vala_array_destroy (_data_->threads, 16, (GDestroyNotify) g_thread_unref);
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->boards = (_vala_array_free (_data_->boards, _data_->boards_length1, (GDestroyNotify) g_object_unref), NULL);
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (_data_->boards_list);
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	if (_data_->_state_ == 0) {
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 856 "sudoku-generator.c"
	} else {
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 860 "sudoku-generator.c"
	}
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_object_unref (_data_->_async_result);
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return FALSE;
#line 866 "sudoku-generator.c"
}


void sudoku_generator_print_stats (SudokuBoard* board) {
	gint* cells = NULL;
	SudokuBoard* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint cells_length1 = 0;
	gint cells_length2 = 0;
	gint* puzzle = NULL;
	SudokuBoard* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	SudokuBoard* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint* _tmp10_ = NULL;
	gint puzzle_length1 = 0;
	gint _puzzle_size_ = 0;
	gint* _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
#line 59 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_if_fail (board != NULL);
#line 61 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = board;
#line 61 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = sudoku_board_get_cells (_tmp0_, &_tmp1_, &_tmp2_);
#line 61 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	cells = _tmp3_;
#line 61 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	cells_length1 = _tmp1_;
#line 61 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	cells_length2 = _tmp2_;
#line 62 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4_ = board;
#line 62 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp5_ = sudoku_board_get_rows (_tmp4_);
#line 62 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp6_ = _tmp5_;
#line 62 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp7_ = board;
#line 62 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp8_ = sudoku_board_get_cols (_tmp7_);
#line 62 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp9_ = _tmp8_;
#line 62 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp10_ = g_new0 (gint, _tmp6_ * _tmp9_);
#line 62 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = _tmp10_;
#line 62 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle_length1 = _tmp6_ * _tmp9_;
#line 62 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_puzzle_size_ = puzzle_length1;
#line 922 "sudoku-generator.c"
	{
		gint row = 0;
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		row = 0;
#line 927 "sudoku-generator.c"
		{
			gboolean _tmp11_ = FALSE;
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp11_ = TRUE;
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 934 "sudoku-generator.c"
				gint _tmp13_ = 0;
				SudokuBoard* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_tmp11_) {
#line 941 "sudoku-generator.c"
					gint _tmp12_ = 0;
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp12_ = row;
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					row = _tmp12_ + 1;
#line 947 "sudoku-generator.c"
				}
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp11_ = FALSE;
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp13_ = row;
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp14_ = board;
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp15_ = sudoku_board_get_rows (_tmp14_);
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp16_ = _tmp15_;
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_tmp13_ < _tmp16_)) {
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 963 "sudoku-generator.c"
				}
				{
					gint col = 0;
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					col = 0;
#line 969 "sudoku-generator.c"
					{
						gboolean _tmp17_ = FALSE;
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp17_ = TRUE;
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						while (TRUE) {
#line 976 "sudoku-generator.c"
							gint _tmp19_ = 0;
							SudokuBoard* _tmp20_ = NULL;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint* _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp24_ = 0;
							SudokuBoard* _tmp25_ = NULL;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							gint* _tmp29_ = NULL;
							gint _tmp29__length1 = 0;
							gint _tmp29__length2 = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							if (!_tmp17_) {
#line 997 "sudoku-generator.c"
								gint _tmp18_ = 0;
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp18_ = col;
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								col = _tmp18_ + 1;
#line 1003 "sudoku-generator.c"
							}
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp17_ = FALSE;
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp19_ = col;
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp20_ = board;
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp21_ = sudoku_board_get_cols (_tmp20_);
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp22_ = _tmp21_;
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							if (!(_tmp19_ < _tmp22_)) {
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								break;
#line 1019 "sudoku-generator.c"
							}
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23_ = puzzle;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23__length1 = puzzle_length1;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp24_ = row;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp25_ = board;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp26_ = sudoku_board_get_cols (_tmp25_);
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp27_ = _tmp26_;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp28_ = col;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp29_ = cells;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp29__length1 = cells_length1;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp29__length2 = cells_length2;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp30_ = row;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp31_ = col;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23_[(_tmp24_ * _tmp27_) + _tmp28_] = _tmp32_;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp33_ = _tmp23_[(_tmp24_ * _tmp27_) + _tmp28_];
#line 1051 "sudoku-generator.c"
						}
					}
				}
			}
		}
	}
#line 68 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp34_ = puzzle;
#line 68 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp34__length1 = puzzle_length1;
#line 68 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	qqwing_print_stats (_tmp34_);
#line 59 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = (g_free (puzzle), NULL);
#line 59 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	cells = (g_free (cells), NULL);
#line 1068 "sudoku-generator.c"
}


gchar* sudoku_generator_qqwing_version (void) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 73 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = qqwing_get_version ();
#line 73 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	result = _tmp0_;
#line 73 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 1081 "sudoku-generator.c"
}


static gint sudoku_generator_get_number_of_processors (void) {
	gint result = 0;
	gint ncpu = 0;
	gchar* nproc_stdout = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		gint _tmp1_ = 0;
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		g_spawn_command_line_sync ("nproc", &_tmp0_, NULL, NULL, &_inner_error_);
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_g_free0 (nproc_stdout);
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		nproc_stdout = _tmp0_;
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		if (_inner_error_ != NULL) {
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 1103 "sudoku-generator.c"
				goto __catch4_g_spawn_error;
			}
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_g_free0 (nproc_stdout);
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			g_clear_error (&_inner_error_);
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			return 0;
#line 1114 "sudoku-generator.c"
		}
#line 83 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp1_ = atoi (nproc_stdout);
#line 83 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		ncpu = _tmp1_;
#line 1120 "sudoku-generator.c"
	}
	goto __finally4;
	__catch4_g_spawn_error:
	{
		GError* e = NULL;
#line 81 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		e = _inner_error_;
#line 81 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_inner_error_ = NULL;
#line 85 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		g_warning ("sudoku-generator.vala:85: Call to nproc failed. Puzzles will be genera" \
"ted in a single thread");
#line 86 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		ncpu = 1;
#line 81 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_g_error_free0 (e);
#line 1136 "sudoku-generator.c"
	}
	__finally4:
#line 81 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	if (_inner_error_ != NULL) {
#line 81 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_g_free0 (nproc_stdout);
#line 81 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 81 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		g_clear_error (&_inner_error_);
#line 81 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		return 0;
#line 1149 "sudoku-generator.c"
	}
#line 89 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	result = ncpu;
#line 89 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_g_free0 (nproc_stdout);
#line 89 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 1157 "sudoku-generator.c"
}


static void sudoku_generator_class_init (SudokuGeneratorClass * klass) {
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_parent_class = g_type_class_peek_parent (klass);
#line 1164 "sudoku-generator.c"
}


static void sudoku_generator_instance_init (SudokuGenerator * self) {
}


GType sudoku_generator_get_type (void) {
	static volatile gsize sudoku_generator_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_generator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGenerator), 0, (GInstanceInitFunc) sudoku_generator_instance_init, NULL };
		GType sudoku_generator_type_id;
		sudoku_generator_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuGenerator", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_generator_type_id__volatile, sudoku_generator_type_id);
	}
	return sudoku_generator_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 104 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return self ? g_object_ref (self) : NULL;
#line 1187 "sudoku-generator.c"
}


GeneratorThread* generator_thread_construct (GType object_type, gint nsudokus, DifficultyCategory level, GeeArrayList** boards_list, GSourceFunc callback, void* callback_target) {
	GeneratorThread * self = NULL;
	gint _tmp0_ = 0;
	DifficultyCategory _tmp1_ = 0;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GSourceFunc _tmp4_ = NULL;
	void* _tmp4__target = NULL;
#line 100 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_val_if_fail (*boards_list != NULL, NULL);
#line 100 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self = (GeneratorThread*) g_object_new (object_type, NULL);
#line 102 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = nsudokus;
#line 102 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->nsudokus = _tmp0_;
#line 103 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = level;
#line 103 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->level = _tmp1_;
#line 104 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp2_ = *boards_list;
#line 104 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 104 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (self->priv->boards_list);
#line 104 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->boards_list = _tmp3_;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4_ = callback;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4__target = callback_target;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	(self->priv->callback_target_destroy_notify == NULL) ? NULL : (self->priv->callback_target_destroy_notify (self->priv->callback_target), NULL);
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback = NULL;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback_target = NULL;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback_target_destroy_notify = NULL;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback = _tmp4_;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback_target = _tmp4__target;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback_target_destroy_notify = NULL;
#line 100 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return self;
#line 1239 "sudoku-generator.c"
}


GeneratorThread* generator_thread_new (gint nsudokus, DifficultyCategory level, GeeArrayList** boards_list, GSourceFunc callback, void* callback_target) {
#line 100 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return generator_thread_construct (TYPE_GENERATOR_THREAD, nsudokus, level, boards_list, callback, callback_target);
#line 1246 "sudoku-generator.c"
}


void* generator_thread_run (GeneratorThread* self) {
	void* result = NULL;
	GSourceFunc _tmp8_ = NULL;
	void* _tmp8__target = NULL;
	GDestroyNotify _tmp8__target_destroy_notify = NULL;
#line 108 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1257 "sudoku-generator.c"
	{
		gint i = 0;
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		i = 0;
#line 1262 "sudoku-generator.c"
		{
			gboolean _tmp0_ = FALSE;
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp0_ = TRUE;
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 1269 "sudoku-generator.c"
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				GeeArrayList* _tmp4_ = NULL;
				DifficultyCategory _tmp5_ = 0;
				SudokuBoard* _tmp6_ = NULL;
				SudokuBoard* _tmp7_ = NULL;
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_tmp0_) {
#line 1278 "sudoku-generator.c"
					gint _tmp1_ = 0;
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp1_ = i;
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					i = _tmp1_ + 1;
#line 1284 "sudoku-generator.c"
				}
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp0_ = FALSE;
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp2_ = i;
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp3_ = self->priv->nsudokus;
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_tmp2_ < _tmp3_)) {
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 1296 "sudoku-generator.c"
				}
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp4_ = self->priv->boards_list;
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp5_ = self->priv->level;
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp6_ = sudoku_generator_generate_board (_tmp5_);
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp7_ = _tmp6_;
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp7_);
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_g_object_unref0 (_tmp7_);
#line 1310 "sudoku-generator.c"
			}
		}
	}
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp8_ = self->priv->callback;
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp8__target = self->priv->callback_target;
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp8__target_destroy_notify = self->priv->callback_target_destroy_notify;
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback_target_destroy_notify = NULL;
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp8_, _tmp8__target, _tmp8__target_destroy_notify);
#line 114 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	result = NULL;
#line 114 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 1328 "sudoku-generator.c"
}


static void generator_thread_class_init (GeneratorThreadClass * klass) {
#line 93 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	generator_thread_parent_class = g_type_class_peek_parent (klass);
#line 93 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_type_class_add_private (klass, sizeof (GeneratorThreadPrivate));
#line 93 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	G_OBJECT_CLASS (klass)->finalize = generator_thread_finalize;
#line 1339 "sudoku-generator.c"
}


static void generator_thread_instance_init (GeneratorThread * self) {
#line 93 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv = GENERATOR_THREAD_GET_PRIVATE (self);
#line 1346 "sudoku-generator.c"
}


static void generator_thread_finalize (GObject* obj) {
	GeneratorThread * self;
#line 93 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GENERATOR_THREAD, GeneratorThread);
#line 97 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (self->priv->boards_list);
#line 98 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	(self->priv->callback_target_destroy_notify == NULL) ? NULL : (self->priv->callback_target_destroy_notify (self->priv->callback_target), NULL);
#line 98 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback = NULL;
#line 98 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback_target = NULL;
#line 98 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback_target_destroy_notify = NULL;
#line 93 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	G_OBJECT_CLASS (generator_thread_parent_class)->finalize (obj);
#line 1366 "sudoku-generator.c"
}


GType generator_thread_get_type (void) {
	static volatile gsize generator_thread_type_id__volatile = 0;
	if (g_once_init_enter (&generator_thread_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeneratorThreadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) generator_thread_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeneratorThread), 0, (GInstanceInitFunc) generator_thread_instance_init, NULL };
		GType generator_thread_type_id;
		generator_thread_type_id = g_type_register_static (G_TYPE_OBJECT, "GeneratorThread", &g_define_type_info, 0);
		g_once_init_leave (&generator_thread_type_id__volatile, generator_thread_type_id);
	}
	return generator_thread_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



