/* rygel-mp2ts-transcoder.c generated by valac 0.25.1.16-16e7a, the Vala compiler
 * generated from rygel-mp2ts-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gst/pbutils/pbutils.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MP2_TS_PROFILE (rygel_mp2_ts_profile_get_type ())

#define RYGEL_TYPE_GST_TRANSCODER (rygel_gst_transcoder_get_type ())
#define RYGEL_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder))
#define RYGEL_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))
#define RYGEL_IS_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_IS_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_GST_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))

typedef struct _RygelGstTranscoder RygelGstTranscoder;
typedef struct _RygelGstTranscoderClass RygelGstTranscoderClass;
typedef struct _RygelGstTranscoderPrivate RygelGstTranscoderPrivate;

#define RYGEL_TYPE_AUDIO_TRANSCODER (rygel_audio_transcoder_get_type ())
#define RYGEL_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoder))
#define RYGEL_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))
#define RYGEL_IS_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_IS_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_AUDIO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))

typedef struct _RygelAudioTranscoder RygelAudioTranscoder;
typedef struct _RygelAudioTranscoderClass RygelAudioTranscoderClass;
typedef struct _RygelAudioTranscoderPrivate RygelAudioTranscoderPrivate;

#define RYGEL_TYPE_VIDEO_TRANSCODER (rygel_video_transcoder_get_type ())
#define RYGEL_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder))
#define RYGEL_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))
#define RYGEL_IS_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_IS_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_VIDEO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))

typedef struct _RygelVideoTranscoder RygelVideoTranscoder;
typedef struct _RygelVideoTranscoderClass RygelVideoTranscoderClass;
typedef struct _RygelVideoTranscoderPrivate RygelVideoTranscoderPrivate;

#define RYGEL_TYPE_MP2_TS_TRANSCODER (rygel_mp2_ts_transcoder_get_type ())
#define RYGEL_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoder))
#define RYGEL_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))
#define RYGEL_IS_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_IS_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_MP2_TS_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))

typedef struct _RygelMP2TSTranscoder RygelMP2TSTranscoder;
typedef struct _RygelMP2TSTranscoderClass RygelMP2TSTranscoderClass;
typedef struct _RygelMP2TSTranscoderPrivate RygelMP2TSTranscoderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	RYGEL_MP2_TS_PROFILE_SD_EU = 0,
	RYGEL_MP2_TS_PROFILE_SD_NA,
	RYGEL_MP2_TS_PROFILE_HD_NA
} RygelMP2TSProfile;

struct _RygelGstTranscoder {
	RygelTranscoder parent_instance;
	RygelGstTranscoderPrivate * priv;
};

struct _RygelGstTranscoderClass {
	RygelTranscoderClass parent_class;
	GstEncodingProfile* (*get_encoding_profile) (RygelGstTranscoder* self);
};

struct _RygelAudioTranscoder {
	RygelGstTranscoder parent_instance;
	RygelAudioTranscoderPrivate * priv;
	gint audio_bitrate;
	GstCaps* container_format;
	GstCaps* audio_codec_format;
};

struct _RygelAudioTranscoderClass {
	RygelGstTranscoderClass parent_class;
};

struct _RygelVideoTranscoder {
	RygelAudioTranscoder parent_instance;
	RygelVideoTranscoderPrivate * priv;
};

struct _RygelVideoTranscoderClass {
	RygelAudioTranscoderClass parent_class;
};

struct _RygelMP2TSTranscoder {
	RygelVideoTranscoder parent_instance;
	RygelMP2TSTranscoderPrivate * priv;
};

struct _RygelMP2TSTranscoderClass {
	RygelVideoTranscoderClass parent_class;
};

struct _RygelMP2TSTranscoderPrivate {
	RygelMP2TSProfile profile;
};


static gpointer rygel_mp2_ts_transcoder_parent_class = NULL;

GType rygel_mp2_ts_profile_get_type (void) G_GNUC_CONST;
GType rygel_gst_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_audio_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_video_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_mp2_ts_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_MP2_TS_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderPrivate))
enum  {
	RYGEL_MP2_TS_TRANSCODER_DUMMY_PROPERTY
};
#define RYGEL_MP2_TS_TRANSCODER_VIDEO_BITRATE 1500
#define RYGEL_MP2_TS_TRANSCODER_AUDIO_BITRATE 192
#define RYGEL_MP2_TS_TRANSCODER_CONTAINER "video/mpegts,systemstream=true,packetsize=188"
#define RYGEL_MP2_TS_TRANSCODER_AUDIO_FORMAT "audio/mpeg,mpegversion=1,layer=2"
#define RYGEL_MP2_TS_TRANSCODER_BASE_VIDEO_FORMAT "video/mpeg,mpegversion=2,systemstream=false"
#define RYGEL_MP2_TS_TRANSCODER_RESTRICTION_TEMPLATE "video/x-raw,framerate=(fraction)%d/1,width=%d,height=%d"
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_new (RygelMP2TSProfile profile);
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_construct (GType object_type, RygelMP2TSProfile profile);
RygelVideoTranscoder* rygel_video_transcoder_new (const gchar* content_type, const gchar* dlna_profile, gint audio_bitrate, gint video_bitrate, const gchar* container_caps, const gchar* audio_codec_caps, const gchar* video_codec_caps, const gchar* extension, const gchar* restrictions);
RygelVideoTranscoder* rygel_video_transcoder_construct (GType object_type, const gchar* content_type, const gchar* dlna_profile, gint audio_bitrate, gint video_bitrate, const gchar* container_caps, const gchar* audio_codec_caps, const gchar* video_codec_caps, const gchar* extension, const gchar* restrictions);
static GUPnPDIDLLiteResource* rygel_mp2_ts_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static guint rygel_mp2_ts_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item);
static void rygel_mp2_ts_transcoder_finalize (GObject* obj);

static const gint RYGEL_MP2_TS_TRANSCODER_WIDTH[3] = {720, 720, 1280};
static const gint RYGEL_MP2_TS_TRANSCODER_HEIGHT[3] = {576, 480, 720};
static const gint RYGEL_MP2_TS_TRANSCODER_FRAME_RATE[3] = {25, 30, 30};
static const gchar* RYGEL_MP2_TS_TRANSCODER_PROFILES[3] = {"MPEG_TS_SD_EU_ISO", "MPEG_TS_SD_NA_ISO", "MPEG_TS_HD_NA_ISO"};

GType rygel_mp2_ts_profile_get_type (void) {
	static volatile gsize rygel_mp2_ts_profile_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mp2_ts_profile_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_MP2_TS_PROFILE_SD_EU, "RYGEL_MP2_TS_PROFILE_SD_EU", "sd-eu"}, {RYGEL_MP2_TS_PROFILE_SD_NA, "RYGEL_MP2_TS_PROFILE_SD_NA", "sd-na"}, {RYGEL_MP2_TS_PROFILE_HD_NA, "RYGEL_MP2_TS_PROFILE_HD_NA", "hd-na"}, {0, NULL, NULL}};
		GType rygel_mp2_ts_profile_type_id;
		rygel_mp2_ts_profile_type_id = g_enum_register_static ("RygelMP2TSProfile", values);
		g_once_init_leave (&rygel_mp2_ts_profile_type_id__volatile, rygel_mp2_ts_profile_type_id);
	}
	return rygel_mp2_ts_profile_type_id__volatile;
}


RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_construct (GType object_type, RygelMP2TSProfile profile) {
	RygelMP2TSTranscoder * self = NULL;
	RygelMP2TSProfile _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	RygelMP2TSProfile _tmp2_ = 0;
	gint _tmp3_ = 0;
	RygelMP2TSProfile _tmp4_ = 0;
	gint _tmp5_ = 0;
	RygelMP2TSProfile _tmp6_ = 0;
	gint _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	RygelMP2TSProfile _tmp10_ = 0;
	_tmp0_ = profile;
	_tmp1_ = RYGEL_MP2_TS_TRANSCODER_PROFILES[_tmp0_];
	_tmp2_ = profile;
	_tmp3_ = RYGEL_MP2_TS_TRANSCODER_FRAME_RATE[_tmp2_];
	_tmp4_ = profile;
	_tmp5_ = RYGEL_MP2_TS_TRANSCODER_WIDTH[_tmp4_];
	_tmp6_ = profile;
	_tmp7_ = RYGEL_MP2_TS_TRANSCODER_HEIGHT[_tmp6_];
	_tmp8_ = g_strdup_printf (RYGEL_MP2_TS_TRANSCODER_RESTRICTION_TEMPLATE, _tmp3_, _tmp5_, _tmp7_);
	_tmp9_ = _tmp8_;
	self = (RygelMP2TSTranscoder*) rygel_video_transcoder_construct (object_type, "video/mpeg", _tmp1_, RYGEL_MP2_TS_TRANSCODER_AUDIO_BITRATE, RYGEL_MP2_TS_TRANSCODER_VIDEO_BITRATE, RYGEL_MP2_TS_TRANSCODER_CONTAINER, RYGEL_MP2_TS_TRANSCODER_AUDIO_FORMAT, RYGEL_MP2_TS_TRANSCODER_BASE_VIDEO_FORMAT, "mpg", _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = profile;
	self->priv->profile = _tmp10_;
	return self;
}


RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_new (RygelMP2TSProfile profile) {
	return rygel_mp2_ts_transcoder_construct (RYGEL_TYPE_MP2_TS_TRANSCODER, profile);
}


static GUPnPDIDLLiteResource* rygel_mp2_ts_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
	RygelMP2TSTranscoder * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* resource = NULL;
	GUPnPDIDLLiteItem* _tmp0_ = NULL;
	RygelMediaItem* _tmp1_ = NULL;
	RygelTranscodeManager* _tmp2_ = NULL;
	GUPnPDIDLLiteResource* _tmp3_ = NULL;
	RygelMP2TSProfile _tmp4_ = 0;
	gint _tmp5_ = 0;
	RygelMP2TSProfile _tmp6_ = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	self = (RygelMP2TSTranscoder*) base;
	g_return_val_if_fail (didl_item != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (manager != NULL, NULL);
	_tmp0_ = didl_item;
	_tmp1_ = item;
	_tmp2_ = manager;
	_tmp3_ = RYGEL_TRANSCODER_CLASS (rygel_mp2_ts_transcoder_parent_class)->add_resource ((RygelTranscoder*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder), _tmp0_, _tmp1_, _tmp2_, &_inner_error_);
	resource = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (resource == NULL) {
		result = NULL;
		_g_object_unref0 (resource);
		return result;
	}
	_tmp4_ = self->priv->profile;
	_tmp5_ = RYGEL_MP2_TS_TRANSCODER_WIDTH[_tmp4_];
	gupnp_didl_lite_resource_set_width (resource, _tmp5_);
	_tmp6_ = self->priv->profile;
	_tmp7_ = RYGEL_MP2_TS_TRANSCODER_HEIGHT[_tmp6_];
	gupnp_didl_lite_resource_set_height (resource, _tmp7_);
	gupnp_didl_lite_resource_set_bitrate (resource, ((RYGEL_MP2_TS_TRANSCODER_VIDEO_BITRATE + RYGEL_MP2_TS_TRANSCODER_AUDIO_BITRATE) * 1000) / 8);
	result = resource;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static guint rygel_mp2_ts_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item) {
	RygelMP2TSTranscoder * self;
	guint result = 0U;
	RygelMediaItem* _tmp0_ = NULL;
	RygelVideoItem* video_item = NULL;
	RygelMediaItem* _tmp1_ = NULL;
	RygelVideoItem* _tmp2_ = NULL;
	guint distance = 0U;
	RygelMediaItem* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	RygelVideoItem* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	RygelVideoItem* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	RygelVideoItem* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	self = (RygelMP2TSTranscoder*) base;
	g_return_val_if_fail (item != NULL, 0U);
	_tmp0_ = item;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_VIDEO_ITEM)) {
		result = G_MAXUINT;
		return result;
	}
	_tmp1_ = item;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp1_) : NULL);
	video_item = _tmp2_;
	_tmp3_ = item;
	_tmp4_ = RYGEL_TRANSCODER_CLASS (rygel_mp2_ts_transcoder_parent_class)->get_distance ((RygelTranscoder*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder), _tmp3_);
	distance = _tmp4_;
	_tmp5_ = video_item;
	_tmp6_ = rygel_audio_item_get_bitrate ((RygelAudioItem*) _tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ > 0) {
		guint _tmp8_ = 0U;
		RygelVideoItem* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp8_ = distance;
		_tmp9_ = video_item;
		_tmp10_ = rygel_audio_item_get_bitrate ((RygelAudioItem*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = abs (_tmp11_ - RYGEL_MP2_TS_TRANSCODER_VIDEO_BITRATE);
		distance = _tmp8_ + _tmp12_;
	}
	_tmp13_ = video_item;
	_tmp14_ = rygel_visual_item_get_width ((RygelVisualItem*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ > 0) {
		guint _tmp16_ = 0U;
		RygelVideoItem* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		RygelMP2TSProfile _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		_tmp16_ = distance;
		_tmp17_ = video_item;
		_tmp18_ = rygel_visual_item_get_width ((RygelVisualItem*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->profile;
		_tmp21_ = RYGEL_MP2_TS_TRANSCODER_WIDTH[_tmp20_];
		_tmp22_ = abs (_tmp19_ - _tmp21_);
		distance = _tmp16_ + _tmp22_;
	}
	_tmp23_ = video_item;
	_tmp24_ = rygel_visual_item_get_height ((RygelVisualItem*) _tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ > 0) {
		guint _tmp26_ = 0U;
		RygelVideoItem* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		RygelMP2TSProfile _tmp30_ = 0;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		_tmp26_ = distance;
		_tmp27_ = video_item;
		_tmp28_ = rygel_visual_item_get_height ((RygelVisualItem*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = self->priv->profile;
		_tmp31_ = RYGEL_MP2_TS_TRANSCODER_HEIGHT[_tmp30_];
		_tmp32_ = abs (_tmp29_ - _tmp31_);
		distance = _tmp26_ + _tmp32_;
	}
	result = distance;
	_g_object_unref0 (video_item);
	return result;
}


static void rygel_mp2_ts_transcoder_class_init (RygelMP2TSTranscoderClass * klass) {
	rygel_mp2_ts_transcoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMP2TSTranscoderPrivate));
	((RygelTranscoderClass *) klass)->add_resource = rygel_mp2_ts_transcoder_real_add_resource;
	((RygelTranscoderClass *) klass)->get_distance = rygel_mp2_ts_transcoder_real_get_distance;
	G_OBJECT_CLASS (klass)->finalize = rygel_mp2_ts_transcoder_finalize;
}


static void rygel_mp2_ts_transcoder_instance_init (RygelMP2TSTranscoder * self) {
	self->priv = RYGEL_MP2_TS_TRANSCODER_GET_PRIVATE (self);
}


static void rygel_mp2_ts_transcoder_finalize (GObject* obj) {
	RygelMP2TSTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoder);
	G_OBJECT_CLASS (rygel_mp2_ts_transcoder_parent_class)->finalize (obj);
}


/**
 * Transcoder for mpeg transport stream containing mpeg 2 video and mp2 audio.
 */
GType rygel_mp2_ts_transcoder_get_type (void) {
	static volatile gsize rygel_mp2_ts_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mp2_ts_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMP2TSTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mp2_ts_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMP2TSTranscoder), 0, (GInstanceInitFunc) rygel_mp2_ts_transcoder_instance_init, NULL };
		GType rygel_mp2_ts_transcoder_type_id;
		rygel_mp2_ts_transcoder_type_id = g_type_register_static (RYGEL_TYPE_VIDEO_TRANSCODER, "RygelMP2TSTranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_mp2_ts_transcoder_type_id__volatile, rygel_mp2_ts_transcoder_type_id);
	}
	return rygel_mp2_ts_transcoder_type_id__volatile;
}



