/* iagno.c generated by valac 0.23.3.24-5b8db, the Vala compiler
 * generated from iagno.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <locale.h>


#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;
typedef struct _IagnoPrivate IagnoPrivate;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;

#define TYPE_PLAYER (player_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _Iagno {
	GtkApplication parent_instance;
	IagnoPrivate * priv;
};

struct _IagnoClass {
	GtkApplicationClass parent_class;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _IagnoPrivate {
	GSettings* settings;
	gboolean is_fullscreen;
	gboolean is_maximized;
	GtkWindow* window;
	gint window_width;
	gint window_height;
	GtkHeaderBar* headerbar;
	GameView* view;
	GtkLabel* dark_label;
	GtkLabel* dark_score_label;
	GtkLabel* light_label;
	GtkLabel* light_score_label;
	ComputerPlayer* computer;
	Player player_one;
	guint computer_timer;
	Game* game;
};

struct _Block2Data {
	int _ref_count_;
	Iagno* self;
	GtkComboBox* combo;
	GtkComboBox* level_combo;
	GtkCheckButton* enable_sounds_button;
};


static gpointer iagno_parent_class = NULL;
static gboolean iagno_fast_mode;
static gboolean iagno_fast_mode = FALSE;
static gint iagno_computer_level;
static gint iagno_computer_level = 0;

GType iagno_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
GType computer_player_get_type (void) G_GNUC_CONST;
GType player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define IAGNO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IAGNO, IagnoPrivate))
enum  {
	IAGNO_DUMMY_PROPERTY
};
static void iagno_new_game_cb (Iagno* self);
static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_undo_move_cb (Iagno* self);
static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_preferences_cb (Iagno* self);
static void _iagno_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_help_cb (Iagno* self);
static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_about_cb (Iagno* self);
static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_quit_cb (Iagno* self);
static void _iagno_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_real_startup (GApplication* base);
Iagno* iagno_new (void);
Iagno* iagno_construct (GType object_type);
static void iagno_real_activate (GApplication* base);
static gboolean iagno_window_configure_event_cb (Iagno* self, GdkEventConfigure* event);
static gboolean _iagno_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean iagno_window_state_event_cb (Iagno* self, GdkEventWindowState* event);
static gboolean _iagno_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
void game_view_set_game (GameView* self, Game* value);
static void iagno_player_move_cb (Iagno* self, gint x, gint y);
static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self);
void game_view_set_theme (GameView* self, const gchar* value);
static void iagno_start_game (Iagno* self);
static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options);
static void iagno_real_shutdown (GApplication* base);
static void iagno_cancel_pending_computer_moves (Iagno* self);
Game* game_new (gint width, gint height);
Game* game_construct (GType object_type, gint width, gint height);
static void iagno_game_move_cb (Iagno* self);
static void _iagno_game_move_cb_game_move (Game* _sender, gpointer self);
static void iagno_game_complete_cb (Iagno* self);
static void _iagno_game_complete_cb_game_complete (Game* _sender, gpointer self);
ComputerPlayer* computer_player_new (Game* game, gint level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level);
static void iagno_update_ui (Iagno* self);
static gboolean iagno_computer_move_cb (Iagno* self);
static gboolean _iagno_computer_move_cb_gsource_func (gpointer self);
gboolean game_can_undo (Game* self, gint count);
Player game_get_current_color (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
void game_undo (Game* self, gint count);
gboolean game_can_move (Game* self, Player color);
static void iagno_show_preferences_dialog (Iagno* self);
static void iagno_play_sound (Iagno* self, const gchar* name);
void game_pass (Game* self);
gint game_get_n_tiles (Game* self);
void computer_player_move (ComputerPlayer* self);
gint game_place_tile (Game* self, gint x, gint y);
static void iagno_computer_level_changed_cb (Iagno* self, GtkComboBox* combo);
static void iagno_mode_changed_cb (Iagno* self, GtkComboBox* combo, GtkComboBox* level_combo);
static void iagno_sound_select (Iagno* self, GtkToggleButton* widget);
static void iagno_propbox_response_cb (Iagno* self, GtkWidget* widget, gint response_id);
static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event);
static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget);
void game_view_redraw (GameView* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _iagno_propbox_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void __lambda4_ (Block2Data* _data2_);
static void ___lambda4__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void __lambda5_ (Block2Data* _data2_);
static void ___lambda5__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _iagno_computer_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void __lambda6_ (Block2Data* _data2_);
static void ___lambda6__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void __lambda7_ (Block2Data* _data2_);
static void ___lambda7__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _iagno_sound_select_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
gint iagno_main (gchar** args, int args_length1);
static void iagno_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry IAGNO_option_entries[9] = {{"fast-mode", 'f', 0, G_OPTION_ARG_NONE, &iagno_fast_mode, "Reduce delay before AI moves", NULL}, {"first", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play first", NULL}, {"level", 'l', 0, G_OPTION_ARG_INT, &iagno_computer_level, "Set the level of the computer's AI", NULL}, {"mute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn off the sound", NULL}, {"second", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play second", NULL}, {"two-players", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Two-players mode", NULL}, {"unmute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn on the sound", NULL}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print release version and exit", NULL}, {NULL}};
static const GActionEntry IAGNO_app_actions[6] = {{"new-game", _iagno_new_game_cb_gsimple_action_activate_callback}, {"undo-move", _iagno_undo_move_cb_gsimple_action_activate_callback}, {"preferences", _iagno_preferences_cb_gsimple_action_activate_callback}, {"help", _iagno_help_cb_gsimple_action_activate_callback}, {"about", _iagno_about_cb_gsimple_action_activate_callback}, {"quit", _iagno_quit_cb_gsimple_action_activate_callback}};

static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_new_game_cb ((Iagno*) self);
#line 228 "iagno.c"
}


static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_undo_move_cb ((Iagno*) self);
#line 235 "iagno.c"
}


static void _iagno_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_preferences_cb ((Iagno*) self);
#line 242 "iagno.c"
}


static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_help_cb ((Iagno*) self);
#line 249 "iagno.c"
}


static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_about_cb ((Iagno*) self);
#line 256 "iagno.c"
}


static void _iagno_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_quit_cb ((Iagno*) self);
#line 263 "iagno.c"
}


static void iagno_real_startup (GApplication* base) {
	Iagno * self;
#line 67 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 69 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (iagno_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
#line 70 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_action_map_add_action_entries ((GActionMap*) self, IAGNO_app_actions, G_N_ELEMENTS (IAGNO_app_actions), self);
#line 275 "iagno.c"
}


Iagno* iagno_construct (GType object_type) {
	Iagno * self = NULL;
#line 75 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self = (Iagno*) g_object_new (object_type, "application-id", "org.gnome.iagno", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 77 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_application_add_main_option_entries ((GApplication*) self, IAGNO_option_entries);
#line 73 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	return self;
#line 287 "iagno.c"
}


Iagno* iagno_new (void) {
#line 73 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	return iagno_construct (TYPE_IAGNO);
#line 294 "iagno.c"
}


static gboolean _iagno_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = iagno_window_configure_event_cb ((Iagno*) self, event);
#line 103 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	return result;
#line 303 "iagno.c"
}


static gboolean _iagno_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = iagno_window_state_event_cb ((Iagno*) self, event);
#line 104 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	return result;
#line 312 "iagno.c"
}


static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self) {
#line 142 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_player_move_cb ((Iagno*) self, x, y);
#line 319 "iagno.c"
}


static void iagno_real_activate (GApplication* base) {
	Iagno * self;
	GtkWindow* _tmp0_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* _tmp7_ = NULL;
	GObject* _tmp8_ = NULL;
	GtkApplicationWindow* _tmp9_ = NULL;
	GtkWindow* _tmp10_ = NULL;
	GtkWindow* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkWindow* _tmp13_ = NULL;
	GtkWindow* _tmp14_ = NULL;
	GtkWindow* _tmp15_ = NULL;
	GtkWindow* _tmp16_ = NULL;
	GSettings* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	GSettings* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	GSettings* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GtkImage* image = NULL;
	GtkImage* _tmp24_ = NULL;
	GtkImage* _tmp25_ = NULL;
	GtkTextDirection _tmp26_ = 0;
	GtkButton* undo_button = NULL;
	GtkButton* _tmp29_ = NULL;
	GtkButton* _tmp30_ = NULL;
	GtkImage* _tmp31_ = NULL;
	GtkButton* _tmp32_ = NULL;
	GtkButton* _tmp33_ = NULL;
	GtkButton* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	GtkButton* _tmp36_ = NULL;
	GtkHeaderBar* _tmp37_ = NULL;
	GtkHeaderBar* _tmp38_ = NULL;
	GtkHeaderBar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	GtkHeaderBar* _tmp41_ = NULL;
	GtkButton* _tmp42_ = NULL;
	GtkHeaderBar* _tmp43_ = NULL;
	GtkWindow* _tmp44_ = NULL;
	GtkHeaderBar* _tmp45_ = NULL;
	GtkAspectFrame* frame = NULL;
	GtkAspectFrame* _tmp46_ = NULL;
	GtkAspectFrame* _tmp47_ = NULL;
	GtkAspectFrame* _tmp48_ = NULL;
	GtkWindow* _tmp49_ = NULL;
	GtkAspectFrame* _tmp50_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp51_ = NULL;
	GtkBox* _tmp52_ = NULL;
	GtkBox* _tmp53_ = NULL;
	GtkAspectFrame* _tmp54_ = NULL;
	GtkBox* _tmp55_ = NULL;
	GameView* _tmp56_ = NULL;
	GameView* _tmp57_ = NULL;
	Game* _tmp58_ = NULL;
	GameView* _tmp59_ = NULL;
	gchar* tile_set = NULL;
	GSettings* _tmp60_ = NULL;
	gchar* _tmp61_ = NULL;
	GameView* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
	GameView* _tmp66_ = NULL;
	GameView* _tmp67_ = NULL;
	GtkBox* _tmp68_ = NULL;
	GameView* _tmp69_ = NULL;
	GtkBox* side_box = NULL;
	GtkBox* _tmp70_ = NULL;
	GtkBox* _tmp71_ = NULL;
	GtkBox* _tmp72_ = NULL;
	GtkBox* _tmp73_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp74_ = NULL;
	GtkGrid* _tmp75_ = NULL;
	GtkGrid* _tmp76_ = NULL;
	GtkGrid* _tmp77_ = NULL;
	GtkGrid* _tmp78_ = NULL;
	GtkGrid* _tmp79_ = NULL;
	GtkBox* _tmp80_ = NULL;
	GtkGrid* _tmp81_ = NULL;
	const gchar* _tmp82_ = NULL;
	GtkLabel* _tmp83_ = NULL;
	GtkLabel* _tmp84_ = NULL;
	GtkGrid* _tmp85_ = NULL;
	GtkLabel* _tmp86_ = NULL;
	GtkLabel* _tmp87_ = NULL;
	GtkLabel* _tmp88_ = NULL;
	GtkGrid* _tmp89_ = NULL;
	GtkLabel* _tmp90_ = NULL;
	const gchar* _tmp91_ = NULL;
	GtkLabel* _tmp92_ = NULL;
	GtkLabel* _tmp93_ = NULL;
	GtkGrid* _tmp94_ = NULL;
	GtkLabel* _tmp95_ = NULL;
	GtkLabel* _tmp96_ = NULL;
	GtkLabel* _tmp97_ = NULL;
	GtkGrid* _tmp98_ = NULL;
	GtkLabel* _tmp99_ = NULL;
	GtkButton* new_game_button = NULL;
	GtkButton* _tmp100_ = NULL;
	GtkButton* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	GtkButton* _tmp103_ = NULL;
	GtkButton* _tmp104_ = NULL;
	GtkButton* _tmp105_ = NULL;
	GtkButton* _tmp106_ = NULL;
	GtkButton* _tmp107_ = NULL;
	GtkButton* _tmp108_ = NULL;
	GtkButton* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	GtkButton* _tmp111_ = NULL;
	GtkBox* _tmp112_ = NULL;
	GtkButton* _tmp113_ = NULL;
	GtkWindow* _tmp114_ = NULL;
	GError * _inner_error_ = NULL;
#line 80 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 82 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 82 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp0_ != NULL) {
#line 448 "iagno.c"
		GtkWindow* _tmp1_ = NULL;
#line 84 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp1_ = self->priv->window;
#line 84 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		gtk_widget_show ((GtkWidget*) _tmp1_);
#line 85 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		return;
#line 456 "iagno.c"
	}
#line 88 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = gtk_builder_new ();
#line 88 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	builder = _tmp2_;
#line 462 "iagno.c"
	{
		GtkBuilder* _tmp3_ = NULL;
#line 91 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp3_ = builder;
#line 91 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		gtk_builder_add_from_file (_tmp3_, DATA_DIRECTORY "/iagno.ui", &_inner_error_);
#line 91 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		if (_inner_error_ != NULL) {
#line 471 "iagno.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 89 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		e = _inner_error_;
#line 89 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_inner_error_ = NULL;
#line 95 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp4_ = stderr;
#line 95 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp5_ = e;
#line 95 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp6_ = _tmp5_->message;
#line 95 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		fprintf (_tmp4_, "Could not load UI: %s\n", _tmp6_);
#line 96 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_error_free0 (e);
#line 96 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (builder);
#line 96 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		return;
#line 500 "iagno.c"
	}
	__finally2:
#line 89 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_inner_error_ != NULL) {
#line 89 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (builder);
#line 89 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 89 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_clear_error (&_inner_error_);
#line 89 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		return;
#line 513 "iagno.c"
	}
#line 98 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp7_ = builder;
#line 98 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp8_ = gtk_builder_get_object (_tmp7_, "iagno-menu");
#line 98 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_application_set_app_menu ((GtkApplication*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp8_) : NULL);
#line 99 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp9_ = (GtkApplicationWindow*) gtk_application_window_new ((GtkApplication*) self);
#line 99 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp9_);
#line 99 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->window);
#line 99 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self->priv->window = (GtkWindow*) _tmp9_;
#line 100 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp10_ = self->priv->window;
#line 100 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp10_, (guint) 25);
#line 101 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp11_ = self->priv->window;
#line 101 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp12_ = _ ("Iagno");
#line 101 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_window_set_title (_tmp11_, _tmp12_);
#line 102 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp13_ = self->priv->window;
#line 102 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_window_set_icon_name (_tmp13_, "iagno");
#line 103 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp14_ = self->priv->window;
#line 103 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_signal_connect_object ((GtkWidget*) _tmp14_, "configure-event", (GCallback) _iagno_window_configure_event_cb_gtk_widget_configure_event, self, 0);
#line 104 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp15_ = self->priv->window;
#line 104 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_signal_connect_object ((GtkWidget*) _tmp15_, "window-state-event", (GCallback) _iagno_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 105 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp16_ = self->priv->window;
#line 105 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp17_ = self->priv->settings;
#line 105 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp18_ = g_settings_get_int (_tmp17_, "window-width");
#line 105 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp19_ = self->priv->settings;
#line 105 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp20_ = g_settings_get_int (_tmp19_, "window-height");
#line 105 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_window_set_default_size (_tmp16_, _tmp18_, _tmp20_);
#line 106 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp21_ = self->priv->settings;
#line 106 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp22_ = g_settings_get_boolean (_tmp21_, "window-is-maximized");
#line 106 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp22_) {
#line 569 "iagno.c"
		GtkWindow* _tmp23_ = NULL;
#line 107 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp23_ = self->priv->window;
#line 107 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		gtk_window_maximize (_tmp23_);
#line 575 "iagno.c"
	}
#line 109 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp24_ = (GtkImage*) gtk_image_new ();
#line 109 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp24_);
#line 109 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	image = _tmp24_;
#line 110 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp25_ = image;
#line 110 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_set (_tmp25_, "icon-size", (gint) GTK_ICON_SIZE_BUTTON, NULL);
#line 111 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp26_ = gtk_widget_get_default_direction ();
#line 111 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp26_ == GTK_TEXT_DIR_RTL) {
#line 591 "iagno.c"
		GtkImage* _tmp27_ = NULL;
#line 112 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp27_ = image;
#line 112 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_object_set (_tmp27_, "icon-name", "edit-undo-rtl-symbolic", NULL);
#line 597 "iagno.c"
	} else {
		GtkImage* _tmp28_ = NULL;
#line 114 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp28_ = image;
#line 114 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_object_set (_tmp28_, "icon-name", "edit-undo-symbolic", NULL);
#line 604 "iagno.c"
	}
#line 116 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp29_ = (GtkButton*) gtk_button_new ();
#line 116 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp29_);
#line 116 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	undo_button = _tmp29_;
#line 117 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp30_ = undo_button;
#line 117 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp31_ = image;
#line 117 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_button_set_image (_tmp30_, (GtkWidget*) _tmp31_);
#line 118 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp32_ = undo_button;
#line 118 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp32_, GTK_ALIGN_CENTER);
#line 119 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp33_ = undo_button;
#line 119 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_actionable_set_action_name ((GtkActionable*) _tmp33_, "app.undo-move");
#line 120 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp34_ = undo_button;
#line 120 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp35_ = _ ("Undo your most recent move");
#line 120 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp34_, _tmp35_);
#line 121 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp36_ = undo_button;
#line 121 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp36_);
#line 123 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp37_ = (GtkHeaderBar*) gtk_header_bar_new ();
#line 123 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp37_);
#line 123 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 123 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self->priv->headerbar = _tmp37_;
#line 124 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp38_ = self->priv->headerbar;
#line 124 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_header_bar_set_show_close_button (_tmp38_, TRUE);
#line 125 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp39_ = self->priv->headerbar;
#line 125 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp40_ = _ ("Iagno");
#line 125 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_header_bar_set_title (_tmp39_, _tmp40_);
#line 126 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp41_ = self->priv->headerbar;
#line 126 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp42_ = undo_button;
#line 126 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_header_bar_pack_start (_tmp41_, (GtkWidget*) _tmp42_);
#line 127 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp43_ = self->priv->headerbar;
#line 127 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp43_);
#line 128 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp44_ = self->priv->window;
#line 128 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp45_ = self->priv->headerbar;
#line 128 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_window_set_titlebar (_tmp44_, (GtkWidget*) _tmp45_);
#line 130 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp46_ = (GtkAspectFrame*) gtk_aspect_frame_new (NULL, (gfloat) 0.5, (gfloat) 0.5, (gfloat) 1.4, FALSE);
#line 130 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp46_);
#line 130 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	frame = _tmp46_;
#line 131 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp47_ = frame;
#line 131 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_frame_set_shadow_type ((GtkFrame*) _tmp47_, GTK_SHADOW_NONE);
#line 132 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp48_ = frame;
#line 132 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp48_);
#line 133 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp49_ = self->priv->window;
#line 133 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp50_ = frame;
#line 133 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_container_add ((GtkContainer*) _tmp49_, (GtkWidget*) _tmp50_);
#line 135 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp51_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 25);
#line 135 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp51_);
#line 135 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	hbox = _tmp51_;
#line 136 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp52_ = hbox;
#line 136 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp52_, GTK_ALIGN_FILL);
#line 137 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp53_ = hbox;
#line 137 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp53_);
#line 138 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp54_ = frame;
#line 138 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp55_ = hbox;
#line 138 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_container_add ((GtkContainer*) _tmp54_, (GtkWidget*) _tmp55_);
#line 140 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp56_ = game_view_new ();
#line 140 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp56_);
#line 140 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->view);
#line 140 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self->priv->view = _tmp56_;
#line 141 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp57_ = self->priv->view;
#line 141 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp58_ = self->priv->game;
#line 141 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	game_view_set_game (_tmp57_, _tmp58_);
#line 142 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp59_ = self->priv->view;
#line 142 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp59_, "move", (GCallback) _iagno_player_move_cb_game_view_move, self, 0);
#line 143 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp60_ = self->priv->settings;
#line 143 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp61_ = g_settings_get_string (_tmp60_, "tileset");
#line 143 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	tile_set = _tmp61_;
#line 144 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp62_ = self->priv->view;
#line 144 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp63_ = tile_set;
#line 144 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp64_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp63_, NULL);
#line 144 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp65_ = _tmp64_;
#line 144 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	game_view_set_theme (_tmp62_, _tmp65_);
#line 144 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_free0 (_tmp65_);
#line 145 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp66_ = self->priv->view;
#line 145 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp66_, GTK_ALIGN_END);
#line 146 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp67_ = self->priv->view;
#line 146 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp67_);
#line 147 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp68_ = hbox;
#line 147 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp69_ = self->priv->view;
#line 147 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_box_pack_start (_tmp68_, (GtkWidget*) _tmp69_, TRUE, TRUE, (guint) 0);
#line 149 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp70_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
#line 149 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp70_);
#line 149 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	side_box = _tmp70_;
#line 150 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp71_ = side_box;
#line 150 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp71_);
#line 151 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp72_ = hbox;
#line 151 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp73_ = side_box;
#line 151 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_box_pack_end (_tmp72_, (GtkWidget*) _tmp73_, FALSE, TRUE, (guint) 0);
#line 153 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp74_ = (GtkGrid*) gtk_grid_new ();
#line 153 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp74_);
#line 153 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	grid = _tmp74_;
#line 154 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp75_ = grid;
#line 154 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp75_, GTK_ALIGN_CENTER);
#line 155 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp76_ = grid;
#line 155 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_set_vexpand ((GtkWidget*) _tmp76_, TRUE);
#line 156 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp77_ = grid;
#line 156 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp77_, TRUE);
#line 157 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp78_ = grid;
#line 157 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_grid_set_column_spacing (_tmp78_, (guint) 8);
#line 158 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp79_ = grid;
#line 158 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp79_);
#line 159 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp80_ = side_box;
#line 159 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp81_ = grid;
#line 159 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_box_pack_start (_tmp80_, (GtkWidget*) _tmp81_, FALSE, TRUE, (guint) 0);
#line 161 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp82_ = _ ("Dark:");
#line 161 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp83_ = (GtkLabel*) gtk_label_new (_tmp82_);
#line 161 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp83_);
#line 161 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_label);
#line 161 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self->priv->dark_label = _tmp83_;
#line 162 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp84_ = self->priv->dark_label;
#line 162 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp84_);
#line 163 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp85_ = grid;
#line 163 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp86_ = self->priv->dark_label;
#line 163 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp85_, (GtkWidget*) _tmp86_, 1, 0, 1, 1);
#line 165 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp87_ = (GtkLabel*) gtk_label_new ("00");
#line 165 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp87_);
#line 165 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_score_label);
#line 165 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self->priv->dark_score_label = _tmp87_;
#line 166 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp88_ = self->priv->dark_score_label;
#line 166 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp88_);
#line 167 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp89_ = grid;
#line 167 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp90_ = self->priv->dark_score_label;
#line 167 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp89_, (GtkWidget*) _tmp90_, 2, 0, 1, 1);
#line 169 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp91_ = _ ("Light:");
#line 169 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp92_ = (GtkLabel*) gtk_label_new (_tmp91_);
#line 169 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp92_);
#line 169 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_label);
#line 169 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self->priv->light_label = _tmp92_;
#line 170 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp93_ = self->priv->light_label;
#line 170 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp93_);
#line 171 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp94_ = grid;
#line 171 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp95_ = self->priv->light_label;
#line 171 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp94_, (GtkWidget*) _tmp95_, 1, 1, 1, 1);
#line 173 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp96_ = (GtkLabel*) gtk_label_new ("00");
#line 173 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp96_);
#line 173 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_score_label);
#line 173 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self->priv->light_score_label = _tmp96_;
#line 174 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp97_ = self->priv->light_score_label;
#line 174 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp97_);
#line 175 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp98_ = grid;
#line 175 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp99_ = self->priv->light_score_label;
#line 175 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp98_, (GtkWidget*) _tmp99_, 2, 1, 1, 1);
#line 177 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp100_ = (GtkButton*) gtk_button_new ();
#line 177 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp100_);
#line 177 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	new_game_button = _tmp100_;
#line 178 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp101_ = new_game_button;
#line 178 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp102_ = _ ("_Start Over");
#line 178 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_button_set_label (_tmp101_, _tmp102_);
#line 179 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp103_ = new_game_button;
#line 179 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_button_set_use_underline (_tmp103_, TRUE);
#line 180 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp104_ = new_game_button;
#line 180 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_set ((GtkWidget*) _tmp104_, "width-request", 120, NULL);
#line 181 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp105_ = new_game_button;
#line 181 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_set ((GtkWidget*) _tmp105_, "height-request", 60, NULL);
#line 182 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp106_ = new_game_button;
#line 182 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp106_, GTK_ALIGN_END);
#line 183 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp107_ = new_game_button;
#line 183 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp107_, GTK_ALIGN_END);
#line 184 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp108_ = new_game_button;
#line 184 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_actionable_set_action_name ((GtkActionable*) _tmp108_, "app.new-game");
#line 185 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp109_ = new_game_button;
#line 185 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp110_ = _ ("Start a new game");
#line 185 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp109_, _tmp110_);
#line 186 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp111_ = new_game_button;
#line 186 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp111_);
#line 187 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp112_ = side_box;
#line 187 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp113_ = new_game_button;
#line 187 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_box_pack_end (_tmp112_, (GtkWidget*) _tmp113_, FALSE, FALSE, (guint) 0);
#line 189 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_start_game (self);
#line 191 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp114_ = self->priv->window;
#line 191 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp114_);
#line 80 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (new_game_button);
#line 80 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (grid);
#line 80 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (side_box);
#line 80 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_free0 (tile_set);
#line 80 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (hbox);
#line 80 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (frame);
#line 80 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (undo_button);
#line 80 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (image);
#line 80 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (builder);
#line 960 "iagno.c"
}


static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Iagno * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp3_ = NULL;
	GVariantDict* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GVariantDict* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gint _tmp10_ = 0;
	GVariantDict* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	GVariantDict* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GVariantDict* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
#line 194 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 194 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 196 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = options;
#line 196 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 196 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 991 "iagno.c"
		FILE* _tmp2_ = NULL;
#line 199 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp2_ = stderr;
#line 199 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		fprintf (_tmp2_, "%1$s %2$s\n", "iagno", VERSION);
#line 200 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		result = EXIT_SUCCESS;
#line 200 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		return result;
#line 1001 "iagno.c"
	}
#line 205 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp3_ = g_settings_new ("org.gnome.iagno");
#line 205 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->settings);
#line 205 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self->priv->settings = _tmp3_;
#line 208 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp4_ = options;
#line 208 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp5_ = g_variant_dict_contains (_tmp4_, "unmute");
#line 208 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp5_) {
#line 1015 "iagno.c"
		GSettings* _tmp6_ = NULL;
#line 209 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp6_ = self->priv->settings;
#line 209 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_settings_set_boolean (_tmp6_, "sound", TRUE);
#line 1021 "iagno.c"
	}
#line 210 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp7_ = options;
#line 210 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp8_ = g_variant_dict_contains (_tmp7_, "mute");
#line 210 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp8_) {
#line 1029 "iagno.c"
		GSettings* _tmp9_ = NULL;
#line 211 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp9_ = self->priv->settings;
#line 211 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_settings_set_boolean (_tmp9_, "sound", FALSE);
#line 1035 "iagno.c"
	}
#line 214 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp10_ = iagno_computer_level;
#line 214 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp10_ > 0) {
#line 1041 "iagno.c"
		gint _tmp11_ = 0;
#line 216 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp11_ = iagno_computer_level;
#line 216 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		if (_tmp11_ <= 3) {
#line 1047 "iagno.c"
			GSettings* _tmp12_ = NULL;
			gint _tmp13_ = 0;
#line 217 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp12_ = self->priv->settings;
#line 217 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp13_ = iagno_computer_level;
#line 217 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			g_settings_set_int (_tmp12_, "computer-level", _tmp13_);
#line 1056 "iagno.c"
		} else {
			FILE* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 219 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp14_ = stderr;
#line 219 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp15_ = _ ("Level should be between 1 (easy) and 3 (hard). Settings unchanged.");
#line 219 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			fprintf (_tmp14_, "%1$s\n", _tmp15_);
#line 1066 "iagno.c"
		}
	}
#line 223 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp16_ = options;
#line 223 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp17_ = g_variant_dict_contains (_tmp16_, "second");
#line 223 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp17_) {
#line 1075 "iagno.c"
		GSettings* _tmp18_ = NULL;
#line 224 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp18_ = self->priv->settings;
#line 224 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_settings_set_string (_tmp18_, "play-as", "second");
#line 1081 "iagno.c"
	}
#line 225 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp19_ = options;
#line 225 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp20_ = g_variant_dict_contains (_tmp19_, "first");
#line 225 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp20_) {
#line 1089 "iagno.c"
		GSettings* _tmp21_ = NULL;
#line 226 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp21_ = self->priv->settings;
#line 226 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_settings_set_string (_tmp21_, "play-as", "first");
#line 1095 "iagno.c"
	}
#line 227 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp22_ = options;
#line 227 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp23_ = g_variant_dict_contains (_tmp22_, "two-players");
#line 227 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp23_) {
#line 1103 "iagno.c"
		GSettings* _tmp24_ = NULL;
#line 228 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp24_ = self->priv->settings;
#line 228 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_settings_set_string (_tmp24_, "play-as", "two-players");
#line 1109 "iagno.c"
	}
#line 231 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	result = -1;
#line 231 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	return result;
#line 1115 "iagno.c"
}


static void iagno_real_shutdown (GApplication* base) {
	Iagno * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 234 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 236 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (iagno_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
#line 239 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 239 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = self->priv->window_width;
#line 239 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
#line 240 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = self->priv->settings;
#line 240 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp3_ = self->priv->window_height;
#line 240 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
#line 241 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp4_ = self->priv->settings;
#line 241 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp5_ = self->priv->is_maximized;
#line 241 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
#line 1149 "iagno.c"
}


static gboolean iagno_window_configure_event_cb (Iagno* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 244 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 244 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 246 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = self->priv->is_maximized;
#line 246 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (!_tmp1_) {
#line 1165 "iagno.c"
		gboolean _tmp2_ = FALSE;
#line 246 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp2_ = self->priv->is_fullscreen;
#line 246 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp0_ = !_tmp2_;
#line 1171 "iagno.c"
	} else {
#line 246 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp0_ = FALSE;
#line 1175 "iagno.c"
	}
#line 246 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp0_) {
#line 1179 "iagno.c"
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		GdkEventConfigure* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 248 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp3_ = event;
#line 248 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp4_ = _tmp3_->width;
#line 248 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		self->priv->window_width = _tmp4_;
#line 249 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp5_ = event;
#line 249 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp6_ = _tmp5_->height;
#line 249 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		self->priv->window_height = _tmp6_;
#line 1196 "iagno.c"
	}
#line 252 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	result = FALSE;
#line 252 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	return result;
#line 1202 "iagno.c"
}


static gboolean iagno_window_state_event_cb (Iagno* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 255 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 255 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 257 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = event;
#line 257 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 257 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1222 "iagno.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 258 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp2_ = event;
#line 258 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 258 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1231 "iagno.c"
	}
#line 259 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp4_ = event;
#line 259 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 259 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
#line 1239 "iagno.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 260 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp6_ = event;
#line 260 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 260 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		self->priv->is_fullscreen = (_tmp7_ & GDK_WINDOW_STATE_FULLSCREEN) != 0;
#line 1248 "iagno.c"
	}
#line 261 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	result = FALSE;
#line 261 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	return result;
#line 1254 "iagno.c"
}


static void iagno_quit_cb (Iagno* self) {
	GtkWindow* _tmp0_ = NULL;
#line 264 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 266 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 266 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 1266 "iagno.c"
}


static void iagno_new_game_cb (Iagno* self) {
#line 269 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 271 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_start_game (self);
#line 1275 "iagno.c"
}


static void _iagno_game_move_cb_game_move (Game* _sender, gpointer self) {
#line 282 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_game_move_cb ((Iagno*) self);
#line 1282 "iagno.c"
}


static void _iagno_game_complete_cb_game_complete (Game* _sender, gpointer self) {
#line 283 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_game_complete_cb ((Iagno*) self);
#line 1289 "iagno.c"
}


static gboolean _iagno_computer_move_cb_gsource_func (gpointer self) {
	gboolean result;
	result = iagno_computer_move_cb ((Iagno*) self);
#line 301 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	return result;
#line 1298 "iagno.c"
}


static void iagno_start_game (Iagno* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	GameView* _tmp5_ = NULL;
	Game* _tmp6_ = NULL;
	gchar* mode = NULL;
	GSettings* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	Player _tmp14_ = 0;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	Player _tmp17_ = 0;
#line 274 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 276 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_cancel_pending_computer_moves (self);
#line 278 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 278 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp0_ != NULL) {
#line 1325 "iagno.c"
		Game* _tmp1_ = NULL;
#line 279 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp1_ = self->priv->game;
#line 279 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 1331 "iagno.c"
	}
#line 281 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = game_new (8, 8);
#line 281 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->game);
#line 281 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self->priv->game = _tmp2_;
#line 282 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp3_ = self->priv->game;
#line 282 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp3_, "move", (GCallback) _iagno_game_move_cb_game_move, self, 0);
#line 283 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp4_ = self->priv->game;
#line 283 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp4_, "complete", (GCallback) _iagno_game_complete_cb_game_complete, self, 0);
#line 284 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp5_ = self->priv->view;
#line 284 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp6_ = self->priv->game;
#line 284 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	game_view_set_game (_tmp5_, _tmp6_);
#line 286 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp7_ = self->priv->settings;
#line 286 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp8_ = g_settings_get_string (_tmp7_, "play-as");
#line 286 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	mode = _tmp8_;
#line 287 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp9_ = mode;
#line 287 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (g_strcmp0 (_tmp9_, "two-players") == 0) {
#line 288 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->computer);
#line 288 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		self->priv->computer = NULL;
#line 1367 "iagno.c"
	} else {
		Game* _tmp10_ = NULL;
		GSettings* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		ComputerPlayer* _tmp13_ = NULL;
#line 290 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp10_ = self->priv->game;
#line 290 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp11_ = self->priv->settings;
#line 290 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp12_ = g_settings_get_int (_tmp11_, "computer-level");
#line 290 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp13_ = computer_player_new (_tmp10_, _tmp12_);
#line 290 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->computer);
#line 290 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		self->priv->computer = _tmp13_;
#line 1385 "iagno.c"
	}
#line 292 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp15_ = mode;
#line 292 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (g_strcmp0 (_tmp15_, "first") == 0) {
#line 292 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp14_ = PLAYER_DARK;
#line 1393 "iagno.c"
	} else {
#line 292 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp14_ = PLAYER_LIGHT;
#line 1397 "iagno.c"
	}
#line 292 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self->priv->player_one = _tmp14_;
#line 294 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 300 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp17_ = self->priv->player_one;
#line 300 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp17_ != PLAYER_DARK) {
#line 1407 "iagno.c"
		ComputerPlayer* _tmp18_ = NULL;
#line 300 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp18_ = self->priv->computer;
#line 300 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp16_ = _tmp18_ != NULL;
#line 1413 "iagno.c"
	} else {
#line 300 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp16_ = FALSE;
#line 1417 "iagno.c"
	}
#line 300 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp16_) {
#line 1421 "iagno.c"
		guint _tmp19_ = 0U;
#line 301 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp19_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 301 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		self->priv->computer_timer = _tmp19_;
#line 1427 "iagno.c"
	}
#line 274 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_free0 (mode);
#line 1431 "iagno.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 308 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	return self ? g_object_ref (self) : NULL;
#line 1438 "iagno.c"
}


static void iagno_update_ui (Iagno* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	GSimpleAction* undo_action = NULL;
	GAction* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	Player _tmp4_ = 0;
	GSimpleAction* new_game_action = NULL;
	GAction* _tmp12_ = NULL;
	GSimpleAction* _tmp13_ = NULL;
	GSimpleAction* _tmp14_ = NULL;
	Game* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	Game* _tmp17_ = NULL;
	Player _tmp18_ = 0;
	Player _tmp19_ = 0;
#line 304 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 306 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = self->priv->headerbar;
#line 306 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_header_bar_set_subtitle (_tmp0_, NULL);
#line 308 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) self, "undo-move");
#line 308 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
#line 308 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	undo_action = _tmp2_;
#line 309 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp4_ = self->priv->player_one;
#line 309 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp4_ == PLAYER_DARK) {
#line 309 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp3_ = TRUE;
#line 1476 "iagno.c"
	} else {
		ComputerPlayer* _tmp5_ = NULL;
#line 309 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp5_ = self->priv->computer;
#line 309 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp3_ = _tmp5_ == NULL;
#line 1483 "iagno.c"
	}
#line 309 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp3_) {
#line 1487 "iagno.c"
		GSimpleAction* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 310 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp6_ = undo_action;
#line 310 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 310 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp8_ = game_can_undo (_tmp7_, 1);
#line 310 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_simple_action_set_enabled (_tmp6_, _tmp8_);
#line 1499 "iagno.c"
	} else {
		GSimpleAction* _tmp9_ = NULL;
		Game* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 312 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp9_ = undo_action;
#line 312 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp10_ = self->priv->game;
#line 312 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp11_ = game_can_undo (_tmp10_, 2);
#line 312 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_simple_action_set_enabled (_tmp9_, _tmp11_);
#line 1512 "iagno.c"
	}
#line 314 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp12_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
#line 314 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_simple_action_get_type (), GSimpleAction));
#line 314 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	new_game_action = _tmp13_;
#line 315 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp14_ = new_game_action;
#line 315 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp15_ = self->priv->game;
#line 315 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp16_ = game_can_undo (_tmp15_, 1);
#line 315 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_simple_action_set_enabled (_tmp14_, _tmp16_);
#line 317 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp17_ = self->priv->game;
#line 317 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp18_ = game_get_current_color (_tmp17_);
#line 317 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp19_ = _tmp18_;
#line 317 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp19_ == PLAYER_DARK) {
#line 1536 "iagno.c"
		GtkLabel* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		GtkLabel* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		GtkLabel* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		Game* _tmp34_ = NULL;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		GtkLabel* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		Game* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
#line 319 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp20_ = self->priv->dark_label;
#line 319 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp21_ = _ ("Dark:");
#line 319 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp22_ = g_strconcat ("<span font_weight='bold'>", _tmp21_, NULL);
#line 319 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp23_ = _tmp22_;
#line 319 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp24_ = g_strconcat (_tmp23_, "</span>", NULL);
#line 319 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp25_ = _tmp24_;
#line 319 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		gtk_label_set_markup (_tmp20_, _tmp25_);
#line 319 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_free0 (_tmp25_);
#line 319 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_free0 (_tmp23_);
#line 320 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp26_ = self->priv->light_label;
#line 320 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp27_ = _ ("Light:");
#line 320 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp28_ = g_strconcat ("<span font_weight='normal'>", _tmp27_, NULL);
#line 320 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp29_ = _tmp28_;
#line 320 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp30_ = g_strconcat (_tmp29_, "</span>", NULL);
#line 320 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp31_ = _tmp30_;
#line 320 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		gtk_label_set_markup (_tmp26_, _tmp31_);
#line 320 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_free0 (_tmp31_);
#line 320 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_free0 (_tmp29_);
#line 322 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp32_ = self->priv->dark_score_label;
#line 322 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp33_ = _ ("%.2d");
#line 322 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp34_ = self->priv->game;
#line 322 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp35_ = game_get_n_dark_tiles (_tmp34_);
#line 322 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp36_ = _tmp35_;
#line 322 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp37_ = g_strdup_printf (_tmp33_, _tmp36_);
#line 322 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp38_ = _tmp37_;
#line 322 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp39_ = g_strconcat ("<span font_weight='bold'>", _tmp38_, NULL);
#line 322 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp40_ = _tmp39_;
#line 322 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp41_ = g_strconcat (_tmp40_, "</span>", NULL);
#line 322 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp42_ = _tmp41_;
#line 322 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		gtk_label_set_markup (_tmp32_, _tmp42_);
#line 322 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_free0 (_tmp42_);
#line 322 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_free0 (_tmp40_);
#line 322 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_free0 (_tmp38_);
#line 323 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp43_ = self->priv->light_score_label;
#line 323 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp44_ = _ ("%.2d");
#line 323 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp45_ = self->priv->game;
#line 323 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp46_ = game_get_n_light_tiles (_tmp45_);
#line 323 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp47_ = _tmp46_;
#line 323 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp48_ = g_strdup_printf (_tmp44_, _tmp47_);
#line 323 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp49_ = _tmp48_;
#line 323 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp50_ = g_strconcat ("<span font_weight='normal'>", _tmp49_, NULL);
#line 323 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp51_ = _tmp50_;
#line 323 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp52_ = g_strconcat (_tmp51_, "</span>", NULL);
#line 323 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp53_ = _tmp52_;
#line 323 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		gtk_label_set_markup (_tmp43_, _tmp53_);
#line 323 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_free0 (_tmp53_);
#line 323 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_free0 (_tmp51_);
#line 323 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_free0 (_tmp49_);
#line 1667 "iagno.c"
	} else {
		Game* _tmp54_ = NULL;
		Player _tmp55_ = 0;
		Player _tmp56_ = 0;
#line 325 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp54_ = self->priv->game;
#line 325 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp55_ = game_get_current_color (_tmp54_);
#line 325 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp56_ = _tmp55_;
#line 325 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		if (_tmp56_ == PLAYER_LIGHT) {
#line 1680 "iagno.c"
			GtkLabel* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
			gchar* _tmp59_ = NULL;
			gchar* _tmp60_ = NULL;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_ = NULL;
			GtkLabel* _tmp63_ = NULL;
			const gchar* _tmp64_ = NULL;
			gchar* _tmp65_ = NULL;
			gchar* _tmp66_ = NULL;
			gchar* _tmp67_ = NULL;
			gchar* _tmp68_ = NULL;
			GtkLabel* _tmp69_ = NULL;
			const gchar* _tmp70_ = NULL;
			Game* _tmp71_ = NULL;
			gint _tmp72_ = 0;
			gint _tmp73_ = 0;
			gchar* _tmp74_ = NULL;
			gchar* _tmp75_ = NULL;
			gchar* _tmp76_ = NULL;
			gchar* _tmp77_ = NULL;
			gchar* _tmp78_ = NULL;
			gchar* _tmp79_ = NULL;
			GtkLabel* _tmp80_ = NULL;
			const gchar* _tmp81_ = NULL;
			Game* _tmp82_ = NULL;
			gint _tmp83_ = 0;
			gint _tmp84_ = 0;
			gchar* _tmp85_ = NULL;
			gchar* _tmp86_ = NULL;
			gchar* _tmp87_ = NULL;
			gchar* _tmp88_ = NULL;
			gchar* _tmp89_ = NULL;
			gchar* _tmp90_ = NULL;
#line 327 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp57_ = self->priv->dark_label;
#line 327 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp58_ = _ ("Dark:");
#line 327 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp59_ = g_strconcat ("<span font_weight='normal'>", _tmp58_, NULL);
#line 327 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp60_ = _tmp59_;
#line 327 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp61_ = g_strconcat (_tmp60_, "</span>", NULL);
#line 327 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp62_ = _tmp61_;
#line 327 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			gtk_label_set_markup (_tmp57_, _tmp62_);
#line 327 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_free0 (_tmp62_);
#line 327 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_free0 (_tmp60_);
#line 328 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp63_ = self->priv->light_label;
#line 328 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp64_ = _ ("Light:");
#line 328 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp65_ = g_strconcat ("<span font_weight='bold'>", _tmp64_, NULL);
#line 328 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp66_ = _tmp65_;
#line 328 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp67_ = g_strconcat (_tmp66_, "</span>", NULL);
#line 328 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp68_ = _tmp67_;
#line 328 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			gtk_label_set_markup (_tmp63_, _tmp68_);
#line 328 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_free0 (_tmp68_);
#line 328 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_free0 (_tmp66_);
#line 330 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp69_ = self->priv->dark_score_label;
#line 330 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp70_ = _ ("%.2d");
#line 330 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp71_ = self->priv->game;
#line 330 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp72_ = game_get_n_dark_tiles (_tmp71_);
#line 330 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp73_ = _tmp72_;
#line 330 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp74_ = g_strdup_printf (_tmp70_, _tmp73_);
#line 330 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp75_ = _tmp74_;
#line 330 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp76_ = g_strconcat ("<span font_weight='normal'>", _tmp75_, NULL);
#line 330 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp77_ = _tmp76_;
#line 330 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp78_ = g_strconcat (_tmp77_, "</span>", NULL);
#line 330 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp79_ = _tmp78_;
#line 330 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			gtk_label_set_markup (_tmp69_, _tmp79_);
#line 330 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_free0 (_tmp79_);
#line 330 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_free0 (_tmp77_);
#line 330 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_free0 (_tmp75_);
#line 331 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp80_ = self->priv->light_score_label;
#line 331 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp81_ = _ ("%.2d");
#line 331 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp82_ = self->priv->game;
#line 331 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp83_ = game_get_n_light_tiles (_tmp82_);
#line 331 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp84_ = _tmp83_;
#line 331 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp85_ = g_strdup_printf (_tmp81_, _tmp84_);
#line 331 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp86_ = _tmp85_;
#line 331 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp87_ = g_strconcat ("<span font_weight='bold'>", _tmp86_, NULL);
#line 331 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp88_ = _tmp87_;
#line 331 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp89_ = g_strconcat (_tmp88_, "</span>", NULL);
#line 331 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp90_ = _tmp89_;
#line 331 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			gtk_label_set_markup (_tmp80_, _tmp90_);
#line 331 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_free0 (_tmp90_);
#line 331 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_free0 (_tmp88_);
#line 331 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_free0 (_tmp86_);
#line 1811 "iagno.c"
		}
	}
#line 304 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (new_game_action);
#line 304 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (undo_action);
#line 1818 "iagno.c"
}


static void iagno_undo_move_cb (Iagno* self) {
	ComputerPlayer* _tmp0_ = NULL;
#line 335 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 337 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_cancel_pending_computer_moves (self);
#line 339 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = self->priv->computer;
#line 339 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp0_ == NULL) {
#line 1832 "iagno.c"
		Game* _tmp1_ = NULL;
		Game* _tmp2_ = NULL;
		Game* _tmp3_ = NULL;
		Player _tmp4_ = 0;
		Player _tmp5_ = 0;
		gboolean _tmp6_ = FALSE;
#line 341 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp1_ = self->priv->game;
#line 341 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		game_undo (_tmp1_, 1);
#line 342 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp2_ = self->priv->game;
#line 342 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp3_ = self->priv->game;
#line 342 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp4_ = game_get_current_color (_tmp3_);
#line 342 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp5_ = _tmp4_;
#line 342 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp6_ = game_can_move (_tmp2_, _tmp5_);
#line 342 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		if (!_tmp6_) {
#line 1855 "iagno.c"
			Game* _tmp7_ = NULL;
#line 343 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp7_ = self->priv->game;
#line 343 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			game_undo (_tmp7_, 1);
#line 1861 "iagno.c"
		}
	} else {
		Game* _tmp8_ = NULL;
		Player _tmp9_ = 0;
		Player _tmp10_ = 0;
		Player _tmp11_ = 0;
#line 348 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp8_ = self->priv->game;
#line 348 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp9_ = game_get_current_color (_tmp8_);
#line 348 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp10_ = _tmp9_;
#line 348 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp11_ = self->priv->player_one;
#line 348 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		if (_tmp10_ != _tmp11_) {
#line 1878 "iagno.c"
			Game* _tmp12_ = NULL;
#line 349 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp12_ = self->priv->game;
#line 349 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			game_undo (_tmp12_, 1);
#line 1884 "iagno.c"
		} else {
			Game* _tmp13_ = NULL;
#line 351 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp13_ = self->priv->game;
#line 351 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			game_undo (_tmp13_, 2);
#line 1891 "iagno.c"
		}
#line 354 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		while (TRUE) {
#line 1895 "iagno.c"
			Game* _tmp14_ = NULL;
			Game* _tmp15_ = NULL;
			Player _tmp16_ = 0;
			Player _tmp17_ = 0;
			gboolean _tmp18_ = FALSE;
			Game* _tmp19_ = NULL;
#line 354 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp14_ = self->priv->game;
#line 354 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp15_ = self->priv->game;
#line 354 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp16_ = game_get_current_color (_tmp15_);
#line 354 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp17_ = _tmp16_;
#line 354 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp18_ = game_can_move (_tmp14_, _tmp17_);
#line 354 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			if (!(!_tmp18_)) {
#line 354 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				break;
#line 1916 "iagno.c"
			}
#line 355 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp19_ = self->priv->game;
#line 355 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			game_undo (_tmp19_, 2);
#line 1922 "iagno.c"
		}
	}
#line 358 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_game_move_cb (self);
#line 1927 "iagno.c"
}


static void iagno_about_cb (Iagno* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GtkWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 361 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 363 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = g_strdup ("Ian Peters");
#line 363 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = g_strdup ("Robert Ancell");
#line 363 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = g_new0 (gchar*, 3 + 1);
#line 363 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_[0] = _tmp0_;
#line 363 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_[1] = _tmp1_;
#line 363 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_[2] = NULL;
#line 363 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	authors = _tmp2_;
#line 363 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	authors_length1 = 3;
#line 363 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_authors_size_ = authors_length1;
#line 364 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp3_ = g_strdup ("Tiffany Antopolski");
#line 364 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp4_ = g_new0 (gchar*, 2 + 1);
#line 364 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp4_[0] = _tmp3_;
#line 364 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp4_[1] = NULL;
#line 364 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	documenters = _tmp4_;
#line 364 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	documenters_length1 = 2;
#line 364 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_documenters_size_ = documenters_length1;
#line 366 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp5_ = self->priv->window;
#line 366 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp6_ = _ ("Iagno");
#line 366 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp7_ = _ ("A disk flipping game derived from Reversi\n" \
"\n" \
"Iagno is a part of GNOME Games.");
#line 366 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp8_ = _ ("translator-credits");
#line 366 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_show_about_dialog (_tmp5_, "name", _tmp6_, "version", VERSION, "copyright", "Copyright © 1998–2008 Ian Peters\n" \
"Copyright © 2013–2014 Michael Catanzaro", "license-type", GTK_LICENSE_GPL_2_0, "comments", _tmp7_, "authors", authors, "documenters", documenters, "translator-credits", _tmp8_, "logo-icon-name", "iagno", "website", "https://wiki.gnome.org/Apps/Iagno", NULL, NULL);
#line 361 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
#line 361 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 1995 "iagno.c"
}


static void iagno_preferences_cb (Iagno* self) {
#line 381 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 383 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_show_preferences_dialog (self);
#line 2004 "iagno.c"
}


static void iagno_help_cb (Iagno* self) {
	GError * _inner_error_ = NULL;
#line 386 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 2012 "iagno.c"
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 390 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp0_ = self->priv->window;
#line 390 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp1_ = gtk_window_get_screen (_tmp0_);
#line 390 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 390 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		gtk_show_uri (_tmp1_, "help:iagno", _tmp2_, &_inner_error_);
#line 390 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		if (_inner_error_ != NULL) {
#line 2027 "iagno.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 388 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		e = _inner_error_;
#line 388 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_inner_error_ = NULL;
#line 394 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp3_ = e;
#line 394 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp4_ = _tmp3_->message;
#line 394 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_warning ("iagno.vala:394: Failed to show help: %s", _tmp4_);
#line 388 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_error_free0 (e);
#line 2049 "iagno.c"
	}
	__finally3:
#line 388 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_inner_error_ != NULL) {
#line 388 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 388 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_clear_error (&_inner_error_);
#line 388 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		return;
#line 2060 "iagno.c"
	}
}


static void iagno_game_move_cb (Iagno* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp13_ = FALSE;
	Game* _tmp14_ = NULL;
	Player _tmp15_ = 0;
	Player _tmp16_ = 0;
	Player _tmp17_ = 0;
#line 398 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 400 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_play_sound (self, "flip-piece");
#line 402 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 402 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = self->priv->game;
#line 402 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = game_get_current_color (_tmp1_);
#line 402 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp3_ = _tmp2_;
#line 402 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp4_ = game_can_move (_tmp0_, _tmp3_);
#line 402 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (!_tmp4_) {
#line 2092 "iagno.c"
		Game* _tmp5_ = NULL;
		Game* _tmp6_ = NULL;
		Player _tmp7_ = 0;
		Player _tmp8_ = 0;
#line 404 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp5_ = self->priv->game;
#line 404 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		game_pass (_tmp5_);
#line 405 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp6_ = self->priv->game;
#line 405 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp7_ = game_get_current_color (_tmp6_);
#line 405 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp8_ = _tmp7_;
#line 405 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		if (_tmp8_ == PLAYER_DARK) {
#line 2109 "iagno.c"
			GtkHeaderBar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
#line 408 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp9_ = self->priv->headerbar;
#line 408 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp10_ = _ ("Light must pass, Dark’s move");
#line 408 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			gtk_header_bar_set_subtitle (_tmp9_, _tmp10_);
#line 2118 "iagno.c"
		} else {
			GtkHeaderBar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
#line 413 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp11_ = self->priv->headerbar;
#line 413 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp12_ = _ ("Dark must pass, Light’s move");
#line 413 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			gtk_header_bar_set_subtitle (_tmp11_, _tmp12_);
#line 2128 "iagno.c"
		}
#line 415 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		return;
#line 2132 "iagno.c"
	}
#line 418 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 425 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp14_ = self->priv->game;
#line 425 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp15_ = game_get_current_color (_tmp14_);
#line 425 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp16_ = _tmp15_;
#line 425 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp17_ = self->priv->player_one;
#line 425 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp16_ != _tmp17_) {
#line 2146 "iagno.c"
		ComputerPlayer* _tmp18_ = NULL;
#line 425 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp18_ = self->priv->computer;
#line 425 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp13_ = _tmp18_ != NULL;
#line 2152 "iagno.c"
	} else {
#line 425 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp13_ = FALSE;
#line 2156 "iagno.c"
	}
#line 425 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp13_) {
#line 2160 "iagno.c"
		gboolean _tmp19_ = FALSE;
		Game* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
#line 427 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp20_ = self->priv->game;
#line 427 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp21_ = game_get_n_tiles (_tmp20_);
#line 427 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp22_ = _tmp21_;
#line 427 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		if (_tmp22_ == 63) {
#line 427 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp19_ = TRUE;
#line 2175 "iagno.c"
		} else {
			gboolean _tmp23_ = FALSE;
#line 427 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp23_ = iagno_fast_mode;
#line 427 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp19_ = _tmp23_;
#line 2182 "iagno.c"
		}
#line 427 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		if (_tmp19_) {
#line 2186 "iagno.c"
			guint _tmp24_ = 0U;
#line 428 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp24_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 400, _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 428 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			self->priv->computer_timer = _tmp24_;
#line 2192 "iagno.c"
		} else {
			guint _tmp25_ = 0U;
#line 430 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp25_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 430 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			self->priv->computer_timer = _tmp25_;
#line 2199 "iagno.c"
		}
	}
}


static gboolean iagno_computer_move_cb (Iagno* self) {
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Player _tmp1_ = 0;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
#line 434 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 436 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_cancel_pending_computer_moves (self);
#line 437 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 437 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = game_get_current_color (_tmp0_);
#line 437 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 437 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp3_ = self->priv->player_one;
#line 437 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp2_ != _tmp3_) {
#line 2225 "iagno.c"
		ComputerPlayer* _tmp4_ = NULL;
#line 438 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp4_ = self->priv->computer;
#line 438 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		computer_player_move (_tmp4_);
#line 2231 "iagno.c"
	}
#line 439 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	result = FALSE;
#line 439 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	return result;
#line 2237 "iagno.c"
}


static void iagno_cancel_pending_computer_moves (Iagno* self) {
	guint _tmp0_ = 0U;
#line 442 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 444 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = self->priv->computer_timer;
#line 444 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 2249 "iagno.c"
		guint _tmp1_ = 0U;
#line 446 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp1_ = self->priv->computer_timer;
#line 446 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_source_remove (_tmp1_);
#line 447 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		self->priv->computer_timer = (guint) 0;
#line 2257 "iagno.c"
	}
}


static void iagno_game_complete_cb (Iagno* self) {
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 451 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 453 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 455 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 455 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = game_get_n_light_tiles (_tmp0_);
#line 455 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 455 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp3_ = self->priv->game;
#line 455 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp4_ = game_get_n_dark_tiles (_tmp3_);
#line 455 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp5_ = _tmp4_;
#line 455 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp2_ > _tmp5_) {
#line 2287 "iagno.c"
		GtkHeaderBar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 458 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp6_ = self->priv->headerbar;
#line 458 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp7_ = _ ("Light wins!");
#line 458 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		gtk_header_bar_set_subtitle (_tmp6_, _tmp7_);
#line 2296 "iagno.c"
	} else {
		Game* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 460 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp8_ = self->priv->game;
#line 460 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp9_ = game_get_n_dark_tiles (_tmp8_);
#line 460 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp10_ = _tmp9_;
#line 460 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp11_ = self->priv->game;
#line 460 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp12_ = game_get_n_light_tiles (_tmp11_);
#line 460 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp13_ = _tmp12_;
#line 460 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		if (_tmp10_ > _tmp13_) {
#line 2318 "iagno.c"
			GtkHeaderBar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 463 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp14_ = self->priv->headerbar;
#line 463 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp15_ = _ ("Dark wins!");
#line 463 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			gtk_header_bar_set_subtitle (_tmp14_, _tmp15_);
#line 2327 "iagno.c"
		} else {
			Game* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			Game* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
#line 465 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp16_ = self->priv->game;
#line 465 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp17_ = game_get_n_light_tiles (_tmp16_);
#line 465 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp18_ = _tmp17_;
#line 465 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp19_ = self->priv->game;
#line 465 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp20_ = game_get_n_dark_tiles (_tmp19_);
#line 465 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp21_ = _tmp20_;
#line 465 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			if (_tmp18_ == _tmp21_) {
#line 2349 "iagno.c"
				GtkHeaderBar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
#line 468 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp22_ = self->priv->headerbar;
#line 468 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp23_ = _ ("The game is draw.");
#line 468 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				gtk_header_bar_set_subtitle (_tmp22_, _tmp23_);
#line 2358 "iagno.c"
			} else {
#line 470 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				g_assert_not_reached ();
#line 2362 "iagno.c"
			}
		}
	}
#line 472 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_play_sound (self, "gameover");
#line 2368 "iagno.c"
}


static void iagno_play_sound (Iagno* self, const gchar* name) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GameView* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 475 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 475 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (name != NULL);
#line 477 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 477 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
#line 477 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (!_tmp1_) {
#line 478 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		return;
#line 2394 "iagno.c"
	}
#line 480 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = self->priv->view;
#line 480 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp3_ = name;
#line 480 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp4_ = name;
#line 480 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp5_ = g_strdup_printf ("%s.ogg", _tmp4_);
#line 480 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp6_ = _tmp5_;
#line 480 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp7_ = g_build_filename (SOUND_DIRECTORY, _tmp6_, NULL);
#line 480 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp8_ = _tmp7_;
#line 480 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	ca_gtk_play_for_widget ((GtkWidget*) _tmp2_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp3_, CA_PROP_MEDIA_FILENAME, _tmp8_, NULL);
#line 480 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_free0 (_tmp8_);
#line 480 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_free0 (_tmp6_);
#line 2416 "iagno.c"
}


static void iagno_player_move_cb (Iagno* self, gint x, gint y) {
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Game* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
#line 485 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 488 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = self->priv->game;
#line 488 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = game_get_current_color (_tmp1_);
#line 488 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp3_ = _tmp2_;
#line 488 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp4_ = self->priv->player_one;
#line 488 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp3_ != _tmp4_) {
#line 2442 "iagno.c"
		ComputerPlayer* _tmp5_ = NULL;
#line 488 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp5_ = self->priv->computer;
#line 488 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp0_ = _tmp5_ != NULL;
#line 2448 "iagno.c"
	} else {
#line 488 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp0_ = FALSE;
#line 2452 "iagno.c"
	}
#line 488 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp0_) {
#line 489 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		return;
#line 2458 "iagno.c"
	}
#line 491 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp6_ = self->priv->game;
#line 491 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp7_ = x;
#line 491 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp8_ = y;
#line 491 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp9_ = game_place_tile (_tmp6_, _tmp7_, _tmp8_);
#line 491 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_tmp9_ == 0) {
#line 2470 "iagno.c"
		GtkHeaderBar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 494 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp10_ = self->priv->headerbar;
#line 494 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp11_ = _ ("You can’t move there!");
#line 494 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		gtk_header_bar_set_subtitle (_tmp10_, _tmp11_);
#line 2479 "iagno.c"
	}
}


static void iagno_computer_level_changed_cb (Iagno* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint level = 0;
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GSettings* _tmp6_ = NULL;
#line 498 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 498 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (combo != NULL);
#line 501 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = combo;
#line 501 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 501 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iter = _tmp1_;
#line 503 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = combo;
#line 503 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
#line 503 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 503 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp5_ = iter;
#line 503 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &level, -1);
#line 504 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp6_ = self->priv->settings;
#line 504 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_settings_set_int (_tmp6_, "computer-level", level);
#line 2518 "iagno.c"
}


static void iagno_mode_changed_cb (Iagno* self, GtkComboBox* combo, GtkComboBox* level_combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gchar* mode = NULL;
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GSettings* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	GtkComboBox* _tmp10_ = NULL;
#line 507 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 507 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (combo != NULL);
#line 507 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (level_combo != NULL);
#line 510 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = combo;
#line 510 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 510 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iter = _tmp1_;
#line 512 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = combo;
#line 512 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
#line 512 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 512 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp5_ = iter;
#line 512 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &mode, -1);
#line 513 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp6_ = self->priv->settings;
#line 513 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp7_ = mode;
#line 513 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_settings_set_string (_tmp6_, "play-as", _tmp7_);
#line 514 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp9_ = mode;
#line 514 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (g_strcmp0 (_tmp9_, "two-players") == 0) {
#line 514 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp8_ = FALSE;
#line 2570 "iagno.c"
	} else {
#line 514 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp8_ = TRUE;
#line 2574 "iagno.c"
	}
#line 514 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp10_ = level_combo;
#line 514 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, _tmp8_);
#line 507 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_free0 (mode);
#line 2582 "iagno.c"
}


static void iagno_sound_select (Iagno* self, GtkToggleButton* widget) {
	gboolean play_sounds = FALSE;
	GtkToggleButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_ = NULL;
#line 517 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 517 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (widget != NULL);
#line 519 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = widget;
#line 519 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
#line 519 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	play_sounds = _tmp1_;
#line 520 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = self->priv->settings;
#line 520 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_settings_set_boolean (_tmp2_, "sound", play_sounds);
#line 2605 "iagno.c"
}


static void iagno_propbox_response_cb (Iagno* self, GtkWidget* widget, gint response_id) {
	GtkWidget* _tmp0_ = NULL;
#line 523 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 523 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (widget != NULL);
#line 525 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = widget;
#line 525 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_hide (_tmp0_);
#line 2619 "iagno.c"
}


static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
#line 528 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 528 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 528 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 530 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = widget;
#line 530 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_hide (_tmp0_);
#line 531 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	result = TRUE;
#line 531 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	return result;
#line 2640 "iagno.c"
}


static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gchar* tile_set = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeIter _tmp7_ = {0};
	GSettings* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GameView* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GameView* _tmp14_ = NULL;
#line 534 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 534 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (widget != NULL);
#line 536 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = widget;
#line 536 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 536 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 536 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	model = _tmp2_;
#line 538 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp3_ = widget;
#line 538 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp5_ = gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
#line 538 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iter = _tmp4_;
#line 538 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (!_tmp5_) {
#line 539 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (model);
#line 539 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		return;
#line 2687 "iagno.c"
	}
#line 541 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp6_ = model;
#line 541 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp7_ = iter;
#line 541 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_tree_model_get (_tmp6_, &_tmp7_, 1, &tile_set, -1);
#line 542 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp8_ = self->priv->settings;
#line 542 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp9_ = tile_set;
#line 542 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_settings_set_string (_tmp8_, "tileset", _tmp9_);
#line 543 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp10_ = self->priv->view;
#line 543 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp11_ = tile_set;
#line 543 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp12_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp11_, NULL);
#line 543 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp13_ = _tmp12_;
#line 543 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	game_view_set_theme (_tmp10_, _tmp13_);
#line 543 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_free0 (_tmp13_);
#line 544 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp14_ = self->priv->view;
#line 544 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	game_view_redraw (_tmp14_);
#line 534 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_free0 (tile_set);
#line 534 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (model);
#line 2721 "iagno.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	return _data2_;
#line 2730 "iagno.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 2739 "iagno.c"
		Iagno* self;
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		self = _data2_->self;
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (_data2_->enable_sounds_button);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (_data2_->level_combo);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (_data2_->combo);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (self);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_slice_free (Block2Data, _data2_);
#line 2753 "iagno.c"
	}
}


static void _iagno_propbox_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 558 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_propbox_response_cb ((Iagno*) self, _sender, response_id);
#line 2761 "iagno.c"
}


static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = iagno_propbox_close_cb ((Iagno*) self, _sender, event);
#line 559 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	return result;
#line 2770 "iagno.c"
}


static void __lambda4_ (Block2Data* _data2_) {
	Iagno* self;
	GtkComboBox* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
#line 569 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self = _data2_->self;
#line 569 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = _data2_->combo;
#line 569 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = _data2_->level_combo;
#line 569 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_mode_changed_cb (self, _tmp0_, _tmp1_);
#line 2786 "iagno.c"
}


static void ___lambda4__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 569 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	__lambda4_ (self);
#line 2793 "iagno.c"
}


static void __lambda5_ (Block2Data* _data2_) {
	Iagno* self;
	gchar* mode = NULL;
	GSettings* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkComboBox* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	GtkComboBox* _tmp6_ = NULL;
#line 588 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self = _data2_->self;
#line 589 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 589 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = g_settings_get_string (_tmp0_, "play-as");
#line 589 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	mode = _tmp1_;
#line 590 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = _data2_->combo;
#line 590 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp3_ = mode;
#line 590 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_combo_box_set_active_id (_tmp2_, _tmp3_);
#line 591 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp5_ = mode;
#line 591 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (g_strcmp0 (_tmp5_, "two-players") == 0) {
#line 591 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp4_ = FALSE;
#line 2827 "iagno.c"
	} else {
#line 591 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp4_ = TRUE;
#line 2831 "iagno.c"
	}
#line 591 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp6_ = _data2_->level_combo;
#line 591 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, _tmp4_);
#line 588 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_free0 (mode);
#line 2839 "iagno.c"
}


static void ___lambda5__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 588 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	__lambda5_ (self);
#line 2846 "iagno.c"
}


static void _iagno_computer_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 602 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_computer_level_changed_cb ((Iagno*) self, _sender);
#line 2853 "iagno.c"
}


static void __lambda6_ (Block2Data* _data2_) {
	Iagno* self;
	GtkComboBox* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 614 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self = _data2_->self;
#line 615 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = _data2_->level_combo;
#line 615 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = self->priv->settings;
#line 615 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = g_settings_get_int (_tmp1_, "computer-level");
#line 615 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_combo_box_set_active (_tmp0_, _tmp2_ - 1);
#line 2872 "iagno.c"
}


static void ___lambda6__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 614 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	__lambda6_ (self);
#line 2879 "iagno.c"
}


static void _g_free0_ (gpointer var) {
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	var = (g_free (var), NULL);
#line 2886 "iagno.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_list_free (self);
#line 2895 "iagno.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1278 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1278 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1278 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 2908 "iagno.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2939 "iagno.c"
				goto __catch5_g_regex_error;
			}
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			return NULL;
#line 2948 "iagno.c"
		}
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2964 "iagno.c"
				goto __catch5_g_regex_error;
			}
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			return NULL;
#line 2975 "iagno.c"
		}
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 2989 "iagno.c"
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1283 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 3003 "iagno.c"
	}
	__finally5:
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		return NULL;
#line 3014 "iagno.c"
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 930 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 931 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 931 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 931 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 931 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 933 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 933 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 3040 "iagno.c"
		gchar* _tmp4_ = NULL;
#line 934 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 934 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 934 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 3048 "iagno.c"
	} else {
#line 936 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		result = -1;
#line 936 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 3054 "iagno.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1193 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1193 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1193 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1193 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1194 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1194 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 3078 "iagno.c"
		glong _tmp4_ = 0L;
#line 1195 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1195 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1195 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 3086 "iagno.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1197 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1197 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1197 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1197 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 3098 "iagno.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1204 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1206 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1206 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 3122 "iagno.c"
		glong _tmp2_ = 0L;
#line 1206 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1206 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 3128 "iagno.c"
	} else {
#line 1206 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 3132 "iagno.c"
	}
#line 1206 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 3136 "iagno.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1208 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1208 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1208 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1208 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 3148 "iagno.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1210 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1210 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1210 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 3158 "iagno.c"
	}
#line 1213 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1213 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 3164 "iagno.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1214 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1214 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1214 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1215 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1215 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 3178 "iagno.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1217 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1217 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1217 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 3188 "iagno.c"
	}
#line 1219 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1219 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 3194 "iagno.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1220 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1220 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1220 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 3203 "iagno.c"
	}
#line 1222 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1222 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1222 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1222 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1223 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1223 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1223 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1223 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1223 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 3223 "iagno.c"
}


static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 669 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_theme_changed_cb ((Iagno*) self, _sender);
#line 3230 "iagno.c"
}


static void __lambda7_ (Block2Data* _data2_) {
	Iagno* self;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 673 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self = _data2_->self;
#line 674 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 674 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
#line 674 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _data2_->enable_sounds_button, _tmp1_);
#line 3246 "iagno.c"
}


static void ___lambda7__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 673 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	__lambda7_ (self);
#line 3253 "iagno.c"
}


static void _iagno_sound_select_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
#line 677 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_sound_select ((Iagno*) self, _sender);
#line 3260 "iagno.c"
}


static void iagno_show_preferences_dialog (Iagno* self) {
	Block2Data* _data2_;
	GtkDialog* propbox = NULL;
	const gchar* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkBox* box = NULL;
	GtkDialog* _tmp4_ = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	GtkDialog* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkGrid* _tmp12_ = NULL;
	GtkGrid* _tmp13_ = NULL;
	GtkGrid* _tmp14_ = NULL;
	GtkBox* _tmp15_ = NULL;
	GtkGrid* _tmp16_ = NULL;
	GtkComboBox* _tmp17_ = NULL;
	GtkComboBox* _tmp18_ = NULL;
	GtkComboBox* _tmp19_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkGrid* _tmp24_ = NULL;
	GtkLabel* _tmp25_ = NULL;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp26_ = NULL;
	GtkComboBox* _tmp27_ = NULL;
	GtkCellRendererText* _tmp28_ = NULL;
	GtkComboBox* _tmp29_ = NULL;
	GtkCellRendererText* _tmp30_ = NULL;
	GtkListStore* model = NULL;
	GtkListStore* _tmp31_ = NULL;
	GtkComboBox* _tmp32_ = NULL;
	GtkListStore* _tmp33_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp34_ = NULL;
	GtkTreeIter _tmp35_ = {0};
	GtkListStore* _tmp36_ = NULL;
	GtkTreeIter _tmp37_ = {0};
	const gchar* _tmp38_ = NULL;
	GtkListStore* _tmp39_ = NULL;
	GtkTreeIter _tmp40_ = {0};
	GtkListStore* _tmp41_ = NULL;
	GtkTreeIter _tmp42_ = {0};
	const gchar* _tmp43_ = NULL;
	GtkListStore* _tmp44_ = NULL;
	GtkTreeIter _tmp45_ = {0};
	GtkListStore* _tmp46_ = NULL;
	GtkTreeIter _tmp47_ = {0};
	const gchar* _tmp48_ = NULL;
	GtkComboBox* _tmp49_ = NULL;
	GSettings* _tmp50_ = NULL;
	gchar* mode = NULL;
	GSettings* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	GtkComboBox* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	gboolean _tmp55_ = FALSE;
	const gchar* _tmp56_ = NULL;
	GtkComboBox* _tmp57_ = NULL;
	GtkGrid* _tmp58_ = NULL;
	GtkComboBox* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	GtkLabel* _tmp61_ = NULL;
	GtkLabel* _tmp62_ = NULL;
	GtkLabel* _tmp63_ = NULL;
	GtkGrid* _tmp64_ = NULL;
	GtkLabel* _tmp65_ = NULL;
	GtkComboBox* _tmp66_ = NULL;
	GtkCellRendererText* _tmp67_ = NULL;
	GtkComboBox* _tmp68_ = NULL;
	GtkCellRendererText* _tmp69_ = NULL;
	GtkComboBox* _tmp70_ = NULL;
	GtkCellRendererText* _tmp71_ = NULL;
	GtkListStore* _tmp72_ = NULL;
	GtkComboBox* _tmp73_ = NULL;
	GtkListStore* _tmp74_ = NULL;
	GtkListStore* _tmp75_ = NULL;
	GtkTreeIter _tmp76_ = {0};
	GtkListStore* _tmp77_ = NULL;
	GtkTreeIter _tmp78_ = {0};
	const gchar* _tmp79_ = NULL;
	GtkListStore* _tmp80_ = NULL;
	GtkTreeIter _tmp81_ = {0};
	GtkListStore* _tmp82_ = NULL;
	GtkTreeIter _tmp83_ = {0};
	const gchar* _tmp84_ = NULL;
	GtkListStore* _tmp85_ = NULL;
	GtkTreeIter _tmp86_ = {0};
	GtkListStore* _tmp87_ = NULL;
	GtkTreeIter _tmp88_ = {0};
	const gchar* _tmp89_ = NULL;
	GSettings* _tmp90_ = NULL;
	GtkComboBox* _tmp91_ = NULL;
	GSettings* _tmp92_ = NULL;
	gint _tmp93_ = 0;
	GtkGrid* _tmp94_ = NULL;
	GtkComboBox* _tmp95_ = NULL;
	const gchar* _tmp96_ = NULL;
	GtkLabel* _tmp97_ = NULL;
	GtkLabel* _tmp98_ = NULL;
	GtkLabel* _tmp99_ = NULL;
	GtkGrid* _tmp100_ = NULL;
	GtkLabel* _tmp101_ = NULL;
	GtkComboBox* theme_combo = NULL;
	GtkComboBox* _tmp102_ = NULL;
	GtkCellRendererText* _tmp103_ = NULL;
	GtkComboBox* _tmp104_ = NULL;
	GtkCellRendererText* _tmp105_ = NULL;
	GtkComboBox* _tmp106_ = NULL;
	GtkCellRendererText* _tmp107_ = NULL;
	GtkListStore* _tmp108_ = NULL;
	GtkComboBox* _tmp109_ = NULL;
	GtkListStore* _tmp110_ = NULL;
	GDir* dir = NULL;
	GList* dirlist = NULL;
	GList* _tmp126_ = NULL;
	GtkLabel* _tmp151_ = NULL;
	GtkComboBox* _tmp152_ = NULL;
	GtkComboBox* _tmp153_ = NULL;
	GtkGrid* _tmp154_ = NULL;
	GtkComboBox* _tmp155_ = NULL;
	const gchar* _tmp156_ = NULL;
	GtkCheckButton* _tmp157_ = NULL;
	GSettings* _tmp158_ = NULL;
	GSettings* _tmp159_ = NULL;
	gboolean _tmp160_ = FALSE;
	GtkGrid* _tmp161_ = NULL;
	GtkDialog* _tmp162_ = NULL;
	GError * _inner_error_ = NULL;
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_data2_->_ref_count_ = 1;
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_data2_->self = g_object_ref (self);
#line 549 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = _ ("Preferences");
#line 549 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = self->priv->window;
#line 549 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, _tmp1_, GTK_DIALOG_USE_HEADER_BAR, NULL, NULL);
#line 549 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp2_);
#line 549 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	propbox = _tmp2_;
#line 554 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp3_ = propbox;
#line 554 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp3_, (guint) 5);
#line 555 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp4_ = propbox;
#line 555 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp5_ = (GtkBox*) gtk_dialog_get_content_area (_tmp4_);
#line 555 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GTK_TYPE_BOX, GtkBox));
#line 555 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	box = _tmp6_;
#line 556 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp7_ = box;
#line 556 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_box_set_spacing (_tmp7_, 2);
#line 557 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp8_ = propbox;
#line 557 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_window_set_resizable ((GtkWindow*) _tmp8_, FALSE);
#line 558 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp9_ = propbox;
#line 558 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp9_, "response", (GCallback) _iagno_propbox_response_cb_gtk_dialog_response, self, 0);
#line 559 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp10_ = propbox;
#line 559 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_signal_connect_object ((GtkWidget*) _tmp10_, "delete-event", (GCallback) _iagno_propbox_close_cb_gtk_widget_delete_event, self, 0);
#line 561 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
#line 561 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp11_);
#line 561 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	grid = _tmp11_;
#line 562 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp12_ = grid;
#line 562 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp12_, (guint) 6);
#line 563 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp13_ = grid;
#line 563 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_grid_set_row_spacing (_tmp13_, (guint) 6);
#line 564 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp14_ = grid;
#line 564 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_grid_set_column_spacing (_tmp14_, (guint) 18);
#line 565 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp15_ = box;
#line 565 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp16_ = grid;
#line 565 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
#line 567 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp17_ = (GtkComboBox*) gtk_combo_box_new ();
#line 567 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp17_);
#line 567 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_data2_->combo = _tmp17_;
#line 568 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp18_ = (GtkComboBox*) gtk_combo_box_new ();
#line 568 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp18_);
#line 568 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_data2_->level_combo = _tmp18_;
#line 569 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp19_ = _data2_->combo;
#line 569 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_signal_connect_data (_tmp19_, "changed", (GCallback) ___lambda4__gtk_combo_box_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 571 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp20_ = _ ("Game mode:");
#line 571 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp21_ = (GtkLabel*) gtk_label_new (_tmp20_);
#line 571 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp21_);
#line 571 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	label = _tmp21_;
#line 572 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp22_ = label;
#line 572 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp22_, 0.0f, 0.5f);
#line 573 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp23_ = label;
#line 573 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_set ((GtkWidget*) _tmp23_, "expand", TRUE, NULL);
#line 574 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp24_ = grid;
#line 574 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp25_ = label;
#line 574 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 0, 0, 1, 1);
#line 575 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp26_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 575 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp26_);
#line 575 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	renderer = _tmp26_;
#line 576 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp27_ = _data2_->combo;
#line 576 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp28_ = renderer;
#line 576 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp27_, (GtkCellRenderer*) _tmp28_, TRUE);
#line 577 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp29_ = _data2_->combo;
#line 577 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp30_ = renderer;
#line 577 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp29_, (GtkCellRenderer*) _tmp30_, "text", 0);
#line 578 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp31_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
#line 578 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	model = _tmp31_;
#line 579 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp32_ = _data2_->combo;
#line 579 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp33_ = model;
#line 579 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_combo_box_set_model (_tmp32_, (GtkTreeModel*) _tmp33_);
#line 581 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp34_ = model;
#line 581 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_list_store_append (_tmp34_, &_tmp35_);
#line 581 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iter = _tmp35_;
#line 582 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp36_ = model;
#line 582 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp37_ = iter;
#line 582 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp38_ = _ ("Play first (Dark)");
#line 582 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_list_store_set (_tmp36_, &_tmp37_, 0, _tmp38_, 1, "first", -1);
#line 583 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp39_ = model;
#line 583 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_list_store_append (_tmp39_, &_tmp40_);
#line 583 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iter = _tmp40_;
#line 584 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp41_ = model;
#line 584 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp42_ = iter;
#line 584 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp43_ = _ ("Play second (Light)");
#line 584 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_list_store_set (_tmp41_, &_tmp42_, 0, _tmp43_, 1, "second", -1);
#line 585 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp44_ = model;
#line 585 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_list_store_append (_tmp44_, &_tmp45_);
#line 585 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iter = _tmp45_;
#line 586 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp46_ = model;
#line 586 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp47_ = iter;
#line 586 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp48_ = _ ("Two players");
#line 586 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_list_store_set (_tmp46_, &_tmp47_, 0, _tmp48_, 1, "two-players", -1);
#line 587 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp49_ = _data2_->combo;
#line 587 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_combo_box_set_id_column (_tmp49_, 1);
#line 588 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp50_ = self->priv->settings;
#line 588 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_signal_connect_data (_tmp50_, "changed::play-as", (GCallback) ___lambda5__g_settings_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 593 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp51_ = self->priv->settings;
#line 593 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp52_ = g_settings_get_string (_tmp51_, "play-as");
#line 593 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	mode = _tmp52_;
#line 594 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp53_ = _data2_->combo;
#line 594 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp54_ = mode;
#line 594 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_combo_box_set_active_id (_tmp53_, _tmp54_);
#line 595 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp56_ = mode;
#line 595 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (g_strcmp0 (_tmp56_, "two-players") == 0) {
#line 595 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp55_ = FALSE;
#line 3606 "iagno.c"
	} else {
#line 595 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp55_ = TRUE;
#line 3610 "iagno.c"
	}
#line 595 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp57_ = _data2_->level_combo;
#line 595 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp57_, _tmp55_);
#line 596 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp58_ = grid;
#line 596 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp59_ = _data2_->combo;
#line 596 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp58_, (GtkWidget*) _tmp59_, 1, 0, 1, 1);
#line 598 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp60_ = _ ("Computer:");
#line 598 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp61_ = (GtkLabel*) gtk_label_new (_tmp60_);
#line 598 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp61_);
#line 598 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (label);
#line 598 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	label = _tmp61_;
#line 599 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp62_ = label;
#line 599 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp62_, 0.0f, 0.5f);
#line 600 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp63_ = label;
#line 600 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_set ((GtkWidget*) _tmp63_, "expand", TRUE, NULL);
#line 601 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp64_ = grid;
#line 601 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp65_ = label;
#line 601 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp64_, (GtkWidget*) _tmp65_, 0, 1, 1, 1);
#line 602 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp66_ = _data2_->level_combo;
#line 602 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp66_, "changed", (GCallback) _iagno_computer_level_changed_cb_gtk_combo_box_changed, self, 0);
#line 603 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp67_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 603 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp67_);
#line 603 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (renderer);
#line 603 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	renderer = _tmp67_;
#line 604 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp68_ = _data2_->level_combo;
#line 604 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp69_ = renderer;
#line 604 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp68_, (GtkCellRenderer*) _tmp69_, TRUE);
#line 605 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp70_ = _data2_->level_combo;
#line 605 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp71_ = renderer;
#line 605 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp70_, (GtkCellRenderer*) _tmp71_, "text", 0);
#line 606 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp72_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
#line 606 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (model);
#line 606 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	model = _tmp72_;
#line 607 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp73_ = _data2_->level_combo;
#line 607 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp74_ = model;
#line 607 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_combo_box_set_model (_tmp73_, (GtkTreeModel*) _tmp74_);
#line 608 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp75_ = model;
#line 608 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_list_store_append (_tmp75_, &_tmp76_);
#line 608 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iter = _tmp76_;
#line 609 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp77_ = model;
#line 609 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp78_ = iter;
#line 609 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp79_ = _ ("Level one");
#line 609 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_list_store_set (_tmp77_, &_tmp78_, 0, _tmp79_, 1, 1, -1);
#line 610 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp80_ = model;
#line 610 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_list_store_append (_tmp80_, &_tmp81_);
#line 610 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iter = _tmp81_;
#line 611 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp82_ = model;
#line 611 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp83_ = iter;
#line 611 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp84_ = _ ("Level two");
#line 611 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_list_store_set (_tmp82_, &_tmp83_, 0, _tmp84_, 1, 2, -1);
#line 612 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp85_ = model;
#line 612 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_list_store_append (_tmp85_, &_tmp86_);
#line 612 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iter = _tmp86_;
#line 613 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp87_ = model;
#line 613 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp88_ = iter;
#line 613 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp89_ = _ ("Level three");
#line 613 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_list_store_set (_tmp87_, &_tmp88_, 0, _tmp89_, 1, 3, -1);
#line 614 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp90_ = self->priv->settings;
#line 614 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_signal_connect_data (_tmp90_, "changed::computer-level", (GCallback) ___lambda6__g_settings_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 617 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp91_ = _data2_->level_combo;
#line 617 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp92_ = self->priv->settings;
#line 617 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp93_ = g_settings_get_int (_tmp92_, "computer-level");
#line 617 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_combo_box_set_active (_tmp91_, _tmp93_ - 1);
#line 618 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp94_ = grid;
#line 618 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp95_ = _data2_->level_combo;
#line 618 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp94_, (GtkWidget*) _tmp95_, 1, 1, 1, 1);
#line 620 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp96_ = _ ("_Tile set:");
#line 620 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp97_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp96_);
#line 620 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp97_);
#line 620 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (label);
#line 620 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	label = _tmp97_;
#line 621 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp98_ = label;
#line 621 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp98_, 0.0f, 0.5f);
#line 622 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp99_ = label;
#line 622 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_set ((GtkWidget*) _tmp99_, "expand", TRUE, NULL);
#line 623 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp100_ = grid;
#line 623 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp101_ = label;
#line 623 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp100_, (GtkWidget*) _tmp101_, 0, 2, 1, 1);
#line 625 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp102_ = (GtkComboBox*) gtk_combo_box_new ();
#line 625 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp102_);
#line 625 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	theme_combo = _tmp102_;
#line 626 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp103_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 626 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp103_);
#line 626 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (renderer);
#line 626 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	renderer = _tmp103_;
#line 627 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp104_ = theme_combo;
#line 627 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp105_ = renderer;
#line 627 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp104_, (GtkCellRenderer*) _tmp105_, TRUE);
#line 628 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp106_ = theme_combo;
#line 628 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp107_ = renderer;
#line 628 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp106_, (GtkCellRenderer*) _tmp107_, "text", 0);
#line 629 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp108_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
#line 629 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (model);
#line 629 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	model = _tmp108_;
#line 630 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp109_ = theme_combo;
#line 630 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp110_ = model;
#line 630 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_combo_box_set_model (_tmp109_, (GtkTreeModel*) _tmp110_);
#line 632 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	dirlist = NULL;
#line 3806 "iagno.c"
	{
		GDir* _tmp111_ = NULL;
		gchar* _tmp112_ = NULL;
		gchar* _tmp113_ = NULL;
		GDir* _tmp114_ = NULL;
		GDir* _tmp115_ = NULL;
		GDir* _tmp116_ = NULL;
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp112_ = g_build_filename (DATA_DIRECTORY, "themes", NULL);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp113_ = _tmp112_;
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp114_ = g_dir_open (_tmp113_, (guint) 0, &_inner_error_);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp115_ = _tmp114_;
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_free0 (_tmp113_);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp111_ = _tmp115_;
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		if (_inner_error_ != NULL) {
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 3830 "iagno.c"
				goto __catch4_g_file_error;
			}
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			__g_list_free__g_free0_0 (dirlist);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_dir_close0 (dir);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_object_unref0 (theme_combo);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_free0 (mode);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_object_unref0 (model);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_object_unref0 (renderer);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_object_unref0 (label);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_object_unref0 (grid);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_object_unref0 (box);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_object_unref0 (propbox);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			block2_data_unref (_data2_);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_data2_ = NULL;
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			g_clear_error (&_inner_error_);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			return;
#line 3863 "iagno.c"
		}
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp116_ = _tmp111_;
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp111_ = NULL;
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_dir_close0 (dir);
#line 637 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		dir = _tmp116_;
#line 638 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		while (TRUE) {
#line 3875 "iagno.c"
			gchar* filename = NULL;
			GDir* _tmp117_ = NULL;
			const gchar* _tmp118_ = NULL;
			gchar* _tmp119_ = NULL;
			const gchar* _tmp120_ = NULL;
			const gchar* _tmp121_ = NULL;
			gchar* _tmp122_ = NULL;
			GCompareFunc _tmp123_ = NULL;
#line 640 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp117_ = dir;
#line 640 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp118_ = g_dir_read_name (_tmp117_);
#line 640 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp119_ = g_strdup (_tmp118_);
#line 640 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			filename = _tmp119_;
#line 641 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp120_ = filename;
#line 641 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			if (_tmp120_ == NULL) {
#line 642 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_g_free0 (filename);
#line 642 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				break;
#line 3900 "iagno.c"
			}
#line 643 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp121_ = filename;
#line 643 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp122_ = g_strdup (_tmp121_);
#line 643 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp123_ = g_strcmp0;
#line 643 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			dirlist = g_list_insert_sorted (dirlist, _tmp122_, _tmp123_);
#line 638 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_g_free0 (filename);
#line 3912 "iagno.c"
		}
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_dir_close0 (_tmp111_);
#line 3916 "iagno.c"
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp124_ = NULL;
		const gchar* _tmp125_ = NULL;
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		e = _inner_error_;
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_inner_error_ = NULL;
#line 648 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp124_ = e;
#line 648 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_tmp125_ = _tmp124_->message;
#line 648 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_warning ("iagno.vala:648: Failed to load themes: %s", _tmp125_);
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_error_free0 (e);
#line 3936 "iagno.c"
	}
	__finally4:
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	if (_inner_error_ != NULL) {
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		__g_list_free__g_free0_0 (dirlist);
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_dir_close0 (dir);
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (theme_combo);
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_free0 (mode);
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (model);
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (renderer);
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (label);
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (grid);
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (box);
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_g_object_unref0 (propbox);
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		block2_data_unref (_data2_);
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		_data2_ = NULL;
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		g_clear_error (&_inner_error_);
#line 635 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		return;
#line 3971 "iagno.c"
	}
#line 651 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp126_ = dirlist;
#line 3975 "iagno.c"
	{
		GList* filename_collection = NULL;
		GList* filename_it = NULL;
#line 651 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		filename_collection = _tmp126_;
#line 651 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
		for (filename_it = filename_collection; filename_it != NULL; filename_it = filename_it->next) {
#line 3983 "iagno.c"
			gchar* _tmp127_ = NULL;
			gchar* filename = NULL;
#line 651 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			_tmp127_ = g_strdup ((const gchar*) filename_it->data);
#line 651 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
			filename = _tmp127_;
#line 3990 "iagno.c"
			{
				GtkListStore* _tmp128_ = NULL;
				GtkTreeIter _tmp129_ = {0};
				gchar* label_text = NULL;
				const gchar* _tmp130_ = NULL;
				gchar* _tmp131_ = NULL;
				const gchar* _tmp132_ = NULL;
				gchar* _tmp133_ = NULL;
				gint extension_index = 0;
				const gchar* _tmp134_ = NULL;
				gint _tmp135_ = 0;
				gint _tmp136_ = 0;
				GtkListStore* _tmp140_ = NULL;
				GtkTreeIter _tmp141_ = {0};
				const gchar* _tmp142_ = NULL;
				const gchar* _tmp143_ = NULL;
				const gchar* _tmp144_ = NULL;
				GSettings* _tmp145_ = NULL;
				gchar* _tmp146_ = NULL;
				gchar* _tmp147_ = NULL;
				gboolean _tmp148_ = FALSE;
#line 653 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp128_ = model;
#line 653 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				gtk_list_store_append (_tmp128_, &_tmp129_);
#line 653 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				iter = _tmp129_;
#line 656 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp130_ = filename;
#line 656 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp131_ = g_strdup (_tmp130_);
#line 656 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				label_text = _tmp131_;
#line 658 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp132_ = label_text;
#line 658 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp133_ = string_replace (_tmp132_, "_", " ");
#line 658 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_g_free0 (label_text);
#line 658 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				label_text = _tmp133_;
#line 659 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp134_ = label_text;
#line 659 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp135_ = string_last_index_of_char (_tmp134_, (gunichar) '.', 0);
#line 659 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				extension_index = _tmp135_;
#line 660 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp136_ = extension_index;
#line 660 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				if (_tmp136_ > 0) {
#line 4042 "iagno.c"
					const gchar* _tmp137_ = NULL;
					gint _tmp138_ = 0;
					gchar* _tmp139_ = NULL;
#line 661 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
					_tmp137_ = label_text;
#line 661 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
					_tmp138_ = extension_index;
#line 661 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
					_tmp139_ = string_substring (_tmp137_, (glong) 0, (glong) _tmp138_);
#line 661 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
					_g_free0 (label_text);
#line 661 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
					label_text = _tmp139_;
#line 4056 "iagno.c"
				}
#line 663 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp140_ = model;
#line 663 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp141_ = iter;
#line 663 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp142_ = label_text;
#line 663 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp143_ = filename;
#line 663 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				gtk_list_store_set (_tmp140_, &_tmp141_, 0, _tmp142_, 1, _tmp143_, -1);
#line 664 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp144_ = filename;
#line 664 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp145_ = self->priv->settings;
#line 664 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp146_ = g_settings_get_string (_tmp145_, "tileset");
#line 664 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp147_ = _tmp146_;
#line 664 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_tmp148_ = g_strcmp0 (_tmp144_, _tmp147_) == 0;
#line 664 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_g_free0 (_tmp147_);
#line 664 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				if (_tmp148_) {
#line 4082 "iagno.c"
					GtkComboBox* _tmp149_ = NULL;
					GtkTreeIter _tmp150_ = {0};
#line 665 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
					_tmp149_ = theme_combo;
#line 665 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
					_tmp150_ = iter;
#line 665 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
					gtk_combo_box_set_active_iter (_tmp149_, &_tmp150_);
#line 4091 "iagno.c"
				}
#line 651 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_g_free0 (label_text);
#line 651 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
				_g_free0 (filename);
#line 4097 "iagno.c"
			}
		}
	}
#line 668 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp151_ = label;
#line 668 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp152_ = theme_combo;
#line 668 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_label_set_mnemonic_widget (_tmp151_, (GtkWidget*) _tmp152_);
#line 669 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp153_ = theme_combo;
#line 669 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp153_, "changed", (GCallback) _iagno_theme_changed_cb_gtk_combo_box_changed, self, 0);
#line 670 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp154_ = grid;
#line 670 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp155_ = theme_combo;
#line 670 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp154_, (GtkWidget*) _tmp155_, 1, 2, 1, 1);
#line 672 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp156_ = _ ("E_nable sounds");
#line 672 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp157_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp156_);
#line 672 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp157_);
#line 672 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_data2_->enable_sounds_button = _tmp157_;
#line 673 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp158_ = self->priv->settings;
#line 673 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_signal_connect_data (_tmp158_, "changed::sound", (GCallback) ___lambda7__g_settings_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 676 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp159_ = self->priv->settings;
#line 676 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp160_ = g_settings_get_boolean (_tmp159_, "sound");
#line 676 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _data2_->enable_sounds_button, _tmp160_);
#line 677 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_signal_connect_object ((GtkToggleButton*) _data2_->enable_sounds_button, "toggled", (GCallback) _iagno_sound_select_gtk_toggle_button_toggled, self, 0);
#line 678 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp161_ = grid;
#line 678 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp161_, (GtkWidget*) _data2_->enable_sounds_button, 0, 3, 2, 1);
#line 680 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp162_ = propbox;
#line 680 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp162_);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	__g_list_free__g_free0_0 (dirlist);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_dir_close0 (dir);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (theme_combo);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_free0 (mode);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (model);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (renderer);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (label);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (grid);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (box);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (propbox);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	block2_data_unref (_data2_);
#line 547 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_data2_ = NULL;
#line 4169 "iagno.c"
}


gint iagno_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	Iagno* app = NULL;
	Iagno* _tmp1_ = NULL;
	gint _result_ = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
#line 685 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	setlocale (LC_ALL, "");
#line 686 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 687 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 688 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	textdomain (GETTEXT_PACKAGE);
#line 690 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp0_ = _ ("Iagno");
#line 690 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_set_application_name (_tmp0_);
#line 692 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	gtk_window_set_default_icon_name ("iagno");
#line 694 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp1_ = iagno_new ();
#line 694 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	app = _tmp1_;
#line 696 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2_ = args;
#line 696 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp2__length1 = args_length1;
#line 696 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_tmp3_ = g_application_run ((GApplication*) app, _tmp2__length1, _tmp2_);
#line 696 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_result_ = _tmp3_;
#line 698 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	result = _result_;
#line 698 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (app);
#line 698 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	return result;
#line 4214 "iagno.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 683 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	return iagno_main (argv, argc);
#line 4224 "iagno.c"
}


static void iagno_class_init (IagnoClass * klass) {
#line 12 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	iagno_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	g_type_class_add_private (klass, sizeof (IagnoPrivate));
#line 12 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (klass)->startup = iagno_real_startup;
#line 12 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (klass)->activate = iagno_real_activate;
#line 12 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (klass)->handle_local_options = iagno_real_handle_local_options;
#line 12 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (klass)->shutdown = iagno_real_shutdown;
#line 12 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	G_OBJECT_CLASS (klass)->finalize = iagno_finalize;
#line 4243 "iagno.c"
}


static void iagno_instance_init (Iagno * self) {
#line 12 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self->priv = IAGNO_GET_PRIVATE (self);
#line 33 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self->priv->computer = NULL;
#line 39 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self->priv->computer_timer = (guint) 0;
#line 42 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self->priv->game = NULL;
#line 4256 "iagno.c"
}


static void iagno_finalize (GObject* obj) {
	Iagno * self;
#line 12 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IAGNO, Iagno);
#line 15 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->settings);
#line 22 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->window);
#line 25 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 26 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->view);
#line 27 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_label);
#line 28 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_score_label);
#line 29 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_label);
#line 30 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_score_label);
#line 33 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->computer);
#line 42 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->game);
#line 12 "/home/manhattan/checkout/gnome/iagno/src/iagno.vala"
	G_OBJECT_CLASS (iagno_parent_class)->finalize (obj);
#line 4286 "iagno.c"
}


GType iagno_get_type (void) {
	static volatile gsize iagno_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Iagno), 0, (GInstanceInitFunc) iagno_instance_init, NULL };
		GType iagno_type_id;
		iagno_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Iagno", &g_define_type_info, 0);
		g_once_init_leave (&iagno_type_id__volatile, iagno_type_id);
	}
	return iagno_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



