/* led-array.c generated by valac 0.23.3.20-47868, the Vala compiler
 * generated from led-array.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <cairo.h>
#include <float.h>
#include <math.h>


#define TYPE_LED_DIGIT (led_digit_get_type ())
#define LED_DIGIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LED_DIGIT, LEDDigit))
#define LED_DIGIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LED_DIGIT, LEDDigitClass))
#define IS_LED_DIGIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LED_DIGIT))
#define IS_LED_DIGIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LED_DIGIT))
#define LED_DIGIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LED_DIGIT, LEDDigitClass))

typedef struct _LEDDigit LEDDigit;
typedef struct _LEDDigitClass LEDDigitClass;
typedef struct _LEDDigitPrivate LEDDigitPrivate;

#define TYPE_LED_ARRAY (led_array_get_type ())
#define LED_ARRAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LED_ARRAY, LEDArray))
#define LED_ARRAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LED_ARRAY, LEDArrayClass))
#define IS_LED_ARRAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LED_ARRAY))
#define IS_LED_ARRAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LED_ARRAY))
#define LED_ARRAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LED_ARRAY, LEDArrayClass))

typedef struct _LEDArray LEDArray;
typedef struct _LEDArrayClass LEDArrayClass;
typedef struct _LEDArrayPrivate LEDArrayPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _LEDDigit {
	ClutterCairoTexture parent_instance;
	LEDDigitPrivate * priv;
};

struct _LEDDigitClass {
	ClutterCairoTextureClass parent_class;
};

struct _LEDDigitPrivate {
	gint _value;
};

struct _LEDArray {
	ClutterGroup parent_instance;
	LEDArrayPrivate * priv;
};

struct _LEDArrayClass {
	ClutterGroupClass parent_class;
};

struct _LEDArrayPrivate {
	GList* digits;
	ClutterActor* back;
	gint _value;
};


static gpointer led_digit_parent_class = NULL;
static gpointer led_array_parent_class = NULL;

GType led_digit_get_type (void) G_GNUC_CONST;
#define LED_DIGIT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LED_DIGIT, LEDDigitPrivate))
enum  {
	LED_DIGIT_DUMMY_PROPERTY,
	LED_DIGIT_VALUE
};
#define LED_DIGIT_scale 23
LEDDigit* led_digit_new (void);
LEDDigit* led_digit_construct (GType object_type);
static gboolean led_digit_real_draw (ClutterCairoTexture* base, cairo_t* cr);
gint led_digit_get_value (LEDDigit* self);
static void led_digit_draw_segment (LEDDigit* self, cairo_t* cr, gdouble x, gdouble y, gboolean is_vertical, gboolean is_lit);
void led_digit_set_value (LEDDigit* self, gint value);
static void led_digit_finalize (GObject* obj);
static void _vala_led_digit_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_led_digit_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType led_array_get_type (void) G_GNUC_CONST;
#define LED_ARRAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LED_ARRAY, LEDArrayPrivate))
enum  {
	LED_ARRAY_DUMMY_PROPERTY,
	LED_ARRAY_VALUE
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
LEDArray* led_array_new (gint n_digits, ClutterActor* back_texture);
LEDArray* led_array_construct (GType object_type, gint n_digits, ClutterActor* back_texture);
gint led_array_get_value (LEDArray* self);
void led_array_set_value (LEDArray* self, gint value);
static void led_array_finalize (GObject* obj);
static void _vala_led_array_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_led_array_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gboolean LED_DIGIT_segment_states[70] = {TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, TRUE, FALSE, TRUE, TRUE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, TRUE, TRUE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, TRUE, TRUE, TRUE};

LEDDigit* led_digit_construct (GType object_type) {
	LEDDigit * self = NULL;
	self = (LEDDigit*) g_object_new (object_type, NULL);
	clutter_cairo_texture_set_surface_size ((ClutterCairoTexture*) self, (guint) 37, (guint) 65);
	clutter_cairo_texture_invalidate ((ClutterCairoTexture*) self);
	return self;
}


LEDDigit* led_digit_new (void) {
	return led_digit_construct (TYPE_LED_DIGIT);
}


static gboolean led_digit_real_draw (ClutterCairoTexture* base, cairo_t* cr) {
	LEDDigit * self;
	gboolean result = FALSE;
	cairo_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	gint thickness = 0;
	gint pointy = 0;
	gdouble margin = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble side = 0.0;
	gint offset = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	cairo_t* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	cairo_t* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	cairo_t* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	cairo_t* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	cairo_t* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	cairo_t* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	cairo_t* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	self = (LEDDigit*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = cr;
	cairo_set_operator (_tmp0_, CAIRO_OPERATOR_CLEAR);
	_tmp1_ = cr;
	cairo_paint (_tmp1_);
	_tmp2_ = cr;
	cairo_set_operator (_tmp2_, CAIRO_OPERATOR_OVER);
	thickness = LED_DIGIT_scale / 3;
	pointy = thickness / 2;
	_tmp3_ = log ((gdouble) LED_DIGIT_scale);
	_tmp4_ = floor (_tmp3_);
	margin = _tmp4_;
	side = pointy + margin;
	_tmp5_ = led_digit_get_value (self);
	_tmp6_ = _tmp5_;
	offset = _tmp6_ * 7;
	_tmp7_ = cr;
	_tmp8_ = LED_DIGIT_segment_states[offset];
	led_digit_draw_segment (self, _tmp7_, side, (gdouble) 0, FALSE, _tmp8_);
	_tmp9_ = cr;
	_tmp10_ = LED_DIGIT_segment_states[offset + 1];
	led_digit_draw_segment (self, _tmp9_, (gdouble) 0, side, TRUE, _tmp10_);
	_tmp11_ = cr;
	_tmp12_ = LED_DIGIT_segment_states[offset + 2];
	led_digit_draw_segment (self, _tmp11_, (gdouble) 0, (side + LED_DIGIT_scale) + (margin * 2), TRUE, _tmp12_);
	_tmp13_ = cr;
	_tmp14_ = LED_DIGIT_segment_states[offset + 3];
	led_digit_draw_segment (self, _tmp13_, side, (2 * LED_DIGIT_scale) + (4 * margin), FALSE, _tmp14_);
	_tmp15_ = cr;
	_tmp16_ = LED_DIGIT_segment_states[offset + 4];
	led_digit_draw_segment (self, _tmp15_, LED_DIGIT_scale + (2 * margin), (side + LED_DIGIT_scale) + (margin * 2), TRUE, _tmp16_);
	_tmp17_ = cr;
	_tmp18_ = LED_DIGIT_segment_states[offset + 5];
	led_digit_draw_segment (self, _tmp17_, side, LED_DIGIT_scale + (2 * margin), FALSE, _tmp18_);
	_tmp19_ = cr;
	_tmp20_ = LED_DIGIT_segment_states[offset + 6];
	led_digit_draw_segment (self, _tmp19_, LED_DIGIT_scale + (2 * margin), side, TRUE, _tmp20_);
	result = FALSE;
	return result;
}


static void led_digit_draw_segment (LEDDigit* self, cairo_t* cr, gdouble x, gdouble y, gboolean is_vertical, gboolean is_lit) {
	gboolean _tmp0_ = FALSE;
	cairo_t* _tmp3_ = NULL;
	gint thickness = 0;
	gint pointy = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	cairo_t* _tmp58_ = NULL;
	cairo_t* _tmp59_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = is_lit;
	if (_tmp0_) {
		cairo_t* _tmp1_ = NULL;
		_tmp1_ = cr;
		cairo_set_source_rgba (_tmp1_, 0.145, 0.541, (gdouble) 1, (gdouble) 1);
	} else {
		cairo_t* _tmp2_ = NULL;
		_tmp2_ = cr;
		cairo_set_source_rgba (_tmp2_, 0.2, 0.2, 0.2, (gdouble) 1);
	}
	_tmp3_ = cr;
	cairo_new_path (_tmp3_);
	thickness = LED_DIGIT_scale / 3;
	_tmp4_ = thickness;
	pointy = _tmp4_ / 2;
	_tmp5_ = is_vertical;
	if (_tmp5_) {
		cairo_t* _tmp6_ = NULL;
		gdouble _tmp7_ = 0.0;
		gint _tmp8_ = 0;
		gdouble _tmp9_ = 0.0;
		cairo_t* _tmp10_ = NULL;
		gdouble _tmp11_ = 0.0;
		gdouble _tmp12_ = 0.0;
		gint _tmp13_ = 0;
		cairo_t* _tmp14_ = NULL;
		gdouble _tmp15_ = 0.0;
		gdouble _tmp16_ = 0.0;
		gint _tmp17_ = 0;
		cairo_t* _tmp18_ = NULL;
		gdouble _tmp19_ = 0.0;
		gint _tmp20_ = 0;
		gdouble _tmp21_ = 0.0;
		cairo_t* _tmp22_ = NULL;
		gdouble _tmp23_ = 0.0;
		gint _tmp24_ = 0;
		gdouble _tmp25_ = 0.0;
		gint _tmp26_ = 0;
		cairo_t* _tmp27_ = NULL;
		gdouble _tmp28_ = 0.0;
		gint _tmp29_ = 0;
		gdouble _tmp30_ = 0.0;
		gint _tmp31_ = 0;
		_tmp6_ = cr;
		_tmp7_ = x;
		_tmp8_ = thickness;
		_tmp9_ = y;
		cairo_move_to (_tmp6_, _tmp7_ + (_tmp8_ / 2), _tmp9_ + 0);
		_tmp10_ = cr;
		_tmp11_ = x;
		_tmp12_ = y;
		_tmp13_ = pointy;
		cairo_line_to (_tmp10_, _tmp11_ + 0, _tmp12_ + _tmp13_);
		_tmp14_ = cr;
		_tmp15_ = x;
		_tmp16_ = y;
		_tmp17_ = pointy;
		cairo_line_to (_tmp14_, _tmp15_ + 0, (_tmp16_ + LED_DIGIT_scale) - _tmp17_);
		_tmp18_ = cr;
		_tmp19_ = x;
		_tmp20_ = thickness;
		_tmp21_ = y;
		cairo_line_to (_tmp18_, _tmp19_ + (_tmp20_ / 2), _tmp21_ + LED_DIGIT_scale);
		_tmp22_ = cr;
		_tmp23_ = x;
		_tmp24_ = thickness;
		_tmp25_ = y;
		_tmp26_ = pointy;
		cairo_line_to (_tmp22_, _tmp23_ + _tmp24_, (_tmp25_ + LED_DIGIT_scale) - _tmp26_);
		_tmp27_ = cr;
		_tmp28_ = x;
		_tmp29_ = thickness;
		_tmp30_ = y;
		_tmp31_ = pointy;
		cairo_line_to (_tmp27_, _tmp28_ + _tmp29_, _tmp30_ + _tmp31_);
	} else {
		cairo_t* _tmp32_ = NULL;
		gdouble _tmp33_ = 0.0;
		gdouble _tmp34_ = 0.0;
		gint _tmp35_ = 0;
		cairo_t* _tmp36_ = NULL;
		gdouble _tmp37_ = 0.0;
		gint _tmp38_ = 0;
		gdouble _tmp39_ = 0.0;
		cairo_t* _tmp40_ = NULL;
		gdouble _tmp41_ = 0.0;
		gint _tmp42_ = 0;
		gdouble _tmp43_ = 0.0;
		cairo_t* _tmp44_ = NULL;
		gdouble _tmp45_ = 0.0;
		gdouble _tmp46_ = 0.0;
		gint _tmp47_ = 0;
		cairo_t* _tmp48_ = NULL;
		gdouble _tmp49_ = 0.0;
		gint _tmp50_ = 0;
		gdouble _tmp51_ = 0.0;
		gint _tmp52_ = 0;
		cairo_t* _tmp53_ = NULL;
		gdouble _tmp54_ = 0.0;
		gint _tmp55_ = 0;
		gdouble _tmp56_ = 0.0;
		gint _tmp57_ = 0;
		_tmp32_ = cr;
		_tmp33_ = x;
		_tmp34_ = y;
		_tmp35_ = thickness;
		cairo_move_to (_tmp32_, _tmp33_ + 0, _tmp34_ + (_tmp35_ / 2));
		_tmp36_ = cr;
		_tmp37_ = x;
		_tmp38_ = pointy;
		_tmp39_ = y;
		cairo_line_to (_tmp36_, _tmp37_ + _tmp38_, _tmp39_ + 0);
		_tmp40_ = cr;
		_tmp41_ = x;
		_tmp42_ = pointy;
		_tmp43_ = y;
		cairo_line_to (_tmp40_, (_tmp41_ + LED_DIGIT_scale) - _tmp42_, _tmp43_ + 0);
		_tmp44_ = cr;
		_tmp45_ = x;
		_tmp46_ = y;
		_tmp47_ = thickness;
		cairo_line_to (_tmp44_, _tmp45_ + LED_DIGIT_scale, _tmp46_ + (_tmp47_ / 2));
		_tmp48_ = cr;
		_tmp49_ = x;
		_tmp50_ = pointy;
		_tmp51_ = y;
		_tmp52_ = thickness;
		cairo_line_to (_tmp48_, (_tmp49_ + LED_DIGIT_scale) - _tmp50_, _tmp51_ + _tmp52_);
		_tmp53_ = cr;
		_tmp54_ = x;
		_tmp55_ = pointy;
		_tmp56_ = y;
		_tmp57_ = thickness;
		cairo_line_to (_tmp53_, _tmp54_ + _tmp55_, _tmp56_ + _tmp57_);
	}
	_tmp58_ = cr;
	cairo_close_path (_tmp58_);
	_tmp59_ = cr;
	cairo_fill (_tmp59_);
}


gint led_digit_get_value (LEDDigit* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}


void led_digit_set_value (LEDDigit* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_value = _tmp0_;
	clutter_cairo_texture_invalidate ((ClutterCairoTexture*) self);
	g_object_notify ((GObject *) self, "value");
}


static void led_digit_class_init (LEDDigitClass * klass) {
	led_digit_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LEDDigitPrivate));
	CLUTTER_CAIRO_TEXTURE_CLASS (klass)->draw = led_digit_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_led_digit_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_led_digit_set_property;
	G_OBJECT_CLASS (klass)->finalize = led_digit_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LED_DIGIT_VALUE, g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void led_digit_instance_init (LEDDigit * self) {
	self->priv = LED_DIGIT_GET_PRIVATE (self);
	self->priv->_value = 0;
}


static void led_digit_finalize (GObject* obj) {
	LEDDigit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LED_DIGIT, LEDDigit);
	G_OBJECT_CLASS (led_digit_parent_class)->finalize (obj);
}


GType led_digit_get_type (void) {
	static volatile gsize led_digit_type_id__volatile = 0;
	if (g_once_init_enter (&led_digit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LEDDigitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) led_digit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LEDDigit), 0, (GInstanceInitFunc) led_digit_instance_init, NULL };
		GType led_digit_type_id;
		led_digit_type_id = g_type_register_static (clutter_cairo_texture_get_type (), "LEDDigit", &g_define_type_info, 0);
		g_once_init_leave (&led_digit_type_id__volatile, led_digit_type_id);
	}
	return led_digit_type_id__volatile;
}


static void _vala_led_digit_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	LEDDigit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LED_DIGIT, LEDDigit);
	switch (property_id) {
		case LED_DIGIT_VALUE:
		g_value_set_int (value, led_digit_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_led_digit_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	LEDDigit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LED_DIGIT, LEDDigit);
	switch (property_id) {
		case LED_DIGIT_VALUE:
		led_digit_set_value (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


LEDArray* led_array_construct (GType object_type, gint n_digits, ClutterActor* back_texture) {
	LEDArray * self = NULL;
	gint margin = 0;
	gint inner_x_margin = 0;
	gint inner_y_margin = 0;
	ClutterActor* _tmp0_ = NULL;
	ClutterClone* _tmp1_ = NULL;
	ClutterActor* _tmp2_ = NULL;
	g_return_val_if_fail (back_texture != NULL, NULL);
	self = (LEDArray*) g_object_new (object_type, NULL);
	margin = 4;
	inner_x_margin = 10;
	inner_y_margin = -1;
	_tmp0_ = back_texture;
	_tmp1_ = (ClutterClone*) clutter_clone_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->back);
	self->priv->back = (ClutterActor*) _tmp1_;
	_tmp2_ = self->priv->back;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp2_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				LEDDigit* d = NULL;
				LEDDigit* _tmp7_ = NULL;
				LEDDigit* _tmp8_ = NULL;
				LEDDigit* _tmp9_ = NULL;
				gfloat _tmp10_ = 0.0F;
				gfloat _tmp11_ = 0.0F;
				LEDDigit* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				LEDDigit* _tmp14_ = NULL;
				gfloat _tmp15_ = 0.0F;
				gfloat _tmp16_ = 0.0F;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				LEDDigit* _tmp19_ = NULL;
				ClutterActor* _tmp20_ = NULL;
				gfloat _tmp21_ = 0.0F;
				gfloat _tmp22_ = 0.0F;
				gint _tmp23_ = 0;
				LEDDigit* _tmp24_ = NULL;
				LEDDigit* _tmp25_ = NULL;
				LEDDigit* _tmp26_ = NULL;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = n_digits;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = led_digit_new ();
				g_object_ref_sink (_tmp7_);
				d = _tmp7_;
				_tmp8_ = d;
				_tmp9_ = d;
				_tmp10_ = clutter_actor_get_height ((ClutterActor*) _tmp9_);
				_tmp11_ = _tmp10_;
				clutter_actor_set_anchor_point ((ClutterActor*) _tmp8_, (gfloat) 0, _tmp11_ / 2);
				_tmp12_ = d;
				_tmp13_ = i;
				_tmp14_ = d;
				_tmp15_ = clutter_actor_get_width ((ClutterActor*) _tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = margin;
				_tmp18_ = inner_x_margin;
				clutter_actor_set_x ((ClutterActor*) _tmp12_, (_tmp13_ * (_tmp16_ + _tmp17_)) + _tmp18_);
				_tmp19_ = d;
				_tmp20_ = self->priv->back;
				_tmp21_ = clutter_actor_get_height (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = inner_y_margin;
				clutter_actor_set_y ((ClutterActor*) _tmp19_, (_tmp22_ / 2) + _tmp23_);
				_tmp24_ = d;
				clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp24_);
				_tmp25_ = d;
				_tmp26_ = _g_object_ref0 (_tmp25_);
				self->priv->digits = g_list_prepend (self->priv->digits, _tmp26_);
				_g_object_unref0 (d);
			}
		}
	}
	return self;
}


LEDArray* led_array_new (gint n_digits, ClutterActor* back_texture) {
	return led_array_construct (TYPE_LED_ARRAY, n_digits, back_texture);
}


gint led_array_get_value (LEDArray* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}


void led_array_set_value (LEDArray* self, gint value) {
	gint _tmp0_ = 0;
	gint d_val = 0;
	gint _tmp1_ = 0;
	GList* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_value = _tmp0_;
	_tmp1_ = value;
	d_val = _tmp1_;
	_tmp2_ = self->priv->digits;
	{
		GList* d_collection = NULL;
		GList* d_it = NULL;
		d_collection = _tmp2_;
		for (d_it = d_collection; d_it != NULL; d_it = d_it->next) {
			LEDDigit* _tmp3_ = NULL;
			LEDDigit* d = NULL;
			_tmp3_ = _g_object_ref0 ((LEDDigit*) d_it->data);
			d = _tmp3_;
			{
				LEDDigit* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gdouble _tmp6_ = 0.0;
				gint _tmp7_ = 0;
				_tmp4_ = d;
				_tmp5_ = d_val;
				_tmp6_ = floor ((gdouble) (_tmp5_ % 10));
				led_digit_set_value (_tmp4_, (gint) _tmp6_);
				_tmp7_ = d_val;
				d_val = _tmp7_ / 10;
				_g_object_unref0 (d);
			}
		}
	}
	g_object_notify ((GObject *) self, "value");
}


static void led_array_class_init (LEDArrayClass * klass) {
	led_array_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LEDArrayPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_led_array_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_led_array_set_property;
	G_OBJECT_CLASS (klass)->finalize = led_array_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LED_ARRAY_VALUE, g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void led_array_instance_init (LEDArray * self) {
	self->priv = LED_ARRAY_GET_PRIVATE (self);
	self->priv->digits = NULL;
	self->priv->_value = 0;
}


static void led_array_finalize (GObject* obj) {
	LEDArray * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LED_ARRAY, LEDArray);
	__g_list_free__g_object_unref0_0 (self->priv->digits);
	_g_object_unref0 (self->priv->back);
	G_OBJECT_CLASS (led_array_parent_class)->finalize (obj);
}


GType led_array_get_type (void) {
	static volatile gsize led_array_type_id__volatile = 0;
	if (g_once_init_enter (&led_array_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LEDArrayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) led_array_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LEDArray), 0, (GInstanceInitFunc) led_array_instance_init, NULL };
		GType led_array_type_id;
		led_array_type_id = g_type_register_static (clutter_group_get_type (), "LEDArray", &g_define_type_info, 0);
		g_once_init_leave (&led_array_type_id__volatile, led_array_type_id);
	}
	return led_array_type_id__volatile;
}


static void _vala_led_array_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	LEDArray * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LED_ARRAY, LEDArray);
	switch (property_id) {
		case LED_ARRAY_VALUE:
		g_value_set_int (value, led_array_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_led_array_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	LEDArray * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LED_ARRAY, LEDArray);
	switch (property_id) {
		case LED_ARRAY_VALUE:
		led_array_set_value (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



