/* game-view.c generated by valac 0.23.3.6-62e8, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <librsvg/rsvg.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _game_unref0(var) ((var == NULL) ? NULL : (var = (game_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _GamePrivate GamePrivate;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _TilePrivate TilePrivate;

#define TYPE_SLOT (slot_get_type ())
#define SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLOT, Slot))
#define SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLOT, SlotClass))
#define IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLOT))
#define IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLOT))
#define SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLOT, SlotClass))

typedef struct _Slot Slot;
typedef struct _SlotClass SlotClass;
#define _tile_unref0(var) ((var == NULL) ? NULL : (var = (tile_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SlotPrivate SlotPrivate;

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
	GdkRGBA background_color;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameViewPrivate {
	cairo_pattern_t* tile_pattern;
	gint tile_pattern_width;
	gint tile_pattern_height;
	gint x_offset;
	gint y_offset;
	gint tile_width;
	gint tile_height;
	gint tile_layer_offset_x;
	gint tile_layer_offset_y;
	Game* _game;
	gchar* _theme;
};

struct _Game {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GamePrivate * priv;
	Map* map;
	GList* tiles;
	Tile* hint_tiles[2];
	gint move_number;
	guint hint_blink_counter;
};

struct _GameClass {
	GTypeClass parent_class;
	void (*finalize) (Game *self);
};

struct _Tile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TilePrivate * priv;
	gint number;
	Slot* slot;
	gboolean visible;
	gint move_number;
};

struct _TileClass {
	GTypeClass parent_class;
	void (*finalize) (Tile *self);
};

struct _Slot {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SlotPrivate * priv;
	gint x;
	gint y;
	gint layer;
};

struct _SlotClass {
	GTypeClass parent_class;
	void (*finalize) (Slot *self);
};


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
gpointer game_ref (gpointer instance);
void game_unref (gpointer instance);
GParamSpec* param_spec_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_game (GValue* value, gpointer v_object);
void value_take_game (GValue* value, gpointer v_object);
gpointer value_get_game (const GValue* value);
GType game_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_GAME,
	GAME_VIEW_THEME
};
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
void game_view_set_background (GameView* self, const gchar* colour);
static void game_view_draw_game (GameView* self, cairo_t* cr, gboolean render_indexes);
const gchar* game_view_get_theme (GameView* self);
static void game_view_update_dimensions (GameView* self);
static void game_view_load_theme (GameView* self, cairo_t* c, gint width, gint height);
Game* game_view_get_game (GameView* self);
gpointer map_ref (gpointer instance);
void map_unref (gpointer instance);
GParamSpec* param_spec_map (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_map (GValue* value, gpointer v_object);
void value_take_map (GValue* value, gpointer v_object);
gpointer value_get_map (const GValue* value);
GType map_get_type (void) G_GNUC_CONST;
gpointer tile_ref (gpointer instance);
void tile_unref (gpointer instance);
GParamSpec* param_spec_tile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tile (GValue* value, gpointer v_object);
void value_take_tile (GValue* value, gpointer v_object);
gpointer value_get_tile (const GValue* value);
GType tile_get_type (void) G_GNUC_CONST;
gpointer slot_ref (gpointer instance);
void slot_unref (gpointer instance);
GParamSpec* param_spec_slot (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_slot (GValue* value, gpointer v_object);
void value_take_slot (GValue* value, gpointer v_object);
gpointer value_get_slot (const GValue* value);
GType slot_get_type (void) G_GNUC_CONST;
static void game_view_get_tile_position (GameView* self, Tile* tile, gint* x, gint* y);
static gint game_view_get_image_offset (GameView* self, gint number);
gboolean game_get_paused (Game* self);
Tile* game_get_selected_tile (Game* self);
static gboolean game_view_get_theme_dimensions (GameView* self, gint* width, gint* height);
guint map_get_width (Map* self);
guint map_get_height (Map* self);
static void game_view_redraw_tile_cb (GameView* self, Tile* tile);
static void game_view_paused_changed_cb (GameView* self);
static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr);
static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static Tile* game_view_find_tile (GameView* self, guint x, guint y);
gboolean game_tile_can_move (Game* self, Tile* tile);
void game_set_selected_tile (Game* self, Tile* value);
gboolean tile_matches (Tile* self, Tile* tile);
gboolean game_remove_pair (Game* self, Tile* tile0, Tile* tile1);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_redraw_tile_cb_game_redraw_tile (Game* _sender, Tile* tile, gpointer self);
static void _game_view_paused_changed_cb_game_paused_changed (Game* _sender, gpointer self);
void game_view_set_theme (GameView* self, const gchar* value);
static void game_view_finalize (GObject* obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_PRESS_MASK);
	return self;
}


GameView* game_view_new (void) {
	return game_view_construct (TYPE_GAME_VIEW);
}


void game_view_set_background (GameView* self, const gchar* colour) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	memset (&self->background_color, 0, sizeof (GdkRGBA));
	_tmp1_ = colour;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = colour;
		_tmp3_ = gdk_rgba_parse (&self->background_color, _tmp2_);
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		self->background_color.blue = (gdouble) 0;
		_tmp4_ = self->background_color.blue;
		self->background_color.green = _tmp4_;
		_tmp5_ = self->background_color.green;
		self->background_color.red = _tmp5_;
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static gpointer _tile_ref0 (gpointer self) {
	return self ? tile_ref (self) : NULL;
}


static void game_view_draw_game (GameView* self, cairo_t* cr, gboolean render_indexes) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint image_width = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint image_height = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	Game* _tmp31_ = NULL;
	Game* _tmp32_ = NULL;
	GList* _tmp33_ = NULL;
	Game* _tmp92_ = NULL;
	Game* _tmp93_ = NULL;
	gboolean _tmp94_ = FALSE;
	gboolean _tmp95_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = game_view_get_theme (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	game_view_update_dimensions (self);
	_tmp2_ = self->priv->tile_width;
	_tmp3_ = self->priv->tile_layer_offset_x;
	image_width = _tmp2_ + _tmp3_;
	_tmp4_ = self->priv->tile_height;
	_tmp5_ = self->priv->tile_layer_offset_y;
	image_height = _tmp4_ + _tmp5_;
	_tmp7_ = render_indexes;
	if (!_tmp7_) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		cairo_pattern_t* _tmp10_ = NULL;
		_tmp10_ = self->priv->tile_pattern;
		if (_tmp10_ == NULL) {
			_tmp9_ = TRUE;
		} else {
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			_tmp11_ = self->priv->tile_pattern_width;
			_tmp12_ = image_width;
			_tmp9_ = _tmp11_ != _tmp12_;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			_tmp13_ = self->priv->tile_pattern_height;
			_tmp14_ = image_height;
			_tmp8_ = _tmp13_ != _tmp14_;
		}
		_tmp6_ = _tmp8_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint width = 0;
		gint _tmp17_ = 0;
		gint height = 0;
		gint _tmp18_ = 0;
		cairo_surface_t* surface = NULL;
		cairo_t* _tmp19_ = NULL;
		cairo_surface_t* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		cairo_surface_t* _tmp23_ = NULL;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp24_ = NULL;
		cairo_t* _tmp25_ = NULL;
		cairo_t* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		cairo_surface_t* _tmp29_ = NULL;
		cairo_pattern_t* _tmp30_ = NULL;
		_tmp15_ = image_width;
		self->priv->tile_pattern_width = _tmp15_;
		_tmp16_ = image_height;
		self->priv->tile_pattern_height = _tmp16_;
		_tmp17_ = image_width;
		width = _tmp17_ * 43;
		_tmp18_ = image_height;
		height = _tmp18_ * 2;
		_tmp19_ = cr;
		_tmp20_ = cairo_get_target (_tmp19_);
		_tmp21_ = width;
		_tmp22_ = height;
		_tmp23_ = cairo_surface_create_similar (_tmp20_, CAIRO_CONTENT_COLOR_ALPHA, _tmp21_, _tmp22_);
		surface = _tmp23_;
		_tmp24_ = surface;
		_tmp25_ = cairo_create (_tmp24_);
		c = _tmp25_;
		_tmp26_ = c;
		_tmp27_ = width;
		_tmp28_ = height;
		game_view_load_theme (self, _tmp26_, _tmp27_, _tmp28_);
		_tmp29_ = surface;
		_tmp30_ = cairo_pattern_create_for_surface (_tmp29_);
		_cairo_pattern_destroy0 (self->priv->tile_pattern);
		self->priv->tile_pattern = _tmp30_;
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (surface);
	}
	_tmp31_ = game_view_get_game (self);
	_tmp32_ = _tmp31_;
	_tmp33_ = _tmp32_->tiles;
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
		tile_collection = _tmp33_;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			Tile* _tmp34_ = NULL;
			Tile* tile = NULL;
			_tmp34_ = _tile_ref0 ((Tile*) tile_it->data);
			tile = _tmp34_;
			{
				Tile* _tmp35_ = NULL;
				gboolean _tmp36_ = FALSE;
				gint x = 0;
				gint y = 0;
				Tile* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				gint texture_x = 0;
				Tile* _tmp40_ = NULL;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				gint texture_y = 0;
				Game* _tmp44_ = NULL;
				Game* _tmp45_ = NULL;
				gboolean _tmp46_ = FALSE;
				gboolean _tmp47_ = FALSE;
				gboolean _tmp70_ = FALSE;
				cairo_t* _tmp86_ = NULL;
				gint _tmp87_ = 0;
				gint _tmp88_ = 0;
				gint _tmp89_ = 0;
				gint _tmp90_ = 0;
				cairo_t* _tmp91_ = NULL;
				_tmp35_ = tile;
				_tmp36_ = _tmp35_->visible;
				if (!_tmp36_) {
					_tile_unref0 (tile);
					continue;
				}
				_tmp37_ = tile;
				game_view_get_tile_position (self, _tmp37_, &_tmp38_, &_tmp39_);
				x = _tmp38_;
				y = _tmp39_;
				_tmp40_ = tile;
				_tmp41_ = _tmp40_->number;
				_tmp42_ = game_view_get_image_offset (self, _tmp41_);
				_tmp43_ = image_width;
				texture_x = _tmp42_ * _tmp43_;
				texture_y = 0;
				_tmp44_ = game_view_get_game (self);
				_tmp45_ = _tmp44_;
				_tmp46_ = game_get_paused (_tmp45_);
				_tmp47_ = _tmp46_;
				if (_tmp47_) {
					gint _tmp48_ = 0;
					gint _tmp49_ = 0;
					_tmp48_ = game_view_get_image_offset (self, -1);
					_tmp49_ = image_width;
					texture_x = _tmp48_ * _tmp49_;
					texture_y = 0;
				} else {
					Tile* _tmp50_ = NULL;
					Game* _tmp51_ = NULL;
					Game* _tmp52_ = NULL;
					Tile* _tmp53_ = NULL;
					Tile* _tmp54_ = NULL;
					_tmp50_ = tile;
					_tmp51_ = game_view_get_game (self);
					_tmp52_ = _tmp51_;
					_tmp53_ = game_get_selected_tile (_tmp52_);
					_tmp54_ = _tmp53_;
					if (_tmp50_ == _tmp54_) {
						gint _tmp55_ = 0;
						_tmp55_ = image_height;
						texture_y = _tmp55_;
					} else {
						gboolean _tmp56_ = FALSE;
						Game* _tmp57_ = NULL;
						Game* _tmp58_ = NULL;
						guint _tmp59_ = 0U;
						_tmp57_ = game_view_get_game (self);
						_tmp58_ = _tmp57_;
						_tmp59_ = _tmp58_->hint_blink_counter;
						if ((_tmp59_ % 2) == ((guint) 1)) {
							gboolean _tmp60_ = FALSE;
							Tile* _tmp61_ = NULL;
							Game* _tmp62_ = NULL;
							Game* _tmp63_ = NULL;
							Tile* _tmp64_ = NULL;
							_tmp61_ = tile;
							_tmp62_ = game_view_get_game (self);
							_tmp63_ = _tmp62_;
							_tmp64_ = _tmp63_->hint_tiles[0];
							if (_tmp61_ == _tmp64_) {
								_tmp60_ = TRUE;
							} else {
								Tile* _tmp65_ = NULL;
								Game* _tmp66_ = NULL;
								Game* _tmp67_ = NULL;
								Tile* _tmp68_ = NULL;
								_tmp65_ = tile;
								_tmp66_ = game_view_get_game (self);
								_tmp67_ = _tmp66_;
								_tmp68_ = _tmp67_->hint_tiles[1];
								_tmp60_ = _tmp65_ == _tmp68_;
							}
							_tmp56_ = _tmp60_;
						} else {
							_tmp56_ = FALSE;
						}
						if (_tmp56_) {
							gint _tmp69_ = 0;
							_tmp69_ = image_height;
							texture_y = _tmp69_;
						}
					}
				}
				_tmp70_ = render_indexes;
				if (_tmp70_) {
					cairo_t* _tmp71_ = NULL;
					Tile* _tmp72_ = NULL;
					gint _tmp73_ = 0;
					Tile* _tmp74_ = NULL;
					gint _tmp75_ = 0;
					Tile* _tmp76_ = NULL;
					gint _tmp77_ = 0;
					_tmp71_ = cr;
					_tmp72_ = tile;
					_tmp73_ = _tmp72_->number;
					_tmp74_ = tile;
					_tmp75_ = _tmp74_->number;
					_tmp76_ = tile;
					_tmp77_ = _tmp76_->number;
					cairo_set_source_rgb (_tmp71_, _tmp73_ / 255.0, _tmp75_ / 255.0, _tmp77_ / 255.0);
				} else {
					cairo_matrix_t matrix = {0};
					gint _tmp78_ = 0;
					gint _tmp79_ = 0;
					gint _tmp80_ = 0;
					gint _tmp81_ = 0;
					cairo_pattern_t* _tmp82_ = NULL;
					cairo_matrix_t _tmp83_ = {0};
					cairo_t* _tmp84_ = NULL;
					cairo_pattern_t* _tmp85_ = NULL;
					cairo_matrix_init_identity (&matrix);
					_tmp78_ = texture_x;
					_tmp79_ = x;
					_tmp80_ = texture_y;
					_tmp81_ = y;
					cairo_matrix_translate (&matrix, (gdouble) (_tmp78_ - _tmp79_), (gdouble) (_tmp80_ - _tmp81_));
					_tmp82_ = self->priv->tile_pattern;
					_tmp83_ = matrix;
					cairo_pattern_set_matrix (_tmp82_, &_tmp83_);
					_tmp84_ = cr;
					_tmp85_ = self->priv->tile_pattern;
					cairo_set_source (_tmp84_, _tmp85_);
				}
				_tmp86_ = cr;
				_tmp87_ = x;
				_tmp88_ = y;
				_tmp89_ = image_width;
				_tmp90_ = image_height;
				cairo_rectangle (_tmp86_, (gdouble) _tmp87_, (gdouble) _tmp88_, (gdouble) _tmp89_, (gdouble) _tmp90_);
				_tmp91_ = cr;
				cairo_fill (_tmp91_);
				_tile_unref0 (tile);
			}
		}
	}
	_tmp92_ = game_view_get_game (self);
	_tmp93_ = _tmp92_;
	_tmp94_ = game_get_paused (_tmp93_);
	_tmp95_ = _tmp94_;
	if (_tmp95_) {
		cairo_t* _tmp96_ = NULL;
		cairo_t* _tmp97_ = NULL;
		cairo_t* _tmp98_ = NULL;
		cairo_t* _tmp99_ = NULL;
		gint _tmp100_ = 0;
		gchar* text = NULL;
		const gchar* _tmp101_ = NULL;
		gchar* _tmp102_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp103_ = NULL;
		const gchar* _tmp104_ = NULL;
		cairo_text_extents_t _tmp105_ = {0};
		cairo_t* _tmp106_ = NULL;
		gint _tmp107_ = 0;
		cairo_text_extents_t _tmp108_ = {0};
		gdouble _tmp109_ = 0.0;
		gint _tmp110_ = 0;
		cairo_text_extents_t _tmp111_ = {0};
		gdouble _tmp112_ = 0.0;
		cairo_t* _tmp113_ = NULL;
		cairo_t* _tmp114_ = NULL;
		const gchar* _tmp115_ = NULL;
		_tmp96_ = cr;
		cairo_set_source_rgba (_tmp96_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
		_tmp97_ = cr;
		cairo_paint (_tmp97_);
		_tmp98_ = cr;
		cairo_select_font_face (_tmp98_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		_tmp99_ = cr;
		_tmp100_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		cairo_set_font_size (_tmp99_, _tmp100_ * 0.125);
		_tmp101_ = _ ("Paused");
		_tmp102_ = g_strdup (_tmp101_);
		text = _tmp102_;
		_tmp103_ = cr;
		_tmp104_ = text;
		cairo_text_extents (_tmp103_, _tmp104_, &_tmp105_);
		extents = _tmp105_;
		_tmp106_ = cr;
		_tmp107_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp108_ = extents;
		_tmp109_ = _tmp108_.width;
		_tmp110_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp111_ = extents;
		_tmp112_ = _tmp111_.height;
		cairo_move_to (_tmp106_, (_tmp107_ - _tmp109_) / 2.0, (_tmp110_ + _tmp112_) / 2.0);
		_tmp113_ = cr;
		cairo_set_source_rgb (_tmp113_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp114_ = cr;
		_tmp115_ = text;
		cairo_show_text (_tmp114_, _tmp115_);
		_g_free0 (text);
	}
}


static void game_view_load_theme (GameView* self, cairo_t* c, gint width, gint height) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	{
		RsvgHandle* h = NULL;
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		RsvgHandle* _tmp2_ = NULL;
		cairo_matrix_t m = {0};
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		cairo_t* _tmp9_ = NULL;
		cairo_matrix_t _tmp10_ = {0};
		cairo_t* _tmp11_ = NULL;
		_tmp0_ = game_view_get_theme (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = rsvg_handle_new_from_file (_tmp1_, &_inner_error_);
		h = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		cairo_matrix_init_identity (&m);
		_tmp3_ = width;
		g_object_get (h, "width", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = height;
		g_object_get (h, "height", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		cairo_matrix_scale (&m, ((gdouble) _tmp3_) / _tmp5_, ((gdouble) _tmp6_) / _tmp8_);
		_tmp9_ = c;
		_tmp10_ = m;
		cairo_set_matrix (_tmp9_, &_tmp10_);
		_tmp11_ = c;
		rsvg_handle_render_cairo (h, _tmp11_);
		_g_object_unref0 (h);
		return;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		GdkPixbuf* _tmp16_ = NULL;
		cairo_t* _tmp17_ = NULL;
		GdkPixbuf* _tmp18_ = NULL;
		cairo_t* _tmp19_ = NULL;
		_tmp12_ = game_view_get_theme (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = width;
		_tmp15_ = height;
		_tmp16_ = gdk_pixbuf_new_from_file_at_scale (_tmp13_, _tmp14_, _tmp15_, FALSE, &_inner_error_);
		p = _tmp16_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_tmp17_ = c;
		_tmp18_ = p;
		gdk_cairo_set_source_pixbuf (_tmp17_, _tmp18_, (gdouble) 0, (gdouble) 0);
		_tmp19_ = c;
		cairo_paint (_tmp19_);
		_g_object_unref0 (p);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = game_view_get_theme (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_warning ("game-view.vala:167: Failed to load theme %s: %s", _tmp21_, _tmp23_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void game_view_update_dimensions (GameView* self) {
	gint width = 0;
	gint _tmp0_ = 0;
	gint height = 0;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint theme_width = 0;
	gint theme_height = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gdouble aspect = 0.0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gdouble map_width = 0.0;
	Game* _tmp9_ = NULL;
	Game* _tmp10_ = NULL;
	Map* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	gdouble map_height = 0.0;
	Game* _tmp14_ = NULL;
	Game* _tmp15_ = NULL;
	Map* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	guint _tmp18_ = 0U;
	gdouble _tmp19_ = 0.0;
	gdouble unit_width = 0.0;
	gint _tmp20_ = 0;
	gdouble _tmp21_ = 0.0;
	gint _tmp22_ = 0;
	gdouble _tmp23_ = 0.0;
	gdouble _tmp24_ = 0.0;
	gdouble unit_height = 0.0;
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_ = 0.0;
	gdouble _tmp27_ = 0.0;
	gdouble _tmp28_ = 0.0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	Game* _tmp32_ = NULL;
	Game* _tmp33_ = NULL;
	Map* _tmp34_ = NULL;
	guint _tmp35_ = 0U;
	guint _tmp36_ = 0U;
	gdouble _tmp37_ = 0.0;
	gint _tmp38_ = 0;
	Game* _tmp39_ = NULL;
	Game* _tmp40_ = NULL;
	Map* _tmp41_ = NULL;
	guint _tmp42_ = 0U;
	guint _tmp43_ = 0U;
	gdouble _tmp44_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	width = _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	height = _tmp1_;
	_tmp2_ = game_view_get_theme (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp6_ = game_view_get_theme_dimensions (self, &_tmp4_, &_tmp5_);
	theme_width = _tmp4_;
	theme_height = _tmp5_;
	if (!_tmp6_) {
		return;
	}
	_tmp7_ = theme_height;
	_tmp8_ = theme_width;
	aspect = (((gdouble) _tmp7_) / 2) / (((gdouble) _tmp8_) / 43);
	_tmp9_ = game_view_get_game (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_->map;
	_tmp12_ = map_get_width (_tmp11_);
	_tmp13_ = _tmp12_;
	map_width = _tmp13_ + 2.0;
	_tmp14_ = game_view_get_game (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_->map;
	_tmp17_ = map_get_height (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = aspect;
	map_height = (_tmp18_ + 2.0) * _tmp19_;
	_tmp20_ = width;
	_tmp21_ = map_width;
	_tmp22_ = height;
	_tmp23_ = map_height;
	_tmp24_ = MIN (_tmp20_ / _tmp21_, _tmp22_ / _tmp23_);
	unit_width = _tmp24_;
	_tmp25_ = unit_width;
	_tmp26_ = aspect;
	unit_height = _tmp25_ * _tmp26_;
	_tmp27_ = unit_width;
	self->priv->tile_width = (gint) (_tmp27_ * 2);
	_tmp28_ = unit_height;
	self->priv->tile_height = (gint) (_tmp28_ * 2);
	_tmp29_ = self->priv->tile_width;
	self->priv->tile_layer_offset_x = _tmp29_ / 7;
	_tmp30_ = self->priv->tile_height;
	self->priv->tile_layer_offset_y = _tmp30_ / 10;
	_tmp31_ = width;
	_tmp32_ = game_view_get_game (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_->map;
	_tmp35_ = map_get_width (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = unit_width;
	self->priv->x_offset = ((gint) (_tmp31_ - (_tmp36_ * _tmp37_))) / 2;
	_tmp38_ = height;
	_tmp39_ = game_view_get_game (self);
	_tmp40_ = _tmp39_;
	_tmp41_ = _tmp40_->map;
	_tmp42_ = map_get_height (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = unit_height;
	self->priv->y_offset = ((gint) (_tmp38_ - (_tmp43_ * _tmp44_))) / 2;
}


static gboolean game_view_get_theme_dimensions (GameView* self, gint* width, gint* height) {
	gint _vala_width = 0;
	gint _vala_height = 0;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		RsvgHandle* svg = NULL;
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		RsvgHandle* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp0_ = game_view_get_theme (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = rsvg_handle_new_from_file (_tmp1_, &_inner_error_);
		svg = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		g_object_get (svg, "width", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		_vala_width = _tmp4_;
		g_object_get (svg, "height", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_vala_height = _tmp6_;
		result = TRUE;
		_g_object_unref0 (svg);
		if (width) {
			*width = _vala_width;
		}
		if (height) {
			*height = _vala_height;
		}
		return result;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = game_view_get_theme (self);
		_tmp8_ = _tmp7_;
		gdk_pixbuf_get_file_info (_tmp8_, &_tmp9_, &_tmp10_);
		_vala_width = _tmp9_;
		_vala_height = _tmp10_;
		result = TRUE;
		_g_error_free0 (e);
		if (width) {
			*width = _vala_width;
		}
		if (height) {
			*height = _vala_height;
		}
		return result;
	}
	__finally2:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


static void game_view_get_tile_position (GameView* self, Tile* tile, gint* x, gint* y) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gint _tmp0_ = 0;
	Tile* _tmp1_ = NULL;
	Slot* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Tile* _tmp5_ = NULL;
	Slot* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	Tile* _tmp10_ = NULL;
	Slot* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	Tile* _tmp14_ = NULL;
	Slot* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tile != NULL);
	_tmp0_ = self->priv->x_offset;
	_tmp1_ = tile;
	_tmp2_ = _tmp1_->slot;
	_tmp3_ = _tmp2_->x;
	_tmp4_ = self->priv->tile_width;
	_tmp5_ = tile;
	_tmp6_ = _tmp5_->slot;
	_tmp7_ = _tmp6_->layer;
	_tmp8_ = self->priv->tile_layer_offset_x;
	_vala_x = (_tmp0_ + ((_tmp3_ * _tmp4_) / 2)) + (_tmp7_ * _tmp8_);
	_tmp9_ = self->priv->y_offset;
	_tmp10_ = tile;
	_tmp11_ = _tmp10_->slot;
	_tmp12_ = _tmp11_->y;
	_tmp13_ = self->priv->tile_height;
	_tmp14_ = tile;
	_tmp15_ = _tmp14_->slot;
	_tmp16_ = _tmp15_->layer;
	_tmp17_ = self->priv->tile_layer_offset_y;
	_vala_y = (_tmp9_ + ((_tmp12_ * _tmp13_) / 2)) - (_tmp16_ * _tmp17_);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}


static gint game_view_get_image_offset (GameView* self, gint number) {
	gint result = 0;
	gint set = 0;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp4_ = 0;
	gint _tmp6_ = 0;
	gint _tmp8_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = number;
	set = _tmp0_ / 4;
	_tmp2_ = number;
	if (_tmp2_ < 0) {
		_tmp1_ = TRUE;
	} else {
		gint _tmp3_ = 0;
		_tmp3_ = set;
		_tmp1_ = _tmp3_ >= 36;
	}
	if (_tmp1_) {
		result = 42;
		return result;
	}
	_tmp4_ = set;
	if (_tmp4_ == 33) {
		gint _tmp5_ = 0;
		_tmp5_ = number;
		result = 33 + (_tmp5_ % 4);
		return result;
	}
	_tmp6_ = set;
	if (_tmp6_ == 35) {
		gint _tmp7_ = 0;
		_tmp7_ = number;
		result = 38 + (_tmp7_ % 4);
		return result;
	}
	_tmp8_ = set;
	if (_tmp8_ == 34) {
		result = 37;
		return result;
	}
	result = set;
	return result;
}


static void game_view_redraw_tile_cb (GameView* self, Tile* tile) {
	gint x = 0;
	gint y = 0;
	Tile* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tile != NULL);
	game_view_update_dimensions (self);
	_tmp0_ = tile;
	game_view_get_tile_position (self, _tmp0_, &_tmp1_, &_tmp2_);
	x = _tmp1_;
	y = _tmp2_;
	_tmp3_ = self->priv->tile_pattern_width;
	_tmp4_ = self->priv->tile_pattern_height;
	gtk_widget_queue_draw_area ((GtkWidget*) self, x, y, _tmp3_, _tmp4_);
}


static void game_view_paused_changed_cb (GameView* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr) {
	GameView * self;
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	GdkRGBA _tmp3_ = {0};
	cairo_t* _tmp4_ = NULL;
	cairo_t* _tmp5_ = NULL;
	self = (GameView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp2_ = cr;
	_tmp3_ = self->background_color;
	gdk_cairo_set_source_rgba (_tmp2_, &_tmp3_);
	_tmp4_ = cr;
	cairo_paint (_tmp4_);
	_tmp5_ = cr;
	game_view_draw_game (self, _tmp5_, FALSE);
	result = TRUE;
	return result;
}


static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GameView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	GdkEventButton* _tmp7_ = NULL;
	GdkEventType _tmp8_ = 0;
	Tile* tile = NULL;
	GdkEventButton* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	GdkEventButton* _tmp11_ = NULL;
	gdouble _tmp12_ = 0.0;
	Tile* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	Tile* _tmp15_ = NULL;
	GdkEventButton* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
	self = (GameView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Game* _tmp3_ = NULL;
		Game* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp3_ = game_view_get_game (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = game_get_paused (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp7_ = event;
	_tmp8_ = _tmp7_->type;
	if (_tmp8_ != GDK_BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp9_ = event;
	_tmp10_ = _tmp9_->x;
	_tmp11_ = event;
	_tmp12_ = _tmp11_->y;
	_tmp13_ = game_view_find_tile (self, (guint) _tmp10_, (guint) _tmp12_);
	tile = _tmp13_;
	_tmp15_ = tile;
	if (_tmp15_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		Game* _tmp16_ = NULL;
		Game* _tmp17_ = NULL;
		Tile* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		_tmp16_ = game_view_get_game (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = tile;
		_tmp19_ = game_tile_can_move (_tmp17_, _tmp18_);
		_tmp14_ = !_tmp19_;
	}
	if (_tmp14_) {
		result = TRUE;
		_tile_unref0 (tile);
		return result;
	}
	_tmp20_ = event;
	_tmp21_ = _tmp20_->button;
	if (_tmp21_ == ((guint) 1)) {
		Game* _tmp22_ = NULL;
		Game* _tmp23_ = NULL;
		Tile* _tmp24_ = NULL;
		Tile* _tmp25_ = NULL;
		Tile* _tmp29_ = NULL;
		Game* _tmp30_ = NULL;
		Game* _tmp31_ = NULL;
		Tile* _tmp32_ = NULL;
		Tile* _tmp33_ = NULL;
		Game* _tmp36_ = NULL;
		Game* _tmp37_ = NULL;
		Tile* _tmp38_ = NULL;
		Tile* _tmp39_ = NULL;
		Tile* _tmp40_ = NULL;
		gboolean _tmp41_ = FALSE;
		_tmp22_ = game_view_get_game (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = game_get_selected_tile (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp25_ == NULL) {
			Game* _tmp26_ = NULL;
			Game* _tmp27_ = NULL;
			Tile* _tmp28_ = NULL;
			_tmp26_ = game_view_get_game (self);
			_tmp27_ = _tmp26_;
			_tmp28_ = tile;
			game_set_selected_tile (_tmp27_, _tmp28_);
			result = TRUE;
			_tile_unref0 (tile);
			return result;
		}
		_tmp29_ = tile;
		_tmp30_ = game_view_get_game (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = game_get_selected_tile (_tmp31_);
		_tmp33_ = _tmp32_;
		if (_tmp29_ == _tmp33_) {
			Game* _tmp34_ = NULL;
			Game* _tmp35_ = NULL;
			_tmp34_ = game_view_get_game (self);
			_tmp35_ = _tmp34_;
			game_set_selected_tile (_tmp35_, NULL);
			result = TRUE;
			_tile_unref0 (tile);
			return result;
		}
		_tmp36_ = game_view_get_game (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = game_get_selected_tile (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = tile;
		_tmp41_ = tile_matches (_tmp39_, _tmp40_);
		if (_tmp41_) {
			Game* _tmp42_ = NULL;
			Game* _tmp43_ = NULL;
			Game* _tmp44_ = NULL;
			Game* _tmp45_ = NULL;
			Tile* _tmp46_ = NULL;
			Tile* _tmp47_ = NULL;
			Tile* _tmp48_ = NULL;
			_tmp42_ = game_view_get_game (self);
			_tmp43_ = _tmp42_;
			_tmp44_ = game_view_get_game (self);
			_tmp45_ = _tmp44_;
			_tmp46_ = game_get_selected_tile (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = tile;
			game_remove_pair (_tmp43_, _tmp47_, _tmp48_);
			result = TRUE;
			_tile_unref0 (tile);
			return result;
		} else {
			Game* _tmp49_ = NULL;
			Game* _tmp50_ = NULL;
			Tile* _tmp51_ = NULL;
			_tmp49_ = game_view_get_game (self);
			_tmp50_ = _tmp49_;
			_tmp51_ = tile;
			game_set_selected_tile (_tmp50_, _tmp51_);
			result = TRUE;
			_tile_unref0 (tile);
			return result;
		}
	}
	result = FALSE;
	_tile_unref0 (tile);
	return result;
}


static Tile* game_view_find_tile (GameView* self, guint x, guint y) {
	Tile* result = NULL;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	cairo_t* _tmp4_ = NULL;
	cairo_t* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	cairo_t* _tmp8_ = NULL;
	guchar* data = NULL;
	cairo_surface_t* _tmp9_ = NULL;
	guchar* _tmp10_ = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	guchar number = '\0';
	guchar* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	guchar _tmp12_ = '\0';
	Game* _tmp13_ = NULL;
	Game* _tmp14_ = NULL;
	GList* _tmp15_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, 1, 1);
	surface = _tmp0_;
	_tmp1_ = surface;
	_tmp2_ = cairo_create (_tmp1_);
	cr = _tmp2_;
	_tmp3_ = cr;
	cairo_set_source_rgba (_tmp3_, (gdouble) 255, (gdouble) 255, (gdouble) 255, (gdouble) 255);
	_tmp4_ = cr;
	cairo_paint (_tmp4_);
	_tmp5_ = cr;
	_tmp6_ = x;
	_tmp7_ = y;
	cairo_translate (_tmp5_, (gdouble) (-_tmp6_), (gdouble) (-_tmp7_));
	_tmp8_ = cr;
	game_view_draw_game (self, _tmp8_, TRUE);
	_tmp9_ = surface;
	_tmp10_ = cairo_image_surface_get_data (_tmp9_);
	data = _tmp10_;
	data_length1 = -1;
	_data_size_ = data_length1;
	_tmp11_ = data;
	_tmp11__length1 = data_length1;
	_tmp12_ = _tmp11_[0];
	number = _tmp12_;
	_tmp13_ = game_view_get_game (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_->tiles;
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
		tile_collection = _tmp15_;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			Tile* _tmp16_ = NULL;
			Tile* tile = NULL;
			_tmp16_ = _tile_ref0 ((Tile*) tile_it->data);
			tile = _tmp16_;
			{
				Tile* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				guchar _tmp19_ = '\0';
				_tmp17_ = tile;
				_tmp18_ = _tmp17_->number;
				_tmp19_ = number;
				if (_tmp18_ == ((gint) _tmp19_)) {
					result = tile;
					_cairo_destroy0 (cr);
					_cairo_surface_destroy0 (surface);
					return result;
				}
				_tile_unref0 (tile);
			}
		}
	}
	result = NULL;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (surface);
	return result;
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static gpointer _game_ref0 (gpointer self) {
	return self ? game_ref (self) : NULL;
}


static void _game_view_redraw_tile_cb_game_redraw_tile (Game* _sender, Tile* tile, gpointer self) {
	game_view_redraw_tile_cb ((GameView*) self, tile);
}


static void _game_view_paused_changed_cb_game_paused_changed (Game* _sender, gpointer self) {
	game_view_paused_changed_cb ((GameView*) self);
}


void game_view_set_game (GameView* self, Game* value) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _game_ref0 (_tmp0_);
	_game_unref0 (self->priv->_game);
	self->priv->_game = _tmp1_;
	_tmp2_ = self->priv->_game;
	g_signal_connect_object (_tmp2_, "redraw-tile", (GCallback) _game_view_redraw_tile_cb_game_redraw_tile, self, 0);
	_tmp3_ = self->priv->_game;
	g_signal_connect_object (_tmp3_, "paused-changed", (GCallback) _game_view_paused_changed_cb_game_paused_changed, self, 0);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "game");
}


const gchar* game_view_get_theme (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}


void game_view_set_theme (GameView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp1_;
	_cairo_pattern_destroy0 (self->priv->tile_pattern);
	self->priv->tile_pattern = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "theme");
}


static void game_view_class_init (GameViewClass * klass) {
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
	GTK_WIDGET_CLASS (klass)->draw = game_view_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = game_view_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME, param_spec_game ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME, g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void game_view_instance_init (GameView * self) {
	self->priv = GAME_VIEW_GET_PRIVATE (self);
	self->priv->tile_pattern = NULL;
	self->priv->tile_pattern_width = 0;
	self->priv->tile_pattern_height = 0;
	self->priv->_theme = NULL;
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_cairo_pattern_destroy0 (self->priv->tile_pattern);
	_game_unref0 (self->priv->_game);
	_g_free0 (self->priv->_theme);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_GAME:
		value_set_game (value, game_view_get_game (self));
		break;
		case GAME_VIEW_THEME:
		g_value_set_string (value, game_view_get_theme (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_GAME:
		game_view_set_game (self, value_get_game (value));
		break;
		case GAME_VIEW_THEME:
		game_view_set_theme (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



