/* rygel-media-engine-test.c generated by valac 0.22.0.18-aa6c, the Vala compiler
 * generated from rygel-media-engine-test.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <libsoup/soup.h>
#include <gee.h>
#include <gio/gio.h>
#include <gmodule.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG (rygel_data_source_test_config_get_type ())
#define RYGEL_DATA_SOURCE_TEST_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG, RygelDataSourceTestConfig))
#define RYGEL_DATA_SOURCE_TEST_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG, RygelDataSourceTestConfigClass))
#define RYGEL_IS_DATA_SOURCE_TEST_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG))
#define RYGEL_IS_DATA_SOURCE_TEST_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG))
#define RYGEL_DATA_SOURCE_TEST_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG, RygelDataSourceTestConfigClass))

typedef struct _RygelDataSourceTestConfig RygelDataSourceTestConfig;
typedef struct _RygelDataSourceTestConfigClass RygelDataSourceTestConfigClass;
typedef struct _RygelDataSourceTestConfigPrivate RygelDataSourceTestConfigPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_BYTE_SEEK (rygel_byte_seek_get_type ())
#define RYGEL_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BYTE_SEEK, RygelByteSeek))
#define RYGEL_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BYTE_SEEK, RygelByteSeekClass))
#define RYGEL_IS_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BYTE_SEEK))
#define RYGEL_IS_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BYTE_SEEK))
#define RYGEL_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BYTE_SEEK, RygelByteSeekClass))

typedef struct _RygelByteSeek RygelByteSeek;
typedef struct _RygelByteSeekClass RygelByteSeekClass;
typedef struct _RygelByteSeekPrivate RygelByteSeekPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DATA_BLOCK (data_block_get_type ())
#define DATA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_BLOCK, DataBlock))
#define DATA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_BLOCK, DataBlockClass))
#define IS_DATA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_BLOCK))
#define IS_DATA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_BLOCK))
#define DATA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_BLOCK, DataBlockClass))

typedef struct _DataBlock DataBlock;
typedef struct _DataBlockClass DataBlockClass;
typedef struct _DataBlockPrivate DataBlockPrivate;
typedef struct _ParamSpecDataBlock ParamSpecDataBlock;

#define RYGEL_TYPE_DATA_POOL (rygel_data_pool_get_type ())
#define RYGEL_DATA_POOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_POOL, RygelDataPool))
#define RYGEL_DATA_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DATA_POOL, RygelDataPoolClass))
#define RYGEL_IS_DATA_POOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_POOL))
#define RYGEL_IS_DATA_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DATA_POOL))
#define RYGEL_DATA_POOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DATA_POOL, RygelDataPoolClass))

typedef struct _RygelDataPool RygelDataPool;
typedef struct _RygelDataPoolClass RygelDataPoolClass;
typedef struct _RygelDataPoolPrivate RygelDataPoolPrivate;
#define _data_block_unref0(var) ((var == NULL) ? NULL : (var = (data_block_unref (var), NULL)))

#define RYGEL_TYPE_DATA_SOURCE_TEST (rygel_data_source_test_get_type ())
#define RYGEL_DATA_SOURCE_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE_TEST, RygelDataSourceTest))
#define RYGEL_DATA_SOURCE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DATA_SOURCE_TEST, RygelDataSourceTestClass))
#define RYGEL_IS_DATA_SOURCE_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE_TEST))
#define RYGEL_IS_DATA_SOURCE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DATA_SOURCE_TEST))
#define RYGEL_DATA_SOURCE_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DATA_SOURCE_TEST, RygelDataSourceTestClass))

typedef struct _RygelDataSourceTest RygelDataSourceTest;
typedef struct _RygelDataSourceTestClass RygelDataSourceTestClass;
typedef struct _RygelDataSourceTestPrivate RygelDataSourceTestPrivate;
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelDataSourceTestConfig {
	RygelBaseConfiguration parent_instance;
	RygelDataSourceTestConfigPrivate * priv;
};

struct _RygelDataSourceTestConfigClass {
	RygelBaseConfigurationClass parent_class;
};

struct _RygelDataSourceTestConfigPrivate {
	gchar* engine;
	gchar* path;
};

struct _RygelByteSeek {
	RygelHTTPSeek parent_instance;
	RygelByteSeekPrivate * priv;
};

struct _RygelByteSeekClass {
	RygelHTTPSeekClass parent_class;
};

struct _DataBlock {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataBlockPrivate * priv;
	guint8* data;
	gint data_length1;
	gint _data_size_;
};

struct _DataBlockClass {
	GTypeClass parent_class;
	void (*finalize) (DataBlock *self);
};

struct _ParamSpecDataBlock {
	GParamSpec parent_instance;
};

struct _RygelDataPool {
	GeeArrayList parent_instance;
	RygelDataPoolPrivate * priv;
};

struct _RygelDataPoolClass {
	GeeArrayListClass parent_class;
};

struct _RygelDataSourceTest {
	GObject parent_instance;
	RygelDataSourceTestPrivate * priv;
};

struct _RygelDataSourceTestClass {
	GObjectClass parent_class;
};

struct _RygelDataSourceTestPrivate {
	GFile* test_data_file;
	GMappedFile* test_data_mapped;
};

struct _Block1Data {
	int _ref_count_;
	RygelDataSourceTest * self;
	RygelDataSource* source;
	guint64 received_bytes;
	GMainLoop* loop;
};

struct _Block2Data {
	int _ref_count_;
	RygelDataSourceTest * self;
	RygelDataPool* received_data;
	GMainLoop* loop;
};

struct _Block3Data {
	int _ref_count_;
	RygelDataSourceTest * self;
	RygelDataSource* source;
	RygelDataPool* pool;
	GMainLoop* loop;
};

struct _Block4Data {
	int _ref_count_;
	RygelDataSourceTest * self;
	RygelDataSource* source;
	GMainLoop* loop;
};

struct _Block5Data {
	int _ref_count_;
	RygelDataSourceTest * self;
	GMainLoop* loop;
	gboolean quit;
};


static gpointer rygel_data_source_test_config_parent_class = NULL;
static gpointer rygel_byte_seek_parent_class = NULL;
static gpointer data_block_parent_class = NULL;
static gpointer rygel_data_pool_parent_class = NULL;
static gpointer rygel_data_source_test_parent_class = NULL;

GType rygel_data_source_test_config_get_type (void) G_GNUC_CONST;
#define RYGEL_DATA_SOURCE_TEST_CONFIG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG, RygelDataSourceTestConfigPrivate))
enum  {
	RYGEL_DATA_SOURCE_TEST_CONFIG_DUMMY_PROPERTY
};
RygelDataSourceTestConfig* rygel_data_source_test_config_new (const gchar* path, const gchar* engine);
RygelDataSourceTestConfig* rygel_data_source_test_config_construct (GType object_type, const gchar* path, const gchar* engine);
static gchar* rygel_data_source_test_config_real_get_media_engine (RygelBaseConfiguration* base, GError** error);
static gchar* rygel_data_source_test_config_real_get_engine_path (RygelBaseConfiguration* base, GError** error);
gchar* rygel_data_source_test_config_to_string (RygelDataSourceTestConfig* self);
void rygel_data_source_test_config_clear (RygelDataSourceTestConfig* self);
static void rygel_data_source_test_config_finalize (GObject* obj);
GType rygel_byte_seek_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_BYTE_SEEK_DUMMY_PROPERTY
};
RygelByteSeek* rygel_byte_seek_new (gint64 first, gint64 last, gint64 length);
RygelByteSeek* rygel_byte_seek_construct (GType object_type, gint64 first, gint64 last, gint64 length);
static void rygel_byte_seek_real_add_response_headers (RygelHTTPSeek* base);
gpointer data_block_ref (gpointer instance);
void data_block_unref (gpointer instance);
GParamSpec* param_spec_data_block (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_block (GValue* value, gpointer v_object);
void value_take_data_block (GValue* value, gpointer v_object);
gpointer value_get_data_block (const GValue* value);
GType data_block_get_type (void) G_GNUC_CONST;
enum  {
	DATA_BLOCK_DUMMY_PROPERTY
};
DataBlock* data_block_new (guint8* data, int data_length1);
DataBlock* data_block_construct (GType object_type, guint8* data, int data_length1);
static guint8* _vala_array_dup1 (guint8* self, int length);
static void data_block_finalize (DataBlock* obj);
GType rygel_data_pool_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_DATA_POOL_DUMMY_PROPERTY
};
guint8* rygel_data_pool_flatten (RygelDataPool* self, int* result_length1);
guint64 rygel_data_pool_total_size (RygelDataPool* self);
RygelDataPool* rygel_data_pool_new (void);
RygelDataPool* rygel_data_pool_construct (GType object_type);
GType rygel_data_source_test_get_type (void) G_GNUC_CONST;
#define RYGEL_DATA_SOURCE_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DATA_SOURCE_TEST, RygelDataSourceTestPrivate))
enum  {
	RYGEL_DATA_SOURCE_TEST_DUMMY_PROPERTY
};
RygelDataSourceTest* rygel_data_source_test_new (void);
RygelDataSourceTest* rygel_data_source_test_construct (GType object_type);
static void rygel_data_source_test_test_simple_streaming (RygelDataSourceTest* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda2_ (Block1Data* _data1_, guint8* data, int data_length1);
static void ___lambda2__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self);
static void __lambda3_ (Block1Data* _data1_, RygelDataSource* data);
static void ___lambda3__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
static gboolean __lambda4_ (Block1Data* _data1_);
static gboolean ___lambda4__gsource_func (gpointer self);
static void rygel_data_source_test_test_byte_range_request (RygelDataSourceTest* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda5_ (Block2Data* _data2_, guint8* data, int data_length1);
static void ____lambda5__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self);
static void ___lambda6_ (Block2Data* _data2_, RygelDataSource* data);
static void ____lambda6__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
static void ___lambda7_ (RygelDataSourceTest* self);
static void ____lambda7__rygel_data_source_error (RygelDataSource* _sender, GError* _error_, gpointer self);
static void ___lambda8_ (Block2Data* _data2_, guint8* data, int data_length1);
static void ____lambda8__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self);
static void ___lambda9_ (Block2Data* _data2_, RygelDataSource* data);
static void ____lambda9__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
static void ___lambda10_ (RygelDataSourceTest* self);
static void ____lambda10__rygel_data_source_error (RygelDataSource* _sender, GError* _error_, gpointer self);
static void ___lambda11_ (Block2Data* _data2_, guint8* data, int data_length1);
static void ____lambda11__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self);
static void ___lambda12_ (Block2Data* _data2_, RygelDataSource* data);
static void ____lambda12__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
static void ___lambda13_ (RygelDataSourceTest* self);
static void ____lambda13__rygel_data_source_error (RygelDataSource* _sender, GError* _error_, gpointer self);
static void rygel_data_source_test_test_stop_start (RygelDataSourceTest* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda14_ (Block3Data* _data3_, guint8* data, int data_length1);
static void ___lambda14__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self);
static void __lambda15_ (Block3Data* _data3_, RygelDataSource* data);
static void ___lambda15__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
static gboolean __lambda16_ (Block3Data* _data3_);
static gboolean ___lambda16__gsource_func (gpointer self);
static gboolean __lambda17_ (Block3Data* _data3_);
static gboolean ___lambda17__gsource_func (gpointer self);
static void rygel_data_source_test_test_freeze_stop (RygelDataSourceTest* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda18_ (Block4Data* _data4_);
static void ___lambda18__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
static gboolean __lambda19_ (RygelDataSourceTest* self);
static gboolean ___lambda19__gsource_func (gpointer self);
static gboolean __lambda20_ (Block4Data* _data4_);
static gboolean ___lambda20__gsource_func (gpointer self);
void rygel_data_source_test_test_parallel_streaming (RygelDataSourceTest* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda21_ (Block5Data* _data5_);
static void ___lambda21__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
static void __lambda22_ (Block5Data* _data5_);
static void ___lambda22__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
gint rygel_data_source_test_run (RygelDataSourceTest* self);
gint rygel_data_source_test_main (gchar** args, int args_length1);
static void rygel_data_source_test_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


RygelDataSourceTestConfig* rygel_data_source_test_config_construct (GType object_type, const gchar* path, const gchar* engine) {
	RygelDataSourceTestConfig * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	self = (RygelDataSourceTestConfig*) rygel_base_configuration_construct (object_type);
	_tmp0_ = engine;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->engine);
	self->priv->engine = _tmp1_;
	_tmp2_ = path;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->path);
	self->priv->path = _tmp3_;
	return self;
}


RygelDataSourceTestConfig* rygel_data_source_test_config_new (const gchar* path, const gchar* engine) {
	return rygel_data_source_test_config_construct (RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG, path, engine);
}


static gchar* rygel_data_source_test_config_real_get_media_engine (RygelBaseConfiguration* base, GError** error) {
	RygelDataSourceTestConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelDataSourceTestConfig*) base;
	_tmp0_ = self->priv->engine;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = self->priv->engine;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp4_ = RYGEL_BASE_CONFIGURATION_CLASS (rygel_data_source_test_config_parent_class)->get_media_engine (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASE_CONFIGURATION, RygelBaseConfiguration), &_inner_error_);
	_tmp3_ = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp3_;
	return result;
}


static gchar* rygel_data_source_test_config_real_get_engine_path (RygelBaseConfiguration* base, GError** error) {
	RygelDataSourceTestConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp3_ = NULL;
	self = (RygelDataSourceTestConfig*) base;
	_tmp0_ = self->priv->path;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = self->priv->path;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_strdup (TEST_ENGINE_PATH);
	result = _tmp3_;
	return result;
}


gchar* rygel_data_source_test_config_to_string (RygelDataSourceTestConfig* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->path;
	_tmp1_ = self->priv->engine;
	_tmp2_ = g_strdup_printf ("Path: %s, Engine: %s", _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


void rygel_data_source_test_config_clear (RygelDataSourceTestConfig* self) {
	g_return_if_fail (self != NULL);
	_g_free0 (self->priv->engine);
	self->priv->engine = NULL;
	_g_free0 (self->priv->path);
	self->priv->path = NULL;
}


static void rygel_data_source_test_config_class_init (RygelDataSourceTestConfigClass * klass) {
	rygel_data_source_test_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelDataSourceTestConfigPrivate));
	RYGEL_BASE_CONFIGURATION_CLASS (klass)->get_media_engine = rygel_data_source_test_config_real_get_media_engine;
	RYGEL_BASE_CONFIGURATION_CLASS (klass)->get_engine_path = rygel_data_source_test_config_real_get_engine_path;
	G_OBJECT_CLASS (klass)->finalize = rygel_data_source_test_config_finalize;
}


static void rygel_data_source_test_config_instance_init (RygelDataSourceTestConfig * self) {
	self->priv = RYGEL_DATA_SOURCE_TEST_CONFIG_GET_PRIVATE (self);
}


static void rygel_data_source_test_config_finalize (GObject* obj) {
	RygelDataSourceTestConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG, RygelDataSourceTestConfig);
	_g_free0 (self->priv->engine);
	_g_free0 (self->priv->path);
	G_OBJECT_CLASS (rygel_data_source_test_config_parent_class)->finalize (obj);
}


/**
 * Helper class to convince the engine loader to load the media engine we want
 * to test.
 */
GType rygel_data_source_test_config_get_type (void) {
	static volatile gsize rygel_data_source_test_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_data_source_test_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDataSourceTestConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_data_source_test_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDataSourceTestConfig), 0, (GInstanceInitFunc) rygel_data_source_test_config_instance_init, NULL };
		GType rygel_data_source_test_config_type_id;
		rygel_data_source_test_config_type_id = g_type_register_static (RYGEL_TYPE_BASE_CONFIGURATION, "RygelDataSourceTestConfig", &g_define_type_info, 0);
		g_once_init_leave (&rygel_data_source_test_config_type_id__volatile, rygel_data_source_test_config_type_id);
	}
	return rygel_data_source_test_config_type_id__volatile;
}


RygelByteSeek* rygel_byte_seek_construct (GType object_type, gint64 first, gint64 last, gint64 length) {
	RygelByteSeek * self = NULL;
	SoupMessage* msg = NULL;
	SoupMessage* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = soup_message_new ("GET", "http://example.com/");
	msg = _tmp0_;
	{
		gint64 _tmp1_ = 0LL;
		gint64 _tmp2_ = 0LL;
		gint64 _tmp3_ = 0LL;
		_tmp1_ = first;
		_tmp2_ = last;
		_tmp3_ = length;
		self = (RygelByteSeek*) rygel_http_seek_construct (object_type, msg, _tmp1_, _tmp2_, (gint64) 1, _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
				goto __catch0_rygel_http_seek_error;
			}
			_g_object_unref0 (msg);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally0;
	__catch0_rygel_http_seek_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	rygel_http_seek_set_seek_type ((RygelHTTPSeek*) self, RYGEL_HTTP_SEEK_TYPE_BYTE);
	_g_object_unref0 (msg);
	return self;
}


RygelByteSeek* rygel_byte_seek_new (gint64 first, gint64 last, gint64 length) {
	return rygel_byte_seek_construct (RYGEL_TYPE_BYTE_SEEK, first, last, length);
}


static void rygel_byte_seek_real_add_response_headers (RygelHTTPSeek* base) {
	RygelByteSeek * self;
	self = (RygelByteSeek*) base;
}


static void rygel_byte_seek_class_init (RygelByteSeekClass * klass) {
	rygel_byte_seek_parent_class = g_type_class_peek_parent (klass);
	RYGEL_HTTP_SEEK_CLASS (klass)->add_response_headers = rygel_byte_seek_real_add_response_headers;
}


static void rygel_byte_seek_instance_init (RygelByteSeek * self) {
}


/**
 * Stub implementation of Rygel.HTTPSeek
 */
GType rygel_byte_seek_get_type (void) {
	static volatile gsize rygel_byte_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_byte_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelByteSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_byte_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelByteSeek), 0, (GInstanceInitFunc) rygel_byte_seek_instance_init, NULL };
		GType rygel_byte_seek_type_id;
		rygel_byte_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelByteSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_byte_seek_type_id__volatile, rygel_byte_seek_type_id);
	}
	return rygel_byte_seek_type_id__volatile;
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


DataBlock* data_block_construct (GType object_type, guint8* data, int data_length1) {
	DataBlock* self = NULL;
	guint8* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	guint8* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (DataBlock*) g_type_create_instance (object_type);
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->data = (g_free (self->data), NULL);
	self->data = _tmp1_;
	self->data_length1 = _tmp1__length1;
	self->_data_size_ = self->data_length1;
	return self;
}


DataBlock* data_block_new (guint8* data, int data_length1) {
	return data_block_construct (TYPE_DATA_BLOCK, data, data_length1);
}


static void value_data_block_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_data_block_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		data_block_unref (value->data[0].v_pointer);
	}
}


static void value_data_block_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = data_block_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_data_block_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_data_block_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DataBlock* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = data_block_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_data_block_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DataBlock** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = data_block_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_data_block (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecDataBlock* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DATA_BLOCK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_data_block (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_BLOCK), NULL);
	return value->data[0].v_pointer;
}


void value_set_data_block (GValue* value, gpointer v_object) {
	DataBlock* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_BLOCK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATA_BLOCK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		data_block_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		data_block_unref (old);
	}
}


void value_take_data_block (GValue* value, gpointer v_object) {
	DataBlock* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_BLOCK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATA_BLOCK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		data_block_unref (old);
	}
}


static void data_block_class_init (DataBlockClass * klass) {
	data_block_parent_class = g_type_class_peek_parent (klass);
	DATA_BLOCK_CLASS (klass)->finalize = data_block_finalize;
}


static void data_block_instance_init (DataBlock * self) {
	self->ref_count = 1;
}


static void data_block_finalize (DataBlock* obj) {
	DataBlock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATA_BLOCK, DataBlock);
	self->data = (g_free (self->data), NULL);
}


/**
 * Wrapper class arount uint8[] arrays to help stuff those buffers into a
 * Gee.ArrayList
 */
GType data_block_get_type (void) {
	static volatile gsize data_block_type_id__volatile = 0;
	if (g_once_init_enter (&data_block_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_data_block_init, value_data_block_free_value, value_data_block_copy_value, value_data_block_peek_pointer, "p", value_data_block_collect_value, "p", value_data_block_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DataBlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataBlock), 0, (GInstanceInitFunc) data_block_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType data_block_type_id;
		data_block_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DataBlock", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&data_block_type_id__volatile, data_block_type_id);
	}
	return data_block_type_id__volatile;
}


gpointer data_block_ref (gpointer instance) {
	DataBlock* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void data_block_unref (gpointer instance) {
	DataBlock* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DATA_BLOCK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


guint8* rygel_data_pool_flatten (RygelDataPool* self, int* result_length1) {
	guint8* result = NULL;
	guint64 size = 0ULL;
	guint64 _tmp0_ = 0ULL;
	guint8* _result_ = NULL;
	guint64 _tmp1_ = 0ULL;
	guint8* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint offset = 0;
	guint8* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	DataBlock* _tmp23_ = NULL;
	DataBlock* _tmp24_ = NULL;
	guint8* _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_data_pool_total_size (self);
	size = _tmp0_;
	_tmp1_ = size;
	_tmp2_ = g_new0 (guint8, _tmp1_);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_;
	__result__size_ = _result__length1;
	offset = 0;
	{
		RygelDataPool* _data_list = NULL;
		RygelDataPool* _tmp3_ = NULL;
		gint _data_size = 0;
		RygelDataPool* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _data_index = 0;
		_tmp3_ = _g_object_ref0 (self);
		_data_list = _tmp3_;
		_tmp4_ = _data_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_data_size = _tmp6_;
		_data_index = -1;
		while (TRUE) {
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			DataBlock* data = NULL;
			RygelDataPool* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gpointer _tmp12_ = NULL;
			guint8* _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			gint _tmp14_ = 0;
			DataBlock* _tmp15_ = NULL;
			guint8* _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			DataBlock* _tmp17_ = NULL;
			guint8* _tmp18_ = NULL;
			gint _tmp18__length1 = 0;
			gint _tmp19_ = 0;
			DataBlock* _tmp20_ = NULL;
			guint8* _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			_tmp7_ = _data_index;
			_data_index = _tmp7_ + 1;
			_tmp8_ = _data_index;
			_tmp9_ = _data_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _data_list;
			_tmp11_ = _data_index;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
			data = (DataBlock*) _tmp12_;
			_tmp13_ = _result_;
			_tmp13__length1 = _result__length1;
			_tmp14_ = offset;
			_tmp15_ = data;
			_tmp16_ = _tmp15_->data;
			_tmp16__length1 = _tmp15_->data_length1;
			_tmp17_ = data;
			_tmp18_ = _tmp17_->data;
			_tmp18__length1 = _tmp17_->data_length1;
			memcpy (_tmp13_ + ((guint8) _tmp14_), (void*) _tmp16_, (gsize) _tmp18__length1);
			_tmp19_ = offset;
			_tmp20_ = data;
			_tmp21_ = _tmp20_->data;
			_tmp21__length1 = _tmp20_->data_length1;
			offset = _tmp19_ + _tmp21__length1;
			_data_block_unref0 (data);
		}
		_g_object_unref0 (_data_list);
	}
	gee_abstract_collection_clear ((GeeAbstractCollection*) self);
	_tmp22_ = _result_;
	_tmp22__length1 = _result__length1;
	_tmp23_ = data_block_new (_tmp22_, _tmp22__length1);
	_tmp24_ = _tmp23_;
	gee_abstract_collection_add ((GeeAbstractCollection*) self, _tmp24_);
	_data_block_unref0 (_tmp24_);
	_tmp25_ = _result_;
	_tmp25__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp25__length1;
	}
	result = _tmp25_;
	return result;
}


guint64 rygel_data_pool_total_size (RygelDataPool* self) {
	guint64 result = 0ULL;
	guint64 total = 0ULL;
	g_return_val_if_fail (self != NULL, 0ULL);
	total = (guint64) 0;
	{
		RygelDataPool* _data_list = NULL;
		RygelDataPool* _tmp0_ = NULL;
		gint _data_size = 0;
		RygelDataPool* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _data_index = 0;
		_tmp0_ = _g_object_ref0 (self);
		_data_list = _tmp0_;
		_tmp1_ = _data_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_data_size = _tmp3_;
		_data_index = -1;
		while (TRUE) {
			gint _tmp4_ = 0;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			DataBlock* data = NULL;
			RygelDataPool* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gpointer _tmp9_ = NULL;
			guint64 _tmp10_ = 0ULL;
			DataBlock* _tmp11_ = NULL;
			guint8* _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			_tmp4_ = _data_index;
			_data_index = _tmp4_ + 1;
			_tmp5_ = _data_index;
			_tmp6_ = _data_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _data_list;
			_tmp8_ = _data_index;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp8_);
			data = (DataBlock*) _tmp9_;
			_tmp10_ = total;
			_tmp11_ = data;
			_tmp12_ = _tmp11_->data;
			_tmp12__length1 = _tmp11_->data_length1;
			total = _tmp10_ + _tmp12__length1;
			_data_block_unref0 (data);
		}
		_g_object_unref0 (_data_list);
	}
	result = total;
	return result;
}


RygelDataPool* rygel_data_pool_construct (GType object_type) {
	RygelDataPool * self = NULL;
	self = (RygelDataPool*) gee_array_list_construct (object_type, TYPE_DATA_BLOCK, (GBoxedCopyFunc) data_block_ref, data_block_unref, NULL, NULL, NULL);
	return self;
}


RygelDataPool* rygel_data_pool_new (void) {
	return rygel_data_pool_construct (RYGEL_TYPE_DATA_POOL);
}


static void rygel_data_pool_class_init (RygelDataPoolClass * klass) {
	rygel_data_pool_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_data_pool_instance_init (RygelDataPool * self) {
}


/**
 * Helper class to collect a number of byte buffers
 */
GType rygel_data_pool_get_type (void) {
	static volatile gsize rygel_data_pool_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_data_pool_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDataPoolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_data_pool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDataPool), 0, (GInstanceInitFunc) rygel_data_pool_instance_init, NULL };
		GType rygel_data_pool_type_id;
		rygel_data_pool_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "RygelDataPool", &g_define_type_info, 0);
		g_once_init_leave (&rygel_data_pool_type_id__volatile, rygel_data_pool_type_id);
	}
	return rygel_data_pool_type_id__volatile;
}


RygelDataSourceTest* rygel_data_source_test_construct (GType object_type) {
	RygelDataSourceTest * self = NULL;
	gchar* path = NULL;
	gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelDataSourceTest*) g_object_new (object_type, NULL);
	_tmp0_ = g_build_filename (TEST_DATA_FOLDER, "test-data.dat", NULL);
	path = _tmp0_;
	_tmp1_ = g_file_new_for_path (path);
	_g_object_unref0 (self->priv->test_data_file);
	self->priv->test_data_file = _tmp1_;
	{
		GMappedFile* _tmp2_ = NULL;
		GMappedFile* _tmp3_ = NULL;
		_tmp3_ = g_mapped_file_new (path, FALSE, &_inner_error_);
		_tmp2_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_g_mapped_file_unref0 (self->priv->test_data_mapped);
		self->priv->test_data_mapped = _tmp2_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp4_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _error_->message;
		g_warning ("rygel-media-engine-test.vala:154: Error: Could not map file: %s", _tmp4_);
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (path);
	return self;
}


RygelDataSourceTest* rygel_data_source_test_new (void) {
	return rygel_data_source_test_construct (RYGEL_TYPE_DATA_SOURCE_TEST);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelDataSourceTest * self;
		self = _data1_->self;
		_g_main_loop_unref0 (_data1_->loop);
		_g_object_unref0 (_data1_->source);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda2_ (Block1Data* _data1_, guint8* data, int data_length1) {
	RygelDataSourceTest * self;
	guint8* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	self = _data1_->self;
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	_data1_->received_bytes = _data1_->received_bytes + _tmp0__length1;
}


static void ___lambda2__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self) {
	__lambda2_ (self, data, data_length1);
}


static void __lambda3_ (Block1Data* _data1_, RygelDataSource* data) {
	RygelDataSourceTest * self;
	self = _data1_->self;
	g_return_if_fail (data != NULL);
	g_main_loop_quit (_data1_->loop);
}


static void ___lambda3__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
	__lambda3_ (self, _sender);
}


static gboolean __lambda4_ (Block1Data* _data1_) {
	RygelDataSourceTest * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	{
		RygelDataSource* _tmp0_ = NULL;
		_tmp0_ = _data1_->source;
		rygel_data_source_start (_tmp0_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		result = FALSE;
		return result;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally2:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ (self);
	return result;
}


static void rygel_data_source_test_test_simple_streaming (RygelDataSourceTest* self) {
	Block1Data* _data1_;
	RygelMediaEngine* _tmp0_ = NULL;
	RygelMediaEngine* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	RygelDataSource* _tmp5_ = NULL;
	RygelDataSource* _tmp6_ = NULL;
	RygelDataSource* _tmp7_ = NULL;
	GMainLoop* _tmp8_ = NULL;
	RygelDataSource* _tmp9_ = NULL;
	RygelDataSource* _tmp10_ = NULL;
	GMappedFile* _tmp11_ = NULL;
	gsize _tmp12_ = 0UL;
	RygelDataSource* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	g_debug ("rygel-media-engine-test.vala:161: test_simple_streaming");
	_tmp0_ = rygel_media_engine_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->test_data_file;
	_tmp3_ = g_file_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = rygel_media_engine_create_data_source (_tmp1_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	_data1_->source = _tmp6_;
	_tmp7_ = _data1_->source;
	_vala_assert (_tmp7_ != NULL, "source != null");
	_data1_->received_bytes = (guint64) 0;
	_tmp8_ = g_main_loop_new (NULL, FALSE);
	_data1_->loop = _tmp8_;
	_tmp9_ = _data1_->source;
	g_signal_connect_data (_tmp9_, "data-available", (GCallback) ___lambda2__rygel_data_source_data_available, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp10_ = _data1_->source;
	g_signal_connect_data (_tmp10_, "done", (GCallback) ___lambda3__rygel_data_source_done, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda4__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	g_main_loop_run (_data1_->loop);
	_tmp11_ = self->priv->test_data_mapped;
	_tmp12_ = g_mapped_file_get_length (_tmp11_);
	_vala_assert (_data1_->received_bytes == ((guint64) _tmp12_), "received_bytes == this.test_data_mapped.get_length ()");
	_tmp13_ = _data1_->source;
	rygel_data_source_stop (_tmp13_);
	_g_object_unref0 (_data1_->source);
	_data1_->source = NULL;
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		RygelDataSourceTest * self;
		self = _data2_->self;
		_g_main_loop_unref0 (_data2_->loop);
		_g_object_unref0 (_data2_->received_data);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void ___lambda5_ (Block2Data* _data2_, guint8* data, int data_length1) {
	RygelDataSourceTest * self;
	RygelDataPool* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	DataBlock* _tmp2_ = NULL;
	DataBlock* _tmp3_ = NULL;
	self = _data2_->self;
	_tmp0_ = _data2_->received_data;
	_tmp1_ = data;
	_tmp1__length1 = data_length1;
	_tmp2_ = data_block_new (_tmp1_, _tmp1__length1);
	_tmp3_ = _tmp2_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp3_);
	_data_block_unref0 (_tmp3_);
}


static void ____lambda5__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self) {
	___lambda5_ (self, data, data_length1);
}


static void ___lambda6_ (Block2Data* _data2_, RygelDataSource* data) {
	RygelDataSourceTest * self;
	GMainLoop* _tmp0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = _data2_->loop;
	g_main_loop_quit (_tmp0_);
}


static void ____lambda6__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
	___lambda6_ (self, _sender);
}


static void ___lambda7_ (RygelDataSourceTest* self) {
	g_assert_not_reached ();
}


static void ____lambda7__rygel_data_source_error (RygelDataSource* _sender, GError* _error_, gpointer self) {
	___lambda7_ (self);
}


static void ___lambda8_ (Block2Data* _data2_, guint8* data, int data_length1) {
	RygelDataSourceTest * self;
	RygelDataPool* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	DataBlock* _tmp2_ = NULL;
	DataBlock* _tmp3_ = NULL;
	self = _data2_->self;
	_tmp0_ = _data2_->received_data;
	_tmp1_ = data;
	_tmp1__length1 = data_length1;
	_tmp2_ = data_block_new (_tmp1_, _tmp1__length1);
	_tmp3_ = _tmp2_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp3_);
	_data_block_unref0 (_tmp3_);
}


static void ____lambda8__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self) {
	___lambda8_ (self, data, data_length1);
}


static void ___lambda9_ (Block2Data* _data2_, RygelDataSource* data) {
	RygelDataSourceTest * self;
	GMainLoop* _tmp0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = _data2_->loop;
	g_main_loop_quit (_tmp0_);
}


static void ____lambda9__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
	___lambda9_ (self, _sender);
}


static void ___lambda10_ (RygelDataSourceTest* self) {
	g_assert_not_reached ();
}


static void ____lambda10__rygel_data_source_error (RygelDataSource* _sender, GError* _error_, gpointer self) {
	___lambda10_ (self);
}


static void ___lambda11_ (Block2Data* _data2_, guint8* data, int data_length1) {
	RygelDataSourceTest * self;
	RygelDataPool* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	DataBlock* _tmp2_ = NULL;
	DataBlock* _tmp3_ = NULL;
	self = _data2_->self;
	_tmp0_ = _data2_->received_data;
	_tmp1_ = data;
	_tmp1__length1 = data_length1;
	_tmp2_ = data_block_new (_tmp1_, _tmp1__length1);
	_tmp3_ = _tmp2_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp3_);
	_data_block_unref0 (_tmp3_);
}


static void ____lambda11__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self) {
	___lambda11_ (self, data, data_length1);
}


static void ___lambda12_ (Block2Data* _data2_, RygelDataSource* data) {
	RygelDataSourceTest * self;
	GMainLoop* _tmp0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = _data2_->loop;
	g_main_loop_quit (_tmp0_);
}


static void ____lambda12__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
	___lambda12_ (self, _sender);
}


static void ___lambda13_ (RygelDataSourceTest* self) {
	g_assert_not_reached ();
}


static void ____lambda13__rygel_data_source_error (RygelDataSource* _sender, GError* _error_, gpointer self) {
	___lambda13_ (self);
}


static void rygel_data_source_test_test_byte_range_request (RygelDataSourceTest* self) {
	RygelDataSource* source = NULL;
	RygelMediaEngine* _tmp0_ = NULL;
	RygelMediaEngine* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	RygelDataSource* _tmp5_ = NULL;
	RygelDataSource* _tmp6_ = NULL;
	RygelDataSource* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("rygel-media-engine-test.vala:194: test_byte_range_request");
	_tmp0_ = rygel_media_engine_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->test_data_file;
	_tmp3_ = g_file_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = rygel_media_engine_create_data_source (_tmp1_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	source = _tmp6_;
	_tmp7_ = source;
	_vala_assert (_tmp7_ != NULL, "source != null");
	{
		Block2Data* _data2_;
		RygelByteSeek* seek = NULL;
		GMappedFile* _tmp8_ = NULL;
		gsize _tmp9_ = 0UL;
		RygelByteSeek* _tmp10_ = NULL;
		RygelDataPool* _tmp11_ = NULL;
		GMainLoop* _tmp12_ = NULL;
		RygelDataSource* _tmp13_ = NULL;
		RygelDataSource* _tmp14_ = NULL;
		RygelDataSource* _tmp15_ = NULL;
		RygelDataSource* _tmp16_ = NULL;
		RygelByteSeek* _tmp17_ = NULL;
		GMainLoop* _tmp18_ = NULL;
		RygelDataPool* _tmp19_ = NULL;
		guint64 _tmp20_ = 0ULL;
		GMappedFile* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		RygelDataPool* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		guint8* _tmp25_ = NULL;
		RygelDataPool* _tmp26_ = NULL;
		guint64 _tmp27_ = 0ULL;
		GMappedFile* _tmp28_ = NULL;
		gsize _tmp29_ = 0UL;
		GMappedFile* _tmp30_ = NULL;
		gsize _tmp31_ = 0UL;
		GMappedFile* _tmp32_ = NULL;
		gsize _tmp33_ = 0UL;
		RygelByteSeek* _tmp34_ = NULL;
		RygelDataPool* _tmp35_ = NULL;
		GMainLoop* _tmp36_ = NULL;
		RygelMediaEngine* _tmp37_ = NULL;
		RygelMediaEngine* _tmp38_ = NULL;
		GFile* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		RygelDataSource* _tmp42_ = NULL;
		RygelDataSource* _tmp43_ = NULL;
		RygelDataSource* _tmp44_ = NULL;
		RygelDataSource* _tmp45_ = NULL;
		RygelDataSource* _tmp46_ = NULL;
		RygelByteSeek* _tmp47_ = NULL;
		GMainLoop* _tmp48_ = NULL;
		RygelDataPool* _tmp49_ = NULL;
		guint64 _tmp50_ = 0ULL;
		GMappedFile* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		GMappedFile* _tmp53_ = NULL;
		gsize _tmp54_ = 0UL;
		RygelDataPool* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		guint8* _tmp57_ = NULL;
		RygelDataPool* _tmp58_ = NULL;
		guint64 _tmp59_ = 0ULL;
		GMappedFile* _tmp60_ = NULL;
		gsize _tmp61_ = 0UL;
		GMappedFile* _tmp62_ = NULL;
		gsize _tmp63_ = 0UL;
		GMappedFile* _tmp64_ = NULL;
		gsize _tmp65_ = 0UL;
		RygelByteSeek* _tmp66_ = NULL;
		RygelDataPool* _tmp67_ = NULL;
		GMainLoop* _tmp68_ = NULL;
		RygelMediaEngine* _tmp69_ = NULL;
		RygelMediaEngine* _tmp70_ = NULL;
		GFile* _tmp71_ = NULL;
		gchar* _tmp72_ = NULL;
		gchar* _tmp73_ = NULL;
		RygelDataSource* _tmp74_ = NULL;
		RygelDataSource* _tmp75_ = NULL;
		RygelDataSource* _tmp76_ = NULL;
		RygelDataSource* _tmp77_ = NULL;
		RygelDataSource* _tmp78_ = NULL;
		RygelByteSeek* _tmp79_ = NULL;
		GMainLoop* _tmp80_ = NULL;
		RygelDataPool* _tmp81_ = NULL;
		guint64 _tmp82_ = 0ULL;
		GMappedFile* _tmp83_ = NULL;
		gchar* _tmp84_ = NULL;
		GMappedFile* _tmp85_ = NULL;
		gsize _tmp86_ = 0UL;
		RygelDataPool* _tmp87_ = NULL;
		gint _tmp88_ = 0;
		guint8* _tmp89_ = NULL;
		RygelDataPool* _tmp90_ = NULL;
		guint64 _tmp91_ = 0ULL;
		RygelDataSource* _tmp92_ = NULL;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->self = g_object_ref (self);
		_tmp8_ = self->priv->test_data_mapped;
		_tmp9_ = g_mapped_file_get_length (_tmp8_);
		_tmp10_ = rygel_byte_seek_new ((gint64) 0, (gint64) 9, (gint64) _tmp9_);
		seek = _tmp10_;
		_tmp11_ = rygel_data_pool_new ();
		_data2_->received_data = _tmp11_;
		_tmp12_ = g_main_loop_new (NULL, FALSE);
		_data2_->loop = _tmp12_;
		_tmp13_ = source;
		g_signal_connect_data (_tmp13_, "data-available", (GCallback) ____lambda5__rygel_data_source_data_available, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp14_ = source;
		g_signal_connect_data (_tmp14_, "done", (GCallback) ____lambda6__rygel_data_source_done, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp15_ = source;
		g_signal_connect_object (_tmp15_, "error", (GCallback) ____lambda7__rygel_data_source_error, self, 0);
		_tmp16_ = source;
		_tmp17_ = seek;
		rygel_data_source_start (_tmp16_, (RygelHTTPSeek*) _tmp17_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (seek);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			if (g_error_matches (_inner_error_, RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED)) {
				goto __catch3_rygel_data_source_error_seek_failed;
			}
			goto __catch3_g_error;
		}
		_tmp18_ = _data2_->loop;
		g_main_loop_run (_tmp18_);
		_tmp19_ = _data2_->received_data;
		_tmp20_ = rygel_data_pool_total_size (_tmp19_);
		_vala_assert (_tmp20_ == ((guint64) 10), "received_data.total_size () == 10");
		_tmp21_ = self->priv->test_data_mapped;
		_tmp22_ = g_mapped_file_get_contents (_tmp21_);
		_tmp23_ = _data2_->received_data;
		_tmp25_ = rygel_data_pool_flatten (_tmp23_, &_tmp24_);
		_tmp26_ = _data2_->received_data;
		_tmp27_ = rygel_data_pool_total_size (_tmp26_);
		memcmp (_tmp22_, _tmp25_, (gsize) _tmp27_);
		_tmp28_ = self->priv->test_data_mapped;
		_tmp29_ = g_mapped_file_get_length (_tmp28_);
		_tmp30_ = self->priv->test_data_mapped;
		_tmp31_ = g_mapped_file_get_length (_tmp30_);
		_tmp32_ = self->priv->test_data_mapped;
		_tmp33_ = g_mapped_file_get_length (_tmp32_);
		_tmp34_ = rygel_byte_seek_new ((gint64) (_tmp29_ - 10), (gint64) (_tmp31_ - 1), (gint64) _tmp33_);
		_g_object_unref0 (seek);
		seek = _tmp34_;
		_tmp35_ = rygel_data_pool_new ();
		_g_object_unref0 (_data2_->received_data);
		_data2_->received_data = _tmp35_;
		_tmp36_ = g_main_loop_new (NULL, FALSE);
		_g_main_loop_unref0 (_data2_->loop);
		_data2_->loop = _tmp36_;
		_tmp37_ = rygel_media_engine_get_default ();
		_tmp38_ = _tmp37_;
		_tmp39_ = self->priv->test_data_file;
		_tmp40_ = g_file_get_uri (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = rygel_media_engine_create_data_source (_tmp38_, _tmp41_);
		_g_object_unref0 (source);
		source = _tmp42_;
		_g_free0 (_tmp41_);
		_g_object_unref0 (_tmp38_);
		_tmp43_ = source;
		g_signal_connect_data (_tmp43_, "data-available", (GCallback) ____lambda8__rygel_data_source_data_available, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp44_ = source;
		g_signal_connect_data (_tmp44_, "done", (GCallback) ____lambda9__rygel_data_source_done, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp45_ = source;
		g_signal_connect_object (_tmp45_, "error", (GCallback) ____lambda10__rygel_data_source_error, self, 0);
		_tmp46_ = source;
		_tmp47_ = seek;
		rygel_data_source_start (_tmp46_, (RygelHTTPSeek*) _tmp47_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (seek);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			if (g_error_matches (_inner_error_, RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED)) {
				goto __catch3_rygel_data_source_error_seek_failed;
			}
			goto __catch3_g_error;
		}
		_tmp48_ = _data2_->loop;
		g_main_loop_run (_tmp48_);
		_tmp49_ = _data2_->received_data;
		_tmp50_ = rygel_data_pool_total_size (_tmp49_);
		_vala_assert (_tmp50_ == ((guint64) 10), "received_data.total_size () == 10");
		_tmp51_ = self->priv->test_data_mapped;
		_tmp52_ = g_mapped_file_get_contents (_tmp51_);
		_tmp53_ = self->priv->test_data_mapped;
		_tmp54_ = g_mapped_file_get_length (_tmp53_);
		_tmp55_ = _data2_->received_data;
		_tmp57_ = rygel_data_pool_flatten (_tmp55_, &_tmp56_);
		_tmp58_ = _data2_->received_data;
		_tmp59_ = rygel_data_pool_total_size (_tmp58_);
		memcmp (_tmp52_ + (_tmp54_ - 10), _tmp57_, (gsize) _tmp59_);
		_tmp60_ = self->priv->test_data_mapped;
		_tmp61_ = g_mapped_file_get_length (_tmp60_);
		_tmp62_ = self->priv->test_data_mapped;
		_tmp63_ = g_mapped_file_get_length (_tmp62_);
		_tmp64_ = self->priv->test_data_mapped;
		_tmp65_ = g_mapped_file_get_length (_tmp64_);
		_tmp66_ = rygel_byte_seek_new ((gint64) (_tmp61_ / 2), (gint64) ((_tmp63_ / 2) + 9), (gint64) _tmp65_);
		_g_object_unref0 (seek);
		seek = _tmp66_;
		_tmp67_ = rygel_data_pool_new ();
		_g_object_unref0 (_data2_->received_data);
		_data2_->received_data = _tmp67_;
		_tmp68_ = g_main_loop_new (NULL, FALSE);
		_g_main_loop_unref0 (_data2_->loop);
		_data2_->loop = _tmp68_;
		_tmp69_ = rygel_media_engine_get_default ();
		_tmp70_ = _tmp69_;
		_tmp71_ = self->priv->test_data_file;
		_tmp72_ = g_file_get_uri (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = rygel_media_engine_create_data_source (_tmp70_, _tmp73_);
		_g_object_unref0 (source);
		source = _tmp74_;
		_g_free0 (_tmp73_);
		_g_object_unref0 (_tmp70_);
		_tmp75_ = source;
		g_signal_connect_data (_tmp75_, "data-available", (GCallback) ____lambda11__rygel_data_source_data_available, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp76_ = source;
		g_signal_connect_data (_tmp76_, "done", (GCallback) ____lambda12__rygel_data_source_done, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp77_ = source;
		g_signal_connect_object (_tmp77_, "error", (GCallback) ____lambda13__rygel_data_source_error, self, 0);
		_tmp78_ = source;
		_tmp79_ = seek;
		rygel_data_source_start (_tmp78_, (RygelHTTPSeek*) _tmp79_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (seek);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			if (g_error_matches (_inner_error_, RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED)) {
				goto __catch3_rygel_data_source_error_seek_failed;
			}
			goto __catch3_g_error;
		}
		_tmp80_ = _data2_->loop;
		g_main_loop_run (_tmp80_);
		_tmp81_ = _data2_->received_data;
		_tmp82_ = rygel_data_pool_total_size (_tmp81_);
		_vala_assert (_tmp82_ == ((guint64) 10), "received_data.total_size () == 10");
		_tmp83_ = self->priv->test_data_mapped;
		_tmp84_ = g_mapped_file_get_contents (_tmp83_);
		_tmp85_ = self->priv->test_data_mapped;
		_tmp86_ = g_mapped_file_get_length (_tmp85_);
		_tmp87_ = _data2_->received_data;
		_tmp89_ = rygel_data_pool_flatten (_tmp87_, &_tmp88_);
		_tmp90_ = _data2_->received_data;
		_tmp91_ = rygel_data_pool_total_size (_tmp90_);
		memcmp (_tmp84_ + (_tmp86_ / 2), _tmp89_, (gsize) _tmp91_);
		_tmp92_ = source;
		rygel_data_source_stop (_tmp92_);
		_g_object_unref0 (source);
		source = NULL;
		_g_object_unref0 (seek);
		block2_data_unref (_data2_);
		_data2_ = NULL;
	}
	goto __finally3;
	__catch3_rygel_data_source_error_seek_failed:
	{
		GError* seek_error = NULL;
		seek_error = _inner_error_;
		_inner_error_ = NULL;
		g_debug ("rygel-media-engine-test.vala:275: Skipping seek test");
		_g_error_free0 (seek_error);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp93_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp93_ = _error_->message;
		g_warning ("rygel-media-engine-test.vala:277: Failed to test: %s", _tmp93_);
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (source);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (source);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		RygelDataSourceTest * self;
		self = _data3_->self;
		_g_main_loop_unref0 (_data3_->loop);
		_g_object_unref0 (_data3_->pool);
		_g_object_unref0 (_data3_->source);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda14_ (Block3Data* _data3_, guint8* data, int data_length1) {
	RygelDataSourceTest * self;
	guint8* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	DataBlock* _tmp1_ = NULL;
	DataBlock* _tmp2_ = NULL;
	RygelDataSource* _tmp3_ = NULL;
	self = _data3_->self;
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	_tmp1_ = data_block_new (_tmp0_, _tmp0__length1);
	_tmp2_ = _tmp1_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data3_->pool, _tmp2_);
	_data_block_unref0 (_tmp2_);
	_tmp3_ = _data3_->source;
	rygel_data_source_stop (_tmp3_);
}


static void ___lambda14__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self) {
	__lambda14_ (self, data, data_length1);
}


static void __lambda15_ (Block3Data* _data3_, RygelDataSource* data) {
	RygelDataSourceTest * self;
	self = _data3_->self;
	g_return_if_fail (data != NULL);
	g_main_loop_quit (_data3_->loop);
}


static void ___lambda15__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
	__lambda15_ (self, _sender);
}


static gboolean __lambda16_ (Block3Data* _data3_) {
	RygelDataSourceTest * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	{
		RygelDataSource* _tmp0_ = NULL;
		_tmp0_ = _data3_->source;
		rygel_data_source_start (_tmp0_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		result = FALSE;
		return result;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally4:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


static gboolean ___lambda16__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda16_ (self);
	return result;
}


static gboolean __lambda17_ (Block3Data* _data3_) {
	RygelDataSourceTest * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	{
		RygelDataSource* _tmp0_ = NULL;
		_tmp0_ = _data3_->source;
		rygel_data_source_start (_tmp0_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		result = FALSE;
		return result;
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally5:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


static gboolean ___lambda17__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda17_ (self);
	return result;
}


static void rygel_data_source_test_test_stop_start (RygelDataSourceTest* self) {
	Block3Data* _data3_;
	RygelMediaEngine* _tmp0_ = NULL;
	RygelMediaEngine* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	RygelDataSource* _tmp5_ = NULL;
	RygelDataSource* _tmp6_ = NULL;
	RygelDataSource* _tmp7_ = NULL;
	RygelDataPool* _tmp8_ = NULL;
	GMainLoop* _tmp9_ = NULL;
	RygelDataSource* _tmp10_ = NULL;
	RygelDataSource* _tmp11_ = NULL;
	GMappedFile* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	guint8* _tmp15_ = NULL;
	guint64 _tmp16_ = 0ULL;
	RygelDataSource* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	g_debug ("rygel-media-engine-test.vala:285: test_stop_start");
	_tmp0_ = rygel_media_engine_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->test_data_file;
	_tmp3_ = g_file_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = rygel_media_engine_create_data_source (_tmp1_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	_data3_->source = _tmp6_;
	_tmp7_ = _data3_->source;
	_vala_assert (_tmp7_ != NULL, "source != null");
	_tmp8_ = rygel_data_pool_new ();
	_data3_->pool = _tmp8_;
	_tmp9_ = g_main_loop_new (NULL, FALSE);
	_data3_->loop = _tmp9_;
	_tmp10_ = _data3_->source;
	g_signal_connect_data (_tmp10_, "data-available", (GCallback) ___lambda14__rygel_data_source_data_available, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp11_ = _data3_->source;
	g_signal_connect_data (_tmp11_, "done", (GCallback) ___lambda15__rygel_data_source_done, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda16__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	g_main_loop_run (_data3_->loop);
	gee_abstract_collection_clear ((GeeAbstractCollection*) _data3_->pool);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda17__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	g_main_loop_run (_data3_->loop);
	_tmp12_ = self->priv->test_data_mapped;
	_tmp13_ = g_mapped_file_get_contents (_tmp12_);
	_tmp15_ = rygel_data_pool_flatten (_data3_->pool, &_tmp14_);
	_tmp16_ = rygel_data_pool_total_size (_data3_->pool);
	memcmp (_tmp13_, _tmp15_, (gsize) _tmp16_);
	_tmp17_ = _data3_->source;
	rygel_data_source_stop (_tmp17_);
	_g_object_unref0 (_data3_->source);
	_data3_->source = NULL;
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		RygelDataSourceTest * self;
		self = _data4_->self;
		_g_main_loop_unref0 (_data4_->loop);
		_g_object_unref0 (_data4_->source);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda18_ (Block4Data* _data4_) {
	RygelDataSourceTest * self;
	self = _data4_->self;
	g_main_loop_quit (_data4_->loop);
}


static void ___lambda18__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
	__lambda18_ (self);
}


static gboolean __lambda19_ (RygelDataSourceTest* self) {
	gboolean result = FALSE;
	g_assert_not_reached ();
	return result;
}


static gboolean ___lambda19__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda19_ (self);
	return result;
}


static gboolean __lambda20_ (Block4Data* _data4_) {
	RygelDataSourceTest * self;
	gboolean result = FALSE;
	RygelDataSource* _tmp0_ = NULL;
	self = _data4_->self;
	_tmp0_ = _data4_->source;
	rygel_data_source_stop (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda20__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda20_ (self);
	return result;
}


static void rygel_data_source_test_test_freeze_stop (RygelDataSourceTest* self) {
	Block4Data* _data4_;
	RygelMediaEngine* _tmp0_ = NULL;
	RygelMediaEngine* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	RygelDataSource* _tmp5_ = NULL;
	RygelDataSource* _tmp6_ = NULL;
	RygelDataSource* _tmp7_ = NULL;
	RygelDataSource* _tmp9_ = NULL;
	GMainLoop* _tmp10_ = NULL;
	RygelDataSource* _tmp11_ = NULL;
	guint id = 0U;
	guint _tmp12_ = 0U;
	RygelDataSource* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	g_debug ("rygel-media-engine-test.vala:335: test_freeze_stop");
	_tmp0_ = rygel_media_engine_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->test_data_file;
	_tmp3_ = g_file_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = rygel_media_engine_create_data_source (_tmp1_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	_data4_->source = _tmp6_;
	_tmp7_ = _data4_->source;
	_vala_assert (_tmp7_ != NULL, "source != null");
	{
		RygelDataSource* _tmp8_ = NULL;
		_tmp8_ = _data4_->source;
		rygel_data_source_start (_tmp8_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp9_ = _data4_->source;
	rygel_data_source_freeze (_tmp9_);
	_tmp10_ = g_main_loop_new (NULL, FALSE);
	_data4_->loop = _tmp10_;
	_tmp11_ = _data4_->source;
	g_signal_connect_data (_tmp11_, "done", (GCallback) ___lambda18__rygel_data_source_done, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp12_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ___lambda19__gsource_func, g_object_ref (self), g_object_unref);
	id = _tmp12_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda20__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	g_main_loop_run (_data4_->loop);
	g_source_remove (id);
	_tmp13_ = _data4_->source;
	rygel_data_source_stop (_tmp13_);
	_g_object_unref0 (_data4_->source);
	_data4_->source = NULL;
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		RygelDataSourceTest * self;
		self = _data5_->self;
		_g_main_loop_unref0 (_data5_->loop);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda21_ (Block5Data* _data5_) {
	RygelDataSourceTest * self;
	self = _data5_->self;
	if (_data5_->quit) {
		g_main_loop_quit (_data5_->loop);
	} else {
		_data5_->quit = TRUE;
	}
}


static void ___lambda21__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
	__lambda21_ (self);
}


static void __lambda22_ (Block5Data* _data5_) {
	RygelDataSourceTest * self;
	self = _data5_->self;
	if (_data5_->quit) {
		g_main_loop_quit (_data5_->loop);
	} else {
		_data5_->quit = TRUE;
	}
}


static void ___lambda22__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
	__lambda22_ (self);
}


void rygel_data_source_test_test_parallel_streaming (RygelDataSourceTest* self) {
	Block5Data* _data5_;
	RygelDataSource* source1 = NULL;
	RygelMediaEngine* _tmp0_ = NULL;
	RygelMediaEngine* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	RygelDataSource* _tmp5_ = NULL;
	RygelDataSource* _tmp6_ = NULL;
	RygelDataSource* source2 = NULL;
	RygelMediaEngine* _tmp7_ = NULL;
	RygelMediaEngine* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	RygelDataSource* _tmp12_ = NULL;
	RygelDataSource* _tmp13_ = NULL;
	RygelByteSeek* seek = NULL;
	GMappedFile* _tmp14_ = NULL;
	gsize _tmp15_ = 0UL;
	GMappedFile* _tmp16_ = NULL;
	gsize _tmp17_ = 0UL;
	RygelByteSeek* _tmp18_ = NULL;
	GMainLoop* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	g_debug ("rygel-media-engine-test.vala:364: test_parallel_streaming");
	_tmp0_ = rygel_media_engine_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->test_data_file;
	_tmp3_ = g_file_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = rygel_media_engine_create_data_source (_tmp1_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	source1 = _tmp6_;
	_vala_assert (source1 != NULL, "source1 != null");
	_tmp7_ = rygel_media_engine_get_default ();
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->test_data_file;
	_tmp10_ = g_file_get_uri (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = rygel_media_engine_create_data_source (_tmp8_, _tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_object_unref0 (_tmp8_);
	source2 = _tmp13_;
	_vala_assert (source2 != NULL, "source2 != null");
	{
		rygel_data_source_start (source1, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (source2);
		_g_object_unref0 (source1);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = self->priv->test_data_mapped;
	_tmp15_ = g_mapped_file_get_length (_tmp14_);
	_tmp16_ = self->priv->test_data_mapped;
	_tmp17_ = g_mapped_file_get_length (_tmp16_);
	_tmp18_ = rygel_byte_seek_new ((gint64) 0, (gint64) (_tmp15_ / 2), (gint64) _tmp17_);
	seek = _tmp18_;
	_vala_assert (seek != NULL, "seek != null");
	{
		rygel_data_source_start (source2, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (seek);
		_g_object_unref0 (source2);
		_g_object_unref0 (source1);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp19_ = g_main_loop_new (NULL, FALSE);
	_data5_->loop = _tmp19_;
	_data5_->quit = FALSE;
	g_signal_connect_data (source1, "done", (GCallback) ___lambda21__rygel_data_source_done, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	g_signal_connect_data (source2, "done", (GCallback) ___lambda22__rygel_data_source_done, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	g_main_loop_run (_data5_->loop);
	_g_object_unref0 (seek);
	_g_object_unref0 (source2);
	_g_object_unref0 (source1);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


gint rygel_data_source_test_run (RygelDataSourceTest* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	rygel_data_source_test_test_simple_streaming (self);
	rygel_data_source_test_test_byte_range_request (self);
	rygel_data_source_test_test_stop_start (self);
	rygel_data_source_test_test_freeze_stop (self);
	rygel_data_source_test_test_parallel_streaming (self);
	result = 0;
	return result;
}


gint rygel_data_source_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GeeArrayList* configs = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	RygelDataSourceTestConfig* previous_config = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	configs = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	if (_tmp1__length1 > 1) {
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		_tmp2_ = args;
		_tmp2__length1 = args_length1;
		{
			gchar** arg_collection = NULL;
			gint arg_collection_length1 = 0;
			gint _arg_collection_size_ = 0;
			gint arg_it = 0;
			arg_collection = _tmp2_;
			arg_collection_length1 = _tmp2__length1;
			for (arg_it = 0; arg_it < _tmp2__length1; arg_it = arg_it + 1) {
				gchar* _tmp3_ = NULL;
				gchar* arg = NULL;
				_tmp3_ = g_strdup (arg_collection[arg_it]);
				arg = _tmp3_;
				{
					GFile* file = NULL;
					gchar** _tmp4_ = NULL;
					gint _tmp4__length1 = 0;
					const gchar* _tmp5_ = NULL;
					gboolean _tmp6_ = FALSE;
					gchar* path = NULL;
					GFile* _tmp13_ = NULL;
					GFile* _tmp14_ = NULL;
					GFile* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					gchar* engine = NULL;
					GFile* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					GeeArrayList* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					RygelDataSourceTestConfig* _tmp23_ = NULL;
					RygelDataSourceTestConfig* _tmp24_ = NULL;
					_tmp4_ = args;
					_tmp4__length1 = args_length1;
					_tmp5_ = _tmp4_[1];
					_tmp6_ = g_str_has_prefix (_tmp5_, "~");
					if (_tmp6_) {
						gchar** _tmp7_ = NULL;
						gint _tmp7__length1 = 0;
						const gchar* _tmp8_ = NULL;
						GFile* _tmp9_ = NULL;
						_tmp7_ = args;
						_tmp7__length1 = args_length1;
						_tmp8_ = _tmp7_[1];
						_tmp9_ = g_file_parse_name (_tmp8_);
						_g_object_unref0 (file);
						file = _tmp9_;
					} else {
						gchar** _tmp10_ = NULL;
						gint _tmp10__length1 = 0;
						const gchar* _tmp11_ = NULL;
						GFile* _tmp12_ = NULL;
						_tmp10_ = args;
						_tmp10__length1 = args_length1;
						_tmp11_ = _tmp10_[1];
						_tmp12_ = g_file_new_for_commandline_arg (_tmp11_);
						_g_object_unref0 (file);
						file = _tmp12_;
					}
					_tmp13_ = file;
					_tmp14_ = g_file_get_parent (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_file_get_path (_tmp15_);
					_tmp17_ = _tmp16_;
					_g_object_unref0 (_tmp15_);
					path = _tmp17_;
					_tmp18_ = file;
					_tmp19_ = g_file_get_basename (_tmp18_);
					engine = _tmp19_;
					_tmp20_ = configs;
					_tmp21_ = path;
					_tmp22_ = engine;
					_tmp23_ = rygel_data_source_test_config_new (_tmp21_, _tmp22_);
					_tmp24_ = _tmp23_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp24_);
					_g_object_unref0 (_tmp24_);
					_g_free0 (engine);
					_g_free0 (path);
					_g_object_unref0 (file);
					_g_free0 (arg);
				}
			}
		}
	} else {
		gchar** _tmp25_ = NULL;
		gchar** _tmp26_ = NULL;
		_tmp26_ = _tmp25_ = g_strsplit (BUILT_ENGINES, ";", 0);
		{
			gchar** engine_collection = NULL;
			gint engine_collection_length1 = 0;
			gint _engine_collection_size_ = 0;
			gint engine_it = 0;
			engine_collection = _tmp26_;
			engine_collection_length1 = _vala_array_length (_tmp25_);
			for (engine_it = 0; engine_it < _vala_array_length (_tmp25_); engine_it = engine_it + 1) {
				gchar* _tmp27_ = NULL;
				gchar* engine = NULL;
				_tmp27_ = g_strdup (engine_collection[engine_it]);
				engine = _tmp27_;
				{
					gchar* name = NULL;
					const gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
					GeeArrayList* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					RygelDataSourceTestConfig* _tmp35_ = NULL;
					RygelDataSourceTestConfig* _tmp36_ = NULL;
					_tmp28_ = engine;
					_tmp29_ = g_strconcat (_tmp28_, ".", NULL);
					_tmp30_ = _tmp29_;
					_tmp31_ = g_strconcat (_tmp30_, G_MODULE_SUFFIX, NULL);
					_tmp32_ = _tmp31_;
					_g_free0 (_tmp30_);
					name = _tmp32_;
					_tmp33_ = configs;
					_tmp34_ = name;
					_tmp35_ = rygel_data_source_test_config_new (NULL, _tmp34_);
					_tmp36_ = _tmp35_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp36_);
					_g_object_unref0 (_tmp36_);
					_g_free0 (name);
					_g_free0 (engine);
				}
			}
			engine_collection = (_vala_array_free (engine_collection, engine_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	previous_config = NULL;
	{
		GeeArrayList* _config_list = NULL;
		GeeArrayList* _tmp37_ = NULL;
		GeeArrayList* _tmp38_ = NULL;
		gint _config_size = 0;
		GeeArrayList* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		gint _config_index = 0;
		_tmp37_ = configs;
		_tmp38_ = _g_object_ref0 (_tmp37_);
		_config_list = _tmp38_;
		_tmp39_ = _config_list;
		_tmp40_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_config_size = _tmp41_;
		_config_index = -1;
		while (TRUE) {
			gint _tmp42_ = 0;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			RygelDataSourceTestConfig* config = NULL;
			GeeArrayList* _tmp45_ = NULL;
			gint _tmp46_ = 0;
			gpointer _tmp47_ = NULL;
			RygelDataSourceTestConfig* _tmp48_ = NULL;
			RygelDataSourceTestConfig* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
			RygelDataSourceTestConfig* _tmp53_ = NULL;
			RygelDataSourceTestConfig* _tmp54_ = NULL;
			RygelDataSourceTestConfig* _tmp55_ = NULL;
			RygelDataSourceTest* test = NULL;
			RygelDataSourceTest* _tmp56_ = NULL;
			gint _result_ = 0;
			RygelDataSourceTest* _tmp57_ = NULL;
			gint _tmp58_ = 0;
			gint _tmp59_ = 0;
			_tmp42_ = _config_index;
			_config_index = _tmp42_ + 1;
			_tmp43_ = _config_index;
			_tmp44_ = _config_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _config_list;
			_tmp46_ = _config_index;
			_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _tmp46_);
			config = (RygelDataSourceTestConfig*) _tmp47_;
			_tmp48_ = previous_config;
			if (_tmp48_ != NULL) {
				RygelDataSourceTestConfig* _tmp49_ = NULL;
				_tmp49_ = previous_config;
				rygel_data_source_test_config_clear (_tmp49_);
			}
			_tmp50_ = config;
			_tmp51_ = rygel_data_source_test_config_to_string (_tmp50_);
			_tmp52_ = _tmp51_;
			g_debug ("rygel-media-engine-test.vala:451: => Executing tests for config %s", _tmp52_);
			_g_free0 (_tmp52_);
			_tmp53_ = config;
			rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp53_);
			_tmp54_ = config;
			_tmp55_ = _g_object_ref0 (_tmp54_);
			_g_object_unref0 (previous_config);
			previous_config = _tmp55_;
			{
				rygel_media_engine_init (&_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch9_g_error;
				}
			}
			goto __finally9;
			__catch9_g_error:
			{
				GError* _error_ = NULL;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				g_assert_not_reached ();
				_g_error_free0 (_error_);
			}
			__finally9:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				_g_object_unref0 (previous_config);
				_g_object_unref0 (configs);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp56_ = rygel_data_source_test_new ();
			test = _tmp56_;
			_tmp57_ = test;
			_tmp58_ = rygel_data_source_test_run (_tmp57_);
			_result_ = _tmp58_;
			_tmp59_ = _result_;
			if (_tmp59_ != 0) {
				result = _result_;
				_g_object_unref0 (test);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				_g_object_unref0 (previous_config);
				_g_object_unref0 (configs);
				return result;
			}
			_g_object_unref0 (test);
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	result = 0;
	_g_object_unref0 (previous_config);
	_g_object_unref0 (configs);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return rygel_data_source_test_main (argv, argc);
}


static void rygel_data_source_test_class_init (RygelDataSourceTestClass * klass) {
	rygel_data_source_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelDataSourceTestPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_data_source_test_finalize;
}


static void rygel_data_source_test_instance_init (RygelDataSourceTest * self) {
	self->priv = RYGEL_DATA_SOURCE_TEST_GET_PRIVATE (self);
}


static void rygel_data_source_test_finalize (GObject* obj) {
	RygelDataSourceTest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DATA_SOURCE_TEST, RygelDataSourceTest);
	_g_object_unref0 (self->priv->test_data_file);
	_g_mapped_file_unref0 (self->priv->test_data_mapped);
	G_OBJECT_CLASS (rygel_data_source_test_parent_class)->finalize (obj);
}


/**
 * Test a DataSource implementation against the expectations of the interface
 *
 * It is run as part of the test suite but can be used to check arbitrary
 * media engines as well:
 *
 * rygel-media-engine-test /path/to/my/first/custom-rygel-engine.so \
 *                         /path/to/my/second/custom-rygel-engine.so ...
 */
GType rygel_data_source_test_get_type (void) {
	static volatile gsize rygel_data_source_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_data_source_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDataSourceTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_data_source_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDataSourceTest), 0, (GInstanceInitFunc) rygel_data_source_test_instance_init, NULL };
		GType rygel_data_source_test_type_id;
		rygel_data_source_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelDataSourceTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_data_source_test_type_id__volatile, rygel_data_source_test_type_id);
	}
	return rygel_data_source_test_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



