/* rygel-http-time-seek_http-get.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-http-time-seek_http-get.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
typedef struct _RygelHTTPSeekPrivate RygelHTTPSeekPrivate;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;
typedef struct _RygelHTTPTimeSeekPrivate RygelHTTPTimeSeekPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_SEEK_TYPE (rygel_http_seek_type_get_type ())
#define _rygel_client_hacks_unref0(var) ((var == NULL) ? NULL : (var = (rygel_client_hacks_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;

struct _RygelHTTPSeek {
	GObject parent_instance;
	RygelHTTPSeekPrivate * priv;
};

struct _RygelHTTPSeekClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPSeek* self);
};

struct _RygelHTTPTimeSeek {
	RygelHTTPSeek parent_instance;
	RygelHTTPTimeSeekPrivate * priv;
};

struct _RygelHTTPTimeSeekClass {
	RygelHTTPSeekClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* mime_type;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	GeeArrayList* uris;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_TYPE_BYTE,
	RYGEL_HTTP_SEEK_TYPE_TIME
} RygelHTTPSeekType;

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPSeek* seek;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};


static gpointer rygel_http_time_seek_parent_class = NULL;

GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TIME_SEEK_DUMMY_PROPERTY
};
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_error_quark (void);
RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
gpointer rygel_client_hacks_ref (gpointer instance);
void rygel_client_hacks_unref (gpointer instance);
GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_client_hacks (GValue* value, gpointer v_object);
void rygel_value_take_client_hacks (GValue* value, gpointer v_object);
gpointer rygel_value_get_client_hacks (const GValue* value);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
static gboolean rygel_http_time_seek_parse_seconds (const gchar* range_token, gint64* value);
static gboolean rygel_http_time_seek_parse_time (const gchar* range_token, gint64* value);
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, SoupMessage* msg, gint64 start, gint64 stop, gint64 step, gint64 total_length, GError** error);
GType rygel_http_seek_type_get_type (void) G_GNUC_CONST;
void rygel_http_seek_set_seek_type (RygelHTTPSeek* self, RygelHTTPSeekType value);
gboolean rygel_http_time_seek_needed (RygelHTTPGet* request);
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
gpointer rygel_http_get_handler_ref (gpointer instance);
void rygel_http_get_handler_unref (gpointer instance);
GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_http_get_handler (GValue* value, gpointer v_object);
void rygel_value_take_http_get_handler (GValue* value, gpointer v_object);
gpointer rygel_value_get_http_get_handler (const GValue* value);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gboolean rygel_http_time_seek_requested (RygelHTTPGet* request);
static void rygel_http_time_seek_real_add_response_headers (RygelHTTPSeek* base);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
SoupMessage* rygel_http_seek_get_msg (RygelHTTPSeek* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 400 "rygel-http-time-seek_http-get.c"
		glong _tmp4_ = 0L;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 408 "rygel-http-time-seek_http-get.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 420 "rygel-http-time-seek_http-get.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1167 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 445 "rygel-http-time-seek_http-get.c"
		glong _tmp2_ = 0L;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 451 "rygel-http-time-seek_http-get.c"
	} else {
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 455 "rygel-http-time-seek_http-get.c"
	}
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 461 "rygel-http-time-seek_http-get.c"
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 473 "rygel-http-time-seek_http-get.c"
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 483 "rygel-http-time-seek_http-get.c"
	}
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 489 "rygel-http-time-seek_http-get.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 503 "rygel-http-time-seek_http-get.c"
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 513 "rygel-http-time-seek_http-get.c"
	}
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 519 "rygel-http-time-seek_http-get.c"
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 528 "rygel-http-time-seek_http-get.c"
	}
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 548 "rygel-http-time-seek_http-get.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 898 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 898 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 901 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 901 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 575 "rygel-http-time-seek_http-get.c"
		gchar* _tmp4_ = NULL;
#line 902 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 902 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 902 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 583 "rygel-http-time-seek_http-get.c"
	} else {
#line 904 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = -1;
#line 904 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 589 "rygel-http-time-seek_http-get.c"
	}
}


RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error) {
	RygelHTTPTimeSeek * self = NULL;
	gchar* range = NULL;
	gchar** range_tokens = NULL;
	gint range_tokens_length1 = 0;
	gint _range_tokens_size_ = 0;
	gint64 start = 0LL;
	gint64 duration = 0LL;
	RygelHTTPGet* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 stop = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 parsed_value = 0LL;
	gboolean parsing_start = FALSE;
	RygelHTTPGet* _tmp4_ = NULL;
	SoupMessage* _tmp5_ = NULL;
	SoupMessageHeaders* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	RygelHTTPGet* _tmp55_ = NULL;
	SoupMessage* _tmp56_ = NULL;
	gint64 _tmp57_ = 0LL;
	gint64 _tmp58_ = 0LL;
	gint64 _tmp59_ = 0LL;
	GError * _inner_error_ = NULL;
#line 27 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	start = (gint64) 0;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp0_ = request;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->object;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp2_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp1_) : NULL)->duration;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	duration = _tmp2_ * G_TIME_SPAN_SECOND;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp3_ = duration;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	stop = _tmp3_ - G_TIME_SPAN_MILLISECOND;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	parsed_value = (gint64) 0;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	parsing_start = TRUE;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp4_ = request;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp5_ = ((RygelHTTPRequest*) _tmp4_)->msg;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp6_ = _tmp5_->request_headers;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp7_ = soup_message_headers_get_one (_tmp6_, "TimeSeekRange.dlna.org");
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_g_free0 (range);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	range = _tmp8_;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp9_ = range;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	if (_tmp9_ != NULL) {
#line 659 "rygel-http-time-seek_http-get.c"
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar** _tmp17_ = NULL;
		gchar** _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		const gchar* _tmp22_ = NULL;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		gint64 _tmp50_ = 0LL;
		gint64 _tmp51_ = 0LL;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp10_ = range;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp11_ = g_str_has_prefix (_tmp10_, "npt=");
#line 39 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		if (!_tmp11_) {
#line 684 "rygel-http-time-seek_http-get.c"
			const gchar* _tmp12_ = NULL;
			GError* _tmp13_ = NULL;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp12_ = range;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp13_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, "Invalid Range '%s'", _tmp12_);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_inner_error_ = _tmp13_;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				g_propagate_error (error, _inner_error_);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_g_free0 (range);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_g_object_unref0 (self);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				return NULL;
#line 705 "rygel-http-time-seek_http-get.c"
			} else {
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_g_free0 (range);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				g_clear_error (&_inner_error_);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				return NULL;
#line 717 "rygel-http-time-seek_http-get.c"
			}
		}
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp14_ = range;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp15_ = string_substring (_tmp14_, (glong) 4, (glong) (-1));
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp16_ = _tmp15_;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "-", 2);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		range_tokens = _tmp18_;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		range_tokens_length1 = _vala_array_length (_tmp17_);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_range_tokens_size_ = range_tokens_length1;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_g_free0 (_tmp16_);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp21_ = range_tokens;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp21__length1 = range_tokens_length1;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp22_ = _tmp21_[0];
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		if (_tmp22_ == NULL) {
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp20_ = TRUE;
#line 748 "rygel-http-time-seek_http-get.c"
		} else {
			gchar** _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			const gchar* _tmp24_ = NULL;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp23_ = range_tokens;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp23__length1 = range_tokens_length1;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp24_ = _tmp23_[0];
#line 47 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp20_ = g_strcmp0 (_tmp24_, "") == 0;
#line 761 "rygel-http-time-seek_http-get.c"
		}
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp25_ = _tmp20_;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		if (_tmp25_) {
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp19_ = TRUE;
#line 769 "rygel-http-time-seek_http-get.c"
		} else {
			gchar** _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			const gchar* _tmp27_ = NULL;
#line 48 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp26_ = range_tokens;
#line 48 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp26__length1 = range_tokens_length1;
#line 48 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp27_ = _tmp26_[1];
#line 48 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp19_ = _tmp27_ == NULL;
#line 782 "rygel-http-time-seek_http-get.c"
		}
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp28_ = _tmp19_;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		if (_tmp28_) {
#line 788 "rygel-http-time-seek_http-get.c"
			const gchar* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			GError* _tmp31_ = NULL;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp29_ = _ ("Invalid Range '%s'");
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp30_ = range;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp31_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp29_, _tmp30_);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_inner_error_ = _tmp31_;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				g_propagate_error (error, _inner_error_);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_g_free0 (range);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_g_object_unref0 (self);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				return NULL;
#line 812 "rygel-http-time-seek_http-get.c"
			} else {
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_g_free0 (range);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				g_clear_error (&_inner_error_);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				return NULL;
#line 824 "rygel-http-time-seek_http-get.c"
			}
		}
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp32_ = range_tokens;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp32__length1 = range_tokens_length1;
#line 831 "rygel-http-time-seek_http-get.c"
		{
			gchar** range_token_collection = NULL;
			gint range_token_collection_length1 = 0;
			gint _range_token_collection_size_ = 0;
			gint range_token_it = 0;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			range_token_collection = _tmp32_;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			range_token_collection_length1 = _tmp32__length1;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			for (range_token_it = 0; range_token_it < _tmp32__length1; range_token_it = range_token_it + 1) {
#line 843 "rygel-http-time-seek_http-get.c"
				gchar* _tmp33_ = NULL;
				gchar* range_token = NULL;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_tmp33_ = g_strdup (range_token_collection[range_token_it]);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				range_token = _tmp33_;
#line 850 "rygel-http-time-seek_http-get.c"
				{
					const gchar* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					gint _tmp36_ = 0;
					gboolean _tmp47_ = FALSE;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp34_ = range_token;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					if (g_strcmp0 (_tmp34_, "") == 0) {
#line 55 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
						_g_free0 (range_token);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
						continue;
#line 864 "rygel-http-time-seek_http-get.c"
					}
#line 58 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp35_ = range_token;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp36_ = string_index_of (_tmp35_, ":", 0);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					if (_tmp36_ == (-1)) {
#line 872 "rygel-http-time-seek_http-get.c"
						const gchar* _tmp37_ = NULL;
						gboolean _tmp38_ = FALSE;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
						_tmp37_ = range_token;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
						_tmp38_ = rygel_http_time_seek_parse_seconds (_tmp37_, &parsed_value);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
						if (!_tmp38_) {
#line 881 "rygel-http-time-seek_http-get.c"
							const gchar* _tmp39_ = NULL;
							const gchar* _tmp40_ = NULL;
							GError* _tmp41_ = NULL;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
							_tmp39_ = _ ("Invalid Range '%s'");
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
							_tmp40_ = range;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
							_tmp41_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp39_, _tmp40_);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
							_inner_error_ = _tmp41_;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
							if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								g_propagate_error (error, _inner_error_);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								_g_free0 (range_token);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								_g_free0 (range);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								_g_object_unref0 (self);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								return NULL;
#line 907 "rygel-http-time-seek_http-get.c"
							} else {
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								_g_free0 (range_token);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								_g_free0 (range);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								g_clear_error (&_inner_error_);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								return NULL;
#line 921 "rygel-http-time-seek_http-get.c"
							}
						}
					} else {
						const gchar* _tmp42_ = NULL;
						gboolean _tmp43_ = FALSE;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
						_tmp42_ = range_token;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
						_tmp43_ = rygel_http_time_seek_parse_time (_tmp42_, &parsed_value);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
						if (!_tmp43_) {
#line 933 "rygel-http-time-seek_http-get.c"
							const gchar* _tmp44_ = NULL;
							const gchar* _tmp45_ = NULL;
							GError* _tmp46_ = NULL;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
							_tmp44_ = _ ("Invalid Range '%s'");
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
							_tmp45_ = range;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
							_tmp46_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp44_, _tmp45_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
							_inner_error_ = _tmp46_;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
							if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								g_propagate_error (error, _inner_error_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								_g_free0 (range_token);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								_g_free0 (range);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								_g_object_unref0 (self);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								return NULL;
#line 959 "rygel-http-time-seek_http-get.c"
							} else {
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								_g_free0 (range_token);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								_g_free0 (range);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								g_clear_error (&_inner_error_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
								return NULL;
#line 973 "rygel-http-time-seek_http-get.c"
							}
						}
					}
#line 73 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp47_ = parsing_start;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					if (_tmp47_) {
#line 981 "rygel-http-time-seek_http-get.c"
						gint64 _tmp48_ = 0LL;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
						parsing_start = FALSE;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
						_tmp48_ = parsed_value;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
						start = _tmp48_;
#line 989 "rygel-http-time-seek_http-get.c"
					} else {
						gint64 _tmp49_ = 0LL;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
						_tmp49_ = parsed_value;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
						stop = _tmp49_;
#line 996 "rygel-http-time-seek_http-get.c"
					}
#line 53 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_g_free0 (range_token);
#line 1000 "rygel-http-time-seek_http-get.c"
				}
			}
		}
#line 81 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp50_ = start;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp51_ = stop;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		if (_tmp50_ > _tmp51_) {
#line 1010 "rygel-http-time-seek_http-get.c"
			const gchar* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			GError* _tmp54_ = NULL;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp52_ = _ ("Invalid Range '%s'");
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp53_ = range;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp54_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp52_, _tmp53_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_inner_error_ = _tmp54_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				g_propagate_error (error, _inner_error_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_g_free0 (range);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_g_object_unref0 (self);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				return NULL;
#line 1034 "rygel-http-time-seek_http-get.c"
			} else {
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_g_free0 (range);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				g_clear_error (&_inner_error_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				return NULL;
#line 1046 "rygel-http-time-seek_http-get.c"
			}
		}
	}
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp55_ = request;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp56_ = ((RygelHTTPRequest*) _tmp55_)->msg;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp57_ = start;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp58_ = stop;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp59_ = duration;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	self = (RygelHTTPTimeSeek*) rygel_http_seek_construct (object_type, _tmp56_, _tmp57_, _tmp58_ - 1, (gint64) G_TIME_SPAN_MILLISECOND, _tmp59_, &_inner_error_);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	if (_inner_error_ != NULL) {
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			g_propagate_error (error, _inner_error_);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_g_free0 (range);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_g_object_unref0 (self);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			return NULL;
#line 1076 "rygel-http-time-seek_http-get.c"
		} else {
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_g_free0 (range);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			g_clear_error (&_inner_error_);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			return NULL;
#line 1088 "rygel-http-time-seek_http-get.c"
		}
	}
#line 89 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	rygel_http_seek_set_seek_type ((RygelHTTPSeek*) self, RYGEL_HTTP_SEEK_TYPE_TIME);
#line 27 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 27 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_g_free0 (range);
#line 27 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	return self;
#line 1099 "rygel-http-time-seek_http-get.c"
}


RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error) {
#line 27 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	return rygel_http_time_seek_construct (RYGEL_TYPE_HTTP_TIME_SEEK, request, error);
#line 1106 "rygel-http-time-seek_http-get.c"
}


gboolean rygel_http_time_seek_needed (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gboolean force_seek = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp30_ = FALSE;
	GError * _inner_error_ = NULL;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	force_seek = FALSE;
#line 1121 "rygel-http-time-seek_http-get.c"
	{
		RygelClientHacks* hack = NULL;
		RygelHTTPGet* _tmp0_ = NULL;
		SoupMessage* _tmp1_ = NULL;
		RygelClientHacks* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp0_ = request;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp2_ = rygel_client_hacks_create (_tmp1_, &_inner_error_);
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		hack = _tmp2_;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		if (_inner_error_ != NULL) {
#line 1138 "rygel-http-time-seek_http-get.c"
			goto __catch8_g_error;
		}
#line 97 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp3_ = rygel_client_hacks_force_seek (hack);
#line 97 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		force_seek = _tmp3_;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_rygel_client_hacks_unref0 (hack);
#line 1147 "rygel-http-time-seek_http-get.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* _error_ = NULL;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_error_ = _inner_error_;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_inner_error_ = NULL;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_g_error_free0 (_error_);
#line 1159 "rygel-http-time-seek_http-get.c"
	}
	__finally8:
#line 95 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	if (_inner_error_ != NULL) {
#line 95 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		g_clear_error (&_inner_error_);
#line 95 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		return FALSE;
#line 1170 "rygel-http-time-seek_http-get.c"
	}
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp5_ = force_seek;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	if (_tmp5_) {
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp4_ = TRUE;
#line 1178 "rygel-http-time-seek_http-get.c"
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		RygelHTTPGet* _tmp8_ = NULL;
		RygelMediaObject* _tmp9_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp29_ = FALSE;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp8_ = request;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp9_ = ((RygelHTTPRequest*) _tmp8_)->object;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, RYGEL_TYPE_AUDIO_ITEM)) {
#line 1192 "rygel-http-time-seek_http-get.c"
			RygelHTTPGet* _tmp10_ = NULL;
			RygelMediaObject* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp10_ = request;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp11_ = ((RygelHTTPRequest*) _tmp10_)->object;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp12_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp11_) : NULL)->duration;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp7_ = _tmp12_ > ((gint64) 0);
#line 1204 "rygel-http-time-seek_http-get.c"
		} else {
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp7_ = FALSE;
#line 1208 "rygel-http-time-seek_http-get.c"
		}
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp13_ = _tmp7_;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		if (_tmp13_) {
#line 1214 "rygel-http-time-seek_http-get.c"
			gboolean _tmp14_ = FALSE;
			RygelHTTPGet* _tmp15_ = NULL;
			RygelHTTPGetHandler* _tmp16_ = NULL;
			gboolean _tmp28_ = FALSE;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp15_ = request;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp16_ = _tmp15_->handler;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_HTTP_TRANSCODE_HANDLER)) {
#line 102 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_tmp14_ = TRUE;
#line 1227 "rygel-http-time-seek_http-get.c"
			} else {
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				RygelHTTPGet* _tmp19_ = NULL;
				RygelThumbnail* _tmp20_ = NULL;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp27_ = FALSE;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_tmp19_ = request;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_tmp20_ = _tmp19_->thumbnail;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				if (_tmp20_ == NULL) {
#line 1241 "rygel-http-time-seek_http-get.c"
					RygelHTTPGet* _tmp21_ = NULL;
					RygelSubtitle* _tmp22_ = NULL;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp21_ = request;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp22_ = _tmp21_->subtitle;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp18_ = _tmp22_ == NULL;
#line 1250 "rygel-http-time-seek_http-get.c"
				} else {
#line 103 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp18_ = FALSE;
#line 1254 "rygel-http-time-seek_http-get.c"
				}
#line 103 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_tmp23_ = _tmp18_;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				if (_tmp23_) {
#line 1260 "rygel-http-time-seek_http-get.c"
					RygelHTTPGet* _tmp24_ = NULL;
					RygelMediaObject* _tmp25_ = NULL;
					gboolean _tmp26_ = FALSE;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp24_ = request;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp25_ = ((RygelHTTPRequest*) _tmp24_)->object;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp26_ = rygel_media_item_is_live_stream (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp25_) : NULL);
#line 105 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp17_ = _tmp26_;
#line 1272 "rygel-http-time-seek_http-get.c"
				} else {
#line 103 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp17_ = FALSE;
#line 1276 "rygel-http-time-seek_http-get.c"
				}
#line 103 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_tmp27_ = _tmp17_;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_tmp14_ = _tmp27_;
#line 1282 "rygel-http-time-seek_http-get.c"
			}
#line 102 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp28_ = _tmp14_;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp6_ = _tmp28_;
#line 1288 "rygel-http-time-seek_http-get.c"
		} else {
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp6_ = FALSE;
#line 1292 "rygel-http-time-seek_http-get.c"
		}
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp29_ = _tmp6_;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp4_ = _tmp29_;
#line 1298 "rygel-http-time-seek_http-get.c"
	}
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp30_ = _tmp4_;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	result = _tmp30_;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	return result;
#line 1306 "rygel-http-time-seek_http-get.c"
}


gboolean rygel_http_time_seek_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp0_ = request;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp2_ = _tmp1_->request_headers;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp3_ = soup_message_headers_get_one (_tmp2_, "TimeSeekRange.dlna.org");
#line 109 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	result = _tmp3_ != NULL;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	return result;
#line 1330 "rygel-http-time-seek_http-get.c"
}


static void rygel_http_time_seek_real_add_response_headers (RygelHTTPSeek* base) {
	RygelHTTPTimeSeek * self;
	gdouble start = 0.0;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gdouble stop = 0.0;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gdouble total = 0.0;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gchar* start_str = NULL;
	gchar* _tmp6_ = NULL;
	gint start_str_length1 = 0;
	gint _start_str_size_ = 0;
	gchar* stop_str = NULL;
	gchar* _tmp7_ = NULL;
	gint stop_str_length1 = 0;
	gint _stop_str_size_ = 0;
	gchar* total_str = NULL;
	gchar* _tmp8_ = NULL;
	gint total_str_length1 = 0;
	gint _total_str_size_ = 0;
	gchar* range = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	SoupMessage* _tmp22_ = NULL;
	SoupMessage* _tmp23_ = NULL;
	SoupMessageHeaders* _tmp24_ = NULL;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	self = (RygelHTTPTimeSeek*) base;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp0_ = rygel_http_seek_get_start ((RygelHTTPSeek*) self);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp1_ = _tmp0_;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	start = ((gdouble) _tmp1_) / G_TIME_SPAN_SECOND;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp2_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) self);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp3_ = _tmp2_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	stop = ((gdouble) _tmp3_) / G_TIME_SPAN_SECOND;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp4_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) self);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp5_ = _tmp4_;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	total = ((gdouble) _tmp5_) / G_TIME_SPAN_SECOND;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp6_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	start_str = _tmp6_;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	start_str_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_start_str_size_ = start_str_length1;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp7_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 120 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	stop_str = _tmp7_;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	stop_str_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_stop_str_size_ = stop_str_length1;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp8_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 121 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	total_str = _tmp8_;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	total_str_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_total_str_size_ = total_str_length1;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp9_ = g_ascii_formatd (start_str, start_str_length1, "%.3f", start);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp10_ = g_strconcat ("npt=", _tmp9_, NULL);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp11_ = _tmp10_;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp12_ = g_strconcat (_tmp11_, "-", NULL);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp13_ = _tmp12_;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp14_ = g_ascii_formatd (stop_str, stop_str_length1, "%.3f", stop);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp15_ = g_strconcat (_tmp13_, _tmp14_, NULL);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp16_ = _tmp15_;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp17_ = g_strconcat (_tmp16_, "/", NULL);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp18_ = _tmp17_;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp19_ = g_ascii_formatd (total_str, total_str_length1, "%.3f", total);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp21_ = _tmp20_;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_g_free0 (_tmp18_);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_g_free0 (_tmp16_);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_g_free0 (_tmp13_);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_g_free0 (_tmp11_);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	range = _tmp21_;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp22_ = rygel_http_seek_get_msg ((RygelHTTPSeek*) self);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp23_ = _tmp22_;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp24_ = _tmp23_->response_headers;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	soup_message_headers_append (_tmp24_, "TimeSeekRange.dlna.org", range);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_g_free0 (range);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	total_str = (g_free (total_str), NULL);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	stop_str = (g_free (stop_str), NULL);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	start_str = (g_free (start_str), NULL);
#line 1470 "rygel-http-time-seek_http-get.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 965 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 1488 "rygel-http-time-seek_http-get.c"
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 787 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0.0);
#line 788 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 788 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
#line 788 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 788 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 1506 "rygel-http-time-seek_http-get.c"
}


static gboolean rygel_http_time_seek_parse_seconds (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
	gboolean _tmp2_ = FALSE;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	g_return_val_if_fail (range_token != NULL, FALSE);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp0_ = range_token;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp1_ = string_get (_tmp0_, (glong) 0);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp2_ = g_ascii_isdigit (_tmp1_);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	if (_tmp2_) {
#line 1525 "rygel-http-time-seek_http-get.c"
		const gchar* _tmp3_ = NULL;
		gdouble _tmp4_ = 0.0;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp3_ = range_token;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp4_ = double_parse (_tmp3_);
#line 134 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		*value = (gint64) (_tmp4_ * G_TIME_SPAN_SECOND);
#line 1534 "rygel-http-time-seek_http-get.c"
	} else {
#line 136 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		result = FALSE;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		return result;
#line 1540 "rygel-http-time-seek_http-get.c"
	}
#line 138 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	result = TRUE;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	return result;
#line 1546 "rygel-http-time-seek_http-get.c"
}


static gboolean rygel_http_time_seek_parse_time (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	gint64 seconds_sum = 0LL;
	gint time_factor = 0;
	gchar** time_tokens = NULL;
	gint time_tokens_length1 = 0;
	gint _time_tokens_size_ = 0;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint64 _tmp23_ = 0LL;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	g_return_val_if_fail (range_token != NULL, FALSE);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	seconds_sum = (gint64) 0;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	time_factor = 0;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	seconds_sum = (gint64) 0;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	time_factor = 3600;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp0_ = range_token;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ":", 3);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	time_tokens = _tmp2_;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	time_tokens_length1 = _vala_array_length (_tmp1_);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_time_tokens_size_ = time_tokens_length1;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp5_ = time_tokens;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp5__length1 = time_tokens_length1;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp6_ = _tmp5_[0];
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	if (_tmp6_ == NULL) {
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp4_ = TRUE;
#line 1602 "rygel-http-time-seek_http-get.c"
	} else {
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		const gchar* _tmp8_ = NULL;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp7_ = time_tokens;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp7__length1 = time_tokens_length1;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp8_ = _tmp7_[1];
#line 153 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp4_ = _tmp8_ == NULL;
#line 1615 "rygel-http-time-seek_http-get.c"
	}
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp9_ = _tmp4_;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	if (_tmp9_) {
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp3_ = TRUE;
#line 1623 "rygel-http-time-seek_http-get.c"
	} else {
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		const gchar* _tmp11_ = NULL;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp10_ = time_tokens;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp10__length1 = time_tokens_length1;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp11_ = _tmp10_[2];
#line 154 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		_tmp3_ = _tmp11_ == NULL;
#line 1636 "rygel-http-time-seek_http-get.c"
	}
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp12_ = _tmp3_;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	if (_tmp12_) {
#line 155 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		result = FALSE;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 155 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		return result;
#line 1648 "rygel-http-time-seek_http-get.c"
	}
#line 158 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp13_ = time_tokens;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp13__length1 = time_tokens_length1;
#line 1654 "rygel-http-time-seek_http-get.c"
	{
		gchar** time_collection = NULL;
		gint time_collection_length1 = 0;
		gint _time_collection_size_ = 0;
		gint time_it = 0;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		time_collection = _tmp13_;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		time_collection_length1 = _tmp13__length1;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
		for (time_it = 0; time_it < _tmp13__length1; time_it = time_it + 1) {
#line 1666 "rygel-http-time-seek_http-get.c"
			gchar* _tmp14_ = NULL;
			gchar* time = NULL;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			_tmp14_ = g_strdup (time_collection[time_it]);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
			time = _tmp14_;
#line 1673 "rygel-http-time-seek_http-get.c"
			{
				const gchar* _tmp15_ = NULL;
				gchar _tmp16_ = '\0';
				gboolean _tmp17_ = FALSE;
				gint _tmp22_ = 0;
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_tmp15_ = time;
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_tmp16_ = string_get (_tmp15_, (glong) 0);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_tmp17_ = g_ascii_isdigit (_tmp16_);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				if (_tmp17_) {
#line 1687 "rygel-http-time-seek_http-get.c"
					gint64 _tmp18_ = 0LL;
					const gchar* _tmp19_ = NULL;
					gdouble _tmp20_ = 0.0;
					gint _tmp21_ = 0;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp18_ = seconds_sum;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp19_ = time;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp20_ = double_parse (_tmp19_);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_tmp21_ = time_factor;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					seconds_sum = _tmp18_ + ((gint64) ((_tmp20_ * G_TIME_SPAN_SECOND) * _tmp21_));
#line 1702 "rygel-http-time-seek_http-get.c"
				} else {
#line 163 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					result = FALSE;
#line 163 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					_g_free0 (time);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
					return result;
#line 1712 "rygel-http-time-seek_http-get.c"
				}
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_tmp22_ = time_factor;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				time_factor = _tmp22_ / 60;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
				_g_free0 (time);
#line 1720 "rygel-http-time-seek_http-get.c"
			}
		}
	}
#line 167 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	_tmp23_ = seconds_sum;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	*value = _tmp23_;
#line 169 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	result = TRUE;
#line 169 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 169 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	return result;
#line 1734 "rygel-http-time-seek_http-get.c"
}


static void rygel_http_time_seek_class_init (RygelHTTPTimeSeekClass * klass) {
#line 26 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	rygel_http_time_seek_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/jens/Source/rygel/tests/rygel-http-time-seek_http-get.vala"
	RYGEL_HTTP_SEEK_CLASS (klass)->add_response_headers = rygel_http_time_seek_real_add_response_headers;
#line 1743 "rygel-http-time-seek_http-get.c"
}


static void rygel_http_time_seek_instance_init (RygelHTTPTimeSeek * self) {
}


GType rygel_http_time_seek_get_type (void) {
	static volatile gsize rygel_http_time_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeek), 0, (GInstanceInitFunc) rygel_http_time_seek_instance_init, NULL };
		GType rygel_http_time_seek_type_id;
		rygel_http_time_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelHTTPTimeSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_type_id__volatile, rygel_http_time_seek_type_id);
	}
	return rygel_http_time_seek_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



