/* rygel-http-server.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-http-server.vala, do not modify */

/*
 * Copyright (C) 2008, 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <gio/gio.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;
typedef struct _RygelHttpServerRunData RygelHttpServerRunData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_POST (rygel_http_post_get_type ())
#define RYGEL_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPost))
#define RYGEL_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))
#define RYGEL_IS_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST))
#define RYGEL_IS_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST))
#define RYGEL_HTTP_POST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))

typedef struct _RygelHTTPPost RygelHTTPPost;
typedef struct _RygelHTTPPostClass RygelHTTPPostClass;

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};

struct _RygelHTTPServerPrivate {
	gchar* _path_root;
	GeeArrayList* requests;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

struct _RygelHttpServerRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPServer* self;
	GUPnPContext* _tmp0_;
	SoupServer* _tmp1_;
	SoupServer* _tmp2_;
	const gchar* _tmp3_;
	GUPnPContext* _tmp4_;
	SoupServer* _tmp5_;
	SoupServer* _tmp6_;
	GUPnPContext* _tmp7_;
	SoupServer* _tmp8_;
	SoupServer* _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
	GCancellable* _tmp12_;
	GCancellable* _tmp13_;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_http_server_parent_class = NULL;
static RygelStateMachineIface* rygel_http_server_rygel_state_machine_parent_iface = NULL;

GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerPrivate))
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT,
	RYGEL_HTTP_SERVER_CANCELLABLE
};
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
RygelHTTPServer* rygel_http_server_new (RygelContentDirectory* content_dir, const gchar* name);
RygelHTTPServer* rygel_http_server_construct (GType object_type, RygelContentDirectory* content_dir, const gchar* name);
RygelTranscodeManager* rygel_transcode_manager_construct (GType object_type);
static void rygel_http_server_set_path_root (RygelHTTPServer* self, const gchar* value);
static void rygel_http_server_real_run_data_free (gpointer _data);
static void rygel_http_server_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_server_real_run_co (RygelHttpServerRunData* _data_);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
static void rygel_http_server_server_handler (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* server_path, GHashTable* query, SoupClientContext* soup_client);
static void _rygel_http_server_server_handler_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self);
static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client);
static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self);
static void rygel_http_server_on_request_started (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client);
static void _rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self);
static void rygel_http_server_on_cancelled (RygelHTTPServer* self, GCancellable* cancellable);
static void _rygel_http_server_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self);
void rygel_http_server_add_proxy_resource (RygelHTTPServer* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
static gboolean rygel_http_server_http_uri_present (RygelHTTPServer* self, RygelMediaItem* item);
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
GUPnPDIDLLiteResource* rygel_media_object_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const gchar* uri);
GType rygel_serializer_get_type (void) G_GNUC_CONST;
static gchar* rygel_http_server_real_create_uri_for_item (RygelTranscodeManager* base, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static gchar* rygel_http_server_real_get_protocol (RygelTranscodeManager* base);
static GeeArrayList* rygel_http_server_real_get_protocol_info (RygelTranscodeManager* base);
GeeArrayList* rygel_transcode_manager_get_protocol_info (RygelTranscodeManager* self);
static void rygel_http_server_on_request_completed (RygelHTTPServer* self, RygelStateMachine* machine);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
static void __lambda10_ (RygelHTTPServer* self, const gchar* name, const gchar* value);
static void ___lambda10__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self);
static void rygel_http_server_queue_request (RygelHTTPServer* self, RygelHTTPRequest* request);
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
static void rygel_http_server_on_got_headers (RygelHTTPServer* self, SoupMessage* msg);
static void _rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender, gpointer self);
RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_http_post_get_type (void) G_GNUC_CONST;
static void _rygel_http_server_on_request_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	return self ? g_object_ref (self) : NULL;
#line 340 "rygel-http-server.c"
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, RygelContentDirectory* content_dir, const gchar* name) {
	RygelHTTPServer * self = NULL;
	RygelContentDirectory* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	RygelContentDirectory* _tmp3_ = NULL;
	GUPnPContext* _tmp4_ = NULL;
	GUPnPContext* _tmp5_ = NULL;
	GUPnPContext* _tmp6_ = NULL;
	GeeArrayList* _tmp7_ = NULL;
	RygelContentDirectory* _tmp8_ = NULL;
	GCancellable* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	self = (RygelHTTPServer*) rygel_transcode_manager_construct (object_type);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = content_dir;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp1_ = _tmp0_->root_container;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_object_unref0 (self->root_container);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	self->root_container = _tmp2_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp3_ = content_dir;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp4_ = gupnp_service_info_get_context ((GUPnPServiceInfo*) _tmp3_);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp5_ = _tmp4_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_object_unref0 (self->context);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	self->context = _tmp6_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp7_ = gee_array_list_new (RYGEL_TYPE_HTTP_REQUEST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_object_unref0 (self->priv->requests);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	self->priv->requests = _tmp7_;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp8_ = content_dir;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp9_ = _tmp8_->cancellable;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp9_);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp10_ = name;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp11_ = g_strconcat ("/", _tmp10_, NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp12_ = _tmp11_;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	rygel_http_server_set_path_root (self, _tmp12_);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_free0 (_tmp12_);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	return self;
#line 411 "rygel-http-server.c"
}


RygelHTTPServer* rygel_http_server_new (RygelContentDirectory* content_dir, const gchar* name) {
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, content_dir, name);
#line 418 "rygel-http-server.c"
}


static void rygel_http_server_real_run_data_free (gpointer _data) {
	RygelHttpServerRunData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_slice_free (RygelHttpServerRunData, _data_);
#line 429 "rygel-http-server.c"
}


static void rygel_http_server_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPServer * self;
	RygelHttpServerRunData* _data_;
	RygelHTTPServer* _tmp0_ = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	self = (RygelHTTPServer*) base;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_ = g_slice_new0 (RygelHttpServerRunData);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_server_real_run);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_server_real_run_data_free);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	rygel_http_server_real_run_co (_data_);
#line 451 "rygel-http-server.c"
}


static void rygel_http_server_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpServerRunData* _data_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 459 "rygel-http-server.c"
}


static void _rygel_http_server_server_handler_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self) {
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	rygel_http_server_server_handler (self, server, msg, path, query, client);
#line 466 "rygel-http-server.c"
}


static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self) {
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	rygel_http_server_on_request_aborted (self, _sender, msg, client);
#line 473 "rygel-http-server.c"
}


static void _rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self) {
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	rygel_http_server_on_request_started (self, _sender, msg, client);
#line 480 "rygel-http-server.c"
}


static void _rygel_http_server_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	rygel_http_server_on_cancelled (self, _sender);
#line 487 "rygel-http-server.c"
}


static gboolean rygel_http_server_real_run_co (RygelHttpServerRunData* _data_) {
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	switch (_data_->_state_) {
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		case 0:
#line 496 "rygel-http-server.c"
		goto _state_0;
		default:
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		g_assert_not_reached ();
#line 501 "rygel-http-server.c"
	}
	_state_0:
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp0_ = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp0_ = _data_->self->context;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp1_ = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp1_ = gupnp_context_get_server (_data_->_tmp0_);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp2_ = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp3_ = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp3_ = _data_->self->priv->_path_root;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	soup_server_add_handler (_data_->_tmp2_, _data_->_tmp3_, _rygel_http_server_server_handler_soup_server_callback, g_object_ref (_data_->self), g_object_unref);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp4_ = NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp4_ = _data_->self->context;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp5_ = NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp5_ = gupnp_context_get_server (_data_->_tmp4_);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp6_ = NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_signal_connect_object (_data_->_tmp6_, "request-aborted", (GCallback) _rygel_http_server_on_request_aborted_soup_server_request_aborted, _data_->self, 0);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp7_ = NULL;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp7_ = _data_->self->context;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp8_ = NULL;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp8_ = gupnp_context_get_server (_data_->_tmp7_);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp9_ = NULL;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_signal_connect_object (_data_->_tmp9_, "request-started", (GCallback) _rygel_http_server_on_request_started_soup_server_request_started, _data_->self, 0);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp10_ = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp10_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp11_ = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	if (_data_->_tmp11_ != NULL) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_data_->_tmp12_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_data_->_tmp12_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_data_->_tmp13_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_data_->_tmp13_ = _data_->_tmp12_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		g_signal_connect_object (_data_->_tmp13_, "cancelled", (GCallback) _rygel_http_server_on_cancelled_g_cancellable_cancelled, _data_->self, 0);
#line 570 "rygel-http-server.c"
	}
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	if (_data_->_state_ == 0) {
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 576 "rygel-http-server.c"
	} else {
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 580 "rygel-http-server.c"
	}
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_object_unref (_data_->_async_result);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	return FALSE;
#line 586 "rygel-http-server.c"
}


void rygel_http_server_add_proxy_resource (RygelHTTPServer* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error) {
	RygelMediaItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* uri = NULL;
	RygelMediaItem* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelMediaItem* _tmp4_ = NULL;
	GUPnPDIDLLiteItem* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GUPnPDIDLLiteResource* _tmp10_ = NULL;
	GUPnPDIDLLiteResource* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (didl_item != NULL);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (item != NULL);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = item;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp1_ = rygel_http_server_http_uri_present (self, _tmp0_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	if (_tmp1_) {
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		return;
#line 619 "rygel-http-server.c"
	}
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp2_ = item;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp3_ = rygel_transcode_manager_create_uri_for_item ((RygelTranscodeManager*) self, _tmp2_, -1, -1, NULL, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	uri = _tmp3_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp4_ = item;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp5_ = didl_item;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp6_ = uri;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp7_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) self);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp8_ = _tmp7_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp9_ = uri;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp10_ = rygel_media_object_add_resource ((RygelMediaObject*) _tmp4_, (GUPnPDIDLLiteObject*) _tmp5_, _tmp6_, _tmp8_, _tmp9_, &_inner_error_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp11_ = _tmp10_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_object_unref0 (_tmp11_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_free0 (_tmp8_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	if (_inner_error_ != NULL) {
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		g_propagate_error (error, _inner_error_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_g_free0 (uri);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		return;
#line 655 "rygel-http-server.c"
	}
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_free0 (uri);
#line 659 "rygel-http-server.c"
}


gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const gchar* uri) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_val_if_fail (uri != NULL, FALSE);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = uri;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp1_ = g_uri_parse_scheme (_tmp0_);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp2_ = _tmp1_;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp3_ = g_strcmp0 (_tmp2_, "http") != 0;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_free0 (_tmp2_);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	result = _tmp3_;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	return result;
#line 687 "rygel-http-server.c"
}


static gboolean rygel_http_server_http_uri_present (RygelHTTPServer* self, RygelMediaItem* item) {
	gboolean result = FALSE;
	gboolean present = FALSE;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	present = FALSE;
#line 700 "rygel-http-server.c"
	{
		GeeArrayList* _uri_list = NULL;
		RygelMediaItem* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		gint _uri_size = 0;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _uri_index = 0;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp0_ = item;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp1_ = ((RygelMediaObject*) _tmp0_)->uris;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_uri_list = _tmp2_;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp3_ = _uri_list;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp5_ = _tmp4_;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_uri_size = _tmp5_;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_uri_index = -1;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		while (TRUE) {
#line 731 "rygel-http-server.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gchar* uri = NULL;
			GeeArrayList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp6_ = _uri_index;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_uri_index = _tmp6_ + 1;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp7_ = _uri_index;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp8_ = _uri_size;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				break;
#line 753 "rygel-http-server.c"
			}
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp9_ = _uri_list;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp10_ = _uri_index;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			uri = (gchar*) _tmp11_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp12_ = uri;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp13_ = rygel_http_server_need_proxy (self, _tmp12_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			if (!_tmp13_) {
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				present = TRUE;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_g_free0 (uri);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				break;
#line 775 "rygel-http-server.c"
			}
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_g_free0 (uri);
#line 779 "rygel-http-server.c"
		}
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_g_object_unref0 (_uri_list);
#line 783 "rygel-http-server.c"
	}
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	result = present;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	return result;
#line 789 "rygel-http-server.c"
}


static void rygel_http_server_on_cancelled (RygelHTTPServer* self, GCancellable* cancellable) {
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GUPnPContext* _tmp2_ = NULL;
	SoupServer* _tmp3_ = NULL;
	SoupServer* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (cancellable != NULL);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp1_ = _tmp0_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_cancellable_cancel (_tmp1_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp2_ = self->context;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp3_ = gupnp_context_get_server (_tmp2_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp4_ = _tmp3_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp5_ = self->priv->_path_root;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	soup_server_remove_handler (_tmp4_, _tmp5_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 822 "rygel-http-server.c"
}


static gchar* rygel_http_server_real_create_uri_for_item (RygelTranscodeManager* base, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target) {
	RygelHTTPServer * self;
	gchar* result = NULL;
	RygelHTTPItemURI* uri = NULL;
	RygelMediaItem* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	RygelHTTPItemURI* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	self = (RygelHTTPServer*) base;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = item;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp1_ = thumbnail_index;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp2_ = subtitle_index;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp3_ = transcode_target;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp4_ = playlist_target;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp5_ = rygel_http_item_uri_new ((RygelMediaObject*) _tmp0_, self, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	uri = _tmp5_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp6_ = rygel_http_item_uri_to_string (uri);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	result = _tmp6_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_object_unref0 (uri);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	return result;
#line 863 "rygel-http-server.c"
}


static gchar* rygel_http_server_real_get_protocol (RygelTranscodeManager* base) {
	RygelHTTPServer * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	self = (RygelHTTPServer*) base;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = g_strdup ("http-get");
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	result = _tmp0_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	return result;
#line 879 "rygel-http-server.c"
}


static GeeArrayList* rygel_http_server_real_get_protocol_info (RygelTranscodeManager* base) {
	RygelHTTPServer * self;
	GeeArrayList* result = NULL;
	GeeArrayList* protocol_infos = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GUPnPProtocolInfo* protocol_info = NULL;
	GUPnPProtocolInfo* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	self = (RygelHTTPServer*) base;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = RYGEL_TRANSCODE_MANAGER_CLASS (rygel_http_server_parent_class)->get_protocol_info (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager));
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	protocol_infos = _tmp0_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp1_ = gupnp_protocol_info_new ();
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	protocol_info = _tmp1_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp2_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) self);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp3_ = _tmp2_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	gupnp_protocol_info_set_protocol (protocol_info, _tmp3_);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_free0 (_tmp3_);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	gupnp_protocol_info_set_mime_type (protocol_info, "*");
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) protocol_infos, protocol_info);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	result = protocol_infos;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_object_unref0 (protocol_info);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	return result;
#line 920 "rygel-http-server.c"
}


static void rygel_http_server_on_request_completed (RygelHTTPServer* self, RygelStateMachine* machine) {
	RygelHTTPRequest* request = NULL;
	RygelStateMachine* _tmp0_ = NULL;
	RygelHTTPRequest* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	SoupMessage* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	SoupMessage* _tmp7_ = NULL;
	SoupURI* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (machine != NULL);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = machine;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_HTTP_REQUEST) ? ((RygelHTTPRequest*) _tmp0_) : NULL);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	request = _tmp1_;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp2_ = self->priv->requests;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp2_, request);
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp3_ = request->msg;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_object_get (_tmp3_, "method", &_tmp4_, NULL);
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp5_ = _tmp4_;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp6_ = _tmp5_;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp7_ = request->msg;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp8_ = soup_message_get_uri (_tmp7_);
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp9_ = soup_uri_to_string (_tmp8_, FALSE);
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp10_ = _tmp9_;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_debug ("rygel-http-server.vala:136: HTTP %s request for URI '%s' handled.", _tmp6_, _tmp10_);
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_free0 (_tmp10_);
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_free0 (_tmp6_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_object_unref0 (request);
#line 975 "rygel-http-server.c"
}


static void __lambda10_ (RygelHTTPServer* self, const gchar* name, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (name != NULL);
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (value != NULL);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = name;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp1_ = value;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_debug ("rygel-http-server.vala:155: %s : %s", _tmp0_, _tmp1_);
#line 992 "rygel-http-server.c"
}


static void ___lambda10__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self) {
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	__lambda10_ (self, name, value);
#line 999 "rygel-http-server.c"
}


static void rygel_http_server_server_handler (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* server_path, GHashTable* query, SoupClientContext* soup_client) {
	SoupMessage* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	SoupMessage* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	SoupMessage* _tmp9_ = NULL;
	SoupURI* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	SoupMessage* _tmp13_ = NULL;
	SoupMessageHeaders* _tmp14_ = NULL;
	SoupServer* _tmp15_ = NULL;
	SoupMessage* _tmp16_ = NULL;
	RygelHTTPGet* _tmp17_ = NULL;
	RygelHTTPGet* _tmp18_ = NULL;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (server != NULL);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (msg != NULL);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (server_path != NULL);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (soup_client != NULL);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = msg;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_object_get (_tmp0_, "method", &_tmp1_, NULL);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp2_ = _tmp1_;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp3_ = _tmp2_;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp4_ = g_strcmp0 (_tmp3_, "POST") == 0;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_free0 (_tmp3_);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	if (_tmp4_) {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		return;
#line 1049 "rygel-http-server.c"
	}
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp5_ = msg;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_object_get (_tmp5_, "method", &_tmp6_, NULL);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp7_ = _tmp6_;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp8_ = _tmp7_;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp9_ = msg;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp10_ = soup_message_get_uri (_tmp9_);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp11_ = soup_uri_to_string (_tmp10_, FALSE);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp12_ = _tmp11_;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_debug ("rygel-http-server.vala:151: HTTP %s request for URI '%s'. Headers:", _tmp8_, _tmp12_);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_free0 (_tmp12_);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_free0 (_tmp8_);
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp13_ = msg;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp14_ = _tmp13_->request_headers;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	soup_message_headers_foreach (_tmp14_, ___lambda10__soup_message_headers_foreach_func, self);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp15_ = server;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp16_ = msg;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp17_ = rygel_http_get_new (self, _tmp15_, _tmp16_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp18_ = _tmp17_;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	rygel_http_server_queue_request (self, (RygelHTTPRequest*) _tmp18_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_object_unref0 (_tmp18_);
#line 1091 "rygel-http-server.c"
}


static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client) {
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (server != NULL);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (message != NULL);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (client != NULL);
#line 1104 "rygel-http-server.c"
	{
		GeeArrayList* _request_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _request_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _request_index = 0;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp0_ = self->priv->requests;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_request_list = _tmp1_;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp2_ = _request_list;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp4_ = _tmp3_;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_request_size = _tmp4_;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_request_index = -1;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		while (TRUE) {
#line 1132 "rygel-http-server.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			RygelHTTPRequest* request = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			RygelHTTPRequest* _tmp11_ = NULL;
			SoupMessage* _tmp12_ = NULL;
			SoupMessage* _tmp13_ = NULL;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp5_ = _request_index;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_request_index = _tmp5_ + 1;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp6_ = _request_index;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp7_ = _request_size;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				break;
#line 1155 "rygel-http-server.c"
			}
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp8_ = _request_list;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp9_ = _request_index;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			request = (RygelHTTPRequest*) _tmp10_;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp11_ = request;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp12_ = _tmp11_->msg;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_tmp13_ = message;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			if (_tmp12_ == _tmp13_) {
#line 1173 "rygel-http-server.c"
				RygelHTTPRequest* _tmp14_ = NULL;
				GCancellable* _tmp15_ = NULL;
				GCancellable* _tmp16_ = NULL;
				RygelHTTPRequest* _tmp17_ = NULL;
				SoupMessage* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				RygelHTTPRequest* _tmp22_ = NULL;
				SoupMessage* _tmp23_ = NULL;
				SoupURI* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_tmp14_ = request;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_tmp15_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp14_);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_tmp16_ = _tmp15_;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				g_cancellable_cancel (_tmp16_);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_tmp17_ = request;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_tmp18_ = _tmp17_->msg;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				g_object_get (_tmp18_, "method", &_tmp19_, NULL);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_tmp20_ = _tmp19_;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_tmp21_ = _tmp20_;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_tmp22_ = request;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_tmp23_ = _tmp22_->msg;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_tmp24_ = soup_message_get_uri (_tmp23_);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_tmp25_ = soup_uri_to_string (_tmp24_, FALSE);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_tmp26_ = _tmp25_;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				g_debug ("rygel-http-server.vala:167: HTTP client aborted %s request for URI '%s" \
"'.", _tmp21_, _tmp26_);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_g_free0 (_tmp26_);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_g_free0 (_tmp21_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				_g_object_unref0 (request);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
				break;
#line 1225 "rygel-http-server.c"
			}
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
			_g_object_unref0 (request);
#line 1229 "rygel-http-server.c"
		}
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_g_object_unref0 (_request_list);
#line 1233 "rygel-http-server.c"
	}
}


static void _rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender, gpointer self) {
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	rygel_http_server_on_got_headers (self, _sender);
#line 1241 "rygel-http-server.c"
}


static void rygel_http_server_on_request_started (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client) {
	SoupMessage* _tmp0_ = NULL;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (server != NULL);
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (message != NULL);
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (client != NULL);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = message;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_signal_connect_object (_tmp0_, "got-headers", (GCallback) _rygel_http_server_on_got_headers_soup_message_got_headers, self, 0);
#line 1259 "rygel-http-server.c"
}


static void rygel_http_server_on_got_headers (RygelHTTPServer* self, SoupMessage* msg) {
	gboolean _tmp0_ = FALSE;
	SoupMessage* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp12_ = FALSE;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (msg != NULL);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp1_ = msg;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_object_get (_tmp1_, "method", &_tmp2_, NULL);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp3_ = _tmp2_;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp4_ = _tmp3_;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp5_ = g_strcmp0 (_tmp4_, "POST") == 0;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_free0 (_tmp4_);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	if (_tmp5_) {
#line 1289 "rygel-http-server.c"
		SoupMessage* _tmp6_ = NULL;
		SoupURI* _tmp7_ = NULL;
		SoupURI* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp6_ = msg;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp7_ = soup_message_get_uri (_tmp6_);
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp8_ = _tmp7_;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp9_ = _tmp8_->path;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp10_ = self->priv->_path_root;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp11_ = g_str_has_prefix (_tmp9_, _tmp10_);
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp0_ = _tmp11_;
#line 1310 "rygel-http-server.c"
	} else {
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp0_ = FALSE;
#line 1314 "rygel-http-server.c"
	}
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp12_ = _tmp0_;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	if (_tmp12_) {
#line 1320 "rygel-http-server.c"
		SoupMessage* _tmp13_ = NULL;
		SoupURI* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		GUPnPContext* _tmp17_ = NULL;
		SoupServer* _tmp18_ = NULL;
		SoupServer* _tmp19_ = NULL;
		SoupMessage* _tmp20_ = NULL;
		RygelHTTPPost* _tmp21_ = NULL;
		RygelHTTPPost* _tmp22_ = NULL;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp13_ = msg;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp14_ = soup_message_get_uri (_tmp13_);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp15_ = soup_uri_to_string (_tmp14_, FALSE);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp16_ = _tmp15_;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		g_debug ("rygel-http-server.vala:185: HTTP POST request for URI '%s'", _tmp16_);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_g_free0 (_tmp16_);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp17_ = self->context;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp18_ = gupnp_context_get_server (_tmp17_);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp19_ = _tmp18_;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp20_ = msg;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp21_ = rygel_http_post_new (self, _tmp19_, _tmp20_);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_tmp22_ = _tmp21_;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		rygel_http_server_queue_request (self, (RygelHTTPRequest*) _tmp22_);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		_g_object_unref0 (_tmp22_);
#line 1359 "rygel-http-server.c"
	}
}


static void _rygel_http_server_on_request_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	rygel_http_server_on_request_completed (self, _sender);
#line 1367 "rygel-http-server.c"
}


static void rygel_http_server_queue_request (RygelHTTPServer* self, RygelHTTPRequest* request) {
	RygelHTTPRequest* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	RygelHTTPRequest* _tmp2_ = NULL;
	RygelHTTPRequest* _tmp3_ = NULL;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (request != NULL);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = request;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_signal_connect_object ((RygelStateMachine*) _tmp0_, "completed", (GCallback) _rygel_http_server_on_request_completed_rygel_state_machine_completed, self, 0);
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp1_ = self->priv->requests;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp2_ = request;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp2_);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp3_ = request;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp3_, NULL, NULL);
#line 1394 "rygel-http-server.c"
}


const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = self->priv->_path_root;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	result = _tmp0_;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	return result;
#line 1409 "rygel-http-server.c"
}


static void rygel_http_server_set_path_root (RygelHTTPServer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = value;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_free0 (self->priv->_path_root);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	self->priv->_path_root = _tmp1_;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_object_notify ((GObject *) self, "path-root");
#line 1428 "rygel-http-server.c"
}


static GCancellable* rygel_http_server_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPServer* self;
	GCancellable* _tmp0_ = NULL;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	self = (RygelHTTPServer*) base;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = self->priv->_cancellable;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	result = _tmp0_;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	return result;
#line 1444 "rygel-http-server.c"
}


static void rygel_http_server_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPServer* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	self = (RygelHTTPServer*) base;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp0_ = value;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	self->priv->_cancellable = _tmp1_;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 1464 "rygel-http-server.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPServerPrivate));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->create_uri_for_item = rygel_http_server_real_create_uri_for_item;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol = rygel_http_server_real_get_protocol;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol_info = rygel_http_server_real_get_protocol_info;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_server_set_property;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1489 "rygel-http-server.c"
}


static void rygel_http_server_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	rygel_http_server_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_server_real_run;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	iface->run_finish = rygel_http_server_real_run_finish;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	iface->get_cancellable = rygel_http_server_real_get_cancellable;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	iface->set_cancellable = rygel_http_server_real_set_cancellable;
#line 1504 "rygel-http-server.c"
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	self->priv = RYGEL_HTTP_SERVER_GET_PRIVATE (self);
#line 1511 "rygel-http-server.c"
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_free0 (self->priv->_path_root);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_object_unref0 (self->root_container);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_object_unref0 (self->context);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_object_unref0 (self->priv->requests);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
#line 1531 "rygel-http-server.c"
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_server_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (RYGEL_TYPE_TRANSCODE_MANAGER, "RygelHTTPServer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_server_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		case RYGEL_HTTP_SERVER_PATH_ROOT:
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		g_value_set_string (value, rygel_http_server_get_path_root (self));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		case RYGEL_HTTP_SERVER_CANCELLABLE:
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		break;
#line 1566 "rygel-http-server.c"
		default:
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		break;
#line 1572 "rygel-http-server.c"
	}
}


static void _vala_rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		case RYGEL_HTTP_SERVER_PATH_ROOT:
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		rygel_http_server_set_path_root (self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		case RYGEL_HTTP_SERVER_CANCELLABLE:
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		break;
#line 1594 "rygel-http-server.c"
		default:
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-server.vala"
		break;
#line 1600 "rygel-http-server.c"
	}
}



