/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-language.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-language
 * @title: IAnjutaLanguage
 * @short_description: Interface to manage multiple programming languages
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-language.h
 * 
 */

#include "ianjuta-language.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_language_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-language-quark");
	}
	
	return quark;
}

 /**
  * ianjuta_language_get_from_editor:
  * @obj: Self
  * @editor: An object implementing IAnjutaEditorLanguage
  * @err: Error propagation
  *
  * Conviniece method to get the id directly from the editor
  *
  * Returns: A valid language id or 0
  */
IAnjutaLanguageId
ianjuta_language_get_from_editor (IAnjutaLanguage *obj, IAnjutaEditorLanguage* editor, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_LANGUAGE(obj), 0);
	g_return_val_if_fail ((editor == NULL) ||IANJUTA_IS_EDITOR_LANGUAGE(editor), 0);
	return IANJUTA_LANGUAGE_GET_IFACE (obj)->get_from_editor (obj, editor, err);
}

/* Default implementation */
static IAnjutaLanguageId
ianjuta_language_get_from_editor_default (IAnjutaLanguage *obj, IAnjutaEditorLanguage* editor, GError **err)
{
	g_return_val_if_reached (0);
}

/**
 * ianjuta_language_from_mime_type:
 * @obj: Self
 * @mime_type: A mime type to get the language for
 *
 * Returns: A language Id or 0 in case no language was found
 */
IAnjutaLanguageId
ianjuta_language_get_from_mime_type (IAnjutaLanguage *obj, const gchar* mime_type, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_LANGUAGE(obj), 0);
	return IANJUTA_LANGUAGE_GET_IFACE (obj)->get_from_mime_type (obj, mime_type, err);
}

/* Default implementation */
static IAnjutaLanguageId
ianjuta_language_get_from_mime_type_default (IAnjutaLanguage *obj, const gchar* mime_type, GError **err)
{
	g_return_val_if_reached (0);
}

/**
 * ianjuta_language_from_string:
 * @obj: Self
 * @string: A string representation of the language. Note that multiple
 * strings may describe the language like C++ and Cpp
 *
 * Returns: A language Id or 0 in case no language was found
 */
IAnjutaLanguageId
ianjuta_language_get_from_string (IAnjutaLanguage *obj, const gchar* string, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_LANGUAGE(obj), 0);
	return IANJUTA_LANGUAGE_GET_IFACE (obj)->get_from_string (obj, string, err);
}

/* Default implementation */
static IAnjutaLanguageId
ianjuta_language_get_from_string_default (IAnjutaLanguage *obj, const gchar* string, GError **err)
{
	g_return_val_if_reached (0);
}

  /**
   * ianjuta_language_get_languages:
   * @obj: Self
   * @err: Error propagation
   *
   * Returns: (element-type int) (transfer container): a list of ids of the available
   * languages. Use GPOINTER_TO_INT() to receive them. The list but not the
   * values should be free'd with g_list_free()
   */
GList*
ianjuta_language_get_languages (IAnjutaLanguage *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_LANGUAGE(obj), NULL);
	return IANJUTA_LANGUAGE_GET_IFACE (obj)->get_languages (obj, err);
}

/* Default implementation */
static GList*
ianjuta_language_get_languages_default (IAnjutaLanguage *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_language_get_make_target:
 * @obj: Self
 * @id: A valid language id
 *
 * Returns: The suffix for the file thats needs to be passed to
 * make to compile the file, e.g. ".o" for C
 */
const gchar*
ianjuta_language_get_make_target (IAnjutaLanguage *obj, IAnjutaLanguageId id, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_LANGUAGE(obj), NULL);
	return IANJUTA_LANGUAGE_GET_IFACE (obj)->get_make_target (obj, id, err);
}

/* Default implementation */
static const gchar*
ianjuta_language_get_make_target_default (IAnjutaLanguage *obj, IAnjutaLanguageId id, GError **err)
{
	g_return_val_if_reached (NULL);
}

 	/**
 * ianjuta_language_get_name:
 * @obj: Self
 * @id: A valid language id
 *
 * Returns: The main name of the language. When you call ianjuta_language_from_string()
 * before that method the string you get here might be different to the one you passed 
 * because the language might have multiple string representations
 */
const gchar*
ianjuta_language_get_name (IAnjutaLanguage *obj, IAnjutaLanguageId id, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_LANGUAGE(obj), NULL);
	return IANJUTA_LANGUAGE_GET_IFACE (obj)->get_name (obj, id, err);
}

/* Default implementation */
static const gchar*
ianjuta_language_get_name_default (IAnjutaLanguage *obj, IAnjutaLanguageId id, GError **err)
{
	g_return_val_if_reached (NULL);
}

 /**
  * ianjuta_language_get_name_from_editor:
  * @obj: Self
  * @editor: An object implementing IAnjutaEditorLanguage
  * @err: Error propagation
  *
  * Conviniece method to get the name directly from the editor
  *
  * Returns: A language name or NULL
  */
const gchar*
ianjuta_language_get_name_from_editor (IAnjutaLanguage *obj, IAnjutaEditorLanguage* editor, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_LANGUAGE(obj), NULL);
	g_return_val_if_fail ((editor == NULL) ||IANJUTA_IS_EDITOR_LANGUAGE(editor), NULL);
	return IANJUTA_LANGUAGE_GET_IFACE (obj)->get_name_from_editor (obj, editor, err);
}

/* Default implementation */
static const gchar*
ianjuta_language_get_name_from_editor_default (IAnjutaLanguage *obj, IAnjutaEditorLanguage* editor, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_language_get_strings:
 * @obj: Self
 * @id: A valid language id
 *
 * Returns: (element-type utf8): A list of strings that represent this language that language
 */
GList*
ianjuta_language_get_strings (IAnjutaLanguage *obj, IAnjutaLanguageId id, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_LANGUAGE(obj), 0);
	return IANJUTA_LANGUAGE_GET_IFACE (obj)->get_strings (obj, id, err);
}

/* Default implementation */
static GList*
ianjuta_language_get_strings_default (IAnjutaLanguage *obj, IAnjutaLanguageId id, GError **err)
{
	g_return_val_if_reached (NULL);
}

static void
ianjuta_language_base_init (IAnjutaLanguageIface* klass)
{
	static gboolean initialized = FALSE;

	klass->get_from_editor = ianjuta_language_get_from_editor_default;
	klass->get_from_mime_type = ianjuta_language_get_from_mime_type_default;
	klass->get_from_string = ianjuta_language_get_from_string_default;
	klass->get_languages = ianjuta_language_get_languages_default;
	klass->get_make_target = ianjuta_language_get_make_target_default;
	klass->get_name = ianjuta_language_get_name_default;
	klass->get_name_from_editor = ianjuta_language_get_name_from_editor_default;
	klass->get_strings = ianjuta_language_get_strings_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_language_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaLanguageIface),
			(GBaseInitFunc) ianjuta_language_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaLanguage", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
