/* rygel-http-post.c generated by valac 0.18.1, the Vala compiler
 * generated from rygel-http-post.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_HTTP_POST (rygel_http_post_get_type ())
#define RYGEL_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPost))
#define RYGEL_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))
#define RYGEL_IS_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST))
#define RYGEL_IS_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST))
#define RYGEL_HTTP_POST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))

typedef struct _RygelHTTPPost RygelHTTPPost;
typedef struct _RygelHTTPPostClass RygelHTTPPostClass;
typedef struct _RygelHTTPPostPrivate RygelHTTPPostPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_ITEM_REMOVAL_QUEUE (rygel_item_removal_queue_get_type ())
#define RYGEL_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueue))
#define RYGEL_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))

typedef struct _RygelItemRemovalQueue RygelItemRemovalQueue;
typedef struct _RygelItemRemovalQueueClass RygelItemRemovalQueueClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHttpPostHandleData RygelHttpPostHandleData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHttpPostHandleRealData RygelHttpPostHandleRealData;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _RygelHttpPostWaitForItemData RygelHttpPostWaitForItemData;
typedef struct _RygelHttpPostFinalizePostData RygelHttpPostFinalizePostData;
typedef struct _RygelHttpPostRemoveItemData RygelHttpPostRemoveItemData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPPost {
	RygelHTTPRequest parent_instance;
	RygelHTTPPostPrivate * priv;
};

struct _RygelHTTPPostClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelHTTPPostPrivate {
	GSourceFunc handle_continue;
	gpointer handle_continue_target;
	GDestroyNotify handle_continue_target_destroy_notify;
	GFile* file;
	GFile* dotfile;
	GOutputStream* stream;
};

struct _RygelHttpPostHandleData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelItemRemovalQueue* _tmp0_;
	RygelItemRemovalQueue* queue;
	RygelItemRemovalQueue* _tmp1_;
	RygelMediaObject* _tmp2_;
	GError* _error_;
	RygelItemRemovalQueue* _tmp3_;
	RygelMediaObject* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	RygelMediaContainer* parent;
	gchar* mime_type;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	glong duration;
	GeeArrayList* uris;
	gboolean place_holder;
	GFile* file;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHttpPostHandleRealData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelMediaObject* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* msg;
	const gchar* _tmp4_;
	RygelMediaObject* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	RygelMediaObject* _tmp8_;
	GCancellable* _tmp9_;
	GCancellable* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	const gchar* _tmp14_;
	RygelMediaObject* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	GFile* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GFile* _tmp26_;
	GFile* _tmp27_;
	GCancellable* _tmp28_;
	GCancellable* _tmp29_;
	GFileOutputStream* _tmp30_;
	GFileOutputStream* _tmp31_;
	SoupMessage* _tmp32_;
	SoupMessage* _tmp33_;
	SoupServer* _tmp34_;
	SoupMessage* _tmp35_;
	GError * _inner_error_;
};

struct _Block5Data {
	int _ref_count_;
	RygelHTTPPost * self;
	RygelMediaContainer* container;
	gpointer _async_data_;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	guint source_id;
};

struct _RygelHttpPostWaitForItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelMediaContainer* container;
	gchar* id;
	guint timeout;
	Block5Data* _data5_;
	RygelMediaContainer* _tmp0_;
	RygelMediaItem* item;
	gboolean _tmp1_;
	RygelMediaItem* _tmp2_;
	RygelMediaItem* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	RygelMediaContainer* _tmp6_;
	const gchar* _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
	RygelMediaObject* _tmp10_;
	RygelMediaObject* _tmp11_;
	GError* _error_;
	RygelMediaItem* _tmp12_;
	const gchar* _tmp13_;
	RygelMediaItem* _tmp14_;
	gboolean _tmp15_;
	Block6Data* _data6_;
	guint _tmp16_;
	guint _tmp17_;
	RygelMediaContainer* _tmp18_;
	gulong _tmp19_;
	gulong update_id;
	RygelMediaContainer* _tmp20_;
	gulong _tmp21_;
	guint _tmp22_;
	guint _tmp23_;
	GError * _inner_error_;
};

struct _RygelHttpPostFinalizePostData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	GOutputStream* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GError* _error_;
	GSourceFunc _tmp3_;
	void* _tmp3__target;
	SoupServer* _tmp4_;
	SoupMessage* _tmp5_;
	RygelMediaObject* _tmp6_;
	RygelMediaContainer* _tmp7_;
	const gchar* _tmp8_;
	RygelMediaObject* _tmp9_;
	const gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GCancellable* _tmp13_;
	GCancellable* _tmp14_;
	GError* move_error;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	SoupServer* _tmp21_;
	SoupMessage* _tmp22_;
	GSourceFunc _tmp23_;
	void* _tmp23__target;
	RygelMediaObject* _tmp24_;
	RygelMediaContainer* _tmp25_;
	RygelMediaObject* _tmp26_;
	const gchar* _tmp27_;
	SoupServer* _tmp28_;
	SoupMessage* _tmp29_;
	GSourceFunc _tmp30_;
	void* _tmp30__target;
	GError * _inner_error_;
};

struct _RygelHttpPostRemoveItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelItemRemovalQueue* _tmp0_;
	RygelItemRemovalQueue* queue;
	RygelMediaObject* _tmp1_;
};


static gpointer rygel_http_post_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
gpointer rygel_client_hacks_ref (gpointer instance);
void rygel_client_hacks_unref (gpointer instance);
GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_client_hacks (GValue* value, gpointer v_object);
void rygel_value_take_client_hacks (GValue* value, gpointer v_object);
gpointer rygel_value_get_client_hacks (const GValue* value);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_http_post_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_POST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_POST, RygelHTTPPostPrivate))
enum  {
	RYGEL_HTTP_POST_DUMMY_PROPERTY
};
RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_http_post_on_request_cancelled (RygelHTTPPost* self);
static void _rygel_http_post_on_request_cancelled_gfunc (gconstpointer data, gpointer self);
static void rygel_http_post_real_handle_data_free (gpointer _data);
static void rygel_http_post_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_post_real_handle_co (RygelHttpPostHandleData* _data_);
GType rygel_item_removal_queue_get_type (void) G_GNUC_CONST;
RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
gboolean rygel_item_removal_queue_dequeue (RygelItemRemovalQueue* self, RygelMediaItem* item);
static void rygel_http_post_handle_real (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_handle_real_finish (RygelHTTPPost* self, GAsyncResult* _res_, GError** error);
static void rygel_http_post_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_item_removal_queue_remove_now (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_item_removal_queue_remove_now_finish (RygelItemRemovalQueue* self, GAsyncResult* _res_);
static void rygel_http_post_handle_real_data_free (gpointer _data);
static gboolean rygel_http_post_handle_real_co (RygelHttpPostHandleRealData* _data_);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GQuark rygel_content_directory_error_quark (void);
void rygel_media_item_get_writable (RygelMediaItem* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_item_get_writable_finish (RygelMediaItem* self, GAsyncResult* _res_, GError** error);
static void rygel_http_post_handle_real_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GQuark rygel_http_request_error_quark (void);
static void rygel_http_post_on_got_chunk (RygelHTTPPost* self, SoupMessage* msg, SoupBuffer* chunk);
static void _rygel_http_post_on_got_chunk_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self);
static void rygel_http_post_on_got_body (RygelHTTPPost* self, SoupMessage* msg);
static void _rygel_http_post_on_got_body_soup_message_got_body (SoupMessage* _sender, gpointer self);
static gboolean _rygel_http_post_handle_real_co_gsource_func (gpointer self);
static void rygel_http_post_finalize_post (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_finalize_post_finish (RygelHTTPPost* self, GAsyncResult* _res_);
static void rygel_http_post_wait_for_item_data_free (gpointer _data);
static void rygel_http_post_wait_for_item (RygelHTTPPost* self, RygelMediaContainer* container, const gchar* id, guint timeout, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_wait_for_item_finish (RygelHTTPPost* self, GAsyncResult* _res_);
static gboolean rygel_http_post_wait_for_item_co (RygelHttpPostWaitForItemData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_http_post_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean ____lambda4_ (Block6Data* _data6_);
static gboolean _____lambda4__gsource_func (gpointer self);
static void ____lambda5_ (Block6Data* _data6_);
static void _____lambda5__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static void rygel_http_post_finalize_post_data_free (gpointer _data);
static gboolean rygel_http_post_finalize_post_co (RygelHttpPostFinalizePostData* _data_);
void rygel_http_request_end (RygelHTTPRequest* self, guint status);
static void rygel_http_post_finalize_post_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_post_disconnect_message_signals (RygelHTTPPost* self);
void rygel_http_request_handle_error (RygelHTTPRequest* self, GError* _error_);
static void rygel_http_post_remove_item (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_remove_item_finish (RygelHTTPPost* self, GAsyncResult* _res_);
static void rygel_http_post_remove_item_data_free (gpointer _data);
static gboolean rygel_http_post_remove_item_co (RygelHttpPostRemoveItemData* _data_);
static void rygel_http_post_remove_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_post_finalize (GObject* obj);


static void _rygel_http_post_on_request_cancelled_gfunc (gconstpointer data, gpointer self) {
	rygel_http_post_on_request_cancelled (self);
}


RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPPost * self = NULL;
	RygelHTTPServer* _tmp0_;
	SoupServer* _tmp1_;
	SoupMessage* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessageBody* _tmp6_;
	g_return_val_if_fail (http_server != NULL, NULL);
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = http_server;
	_tmp1_ = server;
	_tmp2_ = msg;
	self = (RygelHTTPPost*) rygel_http_request_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp4_ = _tmp3_;
	g_cancellable_connect (_tmp4_, (GCallback) _rygel_http_post_on_request_cancelled_gfunc, g_object_ref (self), g_object_unref);
	_tmp5_ = msg;
	_tmp6_ = _tmp5_->request_body;
	soup_message_body_set_accumulate (_tmp6_, FALSE);
	return self;
}


RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	return rygel_http_post_construct (RYGEL_TYPE_HTTP_POST, http_server, server, msg);
}


static void rygel_http_post_real_handle_data_free (gpointer _data) {
	RygelHttpPostHandleData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpPostHandleData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_http_post_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPPost * self;
	RygelHttpPostHandleData* _data_;
	RygelHTTPPost* _tmp0_;
	self = (RygelHTTPPost*) base;
	_data_ = g_slice_new0 (RygelHttpPostHandleData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_real_handle);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_real_handle_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_post_real_handle_co (_data_);
}


static void rygel_http_post_real_handle_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpPostHandleData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_post_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostHandleData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_post_real_handle_co (_data_);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean rygel_http_post_real_handle_co (RygelHttpPostHandleData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = rygel_item_removal_queue_get_default ();
	_data_->queue = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->queue;
	_data_->_tmp2_ = ((RygelHTTPRequest*) _data_->self)->object;
	rygel_item_removal_queue_dequeue (_data_->_tmp1_, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp2_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp2_) : NULL);
	{
		_data_->_state_ = 1;
		rygel_http_post_handle_real (_data_->self, rygel_http_post_handle_ready, _data_);
		return FALSE;
		_state_1:
		rygel_http_post_handle_real_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp3_ = _data_->queue;
		_data_->_tmp4_ = ((RygelHTTPRequest*) _data_->self)->object;
		_data_->_tmp5_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_state_ = 2;
		rygel_item_removal_queue_remove_now (_data_->_tmp3_, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp4_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp4_) : NULL, _data_->_tmp6_, rygel_http_post_handle_ready, _data_);
		return FALSE;
		_state_2:
		rygel_item_removal_queue_remove_now_finish (_data_->_tmp3_, _data_->_res_);
		_data_->_tmp7_ = _data_->_error_;
		_data_->_tmp8_ = _g_error_copy0 (_data_->_tmp7_);
		_data_->_inner_error_ = _data_->_tmp8_;
		_g_error_free0 (_data_->_error_);
		goto __finally6;
	}
	__finally6:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->queue);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->queue);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_http_post_handle_real_data_free (gpointer _data) {
	RygelHttpPostHandleRealData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpPostHandleRealData, _data_);
}


static void rygel_http_post_handle_real (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostHandleRealData* _data_;
	RygelHTTPPost* _tmp0_;
	_data_ = g_slice_new0 (RygelHttpPostHandleRealData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_handle_real);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_handle_real_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_post_handle_real_co (_data_);
}


static void rygel_http_post_handle_real_finish (RygelHTTPPost* self, GAsyncResult* _res_, GError** error) {
	RygelHttpPostHandleRealData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_post_handle_real_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostHandleRealData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_post_handle_real_co (_data_);
}


static void _rygel_http_post_on_got_chunk_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self) {
	rygel_http_post_on_got_chunk (self, _sender, chunk);
}


static void _rygel_http_post_on_got_body_soup_message_got_body (SoupMessage* _sender, gpointer self) {
	rygel_http_post_on_got_body (self, _sender);
}


static gboolean _rygel_http_post_handle_real_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_post_handle_real_co (self);
	return result;
}


static gboolean rygel_http_post_handle_real_co (RygelHttpPostHandleRealData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((RygelHTTPRequest*) _data_->self)->object;
	_data_->_tmp1_ = (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp0_) : NULL)->place_holder;
	if (!_data_->_tmp1_) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _ ("Pushing data to non-empty item '%s' not allowed");
		_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
		_data_->msg = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->msg;
		_data_->_tmp5_ = ((RygelHTTPRequest*) _data_->self)->object;
		_data_->_tmp6_ = _data_->_tmp5_->id;
		_data_->_tmp7_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _data_->_tmp4_, _data_->_tmp6_);
		_data_->_inner_error_ = _data_->_tmp7_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->msg);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = ((RygelHTTPRequest*) _data_->self)->object;
	_data_->_tmp9_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_state_ = 1;
	rygel_media_item_get_writable (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp8_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp8_) : NULL, _data_->_tmp10_, rygel_http_post_handle_real_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = rygel_media_item_get_writable_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp8_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp8_) : NULL, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp12_ = _data_->_tmp11_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->self->priv->file);
	_data_->self->priv->file = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->self->priv->file;
	if (_data_->_tmp13_ == NULL) {
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _ ("No writable URI for %s available");
		_data_->_tmp15_ = ((RygelHTTPRequest*) _data_->self)->object;
		_data_->_tmp16_ = _data_->_tmp15_->id;
		_data_->_tmp17_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _data_->_tmp14_, _data_->_tmp16_);
		_data_->_inner_error_ = _data_->_tmp17_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->self->priv->file;
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = g_file_get_parent (_data_->_tmp18_);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = _data_->self->priv->file;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = g_file_get_basename (_data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	_data_->_tmp24_ = g_strconcat (".", _data_->_tmp23_, NULL);
	_data_->_tmp25_ = _data_->_tmp24_;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = g_file_get_child (_data_->_tmp20_, _data_->_tmp25_);
	_g_object_unref0 (_data_->self->priv->dotfile);
	_data_->self->priv->dotfile = _data_->_tmp26_;
	_g_free0 (_data_->_tmp25_);
	_g_free0 (_data_->_tmp23_);
	_g_object_unref0 (_data_->_tmp20_);
	_data_->_tmp27_ = _data_->self->priv->dotfile;
	_data_->_tmp28_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp29_ = _data_->_tmp28_;
	_data_->_state_ = 2;
	g_file_replace_async (_data_->_tmp27_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_LOW, _data_->_tmp29_, rygel_http_post_handle_real_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = g_file_replace_finish (_data_->_tmp27_, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp31_ = _data_->_tmp30_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->self->priv->stream);
	_data_->self->priv->stream = (GOutputStream*) _data_->_tmp31_;
	_data_->_tmp32_ = ((RygelHTTPRequest*) _data_->self)->msg;
	g_signal_connect_object (_data_->_tmp32_, "got-chunk", (GCallback) _rygel_http_post_on_got_chunk_soup_message_got_chunk, _data_->self, 0);
	_data_->_tmp33_ = ((RygelHTTPRequest*) _data_->self)->msg;
	g_signal_connect_object (_data_->_tmp33_, "got-body", (GCallback) _rygel_http_post_on_got_body_soup_message_got_body, _data_->self, 0);
	_data_->_tmp34_ = ((RygelHTTPRequest*) _data_->self)->server;
	_data_->_tmp35_ = ((RygelHTTPRequest*) _data_->self)->msg;
	soup_server_unpause_message (_data_->_tmp34_, _data_->_tmp35_);
	(_data_->self->priv->handle_continue_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->handle_continue_target_destroy_notify (_data_->self->priv->handle_continue_target), NULL);
	_data_->self->priv->handle_continue = NULL;
	_data_->self->priv->handle_continue_target = NULL;
	_data_->self->priv->handle_continue_target_destroy_notify = NULL;
	_data_->self->priv->handle_continue = _rygel_http_post_handle_real_co_gsource_func;
	_data_->self->priv->handle_continue_target = _data_;
	_data_->self->priv->handle_continue_target_destroy_notify = NULL;
	_data_->_state_ = 3;
	return FALSE;
	_state_3:
	;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_http_post_on_got_body (RygelHTTPPost* self, SoupMessage* msg) {
	SoupMessage* _tmp0_;
	SoupMessage* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = ((RygelHTTPRequest*) self)->msg;
	_tmp1_ = msg;
	if (_tmp0_ != _tmp1_) {
		return;
	}
	rygel_http_post_finalize_post (self, NULL, NULL);
}


static void rygel_http_post_wait_for_item_data_free (gpointer _data) {
	RygelHttpPostWaitForItemData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpPostWaitForItemData, _data_);
}


static void rygel_http_post_wait_for_item (RygelHTTPPost* self, RygelMediaContainer* container, const gchar* id, guint timeout, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostWaitForItemData* _data_;
	RygelHTTPPost* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelMediaContainer* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	guint _tmp5_;
	_data_ = g_slice_new0 (RygelHttpPostWaitForItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_wait_for_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_wait_for_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->container);
	_data_->container = _tmp2_;
	_tmp3_ = id;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->id);
	_data_->id = _tmp4_;
	_tmp5_ = timeout;
	_data_->timeout = _tmp5_;
	rygel_http_post_wait_for_item_co (_data_);
}


static void rygel_http_post_wait_for_item_finish (RygelHTTPPost* self, GAsyncResult* _res_) {
	RygelHttpPostWaitForItemData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Waits for an item with @id to change its state to non-placeholder under
     * @container, but at most @timeout seconds.
     *
     * @param container The container to watch for changes
     * @param id The child id to look for
     * @param timeout Seconds to wait befor cancelling
     */
static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		RygelHTTPPost * self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->container);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void rygel_http_post_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostWaitForItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_post_wait_for_item_co (_data_);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		RygelHTTPPost * self;
		self = _data6_->_data5_->self;
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}


static gboolean ____lambda4_ (Block6Data* _data6_) {
	Block5Data* _data5_;
	RygelHTTPPost * self;
	gboolean result = FALSE;
	RygelMediaContainer* _tmp0_;
	const gchar* _tmp1_;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	_tmp0_ = _data5_->container;
	_tmp1_ = ((RygelMediaObject*) _tmp0_)->id;
	g_debug ("rygel-http-post.vala:136: Timeout on waiting for 'updated' signal on '" \
"%s'.", _tmp1_);
	_data6_->source_id = (guint) 0;
	rygel_http_post_wait_for_item_co (_data5_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean _____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda4_ (self);
	return result;
}


static void ____lambda5_ (Block6Data* _data6_) {
	Block5Data* _data5_;
	RygelHTTPPost * self;
	RygelMediaContainer* _tmp0_;
	const gchar* _tmp1_;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	_tmp0_ = _data5_->container;
	_tmp1_ = ((RygelMediaObject*) _tmp0_)->id;
	g_debug ("rygel-http-post.vala:145: Finished waiting for update signal from cont" \
"ainer '%s'", _tmp1_);
	rygel_http_post_wait_for_item_co (_data5_->_async_data_);
}


static void _____lambda5__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
	____lambda5_ (self);
}


static gboolean rygel_http_post_wait_for_item_co (RygelHttpPostWaitForItemData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->container;
	_g_object_unref0 (_data_->_data5_->container);
	_data_->_data5_->container = _data_->_tmp0_;
	_data_->_data5_->_async_data_ = _data_;
	_data_->item = NULL;
	while (TRUE) {
		_data_->_tmp2_ = _data_->item;
		if (_data_->_tmp2_ == NULL) {
			_data_->_tmp1_ = TRUE;
		} else {
			_data_->_tmp3_ = _data_->item;
			_data_->_tmp4_ = _data_->_tmp3_->place_holder;
			_data_->_tmp1_ = _data_->_tmp4_;
		}
		_data_->_tmp5_ = _data_->_tmp1_;
		if (!_data_->_tmp5_) {
			break;
		}
		{
			_data_->_tmp6_ = _data_->_data5_->container;
			_data_->_tmp7_ = _data_->id;
			_data_->_tmp8_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_state_ = 1;
			rygel_media_container_find_object (_data_->_tmp6_, _data_->_tmp7_, _data_->_tmp9_, rygel_http_post_wait_for_item_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = rygel_media_container_find_object_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp11_ = _data_->_tmp10_;
			if (_data_->_inner_error_ != NULL) {
				goto __catch7_g_error;
			}
			_g_object_unref0 (_data_->item);
			_data_->item = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp11_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp11_) : NULL;
		}
		goto __finally7;
		__catch7_g_error:
		{
			_data_->_error_ = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_g_error_free0 (_data_->_error_);
			break;
		}
		__finally7:
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->item);
			block5_data_unref (_data_->_data5_);
			_data_->_data5_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp12_ = _data_->item;
		if (_data_->_tmp12_ == NULL) {
			_data_->_tmp13_ = _data_->id;
			g_warning ("rygel-http-post.vala:128: Item %s disappeared, stop waiting for it", _data_->_tmp13_);
			break;
		}
		_data_->_tmp14_ = _data_->item;
		_data_->_tmp15_ = _data_->_tmp14_->place_holder;
		if (_data_->_tmp15_) {
			_data_->_data6_ = g_slice_new0 (Block6Data);
			_data_->_data6_->_ref_count_ = 1;
			_data_->_data6_->_data5_ = block5_data_ref (_data_->_data5_);
			_data_->_data6_->source_id = (guint) 0;
			_data_->_tmp16_ = _data_->timeout;
			_data_->_tmp17_ = 0U;
			_data_->_tmp17_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _data_->_tmp16_, _____lambda4__gsource_func, block6_data_ref (_data_->_data6_), block6_data_unref);
			_data_->_data6_->source_id = _data_->_tmp17_;
			_data_->_tmp18_ = _data_->_data5_->container;
			_data_->_tmp19_ = 0UL;
			_data_->_tmp19_ = g_signal_connect_data (_data_->_tmp18_, "container-updated", (GCallback) _____lambda5__rygel_media_container_container_updated, block6_data_ref (_data_->_data6_), (GClosureNotify) block6_data_unref, 0);
			_data_->update_id = _data_->_tmp19_;
			_data_->_state_ = 2;
			return FALSE;
			_state_2:
			;
			_data_->_tmp20_ = _data_->_data5_->container;
			_data_->_tmp21_ = _data_->update_id;
			g_signal_handler_disconnect ((GObject*) _data_->_tmp20_, _data_->_tmp21_);
			_data_->_tmp22_ = _data_->_data6_->source_id;
			if (_data_->_tmp22_ != ((guint) 0)) {
				_data_->_tmp23_ = _data_->_data6_->source_id;
				g_source_remove (_data_->_tmp23_);
			} else {
				block6_data_unref (_data_->_data6_);
				_data_->_data6_ = NULL;
				break;
			}
			block6_data_unref (_data_->_data6_);
			_data_->_data6_ = NULL;
		}
	}
	_g_object_unref0 (_data_->item);
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_http_post_finalize_post_data_free (gpointer _data) {
	RygelHttpPostFinalizePostData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpPostFinalizePostData, _data_);
}


static void rygel_http_post_finalize_post (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostFinalizePostData* _data_;
	RygelHTTPPost* _tmp0_;
	_data_ = g_slice_new0 (RygelHttpPostFinalizePostData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_finalize_post);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_finalize_post_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_post_finalize_post_co (_data_);
}


static void rygel_http_post_finalize_post_finish (RygelHTTPPost* self, GAsyncResult* _res_) {
	RygelHttpPostFinalizePostData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_post_finalize_post_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostFinalizePostData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_post_finalize_post_co (_data_);
}


static gboolean rygel_http_post_finalize_post_co (RygelHttpPostFinalizePostData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->stream;
		_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp2_ = _data_->_tmp1_;
		g_output_stream_close (_data_->_tmp0_, _data_->_tmp2_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_INTERNAL_SERVER_ERROR);
		_data_->_tmp3_ = _data_->self->priv->handle_continue;
		_data_->_tmp3__target = _data_->self->priv->handle_continue_target;
		_data_->_tmp3_ (_data_->_tmp3__target);
		_g_error_free0 (_data_->_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally8:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp4_ = ((RygelHTTPRequest*) _data_->self)->server;
	_data_->_tmp5_ = ((RygelHTTPRequest*) _data_->self)->msg;
	soup_server_pause_message (_data_->_tmp4_, _data_->_tmp5_);
	_data_->_tmp6_ = ((RygelHTTPRequest*) _data_->self)->object;
	_data_->_tmp7_ = _data_->_tmp6_->parent;
	_data_->_tmp8_ = ((RygelMediaObject*) _data_->_tmp7_)->id;
	_data_->_tmp9_ = ((RygelHTTPRequest*) _data_->self)->object;
	_data_->_tmp10_ = _data_->_tmp9_->id;
	g_debug ("Waiting for update signal from container '%s' after pushing" " content to its child item '%s'..", _data_->_tmp8_, _data_->_tmp10_);
	{
		_data_->_tmp11_ = _data_->self->priv->dotfile;
		_data_->_tmp12_ = _data_->self->priv->file;
		_data_->_tmp13_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp14_ = _data_->_tmp13_;
		g_file_move (_data_->_tmp11_, _data_->_tmp12_, G_FILE_COPY_NONE, _data_->_tmp14_, NULL, NULL, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		_data_->move_error = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _ ("Failed to move dotfile %s: %s");
		_data_->_tmp16_ = _data_->self->priv->dotfile;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_file_get_uri (_data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = _data_->move_error;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		g_warning (_data_->_tmp15_, _data_->_tmp18_, _data_->_tmp20_);
		_g_free0 (_data_->_tmp18_);
		_data_->_tmp21_ = ((RygelHTTPRequest*) _data_->self)->server;
		_data_->_tmp22_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_server_unpause_message (_data_->_tmp21_, _data_->_tmp22_);
		rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_INTERNAL_SERVER_ERROR);
		_data_->_tmp23_ = _data_->self->priv->handle_continue;
		_data_->_tmp23__target = _data_->self->priv->handle_continue_target;
		_data_->_tmp23_ (_data_->_tmp23__target);
		_g_error_free0 (_data_->move_error);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally9:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp24_ = ((RygelHTTPRequest*) _data_->self)->object;
	_data_->_tmp25_ = _data_->_tmp24_->parent;
	_data_->_tmp26_ = ((RygelHTTPRequest*) _data_->self)->object;
	_data_->_tmp27_ = _data_->_tmp26_->id;
	_data_->_state_ = 1;
	rygel_http_post_wait_for_item (_data_->self, _data_->_tmp25_, _data_->_tmp27_, (guint) 5, rygel_http_post_finalize_post_ready, _data_);
	return FALSE;
	_state_1:
	rygel_http_post_wait_for_item_finish (_data_->self, _data_->_res_);
	_data_->_tmp28_ = ((RygelHTTPRequest*) _data_->self)->server;
	_data_->_tmp29_ = ((RygelHTTPRequest*) _data_->self)->msg;
	soup_server_unpause_message (_data_->_tmp28_, _data_->_tmp29_);
	rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_OK);
	_data_->_tmp30_ = _data_->self->priv->handle_continue;
	_data_->_tmp30__target = _data_->self->priv->handle_continue_target;
	_data_->_tmp30_ (_data_->_tmp30__target);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_http_post_on_got_chunk (RygelHTTPPost* self, SoupMessage* msg, SoupBuffer* chunk) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	g_return_if_fail (chunk != NULL);
	{
		GOutputStream* _tmp0_;
		SoupBuffer* _tmp1_;
		guint8* _tmp2_;
		gint _tmp2__length1;
		GCancellable* _tmp3_;
		GCancellable* _tmp4_;
		_tmp0_ = self->priv->stream;
		_tmp1_ = chunk;
		_tmp2_ = _tmp1_->data;
		_tmp2__length1 = (gint) _tmp1_->length;
		_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		_tmp4_ = _tmp3_;
		g_output_stream_write_all (_tmp0_, _tmp2_, (gsize) _tmp2__length1, NULL, _tmp4_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		GSourceFunc _tmp9_;
		void* _tmp9__target;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		rygel_http_post_disconnect_message_signals (self);
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR, _tmp6_);
		_tmp8_ = _tmp7_;
		rygel_http_request_handle_error ((RygelHTTPRequest*) self, _tmp8_);
		_g_error_free0 (_tmp8_);
		_tmp9_ = self->priv->handle_continue;
		_tmp9__target = self->priv->handle_continue_target;
		_tmp9_ (_tmp9__target);
		_g_error_free0 (_error_);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_http_post_on_request_cancelled (RygelHTTPPost* self) {
	g_return_if_fail (self != NULL);
	rygel_http_post_remove_item (self, NULL, NULL);
}


static void rygel_http_post_remove_item_data_free (gpointer _data) {
	RygelHttpPostRemoveItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpPostRemoveItemData, _data_);
}


static void rygel_http_post_remove_item (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostRemoveItemData* _data_;
	RygelHTTPPost* _tmp0_;
	_data_ = g_slice_new0 (RygelHttpPostRemoveItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_remove_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_remove_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_post_remove_item_co (_data_);
}


static void rygel_http_post_remove_item_finish (RygelHTTPPost* self, GAsyncResult* _res_) {
	RygelHttpPostRemoveItemData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_post_remove_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostRemoveItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_post_remove_item_co (_data_);
}


static gboolean rygel_http_post_remove_item_co (RygelHttpPostRemoveItemData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = rygel_item_removal_queue_get_default ();
	_data_->queue = _data_->_tmp0_;
	_data_->_tmp1_ = ((RygelHTTPRequest*) _data_->self)->object;
	_data_->_state_ = 1;
	rygel_item_removal_queue_remove_now (_data_->queue, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp1_) : NULL, NULL, rygel_http_post_remove_item_ready, _data_);
	return FALSE;
	_state_1:
	rygel_item_removal_queue_remove_now_finish (_data_->queue, _data_->_res_);
	_g_object_unref0 (_data_->queue);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_http_post_disconnect_message_signals (RygelHTTPPost* self) {
	SoupMessage* _tmp0_;
	guint _tmp1_ = 0U;
	SoupMessage* _tmp2_;
	guint _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((RygelHTTPRequest*) self)->msg;
	g_signal_parse_name ("got-body", soup_message_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _rygel_http_post_on_got_body_soup_message_got_body, self);
	_tmp2_ = ((RygelHTTPRequest*) self)->msg;
	g_signal_parse_name ("got-chunk", soup_message_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _rygel_http_post_on_got_chunk_soup_message_got_chunk, self);
}


static void rygel_http_post_class_init (RygelHTTPPostClass * klass) {
	rygel_http_post_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPPostPrivate));
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle = rygel_http_post_real_handle;
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle_finish = rygel_http_post_real_handle_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_post_finalize;
}


static void rygel_http_post_instance_init (RygelHTTPPost * self) {
	self->priv = RYGEL_HTTP_POST_GET_PRIVATE (self);
}


static void rygel_http_post_finalize (GObject* obj) {
	RygelHTTPPost * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_POST, RygelHTTPPost);
	(self->priv->handle_continue_target_destroy_notify == NULL) ? NULL : (self->priv->handle_continue_target_destroy_notify (self->priv->handle_continue_target), NULL);
	self->priv->handle_continue = NULL;
	self->priv->handle_continue_target = NULL;
	self->priv->handle_continue_target_destroy_notify = NULL;
	_g_object_unref0 (self->priv->file);
	_g_object_unref0 (self->priv->dotfile);
	_g_object_unref0 (self->priv->stream);
	G_OBJECT_CLASS (rygel_http_post_parent_class)->finalize (obj);
}


/**
 * Responsible for handling HTTP POST client requests.
 */
GType rygel_http_post_get_type (void) {
	static volatile gsize rygel_http_post_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_post_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPPostClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_post_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPPost), 0, (GInstanceInitFunc) rygel_http_post_instance_init, NULL };
		GType rygel_http_post_type_id;
		rygel_http_post_type_id = g_type_register_static (RYGEL_TYPE_HTTP_REQUEST, "RygelHTTPPost", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_post_type_id__volatile, rygel_http_post_type_id);
	}
	return rygel_http_post_type_id__volatile;
}



